/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { dnsCreateRecord } from "../funcs/dnsCreateRecord.js";
import { dnsGetRecords } from "../funcs/dnsGetRecords.js";
import { dnsRemoveRecord } from "../funcs/dnsRemoveRecord.js";
import { dnsUpdateRecord } from "../funcs/dnsUpdateRecord.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  CreateRecordRequest,
  CreateRecordResponseBody,
} from "../models/operations/createrecord.js";
import {
  GetRecordsRequest,
  GetRecordsResponseBody,
} from "../models/operations/getrecords.js";
import {
  RemoveRecordRequest,
  RemoveRecordResponseBody,
} from "../models/operations/removerecord.js";
import {
  UpdateRecordRequest,
  UpdateRecordResponseBody,
} from "../models/operations/updaterecord.js";
import { unwrapAsync } from "../types/fp.js";

export class Dns extends ClientSDK {
  /**
   * List existing DNS records
   *
   * @remarks
   * Retrieves a list of DNS records created for a domain name. By default it returns 20 records if no limit is provided. The rest can be retrieved using the pagination options.
   */
  async getRecords(
    request: GetRecordsRequest,
    options?: RequestOptions,
  ): Promise<GetRecordsResponseBody> {
    return unwrapAsync(dnsGetRecords(
      this,
      request,
      options,
    ));
  }

  /**
   * Create a DNS record
   *
   * @remarks
   * Creates a DNS record for a domain.
   */
  async createRecord(
    request: CreateRecordRequest,
    options?: RequestOptions,
  ): Promise<CreateRecordResponseBody> {
    return unwrapAsync(dnsCreateRecord(
      this,
      request,
      options,
    ));
  }

  /**
   * Update an existing DNS record
   *
   * @remarks
   * Updates an existing DNS record for a domain name.
   */
  async updateRecord(
    request: UpdateRecordRequest,
    options?: RequestOptions,
  ): Promise<UpdateRecordResponseBody> {
    return unwrapAsync(dnsUpdateRecord(
      this,
      request,
      options,
    ));
  }

  /**
   * Delete a DNS record
   *
   * @remarks
   * Removes an existing DNS record from a domain name.
   */
  async removeRecord(
    request: RemoveRecordRequest,
    options?: RequestOptions,
  ): Promise<RemoveRecordResponseBody> {
    return unwrapAsync(dnsRemoveRecord(
      this,
      request,
      options,
    ));
  }
}
