/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { checksCreateCheck } from "../funcs/checksCreateCheck.js";
import { checksGetAllChecks } from "../funcs/checksGetAllChecks.js";
import { checksGetCheck } from "../funcs/checksGetCheck.js";
import { checksRerequestCheck } from "../funcs/checksRerequestCheck.js";
import { checksUpdateCheck } from "../funcs/checksUpdateCheck.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  CreateCheckRequest,
  CreateCheckResponseBody,
} from "../models/operations/createcheck.js";
import {
  GetAllChecksRequest,
  GetAllChecksResponseBody,
} from "../models/operations/getallchecks.js";
import {
  GetCheckRequest,
  GetCheckResponseBody,
} from "../models/operations/getcheck.js";
import {
  RerequestCheckRequest,
  RerequestCheckResponseBody,
} from "../models/operations/rerequestcheck.js";
import {
  UpdateCheckRequest,
  UpdateCheckResponseBody,
} from "../models/operations/updatecheck.js";
import { unwrapAsync } from "../types/fp.js";

export class Checks extends ClientSDK {
  /**
   * Creates a new Check
   *
   * @remarks
   * Creates a new check. This endpoint must be called with an OAuth2 or it will produce a 400 error.
   */
  async createCheck(
    request: CreateCheckRequest,
    options?: RequestOptions,
  ): Promise<CreateCheckResponseBody> {
    return unwrapAsync(checksCreateCheck(
      this,
      request,
      options,
    ));
  }

  /**
   * Retrieve a list of all checks
   *
   * @remarks
   * List all of the checks created for a deployment.
   */
  async getAllChecks(
    request: GetAllChecksRequest,
    options?: RequestOptions,
  ): Promise<GetAllChecksResponseBody> {
    return unwrapAsync(checksGetAllChecks(
      this,
      request,
      options,
    ));
  }

  /**
   * Get a single check
   *
   * @remarks
   * Return a detailed response for a single check.
   */
  async getCheck(
    request: GetCheckRequest,
    options?: RequestOptions,
  ): Promise<GetCheckResponseBody> {
    return unwrapAsync(checksGetCheck(
      this,
      request,
      options,
    ));
  }

  /**
   * Update a check
   *
   * @remarks
   * Update an existing check. This endpoint must be called with an OAuth2 or it will produce a 400 error.
   */
  async updateCheck(
    request: UpdateCheckRequest,
    options?: RequestOptions,
  ): Promise<UpdateCheckResponseBody> {
    return unwrapAsync(checksUpdateCheck(
      this,
      request,
      options,
    ));
  }

  /**
   * Rerequest a check
   *
   * @remarks
   * Rerequest a selected check that has failed.
   */
  async rerequestCheck(
    request: RerequestCheckRequest,
    options?: RequestOptions,
  ): Promise<RerequestCheckResponseBody> {
    return unwrapAsync(checksRerequestCheck(
      this,
      request,
      options,
    ));
  }
}
