/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { artifactsArtifactExists } from "../funcs/artifactsArtifactExists.js";
import { artifactsArtifactQuery } from "../funcs/artifactsArtifactQuery.js";
import { artifactsDownloadArtifact } from "../funcs/artifactsDownloadArtifact.js";
import { artifactsRecordEvents } from "../funcs/artifactsRecordEvents.js";
import { artifactsStatus } from "../funcs/artifactsStatus.js";
import { artifactsUploadArtifact } from "../funcs/artifactsUploadArtifact.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import { ArtifactExistsRequest } from "../models/operations/artifactexists.js";
import {
  ArtifactQueryRequest,
  ResponseBody,
} from "../models/operations/artifactquery.js";
import { DownloadArtifactRequest } from "../models/operations/downloadartifact.js";
import { RecordEventsRequest } from "../models/operations/recordevents.js";
import {
  StatusRequest,
  StatusResponseBody,
} from "../models/operations/status.js";
import {
  UploadArtifactRequest,
  UploadArtifactResponseBody,
} from "../models/operations/uploadartifact.js";
import { unwrapAsync } from "../types/fp.js";

export class Artifacts extends ClientSDK {
  /**
   * Record an artifacts cache usage event
   *
   * @remarks
   * Records an artifacts cache usage event. The body of this request is an array of cache usage events. The supported event types are `HIT` and `MISS`. The source is either `LOCAL` the cache event was on the users filesystem cache or `REMOTE` if the cache event is for a remote cache. When the event is a `HIT` the request also accepts a number `duration` which is the time taken to generate the artifact in the cache.
   */
  async recordEvents(
    request: RecordEventsRequest,
    options?: RequestOptions,
  ): Promise<void> {
    return unwrapAsync(artifactsRecordEvents(
      this,
      request,
      options,
    ));
  }

  /**
   * Get status of Remote Caching for this principal
   *
   * @remarks
   * Check the status of Remote Caching for this principal. Returns a JSON-encoded status indicating if Remote Caching is enabled, disabled, or disabled due to usage limits.
   */
  async status(
    request: StatusRequest,
    options?: RequestOptions,
  ): Promise<StatusResponseBody> {
    return unwrapAsync(artifactsStatus(
      this,
      request,
      options,
    ));
  }

  /**
   * Upload a cache artifact
   *
   * @remarks
   * Uploads a cache artifact identified by the `hash` specified on the path. The cache artifact can then be downloaded with the provided `hash`.
   */
  async uploadArtifact(
    request: UploadArtifactRequest,
    options?: RequestOptions,
  ): Promise<UploadArtifactResponseBody> {
    return unwrapAsync(artifactsUploadArtifact(
      this,
      request,
      options,
    ));
  }

  /**
   * Download a cache artifact
   *
   * @remarks
   * Downloads a cache artifact indentified by its `hash` specified on the request path. The artifact is downloaded as an octet-stream. The client should verify the content-length header and response body.
   */
  async downloadArtifact(
    request: DownloadArtifactRequest,
    options?: RequestOptions,
  ): Promise<ReadableStream<Uint8Array>> {
    return unwrapAsync(artifactsDownloadArtifact(
      this,
      request,
      options,
    ));
  }

  /**
   * Check if a cache artifact exists
   *
   * @remarks
   * Check that a cache artifact with the given `hash` exists. This request returns response headers only and is equivalent to a `GET` request to this endpoint where the response contains no body.
   */
  async artifactExists(
    request: ArtifactExistsRequest,
    options?: RequestOptions,
  ): Promise<void> {
    return unwrapAsync(artifactsArtifactExists(
      this,
      request,
      options,
    ));
  }

  /**
   * Query information about an artifact
   *
   * @remarks
   * Query information about an array of artifacts.
   */
  async artifactQuery(
    request: ArtifactQueryRequest,
    options?: RequestOptions,
  ): Promise<{ [k: string]: ResponseBody }> {
    return unwrapAsync(artifactsArtifactQuery(
      this,
      request,
      options,
    ));
  }
}
