/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { aliasesAssignAlias } from "../funcs/aliasesAssignAlias.js";
import { aliasesDeleteAlias } from "../funcs/aliasesDeleteAlias.js";
import { aliasesGetAlias } from "../funcs/aliasesGetAlias.js";
import { aliasesListAliases } from "../funcs/aliasesListAliases.js";
import { aliasesListDeploymentAliases } from "../funcs/aliasesListDeploymentAliases.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  AssignAliasRequest,
  AssignAliasResponseBody,
} from "../models/operations/assignalias.js";
import {
  DeleteAliasRequest,
  DeleteAliasResponseBody,
} from "../models/operations/deletealias.js";
import {
  GetAliasRequest,
  GetAliasResponseBody,
} from "../models/operations/getalias.js";
import {
  ListAliasesRequest,
  ListAliasesResponseBody,
} from "../models/operations/listaliases.js";
import {
  ListDeploymentAliasesRequest,
  ListDeploymentAliasesResponseBody,
} from "../models/operations/listdeploymentaliases.js";
import { unwrapAsync } from "../types/fp.js";

export class Aliases extends ClientSDK {
  /**
   * List aliases
   *
   * @remarks
   * Retrieves a list of aliases for the authenticated User or Team. When `domain` is provided, only aliases for that domain will be returned. When `projectId` is provided, it will only return the given project aliases.
   */
  async listAliases(
    request: ListAliasesRequest,
    options?: RequestOptions,
  ): Promise<ListAliasesResponseBody> {
    return unwrapAsync(aliasesListAliases(
      this,
      request,
      options,
    ));
  }

  /**
   * Get an Alias
   *
   * @remarks
   * Retrieves an Alias for the given host name or alias ID.
   */
  async getAlias(
    request: GetAliasRequest,
    options?: RequestOptions,
  ): Promise<GetAliasResponseBody> {
    return unwrapAsync(aliasesGetAlias(
      this,
      request,
      options,
    ));
  }

  /**
   * Delete an Alias
   *
   * @remarks
   * Delete an Alias with the specified ID.
   */
  async deleteAlias(
    request: DeleteAliasRequest,
    options?: RequestOptions,
  ): Promise<DeleteAliasResponseBody> {
    return unwrapAsync(aliasesDeleteAlias(
      this,
      request,
      options,
    ));
  }

  /**
   * List Deployment Aliases
   *
   * @remarks
   * Retrieves all Aliases for the Deployment with the given ID. The authenticated user or team must own the deployment.
   */
  async listDeploymentAliases(
    request: ListDeploymentAliasesRequest,
    options?: RequestOptions,
  ): Promise<ListDeploymentAliasesResponseBody> {
    return unwrapAsync(aliasesListDeploymentAliases(
      this,
      request,
      options,
    ));
  }

  /**
   * Assign an Alias
   *
   * @remarks
   * Creates a new alias for the deployment with the given deployment ID. The authenticated user or team must own this deployment. If the desired alias is already assigned to another deployment, then it will be removed from the old deployment and assigned to the new one.
   */
  async assignAlias(
    request: AssignAliasRequest,
    options?: RequestOptions,
  ): Promise<AssignAliasResponseBody> {
    return unwrapAsync(aliasesAssignAlias(
      this,
      request,
      options,
    ));
  }
}
