/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import { accessGroupsCreateAccessGroup } from "../funcs/accessGroupsCreateAccessGroup.js";
import { accessGroupsDeleteAccessGroup } from "../funcs/accessGroupsDeleteAccessGroup.js";
import { accessGroupsListAccessGroupMembers } from "../funcs/accessGroupsListAccessGroupMembers.js";
import { accessGroupsListAccessGroupProjects } from "../funcs/accessGroupsListAccessGroupProjects.js";
import { accessGroupsListAccessGroups } from "../funcs/accessGroupsListAccessGroups.js";
import { accessGroupsReadAccessGroup } from "../funcs/accessGroupsReadAccessGroup.js";
import { accessGroupsUpdateAccessGroup } from "../funcs/accessGroupsUpdateAccessGroup.js";
import { ClientSDK, RequestOptions } from "../lib/sdks.js";
import {
  CreateAccessGroupRequest,
  CreateAccessGroupResponseBody,
} from "../models/operations/createaccessgroup.js";
import { DeleteAccessGroupRequest } from "../models/operations/deleteaccessgroup.js";
import {
  ListAccessGroupMembersRequest,
  ListAccessGroupMembersResponseBody,
} from "../models/operations/listaccessgroupmembers.js";
import {
  ListAccessGroupProjectsRequest,
  ListAccessGroupProjectsResponseBody,
} from "../models/operations/listaccessgroupprojects.js";
import {
  ListAccessGroupsRequest,
  ListAccessGroupsResponseBody,
} from "../models/operations/listaccessgroups.js";
import {
  ReadAccessGroupRequest,
  ReadAccessGroupResponseBody,
} from "../models/operations/readaccessgroup.js";
import {
  UpdateAccessGroupRequest,
  UpdateAccessGroupResponseBody,
} from "../models/operations/updateaccessgroup.js";
import { unwrapAsync } from "../types/fp.js";

export class AccessGroups extends ClientSDK {
  /**
   * Reads an access group
   *
   * @remarks
   * Allows to read an access group
   */
  async readAccessGroup(
    request: ReadAccessGroupRequest,
    options?: RequestOptions,
  ): Promise<ReadAccessGroupResponseBody> {
    return unwrapAsync(accessGroupsReadAccessGroup(
      this,
      request,
      options,
    ));
  }

  /**
   * Update an access group
   *
   * @remarks
   * Allows to update an access group metadata
   */
  async updateAccessGroup(
    request: UpdateAccessGroupRequest,
    options?: RequestOptions,
  ): Promise<UpdateAccessGroupResponseBody> {
    return unwrapAsync(accessGroupsUpdateAccessGroup(
      this,
      request,
      options,
    ));
  }

  /**
   * Deletes an access group
   *
   * @remarks
   * Allows to delete an access group
   */
  async deleteAccessGroup(
    request: DeleteAccessGroupRequest,
    options?: RequestOptions,
  ): Promise<void> {
    return unwrapAsync(accessGroupsDeleteAccessGroup(
      this,
      request,
      options,
    ));
  }

  /**
   * List members of an access group
   *
   * @remarks
   * List members of an access group
   */
  async listAccessGroupMembers(
    request: ListAccessGroupMembersRequest,
    options?: RequestOptions,
  ): Promise<ListAccessGroupMembersResponseBody> {
    return unwrapAsync(accessGroupsListAccessGroupMembers(
      this,
      request,
      options,
    ));
  }

  /**
   * List access groups for a team, project or member
   *
   * @remarks
   * List access groups
   */
  async listAccessGroups(
    request: ListAccessGroupsRequest,
    options?: RequestOptions,
  ): Promise<ListAccessGroupsResponseBody> {
    return unwrapAsync(accessGroupsListAccessGroups(
      this,
      request,
      options,
    ));
  }

  /**
   * Creates an access group
   *
   * @remarks
   * Allows to create an access group
   */
  async createAccessGroup(
    request: CreateAccessGroupRequest,
    options?: RequestOptions,
  ): Promise<CreateAccessGroupResponseBody> {
    return unwrapAsync(accessGroupsCreateAccessGroup(
      this,
      request,
      options,
    ));
  }

  /**
   * List projects of an access group
   *
   * @remarks
   * List projects of an access group
   */
  async listAccessGroupProjects(
    request: ListAccessGroupProjectsRequest,
    options?: RequestOptions,
  ): Promise<ListAccessGroupProjectsResponseBody> {
    return unwrapAsync(accessGroupsListAccessGroupProjects(
      this,
      request,
      options,
    ));
  }
}
