/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";

export type VerifyProjectDomainRequest = {
  /**
   * The unique project identifier or the project name
   */
  idOrName: string;
  /**
   * The domain name you want to verify
   */
  domain: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
 */
export type VerifyProjectDomainVerification = {
  type: string;
  domain: string;
  value: string;
  reason: string;
};

/**
 * The project domain was verified successfully
 *
 * @remarks
 * Domain is already verified
 */
export type VerifyProjectDomainResponseBody = {
  name: string;
  apexName: string;
  projectId: string;
  redirect?: string | null | undefined;
  redirectStatusCode?: number | null | undefined;
  gitBranch?: string | null | undefined;
  customEnvironmentId?: string | null | undefined;
  updatedAt?: number | undefined;
  createdAt?: number | undefined;
  /**
   * `true` if the domain is verified for use with the project. If `false` it will not be used as an alias on this project until the challenge in `verification` is completed.
   */
  verified: boolean;
  /**
   * A list of verification challenges, one of which must be completed to verify the domain for use on the project. After the challenge is complete `POST /projects/:idOrName/domains/:domain/verify` to verify the domain. Possible challenges: - If `verification.type = TXT` the `verification.domain` will be checked for a TXT record matching `verification.value`.
   */
  verification?: Array<VerifyProjectDomainVerification> | undefined;
};

/** @internal */
export const VerifyProjectDomainRequest$inboundSchema: z.ZodType<
  VerifyProjectDomainRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrName: z.string(),
  domain: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type VerifyProjectDomainRequest$Outbound = {
  idOrName: string;
  domain: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const VerifyProjectDomainRequest$outboundSchema: z.ZodType<
  VerifyProjectDomainRequest$Outbound,
  z.ZodTypeDef,
  VerifyProjectDomainRequest
> = z.object({
  idOrName: z.string(),
  domain: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace VerifyProjectDomainRequest$ {
  /** @deprecated use `VerifyProjectDomainRequest$inboundSchema` instead. */
  export const inboundSchema = VerifyProjectDomainRequest$inboundSchema;
  /** @deprecated use `VerifyProjectDomainRequest$outboundSchema` instead. */
  export const outboundSchema = VerifyProjectDomainRequest$outboundSchema;
  /** @deprecated use `VerifyProjectDomainRequest$Outbound` instead. */
  export type Outbound = VerifyProjectDomainRequest$Outbound;
}

/** @internal */
export const VerifyProjectDomainVerification$inboundSchema: z.ZodType<
  VerifyProjectDomainVerification,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: z.string(),
  domain: z.string(),
  value: z.string(),
  reason: z.string(),
});

/** @internal */
export type VerifyProjectDomainVerification$Outbound = {
  type: string;
  domain: string;
  value: string;
  reason: string;
};

/** @internal */
export const VerifyProjectDomainVerification$outboundSchema: z.ZodType<
  VerifyProjectDomainVerification$Outbound,
  z.ZodTypeDef,
  VerifyProjectDomainVerification
> = z.object({
  type: z.string(),
  domain: z.string(),
  value: z.string(),
  reason: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace VerifyProjectDomainVerification$ {
  /** @deprecated use `VerifyProjectDomainVerification$inboundSchema` instead. */
  export const inboundSchema = VerifyProjectDomainVerification$inboundSchema;
  /** @deprecated use `VerifyProjectDomainVerification$outboundSchema` instead. */
  export const outboundSchema = VerifyProjectDomainVerification$outboundSchema;
  /** @deprecated use `VerifyProjectDomainVerification$Outbound` instead. */
  export type Outbound = VerifyProjectDomainVerification$Outbound;
}

/** @internal */
export const VerifyProjectDomainResponseBody$inboundSchema: z.ZodType<
  VerifyProjectDomainResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  apexName: z.string(),
  projectId: z.string(),
  redirect: z.nullable(z.string()).optional(),
  redirectStatusCode: z.nullable(z.number()).optional(),
  gitBranch: z.nullable(z.string()).optional(),
  customEnvironmentId: z.nullable(z.string()).optional(),
  updatedAt: z.number().optional(),
  createdAt: z.number().optional(),
  verified: z.boolean(),
  verification: z.array(
    z.lazy(() => VerifyProjectDomainVerification$inboundSchema),
  ).optional(),
});

/** @internal */
export type VerifyProjectDomainResponseBody$Outbound = {
  name: string;
  apexName: string;
  projectId: string;
  redirect?: string | null | undefined;
  redirectStatusCode?: number | null | undefined;
  gitBranch?: string | null | undefined;
  customEnvironmentId?: string | null | undefined;
  updatedAt?: number | undefined;
  createdAt?: number | undefined;
  verified: boolean;
  verification?: Array<VerifyProjectDomainVerification$Outbound> | undefined;
};

/** @internal */
export const VerifyProjectDomainResponseBody$outboundSchema: z.ZodType<
  VerifyProjectDomainResponseBody$Outbound,
  z.ZodTypeDef,
  VerifyProjectDomainResponseBody
> = z.object({
  name: z.string(),
  apexName: z.string(),
  projectId: z.string(),
  redirect: z.nullable(z.string()).optional(),
  redirectStatusCode: z.nullable(z.number()).optional(),
  gitBranch: z.nullable(z.string()).optional(),
  customEnvironmentId: z.nullable(z.string()).optional(),
  updatedAt: z.number().optional(),
  createdAt: z.number().optional(),
  verified: z.boolean(),
  verification: z.array(
    z.lazy(() => VerifyProjectDomainVerification$outboundSchema),
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace VerifyProjectDomainResponseBody$ {
  /** @deprecated use `VerifyProjectDomainResponseBody$inboundSchema` instead. */
  export const inboundSchema = VerifyProjectDomainResponseBody$inboundSchema;
  /** @deprecated use `VerifyProjectDomainResponseBody$outboundSchema` instead. */
  export const outboundSchema = VerifyProjectDomainResponseBody$outboundSchema;
  /** @deprecated use `VerifyProjectDomainResponseBody$Outbound` instead. */
  export type Outbound = VerifyProjectDomainResponseBody$Outbound;
}
