/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";

export type UploadFileRequest = {
  /**
   * The file size in bytes
   */
  contentLength?: number | undefined;
  /**
   * The file SHA1 used to check the integrity
   */
  xVercelDigest?: string | undefined;
  /**
   * The file SHA1 used to check the integrity
   */
  xNowDigest?: string | undefined;
  /**
   * The file size as an alternative to `Content-Length`
   */
  xNowSize?: number | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export type UploadFileResponseBody2 = {};

export type UploadFileResponseBody1 = {
  /**
   * Array of URLs where the file was updated
   */
  urls: Array<string>;
};

/**
 * File already uploaded
 *
 * @remarks
 * File successfully uploaded
 */
export type UploadFileResponseBody =
  | UploadFileResponseBody2
  | UploadFileResponseBody1;

/** @internal */
export const UploadFileRequest$inboundSchema: z.ZodType<
  UploadFileRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  "Content-Length": z.number().optional(),
  "x-vercel-digest": z.string().optional(),
  "x-now-digest": z.string().optional(),
  "x-now-size": z.number().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
}).transform((v) => {
  return remap$(v, {
    "Content-Length": "contentLength",
    "x-vercel-digest": "xVercelDigest",
    "x-now-digest": "xNowDigest",
    "x-now-size": "xNowSize",
  });
});

/** @internal */
export type UploadFileRequest$Outbound = {
  "Content-Length"?: number | undefined;
  "x-vercel-digest"?: string | undefined;
  "x-now-digest"?: string | undefined;
  "x-now-size"?: number | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const UploadFileRequest$outboundSchema: z.ZodType<
  UploadFileRequest$Outbound,
  z.ZodTypeDef,
  UploadFileRequest
> = z.object({
  contentLength: z.number().optional(),
  xVercelDigest: z.string().optional(),
  xNowDigest: z.string().optional(),
  xNowSize: z.number().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
}).transform((v) => {
  return remap$(v, {
    contentLength: "Content-Length",
    xVercelDigest: "x-vercel-digest",
    xNowDigest: "x-now-digest",
    xNowSize: "x-now-size",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadFileRequest$ {
  /** @deprecated use `UploadFileRequest$inboundSchema` instead. */
  export const inboundSchema = UploadFileRequest$inboundSchema;
  /** @deprecated use `UploadFileRequest$outboundSchema` instead. */
  export const outboundSchema = UploadFileRequest$outboundSchema;
  /** @deprecated use `UploadFileRequest$Outbound` instead. */
  export type Outbound = UploadFileRequest$Outbound;
}

/** @internal */
export const UploadFileResponseBody2$inboundSchema: z.ZodType<
  UploadFileResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type UploadFileResponseBody2$Outbound = {};

/** @internal */
export const UploadFileResponseBody2$outboundSchema: z.ZodType<
  UploadFileResponseBody2$Outbound,
  z.ZodTypeDef,
  UploadFileResponseBody2
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadFileResponseBody2$ {
  /** @deprecated use `UploadFileResponseBody2$inboundSchema` instead. */
  export const inboundSchema = UploadFileResponseBody2$inboundSchema;
  /** @deprecated use `UploadFileResponseBody2$outboundSchema` instead. */
  export const outboundSchema = UploadFileResponseBody2$outboundSchema;
  /** @deprecated use `UploadFileResponseBody2$Outbound` instead. */
  export type Outbound = UploadFileResponseBody2$Outbound;
}

/** @internal */
export const UploadFileResponseBody1$inboundSchema: z.ZodType<
  UploadFileResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  urls: z.array(z.string()),
});

/** @internal */
export type UploadFileResponseBody1$Outbound = {
  urls: Array<string>;
};

/** @internal */
export const UploadFileResponseBody1$outboundSchema: z.ZodType<
  UploadFileResponseBody1$Outbound,
  z.ZodTypeDef,
  UploadFileResponseBody1
> = z.object({
  urls: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadFileResponseBody1$ {
  /** @deprecated use `UploadFileResponseBody1$inboundSchema` instead. */
  export const inboundSchema = UploadFileResponseBody1$inboundSchema;
  /** @deprecated use `UploadFileResponseBody1$outboundSchema` instead. */
  export const outboundSchema = UploadFileResponseBody1$outboundSchema;
  /** @deprecated use `UploadFileResponseBody1$Outbound` instead. */
  export type Outbound = UploadFileResponseBody1$Outbound;
}

/** @internal */
export const UploadFileResponseBody$inboundSchema: z.ZodType<
  UploadFileResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UploadFileResponseBody2$inboundSchema),
  z.lazy(() => UploadFileResponseBody1$inboundSchema),
]);

/** @internal */
export type UploadFileResponseBody$Outbound =
  | UploadFileResponseBody2$Outbound
  | UploadFileResponseBody1$Outbound;

/** @internal */
export const UploadFileResponseBody$outboundSchema: z.ZodType<
  UploadFileResponseBody$Outbound,
  z.ZodTypeDef,
  UploadFileResponseBody
> = z.union([
  z.lazy(() => UploadFileResponseBody2$outboundSchema),
  z.lazy(() => UploadFileResponseBody1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadFileResponseBody$ {
  /** @deprecated use `UploadFileResponseBody$inboundSchema` instead. */
  export const inboundSchema = UploadFileResponseBody$inboundSchema;
  /** @deprecated use `UploadFileResponseBody$outboundSchema` instead. */
  export const outboundSchema = UploadFileResponseBody$outboundSchema;
  /** @deprecated use `UploadFileResponseBody$Outbound` instead. */
  export type Outbound = UploadFileResponseBody$Outbound;
}
