/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";

export type UploadCertRequestBody = {
  /**
   * The certificate authority
   */
  ca: string;
  /**
   * The certificate key
   */
  key: string;
  /**
   * The certificate
   */
  cert: string;
  /**
   * Skip validation of the certificate
   */
  skipValidation?: boolean | undefined;
};

export type UploadCertRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: UploadCertRequestBody | undefined;
};

export type UploadCertResponseBody = {
  id: string;
  createdAt: number;
  expiresAt: number;
  autoRenew: boolean;
  cns: Array<string>;
};

/** @internal */
export const UploadCertRequestBody$inboundSchema: z.ZodType<
  UploadCertRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  ca: z.string(),
  key: z.string(),
  cert: z.string(),
  skipValidation: z.boolean().optional(),
});

/** @internal */
export type UploadCertRequestBody$Outbound = {
  ca: string;
  key: string;
  cert: string;
  skipValidation?: boolean | undefined;
};

/** @internal */
export const UploadCertRequestBody$outboundSchema: z.ZodType<
  UploadCertRequestBody$Outbound,
  z.ZodTypeDef,
  UploadCertRequestBody
> = z.object({
  ca: z.string(),
  key: z.string(),
  cert: z.string(),
  skipValidation: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadCertRequestBody$ {
  /** @deprecated use `UploadCertRequestBody$inboundSchema` instead. */
  export const inboundSchema = UploadCertRequestBody$inboundSchema;
  /** @deprecated use `UploadCertRequestBody$outboundSchema` instead. */
  export const outboundSchema = UploadCertRequestBody$outboundSchema;
  /** @deprecated use `UploadCertRequestBody$Outbound` instead. */
  export type Outbound = UploadCertRequestBody$Outbound;
}

/** @internal */
export const UploadCertRequest$inboundSchema: z.ZodType<
  UploadCertRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => UploadCertRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type UploadCertRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: UploadCertRequestBody$Outbound | undefined;
};

/** @internal */
export const UploadCertRequest$outboundSchema: z.ZodType<
  UploadCertRequest$Outbound,
  z.ZodTypeDef,
  UploadCertRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => UploadCertRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadCertRequest$ {
  /** @deprecated use `UploadCertRequest$inboundSchema` instead. */
  export const inboundSchema = UploadCertRequest$inboundSchema;
  /** @deprecated use `UploadCertRequest$outboundSchema` instead. */
  export const outboundSchema = UploadCertRequest$outboundSchema;
  /** @deprecated use `UploadCertRequest$Outbound` instead. */
  export type Outbound = UploadCertRequest$Outbound;
}

/** @internal */
export const UploadCertResponseBody$inboundSchema: z.ZodType<
  UploadCertResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  createdAt: z.number(),
  expiresAt: z.number(),
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
});

/** @internal */
export type UploadCertResponseBody$Outbound = {
  id: string;
  createdAt: number;
  expiresAt: number;
  autoRenew: boolean;
  cns: Array<string>;
};

/** @internal */
export const UploadCertResponseBody$outboundSchema: z.ZodType<
  UploadCertResponseBody$Outbound,
  z.ZodTypeDef,
  UploadCertResponseBody
> = z.object({
  id: z.string(),
  createdAt: z.number(),
  expiresAt: z.number(),
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadCertResponseBody$ {
  /** @deprecated use `UploadCertResponseBody$inboundSchema` instead. */
  export const inboundSchema = UploadCertResponseBody$inboundSchema;
  /** @deprecated use `UploadCertResponseBody$outboundSchema` instead. */
  export const outboundSchema = UploadCertResponseBody$outboundSchema;
  /** @deprecated use `UploadCertResponseBody$Outbound` instead. */
  export type Outbound = UploadCertResponseBody$Outbound;
}
