/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  ACLAction,
  ACLAction$inboundSchema,
  ACLAction$outboundSchema,
} from "../components/aclaction.js";

export type UpdateProjectDataCacheRequestBody = {
  /**
   * Enable or disable data cache for the project - default: false
   */
  disabled?: boolean | undefined;
};

export type UpdateProjectDataCacheRequest = {
  /**
   * The unique project identifier
   */
  projectId: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: UpdateProjectDataCacheRequestBody | undefined;
};

export type Analytics = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

export type SpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type Definitions = {
  /**
   * The hostname that should be used.
   */
  host: string;
  /**
   * The path that should be called for the cronjob.
   */
  path: string;
  /**
   * The cron expression.
   */
  schedule: string;
};

export type Crons = {
  /**
   * The time the feature was enabled for this project. Note: It enables automatically with the first Deployment that outputs cronjobs.
   */
  enabledAt: number;
  /**
   * The time the feature was disabled for this project.
   */
  disabledAt: number | null;
  updatedAt: number;
  /**
   * The ID of the Deployment from which the definitions originated.
   */
  deploymentId: string | null;
  definitions: Array<Definitions>;
};

export type DataCache = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

export type DeploymentExpiration = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

export const UpdateProjectDataCacheTarget2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type UpdateProjectDataCacheTarget2 = ClosedEnum<
  typeof UpdateProjectDataCacheTarget2
>;

export const UpdateProjectDataCacheTarget1 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type UpdateProjectDataCacheTarget1 = ClosedEnum<
  typeof UpdateProjectDataCacheTarget1
>;

export type UpdateProjectDataCacheTarget =
  | Array<UpdateProjectDataCacheTarget1>
  | UpdateProjectDataCacheTarget2;

export const UpdateProjectDataCacheProjectsResponse200Type = {
  Secret: "secret",
  System: "system",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
export type UpdateProjectDataCacheProjectsResponse200Type = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsResponse200Type
>;

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  >;

export type Fifteen = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type;
  projectId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  >;

export type Fourteen = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  >;

export type Thirteen = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  >;

export type Twelve = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  >;

export type UpdateProjectDataCacheContentHint11 = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  >;

export type ContentHint10 = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  >;

export type ContentHint9 = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  >;

export type ContentHint8 = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type ContentHint7 = {
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType
  >;

export type ContentHint6 = {
  type: UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponse200Type = {
  BlobReadWriteToken: "blob-read-write-token",
} as const;
export type UpdateProjectDataCacheContentHintProjectsResponse200Type =
  ClosedEnum<typeof UpdateProjectDataCacheContentHintProjectsResponse200Type>;

export type ContentHint5 = {
  type: UpdateProjectDataCacheContentHintProjectsResponse200Type;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsResponseType = {
  RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
} as const;
export type UpdateProjectDataCacheContentHintProjectsResponseType = ClosedEnum<
  typeof UpdateProjectDataCacheContentHintProjectsResponseType
>;

export type ContentHint4 = {
  type: UpdateProjectDataCacheContentHintProjectsResponseType;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintProjectsType = {
  RedisRestApiToken: "redis-rest-api-token",
} as const;
export type UpdateProjectDataCacheContentHintProjectsType = ClosedEnum<
  typeof UpdateProjectDataCacheContentHintProjectsType
>;

export type ContentHint3 = {
  type: UpdateProjectDataCacheContentHintProjectsType;
  storeId: string;
};

export const UpdateProjectDataCacheContentHintType = {
  RedisRestApiUrl: "redis-rest-api-url",
} as const;
export type UpdateProjectDataCacheContentHintType = ClosedEnum<
  typeof UpdateProjectDataCacheContentHintType
>;

export type ContentHint2 = {
  type: UpdateProjectDataCacheContentHintType;
  storeId: string;
};

export const ContentHintType = {
  RedisUrl: "redis-url",
} as const;
export type ContentHintType = ClosedEnum<typeof ContentHintType>;

export type ContentHint1 = {
  type: ContentHintType;
  storeId: string;
};

export type ContentHint =
  | ContentHint1
  | ContentHint2
  | ContentHint3
  | ContentHint4
  | ContentHint5
  | ContentHint6
  | ContentHint7
  | ContentHint8
  | ContentHint9
  | ContentHint10
  | UpdateProjectDataCacheContentHint11
  | Twelve
  | Thirteen
  | Fifteen
  | Fourteen;

export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType =
  {
    FlagsSecret: "flags-secret",
  } as const;
export type UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType
  >;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type InternalContentHint = {
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type Env = {
  target?:
    | Array<UpdateProjectDataCacheTarget1>
    | UpdateProjectDataCacheTarget2
    | undefined;
  type: UpdateProjectDataCacheProjectsResponse200Type;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | ContentHint1
    | ContentHint2
    | ContentHint3
    | ContentHint4
    | ContentHint5
    | ContentHint6
    | ContentHint7
    | ContentHint8
    | ContentHint9
    | ContentHint10
    | UpdateProjectDataCacheContentHint11
    | Twelve
    | Thirteen
    | Fifteen
    | Fourteen
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?: InternalContentHint | null | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

export type CustomEnvironments = {};

export const UpdateProjectDataCacheFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type UpdateProjectDataCacheFramework = ClosedEnum<
  typeof UpdateProjectDataCacheFramework
>;

export type IpBuckets = {
  bucket: string;
  supportUntil?: number | undefined;
};

export type AliasAssigned = number | boolean;

export type UpdateProjectDataCacheProjectsAliasError = {
  code: string;
  message: string;
};

export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONType = {
  EndsWith: "endsWith",
  StartsWith: "startsWith",
  Equals: "equals",
} as const;
export type UpdateProjectDataCacheProjectsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONType
  >;

export type BranchMatcher = {
  type: UpdateProjectDataCacheProjectsResponse200ApplicationJSONType;
  pattern: string;
};

export type UpdateProjectDataCacheProjectsBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const UpdateProjectDataCacheProjectsChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type UpdateProjectDataCacheProjectsChecksConclusion = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsChecksConclusion
>;

export const UpdateProjectDataCacheProjectsChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type UpdateProjectDataCacheProjectsChecksState = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsChecksState
>;

export type UpdateProjectDataCacheProjectsCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type UpdateProjectDataCacheProjectsOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const UpdateProjectDataCacheProjectsPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type UpdateProjectDataCacheProjectsPlan = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsPlan
>;

export const UpdateProjectDataCacheProjectsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type UpdateProjectDataCacheProjectsReadyState = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsReadyState
>;

export const UpdateProjectDataCacheProjectsReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type UpdateProjectDataCacheProjectsReadySubstate = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsReadySubstate
>;

export const UpdateProjectDataCacheType = {
  Lambdas: "LAMBDAS",
} as const;
export type UpdateProjectDataCacheType = ClosedEnum<
  typeof UpdateProjectDataCacheType
>;

export type LatestDeployments = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectDataCacheProjectsAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: BranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectDataCacheProjectsBuilds> | undefined;
  checksConclusion?: UpdateProjectDataCacheProjectsChecksConclusion | undefined;
  checksState?: UpdateProjectDataCacheProjectsChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectDataCacheProjectsCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectDataCacheProjectsOidcTokenClaims | undefined;
  plan: UpdateProjectDataCacheProjectsPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: UpdateProjectDataCacheProjectsReadyState;
  readySubstate?: UpdateProjectDataCacheProjectsReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: UpdateProjectDataCacheType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export const UpdateProjectDataCacheLinkProjectsType = {
  Bitbucket: "bitbucket",
} as const;
export type UpdateProjectDataCacheLinkProjectsType = ClosedEnum<
  typeof UpdateProjectDataCacheLinkProjectsType
>;

export type UpdateProjectDataCacheLinkDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type Link3 = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: UpdateProjectDataCacheLinkProjectsType | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectDataCacheLinkDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const UpdateProjectDataCacheLinkType = {
  Gitlab: "gitlab",
} as const;
export type UpdateProjectDataCacheLinkType = ClosedEnum<
  typeof UpdateProjectDataCacheLinkType
>;

export type LinkDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type Link2 = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes. This is the id of the top level group that a namespace belongs to. Gitlab supports group nesting (up to 20 levels).
   */
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: UpdateProjectDataCacheLinkType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<LinkDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const LinkType = {
  Github: "github",
} as const;
export type LinkType = ClosedEnum<typeof LinkType>;

export type DeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type Link1 = {
  org?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes.
   */
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: LinkType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<DeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export type Link = Link1 | Link3 | Link2;

/**
 * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
 */
export type Group = {
  /**
   * A unique identifier for the group of microfrontends. All related microfrontend projects will share this group ID. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
   */
  id: string;
  /**
   * A human readable name for the microfrontends group. This will be used to display the microfrontends group in the UI.
   */
  slug: string;
};

export type Microfrontends = {
  /**
   * Timestamp when the microfrontends settings were last updated.
   */
  updatedAt: number;
  /**
   * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
   */
  group: Group;
  /**
   * Whether microfrontends are enabled for this project.
   */
  enabled: boolean;
  /**
   * Whether this project is the default application for the microfrontends group. The default application is the one that is used as the top level shell for the microfrontends group and hosts the other microfrontends.
   */
  isDefaultApp?: boolean | undefined;
  /**
   * A path that is used to take screenshots and as the default path in preview links when a domain for this microfrontend is shown in the UI.
   */
  defaultRoute?: string | undefined;
};

export const UpdateProjectDataCacheNodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
  Eight10X: "8.10.x",
} as const;
export type UpdateProjectDataCacheNodeVersion = ClosedEnum<
  typeof UpdateProjectDataCacheNodeVersion
>;

export type UpdateProjectDataCachePaths = {
  value: string;
};

export type UpdateProjectDataCacheOptionsAllowlist = {
  paths: Array<UpdateProjectDataCachePaths>;
};

export type UpdateProjectDataCachePasswordProtection = {};

export const FunctionDefaultMemoryType = {
  StandardLegacy: "standard_legacy",
  Standard: "standard",
  Performance: "performance",
} as const;
export type FunctionDefaultMemoryType = ClosedEnum<
  typeof FunctionDefaultMemoryType
>;

export type ResourceConfig = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?: FunctionDefaultMemoryType | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

export const UpdateProjectDataCacheDeploymentType = {
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type UpdateProjectDataCacheDeploymentType = ClosedEnum<
  typeof UpdateProjectDataCacheDeploymentType
>;

export type UpdateProjectDataCacheSsoProtection = {
  deploymentType: UpdateProjectDataCacheDeploymentType;
};

export type UpdateProjectDataCacheAliasAssigned = number | boolean;

export type UpdateProjectDataCacheAliasError = {
  code: string;
  message: string;
};

export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType =
  {
    EndsWith: "endsWith",
    StartsWith: "startsWith",
    Equals: "equals",
  } as const;
export type UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType =
  ClosedEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType
  >;

export type UpdateProjectDataCacheBranchMatcher = {
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType;
  pattern: string;
};

export type UpdateProjectDataCacheBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const UpdateProjectDataCacheChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type UpdateProjectDataCacheChecksConclusion = ClosedEnum<
  typeof UpdateProjectDataCacheChecksConclusion
>;

export const UpdateProjectDataCacheChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type UpdateProjectDataCacheChecksState = ClosedEnum<
  typeof UpdateProjectDataCacheChecksState
>;

export type UpdateProjectDataCacheCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type UpdateProjectDataCacheOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const UpdateProjectDataCachePlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type UpdateProjectDataCachePlan = ClosedEnum<
  typeof UpdateProjectDataCachePlan
>;

export const UpdateProjectDataCacheReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type UpdateProjectDataCacheReadyState = ClosedEnum<
  typeof UpdateProjectDataCacheReadyState
>;

export const UpdateProjectDataCacheReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type UpdateProjectDataCacheReadySubstate = ClosedEnum<
  typeof UpdateProjectDataCacheReadySubstate
>;

export const UpdateProjectDataCacheProjectsType = {
  Lambdas: "LAMBDAS",
} as const;
export type UpdateProjectDataCacheProjectsType = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsType
>;

export type Targets = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectDataCacheAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: UpdateProjectDataCacheBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectDataCacheBuilds> | undefined;
  checksConclusion?: UpdateProjectDataCacheChecksConclusion | undefined;
  checksState?: UpdateProjectDataCacheChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectDataCacheCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectDataCacheOidcTokenClaims | undefined;
  plan: UpdateProjectDataCachePlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: UpdateProjectDataCacheReadyState;
  readySubstate?: UpdateProjectDataCacheReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: UpdateProjectDataCacheProjectsType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export type Permissions = {
  accessGroup?: Array<ACLAction> | undefined;
  aliasGlobal?: Array<ACLAction> | undefined;
  analyticsSampling?: Array<ACLAction> | undefined;
  analyticsUsage?: Array<ACLAction> | undefined;
  auditLog?: Array<ACLAction> | undefined;
  billingAddress?: Array<ACLAction> | undefined;
  billingInformation?: Array<ACLAction> | undefined;
  billingInvoice?: Array<ACLAction> | undefined;
  billingInvoiceEmailRecipient?: Array<ACLAction> | undefined;
  billingInvoiceLanguage?: Array<ACLAction> | undefined;
  billingPlan?: Array<ACLAction> | undefined;
  billingPurchaseOrder?: Array<ACLAction> | undefined;
  billingTaxId?: Array<ACLAction> | undefined;
  blob?: Array<ACLAction> | undefined;
  budget?: Array<ACLAction> | undefined;
  cacheArtifact?: Array<ACLAction> | undefined;
  cacheArtifactUsageEvent?: Array<ACLAction> | undefined;
  codeChecks?: Array<ACLAction> | undefined;
  concurrentBuilds?: Array<ACLAction> | undefined;
  connect?: Array<ACLAction> | undefined;
  connectConfiguration?: Array<ACLAction> | undefined;
  domain?: Array<ACLAction> | undefined;
  domainAcceptDelegation?: Array<ACLAction> | undefined;
  domainAuthCodes?: Array<ACLAction> | undefined;
  domainCertificate?: Array<ACLAction> | undefined;
  domainCheckConfig?: Array<ACLAction> | undefined;
  domainMove?: Array<ACLAction> | undefined;
  domainPurchase?: Array<ACLAction> | undefined;
  domainRecord?: Array<ACLAction> | undefined;
  domainTransferIn?: Array<ACLAction> | undefined;
  event?: Array<ACLAction> | undefined;
  ownEvent?: Array<ACLAction> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<ACLAction> | undefined;
  fileUpload?: Array<ACLAction> | undefined;
  gitRepository?: Array<ACLAction> | undefined;
  ipBlocking?: Array<ACLAction> | undefined;
  integration?: Array<ACLAction> | undefined;
  integrationAccount?: Array<ACLAction> | undefined;
  integrationConfiguration?: Array<ACLAction> | undefined;
  integrationConfigurationTransfer?: Array<ACLAction> | undefined;
  integrationConfigurationProjects?: Array<ACLAction> | undefined;
  integrationVercelConfigurationOverride?: Array<ACLAction> | undefined;
  integrationConfigurationRole?: Array<ACLAction> | undefined;
  integrationResource?: Array<ACLAction> | undefined;
  integrationEvent?: Array<ACLAction> | undefined;
  integrationResourceSecrets?: Array<ACLAction> | undefined;
  integrationDeploymentAction?: Array<ACLAction> | undefined;
  marketplaceInstallationMember?: Array<ACLAction> | undefined;
  marketplaceBillingData?: Array<ACLAction> | undefined;
  marketplaceInvoice?: Array<ACLAction> | undefined;
  jobGlobal?: Array<ACLAction> | undefined;
  logDrain?: Array<ACLAction> | undefined;
  monitoring?: Array<ACLAction> | undefined;
  monitoringSettings?: Array<ACLAction> | undefined;
  monitoringQuery?: Array<ACLAction> | undefined;
  monitoringChart?: Array<ACLAction> | undefined;
  monitoringAlert?: Array<ACLAction> | undefined;
  notificationDeploymentFailed?: Array<ACLAction> | undefined;
  notificationDomainConfiguration?: Array<ACLAction> | undefined;
  notificationDomainExpire?: Array<ACLAction> | undefined;
  notificationDomainMoved?: Array<ACLAction> | undefined;
  notificationDomainPurchase?: Array<ACLAction> | undefined;
  notificationDomainRenewal?: Array<ACLAction> | undefined;
  notificationDomainTransfer?: Array<ACLAction> | undefined;
  notificationDomainUnverified?: Array<ACLAction> | undefined;
  notificationMonitoringAlert?: Array<ACLAction> | undefined;
  notificationPaymentFailed?: Array<ACLAction> | undefined;
  notificationUsageAlert?: Array<ACLAction> | undefined;
  notificationCustomerBudget?: Array<ACLAction> | undefined;
  notificationStatementOfReasons?: Array<ACLAction> | undefined;
  oauth2Connection?: Array<ACLAction> | undefined;
  openTelemetryEndpoint?: Array<ACLAction> | undefined;
  paymentMethod?: Array<ACLAction> | undefined;
  permissions?: Array<ACLAction> | undefined;
  postgres?: Array<ACLAction> | undefined;
  previewDeploymentSuffix?: Array<ACLAction> | undefined;
  proTrialOnboarding?: Array<ACLAction> | undefined;
  sharedEnvVars?: Array<ACLAction> | undefined;
  sharedEnvVarsProduction?: Array<ACLAction> | undefined;
  space?: Array<ACLAction> | undefined;
  spaceRun?: Array<ACLAction> | undefined;
  passwordProtectionInvoiceItem?: Array<ACLAction> | undefined;
  rateLimit?: Array<ACLAction> | undefined;
  redis?: Array<ACLAction> | undefined;
  repository?: Array<ACLAction> | undefined;
  remoteCaching?: Array<ACLAction> | undefined;
  samlConfig?: Array<ACLAction> | undefined;
  secret?: Array<ACLAction> | undefined;
  redisStoreTokenSet?: Array<ACLAction> | undefined;
  blobStoreTokenSet?: Array<ACLAction> | undefined;
  postgresStoreTokenSet?: Array<ACLAction> | undefined;
  integrationStoreTokenSet?: Array<ACLAction> | undefined;
  integrationResourceReplCommand?: Array<ACLAction> | undefined;
  storeTransfer?: Array<ACLAction> | undefined;
  supportCase?: Array<ACLAction> | undefined;
  supportCaseComment?: Array<ACLAction> | undefined;
  dataCacheBillingSettings?: Array<ACLAction> | undefined;
  team?: Array<ACLAction> | undefined;
  teamAccessRequest?: Array<ACLAction> | undefined;
  teamFellowMembership?: Array<ACLAction> | undefined;
  teamGitExclusivity?: Array<ACLAction> | undefined;
  teamInvite?: Array<ACLAction> | undefined;
  teamInviteCode?: Array<ACLAction> | undefined;
  teamJoin?: Array<ACLAction> | undefined;
  teamOwnMembership?: Array<ACLAction> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<ACLAction> | undefined;
  token?: Array<ACLAction> | undefined;
  usage?: Array<ACLAction> | undefined;
  usageCycle?: Array<ACLAction> | undefined;
  user?: Array<ACLAction> | undefined;
  userConnection?: Array<ACLAction> | undefined;
  vpcPeeringConnection?: Array<ACLAction> | undefined;
  webAnalyticsPlan?: Array<ACLAction> | undefined;
  webAuthn?: Array<ACLAction> | undefined;
  edgeConfig?: Array<ACLAction> | undefined;
  edgeConfigItem?: Array<ACLAction> | undefined;
  edgeConfigSchema?: Array<ACLAction> | undefined;
  edgeConfigToken?: Array<ACLAction> | undefined;
  webhook?: Array<ACLAction> | undefined;
  webhookEvent?: Array<ACLAction> | undefined;
  endpointVerification?: Array<ACLAction> | undefined;
  projectTransferIn?: Array<ACLAction> | undefined;
  oauth2Application?: Array<ACLAction> | undefined;
  aliasProject?: Array<ACLAction> | undefined;
  aliasProtectionBypass?: Array<ACLAction> | undefined;
  productionAliasProtectionBypass?: Array<ACLAction> | undefined;
  connectConfigurationLink?: Array<ACLAction> | undefined;
  dataCacheNamespace?: Array<ACLAction> | undefined;
  deployment?: Array<ACLAction> | undefined;
  deploymentCheck?: Array<ACLAction> | undefined;
  deploymentCheckPreview?: Array<ACLAction> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<ACLAction> | undefined;
  deploymentProductionGit?: Array<ACLAction> | undefined;
  deploymentPreview?: Array<ACLAction> | undefined;
  deploymentPrivate?: Array<ACLAction> | undefined;
  deploymentPromote?: Array<ACLAction> | undefined;
  deploymentRollback?: Array<ACLAction> | undefined;
  environments?: Array<ACLAction> | undefined;
  logs?: Array<ACLAction> | undefined;
  logsPreset?: Array<ACLAction> | undefined;
  passwordProtection?: Array<ACLAction> | undefined;
  optionsAllowlist?: Array<ACLAction> | undefined;
  job?: Array<ACLAction> | undefined;
  project?: Array<ACLAction> | undefined;
  projectAccessGroup?: Array<ACLAction> | undefined;
  projectAnalyticsSampling?: Array<ACLAction> | undefined;
  projectDeploymentHook?: Array<ACLAction> | undefined;
  projectDomain?: Array<ACLAction> | undefined;
  projectDomainMove?: Array<ACLAction> | undefined;
  projectDomainCheckConfig?: Array<ACLAction> | undefined;
  projectEnvVars?: Array<ACLAction> | undefined;
  projectEnvVarsProduction?: Array<ACLAction> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<ACLAction> | undefined;
  projectFlags?: Array<ACLAction> | undefined;
  projectId?: Array<ACLAction> | undefined;
  projectIntegrationConfiguration?: Array<ACLAction> | undefined;
  projectLink?: Array<ACLAction> | undefined;
  projectMember?: Array<ACLAction> | undefined;
  projectMonitoring?: Array<ACLAction> | undefined;
  projectPermissions?: Array<ACLAction> | undefined;
  projectProductionBranch?: Array<ACLAction> | undefined;
  projectTransfer?: Array<ACLAction> | undefined;
  projectTransferOut?: Array<ACLAction> | undefined;
  projectProtectionBypass?: Array<ACLAction> | undefined;
  projectUsage?: Array<ACLAction> | undefined;
  projectAnalyticsUsage?: Array<ACLAction> | undefined;
  projectSupportCase?: Array<ACLAction> | undefined;
  projectSupportCaseComment?: Array<ACLAction> | undefined;
  projectDeploymentExpiration?: Array<ACLAction> | undefined;
  projectTier?: Array<ACLAction> | undefined;
  seawallConfig?: Array<ACLAction> | undefined;
  skewProtection?: Array<ACLAction> | undefined;
  analytics?: Array<ACLAction> | undefined;
  trustedIps?: Array<ACLAction> | undefined;
  webAnalytics?: Array<ACLAction> | undefined;
  sharedEnvVarConnection?: Array<ACLAction> | undefined;
  sonar?: Array<ACLAction> | undefined;
};

export type LastRollbackTarget = {};

export const JobStatus = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Pending: "pending",
  InProgress: "in-progress",
} as const;
export type JobStatus = ClosedEnum<typeof JobStatus>;

export const UpdateProjectDataCacheProjectsResponseType = {
  Promote: "promote",
  Rollback: "rollback",
} as const;
export type UpdateProjectDataCacheProjectsResponseType = ClosedEnum<
  typeof UpdateProjectDataCacheProjectsResponseType
>;

export type LastAliasRequest = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: JobStatus;
  requestedAt: number;
  type: UpdateProjectDataCacheProjectsResponseType;
};

export const Scope = {
  AutomationBypass: "automation-bypass",
} as const;
export type Scope = ClosedEnum<typeof Scope>;

export type ProtectionBypass = {
  createdAt: number;
  createdBy: string;
  scope: Scope;
};

export const UpdateProjectDataCacheTrustedIpsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type UpdateProjectDataCacheTrustedIpsDeploymentType = ClosedEnum<
  typeof UpdateProjectDataCacheTrustedIpsDeploymentType
>;

export type TrustedIps2 = {
  deploymentType: UpdateProjectDataCacheTrustedIpsDeploymentType;
};

export const TrustedIpsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type TrustedIpsDeploymentType = ClosedEnum<
  typeof TrustedIpsDeploymentType
>;

export type UpdateProjectDataCacheTrustedIpsAddresses = {
  value: string;
  note?: string | undefined;
};

export const UpdateProjectDataCacheTrustedIpsProtectionMode = {
  Additional: "additional",
  Exclusive: "exclusive",
} as const;
export type UpdateProjectDataCacheTrustedIpsProtectionMode = ClosedEnum<
  typeof UpdateProjectDataCacheTrustedIpsProtectionMode
>;

export type TrustedIps1 = {
  deploymentType: TrustedIpsDeploymentType;
  addresses: Array<UpdateProjectDataCacheTrustedIpsAddresses>;
  protectionMode: UpdateProjectDataCacheTrustedIpsProtectionMode;
};

export type UpdateProjectDataCacheTrustedIps = TrustedIps2 | TrustedIps1;

export type GitComments = {
  /**
   * Whether the Vercel bot should comment on PRs
   */
  onPullRequest: boolean;
  /**
   * Whether the Vercel bot should comment on commits
   */
  onCommit: boolean;
};

export type WebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type Src2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type Src = Src2 | string;

export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType =
  ClosedEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType
  >;

export type UpdateProjectDataCacheValueProjects2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type UpdateProjectDataCacheProjectsValue =
  | UpdateProjectDataCacheValueProjects2
  | string;

export type Has = {
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType;
  key?: string | undefined;
  value?: UpdateProjectDataCacheValueProjects2 | string | undefined;
};

export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType =
  ClosedEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  >;

export type UpdateProjectDataCacheValue2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type UpdateProjectDataCacheValue = UpdateProjectDataCacheValue2 | string;

export type Missing = {
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType;
  key?: string | undefined;
  value?: UpdateProjectDataCacheValue2 | string | undefined;
};

export const Handle = {
  Init: "init",
  Finalize: "finalize",
} as const;
export type Handle = ClosedEnum<typeof Handle>;

export const UpdateProjectDataCacheAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type UpdateProjectDataCacheAction = ClosedEnum<
  typeof UpdateProjectDataCacheAction
>;

export const UpdateProjectDataCacheAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type UpdateProjectDataCacheAlgo = ClosedEnum<
  typeof UpdateProjectDataCacheAlgo
>;

export type Erl = {
  algo: UpdateProjectDataCacheAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
};

export type UpdateProjectDataCacheMitigate = {
  action: UpdateProjectDataCacheAction;
  ruleId: string;
  ttl?: number | undefined;
  erl?: Erl | undefined;
};

export type FirewallRoutes = {
  src?: Src2 | string | undefined;
  has?: Array<Has> | undefined;
  missing?: Array<Missing> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: Handle | undefined;
  mitigate?: UpdateProjectDataCacheMitigate | undefined;
};

export type Security = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<FirewallRoutes> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export const UpdateProjectDataCacheIssuerMode = {
  Team: "team",
  Global: "global",
} as const;
/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export type UpdateProjectDataCacheIssuerMode = ClosedEnum<
  typeof UpdateProjectDataCacheIssuerMode
>;

export type UpdateProjectDataCacheOidcTokenConfig = {
  enabled: boolean;
  /**
   * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
   */
  issuerMode?: UpdateProjectDataCacheIssuerMode | undefined;
};

export const Tier = {
  Standard: "standard",
  Advanced: "advanced",
  Critical: "critical",
} as const;
export type Tier = ClosedEnum<typeof Tier>;

export type UpdateProjectDataCacheResponseBody = {
  accountId: string;
  analytics?: Analytics | undefined;
  speedInsights?: SpeedInsights | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: Crons | undefined;
  dataCache?: DataCache | undefined;
  deploymentExpiration?: DeploymentExpiration | null | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<Env> | undefined;
  customEnvironments?: Array<CustomEnvironments> | undefined;
  framework?: UpdateProjectDataCacheFramework | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<IpBuckets> | undefined;
  latestDeployments?: Array<LatestDeployments> | undefined;
  link?: Link1 | Link3 | Link2 | undefined;
  microfrontends?: Microfrontends | undefined;
  name: string;
  nodeVersion: UpdateProjectDataCacheNodeVersion;
  optionsAllowlist?: UpdateProjectDataCacheOptionsAllowlist | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?:
    | UpdateProjectDataCachePasswordProtection
    | null
    | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: ResourceConfig | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: UpdateProjectDataCacheSsoProtection | null | undefined;
  targets?: { [k: string]: Targets } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: Permissions | undefined;
  lastRollbackTarget?: LastRollbackTarget | null | undefined;
  lastAliasRequest?: LastAliasRequest | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?: { [k: string]: ProtectionBypass } | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?: TrustedIps2 | TrustedIps1 | null | undefined;
  gitComments?: GitComments | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: WebAnalytics | undefined;
  security?: Security | undefined;
  oidcTokenConfig?: UpdateProjectDataCacheOidcTokenConfig | undefined;
  tier?: Tier | undefined;
};

/** @internal */
export const UpdateProjectDataCacheRequestBody$inboundSchema: z.ZodType<
  UpdateProjectDataCacheRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  disabled: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectDataCacheRequestBody$Outbound = {
  disabled?: boolean | undefined;
};

/** @internal */
export const UpdateProjectDataCacheRequestBody$outboundSchema: z.ZodType<
  UpdateProjectDataCacheRequestBody$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheRequestBody
> = z.object({
  disabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheRequestBody$ {
  /** @deprecated use `UpdateProjectDataCacheRequestBody$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheRequestBody$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheRequestBody$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheRequestBody$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheRequestBody$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheRequestBody$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheRequest$inboundSchema: z.ZodType<
  UpdateProjectDataCacheRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => UpdateProjectDataCacheRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type UpdateProjectDataCacheRequest$Outbound = {
  projectId: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: UpdateProjectDataCacheRequestBody$Outbound | undefined;
};

/** @internal */
export const UpdateProjectDataCacheRequest$outboundSchema: z.ZodType<
  UpdateProjectDataCacheRequest$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheRequest
> = z.object({
  projectId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => UpdateProjectDataCacheRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheRequest$ {
  /** @deprecated use `UpdateProjectDataCacheRequest$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheRequest$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheRequest$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheRequest$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheRequest$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheRequest$Outbound;
}

/** @internal */
export const Analytics$inboundSchema: z.ZodType<
  Analytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/** @internal */
export type Analytics$Outbound = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

/** @internal */
export const Analytics$outboundSchema: z.ZodType<
  Analytics$Outbound,
  z.ZodTypeDef,
  Analytics
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Analytics$ {
  /** @deprecated use `Analytics$inboundSchema` instead. */
  export const inboundSchema = Analytics$inboundSchema;
  /** @deprecated use `Analytics$outboundSchema` instead. */
  export const outboundSchema = Analytics$outboundSchema;
  /** @deprecated use `Analytics$Outbound` instead. */
  export type Outbound = Analytics$Outbound;
}

/** @internal */
export const SpeedInsights$inboundSchema: z.ZodType<
  SpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type SpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const SpeedInsights$outboundSchema: z.ZodType<
  SpeedInsights$Outbound,
  z.ZodTypeDef,
  SpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace SpeedInsights$ {
  /** @deprecated use `SpeedInsights$inboundSchema` instead. */
  export const inboundSchema = SpeedInsights$inboundSchema;
  /** @deprecated use `SpeedInsights$outboundSchema` instead. */
  export const outboundSchema = SpeedInsights$outboundSchema;
  /** @deprecated use `SpeedInsights$Outbound` instead. */
  export type Outbound = SpeedInsights$Outbound;
}

/** @internal */
export const Definitions$inboundSchema: z.ZodType<
  Definitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/** @internal */
export type Definitions$Outbound = {
  host: string;
  path: string;
  schedule: string;
};

/** @internal */
export const Definitions$outboundSchema: z.ZodType<
  Definitions$Outbound,
  z.ZodTypeDef,
  Definitions
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Definitions$ {
  /** @deprecated use `Definitions$inboundSchema` instead. */
  export const inboundSchema = Definitions$inboundSchema;
  /** @deprecated use `Definitions$outboundSchema` instead. */
  export const outboundSchema = Definitions$outboundSchema;
  /** @deprecated use `Definitions$Outbound` instead. */
  export type Outbound = Definitions$Outbound;
}

/** @internal */
export const Crons$inboundSchema: z.ZodType<Crons, z.ZodTypeDef, unknown> = z
  .object({
    enabledAt: z.number(),
    disabledAt: z.nullable(z.number()),
    updatedAt: z.number(),
    deploymentId: z.nullable(z.string()),
    definitions: z.array(z.lazy(() => Definitions$inboundSchema)),
  });

/** @internal */
export type Crons$Outbound = {
  enabledAt: number;
  disabledAt: number | null;
  updatedAt: number;
  deploymentId: string | null;
  definitions: Array<Definitions$Outbound>;
};

/** @internal */
export const Crons$outboundSchema: z.ZodType<
  Crons$Outbound,
  z.ZodTypeDef,
  Crons
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => Definitions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Crons$ {
  /** @deprecated use `Crons$inboundSchema` instead. */
  export const inboundSchema = Crons$inboundSchema;
  /** @deprecated use `Crons$outboundSchema` instead. */
  export const outboundSchema = Crons$outboundSchema;
  /** @deprecated use `Crons$Outbound` instead. */
  export type Outbound = Crons$Outbound;
}

/** @internal */
export const DataCache$inboundSchema: z.ZodType<
  DataCache,
  z.ZodTypeDef,
  unknown
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/** @internal */
export type DataCache$Outbound = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

/** @internal */
export const DataCache$outboundSchema: z.ZodType<
  DataCache$Outbound,
  z.ZodTypeDef,
  DataCache
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DataCache$ {
  /** @deprecated use `DataCache$inboundSchema` instead. */
  export const inboundSchema = DataCache$inboundSchema;
  /** @deprecated use `DataCache$outboundSchema` instead. */
  export const outboundSchema = DataCache$outboundSchema;
  /** @deprecated use `DataCache$Outbound` instead. */
  export type Outbound = DataCache$Outbound;
}

/** @internal */
export const DeploymentExpiration$inboundSchema: z.ZodType<
  DeploymentExpiration,
  z.ZodTypeDef,
  unknown
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/** @internal */
export type DeploymentExpiration$Outbound = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

/** @internal */
export const DeploymentExpiration$outboundSchema: z.ZodType<
  DeploymentExpiration$Outbound,
  z.ZodTypeDef,
  DeploymentExpiration
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeploymentExpiration$ {
  /** @deprecated use `DeploymentExpiration$inboundSchema` instead. */
  export const inboundSchema = DeploymentExpiration$inboundSchema;
  /** @deprecated use `DeploymentExpiration$outboundSchema` instead. */
  export const outboundSchema = DeploymentExpiration$outboundSchema;
  /** @deprecated use `DeploymentExpiration$Outbound` instead. */
  export type Outbound = DeploymentExpiration$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheTarget2$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheTarget2
> = z.nativeEnum(UpdateProjectDataCacheTarget2);

/** @internal */
export const UpdateProjectDataCacheTarget2$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheTarget2
> = UpdateProjectDataCacheTarget2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTarget2$ {
  /** @deprecated use `UpdateProjectDataCacheTarget2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheTarget2$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTarget2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheTarget2$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheTarget1$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheTarget1
> = z.nativeEnum(UpdateProjectDataCacheTarget1);

/** @internal */
export const UpdateProjectDataCacheTarget1$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheTarget1
> = UpdateProjectDataCacheTarget1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTarget1$ {
  /** @deprecated use `UpdateProjectDataCacheTarget1$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheTarget1$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTarget1$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheTarget1$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheTarget$inboundSchema: z.ZodType<
  UpdateProjectDataCacheTarget,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(UpdateProjectDataCacheTarget1$inboundSchema),
  UpdateProjectDataCacheTarget2$inboundSchema,
]);

/** @internal */
export type UpdateProjectDataCacheTarget$Outbound = Array<string> | string;

/** @internal */
export const UpdateProjectDataCacheTarget$outboundSchema: z.ZodType<
  UpdateProjectDataCacheTarget$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheTarget
> = z.union([
  z.array(UpdateProjectDataCacheTarget1$outboundSchema),
  UpdateProjectDataCacheTarget2$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTarget$ {
  /** @deprecated use `UpdateProjectDataCacheTarget$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheTarget$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTarget$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheTarget$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTarget$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheTarget$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsResponse200Type> = z
    .nativeEnum(UpdateProjectDataCacheProjectsResponse200Type);

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsResponse200Type> =
    UpdateProjectDataCacheProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponse200Type$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponse200Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema;
}

/** @internal */
export const Fifteen$inboundSchema: z.ZodType<Fifteen, z.ZodTypeDef, unknown> =
  z.object({
    type:
      UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema,
    projectId: z.string(),
  });

/** @internal */
export type Fifteen$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const Fifteen$outboundSchema: z.ZodType<
  Fifteen$Outbound,
  z.ZodTypeDef,
  Fifteen
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Fifteen$ {
  /** @deprecated use `Fifteen$inboundSchema` instead. */
  export const inboundSchema = Fifteen$inboundSchema;
  /** @deprecated use `Fifteen$outboundSchema` instead. */
  export const outboundSchema = Fifteen$outboundSchema;
  /** @deprecated use `Fifteen$Outbound` instead. */
  export type Outbound = Fifteen$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema;
}

/** @internal */
export const Fourteen$inboundSchema: z.ZodType<
  Fourteen,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type Fourteen$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const Fourteen$outboundSchema: z.ZodType<
  Fourteen$Outbound,
  z.ZodTypeDef,
  Fourteen
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Fourteen$ {
  /** @deprecated use `Fourteen$inboundSchema` instead. */
  export const inboundSchema = Fourteen$inboundSchema;
  /** @deprecated use `Fourteen$outboundSchema` instead. */
  export const outboundSchema = Fourteen$outboundSchema;
  /** @deprecated use `Fourteen$Outbound` instead. */
  export type Outbound = Fourteen$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema;
}

/** @internal */
export const Thirteen$inboundSchema: z.ZodType<
  Thirteen,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type Thirteen$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const Thirteen$outboundSchema: z.ZodType<
  Thirteen$Outbound,
  z.ZodTypeDef,
  Thirteen
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Thirteen$ {
  /** @deprecated use `Thirteen$inboundSchema` instead. */
  export const inboundSchema = Thirteen$inboundSchema;
  /** @deprecated use `Thirteen$outboundSchema` instead. */
  export const outboundSchema = Thirteen$outboundSchema;
  /** @deprecated use `Thirteen$Outbound` instead. */
  export type Outbound = Thirteen$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema;
}

/** @internal */
export const Twelve$inboundSchema: z.ZodType<Twelve, z.ZodTypeDef, unknown> = z
  .object({
    type:
      UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema,
    storeId: z.string(),
  });

/** @internal */
export type Twelve$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const Twelve$outboundSchema: z.ZodType<
  Twelve$Outbound,
  z.ZodTypeDef,
  Twelve
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Twelve$ {
  /** @deprecated use `Twelve$inboundSchema` instead. */
  export const inboundSchema = Twelve$inboundSchema;
  /** @deprecated use `Twelve$outboundSchema` instead. */
  export const outboundSchema = Twelve$outboundSchema;
  /** @deprecated use `Twelve$Outbound` instead. */
  export type Outbound = Twelve$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheContentHint11$inboundSchema: z.ZodType<
  UpdateProjectDataCacheContentHint11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheContentHint11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectDataCacheContentHint11$outboundSchema: z.ZodType<
  UpdateProjectDataCacheContentHint11$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheContentHint11
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHint11$ {
  /** @deprecated use `UpdateProjectDataCacheContentHint11$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHint11$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHint11$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHint11$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHint11$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheContentHint11$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema;
}

/** @internal */
export const ContentHint10$inboundSchema: z.ZodType<
  ContentHint10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint10$outboundSchema: z.ZodType<
  ContentHint10$Outbound,
  z.ZodTypeDef,
  ContentHint10
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint10$ {
  /** @deprecated use `ContentHint10$inboundSchema` instead. */
  export const inboundSchema = ContentHint10$inboundSchema;
  /** @deprecated use `ContentHint10$outboundSchema` instead. */
  export const outboundSchema = ContentHint10$outboundSchema;
  /** @deprecated use `ContentHint10$Outbound` instead. */
  export type Outbound = ContentHint10$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema;
}

/** @internal */
export const ContentHint9$inboundSchema: z.ZodType<
  ContentHint9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint9$outboundSchema: z.ZodType<
  ContentHint9$Outbound,
  z.ZodTypeDef,
  ContentHint9
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint9$ {
  /** @deprecated use `ContentHint9$inboundSchema` instead. */
  export const inboundSchema = ContentHint9$inboundSchema;
  /** @deprecated use `ContentHint9$outboundSchema` instead. */
  export const outboundSchema = ContentHint9$outboundSchema;
  /** @deprecated use `ContentHint9$Outbound` instead. */
  export type Outbound = ContentHint9$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema;
}

/** @internal */
export const ContentHint8$inboundSchema: z.ZodType<
  ContentHint8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint8$outboundSchema: z.ZodType<
  ContentHint8$Outbound,
  z.ZodTypeDef,
  ContentHint8
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint8$ {
  /** @deprecated use `ContentHint8$inboundSchema` instead. */
  export const inboundSchema = ContentHint8$inboundSchema;
  /** @deprecated use `ContentHint8$outboundSchema` instead. */
  export const outboundSchema = ContentHint8$outboundSchema;
  /** @deprecated use `ContentHint8$Outbound` instead. */
  export type Outbound = ContentHint8$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const ContentHint7$inboundSchema: z.ZodType<
  ContentHint7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint7$outboundSchema: z.ZodType<
  ContentHint7$Outbound,
  z.ZodTypeDef,
  ContentHint7
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint7$ {
  /** @deprecated use `ContentHint7$inboundSchema` instead. */
  export const inboundSchema = ContentHint7$inboundSchema;
  /** @deprecated use `ContentHint7$outboundSchema` instead. */
  export const outboundSchema = ContentHint7$outboundSchema;
  /** @deprecated use `ContentHint7$Outbound` instead. */
  export type Outbound = ContentHint7$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType
  > = z.nativeEnum(
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType
  > =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const ContentHint6$inboundSchema: z.ZodType<
  ContentHint6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint6$outboundSchema: z.ZodType<
  ContentHint6$Outbound,
  z.ZodTypeDef,
  ContentHint6
> = z.object({
  type:
    UpdateProjectDataCacheContentHintProjectsResponse200ApplicationJSONType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint6$ {
  /** @deprecated use `ContentHint6$inboundSchema` instead. */
  export const inboundSchema = ContentHint6$inboundSchema;
  /** @deprecated use `ContentHint6$outboundSchema` instead. */
  export const outboundSchema = ContentHint6$outboundSchema;
  /** @deprecated use `ContentHint6$Outbound` instead. */
  export type Outbound = ContentHint6$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200Type
  > = z.nativeEnum(UpdateProjectDataCacheContentHintProjectsResponse200Type);

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponse200Type
  > = UpdateProjectDataCacheContentHintProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponse200Type$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200Type$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const ContentHint5$inboundSchema: z.ZodType<
  ContentHint5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectDataCacheContentHintProjectsResponse200Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint5$outboundSchema: z.ZodType<
  ContentHint5$Outbound,
  z.ZodTypeDef,
  ContentHint5
> = z.object({
  type: UpdateProjectDataCacheContentHintProjectsResponse200Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint5$ {
  /** @deprecated use `ContentHint5$inboundSchema` instead. */
  export const inboundSchema = ContentHint5$inboundSchema;
  /** @deprecated use `ContentHint5$outboundSchema` instead. */
  export const outboundSchema = ContentHint5$outboundSchema;
  /** @deprecated use `ContentHint5$Outbound` instead. */
  export type Outbound = ContentHint5$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponseType
  > = z.nativeEnum(UpdateProjectDataCacheContentHintProjectsResponseType);

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheContentHintProjectsResponseType
  > = UpdateProjectDataCacheContentHintProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsResponseType$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponseType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsResponseType$outboundSchema;
}

/** @internal */
export const ContentHint4$inboundSchema: z.ZodType<
  ContentHint4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectDataCacheContentHintProjectsResponseType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint4$outboundSchema: z.ZodType<
  ContentHint4$Outbound,
  z.ZodTypeDef,
  ContentHint4
> = z.object({
  type: UpdateProjectDataCacheContentHintProjectsResponseType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint4$ {
  /** @deprecated use `ContentHint4$inboundSchema` instead. */
  export const inboundSchema = ContentHint4$inboundSchema;
  /** @deprecated use `ContentHint4$outboundSchema` instead. */
  export const outboundSchema = ContentHint4$outboundSchema;
  /** @deprecated use `ContentHint4$Outbound` instead. */
  export type Outbound = ContentHint4$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheContentHintProjectsType> = z
    .nativeEnum(UpdateProjectDataCacheContentHintProjectsType);

/** @internal */
export const UpdateProjectDataCacheContentHintProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheContentHintProjectsType> =
    UpdateProjectDataCacheContentHintProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintProjectsType$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintProjectsType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintProjectsType$outboundSchema;
}

/** @internal */
export const ContentHint3$inboundSchema: z.ZodType<
  ContentHint3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectDataCacheContentHintProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint3$outboundSchema: z.ZodType<
  ContentHint3$Outbound,
  z.ZodTypeDef,
  ContentHint3
> = z.object({
  type: UpdateProjectDataCacheContentHintProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint3$ {
  /** @deprecated use `ContentHint3$inboundSchema` instead. */
  export const inboundSchema = ContentHint3$inboundSchema;
  /** @deprecated use `ContentHint3$outboundSchema` instead. */
  export const outboundSchema = ContentHint3$outboundSchema;
  /** @deprecated use `ContentHint3$Outbound` instead. */
  export type Outbound = ContentHint3$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheContentHintType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheContentHintType> = z.nativeEnum(
    UpdateProjectDataCacheContentHintType,
  );

/** @internal */
export const UpdateProjectDataCacheContentHintType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheContentHintType> =
    UpdateProjectDataCacheContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheContentHintType$ {
  /** @deprecated use `UpdateProjectDataCacheContentHintType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheContentHintType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheContentHintType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheContentHintType$outboundSchema;
}

/** @internal */
export const ContentHint2$inboundSchema: z.ZodType<
  ContentHint2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectDataCacheContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint2$outboundSchema: z.ZodType<
  ContentHint2$Outbound,
  z.ZodTypeDef,
  ContentHint2
> = z.object({
  type: UpdateProjectDataCacheContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint2$ {
  /** @deprecated use `ContentHint2$inboundSchema` instead. */
  export const inboundSchema = ContentHint2$inboundSchema;
  /** @deprecated use `ContentHint2$outboundSchema` instead. */
  export const outboundSchema = ContentHint2$outboundSchema;
  /** @deprecated use `ContentHint2$Outbound` instead. */
  export type Outbound = ContentHint2$Outbound;
}

/** @internal */
export const ContentHintType$inboundSchema: z.ZodNativeEnum<
  typeof ContentHintType
> = z.nativeEnum(ContentHintType);

/** @internal */
export const ContentHintType$outboundSchema: z.ZodNativeEnum<
  typeof ContentHintType
> = ContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHintType$ {
  /** @deprecated use `ContentHintType$inboundSchema` instead. */
  export const inboundSchema = ContentHintType$inboundSchema;
  /** @deprecated use `ContentHintType$outboundSchema` instead. */
  export const outboundSchema = ContentHintType$outboundSchema;
}

/** @internal */
export const ContentHint1$inboundSchema: z.ZodType<
  ContentHint1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: ContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint1$outboundSchema: z.ZodType<
  ContentHint1$Outbound,
  z.ZodTypeDef,
  ContentHint1
> = z.object({
  type: ContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint1$ {
  /** @deprecated use `ContentHint1$inboundSchema` instead. */
  export const inboundSchema = ContentHint1$inboundSchema;
  /** @deprecated use `ContentHint1$outboundSchema` instead. */
  export const outboundSchema = ContentHint1$outboundSchema;
  /** @deprecated use `ContentHint1$Outbound` instead. */
  export type Outbound = ContentHint1$Outbound;
}

/** @internal */
export const ContentHint$inboundSchema: z.ZodType<
  ContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => ContentHint1$inboundSchema),
  z.lazy(() => ContentHint2$inboundSchema),
  z.lazy(() => ContentHint3$inboundSchema),
  z.lazy(() => ContentHint4$inboundSchema),
  z.lazy(() => ContentHint5$inboundSchema),
  z.lazy(() => ContentHint6$inboundSchema),
  z.lazy(() => ContentHint7$inboundSchema),
  z.lazy(() => ContentHint8$inboundSchema),
  z.lazy(() => ContentHint9$inboundSchema),
  z.lazy(() => ContentHint10$inboundSchema),
  z.lazy(() => UpdateProjectDataCacheContentHint11$inboundSchema),
  z.lazy(() => Twelve$inboundSchema),
  z.lazy(() => Thirteen$inboundSchema),
  z.lazy(() => Fifteen$inboundSchema),
  z.lazy(() => Fourteen$inboundSchema),
]);

/** @internal */
export type ContentHint$Outbound =
  | ContentHint1$Outbound
  | ContentHint2$Outbound
  | ContentHint3$Outbound
  | ContentHint4$Outbound
  | ContentHint5$Outbound
  | ContentHint6$Outbound
  | ContentHint7$Outbound
  | ContentHint8$Outbound
  | ContentHint9$Outbound
  | ContentHint10$Outbound
  | UpdateProjectDataCacheContentHint11$Outbound
  | Twelve$Outbound
  | Thirteen$Outbound
  | Fifteen$Outbound
  | Fourteen$Outbound;

/** @internal */
export const ContentHint$outboundSchema: z.ZodType<
  ContentHint$Outbound,
  z.ZodTypeDef,
  ContentHint
> = z.union([
  z.lazy(() => ContentHint1$outboundSchema),
  z.lazy(() => ContentHint2$outboundSchema),
  z.lazy(() => ContentHint3$outboundSchema),
  z.lazy(() => ContentHint4$outboundSchema),
  z.lazy(() => ContentHint5$outboundSchema),
  z.lazy(() => ContentHint6$outboundSchema),
  z.lazy(() => ContentHint7$outboundSchema),
  z.lazy(() => ContentHint8$outboundSchema),
  z.lazy(() => ContentHint9$outboundSchema),
  z.lazy(() => ContentHint10$outboundSchema),
  z.lazy(() => UpdateProjectDataCacheContentHint11$outboundSchema),
  z.lazy(() => Twelve$outboundSchema),
  z.lazy(() => Thirteen$outboundSchema),
  z.lazy(() => Fifteen$outboundSchema),
  z.lazy(() => Fourteen$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint$ {
  /** @deprecated use `ContentHint$inboundSchema` instead. */
  export const inboundSchema = ContentHint$inboundSchema;
  /** @deprecated use `ContentHint$outboundSchema` instead. */
  export const outboundSchema = ContentHint$outboundSchema;
  /** @deprecated use `ContentHint$Outbound` instead. */
  export type Outbound = ContentHint$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType
  > =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const InternalContentHint$inboundSchema: z.ZodType<
  InternalContentHint,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  encryptedValue: z.string(),
});

/** @internal */
export type InternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const InternalContentHint$outboundSchema: z.ZodType<
  InternalContentHint$Outbound,
  z.ZodTypeDef,
  InternalContentHint
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  encryptedValue: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace InternalContentHint$ {
  /** @deprecated use `InternalContentHint$inboundSchema` instead. */
  export const inboundSchema = InternalContentHint$inboundSchema;
  /** @deprecated use `InternalContentHint$outboundSchema` instead. */
  export const outboundSchema = InternalContentHint$outboundSchema;
  /** @deprecated use `InternalContentHint$Outbound` instead. */
  export type Outbound = InternalContentHint$Outbound;
}

/** @internal */
export const Env$inboundSchema: z.ZodType<Env, z.ZodTypeDef, unknown> = z
  .object({
    target: z.union([
      z.array(UpdateProjectDataCacheTarget1$inboundSchema),
      UpdateProjectDataCacheTarget2$inboundSchema,
    ]).optional(),
    type: UpdateProjectDataCacheProjectsResponse200Type$inboundSchema,
    sunsetSecretId: z.string().optional(),
    id: z.string().optional(),
    key: z.string(),
    value: z.string(),
    configurationId: z.nullable(z.string()).optional(),
    createdAt: z.number().optional(),
    updatedAt: z.number().optional(),
    createdBy: z.nullable(z.string()).optional(),
    updatedBy: z.nullable(z.string()).optional(),
    gitBranch: z.string().optional(),
    edgeConfigId: z.nullable(z.string()).optional(),
    edgeConfigTokenId: z.nullable(z.string()).optional(),
    contentHint: z.nullable(
      z.union([
        z.lazy(() => ContentHint1$inboundSchema),
        z.lazy(() => ContentHint2$inboundSchema),
        z.lazy(() => ContentHint3$inboundSchema),
        z.lazy(() => ContentHint4$inboundSchema),
        z.lazy(() => ContentHint5$inboundSchema),
        z.lazy(() => ContentHint6$inboundSchema),
        z.lazy(() => ContentHint7$inboundSchema),
        z.lazy(() => ContentHint8$inboundSchema),
        z.lazy(() => ContentHint9$inboundSchema),
        z.lazy(() => ContentHint10$inboundSchema),
        z.lazy(() => UpdateProjectDataCacheContentHint11$inboundSchema),
        z.lazy(() => Twelve$inboundSchema),
        z.lazy(() => Thirteen$inboundSchema),
        z.lazy(() => Fifteen$inboundSchema),
        z.lazy(() => Fourteen$inboundSchema),
      ]),
    ).optional(),
    internalContentHint: z.nullable(
      z.lazy(() => InternalContentHint$inboundSchema),
    ).optional(),
    decrypted: z.boolean().optional(),
    comment: z.string().optional(),
    customEnvironmentIds: z.array(z.string()).optional(),
    vsmValue: z.string().optional(),
  });

/** @internal */
export type Env$Outbound = {
  target?: Array<string> | string | undefined;
  type: string;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | ContentHint1$Outbound
    | ContentHint2$Outbound
    | ContentHint3$Outbound
    | ContentHint4$Outbound
    | ContentHint5$Outbound
    | ContentHint6$Outbound
    | ContentHint7$Outbound
    | ContentHint8$Outbound
    | ContentHint9$Outbound
    | ContentHint10$Outbound
    | UpdateProjectDataCacheContentHint11$Outbound
    | Twelve$Outbound
    | Thirteen$Outbound
    | Fifteen$Outbound
    | Fourteen$Outbound
    | null
    | undefined;
  internalContentHint?: InternalContentHint$Outbound | null | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

/** @internal */
export const Env$outboundSchema: z.ZodType<Env$Outbound, z.ZodTypeDef, Env> = z
  .object({
    target: z.union([
      z.array(UpdateProjectDataCacheTarget1$outboundSchema),
      UpdateProjectDataCacheTarget2$outboundSchema,
    ]).optional(),
    type: UpdateProjectDataCacheProjectsResponse200Type$outboundSchema,
    sunsetSecretId: z.string().optional(),
    id: z.string().optional(),
    key: z.string(),
    value: z.string(),
    configurationId: z.nullable(z.string()).optional(),
    createdAt: z.number().optional(),
    updatedAt: z.number().optional(),
    createdBy: z.nullable(z.string()).optional(),
    updatedBy: z.nullable(z.string()).optional(),
    gitBranch: z.string().optional(),
    edgeConfigId: z.nullable(z.string()).optional(),
    edgeConfigTokenId: z.nullable(z.string()).optional(),
    contentHint: z.nullable(
      z.union([
        z.lazy(() => ContentHint1$outboundSchema),
        z.lazy(() => ContentHint2$outboundSchema),
        z.lazy(() => ContentHint3$outboundSchema),
        z.lazy(() => ContentHint4$outboundSchema),
        z.lazy(() => ContentHint5$outboundSchema),
        z.lazy(() => ContentHint6$outboundSchema),
        z.lazy(() => ContentHint7$outboundSchema),
        z.lazy(() => ContentHint8$outboundSchema),
        z.lazy(() => ContentHint9$outboundSchema),
        z.lazy(() => ContentHint10$outboundSchema),
        z.lazy(() => UpdateProjectDataCacheContentHint11$outboundSchema),
        z.lazy(() => Twelve$outboundSchema),
        z.lazy(() => Thirteen$outboundSchema),
        z.lazy(() => Fifteen$outboundSchema),
        z.lazy(() => Fourteen$outboundSchema),
      ]),
    ).optional(),
    internalContentHint: z.nullable(
      z.lazy(() => InternalContentHint$outboundSchema),
    ).optional(),
    decrypted: z.boolean().optional(),
    comment: z.string().optional(),
    customEnvironmentIds: z.array(z.string()).optional(),
    vsmValue: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Env$ {
  /** @deprecated use `Env$inboundSchema` instead. */
  export const inboundSchema = Env$inboundSchema;
  /** @deprecated use `Env$outboundSchema` instead. */
  export const outboundSchema = Env$outboundSchema;
  /** @deprecated use `Env$Outbound` instead. */
  export type Outbound = Env$Outbound;
}

/** @internal */
export const CustomEnvironments$inboundSchema: z.ZodType<
  CustomEnvironments,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CustomEnvironments$Outbound = {};

/** @internal */
export const CustomEnvironments$outboundSchema: z.ZodType<
  CustomEnvironments$Outbound,
  z.ZodTypeDef,
  CustomEnvironments
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CustomEnvironments$ {
  /** @deprecated use `CustomEnvironments$inboundSchema` instead. */
  export const inboundSchema = CustomEnvironments$inboundSchema;
  /** @deprecated use `CustomEnvironments$outboundSchema` instead. */
  export const outboundSchema = CustomEnvironments$outboundSchema;
  /** @deprecated use `CustomEnvironments$Outbound` instead. */
  export type Outbound = CustomEnvironments$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheFramework$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheFramework
> = z.nativeEnum(UpdateProjectDataCacheFramework);

/** @internal */
export const UpdateProjectDataCacheFramework$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheFramework
> = UpdateProjectDataCacheFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheFramework$ {
  /** @deprecated use `UpdateProjectDataCacheFramework$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheFramework$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheFramework$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheFramework$outboundSchema;
}

/** @internal */
export const IpBuckets$inboundSchema: z.ZodType<
  IpBuckets,
  z.ZodTypeDef,
  unknown
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/** @internal */
export type IpBuckets$Outbound = {
  bucket: string;
  supportUntil?: number | undefined;
};

/** @internal */
export const IpBuckets$outboundSchema: z.ZodType<
  IpBuckets$Outbound,
  z.ZodTypeDef,
  IpBuckets
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace IpBuckets$ {
  /** @deprecated use `IpBuckets$inboundSchema` instead. */
  export const inboundSchema = IpBuckets$inboundSchema;
  /** @deprecated use `IpBuckets$outboundSchema` instead. */
  export const outboundSchema = IpBuckets$outboundSchema;
  /** @deprecated use `IpBuckets$Outbound` instead. */
  export type Outbound = IpBuckets$Outbound;
}

/** @internal */
export const AliasAssigned$inboundSchema: z.ZodType<
  AliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type AliasAssigned$Outbound = number | boolean;

/** @internal */
export const AliasAssigned$outboundSchema: z.ZodType<
  AliasAssigned$Outbound,
  z.ZodTypeDef,
  AliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AliasAssigned$ {
  /** @deprecated use `AliasAssigned$inboundSchema` instead. */
  export const inboundSchema = AliasAssigned$inboundSchema;
  /** @deprecated use `AliasAssigned$outboundSchema` instead. */
  export const outboundSchema = AliasAssigned$outboundSchema;
  /** @deprecated use `AliasAssigned$Outbound` instead. */
  export type Outbound = AliasAssigned$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsAliasError$inboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheProjectsAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const UpdateProjectDataCacheProjectsAliasError$outboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsAliasError$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheProjectsAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsAliasError$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsAliasError$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsAliasError$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsAliasError$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsAliasError$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsAliasError$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheProjectsAliasError$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONType
  > = z.nativeEnum(
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONType,
  );

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONType
  > =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const BranchMatcher$inboundSchema: z.ZodType<
  BranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type BranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const BranchMatcher$outboundSchema: z.ZodType<
  BranchMatcher$Outbound,
  z.ZodTypeDef,
  BranchMatcher
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BranchMatcher$ {
  /** @deprecated use `BranchMatcher$inboundSchema` instead. */
  export const inboundSchema = BranchMatcher$inboundSchema;
  /** @deprecated use `BranchMatcher$outboundSchema` instead. */
  export const outboundSchema = BranchMatcher$outboundSchema;
  /** @deprecated use `BranchMatcher$Outbound` instead. */
  export type Outbound = BranchMatcher$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsBuilds$inboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type UpdateProjectDataCacheProjectsBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const UpdateProjectDataCacheProjectsBuilds$outboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsBuilds$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheProjectsBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsBuilds$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsBuilds$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsBuilds$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsBuilds$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsBuilds$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsBuilds$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheProjectsBuilds$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsChecksConclusion$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsChecksConclusion> = z
    .nativeEnum(UpdateProjectDataCacheProjectsChecksConclusion);

/** @internal */
export const UpdateProjectDataCacheProjectsChecksConclusion$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsChecksConclusion> =
    UpdateProjectDataCacheProjectsChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsChecksConclusion$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsChecksConclusion$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsChecksConclusion$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsChecksConclusion$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsChecksConclusion$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheProjectsChecksState$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsChecksState> = z
    .nativeEnum(UpdateProjectDataCacheProjectsChecksState);

/** @internal */
export const UpdateProjectDataCacheProjectsChecksState$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsChecksState> =
    UpdateProjectDataCacheProjectsChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsChecksState$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsChecksState$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsChecksState$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsChecksState$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsChecksState$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheProjectsCreator$inboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheProjectsCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const UpdateProjectDataCacheProjectsCreator$outboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsCreator$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheProjectsCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsCreator$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsCreator$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsCreator$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsCreator$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsCreator$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsCreator$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheProjectsCreator$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsOidcTokenClaims$inboundSchema:
  z.ZodType<
    UpdateProjectDataCacheProjectsOidcTokenClaims,
    z.ZodTypeDef,
    unknown
  > = z.object({
    iss: z.string(),
    sub: z.string(),
    scope: z.string(),
    aud: z.string(),
    owner: z.string(),
    owner_id: z.string(),
    project: z.string(),
    project_id: z.string(),
    environment: z.string(),
  }).transform((v) => {
    return remap$(v, {
      "owner_id": "ownerId",
      "project_id": "projectId",
    });
  });

/** @internal */
export type UpdateProjectDataCacheProjectsOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const UpdateProjectDataCacheProjectsOidcTokenClaims$outboundSchema:
  z.ZodType<
    UpdateProjectDataCacheProjectsOidcTokenClaims$Outbound,
    z.ZodTypeDef,
    UpdateProjectDataCacheProjectsOidcTokenClaims
  > = z.object({
    iss: z.string(),
    sub: z.string(),
    scope: z.string(),
    aud: z.string(),
    owner: z.string(),
    ownerId: z.string(),
    project: z.string(),
    projectId: z.string(),
    environment: z.string(),
  }).transform((v) => {
    return remap$(v, {
      ownerId: "owner_id",
      projectId: "project_id",
    });
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsOidcTokenClaims$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsOidcTokenClaims$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsOidcTokenClaims$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsOidcTokenClaims$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheProjectsOidcTokenClaims$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsPlan$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheProjectsPlan
> = z.nativeEnum(UpdateProjectDataCacheProjectsPlan);

/** @internal */
export const UpdateProjectDataCacheProjectsPlan$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheProjectsPlan
> = UpdateProjectDataCacheProjectsPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsPlan$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsPlan$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheProjectsPlan$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsPlan$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsPlan$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheProjectsReadyState$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsReadyState> = z
    .nativeEnum(UpdateProjectDataCacheProjectsReadyState);

/** @internal */
export const UpdateProjectDataCacheProjectsReadyState$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsReadyState> =
    UpdateProjectDataCacheProjectsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsReadyState$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsReadyState$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsReadyState$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsReadyState$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsReadyState$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheProjectsReadySubstate$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsReadySubstate> = z
    .nativeEnum(UpdateProjectDataCacheProjectsReadySubstate);

/** @internal */
export const UpdateProjectDataCacheProjectsReadySubstate$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsReadySubstate> =
    UpdateProjectDataCacheProjectsReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsReadySubstate$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsReadySubstate$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsReadySubstate$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsReadySubstate$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsReadySubstate$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheType
> = z.nativeEnum(UpdateProjectDataCacheType);

/** @internal */
export const UpdateProjectDataCacheType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheType
> = UpdateProjectDataCacheType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheType$ {
  /** @deprecated use `UpdateProjectDataCacheType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheType$outboundSchema;
}

/** @internal */
export const LatestDeployments$inboundSchema: z.ZodType<
  LatestDeployments,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => UpdateProjectDataCacheProjectsAliasError$inboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => BranchMatcher$inboundSchema).optional(),
  buildingAt: z.number().optional(),
  builds: z.array(
    z.lazy(() => UpdateProjectDataCacheProjectsBuilds$inboundSchema),
  ).optional(),
  checksConclusion: UpdateProjectDataCacheProjectsChecksConclusion$inboundSchema
    .optional(),
  checksState: UpdateProjectDataCacheProjectsChecksState$inboundSchema
    .optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(
    z.lazy(() => UpdateProjectDataCacheProjectsCreator$inboundSchema),
  ),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    UpdateProjectDataCacheProjectsOidcTokenClaims$inboundSchema
  ).optional(),
  plan: UpdateProjectDataCacheProjectsPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectDataCacheProjectsReadyState$inboundSchema,
  readySubstate: UpdateProjectDataCacheProjectsReadySubstate$inboundSchema
    .optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectDataCacheType$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type LatestDeployments$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?:
    | UpdateProjectDataCacheProjectsAliasError$Outbound
    | null
    | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: BranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectDataCacheProjectsBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectDataCacheProjectsCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?:
    | UpdateProjectDataCacheProjectsOidcTokenClaims$Outbound
    | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const LatestDeployments$outboundSchema: z.ZodType<
  LatestDeployments$Outbound,
  z.ZodTypeDef,
  LatestDeployments
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => UpdateProjectDataCacheProjectsAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => BranchMatcher$outboundSchema).optional(),
  buildingAt: z.number().optional(),
  builds: z.array(
    z.lazy(() => UpdateProjectDataCacheProjectsBuilds$outboundSchema),
  ).optional(),
  checksConclusion:
    UpdateProjectDataCacheProjectsChecksConclusion$outboundSchema.optional(),
  checksState: UpdateProjectDataCacheProjectsChecksState$outboundSchema
    .optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(
    z.lazy(() => UpdateProjectDataCacheProjectsCreator$outboundSchema),
  ),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    UpdateProjectDataCacheProjectsOidcTokenClaims$outboundSchema
  ).optional(),
  plan: UpdateProjectDataCacheProjectsPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectDataCacheProjectsReadyState$outboundSchema,
  readySubstate: UpdateProjectDataCacheProjectsReadySubstate$outboundSchema
    .optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectDataCacheType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace LatestDeployments$ {
  /** @deprecated use `LatestDeployments$inboundSchema` instead. */
  export const inboundSchema = LatestDeployments$inboundSchema;
  /** @deprecated use `LatestDeployments$outboundSchema` instead. */
  export const outboundSchema = LatestDeployments$outboundSchema;
  /** @deprecated use `LatestDeployments$Outbound` instead. */
  export type Outbound = LatestDeployments$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheLinkProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheLinkProjectsType> = z.nativeEnum(
    UpdateProjectDataCacheLinkProjectsType,
  );

/** @internal */
export const UpdateProjectDataCacheLinkProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheLinkProjectsType> =
    UpdateProjectDataCacheLinkProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheLinkProjectsType$ {
  /** @deprecated use `UpdateProjectDataCacheLinkProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheLinkProjectsType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheLinkProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheLinkProjectsType$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheLinkDeployHooks$inboundSchema: z.ZodType<
  UpdateProjectDataCacheLinkDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheLinkDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const UpdateProjectDataCacheLinkDeployHooks$outboundSchema: z.ZodType<
  UpdateProjectDataCacheLinkDeployHooks$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheLinkDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheLinkDeployHooks$ {
  /** @deprecated use `UpdateProjectDataCacheLinkDeployHooks$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheLinkDeployHooks$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheLinkDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheLinkDeployHooks$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheLinkDeployHooks$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheLinkDeployHooks$Outbound;
}

/** @internal */
export const Link3$inboundSchema: z.ZodType<Link3, z.ZodTypeDef, unknown> = z
  .object({
    name: z.string().optional(),
    slug: z.string().optional(),
    owner: z.string().optional(),
    type: UpdateProjectDataCacheLinkProjectsType$inboundSchema.optional(),
    uuid: z.string().optional(),
    workspaceUuid: z.string().optional(),
    createdAt: z.number().optional(),
    deployHooks: z.array(
      z.lazy(() => UpdateProjectDataCacheLinkDeployHooks$inboundSchema),
    ),
    gitCredentialId: z.string().optional(),
    updatedAt: z.number().optional(),
    sourceless: z.boolean().optional(),
    productionBranch: z.string().optional(),
  });

/** @internal */
export type Link3$Outbound = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: string | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectDataCacheLinkDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const Link3$outboundSchema: z.ZodType<
  Link3$Outbound,
  z.ZodTypeDef,
  Link3
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: UpdateProjectDataCacheLinkProjectsType$outboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectDataCacheLinkDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Link3$ {
  /** @deprecated use `Link3$inboundSchema` instead. */
  export const inboundSchema = Link3$inboundSchema;
  /** @deprecated use `Link3$outboundSchema` instead. */
  export const outboundSchema = Link3$outboundSchema;
  /** @deprecated use `Link3$Outbound` instead. */
  export type Outbound = Link3$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheLinkType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheLinkType
> = z.nativeEnum(UpdateProjectDataCacheLinkType);

/** @internal */
export const UpdateProjectDataCacheLinkType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheLinkType
> = UpdateProjectDataCacheLinkType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheLinkType$ {
  /** @deprecated use `UpdateProjectDataCacheLinkType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheLinkType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheLinkType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheLinkType$outboundSchema;
}

/** @internal */
export const LinkDeployHooks$inboundSchema: z.ZodType<
  LinkDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type LinkDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const LinkDeployHooks$outboundSchema: z.ZodType<
  LinkDeployHooks$Outbound,
  z.ZodTypeDef,
  LinkDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace LinkDeployHooks$ {
  /** @deprecated use `LinkDeployHooks$inboundSchema` instead. */
  export const inboundSchema = LinkDeployHooks$inboundSchema;
  /** @deprecated use `LinkDeployHooks$outboundSchema` instead. */
  export const outboundSchema = LinkDeployHooks$outboundSchema;
  /** @deprecated use `LinkDeployHooks$Outbound` instead. */
  export type Outbound = LinkDeployHooks$Outbound;
}

/** @internal */
export const Link2$inboundSchema: z.ZodType<Link2, z.ZodTypeDef, unknown> = z
  .object({
    projectId: z.string().optional(),
    projectName: z.string().optional(),
    projectNameWithNamespace: z.string().optional(),
    projectNamespace: z.string().optional(),
    projectOwnerId: z.number().optional(),
    projectUrl: z.string().optional(),
    type: UpdateProjectDataCacheLinkType$inboundSchema.optional(),
    createdAt: z.number().optional(),
    deployHooks: z.array(z.lazy(() => LinkDeployHooks$inboundSchema)),
    gitCredentialId: z.string().optional(),
    updatedAt: z.number().optional(),
    sourceless: z.boolean().optional(),
    productionBranch: z.string().optional(),
  });

/** @internal */
export type Link2$Outbound = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<LinkDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const Link2$outboundSchema: z.ZodType<
  Link2$Outbound,
  z.ZodTypeDef,
  Link2
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: UpdateProjectDataCacheLinkType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(z.lazy(() => LinkDeployHooks$outboundSchema)),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Link2$ {
  /** @deprecated use `Link2$inboundSchema` instead. */
  export const inboundSchema = Link2$inboundSchema;
  /** @deprecated use `Link2$outboundSchema` instead. */
  export const outboundSchema = Link2$outboundSchema;
  /** @deprecated use `Link2$Outbound` instead. */
  export type Outbound = Link2$Outbound;
}

/** @internal */
export const LinkType$inboundSchema: z.ZodNativeEnum<typeof LinkType> = z
  .nativeEnum(LinkType);

/** @internal */
export const LinkType$outboundSchema: z.ZodNativeEnum<typeof LinkType> =
  LinkType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace LinkType$ {
  /** @deprecated use `LinkType$inboundSchema` instead. */
  export const inboundSchema = LinkType$inboundSchema;
  /** @deprecated use `LinkType$outboundSchema` instead. */
  export const outboundSchema = LinkType$outboundSchema;
}

/** @internal */
export const DeployHooks$inboundSchema: z.ZodType<
  DeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type DeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const DeployHooks$outboundSchema: z.ZodType<
  DeployHooks$Outbound,
  z.ZodTypeDef,
  DeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeployHooks$ {
  /** @deprecated use `DeployHooks$inboundSchema` instead. */
  export const inboundSchema = DeployHooks$inboundSchema;
  /** @deprecated use `DeployHooks$outboundSchema` instead. */
  export const outboundSchema = DeployHooks$outboundSchema;
  /** @deprecated use `DeployHooks$Outbound` instead. */
  export type Outbound = DeployHooks$Outbound;
}

/** @internal */
export const Link1$inboundSchema: z.ZodType<Link1, z.ZodTypeDef, unknown> = z
  .object({
    org: z.string().optional(),
    repoOwnerId: z.number().optional(),
    repo: z.string().optional(),
    repoId: z.number().optional(),
    type: LinkType$inboundSchema.optional(),
    createdAt: z.number().optional(),
    deployHooks: z.array(z.lazy(() => DeployHooks$inboundSchema)),
    gitCredentialId: z.string().optional(),
    updatedAt: z.number().optional(),
    sourceless: z.boolean().optional(),
    productionBranch: z.string().optional(),
  });

/** @internal */
export type Link1$Outbound = {
  org?: string | undefined;
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<DeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const Link1$outboundSchema: z.ZodType<
  Link1$Outbound,
  z.ZodTypeDef,
  Link1
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: LinkType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(z.lazy(() => DeployHooks$outboundSchema)),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Link1$ {
  /** @deprecated use `Link1$inboundSchema` instead. */
  export const inboundSchema = Link1$inboundSchema;
  /** @deprecated use `Link1$outboundSchema` instead. */
  export const outboundSchema = Link1$outboundSchema;
  /** @deprecated use `Link1$Outbound` instead. */
  export type Outbound = Link1$Outbound;
}

/** @internal */
export const Link$inboundSchema: z.ZodType<Link, z.ZodTypeDef, unknown> = z
  .union([
    z.lazy(() => Link1$inboundSchema),
    z.lazy(() => Link3$inboundSchema),
    z.lazy(() => Link2$inboundSchema),
  ]);

/** @internal */
export type Link$Outbound = Link1$Outbound | Link3$Outbound | Link2$Outbound;

/** @internal */
export const Link$outboundSchema: z.ZodType<Link$Outbound, z.ZodTypeDef, Link> =
  z.union([
    z.lazy(() => Link1$outboundSchema),
    z.lazy(() => Link3$outboundSchema),
    z.lazy(() => Link2$outboundSchema),
  ]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Link$ {
  /** @deprecated use `Link$inboundSchema` instead. */
  export const inboundSchema = Link$inboundSchema;
  /** @deprecated use `Link$outboundSchema` instead. */
  export const outboundSchema = Link$outboundSchema;
  /** @deprecated use `Link$Outbound` instead. */
  export type Outbound = Link$Outbound;
}

/** @internal */
export const Group$inboundSchema: z.ZodType<Group, z.ZodTypeDef, unknown> = z
  .object({
    id: z.string(),
    slug: z.string(),
  });

/** @internal */
export type Group$Outbound = {
  id: string;
  slug: string;
};

/** @internal */
export const Group$outboundSchema: z.ZodType<
  Group$Outbound,
  z.ZodTypeDef,
  Group
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Group$ {
  /** @deprecated use `Group$inboundSchema` instead. */
  export const inboundSchema = Group$inboundSchema;
  /** @deprecated use `Group$outboundSchema` instead. */
  export const outboundSchema = Group$outboundSchema;
  /** @deprecated use `Group$Outbound` instead. */
  export type Outbound = Group$Outbound;
}

/** @internal */
export const Microfrontends$inboundSchema: z.ZodType<
  Microfrontends,
  z.ZodTypeDef,
  unknown
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => Group$inboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/** @internal */
export type Microfrontends$Outbound = {
  updatedAt: number;
  group: Group$Outbound;
  enabled: boolean;
  isDefaultApp?: boolean | undefined;
  defaultRoute?: string | undefined;
};

/** @internal */
export const Microfrontends$outboundSchema: z.ZodType<
  Microfrontends$Outbound,
  z.ZodTypeDef,
  Microfrontends
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => Group$outboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Microfrontends$ {
  /** @deprecated use `Microfrontends$inboundSchema` instead. */
  export const inboundSchema = Microfrontends$inboundSchema;
  /** @deprecated use `Microfrontends$outboundSchema` instead. */
  export const outboundSchema = Microfrontends$outboundSchema;
  /** @deprecated use `Microfrontends$Outbound` instead. */
  export type Outbound = Microfrontends$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheNodeVersion$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheNodeVersion
> = z.nativeEnum(UpdateProjectDataCacheNodeVersion);

/** @internal */
export const UpdateProjectDataCacheNodeVersion$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheNodeVersion
> = UpdateProjectDataCacheNodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheNodeVersion$ {
  /** @deprecated use `UpdateProjectDataCacheNodeVersion$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheNodeVersion$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheNodeVersion$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheNodeVersion$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCachePaths$inboundSchema: z.ZodType<
  UpdateProjectDataCachePaths,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
});

/** @internal */
export type UpdateProjectDataCachePaths$Outbound = {
  value: string;
};

/** @internal */
export const UpdateProjectDataCachePaths$outboundSchema: z.ZodType<
  UpdateProjectDataCachePaths$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCachePaths
> = z.object({
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCachePaths$ {
  /** @deprecated use `UpdateProjectDataCachePaths$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCachePaths$inboundSchema;
  /** @deprecated use `UpdateProjectDataCachePaths$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCachePaths$outboundSchema;
  /** @deprecated use `UpdateProjectDataCachePaths$Outbound` instead. */
  export type Outbound = UpdateProjectDataCachePaths$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheOptionsAllowlist$inboundSchema: z.ZodType<
  UpdateProjectDataCacheOptionsAllowlist,
  z.ZodTypeDef,
  unknown
> = z.object({
  paths: z.array(z.lazy(() => UpdateProjectDataCachePaths$inboundSchema)),
});

/** @internal */
export type UpdateProjectDataCacheOptionsAllowlist$Outbound = {
  paths: Array<UpdateProjectDataCachePaths$Outbound>;
};

/** @internal */
export const UpdateProjectDataCacheOptionsAllowlist$outboundSchema: z.ZodType<
  UpdateProjectDataCacheOptionsAllowlist$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheOptionsAllowlist
> = z.object({
  paths: z.array(z.lazy(() => UpdateProjectDataCachePaths$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheOptionsAllowlist$ {
  /** @deprecated use `UpdateProjectDataCacheOptionsAllowlist$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheOptionsAllowlist$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheOptionsAllowlist$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheOptionsAllowlist$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheOptionsAllowlist$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheOptionsAllowlist$Outbound;
}

/** @internal */
export const UpdateProjectDataCachePasswordProtection$inboundSchema: z.ZodType<
  UpdateProjectDataCachePasswordProtection,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type UpdateProjectDataCachePasswordProtection$Outbound = {};

/** @internal */
export const UpdateProjectDataCachePasswordProtection$outboundSchema: z.ZodType<
  UpdateProjectDataCachePasswordProtection$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCachePasswordProtection
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCachePasswordProtection$ {
  /** @deprecated use `UpdateProjectDataCachePasswordProtection$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCachePasswordProtection$inboundSchema;
  /** @deprecated use `UpdateProjectDataCachePasswordProtection$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCachePasswordProtection$outboundSchema;
  /** @deprecated use `UpdateProjectDataCachePasswordProtection$Outbound` instead. */
  export type Outbound = UpdateProjectDataCachePasswordProtection$Outbound;
}

/** @internal */
export const FunctionDefaultMemoryType$inboundSchema: z.ZodNativeEnum<
  typeof FunctionDefaultMemoryType
> = z.nativeEnum(FunctionDefaultMemoryType);

/** @internal */
export const FunctionDefaultMemoryType$outboundSchema: z.ZodNativeEnum<
  typeof FunctionDefaultMemoryType
> = FunctionDefaultMemoryType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FunctionDefaultMemoryType$ {
  /** @deprecated use `FunctionDefaultMemoryType$inboundSchema` instead. */
  export const inboundSchema = FunctionDefaultMemoryType$inboundSchema;
  /** @deprecated use `FunctionDefaultMemoryType$outboundSchema` instead. */
  export const outboundSchema = FunctionDefaultMemoryType$outboundSchema;
}

/** @internal */
export const ResourceConfig$inboundSchema: z.ZodType<
  ResourceConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType: FunctionDefaultMemoryType$inboundSchema.optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/** @internal */
export type ResourceConfig$Outbound = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?: string | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

/** @internal */
export const ResourceConfig$outboundSchema: z.ZodType<
  ResourceConfig$Outbound,
  z.ZodTypeDef,
  ResourceConfig
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType: FunctionDefaultMemoryType$outboundSchema
    .optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResourceConfig$ {
  /** @deprecated use `ResourceConfig$inboundSchema` instead. */
  export const inboundSchema = ResourceConfig$inboundSchema;
  /** @deprecated use `ResourceConfig$outboundSchema` instead. */
  export const outboundSchema = ResourceConfig$outboundSchema;
  /** @deprecated use `ResourceConfig$Outbound` instead. */
  export type Outbound = ResourceConfig$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheDeploymentType> = z.nativeEnum(
    UpdateProjectDataCacheDeploymentType,
  );

/** @internal */
export const UpdateProjectDataCacheDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheDeploymentType> =
    UpdateProjectDataCacheDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheDeploymentType$ {
  /** @deprecated use `UpdateProjectDataCacheDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheDeploymentType$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheSsoProtection$inboundSchema: z.ZodType<
  UpdateProjectDataCacheSsoProtection,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectDataCacheDeploymentType$inboundSchema,
});

/** @internal */
export type UpdateProjectDataCacheSsoProtection$Outbound = {
  deploymentType: string;
};

/** @internal */
export const UpdateProjectDataCacheSsoProtection$outboundSchema: z.ZodType<
  UpdateProjectDataCacheSsoProtection$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheSsoProtection
> = z.object({
  deploymentType: UpdateProjectDataCacheDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheSsoProtection$ {
  /** @deprecated use `UpdateProjectDataCacheSsoProtection$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheSsoProtection$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheSsoProtection$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheSsoProtection$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheSsoProtection$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheSsoProtection$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheAliasAssigned$inboundSchema: z.ZodType<
  UpdateProjectDataCacheAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type UpdateProjectDataCacheAliasAssigned$Outbound = number | boolean;

/** @internal */
export const UpdateProjectDataCacheAliasAssigned$outboundSchema: z.ZodType<
  UpdateProjectDataCacheAliasAssigned$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheAliasAssigned$ {
  /** @deprecated use `UpdateProjectDataCacheAliasAssigned$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheAliasAssigned$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheAliasAssigned$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheAliasAssigned$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheAliasAssigned$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheAliasAssigned$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheAliasError$inboundSchema: z.ZodType<
  UpdateProjectDataCacheAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const UpdateProjectDataCacheAliasError$outboundSchema: z.ZodType<
  UpdateProjectDataCacheAliasError$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheAliasError$ {
  /** @deprecated use `UpdateProjectDataCacheAliasError$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheAliasError$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheAliasError$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheAliasError$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheAliasError$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheAliasError$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType
  > = z.nativeEnum(
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType,
  );

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType
  > =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheBranchMatcher$inboundSchema: z.ZodType<
  UpdateProjectDataCacheBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const UpdateProjectDataCacheBranchMatcher$outboundSchema: z.ZodType<
  UpdateProjectDataCacheBranchMatcher$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheBranchMatcher
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheBranchMatcher$ {
  /** @deprecated use `UpdateProjectDataCacheBranchMatcher$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheBranchMatcher$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheBranchMatcher$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheBranchMatcher$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheBranchMatcher$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheBranchMatcher$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheBuilds$inboundSchema: z.ZodType<
  UpdateProjectDataCacheBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type UpdateProjectDataCacheBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const UpdateProjectDataCacheBuilds$outboundSchema: z.ZodType<
  UpdateProjectDataCacheBuilds$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheBuilds$ {
  /** @deprecated use `UpdateProjectDataCacheBuilds$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheBuilds$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheBuilds$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheBuilds$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheBuilds$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheBuilds$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheChecksConclusion$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheChecksConclusion> = z.nativeEnum(
    UpdateProjectDataCacheChecksConclusion,
  );

/** @internal */
export const UpdateProjectDataCacheChecksConclusion$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheChecksConclusion> =
    UpdateProjectDataCacheChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheChecksConclusion$ {
  /** @deprecated use `UpdateProjectDataCacheChecksConclusion$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheChecksConclusion$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheChecksConclusion$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheChecksConclusion$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheChecksState$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheChecksState
> = z.nativeEnum(UpdateProjectDataCacheChecksState);

/** @internal */
export const UpdateProjectDataCacheChecksState$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheChecksState
> = UpdateProjectDataCacheChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheChecksState$ {
  /** @deprecated use `UpdateProjectDataCacheChecksState$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheChecksState$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheChecksState$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheChecksState$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheCreator$inboundSchema: z.ZodType<
  UpdateProjectDataCacheCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type UpdateProjectDataCacheCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const UpdateProjectDataCacheCreator$outboundSchema: z.ZodType<
  UpdateProjectDataCacheCreator$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheCreator$ {
  /** @deprecated use `UpdateProjectDataCacheCreator$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheCreator$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheCreator$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheCreator$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheCreator$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheCreator$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheOidcTokenClaims$inboundSchema: z.ZodType<
  UpdateProjectDataCacheOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type UpdateProjectDataCacheOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const UpdateProjectDataCacheOidcTokenClaims$outboundSchema: z.ZodType<
  UpdateProjectDataCacheOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheOidcTokenClaims$ {
  /** @deprecated use `UpdateProjectDataCacheOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheOidcTokenClaims$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheOidcTokenClaims$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheOidcTokenClaims$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheOidcTokenClaims$Outbound;
}

/** @internal */
export const UpdateProjectDataCachePlan$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCachePlan
> = z.nativeEnum(UpdateProjectDataCachePlan);

/** @internal */
export const UpdateProjectDataCachePlan$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCachePlan
> = UpdateProjectDataCachePlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCachePlan$ {
  /** @deprecated use `UpdateProjectDataCachePlan$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCachePlan$inboundSchema;
  /** @deprecated use `UpdateProjectDataCachePlan$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCachePlan$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheReadyState$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheReadyState
> = z.nativeEnum(UpdateProjectDataCacheReadyState);

/** @internal */
export const UpdateProjectDataCacheReadyState$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheReadyState
> = UpdateProjectDataCacheReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheReadyState$ {
  /** @deprecated use `UpdateProjectDataCacheReadyState$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheReadyState$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheReadyState$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheReadyState$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheReadySubstate
> = z.nativeEnum(UpdateProjectDataCacheReadySubstate);

/** @internal */
export const UpdateProjectDataCacheReadySubstate$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheReadySubstate> =
    UpdateProjectDataCacheReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheReadySubstate$ {
  /** @deprecated use `UpdateProjectDataCacheReadySubstate$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheReadySubstate$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheReadySubstate$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheReadySubstate$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheProjectsType
> = z.nativeEnum(UpdateProjectDataCacheProjectsType);

/** @internal */
export const UpdateProjectDataCacheProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheProjectsType
> = UpdateProjectDataCacheProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheProjectsType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsType$outboundSchema;
}

/** @internal */
export const Targets$inboundSchema: z.ZodType<Targets, z.ZodTypeDef, unknown> =
  z.object({
    id: z.string(),
    alias: z.array(z.string()).optional(),
    aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
    aliasError: z.nullable(
      z.lazy(() => UpdateProjectDataCacheAliasError$inboundSchema),
    ).optional(),
    aliasFinal: z.nullable(z.string()).optional(),
    automaticAliases: z.array(z.string()).optional(),
    branchMatcher: z.lazy(() =>
      UpdateProjectDataCacheBranchMatcher$inboundSchema
    ).optional(),
    buildingAt: z.number().optional(),
    builds: z.array(z.lazy(() => UpdateProjectDataCacheBuilds$inboundSchema))
      .optional(),
    checksConclusion: UpdateProjectDataCacheChecksConclusion$inboundSchema
      .optional(),
    checksState: UpdateProjectDataCacheChecksState$inboundSchema.optional(),
    connectBuildsEnabled: z.boolean().optional(),
    connectConfigurationId: z.string().optional(),
    createdAt: z.number(),
    createdIn: z.string(),
    creator: z.nullable(
      z.lazy(() => UpdateProjectDataCacheCreator$inboundSchema),
    ),
    deletedAt: z.number().optional(),
    deploymentHostname: z.string(),
    forced: z.boolean().optional(),
    name: z.string(),
    meta: z.record(z.string()).optional(),
    monorepoManager: z.nullable(z.string()).optional(),
    oidcTokenClaims: z.lazy(() =>
      UpdateProjectDataCacheOidcTokenClaims$inboundSchema
    ).optional(),
    plan: UpdateProjectDataCachePlan$inboundSchema,
    previewCommentsEnabled: z.boolean().optional(),
    private: z.boolean(),
    readyAt: z.number().optional(),
    readyState: UpdateProjectDataCacheReadyState$inboundSchema,
    readySubstate: UpdateProjectDataCacheReadySubstate$inboundSchema.optional(),
    requestedAt: z.number().optional(),
    target: z.nullable(z.string()).optional(),
    teamId: z.nullable(z.string()).optional(),
    type: UpdateProjectDataCacheProjectsType$inboundSchema,
    url: z.string(),
    userId: z.string(),
    withCache: z.boolean().optional(),
  });

/** @internal */
export type Targets$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectDataCacheAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: UpdateProjectDataCacheBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectDataCacheBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectDataCacheCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectDataCacheOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const Targets$outboundSchema: z.ZodType<
  Targets$Outbound,
  z.ZodTypeDef,
  Targets
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => UpdateProjectDataCacheAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() =>
    UpdateProjectDataCacheBranchMatcher$outboundSchema
  ).optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => UpdateProjectDataCacheBuilds$outboundSchema))
    .optional(),
  checksConclusion: UpdateProjectDataCacheChecksConclusion$outboundSchema
    .optional(),
  checksState: UpdateProjectDataCacheChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(
    z.lazy(() => UpdateProjectDataCacheCreator$outboundSchema),
  ),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    UpdateProjectDataCacheOidcTokenClaims$outboundSchema
  ).optional(),
  plan: UpdateProjectDataCachePlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectDataCacheReadyState$outboundSchema,
  readySubstate: UpdateProjectDataCacheReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectDataCacheProjectsType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Targets$ {
  /** @deprecated use `Targets$inboundSchema` instead. */
  export const inboundSchema = Targets$inboundSchema;
  /** @deprecated use `Targets$outboundSchema` instead. */
  export const outboundSchema = Targets$outboundSchema;
  /** @deprecated use `Targets$Outbound` instead. */
  export type Outbound = Targets$Outbound;
}

/** @internal */
export const Permissions$inboundSchema: z.ZodType<
  Permissions,
  z.ZodTypeDef,
  unknown
> = z.object({
  accessGroup: z.array(ACLAction$inboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$inboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  auditLog: z.array(ACLAction$inboundSchema).optional(),
  billingAddress: z.array(ACLAction$inboundSchema).optional(),
  billingInformation: z.array(ACLAction$inboundSchema).optional(),
  billingInvoice: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$inboundSchema).optional(),
  billingPlan: z.array(ACLAction$inboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$inboundSchema).optional(),
  billingTaxId: z.array(ACLAction$inboundSchema).optional(),
  blob: z.array(ACLAction$inboundSchema).optional(),
  budget: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$inboundSchema).optional(),
  codeChecks: z.array(ACLAction$inboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$inboundSchema).optional(),
  connect: z.array(ACLAction$inboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$inboundSchema).optional(),
  domain: z.array(ACLAction$inboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$inboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$inboundSchema).optional(),
  domainCertificate: z.array(ACLAction$inboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  domainMove: z.array(ACLAction$inboundSchema).optional(),
  domainPurchase: z.array(ACLAction$inboundSchema).optional(),
  domainRecord: z.array(ACLAction$inboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$inboundSchema).optional(),
  event: z.array(ACLAction$inboundSchema).optional(),
  ownEvent: z.array(ACLAction$inboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$inboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$inboundSchema).optional(),
  gitRepository: z.array(ACLAction$inboundSchema).optional(),
  ipBlocking: z.array(ACLAction$inboundSchema).optional(),
  integration: z.array(ACLAction$inboundSchema).optional(),
  integrationAccount: z.array(ACLAction$inboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationProjects: z.array(ACLAction$inboundSchema).optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$inboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$inboundSchema).optional(),
  integrationResource: z.array(ACLAction$inboundSchema).optional(),
  integrationEvent: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$inboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$inboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$inboundSchema).optional(),
  jobGlobal: z.array(ACLAction$inboundSchema).optional(),
  logDrain: z.array(ACLAction$inboundSchema).optional(),
  Monitoring: z.array(ACLAction$inboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$inboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$inboundSchema).optional(),
  monitoringChart: z.array(ACLAction$inboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$inboundSchema).optional(),
  NotificationMonitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$inboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$inboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$inboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$inboundSchema).optional(),
  paymentMethod: z.array(ACLAction$inboundSchema).optional(),
  permissions: z.array(ACLAction$inboundSchema).optional(),
  postgres: z.array(ACLAction$inboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$inboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  space: z.array(ACLAction$inboundSchema).optional(),
  spaceRun: z.array(ACLAction$inboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$inboundSchema).optional(),
  rateLimit: z.array(ACLAction$inboundSchema).optional(),
  redis: z.array(ACLAction$inboundSchema).optional(),
  repository: z.array(ACLAction$inboundSchema).optional(),
  remoteCaching: z.array(ACLAction$inboundSchema).optional(),
  samlConfig: z.array(ACLAction$inboundSchema).optional(),
  secret: z.array(ACLAction$inboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$inboundSchema).optional(),
  storeTransfer: z.array(ACLAction$inboundSchema).optional(),
  supportCase: z.array(ACLAction$inboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$inboundSchema).optional(),
  team: z.array(ACLAction$inboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$inboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$inboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$inboundSchema).optional(),
  teamInvite: z.array(ACLAction$inboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$inboundSchema).optional(),
  teamJoin: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$inboundSchema).optional(),
  token: z.array(ACLAction$inboundSchema).optional(),
  usage: z.array(ACLAction$inboundSchema).optional(),
  usageCycle: z.array(ACLAction$inboundSchema).optional(),
  user: z.array(ACLAction$inboundSchema).optional(),
  userConnection: z.array(ACLAction$inboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$inboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$inboundSchema).optional(),
  webAuthn: z.array(ACLAction$inboundSchema).optional(),
  edgeConfig: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$inboundSchema).optional(),
  webhook: z.array(ACLAction$inboundSchema).optional(),
  "webhook-event": z.array(ACLAction$inboundSchema).optional(),
  endpointVerification: z.array(ACLAction$inboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$inboundSchema).optional(),
  oauth2Application: z.array(ACLAction$inboundSchema).optional(),
  aliasProject: z.array(ACLAction$inboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$inboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$inboundSchema).optional(),
  deployment: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$inboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$inboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$inboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$inboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$inboundSchema).optional(),
  environments: z.array(ACLAction$inboundSchema).optional(),
  logs: z.array(ACLAction$inboundSchema).optional(),
  logsPreset: z.array(ACLAction$inboundSchema).optional(),
  passwordProtection: z.array(ACLAction$inboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$inboundSchema).optional(),
  job: z.array(ACLAction$inboundSchema).optional(),
  project: z.array(ACLAction$inboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$inboundSchema).optional(),
  projectDomain: z.array(ACLAction$inboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$inboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$inboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$inboundSchema).optional(),
  projectId: z.array(ACLAction$inboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  projectLink: z.array(ACLAction$inboundSchema).optional(),
  projectMember: z.array(ACLAction$inboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$inboundSchema).optional(),
  projectPermissions: z.array(ACLAction$inboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$inboundSchema).optional(),
  projectTransfer: z.array(ACLAction$inboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$inboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  projectUsage: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$inboundSchema).optional(),
  projectTier: z.array(ACLAction$inboundSchema).optional(),
  seawallConfig: z.array(ACLAction$inboundSchema).optional(),
  skewProtection: z.array(ACLAction$inboundSchema).optional(),
  analytics: z.array(ACLAction$inboundSchema).optional(),
  trustedIps: z.array(ACLAction$inboundSchema).optional(),
  webAnalytics: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$inboundSchema).optional(),
  sonar: z.array(ACLAction$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "Monitoring": "monitoring",
    "NotificationMonitoringAlert": "notificationMonitoringAlert",
    "webhook-event": "webhookEvent",
  });
});

/** @internal */
export type Permissions$Outbound = {
  accessGroup?: Array<string> | undefined;
  aliasGlobal?: Array<string> | undefined;
  analyticsSampling?: Array<string> | undefined;
  analyticsUsage?: Array<string> | undefined;
  auditLog?: Array<string> | undefined;
  billingAddress?: Array<string> | undefined;
  billingInformation?: Array<string> | undefined;
  billingInvoice?: Array<string> | undefined;
  billingInvoiceEmailRecipient?: Array<string> | undefined;
  billingInvoiceLanguage?: Array<string> | undefined;
  billingPlan?: Array<string> | undefined;
  billingPurchaseOrder?: Array<string> | undefined;
  billingTaxId?: Array<string> | undefined;
  blob?: Array<string> | undefined;
  budget?: Array<string> | undefined;
  cacheArtifact?: Array<string> | undefined;
  cacheArtifactUsageEvent?: Array<string> | undefined;
  codeChecks?: Array<string> | undefined;
  concurrentBuilds?: Array<string> | undefined;
  connect?: Array<string> | undefined;
  connectConfiguration?: Array<string> | undefined;
  domain?: Array<string> | undefined;
  domainAcceptDelegation?: Array<string> | undefined;
  domainAuthCodes?: Array<string> | undefined;
  domainCertificate?: Array<string> | undefined;
  domainCheckConfig?: Array<string> | undefined;
  domainMove?: Array<string> | undefined;
  domainPurchase?: Array<string> | undefined;
  domainRecord?: Array<string> | undefined;
  domainTransferIn?: Array<string> | undefined;
  event?: Array<string> | undefined;
  ownEvent?: Array<string> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<string> | undefined;
  fileUpload?: Array<string> | undefined;
  gitRepository?: Array<string> | undefined;
  ipBlocking?: Array<string> | undefined;
  integration?: Array<string> | undefined;
  integrationAccount?: Array<string> | undefined;
  integrationConfiguration?: Array<string> | undefined;
  integrationConfigurationTransfer?: Array<string> | undefined;
  integrationConfigurationProjects?: Array<string> | undefined;
  integrationVercelConfigurationOverride?: Array<string> | undefined;
  integrationConfigurationRole?: Array<string> | undefined;
  integrationResource?: Array<string> | undefined;
  integrationEvent?: Array<string> | undefined;
  integrationResourceSecrets?: Array<string> | undefined;
  integrationDeploymentAction?: Array<string> | undefined;
  marketplaceInstallationMember?: Array<string> | undefined;
  marketplaceBillingData?: Array<string> | undefined;
  marketplaceInvoice?: Array<string> | undefined;
  jobGlobal?: Array<string> | undefined;
  logDrain?: Array<string> | undefined;
  Monitoring?: Array<string> | undefined;
  monitoringSettings?: Array<string> | undefined;
  monitoringQuery?: Array<string> | undefined;
  monitoringChart?: Array<string> | undefined;
  monitoringAlert?: Array<string> | undefined;
  notificationDeploymentFailed?: Array<string> | undefined;
  notificationDomainConfiguration?: Array<string> | undefined;
  notificationDomainExpire?: Array<string> | undefined;
  notificationDomainMoved?: Array<string> | undefined;
  notificationDomainPurchase?: Array<string> | undefined;
  notificationDomainRenewal?: Array<string> | undefined;
  notificationDomainTransfer?: Array<string> | undefined;
  notificationDomainUnverified?: Array<string> | undefined;
  NotificationMonitoringAlert?: Array<string> | undefined;
  notificationPaymentFailed?: Array<string> | undefined;
  notificationUsageAlert?: Array<string> | undefined;
  notificationCustomerBudget?: Array<string> | undefined;
  notificationStatementOfReasons?: Array<string> | undefined;
  oauth2Connection?: Array<string> | undefined;
  openTelemetryEndpoint?: Array<string> | undefined;
  paymentMethod?: Array<string> | undefined;
  permissions?: Array<string> | undefined;
  postgres?: Array<string> | undefined;
  previewDeploymentSuffix?: Array<string> | undefined;
  proTrialOnboarding?: Array<string> | undefined;
  sharedEnvVars?: Array<string> | undefined;
  sharedEnvVarsProduction?: Array<string> | undefined;
  space?: Array<string> | undefined;
  spaceRun?: Array<string> | undefined;
  passwordProtectionInvoiceItem?: Array<string> | undefined;
  rateLimit?: Array<string> | undefined;
  redis?: Array<string> | undefined;
  repository?: Array<string> | undefined;
  remoteCaching?: Array<string> | undefined;
  samlConfig?: Array<string> | undefined;
  secret?: Array<string> | undefined;
  redisStoreTokenSet?: Array<string> | undefined;
  blobStoreTokenSet?: Array<string> | undefined;
  postgresStoreTokenSet?: Array<string> | undefined;
  integrationStoreTokenSet?: Array<string> | undefined;
  integrationResourceReplCommand?: Array<string> | undefined;
  storeTransfer?: Array<string> | undefined;
  supportCase?: Array<string> | undefined;
  supportCaseComment?: Array<string> | undefined;
  dataCacheBillingSettings?: Array<string> | undefined;
  team?: Array<string> | undefined;
  teamAccessRequest?: Array<string> | undefined;
  teamFellowMembership?: Array<string> | undefined;
  teamGitExclusivity?: Array<string> | undefined;
  teamInvite?: Array<string> | undefined;
  teamInviteCode?: Array<string> | undefined;
  teamJoin?: Array<string> | undefined;
  teamOwnMembership?: Array<string> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<string> | undefined;
  token?: Array<string> | undefined;
  usage?: Array<string> | undefined;
  usageCycle?: Array<string> | undefined;
  user?: Array<string> | undefined;
  userConnection?: Array<string> | undefined;
  vpcPeeringConnection?: Array<string> | undefined;
  webAnalyticsPlan?: Array<string> | undefined;
  webAuthn?: Array<string> | undefined;
  edgeConfig?: Array<string> | undefined;
  edgeConfigItem?: Array<string> | undefined;
  edgeConfigSchema?: Array<string> | undefined;
  edgeConfigToken?: Array<string> | undefined;
  webhook?: Array<string> | undefined;
  "webhook-event"?: Array<string> | undefined;
  endpointVerification?: Array<string> | undefined;
  projectTransferIn?: Array<string> | undefined;
  oauth2Application?: Array<string> | undefined;
  aliasProject?: Array<string> | undefined;
  aliasProtectionBypass?: Array<string> | undefined;
  productionAliasProtectionBypass?: Array<string> | undefined;
  connectConfigurationLink?: Array<string> | undefined;
  dataCacheNamespace?: Array<string> | undefined;
  deployment?: Array<string> | undefined;
  deploymentCheck?: Array<string> | undefined;
  deploymentCheckPreview?: Array<string> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<string> | undefined;
  deploymentProductionGit?: Array<string> | undefined;
  deploymentPreview?: Array<string> | undefined;
  deploymentPrivate?: Array<string> | undefined;
  deploymentPromote?: Array<string> | undefined;
  deploymentRollback?: Array<string> | undefined;
  environments?: Array<string> | undefined;
  logs?: Array<string> | undefined;
  logsPreset?: Array<string> | undefined;
  passwordProtection?: Array<string> | undefined;
  optionsAllowlist?: Array<string> | undefined;
  job?: Array<string> | undefined;
  project?: Array<string> | undefined;
  projectAccessGroup?: Array<string> | undefined;
  projectAnalyticsSampling?: Array<string> | undefined;
  projectDeploymentHook?: Array<string> | undefined;
  projectDomain?: Array<string> | undefined;
  projectDomainMove?: Array<string> | undefined;
  projectDomainCheckConfig?: Array<string> | undefined;
  projectEnvVars?: Array<string> | undefined;
  projectEnvVarsProduction?: Array<string> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<string> | undefined;
  projectFlags?: Array<string> | undefined;
  projectId?: Array<string> | undefined;
  projectIntegrationConfiguration?: Array<string> | undefined;
  projectLink?: Array<string> | undefined;
  projectMember?: Array<string> | undefined;
  projectMonitoring?: Array<string> | undefined;
  projectPermissions?: Array<string> | undefined;
  projectProductionBranch?: Array<string> | undefined;
  projectTransfer?: Array<string> | undefined;
  projectTransferOut?: Array<string> | undefined;
  projectProtectionBypass?: Array<string> | undefined;
  projectUsage?: Array<string> | undefined;
  projectAnalyticsUsage?: Array<string> | undefined;
  projectSupportCase?: Array<string> | undefined;
  projectSupportCaseComment?: Array<string> | undefined;
  projectDeploymentExpiration?: Array<string> | undefined;
  projectTier?: Array<string> | undefined;
  seawallConfig?: Array<string> | undefined;
  skewProtection?: Array<string> | undefined;
  analytics?: Array<string> | undefined;
  trustedIps?: Array<string> | undefined;
  webAnalytics?: Array<string> | undefined;
  sharedEnvVarConnection?: Array<string> | undefined;
  sonar?: Array<string> | undefined;
};

/** @internal */
export const Permissions$outboundSchema: z.ZodType<
  Permissions$Outbound,
  z.ZodTypeDef,
  Permissions
> = z.object({
  accessGroup: z.array(ACLAction$outboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$outboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  auditLog: z.array(ACLAction$outboundSchema).optional(),
  billingAddress: z.array(ACLAction$outboundSchema).optional(),
  billingInformation: z.array(ACLAction$outboundSchema).optional(),
  billingInvoice: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$outboundSchema).optional(),
  billingPlan: z.array(ACLAction$outboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$outboundSchema).optional(),
  billingTaxId: z.array(ACLAction$outboundSchema).optional(),
  blob: z.array(ACLAction$outboundSchema).optional(),
  budget: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$outboundSchema).optional(),
  codeChecks: z.array(ACLAction$outboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$outboundSchema).optional(),
  connect: z.array(ACLAction$outboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$outboundSchema).optional(),
  domain: z.array(ACLAction$outboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$outboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$outboundSchema).optional(),
  domainCertificate: z.array(ACLAction$outboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  domainMove: z.array(ACLAction$outboundSchema).optional(),
  domainPurchase: z.array(ACLAction$outboundSchema).optional(),
  domainRecord: z.array(ACLAction$outboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$outboundSchema).optional(),
  event: z.array(ACLAction$outboundSchema).optional(),
  ownEvent: z.array(ACLAction$outboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$outboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$outboundSchema).optional(),
  gitRepository: z.array(ACLAction$outboundSchema).optional(),
  ipBlocking: z.array(ACLAction$outboundSchema).optional(),
  integration: z.array(ACLAction$outboundSchema).optional(),
  integrationAccount: z.array(ACLAction$outboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationProjects: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$outboundSchema).optional(),
  integrationResource: z.array(ACLAction$outboundSchema).optional(),
  integrationEvent: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$outboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$outboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$outboundSchema).optional(),
  jobGlobal: z.array(ACLAction$outboundSchema).optional(),
  logDrain: z.array(ACLAction$outboundSchema).optional(),
  monitoring: z.array(ACLAction$outboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$outboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$outboundSchema).optional(),
  monitoringChart: z.array(ACLAction$outboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$outboundSchema).optional(),
  notificationMonitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$outboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$outboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$outboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$outboundSchema).optional(),
  paymentMethod: z.array(ACLAction$outboundSchema).optional(),
  permissions: z.array(ACLAction$outboundSchema).optional(),
  postgres: z.array(ACLAction$outboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$outboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  space: z.array(ACLAction$outboundSchema).optional(),
  spaceRun: z.array(ACLAction$outboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$outboundSchema).optional(),
  rateLimit: z.array(ACLAction$outboundSchema).optional(),
  redis: z.array(ACLAction$outboundSchema).optional(),
  repository: z.array(ACLAction$outboundSchema).optional(),
  remoteCaching: z.array(ACLAction$outboundSchema).optional(),
  samlConfig: z.array(ACLAction$outboundSchema).optional(),
  secret: z.array(ACLAction$outboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$outboundSchema).optional(),
  storeTransfer: z.array(ACLAction$outboundSchema).optional(),
  supportCase: z.array(ACLAction$outboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$outboundSchema).optional(),
  team: z.array(ACLAction$outboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$outboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$outboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$outboundSchema).optional(),
  teamInvite: z.array(ACLAction$outboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$outboundSchema).optional(),
  teamJoin: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$outboundSchema).optional(),
  token: z.array(ACLAction$outboundSchema).optional(),
  usage: z.array(ACLAction$outboundSchema).optional(),
  usageCycle: z.array(ACLAction$outboundSchema).optional(),
  user: z.array(ACLAction$outboundSchema).optional(),
  userConnection: z.array(ACLAction$outboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$outboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$outboundSchema).optional(),
  webAuthn: z.array(ACLAction$outboundSchema).optional(),
  edgeConfig: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$outboundSchema).optional(),
  webhook: z.array(ACLAction$outboundSchema).optional(),
  webhookEvent: z.array(ACLAction$outboundSchema).optional(),
  endpointVerification: z.array(ACLAction$outboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$outboundSchema).optional(),
  oauth2Application: z.array(ACLAction$outboundSchema).optional(),
  aliasProject: z.array(ACLAction$outboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$outboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$outboundSchema).optional(),
  deployment: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$outboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$outboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$outboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$outboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$outboundSchema).optional(),
  environments: z.array(ACLAction$outboundSchema).optional(),
  logs: z.array(ACLAction$outboundSchema).optional(),
  logsPreset: z.array(ACLAction$outboundSchema).optional(),
  passwordProtection: z.array(ACLAction$outboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$outboundSchema).optional(),
  job: z.array(ACLAction$outboundSchema).optional(),
  project: z.array(ACLAction$outboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$outboundSchema).optional(),
  projectDomain: z.array(ACLAction$outboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$outboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$outboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$outboundSchema).optional(),
  projectId: z.array(ACLAction$outboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  projectLink: z.array(ACLAction$outboundSchema).optional(),
  projectMember: z.array(ACLAction$outboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$outboundSchema).optional(),
  projectPermissions: z.array(ACLAction$outboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$outboundSchema).optional(),
  projectTransfer: z.array(ACLAction$outboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$outboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  projectUsage: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$outboundSchema).optional(),
  projectTier: z.array(ACLAction$outboundSchema).optional(),
  seawallConfig: z.array(ACLAction$outboundSchema).optional(),
  skewProtection: z.array(ACLAction$outboundSchema).optional(),
  analytics: z.array(ACLAction$outboundSchema).optional(),
  trustedIps: z.array(ACLAction$outboundSchema).optional(),
  webAnalytics: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$outboundSchema).optional(),
  sonar: z.array(ACLAction$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    monitoring: "Monitoring",
    notificationMonitoringAlert: "NotificationMonitoringAlert",
    webhookEvent: "webhook-event",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Permissions$ {
  /** @deprecated use `Permissions$inboundSchema` instead. */
  export const inboundSchema = Permissions$inboundSchema;
  /** @deprecated use `Permissions$outboundSchema` instead. */
  export const outboundSchema = Permissions$outboundSchema;
  /** @deprecated use `Permissions$Outbound` instead. */
  export type Outbound = Permissions$Outbound;
}

/** @internal */
export const LastRollbackTarget$inboundSchema: z.ZodType<
  LastRollbackTarget,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type LastRollbackTarget$Outbound = {};

/** @internal */
export const LastRollbackTarget$outboundSchema: z.ZodType<
  LastRollbackTarget$Outbound,
  z.ZodTypeDef,
  LastRollbackTarget
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace LastRollbackTarget$ {
  /** @deprecated use `LastRollbackTarget$inboundSchema` instead. */
  export const inboundSchema = LastRollbackTarget$inboundSchema;
  /** @deprecated use `LastRollbackTarget$outboundSchema` instead. */
  export const outboundSchema = LastRollbackTarget$outboundSchema;
  /** @deprecated use `LastRollbackTarget$Outbound` instead. */
  export type Outbound = LastRollbackTarget$Outbound;
}

/** @internal */
export const JobStatus$inboundSchema: z.ZodNativeEnum<typeof JobStatus> = z
  .nativeEnum(JobStatus);

/** @internal */
export const JobStatus$outboundSchema: z.ZodNativeEnum<typeof JobStatus> =
  JobStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace JobStatus$ {
  /** @deprecated use `JobStatus$inboundSchema` instead. */
  export const inboundSchema = JobStatus$inboundSchema;
  /** @deprecated use `JobStatus$outboundSchema` instead. */
  export const outboundSchema = JobStatus$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsResponseType> = z
    .nativeEnum(UpdateProjectDataCacheProjectsResponseType);

/** @internal */
export const UpdateProjectDataCacheProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheProjectsResponseType> =
    UpdateProjectDataCacheProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponseType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponseType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponseType$outboundSchema;
}

/** @internal */
export const LastAliasRequest$inboundSchema: z.ZodType<
  LastAliasRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: JobStatus$inboundSchema,
  requestedAt: z.number(),
  type: UpdateProjectDataCacheProjectsResponseType$inboundSchema,
});

/** @internal */
export type LastAliasRequest$Outbound = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: string;
  requestedAt: number;
  type: string;
};

/** @internal */
export const LastAliasRequest$outboundSchema: z.ZodType<
  LastAliasRequest$Outbound,
  z.ZodTypeDef,
  LastAliasRequest
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: JobStatus$outboundSchema,
  requestedAt: z.number(),
  type: UpdateProjectDataCacheProjectsResponseType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace LastAliasRequest$ {
  /** @deprecated use `LastAliasRequest$inboundSchema` instead. */
  export const inboundSchema = LastAliasRequest$inboundSchema;
  /** @deprecated use `LastAliasRequest$outboundSchema` instead. */
  export const outboundSchema = LastAliasRequest$outboundSchema;
  /** @deprecated use `LastAliasRequest$Outbound` instead. */
  export type Outbound = LastAliasRequest$Outbound;
}

/** @internal */
export const Scope$inboundSchema: z.ZodNativeEnum<typeof Scope> = z.nativeEnum(
  Scope,
);

/** @internal */
export const Scope$outboundSchema: z.ZodNativeEnum<typeof Scope> =
  Scope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Scope$ {
  /** @deprecated use `Scope$inboundSchema` instead. */
  export const inboundSchema = Scope$inboundSchema;
  /** @deprecated use `Scope$outboundSchema` instead. */
  export const outboundSchema = Scope$outboundSchema;
}

/** @internal */
export const ProtectionBypass$inboundSchema: z.ZodType<
  ProtectionBypass,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: Scope$inboundSchema,
});

/** @internal */
export type ProtectionBypass$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const ProtectionBypass$outboundSchema: z.ZodType<
  ProtectionBypass$Outbound,
  z.ZodTypeDef,
  ProtectionBypass
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: Scope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionBypass$ {
  /** @deprecated use `ProtectionBypass$inboundSchema` instead. */
  export const inboundSchema = ProtectionBypass$inboundSchema;
  /** @deprecated use `ProtectionBypass$outboundSchema` instead. */
  export const outboundSchema = ProtectionBypass$outboundSchema;
  /** @deprecated use `ProtectionBypass$Outbound` instead. */
  export type Outbound = ProtectionBypass$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheTrustedIpsDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheTrustedIpsDeploymentType> = z
    .nativeEnum(UpdateProjectDataCacheTrustedIpsDeploymentType);

/** @internal */
export const UpdateProjectDataCacheTrustedIpsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheTrustedIpsDeploymentType> =
    UpdateProjectDataCacheTrustedIpsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTrustedIpsDeploymentType$ {
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheTrustedIpsDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheTrustedIpsDeploymentType$outboundSchema;
}

/** @internal */
export const TrustedIps2$inboundSchema: z.ZodType<
  TrustedIps2,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectDataCacheTrustedIpsDeploymentType$inboundSchema,
});

/** @internal */
export type TrustedIps2$Outbound = {
  deploymentType: string;
};

/** @internal */
export const TrustedIps2$outboundSchema: z.ZodType<
  TrustedIps2$Outbound,
  z.ZodTypeDef,
  TrustedIps2
> = z.object({
  deploymentType: UpdateProjectDataCacheTrustedIpsDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TrustedIps2$ {
  /** @deprecated use `TrustedIps2$inboundSchema` instead. */
  export const inboundSchema = TrustedIps2$inboundSchema;
  /** @deprecated use `TrustedIps2$outboundSchema` instead. */
  export const outboundSchema = TrustedIps2$outboundSchema;
  /** @deprecated use `TrustedIps2$Outbound` instead. */
  export type Outbound = TrustedIps2$Outbound;
}

/** @internal */
export const TrustedIpsDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof TrustedIpsDeploymentType
> = z.nativeEnum(TrustedIpsDeploymentType);

/** @internal */
export const TrustedIpsDeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof TrustedIpsDeploymentType
> = TrustedIpsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TrustedIpsDeploymentType$ {
  /** @deprecated use `TrustedIpsDeploymentType$inboundSchema` instead. */
  export const inboundSchema = TrustedIpsDeploymentType$inboundSchema;
  /** @deprecated use `TrustedIpsDeploymentType$outboundSchema` instead. */
  export const outboundSchema = TrustedIpsDeploymentType$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheTrustedIpsAddresses$inboundSchema: z.ZodType<
  UpdateProjectDataCacheTrustedIpsAddresses,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/** @internal */
export type UpdateProjectDataCacheTrustedIpsAddresses$Outbound = {
  value: string;
  note?: string | undefined;
};

/** @internal */
export const UpdateProjectDataCacheTrustedIpsAddresses$outboundSchema:
  z.ZodType<
    UpdateProjectDataCacheTrustedIpsAddresses$Outbound,
    z.ZodTypeDef,
    UpdateProjectDataCacheTrustedIpsAddresses
  > = z.object({
    value: z.string(),
    note: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTrustedIpsAddresses$ {
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsAddresses$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheTrustedIpsAddresses$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsAddresses$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheTrustedIpsAddresses$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsAddresses$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheTrustedIpsAddresses$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheTrustedIpsProtectionMode$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheTrustedIpsProtectionMode> = z
    .nativeEnum(UpdateProjectDataCacheTrustedIpsProtectionMode);

/** @internal */
export const UpdateProjectDataCacheTrustedIpsProtectionMode$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectDataCacheTrustedIpsProtectionMode> =
    UpdateProjectDataCacheTrustedIpsProtectionMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTrustedIpsProtectionMode$ {
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsProtectionMode$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheTrustedIpsProtectionMode$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTrustedIpsProtectionMode$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheTrustedIpsProtectionMode$outboundSchema;
}

/** @internal */
export const TrustedIps1$inboundSchema: z.ZodType<
  TrustedIps1,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: TrustedIpsDeploymentType$inboundSchema,
  addresses: z.array(
    z.lazy(() => UpdateProjectDataCacheTrustedIpsAddresses$inboundSchema),
  ),
  protectionMode: UpdateProjectDataCacheTrustedIpsProtectionMode$inboundSchema,
});

/** @internal */
export type TrustedIps1$Outbound = {
  deploymentType: string;
  addresses: Array<UpdateProjectDataCacheTrustedIpsAddresses$Outbound>;
  protectionMode: string;
};

/** @internal */
export const TrustedIps1$outboundSchema: z.ZodType<
  TrustedIps1$Outbound,
  z.ZodTypeDef,
  TrustedIps1
> = z.object({
  deploymentType: TrustedIpsDeploymentType$outboundSchema,
  addresses: z.array(
    z.lazy(() => UpdateProjectDataCacheTrustedIpsAddresses$outboundSchema),
  ),
  protectionMode: UpdateProjectDataCacheTrustedIpsProtectionMode$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TrustedIps1$ {
  /** @deprecated use `TrustedIps1$inboundSchema` instead. */
  export const inboundSchema = TrustedIps1$inboundSchema;
  /** @deprecated use `TrustedIps1$outboundSchema` instead. */
  export const outboundSchema = TrustedIps1$outboundSchema;
  /** @deprecated use `TrustedIps1$Outbound` instead. */
  export type Outbound = TrustedIps1$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheTrustedIps$inboundSchema: z.ZodType<
  UpdateProjectDataCacheTrustedIps,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => TrustedIps2$inboundSchema),
  z.lazy(() => TrustedIps1$inboundSchema),
]);

/** @internal */
export type UpdateProjectDataCacheTrustedIps$Outbound =
  | TrustedIps2$Outbound
  | TrustedIps1$Outbound;

/** @internal */
export const UpdateProjectDataCacheTrustedIps$outboundSchema: z.ZodType<
  UpdateProjectDataCacheTrustedIps$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheTrustedIps
> = z.union([
  z.lazy(() => TrustedIps2$outboundSchema),
  z.lazy(() => TrustedIps1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheTrustedIps$ {
  /** @deprecated use `UpdateProjectDataCacheTrustedIps$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheTrustedIps$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTrustedIps$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheTrustedIps$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheTrustedIps$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheTrustedIps$Outbound;
}

/** @internal */
export const GitComments$inboundSchema: z.ZodType<
  GitComments,
  z.ZodTypeDef,
  unknown
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/** @internal */
export type GitComments$Outbound = {
  onPullRequest: boolean;
  onCommit: boolean;
};

/** @internal */
export const GitComments$outboundSchema: z.ZodType<
  GitComments$Outbound,
  z.ZodTypeDef,
  GitComments
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitComments$ {
  /** @deprecated use `GitComments$inboundSchema` instead. */
  export const inboundSchema = GitComments$inboundSchema;
  /** @deprecated use `GitComments$outboundSchema` instead. */
  export const outboundSchema = GitComments$outboundSchema;
  /** @deprecated use `GitComments$Outbound` instead. */
  export type Outbound = GitComments$Outbound;
}

/** @internal */
export const WebAnalytics$inboundSchema: z.ZodType<
  WebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type WebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const WebAnalytics$outboundSchema: z.ZodType<
  WebAnalytics$Outbound,
  z.ZodTypeDef,
  WebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace WebAnalytics$ {
  /** @deprecated use `WebAnalytics$inboundSchema` instead. */
  export const inboundSchema = WebAnalytics$inboundSchema;
  /** @deprecated use `WebAnalytics$outboundSchema` instead. */
  export const outboundSchema = WebAnalytics$outboundSchema;
  /** @deprecated use `WebAnalytics$Outbound` instead. */
  export type Outbound = WebAnalytics$Outbound;
}

/** @internal */
export const Src2$inboundSchema: z.ZodType<Src2, z.ZodTypeDef, unknown> = z
  .object({
    re: z.string().optional(),
    eq: z.string().optional(),
    neq: z.string().optional(),
    inc: z.array(z.string()).optional(),
    ninc: z.array(z.string()).optional(),
    pre: z.string().optional(),
    suf: z.string().optional(),
    gt: z.number().optional(),
    gte: z.number().optional(),
    lt: z.number().optional(),
    lte: z.number().optional(),
  });

/** @internal */
export type Src2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const Src2$outboundSchema: z.ZodType<Src2$Outbound, z.ZodTypeDef, Src2> =
  z.object({
    re: z.string().optional(),
    eq: z.string().optional(),
    neq: z.string().optional(),
    inc: z.array(z.string()).optional(),
    ninc: z.array(z.string()).optional(),
    pre: z.string().optional(),
    suf: z.string().optional(),
    gt: z.number().optional(),
    gte: z.number().optional(),
    lt: z.number().optional(),
    lte: z.number().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Src2$ {
  /** @deprecated use `Src2$inboundSchema` instead. */
  export const inboundSchema = Src2$inboundSchema;
  /** @deprecated use `Src2$outboundSchema` instead. */
  export const outboundSchema = Src2$outboundSchema;
  /** @deprecated use `Src2$Outbound` instead. */
  export type Outbound = Src2$Outbound;
}

/** @internal */
export const Src$inboundSchema: z.ZodType<Src, z.ZodTypeDef, unknown> = z.union(
  [z.lazy(() => Src2$inboundSchema), z.string()],
);

/** @internal */
export type Src$Outbound = Src2$Outbound | string;

/** @internal */
export const Src$outboundSchema: z.ZodType<Src$Outbound, z.ZodTypeDef, Src> = z
  .union([z.lazy(() => Src2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Src$ {
  /** @deprecated use `Src$inboundSchema` instead. */
  export const inboundSchema = Src$inboundSchema;
  /** @deprecated use `Src$outboundSchema` instead. */
  export const outboundSchema = Src$outboundSchema;
  /** @deprecated use `Src$Outbound` instead. */
  export type Outbound = Src$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType
  > = z.nativeEnum(
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType,
  );

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType
  > =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheValueProjects2$inboundSchema: z.ZodType<
  UpdateProjectDataCacheValueProjects2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type UpdateProjectDataCacheValueProjects2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const UpdateProjectDataCacheValueProjects2$outboundSchema: z.ZodType<
  UpdateProjectDataCacheValueProjects2$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheValueProjects2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheValueProjects2$ {
  /** @deprecated use `UpdateProjectDataCacheValueProjects2$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheValueProjects2$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheValueProjects2$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheValueProjects2$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheValueProjects2$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheValueProjects2$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsValue$inboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsValue,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateProjectDataCacheValueProjects2$inboundSchema),
  z.string(),
]);

/** @internal */
export type UpdateProjectDataCacheProjectsValue$Outbound =
  | UpdateProjectDataCacheValueProjects2$Outbound
  | string;

/** @internal */
export const UpdateProjectDataCacheProjectsValue$outboundSchema: z.ZodType<
  UpdateProjectDataCacheProjectsValue$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheProjectsValue
> = z.union([
  z.lazy(() => UpdateProjectDataCacheValueProjects2$outboundSchema),
  z.string(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsValue$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsValue$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsValue$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsValue$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsValue$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsValue$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheProjectsValue$Outbound;
}

/** @internal */
export const Has$inboundSchema: z.ZodType<Has, z.ZodTypeDef, unknown> = z
  .object({
    type:
      UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema,
    key: z.string().optional(),
    value: z.union([
      z.lazy(() => UpdateProjectDataCacheValueProjects2$inboundSchema),
      z.string(),
    ]).optional(),
  });

/** @internal */
export type Has$Outbound = {
  type: string;
  key?: string | undefined;
  value?: UpdateProjectDataCacheValueProjects2$Outbound | string | undefined;
};

/** @internal */
export const Has$outboundSchema: z.ZodType<Has$Outbound, z.ZodTypeDef, Has> = z
  .object({
    type:
      UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema,
    key: z.string().optional(),
    value: z.union([
      z.lazy(() => UpdateProjectDataCacheValueProjects2$outboundSchema),
      z.string(),
    ]).optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Has$ {
  /** @deprecated use `Has$inboundSchema` instead. */
  export const inboundSchema = Has$inboundSchema;
  /** @deprecated use `Has$outboundSchema` instead. */
  export const outboundSchema = Has$outboundSchema;
  /** @deprecated use `Has$Outbound` instead. */
  export type Outbound = Has$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  > = z.nativeEnum(
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType,
  );

/** @internal */
export const UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  > =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$ {
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheValue2$inboundSchema: z.ZodType<
  UpdateProjectDataCacheValue2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type UpdateProjectDataCacheValue2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const UpdateProjectDataCacheValue2$outboundSchema: z.ZodType<
  UpdateProjectDataCacheValue2$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheValue2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheValue2$ {
  /** @deprecated use `UpdateProjectDataCacheValue2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheValue2$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheValue2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheValue2$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheValue2$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheValue2$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheValue$inboundSchema: z.ZodType<
  UpdateProjectDataCacheValue,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateProjectDataCacheValue2$inboundSchema),
  z.string(),
]);

/** @internal */
export type UpdateProjectDataCacheValue$Outbound =
  | UpdateProjectDataCacheValue2$Outbound
  | string;

/** @internal */
export const UpdateProjectDataCacheValue$outboundSchema: z.ZodType<
  UpdateProjectDataCacheValue$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheValue
> = z.union([
  z.lazy(() => UpdateProjectDataCacheValue2$outboundSchema),
  z.string(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheValue$ {
  /** @deprecated use `UpdateProjectDataCacheValue$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheValue$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheValue$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheValue$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheValue$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheValue$Outbound;
}

/** @internal */
export const Missing$inboundSchema: z.ZodType<Missing, z.ZodTypeDef, unknown> =
  z.object({
    type:
      UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema,
    key: z.string().optional(),
    value: z.union([
      z.lazy(() => UpdateProjectDataCacheValue2$inboundSchema),
      z.string(),
    ]).optional(),
  });

/** @internal */
export type Missing$Outbound = {
  type: string;
  key?: string | undefined;
  value?: UpdateProjectDataCacheValue2$Outbound | string | undefined;
};

/** @internal */
export const Missing$outboundSchema: z.ZodType<
  Missing$Outbound,
  z.ZodTypeDef,
  Missing
> = z.object({
  type:
    UpdateProjectDataCacheProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => UpdateProjectDataCacheValue2$outboundSchema),
    z.string(),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Missing$ {
  /** @deprecated use `Missing$inboundSchema` instead. */
  export const inboundSchema = Missing$inboundSchema;
  /** @deprecated use `Missing$outboundSchema` instead. */
  export const outboundSchema = Missing$outboundSchema;
  /** @deprecated use `Missing$Outbound` instead. */
  export type Outbound = Missing$Outbound;
}

/** @internal */
export const Handle$inboundSchema: z.ZodNativeEnum<typeof Handle> = z
  .nativeEnum(Handle);

/** @internal */
export const Handle$outboundSchema: z.ZodNativeEnum<typeof Handle> =
  Handle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Handle$ {
  /** @deprecated use `Handle$inboundSchema` instead. */
  export const inboundSchema = Handle$inboundSchema;
  /** @deprecated use `Handle$outboundSchema` instead. */
  export const outboundSchema = Handle$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheAction$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheAction
> = z.nativeEnum(UpdateProjectDataCacheAction);

/** @internal */
export const UpdateProjectDataCacheAction$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheAction
> = UpdateProjectDataCacheAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheAction$ {
  /** @deprecated use `UpdateProjectDataCacheAction$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheAction$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheAction$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheAction$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheAlgo$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheAlgo
> = z.nativeEnum(UpdateProjectDataCacheAlgo);

/** @internal */
export const UpdateProjectDataCacheAlgo$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheAlgo
> = UpdateProjectDataCacheAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheAlgo$ {
  /** @deprecated use `UpdateProjectDataCacheAlgo$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheAlgo$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheAlgo$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheAlgo$outboundSchema;
}

/** @internal */
export const Erl$inboundSchema: z.ZodType<Erl, z.ZodTypeDef, unknown> = z
  .object({
    algo: UpdateProjectDataCacheAlgo$inboundSchema,
    window: z.number(),
    limit: z.number(),
    keys: z.array(z.string()),
  });

/** @internal */
export type Erl$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
};

/** @internal */
export const Erl$outboundSchema: z.ZodType<Erl$Outbound, z.ZodTypeDef, Erl> = z
  .object({
    algo: UpdateProjectDataCacheAlgo$outboundSchema,
    window: z.number(),
    limit: z.number(),
    keys: z.array(z.string()),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Erl$ {
  /** @deprecated use `Erl$inboundSchema` instead. */
  export const inboundSchema = Erl$inboundSchema;
  /** @deprecated use `Erl$outboundSchema` instead. */
  export const outboundSchema = Erl$outboundSchema;
  /** @deprecated use `Erl$Outbound` instead. */
  export type Outbound = Erl$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheMitigate$inboundSchema: z.ZodType<
  UpdateProjectDataCacheMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateProjectDataCacheAction$inboundSchema,
  rule_id: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => Erl$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "rule_id": "ruleId",
  });
});

/** @internal */
export type UpdateProjectDataCacheMitigate$Outbound = {
  action: string;
  rule_id: string;
  ttl?: number | undefined;
  erl?: Erl$Outbound | undefined;
};

/** @internal */
export const UpdateProjectDataCacheMitigate$outboundSchema: z.ZodType<
  UpdateProjectDataCacheMitigate$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheMitigate
> = z.object({
  action: UpdateProjectDataCacheAction$outboundSchema,
  ruleId: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => Erl$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    ruleId: "rule_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheMitigate$ {
  /** @deprecated use `UpdateProjectDataCacheMitigate$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheMitigate$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheMitigate$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheMitigate$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheMitigate$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheMitigate$Outbound;
}

/** @internal */
export const FirewallRoutes$inboundSchema: z.ZodType<
  FirewallRoutes,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.union([z.lazy(() => Src2$inboundSchema), z.string()]).optional(),
  has: z.array(z.lazy(() => Has$inboundSchema)).optional(),
  missing: z.array(z.lazy(() => Missing$inboundSchema)).optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: Handle$inboundSchema.optional(),
  mitigate: z.lazy(() => UpdateProjectDataCacheMitigate$inboundSchema)
    .optional(),
});

/** @internal */
export type FirewallRoutes$Outbound = {
  src?: Src2$Outbound | string | undefined;
  has?: Array<Has$Outbound> | undefined;
  missing?: Array<Missing$Outbound> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: string | undefined;
  mitigate?: UpdateProjectDataCacheMitigate$Outbound | undefined;
};

/** @internal */
export const FirewallRoutes$outboundSchema: z.ZodType<
  FirewallRoutes$Outbound,
  z.ZodTypeDef,
  FirewallRoutes
> = z.object({
  src: z.union([z.lazy(() => Src2$outboundSchema), z.string()]).optional(),
  has: z.array(z.lazy(() => Has$outboundSchema)).optional(),
  missing: z.array(z.lazy(() => Missing$outboundSchema)).optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: Handle$outboundSchema.optional(),
  mitigate: z.lazy(() => UpdateProjectDataCacheMitigate$outboundSchema)
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FirewallRoutes$ {
  /** @deprecated use `FirewallRoutes$inboundSchema` instead. */
  export const inboundSchema = FirewallRoutes$inboundSchema;
  /** @deprecated use `FirewallRoutes$outboundSchema` instead. */
  export const outboundSchema = FirewallRoutes$outboundSchema;
  /** @deprecated use `FirewallRoutes$Outbound` instead. */
  export type Outbound = FirewallRoutes$Outbound;
}

/** @internal */
export const Security$inboundSchema: z.ZodType<
  Security,
  z.ZodTypeDef,
  unknown
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(z.lazy(() => FirewallRoutes$inboundSchema))
    .optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/** @internal */
export type Security$Outbound = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<FirewallRoutes$Outbound> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/** @internal */
export const Security$outboundSchema: z.ZodType<
  Security$Outbound,
  z.ZodTypeDef,
  Security
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(z.lazy(() => FirewallRoutes$outboundSchema))
    .optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Security$ {
  /** @deprecated use `Security$inboundSchema` instead. */
  export const inboundSchema = Security$inboundSchema;
  /** @deprecated use `Security$outboundSchema` instead. */
  export const outboundSchema = Security$outboundSchema;
  /** @deprecated use `Security$Outbound` instead. */
  export type Outbound = Security$Outbound;
}

/** @internal */
export const UpdateProjectDataCacheIssuerMode$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheIssuerMode
> = z.nativeEnum(UpdateProjectDataCacheIssuerMode);

/** @internal */
export const UpdateProjectDataCacheIssuerMode$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDataCacheIssuerMode
> = UpdateProjectDataCacheIssuerMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheIssuerMode$ {
  /** @deprecated use `UpdateProjectDataCacheIssuerMode$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheIssuerMode$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheIssuerMode$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCacheIssuerMode$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheOidcTokenConfig$inboundSchema: z.ZodType<
  UpdateProjectDataCacheOidcTokenConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean(),
  issuerMode: UpdateProjectDataCacheIssuerMode$inboundSchema.optional(),
});

/** @internal */
export type UpdateProjectDataCacheOidcTokenConfig$Outbound = {
  enabled: boolean;
  issuerMode?: string | undefined;
};

/** @internal */
export const UpdateProjectDataCacheOidcTokenConfig$outboundSchema: z.ZodType<
  UpdateProjectDataCacheOidcTokenConfig$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheOidcTokenConfig
> = z.object({
  enabled: z.boolean(),
  issuerMode: UpdateProjectDataCacheIssuerMode$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheOidcTokenConfig$ {
  /** @deprecated use `UpdateProjectDataCacheOidcTokenConfig$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectDataCacheOidcTokenConfig$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheOidcTokenConfig$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheOidcTokenConfig$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheOidcTokenConfig$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheOidcTokenConfig$Outbound;
}

/** @internal */
export const Tier$inboundSchema: z.ZodNativeEnum<typeof Tier> = z.nativeEnum(
  Tier,
);

/** @internal */
export const Tier$outboundSchema: z.ZodNativeEnum<typeof Tier> =
  Tier$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Tier$ {
  /** @deprecated use `Tier$inboundSchema` instead. */
  export const inboundSchema = Tier$inboundSchema;
  /** @deprecated use `Tier$outboundSchema` instead. */
  export const outboundSchema = Tier$outboundSchema;
}

/** @internal */
export const UpdateProjectDataCacheResponseBody$inboundSchema: z.ZodType<
  UpdateProjectDataCacheResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => Analytics$inboundSchema).optional(),
  speedInsights: z.lazy(() => SpeedInsights$inboundSchema).optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => Crons$inboundSchema).optional(),
  dataCache: z.lazy(() => DataCache$inboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => DeploymentExpiration$inboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => Env$inboundSchema)).optional(),
  customEnvironments: z.array(z.lazy(() => CustomEnvironments$inboundSchema))
    .optional(),
  framework: z.nullable(UpdateProjectDataCacheFramework$inboundSchema)
    .optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => IpBuckets$inboundSchema)).optional(),
  latestDeployments: z.array(z.lazy(() => LatestDeployments$inboundSchema))
    .optional(),
  link: z.union([
    z.lazy(() => Link1$inboundSchema),
    z.lazy(() => Link3$inboundSchema),
    z.lazy(() => Link2$inboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => Microfrontends$inboundSchema).optional(),
  name: z.string(),
  nodeVersion: UpdateProjectDataCacheNodeVersion$inboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => UpdateProjectDataCacheOptionsAllowlist$inboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => UpdateProjectDataCachePasswordProtection$inboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => ResourceConfig$inboundSchema).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => UpdateProjectDataCacheSsoProtection$inboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => Targets$inboundSchema)).optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => Permissions$inboundSchema).optional(),
  lastRollbackTarget: z.nullable(z.lazy(() => LastRollbackTarget$inboundSchema))
    .optional(),
  lastAliasRequest: z.nullable(z.lazy(() => LastAliasRequest$inboundSchema))
    .optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(z.lazy(() => ProtectionBypass$inboundSchema))
    .optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => TrustedIps2$inboundSchema),
      z.lazy(() => TrustedIps1$inboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => GitComments$inboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => WebAnalytics$inboundSchema).optional(),
  security: z.lazy(() => Security$inboundSchema).optional(),
  oidcTokenConfig: z.lazy(() =>
    UpdateProjectDataCacheOidcTokenConfig$inboundSchema
  ).optional(),
  tier: Tier$inboundSchema.optional(),
});

/** @internal */
export type UpdateProjectDataCacheResponseBody$Outbound = {
  accountId: string;
  analytics?: Analytics$Outbound | undefined;
  speedInsights?: SpeedInsights$Outbound | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: Crons$Outbound | undefined;
  dataCache?: DataCache$Outbound | undefined;
  deploymentExpiration?: DeploymentExpiration$Outbound | null | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<Env$Outbound> | undefined;
  customEnvironments?: Array<CustomEnvironments$Outbound> | undefined;
  framework?: string | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<IpBuckets$Outbound> | undefined;
  latestDeployments?: Array<LatestDeployments$Outbound> | undefined;
  link?: Link1$Outbound | Link3$Outbound | Link2$Outbound | undefined;
  microfrontends?: Microfrontends$Outbound | undefined;
  name: string;
  nodeVersion: string;
  optionsAllowlist?:
    | UpdateProjectDataCacheOptionsAllowlist$Outbound
    | null
    | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?:
    | UpdateProjectDataCachePasswordProtection$Outbound
    | null
    | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: ResourceConfig$Outbound | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?:
    | UpdateProjectDataCacheSsoProtection$Outbound
    | null
    | undefined;
  targets?: { [k: string]: Targets$Outbound } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: Permissions$Outbound | undefined;
  lastRollbackTarget?: LastRollbackTarget$Outbound | null | undefined;
  lastAliasRequest?: LastAliasRequest$Outbound | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?: { [k: string]: ProtectionBypass$Outbound } | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?: TrustedIps2$Outbound | TrustedIps1$Outbound | null | undefined;
  gitComments?: GitComments$Outbound | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: WebAnalytics$Outbound | undefined;
  security?: Security$Outbound | undefined;
  oidcTokenConfig?: UpdateProjectDataCacheOidcTokenConfig$Outbound | undefined;
  tier?: string | undefined;
};

/** @internal */
export const UpdateProjectDataCacheResponseBody$outboundSchema: z.ZodType<
  UpdateProjectDataCacheResponseBody$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCacheResponseBody
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => Analytics$outboundSchema).optional(),
  speedInsights: z.lazy(() => SpeedInsights$outboundSchema).optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => Crons$outboundSchema).optional(),
  dataCache: z.lazy(() => DataCache$outboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => DeploymentExpiration$outboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => Env$outboundSchema)).optional(),
  customEnvironments: z.array(z.lazy(() => CustomEnvironments$outboundSchema))
    .optional(),
  framework: z.nullable(UpdateProjectDataCacheFramework$outboundSchema)
    .optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => IpBuckets$outboundSchema)).optional(),
  latestDeployments: z.array(z.lazy(() => LatestDeployments$outboundSchema))
    .optional(),
  link: z.union([
    z.lazy(() => Link1$outboundSchema),
    z.lazy(() => Link3$outboundSchema),
    z.lazy(() => Link2$outboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => Microfrontends$outboundSchema).optional(),
  name: z.string(),
  nodeVersion: UpdateProjectDataCacheNodeVersion$outboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => UpdateProjectDataCacheOptionsAllowlist$outboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => UpdateProjectDataCachePasswordProtection$outboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => ResourceConfig$outboundSchema).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => UpdateProjectDataCacheSsoProtection$outboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => Targets$outboundSchema)).optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => Permissions$outboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => LastRollbackTarget$outboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(z.lazy(() => LastAliasRequest$outboundSchema))
    .optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(z.lazy(() => ProtectionBypass$outboundSchema))
    .optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => TrustedIps2$outboundSchema),
      z.lazy(() => TrustedIps1$outboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => GitComments$outboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => WebAnalytics$outboundSchema).optional(),
  security: z.lazy(() => Security$outboundSchema).optional(),
  oidcTokenConfig: z.lazy(() =>
    UpdateProjectDataCacheOidcTokenConfig$outboundSchema
  ).optional(),
  tier: Tier$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCacheResponseBody$ {
  /** @deprecated use `UpdateProjectDataCacheResponseBody$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCacheResponseBody$inboundSchema;
  /** @deprecated use `UpdateProjectDataCacheResponseBody$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDataCacheResponseBody$outboundSchema;
  /** @deprecated use `UpdateProjectDataCacheResponseBody$Outbound` instead. */
  export type Outbound = UpdateProjectDataCacheResponseBody$Outbound;
}
