/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  ACLAction,
  ACLAction$inboundSchema,
  ACLAction$outboundSchema,
} from "../components/aclaction.js";

/**
 * The framework that is being used for this project. When `null` is used no framework is selected
 */
export const UpdateProjectFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
/**
 * The framework that is being used for this project. When `null` is used no framework is selected
 */
export type UpdateProjectFramework = ClosedEnum<typeof UpdateProjectFramework>;

export const UpdateProjectNodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
} as const;
export type UpdateProjectNodeVersion = ClosedEnum<
  typeof UpdateProjectNodeVersion
>;

/**
 * team: `https://oidc.vercel.com/[team_slug]` global: `https://oidc.vercel.com`
 */
export const UpdateProjectIssuerMode = {
  Team: "team",
  Global: "global",
} as const;
/**
 * team: `https://oidc.vercel.com/[team_slug]` global: `https://oidc.vercel.com`
 */
export type UpdateProjectIssuerMode = ClosedEnum<
  typeof UpdateProjectIssuerMode
>;

/**
 * OpenID Connect JSON Web Token generation configuration.
 */
export type UpdateProjectOidcTokenConfig = {
  /**
   * Whether or not to generate OpenID Connect JSON Web Tokens.
   */
  enabled: boolean;
  /**
   * team: `https://oidc.vercel.com/[team_slug]` global: `https://oidc.vercel.com`
   */
  issuerMode?: UpdateProjectIssuerMode | undefined;
};

/**
 * Specify if the password will apply to every Deployment Target or just Preview
 */
export const DeploymentType = {
  All: "all",
  Preview: "preview",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
/**
 * Specify if the password will apply to every Deployment Target or just Preview
 */
export type DeploymentType = ClosedEnum<typeof DeploymentType>;

/**
 * Allows to protect project deployments with a password
 */
export type PasswordProtection = {
  /**
   * Specify if the password will apply to every Deployment Target or just Preview
   */
  deploymentType: DeploymentType;
  /**
   * The password that will be used to protect Project Deployments
   */
  password?: string | null | undefined;
};

/**
 * Specify if the Vercel Authentication (SSO Protection) will apply to every Deployment Target or just Preview
 */
export const UpdateProjectDeploymentType = {
  All: "all",
  Preview: "preview",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
/**
 * Specify if the Vercel Authentication (SSO Protection) will apply to every Deployment Target or just Preview
 */
export type UpdateProjectDeploymentType = ClosedEnum<
  typeof UpdateProjectDeploymentType
>;

/**
 * Ensures visitors to your Preview Deployments are logged into Vercel and have a minimum of Viewer access on your team
 */
export type SsoProtection = {
  /**
   * Specify if the Vercel Authentication (SSO Protection) will apply to every Deployment Target or just Preview
   */
  deploymentType?: UpdateProjectDeploymentType | undefined;
};

/**
 * Specify if the Trusted IPs will apply to every Deployment Target or just Preview
 */
export const UpdateProjectProjectsDeploymentType = {
  All: "all",
  Preview: "preview",
  Production: "production",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
/**
 * Specify if the Trusted IPs will apply to every Deployment Target or just Preview
 */
export type UpdateProjectProjectsDeploymentType = ClosedEnum<
  typeof UpdateProjectProjectsDeploymentType
>;

export type Addresses = {
  /**
   * The IP addresses that are allowlisted. Supports IPv4 addresses and CIDR notations. IPv6 is not supported
   */
  value: string;
  /**
   * An optional note explaining what the IP address or subnet is used for
   */
  note?: string | undefined;
};

/**
 * exclusive: ip match is enough to bypass deployment protection (regardless of other settings). additional: ip must match + any other protection should be also provided (password, vercel auth, shareable link, automation bypass header, automation bypass query param)
 */
export const ProtectionMode = {
  Exclusive: "exclusive",
  Additional: "additional",
} as const;
/**
 * exclusive: ip match is enough to bypass deployment protection (regardless of other settings). additional: ip must match + any other protection should be also provided (password, vercel auth, shareable link, automation bypass header, automation bypass query param)
 */
export type ProtectionMode = ClosedEnum<typeof ProtectionMode>;

/**
 * Restricts access to deployments based on the incoming request IP address
 */
export type TrustedIps = {
  /**
   * Specify if the Trusted IPs will apply to every Deployment Target or just Preview
   */
  deploymentType: UpdateProjectProjectsDeploymentType;
  addresses: Array<Addresses>;
  /**
   * exclusive: ip match is enough to bypass deployment protection (regardless of other settings). additional: ip must match + any other protection should be also provided (password, vercel auth, shareable link, automation bypass header, automation bypass query param)
   */
  protectionMode: ProtectionMode;
};

export type Paths = {
  /**
   * The regex path that should not be protected by Deployment Protection
   */
  value: string;
};

/**
 * Specify a list of paths that should not be protected by Deployment Protection to enable Cors preflight requests
 */
export type OptionsAllowlist = {
  paths: Array<Paths>;
};

export type UpdateProjectRequestBody = {
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  /**
   * The build command for this project. When `null` is used this value will be automatically detected
   */
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  /**
   * Specifies whether customer support can see git source for a deployment
   */
  customerSupportCodeVisibility?: boolean | undefined;
  /**
   * The dev command for this project. When `null` is used this value will be automatically detected
   */
  devCommand?: string | null | undefined;
  directoryListing?: boolean | undefined;
  /**
   * The framework that is being used for this project. When `null` is used no framework is selected
   */
  framework?: UpdateProjectFramework | null | undefined;
  /**
   * Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed
   */
  gitForkProtection?: boolean | undefined;
  /**
   * Specifies whether Git LFS is enabled for this project.
   */
  gitLFS?: boolean | undefined;
  /**
   * The install command for this project. When `null` is used this value will be automatically detected
   */
  installCommand?: string | null | undefined;
  /**
   * The desired name for the project
   */
  name?: string | undefined;
  nodeVersion?: UpdateProjectNodeVersion | undefined;
  /**
   * The output directory of the project. When `null` is used this value will be automatically detected
   */
  outputDirectory?: string | null | undefined;
  /**
   * Specifies whether preview deployments are disabled for this project.
   */
  previewDeploymentsDisabled?: boolean | null | undefined;
  /**
   * Specifies whether the source code and logs of the deployments for this project should be public or not
   */
  publicSource?: boolean | null | undefined;
  /**
   * The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root
   */
  rootDirectory?: string | null | undefined;
  /**
   * The region to deploy Serverless Functions in this project
   */
  serverlessFunctionRegion?: string | null | undefined;
  /**
   * Specifies whether Zero Config Failover is enabled for this project.
   */
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  /**
   * Deployments created before this absolute datetime have Skew Protection disabled. Value is in milliseconds since epoch to match \"createdAt\" fields.
   */
  skewProtectionBoundaryAt?: number | undefined;
  /**
   * Deployments created before this rolling window have Skew Protection disabled. Value is in seconds to match \"revalidate\" fields.
   */
  skewProtectionMaxAge?: number | undefined;
  /**
   * Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`.
   *
   * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
   */
  skipGitConnectDuringLink?: boolean | undefined;
  /**
   * Indicates if there are source files outside of the root directory
   */
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  /**
   * Opt-in to preview toolbar on the project level
   */
  enablePreviewFeedback?: boolean | null | undefined;
  /**
   * Opt-in to production toolbar on the project level
   */
  enableProductionFeedback?: boolean | null | undefined;
  /**
   * Opt-in to skip deployments when there are no changes to the root directory and its dependencies
   */
  enableAffectedProjectsDeployments?: boolean | undefined;
  /**
   * OpenID Connect JSON Web Token generation configuration.
   */
  oidcTokenConfig?: UpdateProjectOidcTokenConfig | undefined;
  /**
   * Allows to protect project deployments with a password
   */
  passwordProtection?: PasswordProtection | null | undefined;
  /**
   * Ensures visitors to your Preview Deployments are logged into Vercel and have a minimum of Viewer access on your team
   */
  ssoProtection?: SsoProtection | null | undefined;
  /**
   * Restricts access to deployments based on the incoming request IP address
   */
  trustedIps?: TrustedIps | null | undefined;
  /**
   * Specify a list of paths that should not be protected by Deployment Protection to enable Cors preflight requests
   */
  optionsAllowlist?: OptionsAllowlist | null | undefined;
};

export type UpdateProjectRequest = {
  /**
   * The unique project identifier or the project name
   */
  idOrName: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: UpdateProjectRequestBody | undefined;
};

export type UpdateProjectAnalytics = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

export type UpdateProjectSpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type UpdateProjectDefinitions = {
  /**
   * The hostname that should be used.
   */
  host: string;
  /**
   * The path that should be called for the cronjob.
   */
  path: string;
  /**
   * The cron expression.
   */
  schedule: string;
};

export type UpdateProjectCrons = {
  /**
   * The time the feature was enabled for this project. Note: It enables automatically with the first Deployment that outputs cronjobs.
   */
  enabledAt: number;
  /**
   * The time the feature was disabled for this project.
   */
  disabledAt: number | null;
  updatedAt: number;
  /**
   * The ID of the Deployment from which the definitions originated.
   */
  deploymentId: string | null;
  definitions: Array<UpdateProjectDefinitions>;
};

export type UpdateProjectDataCache = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

export type UpdateProjectDeploymentExpiration = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

export const UpdateProjectTarget2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type UpdateProjectTarget2 = ClosedEnum<typeof UpdateProjectTarget2>;

export type UpdateProjectTarget = Array<string> | UpdateProjectTarget2;

export const UpdateProjectType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
export type UpdateProjectType = ClosedEnum<typeof UpdateProjectType>;

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  >;

export type UpdateProjectContentHint15 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type;
  projectId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  >;

export type UpdateProjectContentHint14 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  >;

export type UpdateProjectContentHint13 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  >;

export type UpdateProjectContentHint12 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  >;

export type UpdateProjectContentHint11 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  >;

export type UpdateProjectContentHint10 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  >;

export type UpdateProjectContentHint9 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type
  >;

export type UpdateProjectContentHint8 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  >;

export type UpdateProjectContentHint7 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type UpdateProjectContentHint6 = {
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200ApplicationJSONType = {
  BlobReadWriteToken: "blob-read-write-token",
} as const;
export type UpdateProjectContentHintProjectsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONType
  >;

export type UpdateProjectContentHint5 = {
  type: UpdateProjectContentHintProjectsResponse200ApplicationJSONType;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponse200Type = {
  RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
} as const;
export type UpdateProjectContentHintProjectsResponse200Type = ClosedEnum<
  typeof UpdateProjectContentHintProjectsResponse200Type
>;

export type UpdateProjectContentHint4 = {
  type: UpdateProjectContentHintProjectsResponse200Type;
  storeId: string;
};

export const UpdateProjectContentHintProjectsResponseType = {
  RedisRestApiToken: "redis-rest-api-token",
} as const;
export type UpdateProjectContentHintProjectsResponseType = ClosedEnum<
  typeof UpdateProjectContentHintProjectsResponseType
>;

export type UpdateProjectContentHint3 = {
  type: UpdateProjectContentHintProjectsResponseType;
  storeId: string;
};

export const UpdateProjectContentHintProjectsType = {
  RedisRestApiUrl: "redis-rest-api-url",
} as const;
export type UpdateProjectContentHintProjectsType = ClosedEnum<
  typeof UpdateProjectContentHintProjectsType
>;

export type UpdateProjectContentHint2 = {
  type: UpdateProjectContentHintProjectsType;
  storeId: string;
};

export const UpdateProjectContentHintType = {
  RedisUrl: "redis-url",
} as const;
export type UpdateProjectContentHintType = ClosedEnum<
  typeof UpdateProjectContentHintType
>;

export type UpdateProjectContentHint1 = {
  type: UpdateProjectContentHintType;
  storeId: string;
};

export type UpdateProjectContentHint =
  | UpdateProjectContentHint1
  | UpdateProjectContentHint2
  | UpdateProjectContentHint3
  | UpdateProjectContentHint4
  | UpdateProjectContentHint5
  | UpdateProjectContentHint6
  | UpdateProjectContentHint7
  | UpdateProjectContentHint8
  | UpdateProjectContentHint9
  | UpdateProjectContentHint10
  | UpdateProjectContentHint11
  | UpdateProjectContentHint12
  | UpdateProjectContentHint13
  | UpdateProjectContentHint15
  | UpdateProjectContentHint14;

export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType =
  {
    FlagsSecret: "flags-secret",
  } as const;
export type UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType =
  ClosedEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType
  >;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type UpdateProjectInternalContentHint = {
  type: UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type UpdateProjectEnv = {
  target?: Array<string> | UpdateProjectTarget2 | undefined;
  type: UpdateProjectType;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | UpdateProjectContentHint1
    | UpdateProjectContentHint2
    | UpdateProjectContentHint3
    | UpdateProjectContentHint4
    | UpdateProjectContentHint5
    | UpdateProjectContentHint6
    | UpdateProjectContentHint7
    | UpdateProjectContentHint8
    | UpdateProjectContentHint9
    | UpdateProjectContentHint10
    | UpdateProjectContentHint11
    | UpdateProjectContentHint12
    | UpdateProjectContentHint13
    | UpdateProjectContentHint15
    | UpdateProjectContentHint14
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?: UpdateProjectInternalContentHint | null | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

export type UpdateProjectCustomEnvironments = {};

export const UpdateProjectProjectsFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type UpdateProjectProjectsFramework = ClosedEnum<
  typeof UpdateProjectProjectsFramework
>;

export type UpdateProjectIpBuckets = {
  bucket: string;
  supportUntil?: number | undefined;
};

export type UpdateProjectAliasAssigned = number | boolean;

export type UpdateProjectAliasError = {
  code: string;
  message: string;
};

export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType = {
  EndsWith: "endsWith",
  StartsWith: "startsWith",
  Equals: "equals",
} as const;
export type UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type UpdateProjectBranchMatcher = {
  type: UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType;
  pattern: string;
};

export type UpdateProjectBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const UpdateProjectChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type UpdateProjectChecksConclusion = ClosedEnum<
  typeof UpdateProjectChecksConclusion
>;

export const UpdateProjectChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type UpdateProjectChecksState = ClosedEnum<
  typeof UpdateProjectChecksState
>;

export type UpdateProjectCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type UpdateProjectOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const UpdateProjectPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type UpdateProjectPlan = ClosedEnum<typeof UpdateProjectPlan>;

export const UpdateProjectReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type UpdateProjectReadyState = ClosedEnum<
  typeof UpdateProjectReadyState
>;

export const UpdateProjectReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type UpdateProjectReadySubstate = ClosedEnum<
  typeof UpdateProjectReadySubstate
>;

export const UpdateProjectProjectsType = {
  Lambdas: "LAMBDAS",
} as const;
export type UpdateProjectProjectsType = ClosedEnum<
  typeof UpdateProjectProjectsType
>;

export type UpdateProjectLatestDeployments = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: UpdateProjectBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectBuilds> | undefined;
  checksConclusion?: UpdateProjectChecksConclusion | undefined;
  checksState?: UpdateProjectChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectOidcTokenClaims | undefined;
  plan: UpdateProjectPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: UpdateProjectReadyState;
  readySubstate?: UpdateProjectReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: UpdateProjectProjectsType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export const UpdateProjectLinkProjectsResponseType = {
  Bitbucket: "bitbucket",
} as const;
export type UpdateProjectLinkProjectsResponseType = ClosedEnum<
  typeof UpdateProjectLinkProjectsResponseType
>;

export type UpdateProjectLinkProjectsResponseDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type UpdateProjectLink3 = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: UpdateProjectLinkProjectsResponseType | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectLinkProjectsResponseDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const UpdateProjectLinkProjectsType = {
  Gitlab: "gitlab",
} as const;
export type UpdateProjectLinkProjectsType = ClosedEnum<
  typeof UpdateProjectLinkProjectsType
>;

export type UpdateProjectLinkProjectsDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type UpdateProjectLink2 = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes. This is the id of the top level group that a namespace belongs to. Gitlab supports group nesting (up to 20 levels).
   */
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: UpdateProjectLinkProjectsType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectLinkProjectsDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const UpdateProjectLinkType = {
  Github: "github",
} as const;
export type UpdateProjectLinkType = ClosedEnum<typeof UpdateProjectLinkType>;

export type UpdateProjectLinkDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type UpdateProjectLink1 = {
  org?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes.
   */
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: UpdateProjectLinkType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectLinkDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export type UpdateProjectLink =
  | UpdateProjectLink1
  | UpdateProjectLink3
  | UpdateProjectLink2;

/**
 * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
 */
export type UpdateProjectGroup = {
  /**
   * A unique identifier for the group of microfrontends. All related microfrontend projects will share this group ID. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
   */
  id: string;
  /**
   * A human readable name for the microfrontends group. This will be used to display the microfrontends group in the UI.
   */
  slug: string;
};

export type UpdateProjectMicrofrontends = {
  /**
   * Timestamp when the microfrontends settings were last updated.
   */
  updatedAt: number;
  /**
   * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
   */
  group: UpdateProjectGroup;
  /**
   * Whether microfrontends are enabled for this project.
   */
  enabled: boolean;
  /**
   * Whether this project is the default application for the microfrontends group. The default application is the one that is used as the top level shell for the microfrontends group and hosts the other microfrontends.
   */
  isDefaultApp?: boolean | undefined;
  /**
   * A path that is used to take screenshots and as the default path in preview links when a domain for this microfrontend is shown in the UI.
   */
  defaultRoute?: string | undefined;
};

export const UpdateProjectProjectsNodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
  Eight10X: "8.10.x",
} as const;
export type UpdateProjectProjectsNodeVersion = ClosedEnum<
  typeof UpdateProjectProjectsNodeVersion
>;

export type UpdateProjectPaths = {
  value: string;
};

export type UpdateProjectOptionsAllowlist = {
  paths: Array<UpdateProjectPaths>;
};

export type UpdateProjectPasswordProtection = {};

export const UpdateProjectFunctionDefaultMemoryType = {
  StandardLegacy: "standard_legacy",
  Standard: "standard",
  Performance: "performance",
} as const;
export type UpdateProjectFunctionDefaultMemoryType = ClosedEnum<
  typeof UpdateProjectFunctionDefaultMemoryType
>;

export type UpdateProjectResourceConfig = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?:
    | UpdateProjectFunctionDefaultMemoryType
    | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

export const UpdateProjectProjectsResponseDeploymentType = {
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type UpdateProjectProjectsResponseDeploymentType = ClosedEnum<
  typeof UpdateProjectProjectsResponseDeploymentType
>;

export type UpdateProjectSsoProtection = {
  deploymentType: UpdateProjectProjectsResponseDeploymentType;
};

export type UpdateProjectProjectsAliasAssigned = number | boolean;

export type UpdateProjectProjectsAliasError = {
  code: string;
  message: string;
};

export const UpdateProjectProjectsResponse200ApplicationJSONType = {
  EndsWith: "endsWith",
  StartsWith: "startsWith",
  Equals: "equals",
} as const;
export type UpdateProjectProjectsResponse200ApplicationJSONType = ClosedEnum<
  typeof UpdateProjectProjectsResponse200ApplicationJSONType
>;

export type UpdateProjectProjectsBranchMatcher = {
  type: UpdateProjectProjectsResponse200ApplicationJSONType;
  pattern: string;
};

export type UpdateProjectProjectsBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const UpdateProjectProjectsChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type UpdateProjectProjectsChecksConclusion = ClosedEnum<
  typeof UpdateProjectProjectsChecksConclusion
>;

export const UpdateProjectProjectsChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type UpdateProjectProjectsChecksState = ClosedEnum<
  typeof UpdateProjectProjectsChecksState
>;

export type UpdateProjectProjectsCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type UpdateProjectProjectsOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const UpdateProjectProjectsPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type UpdateProjectProjectsPlan = ClosedEnum<
  typeof UpdateProjectProjectsPlan
>;

export const UpdateProjectProjectsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type UpdateProjectProjectsReadyState = ClosedEnum<
  typeof UpdateProjectProjectsReadyState
>;

export const UpdateProjectProjectsReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type UpdateProjectProjectsReadySubstate = ClosedEnum<
  typeof UpdateProjectProjectsReadySubstate
>;

export const UpdateProjectProjectsResponseType = {
  Lambdas: "LAMBDAS",
} as const;
export type UpdateProjectProjectsResponseType = ClosedEnum<
  typeof UpdateProjectProjectsResponseType
>;

export type UpdateProjectTargets = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectProjectsAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: UpdateProjectProjectsBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectProjectsBuilds> | undefined;
  checksConclusion?: UpdateProjectProjectsChecksConclusion | undefined;
  checksState?: UpdateProjectProjectsChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectProjectsCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectProjectsOidcTokenClaims | undefined;
  plan: UpdateProjectProjectsPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: UpdateProjectProjectsReadyState;
  readySubstate?: UpdateProjectProjectsReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: UpdateProjectProjectsResponseType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export type UpdateProjectPermissions = {
  accessGroup?: Array<ACLAction> | undefined;
  aliasGlobal?: Array<ACLAction> | undefined;
  analyticsSampling?: Array<ACLAction> | undefined;
  analyticsUsage?: Array<ACLAction> | undefined;
  auditLog?: Array<ACLAction> | undefined;
  billingAddress?: Array<ACLAction> | undefined;
  billingInformation?: Array<ACLAction> | undefined;
  billingInvoice?: Array<ACLAction> | undefined;
  billingInvoiceEmailRecipient?: Array<ACLAction> | undefined;
  billingInvoiceLanguage?: Array<ACLAction> | undefined;
  billingPlan?: Array<ACLAction> | undefined;
  billingPurchaseOrder?: Array<ACLAction> | undefined;
  billingTaxId?: Array<ACLAction> | undefined;
  blob?: Array<ACLAction> | undefined;
  budget?: Array<ACLAction> | undefined;
  cacheArtifact?: Array<ACLAction> | undefined;
  cacheArtifactUsageEvent?: Array<ACLAction> | undefined;
  codeChecks?: Array<ACLAction> | undefined;
  concurrentBuilds?: Array<ACLAction> | undefined;
  connect?: Array<ACLAction> | undefined;
  connectConfiguration?: Array<ACLAction> | undefined;
  domain?: Array<ACLAction> | undefined;
  domainAcceptDelegation?: Array<ACLAction> | undefined;
  domainAuthCodes?: Array<ACLAction> | undefined;
  domainCertificate?: Array<ACLAction> | undefined;
  domainCheckConfig?: Array<ACLAction> | undefined;
  domainMove?: Array<ACLAction> | undefined;
  domainPurchase?: Array<ACLAction> | undefined;
  domainRecord?: Array<ACLAction> | undefined;
  domainTransferIn?: Array<ACLAction> | undefined;
  event?: Array<ACLAction> | undefined;
  ownEvent?: Array<ACLAction> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<ACLAction> | undefined;
  fileUpload?: Array<ACLAction> | undefined;
  gitRepository?: Array<ACLAction> | undefined;
  ipBlocking?: Array<ACLAction> | undefined;
  integration?: Array<ACLAction> | undefined;
  integrationAccount?: Array<ACLAction> | undefined;
  integrationConfiguration?: Array<ACLAction> | undefined;
  integrationConfigurationTransfer?: Array<ACLAction> | undefined;
  integrationConfigurationProjects?: Array<ACLAction> | undefined;
  integrationVercelConfigurationOverride?: Array<ACLAction> | undefined;
  integrationConfigurationRole?: Array<ACLAction> | undefined;
  integrationResource?: Array<ACLAction> | undefined;
  integrationEvent?: Array<ACLAction> | undefined;
  integrationResourceSecrets?: Array<ACLAction> | undefined;
  integrationDeploymentAction?: Array<ACLAction> | undefined;
  marketplaceInstallationMember?: Array<ACLAction> | undefined;
  marketplaceBillingData?: Array<ACLAction> | undefined;
  marketplaceInvoice?: Array<ACLAction> | undefined;
  jobGlobal?: Array<ACLAction> | undefined;
  logDrain?: Array<ACLAction> | undefined;
  monitoring?: Array<ACLAction> | undefined;
  monitoringSettings?: Array<ACLAction> | undefined;
  monitoringQuery?: Array<ACLAction> | undefined;
  monitoringChart?: Array<ACLAction> | undefined;
  monitoringAlert?: Array<ACLAction> | undefined;
  notificationDeploymentFailed?: Array<ACLAction> | undefined;
  notificationDomainConfiguration?: Array<ACLAction> | undefined;
  notificationDomainExpire?: Array<ACLAction> | undefined;
  notificationDomainMoved?: Array<ACLAction> | undefined;
  notificationDomainPurchase?: Array<ACLAction> | undefined;
  notificationDomainRenewal?: Array<ACLAction> | undefined;
  notificationDomainTransfer?: Array<ACLAction> | undefined;
  notificationDomainUnverified?: Array<ACLAction> | undefined;
  notificationMonitoringAlert?: Array<ACLAction> | undefined;
  notificationPaymentFailed?: Array<ACLAction> | undefined;
  notificationUsageAlert?: Array<ACLAction> | undefined;
  notificationCustomerBudget?: Array<ACLAction> | undefined;
  notificationStatementOfReasons?: Array<ACLAction> | undefined;
  oauth2Connection?: Array<ACLAction> | undefined;
  openTelemetryEndpoint?: Array<ACLAction> | undefined;
  paymentMethod?: Array<ACLAction> | undefined;
  permissions?: Array<ACLAction> | undefined;
  postgres?: Array<ACLAction> | undefined;
  previewDeploymentSuffix?: Array<ACLAction> | undefined;
  proTrialOnboarding?: Array<ACLAction> | undefined;
  sharedEnvVars?: Array<ACLAction> | undefined;
  sharedEnvVarsProduction?: Array<ACLAction> | undefined;
  space?: Array<ACLAction> | undefined;
  spaceRun?: Array<ACLAction> | undefined;
  passwordProtectionInvoiceItem?: Array<ACLAction> | undefined;
  rateLimit?: Array<ACLAction> | undefined;
  redis?: Array<ACLAction> | undefined;
  repository?: Array<ACLAction> | undefined;
  remoteCaching?: Array<ACLAction> | undefined;
  samlConfig?: Array<ACLAction> | undefined;
  secret?: Array<ACLAction> | undefined;
  redisStoreTokenSet?: Array<ACLAction> | undefined;
  blobStoreTokenSet?: Array<ACLAction> | undefined;
  postgresStoreTokenSet?: Array<ACLAction> | undefined;
  integrationStoreTokenSet?: Array<ACLAction> | undefined;
  integrationResourceReplCommand?: Array<ACLAction> | undefined;
  storeTransfer?: Array<ACLAction> | undefined;
  supportCase?: Array<ACLAction> | undefined;
  supportCaseComment?: Array<ACLAction> | undefined;
  dataCacheBillingSettings?: Array<ACLAction> | undefined;
  team?: Array<ACLAction> | undefined;
  teamAccessRequest?: Array<ACLAction> | undefined;
  teamFellowMembership?: Array<ACLAction> | undefined;
  teamGitExclusivity?: Array<ACLAction> | undefined;
  teamInvite?: Array<ACLAction> | undefined;
  teamInviteCode?: Array<ACLAction> | undefined;
  teamJoin?: Array<ACLAction> | undefined;
  teamOwnMembership?: Array<ACLAction> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<ACLAction> | undefined;
  token?: Array<ACLAction> | undefined;
  usage?: Array<ACLAction> | undefined;
  usageCycle?: Array<ACLAction> | undefined;
  user?: Array<ACLAction> | undefined;
  userConnection?: Array<ACLAction> | undefined;
  vpcPeeringConnection?: Array<ACLAction> | undefined;
  webAnalyticsPlan?: Array<ACLAction> | undefined;
  webAuthn?: Array<ACLAction> | undefined;
  edgeConfig?: Array<ACLAction> | undefined;
  edgeConfigItem?: Array<ACLAction> | undefined;
  edgeConfigSchema?: Array<ACLAction> | undefined;
  edgeConfigToken?: Array<ACLAction> | undefined;
  webhook?: Array<ACLAction> | undefined;
  webhookEvent?: Array<ACLAction> | undefined;
  endpointVerification?: Array<ACLAction> | undefined;
  projectTransferIn?: Array<ACLAction> | undefined;
  oauth2Application?: Array<ACLAction> | undefined;
  aliasProject?: Array<ACLAction> | undefined;
  aliasProtectionBypass?: Array<ACLAction> | undefined;
  productionAliasProtectionBypass?: Array<ACLAction> | undefined;
  connectConfigurationLink?: Array<ACLAction> | undefined;
  dataCacheNamespace?: Array<ACLAction> | undefined;
  deployment?: Array<ACLAction> | undefined;
  deploymentCheck?: Array<ACLAction> | undefined;
  deploymentCheckPreview?: Array<ACLAction> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<ACLAction> | undefined;
  deploymentProductionGit?: Array<ACLAction> | undefined;
  deploymentPreview?: Array<ACLAction> | undefined;
  deploymentPrivate?: Array<ACLAction> | undefined;
  deploymentPromote?: Array<ACLAction> | undefined;
  deploymentRollback?: Array<ACLAction> | undefined;
  environments?: Array<ACLAction> | undefined;
  logs?: Array<ACLAction> | undefined;
  logsPreset?: Array<ACLAction> | undefined;
  passwordProtection?: Array<ACLAction> | undefined;
  optionsAllowlist?: Array<ACLAction> | undefined;
  job?: Array<ACLAction> | undefined;
  project?: Array<ACLAction> | undefined;
  projectAccessGroup?: Array<ACLAction> | undefined;
  projectAnalyticsSampling?: Array<ACLAction> | undefined;
  projectDeploymentHook?: Array<ACLAction> | undefined;
  projectDomain?: Array<ACLAction> | undefined;
  projectDomainMove?: Array<ACLAction> | undefined;
  projectDomainCheckConfig?: Array<ACLAction> | undefined;
  projectEnvVars?: Array<ACLAction> | undefined;
  projectEnvVarsProduction?: Array<ACLAction> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<ACLAction> | undefined;
  projectFlags?: Array<ACLAction> | undefined;
  projectId?: Array<ACLAction> | undefined;
  projectIntegrationConfiguration?: Array<ACLAction> | undefined;
  projectLink?: Array<ACLAction> | undefined;
  projectMember?: Array<ACLAction> | undefined;
  projectMonitoring?: Array<ACLAction> | undefined;
  projectPermissions?: Array<ACLAction> | undefined;
  projectProductionBranch?: Array<ACLAction> | undefined;
  projectTransfer?: Array<ACLAction> | undefined;
  projectTransferOut?: Array<ACLAction> | undefined;
  projectProtectionBypass?: Array<ACLAction> | undefined;
  projectUsage?: Array<ACLAction> | undefined;
  projectAnalyticsUsage?: Array<ACLAction> | undefined;
  projectSupportCase?: Array<ACLAction> | undefined;
  projectSupportCaseComment?: Array<ACLAction> | undefined;
  projectDeploymentExpiration?: Array<ACLAction> | undefined;
  projectTier?: Array<ACLAction> | undefined;
  seawallConfig?: Array<ACLAction> | undefined;
  skewProtection?: Array<ACLAction> | undefined;
  analytics?: Array<ACLAction> | undefined;
  trustedIps?: Array<ACLAction> | undefined;
  webAnalytics?: Array<ACLAction> | undefined;
  sharedEnvVarConnection?: Array<ACLAction> | undefined;
  sonar?: Array<ACLAction> | undefined;
};

export type UpdateProjectLastRollbackTarget = {};

export const UpdateProjectJobStatus = {
  Pending: "pending",
  InProgress: "in-progress",
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
} as const;
export type UpdateProjectJobStatus = ClosedEnum<typeof UpdateProjectJobStatus>;

export const UpdateProjectProjectsResponse200Type = {
  Promote: "promote",
  Rollback: "rollback",
} as const;
export type UpdateProjectProjectsResponse200Type = ClosedEnum<
  typeof UpdateProjectProjectsResponse200Type
>;

export type UpdateProjectLastAliasRequest = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: UpdateProjectJobStatus;
  requestedAt: number;
  type: UpdateProjectProjectsResponse200Type;
};

export const UpdateProjectScope = {
  AutomationBypass: "automation-bypass",
} as const;
export type UpdateProjectScope = ClosedEnum<typeof UpdateProjectScope>;

export type UpdateProjectProtectionBypass = {
  createdAt: number;
  createdBy: string;
  scope: UpdateProjectScope;
};

export const UpdateProjectTrustedIpsProjectsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type UpdateProjectTrustedIpsProjectsDeploymentType = ClosedEnum<
  typeof UpdateProjectTrustedIpsProjectsDeploymentType
>;

export type UpdateProjectTrustedIps2 = {
  deploymentType: UpdateProjectTrustedIpsProjectsDeploymentType;
};

export const UpdateProjectTrustedIpsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type UpdateProjectTrustedIpsDeploymentType = ClosedEnum<
  typeof UpdateProjectTrustedIpsDeploymentType
>;

export type UpdateProjectTrustedIpsAddresses = {
  value: string;
  note?: string | undefined;
};

export const UpdateProjectTrustedIpsProtectionMode = {
  Additional: "additional",
  Exclusive: "exclusive",
} as const;
export type UpdateProjectTrustedIpsProtectionMode = ClosedEnum<
  typeof UpdateProjectTrustedIpsProtectionMode
>;

export type UpdateProjectTrustedIps1 = {
  deploymentType: UpdateProjectTrustedIpsDeploymentType;
  addresses: Array<UpdateProjectTrustedIpsAddresses>;
  protectionMode: UpdateProjectTrustedIpsProtectionMode;
};

export type UpdateProjectTrustedIps =
  | UpdateProjectTrustedIps2
  | UpdateProjectTrustedIps1;

export type UpdateProjectGitComments = {
  /**
   * Whether the Vercel bot should comment on PRs
   */
  onPullRequest: boolean;
  /**
   * Whether the Vercel bot should comment on commits
   */
  onCommit: boolean;
};

export type UpdateProjectWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type UpdateProjectSrc2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type UpdateProjectSrc = UpdateProjectSrc2 | string;

export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType =
  ClosedEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType
  >;

export type UpdateProjectValue2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type UpdateProjectValue = UpdateProjectValue2 | string;

export type UpdateProjectHas = {
  type: UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType;
  key?: string | undefined;
  value?: UpdateProjectValue2 | string | undefined;
};

export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType =
  ClosedEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  >;

export type UpdateProjectValueProjects2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type UpdateProjectProjectsValue = UpdateProjectValueProjects2 | string;

export type UpdateProjectMissing = {
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType;
  key?: string | undefined;
  value?: UpdateProjectValueProjects2 | string | undefined;
};

export const UpdateProjectHandle = {
  Init: "init",
  Finalize: "finalize",
} as const;
export type UpdateProjectHandle = ClosedEnum<typeof UpdateProjectHandle>;

export const UpdateProjectAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type UpdateProjectAction = ClosedEnum<typeof UpdateProjectAction>;

export const UpdateProjectAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type UpdateProjectAlgo = ClosedEnum<typeof UpdateProjectAlgo>;

export type UpdateProjectErl = {
  algo: UpdateProjectAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
};

export type UpdateProjectMitigate = {
  action: UpdateProjectAction;
  ruleId: string;
  ttl?: number | undefined;
  erl?: UpdateProjectErl | undefined;
};

export type UpdateProjectFirewallRoutes = {
  src?: UpdateProjectSrc2 | string | undefined;
  has?: Array<UpdateProjectHas> | undefined;
  missing?: Array<UpdateProjectMissing> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: UpdateProjectHandle | undefined;
  mitigate?: UpdateProjectMitigate | undefined;
};

export type UpdateProjectSecurity = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<UpdateProjectFirewallRoutes> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export const UpdateProjectProjectsIssuerMode = {
  Team: "team",
  Global: "global",
} as const;
/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export type UpdateProjectProjectsIssuerMode = ClosedEnum<
  typeof UpdateProjectProjectsIssuerMode
>;

export type UpdateProjectProjectsOidcTokenConfig = {
  enabled: boolean;
  /**
   * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
   */
  issuerMode?: UpdateProjectProjectsIssuerMode | undefined;
};

export const UpdateProjectTier = {
  Standard: "standard",
  Advanced: "advanced",
  Critical: "critical",
} as const;
export type UpdateProjectTier = ClosedEnum<typeof UpdateProjectTier>;

/**
 * The project was successfully updated
 */
export type UpdateProjectResponseBody = {
  accountId: string;
  analytics?: UpdateProjectAnalytics | undefined;
  speedInsights?: UpdateProjectSpeedInsights | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: UpdateProjectCrons | undefined;
  dataCache?: UpdateProjectDataCache | undefined;
  deploymentExpiration?: UpdateProjectDeploymentExpiration | null | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<UpdateProjectEnv> | undefined;
  customEnvironments?: Array<UpdateProjectCustomEnvironments> | undefined;
  framework?: UpdateProjectProjectsFramework | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<UpdateProjectIpBuckets> | undefined;
  latestDeployments?: Array<UpdateProjectLatestDeployments> | undefined;
  link?:
    | UpdateProjectLink1
    | UpdateProjectLink3
    | UpdateProjectLink2
    | undefined;
  microfrontends?: UpdateProjectMicrofrontends | undefined;
  name: string;
  nodeVersion: UpdateProjectProjectsNodeVersion;
  optionsAllowlist?: UpdateProjectOptionsAllowlist | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?: UpdateProjectPasswordProtection | null | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: UpdateProjectResourceConfig | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: UpdateProjectSsoProtection | null | undefined;
  targets?: { [k: string]: UpdateProjectTargets } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: UpdateProjectPermissions | undefined;
  lastRollbackTarget?: UpdateProjectLastRollbackTarget | null | undefined;
  lastAliasRequest?: UpdateProjectLastAliasRequest | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?: { [k: string]: UpdateProjectProtectionBypass } | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?:
    | UpdateProjectTrustedIps2
    | UpdateProjectTrustedIps1
    | null
    | undefined;
  gitComments?: UpdateProjectGitComments | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: UpdateProjectWebAnalytics | undefined;
  security?: UpdateProjectSecurity | undefined;
  oidcTokenConfig?: UpdateProjectProjectsOidcTokenConfig | undefined;
  tier?: UpdateProjectTier | undefined;
};

/** @internal */
export const UpdateProjectFramework$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectFramework
> = z.nativeEnum(UpdateProjectFramework);

/** @internal */
export const UpdateProjectFramework$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectFramework
> = UpdateProjectFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectFramework$ {
  /** @deprecated use `UpdateProjectFramework$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectFramework$inboundSchema;
  /** @deprecated use `UpdateProjectFramework$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectFramework$outboundSchema;
}

/** @internal */
export const UpdateProjectNodeVersion$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectNodeVersion
> = z.nativeEnum(UpdateProjectNodeVersion);

/** @internal */
export const UpdateProjectNodeVersion$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectNodeVersion
> = UpdateProjectNodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectNodeVersion$ {
  /** @deprecated use `UpdateProjectNodeVersion$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectNodeVersion$inboundSchema;
  /** @deprecated use `UpdateProjectNodeVersion$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectNodeVersion$outboundSchema;
}

/** @internal */
export const UpdateProjectIssuerMode$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectIssuerMode
> = z.nativeEnum(UpdateProjectIssuerMode);

/** @internal */
export const UpdateProjectIssuerMode$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectIssuerMode
> = UpdateProjectIssuerMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectIssuerMode$ {
  /** @deprecated use `UpdateProjectIssuerMode$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectIssuerMode$inboundSchema;
  /** @deprecated use `UpdateProjectIssuerMode$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectIssuerMode$outboundSchema;
}

/** @internal */
export const UpdateProjectOidcTokenConfig$inboundSchema: z.ZodType<
  UpdateProjectOidcTokenConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean(),
  issuerMode: UpdateProjectIssuerMode$inboundSchema.default("global"),
});

/** @internal */
export type UpdateProjectOidcTokenConfig$Outbound = {
  enabled: boolean;
  issuerMode: string;
};

/** @internal */
export const UpdateProjectOidcTokenConfig$outboundSchema: z.ZodType<
  UpdateProjectOidcTokenConfig$Outbound,
  z.ZodTypeDef,
  UpdateProjectOidcTokenConfig
> = z.object({
  enabled: z.boolean(),
  issuerMode: UpdateProjectIssuerMode$outboundSchema.default("global"),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectOidcTokenConfig$ {
  /** @deprecated use `UpdateProjectOidcTokenConfig$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectOidcTokenConfig$inboundSchema;
  /** @deprecated use `UpdateProjectOidcTokenConfig$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectOidcTokenConfig$outboundSchema;
  /** @deprecated use `UpdateProjectOidcTokenConfig$Outbound` instead. */
  export type Outbound = UpdateProjectOidcTokenConfig$Outbound;
}

/** @internal */
export const DeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof DeploymentType
> = z.nativeEnum(DeploymentType);

/** @internal */
export const DeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof DeploymentType
> = DeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeploymentType$ {
  /** @deprecated use `DeploymentType$inboundSchema` instead. */
  export const inboundSchema = DeploymentType$inboundSchema;
  /** @deprecated use `DeploymentType$outboundSchema` instead. */
  export const outboundSchema = DeploymentType$outboundSchema;
}

/** @internal */
export const PasswordProtection$inboundSchema: z.ZodType<
  PasswordProtection,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: DeploymentType$inboundSchema,
  password: z.nullable(z.string()).optional(),
});

/** @internal */
export type PasswordProtection$Outbound = {
  deploymentType: string;
  password?: string | null | undefined;
};

/** @internal */
export const PasswordProtection$outboundSchema: z.ZodType<
  PasswordProtection$Outbound,
  z.ZodTypeDef,
  PasswordProtection
> = z.object({
  deploymentType: DeploymentType$outboundSchema,
  password: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PasswordProtection$ {
  /** @deprecated use `PasswordProtection$inboundSchema` instead. */
  export const inboundSchema = PasswordProtection$inboundSchema;
  /** @deprecated use `PasswordProtection$outboundSchema` instead. */
  export const outboundSchema = PasswordProtection$outboundSchema;
  /** @deprecated use `PasswordProtection$Outbound` instead. */
  export type Outbound = PasswordProtection$Outbound;
}

/** @internal */
export const UpdateProjectDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDeploymentType
> = z.nativeEnum(UpdateProjectDeploymentType);

/** @internal */
export const UpdateProjectDeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectDeploymentType
> = UpdateProjectDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDeploymentType$ {
  /** @deprecated use `UpdateProjectDeploymentType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectDeploymentType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDeploymentType$outboundSchema;
}

/** @internal */
export const SsoProtection$inboundSchema: z.ZodType<
  SsoProtection,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectDeploymentType$inboundSchema.default("preview"),
});

/** @internal */
export type SsoProtection$Outbound = {
  deploymentType: string;
};

/** @internal */
export const SsoProtection$outboundSchema: z.ZodType<
  SsoProtection$Outbound,
  z.ZodTypeDef,
  SsoProtection
> = z.object({
  deploymentType: UpdateProjectDeploymentType$outboundSchema.default("preview"),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace SsoProtection$ {
  /** @deprecated use `SsoProtection$inboundSchema` instead. */
  export const inboundSchema = SsoProtection$inboundSchema;
  /** @deprecated use `SsoProtection$outboundSchema` instead. */
  export const outboundSchema = SsoProtection$outboundSchema;
  /** @deprecated use `SsoProtection$Outbound` instead. */
  export type Outbound = SsoProtection$Outbound;
}

/** @internal */
export const UpdateProjectProjectsDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsDeploymentType
> = z.nativeEnum(UpdateProjectProjectsDeploymentType);

/** @internal */
export const UpdateProjectProjectsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsDeploymentType> =
    UpdateProjectProjectsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsDeploymentType$ {
  /** @deprecated use `UpdateProjectProjectsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsDeploymentType$outboundSchema;
}

/** @internal */
export const Addresses$inboundSchema: z.ZodType<
  Addresses,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/** @internal */
export type Addresses$Outbound = {
  value: string;
  note?: string | undefined;
};

/** @internal */
export const Addresses$outboundSchema: z.ZodType<
  Addresses$Outbound,
  z.ZodTypeDef,
  Addresses
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Addresses$ {
  /** @deprecated use `Addresses$inboundSchema` instead. */
  export const inboundSchema = Addresses$inboundSchema;
  /** @deprecated use `Addresses$outboundSchema` instead. */
  export const outboundSchema = Addresses$outboundSchema;
  /** @deprecated use `Addresses$Outbound` instead. */
  export type Outbound = Addresses$Outbound;
}

/** @internal */
export const ProtectionMode$inboundSchema: z.ZodNativeEnum<
  typeof ProtectionMode
> = z.nativeEnum(ProtectionMode);

/** @internal */
export const ProtectionMode$outboundSchema: z.ZodNativeEnum<
  typeof ProtectionMode
> = ProtectionMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionMode$ {
  /** @deprecated use `ProtectionMode$inboundSchema` instead. */
  export const inboundSchema = ProtectionMode$inboundSchema;
  /** @deprecated use `ProtectionMode$outboundSchema` instead. */
  export const outboundSchema = ProtectionMode$outboundSchema;
}

/** @internal */
export const TrustedIps$inboundSchema: z.ZodType<
  TrustedIps,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectProjectsDeploymentType$inboundSchema,
  addresses: z.array(z.lazy(() => Addresses$inboundSchema)),
  protectionMode: ProtectionMode$inboundSchema,
});

/** @internal */
export type TrustedIps$Outbound = {
  deploymentType: string;
  addresses: Array<Addresses$Outbound>;
  protectionMode: string;
};

/** @internal */
export const TrustedIps$outboundSchema: z.ZodType<
  TrustedIps$Outbound,
  z.ZodTypeDef,
  TrustedIps
> = z.object({
  deploymentType: UpdateProjectProjectsDeploymentType$outboundSchema,
  addresses: z.array(z.lazy(() => Addresses$outboundSchema)),
  protectionMode: ProtectionMode$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TrustedIps$ {
  /** @deprecated use `TrustedIps$inboundSchema` instead. */
  export const inboundSchema = TrustedIps$inboundSchema;
  /** @deprecated use `TrustedIps$outboundSchema` instead. */
  export const outboundSchema = TrustedIps$outboundSchema;
  /** @deprecated use `TrustedIps$Outbound` instead. */
  export type Outbound = TrustedIps$Outbound;
}

/** @internal */
export const Paths$inboundSchema: z.ZodType<Paths, z.ZodTypeDef, unknown> = z
  .object({
    value: z.string(),
  });

/** @internal */
export type Paths$Outbound = {
  value: string;
};

/** @internal */
export const Paths$outboundSchema: z.ZodType<
  Paths$Outbound,
  z.ZodTypeDef,
  Paths
> = z.object({
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Paths$ {
  /** @deprecated use `Paths$inboundSchema` instead. */
  export const inboundSchema = Paths$inboundSchema;
  /** @deprecated use `Paths$outboundSchema` instead. */
  export const outboundSchema = Paths$outboundSchema;
  /** @deprecated use `Paths$Outbound` instead. */
  export type Outbound = Paths$Outbound;
}

/** @internal */
export const OptionsAllowlist$inboundSchema: z.ZodType<
  OptionsAllowlist,
  z.ZodTypeDef,
  unknown
> = z.object({
  paths: z.array(z.lazy(() => Paths$inboundSchema)),
});

/** @internal */
export type OptionsAllowlist$Outbound = {
  paths: Array<Paths$Outbound>;
};

/** @internal */
export const OptionsAllowlist$outboundSchema: z.ZodType<
  OptionsAllowlist$Outbound,
  z.ZodTypeDef,
  OptionsAllowlist
> = z.object({
  paths: z.array(z.lazy(() => Paths$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace OptionsAllowlist$ {
  /** @deprecated use `OptionsAllowlist$inboundSchema` instead. */
  export const inboundSchema = OptionsAllowlist$inboundSchema;
  /** @deprecated use `OptionsAllowlist$outboundSchema` instead. */
  export const outboundSchema = OptionsAllowlist$outboundSchema;
  /** @deprecated use `OptionsAllowlist$Outbound` instead. */
  export type Outbound = OptionsAllowlist$Outbound;
}

/** @internal */
export const UpdateProjectRequestBody$inboundSchema: z.ZodType<
  UpdateProjectRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean().optional(),
  framework: z.nullable(UpdateProjectFramework$inboundSchema).optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  installCommand: z.nullable(z.string()).optional(),
  name: z.string().optional(),
  nodeVersion: UpdateProjectNodeVersion$inboundSchema.optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  previewDeploymentsDisabled: z.nullable(z.boolean()).optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().int().optional(),
  skewProtectionMaxAge: z.number().int().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  oidcTokenConfig: z.lazy(() => UpdateProjectOidcTokenConfig$inboundSchema)
    .optional(),
  passwordProtection: z.nullable(z.lazy(() => PasswordProtection$inboundSchema))
    .optional(),
  ssoProtection: z.nullable(z.lazy(() => SsoProtection$inboundSchema))
    .optional(),
  trustedIps: z.nullable(z.lazy(() => TrustedIps$inboundSchema)).optional(),
  optionsAllowlist: z.nullable(z.lazy(() => OptionsAllowlist$inboundSchema))
    .optional(),
});

/** @internal */
export type UpdateProjectRequestBody$Outbound = {
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  devCommand?: string | null | undefined;
  directoryListing?: boolean | undefined;
  framework?: string | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  installCommand?: string | null | undefined;
  name?: string | undefined;
  nodeVersion?: string | undefined;
  outputDirectory?: string | null | undefined;
  previewDeploymentsDisabled?: boolean | null | undefined;
  publicSource?: boolean | null | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  oidcTokenConfig?: UpdateProjectOidcTokenConfig$Outbound | undefined;
  passwordProtection?: PasswordProtection$Outbound | null | undefined;
  ssoProtection?: SsoProtection$Outbound | null | undefined;
  trustedIps?: TrustedIps$Outbound | null | undefined;
  optionsAllowlist?: OptionsAllowlist$Outbound | null | undefined;
};

/** @internal */
export const UpdateProjectRequestBody$outboundSchema: z.ZodType<
  UpdateProjectRequestBody$Outbound,
  z.ZodTypeDef,
  UpdateProjectRequestBody
> = z.object({
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean().optional(),
  framework: z.nullable(UpdateProjectFramework$outboundSchema).optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  installCommand: z.nullable(z.string()).optional(),
  name: z.string().optional(),
  nodeVersion: UpdateProjectNodeVersion$outboundSchema.optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  previewDeploymentsDisabled: z.nullable(z.boolean()).optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().int().optional(),
  skewProtectionMaxAge: z.number().int().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  oidcTokenConfig: z.lazy(() => UpdateProjectOidcTokenConfig$outboundSchema)
    .optional(),
  passwordProtection: z.nullable(
    z.lazy(() => PasswordProtection$outboundSchema),
  ).optional(),
  ssoProtection: z.nullable(z.lazy(() => SsoProtection$outboundSchema))
    .optional(),
  trustedIps: z.nullable(z.lazy(() => TrustedIps$outboundSchema)).optional(),
  optionsAllowlist: z.nullable(z.lazy(() => OptionsAllowlist$outboundSchema))
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectRequestBody$ {
  /** @deprecated use `UpdateProjectRequestBody$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectRequestBody$inboundSchema;
  /** @deprecated use `UpdateProjectRequestBody$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectRequestBody$outboundSchema;
  /** @deprecated use `UpdateProjectRequestBody$Outbound` instead. */
  export type Outbound = UpdateProjectRequestBody$Outbound;
}

/** @internal */
export const UpdateProjectRequest$inboundSchema: z.ZodType<
  UpdateProjectRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrName: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => UpdateProjectRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type UpdateProjectRequest$Outbound = {
  idOrName: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: UpdateProjectRequestBody$Outbound | undefined;
};

/** @internal */
export const UpdateProjectRequest$outboundSchema: z.ZodType<
  UpdateProjectRequest$Outbound,
  z.ZodTypeDef,
  UpdateProjectRequest
> = z.object({
  idOrName: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => UpdateProjectRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectRequest$ {
  /** @deprecated use `UpdateProjectRequest$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectRequest$inboundSchema;
  /** @deprecated use `UpdateProjectRequest$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectRequest$outboundSchema;
  /** @deprecated use `UpdateProjectRequest$Outbound` instead. */
  export type Outbound = UpdateProjectRequest$Outbound;
}

/** @internal */
export const UpdateProjectAnalytics$inboundSchema: z.ZodType<
  UpdateProjectAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/** @internal */
export type UpdateProjectAnalytics$Outbound = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

/** @internal */
export const UpdateProjectAnalytics$outboundSchema: z.ZodType<
  UpdateProjectAnalytics$Outbound,
  z.ZodTypeDef,
  UpdateProjectAnalytics
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectAnalytics$ {
  /** @deprecated use `UpdateProjectAnalytics$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectAnalytics$inboundSchema;
  /** @deprecated use `UpdateProjectAnalytics$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectAnalytics$outboundSchema;
  /** @deprecated use `UpdateProjectAnalytics$Outbound` instead. */
  export type Outbound = UpdateProjectAnalytics$Outbound;
}

/** @internal */
export const UpdateProjectSpeedInsights$inboundSchema: z.ZodType<
  UpdateProjectSpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type UpdateProjectSpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const UpdateProjectSpeedInsights$outboundSchema: z.ZodType<
  UpdateProjectSpeedInsights$Outbound,
  z.ZodTypeDef,
  UpdateProjectSpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectSpeedInsights$ {
  /** @deprecated use `UpdateProjectSpeedInsights$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectSpeedInsights$inboundSchema;
  /** @deprecated use `UpdateProjectSpeedInsights$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectSpeedInsights$outboundSchema;
  /** @deprecated use `UpdateProjectSpeedInsights$Outbound` instead. */
  export type Outbound = UpdateProjectSpeedInsights$Outbound;
}

/** @internal */
export const UpdateProjectDefinitions$inboundSchema: z.ZodType<
  UpdateProjectDefinitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/** @internal */
export type UpdateProjectDefinitions$Outbound = {
  host: string;
  path: string;
  schedule: string;
};

/** @internal */
export const UpdateProjectDefinitions$outboundSchema: z.ZodType<
  UpdateProjectDefinitions$Outbound,
  z.ZodTypeDef,
  UpdateProjectDefinitions
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDefinitions$ {
  /** @deprecated use `UpdateProjectDefinitions$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDefinitions$inboundSchema;
  /** @deprecated use `UpdateProjectDefinitions$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDefinitions$outboundSchema;
  /** @deprecated use `UpdateProjectDefinitions$Outbound` instead. */
  export type Outbound = UpdateProjectDefinitions$Outbound;
}

/** @internal */
export const UpdateProjectCrons$inboundSchema: z.ZodType<
  UpdateProjectCrons,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => UpdateProjectDefinitions$inboundSchema)),
});

/** @internal */
export type UpdateProjectCrons$Outbound = {
  enabledAt: number;
  disabledAt: number | null;
  updatedAt: number;
  deploymentId: string | null;
  definitions: Array<UpdateProjectDefinitions$Outbound>;
};

/** @internal */
export const UpdateProjectCrons$outboundSchema: z.ZodType<
  UpdateProjectCrons$Outbound,
  z.ZodTypeDef,
  UpdateProjectCrons
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => UpdateProjectDefinitions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectCrons$ {
  /** @deprecated use `UpdateProjectCrons$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectCrons$inboundSchema;
  /** @deprecated use `UpdateProjectCrons$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectCrons$outboundSchema;
  /** @deprecated use `UpdateProjectCrons$Outbound` instead. */
  export type Outbound = UpdateProjectCrons$Outbound;
}

/** @internal */
export const UpdateProjectDataCache$inboundSchema: z.ZodType<
  UpdateProjectDataCache,
  z.ZodTypeDef,
  unknown
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectDataCache$Outbound = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

/** @internal */
export const UpdateProjectDataCache$outboundSchema: z.ZodType<
  UpdateProjectDataCache$Outbound,
  z.ZodTypeDef,
  UpdateProjectDataCache
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDataCache$ {
  /** @deprecated use `UpdateProjectDataCache$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDataCache$inboundSchema;
  /** @deprecated use `UpdateProjectDataCache$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectDataCache$outboundSchema;
  /** @deprecated use `UpdateProjectDataCache$Outbound` instead. */
  export type Outbound = UpdateProjectDataCache$Outbound;
}

/** @internal */
export const UpdateProjectDeploymentExpiration$inboundSchema: z.ZodType<
  UpdateProjectDeploymentExpiration,
  z.ZodTypeDef,
  unknown
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/** @internal */
export type UpdateProjectDeploymentExpiration$Outbound = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

/** @internal */
export const UpdateProjectDeploymentExpiration$outboundSchema: z.ZodType<
  UpdateProjectDeploymentExpiration$Outbound,
  z.ZodTypeDef,
  UpdateProjectDeploymentExpiration
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectDeploymentExpiration$ {
  /** @deprecated use `UpdateProjectDeploymentExpiration$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectDeploymentExpiration$inboundSchema;
  /** @deprecated use `UpdateProjectDeploymentExpiration$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectDeploymentExpiration$outboundSchema;
  /** @deprecated use `UpdateProjectDeploymentExpiration$Outbound` instead. */
  export type Outbound = UpdateProjectDeploymentExpiration$Outbound;
}

/** @internal */
export const UpdateProjectTarget2$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectTarget2
> = z.nativeEnum(UpdateProjectTarget2);

/** @internal */
export const UpdateProjectTarget2$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectTarget2
> = UpdateProjectTarget2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTarget2$ {
  /** @deprecated use `UpdateProjectTarget2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTarget2$inboundSchema;
  /** @deprecated use `UpdateProjectTarget2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTarget2$outboundSchema;
}

/** @internal */
export const UpdateProjectTarget$inboundSchema: z.ZodType<
  UpdateProjectTarget,
  z.ZodTypeDef,
  unknown
> = z.union([z.array(z.string()), UpdateProjectTarget2$inboundSchema]);

/** @internal */
export type UpdateProjectTarget$Outbound = Array<string> | string;

/** @internal */
export const UpdateProjectTarget$outboundSchema: z.ZodType<
  UpdateProjectTarget$Outbound,
  z.ZodTypeDef,
  UpdateProjectTarget
> = z.union([z.array(z.string()), UpdateProjectTarget2$outboundSchema]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTarget$ {
  /** @deprecated use `UpdateProjectTarget$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTarget$inboundSchema;
  /** @deprecated use `UpdateProjectTarget$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTarget$outboundSchema;
  /** @deprecated use `UpdateProjectTarget$Outbound` instead. */
  export type Outbound = UpdateProjectTarget$Outbound;
}

/** @internal */
export const UpdateProjectType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectType
> = z.nativeEnum(UpdateProjectType);

/** @internal */
export const UpdateProjectType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectType
> = UpdateProjectType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectType$ {
  /** @deprecated use `UpdateProjectType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectType$inboundSchema;
  /** @deprecated use `UpdateProjectType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint15$inboundSchema: z.ZodType<
  UpdateProjectContentHint15,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema,
  projectId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint15$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const UpdateProjectContentHint15$outboundSchema: z.ZodType<
  UpdateProjectContentHint15$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint15
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint15$ {
  /** @deprecated use `UpdateProjectContentHint15$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint15$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint15$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint15$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint15$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint15$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint14$inboundSchema: z.ZodType<
  UpdateProjectContentHint14,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint14$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const UpdateProjectContentHint14$outboundSchema: z.ZodType<
  UpdateProjectContentHint14$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint14
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint14$ {
  /** @deprecated use `UpdateProjectContentHint14$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint14$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint14$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint14$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint14$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint14$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint13$inboundSchema: z.ZodType<
  UpdateProjectContentHint13,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint13$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint13$outboundSchema: z.ZodType<
  UpdateProjectContentHint13$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint13
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint13$ {
  /** @deprecated use `UpdateProjectContentHint13$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint13$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint13$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint13$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint13$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint13$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint12$inboundSchema: z.ZodType<
  UpdateProjectContentHint12,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint12$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint12$outboundSchema: z.ZodType<
  UpdateProjectContentHint12$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint12
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint12$ {
  /** @deprecated use `UpdateProjectContentHint12$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint12$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint12$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint12$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint12$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint12$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint11$inboundSchema: z.ZodType<
  UpdateProjectContentHint11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint11$outboundSchema: z.ZodType<
  UpdateProjectContentHint11$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint11
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint11$ {
  /** @deprecated use `UpdateProjectContentHint11$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint11$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint11$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint11$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint11$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint11$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint10$inboundSchema: z.ZodType<
  UpdateProjectContentHint10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint10$outboundSchema: z.ZodType<
  UpdateProjectContentHint10$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint10
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint10$ {
  /** @deprecated use `UpdateProjectContentHint10$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint10$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint10$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint10$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint10$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint10$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint9$inboundSchema: z.ZodType<
  UpdateProjectContentHint9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint9$outboundSchema: z.ZodType<
  UpdateProjectContentHint9$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint9
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint9$ {
  /** @deprecated use `UpdateProjectContentHint9$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint9$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint9$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint9$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint9$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint9$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint8$inboundSchema: z.ZodType<
  UpdateProjectContentHint8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint8$outboundSchema: z.ZodType<
  UpdateProjectContentHint8$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint8
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint8$ {
  /** @deprecated use `UpdateProjectContentHint8$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint8$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint8$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint8$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint8$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint8$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint7$inboundSchema: z.ZodType<
  UpdateProjectContentHint7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint7$outboundSchema: z.ZodType<
  UpdateProjectContentHint7$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint7
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint7$ {
  /** @deprecated use `UpdateProjectContentHint7$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint7$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint7$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint7$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint7$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint7$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint6$inboundSchema: z.ZodType<
  UpdateProjectContentHint6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint6$outboundSchema: z.ZodType<
  UpdateProjectContentHint6$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint6
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint6$ {
  /** @deprecated use `UpdateProjectContentHint6$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint6$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint6$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint6$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint6$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint6$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONType
  > = z.nativeEnum(
    UpdateProjectContentHintProjectsResponse200ApplicationJSONType,
  );

/** @internal */
export const UpdateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectContentHintProjectsResponse200ApplicationJSONType
  > =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint5$inboundSchema: z.ZodType<
  UpdateProjectContentHint5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint5$outboundSchema: z.ZodType<
  UpdateProjectContentHint5$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint5
> = z.object({
  type:
    UpdateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint5$ {
  /** @deprecated use `UpdateProjectContentHint5$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint5$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint5$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint5$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint5$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint5$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectContentHintProjectsResponse200Type> = z
    .nativeEnum(UpdateProjectContentHintProjectsResponse200Type);

/** @internal */
export const UpdateProjectContentHintProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectContentHintProjectsResponse200Type> =
    UpdateProjectContentHintProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponse200Type$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponse200Type$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint4$inboundSchema: z.ZodType<
  UpdateProjectContentHint4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectContentHintProjectsResponse200Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint4$outboundSchema: z.ZodType<
  UpdateProjectContentHint4$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint4
> = z.object({
  type: UpdateProjectContentHintProjectsResponse200Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint4$ {
  /** @deprecated use `UpdateProjectContentHint4$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint4$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint4$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint4$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint4$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint4$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectContentHintProjectsResponseType> = z
    .nativeEnum(UpdateProjectContentHintProjectsResponseType);

/** @internal */
export const UpdateProjectContentHintProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectContentHintProjectsResponseType> =
    UpdateProjectContentHintProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsResponseType$ {
  /** @deprecated use `UpdateProjectContentHintProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsResponseType$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsResponseType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint3$inboundSchema: z.ZodType<
  UpdateProjectContentHint3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectContentHintProjectsResponseType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint3$outboundSchema: z.ZodType<
  UpdateProjectContentHint3$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint3
> = z.object({
  type: UpdateProjectContentHintProjectsResponseType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint3$ {
  /** @deprecated use `UpdateProjectContentHint3$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint3$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint3$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint3$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint3$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint3$Outbound;
}

/** @internal */
export const UpdateProjectContentHintProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectContentHintProjectsType> = z.nativeEnum(
    UpdateProjectContentHintProjectsType,
  );

/** @internal */
export const UpdateProjectContentHintProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectContentHintProjectsType> =
    UpdateProjectContentHintProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintProjectsType$ {
  /** @deprecated use `UpdateProjectContentHintProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectContentHintProjectsType$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectContentHintProjectsType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint2$inboundSchema: z.ZodType<
  UpdateProjectContentHint2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectContentHintProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint2$outboundSchema: z.ZodType<
  UpdateProjectContentHint2$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint2
> = z.object({
  type: UpdateProjectContentHintProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint2$ {
  /** @deprecated use `UpdateProjectContentHint2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint2$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint2$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint2$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint2$Outbound;
}

/** @internal */
export const UpdateProjectContentHintType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectContentHintType
> = z.nativeEnum(UpdateProjectContentHintType);

/** @internal */
export const UpdateProjectContentHintType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectContentHintType
> = UpdateProjectContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHintType$ {
  /** @deprecated use `UpdateProjectContentHintType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHintType$inboundSchema;
  /** @deprecated use `UpdateProjectContentHintType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHintType$outboundSchema;
}

/** @internal */
export const UpdateProjectContentHint1$inboundSchema: z.ZodType<
  UpdateProjectContentHint1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type UpdateProjectContentHint1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const UpdateProjectContentHint1$outboundSchema: z.ZodType<
  UpdateProjectContentHint1$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint1
> = z.object({
  type: UpdateProjectContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint1$ {
  /** @deprecated use `UpdateProjectContentHint1$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint1$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint1$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint1$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint1$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint1$Outbound;
}

/** @internal */
export const UpdateProjectContentHint$inboundSchema: z.ZodType<
  UpdateProjectContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateProjectContentHint1$inboundSchema),
  z.lazy(() => UpdateProjectContentHint2$inboundSchema),
  z.lazy(() => UpdateProjectContentHint3$inboundSchema),
  z.lazy(() => UpdateProjectContentHint4$inboundSchema),
  z.lazy(() => UpdateProjectContentHint5$inboundSchema),
  z.lazy(() => UpdateProjectContentHint6$inboundSchema),
  z.lazy(() => UpdateProjectContentHint7$inboundSchema),
  z.lazy(() => UpdateProjectContentHint8$inboundSchema),
  z.lazy(() => UpdateProjectContentHint9$inboundSchema),
  z.lazy(() => UpdateProjectContentHint10$inboundSchema),
  z.lazy(() => UpdateProjectContentHint11$inboundSchema),
  z.lazy(() => UpdateProjectContentHint12$inboundSchema),
  z.lazy(() => UpdateProjectContentHint13$inboundSchema),
  z.lazy(() => UpdateProjectContentHint15$inboundSchema),
  z.lazy(() => UpdateProjectContentHint14$inboundSchema),
]);

/** @internal */
export type UpdateProjectContentHint$Outbound =
  | UpdateProjectContentHint1$Outbound
  | UpdateProjectContentHint2$Outbound
  | UpdateProjectContentHint3$Outbound
  | UpdateProjectContentHint4$Outbound
  | UpdateProjectContentHint5$Outbound
  | UpdateProjectContentHint6$Outbound
  | UpdateProjectContentHint7$Outbound
  | UpdateProjectContentHint8$Outbound
  | UpdateProjectContentHint9$Outbound
  | UpdateProjectContentHint10$Outbound
  | UpdateProjectContentHint11$Outbound
  | UpdateProjectContentHint12$Outbound
  | UpdateProjectContentHint13$Outbound
  | UpdateProjectContentHint15$Outbound
  | UpdateProjectContentHint14$Outbound;

/** @internal */
export const UpdateProjectContentHint$outboundSchema: z.ZodType<
  UpdateProjectContentHint$Outbound,
  z.ZodTypeDef,
  UpdateProjectContentHint
> = z.union([
  z.lazy(() => UpdateProjectContentHint1$outboundSchema),
  z.lazy(() => UpdateProjectContentHint2$outboundSchema),
  z.lazy(() => UpdateProjectContentHint3$outboundSchema),
  z.lazy(() => UpdateProjectContentHint4$outboundSchema),
  z.lazy(() => UpdateProjectContentHint5$outboundSchema),
  z.lazy(() => UpdateProjectContentHint6$outboundSchema),
  z.lazy(() => UpdateProjectContentHint7$outboundSchema),
  z.lazy(() => UpdateProjectContentHint8$outboundSchema),
  z.lazy(() => UpdateProjectContentHint9$outboundSchema),
  z.lazy(() => UpdateProjectContentHint10$outboundSchema),
  z.lazy(() => UpdateProjectContentHint11$outboundSchema),
  z.lazy(() => UpdateProjectContentHint12$outboundSchema),
  z.lazy(() => UpdateProjectContentHint13$outboundSchema),
  z.lazy(() => UpdateProjectContentHint15$outboundSchema),
  z.lazy(() => UpdateProjectContentHint14$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectContentHint$ {
  /** @deprecated use `UpdateProjectContentHint$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectContentHint$inboundSchema;
  /** @deprecated use `UpdateProjectContentHint$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectContentHint$outboundSchema;
  /** @deprecated use `UpdateProjectContentHint$Outbound` instead. */
  export type Outbound = UpdateProjectContentHint$Outbound;
}

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType
  > = z.nativeEnum(
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType,
  );

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType
  > =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$ {
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema;
}

/** @internal */
export const UpdateProjectInternalContentHint$inboundSchema: z.ZodType<
  UpdateProjectInternalContentHint,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema,
  encryptedValue: z.string(),
});

/** @internal */
export type UpdateProjectInternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const UpdateProjectInternalContentHint$outboundSchema: z.ZodType<
  UpdateProjectInternalContentHint$Outbound,
  z.ZodTypeDef,
  UpdateProjectInternalContentHint
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema,
  encryptedValue: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectInternalContentHint$ {
  /** @deprecated use `UpdateProjectInternalContentHint$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectInternalContentHint$inboundSchema;
  /** @deprecated use `UpdateProjectInternalContentHint$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectInternalContentHint$outboundSchema;
  /** @deprecated use `UpdateProjectInternalContentHint$Outbound` instead. */
  export type Outbound = UpdateProjectInternalContentHint$Outbound;
}

/** @internal */
export const UpdateProjectEnv$inboundSchema: z.ZodType<
  UpdateProjectEnv,
  z.ZodTypeDef,
  unknown
> = z.object({
  target: z.union([z.array(z.string()), UpdateProjectTarget2$inboundSchema])
    .optional(),
  type: UpdateProjectType$inboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => UpdateProjectContentHint1$inboundSchema),
      z.lazy(() => UpdateProjectContentHint2$inboundSchema),
      z.lazy(() => UpdateProjectContentHint3$inboundSchema),
      z.lazy(() => UpdateProjectContentHint4$inboundSchema),
      z.lazy(() => UpdateProjectContentHint5$inboundSchema),
      z.lazy(() => UpdateProjectContentHint6$inboundSchema),
      z.lazy(() => UpdateProjectContentHint7$inboundSchema),
      z.lazy(() => UpdateProjectContentHint8$inboundSchema),
      z.lazy(() => UpdateProjectContentHint9$inboundSchema),
      z.lazy(() => UpdateProjectContentHint10$inboundSchema),
      z.lazy(() => UpdateProjectContentHint11$inboundSchema),
      z.lazy(() => UpdateProjectContentHint12$inboundSchema),
      z.lazy(() => UpdateProjectContentHint13$inboundSchema),
      z.lazy(() => UpdateProjectContentHint15$inboundSchema),
      z.lazy(() => UpdateProjectContentHint14$inboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => UpdateProjectInternalContentHint$inboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
});

/** @internal */
export type UpdateProjectEnv$Outbound = {
  target?: Array<string> | string | undefined;
  type: string;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | UpdateProjectContentHint1$Outbound
    | UpdateProjectContentHint2$Outbound
    | UpdateProjectContentHint3$Outbound
    | UpdateProjectContentHint4$Outbound
    | UpdateProjectContentHint5$Outbound
    | UpdateProjectContentHint6$Outbound
    | UpdateProjectContentHint7$Outbound
    | UpdateProjectContentHint8$Outbound
    | UpdateProjectContentHint9$Outbound
    | UpdateProjectContentHint10$Outbound
    | UpdateProjectContentHint11$Outbound
    | UpdateProjectContentHint12$Outbound
    | UpdateProjectContentHint13$Outbound
    | UpdateProjectContentHint15$Outbound
    | UpdateProjectContentHint14$Outbound
    | null
    | undefined;
  internalContentHint?:
    | UpdateProjectInternalContentHint$Outbound
    | null
    | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

/** @internal */
export const UpdateProjectEnv$outboundSchema: z.ZodType<
  UpdateProjectEnv$Outbound,
  z.ZodTypeDef,
  UpdateProjectEnv
> = z.object({
  target: z.union([z.array(z.string()), UpdateProjectTarget2$outboundSchema])
    .optional(),
  type: UpdateProjectType$outboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => UpdateProjectContentHint1$outboundSchema),
      z.lazy(() => UpdateProjectContentHint2$outboundSchema),
      z.lazy(() => UpdateProjectContentHint3$outboundSchema),
      z.lazy(() => UpdateProjectContentHint4$outboundSchema),
      z.lazy(() => UpdateProjectContentHint5$outboundSchema),
      z.lazy(() => UpdateProjectContentHint6$outboundSchema),
      z.lazy(() => UpdateProjectContentHint7$outboundSchema),
      z.lazy(() => UpdateProjectContentHint8$outboundSchema),
      z.lazy(() => UpdateProjectContentHint9$outboundSchema),
      z.lazy(() => UpdateProjectContentHint10$outboundSchema),
      z.lazy(() => UpdateProjectContentHint11$outboundSchema),
      z.lazy(() => UpdateProjectContentHint12$outboundSchema),
      z.lazy(() => UpdateProjectContentHint13$outboundSchema),
      z.lazy(() => UpdateProjectContentHint15$outboundSchema),
      z.lazy(() => UpdateProjectContentHint14$outboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => UpdateProjectInternalContentHint$outboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectEnv$ {
  /** @deprecated use `UpdateProjectEnv$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectEnv$inboundSchema;
  /** @deprecated use `UpdateProjectEnv$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectEnv$outboundSchema;
  /** @deprecated use `UpdateProjectEnv$Outbound` instead. */
  export type Outbound = UpdateProjectEnv$Outbound;
}

/** @internal */
export const UpdateProjectCustomEnvironments$inboundSchema: z.ZodType<
  UpdateProjectCustomEnvironments,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type UpdateProjectCustomEnvironments$Outbound = {};

/** @internal */
export const UpdateProjectCustomEnvironments$outboundSchema: z.ZodType<
  UpdateProjectCustomEnvironments$Outbound,
  z.ZodTypeDef,
  UpdateProjectCustomEnvironments
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectCustomEnvironments$ {
  /** @deprecated use `UpdateProjectCustomEnvironments$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectCustomEnvironments$inboundSchema;
  /** @deprecated use `UpdateProjectCustomEnvironments$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectCustomEnvironments$outboundSchema;
  /** @deprecated use `UpdateProjectCustomEnvironments$Outbound` instead. */
  export type Outbound = UpdateProjectCustomEnvironments$Outbound;
}

/** @internal */
export const UpdateProjectProjectsFramework$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsFramework
> = z.nativeEnum(UpdateProjectProjectsFramework);

/** @internal */
export const UpdateProjectProjectsFramework$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsFramework
> = UpdateProjectProjectsFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsFramework$ {
  /** @deprecated use `UpdateProjectProjectsFramework$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsFramework$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsFramework$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsFramework$outboundSchema;
}

/** @internal */
export const UpdateProjectIpBuckets$inboundSchema: z.ZodType<
  UpdateProjectIpBuckets,
  z.ZodTypeDef,
  unknown
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/** @internal */
export type UpdateProjectIpBuckets$Outbound = {
  bucket: string;
  supportUntil?: number | undefined;
};

/** @internal */
export const UpdateProjectIpBuckets$outboundSchema: z.ZodType<
  UpdateProjectIpBuckets$Outbound,
  z.ZodTypeDef,
  UpdateProjectIpBuckets
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectIpBuckets$ {
  /** @deprecated use `UpdateProjectIpBuckets$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectIpBuckets$inboundSchema;
  /** @deprecated use `UpdateProjectIpBuckets$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectIpBuckets$outboundSchema;
  /** @deprecated use `UpdateProjectIpBuckets$Outbound` instead. */
  export type Outbound = UpdateProjectIpBuckets$Outbound;
}

/** @internal */
export const UpdateProjectAliasAssigned$inboundSchema: z.ZodType<
  UpdateProjectAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type UpdateProjectAliasAssigned$Outbound = number | boolean;

/** @internal */
export const UpdateProjectAliasAssigned$outboundSchema: z.ZodType<
  UpdateProjectAliasAssigned$Outbound,
  z.ZodTypeDef,
  UpdateProjectAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectAliasAssigned$ {
  /** @deprecated use `UpdateProjectAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectAliasAssigned$inboundSchema;
  /** @deprecated use `UpdateProjectAliasAssigned$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectAliasAssigned$outboundSchema;
  /** @deprecated use `UpdateProjectAliasAssigned$Outbound` instead. */
  export type Outbound = UpdateProjectAliasAssigned$Outbound;
}

/** @internal */
export const UpdateProjectAliasError$inboundSchema: z.ZodType<
  UpdateProjectAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type UpdateProjectAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const UpdateProjectAliasError$outboundSchema: z.ZodType<
  UpdateProjectAliasError$Outbound,
  z.ZodTypeDef,
  UpdateProjectAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectAliasError$ {
  /** @deprecated use `UpdateProjectAliasError$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectAliasError$inboundSchema;
  /** @deprecated use `UpdateProjectAliasError$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectAliasError$outboundSchema;
  /** @deprecated use `UpdateProjectAliasError$Outbound` instead. */
  export type Outbound = UpdateProjectAliasError$Outbound;
}

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType
  > =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const UpdateProjectBranchMatcher$inboundSchema: z.ZodType<
  UpdateProjectBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type UpdateProjectBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const UpdateProjectBranchMatcher$outboundSchema: z.ZodType<
  UpdateProjectBranchMatcher$Outbound,
  z.ZodTypeDef,
  UpdateProjectBranchMatcher
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectBranchMatcher$ {
  /** @deprecated use `UpdateProjectBranchMatcher$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectBranchMatcher$inboundSchema;
  /** @deprecated use `UpdateProjectBranchMatcher$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectBranchMatcher$outboundSchema;
  /** @deprecated use `UpdateProjectBranchMatcher$Outbound` instead. */
  export type Outbound = UpdateProjectBranchMatcher$Outbound;
}

/** @internal */
export const UpdateProjectBuilds$inboundSchema: z.ZodType<
  UpdateProjectBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type UpdateProjectBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const UpdateProjectBuilds$outboundSchema: z.ZodType<
  UpdateProjectBuilds$Outbound,
  z.ZodTypeDef,
  UpdateProjectBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectBuilds$ {
  /** @deprecated use `UpdateProjectBuilds$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectBuilds$inboundSchema;
  /** @deprecated use `UpdateProjectBuilds$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectBuilds$outboundSchema;
  /** @deprecated use `UpdateProjectBuilds$Outbound` instead. */
  export type Outbound = UpdateProjectBuilds$Outbound;
}

/** @internal */
export const UpdateProjectChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectChecksConclusion
> = z.nativeEnum(UpdateProjectChecksConclusion);

/** @internal */
export const UpdateProjectChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectChecksConclusion
> = UpdateProjectChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectChecksConclusion$ {
  /** @deprecated use `UpdateProjectChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectChecksConclusion$inboundSchema;
  /** @deprecated use `UpdateProjectChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectChecksConclusion$outboundSchema;
}

/** @internal */
export const UpdateProjectChecksState$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectChecksState
> = z.nativeEnum(UpdateProjectChecksState);

/** @internal */
export const UpdateProjectChecksState$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectChecksState
> = UpdateProjectChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectChecksState$ {
  /** @deprecated use `UpdateProjectChecksState$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectChecksState$inboundSchema;
  /** @deprecated use `UpdateProjectChecksState$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectChecksState$outboundSchema;
}

/** @internal */
export const UpdateProjectCreator$inboundSchema: z.ZodType<
  UpdateProjectCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type UpdateProjectCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const UpdateProjectCreator$outboundSchema: z.ZodType<
  UpdateProjectCreator$Outbound,
  z.ZodTypeDef,
  UpdateProjectCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectCreator$ {
  /** @deprecated use `UpdateProjectCreator$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectCreator$inboundSchema;
  /** @deprecated use `UpdateProjectCreator$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectCreator$outboundSchema;
  /** @deprecated use `UpdateProjectCreator$Outbound` instead. */
  export type Outbound = UpdateProjectCreator$Outbound;
}

/** @internal */
export const UpdateProjectOidcTokenClaims$inboundSchema: z.ZodType<
  UpdateProjectOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type UpdateProjectOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const UpdateProjectOidcTokenClaims$outboundSchema: z.ZodType<
  UpdateProjectOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  UpdateProjectOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectOidcTokenClaims$ {
  /** @deprecated use `UpdateProjectOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectOidcTokenClaims$inboundSchema;
  /** @deprecated use `UpdateProjectOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectOidcTokenClaims$outboundSchema;
  /** @deprecated use `UpdateProjectOidcTokenClaims$Outbound` instead. */
  export type Outbound = UpdateProjectOidcTokenClaims$Outbound;
}

/** @internal */
export const UpdateProjectPlan$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectPlan
> = z.nativeEnum(UpdateProjectPlan);

/** @internal */
export const UpdateProjectPlan$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectPlan
> = UpdateProjectPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectPlan$ {
  /** @deprecated use `UpdateProjectPlan$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectPlan$inboundSchema;
  /** @deprecated use `UpdateProjectPlan$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectPlan$outboundSchema;
}

/** @internal */
export const UpdateProjectReadyState$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectReadyState
> = z.nativeEnum(UpdateProjectReadyState);

/** @internal */
export const UpdateProjectReadyState$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectReadyState
> = UpdateProjectReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectReadyState$ {
  /** @deprecated use `UpdateProjectReadyState$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectReadyState$inboundSchema;
  /** @deprecated use `UpdateProjectReadyState$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectReadyState$outboundSchema;
}

/** @internal */
export const UpdateProjectReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectReadySubstate
> = z.nativeEnum(UpdateProjectReadySubstate);

/** @internal */
export const UpdateProjectReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectReadySubstate
> = UpdateProjectReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectReadySubstate$ {
  /** @deprecated use `UpdateProjectReadySubstate$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectReadySubstate$inboundSchema;
  /** @deprecated use `UpdateProjectReadySubstate$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectReadySubstate$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsType
> = z.nativeEnum(UpdateProjectProjectsType);

/** @internal */
export const UpdateProjectProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsType
> = UpdateProjectProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsType$ {
  /** @deprecated use `UpdateProjectProjectsType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsType$outboundSchema;
}

/** @internal */
export const UpdateProjectLatestDeployments$inboundSchema: z.ZodType<
  UpdateProjectLatestDeployments,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(z.lazy(() => UpdateProjectAliasError$inboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => UpdateProjectBranchMatcher$inboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => UpdateProjectBuilds$inboundSchema)).optional(),
  checksConclusion: UpdateProjectChecksConclusion$inboundSchema.optional(),
  checksState: UpdateProjectChecksState$inboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => UpdateProjectCreator$inboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() => UpdateProjectOidcTokenClaims$inboundSchema)
    .optional(),
  plan: UpdateProjectPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectReadyState$inboundSchema,
  readySubstate: UpdateProjectReadySubstate$inboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectProjectsType$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectLatestDeployments$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: UpdateProjectBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const UpdateProjectLatestDeployments$outboundSchema: z.ZodType<
  UpdateProjectLatestDeployments$Outbound,
  z.ZodTypeDef,
  UpdateProjectLatestDeployments
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(z.lazy(() => UpdateProjectAliasError$outboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => UpdateProjectBranchMatcher$outboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => UpdateProjectBuilds$outboundSchema)).optional(),
  checksConclusion: UpdateProjectChecksConclusion$outboundSchema.optional(),
  checksState: UpdateProjectChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => UpdateProjectCreator$outboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() => UpdateProjectOidcTokenClaims$outboundSchema)
    .optional(),
  plan: UpdateProjectPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectReadyState$outboundSchema,
  readySubstate: UpdateProjectReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectProjectsType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLatestDeployments$ {
  /** @deprecated use `UpdateProjectLatestDeployments$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLatestDeployments$inboundSchema;
  /** @deprecated use `UpdateProjectLatestDeployments$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLatestDeployments$outboundSchema;
  /** @deprecated use `UpdateProjectLatestDeployments$Outbound` instead. */
  export type Outbound = UpdateProjectLatestDeployments$Outbound;
}

/** @internal */
export const UpdateProjectLinkProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectLinkProjectsResponseType> = z.nativeEnum(
    UpdateProjectLinkProjectsResponseType,
  );

/** @internal */
export const UpdateProjectLinkProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectLinkProjectsResponseType> =
    UpdateProjectLinkProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLinkProjectsResponseType$ {
  /** @deprecated use `UpdateProjectLinkProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectLinkProjectsResponseType$inboundSchema;
  /** @deprecated use `UpdateProjectLinkProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectLinkProjectsResponseType$outboundSchema;
}

/** @internal */
export const UpdateProjectLinkProjectsResponseDeployHooks$inboundSchema:
  z.ZodType<
    UpdateProjectLinkProjectsResponseDeployHooks,
    z.ZodTypeDef,
    unknown
  > = z.object({
    createdAt: z.number().optional(),
    id: z.string(),
    name: z.string(),
    ref: z.string(),
    url: z.string(),
  });

/** @internal */
export type UpdateProjectLinkProjectsResponseDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const UpdateProjectLinkProjectsResponseDeployHooks$outboundSchema:
  z.ZodType<
    UpdateProjectLinkProjectsResponseDeployHooks$Outbound,
    z.ZodTypeDef,
    UpdateProjectLinkProjectsResponseDeployHooks
  > = z.object({
    createdAt: z.number().optional(),
    id: z.string(),
    name: z.string(),
    ref: z.string(),
    url: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLinkProjectsResponseDeployHooks$ {
  /** @deprecated use `UpdateProjectLinkProjectsResponseDeployHooks$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectLinkProjectsResponseDeployHooks$inboundSchema;
  /** @deprecated use `UpdateProjectLinkProjectsResponseDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectLinkProjectsResponseDeployHooks$outboundSchema;
  /** @deprecated use `UpdateProjectLinkProjectsResponseDeployHooks$Outbound` instead. */
  export type Outbound = UpdateProjectLinkProjectsResponseDeployHooks$Outbound;
}

/** @internal */
export const UpdateProjectLink3$inboundSchema: z.ZodType<
  UpdateProjectLink3,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: UpdateProjectLinkProjectsResponseType$inboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectLinkProjectsResponseDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type UpdateProjectLink3$Outbound = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: string | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectLinkProjectsResponseDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const UpdateProjectLink3$outboundSchema: z.ZodType<
  UpdateProjectLink3$Outbound,
  z.ZodTypeDef,
  UpdateProjectLink3
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: UpdateProjectLinkProjectsResponseType$outboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectLinkProjectsResponseDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLink3$ {
  /** @deprecated use `UpdateProjectLink3$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLink3$inboundSchema;
  /** @deprecated use `UpdateProjectLink3$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLink3$outboundSchema;
  /** @deprecated use `UpdateProjectLink3$Outbound` instead. */
  export type Outbound = UpdateProjectLink3$Outbound;
}

/** @internal */
export const UpdateProjectLinkProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectLinkProjectsType
> = z.nativeEnum(UpdateProjectLinkProjectsType);

/** @internal */
export const UpdateProjectLinkProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectLinkProjectsType
> = UpdateProjectLinkProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLinkProjectsType$ {
  /** @deprecated use `UpdateProjectLinkProjectsType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLinkProjectsType$inboundSchema;
  /** @deprecated use `UpdateProjectLinkProjectsType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLinkProjectsType$outboundSchema;
}

/** @internal */
export const UpdateProjectLinkProjectsDeployHooks$inboundSchema: z.ZodType<
  UpdateProjectLinkProjectsDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type UpdateProjectLinkProjectsDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const UpdateProjectLinkProjectsDeployHooks$outboundSchema: z.ZodType<
  UpdateProjectLinkProjectsDeployHooks$Outbound,
  z.ZodTypeDef,
  UpdateProjectLinkProjectsDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLinkProjectsDeployHooks$ {
  /** @deprecated use `UpdateProjectLinkProjectsDeployHooks$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectLinkProjectsDeployHooks$inboundSchema;
  /** @deprecated use `UpdateProjectLinkProjectsDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectLinkProjectsDeployHooks$outboundSchema;
  /** @deprecated use `UpdateProjectLinkProjectsDeployHooks$Outbound` instead. */
  export type Outbound = UpdateProjectLinkProjectsDeployHooks$Outbound;
}

/** @internal */
export const UpdateProjectLink2$inboundSchema: z.ZodType<
  UpdateProjectLink2,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: UpdateProjectLinkProjectsType$inboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectLinkProjectsDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type UpdateProjectLink2$Outbound = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectLinkProjectsDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const UpdateProjectLink2$outboundSchema: z.ZodType<
  UpdateProjectLink2$Outbound,
  z.ZodTypeDef,
  UpdateProjectLink2
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: UpdateProjectLinkProjectsType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectLinkProjectsDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLink2$ {
  /** @deprecated use `UpdateProjectLink2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLink2$inboundSchema;
  /** @deprecated use `UpdateProjectLink2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLink2$outboundSchema;
  /** @deprecated use `UpdateProjectLink2$Outbound` instead. */
  export type Outbound = UpdateProjectLink2$Outbound;
}

/** @internal */
export const UpdateProjectLinkType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectLinkType
> = z.nativeEnum(UpdateProjectLinkType);

/** @internal */
export const UpdateProjectLinkType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectLinkType
> = UpdateProjectLinkType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLinkType$ {
  /** @deprecated use `UpdateProjectLinkType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLinkType$inboundSchema;
  /** @deprecated use `UpdateProjectLinkType$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLinkType$outboundSchema;
}

/** @internal */
export const UpdateProjectLinkDeployHooks$inboundSchema: z.ZodType<
  UpdateProjectLinkDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type UpdateProjectLinkDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const UpdateProjectLinkDeployHooks$outboundSchema: z.ZodType<
  UpdateProjectLinkDeployHooks$Outbound,
  z.ZodTypeDef,
  UpdateProjectLinkDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLinkDeployHooks$ {
  /** @deprecated use `UpdateProjectLinkDeployHooks$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLinkDeployHooks$inboundSchema;
  /** @deprecated use `UpdateProjectLinkDeployHooks$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLinkDeployHooks$outboundSchema;
  /** @deprecated use `UpdateProjectLinkDeployHooks$Outbound` instead. */
  export type Outbound = UpdateProjectLinkDeployHooks$Outbound;
}

/** @internal */
export const UpdateProjectLink1$inboundSchema: z.ZodType<
  UpdateProjectLink1,
  z.ZodTypeDef,
  unknown
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: UpdateProjectLinkType$inboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectLinkDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type UpdateProjectLink1$Outbound = {
  org?: string | undefined;
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<UpdateProjectLinkDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const UpdateProjectLink1$outboundSchema: z.ZodType<
  UpdateProjectLink1$Outbound,
  z.ZodTypeDef,
  UpdateProjectLink1
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: UpdateProjectLinkType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => UpdateProjectLinkDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLink1$ {
  /** @deprecated use `UpdateProjectLink1$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLink1$inboundSchema;
  /** @deprecated use `UpdateProjectLink1$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLink1$outboundSchema;
  /** @deprecated use `UpdateProjectLink1$Outbound` instead. */
  export type Outbound = UpdateProjectLink1$Outbound;
}

/** @internal */
export const UpdateProjectLink$inboundSchema: z.ZodType<
  UpdateProjectLink,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateProjectLink1$inboundSchema),
  z.lazy(() => UpdateProjectLink3$inboundSchema),
  z.lazy(() => UpdateProjectLink2$inboundSchema),
]);

/** @internal */
export type UpdateProjectLink$Outbound =
  | UpdateProjectLink1$Outbound
  | UpdateProjectLink3$Outbound
  | UpdateProjectLink2$Outbound;

/** @internal */
export const UpdateProjectLink$outboundSchema: z.ZodType<
  UpdateProjectLink$Outbound,
  z.ZodTypeDef,
  UpdateProjectLink
> = z.union([
  z.lazy(() => UpdateProjectLink1$outboundSchema),
  z.lazy(() => UpdateProjectLink3$outboundSchema),
  z.lazy(() => UpdateProjectLink2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLink$ {
  /** @deprecated use `UpdateProjectLink$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLink$inboundSchema;
  /** @deprecated use `UpdateProjectLink$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLink$outboundSchema;
  /** @deprecated use `UpdateProjectLink$Outbound` instead. */
  export type Outbound = UpdateProjectLink$Outbound;
}

/** @internal */
export const UpdateProjectGroup$inboundSchema: z.ZodType<
  UpdateProjectGroup,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/** @internal */
export type UpdateProjectGroup$Outbound = {
  id: string;
  slug: string;
};

/** @internal */
export const UpdateProjectGroup$outboundSchema: z.ZodType<
  UpdateProjectGroup$Outbound,
  z.ZodTypeDef,
  UpdateProjectGroup
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectGroup$ {
  /** @deprecated use `UpdateProjectGroup$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectGroup$inboundSchema;
  /** @deprecated use `UpdateProjectGroup$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectGroup$outboundSchema;
  /** @deprecated use `UpdateProjectGroup$Outbound` instead. */
  export type Outbound = UpdateProjectGroup$Outbound;
}

/** @internal */
export const UpdateProjectMicrofrontends$inboundSchema: z.ZodType<
  UpdateProjectMicrofrontends,
  z.ZodTypeDef,
  unknown
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => UpdateProjectGroup$inboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/** @internal */
export type UpdateProjectMicrofrontends$Outbound = {
  updatedAt: number;
  group: UpdateProjectGroup$Outbound;
  enabled: boolean;
  isDefaultApp?: boolean | undefined;
  defaultRoute?: string | undefined;
};

/** @internal */
export const UpdateProjectMicrofrontends$outboundSchema: z.ZodType<
  UpdateProjectMicrofrontends$Outbound,
  z.ZodTypeDef,
  UpdateProjectMicrofrontends
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => UpdateProjectGroup$outboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectMicrofrontends$ {
  /** @deprecated use `UpdateProjectMicrofrontends$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectMicrofrontends$inboundSchema;
  /** @deprecated use `UpdateProjectMicrofrontends$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectMicrofrontends$outboundSchema;
  /** @deprecated use `UpdateProjectMicrofrontends$Outbound` instead. */
  export type Outbound = UpdateProjectMicrofrontends$Outbound;
}

/** @internal */
export const UpdateProjectProjectsNodeVersion$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsNodeVersion
> = z.nativeEnum(UpdateProjectProjectsNodeVersion);

/** @internal */
export const UpdateProjectProjectsNodeVersion$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsNodeVersion
> = UpdateProjectProjectsNodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsNodeVersion$ {
  /** @deprecated use `UpdateProjectProjectsNodeVersion$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsNodeVersion$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsNodeVersion$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsNodeVersion$outboundSchema;
}

/** @internal */
export const UpdateProjectPaths$inboundSchema: z.ZodType<
  UpdateProjectPaths,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
});

/** @internal */
export type UpdateProjectPaths$Outbound = {
  value: string;
};

/** @internal */
export const UpdateProjectPaths$outboundSchema: z.ZodType<
  UpdateProjectPaths$Outbound,
  z.ZodTypeDef,
  UpdateProjectPaths
> = z.object({
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectPaths$ {
  /** @deprecated use `UpdateProjectPaths$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectPaths$inboundSchema;
  /** @deprecated use `UpdateProjectPaths$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectPaths$outboundSchema;
  /** @deprecated use `UpdateProjectPaths$Outbound` instead. */
  export type Outbound = UpdateProjectPaths$Outbound;
}

/** @internal */
export const UpdateProjectOptionsAllowlist$inboundSchema: z.ZodType<
  UpdateProjectOptionsAllowlist,
  z.ZodTypeDef,
  unknown
> = z.object({
  paths: z.array(z.lazy(() => UpdateProjectPaths$inboundSchema)),
});

/** @internal */
export type UpdateProjectOptionsAllowlist$Outbound = {
  paths: Array<UpdateProjectPaths$Outbound>;
};

/** @internal */
export const UpdateProjectOptionsAllowlist$outboundSchema: z.ZodType<
  UpdateProjectOptionsAllowlist$Outbound,
  z.ZodTypeDef,
  UpdateProjectOptionsAllowlist
> = z.object({
  paths: z.array(z.lazy(() => UpdateProjectPaths$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectOptionsAllowlist$ {
  /** @deprecated use `UpdateProjectOptionsAllowlist$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectOptionsAllowlist$inboundSchema;
  /** @deprecated use `UpdateProjectOptionsAllowlist$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectOptionsAllowlist$outboundSchema;
  /** @deprecated use `UpdateProjectOptionsAllowlist$Outbound` instead. */
  export type Outbound = UpdateProjectOptionsAllowlist$Outbound;
}

/** @internal */
export const UpdateProjectPasswordProtection$inboundSchema: z.ZodType<
  UpdateProjectPasswordProtection,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type UpdateProjectPasswordProtection$Outbound = {};

/** @internal */
export const UpdateProjectPasswordProtection$outboundSchema: z.ZodType<
  UpdateProjectPasswordProtection$Outbound,
  z.ZodTypeDef,
  UpdateProjectPasswordProtection
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectPasswordProtection$ {
  /** @deprecated use `UpdateProjectPasswordProtection$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectPasswordProtection$inboundSchema;
  /** @deprecated use `UpdateProjectPasswordProtection$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectPasswordProtection$outboundSchema;
  /** @deprecated use `UpdateProjectPasswordProtection$Outbound` instead. */
  export type Outbound = UpdateProjectPasswordProtection$Outbound;
}

/** @internal */
export const UpdateProjectFunctionDefaultMemoryType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectFunctionDefaultMemoryType> = z.nativeEnum(
    UpdateProjectFunctionDefaultMemoryType,
  );

/** @internal */
export const UpdateProjectFunctionDefaultMemoryType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectFunctionDefaultMemoryType> =
    UpdateProjectFunctionDefaultMemoryType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectFunctionDefaultMemoryType$ {
  /** @deprecated use `UpdateProjectFunctionDefaultMemoryType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectFunctionDefaultMemoryType$inboundSchema;
  /** @deprecated use `UpdateProjectFunctionDefaultMemoryType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectFunctionDefaultMemoryType$outboundSchema;
}

/** @internal */
export const UpdateProjectResourceConfig$inboundSchema: z.ZodType<
  UpdateProjectResourceConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType:
    UpdateProjectFunctionDefaultMemoryType$inboundSchema.optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectResourceConfig$Outbound = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?: string | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

/** @internal */
export const UpdateProjectResourceConfig$outboundSchema: z.ZodType<
  UpdateProjectResourceConfig$Outbound,
  z.ZodTypeDef,
  UpdateProjectResourceConfig
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType:
    UpdateProjectFunctionDefaultMemoryType$outboundSchema.optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectResourceConfig$ {
  /** @deprecated use `UpdateProjectResourceConfig$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectResourceConfig$inboundSchema;
  /** @deprecated use `UpdateProjectResourceConfig$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectResourceConfig$outboundSchema;
  /** @deprecated use `UpdateProjectResourceConfig$Outbound` instead. */
  export type Outbound = UpdateProjectResourceConfig$Outbound;
}

/** @internal */
export const UpdateProjectProjectsResponseDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsResponseDeploymentType> = z
    .nativeEnum(UpdateProjectProjectsResponseDeploymentType);

/** @internal */
export const UpdateProjectProjectsResponseDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsResponseDeploymentType> =
    UpdateProjectProjectsResponseDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponseDeploymentType$ {
  /** @deprecated use `UpdateProjectProjectsResponseDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponseDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponseDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponseDeploymentType$outboundSchema;
}

/** @internal */
export const UpdateProjectSsoProtection$inboundSchema: z.ZodType<
  UpdateProjectSsoProtection,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectProjectsResponseDeploymentType$inboundSchema,
});

/** @internal */
export type UpdateProjectSsoProtection$Outbound = {
  deploymentType: string;
};

/** @internal */
export const UpdateProjectSsoProtection$outboundSchema: z.ZodType<
  UpdateProjectSsoProtection$Outbound,
  z.ZodTypeDef,
  UpdateProjectSsoProtection
> = z.object({
  deploymentType: UpdateProjectProjectsResponseDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectSsoProtection$ {
  /** @deprecated use `UpdateProjectSsoProtection$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectSsoProtection$inboundSchema;
  /** @deprecated use `UpdateProjectSsoProtection$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectSsoProtection$outboundSchema;
  /** @deprecated use `UpdateProjectSsoProtection$Outbound` instead. */
  export type Outbound = UpdateProjectSsoProtection$Outbound;
}

/** @internal */
export const UpdateProjectProjectsAliasAssigned$inboundSchema: z.ZodType<
  UpdateProjectProjectsAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type UpdateProjectProjectsAliasAssigned$Outbound = number | boolean;

/** @internal */
export const UpdateProjectProjectsAliasAssigned$outboundSchema: z.ZodType<
  UpdateProjectProjectsAliasAssigned$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsAliasAssigned$ {
  /** @deprecated use `UpdateProjectProjectsAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsAliasAssigned$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsAliasAssigned$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsAliasAssigned$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsAliasAssigned$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsAliasAssigned$Outbound;
}

/** @internal */
export const UpdateProjectProjectsAliasError$inboundSchema: z.ZodType<
  UpdateProjectProjectsAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type UpdateProjectProjectsAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const UpdateProjectProjectsAliasError$outboundSchema: z.ZodType<
  UpdateProjectProjectsAliasError$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsAliasError$ {
  /** @deprecated use `UpdateProjectProjectsAliasError$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsAliasError$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsAliasError$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsAliasError$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsAliasError$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsAliasError$Outbound;
}

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsResponse200ApplicationJSONType> =
    z.nativeEnum(UpdateProjectProjectsResponse200ApplicationJSONType);

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsResponse200ApplicationJSONType> =
    UpdateProjectProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsBranchMatcher$inboundSchema: z.ZodType<
  UpdateProjectProjectsBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateProjectProjectsResponse200ApplicationJSONType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type UpdateProjectProjectsBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const UpdateProjectProjectsBranchMatcher$outboundSchema: z.ZodType<
  UpdateProjectProjectsBranchMatcher$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsBranchMatcher
> = z.object({
  type: UpdateProjectProjectsResponse200ApplicationJSONType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsBranchMatcher$ {
  /** @deprecated use `UpdateProjectProjectsBranchMatcher$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsBranchMatcher$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsBranchMatcher$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsBranchMatcher$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsBranchMatcher$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsBranchMatcher$Outbound;
}

/** @internal */
export const UpdateProjectProjectsBuilds$inboundSchema: z.ZodType<
  UpdateProjectProjectsBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type UpdateProjectProjectsBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const UpdateProjectProjectsBuilds$outboundSchema: z.ZodType<
  UpdateProjectProjectsBuilds$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsBuilds$ {
  /** @deprecated use `UpdateProjectProjectsBuilds$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsBuilds$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsBuilds$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsBuilds$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsBuilds$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsBuilds$Outbound;
}

/** @internal */
export const UpdateProjectProjectsChecksConclusion$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsChecksConclusion> = z.nativeEnum(
    UpdateProjectProjectsChecksConclusion,
  );

/** @internal */
export const UpdateProjectProjectsChecksConclusion$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsChecksConclusion> =
    UpdateProjectProjectsChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsChecksConclusion$ {
  /** @deprecated use `UpdateProjectProjectsChecksConclusion$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsChecksConclusion$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsChecksConclusion$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsChecksConclusion$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsChecksState$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsChecksState
> = z.nativeEnum(UpdateProjectProjectsChecksState);

/** @internal */
export const UpdateProjectProjectsChecksState$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsChecksState
> = UpdateProjectProjectsChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsChecksState$ {
  /** @deprecated use `UpdateProjectProjectsChecksState$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsChecksState$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsChecksState$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsChecksState$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsCreator$inboundSchema: z.ZodType<
  UpdateProjectProjectsCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type UpdateProjectProjectsCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const UpdateProjectProjectsCreator$outboundSchema: z.ZodType<
  UpdateProjectProjectsCreator$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsCreator$ {
  /** @deprecated use `UpdateProjectProjectsCreator$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsCreator$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsCreator$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsCreator$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsCreator$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsCreator$Outbound;
}

/** @internal */
export const UpdateProjectProjectsOidcTokenClaims$inboundSchema: z.ZodType<
  UpdateProjectProjectsOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type UpdateProjectProjectsOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const UpdateProjectProjectsOidcTokenClaims$outboundSchema: z.ZodType<
  UpdateProjectProjectsOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsOidcTokenClaims$ {
  /** @deprecated use `UpdateProjectProjectsOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsOidcTokenClaims$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsOidcTokenClaims$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsOidcTokenClaims$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsOidcTokenClaims$Outbound;
}

/** @internal */
export const UpdateProjectProjectsPlan$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsPlan
> = z.nativeEnum(UpdateProjectProjectsPlan);

/** @internal */
export const UpdateProjectProjectsPlan$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsPlan
> = UpdateProjectProjectsPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsPlan$ {
  /** @deprecated use `UpdateProjectProjectsPlan$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsPlan$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsPlan$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsPlan$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsReadyState$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsReadyState
> = z.nativeEnum(UpdateProjectProjectsReadyState);

/** @internal */
export const UpdateProjectProjectsReadyState$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsReadyState
> = UpdateProjectProjectsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsReadyState$ {
  /** @deprecated use `UpdateProjectProjectsReadyState$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsReadyState$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsReadyState$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsReadyState$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsReadySubstate
> = z.nativeEnum(UpdateProjectProjectsReadySubstate);

/** @internal */
export const UpdateProjectProjectsReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsReadySubstate
> = UpdateProjectProjectsReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsReadySubstate$ {
  /** @deprecated use `UpdateProjectProjectsReadySubstate$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsReadySubstate$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsReadySubstate$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsReadySubstate$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsResponseType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsResponseType
> = z.nativeEnum(UpdateProjectProjectsResponseType);

/** @internal */
export const UpdateProjectProjectsResponseType$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsResponseType
> = UpdateProjectProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponseType$ {
  /** @deprecated use `UpdateProjectProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsResponseType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponseType$outboundSchema;
}

/** @internal */
export const UpdateProjectTargets$inboundSchema: z.ZodType<
  UpdateProjectTargets,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => UpdateProjectProjectsAliasError$inboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => UpdateProjectProjectsBranchMatcher$inboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => UpdateProjectProjectsBuilds$inboundSchema))
    .optional(),
  checksConclusion: UpdateProjectProjectsChecksConclusion$inboundSchema
    .optional(),
  checksState: UpdateProjectProjectsChecksState$inboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => UpdateProjectProjectsCreator$inboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    UpdateProjectProjectsOidcTokenClaims$inboundSchema
  ).optional(),
  plan: UpdateProjectProjectsPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectProjectsReadyState$inboundSchema,
  readySubstate: UpdateProjectProjectsReadySubstate$inboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectProjectsResponseType$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectTargets$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: UpdateProjectProjectsAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: UpdateProjectProjectsBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<UpdateProjectProjectsBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: UpdateProjectProjectsCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: UpdateProjectProjectsOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const UpdateProjectTargets$outboundSchema: z.ZodType<
  UpdateProjectTargets$Outbound,
  z.ZodTypeDef,
  UpdateProjectTargets
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => UpdateProjectProjectsAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => UpdateProjectProjectsBranchMatcher$outboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => UpdateProjectProjectsBuilds$outboundSchema))
    .optional(),
  checksConclusion: UpdateProjectProjectsChecksConclusion$outboundSchema
    .optional(),
  checksState: UpdateProjectProjectsChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(
    z.lazy(() => UpdateProjectProjectsCreator$outboundSchema),
  ),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    UpdateProjectProjectsOidcTokenClaims$outboundSchema
  ).optional(),
  plan: UpdateProjectProjectsPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: UpdateProjectProjectsReadyState$outboundSchema,
  readySubstate: UpdateProjectProjectsReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: UpdateProjectProjectsResponseType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTargets$ {
  /** @deprecated use `UpdateProjectTargets$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTargets$inboundSchema;
  /** @deprecated use `UpdateProjectTargets$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTargets$outboundSchema;
  /** @deprecated use `UpdateProjectTargets$Outbound` instead. */
  export type Outbound = UpdateProjectTargets$Outbound;
}

/** @internal */
export const UpdateProjectPermissions$inboundSchema: z.ZodType<
  UpdateProjectPermissions,
  z.ZodTypeDef,
  unknown
> = z.object({
  accessGroup: z.array(ACLAction$inboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$inboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  auditLog: z.array(ACLAction$inboundSchema).optional(),
  billingAddress: z.array(ACLAction$inboundSchema).optional(),
  billingInformation: z.array(ACLAction$inboundSchema).optional(),
  billingInvoice: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$inboundSchema).optional(),
  billingPlan: z.array(ACLAction$inboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$inboundSchema).optional(),
  billingTaxId: z.array(ACLAction$inboundSchema).optional(),
  blob: z.array(ACLAction$inboundSchema).optional(),
  budget: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$inboundSchema).optional(),
  codeChecks: z.array(ACLAction$inboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$inboundSchema).optional(),
  connect: z.array(ACLAction$inboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$inboundSchema).optional(),
  domain: z.array(ACLAction$inboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$inboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$inboundSchema).optional(),
  domainCertificate: z.array(ACLAction$inboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  domainMove: z.array(ACLAction$inboundSchema).optional(),
  domainPurchase: z.array(ACLAction$inboundSchema).optional(),
  domainRecord: z.array(ACLAction$inboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$inboundSchema).optional(),
  event: z.array(ACLAction$inboundSchema).optional(),
  ownEvent: z.array(ACLAction$inboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$inboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$inboundSchema).optional(),
  gitRepository: z.array(ACLAction$inboundSchema).optional(),
  ipBlocking: z.array(ACLAction$inboundSchema).optional(),
  integration: z.array(ACLAction$inboundSchema).optional(),
  integrationAccount: z.array(ACLAction$inboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationProjects: z.array(ACLAction$inboundSchema).optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$inboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$inboundSchema).optional(),
  integrationResource: z.array(ACLAction$inboundSchema).optional(),
  integrationEvent: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$inboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$inboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$inboundSchema).optional(),
  jobGlobal: z.array(ACLAction$inboundSchema).optional(),
  logDrain: z.array(ACLAction$inboundSchema).optional(),
  Monitoring: z.array(ACLAction$inboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$inboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$inboundSchema).optional(),
  monitoringChart: z.array(ACLAction$inboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$inboundSchema).optional(),
  NotificationMonitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$inboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$inboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$inboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$inboundSchema).optional(),
  paymentMethod: z.array(ACLAction$inboundSchema).optional(),
  permissions: z.array(ACLAction$inboundSchema).optional(),
  postgres: z.array(ACLAction$inboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$inboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  space: z.array(ACLAction$inboundSchema).optional(),
  spaceRun: z.array(ACLAction$inboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$inboundSchema).optional(),
  rateLimit: z.array(ACLAction$inboundSchema).optional(),
  redis: z.array(ACLAction$inboundSchema).optional(),
  repository: z.array(ACLAction$inboundSchema).optional(),
  remoteCaching: z.array(ACLAction$inboundSchema).optional(),
  samlConfig: z.array(ACLAction$inboundSchema).optional(),
  secret: z.array(ACLAction$inboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$inboundSchema).optional(),
  storeTransfer: z.array(ACLAction$inboundSchema).optional(),
  supportCase: z.array(ACLAction$inboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$inboundSchema).optional(),
  team: z.array(ACLAction$inboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$inboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$inboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$inboundSchema).optional(),
  teamInvite: z.array(ACLAction$inboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$inboundSchema).optional(),
  teamJoin: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$inboundSchema).optional(),
  token: z.array(ACLAction$inboundSchema).optional(),
  usage: z.array(ACLAction$inboundSchema).optional(),
  usageCycle: z.array(ACLAction$inboundSchema).optional(),
  user: z.array(ACLAction$inboundSchema).optional(),
  userConnection: z.array(ACLAction$inboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$inboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$inboundSchema).optional(),
  webAuthn: z.array(ACLAction$inboundSchema).optional(),
  edgeConfig: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$inboundSchema).optional(),
  webhook: z.array(ACLAction$inboundSchema).optional(),
  "webhook-event": z.array(ACLAction$inboundSchema).optional(),
  endpointVerification: z.array(ACLAction$inboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$inboundSchema).optional(),
  oauth2Application: z.array(ACLAction$inboundSchema).optional(),
  aliasProject: z.array(ACLAction$inboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$inboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$inboundSchema).optional(),
  deployment: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$inboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$inboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$inboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$inboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$inboundSchema).optional(),
  environments: z.array(ACLAction$inboundSchema).optional(),
  logs: z.array(ACLAction$inboundSchema).optional(),
  logsPreset: z.array(ACLAction$inboundSchema).optional(),
  passwordProtection: z.array(ACLAction$inboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$inboundSchema).optional(),
  job: z.array(ACLAction$inboundSchema).optional(),
  project: z.array(ACLAction$inboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$inboundSchema).optional(),
  projectDomain: z.array(ACLAction$inboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$inboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$inboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$inboundSchema).optional(),
  projectId: z.array(ACLAction$inboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  projectLink: z.array(ACLAction$inboundSchema).optional(),
  projectMember: z.array(ACLAction$inboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$inboundSchema).optional(),
  projectPermissions: z.array(ACLAction$inboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$inboundSchema).optional(),
  projectTransfer: z.array(ACLAction$inboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$inboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  projectUsage: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$inboundSchema).optional(),
  projectTier: z.array(ACLAction$inboundSchema).optional(),
  seawallConfig: z.array(ACLAction$inboundSchema).optional(),
  skewProtection: z.array(ACLAction$inboundSchema).optional(),
  analytics: z.array(ACLAction$inboundSchema).optional(),
  trustedIps: z.array(ACLAction$inboundSchema).optional(),
  webAnalytics: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$inboundSchema).optional(),
  sonar: z.array(ACLAction$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "Monitoring": "monitoring",
    "NotificationMonitoringAlert": "notificationMonitoringAlert",
    "webhook-event": "webhookEvent",
  });
});

/** @internal */
export type UpdateProjectPermissions$Outbound = {
  accessGroup?: Array<string> | undefined;
  aliasGlobal?: Array<string> | undefined;
  analyticsSampling?: Array<string> | undefined;
  analyticsUsage?: Array<string> | undefined;
  auditLog?: Array<string> | undefined;
  billingAddress?: Array<string> | undefined;
  billingInformation?: Array<string> | undefined;
  billingInvoice?: Array<string> | undefined;
  billingInvoiceEmailRecipient?: Array<string> | undefined;
  billingInvoiceLanguage?: Array<string> | undefined;
  billingPlan?: Array<string> | undefined;
  billingPurchaseOrder?: Array<string> | undefined;
  billingTaxId?: Array<string> | undefined;
  blob?: Array<string> | undefined;
  budget?: Array<string> | undefined;
  cacheArtifact?: Array<string> | undefined;
  cacheArtifactUsageEvent?: Array<string> | undefined;
  codeChecks?: Array<string> | undefined;
  concurrentBuilds?: Array<string> | undefined;
  connect?: Array<string> | undefined;
  connectConfiguration?: Array<string> | undefined;
  domain?: Array<string> | undefined;
  domainAcceptDelegation?: Array<string> | undefined;
  domainAuthCodes?: Array<string> | undefined;
  domainCertificate?: Array<string> | undefined;
  domainCheckConfig?: Array<string> | undefined;
  domainMove?: Array<string> | undefined;
  domainPurchase?: Array<string> | undefined;
  domainRecord?: Array<string> | undefined;
  domainTransferIn?: Array<string> | undefined;
  event?: Array<string> | undefined;
  ownEvent?: Array<string> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<string> | undefined;
  fileUpload?: Array<string> | undefined;
  gitRepository?: Array<string> | undefined;
  ipBlocking?: Array<string> | undefined;
  integration?: Array<string> | undefined;
  integrationAccount?: Array<string> | undefined;
  integrationConfiguration?: Array<string> | undefined;
  integrationConfigurationTransfer?: Array<string> | undefined;
  integrationConfigurationProjects?: Array<string> | undefined;
  integrationVercelConfigurationOverride?: Array<string> | undefined;
  integrationConfigurationRole?: Array<string> | undefined;
  integrationResource?: Array<string> | undefined;
  integrationEvent?: Array<string> | undefined;
  integrationResourceSecrets?: Array<string> | undefined;
  integrationDeploymentAction?: Array<string> | undefined;
  marketplaceInstallationMember?: Array<string> | undefined;
  marketplaceBillingData?: Array<string> | undefined;
  marketplaceInvoice?: Array<string> | undefined;
  jobGlobal?: Array<string> | undefined;
  logDrain?: Array<string> | undefined;
  Monitoring?: Array<string> | undefined;
  monitoringSettings?: Array<string> | undefined;
  monitoringQuery?: Array<string> | undefined;
  monitoringChart?: Array<string> | undefined;
  monitoringAlert?: Array<string> | undefined;
  notificationDeploymentFailed?: Array<string> | undefined;
  notificationDomainConfiguration?: Array<string> | undefined;
  notificationDomainExpire?: Array<string> | undefined;
  notificationDomainMoved?: Array<string> | undefined;
  notificationDomainPurchase?: Array<string> | undefined;
  notificationDomainRenewal?: Array<string> | undefined;
  notificationDomainTransfer?: Array<string> | undefined;
  notificationDomainUnverified?: Array<string> | undefined;
  NotificationMonitoringAlert?: Array<string> | undefined;
  notificationPaymentFailed?: Array<string> | undefined;
  notificationUsageAlert?: Array<string> | undefined;
  notificationCustomerBudget?: Array<string> | undefined;
  notificationStatementOfReasons?: Array<string> | undefined;
  oauth2Connection?: Array<string> | undefined;
  openTelemetryEndpoint?: Array<string> | undefined;
  paymentMethod?: Array<string> | undefined;
  permissions?: Array<string> | undefined;
  postgres?: Array<string> | undefined;
  previewDeploymentSuffix?: Array<string> | undefined;
  proTrialOnboarding?: Array<string> | undefined;
  sharedEnvVars?: Array<string> | undefined;
  sharedEnvVarsProduction?: Array<string> | undefined;
  space?: Array<string> | undefined;
  spaceRun?: Array<string> | undefined;
  passwordProtectionInvoiceItem?: Array<string> | undefined;
  rateLimit?: Array<string> | undefined;
  redis?: Array<string> | undefined;
  repository?: Array<string> | undefined;
  remoteCaching?: Array<string> | undefined;
  samlConfig?: Array<string> | undefined;
  secret?: Array<string> | undefined;
  redisStoreTokenSet?: Array<string> | undefined;
  blobStoreTokenSet?: Array<string> | undefined;
  postgresStoreTokenSet?: Array<string> | undefined;
  integrationStoreTokenSet?: Array<string> | undefined;
  integrationResourceReplCommand?: Array<string> | undefined;
  storeTransfer?: Array<string> | undefined;
  supportCase?: Array<string> | undefined;
  supportCaseComment?: Array<string> | undefined;
  dataCacheBillingSettings?: Array<string> | undefined;
  team?: Array<string> | undefined;
  teamAccessRequest?: Array<string> | undefined;
  teamFellowMembership?: Array<string> | undefined;
  teamGitExclusivity?: Array<string> | undefined;
  teamInvite?: Array<string> | undefined;
  teamInviteCode?: Array<string> | undefined;
  teamJoin?: Array<string> | undefined;
  teamOwnMembership?: Array<string> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<string> | undefined;
  token?: Array<string> | undefined;
  usage?: Array<string> | undefined;
  usageCycle?: Array<string> | undefined;
  user?: Array<string> | undefined;
  userConnection?: Array<string> | undefined;
  vpcPeeringConnection?: Array<string> | undefined;
  webAnalyticsPlan?: Array<string> | undefined;
  webAuthn?: Array<string> | undefined;
  edgeConfig?: Array<string> | undefined;
  edgeConfigItem?: Array<string> | undefined;
  edgeConfigSchema?: Array<string> | undefined;
  edgeConfigToken?: Array<string> | undefined;
  webhook?: Array<string> | undefined;
  "webhook-event"?: Array<string> | undefined;
  endpointVerification?: Array<string> | undefined;
  projectTransferIn?: Array<string> | undefined;
  oauth2Application?: Array<string> | undefined;
  aliasProject?: Array<string> | undefined;
  aliasProtectionBypass?: Array<string> | undefined;
  productionAliasProtectionBypass?: Array<string> | undefined;
  connectConfigurationLink?: Array<string> | undefined;
  dataCacheNamespace?: Array<string> | undefined;
  deployment?: Array<string> | undefined;
  deploymentCheck?: Array<string> | undefined;
  deploymentCheckPreview?: Array<string> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<string> | undefined;
  deploymentProductionGit?: Array<string> | undefined;
  deploymentPreview?: Array<string> | undefined;
  deploymentPrivate?: Array<string> | undefined;
  deploymentPromote?: Array<string> | undefined;
  deploymentRollback?: Array<string> | undefined;
  environments?: Array<string> | undefined;
  logs?: Array<string> | undefined;
  logsPreset?: Array<string> | undefined;
  passwordProtection?: Array<string> | undefined;
  optionsAllowlist?: Array<string> | undefined;
  job?: Array<string> | undefined;
  project?: Array<string> | undefined;
  projectAccessGroup?: Array<string> | undefined;
  projectAnalyticsSampling?: Array<string> | undefined;
  projectDeploymentHook?: Array<string> | undefined;
  projectDomain?: Array<string> | undefined;
  projectDomainMove?: Array<string> | undefined;
  projectDomainCheckConfig?: Array<string> | undefined;
  projectEnvVars?: Array<string> | undefined;
  projectEnvVarsProduction?: Array<string> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<string> | undefined;
  projectFlags?: Array<string> | undefined;
  projectId?: Array<string> | undefined;
  projectIntegrationConfiguration?: Array<string> | undefined;
  projectLink?: Array<string> | undefined;
  projectMember?: Array<string> | undefined;
  projectMonitoring?: Array<string> | undefined;
  projectPermissions?: Array<string> | undefined;
  projectProductionBranch?: Array<string> | undefined;
  projectTransfer?: Array<string> | undefined;
  projectTransferOut?: Array<string> | undefined;
  projectProtectionBypass?: Array<string> | undefined;
  projectUsage?: Array<string> | undefined;
  projectAnalyticsUsage?: Array<string> | undefined;
  projectSupportCase?: Array<string> | undefined;
  projectSupportCaseComment?: Array<string> | undefined;
  projectDeploymentExpiration?: Array<string> | undefined;
  projectTier?: Array<string> | undefined;
  seawallConfig?: Array<string> | undefined;
  skewProtection?: Array<string> | undefined;
  analytics?: Array<string> | undefined;
  trustedIps?: Array<string> | undefined;
  webAnalytics?: Array<string> | undefined;
  sharedEnvVarConnection?: Array<string> | undefined;
  sonar?: Array<string> | undefined;
};

/** @internal */
export const UpdateProjectPermissions$outboundSchema: z.ZodType<
  UpdateProjectPermissions$Outbound,
  z.ZodTypeDef,
  UpdateProjectPermissions
> = z.object({
  accessGroup: z.array(ACLAction$outboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$outboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  auditLog: z.array(ACLAction$outboundSchema).optional(),
  billingAddress: z.array(ACLAction$outboundSchema).optional(),
  billingInformation: z.array(ACLAction$outboundSchema).optional(),
  billingInvoice: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$outboundSchema).optional(),
  billingPlan: z.array(ACLAction$outboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$outboundSchema).optional(),
  billingTaxId: z.array(ACLAction$outboundSchema).optional(),
  blob: z.array(ACLAction$outboundSchema).optional(),
  budget: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$outboundSchema).optional(),
  codeChecks: z.array(ACLAction$outboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$outboundSchema).optional(),
  connect: z.array(ACLAction$outboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$outboundSchema).optional(),
  domain: z.array(ACLAction$outboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$outboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$outboundSchema).optional(),
  domainCertificate: z.array(ACLAction$outboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  domainMove: z.array(ACLAction$outboundSchema).optional(),
  domainPurchase: z.array(ACLAction$outboundSchema).optional(),
  domainRecord: z.array(ACLAction$outboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$outboundSchema).optional(),
  event: z.array(ACLAction$outboundSchema).optional(),
  ownEvent: z.array(ACLAction$outboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$outboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$outboundSchema).optional(),
  gitRepository: z.array(ACLAction$outboundSchema).optional(),
  ipBlocking: z.array(ACLAction$outboundSchema).optional(),
  integration: z.array(ACLAction$outboundSchema).optional(),
  integrationAccount: z.array(ACLAction$outboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationProjects: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$outboundSchema).optional(),
  integrationResource: z.array(ACLAction$outboundSchema).optional(),
  integrationEvent: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$outboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$outboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$outboundSchema).optional(),
  jobGlobal: z.array(ACLAction$outboundSchema).optional(),
  logDrain: z.array(ACLAction$outboundSchema).optional(),
  monitoring: z.array(ACLAction$outboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$outboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$outboundSchema).optional(),
  monitoringChart: z.array(ACLAction$outboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$outboundSchema).optional(),
  notificationMonitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$outboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$outboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$outboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$outboundSchema).optional(),
  paymentMethod: z.array(ACLAction$outboundSchema).optional(),
  permissions: z.array(ACLAction$outboundSchema).optional(),
  postgres: z.array(ACLAction$outboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$outboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  space: z.array(ACLAction$outboundSchema).optional(),
  spaceRun: z.array(ACLAction$outboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$outboundSchema).optional(),
  rateLimit: z.array(ACLAction$outboundSchema).optional(),
  redis: z.array(ACLAction$outboundSchema).optional(),
  repository: z.array(ACLAction$outboundSchema).optional(),
  remoteCaching: z.array(ACLAction$outboundSchema).optional(),
  samlConfig: z.array(ACLAction$outboundSchema).optional(),
  secret: z.array(ACLAction$outboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$outboundSchema).optional(),
  storeTransfer: z.array(ACLAction$outboundSchema).optional(),
  supportCase: z.array(ACLAction$outboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$outboundSchema).optional(),
  team: z.array(ACLAction$outboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$outboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$outboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$outboundSchema).optional(),
  teamInvite: z.array(ACLAction$outboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$outboundSchema).optional(),
  teamJoin: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$outboundSchema).optional(),
  token: z.array(ACLAction$outboundSchema).optional(),
  usage: z.array(ACLAction$outboundSchema).optional(),
  usageCycle: z.array(ACLAction$outboundSchema).optional(),
  user: z.array(ACLAction$outboundSchema).optional(),
  userConnection: z.array(ACLAction$outboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$outboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$outboundSchema).optional(),
  webAuthn: z.array(ACLAction$outboundSchema).optional(),
  edgeConfig: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$outboundSchema).optional(),
  webhook: z.array(ACLAction$outboundSchema).optional(),
  webhookEvent: z.array(ACLAction$outboundSchema).optional(),
  endpointVerification: z.array(ACLAction$outboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$outboundSchema).optional(),
  oauth2Application: z.array(ACLAction$outboundSchema).optional(),
  aliasProject: z.array(ACLAction$outboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$outboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$outboundSchema).optional(),
  deployment: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$outboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$outboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$outboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$outboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$outboundSchema).optional(),
  environments: z.array(ACLAction$outboundSchema).optional(),
  logs: z.array(ACLAction$outboundSchema).optional(),
  logsPreset: z.array(ACLAction$outboundSchema).optional(),
  passwordProtection: z.array(ACLAction$outboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$outboundSchema).optional(),
  job: z.array(ACLAction$outboundSchema).optional(),
  project: z.array(ACLAction$outboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$outboundSchema).optional(),
  projectDomain: z.array(ACLAction$outboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$outboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$outboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$outboundSchema).optional(),
  projectId: z.array(ACLAction$outboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  projectLink: z.array(ACLAction$outboundSchema).optional(),
  projectMember: z.array(ACLAction$outboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$outboundSchema).optional(),
  projectPermissions: z.array(ACLAction$outboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$outboundSchema).optional(),
  projectTransfer: z.array(ACLAction$outboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$outboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  projectUsage: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$outboundSchema).optional(),
  projectTier: z.array(ACLAction$outboundSchema).optional(),
  seawallConfig: z.array(ACLAction$outboundSchema).optional(),
  skewProtection: z.array(ACLAction$outboundSchema).optional(),
  analytics: z.array(ACLAction$outboundSchema).optional(),
  trustedIps: z.array(ACLAction$outboundSchema).optional(),
  webAnalytics: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$outboundSchema).optional(),
  sonar: z.array(ACLAction$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    monitoring: "Monitoring",
    notificationMonitoringAlert: "NotificationMonitoringAlert",
    webhookEvent: "webhook-event",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectPermissions$ {
  /** @deprecated use `UpdateProjectPermissions$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectPermissions$inboundSchema;
  /** @deprecated use `UpdateProjectPermissions$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectPermissions$outboundSchema;
  /** @deprecated use `UpdateProjectPermissions$Outbound` instead. */
  export type Outbound = UpdateProjectPermissions$Outbound;
}

/** @internal */
export const UpdateProjectLastRollbackTarget$inboundSchema: z.ZodType<
  UpdateProjectLastRollbackTarget,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type UpdateProjectLastRollbackTarget$Outbound = {};

/** @internal */
export const UpdateProjectLastRollbackTarget$outboundSchema: z.ZodType<
  UpdateProjectLastRollbackTarget$Outbound,
  z.ZodTypeDef,
  UpdateProjectLastRollbackTarget
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLastRollbackTarget$ {
  /** @deprecated use `UpdateProjectLastRollbackTarget$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLastRollbackTarget$inboundSchema;
  /** @deprecated use `UpdateProjectLastRollbackTarget$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLastRollbackTarget$outboundSchema;
  /** @deprecated use `UpdateProjectLastRollbackTarget$Outbound` instead. */
  export type Outbound = UpdateProjectLastRollbackTarget$Outbound;
}

/** @internal */
export const UpdateProjectJobStatus$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectJobStatus
> = z.nativeEnum(UpdateProjectJobStatus);

/** @internal */
export const UpdateProjectJobStatus$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectJobStatus
> = UpdateProjectJobStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectJobStatus$ {
  /** @deprecated use `UpdateProjectJobStatus$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectJobStatus$inboundSchema;
  /** @deprecated use `UpdateProjectJobStatus$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectJobStatus$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsResponse200Type> = z.nativeEnum(
    UpdateProjectProjectsResponse200Type,
  );

/** @internal */
export const UpdateProjectProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectProjectsResponse200Type> =
    UpdateProjectProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponse200Type$ {
  /** @deprecated use `UpdateProjectProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponse200Type$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const UpdateProjectLastAliasRequest$inboundSchema: z.ZodType<
  UpdateProjectLastAliasRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: UpdateProjectJobStatus$inboundSchema,
  requestedAt: z.number(),
  type: UpdateProjectProjectsResponse200Type$inboundSchema,
});

/** @internal */
export type UpdateProjectLastAliasRequest$Outbound = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: string;
  requestedAt: number;
  type: string;
};

/** @internal */
export const UpdateProjectLastAliasRequest$outboundSchema: z.ZodType<
  UpdateProjectLastAliasRequest$Outbound,
  z.ZodTypeDef,
  UpdateProjectLastAliasRequest
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: UpdateProjectJobStatus$outboundSchema,
  requestedAt: z.number(),
  type: UpdateProjectProjectsResponse200Type$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectLastAliasRequest$ {
  /** @deprecated use `UpdateProjectLastAliasRequest$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectLastAliasRequest$inboundSchema;
  /** @deprecated use `UpdateProjectLastAliasRequest$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectLastAliasRequest$outboundSchema;
  /** @deprecated use `UpdateProjectLastAliasRequest$Outbound` instead. */
  export type Outbound = UpdateProjectLastAliasRequest$Outbound;
}

/** @internal */
export const UpdateProjectScope$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectScope
> = z.nativeEnum(UpdateProjectScope);

/** @internal */
export const UpdateProjectScope$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectScope
> = UpdateProjectScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectScope$ {
  /** @deprecated use `UpdateProjectScope$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectScope$inboundSchema;
  /** @deprecated use `UpdateProjectScope$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectScope$outboundSchema;
}

/** @internal */
export const UpdateProjectProtectionBypass$inboundSchema: z.ZodType<
  UpdateProjectProtectionBypass,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: UpdateProjectScope$inboundSchema,
});

/** @internal */
export type UpdateProjectProtectionBypass$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const UpdateProjectProtectionBypass$outboundSchema: z.ZodType<
  UpdateProjectProtectionBypass$Outbound,
  z.ZodTypeDef,
  UpdateProjectProtectionBypass
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: UpdateProjectScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProtectionBypass$ {
  /** @deprecated use `UpdateProjectProtectionBypass$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProtectionBypass$inboundSchema;
  /** @deprecated use `UpdateProjectProtectionBypass$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProtectionBypass$outboundSchema;
  /** @deprecated use `UpdateProjectProtectionBypass$Outbound` instead. */
  export type Outbound = UpdateProjectProtectionBypass$Outbound;
}

/** @internal */
export const UpdateProjectTrustedIpsProjectsDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectTrustedIpsProjectsDeploymentType> = z
    .nativeEnum(UpdateProjectTrustedIpsProjectsDeploymentType);

/** @internal */
export const UpdateProjectTrustedIpsProjectsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectTrustedIpsProjectsDeploymentType> =
    UpdateProjectTrustedIpsProjectsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIpsProjectsDeploymentType$ {
  /** @deprecated use `UpdateProjectTrustedIpsProjectsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectTrustedIpsProjectsDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIpsProjectsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectTrustedIpsProjectsDeploymentType$outboundSchema;
}

/** @internal */
export const UpdateProjectTrustedIps2$inboundSchema: z.ZodType<
  UpdateProjectTrustedIps2,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectTrustedIpsProjectsDeploymentType$inboundSchema,
});

/** @internal */
export type UpdateProjectTrustedIps2$Outbound = {
  deploymentType: string;
};

/** @internal */
export const UpdateProjectTrustedIps2$outboundSchema: z.ZodType<
  UpdateProjectTrustedIps2$Outbound,
  z.ZodTypeDef,
  UpdateProjectTrustedIps2
> = z.object({
  deploymentType: UpdateProjectTrustedIpsProjectsDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIps2$ {
  /** @deprecated use `UpdateProjectTrustedIps2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTrustedIps2$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIps2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTrustedIps2$outboundSchema;
  /** @deprecated use `UpdateProjectTrustedIps2$Outbound` instead. */
  export type Outbound = UpdateProjectTrustedIps2$Outbound;
}

/** @internal */
export const UpdateProjectTrustedIpsDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectTrustedIpsDeploymentType> = z.nativeEnum(
    UpdateProjectTrustedIpsDeploymentType,
  );

/** @internal */
export const UpdateProjectTrustedIpsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectTrustedIpsDeploymentType> =
    UpdateProjectTrustedIpsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIpsDeploymentType$ {
  /** @deprecated use `UpdateProjectTrustedIpsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectTrustedIpsDeploymentType$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIpsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectTrustedIpsDeploymentType$outboundSchema;
}

/** @internal */
export const UpdateProjectTrustedIpsAddresses$inboundSchema: z.ZodType<
  UpdateProjectTrustedIpsAddresses,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/** @internal */
export type UpdateProjectTrustedIpsAddresses$Outbound = {
  value: string;
  note?: string | undefined;
};

/** @internal */
export const UpdateProjectTrustedIpsAddresses$outboundSchema: z.ZodType<
  UpdateProjectTrustedIpsAddresses$Outbound,
  z.ZodTypeDef,
  UpdateProjectTrustedIpsAddresses
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIpsAddresses$ {
  /** @deprecated use `UpdateProjectTrustedIpsAddresses$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTrustedIpsAddresses$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIpsAddresses$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTrustedIpsAddresses$outboundSchema;
  /** @deprecated use `UpdateProjectTrustedIpsAddresses$Outbound` instead. */
  export type Outbound = UpdateProjectTrustedIpsAddresses$Outbound;
}

/** @internal */
export const UpdateProjectTrustedIpsProtectionMode$inboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectTrustedIpsProtectionMode> = z.nativeEnum(
    UpdateProjectTrustedIpsProtectionMode,
  );

/** @internal */
export const UpdateProjectTrustedIpsProtectionMode$outboundSchema:
  z.ZodNativeEnum<typeof UpdateProjectTrustedIpsProtectionMode> =
    UpdateProjectTrustedIpsProtectionMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIpsProtectionMode$ {
  /** @deprecated use `UpdateProjectTrustedIpsProtectionMode$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectTrustedIpsProtectionMode$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIpsProtectionMode$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectTrustedIpsProtectionMode$outboundSchema;
}

/** @internal */
export const UpdateProjectTrustedIps1$inboundSchema: z.ZodType<
  UpdateProjectTrustedIps1,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: UpdateProjectTrustedIpsDeploymentType$inboundSchema,
  addresses: z.array(
    z.lazy(() => UpdateProjectTrustedIpsAddresses$inboundSchema),
  ),
  protectionMode: UpdateProjectTrustedIpsProtectionMode$inboundSchema,
});

/** @internal */
export type UpdateProjectTrustedIps1$Outbound = {
  deploymentType: string;
  addresses: Array<UpdateProjectTrustedIpsAddresses$Outbound>;
  protectionMode: string;
};

/** @internal */
export const UpdateProjectTrustedIps1$outboundSchema: z.ZodType<
  UpdateProjectTrustedIps1$Outbound,
  z.ZodTypeDef,
  UpdateProjectTrustedIps1
> = z.object({
  deploymentType: UpdateProjectTrustedIpsDeploymentType$outboundSchema,
  addresses: z.array(
    z.lazy(() => UpdateProjectTrustedIpsAddresses$outboundSchema),
  ),
  protectionMode: UpdateProjectTrustedIpsProtectionMode$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIps1$ {
  /** @deprecated use `UpdateProjectTrustedIps1$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTrustedIps1$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIps1$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTrustedIps1$outboundSchema;
  /** @deprecated use `UpdateProjectTrustedIps1$Outbound` instead. */
  export type Outbound = UpdateProjectTrustedIps1$Outbound;
}

/** @internal */
export const UpdateProjectTrustedIps$inboundSchema: z.ZodType<
  UpdateProjectTrustedIps,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateProjectTrustedIps2$inboundSchema),
  z.lazy(() => UpdateProjectTrustedIps1$inboundSchema),
]);

/** @internal */
export type UpdateProjectTrustedIps$Outbound =
  | UpdateProjectTrustedIps2$Outbound
  | UpdateProjectTrustedIps1$Outbound;

/** @internal */
export const UpdateProjectTrustedIps$outboundSchema: z.ZodType<
  UpdateProjectTrustedIps$Outbound,
  z.ZodTypeDef,
  UpdateProjectTrustedIps
> = z.union([
  z.lazy(() => UpdateProjectTrustedIps2$outboundSchema),
  z.lazy(() => UpdateProjectTrustedIps1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTrustedIps$ {
  /** @deprecated use `UpdateProjectTrustedIps$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTrustedIps$inboundSchema;
  /** @deprecated use `UpdateProjectTrustedIps$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTrustedIps$outboundSchema;
  /** @deprecated use `UpdateProjectTrustedIps$Outbound` instead. */
  export type Outbound = UpdateProjectTrustedIps$Outbound;
}

/** @internal */
export const UpdateProjectGitComments$inboundSchema: z.ZodType<
  UpdateProjectGitComments,
  z.ZodTypeDef,
  unknown
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/** @internal */
export type UpdateProjectGitComments$Outbound = {
  onPullRequest: boolean;
  onCommit: boolean;
};

/** @internal */
export const UpdateProjectGitComments$outboundSchema: z.ZodType<
  UpdateProjectGitComments$Outbound,
  z.ZodTypeDef,
  UpdateProjectGitComments
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectGitComments$ {
  /** @deprecated use `UpdateProjectGitComments$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectGitComments$inboundSchema;
  /** @deprecated use `UpdateProjectGitComments$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectGitComments$outboundSchema;
  /** @deprecated use `UpdateProjectGitComments$Outbound` instead. */
  export type Outbound = UpdateProjectGitComments$Outbound;
}

/** @internal */
export const UpdateProjectWebAnalytics$inboundSchema: z.ZodType<
  UpdateProjectWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const UpdateProjectWebAnalytics$outboundSchema: z.ZodType<
  UpdateProjectWebAnalytics$Outbound,
  z.ZodTypeDef,
  UpdateProjectWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectWebAnalytics$ {
  /** @deprecated use `UpdateProjectWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectWebAnalytics$inboundSchema;
  /** @deprecated use `UpdateProjectWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectWebAnalytics$outboundSchema;
  /** @deprecated use `UpdateProjectWebAnalytics$Outbound` instead. */
  export type Outbound = UpdateProjectWebAnalytics$Outbound;
}

/** @internal */
export const UpdateProjectSrc2$inboundSchema: z.ZodType<
  UpdateProjectSrc2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type UpdateProjectSrc2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const UpdateProjectSrc2$outboundSchema: z.ZodType<
  UpdateProjectSrc2$Outbound,
  z.ZodTypeDef,
  UpdateProjectSrc2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectSrc2$ {
  /** @deprecated use `UpdateProjectSrc2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectSrc2$inboundSchema;
  /** @deprecated use `UpdateProjectSrc2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectSrc2$outboundSchema;
  /** @deprecated use `UpdateProjectSrc2$Outbound` instead. */
  export type Outbound = UpdateProjectSrc2$Outbound;
}

/** @internal */
export const UpdateProjectSrc$inboundSchema: z.ZodType<
  UpdateProjectSrc,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => UpdateProjectSrc2$inboundSchema), z.string()]);

/** @internal */
export type UpdateProjectSrc$Outbound = UpdateProjectSrc2$Outbound | string;

/** @internal */
export const UpdateProjectSrc$outboundSchema: z.ZodType<
  UpdateProjectSrc$Outbound,
  z.ZodTypeDef,
  UpdateProjectSrc
> = z.union([z.lazy(() => UpdateProjectSrc2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectSrc$ {
  /** @deprecated use `UpdateProjectSrc$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectSrc$inboundSchema;
  /** @deprecated use `UpdateProjectSrc$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectSrc$outboundSchema;
  /** @deprecated use `UpdateProjectSrc$Outbound` instead. */
  export type Outbound = UpdateProjectSrc$Outbound;
}

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType
  > = z.nativeEnum(
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType,
  );

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType
  > =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$ {
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema;
}

/** @internal */
export const UpdateProjectValue2$inboundSchema: z.ZodType<
  UpdateProjectValue2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type UpdateProjectValue2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const UpdateProjectValue2$outboundSchema: z.ZodType<
  UpdateProjectValue2$Outbound,
  z.ZodTypeDef,
  UpdateProjectValue2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectValue2$ {
  /** @deprecated use `UpdateProjectValue2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectValue2$inboundSchema;
  /** @deprecated use `UpdateProjectValue2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectValue2$outboundSchema;
  /** @deprecated use `UpdateProjectValue2$Outbound` instead. */
  export type Outbound = UpdateProjectValue2$Outbound;
}

/** @internal */
export const UpdateProjectValue$inboundSchema: z.ZodType<
  UpdateProjectValue,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => UpdateProjectValue2$inboundSchema), z.string()]);

/** @internal */
export type UpdateProjectValue$Outbound = UpdateProjectValue2$Outbound | string;

/** @internal */
export const UpdateProjectValue$outboundSchema: z.ZodType<
  UpdateProjectValue$Outbound,
  z.ZodTypeDef,
  UpdateProjectValue
> = z.union([z.lazy(() => UpdateProjectValue2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectValue$ {
  /** @deprecated use `UpdateProjectValue$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectValue$inboundSchema;
  /** @deprecated use `UpdateProjectValue$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectValue$outboundSchema;
  /** @deprecated use `UpdateProjectValue$Outbound` instead. */
  export type Outbound = UpdateProjectValue$Outbound;
}

/** @internal */
export const UpdateProjectHas$inboundSchema: z.ZodType<
  UpdateProjectHas,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema,
  key: z.string().optional(),
  value: z.union([z.lazy(() => UpdateProjectValue2$inboundSchema), z.string()])
    .optional(),
});

/** @internal */
export type UpdateProjectHas$Outbound = {
  type: string;
  key?: string | undefined;
  value?: UpdateProjectValue2$Outbound | string | undefined;
};

/** @internal */
export const UpdateProjectHas$outboundSchema: z.ZodType<
  UpdateProjectHas$Outbound,
  z.ZodTypeDef,
  UpdateProjectHas
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema,
  key: z.string().optional(),
  value: z.union([z.lazy(() => UpdateProjectValue2$outboundSchema), z.string()])
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectHas$ {
  /** @deprecated use `UpdateProjectHas$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectHas$inboundSchema;
  /** @deprecated use `UpdateProjectHas$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectHas$outboundSchema;
  /** @deprecated use `UpdateProjectHas$Outbound` instead. */
  export type Outbound = UpdateProjectHas$Outbound;
}

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  > = z.nativeEnum(
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType,
  );

/** @internal */
export const UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  > =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$ {
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema;
}

/** @internal */
export const UpdateProjectValueProjects2$inboundSchema: z.ZodType<
  UpdateProjectValueProjects2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type UpdateProjectValueProjects2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const UpdateProjectValueProjects2$outboundSchema: z.ZodType<
  UpdateProjectValueProjects2$Outbound,
  z.ZodTypeDef,
  UpdateProjectValueProjects2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectValueProjects2$ {
  /** @deprecated use `UpdateProjectValueProjects2$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectValueProjects2$inboundSchema;
  /** @deprecated use `UpdateProjectValueProjects2$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectValueProjects2$outboundSchema;
  /** @deprecated use `UpdateProjectValueProjects2$Outbound` instead. */
  export type Outbound = UpdateProjectValueProjects2$Outbound;
}

/** @internal */
export const UpdateProjectProjectsValue$inboundSchema: z.ZodType<
  UpdateProjectProjectsValue,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateProjectValueProjects2$inboundSchema),
  z.string(),
]);

/** @internal */
export type UpdateProjectProjectsValue$Outbound =
  | UpdateProjectValueProjects2$Outbound
  | string;

/** @internal */
export const UpdateProjectProjectsValue$outboundSchema: z.ZodType<
  UpdateProjectProjectsValue$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsValue
> = z.union([
  z.lazy(() => UpdateProjectValueProjects2$outboundSchema),
  z.string(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsValue$ {
  /** @deprecated use `UpdateProjectProjectsValue$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsValue$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsValue$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsValue$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsValue$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsValue$Outbound;
}

/** @internal */
export const UpdateProjectMissing$inboundSchema: z.ZodType<
  UpdateProjectMissing,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => UpdateProjectValueProjects2$inboundSchema),
    z.string(),
  ]).optional(),
});

/** @internal */
export type UpdateProjectMissing$Outbound = {
  type: string;
  key?: string | undefined;
  value?: UpdateProjectValueProjects2$Outbound | string | undefined;
};

/** @internal */
export const UpdateProjectMissing$outboundSchema: z.ZodType<
  UpdateProjectMissing$Outbound,
  z.ZodTypeDef,
  UpdateProjectMissing
> = z.object({
  type:
    UpdateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => UpdateProjectValueProjects2$outboundSchema),
    z.string(),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectMissing$ {
  /** @deprecated use `UpdateProjectMissing$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectMissing$inboundSchema;
  /** @deprecated use `UpdateProjectMissing$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectMissing$outboundSchema;
  /** @deprecated use `UpdateProjectMissing$Outbound` instead. */
  export type Outbound = UpdateProjectMissing$Outbound;
}

/** @internal */
export const UpdateProjectHandle$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectHandle
> = z.nativeEnum(UpdateProjectHandle);

/** @internal */
export const UpdateProjectHandle$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectHandle
> = UpdateProjectHandle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectHandle$ {
  /** @deprecated use `UpdateProjectHandle$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectHandle$inboundSchema;
  /** @deprecated use `UpdateProjectHandle$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectHandle$outboundSchema;
}

/** @internal */
export const UpdateProjectAction$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectAction
> = z.nativeEnum(UpdateProjectAction);

/** @internal */
export const UpdateProjectAction$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectAction
> = UpdateProjectAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectAction$ {
  /** @deprecated use `UpdateProjectAction$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectAction$inboundSchema;
  /** @deprecated use `UpdateProjectAction$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectAction$outboundSchema;
}

/** @internal */
export const UpdateProjectAlgo$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectAlgo
> = z.nativeEnum(UpdateProjectAlgo);

/** @internal */
export const UpdateProjectAlgo$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectAlgo
> = UpdateProjectAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectAlgo$ {
  /** @deprecated use `UpdateProjectAlgo$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectAlgo$inboundSchema;
  /** @deprecated use `UpdateProjectAlgo$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectAlgo$outboundSchema;
}

/** @internal */
export const UpdateProjectErl$inboundSchema: z.ZodType<
  UpdateProjectErl,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: UpdateProjectAlgo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
});

/** @internal */
export type UpdateProjectErl$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
};

/** @internal */
export const UpdateProjectErl$outboundSchema: z.ZodType<
  UpdateProjectErl$Outbound,
  z.ZodTypeDef,
  UpdateProjectErl
> = z.object({
  algo: UpdateProjectAlgo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectErl$ {
  /** @deprecated use `UpdateProjectErl$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectErl$inboundSchema;
  /** @deprecated use `UpdateProjectErl$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectErl$outboundSchema;
  /** @deprecated use `UpdateProjectErl$Outbound` instead. */
  export type Outbound = UpdateProjectErl$Outbound;
}

/** @internal */
export const UpdateProjectMitigate$inboundSchema: z.ZodType<
  UpdateProjectMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateProjectAction$inboundSchema,
  rule_id: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => UpdateProjectErl$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "rule_id": "ruleId",
  });
});

/** @internal */
export type UpdateProjectMitigate$Outbound = {
  action: string;
  rule_id: string;
  ttl?: number | undefined;
  erl?: UpdateProjectErl$Outbound | undefined;
};

/** @internal */
export const UpdateProjectMitigate$outboundSchema: z.ZodType<
  UpdateProjectMitigate$Outbound,
  z.ZodTypeDef,
  UpdateProjectMitigate
> = z.object({
  action: UpdateProjectAction$outboundSchema,
  ruleId: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => UpdateProjectErl$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    ruleId: "rule_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectMitigate$ {
  /** @deprecated use `UpdateProjectMitigate$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectMitigate$inboundSchema;
  /** @deprecated use `UpdateProjectMitigate$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectMitigate$outboundSchema;
  /** @deprecated use `UpdateProjectMitigate$Outbound` instead. */
  export type Outbound = UpdateProjectMitigate$Outbound;
}

/** @internal */
export const UpdateProjectFirewallRoutes$inboundSchema: z.ZodType<
  UpdateProjectFirewallRoutes,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.union([z.lazy(() => UpdateProjectSrc2$inboundSchema), z.string()])
    .optional(),
  has: z.array(z.lazy(() => UpdateProjectHas$inboundSchema)).optional(),
  missing: z.array(z.lazy(() => UpdateProjectMissing$inboundSchema)).optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: UpdateProjectHandle$inboundSchema.optional(),
  mitigate: z.lazy(() => UpdateProjectMitigate$inboundSchema).optional(),
});

/** @internal */
export type UpdateProjectFirewallRoutes$Outbound = {
  src?: UpdateProjectSrc2$Outbound | string | undefined;
  has?: Array<UpdateProjectHas$Outbound> | undefined;
  missing?: Array<UpdateProjectMissing$Outbound> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: string | undefined;
  mitigate?: UpdateProjectMitigate$Outbound | undefined;
};

/** @internal */
export const UpdateProjectFirewallRoutes$outboundSchema: z.ZodType<
  UpdateProjectFirewallRoutes$Outbound,
  z.ZodTypeDef,
  UpdateProjectFirewallRoutes
> = z.object({
  src: z.union([z.lazy(() => UpdateProjectSrc2$outboundSchema), z.string()])
    .optional(),
  has: z.array(z.lazy(() => UpdateProjectHas$outboundSchema)).optional(),
  missing: z.array(z.lazy(() => UpdateProjectMissing$outboundSchema))
    .optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: UpdateProjectHandle$outboundSchema.optional(),
  mitigate: z.lazy(() => UpdateProjectMitigate$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectFirewallRoutes$ {
  /** @deprecated use `UpdateProjectFirewallRoutes$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectFirewallRoutes$inboundSchema;
  /** @deprecated use `UpdateProjectFirewallRoutes$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectFirewallRoutes$outboundSchema;
  /** @deprecated use `UpdateProjectFirewallRoutes$Outbound` instead. */
  export type Outbound = UpdateProjectFirewallRoutes$Outbound;
}

/** @internal */
export const UpdateProjectSecurity$inboundSchema: z.ZodType<
  UpdateProjectSecurity,
  z.ZodTypeDef,
  unknown
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(
    z.lazy(() => UpdateProjectFirewallRoutes$inboundSchema),
  ).optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/** @internal */
export type UpdateProjectSecurity$Outbound = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<UpdateProjectFirewallRoutes$Outbound> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/** @internal */
export const UpdateProjectSecurity$outboundSchema: z.ZodType<
  UpdateProjectSecurity$Outbound,
  z.ZodTypeDef,
  UpdateProjectSecurity
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(
    z.lazy(() => UpdateProjectFirewallRoutes$outboundSchema),
  ).optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectSecurity$ {
  /** @deprecated use `UpdateProjectSecurity$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectSecurity$inboundSchema;
  /** @deprecated use `UpdateProjectSecurity$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectSecurity$outboundSchema;
  /** @deprecated use `UpdateProjectSecurity$Outbound` instead. */
  export type Outbound = UpdateProjectSecurity$Outbound;
}

/** @internal */
export const UpdateProjectProjectsIssuerMode$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsIssuerMode
> = z.nativeEnum(UpdateProjectProjectsIssuerMode);

/** @internal */
export const UpdateProjectProjectsIssuerMode$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectProjectsIssuerMode
> = UpdateProjectProjectsIssuerMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsIssuerMode$ {
  /** @deprecated use `UpdateProjectProjectsIssuerMode$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectProjectsIssuerMode$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsIssuerMode$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectProjectsIssuerMode$outboundSchema;
}

/** @internal */
export const UpdateProjectProjectsOidcTokenConfig$inboundSchema: z.ZodType<
  UpdateProjectProjectsOidcTokenConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean(),
  issuerMode: UpdateProjectProjectsIssuerMode$inboundSchema.optional(),
});

/** @internal */
export type UpdateProjectProjectsOidcTokenConfig$Outbound = {
  enabled: boolean;
  issuerMode?: string | undefined;
};

/** @internal */
export const UpdateProjectProjectsOidcTokenConfig$outboundSchema: z.ZodType<
  UpdateProjectProjectsOidcTokenConfig$Outbound,
  z.ZodTypeDef,
  UpdateProjectProjectsOidcTokenConfig
> = z.object({
  enabled: z.boolean(),
  issuerMode: UpdateProjectProjectsIssuerMode$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectProjectsOidcTokenConfig$ {
  /** @deprecated use `UpdateProjectProjectsOidcTokenConfig$inboundSchema` instead. */
  export const inboundSchema =
    UpdateProjectProjectsOidcTokenConfig$inboundSchema;
  /** @deprecated use `UpdateProjectProjectsOidcTokenConfig$outboundSchema` instead. */
  export const outboundSchema =
    UpdateProjectProjectsOidcTokenConfig$outboundSchema;
  /** @deprecated use `UpdateProjectProjectsOidcTokenConfig$Outbound` instead. */
  export type Outbound = UpdateProjectProjectsOidcTokenConfig$Outbound;
}

/** @internal */
export const UpdateProjectTier$inboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectTier
> = z.nativeEnum(UpdateProjectTier);

/** @internal */
export const UpdateProjectTier$outboundSchema: z.ZodNativeEnum<
  typeof UpdateProjectTier
> = UpdateProjectTier$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectTier$ {
  /** @deprecated use `UpdateProjectTier$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectTier$inboundSchema;
  /** @deprecated use `UpdateProjectTier$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectTier$outboundSchema;
}

/** @internal */
export const UpdateProjectResponseBody$inboundSchema: z.ZodType<
  UpdateProjectResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => UpdateProjectAnalytics$inboundSchema).optional(),
  speedInsights: z.lazy(() => UpdateProjectSpeedInsights$inboundSchema)
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => UpdateProjectCrons$inboundSchema).optional(),
  dataCache: z.lazy(() => UpdateProjectDataCache$inboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => UpdateProjectDeploymentExpiration$inboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => UpdateProjectEnv$inboundSchema)).optional(),
  customEnvironments: z.array(
    z.lazy(() => UpdateProjectCustomEnvironments$inboundSchema),
  ).optional(),
  framework: z.nullable(UpdateProjectProjectsFramework$inboundSchema)
    .optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => UpdateProjectIpBuckets$inboundSchema))
    .optional(),
  latestDeployments: z.array(
    z.lazy(() => UpdateProjectLatestDeployments$inboundSchema),
  ).optional(),
  link: z.union([
    z.lazy(() => UpdateProjectLink1$inboundSchema),
    z.lazy(() => UpdateProjectLink3$inboundSchema),
    z.lazy(() => UpdateProjectLink2$inboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => UpdateProjectMicrofrontends$inboundSchema)
    .optional(),
  name: z.string(),
  nodeVersion: UpdateProjectProjectsNodeVersion$inboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => UpdateProjectOptionsAllowlist$inboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => UpdateProjectPasswordProtection$inboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => UpdateProjectResourceConfig$inboundSchema)
    .optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => UpdateProjectSsoProtection$inboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => UpdateProjectTargets$inboundSchema))
    .optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => UpdateProjectPermissions$inboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => UpdateProjectLastRollbackTarget$inboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(
    z.lazy(() => UpdateProjectLastAliasRequest$inboundSchema),
  ).optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(
    z.lazy(() => UpdateProjectProtectionBypass$inboundSchema),
  ).optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => UpdateProjectTrustedIps2$inboundSchema),
      z.lazy(() => UpdateProjectTrustedIps1$inboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => UpdateProjectGitComments$inboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => UpdateProjectWebAnalytics$inboundSchema)
    .optional(),
  security: z.lazy(() => UpdateProjectSecurity$inboundSchema).optional(),
  oidcTokenConfig: z.lazy(() =>
    UpdateProjectProjectsOidcTokenConfig$inboundSchema
  ).optional(),
  tier: UpdateProjectTier$inboundSchema.optional(),
});

/** @internal */
export type UpdateProjectResponseBody$Outbound = {
  accountId: string;
  analytics?: UpdateProjectAnalytics$Outbound | undefined;
  speedInsights?: UpdateProjectSpeedInsights$Outbound | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: UpdateProjectCrons$Outbound | undefined;
  dataCache?: UpdateProjectDataCache$Outbound | undefined;
  deploymentExpiration?:
    | UpdateProjectDeploymentExpiration$Outbound
    | null
    | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<UpdateProjectEnv$Outbound> | undefined;
  customEnvironments?:
    | Array<UpdateProjectCustomEnvironments$Outbound>
    | undefined;
  framework?: string | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<UpdateProjectIpBuckets$Outbound> | undefined;
  latestDeployments?:
    | Array<UpdateProjectLatestDeployments$Outbound>
    | undefined;
  link?:
    | UpdateProjectLink1$Outbound
    | UpdateProjectLink3$Outbound
    | UpdateProjectLink2$Outbound
    | undefined;
  microfrontends?: UpdateProjectMicrofrontends$Outbound | undefined;
  name: string;
  nodeVersion: string;
  optionsAllowlist?: UpdateProjectOptionsAllowlist$Outbound | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?:
    | UpdateProjectPasswordProtection$Outbound
    | null
    | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: UpdateProjectResourceConfig$Outbound | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: UpdateProjectSsoProtection$Outbound | null | undefined;
  targets?: { [k: string]: UpdateProjectTargets$Outbound } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: UpdateProjectPermissions$Outbound | undefined;
  lastRollbackTarget?:
    | UpdateProjectLastRollbackTarget$Outbound
    | null
    | undefined;
  lastAliasRequest?: UpdateProjectLastAliasRequest$Outbound | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?:
    | { [k: string]: UpdateProjectProtectionBypass$Outbound }
    | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?:
    | UpdateProjectTrustedIps2$Outbound
    | UpdateProjectTrustedIps1$Outbound
    | null
    | undefined;
  gitComments?: UpdateProjectGitComments$Outbound | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: UpdateProjectWebAnalytics$Outbound | undefined;
  security?: UpdateProjectSecurity$Outbound | undefined;
  oidcTokenConfig?: UpdateProjectProjectsOidcTokenConfig$Outbound | undefined;
  tier?: string | undefined;
};

/** @internal */
export const UpdateProjectResponseBody$outboundSchema: z.ZodType<
  UpdateProjectResponseBody$Outbound,
  z.ZodTypeDef,
  UpdateProjectResponseBody
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => UpdateProjectAnalytics$outboundSchema).optional(),
  speedInsights: z.lazy(() => UpdateProjectSpeedInsights$outboundSchema)
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => UpdateProjectCrons$outboundSchema).optional(),
  dataCache: z.lazy(() => UpdateProjectDataCache$outboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => UpdateProjectDeploymentExpiration$outboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => UpdateProjectEnv$outboundSchema)).optional(),
  customEnvironments: z.array(
    z.lazy(() => UpdateProjectCustomEnvironments$outboundSchema),
  ).optional(),
  framework: z.nullable(UpdateProjectProjectsFramework$outboundSchema)
    .optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => UpdateProjectIpBuckets$outboundSchema))
    .optional(),
  latestDeployments: z.array(
    z.lazy(() => UpdateProjectLatestDeployments$outboundSchema),
  ).optional(),
  link: z.union([
    z.lazy(() => UpdateProjectLink1$outboundSchema),
    z.lazy(() => UpdateProjectLink3$outboundSchema),
    z.lazy(() => UpdateProjectLink2$outboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => UpdateProjectMicrofrontends$outboundSchema)
    .optional(),
  name: z.string(),
  nodeVersion: UpdateProjectProjectsNodeVersion$outboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => UpdateProjectOptionsAllowlist$outboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => UpdateProjectPasswordProtection$outboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => UpdateProjectResourceConfig$outboundSchema)
    .optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => UpdateProjectSsoProtection$outboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => UpdateProjectTargets$outboundSchema))
    .optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => UpdateProjectPermissions$outboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => UpdateProjectLastRollbackTarget$outboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(
    z.lazy(() => UpdateProjectLastAliasRequest$outboundSchema),
  ).optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(
    z.lazy(() => UpdateProjectProtectionBypass$outboundSchema),
  ).optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => UpdateProjectTrustedIps2$outboundSchema),
      z.lazy(() => UpdateProjectTrustedIps1$outboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => UpdateProjectGitComments$outboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => UpdateProjectWebAnalytics$outboundSchema)
    .optional(),
  security: z.lazy(() => UpdateProjectSecurity$outboundSchema).optional(),
  oidcTokenConfig: z.lazy(() =>
    UpdateProjectProjectsOidcTokenConfig$outboundSchema
  ).optional(),
  tier: UpdateProjectTier$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateProjectResponseBody$ {
  /** @deprecated use `UpdateProjectResponseBody$inboundSchema` instead. */
  export const inboundSchema = UpdateProjectResponseBody$inboundSchema;
  /** @deprecated use `UpdateProjectResponseBody$outboundSchema` instead. */
  export const outboundSchema = UpdateProjectResponseBody$outboundSchema;
  /** @deprecated use `UpdateProjectResponseBody$Outbound` instead. */
  export type Outbound = UpdateProjectResponseBody$Outbound;
}
