/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

export const UpdateFirewallConfigRequestBodySecurityRequest11Action = {
  ManagedRulesUpdate: "managedRules.update",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest11Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest11Action
>;

export const RequestBodyId = {
  Owasp: "owasp",
} as const;
export type RequestBodyId = ClosedEnum<typeof RequestBodyId>;

export type UpdateFirewallConfigRequestBodySecurityRequest11Value = {
  active: boolean;
};

/**
 * Update a managed ruleset
 */
export type Eleven = {
  action: UpdateFirewallConfigRequestBodySecurityRequest11Action;
  id: RequestBodyId;
  value: UpdateFirewallConfigRequestBodySecurityRequest11Value;
};

export const UpdateFirewallConfigRequestBodySecurityRequest10Action = {
  IpRemove: "ip.remove",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest10Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest10Action
>;

/**
 * Remove an IP Blocking rule
 */
export type RequestBody10 = {
  action: UpdateFirewallConfigRequestBodySecurityRequest10Action;
  id: string;
  value?: any | null | undefined;
};

export const UpdateFirewallConfigRequestBodySecurityRequest9Action = {
  IpUpdate: "ip.update",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest9Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest9Action
>;

export const UpdateFirewallConfigRequestBodySecurityRequest9ValueAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest9ValueAction =
  ClosedEnum<typeof UpdateFirewallConfigRequestBodySecurityRequest9ValueAction>;

export type UpdateFirewallConfigRequestBodySecurityRequest9Value = {
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: UpdateFirewallConfigRequestBodySecurityRequest9ValueAction;
};

/**
 * Update an IP Blocking rule
 */
export type RequestBody9 = {
  action: UpdateFirewallConfigRequestBodySecurityRequest9Action;
  id: string;
  value: UpdateFirewallConfigRequestBodySecurityRequest9Value;
};

export const UpdateFirewallConfigRequestBodySecurityRequest8Action = {
  IpInsert: "ip.insert",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest8Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest8Action
>;

export const UpdateFirewallConfigRequestBodySecurityRequest8ValueAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest8ValueAction =
  ClosedEnum<typeof UpdateFirewallConfigRequestBodySecurityRequest8ValueAction>;

export type UpdateFirewallConfigRequestBodySecurityRequestValue = {
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: UpdateFirewallConfigRequestBodySecurityRequest8ValueAction;
};

/**
 * Add an IP Blocking rule
 */
export type RequestBody8 = {
  action: UpdateFirewallConfigRequestBodySecurityRequest8Action;
  id?: any | null | undefined;
  value: UpdateFirewallConfigRequestBodySecurityRequestValue;
};

export const UpdateFirewallConfigRequestBodySecurityRequest7Action = {
  CrsDisable: "crs.disable",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest7Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest7Action
>;

/**
 * Disable a managed rule
 */
export type RequestBody7 = {
  action: UpdateFirewallConfigRequestBodySecurityRequest7Action;
  id?: any | null | undefined;
  value?: any | null | undefined;
};

export const UpdateFirewallConfigRequestBodySecurityRequest6Action = {
  CrsUpdate: "crs.update",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest6Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest6Action
>;

export const Id = {
  Sd: "sd",
  Ma: "ma",
  Lfi: "lfi",
  Rfi: "rfi",
  Rce: "rce",
  Php: "php",
  Gen: "gen",
  Xss: "xss",
  Sqli: "sqli",
  Sf: "sf",
  Java: "java",
} as const;
export type Id = ClosedEnum<typeof Id>;

export const UpdateFirewallConfigRequestBodySecurityRequest6ValueAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest6ValueAction =
  ClosedEnum<typeof UpdateFirewallConfigRequestBodySecurityRequest6ValueAction>;

export type UpdateFirewallConfigRequestBodySecurityValue = {
  active: boolean;
  action: UpdateFirewallConfigRequestBodySecurityRequest6ValueAction;
};

/**
 * Enable a managed rule
 */
export type RequestBody6 = {
  action: UpdateFirewallConfigRequestBodySecurityRequest6Action;
  id: Id;
  value: UpdateFirewallConfigRequestBodySecurityValue;
};

export const UpdateFirewallConfigRequestBodySecurityRequest5Action = {
  RulesPriority: "rules.priority",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest5Action = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequest5Action
>;

/**
 * Reorder a custom rule
 */
export type UpdateFirewallConfigRequestBody5 = {
  action: UpdateFirewallConfigRequestBodySecurityRequest5Action;
  id: string;
  value: number;
};

export const UpdateFirewallConfigRequestBodySecurityRequestAction = {
  RulesRemove: "rules.remove",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequestAction = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityRequestAction
>;

/**
 * Remove a custom rule
 */
export type UpdateFirewallConfigRequestBody4 = {
  action: UpdateFirewallConfigRequestBodySecurityRequestAction;
  id: string;
  value?: any | null | undefined;
};

export const UpdateFirewallConfigRequestBodySecurityAction = {
  RulesUpdate: "rules.update",
} as const;
export type UpdateFirewallConfigRequestBodySecurityAction = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityAction
>;

export const UpdateFirewallConfigRequestBodySecurityType = {
  Host: "host",
  Path: "path",
  Method: "method",
  Header: "header",
  Query: "query",
  Cookie: "cookie",
  TargetPath: "target_path",
  IpAddress: "ip_address",
  Region: "region",
  Protocol: "protocol",
  Scheme: "scheme",
  Environment: "environment",
  UserAgent: "user_agent",
  GeoContinent: "geo_continent",
  GeoCountry: "geo_country",
  GeoCountryRegion: "geo_country_region",
  GeoCity: "geo_city",
  GeoAsNumber: "geo_as_number",
  Ja4Digest: "ja4_digest",
  Ja3Digest: "ja3_digest",
  RateLimitApiId: "rate_limit_api_id",
} as const;
export type UpdateFirewallConfigRequestBodySecurityType = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodySecurityType
>;

export const UpdateFirewallConfigRequestBodyOp = {
  Re: "re",
  Eq: "eq",
  Neq: "neq",
  Ex: "ex",
  Nex: "nex",
  Inc: "inc",
  Ninc: "ninc",
  Pre: "pre",
  Suf: "suf",
  Sub: "sub",
  Gt: "gt",
  Gte: "gte",
  Lt: "lt",
  Lte: "lte",
} as const;
export type UpdateFirewallConfigRequestBodyOp = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodyOp
>;

export type UpdateFirewallConfigRequestBodySecurityRequest3Value =
  | string
  | Array<string>
  | number;

export type UpdateFirewallConfigRequestBodyConditions = {
  type: UpdateFirewallConfigRequestBodySecurityType;
  op: UpdateFirewallConfigRequestBodyOp;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | Array<string> | number | undefined;
};

export type UpdateFirewallConfigRequestBodyConditionGroup = {
  conditions: Array<UpdateFirewallConfigRequestBodyConditions>;
};

export const UpdateFirewallConfigRequestBodySecurityRequest3ValueAction = {
  Log: "log",
  Challenge: "challenge",
  Deny: "deny",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest3ValueAction =
  ClosedEnum<typeof UpdateFirewallConfigRequestBodySecurityRequest3ValueAction>;

export const UpdateFirewallConfigRateLimitAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type UpdateFirewallConfigRateLimitAlgo = ClosedEnum<
  typeof UpdateFirewallConfigRateLimitAlgo
>;

export const UpdateFirewallConfigActionSecurity1 = {
  Log: "log",
  Challenge: "challenge",
  Deny: "deny",
  RateLimit: "rate_limit",
} as const;
export type UpdateFirewallConfigActionSecurity1 = ClosedEnum<
  typeof UpdateFirewallConfigActionSecurity1
>;

export type UpdateFirewallConfigRateLimitSecurityAction =
  | UpdateFirewallConfigActionSecurity1
  | any;

export type UpdateFirewallConfigRateLimitSecurity1 = {
  algo: UpdateFirewallConfigRateLimitAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: UpdateFirewallConfigActionSecurity1 | any | null | undefined;
};

export type UpdateFirewallConfigRequestBodyRateLimit =
  | UpdateFirewallConfigRateLimitSecurity1
  | any;

export type UpdateFirewallConfigRedirectSecurity1 = {
  location: string;
  permanent: boolean;
};

export type UpdateFirewallConfigRequestBodyRedirect =
  | UpdateFirewallConfigRedirectSecurity1
  | any;

export type UpdateFirewallConfigRequestBodyMitigate = {
  action: UpdateFirewallConfigRequestBodySecurityRequest3ValueAction;
  rateLimit?: UpdateFirewallConfigRateLimitSecurity1 | any | null | undefined;
  redirect?: UpdateFirewallConfigRedirectSecurity1 | any | null | undefined;
  actionDuration?: string | null | undefined;
};

export type UpdateFirewallConfigRequestBodySecurityRequest3Action = {
  mitigate?: UpdateFirewallConfigRequestBodyMitigate | undefined;
};

export type UpdateFirewallConfigRequestBodyValue = {
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<UpdateFirewallConfigRequestBodyConditionGroup>;
  action: UpdateFirewallConfigRequestBodySecurityRequest3Action;
};

/**
 * Update a custom rule
 */
export type UpdateFirewallConfigRequestBody3 = {
  action: UpdateFirewallConfigRequestBodySecurityAction;
  id: string;
  value: UpdateFirewallConfigRequestBodyValue;
};

export const UpdateFirewallConfigRequestBodyAction = {
  RulesInsert: "rules.insert",
} as const;
export type UpdateFirewallConfigRequestBodyAction = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodyAction
>;

export const UpdateFirewallConfigRequestBodyType = {
  Host: "host",
  Path: "path",
  Method: "method",
  Header: "header",
  Query: "query",
  Cookie: "cookie",
  TargetPath: "target_path",
  IpAddress: "ip_address",
  Region: "region",
  Protocol: "protocol",
  Scheme: "scheme",
  Environment: "environment",
  UserAgent: "user_agent",
  GeoContinent: "geo_continent",
  GeoCountry: "geo_country",
  GeoCountryRegion: "geo_country_region",
  GeoCity: "geo_city",
  GeoAsNumber: "geo_as_number",
  Ja4Digest: "ja4_digest",
  Ja3Digest: "ja3_digest",
  RateLimitApiId: "rate_limit_api_id",
} as const;
export type UpdateFirewallConfigRequestBodyType = ClosedEnum<
  typeof UpdateFirewallConfigRequestBodyType
>;

export const RequestBodyOp = {
  Re: "re",
  Eq: "eq",
  Neq: "neq",
  Ex: "ex",
  Nex: "nex",
  Inc: "inc",
  Ninc: "ninc",
  Pre: "pre",
  Suf: "suf",
  Sub: "sub",
  Gt: "gt",
  Gte: "gte",
  Lt: "lt",
  Lte: "lte",
} as const;
export type RequestBodyOp = ClosedEnum<typeof RequestBodyOp>;

export type UpdateFirewallConfigRequestBodySecurityRequest2Value =
  | string
  | Array<string>
  | number;

export type RequestBodyConditions = {
  type: UpdateFirewallConfigRequestBodyType;
  op: RequestBodyOp;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | Array<string> | number | undefined;
};

export type RequestBodyConditionGroup = {
  conditions: Array<RequestBodyConditions>;
};

export const UpdateFirewallConfigRequestBodySecurityRequest2ValueAction = {
  Log: "log",
  Challenge: "challenge",
  Deny: "deny",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type UpdateFirewallConfigRequestBodySecurityRequest2ValueAction =
  ClosedEnum<typeof UpdateFirewallConfigRequestBodySecurityRequest2ValueAction>;

export const RateLimitAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type RateLimitAlgo = ClosedEnum<typeof RateLimitAlgo>;

export const UpdateFirewallConfigAction1 = {
  Log: "log",
  Challenge: "challenge",
  Deny: "deny",
  RateLimit: "rate_limit",
} as const;
export type UpdateFirewallConfigAction1 = ClosedEnum<
  typeof UpdateFirewallConfigAction1
>;

export type UpdateFirewallConfigRateLimitAction =
  | UpdateFirewallConfigAction1
  | any;

export type UpdateFirewallConfigRateLimit1 = {
  algo: RateLimitAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: UpdateFirewallConfigAction1 | any | null | undefined;
};

export type RequestBodyRateLimit = UpdateFirewallConfigRateLimit1 | any;

export type UpdateFirewallConfigRedirect1 = {
  location: string;
  permanent: boolean;
};

export type RequestBodyRedirect = UpdateFirewallConfigRedirect1 | any;

export type RequestBodyMitigate = {
  action: UpdateFirewallConfigRequestBodySecurityRequest2ValueAction;
  rateLimit?: UpdateFirewallConfigRateLimit1 | any | null | undefined;
  redirect?: UpdateFirewallConfigRedirect1 | any | null | undefined;
  actionDuration?: string | null | undefined;
};

export type UpdateFirewallConfigRequestBodySecurityRequest2Action = {
  mitigate?: RequestBodyMitigate | undefined;
};

export type RequestBodyValue = {
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<RequestBodyConditionGroup>;
  action: UpdateFirewallConfigRequestBodySecurityRequest2Action;
};

/**
 * Add a custom rule
 */
export type UpdateFirewallConfigRequestBody2 = {
  action: UpdateFirewallConfigRequestBodyAction;
  id?: any | null | undefined;
  value: RequestBodyValue;
};

export const RequestBodyAction = {
  FirewallEnabled: "firewallEnabled",
} as const;
export type RequestBodyAction = ClosedEnum<typeof RequestBodyAction>;

/**
 * Enable Firewall
 */
export type UpdateFirewallConfigRequestBody1 = {
  action: RequestBodyAction;
  id?: any | null | undefined;
  value: boolean;
};

export type UpdateFirewallConfigRequestBody =
  | UpdateFirewallConfigRequestBody1
  | UpdateFirewallConfigRequestBody2
  | UpdateFirewallConfigRequestBody3
  | UpdateFirewallConfigRequestBody4
  | UpdateFirewallConfigRequestBody5
  | RequestBody6
  | RequestBody7
  | RequestBody8
  | RequestBody9
  | RequestBody10
  | Eleven;

export type UpdateFirewallConfigRequest = {
  projectId: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?:
    | UpdateFirewallConfigRequestBody1
    | UpdateFirewallConfigRequestBody2
    | UpdateFirewallConfigRequestBody3
    | UpdateFirewallConfigRequestBody4
    | UpdateFirewallConfigRequestBody5
    | RequestBody6
    | RequestBody7
    | RequestBody8
    | RequestBody9
    | RequestBody10
    | Eleven
    | undefined;
};

export type UpdateFirewallConfigResponseBody = {};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest11Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest11Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest11Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest11Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest11Action
  > = UpdateFirewallConfigRequestBodySecurityRequest11Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest11Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest11Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest11Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest11Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest11Action$outboundSchema;
}

/** @internal */
export const RequestBodyId$inboundSchema: z.ZodNativeEnum<
  typeof RequestBodyId
> = z.nativeEnum(RequestBodyId);

/** @internal */
export const RequestBodyId$outboundSchema: z.ZodNativeEnum<
  typeof RequestBodyId
> = RequestBodyId$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyId$ {
  /** @deprecated use `RequestBodyId$inboundSchema` instead. */
  export const inboundSchema = RequestBodyId$inboundSchema;
  /** @deprecated use `RequestBodyId$outboundSchema` instead. */
  export const outboundSchema = RequestBodyId$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest11Value$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest11Value,
    z.ZodTypeDef,
    unknown
  > = z.object({
    active: z.boolean(),
  });

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequest11Value$Outbound = {
  active: boolean;
};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest11Value$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest11Value$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequest11Value
  > = z.object({
    active: z.boolean(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest11Value$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest11Value$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest11Value$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest11Value$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest11Value$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest11Value$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequest11Value$Outbound;
}

/** @internal */
export const Eleven$inboundSchema: z.ZodType<Eleven, z.ZodTypeDef, unknown> = z
  .object({
    action:
      UpdateFirewallConfigRequestBodySecurityRequest11Action$inboundSchema,
    id: RequestBodyId$inboundSchema,
    value: z.lazy(() =>
      UpdateFirewallConfigRequestBodySecurityRequest11Value$inboundSchema
    ),
  });

/** @internal */
export type Eleven$Outbound = {
  action: string;
  id: string;
  value: UpdateFirewallConfigRequestBodySecurityRequest11Value$Outbound;
};

/** @internal */
export const Eleven$outboundSchema: z.ZodType<
  Eleven$Outbound,
  z.ZodTypeDef,
  Eleven
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest11Action$outboundSchema,
  id: RequestBodyId$outboundSchema,
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest11Value$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Eleven$ {
  /** @deprecated use `Eleven$inboundSchema` instead. */
  export const inboundSchema = Eleven$inboundSchema;
  /** @deprecated use `Eleven$outboundSchema` instead. */
  export const outboundSchema = Eleven$outboundSchema;
  /** @deprecated use `Eleven$Outbound` instead. */
  export type Outbound = Eleven$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest10Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest10Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest10Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest10Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest10Action
  > = UpdateFirewallConfigRequestBodySecurityRequest10Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest10Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest10Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest10Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest10Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest10Action$outboundSchema;
}

/** @internal */
export const RequestBody10$inboundSchema: z.ZodType<
  RequestBody10,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest10Action$inboundSchema,
  id: z.string(),
  value: z.nullable(z.any()).optional(),
});

/** @internal */
export type RequestBody10$Outbound = {
  action: string;
  id: string;
  value?: any | null | undefined;
};

/** @internal */
export const RequestBody10$outboundSchema: z.ZodType<
  RequestBody10$Outbound,
  z.ZodTypeDef,
  RequestBody10
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest10Action$outboundSchema,
  id: z.string(),
  value: z.nullable(z.any()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody10$ {
  /** @deprecated use `RequestBody10$inboundSchema` instead. */
  export const inboundSchema = RequestBody10$inboundSchema;
  /** @deprecated use `RequestBody10$outboundSchema` instead. */
  export const outboundSchema = RequestBody10$outboundSchema;
  /** @deprecated use `RequestBody10$Outbound` instead. */
  export type Outbound = RequestBody10$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest9Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest9Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest9Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest9Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest9Action
  > = UpdateFirewallConfigRequestBodySecurityRequest9Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest9Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest9Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest9Action$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest9ValueAction
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest9ValueAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest9ValueAction
  > = UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest9Value$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest9Value,
    z.ZodTypeDef,
    unknown
  > = z.object({
    hostname: z.string(),
    ip: z.string(),
    notes: z.string().optional(),
    action:
      UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$inboundSchema,
  });

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequest9Value$Outbound = {
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: string;
};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest9Value$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest9Value$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequest9Value
  > = z.object({
    hostname: z.string(),
    ip: z.string(),
    notes: z.string().optional(),
    action:
      UpdateFirewallConfigRequestBodySecurityRequest9ValueAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest9Value$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9Value$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest9Value$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9Value$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest9Value$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest9Value$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequest9Value$Outbound;
}

/** @internal */
export const RequestBody9$inboundSchema: z.ZodType<
  RequestBody9,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest9Action$inboundSchema,
  id: z.string(),
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest9Value$inboundSchema
  ),
});

/** @internal */
export type RequestBody9$Outbound = {
  action: string;
  id: string;
  value: UpdateFirewallConfigRequestBodySecurityRequest9Value$Outbound;
};

/** @internal */
export const RequestBody9$outboundSchema: z.ZodType<
  RequestBody9$Outbound,
  z.ZodTypeDef,
  RequestBody9
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest9Action$outboundSchema,
  id: z.string(),
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest9Value$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody9$ {
  /** @deprecated use `RequestBody9$inboundSchema` instead. */
  export const inboundSchema = RequestBody9$inboundSchema;
  /** @deprecated use `RequestBody9$outboundSchema` instead. */
  export const outboundSchema = RequestBody9$outboundSchema;
  /** @deprecated use `RequestBody9$Outbound` instead. */
  export type Outbound = RequestBody9$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest8Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest8Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest8Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest8Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest8Action
  > = UpdateFirewallConfigRequestBodySecurityRequest8Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest8Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest8Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest8Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest8Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest8Action$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest8ValueAction
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest8ValueAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest8ValueAction
  > = UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequestValue$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequestValue,
    z.ZodTypeDef,
    unknown
  > = z.object({
    hostname: z.string(),
    ip: z.string(),
    notes: z.string().optional(),
    action:
      UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$inboundSchema,
  });

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequestValue$Outbound = {
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: string;
};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequestValue$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequestValue$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequestValue
  > = z.object({
    hostname: z.string(),
    ip: z.string(),
    notes: z.string().optional(),
    action:
      UpdateFirewallConfigRequestBodySecurityRequest8ValueAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequestValue$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequestValue$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequestValue$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequestValue$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequestValue$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequestValue$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequestValue$Outbound;
}

/** @internal */
export const RequestBody8$inboundSchema: z.ZodType<
  RequestBody8,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest8Action$inboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequestValue$inboundSchema
  ),
});

/** @internal */
export type RequestBody8$Outbound = {
  action: string;
  id?: any | null | undefined;
  value: UpdateFirewallConfigRequestBodySecurityRequestValue$Outbound;
};

/** @internal */
export const RequestBody8$outboundSchema: z.ZodType<
  RequestBody8$Outbound,
  z.ZodTypeDef,
  RequestBody8
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest8Action$outboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequestValue$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody8$ {
  /** @deprecated use `RequestBody8$inboundSchema` instead. */
  export const inboundSchema = RequestBody8$inboundSchema;
  /** @deprecated use `RequestBody8$outboundSchema` instead. */
  export const outboundSchema = RequestBody8$outboundSchema;
  /** @deprecated use `RequestBody8$Outbound` instead. */
  export type Outbound = RequestBody8$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest7Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest7Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest7Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest7Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest7Action
  > = UpdateFirewallConfigRequestBodySecurityRequest7Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest7Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest7Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest7Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest7Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest7Action$outboundSchema;
}

/** @internal */
export const RequestBody7$inboundSchema: z.ZodType<
  RequestBody7,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest7Action$inboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.nullable(z.any()).optional(),
});

/** @internal */
export type RequestBody7$Outbound = {
  action: string;
  id?: any | null | undefined;
  value?: any | null | undefined;
};

/** @internal */
export const RequestBody7$outboundSchema: z.ZodType<
  RequestBody7$Outbound,
  z.ZodTypeDef,
  RequestBody7
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest7Action$outboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.nullable(z.any()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody7$ {
  /** @deprecated use `RequestBody7$inboundSchema` instead. */
  export const inboundSchema = RequestBody7$inboundSchema;
  /** @deprecated use `RequestBody7$outboundSchema` instead. */
  export const outboundSchema = RequestBody7$outboundSchema;
  /** @deprecated use `RequestBody7$Outbound` instead. */
  export type Outbound = RequestBody7$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest6Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest6Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest6Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest6Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest6Action
  > = UpdateFirewallConfigRequestBodySecurityRequest6Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest6Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest6Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest6Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest6Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest6Action$outboundSchema;
}

/** @internal */
export const Id$inboundSchema: z.ZodNativeEnum<typeof Id> = z.nativeEnum(Id);

/** @internal */
export const Id$outboundSchema: z.ZodNativeEnum<typeof Id> = Id$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Id$ {
  /** @deprecated use `Id$inboundSchema` instead. */
  export const inboundSchema = Id$inboundSchema;
  /** @deprecated use `Id$outboundSchema` instead. */
  export const outboundSchema = Id$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest6ValueAction
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest6ValueAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest6ValueAction
  > = UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityValue$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityValue,
    z.ZodTypeDef,
    unknown
  > = z.object({
    active: z.boolean(),
    action:
      UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$inboundSchema,
  });

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityValue$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityValue$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityValue$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityValue
  > = z.object({
    active: z.boolean(),
    action:
      UpdateFirewallConfigRequestBodySecurityRequest6ValueAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityValue$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityValue$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityValue$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityValue$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityValue$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityValue$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodySecurityValue$Outbound;
}

/** @internal */
export const RequestBody6$inboundSchema: z.ZodType<
  RequestBody6,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest6Action$inboundSchema,
  id: Id$inboundSchema,
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityValue$inboundSchema
  ),
});

/** @internal */
export type RequestBody6$Outbound = {
  action: string;
  id: string;
  value: UpdateFirewallConfigRequestBodySecurityValue$Outbound;
};

/** @internal */
export const RequestBody6$outboundSchema: z.ZodType<
  RequestBody6$Outbound,
  z.ZodTypeDef,
  RequestBody6
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest6Action$outboundSchema,
  id: Id$outboundSchema,
  value: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityValue$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody6$ {
  /** @deprecated use `RequestBody6$inboundSchema` instead. */
  export const inboundSchema = RequestBody6$inboundSchema;
  /** @deprecated use `RequestBody6$outboundSchema` instead. */
  export const outboundSchema = RequestBody6$outboundSchema;
  /** @deprecated use `RequestBody6$Outbound` instead. */
  export type Outbound = RequestBody6$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest5Action$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest5Action
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest5Action);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest5Action$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest5Action
  > = UpdateFirewallConfigRequestBodySecurityRequest5Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest5Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest5Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest5Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest5Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest5Action$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBody5$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody5,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest5Action$inboundSchema,
  id: z.string(),
  value: z.number(),
});

/** @internal */
export type UpdateFirewallConfigRequestBody5$Outbound = {
  action: string;
  id: string;
  value: number;
};

/** @internal */
export const UpdateFirewallConfigRequestBody5$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody5$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBody5
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequest5Action$outboundSchema,
  id: z.string(),
  value: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBody5$ {
  /** @deprecated use `UpdateFirewallConfigRequestBody5$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBody5$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody5$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequestBody5$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody5$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBody5$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequestAction$inboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodySecurityRequestAction> =
    z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequestAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequestAction$outboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodySecurityRequestAction> =
    UpdateFirewallConfigRequestBodySecurityRequestAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequestAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequestAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequestAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequestAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequestAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBody4$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody4,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequestAction$inboundSchema,
  id: z.string(),
  value: z.nullable(z.any()).optional(),
});

/** @internal */
export type UpdateFirewallConfigRequestBody4$Outbound = {
  action: string;
  id: string;
  value?: any | null | undefined;
};

/** @internal */
export const UpdateFirewallConfigRequestBody4$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody4$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBody4
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityRequestAction$outboundSchema,
  id: z.string(),
  value: z.nullable(z.any()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBody4$ {
  /** @deprecated use `UpdateFirewallConfigRequestBody4$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBody4$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody4$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequestBody4$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody4$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBody4$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityAction$inboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodySecurityAction> = z
    .nativeEnum(UpdateFirewallConfigRequestBodySecurityAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityAction$outboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodySecurityAction> =
    UpdateFirewallConfigRequestBodySecurityAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityType$inboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodySecurityType> = z
    .nativeEnum(UpdateFirewallConfigRequestBodySecurityType);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodySecurityType> =
    UpdateFirewallConfigRequestBodySecurityType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityType$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityType$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityType$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyOp$inboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigRequestBodyOp
> = z.nativeEnum(UpdateFirewallConfigRequestBodyOp);

/** @internal */
export const UpdateFirewallConfigRequestBodyOp$outboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigRequestBodyOp
> = UpdateFirewallConfigRequestBodyOp$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyOp$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyOp$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBodyOp$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyOp$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyOp$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest3Value$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest3Value,
    z.ZodTypeDef,
    unknown
  > = z.union([z.string(), z.array(z.string()), z.number()]);

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequest3Value$Outbound =
  | string
  | Array<string>
  | number;

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest3Value$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest3Value$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequest3Value
  > = z.union([z.string(), z.array(z.string()), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest3Value$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3Value$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest3Value$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3Value$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest3Value$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3Value$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequest3Value$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyConditions$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyConditions,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateFirewallConfigRequestBodySecurityType$inboundSchema,
  op: UpdateFirewallConfigRequestBodyOp$inboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.array(z.string()), z.number()]).optional(),
});

/** @internal */
export type UpdateFirewallConfigRequestBodyConditions$Outbound = {
  type: string;
  op: string;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | Array<string> | number | undefined;
};

/** @internal */
export const UpdateFirewallConfigRequestBodyConditions$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodyConditions$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodyConditions
  > = z.object({
    type: UpdateFirewallConfigRequestBodySecurityType$outboundSchema,
    op: UpdateFirewallConfigRequestBodyOp$outboundSchema,
    neg: z.boolean().optional(),
    key: z.string().optional(),
    value: z.union([z.string(), z.array(z.string()), z.number()]).optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyConditions$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyConditions$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyConditions$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyConditions$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyConditions$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyConditions$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodyConditions$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyConditionGroup$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodyConditionGroup,
    z.ZodTypeDef,
    unknown
  > = z.object({
    conditions: z.array(
      z.lazy(() => UpdateFirewallConfigRequestBodyConditions$inboundSchema),
    ),
  });

/** @internal */
export type UpdateFirewallConfigRequestBodyConditionGroup$Outbound = {
  conditions: Array<UpdateFirewallConfigRequestBodyConditions$Outbound>;
};

/** @internal */
export const UpdateFirewallConfigRequestBodyConditionGroup$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodyConditionGroup$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodyConditionGroup
  > = z.object({
    conditions: z.array(
      z.lazy(() => UpdateFirewallConfigRequestBodyConditions$outboundSchema),
    ),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyConditionGroup$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyConditionGroup$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyConditionGroup$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyConditionGroup$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyConditionGroup$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyConditionGroup$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodyConditionGroup$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest3ValueAction
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest3ValueAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest3ValueAction
  > = UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRateLimitAlgo$inboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigRateLimitAlgo
> = z.nativeEnum(UpdateFirewallConfigRateLimitAlgo);

/** @internal */
export const UpdateFirewallConfigRateLimitAlgo$outboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigRateLimitAlgo
> = UpdateFirewallConfigRateLimitAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRateLimitAlgo$ {
  /** @deprecated use `UpdateFirewallConfigRateLimitAlgo$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRateLimitAlgo$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitAlgo$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRateLimitAlgo$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigActionSecurity1$inboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigActionSecurity1
> = z.nativeEnum(UpdateFirewallConfigActionSecurity1);

/** @internal */
export const UpdateFirewallConfigActionSecurity1$outboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigActionSecurity1> =
    UpdateFirewallConfigActionSecurity1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigActionSecurity1$ {
  /** @deprecated use `UpdateFirewallConfigActionSecurity1$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigActionSecurity1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigActionSecurity1$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigActionSecurity1$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRateLimitSecurityAction$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRateLimitSecurityAction,
    z.ZodTypeDef,
    unknown
  > = z.union([UpdateFirewallConfigActionSecurity1$inboundSchema, z.any()]);

/** @internal */
export type UpdateFirewallConfigRateLimitSecurityAction$Outbound = string | any;

/** @internal */
export const UpdateFirewallConfigRateLimitSecurityAction$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRateLimitSecurityAction$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRateLimitSecurityAction
  > = z.union([UpdateFirewallConfigActionSecurity1$outboundSchema, z.any()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRateLimitSecurityAction$ {
  /** @deprecated use `UpdateFirewallConfigRateLimitSecurityAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRateLimitSecurityAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitSecurityAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRateLimitSecurityAction$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitSecurityAction$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRateLimitSecurityAction$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRateLimitSecurity1$inboundSchema: z.ZodType<
  UpdateFirewallConfigRateLimitSecurity1,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: UpdateFirewallConfigRateLimitAlgo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(
    z.union([UpdateFirewallConfigActionSecurity1$inboundSchema, z.any()]),
  ).optional(),
});

/** @internal */
export type UpdateFirewallConfigRateLimitSecurity1$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: string | any | null | undefined;
};

/** @internal */
export const UpdateFirewallConfigRateLimitSecurity1$outboundSchema: z.ZodType<
  UpdateFirewallConfigRateLimitSecurity1$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRateLimitSecurity1
> = z.object({
  algo: UpdateFirewallConfigRateLimitAlgo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(
    z.union([UpdateFirewallConfigActionSecurity1$outboundSchema, z.any()]),
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRateLimitSecurity1$ {
  /** @deprecated use `UpdateFirewallConfigRateLimitSecurity1$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRateLimitSecurity1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitSecurity1$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRateLimitSecurity1$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitSecurity1$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRateLimitSecurity1$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyRateLimit$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyRateLimit,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateFirewallConfigRateLimitSecurity1$inboundSchema),
  z.any(),
]);

/** @internal */
export type UpdateFirewallConfigRequestBodyRateLimit$Outbound =
  | UpdateFirewallConfigRateLimitSecurity1$Outbound
  | any;

/** @internal */
export const UpdateFirewallConfigRequestBodyRateLimit$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyRateLimit$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBodyRateLimit
> = z.union([
  z.lazy(() => UpdateFirewallConfigRateLimitSecurity1$outboundSchema),
  z.any(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyRateLimit$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyRateLimit$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyRateLimit$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyRateLimit$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyRateLimit$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyRateLimit$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodyRateLimit$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRedirectSecurity1$inboundSchema: z.ZodType<
  UpdateFirewallConfigRedirectSecurity1,
  z.ZodTypeDef,
  unknown
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/** @internal */
export type UpdateFirewallConfigRedirectSecurity1$Outbound = {
  location: string;
  permanent: boolean;
};

/** @internal */
export const UpdateFirewallConfigRedirectSecurity1$outboundSchema: z.ZodType<
  UpdateFirewallConfigRedirectSecurity1$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRedirectSecurity1
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRedirectSecurity1$ {
  /** @deprecated use `UpdateFirewallConfigRedirectSecurity1$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRedirectSecurity1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRedirectSecurity1$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRedirectSecurity1$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRedirectSecurity1$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRedirectSecurity1$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyRedirect$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyRedirect,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateFirewallConfigRedirectSecurity1$inboundSchema),
  z.any(),
]);

/** @internal */
export type UpdateFirewallConfigRequestBodyRedirect$Outbound =
  | UpdateFirewallConfigRedirectSecurity1$Outbound
  | any;

/** @internal */
export const UpdateFirewallConfigRequestBodyRedirect$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyRedirect$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBodyRedirect
> = z.union([
  z.lazy(() => UpdateFirewallConfigRedirectSecurity1$outboundSchema),
  z.any(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyRedirect$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyRedirect$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyRedirect$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyRedirect$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyRedirect$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyRedirect$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodyRedirect$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyMitigate$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action:
    UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$inboundSchema,
  rateLimit: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRateLimitSecurity1$inboundSchema),
      z.any(),
    ]),
  ).optional(),
  redirect: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRedirectSecurity1$inboundSchema),
      z.any(),
    ]),
  ).optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/** @internal */
export type UpdateFirewallConfigRequestBodyMitigate$Outbound = {
  action: string;
  rateLimit?:
    | UpdateFirewallConfigRateLimitSecurity1$Outbound
    | any
    | null
    | undefined;
  redirect?:
    | UpdateFirewallConfigRedirectSecurity1$Outbound
    | any
    | null
    | undefined;
  actionDuration?: string | null | undefined;
};

/** @internal */
export const UpdateFirewallConfigRequestBodyMitigate$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyMitigate$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBodyMitigate
> = z.object({
  action:
    UpdateFirewallConfigRequestBodySecurityRequest3ValueAction$outboundSchema,
  rateLimit: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRateLimitSecurity1$outboundSchema),
      z.any(),
    ]),
  ).optional(),
  redirect: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRedirectSecurity1$outboundSchema),
      z.any(),
    ]),
  ).optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyMitigate$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyMitigate$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyMitigate$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyMitigate$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyMitigate$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyMitigate$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodyMitigate$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest3Action$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest3Action,
    z.ZodTypeDef,
    unknown
  > = z.object({
    mitigate: z.lazy(() =>
      UpdateFirewallConfigRequestBodyMitigate$inboundSchema
    ).optional(),
  });

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequest3Action$Outbound = {
  mitigate?: UpdateFirewallConfigRequestBodyMitigate$Outbound | undefined;
};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest3Action$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest3Action$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequest3Action
  > = z.object({
    mitigate: z.lazy(() =>
      UpdateFirewallConfigRequestBodyMitigate$outboundSchema
    ).optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest3Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest3Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest3Action$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest3Action$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequest3Action$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyValue$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyValue,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(
    z.lazy(() => UpdateFirewallConfigRequestBodyConditionGroup$inboundSchema),
  ),
  action: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest3Action$inboundSchema
  ),
});

/** @internal */
export type UpdateFirewallConfigRequestBodyValue$Outbound = {
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<UpdateFirewallConfigRequestBodyConditionGroup$Outbound>;
  action: UpdateFirewallConfigRequestBodySecurityRequest3Action$Outbound;
};

/** @internal */
export const UpdateFirewallConfigRequestBodyValue$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBodyValue$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBodyValue
> = z.object({
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(
    z.lazy(() => UpdateFirewallConfigRequestBodyConditionGroup$outboundSchema),
  ),
  action: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest3Action$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyValue$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyValue$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyValue$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyValue$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyValue$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyValue$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBodyValue$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBody3$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody3,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityAction$inboundSchema,
  id: z.string(),
  value: z.lazy(() => UpdateFirewallConfigRequestBodyValue$inboundSchema),
});

/** @internal */
export type UpdateFirewallConfigRequestBody3$Outbound = {
  action: string;
  id: string;
  value: UpdateFirewallConfigRequestBodyValue$Outbound;
};

/** @internal */
export const UpdateFirewallConfigRequestBody3$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody3$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBody3
> = z.object({
  action: UpdateFirewallConfigRequestBodySecurityAction$outboundSchema,
  id: z.string(),
  value: z.lazy(() => UpdateFirewallConfigRequestBodyValue$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBody3$ {
  /** @deprecated use `UpdateFirewallConfigRequestBody3$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBody3$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody3$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequestBody3$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody3$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBody3$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyAction$inboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodyAction> = z.nativeEnum(
    UpdateFirewallConfigRequestBodyAction,
  );

/** @internal */
export const UpdateFirewallConfigRequestBodyAction$outboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodyAction> =
    UpdateFirewallConfigRequestBodyAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodyType$inboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigRequestBodyType
> = z.nativeEnum(UpdateFirewallConfigRequestBodyType);

/** @internal */
export const UpdateFirewallConfigRequestBodyType$outboundSchema:
  z.ZodNativeEnum<typeof UpdateFirewallConfigRequestBodyType> =
    UpdateFirewallConfigRequestBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodyType$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodyType$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodyType$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodyType$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodyType$outboundSchema;
}

/** @internal */
export const RequestBodyOp$inboundSchema: z.ZodNativeEnum<
  typeof RequestBodyOp
> = z.nativeEnum(RequestBodyOp);

/** @internal */
export const RequestBodyOp$outboundSchema: z.ZodNativeEnum<
  typeof RequestBodyOp
> = RequestBodyOp$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyOp$ {
  /** @deprecated use `RequestBodyOp$inboundSchema` instead. */
  export const inboundSchema = RequestBodyOp$inboundSchema;
  /** @deprecated use `RequestBodyOp$outboundSchema` instead. */
  export const outboundSchema = RequestBodyOp$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest2Value$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest2Value,
    z.ZodTypeDef,
    unknown
  > = z.union([z.string(), z.array(z.string()), z.number()]);

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequest2Value$Outbound =
  | string
  | Array<string>
  | number;

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest2Value$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest2Value$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequest2Value
  > = z.union([z.string(), z.array(z.string()), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest2Value$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2Value$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest2Value$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2Value$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest2Value$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2Value$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequest2Value$Outbound;
}

/** @internal */
export const RequestBodyConditions$inboundSchema: z.ZodType<
  RequestBodyConditions,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: UpdateFirewallConfigRequestBodyType$inboundSchema,
  op: RequestBodyOp$inboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.array(z.string()), z.number()]).optional(),
});

/** @internal */
export type RequestBodyConditions$Outbound = {
  type: string;
  op: string;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | Array<string> | number | undefined;
};

/** @internal */
export const RequestBodyConditions$outboundSchema: z.ZodType<
  RequestBodyConditions$Outbound,
  z.ZodTypeDef,
  RequestBodyConditions
> = z.object({
  type: UpdateFirewallConfigRequestBodyType$outboundSchema,
  op: RequestBodyOp$outboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.array(z.string()), z.number()]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyConditions$ {
  /** @deprecated use `RequestBodyConditions$inboundSchema` instead. */
  export const inboundSchema = RequestBodyConditions$inboundSchema;
  /** @deprecated use `RequestBodyConditions$outboundSchema` instead. */
  export const outboundSchema = RequestBodyConditions$outboundSchema;
  /** @deprecated use `RequestBodyConditions$Outbound` instead. */
  export type Outbound = RequestBodyConditions$Outbound;
}

/** @internal */
export const RequestBodyConditionGroup$inboundSchema: z.ZodType<
  RequestBodyConditionGroup,
  z.ZodTypeDef,
  unknown
> = z.object({
  conditions: z.array(z.lazy(() => RequestBodyConditions$inboundSchema)),
});

/** @internal */
export type RequestBodyConditionGroup$Outbound = {
  conditions: Array<RequestBodyConditions$Outbound>;
};

/** @internal */
export const RequestBodyConditionGroup$outboundSchema: z.ZodType<
  RequestBodyConditionGroup$Outbound,
  z.ZodTypeDef,
  RequestBodyConditionGroup
> = z.object({
  conditions: z.array(z.lazy(() => RequestBodyConditions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyConditionGroup$ {
  /** @deprecated use `RequestBodyConditionGroup$inboundSchema` instead. */
  export const inboundSchema = RequestBodyConditionGroup$inboundSchema;
  /** @deprecated use `RequestBodyConditionGroup$outboundSchema` instead. */
  export const outboundSchema = RequestBodyConditionGroup$outboundSchema;
  /** @deprecated use `RequestBodyConditionGroup$Outbound` instead. */
  export type Outbound = RequestBodyConditionGroup$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest2ValueAction
  > = z.nativeEnum(UpdateFirewallConfigRequestBodySecurityRequest2ValueAction);

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateFirewallConfigRequestBodySecurityRequest2ValueAction
  > = UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$outboundSchema;
}

/** @internal */
export const RateLimitAlgo$inboundSchema: z.ZodNativeEnum<
  typeof RateLimitAlgo
> = z.nativeEnum(RateLimitAlgo);

/** @internal */
export const RateLimitAlgo$outboundSchema: z.ZodNativeEnum<
  typeof RateLimitAlgo
> = RateLimitAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RateLimitAlgo$ {
  /** @deprecated use `RateLimitAlgo$inboundSchema` instead. */
  export const inboundSchema = RateLimitAlgo$inboundSchema;
  /** @deprecated use `RateLimitAlgo$outboundSchema` instead. */
  export const outboundSchema = RateLimitAlgo$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigAction1$inboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigAction1
> = z.nativeEnum(UpdateFirewallConfigAction1);

/** @internal */
export const UpdateFirewallConfigAction1$outboundSchema: z.ZodNativeEnum<
  typeof UpdateFirewallConfigAction1
> = UpdateFirewallConfigAction1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigAction1$ {
  /** @deprecated use `UpdateFirewallConfigAction1$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigAction1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigAction1$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigAction1$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRateLimitAction$inboundSchema: z.ZodType<
  UpdateFirewallConfigRateLimitAction,
  z.ZodTypeDef,
  unknown
> = z.union([UpdateFirewallConfigAction1$inboundSchema, z.any()]);

/** @internal */
export type UpdateFirewallConfigRateLimitAction$Outbound = string | any;

/** @internal */
export const UpdateFirewallConfigRateLimitAction$outboundSchema: z.ZodType<
  UpdateFirewallConfigRateLimitAction$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRateLimitAction
> = z.union([UpdateFirewallConfigAction1$outboundSchema, z.any()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRateLimitAction$ {
  /** @deprecated use `UpdateFirewallConfigRateLimitAction$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRateLimitAction$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitAction$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRateLimitAction$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimitAction$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRateLimitAction$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRateLimit1$inboundSchema: z.ZodType<
  UpdateFirewallConfigRateLimit1,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: RateLimitAlgo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(
    z.union([UpdateFirewallConfigAction1$inboundSchema, z.any()]),
  ).optional(),
});

/** @internal */
export type UpdateFirewallConfigRateLimit1$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: string | any | null | undefined;
};

/** @internal */
export const UpdateFirewallConfigRateLimit1$outboundSchema: z.ZodType<
  UpdateFirewallConfigRateLimit1$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRateLimit1
> = z.object({
  algo: RateLimitAlgo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(
    z.union([UpdateFirewallConfigAction1$outboundSchema, z.any()]),
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRateLimit1$ {
  /** @deprecated use `UpdateFirewallConfigRateLimit1$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRateLimit1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimit1$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRateLimit1$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRateLimit1$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRateLimit1$Outbound;
}

/** @internal */
export const RequestBodyRateLimit$inboundSchema: z.ZodType<
  RequestBodyRateLimit,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateFirewallConfigRateLimit1$inboundSchema),
  z.any(),
]);

/** @internal */
export type RequestBodyRateLimit$Outbound =
  | UpdateFirewallConfigRateLimit1$Outbound
  | any;

/** @internal */
export const RequestBodyRateLimit$outboundSchema: z.ZodType<
  RequestBodyRateLimit$Outbound,
  z.ZodTypeDef,
  RequestBodyRateLimit
> = z.union([
  z.lazy(() => UpdateFirewallConfigRateLimit1$outboundSchema),
  z.any(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyRateLimit$ {
  /** @deprecated use `RequestBodyRateLimit$inboundSchema` instead. */
  export const inboundSchema = RequestBodyRateLimit$inboundSchema;
  /** @deprecated use `RequestBodyRateLimit$outboundSchema` instead. */
  export const outboundSchema = RequestBodyRateLimit$outboundSchema;
  /** @deprecated use `RequestBodyRateLimit$Outbound` instead. */
  export type Outbound = RequestBodyRateLimit$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRedirect1$inboundSchema: z.ZodType<
  UpdateFirewallConfigRedirect1,
  z.ZodTypeDef,
  unknown
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/** @internal */
export type UpdateFirewallConfigRedirect1$Outbound = {
  location: string;
  permanent: boolean;
};

/** @internal */
export const UpdateFirewallConfigRedirect1$outboundSchema: z.ZodType<
  UpdateFirewallConfigRedirect1$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRedirect1
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRedirect1$ {
  /** @deprecated use `UpdateFirewallConfigRedirect1$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRedirect1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRedirect1$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRedirect1$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRedirect1$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRedirect1$Outbound;
}

/** @internal */
export const RequestBodyRedirect$inboundSchema: z.ZodType<
  RequestBodyRedirect,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateFirewallConfigRedirect1$inboundSchema),
  z.any(),
]);

/** @internal */
export type RequestBodyRedirect$Outbound =
  | UpdateFirewallConfigRedirect1$Outbound
  | any;

/** @internal */
export const RequestBodyRedirect$outboundSchema: z.ZodType<
  RequestBodyRedirect$Outbound,
  z.ZodTypeDef,
  RequestBodyRedirect
> = z.union([
  z.lazy(() => UpdateFirewallConfigRedirect1$outboundSchema),
  z.any(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyRedirect$ {
  /** @deprecated use `RequestBodyRedirect$inboundSchema` instead. */
  export const inboundSchema = RequestBodyRedirect$inboundSchema;
  /** @deprecated use `RequestBodyRedirect$outboundSchema` instead. */
  export const outboundSchema = RequestBodyRedirect$outboundSchema;
  /** @deprecated use `RequestBodyRedirect$Outbound` instead. */
  export type Outbound = RequestBodyRedirect$Outbound;
}

/** @internal */
export const RequestBodyMitigate$inboundSchema: z.ZodType<
  RequestBodyMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action:
    UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$inboundSchema,
  rateLimit: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRateLimit1$inboundSchema),
      z.any(),
    ]),
  ).optional(),
  redirect: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRedirect1$inboundSchema),
      z.any(),
    ]),
  ).optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/** @internal */
export type RequestBodyMitigate$Outbound = {
  action: string;
  rateLimit?: UpdateFirewallConfigRateLimit1$Outbound | any | null | undefined;
  redirect?: UpdateFirewallConfigRedirect1$Outbound | any | null | undefined;
  actionDuration?: string | null | undefined;
};

/** @internal */
export const RequestBodyMitigate$outboundSchema: z.ZodType<
  RequestBodyMitigate$Outbound,
  z.ZodTypeDef,
  RequestBodyMitigate
> = z.object({
  action:
    UpdateFirewallConfigRequestBodySecurityRequest2ValueAction$outboundSchema,
  rateLimit: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRateLimit1$outboundSchema),
      z.any(),
    ]),
  ).optional(),
  redirect: z.nullable(
    z.union([
      z.lazy(() => UpdateFirewallConfigRedirect1$outboundSchema),
      z.any(),
    ]),
  ).optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyMitigate$ {
  /** @deprecated use `RequestBodyMitigate$inboundSchema` instead. */
  export const inboundSchema = RequestBodyMitigate$inboundSchema;
  /** @deprecated use `RequestBodyMitigate$outboundSchema` instead. */
  export const outboundSchema = RequestBodyMitigate$outboundSchema;
  /** @deprecated use `RequestBodyMitigate$Outbound` instead. */
  export type Outbound = RequestBodyMitigate$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest2Action$inboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest2Action,
    z.ZodTypeDef,
    unknown
  > = z.object({
    mitigate: z.lazy(() => RequestBodyMitigate$inboundSchema).optional(),
  });

/** @internal */
export type UpdateFirewallConfigRequestBodySecurityRequest2Action$Outbound = {
  mitigate?: RequestBodyMitigate$Outbound | undefined;
};

/** @internal */
export const UpdateFirewallConfigRequestBodySecurityRequest2Action$outboundSchema:
  z.ZodType<
    UpdateFirewallConfigRequestBodySecurityRequest2Action$Outbound,
    z.ZodTypeDef,
    UpdateFirewallConfigRequestBodySecurityRequest2Action
  > = z.object({
    mitigate: z.lazy(() => RequestBodyMitigate$outboundSchema).optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBodySecurityRequest2Action$ {
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2Action$inboundSchema` instead. */
  export const inboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest2Action$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2Action$outboundSchema` instead. */
  export const outboundSchema =
    UpdateFirewallConfigRequestBodySecurityRequest2Action$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBodySecurityRequest2Action$Outbound` instead. */
  export type Outbound =
    UpdateFirewallConfigRequestBodySecurityRequest2Action$Outbound;
}

/** @internal */
export const RequestBodyValue$inboundSchema: z.ZodType<
  RequestBodyValue,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(
    z.lazy(() => RequestBodyConditionGroup$inboundSchema),
  ),
  action: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest2Action$inboundSchema
  ),
});

/** @internal */
export type RequestBodyValue$Outbound = {
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<RequestBodyConditionGroup$Outbound>;
  action: UpdateFirewallConfigRequestBodySecurityRequest2Action$Outbound;
};

/** @internal */
export const RequestBodyValue$outboundSchema: z.ZodType<
  RequestBodyValue$Outbound,
  z.ZodTypeDef,
  RequestBodyValue
> = z.object({
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(
    z.lazy(() => RequestBodyConditionGroup$outboundSchema),
  ),
  action: z.lazy(() =>
    UpdateFirewallConfigRequestBodySecurityRequest2Action$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyValue$ {
  /** @deprecated use `RequestBodyValue$inboundSchema` instead. */
  export const inboundSchema = RequestBodyValue$inboundSchema;
  /** @deprecated use `RequestBodyValue$outboundSchema` instead. */
  export const outboundSchema = RequestBodyValue$outboundSchema;
  /** @deprecated use `RequestBodyValue$Outbound` instead. */
  export type Outbound = RequestBodyValue$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBody2$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: UpdateFirewallConfigRequestBodyAction$inboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.lazy(() => RequestBodyValue$inboundSchema),
});

/** @internal */
export type UpdateFirewallConfigRequestBody2$Outbound = {
  action: string;
  id?: any | null | undefined;
  value: RequestBodyValue$Outbound;
};

/** @internal */
export const UpdateFirewallConfigRequestBody2$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody2$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBody2
> = z.object({
  action: UpdateFirewallConfigRequestBodyAction$outboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.lazy(() => RequestBodyValue$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBody2$ {
  /** @deprecated use `UpdateFirewallConfigRequestBody2$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBody2$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody2$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequestBody2$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody2$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBody2$Outbound;
}

/** @internal */
export const RequestBodyAction$inboundSchema: z.ZodNativeEnum<
  typeof RequestBodyAction
> = z.nativeEnum(RequestBodyAction);

/** @internal */
export const RequestBodyAction$outboundSchema: z.ZodNativeEnum<
  typeof RequestBodyAction
> = RequestBodyAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyAction$ {
  /** @deprecated use `RequestBodyAction$inboundSchema` instead. */
  export const inboundSchema = RequestBodyAction$inboundSchema;
  /** @deprecated use `RequestBodyAction$outboundSchema` instead. */
  export const outboundSchema = RequestBodyAction$outboundSchema;
}

/** @internal */
export const UpdateFirewallConfigRequestBody1$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: RequestBodyAction$inboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.boolean(),
});

/** @internal */
export type UpdateFirewallConfigRequestBody1$Outbound = {
  action: string;
  id?: any | null | undefined;
  value: boolean;
};

/** @internal */
export const UpdateFirewallConfigRequestBody1$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody1$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBody1
> = z.object({
  action: RequestBodyAction$outboundSchema,
  id: z.nullable(z.any()).optional(),
  value: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBody1$ {
  /** @deprecated use `UpdateFirewallConfigRequestBody1$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBody1$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody1$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequestBody1$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody1$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBody1$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequestBody$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => UpdateFirewallConfigRequestBody1$inboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody2$inboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody3$inboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody4$inboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody5$inboundSchema),
  z.lazy(() => RequestBody6$inboundSchema),
  z.lazy(() => RequestBody7$inboundSchema),
  z.lazy(() => RequestBody8$inboundSchema),
  z.lazy(() => RequestBody9$inboundSchema),
  z.lazy(() => RequestBody10$inboundSchema),
  z.lazy(() => Eleven$inboundSchema),
]);

/** @internal */
export type UpdateFirewallConfigRequestBody$Outbound =
  | UpdateFirewallConfigRequestBody1$Outbound
  | UpdateFirewallConfigRequestBody2$Outbound
  | UpdateFirewallConfigRequestBody3$Outbound
  | UpdateFirewallConfigRequestBody4$Outbound
  | UpdateFirewallConfigRequestBody5$Outbound
  | RequestBody6$Outbound
  | RequestBody7$Outbound
  | RequestBody8$Outbound
  | RequestBody9$Outbound
  | RequestBody10$Outbound
  | Eleven$Outbound;

/** @internal */
export const UpdateFirewallConfigRequestBody$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequestBody$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequestBody
> = z.union([
  z.lazy(() => UpdateFirewallConfigRequestBody1$outboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody2$outboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody3$outboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody4$outboundSchema),
  z.lazy(() => UpdateFirewallConfigRequestBody5$outboundSchema),
  z.lazy(() => RequestBody6$outboundSchema),
  z.lazy(() => RequestBody7$outboundSchema),
  z.lazy(() => RequestBody8$outboundSchema),
  z.lazy(() => RequestBody9$outboundSchema),
  z.lazy(() => RequestBody10$outboundSchema),
  z.lazy(() => Eleven$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequestBody$ {
  /** @deprecated use `UpdateFirewallConfigRequestBody$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequestBody$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequestBody$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequestBody$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequestBody$Outbound;
}

/** @internal */
export const UpdateFirewallConfigRequest$inboundSchema: z.ZodType<
  UpdateFirewallConfigRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.union([
    z.lazy(() => UpdateFirewallConfigRequestBody1$inboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody2$inboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody3$inboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody4$inboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody5$inboundSchema),
    z.lazy(() => RequestBody6$inboundSchema),
    z.lazy(() => RequestBody7$inboundSchema),
    z.lazy(() => RequestBody8$inboundSchema),
    z.lazy(() => RequestBody9$inboundSchema),
    z.lazy(() => RequestBody10$inboundSchema),
    z.lazy(() => Eleven$inboundSchema),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type UpdateFirewallConfigRequest$Outbound = {
  projectId: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?:
    | UpdateFirewallConfigRequestBody1$Outbound
    | UpdateFirewallConfigRequestBody2$Outbound
    | UpdateFirewallConfigRequestBody3$Outbound
    | UpdateFirewallConfigRequestBody4$Outbound
    | UpdateFirewallConfigRequestBody5$Outbound
    | RequestBody6$Outbound
    | RequestBody7$Outbound
    | RequestBody8$Outbound
    | RequestBody9$Outbound
    | RequestBody10$Outbound
    | Eleven$Outbound
    | undefined;
};

/** @internal */
export const UpdateFirewallConfigRequest$outboundSchema: z.ZodType<
  UpdateFirewallConfigRequest$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigRequest
> = z.object({
  projectId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.union([
    z.lazy(() => UpdateFirewallConfigRequestBody1$outboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody2$outboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody3$outboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody4$outboundSchema),
    z.lazy(() => UpdateFirewallConfigRequestBody5$outboundSchema),
    z.lazy(() => RequestBody6$outboundSchema),
    z.lazy(() => RequestBody7$outboundSchema),
    z.lazy(() => RequestBody8$outboundSchema),
    z.lazy(() => RequestBody9$outboundSchema),
    z.lazy(() => RequestBody10$outboundSchema),
    z.lazy(() => Eleven$outboundSchema),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigRequest$ {
  /** @deprecated use `UpdateFirewallConfigRequest$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigRequest$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequest$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigRequest$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigRequest$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigRequest$Outbound;
}

/** @internal */
export const UpdateFirewallConfigResponseBody$inboundSchema: z.ZodType<
  UpdateFirewallConfigResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type UpdateFirewallConfigResponseBody$Outbound = {};

/** @internal */
export const UpdateFirewallConfigResponseBody$outboundSchema: z.ZodType<
  UpdateFirewallConfigResponseBody$Outbound,
  z.ZodTypeDef,
  UpdateFirewallConfigResponseBody
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateFirewallConfigResponseBody$ {
  /** @deprecated use `UpdateFirewallConfigResponseBody$inboundSchema` instead. */
  export const inboundSchema = UpdateFirewallConfigResponseBody$inboundSchema;
  /** @deprecated use `UpdateFirewallConfigResponseBody$outboundSchema` instead. */
  export const outboundSchema = UpdateFirewallConfigResponseBody$outboundSchema;
  /** @deprecated use `UpdateFirewallConfigResponseBody$Outbound` instead. */
  export type Outbound = UpdateFirewallConfigResponseBody$Outbound;
}
