/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The current status of the check
 */
export const Status = {
  Running: "running",
  Completed: "completed",
} as const;
/**
 * The current status of the check
 */
export type Status = ClosedEnum<typeof Status>;

/**
 * The result of the check being run
 */
export const Conclusion = {
  Canceled: "canceled",
  Failed: "failed",
  Neutral: "neutral",
  Succeeded: "succeeded",
  Skipped: "skipped",
} as const;
/**
 * The result of the check being run
 */
export type Conclusion = ClosedEnum<typeof Conclusion>;

export const UpdateCheckSource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckSource = ClosedEnum<typeof UpdateCheckSource>;

export type Fcp = {
  /**
   * First Contentful Paint value
   */
  value: number | null;
  /**
   * Previous First Contentful Paint value to display a delta
   */
  previousValue?: number | undefined;
  source: UpdateCheckSource;
};

export const UpdateCheckChecksSource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksSource = ClosedEnum<
  typeof UpdateCheckChecksSource
>;

export type Lcp = {
  /**
   * Largest Contentful Paint value
   */
  value: number | null;
  /**
   * Previous Largest Contentful Paint value to display a delta
   */
  previousValue?: number | undefined;
  source: UpdateCheckChecksSource;
};

export const UpdateCheckChecksRequestSource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksRequestSource = ClosedEnum<
  typeof UpdateCheckChecksRequestSource
>;

export type Cls = {
  /**
   * Cumulative Layout Shift value
   */
  value: number | null;
  /**
   * Previous Cumulative Layout Shift value to display a delta
   */
  previousValue?: number | undefined;
  source: UpdateCheckChecksRequestSource;
};

export const UpdateCheckChecksRequestRequestBodySource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksRequestRequestBodySource = ClosedEnum<
  typeof UpdateCheckChecksRequestRequestBodySource
>;

export type Tbt = {
  /**
   * Total Blocking Time value
   */
  value: number | null;
  /**
   * Previous Total Blocking Time value to display a delta
   */
  previousValue?: number | undefined;
  source: UpdateCheckChecksRequestRequestBodySource;
};

export const UpdateCheckChecksRequestRequestBodyOutputSource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksRequestRequestBodyOutputSource = ClosedEnum<
  typeof UpdateCheckChecksRequestRequestBodyOutputSource
>;

export type VirtualExperienceScore = {
  /**
   * The calculated Virtual Experience Score value, between 0 and 100
   */
  value: number | null;
  /**
   * A previous Virtual Experience Score value to display a delta, between 0 and 100
   */
  previousValue?: number | undefined;
  source: UpdateCheckChecksRequestRequestBodyOutputSource;
};

/**
 * Metrics about the page
 */
export type Metrics = {
  fcp: Fcp;
  lcp: Lcp;
  cls: Cls;
  tbt: Tbt;
  virtualExperienceScore?: VirtualExperienceScore | undefined;
};

/**
 * The results of the check Run
 */
export type Output = {
  /**
   * Metrics about the page
   */
  metrics?: Metrics | undefined;
};

export type UpdateCheckRequestBody = {
  /**
   * The name of the check being created
   */
  name?: string | undefined;
  /**
   * Path of the page that is being checked
   */
  path?: string | undefined;
  /**
   * The current status of the check
   */
  status?: Status | undefined;
  /**
   * The result of the check being run
   */
  conclusion?: Conclusion | undefined;
  /**
   * A URL a user may visit to see more information about the check
   */
  detailsUrl?: string | undefined;
  /**
   * The results of the check Run
   */
  output?: Output | undefined;
  /**
   * An identifier that can be used as an external reference
   */
  externalId?: string | undefined;
};

export type UpdateCheckRequest = {
  /**
   * The deployment to update the check for.
   */
  deploymentId: string;
  /**
   * The check being updated
   */
  checkId: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: UpdateCheckRequestBody | undefined;
};

export const UpdateCheckStatus = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type UpdateCheckStatus = ClosedEnum<typeof UpdateCheckStatus>;

export const UpdateCheckConclusion = {
  Canceled: "canceled",
  Failed: "failed",
  Neutral: "neutral",
  Succeeded: "succeeded",
  Skipped: "skipped",
  Stale: "stale",
} as const;
export type UpdateCheckConclusion = ClosedEnum<typeof UpdateCheckConclusion>;

export const UpdateCheckChecksResponseSource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksResponseSource = ClosedEnum<
  typeof UpdateCheckChecksResponseSource
>;

export type UpdateCheckFCP = {
  value: number | null;
  previousValue?: number | undefined;
  source: UpdateCheckChecksResponseSource;
};

export const UpdateCheckChecksResponse200Source = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksResponse200Source = ClosedEnum<
  typeof UpdateCheckChecksResponse200Source
>;

export type UpdateCheckLCP = {
  value: number | null;
  previousValue?: number | undefined;
  source: UpdateCheckChecksResponse200Source;
};

export const UpdateCheckChecksResponse200ApplicationJSONSource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksResponse200ApplicationJSONSource = ClosedEnum<
  typeof UpdateCheckChecksResponse200ApplicationJSONSource
>;

export type UpdateCheckCLS = {
  value: number | null;
  previousValue?: number | undefined;
  source: UpdateCheckChecksResponse200ApplicationJSONSource;
};

export const UpdateCheckChecksResponse200ApplicationJSONResponseBodySource = {
  WebVitals: "web-vitals",
} as const;
export type UpdateCheckChecksResponse200ApplicationJSONResponseBodySource =
  ClosedEnum<
    typeof UpdateCheckChecksResponse200ApplicationJSONResponseBodySource
  >;

export type UpdateCheckTBT = {
  value: number | null;
  previousValue?: number | undefined;
  source: UpdateCheckChecksResponse200ApplicationJSONResponseBodySource;
};

export const UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource =
  {
    WebVitals: "web-vitals",
  } as const;
export type UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource =
  ClosedEnum<
    typeof UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource
  >;

export type UpdateCheckVirtualExperienceScore = {
  value: number | null;
  previousValue?: number | undefined;
  source: UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource;
};

export type UpdateCheckMetrics = {
  fcp: UpdateCheckFCP;
  lcp: UpdateCheckLCP;
  cls: UpdateCheckCLS;
  tbt: UpdateCheckTBT;
  virtualExperienceScore?: UpdateCheckVirtualExperienceScore | undefined;
};

export type UpdateCheckOutput = {
  metrics?: UpdateCheckMetrics | undefined;
};

export type UpdateCheckResponseBody = {
  id: string;
  name: string;
  path?: string | undefined;
  status: UpdateCheckStatus;
  conclusion?: UpdateCheckConclusion | undefined;
  blocking: boolean;
  output?: UpdateCheckOutput | undefined;
  detailsUrl?: string | undefined;
  integrationId: string;
  deploymentId: string;
  externalId?: string | undefined;
  createdAt: number;
  updatedAt: number;
  startedAt?: number | undefined;
  completedAt?: number | undefined;
  rerequestable?: boolean | undefined;
};

/** @internal */
export const Status$inboundSchema: z.ZodNativeEnum<typeof Status> = z
  .nativeEnum(Status);

/** @internal */
export const Status$outboundSchema: z.ZodNativeEnum<typeof Status> =
  Status$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Status$ {
  /** @deprecated use `Status$inboundSchema` instead. */
  export const inboundSchema = Status$inboundSchema;
  /** @deprecated use `Status$outboundSchema` instead. */
  export const outboundSchema = Status$outboundSchema;
}

/** @internal */
export const Conclusion$inboundSchema: z.ZodNativeEnum<typeof Conclusion> = z
  .nativeEnum(Conclusion);

/** @internal */
export const Conclusion$outboundSchema: z.ZodNativeEnum<typeof Conclusion> =
  Conclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Conclusion$ {
  /** @deprecated use `Conclusion$inboundSchema` instead. */
  export const inboundSchema = Conclusion$inboundSchema;
  /** @deprecated use `Conclusion$outboundSchema` instead. */
  export const outboundSchema = Conclusion$outboundSchema;
}

/** @internal */
export const UpdateCheckSource$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckSource
> = z.nativeEnum(UpdateCheckSource);

/** @internal */
export const UpdateCheckSource$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckSource
> = UpdateCheckSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckSource$ {
  /** @deprecated use `UpdateCheckSource$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckSource$inboundSchema;
  /** @deprecated use `UpdateCheckSource$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckSource$outboundSchema;
}

/** @internal */
export const Fcp$inboundSchema: z.ZodType<Fcp, z.ZodTypeDef, unknown> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckSource$inboundSchema,
  });

/** @internal */
export type Fcp$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const Fcp$outboundSchema: z.ZodType<Fcp$Outbound, z.ZodTypeDef, Fcp> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckSource$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Fcp$ {
  /** @deprecated use `Fcp$inboundSchema` instead. */
  export const inboundSchema = Fcp$inboundSchema;
  /** @deprecated use `Fcp$outboundSchema` instead. */
  export const outboundSchema = Fcp$outboundSchema;
  /** @deprecated use `Fcp$Outbound` instead. */
  export type Outbound = Fcp$Outbound;
}

/** @internal */
export const UpdateCheckChecksSource$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksSource
> = z.nativeEnum(UpdateCheckChecksSource);

/** @internal */
export const UpdateCheckChecksSource$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksSource
> = UpdateCheckChecksSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksSource$ {
  /** @deprecated use `UpdateCheckChecksSource$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckChecksSource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksSource$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckChecksSource$outboundSchema;
}

/** @internal */
export const Lcp$inboundSchema: z.ZodType<Lcp, z.ZodTypeDef, unknown> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckChecksSource$inboundSchema,
  });

/** @internal */
export type Lcp$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const Lcp$outboundSchema: z.ZodType<Lcp$Outbound, z.ZodTypeDef, Lcp> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckChecksSource$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Lcp$ {
  /** @deprecated use `Lcp$inboundSchema` instead. */
  export const inboundSchema = Lcp$inboundSchema;
  /** @deprecated use `Lcp$outboundSchema` instead. */
  export const outboundSchema = Lcp$outboundSchema;
  /** @deprecated use `Lcp$Outbound` instead. */
  export type Outbound = Lcp$Outbound;
}

/** @internal */
export const UpdateCheckChecksRequestSource$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksRequestSource
> = z.nativeEnum(UpdateCheckChecksRequestSource);

/** @internal */
export const UpdateCheckChecksRequestSource$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksRequestSource
> = UpdateCheckChecksRequestSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksRequestSource$ {
  /** @deprecated use `UpdateCheckChecksRequestSource$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckChecksRequestSource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksRequestSource$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckChecksRequestSource$outboundSchema;
}

/** @internal */
export const Cls$inboundSchema: z.ZodType<Cls, z.ZodTypeDef, unknown> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckChecksRequestSource$inboundSchema,
  });

/** @internal */
export type Cls$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const Cls$outboundSchema: z.ZodType<Cls$Outbound, z.ZodTypeDef, Cls> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckChecksRequestSource$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Cls$ {
  /** @deprecated use `Cls$inboundSchema` instead. */
  export const inboundSchema = Cls$inboundSchema;
  /** @deprecated use `Cls$outboundSchema` instead. */
  export const outboundSchema = Cls$outboundSchema;
  /** @deprecated use `Cls$Outbound` instead. */
  export type Outbound = Cls$Outbound;
}

/** @internal */
export const UpdateCheckChecksRequestRequestBodySource$inboundSchema:
  z.ZodNativeEnum<typeof UpdateCheckChecksRequestRequestBodySource> = z
    .nativeEnum(UpdateCheckChecksRequestRequestBodySource);

/** @internal */
export const UpdateCheckChecksRequestRequestBodySource$outboundSchema:
  z.ZodNativeEnum<typeof UpdateCheckChecksRequestRequestBodySource> =
    UpdateCheckChecksRequestRequestBodySource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksRequestRequestBodySource$ {
  /** @deprecated use `UpdateCheckChecksRequestRequestBodySource$inboundSchema` instead. */
  export const inboundSchema =
    UpdateCheckChecksRequestRequestBodySource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksRequestRequestBodySource$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckChecksRequestRequestBodySource$outboundSchema;
}

/** @internal */
export const Tbt$inboundSchema: z.ZodType<Tbt, z.ZodTypeDef, unknown> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckChecksRequestRequestBodySource$inboundSchema,
  });

/** @internal */
export type Tbt$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const Tbt$outboundSchema: z.ZodType<Tbt$Outbound, z.ZodTypeDef, Tbt> = z
  .object({
    value: z.nullable(z.number()),
    previousValue: z.number().optional(),
    source: UpdateCheckChecksRequestRequestBodySource$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Tbt$ {
  /** @deprecated use `Tbt$inboundSchema` instead. */
  export const inboundSchema = Tbt$inboundSchema;
  /** @deprecated use `Tbt$outboundSchema` instead. */
  export const outboundSchema = Tbt$outboundSchema;
  /** @deprecated use `Tbt$Outbound` instead. */
  export type Outbound = Tbt$Outbound;
}

/** @internal */
export const UpdateCheckChecksRequestRequestBodyOutputSource$inboundSchema:
  z.ZodNativeEnum<typeof UpdateCheckChecksRequestRequestBodyOutputSource> = z
    .nativeEnum(UpdateCheckChecksRequestRequestBodyOutputSource);

/** @internal */
export const UpdateCheckChecksRequestRequestBodyOutputSource$outboundSchema:
  z.ZodNativeEnum<typeof UpdateCheckChecksRequestRequestBodyOutputSource> =
    UpdateCheckChecksRequestRequestBodyOutputSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksRequestRequestBodyOutputSource$ {
  /** @deprecated use `UpdateCheckChecksRequestRequestBodyOutputSource$inboundSchema` instead. */
  export const inboundSchema =
    UpdateCheckChecksRequestRequestBodyOutputSource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksRequestRequestBodyOutputSource$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckChecksRequestRequestBodyOutputSource$outboundSchema;
}

/** @internal */
export const VirtualExperienceScore$inboundSchema: z.ZodType<
  VirtualExperienceScore,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number().int()),
  previousValue: z.number().int().optional(),
  source: UpdateCheckChecksRequestRequestBodyOutputSource$inboundSchema,
});

/** @internal */
export type VirtualExperienceScore$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const VirtualExperienceScore$outboundSchema: z.ZodType<
  VirtualExperienceScore$Outbound,
  z.ZodTypeDef,
  VirtualExperienceScore
> = z.object({
  value: z.nullable(z.number().int()),
  previousValue: z.number().int().optional(),
  source: UpdateCheckChecksRequestRequestBodyOutputSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace VirtualExperienceScore$ {
  /** @deprecated use `VirtualExperienceScore$inboundSchema` instead. */
  export const inboundSchema = VirtualExperienceScore$inboundSchema;
  /** @deprecated use `VirtualExperienceScore$outboundSchema` instead. */
  export const outboundSchema = VirtualExperienceScore$outboundSchema;
  /** @deprecated use `VirtualExperienceScore$Outbound` instead. */
  export type Outbound = VirtualExperienceScore$Outbound;
}

/** @internal */
export const Metrics$inboundSchema: z.ZodType<Metrics, z.ZodTypeDef, unknown> =
  z.object({
    FCP: z.lazy(() => Fcp$inboundSchema),
    LCP: z.lazy(() => Lcp$inboundSchema),
    CLS: z.lazy(() => Cls$inboundSchema),
    TBT: z.lazy(() => Tbt$inboundSchema),
    virtualExperienceScore: z.lazy(() => VirtualExperienceScore$inboundSchema)
      .optional(),
  }).transform((v) => {
    return remap$(v, {
      "FCP": "fcp",
      "LCP": "lcp",
      "CLS": "cls",
      "TBT": "tbt",
    });
  });

/** @internal */
export type Metrics$Outbound = {
  FCP: Fcp$Outbound;
  LCP: Lcp$Outbound;
  CLS: Cls$Outbound;
  TBT: Tbt$Outbound;
  virtualExperienceScore?: VirtualExperienceScore$Outbound | undefined;
};

/** @internal */
export const Metrics$outboundSchema: z.ZodType<
  Metrics$Outbound,
  z.ZodTypeDef,
  Metrics
> = z.object({
  fcp: z.lazy(() => Fcp$outboundSchema),
  lcp: z.lazy(() => Lcp$outboundSchema),
  cls: z.lazy(() => Cls$outboundSchema),
  tbt: z.lazy(() => Tbt$outboundSchema),
  virtualExperienceScore: z.lazy(() => VirtualExperienceScore$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    fcp: "FCP",
    lcp: "LCP",
    cls: "CLS",
    tbt: "TBT",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Metrics$ {
  /** @deprecated use `Metrics$inboundSchema` instead. */
  export const inboundSchema = Metrics$inboundSchema;
  /** @deprecated use `Metrics$outboundSchema` instead. */
  export const outboundSchema = Metrics$outboundSchema;
  /** @deprecated use `Metrics$Outbound` instead. */
  export type Outbound = Metrics$Outbound;
}

/** @internal */
export const Output$inboundSchema: z.ZodType<Output, z.ZodTypeDef, unknown> = z
  .object({
    metrics: z.lazy(() => Metrics$inboundSchema).optional(),
  });

/** @internal */
export type Output$Outbound = {
  metrics?: Metrics$Outbound | undefined;
};

/** @internal */
export const Output$outboundSchema: z.ZodType<
  Output$Outbound,
  z.ZodTypeDef,
  Output
> = z.object({
  metrics: z.lazy(() => Metrics$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Output$ {
  /** @deprecated use `Output$inboundSchema` instead. */
  export const inboundSchema = Output$inboundSchema;
  /** @deprecated use `Output$outboundSchema` instead. */
  export const outboundSchema = Output$outboundSchema;
  /** @deprecated use `Output$Outbound` instead. */
  export type Outbound = Output$Outbound;
}

/** @internal */
export const UpdateCheckRequestBody$inboundSchema: z.ZodType<
  UpdateCheckRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string().optional(),
  path: z.string().optional(),
  status: Status$inboundSchema.optional(),
  conclusion: Conclusion$inboundSchema.optional(),
  detailsUrl: z.string().optional(),
  output: z.lazy(() => Output$inboundSchema).optional(),
  externalId: z.string().optional(),
});

/** @internal */
export type UpdateCheckRequestBody$Outbound = {
  name?: string | undefined;
  path?: string | undefined;
  status?: string | undefined;
  conclusion?: string | undefined;
  detailsUrl?: string | undefined;
  output?: Output$Outbound | undefined;
  externalId?: string | undefined;
};

/** @internal */
export const UpdateCheckRequestBody$outboundSchema: z.ZodType<
  UpdateCheckRequestBody$Outbound,
  z.ZodTypeDef,
  UpdateCheckRequestBody
> = z.object({
  name: z.string().optional(),
  path: z.string().optional(),
  status: Status$outboundSchema.optional(),
  conclusion: Conclusion$outboundSchema.optional(),
  detailsUrl: z.string().optional(),
  output: z.lazy(() => Output$outboundSchema).optional(),
  externalId: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckRequestBody$ {
  /** @deprecated use `UpdateCheckRequestBody$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckRequestBody$inboundSchema;
  /** @deprecated use `UpdateCheckRequestBody$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckRequestBody$outboundSchema;
  /** @deprecated use `UpdateCheckRequestBody$Outbound` instead. */
  export type Outbound = UpdateCheckRequestBody$Outbound;
}

/** @internal */
export const UpdateCheckRequest$inboundSchema: z.ZodType<
  UpdateCheckRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentId: z.string(),
  checkId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => UpdateCheckRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type UpdateCheckRequest$Outbound = {
  deploymentId: string;
  checkId: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: UpdateCheckRequestBody$Outbound | undefined;
};

/** @internal */
export const UpdateCheckRequest$outboundSchema: z.ZodType<
  UpdateCheckRequest$Outbound,
  z.ZodTypeDef,
  UpdateCheckRequest
> = z.object({
  deploymentId: z.string(),
  checkId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => UpdateCheckRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckRequest$ {
  /** @deprecated use `UpdateCheckRequest$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckRequest$inboundSchema;
  /** @deprecated use `UpdateCheckRequest$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckRequest$outboundSchema;
  /** @deprecated use `UpdateCheckRequest$Outbound` instead. */
  export type Outbound = UpdateCheckRequest$Outbound;
}

/** @internal */
export const UpdateCheckStatus$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckStatus
> = z.nativeEnum(UpdateCheckStatus);

/** @internal */
export const UpdateCheckStatus$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckStatus
> = UpdateCheckStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckStatus$ {
  /** @deprecated use `UpdateCheckStatus$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckStatus$inboundSchema;
  /** @deprecated use `UpdateCheckStatus$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckStatus$outboundSchema;
}

/** @internal */
export const UpdateCheckConclusion$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckConclusion
> = z.nativeEnum(UpdateCheckConclusion);

/** @internal */
export const UpdateCheckConclusion$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckConclusion
> = UpdateCheckConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckConclusion$ {
  /** @deprecated use `UpdateCheckConclusion$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckConclusion$inboundSchema;
  /** @deprecated use `UpdateCheckConclusion$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckConclusion$outboundSchema;
}

/** @internal */
export const UpdateCheckChecksResponseSource$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksResponseSource
> = z.nativeEnum(UpdateCheckChecksResponseSource);

/** @internal */
export const UpdateCheckChecksResponseSource$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksResponseSource
> = UpdateCheckChecksResponseSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksResponseSource$ {
  /** @deprecated use `UpdateCheckChecksResponseSource$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckChecksResponseSource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksResponseSource$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckChecksResponseSource$outboundSchema;
}

/** @internal */
export const UpdateCheckFCP$inboundSchema: z.ZodType<
  UpdateCheckFCP,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: UpdateCheckChecksResponseSource$inboundSchema,
});

/** @internal */
export type UpdateCheckFCP$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const UpdateCheckFCP$outboundSchema: z.ZodType<
  UpdateCheckFCP$Outbound,
  z.ZodTypeDef,
  UpdateCheckFCP
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: UpdateCheckChecksResponseSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckFCP$ {
  /** @deprecated use `UpdateCheckFCP$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckFCP$inboundSchema;
  /** @deprecated use `UpdateCheckFCP$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckFCP$outboundSchema;
  /** @deprecated use `UpdateCheckFCP$Outbound` instead. */
  export type Outbound = UpdateCheckFCP$Outbound;
}

/** @internal */
export const UpdateCheckChecksResponse200Source$inboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksResponse200Source
> = z.nativeEnum(UpdateCheckChecksResponse200Source);

/** @internal */
export const UpdateCheckChecksResponse200Source$outboundSchema: z.ZodNativeEnum<
  typeof UpdateCheckChecksResponse200Source
> = UpdateCheckChecksResponse200Source$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksResponse200Source$ {
  /** @deprecated use `UpdateCheckChecksResponse200Source$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckChecksResponse200Source$inboundSchema;
  /** @deprecated use `UpdateCheckChecksResponse200Source$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckChecksResponse200Source$outboundSchema;
}

/** @internal */
export const UpdateCheckLCP$inboundSchema: z.ZodType<
  UpdateCheckLCP,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: UpdateCheckChecksResponse200Source$inboundSchema,
});

/** @internal */
export type UpdateCheckLCP$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const UpdateCheckLCP$outboundSchema: z.ZodType<
  UpdateCheckLCP$Outbound,
  z.ZodTypeDef,
  UpdateCheckLCP
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: UpdateCheckChecksResponse200Source$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckLCP$ {
  /** @deprecated use `UpdateCheckLCP$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckLCP$inboundSchema;
  /** @deprecated use `UpdateCheckLCP$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckLCP$outboundSchema;
  /** @deprecated use `UpdateCheckLCP$Outbound` instead. */
  export type Outbound = UpdateCheckLCP$Outbound;
}

/** @internal */
export const UpdateCheckChecksResponse200ApplicationJSONSource$inboundSchema:
  z.ZodNativeEnum<typeof UpdateCheckChecksResponse200ApplicationJSONSource> = z
    .nativeEnum(UpdateCheckChecksResponse200ApplicationJSONSource);

/** @internal */
export const UpdateCheckChecksResponse200ApplicationJSONSource$outboundSchema:
  z.ZodNativeEnum<typeof UpdateCheckChecksResponse200ApplicationJSONSource> =
    UpdateCheckChecksResponse200ApplicationJSONSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksResponse200ApplicationJSONSource$ {
  /** @deprecated use `UpdateCheckChecksResponse200ApplicationJSONSource$inboundSchema` instead. */
  export const inboundSchema =
    UpdateCheckChecksResponse200ApplicationJSONSource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksResponse200ApplicationJSONSource$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckChecksResponse200ApplicationJSONSource$outboundSchema;
}

/** @internal */
export const UpdateCheckCLS$inboundSchema: z.ZodType<
  UpdateCheckCLS,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: UpdateCheckChecksResponse200ApplicationJSONSource$inboundSchema,
});

/** @internal */
export type UpdateCheckCLS$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const UpdateCheckCLS$outboundSchema: z.ZodType<
  UpdateCheckCLS$Outbound,
  z.ZodTypeDef,
  UpdateCheckCLS
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: UpdateCheckChecksResponse200ApplicationJSONSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckCLS$ {
  /** @deprecated use `UpdateCheckCLS$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckCLS$inboundSchema;
  /** @deprecated use `UpdateCheckCLS$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckCLS$outboundSchema;
  /** @deprecated use `UpdateCheckCLS$Outbound` instead. */
  export type Outbound = UpdateCheckCLS$Outbound;
}

/** @internal */
export const UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateCheckChecksResponse200ApplicationJSONResponseBodySource
  > = z.nativeEnum(
    UpdateCheckChecksResponse200ApplicationJSONResponseBodySource,
  );

/** @internal */
export const UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateCheckChecksResponse200ApplicationJSONResponseBodySource
  > =
    UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$ {
  /** @deprecated use `UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$inboundSchema` instead. */
  export const inboundSchema =
    UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$outboundSchema;
}

/** @internal */
export const UpdateCheckTBT$inboundSchema: z.ZodType<
  UpdateCheckTBT,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source:
    UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$inboundSchema,
});

/** @internal */
export type UpdateCheckTBT$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const UpdateCheckTBT$outboundSchema: z.ZodType<
  UpdateCheckTBT$Outbound,
  z.ZodTypeDef,
  UpdateCheckTBT
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source:
    UpdateCheckChecksResponse200ApplicationJSONResponseBodySource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckTBT$ {
  /** @deprecated use `UpdateCheckTBT$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckTBT$inboundSchema;
  /** @deprecated use `UpdateCheckTBT$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckTBT$outboundSchema;
  /** @deprecated use `UpdateCheckTBT$Outbound` instead. */
  export type Outbound = UpdateCheckTBT$Outbound;
}

/** @internal */
export const UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$inboundSchema:
  z.ZodNativeEnum<
    typeof UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource
  > = z.nativeEnum(
    UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource,
  );

/** @internal */
export const UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$outboundSchema:
  z.ZodNativeEnum<
    typeof UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource
  > =
    UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$ {
  /** @deprecated use `UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$inboundSchema` instead. */
  export const inboundSchema =
    UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$inboundSchema;
  /** @deprecated use `UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$outboundSchema;
}

/** @internal */
export const UpdateCheckVirtualExperienceScore$inboundSchema: z.ZodType<
  UpdateCheckVirtualExperienceScore,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source:
    UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$inboundSchema,
});

/** @internal */
export type UpdateCheckVirtualExperienceScore$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const UpdateCheckVirtualExperienceScore$outboundSchema: z.ZodType<
  UpdateCheckVirtualExperienceScore$Outbound,
  z.ZodTypeDef,
  UpdateCheckVirtualExperienceScore
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source:
    UpdateCheckChecksResponse200ApplicationJSONResponseBodyOutputSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckVirtualExperienceScore$ {
  /** @deprecated use `UpdateCheckVirtualExperienceScore$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckVirtualExperienceScore$inboundSchema;
  /** @deprecated use `UpdateCheckVirtualExperienceScore$outboundSchema` instead. */
  export const outboundSchema =
    UpdateCheckVirtualExperienceScore$outboundSchema;
  /** @deprecated use `UpdateCheckVirtualExperienceScore$Outbound` instead. */
  export type Outbound = UpdateCheckVirtualExperienceScore$Outbound;
}

/** @internal */
export const UpdateCheckMetrics$inboundSchema: z.ZodType<
  UpdateCheckMetrics,
  z.ZodTypeDef,
  unknown
> = z.object({
  FCP: z.lazy(() => UpdateCheckFCP$inboundSchema),
  LCP: z.lazy(() => UpdateCheckLCP$inboundSchema),
  CLS: z.lazy(() => UpdateCheckCLS$inboundSchema),
  TBT: z.lazy(() => UpdateCheckTBT$inboundSchema),
  virtualExperienceScore: z.lazy(() =>
    UpdateCheckVirtualExperienceScore$inboundSchema
  ).optional(),
}).transform((v) => {
  return remap$(v, {
    "FCP": "fcp",
    "LCP": "lcp",
    "CLS": "cls",
    "TBT": "tbt",
  });
});

/** @internal */
export type UpdateCheckMetrics$Outbound = {
  FCP: UpdateCheckFCP$Outbound;
  LCP: UpdateCheckLCP$Outbound;
  CLS: UpdateCheckCLS$Outbound;
  TBT: UpdateCheckTBT$Outbound;
  virtualExperienceScore?:
    | UpdateCheckVirtualExperienceScore$Outbound
    | undefined;
};

/** @internal */
export const UpdateCheckMetrics$outboundSchema: z.ZodType<
  UpdateCheckMetrics$Outbound,
  z.ZodTypeDef,
  UpdateCheckMetrics
> = z.object({
  fcp: z.lazy(() => UpdateCheckFCP$outboundSchema),
  lcp: z.lazy(() => UpdateCheckLCP$outboundSchema),
  cls: z.lazy(() => UpdateCheckCLS$outboundSchema),
  tbt: z.lazy(() => UpdateCheckTBT$outboundSchema),
  virtualExperienceScore: z.lazy(() =>
    UpdateCheckVirtualExperienceScore$outboundSchema
  ).optional(),
}).transform((v) => {
  return remap$(v, {
    fcp: "FCP",
    lcp: "LCP",
    cls: "CLS",
    tbt: "TBT",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckMetrics$ {
  /** @deprecated use `UpdateCheckMetrics$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckMetrics$inboundSchema;
  /** @deprecated use `UpdateCheckMetrics$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckMetrics$outboundSchema;
  /** @deprecated use `UpdateCheckMetrics$Outbound` instead. */
  export type Outbound = UpdateCheckMetrics$Outbound;
}

/** @internal */
export const UpdateCheckOutput$inboundSchema: z.ZodType<
  UpdateCheckOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  metrics: z.lazy(() => UpdateCheckMetrics$inboundSchema).optional(),
});

/** @internal */
export type UpdateCheckOutput$Outbound = {
  metrics?: UpdateCheckMetrics$Outbound | undefined;
};

/** @internal */
export const UpdateCheckOutput$outboundSchema: z.ZodType<
  UpdateCheckOutput$Outbound,
  z.ZodTypeDef,
  UpdateCheckOutput
> = z.object({
  metrics: z.lazy(() => UpdateCheckMetrics$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckOutput$ {
  /** @deprecated use `UpdateCheckOutput$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckOutput$inboundSchema;
  /** @deprecated use `UpdateCheckOutput$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckOutput$outboundSchema;
  /** @deprecated use `UpdateCheckOutput$Outbound` instead. */
  export type Outbound = UpdateCheckOutput$Outbound;
}

/** @internal */
export const UpdateCheckResponseBody$inboundSchema: z.ZodType<
  UpdateCheckResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  path: z.string().optional(),
  status: UpdateCheckStatus$inboundSchema,
  conclusion: UpdateCheckConclusion$inboundSchema.optional(),
  blocking: z.boolean(),
  output: z.lazy(() => UpdateCheckOutput$inboundSchema).optional(),
  detailsUrl: z.string().optional(),
  integrationId: z.string(),
  deploymentId: z.string(),
  externalId: z.string().optional(),
  createdAt: z.number(),
  updatedAt: z.number(),
  startedAt: z.number().optional(),
  completedAt: z.number().optional(),
  rerequestable: z.boolean().optional(),
});

/** @internal */
export type UpdateCheckResponseBody$Outbound = {
  id: string;
  name: string;
  path?: string | undefined;
  status: string;
  conclusion?: string | undefined;
  blocking: boolean;
  output?: UpdateCheckOutput$Outbound | undefined;
  detailsUrl?: string | undefined;
  integrationId: string;
  deploymentId: string;
  externalId?: string | undefined;
  createdAt: number;
  updatedAt: number;
  startedAt?: number | undefined;
  completedAt?: number | undefined;
  rerequestable?: boolean | undefined;
};

/** @internal */
export const UpdateCheckResponseBody$outboundSchema: z.ZodType<
  UpdateCheckResponseBody$Outbound,
  z.ZodTypeDef,
  UpdateCheckResponseBody
> = z.object({
  id: z.string(),
  name: z.string(),
  path: z.string().optional(),
  status: UpdateCheckStatus$outboundSchema,
  conclusion: UpdateCheckConclusion$outboundSchema.optional(),
  blocking: z.boolean(),
  output: z.lazy(() => UpdateCheckOutput$outboundSchema).optional(),
  detailsUrl: z.string().optional(),
  integrationId: z.string(),
  deploymentId: z.string(),
  externalId: z.string().optional(),
  createdAt: z.number(),
  updatedAt: z.number(),
  startedAt: z.number().optional(),
  completedAt: z.number().optional(),
  rerequestable: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateCheckResponseBody$ {
  /** @deprecated use `UpdateCheckResponseBody$inboundSchema` instead. */
  export const inboundSchema = UpdateCheckResponseBody$inboundSchema;
  /** @deprecated use `UpdateCheckResponseBody$outboundSchema` instead. */
  export const outboundSchema = UpdateCheckResponseBody$outboundSchema;
  /** @deprecated use `UpdateCheckResponseBody$Outbound` instead. */
  export type Outbound = UpdateCheckResponseBody$Outbound;
}
