/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";

export type UpdateAttackChallengeModeRequestBody = {
  projectId: string;
  attackModeEnabled: boolean;
  attackModeActiveUntil?: number | null | undefined;
};

export type UpdateAttackChallengeModeRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: UpdateAttackChallengeModeRequestBody | undefined;
};

export type UpdateAttackChallengeModeResponseBody = {
  attackModeEnabled: boolean;
  attackModeUpdatedAt: number;
};

/** @internal */
export const UpdateAttackChallengeModeRequestBody$inboundSchema: z.ZodType<
  UpdateAttackChallengeModeRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string(),
  attackModeEnabled: z.boolean(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
});

/** @internal */
export type UpdateAttackChallengeModeRequestBody$Outbound = {
  projectId: string;
  attackModeEnabled: boolean;
  attackModeActiveUntil?: number | null | undefined;
};

/** @internal */
export const UpdateAttackChallengeModeRequestBody$outboundSchema: z.ZodType<
  UpdateAttackChallengeModeRequestBody$Outbound,
  z.ZodTypeDef,
  UpdateAttackChallengeModeRequestBody
> = z.object({
  projectId: z.string(),
  attackModeEnabled: z.boolean(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateAttackChallengeModeRequestBody$ {
  /** @deprecated use `UpdateAttackChallengeModeRequestBody$inboundSchema` instead. */
  export const inboundSchema =
    UpdateAttackChallengeModeRequestBody$inboundSchema;
  /** @deprecated use `UpdateAttackChallengeModeRequestBody$outboundSchema` instead. */
  export const outboundSchema =
    UpdateAttackChallengeModeRequestBody$outboundSchema;
  /** @deprecated use `UpdateAttackChallengeModeRequestBody$Outbound` instead. */
  export type Outbound = UpdateAttackChallengeModeRequestBody$Outbound;
}

/** @internal */
export const UpdateAttackChallengeModeRequest$inboundSchema: z.ZodType<
  UpdateAttackChallengeModeRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => UpdateAttackChallengeModeRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type UpdateAttackChallengeModeRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: UpdateAttackChallengeModeRequestBody$Outbound | undefined;
};

/** @internal */
export const UpdateAttackChallengeModeRequest$outboundSchema: z.ZodType<
  UpdateAttackChallengeModeRequest$Outbound,
  z.ZodTypeDef,
  UpdateAttackChallengeModeRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => UpdateAttackChallengeModeRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateAttackChallengeModeRequest$ {
  /** @deprecated use `UpdateAttackChallengeModeRequest$inboundSchema` instead. */
  export const inboundSchema = UpdateAttackChallengeModeRequest$inboundSchema;
  /** @deprecated use `UpdateAttackChallengeModeRequest$outboundSchema` instead. */
  export const outboundSchema = UpdateAttackChallengeModeRequest$outboundSchema;
  /** @deprecated use `UpdateAttackChallengeModeRequest$Outbound` instead. */
  export type Outbound = UpdateAttackChallengeModeRequest$Outbound;
}

/** @internal */
export const UpdateAttackChallengeModeResponseBody$inboundSchema: z.ZodType<
  UpdateAttackChallengeModeResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  attackModeEnabled: z.boolean(),
  attackModeUpdatedAt: z.number(),
});

/** @internal */
export type UpdateAttackChallengeModeResponseBody$Outbound = {
  attackModeEnabled: boolean;
  attackModeUpdatedAt: number;
};

/** @internal */
export const UpdateAttackChallengeModeResponseBody$outboundSchema: z.ZodType<
  UpdateAttackChallengeModeResponseBody$Outbound,
  z.ZodTypeDef,
  UpdateAttackChallengeModeResponseBody
> = z.object({
  attackModeEnabled: z.boolean(),
  attackModeUpdatedAt: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UpdateAttackChallengeModeResponseBody$ {
  /** @deprecated use `UpdateAttackChallengeModeResponseBody$inboundSchema` instead. */
  export const inboundSchema =
    UpdateAttackChallengeModeResponseBody$inboundSchema;
  /** @deprecated use `UpdateAttackChallengeModeResponseBody$outboundSchema` instead. */
  export const outboundSchema =
    UpdateAttackChallengeModeResponseBody$outboundSchema;
  /** @deprecated use `UpdateAttackChallengeModeResponseBody$Outbound` instead. */
  export type Outbound = UpdateAttackChallengeModeResponseBody$Outbound;
}
