/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The origin of the request.
 */
export const Origin = {
  Import: "import",
  Teams: "teams",
  Github: "github",
  Gitlab: "gitlab",
  Bitbucket: "bitbucket",
  Feedback: "feedback",
  OrganizationTeams: "organization-teams",
} as const;
/**
 * The origin of the request.
 */
export type Origin = ClosedEnum<typeof Origin>;

/**
 * The ID of the Git account of the user who requests access.
 */
export type GitUserId = string | number;

export type JoinedFrom = {
  /**
   * The origin of the request.
   */
  origin: Origin;
  /**
   * The commit sha if the origin is a git provider.
   */
  commitId?: string | undefined;
  /**
   * The ID of the repository for the given Git provider.
   */
  repoId?: string | undefined;
  /**
   * The path to the repository for the given Git provider.
   */
  repoPath?: string | undefined;
  /**
   * The ID of the Git account of the user who requests access.
   */
  gitUserId?: string | number | undefined;
  /**
   * The login name for the Git account of the user who requests access.
   */
  gitUserLogin?: string | undefined;
};

export type RequestAccessToTeamRequestBody = {
  joinedFrom: JoinedFrom;
};

export type RequestAccessToTeamRequest = {
  teamId: string;
  requestBody?: RequestAccessToTeamRequestBody | undefined;
};

export const RequestAccessToTeamOrigin = {
  Import: "import",
  Teams: "teams",
  Github: "github",
  Gitlab: "gitlab",
  Bitbucket: "bitbucket",
  Feedback: "feedback",
  OrganizationTeams: "organization-teams",
  Mail: "mail",
  Link: "link",
  Saml: "saml",
  Dsync: "dsync",
} as const;
export type RequestAccessToTeamOrigin = ClosedEnum<
  typeof RequestAccessToTeamOrigin
>;

export type RequestAccessToTeamGitUserId = string | number;

export type RequestAccessToTeamJoinedFrom = {
  origin: RequestAccessToTeamOrigin;
  commitId?: string | undefined;
  repoId?: string | undefined;
  repoPath?: string | undefined;
  gitUserId?: string | number | undefined;
  gitUserLogin?: string | undefined;
  ssoUserId?: string | undefined;
  ssoConnectedAt?: number | undefined;
  idpUserId?: string | undefined;
  dsyncUserId?: string | undefined;
  dsyncConnectedAt?: number | undefined;
};

export type Github = {
  login?: string | undefined;
};

export type Gitlab = {
  login?: string | undefined;
};

export type Bitbucket = {
  login?: string | undefined;
};

/**
 * Successfuly requested access to the team.
 */
export type RequestAccessToTeamResponseBody = {
  teamSlug: string;
  teamName: string;
  confirmed?: boolean | undefined;
  joinedFrom?: RequestAccessToTeamJoinedFrom | undefined;
  accessRequestedAt?: number | undefined;
  github: Github | null;
  gitlab: Gitlab | null;
  bitbucket: Bitbucket | null;
};

/** @internal */
export const Origin$inboundSchema: z.ZodNativeEnum<typeof Origin> = z
  .nativeEnum(Origin);

/** @internal */
export const Origin$outboundSchema: z.ZodNativeEnum<typeof Origin> =
  Origin$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Origin$ {
  /** @deprecated use `Origin$inboundSchema` instead. */
  export const inboundSchema = Origin$inboundSchema;
  /** @deprecated use `Origin$outboundSchema` instead. */
  export const outboundSchema = Origin$outboundSchema;
}

/** @internal */
export const GitUserId$inboundSchema: z.ZodType<
  GitUserId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GitUserId$Outbound = string | number;

/** @internal */
export const GitUserId$outboundSchema: z.ZodType<
  GitUserId$Outbound,
  z.ZodTypeDef,
  GitUserId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitUserId$ {
  /** @deprecated use `GitUserId$inboundSchema` instead. */
  export const inboundSchema = GitUserId$inboundSchema;
  /** @deprecated use `GitUserId$outboundSchema` instead. */
  export const outboundSchema = GitUserId$outboundSchema;
  /** @deprecated use `GitUserId$Outbound` instead. */
  export type Outbound = GitUserId$Outbound;
}

/** @internal */
export const JoinedFrom$inboundSchema: z.ZodType<
  JoinedFrom,
  z.ZodTypeDef,
  unknown
> = z.object({
  origin: Origin$inboundSchema,
  commitId: z.string().optional(),
  repoId: z.string().optional(),
  repoPath: z.string().optional(),
  gitUserId: z.union([z.string(), z.number()]).optional(),
  gitUserLogin: z.string().optional(),
});

/** @internal */
export type JoinedFrom$Outbound = {
  origin: string;
  commitId?: string | undefined;
  repoId?: string | undefined;
  repoPath?: string | undefined;
  gitUserId?: string | number | undefined;
  gitUserLogin?: string | undefined;
};

/** @internal */
export const JoinedFrom$outboundSchema: z.ZodType<
  JoinedFrom$Outbound,
  z.ZodTypeDef,
  JoinedFrom
> = z.object({
  origin: Origin$outboundSchema,
  commitId: z.string().optional(),
  repoId: z.string().optional(),
  repoPath: z.string().optional(),
  gitUserId: z.union([z.string(), z.number()]).optional(),
  gitUserLogin: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace JoinedFrom$ {
  /** @deprecated use `JoinedFrom$inboundSchema` instead. */
  export const inboundSchema = JoinedFrom$inboundSchema;
  /** @deprecated use `JoinedFrom$outboundSchema` instead. */
  export const outboundSchema = JoinedFrom$outboundSchema;
  /** @deprecated use `JoinedFrom$Outbound` instead. */
  export type Outbound = JoinedFrom$Outbound;
}

/** @internal */
export const RequestAccessToTeamRequestBody$inboundSchema: z.ZodType<
  RequestAccessToTeamRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  joinedFrom: z.lazy(() => JoinedFrom$inboundSchema),
});

/** @internal */
export type RequestAccessToTeamRequestBody$Outbound = {
  joinedFrom: JoinedFrom$Outbound;
};

/** @internal */
export const RequestAccessToTeamRequestBody$outboundSchema: z.ZodType<
  RequestAccessToTeamRequestBody$Outbound,
  z.ZodTypeDef,
  RequestAccessToTeamRequestBody
> = z.object({
  joinedFrom: z.lazy(() => JoinedFrom$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestAccessToTeamRequestBody$ {
  /** @deprecated use `RequestAccessToTeamRequestBody$inboundSchema` instead. */
  export const inboundSchema = RequestAccessToTeamRequestBody$inboundSchema;
  /** @deprecated use `RequestAccessToTeamRequestBody$outboundSchema` instead. */
  export const outboundSchema = RequestAccessToTeamRequestBody$outboundSchema;
  /** @deprecated use `RequestAccessToTeamRequestBody$Outbound` instead. */
  export type Outbound = RequestAccessToTeamRequestBody$Outbound;
}

/** @internal */
export const RequestAccessToTeamRequest$inboundSchema: z.ZodType<
  RequestAccessToTeamRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string(),
  RequestBody: z.lazy(() => RequestAccessToTeamRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type RequestAccessToTeamRequest$Outbound = {
  teamId: string;
  RequestBody?: RequestAccessToTeamRequestBody$Outbound | undefined;
};

/** @internal */
export const RequestAccessToTeamRequest$outboundSchema: z.ZodType<
  RequestAccessToTeamRequest$Outbound,
  z.ZodTypeDef,
  RequestAccessToTeamRequest
> = z.object({
  teamId: z.string(),
  requestBody: z.lazy(() => RequestAccessToTeamRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestAccessToTeamRequest$ {
  /** @deprecated use `RequestAccessToTeamRequest$inboundSchema` instead. */
  export const inboundSchema = RequestAccessToTeamRequest$inboundSchema;
  /** @deprecated use `RequestAccessToTeamRequest$outboundSchema` instead. */
  export const outboundSchema = RequestAccessToTeamRequest$outboundSchema;
  /** @deprecated use `RequestAccessToTeamRequest$Outbound` instead. */
  export type Outbound = RequestAccessToTeamRequest$Outbound;
}

/** @internal */
export const RequestAccessToTeamOrigin$inboundSchema: z.ZodNativeEnum<
  typeof RequestAccessToTeamOrigin
> = z.nativeEnum(RequestAccessToTeamOrigin);

/** @internal */
export const RequestAccessToTeamOrigin$outboundSchema: z.ZodNativeEnum<
  typeof RequestAccessToTeamOrigin
> = RequestAccessToTeamOrigin$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestAccessToTeamOrigin$ {
  /** @deprecated use `RequestAccessToTeamOrigin$inboundSchema` instead. */
  export const inboundSchema = RequestAccessToTeamOrigin$inboundSchema;
  /** @deprecated use `RequestAccessToTeamOrigin$outboundSchema` instead. */
  export const outboundSchema = RequestAccessToTeamOrigin$outboundSchema;
}

/** @internal */
export const RequestAccessToTeamGitUserId$inboundSchema: z.ZodType<
  RequestAccessToTeamGitUserId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type RequestAccessToTeamGitUserId$Outbound = string | number;

/** @internal */
export const RequestAccessToTeamGitUserId$outboundSchema: z.ZodType<
  RequestAccessToTeamGitUserId$Outbound,
  z.ZodTypeDef,
  RequestAccessToTeamGitUserId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestAccessToTeamGitUserId$ {
  /** @deprecated use `RequestAccessToTeamGitUserId$inboundSchema` instead. */
  export const inboundSchema = RequestAccessToTeamGitUserId$inboundSchema;
  /** @deprecated use `RequestAccessToTeamGitUserId$outboundSchema` instead. */
  export const outboundSchema = RequestAccessToTeamGitUserId$outboundSchema;
  /** @deprecated use `RequestAccessToTeamGitUserId$Outbound` instead. */
  export type Outbound = RequestAccessToTeamGitUserId$Outbound;
}

/** @internal */
export const RequestAccessToTeamJoinedFrom$inboundSchema: z.ZodType<
  RequestAccessToTeamJoinedFrom,
  z.ZodTypeDef,
  unknown
> = z.object({
  origin: RequestAccessToTeamOrigin$inboundSchema,
  commitId: z.string().optional(),
  repoId: z.string().optional(),
  repoPath: z.string().optional(),
  gitUserId: z.union([z.string(), z.number()]).optional(),
  gitUserLogin: z.string().optional(),
  ssoUserId: z.string().optional(),
  ssoConnectedAt: z.number().optional(),
  idpUserId: z.string().optional(),
  dsyncUserId: z.string().optional(),
  dsyncConnectedAt: z.number().optional(),
});

/** @internal */
export type RequestAccessToTeamJoinedFrom$Outbound = {
  origin: string;
  commitId?: string | undefined;
  repoId?: string | undefined;
  repoPath?: string | undefined;
  gitUserId?: string | number | undefined;
  gitUserLogin?: string | undefined;
  ssoUserId?: string | undefined;
  ssoConnectedAt?: number | undefined;
  idpUserId?: string | undefined;
  dsyncUserId?: string | undefined;
  dsyncConnectedAt?: number | undefined;
};

/** @internal */
export const RequestAccessToTeamJoinedFrom$outboundSchema: z.ZodType<
  RequestAccessToTeamJoinedFrom$Outbound,
  z.ZodTypeDef,
  RequestAccessToTeamJoinedFrom
> = z.object({
  origin: RequestAccessToTeamOrigin$outboundSchema,
  commitId: z.string().optional(),
  repoId: z.string().optional(),
  repoPath: z.string().optional(),
  gitUserId: z.union([z.string(), z.number()]).optional(),
  gitUserLogin: z.string().optional(),
  ssoUserId: z.string().optional(),
  ssoConnectedAt: z.number().optional(),
  idpUserId: z.string().optional(),
  dsyncUserId: z.string().optional(),
  dsyncConnectedAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestAccessToTeamJoinedFrom$ {
  /** @deprecated use `RequestAccessToTeamJoinedFrom$inboundSchema` instead. */
  export const inboundSchema = RequestAccessToTeamJoinedFrom$inboundSchema;
  /** @deprecated use `RequestAccessToTeamJoinedFrom$outboundSchema` instead. */
  export const outboundSchema = RequestAccessToTeamJoinedFrom$outboundSchema;
  /** @deprecated use `RequestAccessToTeamJoinedFrom$Outbound` instead. */
  export type Outbound = RequestAccessToTeamJoinedFrom$Outbound;
}

/** @internal */
export const Github$inboundSchema: z.ZodType<Github, z.ZodTypeDef, unknown> = z
  .object({
    login: z.string().optional(),
  });

/** @internal */
export type Github$Outbound = {
  login?: string | undefined;
};

/** @internal */
export const Github$outboundSchema: z.ZodType<
  Github$Outbound,
  z.ZodTypeDef,
  Github
> = z.object({
  login: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Github$ {
  /** @deprecated use `Github$inboundSchema` instead. */
  export const inboundSchema = Github$inboundSchema;
  /** @deprecated use `Github$outboundSchema` instead. */
  export const outboundSchema = Github$outboundSchema;
  /** @deprecated use `Github$Outbound` instead. */
  export type Outbound = Github$Outbound;
}

/** @internal */
export const Gitlab$inboundSchema: z.ZodType<Gitlab, z.ZodTypeDef, unknown> = z
  .object({
    login: z.string().optional(),
  });

/** @internal */
export type Gitlab$Outbound = {
  login?: string | undefined;
};

/** @internal */
export const Gitlab$outboundSchema: z.ZodType<
  Gitlab$Outbound,
  z.ZodTypeDef,
  Gitlab
> = z.object({
  login: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Gitlab$ {
  /** @deprecated use `Gitlab$inboundSchema` instead. */
  export const inboundSchema = Gitlab$inboundSchema;
  /** @deprecated use `Gitlab$outboundSchema` instead. */
  export const outboundSchema = Gitlab$outboundSchema;
  /** @deprecated use `Gitlab$Outbound` instead. */
  export type Outbound = Gitlab$Outbound;
}

/** @internal */
export const Bitbucket$inboundSchema: z.ZodType<
  Bitbucket,
  z.ZodTypeDef,
  unknown
> = z.object({
  login: z.string().optional(),
});

/** @internal */
export type Bitbucket$Outbound = {
  login?: string | undefined;
};

/** @internal */
export const Bitbucket$outboundSchema: z.ZodType<
  Bitbucket$Outbound,
  z.ZodTypeDef,
  Bitbucket
> = z.object({
  login: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Bitbucket$ {
  /** @deprecated use `Bitbucket$inboundSchema` instead. */
  export const inboundSchema = Bitbucket$inboundSchema;
  /** @deprecated use `Bitbucket$outboundSchema` instead. */
  export const outboundSchema = Bitbucket$outboundSchema;
  /** @deprecated use `Bitbucket$Outbound` instead. */
  export type Outbound = Bitbucket$Outbound;
}

/** @internal */
export const RequestAccessToTeamResponseBody$inboundSchema: z.ZodType<
  RequestAccessToTeamResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamSlug: z.string(),
  teamName: z.string(),
  confirmed: z.boolean().optional(),
  joinedFrom: z.lazy(() => RequestAccessToTeamJoinedFrom$inboundSchema)
    .optional(),
  accessRequestedAt: z.number().optional(),
  github: z.nullable(z.lazy(() => Github$inboundSchema)),
  gitlab: z.nullable(z.lazy(() => Gitlab$inboundSchema)),
  bitbucket: z.nullable(z.lazy(() => Bitbucket$inboundSchema)),
});

/** @internal */
export type RequestAccessToTeamResponseBody$Outbound = {
  teamSlug: string;
  teamName: string;
  confirmed?: boolean | undefined;
  joinedFrom?: RequestAccessToTeamJoinedFrom$Outbound | undefined;
  accessRequestedAt?: number | undefined;
  github: Github$Outbound | null;
  gitlab: Gitlab$Outbound | null;
  bitbucket: Bitbucket$Outbound | null;
};

/** @internal */
export const RequestAccessToTeamResponseBody$outboundSchema: z.ZodType<
  RequestAccessToTeamResponseBody$Outbound,
  z.ZodTypeDef,
  RequestAccessToTeamResponseBody
> = z.object({
  teamSlug: z.string(),
  teamName: z.string(),
  confirmed: z.boolean().optional(),
  joinedFrom: z.lazy(() => RequestAccessToTeamJoinedFrom$outboundSchema)
    .optional(),
  accessRequestedAt: z.number().optional(),
  github: z.nullable(z.lazy(() => Github$outboundSchema)),
  gitlab: z.nullable(z.lazy(() => Gitlab$outboundSchema)),
  bitbucket: z.nullable(z.lazy(() => Bitbucket$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestAccessToTeamResponseBody$ {
  /** @deprecated use `RequestAccessToTeamResponseBody$inboundSchema` instead. */
  export const inboundSchema = RequestAccessToTeamResponseBody$inboundSchema;
  /** @deprecated use `RequestAccessToTeamResponseBody$outboundSchema` instead. */
  export const outboundSchema = RequestAccessToTeamResponseBody$outboundSchema;
  /** @deprecated use `RequestAccessToTeamResponseBody$Outbound` instead. */
  export type Outbound = RequestAccessToTeamResponseBody$Outbound;
}
