/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

export type Owasp = {
  active: boolean;
};

export type ManagedRules = {
  owasp: Owasp;
};

export const Action = {
  Deny: "deny",
  Log: "log",
} as const;
export type Action = ClosedEnum<typeof Action>;

export type Sd = {
  active: boolean;
  action: Action;
};

export const PutFirewallConfigAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigAction = ClosedEnum<
  typeof PutFirewallConfigAction
>;

export type Ma = {
  active: boolean;
  action: PutFirewallConfigAction;
};

export const PutFirewallConfigSecurityAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityAction = ClosedEnum<
  typeof PutFirewallConfigSecurityAction
>;

export type Lfi = {
  active: boolean;
  action: PutFirewallConfigSecurityAction;
};

export const PutFirewallConfigSecurityRequestAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestAction = ClosedEnum<
  typeof PutFirewallConfigSecurityRequestAction
>;

export type Rfi = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyAction = ClosedEnum<
  typeof PutFirewallConfigSecurityRequestRequestBodyAction
>;

export type Rce = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyCrsAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyCrsAction = ClosedEnum<
  typeof PutFirewallConfigSecurityRequestRequestBodyCrsAction
>;

export type Php = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyCrsAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyCrsGenAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyCrsGenAction =
  ClosedEnum<typeof PutFirewallConfigSecurityRequestRequestBodyCrsGenAction>;

export type Gen = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyCrsGenAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyCrsXssAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyCrsXssAction =
  ClosedEnum<typeof PutFirewallConfigSecurityRequestRequestBodyCrsXssAction>;

export type Xss = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyCrsXssAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction =
  ClosedEnum<typeof PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction>;

export type Sqli = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyCrsSfAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyCrsSfAction = ClosedEnum<
  typeof PutFirewallConfigSecurityRequestRequestBodyCrsSfAction
>;

export type Sf = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyCrsSfAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction =
  ClosedEnum<typeof PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction>;

export type Java = {
  active: boolean;
  action: PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction;
};

export type Crs = {
  sd?: Sd | undefined;
  ma?: Ma | undefined;
  lfi?: Lfi | undefined;
  rfi?: Rfi | undefined;
  rce?: Rce | undefined;
  php?: Php | undefined;
  gen?: Gen | undefined;
  xss?: Xss | undefined;
  sqli?: Sqli | undefined;
  sf?: Sf | undefined;
  java?: Java | undefined;
};

export const PutFirewallConfigType = {
  Host: "host",
  Path: "path",
  Method: "method",
  Header: "header",
  Query: "query",
  Cookie: "cookie",
  TargetPath: "target_path",
  IpAddress: "ip_address",
  Region: "region",
  Protocol: "protocol",
  Scheme: "scheme",
  Environment: "environment",
  UserAgent: "user_agent",
  GeoContinent: "geo_continent",
  GeoCountry: "geo_country",
  GeoCountryRegion: "geo_country_region",
  GeoCity: "geo_city",
  GeoAsNumber: "geo_as_number",
  Ja4Digest: "ja4_digest",
  Ja3Digest: "ja3_digest",
  RateLimitApiId: "rate_limit_api_id",
} as const;
export type PutFirewallConfigType = ClosedEnum<typeof PutFirewallConfigType>;

export const Op = {
  Re: "re",
  Eq: "eq",
  Neq: "neq",
  Ex: "ex",
  Nex: "nex",
  Inc: "inc",
  Ninc: "ninc",
  Pre: "pre",
  Suf: "suf",
  Sub: "sub",
  Gt: "gt",
  Gte: "gte",
  Lt: "lt",
  Lte: "lte",
} as const;
export type Op = ClosedEnum<typeof Op>;

export type PutFirewallConfigValue = string | Array<string> | number;

export type Conditions = {
  type: PutFirewallConfigType;
  op: Op;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | Array<string> | number | undefined;
};

export type ConditionGroup = {
  conditions: Array<Conditions>;
};

export const PutFirewallConfigSecurityRequestRequestBodyRulesActionAction = {
  Log: "log",
  Challenge: "challenge",
  Deny: "deny",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyRulesActionAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyRulesActionAction
  >;

export const Algo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type Algo = ClosedEnum<typeof Algo>;

export const Action1 = {
  Log: "log",
  Challenge: "challenge",
  Deny: "deny",
  RateLimit: "rate_limit",
} as const;
export type Action1 = ClosedEnum<typeof Action1>;

export type RateLimitAction = Action1 | any;

export type RateLimit1 = {
  algo: Algo;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: Action1 | any | null | undefined;
};

export type RateLimit = RateLimit1 | any;

export type Redirect1 = {
  location: string;
  permanent: boolean;
};

export type Redirect = Redirect1 | any;

export type Mitigate = {
  action: PutFirewallConfigSecurityRequestRequestBodyRulesActionAction;
  rateLimit?: RateLimit1 | any | null | undefined;
  redirect?: Redirect1 | any | null | undefined;
  actionDuration?: string | null | undefined;
};

export type PutFirewallConfigSecurityRequestRequestBodyRulesAction = {
  mitigate?: Mitigate | undefined;
};

export type Rules = {
  id?: string | undefined;
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<ConditionGroup>;
  action: PutFirewallConfigSecurityRequestRequestBodyRulesAction;
};

export const PutFirewallConfigSecurityRequestRequestBodyIpsAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
} as const;
export type PutFirewallConfigSecurityRequestRequestBodyIpsAction = ClosedEnum<
  typeof PutFirewallConfigSecurityRequestRequestBodyIpsAction
>;

export type Ips = {
  id?: string | undefined;
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: PutFirewallConfigSecurityRequestRequestBodyIpsAction;
};

export type PutFirewallConfigRequestBody = {
  firewallEnabled: boolean;
  managedRules?: ManagedRules | undefined;
  crs?: Crs | undefined;
  rules?: Array<Rules> | undefined;
  ips?: Array<Ips> | undefined;
};

export type PutFirewallConfigRequest = {
  projectId: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: PutFirewallConfigRequestBody | undefined;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction
  >;

export type PutFirewallConfigSd = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction
  >;

export type PutFirewallConfigMa = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONAction = {
  Deny: "deny",
  Log: "log",
} as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONAction =
  ClosedEnum<typeof PutFirewallConfigSecurityResponse200ApplicationJSONAction>;

export type PutFirewallConfigLfi = {
  active: boolean;
  action: PutFirewallConfigSecurityResponse200ApplicationJSONAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction
  >;

export type PutFirewallConfigRfi = {
  active: boolean;
  action: PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction
  >;

export type PutFirewallConfigRce = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction
  >;

export type PutFirewallConfigPhp = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction
  >;

export type PutFirewallConfigGen = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction
  >;

export type PutFirewallConfigXss = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction
  >;

export type PutFirewallConfigSqli = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction
  >;

export type PutFirewallConfigSf = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction =
  {
    Deny: "deny",
    Log: "log",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction
  >;

export type PutFirewallConfigJava = {
  active: boolean;
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction;
};

export type PutFirewallConfigCrs = {
  sd: PutFirewallConfigSd;
  ma: PutFirewallConfigMa;
  lfi: PutFirewallConfigLfi;
  rfi: PutFirewallConfigRfi;
  rce: PutFirewallConfigRce;
  php: PutFirewallConfigPhp;
  gen: PutFirewallConfigGen;
  xss: PutFirewallConfigXss;
  sqli: PutFirewallConfigSqli;
  sf: PutFirewallConfigSf;
  java: PutFirewallConfigJava;
};

export const PutFirewallConfigSecurityType = {
  Host: "host",
  Path: "path",
  Method: "method",
  Header: "header",
  Query: "query",
  Cookie: "cookie",
  TargetPath: "target_path",
  IpAddress: "ip_address",
  Protocol: "protocol",
  Region: "region",
  Scheme: "scheme",
  Environment: "environment",
  UserAgent: "user_agent",
  GeoContinent: "geo_continent",
  GeoCountry: "geo_country",
  GeoCountryRegion: "geo_country_region",
  GeoCity: "geo_city",
  GeoAsNumber: "geo_as_number",
  Ja4Digest: "ja4_digest",
  Ja3Digest: "ja3_digest",
  RateLimitApiId: "rate_limit_api_id",
} as const;
export type PutFirewallConfigSecurityType = ClosedEnum<
  typeof PutFirewallConfigSecurityType
>;

export const PutFirewallConfigOp = {
  Re: "re",
  Eq: "eq",
  Ex: "ex",
  Inc: "inc",
  Pre: "pre",
  Suf: "suf",
  Sub: "sub",
  Gt: "gt",
  Gte: "gte",
  Lt: "lt",
  Lte: "lte",
  Nex: "nex",
  Ninc: "ninc",
  Neq: "neq",
} as const;
export type PutFirewallConfigOp = ClosedEnum<typeof PutFirewallConfigOp>;

export type PutFirewallConfigSecurityValue = string | number | Array<string>;

export type PutFirewallConfigConditions = {
  type: PutFirewallConfigSecurityType;
  op: PutFirewallConfigOp;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | number | Array<string> | undefined;
};

export type PutFirewallConfigConditionGroup = {
  conditions: Array<PutFirewallConfigConditions>;
};

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction =
  {
    Deny: "deny",
    Log: "log",
    Challenge: "challenge",
    Bypass: "bypass",
    RateLimit: "rate_limit",
    Redirect: "redirect",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction
  >;

export const PutFirewallConfigAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type PutFirewallConfigAlgo = ClosedEnum<typeof PutFirewallConfigAlgo>;

export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction =
  {
    Deny: "deny",
    Log: "log",
    Challenge: "challenge",
    RateLimit: "rate_limit",
  } as const;
export type PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction =
  ClosedEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction
  >;

export type PutFirewallConfigRateLimit = {
  algo: PutFirewallConfigAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
  action?:
    | PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction
    | null
    | undefined;
};

export type PutFirewallConfigRedirect = {
  location: string;
  permanent: boolean;
};

export type PutFirewallConfigMitigate = {
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction;
  rateLimit?: PutFirewallConfigRateLimit | null | undefined;
  redirect?: PutFirewallConfigRedirect | null | undefined;
  actionDuration?: string | null | undefined;
};

export type PutFirewallConfigSecurityResponseAction = {
  mitigate?: PutFirewallConfigMitigate | undefined;
};

export type PutFirewallConfigRules = {
  id: string;
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<PutFirewallConfigConditionGroup>;
  action: PutFirewallConfigSecurityResponseAction;
};

export const PutFirewallConfigSecurityResponse200Action = {
  Deny: "deny",
  Log: "log",
  Challenge: "challenge",
  Bypass: "bypass",
} as const;
export type PutFirewallConfigSecurityResponse200Action = ClosedEnum<
  typeof PutFirewallConfigSecurityResponse200Action
>;

export type PutFirewallConfigIps = {
  id: string;
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: PutFirewallConfigSecurityResponse200Action;
};

export type PutFirewallConfigChanges = {};

export type PutFirewallConfigOwasp = {
  active: boolean;
  updatedAt?: string | undefined;
  userId?: string | undefined;
  username?: string | undefined;
};

export type PutFirewallConfigVerifiedBotsBypass = {
  active: boolean;
  updatedAt?: string | undefined;
  userId?: string | undefined;
  username?: string | undefined;
};

export type PutFirewallConfigManagedRules = {
  owasp?: PutFirewallConfigOwasp | undefined;
  verifiedBotsBypass?: PutFirewallConfigVerifiedBotsBypass | undefined;
};

export type Active = {
  ownerId: string;
  projectKey: string;
  id: string;
  version: number;
  updatedAt: string;
  firewallEnabled: boolean;
  crs: PutFirewallConfigCrs;
  rules: Array<PutFirewallConfigRules>;
  ips: Array<PutFirewallConfigIps>;
  changes: Array<PutFirewallConfigChanges>;
  managedRules?: PutFirewallConfigManagedRules | undefined;
};

export type PutFirewallConfigResponseBody = {
  active: Active;
};

/** @internal */
export const Owasp$inboundSchema: z.ZodType<Owasp, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
  });

/** @internal */
export type Owasp$Outbound = {
  active: boolean;
};

/** @internal */
export const Owasp$outboundSchema: z.ZodType<
  Owasp$Outbound,
  z.ZodTypeDef,
  Owasp
> = z.object({
  active: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Owasp$ {
  /** @deprecated use `Owasp$inboundSchema` instead. */
  export const inboundSchema = Owasp$inboundSchema;
  /** @deprecated use `Owasp$outboundSchema` instead. */
  export const outboundSchema = Owasp$outboundSchema;
  /** @deprecated use `Owasp$Outbound` instead. */
  export type Outbound = Owasp$Outbound;
}

/** @internal */
export const ManagedRules$inboundSchema: z.ZodType<
  ManagedRules,
  z.ZodTypeDef,
  unknown
> = z.object({
  owasp: z.lazy(() => Owasp$inboundSchema),
});

/** @internal */
export type ManagedRules$Outbound = {
  owasp: Owasp$Outbound;
};

/** @internal */
export const ManagedRules$outboundSchema: z.ZodType<
  ManagedRules$Outbound,
  z.ZodTypeDef,
  ManagedRules
> = z.object({
  owasp: z.lazy(() => Owasp$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ManagedRules$ {
  /** @deprecated use `ManagedRules$inboundSchema` instead. */
  export const inboundSchema = ManagedRules$inboundSchema;
  /** @deprecated use `ManagedRules$outboundSchema` instead. */
  export const outboundSchema = ManagedRules$outboundSchema;
  /** @deprecated use `ManagedRules$Outbound` instead. */
  export type Outbound = ManagedRules$Outbound;
}

/** @internal */
export const Action$inboundSchema: z.ZodNativeEnum<typeof Action> = z
  .nativeEnum(Action);

/** @internal */
export const Action$outboundSchema: z.ZodNativeEnum<typeof Action> =
  Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Action$ {
  /** @deprecated use `Action$inboundSchema` instead. */
  export const inboundSchema = Action$inboundSchema;
  /** @deprecated use `Action$outboundSchema` instead. */
  export const outboundSchema = Action$outboundSchema;
}

/** @internal */
export const Sd$inboundSchema: z.ZodType<Sd, z.ZodTypeDef, unknown> = z.object({
  active: z.boolean(),
  action: Action$inboundSchema,
});

/** @internal */
export type Sd$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Sd$outboundSchema: z.ZodType<Sd$Outbound, z.ZodTypeDef, Sd> = z
  .object({
    active: z.boolean(),
    action: Action$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Sd$ {
  /** @deprecated use `Sd$inboundSchema` instead. */
  export const inboundSchema = Sd$inboundSchema;
  /** @deprecated use `Sd$outboundSchema` instead. */
  export const outboundSchema = Sd$outboundSchema;
  /** @deprecated use `Sd$Outbound` instead. */
  export type Outbound = Sd$Outbound;
}

/** @internal */
export const PutFirewallConfigAction$inboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigAction
> = z.nativeEnum(PutFirewallConfigAction);

/** @internal */
export const PutFirewallConfigAction$outboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigAction
> = PutFirewallConfigAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigAction$ {
  /** @deprecated use `PutFirewallConfigAction$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigAction$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigAction$outboundSchema;
}

/** @internal */
export const Ma$inboundSchema: z.ZodType<Ma, z.ZodTypeDef, unknown> = z.object({
  active: z.boolean(),
  action: PutFirewallConfigAction$inboundSchema,
});

/** @internal */
export type Ma$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Ma$outboundSchema: z.ZodType<Ma$Outbound, z.ZodTypeDef, Ma> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Ma$ {
  /** @deprecated use `Ma$inboundSchema` instead. */
  export const inboundSchema = Ma$inboundSchema;
  /** @deprecated use `Ma$outboundSchema` instead. */
  export const outboundSchema = Ma$outboundSchema;
  /** @deprecated use `Ma$Outbound` instead. */
  export type Outbound = Ma$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityAction$inboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigSecurityAction
> = z.nativeEnum(PutFirewallConfigSecurityAction);

/** @internal */
export const PutFirewallConfigSecurityAction$outboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigSecurityAction
> = PutFirewallConfigSecurityAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityAction$ {
  /** @deprecated use `PutFirewallConfigSecurityAction$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigSecurityAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityAction$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigSecurityAction$outboundSchema;
}

/** @internal */
export const Lfi$inboundSchema: z.ZodType<Lfi, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityAction$inboundSchema,
  });

/** @internal */
export type Lfi$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Lfi$outboundSchema: z.ZodType<Lfi$Outbound, z.ZodTypeDef, Lfi> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Lfi$ {
  /** @deprecated use `Lfi$inboundSchema` instead. */
  export const inboundSchema = Lfi$inboundSchema;
  /** @deprecated use `Lfi$outboundSchema` instead. */
  export const outboundSchema = Lfi$outboundSchema;
  /** @deprecated use `Lfi$Outbound` instead. */
  export type Outbound = Lfi$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestAction$inboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestAction> = z.nativeEnum(
    PutFirewallConfigSecurityRequestAction,
  );

/** @internal */
export const PutFirewallConfigSecurityRequestAction$outboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestAction> =
    PutFirewallConfigSecurityRequestAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestAction$outboundSchema;
}

/** @internal */
export const Rfi$inboundSchema: z.ZodType<Rfi, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityRequestAction$inboundSchema,
  });

/** @internal */
export type Rfi$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Rfi$outboundSchema: z.ZodType<Rfi$Outbound, z.ZodTypeDef, Rfi> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityRequestAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Rfi$ {
  /** @deprecated use `Rfi$inboundSchema` instead. */
  export const inboundSchema = Rfi$inboundSchema;
  /** @deprecated use `Rfi$outboundSchema` instead. */
  export const outboundSchema = Rfi$outboundSchema;
  /** @deprecated use `Rfi$Outbound` instead. */
  export type Outbound = Rfi$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyAction$inboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestRequestBodyAction> = z
    .nativeEnum(PutFirewallConfigSecurityRequestRequestBodyAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyAction$outboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestRequestBodyAction> =
    PutFirewallConfigSecurityRequestRequestBodyAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyAction$outboundSchema;
}

/** @internal */
export const Rce$inboundSchema: z.ZodType<Rce, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityRequestRequestBodyAction$inboundSchema,
  });

/** @internal */
export type Rce$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Rce$outboundSchema: z.ZodType<Rce$Outbound, z.ZodTypeDef, Rce> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityRequestRequestBodyAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Rce$ {
  /** @deprecated use `Rce$inboundSchema` instead. */
  export const inboundSchema = Rce$inboundSchema;
  /** @deprecated use `Rce$outboundSchema` instead. */
  export const outboundSchema = Rce$outboundSchema;
  /** @deprecated use `Rce$Outbound` instead. */
  export type Outbound = Rce$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsAction$inboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestRequestBodyCrsAction> =
    z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyCrsAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsAction$outboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestRequestBodyCrsAction> =
    PutFirewallConfigSecurityRequestRequestBodyCrsAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyCrsAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsAction$outboundSchema;
}

/** @internal */
export const Php$inboundSchema: z.ZodType<Php, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityRequestRequestBodyCrsAction$inboundSchema,
  });

/** @internal */
export type Php$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Php$outboundSchema: z.ZodType<Php$Outbound, z.ZodTypeDef, Php> = z
  .object({
    active: z.boolean(),
    action: PutFirewallConfigSecurityRequestRequestBodyCrsAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Php$ {
  /** @deprecated use `Php$inboundSchema` instead. */
  export const inboundSchema = Php$inboundSchema;
  /** @deprecated use `Php$outboundSchema` instead. */
  export const outboundSchema = Php$outboundSchema;
  /** @deprecated use `Php$Outbound` instead. */
  export type Outbound = Php$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsGenAction
  > = z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyCrsGenAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsGenAction
  > = PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$outboundSchema;
}

/** @internal */
export const Gen$inboundSchema: z.ZodType<Gen, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$inboundSchema,
  });

/** @internal */
export type Gen$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Gen$outboundSchema: z.ZodType<Gen$Outbound, z.ZodTypeDef, Gen> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsGenAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Gen$ {
  /** @deprecated use `Gen$inboundSchema` instead. */
  export const inboundSchema = Gen$inboundSchema;
  /** @deprecated use `Gen$outboundSchema` instead. */
  export const outboundSchema = Gen$outboundSchema;
  /** @deprecated use `Gen$Outbound` instead. */
  export type Outbound = Gen$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsXssAction
  > = z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyCrsXssAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsXssAction
  > = PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$outboundSchema;
}

/** @internal */
export const Xss$inboundSchema: z.ZodType<Xss, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$inboundSchema,
  });

/** @internal */
export type Xss$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Xss$outboundSchema: z.ZodType<Xss$Outbound, z.ZodTypeDef, Xss> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsXssAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Xss$ {
  /** @deprecated use `Xss$inboundSchema` instead. */
  export const inboundSchema = Xss$inboundSchema;
  /** @deprecated use `Xss$outboundSchema` instead. */
  export const outboundSchema = Xss$outboundSchema;
  /** @deprecated use `Xss$Outbound` instead. */
  export type Outbound = Xss$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction
  > = z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction
  > = PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$outboundSchema;
}

/** @internal */
export const Sqli$inboundSchema: z.ZodType<Sqli, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$inboundSchema,
  });

/** @internal */
export type Sqli$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Sqli$outboundSchema: z.ZodType<Sqli$Outbound, z.ZodTypeDef, Sqli> =
  z.object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsSqliAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Sqli$ {
  /** @deprecated use `Sqli$inboundSchema` instead. */
  export const inboundSchema = Sqli$inboundSchema;
  /** @deprecated use `Sqli$outboundSchema` instead. */
  export const outboundSchema = Sqli$outboundSchema;
  /** @deprecated use `Sqli$Outbound` instead. */
  export type Outbound = Sqli$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsSfAction
  > = z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyCrsSfAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsSfAction
  > = PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$outboundSchema;
}

/** @internal */
export const Sf$inboundSchema: z.ZodType<Sf, z.ZodTypeDef, unknown> = z.object({
  active: z.boolean(),
  action: PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$inboundSchema,
});

/** @internal */
export type Sf$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Sf$outboundSchema: z.ZodType<Sf$Outbound, z.ZodTypeDef, Sf> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsSfAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Sf$ {
  /** @deprecated use `Sf$inboundSchema` instead. */
  export const inboundSchema = Sf$inboundSchema;
  /** @deprecated use `Sf$outboundSchema` instead. */
  export const outboundSchema = Sf$outboundSchema;
  /** @deprecated use `Sf$Outbound` instead. */
  export type Outbound = Sf$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction
  > = z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction
  > = PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$outboundSchema;
}

/** @internal */
export const Java$inboundSchema: z.ZodType<Java, z.ZodTypeDef, unknown> = z
  .object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$inboundSchema,
  });

/** @internal */
export type Java$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const Java$outboundSchema: z.ZodType<Java$Outbound, z.ZodTypeDef, Java> =
  z.object({
    active: z.boolean(),
    action:
      PutFirewallConfigSecurityRequestRequestBodyCrsJavaAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Java$ {
  /** @deprecated use `Java$inboundSchema` instead. */
  export const inboundSchema = Java$inboundSchema;
  /** @deprecated use `Java$outboundSchema` instead. */
  export const outboundSchema = Java$outboundSchema;
  /** @deprecated use `Java$Outbound` instead. */
  export type Outbound = Java$Outbound;
}

/** @internal */
export const Crs$inboundSchema: z.ZodType<Crs, z.ZodTypeDef, unknown> = z
  .object({
    sd: z.lazy(() => Sd$inboundSchema).optional(),
    ma: z.lazy(() => Ma$inboundSchema).optional(),
    lfi: z.lazy(() => Lfi$inboundSchema).optional(),
    rfi: z.lazy(() => Rfi$inboundSchema).optional(),
    rce: z.lazy(() => Rce$inboundSchema).optional(),
    php: z.lazy(() => Php$inboundSchema).optional(),
    gen: z.lazy(() => Gen$inboundSchema).optional(),
    xss: z.lazy(() => Xss$inboundSchema).optional(),
    sqli: z.lazy(() => Sqli$inboundSchema).optional(),
    sf: z.lazy(() => Sf$inboundSchema).optional(),
    java: z.lazy(() => Java$inboundSchema).optional(),
  });

/** @internal */
export type Crs$Outbound = {
  sd?: Sd$Outbound | undefined;
  ma?: Ma$Outbound | undefined;
  lfi?: Lfi$Outbound | undefined;
  rfi?: Rfi$Outbound | undefined;
  rce?: Rce$Outbound | undefined;
  php?: Php$Outbound | undefined;
  gen?: Gen$Outbound | undefined;
  xss?: Xss$Outbound | undefined;
  sqli?: Sqli$Outbound | undefined;
  sf?: Sf$Outbound | undefined;
  java?: Java$Outbound | undefined;
};

/** @internal */
export const Crs$outboundSchema: z.ZodType<Crs$Outbound, z.ZodTypeDef, Crs> = z
  .object({
    sd: z.lazy(() => Sd$outboundSchema).optional(),
    ma: z.lazy(() => Ma$outboundSchema).optional(),
    lfi: z.lazy(() => Lfi$outboundSchema).optional(),
    rfi: z.lazy(() => Rfi$outboundSchema).optional(),
    rce: z.lazy(() => Rce$outboundSchema).optional(),
    php: z.lazy(() => Php$outboundSchema).optional(),
    gen: z.lazy(() => Gen$outboundSchema).optional(),
    xss: z.lazy(() => Xss$outboundSchema).optional(),
    sqli: z.lazy(() => Sqli$outboundSchema).optional(),
    sf: z.lazy(() => Sf$outboundSchema).optional(),
    java: z.lazy(() => Java$outboundSchema).optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Crs$ {
  /** @deprecated use `Crs$inboundSchema` instead. */
  export const inboundSchema = Crs$inboundSchema;
  /** @deprecated use `Crs$outboundSchema` instead. */
  export const outboundSchema = Crs$outboundSchema;
  /** @deprecated use `Crs$Outbound` instead. */
  export type Outbound = Crs$Outbound;
}

/** @internal */
export const PutFirewallConfigType$inboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigType
> = z.nativeEnum(PutFirewallConfigType);

/** @internal */
export const PutFirewallConfigType$outboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigType
> = PutFirewallConfigType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigType$ {
  /** @deprecated use `PutFirewallConfigType$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigType$inboundSchema;
  /** @deprecated use `PutFirewallConfigType$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigType$outboundSchema;
}

/** @internal */
export const Op$inboundSchema: z.ZodNativeEnum<typeof Op> = z.nativeEnum(Op);

/** @internal */
export const Op$outboundSchema: z.ZodNativeEnum<typeof Op> = Op$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Op$ {
  /** @deprecated use `Op$inboundSchema` instead. */
  export const inboundSchema = Op$inboundSchema;
  /** @deprecated use `Op$outboundSchema` instead. */
  export const outboundSchema = Op$outboundSchema;
}

/** @internal */
export const PutFirewallConfigValue$inboundSchema: z.ZodType<
  PutFirewallConfigValue,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.array(z.string()), z.number()]);

/** @internal */
export type PutFirewallConfigValue$Outbound = string | Array<string> | number;

/** @internal */
export const PutFirewallConfigValue$outboundSchema: z.ZodType<
  PutFirewallConfigValue$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigValue
> = z.union([z.string(), z.array(z.string()), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigValue$ {
  /** @deprecated use `PutFirewallConfigValue$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigValue$inboundSchema;
  /** @deprecated use `PutFirewallConfigValue$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigValue$outboundSchema;
  /** @deprecated use `PutFirewallConfigValue$Outbound` instead. */
  export type Outbound = PutFirewallConfigValue$Outbound;
}

/** @internal */
export const Conditions$inboundSchema: z.ZodType<
  Conditions,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: PutFirewallConfigType$inboundSchema,
  op: Op$inboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.array(z.string()), z.number()]).optional(),
});

/** @internal */
export type Conditions$Outbound = {
  type: string;
  op: string;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | Array<string> | number | undefined;
};

/** @internal */
export const Conditions$outboundSchema: z.ZodType<
  Conditions$Outbound,
  z.ZodTypeDef,
  Conditions
> = z.object({
  type: PutFirewallConfigType$outboundSchema,
  op: Op$outboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.array(z.string()), z.number()]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Conditions$ {
  /** @deprecated use `Conditions$inboundSchema` instead. */
  export const inboundSchema = Conditions$inboundSchema;
  /** @deprecated use `Conditions$outboundSchema` instead. */
  export const outboundSchema = Conditions$outboundSchema;
  /** @deprecated use `Conditions$Outbound` instead. */
  export type Outbound = Conditions$Outbound;
}

/** @internal */
export const ConditionGroup$inboundSchema: z.ZodType<
  ConditionGroup,
  z.ZodTypeDef,
  unknown
> = z.object({
  conditions: z.array(z.lazy(() => Conditions$inboundSchema)),
});

/** @internal */
export type ConditionGroup$Outbound = {
  conditions: Array<Conditions$Outbound>;
};

/** @internal */
export const ConditionGroup$outboundSchema: z.ZodType<
  ConditionGroup$Outbound,
  z.ZodTypeDef,
  ConditionGroup
> = z.object({
  conditions: z.array(z.lazy(() => Conditions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConditionGroup$ {
  /** @deprecated use `ConditionGroup$inboundSchema` instead. */
  export const inboundSchema = ConditionGroup$inboundSchema;
  /** @deprecated use `ConditionGroup$outboundSchema` instead. */
  export const outboundSchema = ConditionGroup$outboundSchema;
  /** @deprecated use `ConditionGroup$Outbound` instead. */
  export type Outbound = ConditionGroup$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyRulesActionAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityRequestRequestBodyRulesActionAction,
  );

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityRequestRequestBodyRulesActionAction
  > =
    PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$outboundSchema;
}

/** @internal */
export const Algo$inboundSchema: z.ZodNativeEnum<typeof Algo> = z.nativeEnum(
  Algo,
);

/** @internal */
export const Algo$outboundSchema: z.ZodNativeEnum<typeof Algo> =
  Algo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Algo$ {
  /** @deprecated use `Algo$inboundSchema` instead. */
  export const inboundSchema = Algo$inboundSchema;
  /** @deprecated use `Algo$outboundSchema` instead. */
  export const outboundSchema = Algo$outboundSchema;
}

/** @internal */
export const Action1$inboundSchema: z.ZodNativeEnum<typeof Action1> = z
  .nativeEnum(Action1);

/** @internal */
export const Action1$outboundSchema: z.ZodNativeEnum<typeof Action1> =
  Action1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Action1$ {
  /** @deprecated use `Action1$inboundSchema` instead. */
  export const inboundSchema = Action1$inboundSchema;
  /** @deprecated use `Action1$outboundSchema` instead. */
  export const outboundSchema = Action1$outboundSchema;
}

/** @internal */
export const RateLimitAction$inboundSchema: z.ZodType<
  RateLimitAction,
  z.ZodTypeDef,
  unknown
> = z.union([Action1$inboundSchema, z.any()]);

/** @internal */
export type RateLimitAction$Outbound = string | any;

/** @internal */
export const RateLimitAction$outboundSchema: z.ZodType<
  RateLimitAction$Outbound,
  z.ZodTypeDef,
  RateLimitAction
> = z.union([Action1$outboundSchema, z.any()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RateLimitAction$ {
  /** @deprecated use `RateLimitAction$inboundSchema` instead. */
  export const inboundSchema = RateLimitAction$inboundSchema;
  /** @deprecated use `RateLimitAction$outboundSchema` instead. */
  export const outboundSchema = RateLimitAction$outboundSchema;
  /** @deprecated use `RateLimitAction$Outbound` instead. */
  export type Outbound = RateLimitAction$Outbound;
}

/** @internal */
export const RateLimit1$inboundSchema: z.ZodType<
  RateLimit1,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: Algo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(z.union([Action1$inboundSchema, z.any()])).optional(),
});

/** @internal */
export type RateLimit1$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: string | any | null | undefined;
};

/** @internal */
export const RateLimit1$outboundSchema: z.ZodType<
  RateLimit1$Outbound,
  z.ZodTypeDef,
  RateLimit1
> = z.object({
  algo: Algo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(z.union([Action1$outboundSchema, z.any()])).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RateLimit1$ {
  /** @deprecated use `RateLimit1$inboundSchema` instead. */
  export const inboundSchema = RateLimit1$inboundSchema;
  /** @deprecated use `RateLimit1$outboundSchema` instead. */
  export const outboundSchema = RateLimit1$outboundSchema;
  /** @deprecated use `RateLimit1$Outbound` instead. */
  export type Outbound = RateLimit1$Outbound;
}

/** @internal */
export const RateLimit$inboundSchema: z.ZodType<
  RateLimit,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => RateLimit1$inboundSchema), z.any()]);

/** @internal */
export type RateLimit$Outbound = RateLimit1$Outbound | any;

/** @internal */
export const RateLimit$outboundSchema: z.ZodType<
  RateLimit$Outbound,
  z.ZodTypeDef,
  RateLimit
> = z.union([z.lazy(() => RateLimit1$outboundSchema), z.any()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RateLimit$ {
  /** @deprecated use `RateLimit$inboundSchema` instead. */
  export const inboundSchema = RateLimit$inboundSchema;
  /** @deprecated use `RateLimit$outboundSchema` instead. */
  export const outboundSchema = RateLimit$outboundSchema;
  /** @deprecated use `RateLimit$Outbound` instead. */
  export type Outbound = RateLimit$Outbound;
}

/** @internal */
export const Redirect1$inboundSchema: z.ZodType<
  Redirect1,
  z.ZodTypeDef,
  unknown
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/** @internal */
export type Redirect1$Outbound = {
  location: string;
  permanent: boolean;
};

/** @internal */
export const Redirect1$outboundSchema: z.ZodType<
  Redirect1$Outbound,
  z.ZodTypeDef,
  Redirect1
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Redirect1$ {
  /** @deprecated use `Redirect1$inboundSchema` instead. */
  export const inboundSchema = Redirect1$inboundSchema;
  /** @deprecated use `Redirect1$outboundSchema` instead. */
  export const outboundSchema = Redirect1$outboundSchema;
  /** @deprecated use `Redirect1$Outbound` instead. */
  export type Outbound = Redirect1$Outbound;
}

/** @internal */
export const Redirect$inboundSchema: z.ZodType<
  Redirect,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => Redirect1$inboundSchema), z.any()]);

/** @internal */
export type Redirect$Outbound = Redirect1$Outbound | any;

/** @internal */
export const Redirect$outboundSchema: z.ZodType<
  Redirect$Outbound,
  z.ZodTypeDef,
  Redirect
> = z.union([z.lazy(() => Redirect1$outboundSchema), z.any()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Redirect$ {
  /** @deprecated use `Redirect$inboundSchema` instead. */
  export const inboundSchema = Redirect$inboundSchema;
  /** @deprecated use `Redirect$outboundSchema` instead. */
  export const outboundSchema = Redirect$outboundSchema;
  /** @deprecated use `Redirect$Outbound` instead. */
  export type Outbound = Redirect$Outbound;
}

/** @internal */
export const Mitigate$inboundSchema: z.ZodType<
  Mitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action:
    PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$inboundSchema,
  rateLimit: z.nullable(
    z.union([z.lazy(() => RateLimit1$inboundSchema), z.any()]),
  ).optional(),
  redirect: z.nullable(
    z.union([z.lazy(() => Redirect1$inboundSchema), z.any()]),
  ).optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/** @internal */
export type Mitigate$Outbound = {
  action: string;
  rateLimit?: RateLimit1$Outbound | any | null | undefined;
  redirect?: Redirect1$Outbound | any | null | undefined;
  actionDuration?: string | null | undefined;
};

/** @internal */
export const Mitigate$outboundSchema: z.ZodType<
  Mitigate$Outbound,
  z.ZodTypeDef,
  Mitigate
> = z.object({
  action:
    PutFirewallConfigSecurityRequestRequestBodyRulesActionAction$outboundSchema,
  rateLimit: z.nullable(
    z.union([z.lazy(() => RateLimit1$outboundSchema), z.any()]),
  ).optional(),
  redirect: z.nullable(
    z.union([z.lazy(() => Redirect1$outboundSchema), z.any()]),
  ).optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Mitigate$ {
  /** @deprecated use `Mitigate$inboundSchema` instead. */
  export const inboundSchema = Mitigate$inboundSchema;
  /** @deprecated use `Mitigate$outboundSchema` instead. */
  export const outboundSchema = Mitigate$outboundSchema;
  /** @deprecated use `Mitigate$Outbound` instead. */
  export type Outbound = Mitigate$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyRulesAction$inboundSchema:
  z.ZodType<
    PutFirewallConfigSecurityRequestRequestBodyRulesAction,
    z.ZodTypeDef,
    unknown
  > = z.object({
    mitigate: z.lazy(() => Mitigate$inboundSchema).optional(),
  });

/** @internal */
export type PutFirewallConfigSecurityRequestRequestBodyRulesAction$Outbound = {
  mitigate?: Mitigate$Outbound | undefined;
};

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyRulesAction$outboundSchema:
  z.ZodType<
    PutFirewallConfigSecurityRequestRequestBodyRulesAction$Outbound,
    z.ZodTypeDef,
    PutFirewallConfigSecurityRequestRequestBodyRulesAction
  > = z.object({
    mitigate: z.lazy(() => Mitigate$outboundSchema).optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyRulesAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyRulesAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyRulesAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyRulesAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyRulesAction$outboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyRulesAction$Outbound` instead. */
  export type Outbound =
    PutFirewallConfigSecurityRequestRequestBodyRulesAction$Outbound;
}

/** @internal */
export const Rules$inboundSchema: z.ZodType<Rules, z.ZodTypeDef, unknown> = z
  .object({
    id: z.string().optional(),
    name: z.string(),
    description: z.string().optional(),
    active: z.boolean(),
    conditionGroup: z.array(z.lazy(() => ConditionGroup$inboundSchema)),
    action: z.lazy(() =>
      PutFirewallConfigSecurityRequestRequestBodyRulesAction$inboundSchema
    ),
  });

/** @internal */
export type Rules$Outbound = {
  id?: string | undefined;
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<ConditionGroup$Outbound>;
  action: PutFirewallConfigSecurityRequestRequestBodyRulesAction$Outbound;
};

/** @internal */
export const Rules$outboundSchema: z.ZodType<
  Rules$Outbound,
  z.ZodTypeDef,
  Rules
> = z.object({
  id: z.string().optional(),
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(z.lazy(() => ConditionGroup$outboundSchema)),
  action: z.lazy(() =>
    PutFirewallConfigSecurityRequestRequestBodyRulesAction$outboundSchema
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Rules$ {
  /** @deprecated use `Rules$inboundSchema` instead. */
  export const inboundSchema = Rules$inboundSchema;
  /** @deprecated use `Rules$outboundSchema` instead. */
  export const outboundSchema = Rules$outboundSchema;
  /** @deprecated use `Rules$Outbound` instead. */
  export type Outbound = Rules$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyIpsAction$inboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestRequestBodyIpsAction> =
    z.nativeEnum(PutFirewallConfigSecurityRequestRequestBodyIpsAction);

/** @internal */
export const PutFirewallConfigSecurityRequestRequestBodyIpsAction$outboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityRequestRequestBodyIpsAction> =
    PutFirewallConfigSecurityRequestRequestBodyIpsAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityRequestRequestBodyIpsAction$ {
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyIpsAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyIpsAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityRequestRequestBodyIpsAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityRequestRequestBodyIpsAction$outboundSchema;
}

/** @internal */
export const Ips$inboundSchema: z.ZodType<Ips, z.ZodTypeDef, unknown> = z
  .object({
    id: z.string().optional(),
    hostname: z.string(),
    ip: z.string(),
    notes: z.string().optional(),
    action: PutFirewallConfigSecurityRequestRequestBodyIpsAction$inboundSchema,
  });

/** @internal */
export type Ips$Outbound = {
  id?: string | undefined;
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: string;
};

/** @internal */
export const Ips$outboundSchema: z.ZodType<Ips$Outbound, z.ZodTypeDef, Ips> = z
  .object({
    id: z.string().optional(),
    hostname: z.string(),
    ip: z.string(),
    notes: z.string().optional(),
    action: PutFirewallConfigSecurityRequestRequestBodyIpsAction$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Ips$ {
  /** @deprecated use `Ips$inboundSchema` instead. */
  export const inboundSchema = Ips$inboundSchema;
  /** @deprecated use `Ips$outboundSchema` instead. */
  export const outboundSchema = Ips$outboundSchema;
  /** @deprecated use `Ips$Outbound` instead. */
  export type Outbound = Ips$Outbound;
}

/** @internal */
export const PutFirewallConfigRequestBody$inboundSchema: z.ZodType<
  PutFirewallConfigRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  firewallEnabled: z.boolean(),
  managedRules: z.lazy(() => ManagedRules$inboundSchema).optional(),
  crs: z.lazy(() => Crs$inboundSchema).optional(),
  rules: z.array(z.lazy(() => Rules$inboundSchema)).optional(),
  ips: z.array(z.lazy(() => Ips$inboundSchema)).optional(),
});

/** @internal */
export type PutFirewallConfigRequestBody$Outbound = {
  firewallEnabled: boolean;
  managedRules?: ManagedRules$Outbound | undefined;
  crs?: Crs$Outbound | undefined;
  rules?: Array<Rules$Outbound> | undefined;
  ips?: Array<Ips$Outbound> | undefined;
};

/** @internal */
export const PutFirewallConfigRequestBody$outboundSchema: z.ZodType<
  PutFirewallConfigRequestBody$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRequestBody
> = z.object({
  firewallEnabled: z.boolean(),
  managedRules: z.lazy(() => ManagedRules$outboundSchema).optional(),
  crs: z.lazy(() => Crs$outboundSchema).optional(),
  rules: z.array(z.lazy(() => Rules$outboundSchema)).optional(),
  ips: z.array(z.lazy(() => Ips$outboundSchema)).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRequestBody$ {
  /** @deprecated use `PutFirewallConfigRequestBody$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRequestBody$inboundSchema;
  /** @deprecated use `PutFirewallConfigRequestBody$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRequestBody$outboundSchema;
  /** @deprecated use `PutFirewallConfigRequestBody$Outbound` instead. */
  export type Outbound = PutFirewallConfigRequestBody$Outbound;
}

/** @internal */
export const PutFirewallConfigRequest$inboundSchema: z.ZodType<
  PutFirewallConfigRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => PutFirewallConfigRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type PutFirewallConfigRequest$Outbound = {
  projectId: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: PutFirewallConfigRequestBody$Outbound | undefined;
};

/** @internal */
export const PutFirewallConfigRequest$outboundSchema: z.ZodType<
  PutFirewallConfigRequest$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRequest
> = z.object({
  projectId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => PutFirewallConfigRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRequest$ {
  /** @deprecated use `PutFirewallConfigRequest$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRequest$inboundSchema;
  /** @deprecated use `PutFirewallConfigRequest$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRequest$outboundSchema;
  /** @deprecated use `PutFirewallConfigRequest$Outbound` instead. */
  export type Outbound = PutFirewallConfigRequest$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigSd$inboundSchema: z.ZodType<
  PutFirewallConfigSd,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigSd$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigSd$outboundSchema: z.ZodType<
  PutFirewallConfigSd$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigSd
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSdAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSd$ {
  /** @deprecated use `PutFirewallConfigSd$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigSd$inboundSchema;
  /** @deprecated use `PutFirewallConfigSd$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigSd$outboundSchema;
  /** @deprecated use `PutFirewallConfigSd$Outbound` instead. */
  export type Outbound = PutFirewallConfigSd$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigMa$inboundSchema: z.ZodType<
  PutFirewallConfigMa,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigMa$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigMa$outboundSchema: z.ZodType<
  PutFirewallConfigMa$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigMa
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsMaAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigMa$ {
  /** @deprecated use `PutFirewallConfigMa$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigMa$inboundSchema;
  /** @deprecated use `PutFirewallConfigMa$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigMa$outboundSchema;
  /** @deprecated use `PutFirewallConfigMa$Outbound` instead. */
  export type Outbound = PutFirewallConfigMa$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONAction
  > = z.nativeEnum(PutFirewallConfigSecurityResponse200ApplicationJSONAction);

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONAction
  > = PutFirewallConfigSecurityResponse200ApplicationJSONAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigLfi$inboundSchema: z.ZodType<
  PutFirewallConfigLfi,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigLfi$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigLfi$outboundSchema: z.ZodType<
  PutFirewallConfigLfi$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigLfi
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigLfi$ {
  /** @deprecated use `PutFirewallConfigLfi$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigLfi$inboundSchema;
  /** @deprecated use `PutFirewallConfigLfi$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigLfi$outboundSchema;
  /** @deprecated use `PutFirewallConfigLfi$Outbound` instead. */
  export type Outbound = PutFirewallConfigLfi$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigRfi$inboundSchema: z.ZodType<
  PutFirewallConfigRfi,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigRfi$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigRfi$outboundSchema: z.ZodType<
  PutFirewallConfigRfi$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRfi
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRfi$ {
  /** @deprecated use `PutFirewallConfigRfi$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRfi$inboundSchema;
  /** @deprecated use `PutFirewallConfigRfi$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRfi$outboundSchema;
  /** @deprecated use `PutFirewallConfigRfi$Outbound` instead. */
  export type Outbound = PutFirewallConfigRfi$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigRce$inboundSchema: z.ZodType<
  PutFirewallConfigRce,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigRce$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigRce$outboundSchema: z.ZodType<
  PutFirewallConfigRce$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRce
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRce$ {
  /** @deprecated use `PutFirewallConfigRce$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRce$inboundSchema;
  /** @deprecated use `PutFirewallConfigRce$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRce$outboundSchema;
  /** @deprecated use `PutFirewallConfigRce$Outbound` instead. */
  export type Outbound = PutFirewallConfigRce$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigPhp$inboundSchema: z.ZodType<
  PutFirewallConfigPhp,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigPhp$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigPhp$outboundSchema: z.ZodType<
  PutFirewallConfigPhp$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigPhp
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigPhp$ {
  /** @deprecated use `PutFirewallConfigPhp$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigPhp$inboundSchema;
  /** @deprecated use `PutFirewallConfigPhp$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigPhp$outboundSchema;
  /** @deprecated use `PutFirewallConfigPhp$Outbound` instead. */
  export type Outbound = PutFirewallConfigPhp$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigGen$inboundSchema: z.ZodType<
  PutFirewallConfigGen,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigGen$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigGen$outboundSchema: z.ZodType<
  PutFirewallConfigGen$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigGen
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsGenAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigGen$ {
  /** @deprecated use `PutFirewallConfigGen$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigGen$inboundSchema;
  /** @deprecated use `PutFirewallConfigGen$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigGen$outboundSchema;
  /** @deprecated use `PutFirewallConfigGen$Outbound` instead. */
  export type Outbound = PutFirewallConfigGen$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigXss$inboundSchema: z.ZodType<
  PutFirewallConfigXss,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigXss$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigXss$outboundSchema: z.ZodType<
  PutFirewallConfigXss$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigXss
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsXssAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigXss$ {
  /** @deprecated use `PutFirewallConfigXss$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigXss$inboundSchema;
  /** @deprecated use `PutFirewallConfigXss$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigXss$outboundSchema;
  /** @deprecated use `PutFirewallConfigXss$Outbound` instead. */
  export type Outbound = PutFirewallConfigXss$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigSqli$inboundSchema: z.ZodType<
  PutFirewallConfigSqli,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigSqli$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigSqli$outboundSchema: z.ZodType<
  PutFirewallConfigSqli$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigSqli
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSqliAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSqli$ {
  /** @deprecated use `PutFirewallConfigSqli$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigSqli$inboundSchema;
  /** @deprecated use `PutFirewallConfigSqli$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigSqli$outboundSchema;
  /** @deprecated use `PutFirewallConfigSqli$Outbound` instead. */
  export type Outbound = PutFirewallConfigSqli$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigSf$inboundSchema: z.ZodType<
  PutFirewallConfigSf,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigSf$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigSf$outboundSchema: z.ZodType<
  PutFirewallConfigSf$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigSf
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsSfAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSf$ {
  /** @deprecated use `PutFirewallConfigSf$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigSf$inboundSchema;
  /** @deprecated use `PutFirewallConfigSf$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigSf$outboundSchema;
  /** @deprecated use `PutFirewallConfigSf$Outbound` instead. */
  export type Outbound = PutFirewallConfigSf$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigJava$inboundSchema: z.ZodType<
  PutFirewallConfigJava,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$inboundSchema,
});

/** @internal */
export type PutFirewallConfigJava$Outbound = {
  active: boolean;
  action: string;
};

/** @internal */
export const PutFirewallConfigJava$outboundSchema: z.ZodType<
  PutFirewallConfigJava$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigJava
> = z.object({
  active: z.boolean(),
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveCrsJavaAction$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigJava$ {
  /** @deprecated use `PutFirewallConfigJava$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigJava$inboundSchema;
  /** @deprecated use `PutFirewallConfigJava$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigJava$outboundSchema;
  /** @deprecated use `PutFirewallConfigJava$Outbound` instead. */
  export type Outbound = PutFirewallConfigJava$Outbound;
}

/** @internal */
export const PutFirewallConfigCrs$inboundSchema: z.ZodType<
  PutFirewallConfigCrs,
  z.ZodTypeDef,
  unknown
> = z.object({
  sd: z.lazy(() => PutFirewallConfigSd$inboundSchema),
  ma: z.lazy(() => PutFirewallConfigMa$inboundSchema),
  lfi: z.lazy(() => PutFirewallConfigLfi$inboundSchema),
  rfi: z.lazy(() => PutFirewallConfigRfi$inboundSchema),
  rce: z.lazy(() => PutFirewallConfigRce$inboundSchema),
  php: z.lazy(() => PutFirewallConfigPhp$inboundSchema),
  gen: z.lazy(() => PutFirewallConfigGen$inboundSchema),
  xss: z.lazy(() => PutFirewallConfigXss$inboundSchema),
  sqli: z.lazy(() => PutFirewallConfigSqli$inboundSchema),
  sf: z.lazy(() => PutFirewallConfigSf$inboundSchema),
  java: z.lazy(() => PutFirewallConfigJava$inboundSchema),
});

/** @internal */
export type PutFirewallConfigCrs$Outbound = {
  sd: PutFirewallConfigSd$Outbound;
  ma: PutFirewallConfigMa$Outbound;
  lfi: PutFirewallConfigLfi$Outbound;
  rfi: PutFirewallConfigRfi$Outbound;
  rce: PutFirewallConfigRce$Outbound;
  php: PutFirewallConfigPhp$Outbound;
  gen: PutFirewallConfigGen$Outbound;
  xss: PutFirewallConfigXss$Outbound;
  sqli: PutFirewallConfigSqli$Outbound;
  sf: PutFirewallConfigSf$Outbound;
  java: PutFirewallConfigJava$Outbound;
};

/** @internal */
export const PutFirewallConfigCrs$outboundSchema: z.ZodType<
  PutFirewallConfigCrs$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigCrs
> = z.object({
  sd: z.lazy(() => PutFirewallConfigSd$outboundSchema),
  ma: z.lazy(() => PutFirewallConfigMa$outboundSchema),
  lfi: z.lazy(() => PutFirewallConfigLfi$outboundSchema),
  rfi: z.lazy(() => PutFirewallConfigRfi$outboundSchema),
  rce: z.lazy(() => PutFirewallConfigRce$outboundSchema),
  php: z.lazy(() => PutFirewallConfigPhp$outboundSchema),
  gen: z.lazy(() => PutFirewallConfigGen$outboundSchema),
  xss: z.lazy(() => PutFirewallConfigXss$outboundSchema),
  sqli: z.lazy(() => PutFirewallConfigSqli$outboundSchema),
  sf: z.lazy(() => PutFirewallConfigSf$outboundSchema),
  java: z.lazy(() => PutFirewallConfigJava$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigCrs$ {
  /** @deprecated use `PutFirewallConfigCrs$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigCrs$inboundSchema;
  /** @deprecated use `PutFirewallConfigCrs$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigCrs$outboundSchema;
  /** @deprecated use `PutFirewallConfigCrs$Outbound` instead. */
  export type Outbound = PutFirewallConfigCrs$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityType$inboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigSecurityType
> = z.nativeEnum(PutFirewallConfigSecurityType);

/** @internal */
export const PutFirewallConfigSecurityType$outboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigSecurityType
> = PutFirewallConfigSecurityType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityType$ {
  /** @deprecated use `PutFirewallConfigSecurityType$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigSecurityType$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityType$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigSecurityType$outboundSchema;
}

/** @internal */
export const PutFirewallConfigOp$inboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigOp
> = z.nativeEnum(PutFirewallConfigOp);

/** @internal */
export const PutFirewallConfigOp$outboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigOp
> = PutFirewallConfigOp$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigOp$ {
  /** @deprecated use `PutFirewallConfigOp$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigOp$inboundSchema;
  /** @deprecated use `PutFirewallConfigOp$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigOp$outboundSchema;
}

/** @internal */
export const PutFirewallConfigSecurityValue$inboundSchema: z.ZodType<
  PutFirewallConfigSecurityValue,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number(), z.array(z.string())]);

/** @internal */
export type PutFirewallConfigSecurityValue$Outbound =
  | string
  | number
  | Array<string>;

/** @internal */
export const PutFirewallConfigSecurityValue$outboundSchema: z.ZodType<
  PutFirewallConfigSecurityValue$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigSecurityValue
> = z.union([z.string(), z.number(), z.array(z.string())]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityValue$ {
  /** @deprecated use `PutFirewallConfigSecurityValue$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigSecurityValue$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityValue$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigSecurityValue$outboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityValue$Outbound` instead. */
  export type Outbound = PutFirewallConfigSecurityValue$Outbound;
}

/** @internal */
export const PutFirewallConfigConditions$inboundSchema: z.ZodType<
  PutFirewallConfigConditions,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: PutFirewallConfigSecurityType$inboundSchema,
  op: PutFirewallConfigOp$inboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.number(), z.array(z.string())]).optional(),
});

/** @internal */
export type PutFirewallConfigConditions$Outbound = {
  type: string;
  op: string;
  neg?: boolean | undefined;
  key?: string | undefined;
  value?: string | number | Array<string> | undefined;
};

/** @internal */
export const PutFirewallConfigConditions$outboundSchema: z.ZodType<
  PutFirewallConfigConditions$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigConditions
> = z.object({
  type: PutFirewallConfigSecurityType$outboundSchema,
  op: PutFirewallConfigOp$outboundSchema,
  neg: z.boolean().optional(),
  key: z.string().optional(),
  value: z.union([z.string(), z.number(), z.array(z.string())]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigConditions$ {
  /** @deprecated use `PutFirewallConfigConditions$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigConditions$inboundSchema;
  /** @deprecated use `PutFirewallConfigConditions$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigConditions$outboundSchema;
  /** @deprecated use `PutFirewallConfigConditions$Outbound` instead. */
  export type Outbound = PutFirewallConfigConditions$Outbound;
}

/** @internal */
export const PutFirewallConfigConditionGroup$inboundSchema: z.ZodType<
  PutFirewallConfigConditionGroup,
  z.ZodTypeDef,
  unknown
> = z.object({
  conditions: z.array(z.lazy(() => PutFirewallConfigConditions$inboundSchema)),
});

/** @internal */
export type PutFirewallConfigConditionGroup$Outbound = {
  conditions: Array<PutFirewallConfigConditions$Outbound>;
};

/** @internal */
export const PutFirewallConfigConditionGroup$outboundSchema: z.ZodType<
  PutFirewallConfigConditionGroup$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigConditionGroup
> = z.object({
  conditions: z.array(z.lazy(() => PutFirewallConfigConditions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigConditionGroup$ {
  /** @deprecated use `PutFirewallConfigConditionGroup$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigConditionGroup$inboundSchema;
  /** @deprecated use `PutFirewallConfigConditionGroup$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigConditionGroup$outboundSchema;
  /** @deprecated use `PutFirewallConfigConditionGroup$Outbound` instead. */
  export type Outbound = PutFirewallConfigConditionGroup$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigAlgo$inboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigAlgo
> = z.nativeEnum(PutFirewallConfigAlgo);

/** @internal */
export const PutFirewallConfigAlgo$outboundSchema: z.ZodNativeEnum<
  typeof PutFirewallConfigAlgo
> = PutFirewallConfigAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigAlgo$ {
  /** @deprecated use `PutFirewallConfigAlgo$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigAlgo$inboundSchema;
  /** @deprecated use `PutFirewallConfigAlgo$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigAlgo$outboundSchema;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$inboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction
  > = z.nativeEnum(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction,
  );

/** @internal */
export const PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$outboundSchema:
  z.ZodNativeEnum<
    typeof PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction
  > =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$outboundSchema;
}

/** @internal */
export const PutFirewallConfigRateLimit$inboundSchema: z.ZodType<
  PutFirewallConfigRateLimit,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: PutFirewallConfigAlgo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$inboundSchema,
  ).optional(),
});

/** @internal */
export type PutFirewallConfigRateLimit$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
  action?: string | null | undefined;
};

/** @internal */
export const PutFirewallConfigRateLimit$outboundSchema: z.ZodType<
  PutFirewallConfigRateLimit$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRateLimit
> = z.object({
  algo: PutFirewallConfigAlgo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
  action: z.nullable(
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesActionAction$outboundSchema,
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRateLimit$ {
  /** @deprecated use `PutFirewallConfigRateLimit$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRateLimit$inboundSchema;
  /** @deprecated use `PutFirewallConfigRateLimit$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRateLimit$outboundSchema;
  /** @deprecated use `PutFirewallConfigRateLimit$Outbound` instead. */
  export type Outbound = PutFirewallConfigRateLimit$Outbound;
}

/** @internal */
export const PutFirewallConfigRedirect$inboundSchema: z.ZodType<
  PutFirewallConfigRedirect,
  z.ZodTypeDef,
  unknown
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/** @internal */
export type PutFirewallConfigRedirect$Outbound = {
  location: string;
  permanent: boolean;
};

/** @internal */
export const PutFirewallConfigRedirect$outboundSchema: z.ZodType<
  PutFirewallConfigRedirect$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRedirect
> = z.object({
  location: z.string(),
  permanent: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRedirect$ {
  /** @deprecated use `PutFirewallConfigRedirect$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRedirect$inboundSchema;
  /** @deprecated use `PutFirewallConfigRedirect$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRedirect$outboundSchema;
  /** @deprecated use `PutFirewallConfigRedirect$Outbound` instead. */
  export type Outbound = PutFirewallConfigRedirect$Outbound;
}

/** @internal */
export const PutFirewallConfigMitigate$inboundSchema: z.ZodType<
  PutFirewallConfigMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$inboundSchema,
  rateLimit: z.nullable(z.lazy(() => PutFirewallConfigRateLimit$inboundSchema))
    .optional(),
  redirect: z.nullable(z.lazy(() => PutFirewallConfigRedirect$inboundSchema))
    .optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/** @internal */
export type PutFirewallConfigMitigate$Outbound = {
  action: string;
  rateLimit?: PutFirewallConfigRateLimit$Outbound | null | undefined;
  redirect?: PutFirewallConfigRedirect$Outbound | null | undefined;
  actionDuration?: string | null | undefined;
};

/** @internal */
export const PutFirewallConfigMitigate$outboundSchema: z.ZodType<
  PutFirewallConfigMitigate$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigMitigate
> = z.object({
  action:
    PutFirewallConfigSecurityResponse200ApplicationJSONResponseBodyActiveRulesAction$outboundSchema,
  rateLimit: z.nullable(z.lazy(() => PutFirewallConfigRateLimit$outboundSchema))
    .optional(),
  redirect: z.nullable(z.lazy(() => PutFirewallConfigRedirect$outboundSchema))
    .optional(),
  actionDuration: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigMitigate$ {
  /** @deprecated use `PutFirewallConfigMitigate$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigMitigate$inboundSchema;
  /** @deprecated use `PutFirewallConfigMitigate$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigMitigate$outboundSchema;
  /** @deprecated use `PutFirewallConfigMitigate$Outbound` instead. */
  export type Outbound = PutFirewallConfigMitigate$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponseAction$inboundSchema: z.ZodType<
  PutFirewallConfigSecurityResponseAction,
  z.ZodTypeDef,
  unknown
> = z.object({
  mitigate: z.lazy(() => PutFirewallConfigMitigate$inboundSchema).optional(),
});

/** @internal */
export type PutFirewallConfigSecurityResponseAction$Outbound = {
  mitigate?: PutFirewallConfigMitigate$Outbound | undefined;
};

/** @internal */
export const PutFirewallConfigSecurityResponseAction$outboundSchema: z.ZodType<
  PutFirewallConfigSecurityResponseAction$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigSecurityResponseAction
> = z.object({
  mitigate: z.lazy(() => PutFirewallConfigMitigate$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponseAction$ {
  /** @deprecated use `PutFirewallConfigSecurityResponseAction$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponseAction$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponseAction$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponseAction$outboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponseAction$Outbound` instead. */
  export type Outbound = PutFirewallConfigSecurityResponseAction$Outbound;
}

/** @internal */
export const PutFirewallConfigRules$inboundSchema: z.ZodType<
  PutFirewallConfigRules,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(
    z.lazy(() => PutFirewallConfigConditionGroup$inboundSchema),
  ),
  action: z.lazy(() => PutFirewallConfigSecurityResponseAction$inboundSchema),
});

/** @internal */
export type PutFirewallConfigRules$Outbound = {
  id: string;
  name: string;
  description?: string | undefined;
  active: boolean;
  conditionGroup: Array<PutFirewallConfigConditionGroup$Outbound>;
  action: PutFirewallConfigSecurityResponseAction$Outbound;
};

/** @internal */
export const PutFirewallConfigRules$outboundSchema: z.ZodType<
  PutFirewallConfigRules$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigRules
> = z.object({
  id: z.string(),
  name: z.string(),
  description: z.string().optional(),
  active: z.boolean(),
  conditionGroup: z.array(
    z.lazy(() => PutFirewallConfigConditionGroup$outboundSchema),
  ),
  action: z.lazy(() => PutFirewallConfigSecurityResponseAction$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigRules$ {
  /** @deprecated use `PutFirewallConfigRules$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigRules$inboundSchema;
  /** @deprecated use `PutFirewallConfigRules$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigRules$outboundSchema;
  /** @deprecated use `PutFirewallConfigRules$Outbound` instead. */
  export type Outbound = PutFirewallConfigRules$Outbound;
}

/** @internal */
export const PutFirewallConfigSecurityResponse200Action$inboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityResponse200Action> = z
    .nativeEnum(PutFirewallConfigSecurityResponse200Action);

/** @internal */
export const PutFirewallConfigSecurityResponse200Action$outboundSchema:
  z.ZodNativeEnum<typeof PutFirewallConfigSecurityResponse200Action> =
    PutFirewallConfigSecurityResponse200Action$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigSecurityResponse200Action$ {
  /** @deprecated use `PutFirewallConfigSecurityResponse200Action$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigSecurityResponse200Action$inboundSchema;
  /** @deprecated use `PutFirewallConfigSecurityResponse200Action$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigSecurityResponse200Action$outboundSchema;
}

/** @internal */
export const PutFirewallConfigIps$inboundSchema: z.ZodType<
  PutFirewallConfigIps,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  hostname: z.string(),
  ip: z.string(),
  notes: z.string().optional(),
  action: PutFirewallConfigSecurityResponse200Action$inboundSchema,
});

/** @internal */
export type PutFirewallConfigIps$Outbound = {
  id: string;
  hostname: string;
  ip: string;
  notes?: string | undefined;
  action: string;
};

/** @internal */
export const PutFirewallConfigIps$outboundSchema: z.ZodType<
  PutFirewallConfigIps$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigIps
> = z.object({
  id: z.string(),
  hostname: z.string(),
  ip: z.string(),
  notes: z.string().optional(),
  action: PutFirewallConfigSecurityResponse200Action$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigIps$ {
  /** @deprecated use `PutFirewallConfigIps$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigIps$inboundSchema;
  /** @deprecated use `PutFirewallConfigIps$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigIps$outboundSchema;
  /** @deprecated use `PutFirewallConfigIps$Outbound` instead. */
  export type Outbound = PutFirewallConfigIps$Outbound;
}

/** @internal */
export const PutFirewallConfigChanges$inboundSchema: z.ZodType<
  PutFirewallConfigChanges,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type PutFirewallConfigChanges$Outbound = {};

/** @internal */
export const PutFirewallConfigChanges$outboundSchema: z.ZodType<
  PutFirewallConfigChanges$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigChanges
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigChanges$ {
  /** @deprecated use `PutFirewallConfigChanges$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigChanges$inboundSchema;
  /** @deprecated use `PutFirewallConfigChanges$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigChanges$outboundSchema;
  /** @deprecated use `PutFirewallConfigChanges$Outbound` instead. */
  export type Outbound = PutFirewallConfigChanges$Outbound;
}

/** @internal */
export const PutFirewallConfigOwasp$inboundSchema: z.ZodType<
  PutFirewallConfigOwasp,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  updatedAt: z.string().optional(),
  userId: z.string().optional(),
  username: z.string().optional(),
});

/** @internal */
export type PutFirewallConfigOwasp$Outbound = {
  active: boolean;
  updatedAt?: string | undefined;
  userId?: string | undefined;
  username?: string | undefined;
};

/** @internal */
export const PutFirewallConfigOwasp$outboundSchema: z.ZodType<
  PutFirewallConfigOwasp$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigOwasp
> = z.object({
  active: z.boolean(),
  updatedAt: z.string().optional(),
  userId: z.string().optional(),
  username: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigOwasp$ {
  /** @deprecated use `PutFirewallConfigOwasp$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigOwasp$inboundSchema;
  /** @deprecated use `PutFirewallConfigOwasp$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigOwasp$outboundSchema;
  /** @deprecated use `PutFirewallConfigOwasp$Outbound` instead. */
  export type Outbound = PutFirewallConfigOwasp$Outbound;
}

/** @internal */
export const PutFirewallConfigVerifiedBotsBypass$inboundSchema: z.ZodType<
  PutFirewallConfigVerifiedBotsBypass,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.boolean(),
  updatedAt: z.string().optional(),
  userId: z.string().optional(),
  username: z.string().optional(),
});

/** @internal */
export type PutFirewallConfigVerifiedBotsBypass$Outbound = {
  active: boolean;
  updatedAt?: string | undefined;
  userId?: string | undefined;
  username?: string | undefined;
};

/** @internal */
export const PutFirewallConfigVerifiedBotsBypass$outboundSchema: z.ZodType<
  PutFirewallConfigVerifiedBotsBypass$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigVerifiedBotsBypass
> = z.object({
  active: z.boolean(),
  updatedAt: z.string().optional(),
  userId: z.string().optional(),
  username: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigVerifiedBotsBypass$ {
  /** @deprecated use `PutFirewallConfigVerifiedBotsBypass$inboundSchema` instead. */
  export const inboundSchema =
    PutFirewallConfigVerifiedBotsBypass$inboundSchema;
  /** @deprecated use `PutFirewallConfigVerifiedBotsBypass$outboundSchema` instead. */
  export const outboundSchema =
    PutFirewallConfigVerifiedBotsBypass$outboundSchema;
  /** @deprecated use `PutFirewallConfigVerifiedBotsBypass$Outbound` instead. */
  export type Outbound = PutFirewallConfigVerifiedBotsBypass$Outbound;
}

/** @internal */
export const PutFirewallConfigManagedRules$inboundSchema: z.ZodType<
  PutFirewallConfigManagedRules,
  z.ZodTypeDef,
  unknown
> = z.object({
  owasp: z.lazy(() => PutFirewallConfigOwasp$inboundSchema).optional(),
  verifiedBotsBypass: z.lazy(() =>
    PutFirewallConfigVerifiedBotsBypass$inboundSchema
  ).optional(),
});

/** @internal */
export type PutFirewallConfigManagedRules$Outbound = {
  owasp?: PutFirewallConfigOwasp$Outbound | undefined;
  verifiedBotsBypass?: PutFirewallConfigVerifiedBotsBypass$Outbound | undefined;
};

/** @internal */
export const PutFirewallConfigManagedRules$outboundSchema: z.ZodType<
  PutFirewallConfigManagedRules$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigManagedRules
> = z.object({
  owasp: z.lazy(() => PutFirewallConfigOwasp$outboundSchema).optional(),
  verifiedBotsBypass: z.lazy(() =>
    PutFirewallConfigVerifiedBotsBypass$outboundSchema
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigManagedRules$ {
  /** @deprecated use `PutFirewallConfigManagedRules$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigManagedRules$inboundSchema;
  /** @deprecated use `PutFirewallConfigManagedRules$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigManagedRules$outboundSchema;
  /** @deprecated use `PutFirewallConfigManagedRules$Outbound` instead. */
  export type Outbound = PutFirewallConfigManagedRules$Outbound;
}

/** @internal */
export const Active$inboundSchema: z.ZodType<Active, z.ZodTypeDef, unknown> = z
  .object({
    ownerId: z.string(),
    projectKey: z.string(),
    id: z.string(),
    version: z.number(),
    updatedAt: z.string(),
    firewallEnabled: z.boolean(),
    crs: z.lazy(() => PutFirewallConfigCrs$inboundSchema),
    rules: z.array(z.lazy(() => PutFirewallConfigRules$inboundSchema)),
    ips: z.array(z.lazy(() => PutFirewallConfigIps$inboundSchema)),
    changes: z.array(z.lazy(() => PutFirewallConfigChanges$inboundSchema)),
    managedRules: z.lazy(() => PutFirewallConfigManagedRules$inboundSchema)
      .optional(),
  });

/** @internal */
export type Active$Outbound = {
  ownerId: string;
  projectKey: string;
  id: string;
  version: number;
  updatedAt: string;
  firewallEnabled: boolean;
  crs: PutFirewallConfigCrs$Outbound;
  rules: Array<PutFirewallConfigRules$Outbound>;
  ips: Array<PutFirewallConfigIps$Outbound>;
  changes: Array<PutFirewallConfigChanges$Outbound>;
  managedRules?: PutFirewallConfigManagedRules$Outbound | undefined;
};

/** @internal */
export const Active$outboundSchema: z.ZodType<
  Active$Outbound,
  z.ZodTypeDef,
  Active
> = z.object({
  ownerId: z.string(),
  projectKey: z.string(),
  id: z.string(),
  version: z.number(),
  updatedAt: z.string(),
  firewallEnabled: z.boolean(),
  crs: z.lazy(() => PutFirewallConfigCrs$outboundSchema),
  rules: z.array(z.lazy(() => PutFirewallConfigRules$outboundSchema)),
  ips: z.array(z.lazy(() => PutFirewallConfigIps$outboundSchema)),
  changes: z.array(z.lazy(() => PutFirewallConfigChanges$outboundSchema)),
  managedRules: z.lazy(() => PutFirewallConfigManagedRules$outboundSchema)
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Active$ {
  /** @deprecated use `Active$inboundSchema` instead. */
  export const inboundSchema = Active$inboundSchema;
  /** @deprecated use `Active$outboundSchema` instead. */
  export const outboundSchema = Active$outboundSchema;
  /** @deprecated use `Active$Outbound` instead. */
  export type Outbound = Active$Outbound;
}

/** @internal */
export const PutFirewallConfigResponseBody$inboundSchema: z.ZodType<
  PutFirewallConfigResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  active: z.lazy(() => Active$inboundSchema),
});

/** @internal */
export type PutFirewallConfigResponseBody$Outbound = {
  active: Active$Outbound;
};

/** @internal */
export const PutFirewallConfigResponseBody$outboundSchema: z.ZodType<
  PutFirewallConfigResponseBody$Outbound,
  z.ZodTypeDef,
  PutFirewallConfigResponseBody
> = z.object({
  active: z.lazy(() => Active$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PutFirewallConfigResponseBody$ {
  /** @deprecated use `PutFirewallConfigResponseBody$inboundSchema` instead. */
  export const inboundSchema = PutFirewallConfigResponseBody$inboundSchema;
  /** @deprecated use `PutFirewallConfigResponseBody$outboundSchema` instead. */
  export const outboundSchema = PutFirewallConfigResponseBody$outboundSchema;
  /** @deprecated use `PutFirewallConfigResponseBody$Outbound` instead. */
  export type Outbound = PutFirewallConfigResponseBody$Outbound;
}
