/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import {
  UserEvent,
  UserEvent$inboundSchema,
  UserEvent$Outbound,
  UserEvent$outboundSchema,
} from "../components/userevent.js";

export type ListUserEventsRequest = {
  /**
   * Maximum number of items which may be returned.
   */
  limit?: number | undefined;
  /**
   * Timestamp to only include items created since then.
   */
  since?: string | undefined;
  /**
   * Timestamp to only include items created until then.
   */
  until?: string | undefined;
  /**
   * Comma-delimited list of event \"types\" to filter the results by.
   */
  types?: string | undefined;
  /**
   * When retrieving events for a Team, the `userId` parameter may be specified to filter events generated by a specific member of the Team.
   */
  userId?: string | undefined;
  /**
   * When set to `true`, the response will include the `payload` field for each event.
   */
  withPayload?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * Successful response.
 */
export type ListUserEventsResponseBody = {
  /**
   * Array of events generated by the User.
   */
  events: Array<UserEvent>;
};

/** @internal */
export const ListUserEventsRequest$inboundSchema: z.ZodType<
  ListUserEventsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  limit: z.number().optional(),
  since: z.string().optional(),
  until: z.string().optional(),
  types: z.string().optional(),
  userId: z.string().optional(),
  withPayload: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type ListUserEventsRequest$Outbound = {
  limit?: number | undefined;
  since?: string | undefined;
  until?: string | undefined;
  types?: string | undefined;
  userId?: string | undefined;
  withPayload?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const ListUserEventsRequest$outboundSchema: z.ZodType<
  ListUserEventsRequest$Outbound,
  z.ZodTypeDef,
  ListUserEventsRequest
> = z.object({
  limit: z.number().optional(),
  since: z.string().optional(),
  until: z.string().optional(),
  types: z.string().optional(),
  userId: z.string().optional(),
  withPayload: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListUserEventsRequest$ {
  /** @deprecated use `ListUserEventsRequest$inboundSchema` instead. */
  export const inboundSchema = ListUserEventsRequest$inboundSchema;
  /** @deprecated use `ListUserEventsRequest$outboundSchema` instead. */
  export const outboundSchema = ListUserEventsRequest$outboundSchema;
  /** @deprecated use `ListUserEventsRequest$Outbound` instead. */
  export type Outbound = ListUserEventsRequest$Outbound;
}

/** @internal */
export const ListUserEventsResponseBody$inboundSchema: z.ZodType<
  ListUserEventsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  events: z.array(UserEvent$inboundSchema),
});

/** @internal */
export type ListUserEventsResponseBody$Outbound = {
  events: Array<UserEvent$Outbound>;
};

/** @internal */
export const ListUserEventsResponseBody$outboundSchema: z.ZodType<
  ListUserEventsResponseBody$Outbound,
  z.ZodTypeDef,
  ListUserEventsResponseBody
> = z.object({
  events: z.array(UserEvent$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListUserEventsResponseBody$ {
  /** @deprecated use `ListUserEventsResponseBody$inboundSchema` instead. */
  export const inboundSchema = ListUserEventsResponseBody$inboundSchema;
  /** @deprecated use `ListUserEventsResponseBody$outboundSchema` instead. */
  export const outboundSchema = ListUserEventsResponseBody$outboundSchema;
  /** @deprecated use `ListUserEventsResponseBody$Outbound` instead. */
  export type Outbound = ListUserEventsResponseBody$Outbound;
}
