/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type ListDeploymentAliasesRequest = {
  /**
   * The ID of the deployment the aliases should be listed for
   */
  id: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export const ListDeploymentAliasesProtectionBypassAliasesResponse200Scope = {
  EmailInvite: "email_invite",
} as const;
export type ListDeploymentAliasesProtectionBypassAliasesResponse200Scope =
  ClosedEnum<
    typeof ListDeploymentAliasesProtectionBypassAliasesResponse200Scope
  >;

/**
 * The protection bypass for the alias
 */
export type ListDeploymentAliasesProtectionBypass4 = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  scope: ListDeploymentAliasesProtectionBypassAliasesResponse200Scope;
};

export const ListDeploymentAliasesProtectionBypassAliasesResponseScope = {
  AliasProtectionOverride: "alias-protection-override",
} as const;
export type ListDeploymentAliasesProtectionBypassAliasesResponseScope =
  ClosedEnum<typeof ListDeploymentAliasesProtectionBypassAliasesResponseScope>;

/**
 * The protection bypass for the alias
 */
export type ListDeploymentAliasesProtectionBypass3 = {
  createdAt: number;
  createdBy: string;
  scope: ListDeploymentAliasesProtectionBypassAliasesResponseScope;
};

export const ListDeploymentAliasesProtectionBypassAccess = {
  Requested: "requested",
  Granted: "granted",
} as const;
export type ListDeploymentAliasesProtectionBypassAccess = ClosedEnum<
  typeof ListDeploymentAliasesProtectionBypassAccess
>;

export const ListDeploymentAliasesProtectionBypassAliasesScope = {
  User: "user",
} as const;
export type ListDeploymentAliasesProtectionBypassAliasesScope = ClosedEnum<
  typeof ListDeploymentAliasesProtectionBypassAliasesScope
>;

/**
 * The protection bypass for the alias
 */
export type ListDeploymentAliasesProtectionBypass2 = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  access: ListDeploymentAliasesProtectionBypassAccess;
  scope: ListDeploymentAliasesProtectionBypassAliasesScope;
};

export const ListDeploymentAliasesProtectionBypassScope = {
  ShareableLink: "shareable-link",
} as const;
export type ListDeploymentAliasesProtectionBypassScope = ClosedEnum<
  typeof ListDeploymentAliasesProtectionBypassScope
>;

/**
 * The protection bypass for the alias
 */
export type ListDeploymentAliasesProtectionBypass1 = {
  createdAt: number;
  createdBy: string;
  scope: ListDeploymentAliasesProtectionBypassScope;
};

export type ListDeploymentAliasesProtectionBypass =
  | ListDeploymentAliasesProtectionBypass1
  | ListDeploymentAliasesProtectionBypass3
  | ListDeploymentAliasesProtectionBypass4
  | ListDeploymentAliasesProtectionBypass2;

/**
 * A list of the aliases assigned to the deployment
 */
export type ListDeploymentAliasesAliases = {
  /**
   * The unique identifier of the alias
   */
  uid: string;
  /**
   * The alias name, it could be a `.vercel.app` subdomain or a custom domain
   */
  alias: string;
  /**
   * The date when the alias was created
   */
  created: Date;
  /**
   * Target destination domain for redirect when the alias is a redirect
   */
  redirect?: string | null | undefined;
  /**
   * The protection bypass for the alias
   */
  protectionBypass?: {
    [k: string]:
      | ListDeploymentAliasesProtectionBypass1
      | ListDeploymentAliasesProtectionBypass3
      | ListDeploymentAliasesProtectionBypass4
      | ListDeploymentAliasesProtectionBypass2;
  } | undefined;
};

/**
 * The list of aliases assigned to the deployment
 */
export type ListDeploymentAliasesResponseBody = {
  /**
   * A list of the aliases assigned to the deployment
   */
  aliases: Array<ListDeploymentAliasesAliases>;
};

/** @internal */
export const ListDeploymentAliasesRequest$inboundSchema: z.ZodType<
  ListDeploymentAliasesRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type ListDeploymentAliasesRequest$Outbound = {
  id: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const ListDeploymentAliasesRequest$outboundSchema: z.ZodType<
  ListDeploymentAliasesRequest$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesRequest
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesRequest$ {
  /** @deprecated use `ListDeploymentAliasesRequest$inboundSchema` instead. */
  export const inboundSchema = ListDeploymentAliasesRequest$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesRequest$outboundSchema` instead. */
  export const outboundSchema = ListDeploymentAliasesRequest$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesRequest$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesRequest$Outbound;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$inboundSchema:
  z.ZodNativeEnum<
    typeof ListDeploymentAliasesProtectionBypassAliasesResponse200Scope
  > = z.nativeEnum(
    ListDeploymentAliasesProtectionBypassAliasesResponse200Scope,
  );

/** @internal */
export const ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$outboundSchema:
  z.ZodNativeEnum<
    typeof ListDeploymentAliasesProtectionBypassAliasesResponse200Scope
  > =
    ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$outboundSchema;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypass4$inboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass4,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  scope:
    ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$inboundSchema,
});

/** @internal */
export type ListDeploymentAliasesProtectionBypass4$Outbound = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  scope: string;
};

/** @internal */
export const ListDeploymentAliasesProtectionBypass4$outboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass4$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesProtectionBypass4
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  scope:
    ListDeploymentAliasesProtectionBypassAliasesResponse200Scope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypass4$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypass4$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypass4$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass4$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypass4$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass4$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesProtectionBypass4$Outbound;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypassAliasesResponseScope$inboundSchema:
  z.ZodNativeEnum<
    typeof ListDeploymentAliasesProtectionBypassAliasesResponseScope
  > = z.nativeEnum(ListDeploymentAliasesProtectionBypassAliasesResponseScope);

/** @internal */
export const ListDeploymentAliasesProtectionBypassAliasesResponseScope$outboundSchema:
  z.ZodNativeEnum<
    typeof ListDeploymentAliasesProtectionBypassAliasesResponseScope
  > = ListDeploymentAliasesProtectionBypassAliasesResponseScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypassAliasesResponseScope$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAliasesResponseScope$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypassAliasesResponseScope$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAliasesResponseScope$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypassAliasesResponseScope$outboundSchema;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypass3$inboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass3,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope:
    ListDeploymentAliasesProtectionBypassAliasesResponseScope$inboundSchema,
});

/** @internal */
export type ListDeploymentAliasesProtectionBypass3$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const ListDeploymentAliasesProtectionBypass3$outboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass3$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesProtectionBypass3
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope:
    ListDeploymentAliasesProtectionBypassAliasesResponseScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypass3$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypass3$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypass3$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass3$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypass3$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass3$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesProtectionBypass3$Outbound;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypassAccess$inboundSchema:
  z.ZodNativeEnum<typeof ListDeploymentAliasesProtectionBypassAccess> = z
    .nativeEnum(ListDeploymentAliasesProtectionBypassAccess);

/** @internal */
export const ListDeploymentAliasesProtectionBypassAccess$outboundSchema:
  z.ZodNativeEnum<typeof ListDeploymentAliasesProtectionBypassAccess> =
    ListDeploymentAliasesProtectionBypassAccess$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypassAccess$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAccess$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypassAccess$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAccess$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypassAccess$outboundSchema;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypassAliasesScope$inboundSchema:
  z.ZodNativeEnum<typeof ListDeploymentAliasesProtectionBypassAliasesScope> = z
    .nativeEnum(ListDeploymentAliasesProtectionBypassAliasesScope);

/** @internal */
export const ListDeploymentAliasesProtectionBypassAliasesScope$outboundSchema:
  z.ZodNativeEnum<typeof ListDeploymentAliasesProtectionBypassAliasesScope> =
    ListDeploymentAliasesProtectionBypassAliasesScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypassAliasesScope$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAliasesScope$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypassAliasesScope$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypassAliasesScope$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypassAliasesScope$outboundSchema;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypass2$inboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass2,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  access: ListDeploymentAliasesProtectionBypassAccess$inboundSchema,
  scope: ListDeploymentAliasesProtectionBypassAliasesScope$inboundSchema,
});

/** @internal */
export type ListDeploymentAliasesProtectionBypass2$Outbound = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  access: string;
  scope: string;
};

/** @internal */
export const ListDeploymentAliasesProtectionBypass2$outboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass2$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesProtectionBypass2
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  access: ListDeploymentAliasesProtectionBypassAccess$outboundSchema,
  scope: ListDeploymentAliasesProtectionBypassAliasesScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypass2$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypass2$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypass2$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass2$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypass2$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass2$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesProtectionBypass2$Outbound;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypassScope$inboundSchema:
  z.ZodNativeEnum<typeof ListDeploymentAliasesProtectionBypassScope> = z
    .nativeEnum(ListDeploymentAliasesProtectionBypassScope);

/** @internal */
export const ListDeploymentAliasesProtectionBypassScope$outboundSchema:
  z.ZodNativeEnum<typeof ListDeploymentAliasesProtectionBypassScope> =
    ListDeploymentAliasesProtectionBypassScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypassScope$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypassScope$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypassScope$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypassScope$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypassScope$outboundSchema;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypass1$inboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass1,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: ListDeploymentAliasesProtectionBypassScope$inboundSchema,
});

/** @internal */
export type ListDeploymentAliasesProtectionBypass1$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const ListDeploymentAliasesProtectionBypass1$outboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass1$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesProtectionBypass1
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: ListDeploymentAliasesProtectionBypassScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypass1$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypass1$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypass1$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass1$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypass1$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass1$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesProtectionBypass1$Outbound;
}

/** @internal */
export const ListDeploymentAliasesProtectionBypass$inboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => ListDeploymentAliasesProtectionBypass1$inboundSchema),
  z.lazy(() => ListDeploymentAliasesProtectionBypass3$inboundSchema),
  z.lazy(() => ListDeploymentAliasesProtectionBypass4$inboundSchema),
  z.lazy(() => ListDeploymentAliasesProtectionBypass2$inboundSchema),
]);

/** @internal */
export type ListDeploymentAliasesProtectionBypass$Outbound =
  | ListDeploymentAliasesProtectionBypass1$Outbound
  | ListDeploymentAliasesProtectionBypass3$Outbound
  | ListDeploymentAliasesProtectionBypass4$Outbound
  | ListDeploymentAliasesProtectionBypass2$Outbound;

/** @internal */
export const ListDeploymentAliasesProtectionBypass$outboundSchema: z.ZodType<
  ListDeploymentAliasesProtectionBypass$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesProtectionBypass
> = z.union([
  z.lazy(() => ListDeploymentAliasesProtectionBypass1$outboundSchema),
  z.lazy(() => ListDeploymentAliasesProtectionBypass3$outboundSchema),
  z.lazy(() => ListDeploymentAliasesProtectionBypass4$outboundSchema),
  z.lazy(() => ListDeploymentAliasesProtectionBypass2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesProtectionBypass$ {
  /** @deprecated use `ListDeploymentAliasesProtectionBypass$inboundSchema` instead. */
  export const inboundSchema =
    ListDeploymentAliasesProtectionBypass$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesProtectionBypass$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesProtectionBypass$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesProtectionBypass$Outbound;
}

/** @internal */
export const ListDeploymentAliasesAliases$inboundSchema: z.ZodType<
  ListDeploymentAliasesAliases,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  alias: z.string(),
  created: z.string().datetime({ offset: true }).transform(v => new Date(v)),
  redirect: z.nullable(z.string()).optional(),
  protectionBypass: z.record(
    z.union([
      z.lazy(() => ListDeploymentAliasesProtectionBypass1$inboundSchema),
      z.lazy(() => ListDeploymentAliasesProtectionBypass3$inboundSchema),
      z.lazy(() => ListDeploymentAliasesProtectionBypass4$inboundSchema),
      z.lazy(() => ListDeploymentAliasesProtectionBypass2$inboundSchema),
    ]),
  ).optional(),
});

/** @internal */
export type ListDeploymentAliasesAliases$Outbound = {
  uid: string;
  alias: string;
  created: string;
  redirect?: string | null | undefined;
  protectionBypass?: {
    [k: string]:
      | ListDeploymentAliasesProtectionBypass1$Outbound
      | ListDeploymentAliasesProtectionBypass3$Outbound
      | ListDeploymentAliasesProtectionBypass4$Outbound
      | ListDeploymentAliasesProtectionBypass2$Outbound;
  } | undefined;
};

/** @internal */
export const ListDeploymentAliasesAliases$outboundSchema: z.ZodType<
  ListDeploymentAliasesAliases$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesAliases
> = z.object({
  uid: z.string(),
  alias: z.string(),
  created: z.date().transform(v => v.toISOString()),
  redirect: z.nullable(z.string()).optional(),
  protectionBypass: z.record(
    z.union([
      z.lazy(() => ListDeploymentAliasesProtectionBypass1$outboundSchema),
      z.lazy(() => ListDeploymentAliasesProtectionBypass3$outboundSchema),
      z.lazy(() => ListDeploymentAliasesProtectionBypass4$outboundSchema),
      z.lazy(() => ListDeploymentAliasesProtectionBypass2$outboundSchema),
    ]),
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesAliases$ {
  /** @deprecated use `ListDeploymentAliasesAliases$inboundSchema` instead. */
  export const inboundSchema = ListDeploymentAliasesAliases$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesAliases$outboundSchema` instead. */
  export const outboundSchema = ListDeploymentAliasesAliases$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesAliases$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesAliases$Outbound;
}

/** @internal */
export const ListDeploymentAliasesResponseBody$inboundSchema: z.ZodType<
  ListDeploymentAliasesResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  aliases: z.array(z.lazy(() => ListDeploymentAliasesAliases$inboundSchema)),
});

/** @internal */
export type ListDeploymentAliasesResponseBody$Outbound = {
  aliases: Array<ListDeploymentAliasesAliases$Outbound>;
};

/** @internal */
export const ListDeploymentAliasesResponseBody$outboundSchema: z.ZodType<
  ListDeploymentAliasesResponseBody$Outbound,
  z.ZodTypeDef,
  ListDeploymentAliasesResponseBody
> = z.object({
  aliases: z.array(z.lazy(() => ListDeploymentAliasesAliases$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListDeploymentAliasesResponseBody$ {
  /** @deprecated use `ListDeploymentAliasesResponseBody$inboundSchema` instead. */
  export const inboundSchema = ListDeploymentAliasesResponseBody$inboundSchema;
  /** @deprecated use `ListDeploymentAliasesResponseBody$outboundSchema` instead. */
  export const outboundSchema =
    ListDeploymentAliasesResponseBody$outboundSchema;
  /** @deprecated use `ListDeploymentAliasesResponseBody$Outbound` instead. */
  export type Outbound = ListDeploymentAliasesResponseBody$Outbound;
}
