/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";

export type ListAccessGroupsRequest = {
  /**
   * Filter access groups by project.
   */
  projectId?: string | undefined;
  /**
   * Search for access groups by name.
   */
  search?: string | undefined;
  /**
   * Number of members to include in the response.
   */
  membersLimit?: number | undefined;
  /**
   * Number of projects to include in the response.
   */
  projectsLimit?: number | undefined;
  /**
   * Limit how many access group should be returned.
   */
  limit?: number | undefined;
  /**
   * Continuation cursor to retrieve the next page of results.
   */
  next?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export type AccessGroups = {
  members?: Array<string> | undefined;
  projects?: Array<string> | undefined;
  entitlements?: Array<string> | undefined;
  isDsyncManaged: boolean;
  /**
   * The name of this access group.
   */
  name: string;
  /**
   * Timestamp in milliseconds when the access group was created.
   */
  createdAt: string;
  /**
   * ID of the team that this access group belongs to.
   */
  teamId: string;
  /**
   * Timestamp in milliseconds when the access group was last updated.
   */
  updatedAt: string;
  /**
   * ID of the access group.
   */
  accessGroupId: string;
  /**
   * Number of members in the access group.
   */
  membersCount: number;
  /**
   * Number of projects in the access group.
   */
  projectsCount: number;
};

export type ResponseBodyPagination = {
  count: number;
  next: string | null;
};

export type ListAccessGroupsResponseBody2 = {
  accessGroups: Array<AccessGroups>;
  pagination: ResponseBodyPagination;
};

export type ListAccessGroupsResponseBody1 = {};

export type ListAccessGroupsResponseBody =
  | ListAccessGroupsResponseBody1
  | ListAccessGroupsResponseBody2;

/** @internal */
export const ListAccessGroupsRequest$inboundSchema: z.ZodType<
  ListAccessGroupsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string().optional(),
  search: z.string().optional(),
  membersLimit: z.number().int().optional(),
  projectsLimit: z.number().int().optional(),
  limit: z.number().int().optional(),
  next: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type ListAccessGroupsRequest$Outbound = {
  projectId?: string | undefined;
  search?: string | undefined;
  membersLimit?: number | undefined;
  projectsLimit?: number | undefined;
  limit?: number | undefined;
  next?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const ListAccessGroupsRequest$outboundSchema: z.ZodType<
  ListAccessGroupsRequest$Outbound,
  z.ZodTypeDef,
  ListAccessGroupsRequest
> = z.object({
  projectId: z.string().optional(),
  search: z.string().optional(),
  membersLimit: z.number().int().optional(),
  projectsLimit: z.number().int().optional(),
  limit: z.number().int().optional(),
  next: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListAccessGroupsRequest$ {
  /** @deprecated use `ListAccessGroupsRequest$inboundSchema` instead. */
  export const inboundSchema = ListAccessGroupsRequest$inboundSchema;
  /** @deprecated use `ListAccessGroupsRequest$outboundSchema` instead. */
  export const outboundSchema = ListAccessGroupsRequest$outboundSchema;
  /** @deprecated use `ListAccessGroupsRequest$Outbound` instead. */
  export type Outbound = ListAccessGroupsRequest$Outbound;
}

/** @internal */
export const AccessGroups$inboundSchema: z.ZodType<
  AccessGroups,
  z.ZodTypeDef,
  unknown
> = z.object({
  members: z.array(z.string()).optional(),
  projects: z.array(z.string()).optional(),
  entitlements: z.array(z.string()).optional(),
  isDsyncManaged: z.boolean(),
  name: z.string(),
  createdAt: z.string(),
  teamId: z.string(),
  updatedAt: z.string(),
  accessGroupId: z.string(),
  membersCount: z.number(),
  projectsCount: z.number(),
});

/** @internal */
export type AccessGroups$Outbound = {
  members?: Array<string> | undefined;
  projects?: Array<string> | undefined;
  entitlements?: Array<string> | undefined;
  isDsyncManaged: boolean;
  name: string;
  createdAt: string;
  teamId: string;
  updatedAt: string;
  accessGroupId: string;
  membersCount: number;
  projectsCount: number;
};

/** @internal */
export const AccessGroups$outboundSchema: z.ZodType<
  AccessGroups$Outbound,
  z.ZodTypeDef,
  AccessGroups
> = z.object({
  members: z.array(z.string()).optional(),
  projects: z.array(z.string()).optional(),
  entitlements: z.array(z.string()).optional(),
  isDsyncManaged: z.boolean(),
  name: z.string(),
  createdAt: z.string(),
  teamId: z.string(),
  updatedAt: z.string(),
  accessGroupId: z.string(),
  membersCount: z.number(),
  projectsCount: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AccessGroups$ {
  /** @deprecated use `AccessGroups$inboundSchema` instead. */
  export const inboundSchema = AccessGroups$inboundSchema;
  /** @deprecated use `AccessGroups$outboundSchema` instead. */
  export const outboundSchema = AccessGroups$outboundSchema;
  /** @deprecated use `AccessGroups$Outbound` instead. */
  export type Outbound = AccessGroups$Outbound;
}

/** @internal */
export const ResponseBodyPagination$inboundSchema: z.ZodType<
  ResponseBodyPagination,
  z.ZodTypeDef,
  unknown
> = z.object({
  count: z.number(),
  next: z.nullable(z.string()),
});

/** @internal */
export type ResponseBodyPagination$Outbound = {
  count: number;
  next: string | null;
};

/** @internal */
export const ResponseBodyPagination$outboundSchema: z.ZodType<
  ResponseBodyPagination$Outbound,
  z.ZodTypeDef,
  ResponseBodyPagination
> = z.object({
  count: z.number(),
  next: z.nullable(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyPagination$ {
  /** @deprecated use `ResponseBodyPagination$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyPagination$inboundSchema;
  /** @deprecated use `ResponseBodyPagination$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyPagination$outboundSchema;
  /** @deprecated use `ResponseBodyPagination$Outbound` instead. */
  export type Outbound = ResponseBodyPagination$Outbound;
}

/** @internal */
export const ListAccessGroupsResponseBody2$inboundSchema: z.ZodType<
  ListAccessGroupsResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  accessGroups: z.array(z.lazy(() => AccessGroups$inboundSchema)),
  pagination: z.lazy(() => ResponseBodyPagination$inboundSchema),
});

/** @internal */
export type ListAccessGroupsResponseBody2$Outbound = {
  accessGroups: Array<AccessGroups$Outbound>;
  pagination: ResponseBodyPagination$Outbound;
};

/** @internal */
export const ListAccessGroupsResponseBody2$outboundSchema: z.ZodType<
  ListAccessGroupsResponseBody2$Outbound,
  z.ZodTypeDef,
  ListAccessGroupsResponseBody2
> = z.object({
  accessGroups: z.array(z.lazy(() => AccessGroups$outboundSchema)),
  pagination: z.lazy(() => ResponseBodyPagination$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListAccessGroupsResponseBody2$ {
  /** @deprecated use `ListAccessGroupsResponseBody2$inboundSchema` instead. */
  export const inboundSchema = ListAccessGroupsResponseBody2$inboundSchema;
  /** @deprecated use `ListAccessGroupsResponseBody2$outboundSchema` instead. */
  export const outboundSchema = ListAccessGroupsResponseBody2$outboundSchema;
  /** @deprecated use `ListAccessGroupsResponseBody2$Outbound` instead. */
  export type Outbound = ListAccessGroupsResponseBody2$Outbound;
}

/** @internal */
export const ListAccessGroupsResponseBody1$inboundSchema: z.ZodType<
  ListAccessGroupsResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type ListAccessGroupsResponseBody1$Outbound = {};

/** @internal */
export const ListAccessGroupsResponseBody1$outboundSchema: z.ZodType<
  ListAccessGroupsResponseBody1$Outbound,
  z.ZodTypeDef,
  ListAccessGroupsResponseBody1
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListAccessGroupsResponseBody1$ {
  /** @deprecated use `ListAccessGroupsResponseBody1$inboundSchema` instead. */
  export const inboundSchema = ListAccessGroupsResponseBody1$inboundSchema;
  /** @deprecated use `ListAccessGroupsResponseBody1$outboundSchema` instead. */
  export const outboundSchema = ListAccessGroupsResponseBody1$outboundSchema;
  /** @deprecated use `ListAccessGroupsResponseBody1$Outbound` instead. */
  export type Outbound = ListAccessGroupsResponseBody1$Outbound;
}

/** @internal */
export const ListAccessGroupsResponseBody$inboundSchema: z.ZodType<
  ListAccessGroupsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => ListAccessGroupsResponseBody1$inboundSchema),
  z.lazy(() => ListAccessGroupsResponseBody2$inboundSchema),
]);

/** @internal */
export type ListAccessGroupsResponseBody$Outbound =
  | ListAccessGroupsResponseBody1$Outbound
  | ListAccessGroupsResponseBody2$Outbound;

/** @internal */
export const ListAccessGroupsResponseBody$outboundSchema: z.ZodType<
  ListAccessGroupsResponseBody$Outbound,
  z.ZodTypeDef,
  ListAccessGroupsResponseBody
> = z.union([
  z.lazy(() => ListAccessGroupsResponseBody1$outboundSchema),
  z.lazy(() => ListAccessGroupsResponseBody2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ListAccessGroupsResponseBody$ {
  /** @deprecated use `ListAccessGroupsResponseBody$inboundSchema` instead. */
  export const inboundSchema = ListAccessGroupsResponseBody$inboundSchema;
  /** @deprecated use `ListAccessGroupsResponseBody$outboundSchema` instead. */
  export const outboundSchema = ListAccessGroupsResponseBody$outboundSchema;
  /** @deprecated use `ListAccessGroupsResponseBody$Outbound` instead. */
  export type Outbound = ListAccessGroupsResponseBody$Outbound;
}
