/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";

export type IssueCertRequestBody = {
  /**
   * The common names the cert should be issued for
   */
  cns?: Array<string> | undefined;
};

export type IssueCertRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: IssueCertRequestBody | undefined;
};

export type IssueCertResponseBody = {
  id: string;
  createdAt: number;
  expiresAt: number;
  autoRenew: boolean;
  cns: Array<string>;
};

/** @internal */
export const IssueCertRequestBody$inboundSchema: z.ZodType<
  IssueCertRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  cns: z.array(z.string()).optional(),
});

/** @internal */
export type IssueCertRequestBody$Outbound = {
  cns?: Array<string> | undefined;
};

/** @internal */
export const IssueCertRequestBody$outboundSchema: z.ZodType<
  IssueCertRequestBody$Outbound,
  z.ZodTypeDef,
  IssueCertRequestBody
> = z.object({
  cns: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace IssueCertRequestBody$ {
  /** @deprecated use `IssueCertRequestBody$inboundSchema` instead. */
  export const inboundSchema = IssueCertRequestBody$inboundSchema;
  /** @deprecated use `IssueCertRequestBody$outboundSchema` instead. */
  export const outboundSchema = IssueCertRequestBody$outboundSchema;
  /** @deprecated use `IssueCertRequestBody$Outbound` instead. */
  export type Outbound = IssueCertRequestBody$Outbound;
}

/** @internal */
export const IssueCertRequest$inboundSchema: z.ZodType<
  IssueCertRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => IssueCertRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type IssueCertRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: IssueCertRequestBody$Outbound | undefined;
};

/** @internal */
export const IssueCertRequest$outboundSchema: z.ZodType<
  IssueCertRequest$Outbound,
  z.ZodTypeDef,
  IssueCertRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => IssueCertRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace IssueCertRequest$ {
  /** @deprecated use `IssueCertRequest$inboundSchema` instead. */
  export const inboundSchema = IssueCertRequest$inboundSchema;
  /** @deprecated use `IssueCertRequest$outboundSchema` instead. */
  export const outboundSchema = IssueCertRequest$outboundSchema;
  /** @deprecated use `IssueCertRequest$Outbound` instead. */
  export type Outbound = IssueCertRequest$Outbound;
}

/** @internal */
export const IssueCertResponseBody$inboundSchema: z.ZodType<
  IssueCertResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  createdAt: z.number(),
  expiresAt: z.number(),
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
});

/** @internal */
export type IssueCertResponseBody$Outbound = {
  id: string;
  createdAt: number;
  expiresAt: number;
  autoRenew: boolean;
  cns: Array<string>;
};

/** @internal */
export const IssueCertResponseBody$outboundSchema: z.ZodType<
  IssueCertResponseBody$Outbound,
  z.ZodTypeDef,
  IssueCertResponseBody
> = z.object({
  id: z.string(),
  createdAt: z.number(),
  expiresAt: z.number(),
  autoRenew: z.boolean(),
  cns: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace IssueCertResponseBody$ {
  /** @deprecated use `IssueCertResponseBody$inboundSchema` instead. */
  export const inboundSchema = IssueCertResponseBody$inboundSchema;
  /** @deprecated use `IssueCertResponseBody$outboundSchema` instead. */
  export const outboundSchema = IssueCertResponseBody$outboundSchema;
  /** @deprecated use `IssueCertResponseBody$Outbound` instead. */
  export type Outbound = IssueCertResponseBody$Outbound;
}
