/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type GetWebhooksRequest = {
  projectId?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * The webhooks events
 */
export const GetWebhooksResponseBodyEvents = {
  BudgetReached: "budget.reached",
  BudgetReset: "budget.reset",
  DomainCreated: "domain.created",
  DeploymentCreated: "deployment.created",
  DeploymentError: "deployment.error",
  DeploymentCanceled: "deployment.canceled",
  DeploymentSucceeded: "deployment.succeeded",
  DeploymentReady: "deployment.ready",
  DeploymentCheckRerequested: "deployment.check-rerequested",
  DeploymentPromoted: "deployment.promoted",
  DeploymentIntegrationActionStart: "deployment.integration.action.start",
  DeploymentIntegrationActionCancel: "deployment.integration.action.cancel",
  DeploymentIntegrationActionCleanup: "deployment.integration.action.cleanup",
  EdgeConfigCreated: "edge-config.created",
  EdgeConfigDeleted: "edge-config.deleted",
  EdgeConfigItemsUpdated: "edge-config.items.updated",
  FirewallAttack: "firewall.attack",
  IntegrationConfigurationPermissionUpgraded:
    "integration-configuration.permission-upgraded",
  IntegrationConfigurationRemoved: "integration-configuration.removed",
  IntegrationConfigurationScopeChangeConfirmed:
    "integration-configuration.scope-change-confirmed",
  ProjectCreated: "project.created",
  ProjectRemoved: "project.removed",
  DeploymentChecksCompletedLegacy: "deployment-checks-completed",
  DeploymentReadyLegacy: "deployment-ready",
  DeploymentPreparedLegacy: "deployment-prepared",
  DeploymentErrorLegacy: "deployment-error",
  DeploymentCheckRerequestedLegacy: "deployment-check-rerequested",
  DeploymentCanceledLegacy: "deployment-canceled",
  ProjectCreatedLegacy: "project-created",
  ProjectRemovedLegacy: "project-removed",
  DomainCreatedLegacy: "domain-created",
  DeploymentLegacy: "deployment",
  IntegrationConfigurationPermissionUpdatedLegacy:
    "integration-configuration-permission-updated",
  IntegrationConfigurationRemovedLegacy: "integration-configuration-removed",
  IntegrationConfigurationScopeChangeConfirmedLegacy:
    "integration-configuration-scope-change-confirmed",
  MarketplaceInvoiceCreated: "marketplace.invoice.created",
  MarketplaceInvoicePaid: "marketplace.invoice.paid",
  MarketplaceInvoiceNotpaid: "marketplace.invoice.notpaid",
  MarketplaceInvoiceRefunded: "marketplace.invoice.refunded",
  TestWebhook: "observability.anomaly",
  undefined: "test-webhook",
} as const;
/**
 * The webhooks events
 */
export type GetWebhooksResponseBodyEvents = ClosedEnum<
  typeof GetWebhooksResponseBodyEvents
>;

export type GetWebhooksResponseBody2 = {
  /**
   * The webhooks events
   */
  events: Array<GetWebhooksResponseBodyEvents>;
  /**
   * The webhook id
   */
  id: string;
  /**
   * A string with the URL of the webhook
   */
  url: string;
  /**
   * The unique ID of the team the webhook belongs to
   */
  ownerId: string;
  /**
   * A number containing the date when the webhook was created in in milliseconds
   */
  createdAt: number;
  /**
   * A number containing the date when the webhook was updated in in milliseconds
   */
  updatedAt: number;
  /**
   * The ID of the projects the webhook is associated with
   */
  projectIds?: Array<string> | undefined;
};

export const GetWebhooksResponseBodyFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type GetWebhooksResponseBodyFramework = ClosedEnum<
  typeof GetWebhooksResponseBodyFramework
>;

export type ProjectsMetadata = {
  id: string;
  name: string;
  framework?: GetWebhooksResponseBodyFramework | null | undefined;
  latestDeployment?: string | undefined;
};

/**
 * The webhooks events
 */
export const ResponseBodyEvents = {
  BudgetReached: "budget.reached",
  BudgetReset: "budget.reset",
  DomainCreated: "domain.created",
  DeploymentCreated: "deployment.created",
  DeploymentError: "deployment.error",
  DeploymentCanceled: "deployment.canceled",
  DeploymentSucceeded: "deployment.succeeded",
  DeploymentReady: "deployment.ready",
  DeploymentCheckRerequested: "deployment.check-rerequested",
  DeploymentPromoted: "deployment.promoted",
  DeploymentIntegrationActionStart: "deployment.integration.action.start",
  DeploymentIntegrationActionCancel: "deployment.integration.action.cancel",
  DeploymentIntegrationActionCleanup: "deployment.integration.action.cleanup",
  EdgeConfigCreated: "edge-config.created",
  EdgeConfigDeleted: "edge-config.deleted",
  EdgeConfigItemsUpdated: "edge-config.items.updated",
  FirewallAttack: "firewall.attack",
  IntegrationConfigurationPermissionUpgraded:
    "integration-configuration.permission-upgraded",
  IntegrationConfigurationRemoved: "integration-configuration.removed",
  IntegrationConfigurationScopeChangeConfirmed:
    "integration-configuration.scope-change-confirmed",
  ProjectCreated: "project.created",
  ProjectRemoved: "project.removed",
  DeploymentChecksCompletedLegacy: "deployment-checks-completed",
  DeploymentReadyLegacy: "deployment-ready",
  DeploymentPreparedLegacy: "deployment-prepared",
  DeploymentErrorLegacy: "deployment-error",
  DeploymentCheckRerequestedLegacy: "deployment-check-rerequested",
  DeploymentCanceledLegacy: "deployment-canceled",
  ProjectCreatedLegacy: "project-created",
  ProjectRemovedLegacy: "project-removed",
  DomainCreatedLegacy: "domain-created",
  DeploymentLegacy: "deployment",
  IntegrationConfigurationPermissionUpdatedLegacy:
    "integration-configuration-permission-updated",
  IntegrationConfigurationRemovedLegacy: "integration-configuration-removed",
  IntegrationConfigurationScopeChangeConfirmedLegacy:
    "integration-configuration-scope-change-confirmed",
  MarketplaceInvoiceCreated: "marketplace.invoice.created",
  MarketplaceInvoicePaid: "marketplace.invoice.paid",
  MarketplaceInvoiceNotpaid: "marketplace.invoice.notpaid",
  MarketplaceInvoiceRefunded: "marketplace.invoice.refunded",
  TestWebhook: "observability.anomaly",
  undefined: "test-webhook",
} as const;
/**
 * The webhooks events
 */
export type ResponseBodyEvents = ClosedEnum<typeof ResponseBodyEvents>;

export type GetWebhooksResponseBody1 = {
  projectsMetadata: Array<ProjectsMetadata> | null;
  /**
   * The webhooks events
   */
  events: Array<ResponseBodyEvents>;
  /**
   * The webhook id
   */
  id: string;
  /**
   * A string with the URL of the webhook
   */
  url: string;
  /**
   * The unique ID of the team the webhook belongs to
   */
  ownerId: string;
  /**
   * A number containing the date when the webhook was created in in milliseconds
   */
  createdAt: number;
  /**
   * A number containing the date when the webhook was updated in in milliseconds
   */
  updatedAt: number;
  /**
   * The ID of the projects the webhook is associated with
   */
  projectIds?: Array<string> | undefined;
};

export type GetWebhooksResponseBody =
  | Array<GetWebhooksResponseBody1>
  | Array<GetWebhooksResponseBody2>;

/** @internal */
export const GetWebhooksRequest$inboundSchema: z.ZodType<
  GetWebhooksRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetWebhooksRequest$Outbound = {
  projectId?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetWebhooksRequest$outboundSchema: z.ZodType<
  GetWebhooksRequest$Outbound,
  z.ZodTypeDef,
  GetWebhooksRequest
> = z.object({
  projectId: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhooksRequest$ {
  /** @deprecated use `GetWebhooksRequest$inboundSchema` instead. */
  export const inboundSchema = GetWebhooksRequest$inboundSchema;
  /** @deprecated use `GetWebhooksRequest$outboundSchema` instead. */
  export const outboundSchema = GetWebhooksRequest$outboundSchema;
  /** @deprecated use `GetWebhooksRequest$Outbound` instead. */
  export type Outbound = GetWebhooksRequest$Outbound;
}

/** @internal */
export const GetWebhooksResponseBodyEvents$inboundSchema: z.ZodNativeEnum<
  typeof GetWebhooksResponseBodyEvents
> = z.nativeEnum(GetWebhooksResponseBodyEvents);

/** @internal */
export const GetWebhooksResponseBodyEvents$outboundSchema: z.ZodNativeEnum<
  typeof GetWebhooksResponseBodyEvents
> = GetWebhooksResponseBodyEvents$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhooksResponseBodyEvents$ {
  /** @deprecated use `GetWebhooksResponseBodyEvents$inboundSchema` instead. */
  export const inboundSchema = GetWebhooksResponseBodyEvents$inboundSchema;
  /** @deprecated use `GetWebhooksResponseBodyEvents$outboundSchema` instead. */
  export const outboundSchema = GetWebhooksResponseBodyEvents$outboundSchema;
}

/** @internal */
export const GetWebhooksResponseBody2$inboundSchema: z.ZodType<
  GetWebhooksResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  events: z.array(GetWebhooksResponseBodyEvents$inboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/** @internal */
export type GetWebhooksResponseBody2$Outbound = {
  events: Array<string>;
  id: string;
  url: string;
  ownerId: string;
  createdAt: number;
  updatedAt: number;
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const GetWebhooksResponseBody2$outboundSchema: z.ZodType<
  GetWebhooksResponseBody2$Outbound,
  z.ZodTypeDef,
  GetWebhooksResponseBody2
> = z.object({
  events: z.array(GetWebhooksResponseBodyEvents$outboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhooksResponseBody2$ {
  /** @deprecated use `GetWebhooksResponseBody2$inboundSchema` instead. */
  export const inboundSchema = GetWebhooksResponseBody2$inboundSchema;
  /** @deprecated use `GetWebhooksResponseBody2$outboundSchema` instead. */
  export const outboundSchema = GetWebhooksResponseBody2$outboundSchema;
  /** @deprecated use `GetWebhooksResponseBody2$Outbound` instead. */
  export type Outbound = GetWebhooksResponseBody2$Outbound;
}

/** @internal */
export const GetWebhooksResponseBodyFramework$inboundSchema: z.ZodNativeEnum<
  typeof GetWebhooksResponseBodyFramework
> = z.nativeEnum(GetWebhooksResponseBodyFramework);

/** @internal */
export const GetWebhooksResponseBodyFramework$outboundSchema: z.ZodNativeEnum<
  typeof GetWebhooksResponseBodyFramework
> = GetWebhooksResponseBodyFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhooksResponseBodyFramework$ {
  /** @deprecated use `GetWebhooksResponseBodyFramework$inboundSchema` instead. */
  export const inboundSchema = GetWebhooksResponseBodyFramework$inboundSchema;
  /** @deprecated use `GetWebhooksResponseBodyFramework$outboundSchema` instead. */
  export const outboundSchema = GetWebhooksResponseBodyFramework$outboundSchema;
}

/** @internal */
export const ProjectsMetadata$inboundSchema: z.ZodType<
  ProjectsMetadata,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(GetWebhooksResponseBodyFramework$inboundSchema)
    .optional(),
  latestDeployment: z.string().optional(),
});

/** @internal */
export type ProjectsMetadata$Outbound = {
  id: string;
  name: string;
  framework?: string | null | undefined;
  latestDeployment?: string | undefined;
};

/** @internal */
export const ProjectsMetadata$outboundSchema: z.ZodType<
  ProjectsMetadata$Outbound,
  z.ZodTypeDef,
  ProjectsMetadata
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(GetWebhooksResponseBodyFramework$outboundSchema)
    .optional(),
  latestDeployment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProjectsMetadata$ {
  /** @deprecated use `ProjectsMetadata$inboundSchema` instead. */
  export const inboundSchema = ProjectsMetadata$inboundSchema;
  /** @deprecated use `ProjectsMetadata$outboundSchema` instead. */
  export const outboundSchema = ProjectsMetadata$outboundSchema;
  /** @deprecated use `ProjectsMetadata$Outbound` instead. */
  export type Outbound = ProjectsMetadata$Outbound;
}

/** @internal */
export const ResponseBodyEvents$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyEvents
> = z.nativeEnum(ResponseBodyEvents);

/** @internal */
export const ResponseBodyEvents$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyEvents
> = ResponseBodyEvents$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyEvents$ {
  /** @deprecated use `ResponseBodyEvents$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyEvents$inboundSchema;
  /** @deprecated use `ResponseBodyEvents$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyEvents$outboundSchema;
}

/** @internal */
export const GetWebhooksResponseBody1$inboundSchema: z.ZodType<
  GetWebhooksResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectsMetadata: z.nullable(
    z.array(z.lazy(() => ProjectsMetadata$inboundSchema)),
  ),
  events: z.array(ResponseBodyEvents$inboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/** @internal */
export type GetWebhooksResponseBody1$Outbound = {
  projectsMetadata: Array<ProjectsMetadata$Outbound> | null;
  events: Array<string>;
  id: string;
  url: string;
  ownerId: string;
  createdAt: number;
  updatedAt: number;
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const GetWebhooksResponseBody1$outboundSchema: z.ZodType<
  GetWebhooksResponseBody1$Outbound,
  z.ZodTypeDef,
  GetWebhooksResponseBody1
> = z.object({
  projectsMetadata: z.nullable(
    z.array(z.lazy(() => ProjectsMetadata$outboundSchema)),
  ),
  events: z.array(ResponseBodyEvents$outboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhooksResponseBody1$ {
  /** @deprecated use `GetWebhooksResponseBody1$inboundSchema` instead. */
  export const inboundSchema = GetWebhooksResponseBody1$inboundSchema;
  /** @deprecated use `GetWebhooksResponseBody1$outboundSchema` instead. */
  export const outboundSchema = GetWebhooksResponseBody1$outboundSchema;
  /** @deprecated use `GetWebhooksResponseBody1$Outbound` instead. */
  export type Outbound = GetWebhooksResponseBody1$Outbound;
}

/** @internal */
export const GetWebhooksResponseBody$inboundSchema: z.ZodType<
  GetWebhooksResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(z.lazy(() => GetWebhooksResponseBody1$inboundSchema)),
  z.array(z.lazy(() => GetWebhooksResponseBody2$inboundSchema)),
]);

/** @internal */
export type GetWebhooksResponseBody$Outbound =
  | Array<GetWebhooksResponseBody1$Outbound>
  | Array<GetWebhooksResponseBody2$Outbound>;

/** @internal */
export const GetWebhooksResponseBody$outboundSchema: z.ZodType<
  GetWebhooksResponseBody$Outbound,
  z.ZodTypeDef,
  GetWebhooksResponseBody
> = z.union([
  z.array(z.lazy(() => GetWebhooksResponseBody1$outboundSchema)),
  z.array(z.lazy(() => GetWebhooksResponseBody2$outboundSchema)),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhooksResponseBody$ {
  /** @deprecated use `GetWebhooksResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetWebhooksResponseBody$inboundSchema;
  /** @deprecated use `GetWebhooksResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetWebhooksResponseBody$outboundSchema;
  /** @deprecated use `GetWebhooksResponseBody$Outbound` instead. */
  export type Outbound = GetWebhooksResponseBody$Outbound;
}
