/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type GetWebhookRequest = {
  id: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * The webhooks events
 */
export const GetWebhookEvents = {
  BudgetReached: "budget.reached",
  BudgetReset: "budget.reset",
  DomainCreated: "domain.created",
  DeploymentCreated: "deployment.created",
  DeploymentError: "deployment.error",
  DeploymentCanceled: "deployment.canceled",
  DeploymentSucceeded: "deployment.succeeded",
  DeploymentReady: "deployment.ready",
  DeploymentCheckRerequested: "deployment.check-rerequested",
  DeploymentPromoted: "deployment.promoted",
  DeploymentIntegrationActionStart: "deployment.integration.action.start",
  DeploymentIntegrationActionCancel: "deployment.integration.action.cancel",
  DeploymentIntegrationActionCleanup: "deployment.integration.action.cleanup",
  EdgeConfigCreated: "edge-config.created",
  EdgeConfigDeleted: "edge-config.deleted",
  EdgeConfigItemsUpdated: "edge-config.items.updated",
  FirewallAttack: "firewall.attack",
  IntegrationConfigurationPermissionUpgraded:
    "integration-configuration.permission-upgraded",
  IntegrationConfigurationRemoved: "integration-configuration.removed",
  IntegrationConfigurationScopeChangeConfirmed:
    "integration-configuration.scope-change-confirmed",
  ProjectCreated: "project.created",
  ProjectRemoved: "project.removed",
  DeploymentChecksCompletedLegacy: "deployment-checks-completed",
  DeploymentReadyLegacy: "deployment-ready",
  DeploymentPreparedLegacy: "deployment-prepared",
  DeploymentErrorLegacy: "deployment-error",
  DeploymentCheckRerequestedLegacy: "deployment-check-rerequested",
  DeploymentCanceledLegacy: "deployment-canceled",
  ProjectCreatedLegacy: "project-created",
  ProjectRemovedLegacy: "project-removed",
  DomainCreatedLegacy: "domain-created",
  DeploymentLegacy: "deployment",
  IntegrationConfigurationPermissionUpdatedLegacy:
    "integration-configuration-permission-updated",
  IntegrationConfigurationRemovedLegacy: "integration-configuration-removed",
  IntegrationConfigurationScopeChangeConfirmedLegacy:
    "integration-configuration-scope-change-confirmed",
  MarketplaceInvoiceCreated: "marketplace.invoice.created",
  MarketplaceInvoicePaid: "marketplace.invoice.paid",
  MarketplaceInvoiceNotpaid: "marketplace.invoice.notpaid",
  MarketplaceInvoiceRefunded: "marketplace.invoice.refunded",
  TestWebhook: "observability.anomaly",
  undefined: "test-webhook",
} as const;
/**
 * The webhooks events
 */
export type GetWebhookEvents = ClosedEnum<typeof GetWebhookEvents>;

export type GetWebhookResponseBody = {
  /**
   * The webhooks events
   */
  events: Array<GetWebhookEvents>;
  /**
   * The webhook id
   */
  id: string;
  /**
   * A string with the URL of the webhook
   */
  url: string;
  /**
   * The unique ID of the team the webhook belongs to
   */
  ownerId: string;
  /**
   * A number containing the date when the webhook was created in in milliseconds
   */
  createdAt: number;
  /**
   * A number containing the date when the webhook was updated in in milliseconds
   */
  updatedAt: number;
  /**
   * The ID of the projects the webhook is associated with
   */
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const GetWebhookRequest$inboundSchema: z.ZodType<
  GetWebhookRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetWebhookRequest$Outbound = {
  id: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetWebhookRequest$outboundSchema: z.ZodType<
  GetWebhookRequest$Outbound,
  z.ZodTypeDef,
  GetWebhookRequest
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhookRequest$ {
  /** @deprecated use `GetWebhookRequest$inboundSchema` instead. */
  export const inboundSchema = GetWebhookRequest$inboundSchema;
  /** @deprecated use `GetWebhookRequest$outboundSchema` instead. */
  export const outboundSchema = GetWebhookRequest$outboundSchema;
  /** @deprecated use `GetWebhookRequest$Outbound` instead. */
  export type Outbound = GetWebhookRequest$Outbound;
}

/** @internal */
export const GetWebhookEvents$inboundSchema: z.ZodNativeEnum<
  typeof GetWebhookEvents
> = z.nativeEnum(GetWebhookEvents);

/** @internal */
export const GetWebhookEvents$outboundSchema: z.ZodNativeEnum<
  typeof GetWebhookEvents
> = GetWebhookEvents$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhookEvents$ {
  /** @deprecated use `GetWebhookEvents$inboundSchema` instead. */
  export const inboundSchema = GetWebhookEvents$inboundSchema;
  /** @deprecated use `GetWebhookEvents$outboundSchema` instead. */
  export const outboundSchema = GetWebhookEvents$outboundSchema;
}

/** @internal */
export const GetWebhookResponseBody$inboundSchema: z.ZodType<
  GetWebhookResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  events: z.array(GetWebhookEvents$inboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/** @internal */
export type GetWebhookResponseBody$Outbound = {
  events: Array<string>;
  id: string;
  url: string;
  ownerId: string;
  createdAt: number;
  updatedAt: number;
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const GetWebhookResponseBody$outboundSchema: z.ZodType<
  GetWebhookResponseBody$Outbound,
  z.ZodTypeDef,
  GetWebhookResponseBody
> = z.object({
  events: z.array(GetWebhookEvents$outboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetWebhookResponseBody$ {
  /** @deprecated use `GetWebhookResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetWebhookResponseBody$inboundSchema;
  /** @deprecated use `GetWebhookResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetWebhookResponseBody$outboundSchema;
  /** @deprecated use `GetWebhookResponseBody$Outbound` instead. */
  export type Outbound = GetWebhookResponseBody$Outbound;
}
