/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import {
  Pagination,
  Pagination$inboundSchema,
  Pagination$Outbound,
  Pagination$outboundSchema,
} from "../components/pagination.js";
import {
  TeamLimited,
  TeamLimited$inboundSchema,
  TeamLimited$Outbound,
  TeamLimited$outboundSchema,
} from "../components/teamlimited.js";

export type GetTeamsRequest = {
  /**
   * Maximum number of Teams which may be returned.
   */
  limit?: number | undefined;
  /**
   * Timestamp (in milliseconds) to only include Teams created since then.
   */
  since?: number | undefined;
  /**
   * Timestamp (in milliseconds) to only include Teams created until then.
   */
  until?: number | undefined;
};

export type Teams = TeamLimited | { [k: string]: any };

/**
 * A paginated list of teams.
 */
export type GetTeamsResponseBody = {
  teams: Array<TeamLimited | { [k: string]: any }>;
  /**
   * This object contains information related to the pagination of the current request, including the necessary parameters to get the next or previous page of data.
   */
  pagination: Pagination;
};

/** @internal */
export const GetTeamsRequest$inboundSchema: z.ZodType<
  GetTeamsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  limit: z.number().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
});

/** @internal */
export type GetTeamsRequest$Outbound = {
  limit?: number | undefined;
  since?: number | undefined;
  until?: number | undefined;
};

/** @internal */
export const GetTeamsRequest$outboundSchema: z.ZodType<
  GetTeamsRequest$Outbound,
  z.ZodTypeDef,
  GetTeamsRequest
> = z.object({
  limit: z.number().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetTeamsRequest$ {
  /** @deprecated use `GetTeamsRequest$inboundSchema` instead. */
  export const inboundSchema = GetTeamsRequest$inboundSchema;
  /** @deprecated use `GetTeamsRequest$outboundSchema` instead. */
  export const outboundSchema = GetTeamsRequest$outboundSchema;
  /** @deprecated use `GetTeamsRequest$Outbound` instead. */
  export type Outbound = GetTeamsRequest$Outbound;
}

/** @internal */
export const Teams$inboundSchema: z.ZodType<Teams, z.ZodTypeDef, unknown> = z
  .union([TeamLimited$inboundSchema, z.record(z.any())]);

/** @internal */
export type Teams$Outbound = TeamLimited$Outbound | { [k: string]: any };

/** @internal */
export const Teams$outboundSchema: z.ZodType<
  Teams$Outbound,
  z.ZodTypeDef,
  Teams
> = z.union([TeamLimited$outboundSchema, z.record(z.any())]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Teams$ {
  /** @deprecated use `Teams$inboundSchema` instead. */
  export const inboundSchema = Teams$inboundSchema;
  /** @deprecated use `Teams$outboundSchema` instead. */
  export const outboundSchema = Teams$outboundSchema;
  /** @deprecated use `Teams$Outbound` instead. */
  export type Outbound = Teams$Outbound;
}

/** @internal */
export const GetTeamsResponseBody$inboundSchema: z.ZodType<
  GetTeamsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  teams: z.array(z.union([TeamLimited$inboundSchema, z.record(z.any())])),
  pagination: Pagination$inboundSchema,
});

/** @internal */
export type GetTeamsResponseBody$Outbound = {
  teams: Array<TeamLimited$Outbound | { [k: string]: any }>;
  pagination: Pagination$Outbound;
};

/** @internal */
export const GetTeamsResponseBody$outboundSchema: z.ZodType<
  GetTeamsResponseBody$Outbound,
  z.ZodTypeDef,
  GetTeamsResponseBody
> = z.object({
  teams: z.array(z.union([TeamLimited$outboundSchema, z.record(z.any())])),
  pagination: Pagination$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetTeamsResponseBody$ {
  /** @deprecated use `GetTeamsResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetTeamsResponseBody$inboundSchema;
  /** @deprecated use `GetTeamsResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetTeamsResponseBody$outboundSchema;
  /** @deprecated use `GetTeamsResponseBody$Outbound` instead. */
  export type Outbound = GetTeamsResponseBody$Outbound;
}
