/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  ACLAction,
  ACLAction$inboundSchema,
  ACLAction$outboundSchema,
} from "../components/aclaction.js";
import {
  Pagination,
  Pagination$inboundSchema,
  Pagination$Outbound,
  Pagination$outboundSchema,
} from "../components/pagination.js";

/**
 * Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed
 */
export const GitForkProtection = {
  One: "1",
  Zero: "0",
} as const;
/**
 * Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed
 */
export type GitForkProtection = ClosedEnum<typeof GitForkProtection>;

export type GetProjectsRequest = {
  /**
   * Query only projects updated after the given timestamp
   */
  from?: string | undefined;
  /**
   * Specifies whether PRs from Git forks should require a team member's authorization before it can be deployed
   */
  gitForkProtection?: GitForkProtection | undefined;
  /**
   * Limit the number of projects returned
   */
  limit?: string | undefined;
  /**
   * Search projects by the name field
   */
  search?: string | undefined;
  /**
   * Filter results by repo. Also used for project count
   */
  repo?: string | undefined;
  /**
   * Filter results by Repository ID.
   */
  repoId?: string | undefined;
  /**
   * Filter results by Repository URL.
   */
  repoUrl?: string | undefined;
  /**
   * Filter results by excluding those projects that belong to a repo
   */
  excludeRepos?: string | undefined;
  /**
   * Filter results by connected Edge Config ID
   */
  edgeConfigId?: string | undefined;
  /**
   * Filter results by connected Edge Config Token ID
   */
  edgeConfigTokenId?: string | undefined;
  deprecated?: boolean | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export type GetProjectsAnalytics = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

export type GetProjectsSpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type GetProjectsDefinitions = {
  /**
   * The hostname that should be used.
   */
  host: string;
  /**
   * The path that should be called for the cronjob.
   */
  path: string;
  /**
   * The cron expression.
   */
  schedule: string;
};

export type GetProjectsCrons = {
  /**
   * The time the feature was enabled for this project. Note: It enables automatically with the first Deployment that outputs cronjobs.
   */
  enabledAt: number;
  /**
   * The time the feature was disabled for this project.
   */
  disabledAt: number | null;
  updatedAt: number;
  /**
   * The ID of the Deployment from which the definitions originated.
   */
  deploymentId: string | null;
  definitions: Array<GetProjectsDefinitions>;
};

export type GetProjectsDataCache = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

export type GetProjectsDeploymentExpiration = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

export const GetProjectsTarget2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type GetProjectsTarget2 = ClosedEnum<typeof GetProjectsTarget2>;

export const GetProjectsTarget1 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type GetProjectsTarget1 = ClosedEnum<typeof GetProjectsTarget1>;

export type GetProjectsTarget = Array<GetProjectsTarget1> | GetProjectsTarget2;

export const GetProjectsType = {
  System: "system",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
  Secret: "secret",
} as const;
export type GetProjectsType = ClosedEnum<typeof GetProjectsType>;

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type
  >;

export type GetProjectsContentHint15 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type;
  projectId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type
  >;

export type GetProjectsContentHint14 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type
  >;

export type GetProjectsContentHint13 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type
  >;

export type GetProjectsContentHint12 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type
  >;

export type GetProjectsContentHint11 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type
  >;

export type GetProjectsContentHint10 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type
  >;

export type GetProjectsContentHint9 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType
  >;

export type GetProjectsContentHint8 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType
  >;

export type GetProjectsContentHint7 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type GetProjectsContentHint6 = {
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200ApplicationJSONType = {
  BlobReadWriteToken: "blob-read-write-token",
} as const;
export type GetProjectsContentHintProjectsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONType
  >;

export type GetProjectsContentHint5 = {
  type: GetProjectsContentHintProjectsResponse200ApplicationJSONType;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponse200Type = {
  RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
} as const;
export type GetProjectsContentHintProjectsResponse200Type = ClosedEnum<
  typeof GetProjectsContentHintProjectsResponse200Type
>;

export type GetProjectsContentHint4 = {
  type: GetProjectsContentHintProjectsResponse200Type;
  storeId: string;
};

export const GetProjectsContentHintProjectsResponseType = {
  RedisRestApiToken: "redis-rest-api-token",
} as const;
export type GetProjectsContentHintProjectsResponseType = ClosedEnum<
  typeof GetProjectsContentHintProjectsResponseType
>;

export type GetProjectsContentHint3 = {
  type: GetProjectsContentHintProjectsResponseType;
  storeId: string;
};

export const GetProjectsContentHintProjectsType = {
  RedisRestApiUrl: "redis-rest-api-url",
} as const;
export type GetProjectsContentHintProjectsType = ClosedEnum<
  typeof GetProjectsContentHintProjectsType
>;

export type GetProjectsContentHint2 = {
  type: GetProjectsContentHintProjectsType;
  storeId: string;
};

export const GetProjectsContentHintType = {
  RedisUrl: "redis-url",
} as const;
export type GetProjectsContentHintType = ClosedEnum<
  typeof GetProjectsContentHintType
>;

export type GetProjectsContentHint1 = {
  type: GetProjectsContentHintType;
  storeId: string;
};

export type GetProjectsContentHint =
  | GetProjectsContentHint1
  | GetProjectsContentHint2
  | GetProjectsContentHint3
  | GetProjectsContentHint4
  | GetProjectsContentHint5
  | GetProjectsContentHint6
  | GetProjectsContentHint7
  | GetProjectsContentHint8
  | GetProjectsContentHint9
  | GetProjectsContentHint10
  | GetProjectsContentHint11
  | GetProjectsContentHint12
  | GetProjectsContentHint13
  | GetProjectsContentHint15
  | GetProjectsContentHint14;

export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType =
  {
    FlagsSecret: "flags-secret",
  } as const;
export type GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType =
  ClosedEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType
  >;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type GetProjectsInternalContentHint = {
  type: GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type GetProjectsEnv = {
  target?: Array<GetProjectsTarget1> | GetProjectsTarget2 | undefined;
  type: GetProjectsType;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | GetProjectsContentHint1
    | GetProjectsContentHint2
    | GetProjectsContentHint3
    | GetProjectsContentHint4
    | GetProjectsContentHint5
    | GetProjectsContentHint6
    | GetProjectsContentHint7
    | GetProjectsContentHint8
    | GetProjectsContentHint9
    | GetProjectsContentHint10
    | GetProjectsContentHint11
    | GetProjectsContentHint12
    | GetProjectsContentHint13
    | GetProjectsContentHint15
    | GetProjectsContentHint14
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?: GetProjectsInternalContentHint | null | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

export type GetProjectsCustomEnvironments = {};

export const GetProjectsFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type GetProjectsFramework = ClosedEnum<typeof GetProjectsFramework>;

export type GetProjectsIpBuckets = {
  bucket: string;
  supportUntil?: number | undefined;
};

export type GetProjectsAliasAssigned = number | boolean;

export type GetProjectsAliasError = {
  code: string;
  message: string;
};

export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyType = {
  EndsWith: "endsWith",
  StartsWith: "startsWith",
  Equals: "equals",
} as const;
export type GetProjectsProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type GetProjectsBranchMatcher = {
  type: GetProjectsProjectsResponse200ApplicationJSONResponseBodyType;
  pattern: string;
};

export type GetProjectsBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const GetProjectsChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type GetProjectsChecksConclusion = ClosedEnum<
  typeof GetProjectsChecksConclusion
>;

export const GetProjectsChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type GetProjectsChecksState = ClosedEnum<typeof GetProjectsChecksState>;

export type GetProjectsCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type GetProjectsOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const GetProjectsPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type GetProjectsPlan = ClosedEnum<typeof GetProjectsPlan>;

export const GetProjectsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type GetProjectsReadyState = ClosedEnum<typeof GetProjectsReadyState>;

export const GetProjectsReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type GetProjectsReadySubstate = ClosedEnum<
  typeof GetProjectsReadySubstate
>;

export const GetProjectsProjectsType = {
  Lambdas: "LAMBDAS",
} as const;
export type GetProjectsProjectsType = ClosedEnum<
  typeof GetProjectsProjectsType
>;

export type GetProjectsLatestDeployments = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: GetProjectsAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: GetProjectsBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<GetProjectsBuilds> | undefined;
  checksConclusion?: GetProjectsChecksConclusion | undefined;
  checksState?: GetProjectsChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: GetProjectsCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: GetProjectsOidcTokenClaims | undefined;
  plan: GetProjectsPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: GetProjectsReadyState;
  readySubstate?: GetProjectsReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: GetProjectsProjectsType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export const GetProjectsLinkProjectsResponseType = {
  Bitbucket: "bitbucket",
} as const;
export type GetProjectsLinkProjectsResponseType = ClosedEnum<
  typeof GetProjectsLinkProjectsResponseType
>;

export type GetProjectsLinkProjectsResponseDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type GetProjectsLink3 = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: GetProjectsLinkProjectsResponseType | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<GetProjectsLinkProjectsResponseDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const GetProjectsLinkProjectsType = {
  Gitlab: "gitlab",
} as const;
export type GetProjectsLinkProjectsType = ClosedEnum<
  typeof GetProjectsLinkProjectsType
>;

export type GetProjectsLinkProjectsDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type GetProjectsLink2 = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes. This is the id of the top level group that a namespace belongs to. Gitlab supports group nesting (up to 20 levels).
   */
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: GetProjectsLinkProjectsType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<GetProjectsLinkProjectsDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const GetProjectsLinkType = {
  Github: "github",
} as const;
export type GetProjectsLinkType = ClosedEnum<typeof GetProjectsLinkType>;

export type GetProjectsLinkDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type GetProjectsLink1 = {
  org?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes.
   */
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: GetProjectsLinkType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<GetProjectsLinkDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export type GetProjectsLink =
  | GetProjectsLink1
  | GetProjectsLink3
  | GetProjectsLink2;

/**
 * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
 */
export type GetProjectsGroup = {
  /**
   * A unique identifier for the group of microfrontends. All related microfrontend projects will share this group ID. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
   */
  id: string;
  /**
   * A human readable name for the microfrontends group. This will be used to display the microfrontends group in the UI.
   */
  slug: string;
};

export type GetProjectsMicrofrontends = {
  /**
   * Timestamp when the microfrontends settings were last updated.
   */
  updatedAt: number;
  /**
   * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
   */
  group: GetProjectsGroup;
  /**
   * Whether microfrontends are enabled for this project.
   */
  enabled: boolean;
  /**
   * Whether this project is the default application for the microfrontends group. The default application is the one that is used as the top level shell for the microfrontends group and hosts the other microfrontends.
   */
  isDefaultApp?: boolean | undefined;
  /**
   * A path that is used to take screenshots and as the default path in preview links when a domain for this microfrontend is shown in the UI.
   */
  defaultRoute?: string | undefined;
};

export const GetProjectsNodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
  Eight10X: "8.10.x",
} as const;
export type GetProjectsNodeVersion = ClosedEnum<typeof GetProjectsNodeVersion>;

export type GetProjectsPaths = {
  value: string;
};

export type GetProjectsOptionsAllowlist = {
  paths: Array<GetProjectsPaths>;
};

export type GetProjectsPasswordProtection = {};

export const GetProjectsFunctionDefaultMemoryType = {
  StandardLegacy: "standard_legacy",
  Standard: "standard",
  Performance: "performance",
} as const;
export type GetProjectsFunctionDefaultMemoryType = ClosedEnum<
  typeof GetProjectsFunctionDefaultMemoryType
>;

export type GetProjectsResourceConfig = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?: GetProjectsFunctionDefaultMemoryType | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

export const GetProjectsDeploymentType = {
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type GetProjectsDeploymentType = ClosedEnum<
  typeof GetProjectsDeploymentType
>;

export type GetProjectsSsoProtection = {
  deploymentType: GetProjectsDeploymentType;
};

export type GetProjectsProjectsAliasAssigned = number | boolean;

export type GetProjectsProjectsAliasError = {
  code: string;
  message: string;
};

export const GetProjectsProjectsResponse200ApplicationJSONType = {
  EndsWith: "endsWith",
  StartsWith: "startsWith",
  Equals: "equals",
} as const;
export type GetProjectsProjectsResponse200ApplicationJSONType = ClosedEnum<
  typeof GetProjectsProjectsResponse200ApplicationJSONType
>;

export type GetProjectsProjectsBranchMatcher = {
  type: GetProjectsProjectsResponse200ApplicationJSONType;
  pattern: string;
};

export type GetProjectsProjectsBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const GetProjectsProjectsChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type GetProjectsProjectsChecksConclusion = ClosedEnum<
  typeof GetProjectsProjectsChecksConclusion
>;

export const GetProjectsProjectsChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type GetProjectsProjectsChecksState = ClosedEnum<
  typeof GetProjectsProjectsChecksState
>;

export type GetProjectsProjectsCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type GetProjectsProjectsOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const GetProjectsProjectsPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type GetProjectsProjectsPlan = ClosedEnum<
  typeof GetProjectsProjectsPlan
>;

export const GetProjectsProjectsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type GetProjectsProjectsReadyState = ClosedEnum<
  typeof GetProjectsProjectsReadyState
>;

export const GetProjectsProjectsReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type GetProjectsProjectsReadySubstate = ClosedEnum<
  typeof GetProjectsProjectsReadySubstate
>;

export const GetProjectsProjectsResponseType = {
  Lambdas: "LAMBDAS",
} as const;
export type GetProjectsProjectsResponseType = ClosedEnum<
  typeof GetProjectsProjectsResponseType
>;

export type GetProjectsTargets = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: GetProjectsProjectsAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: GetProjectsProjectsBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<GetProjectsProjectsBuilds> | undefined;
  checksConclusion?: GetProjectsProjectsChecksConclusion | undefined;
  checksState?: GetProjectsProjectsChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: GetProjectsProjectsCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: GetProjectsProjectsOidcTokenClaims | undefined;
  plan: GetProjectsProjectsPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: GetProjectsProjectsReadyState;
  readySubstate?: GetProjectsProjectsReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: GetProjectsProjectsResponseType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export type GetProjectsPermissions = {
  accessGroup?: Array<ACLAction> | undefined;
  aliasGlobal?: Array<ACLAction> | undefined;
  analyticsSampling?: Array<ACLAction> | undefined;
  analyticsUsage?: Array<ACLAction> | undefined;
  auditLog?: Array<ACLAction> | undefined;
  billingAddress?: Array<ACLAction> | undefined;
  billingInformation?: Array<ACLAction> | undefined;
  billingInvoice?: Array<ACLAction> | undefined;
  billingInvoiceEmailRecipient?: Array<ACLAction> | undefined;
  billingInvoiceLanguage?: Array<ACLAction> | undefined;
  billingPlan?: Array<ACLAction> | undefined;
  billingPurchaseOrder?: Array<ACLAction> | undefined;
  billingTaxId?: Array<ACLAction> | undefined;
  blob?: Array<ACLAction> | undefined;
  budget?: Array<ACLAction> | undefined;
  cacheArtifact?: Array<ACLAction> | undefined;
  cacheArtifactUsageEvent?: Array<ACLAction> | undefined;
  codeChecks?: Array<ACLAction> | undefined;
  concurrentBuilds?: Array<ACLAction> | undefined;
  connect?: Array<ACLAction> | undefined;
  connectConfiguration?: Array<ACLAction> | undefined;
  domain?: Array<ACLAction> | undefined;
  domainAcceptDelegation?: Array<ACLAction> | undefined;
  domainAuthCodes?: Array<ACLAction> | undefined;
  domainCertificate?: Array<ACLAction> | undefined;
  domainCheckConfig?: Array<ACLAction> | undefined;
  domainMove?: Array<ACLAction> | undefined;
  domainPurchase?: Array<ACLAction> | undefined;
  domainRecord?: Array<ACLAction> | undefined;
  domainTransferIn?: Array<ACLAction> | undefined;
  event?: Array<ACLAction> | undefined;
  ownEvent?: Array<ACLAction> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<ACLAction> | undefined;
  fileUpload?: Array<ACLAction> | undefined;
  gitRepository?: Array<ACLAction> | undefined;
  ipBlocking?: Array<ACLAction> | undefined;
  integration?: Array<ACLAction> | undefined;
  integrationAccount?: Array<ACLAction> | undefined;
  integrationConfiguration?: Array<ACLAction> | undefined;
  integrationConfigurationTransfer?: Array<ACLAction> | undefined;
  integrationConfigurationProjects?: Array<ACLAction> | undefined;
  integrationVercelConfigurationOverride?: Array<ACLAction> | undefined;
  integrationConfigurationRole?: Array<ACLAction> | undefined;
  integrationResource?: Array<ACLAction> | undefined;
  integrationEvent?: Array<ACLAction> | undefined;
  integrationResourceSecrets?: Array<ACLAction> | undefined;
  integrationDeploymentAction?: Array<ACLAction> | undefined;
  marketplaceInstallationMember?: Array<ACLAction> | undefined;
  marketplaceBillingData?: Array<ACLAction> | undefined;
  marketplaceInvoice?: Array<ACLAction> | undefined;
  jobGlobal?: Array<ACLAction> | undefined;
  logDrain?: Array<ACLAction> | undefined;
  monitoring?: Array<ACLAction> | undefined;
  monitoringSettings?: Array<ACLAction> | undefined;
  monitoringQuery?: Array<ACLAction> | undefined;
  monitoringChart?: Array<ACLAction> | undefined;
  monitoringAlert?: Array<ACLAction> | undefined;
  notificationDeploymentFailed?: Array<ACLAction> | undefined;
  notificationDomainConfiguration?: Array<ACLAction> | undefined;
  notificationDomainExpire?: Array<ACLAction> | undefined;
  notificationDomainMoved?: Array<ACLAction> | undefined;
  notificationDomainPurchase?: Array<ACLAction> | undefined;
  notificationDomainRenewal?: Array<ACLAction> | undefined;
  notificationDomainTransfer?: Array<ACLAction> | undefined;
  notificationDomainUnverified?: Array<ACLAction> | undefined;
  notificationMonitoringAlert?: Array<ACLAction> | undefined;
  notificationPaymentFailed?: Array<ACLAction> | undefined;
  notificationUsageAlert?: Array<ACLAction> | undefined;
  notificationCustomerBudget?: Array<ACLAction> | undefined;
  notificationStatementOfReasons?: Array<ACLAction> | undefined;
  oauth2Connection?: Array<ACLAction> | undefined;
  openTelemetryEndpoint?: Array<ACLAction> | undefined;
  paymentMethod?: Array<ACLAction> | undefined;
  permissions?: Array<ACLAction> | undefined;
  postgres?: Array<ACLAction> | undefined;
  previewDeploymentSuffix?: Array<ACLAction> | undefined;
  proTrialOnboarding?: Array<ACLAction> | undefined;
  sharedEnvVars?: Array<ACLAction> | undefined;
  sharedEnvVarsProduction?: Array<ACLAction> | undefined;
  space?: Array<ACLAction> | undefined;
  spaceRun?: Array<ACLAction> | undefined;
  passwordProtectionInvoiceItem?: Array<ACLAction> | undefined;
  rateLimit?: Array<ACLAction> | undefined;
  redis?: Array<ACLAction> | undefined;
  repository?: Array<ACLAction> | undefined;
  remoteCaching?: Array<ACLAction> | undefined;
  samlConfig?: Array<ACLAction> | undefined;
  secret?: Array<ACLAction> | undefined;
  redisStoreTokenSet?: Array<ACLAction> | undefined;
  blobStoreTokenSet?: Array<ACLAction> | undefined;
  postgresStoreTokenSet?: Array<ACLAction> | undefined;
  integrationStoreTokenSet?: Array<ACLAction> | undefined;
  integrationResourceReplCommand?: Array<ACLAction> | undefined;
  storeTransfer?: Array<ACLAction> | undefined;
  supportCase?: Array<ACLAction> | undefined;
  supportCaseComment?: Array<ACLAction> | undefined;
  dataCacheBillingSettings?: Array<ACLAction> | undefined;
  team?: Array<ACLAction> | undefined;
  teamAccessRequest?: Array<ACLAction> | undefined;
  teamFellowMembership?: Array<ACLAction> | undefined;
  teamGitExclusivity?: Array<ACLAction> | undefined;
  teamInvite?: Array<ACLAction> | undefined;
  teamInviteCode?: Array<ACLAction> | undefined;
  teamJoin?: Array<ACLAction> | undefined;
  teamOwnMembership?: Array<ACLAction> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<ACLAction> | undefined;
  token?: Array<ACLAction> | undefined;
  usage?: Array<ACLAction> | undefined;
  usageCycle?: Array<ACLAction> | undefined;
  user?: Array<ACLAction> | undefined;
  userConnection?: Array<ACLAction> | undefined;
  vpcPeeringConnection?: Array<ACLAction> | undefined;
  webAnalyticsPlan?: Array<ACLAction> | undefined;
  webAuthn?: Array<ACLAction> | undefined;
  edgeConfig?: Array<ACLAction> | undefined;
  edgeConfigItem?: Array<ACLAction> | undefined;
  edgeConfigSchema?: Array<ACLAction> | undefined;
  edgeConfigToken?: Array<ACLAction> | undefined;
  webhook?: Array<ACLAction> | undefined;
  webhookEvent?: Array<ACLAction> | undefined;
  endpointVerification?: Array<ACLAction> | undefined;
  projectTransferIn?: Array<ACLAction> | undefined;
  oauth2Application?: Array<ACLAction> | undefined;
  aliasProject?: Array<ACLAction> | undefined;
  aliasProtectionBypass?: Array<ACLAction> | undefined;
  productionAliasProtectionBypass?: Array<ACLAction> | undefined;
  connectConfigurationLink?: Array<ACLAction> | undefined;
  dataCacheNamespace?: Array<ACLAction> | undefined;
  deployment?: Array<ACLAction> | undefined;
  deploymentCheck?: Array<ACLAction> | undefined;
  deploymentCheckPreview?: Array<ACLAction> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<ACLAction> | undefined;
  deploymentProductionGit?: Array<ACLAction> | undefined;
  deploymentPreview?: Array<ACLAction> | undefined;
  deploymentPrivate?: Array<ACLAction> | undefined;
  deploymentPromote?: Array<ACLAction> | undefined;
  deploymentRollback?: Array<ACLAction> | undefined;
  environments?: Array<ACLAction> | undefined;
  logs?: Array<ACLAction> | undefined;
  logsPreset?: Array<ACLAction> | undefined;
  passwordProtection?: Array<ACLAction> | undefined;
  optionsAllowlist?: Array<ACLAction> | undefined;
  job?: Array<ACLAction> | undefined;
  project?: Array<ACLAction> | undefined;
  projectAccessGroup?: Array<ACLAction> | undefined;
  projectAnalyticsSampling?: Array<ACLAction> | undefined;
  projectDeploymentHook?: Array<ACLAction> | undefined;
  projectDomain?: Array<ACLAction> | undefined;
  projectDomainMove?: Array<ACLAction> | undefined;
  projectDomainCheckConfig?: Array<ACLAction> | undefined;
  projectEnvVars?: Array<ACLAction> | undefined;
  projectEnvVarsProduction?: Array<ACLAction> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<ACLAction> | undefined;
  projectFlags?: Array<ACLAction> | undefined;
  projectId?: Array<ACLAction> | undefined;
  projectIntegrationConfiguration?: Array<ACLAction> | undefined;
  projectLink?: Array<ACLAction> | undefined;
  projectMember?: Array<ACLAction> | undefined;
  projectMonitoring?: Array<ACLAction> | undefined;
  projectPermissions?: Array<ACLAction> | undefined;
  projectProductionBranch?: Array<ACLAction> | undefined;
  projectTransfer?: Array<ACLAction> | undefined;
  projectTransferOut?: Array<ACLAction> | undefined;
  projectProtectionBypass?: Array<ACLAction> | undefined;
  projectUsage?: Array<ACLAction> | undefined;
  projectAnalyticsUsage?: Array<ACLAction> | undefined;
  projectSupportCase?: Array<ACLAction> | undefined;
  projectSupportCaseComment?: Array<ACLAction> | undefined;
  projectDeploymentExpiration?: Array<ACLAction> | undefined;
  projectTier?: Array<ACLAction> | undefined;
  seawallConfig?: Array<ACLAction> | undefined;
  skewProtection?: Array<ACLAction> | undefined;
  analytics?: Array<ACLAction> | undefined;
  trustedIps?: Array<ACLAction> | undefined;
  webAnalytics?: Array<ACLAction> | undefined;
  sharedEnvVarConnection?: Array<ACLAction> | undefined;
  sonar?: Array<ACLAction> | undefined;
};

export type GetProjectsLastRollbackTarget = {};

export const GetProjectsJobStatus = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Pending: "pending",
  InProgress: "in-progress",
} as const;
export type GetProjectsJobStatus = ClosedEnum<typeof GetProjectsJobStatus>;

export const GetProjectsProjectsResponse200Type = {
  Promote: "promote",
  Rollback: "rollback",
} as const;
export type GetProjectsProjectsResponse200Type = ClosedEnum<
  typeof GetProjectsProjectsResponse200Type
>;

export type GetProjectsLastAliasRequest = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: GetProjectsJobStatus;
  requestedAt: number;
  type: GetProjectsProjectsResponse200Type;
};

export const GetProjectsScope = {
  AutomationBypass: "automation-bypass",
} as const;
export type GetProjectsScope = ClosedEnum<typeof GetProjectsScope>;

export type GetProjectsProtectionBypass = {
  createdAt: number;
  createdBy: string;
  scope: GetProjectsScope;
};

export const GetProjectsTrustedIpsProjectsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type GetProjectsTrustedIpsProjectsDeploymentType = ClosedEnum<
  typeof GetProjectsTrustedIpsProjectsDeploymentType
>;

export type GetProjectsTrustedIps2 = {
  deploymentType: GetProjectsTrustedIpsProjectsDeploymentType;
};

export const GetProjectsTrustedIpsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type GetProjectsTrustedIpsDeploymentType = ClosedEnum<
  typeof GetProjectsTrustedIpsDeploymentType
>;

export type GetProjectsTrustedIpsAddresses = {
  value: string;
  note?: string | undefined;
};

export const GetProjectsTrustedIpsProtectionMode = {
  Additional: "additional",
  Exclusive: "exclusive",
} as const;
export type GetProjectsTrustedIpsProtectionMode = ClosedEnum<
  typeof GetProjectsTrustedIpsProtectionMode
>;

export type GetProjectsTrustedIps1 = {
  deploymentType: GetProjectsTrustedIpsDeploymentType;
  addresses: Array<GetProjectsTrustedIpsAddresses>;
  protectionMode: GetProjectsTrustedIpsProtectionMode;
};

export type GetProjectsTrustedIps =
  | GetProjectsTrustedIps2
  | GetProjectsTrustedIps1;

export type GetProjectsGitComments = {
  /**
   * Whether the Vercel bot should comment on PRs
   */
  onPullRequest: boolean;
  /**
   * Whether the Vercel bot should comment on commits
   */
  onCommit: boolean;
};

export type GetProjectsWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type GetProjectsSrc2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type GetProjectsSrc = GetProjectsSrc2 | string;

export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType =
  ClosedEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType
  >;

export type GetProjectsValue2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type GetProjectsValue = GetProjectsValue2 | string;

export type GetProjectsHas = {
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType;
  key?: string | undefined;
  value?: GetProjectsValue2 | string | undefined;
};

export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType =
  ClosedEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType
  >;

export type GetProjectsValueProjects2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type GetProjectsProjectsValue = GetProjectsValueProjects2 | string;

export type GetProjectsMissing = {
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType;
  key?: string | undefined;
  value?: GetProjectsValueProjects2 | string | undefined;
};

export const GetProjectsHandle = {
  Init: "init",
  Finalize: "finalize",
} as const;
export type GetProjectsHandle = ClosedEnum<typeof GetProjectsHandle>;

export const GetProjectsAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type GetProjectsAction = ClosedEnum<typeof GetProjectsAction>;

export const GetProjectsAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type GetProjectsAlgo = ClosedEnum<typeof GetProjectsAlgo>;

export type GetProjectsErl = {
  algo: GetProjectsAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
};

export type GetProjectsMitigate = {
  action: GetProjectsAction;
  ruleId: string;
  ttl?: number | undefined;
  erl?: GetProjectsErl | undefined;
};

export type GetProjectsFirewallRoutes = {
  src?: GetProjectsSrc2 | string | undefined;
  has?: Array<GetProjectsHas> | undefined;
  missing?: Array<GetProjectsMissing> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: GetProjectsHandle | undefined;
  mitigate?: GetProjectsMitigate | undefined;
};

export type GetProjectsSecurity = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<GetProjectsFirewallRoutes> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export const GetProjectsIssuerMode = {
  Team: "team",
  Global: "global",
} as const;
/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export type GetProjectsIssuerMode = ClosedEnum<typeof GetProjectsIssuerMode>;

export type GetProjectsOidcTokenConfig = {
  enabled: boolean;
  /**
   * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
   */
  issuerMode?: GetProjectsIssuerMode | undefined;
};

export const GetProjectsTier = {
  Standard: "standard",
  Advanced: "advanced",
  Critical: "critical",
} as const;
export type GetProjectsTier = ClosedEnum<typeof GetProjectsTier>;

export type GetProjectsProjects = {
  accountId: string;
  analytics?: GetProjectsAnalytics | undefined;
  speedInsights?: GetProjectsSpeedInsights | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: GetProjectsCrons | undefined;
  dataCache?: GetProjectsDataCache | undefined;
  deploymentExpiration?: GetProjectsDeploymentExpiration | null | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<GetProjectsEnv> | undefined;
  customEnvironments?: Array<GetProjectsCustomEnvironments> | undefined;
  framework?: GetProjectsFramework | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<GetProjectsIpBuckets> | undefined;
  latestDeployments?: Array<GetProjectsLatestDeployments> | undefined;
  link?: GetProjectsLink1 | GetProjectsLink3 | GetProjectsLink2 | undefined;
  microfrontends?: GetProjectsMicrofrontends | undefined;
  name: string;
  nodeVersion: GetProjectsNodeVersion;
  optionsAllowlist?: GetProjectsOptionsAllowlist | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?: GetProjectsPasswordProtection | null | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: GetProjectsResourceConfig | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: GetProjectsSsoProtection | null | undefined;
  targets?: { [k: string]: GetProjectsTargets } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: GetProjectsPermissions | undefined;
  lastRollbackTarget?: GetProjectsLastRollbackTarget | null | undefined;
  lastAliasRequest?: GetProjectsLastAliasRequest | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?: { [k: string]: GetProjectsProtectionBypass } | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?:
    | GetProjectsTrustedIps2
    | GetProjectsTrustedIps1
    | null
    | undefined;
  gitComments?: GetProjectsGitComments | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: GetProjectsWebAnalytics | undefined;
  security?: GetProjectsSecurity | undefined;
  oidcTokenConfig?: GetProjectsOidcTokenConfig | undefined;
  tier?: GetProjectsTier | undefined;
};

/**
 * The paginated list of projects
 */
export type GetProjectsResponseBody = {
  projects: Array<GetProjectsProjects>;
  /**
   * This object contains information related to the pagination of the current request, including the necessary parameters to get the next or previous page of data.
   */
  pagination: Pagination;
};

/** @internal */
export const GitForkProtection$inboundSchema: z.ZodNativeEnum<
  typeof GitForkProtection
> = z.nativeEnum(GitForkProtection);

/** @internal */
export const GitForkProtection$outboundSchema: z.ZodNativeEnum<
  typeof GitForkProtection
> = GitForkProtection$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitForkProtection$ {
  /** @deprecated use `GitForkProtection$inboundSchema` instead. */
  export const inboundSchema = GitForkProtection$inboundSchema;
  /** @deprecated use `GitForkProtection$outboundSchema` instead. */
  export const outboundSchema = GitForkProtection$outboundSchema;
}

/** @internal */
export const GetProjectsRequest$inboundSchema: z.ZodType<
  GetProjectsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  from: z.string().optional(),
  gitForkProtection: GitForkProtection$inboundSchema.optional(),
  limit: z.string().optional(),
  search: z.string().optional(),
  repo: z.string().optional(),
  repoId: z.string().optional(),
  repoUrl: z.string().optional(),
  excludeRepos: z.string().optional(),
  edgeConfigId: z.string().optional(),
  edgeConfigTokenId: z.string().optional(),
  deprecated: z.boolean().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetProjectsRequest$Outbound = {
  from?: string | undefined;
  gitForkProtection?: string | undefined;
  limit?: string | undefined;
  search?: string | undefined;
  repo?: string | undefined;
  repoId?: string | undefined;
  repoUrl?: string | undefined;
  excludeRepos?: string | undefined;
  edgeConfigId?: string | undefined;
  edgeConfigTokenId?: string | undefined;
  deprecated?: boolean | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetProjectsRequest$outboundSchema: z.ZodType<
  GetProjectsRequest$Outbound,
  z.ZodTypeDef,
  GetProjectsRequest
> = z.object({
  from: z.string().optional(),
  gitForkProtection: GitForkProtection$outboundSchema.optional(),
  limit: z.string().optional(),
  search: z.string().optional(),
  repo: z.string().optional(),
  repoId: z.string().optional(),
  repoUrl: z.string().optional(),
  excludeRepos: z.string().optional(),
  edgeConfigId: z.string().optional(),
  edgeConfigTokenId: z.string().optional(),
  deprecated: z.boolean().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsRequest$ {
  /** @deprecated use `GetProjectsRequest$inboundSchema` instead. */
  export const inboundSchema = GetProjectsRequest$inboundSchema;
  /** @deprecated use `GetProjectsRequest$outboundSchema` instead. */
  export const outboundSchema = GetProjectsRequest$outboundSchema;
  /** @deprecated use `GetProjectsRequest$Outbound` instead. */
  export type Outbound = GetProjectsRequest$Outbound;
}

/** @internal */
export const GetProjectsAnalytics$inboundSchema: z.ZodType<
  GetProjectsAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetProjectsAnalytics$Outbound = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

/** @internal */
export const GetProjectsAnalytics$outboundSchema: z.ZodType<
  GetProjectsAnalytics$Outbound,
  z.ZodTypeDef,
  GetProjectsAnalytics
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsAnalytics$ {
  /** @deprecated use `GetProjectsAnalytics$inboundSchema` instead. */
  export const inboundSchema = GetProjectsAnalytics$inboundSchema;
  /** @deprecated use `GetProjectsAnalytics$outboundSchema` instead. */
  export const outboundSchema = GetProjectsAnalytics$outboundSchema;
  /** @deprecated use `GetProjectsAnalytics$Outbound` instead. */
  export type Outbound = GetProjectsAnalytics$Outbound;
}

/** @internal */
export const GetProjectsSpeedInsights$inboundSchema: z.ZodType<
  GetProjectsSpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type GetProjectsSpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const GetProjectsSpeedInsights$outboundSchema: z.ZodType<
  GetProjectsSpeedInsights$Outbound,
  z.ZodTypeDef,
  GetProjectsSpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsSpeedInsights$ {
  /** @deprecated use `GetProjectsSpeedInsights$inboundSchema` instead. */
  export const inboundSchema = GetProjectsSpeedInsights$inboundSchema;
  /** @deprecated use `GetProjectsSpeedInsights$outboundSchema` instead. */
  export const outboundSchema = GetProjectsSpeedInsights$outboundSchema;
  /** @deprecated use `GetProjectsSpeedInsights$Outbound` instead. */
  export type Outbound = GetProjectsSpeedInsights$Outbound;
}

/** @internal */
export const GetProjectsDefinitions$inboundSchema: z.ZodType<
  GetProjectsDefinitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/** @internal */
export type GetProjectsDefinitions$Outbound = {
  host: string;
  path: string;
  schedule: string;
};

/** @internal */
export const GetProjectsDefinitions$outboundSchema: z.ZodType<
  GetProjectsDefinitions$Outbound,
  z.ZodTypeDef,
  GetProjectsDefinitions
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsDefinitions$ {
  /** @deprecated use `GetProjectsDefinitions$inboundSchema` instead. */
  export const inboundSchema = GetProjectsDefinitions$inboundSchema;
  /** @deprecated use `GetProjectsDefinitions$outboundSchema` instead. */
  export const outboundSchema = GetProjectsDefinitions$outboundSchema;
  /** @deprecated use `GetProjectsDefinitions$Outbound` instead. */
  export type Outbound = GetProjectsDefinitions$Outbound;
}

/** @internal */
export const GetProjectsCrons$inboundSchema: z.ZodType<
  GetProjectsCrons,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => GetProjectsDefinitions$inboundSchema)),
});

/** @internal */
export type GetProjectsCrons$Outbound = {
  enabledAt: number;
  disabledAt: number | null;
  updatedAt: number;
  deploymentId: string | null;
  definitions: Array<GetProjectsDefinitions$Outbound>;
};

/** @internal */
export const GetProjectsCrons$outboundSchema: z.ZodType<
  GetProjectsCrons$Outbound,
  z.ZodTypeDef,
  GetProjectsCrons
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => GetProjectsDefinitions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsCrons$ {
  /** @deprecated use `GetProjectsCrons$inboundSchema` instead. */
  export const inboundSchema = GetProjectsCrons$inboundSchema;
  /** @deprecated use `GetProjectsCrons$outboundSchema` instead. */
  export const outboundSchema = GetProjectsCrons$outboundSchema;
  /** @deprecated use `GetProjectsCrons$Outbound` instead. */
  export type Outbound = GetProjectsCrons$Outbound;
}

/** @internal */
export const GetProjectsDataCache$inboundSchema: z.ZodType<
  GetProjectsDataCache,
  z.ZodTypeDef,
  unknown
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/** @internal */
export type GetProjectsDataCache$Outbound = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

/** @internal */
export const GetProjectsDataCache$outboundSchema: z.ZodType<
  GetProjectsDataCache$Outbound,
  z.ZodTypeDef,
  GetProjectsDataCache
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsDataCache$ {
  /** @deprecated use `GetProjectsDataCache$inboundSchema` instead. */
  export const inboundSchema = GetProjectsDataCache$inboundSchema;
  /** @deprecated use `GetProjectsDataCache$outboundSchema` instead. */
  export const outboundSchema = GetProjectsDataCache$outboundSchema;
  /** @deprecated use `GetProjectsDataCache$Outbound` instead. */
  export type Outbound = GetProjectsDataCache$Outbound;
}

/** @internal */
export const GetProjectsDeploymentExpiration$inboundSchema: z.ZodType<
  GetProjectsDeploymentExpiration,
  z.ZodTypeDef,
  unknown
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/** @internal */
export type GetProjectsDeploymentExpiration$Outbound = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

/** @internal */
export const GetProjectsDeploymentExpiration$outboundSchema: z.ZodType<
  GetProjectsDeploymentExpiration$Outbound,
  z.ZodTypeDef,
  GetProjectsDeploymentExpiration
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsDeploymentExpiration$ {
  /** @deprecated use `GetProjectsDeploymentExpiration$inboundSchema` instead. */
  export const inboundSchema = GetProjectsDeploymentExpiration$inboundSchema;
  /** @deprecated use `GetProjectsDeploymentExpiration$outboundSchema` instead. */
  export const outboundSchema = GetProjectsDeploymentExpiration$outboundSchema;
  /** @deprecated use `GetProjectsDeploymentExpiration$Outbound` instead. */
  export type Outbound = GetProjectsDeploymentExpiration$Outbound;
}

/** @internal */
export const GetProjectsTarget2$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTarget2
> = z.nativeEnum(GetProjectsTarget2);

/** @internal */
export const GetProjectsTarget2$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTarget2
> = GetProjectsTarget2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTarget2$ {
  /** @deprecated use `GetProjectsTarget2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTarget2$inboundSchema;
  /** @deprecated use `GetProjectsTarget2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTarget2$outboundSchema;
}

/** @internal */
export const GetProjectsTarget1$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTarget1
> = z.nativeEnum(GetProjectsTarget1);

/** @internal */
export const GetProjectsTarget1$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTarget1
> = GetProjectsTarget1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTarget1$ {
  /** @deprecated use `GetProjectsTarget1$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTarget1$inboundSchema;
  /** @deprecated use `GetProjectsTarget1$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTarget1$outboundSchema;
}

/** @internal */
export const GetProjectsTarget$inboundSchema: z.ZodType<
  GetProjectsTarget,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(GetProjectsTarget1$inboundSchema),
  GetProjectsTarget2$inboundSchema,
]);

/** @internal */
export type GetProjectsTarget$Outbound = Array<string> | string;

/** @internal */
export const GetProjectsTarget$outboundSchema: z.ZodType<
  GetProjectsTarget$Outbound,
  z.ZodTypeDef,
  GetProjectsTarget
> = z.union([
  z.array(GetProjectsTarget1$outboundSchema),
  GetProjectsTarget2$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTarget$ {
  /** @deprecated use `GetProjectsTarget$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTarget$inboundSchema;
  /** @deprecated use `GetProjectsTarget$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTarget$outboundSchema;
  /** @deprecated use `GetProjectsTarget$Outbound` instead. */
  export type Outbound = GetProjectsTarget$Outbound;
}

/** @internal */
export const GetProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsType
> = z.nativeEnum(GetProjectsType);

/** @internal */
export const GetProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsType
> = GetProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsType$ {
  /** @deprecated use `GetProjectsType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsType$inboundSchema;
  /** @deprecated use `GetProjectsType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint15$inboundSchema: z.ZodType<
  GetProjectsContentHint15,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$inboundSchema,
  projectId: z.string(),
});

/** @internal */
export type GetProjectsContentHint15$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const GetProjectsContentHint15$outboundSchema: z.ZodType<
  GetProjectsContentHint15$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint15
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv15Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint15$ {
  /** @deprecated use `GetProjectsContentHint15$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint15$inboundSchema;
  /** @deprecated use `GetProjectsContentHint15$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint15$outboundSchema;
  /** @deprecated use `GetProjectsContentHint15$Outbound` instead. */
  export type Outbound = GetProjectsContentHint15$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint14$inboundSchema: z.ZodType<
  GetProjectsContentHint14,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type GetProjectsContentHint14$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const GetProjectsContentHint14$outboundSchema: z.ZodType<
  GetProjectsContentHint14$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint14
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv14Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint14$ {
  /** @deprecated use `GetProjectsContentHint14$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint14$inboundSchema;
  /** @deprecated use `GetProjectsContentHint14$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint14$outboundSchema;
  /** @deprecated use `GetProjectsContentHint14$Outbound` instead. */
  export type Outbound = GetProjectsContentHint14$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint13$inboundSchema: z.ZodType<
  GetProjectsContentHint13,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint13$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint13$outboundSchema: z.ZodType<
  GetProjectsContentHint13$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint13
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv13Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint13$ {
  /** @deprecated use `GetProjectsContentHint13$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint13$inboundSchema;
  /** @deprecated use `GetProjectsContentHint13$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint13$outboundSchema;
  /** @deprecated use `GetProjectsContentHint13$Outbound` instead. */
  export type Outbound = GetProjectsContentHint13$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint12$inboundSchema: z.ZodType<
  GetProjectsContentHint12,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint12$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint12$outboundSchema: z.ZodType<
  GetProjectsContentHint12$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint12
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv12Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint12$ {
  /** @deprecated use `GetProjectsContentHint12$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint12$inboundSchema;
  /** @deprecated use `GetProjectsContentHint12$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint12$outboundSchema;
  /** @deprecated use `GetProjectsContentHint12$Outbound` instead. */
  export type Outbound = GetProjectsContentHint12$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint11$inboundSchema: z.ZodType<
  GetProjectsContentHint11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint11$outboundSchema: z.ZodType<
  GetProjectsContentHint11$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint11
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv11Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint11$ {
  /** @deprecated use `GetProjectsContentHint11$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint11$inboundSchema;
  /** @deprecated use `GetProjectsContentHint11$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint11$outboundSchema;
  /** @deprecated use `GetProjectsContentHint11$Outbound` instead. */
  export type Outbound = GetProjectsContentHint11$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint10$inboundSchema: z.ZodType<
  GetProjectsContentHint10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint10$outboundSchema: z.ZodType<
  GetProjectsContentHint10$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint10
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv10Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint10$ {
  /** @deprecated use `GetProjectsContentHint10$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint10$inboundSchema;
  /** @deprecated use `GetProjectsContentHint10$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint10$outboundSchema;
  /** @deprecated use `GetProjectsContentHint10$Outbound` instead. */
  export type Outbound = GetProjectsContentHint10$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint9$inboundSchema: z.ZodType<
  GetProjectsContentHint9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint9$outboundSchema: z.ZodType<
  GetProjectsContentHint9$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint9
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnv9Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint9$ {
  /** @deprecated use `GetProjectsContentHint9$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint9$inboundSchema;
  /** @deprecated use `GetProjectsContentHint9$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint9$outboundSchema;
  /** @deprecated use `GetProjectsContentHint9$Outbound` instead. */
  export type Outbound = GetProjectsContentHint9$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint8$inboundSchema: z.ZodType<
  GetProjectsContentHint8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint8$outboundSchema: z.ZodType<
  GetProjectsContentHint8$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint8
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsEnvType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint8$ {
  /** @deprecated use `GetProjectsContentHint8$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint8$inboundSchema;
  /** @deprecated use `GetProjectsContentHint8$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint8$outboundSchema;
  /** @deprecated use `GetProjectsContentHint8$Outbound` instead. */
  export type Outbound = GetProjectsContentHint8$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint7$inboundSchema: z.ZodType<
  GetProjectsContentHint7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint7$outboundSchema: z.ZodType<
  GetProjectsContentHint7$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint7
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint7$ {
  /** @deprecated use `GetProjectsContentHint7$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint7$inboundSchema;
  /** @deprecated use `GetProjectsContentHint7$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint7$outboundSchema;
  /** @deprecated use `GetProjectsContentHint7$Outbound` instead. */
  export type Outbound = GetProjectsContentHint7$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint6$inboundSchema: z.ZodType<
  GetProjectsContentHint6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint6$outboundSchema: z.ZodType<
  GetProjectsContentHint6$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint6
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint6$ {
  /** @deprecated use `GetProjectsContentHint6$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint6$inboundSchema;
  /** @deprecated use `GetProjectsContentHint6$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint6$outboundSchema;
  /** @deprecated use `GetProjectsContentHint6$Outbound` instead. */
  export type Outbound = GetProjectsContentHint6$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONType
  > = z.nativeEnum(
    GetProjectsContentHintProjectsResponse200ApplicationJSONType,
  );

/** @internal */
export const GetProjectsContentHintProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsContentHintProjectsResponse200ApplicationJSONType
  > =
    GetProjectsContentHintProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint5$inboundSchema: z.ZodType<
  GetProjectsContentHint5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint5$outboundSchema: z.ZodType<
  GetProjectsContentHint5$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint5
> = z.object({
  type:
    GetProjectsContentHintProjectsResponse200ApplicationJSONType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint5$ {
  /** @deprecated use `GetProjectsContentHint5$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint5$inboundSchema;
  /** @deprecated use `GetProjectsContentHint5$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint5$outboundSchema;
  /** @deprecated use `GetProjectsContentHint5$Outbound` instead. */
  export type Outbound = GetProjectsContentHint5$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof GetProjectsContentHintProjectsResponse200Type> = z
    .nativeEnum(GetProjectsContentHintProjectsResponse200Type);

/** @internal */
export const GetProjectsContentHintProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsContentHintProjectsResponse200Type> =
    GetProjectsContentHintProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponse200Type$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponse200Type$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint4$inboundSchema: z.ZodType<
  GetProjectsContentHint4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetProjectsContentHintProjectsResponse200Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint4$outboundSchema: z.ZodType<
  GetProjectsContentHint4$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint4
> = z.object({
  type: GetProjectsContentHintProjectsResponse200Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint4$ {
  /** @deprecated use `GetProjectsContentHint4$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint4$inboundSchema;
  /** @deprecated use `GetProjectsContentHint4$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint4$outboundSchema;
  /** @deprecated use `GetProjectsContentHint4$Outbound` instead. */
  export type Outbound = GetProjectsContentHint4$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof GetProjectsContentHintProjectsResponseType> = z
    .nativeEnum(GetProjectsContentHintProjectsResponseType);

/** @internal */
export const GetProjectsContentHintProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsContentHintProjectsResponseType> =
    GetProjectsContentHintProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsResponseType$ {
  /** @deprecated use `GetProjectsContentHintProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsContentHintProjectsResponseType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsResponseType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint3$inboundSchema: z.ZodType<
  GetProjectsContentHint3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetProjectsContentHintProjectsResponseType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint3$outboundSchema: z.ZodType<
  GetProjectsContentHint3$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint3
> = z.object({
  type: GetProjectsContentHintProjectsResponseType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint3$ {
  /** @deprecated use `GetProjectsContentHint3$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint3$inboundSchema;
  /** @deprecated use `GetProjectsContentHint3$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint3$outboundSchema;
  /** @deprecated use `GetProjectsContentHint3$Outbound` instead. */
  export type Outbound = GetProjectsContentHint3$Outbound;
}

/** @internal */
export const GetProjectsContentHintProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsContentHintProjectsType
> = z.nativeEnum(GetProjectsContentHintProjectsType);

/** @internal */
export const GetProjectsContentHintProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsContentHintProjectsType
> = GetProjectsContentHintProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintProjectsType$ {
  /** @deprecated use `GetProjectsContentHintProjectsType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHintProjectsType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsContentHintProjectsType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint2$inboundSchema: z.ZodType<
  GetProjectsContentHint2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetProjectsContentHintProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint2$outboundSchema: z.ZodType<
  GetProjectsContentHint2$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint2
> = z.object({
  type: GetProjectsContentHintProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint2$ {
  /** @deprecated use `GetProjectsContentHint2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint2$inboundSchema;
  /** @deprecated use `GetProjectsContentHint2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint2$outboundSchema;
  /** @deprecated use `GetProjectsContentHint2$Outbound` instead. */
  export type Outbound = GetProjectsContentHint2$Outbound;
}

/** @internal */
export const GetProjectsContentHintType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsContentHintType
> = z.nativeEnum(GetProjectsContentHintType);

/** @internal */
export const GetProjectsContentHintType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsContentHintType
> = GetProjectsContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHintType$ {
  /** @deprecated use `GetProjectsContentHintType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHintType$inboundSchema;
  /** @deprecated use `GetProjectsContentHintType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHintType$outboundSchema;
}

/** @internal */
export const GetProjectsContentHint1$inboundSchema: z.ZodType<
  GetProjectsContentHint1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetProjectsContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type GetProjectsContentHint1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const GetProjectsContentHint1$outboundSchema: z.ZodType<
  GetProjectsContentHint1$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint1
> = z.object({
  type: GetProjectsContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint1$ {
  /** @deprecated use `GetProjectsContentHint1$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint1$inboundSchema;
  /** @deprecated use `GetProjectsContentHint1$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint1$outboundSchema;
  /** @deprecated use `GetProjectsContentHint1$Outbound` instead. */
  export type Outbound = GetProjectsContentHint1$Outbound;
}

/** @internal */
export const GetProjectsContentHint$inboundSchema: z.ZodType<
  GetProjectsContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetProjectsContentHint1$inboundSchema),
  z.lazy(() => GetProjectsContentHint2$inboundSchema),
  z.lazy(() => GetProjectsContentHint3$inboundSchema),
  z.lazy(() => GetProjectsContentHint4$inboundSchema),
  z.lazy(() => GetProjectsContentHint5$inboundSchema),
  z.lazy(() => GetProjectsContentHint6$inboundSchema),
  z.lazy(() => GetProjectsContentHint7$inboundSchema),
  z.lazy(() => GetProjectsContentHint8$inboundSchema),
  z.lazy(() => GetProjectsContentHint9$inboundSchema),
  z.lazy(() => GetProjectsContentHint10$inboundSchema),
  z.lazy(() => GetProjectsContentHint11$inboundSchema),
  z.lazy(() => GetProjectsContentHint12$inboundSchema),
  z.lazy(() => GetProjectsContentHint13$inboundSchema),
  z.lazy(() => GetProjectsContentHint15$inboundSchema),
  z.lazy(() => GetProjectsContentHint14$inboundSchema),
]);

/** @internal */
export type GetProjectsContentHint$Outbound =
  | GetProjectsContentHint1$Outbound
  | GetProjectsContentHint2$Outbound
  | GetProjectsContentHint3$Outbound
  | GetProjectsContentHint4$Outbound
  | GetProjectsContentHint5$Outbound
  | GetProjectsContentHint6$Outbound
  | GetProjectsContentHint7$Outbound
  | GetProjectsContentHint8$Outbound
  | GetProjectsContentHint9$Outbound
  | GetProjectsContentHint10$Outbound
  | GetProjectsContentHint11$Outbound
  | GetProjectsContentHint12$Outbound
  | GetProjectsContentHint13$Outbound
  | GetProjectsContentHint15$Outbound
  | GetProjectsContentHint14$Outbound;

/** @internal */
export const GetProjectsContentHint$outboundSchema: z.ZodType<
  GetProjectsContentHint$Outbound,
  z.ZodTypeDef,
  GetProjectsContentHint
> = z.union([
  z.lazy(() => GetProjectsContentHint1$outboundSchema),
  z.lazy(() => GetProjectsContentHint2$outboundSchema),
  z.lazy(() => GetProjectsContentHint3$outboundSchema),
  z.lazy(() => GetProjectsContentHint4$outboundSchema),
  z.lazy(() => GetProjectsContentHint5$outboundSchema),
  z.lazy(() => GetProjectsContentHint6$outboundSchema),
  z.lazy(() => GetProjectsContentHint7$outboundSchema),
  z.lazy(() => GetProjectsContentHint8$outboundSchema),
  z.lazy(() => GetProjectsContentHint9$outboundSchema),
  z.lazy(() => GetProjectsContentHint10$outboundSchema),
  z.lazy(() => GetProjectsContentHint11$outboundSchema),
  z.lazy(() => GetProjectsContentHint12$outboundSchema),
  z.lazy(() => GetProjectsContentHint13$outboundSchema),
  z.lazy(() => GetProjectsContentHint15$outboundSchema),
  z.lazy(() => GetProjectsContentHint14$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsContentHint$ {
  /** @deprecated use `GetProjectsContentHint$inboundSchema` instead. */
  export const inboundSchema = GetProjectsContentHint$inboundSchema;
  /** @deprecated use `GetProjectsContentHint$outboundSchema` instead. */
  export const outboundSchema = GetProjectsContentHint$outboundSchema;
  /** @deprecated use `GetProjectsContentHint$Outbound` instead. */
  export type Outbound = GetProjectsContentHint$Outbound;
}

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType
  > = z.nativeEnum(
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType,
  );

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType
  > =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$ {
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema;
}

/** @internal */
export const GetProjectsInternalContentHint$inboundSchema: z.ZodType<
  GetProjectsInternalContentHint,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$inboundSchema,
  encryptedValue: z.string(),
});

/** @internal */
export type GetProjectsInternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const GetProjectsInternalContentHint$outboundSchema: z.ZodType<
  GetProjectsInternalContentHint$Outbound,
  z.ZodTypeDef,
  GetProjectsInternalContentHint
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsType$outboundSchema,
  encryptedValue: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsInternalContentHint$ {
  /** @deprecated use `GetProjectsInternalContentHint$inboundSchema` instead. */
  export const inboundSchema = GetProjectsInternalContentHint$inboundSchema;
  /** @deprecated use `GetProjectsInternalContentHint$outboundSchema` instead. */
  export const outboundSchema = GetProjectsInternalContentHint$outboundSchema;
  /** @deprecated use `GetProjectsInternalContentHint$Outbound` instead. */
  export type Outbound = GetProjectsInternalContentHint$Outbound;
}

/** @internal */
export const GetProjectsEnv$inboundSchema: z.ZodType<
  GetProjectsEnv,
  z.ZodTypeDef,
  unknown
> = z.object({
  target: z.union([
    z.array(GetProjectsTarget1$inboundSchema),
    GetProjectsTarget2$inboundSchema,
  ]).optional(),
  type: GetProjectsType$inboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => GetProjectsContentHint1$inboundSchema),
      z.lazy(() => GetProjectsContentHint2$inboundSchema),
      z.lazy(() => GetProjectsContentHint3$inboundSchema),
      z.lazy(() => GetProjectsContentHint4$inboundSchema),
      z.lazy(() => GetProjectsContentHint5$inboundSchema),
      z.lazy(() => GetProjectsContentHint6$inboundSchema),
      z.lazy(() => GetProjectsContentHint7$inboundSchema),
      z.lazy(() => GetProjectsContentHint8$inboundSchema),
      z.lazy(() => GetProjectsContentHint9$inboundSchema),
      z.lazy(() => GetProjectsContentHint10$inboundSchema),
      z.lazy(() => GetProjectsContentHint11$inboundSchema),
      z.lazy(() => GetProjectsContentHint12$inboundSchema),
      z.lazy(() => GetProjectsContentHint13$inboundSchema),
      z.lazy(() => GetProjectsContentHint15$inboundSchema),
      z.lazy(() => GetProjectsContentHint14$inboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => GetProjectsInternalContentHint$inboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
});

/** @internal */
export type GetProjectsEnv$Outbound = {
  target?: Array<string> | string | undefined;
  type: string;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | GetProjectsContentHint1$Outbound
    | GetProjectsContentHint2$Outbound
    | GetProjectsContentHint3$Outbound
    | GetProjectsContentHint4$Outbound
    | GetProjectsContentHint5$Outbound
    | GetProjectsContentHint6$Outbound
    | GetProjectsContentHint7$Outbound
    | GetProjectsContentHint8$Outbound
    | GetProjectsContentHint9$Outbound
    | GetProjectsContentHint10$Outbound
    | GetProjectsContentHint11$Outbound
    | GetProjectsContentHint12$Outbound
    | GetProjectsContentHint13$Outbound
    | GetProjectsContentHint15$Outbound
    | GetProjectsContentHint14$Outbound
    | null
    | undefined;
  internalContentHint?:
    | GetProjectsInternalContentHint$Outbound
    | null
    | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

/** @internal */
export const GetProjectsEnv$outboundSchema: z.ZodType<
  GetProjectsEnv$Outbound,
  z.ZodTypeDef,
  GetProjectsEnv
> = z.object({
  target: z.union([
    z.array(GetProjectsTarget1$outboundSchema),
    GetProjectsTarget2$outboundSchema,
  ]).optional(),
  type: GetProjectsType$outboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => GetProjectsContentHint1$outboundSchema),
      z.lazy(() => GetProjectsContentHint2$outboundSchema),
      z.lazy(() => GetProjectsContentHint3$outboundSchema),
      z.lazy(() => GetProjectsContentHint4$outboundSchema),
      z.lazy(() => GetProjectsContentHint5$outboundSchema),
      z.lazy(() => GetProjectsContentHint6$outboundSchema),
      z.lazy(() => GetProjectsContentHint7$outboundSchema),
      z.lazy(() => GetProjectsContentHint8$outboundSchema),
      z.lazy(() => GetProjectsContentHint9$outboundSchema),
      z.lazy(() => GetProjectsContentHint10$outboundSchema),
      z.lazy(() => GetProjectsContentHint11$outboundSchema),
      z.lazy(() => GetProjectsContentHint12$outboundSchema),
      z.lazy(() => GetProjectsContentHint13$outboundSchema),
      z.lazy(() => GetProjectsContentHint15$outboundSchema),
      z.lazy(() => GetProjectsContentHint14$outboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => GetProjectsInternalContentHint$outboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsEnv$ {
  /** @deprecated use `GetProjectsEnv$inboundSchema` instead. */
  export const inboundSchema = GetProjectsEnv$inboundSchema;
  /** @deprecated use `GetProjectsEnv$outboundSchema` instead. */
  export const outboundSchema = GetProjectsEnv$outboundSchema;
  /** @deprecated use `GetProjectsEnv$Outbound` instead. */
  export type Outbound = GetProjectsEnv$Outbound;
}

/** @internal */
export const GetProjectsCustomEnvironments$inboundSchema: z.ZodType<
  GetProjectsCustomEnvironments,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type GetProjectsCustomEnvironments$Outbound = {};

/** @internal */
export const GetProjectsCustomEnvironments$outboundSchema: z.ZodType<
  GetProjectsCustomEnvironments$Outbound,
  z.ZodTypeDef,
  GetProjectsCustomEnvironments
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsCustomEnvironments$ {
  /** @deprecated use `GetProjectsCustomEnvironments$inboundSchema` instead. */
  export const inboundSchema = GetProjectsCustomEnvironments$inboundSchema;
  /** @deprecated use `GetProjectsCustomEnvironments$outboundSchema` instead. */
  export const outboundSchema = GetProjectsCustomEnvironments$outboundSchema;
  /** @deprecated use `GetProjectsCustomEnvironments$Outbound` instead. */
  export type Outbound = GetProjectsCustomEnvironments$Outbound;
}

/** @internal */
export const GetProjectsFramework$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsFramework
> = z.nativeEnum(GetProjectsFramework);

/** @internal */
export const GetProjectsFramework$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsFramework
> = GetProjectsFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsFramework$ {
  /** @deprecated use `GetProjectsFramework$inboundSchema` instead. */
  export const inboundSchema = GetProjectsFramework$inboundSchema;
  /** @deprecated use `GetProjectsFramework$outboundSchema` instead. */
  export const outboundSchema = GetProjectsFramework$outboundSchema;
}

/** @internal */
export const GetProjectsIpBuckets$inboundSchema: z.ZodType<
  GetProjectsIpBuckets,
  z.ZodTypeDef,
  unknown
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/** @internal */
export type GetProjectsIpBuckets$Outbound = {
  bucket: string;
  supportUntil?: number | undefined;
};

/** @internal */
export const GetProjectsIpBuckets$outboundSchema: z.ZodType<
  GetProjectsIpBuckets$Outbound,
  z.ZodTypeDef,
  GetProjectsIpBuckets
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsIpBuckets$ {
  /** @deprecated use `GetProjectsIpBuckets$inboundSchema` instead. */
  export const inboundSchema = GetProjectsIpBuckets$inboundSchema;
  /** @deprecated use `GetProjectsIpBuckets$outboundSchema` instead. */
  export const outboundSchema = GetProjectsIpBuckets$outboundSchema;
  /** @deprecated use `GetProjectsIpBuckets$Outbound` instead. */
  export type Outbound = GetProjectsIpBuckets$Outbound;
}

/** @internal */
export const GetProjectsAliasAssigned$inboundSchema: z.ZodType<
  GetProjectsAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type GetProjectsAliasAssigned$Outbound = number | boolean;

/** @internal */
export const GetProjectsAliasAssigned$outboundSchema: z.ZodType<
  GetProjectsAliasAssigned$Outbound,
  z.ZodTypeDef,
  GetProjectsAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsAliasAssigned$ {
  /** @deprecated use `GetProjectsAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = GetProjectsAliasAssigned$inboundSchema;
  /** @deprecated use `GetProjectsAliasAssigned$outboundSchema` instead. */
  export const outboundSchema = GetProjectsAliasAssigned$outboundSchema;
  /** @deprecated use `GetProjectsAliasAssigned$Outbound` instead. */
  export type Outbound = GetProjectsAliasAssigned$Outbound;
}

/** @internal */
export const GetProjectsAliasError$inboundSchema: z.ZodType<
  GetProjectsAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type GetProjectsAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const GetProjectsAliasError$outboundSchema: z.ZodType<
  GetProjectsAliasError$Outbound,
  z.ZodTypeDef,
  GetProjectsAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsAliasError$ {
  /** @deprecated use `GetProjectsAliasError$inboundSchema` instead. */
  export const inboundSchema = GetProjectsAliasError$inboundSchema;
  /** @deprecated use `GetProjectsAliasError$outboundSchema` instead. */
  export const outboundSchema = GetProjectsAliasError$outboundSchema;
  /** @deprecated use `GetProjectsAliasError$Outbound` instead. */
  export type Outbound = GetProjectsAliasError$Outbound;
}

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyType
  > =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const GetProjectsBranchMatcher$inboundSchema: z.ZodType<
  GetProjectsBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type GetProjectsBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const GetProjectsBranchMatcher$outboundSchema: z.ZodType<
  GetProjectsBranchMatcher$Outbound,
  z.ZodTypeDef,
  GetProjectsBranchMatcher
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsBranchMatcher$ {
  /** @deprecated use `GetProjectsBranchMatcher$inboundSchema` instead. */
  export const inboundSchema = GetProjectsBranchMatcher$inboundSchema;
  /** @deprecated use `GetProjectsBranchMatcher$outboundSchema` instead. */
  export const outboundSchema = GetProjectsBranchMatcher$outboundSchema;
  /** @deprecated use `GetProjectsBranchMatcher$Outbound` instead. */
  export type Outbound = GetProjectsBranchMatcher$Outbound;
}

/** @internal */
export const GetProjectsBuilds$inboundSchema: z.ZodType<
  GetProjectsBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type GetProjectsBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const GetProjectsBuilds$outboundSchema: z.ZodType<
  GetProjectsBuilds$Outbound,
  z.ZodTypeDef,
  GetProjectsBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsBuilds$ {
  /** @deprecated use `GetProjectsBuilds$inboundSchema` instead. */
  export const inboundSchema = GetProjectsBuilds$inboundSchema;
  /** @deprecated use `GetProjectsBuilds$outboundSchema` instead. */
  export const outboundSchema = GetProjectsBuilds$outboundSchema;
  /** @deprecated use `GetProjectsBuilds$Outbound` instead. */
  export type Outbound = GetProjectsBuilds$Outbound;
}

/** @internal */
export const GetProjectsChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsChecksConclusion
> = z.nativeEnum(GetProjectsChecksConclusion);

/** @internal */
export const GetProjectsChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsChecksConclusion
> = GetProjectsChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsChecksConclusion$ {
  /** @deprecated use `GetProjectsChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = GetProjectsChecksConclusion$inboundSchema;
  /** @deprecated use `GetProjectsChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = GetProjectsChecksConclusion$outboundSchema;
}

/** @internal */
export const GetProjectsChecksState$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsChecksState
> = z.nativeEnum(GetProjectsChecksState);

/** @internal */
export const GetProjectsChecksState$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsChecksState
> = GetProjectsChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsChecksState$ {
  /** @deprecated use `GetProjectsChecksState$inboundSchema` instead. */
  export const inboundSchema = GetProjectsChecksState$inboundSchema;
  /** @deprecated use `GetProjectsChecksState$outboundSchema` instead. */
  export const outboundSchema = GetProjectsChecksState$outboundSchema;
}

/** @internal */
export const GetProjectsCreator$inboundSchema: z.ZodType<
  GetProjectsCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type GetProjectsCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const GetProjectsCreator$outboundSchema: z.ZodType<
  GetProjectsCreator$Outbound,
  z.ZodTypeDef,
  GetProjectsCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsCreator$ {
  /** @deprecated use `GetProjectsCreator$inboundSchema` instead. */
  export const inboundSchema = GetProjectsCreator$inboundSchema;
  /** @deprecated use `GetProjectsCreator$outboundSchema` instead. */
  export const outboundSchema = GetProjectsCreator$outboundSchema;
  /** @deprecated use `GetProjectsCreator$Outbound` instead. */
  export type Outbound = GetProjectsCreator$Outbound;
}

/** @internal */
export const GetProjectsOidcTokenClaims$inboundSchema: z.ZodType<
  GetProjectsOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type GetProjectsOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const GetProjectsOidcTokenClaims$outboundSchema: z.ZodType<
  GetProjectsOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  GetProjectsOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsOidcTokenClaims$ {
  /** @deprecated use `GetProjectsOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = GetProjectsOidcTokenClaims$inboundSchema;
  /** @deprecated use `GetProjectsOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema = GetProjectsOidcTokenClaims$outboundSchema;
  /** @deprecated use `GetProjectsOidcTokenClaims$Outbound` instead. */
  export type Outbound = GetProjectsOidcTokenClaims$Outbound;
}

/** @internal */
export const GetProjectsPlan$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsPlan
> = z.nativeEnum(GetProjectsPlan);

/** @internal */
export const GetProjectsPlan$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsPlan
> = GetProjectsPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsPlan$ {
  /** @deprecated use `GetProjectsPlan$inboundSchema` instead. */
  export const inboundSchema = GetProjectsPlan$inboundSchema;
  /** @deprecated use `GetProjectsPlan$outboundSchema` instead. */
  export const outboundSchema = GetProjectsPlan$outboundSchema;
}

/** @internal */
export const GetProjectsReadyState$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsReadyState
> = z.nativeEnum(GetProjectsReadyState);

/** @internal */
export const GetProjectsReadyState$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsReadyState
> = GetProjectsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsReadyState$ {
  /** @deprecated use `GetProjectsReadyState$inboundSchema` instead. */
  export const inboundSchema = GetProjectsReadyState$inboundSchema;
  /** @deprecated use `GetProjectsReadyState$outboundSchema` instead. */
  export const outboundSchema = GetProjectsReadyState$outboundSchema;
}

/** @internal */
export const GetProjectsReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsReadySubstate
> = z.nativeEnum(GetProjectsReadySubstate);

/** @internal */
export const GetProjectsReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsReadySubstate
> = GetProjectsReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsReadySubstate$ {
  /** @deprecated use `GetProjectsReadySubstate$inboundSchema` instead. */
  export const inboundSchema = GetProjectsReadySubstate$inboundSchema;
  /** @deprecated use `GetProjectsReadySubstate$outboundSchema` instead. */
  export const outboundSchema = GetProjectsReadySubstate$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsType
> = z.nativeEnum(GetProjectsProjectsType);

/** @internal */
export const GetProjectsProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsType
> = GetProjectsProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsType$ {
  /** @deprecated use `GetProjectsProjectsType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsType$outboundSchema;
}

/** @internal */
export const GetProjectsLatestDeployments$inboundSchema: z.ZodType<
  GetProjectsLatestDeployments,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(z.lazy(() => GetProjectsAliasError$inboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => GetProjectsBranchMatcher$inboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => GetProjectsBuilds$inboundSchema)).optional(),
  checksConclusion: GetProjectsChecksConclusion$inboundSchema.optional(),
  checksState: GetProjectsChecksState$inboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => GetProjectsCreator$inboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() => GetProjectsOidcTokenClaims$inboundSchema)
    .optional(),
  plan: GetProjectsPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: GetProjectsReadyState$inboundSchema,
  readySubstate: GetProjectsReadySubstate$inboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: GetProjectsProjectsType$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type GetProjectsLatestDeployments$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: GetProjectsAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: GetProjectsBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<GetProjectsBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: GetProjectsCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: GetProjectsOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const GetProjectsLatestDeployments$outboundSchema: z.ZodType<
  GetProjectsLatestDeployments$Outbound,
  z.ZodTypeDef,
  GetProjectsLatestDeployments
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(z.lazy(() => GetProjectsAliasError$outboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => GetProjectsBranchMatcher$outboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => GetProjectsBuilds$outboundSchema)).optional(),
  checksConclusion: GetProjectsChecksConclusion$outboundSchema.optional(),
  checksState: GetProjectsChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => GetProjectsCreator$outboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() => GetProjectsOidcTokenClaims$outboundSchema)
    .optional(),
  plan: GetProjectsPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: GetProjectsReadyState$outboundSchema,
  readySubstate: GetProjectsReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: GetProjectsProjectsType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLatestDeployments$ {
  /** @deprecated use `GetProjectsLatestDeployments$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLatestDeployments$inboundSchema;
  /** @deprecated use `GetProjectsLatestDeployments$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLatestDeployments$outboundSchema;
  /** @deprecated use `GetProjectsLatestDeployments$Outbound` instead. */
  export type Outbound = GetProjectsLatestDeployments$Outbound;
}

/** @internal */
export const GetProjectsLinkProjectsResponseType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsLinkProjectsResponseType
> = z.nativeEnum(GetProjectsLinkProjectsResponseType);

/** @internal */
export const GetProjectsLinkProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsLinkProjectsResponseType> =
    GetProjectsLinkProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLinkProjectsResponseType$ {
  /** @deprecated use `GetProjectsLinkProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsLinkProjectsResponseType$inboundSchema;
  /** @deprecated use `GetProjectsLinkProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsLinkProjectsResponseType$outboundSchema;
}

/** @internal */
export const GetProjectsLinkProjectsResponseDeployHooks$inboundSchema:
  z.ZodType<GetProjectsLinkProjectsResponseDeployHooks, z.ZodTypeDef, unknown> =
    z.object({
      createdAt: z.number().optional(),
      id: z.string(),
      name: z.string(),
      ref: z.string(),
      url: z.string(),
    });

/** @internal */
export type GetProjectsLinkProjectsResponseDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const GetProjectsLinkProjectsResponseDeployHooks$outboundSchema:
  z.ZodType<
    GetProjectsLinkProjectsResponseDeployHooks$Outbound,
    z.ZodTypeDef,
    GetProjectsLinkProjectsResponseDeployHooks
  > = z.object({
    createdAt: z.number().optional(),
    id: z.string(),
    name: z.string(),
    ref: z.string(),
    url: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLinkProjectsResponseDeployHooks$ {
  /** @deprecated use `GetProjectsLinkProjectsResponseDeployHooks$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsLinkProjectsResponseDeployHooks$inboundSchema;
  /** @deprecated use `GetProjectsLinkProjectsResponseDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsLinkProjectsResponseDeployHooks$outboundSchema;
  /** @deprecated use `GetProjectsLinkProjectsResponseDeployHooks$Outbound` instead. */
  export type Outbound = GetProjectsLinkProjectsResponseDeployHooks$Outbound;
}

/** @internal */
export const GetProjectsLink3$inboundSchema: z.ZodType<
  GetProjectsLink3,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: GetProjectsLinkProjectsResponseType$inboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => GetProjectsLinkProjectsResponseDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type GetProjectsLink3$Outbound = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: string | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<GetProjectsLinkProjectsResponseDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const GetProjectsLink3$outboundSchema: z.ZodType<
  GetProjectsLink3$Outbound,
  z.ZodTypeDef,
  GetProjectsLink3
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: GetProjectsLinkProjectsResponseType$outboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => GetProjectsLinkProjectsResponseDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLink3$ {
  /** @deprecated use `GetProjectsLink3$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLink3$inboundSchema;
  /** @deprecated use `GetProjectsLink3$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLink3$outboundSchema;
  /** @deprecated use `GetProjectsLink3$Outbound` instead. */
  export type Outbound = GetProjectsLink3$Outbound;
}

/** @internal */
export const GetProjectsLinkProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsLinkProjectsType
> = z.nativeEnum(GetProjectsLinkProjectsType);

/** @internal */
export const GetProjectsLinkProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsLinkProjectsType
> = GetProjectsLinkProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLinkProjectsType$ {
  /** @deprecated use `GetProjectsLinkProjectsType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLinkProjectsType$inboundSchema;
  /** @deprecated use `GetProjectsLinkProjectsType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLinkProjectsType$outboundSchema;
}

/** @internal */
export const GetProjectsLinkProjectsDeployHooks$inboundSchema: z.ZodType<
  GetProjectsLinkProjectsDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type GetProjectsLinkProjectsDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const GetProjectsLinkProjectsDeployHooks$outboundSchema: z.ZodType<
  GetProjectsLinkProjectsDeployHooks$Outbound,
  z.ZodTypeDef,
  GetProjectsLinkProjectsDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLinkProjectsDeployHooks$ {
  /** @deprecated use `GetProjectsLinkProjectsDeployHooks$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLinkProjectsDeployHooks$inboundSchema;
  /** @deprecated use `GetProjectsLinkProjectsDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsLinkProjectsDeployHooks$outboundSchema;
  /** @deprecated use `GetProjectsLinkProjectsDeployHooks$Outbound` instead. */
  export type Outbound = GetProjectsLinkProjectsDeployHooks$Outbound;
}

/** @internal */
export const GetProjectsLink2$inboundSchema: z.ZodType<
  GetProjectsLink2,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: GetProjectsLinkProjectsType$inboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => GetProjectsLinkProjectsDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type GetProjectsLink2$Outbound = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<GetProjectsLinkProjectsDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const GetProjectsLink2$outboundSchema: z.ZodType<
  GetProjectsLink2$Outbound,
  z.ZodTypeDef,
  GetProjectsLink2
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: GetProjectsLinkProjectsType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => GetProjectsLinkProjectsDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLink2$ {
  /** @deprecated use `GetProjectsLink2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLink2$inboundSchema;
  /** @deprecated use `GetProjectsLink2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLink2$outboundSchema;
  /** @deprecated use `GetProjectsLink2$Outbound` instead. */
  export type Outbound = GetProjectsLink2$Outbound;
}

/** @internal */
export const GetProjectsLinkType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsLinkType
> = z.nativeEnum(GetProjectsLinkType);

/** @internal */
export const GetProjectsLinkType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsLinkType
> = GetProjectsLinkType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLinkType$ {
  /** @deprecated use `GetProjectsLinkType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLinkType$inboundSchema;
  /** @deprecated use `GetProjectsLinkType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLinkType$outboundSchema;
}

/** @internal */
export const GetProjectsLinkDeployHooks$inboundSchema: z.ZodType<
  GetProjectsLinkDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type GetProjectsLinkDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const GetProjectsLinkDeployHooks$outboundSchema: z.ZodType<
  GetProjectsLinkDeployHooks$Outbound,
  z.ZodTypeDef,
  GetProjectsLinkDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLinkDeployHooks$ {
  /** @deprecated use `GetProjectsLinkDeployHooks$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLinkDeployHooks$inboundSchema;
  /** @deprecated use `GetProjectsLinkDeployHooks$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLinkDeployHooks$outboundSchema;
  /** @deprecated use `GetProjectsLinkDeployHooks$Outbound` instead. */
  export type Outbound = GetProjectsLinkDeployHooks$Outbound;
}

/** @internal */
export const GetProjectsLink1$inboundSchema: z.ZodType<
  GetProjectsLink1,
  z.ZodTypeDef,
  unknown
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: GetProjectsLinkType$inboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(z.lazy(() => GetProjectsLinkDeployHooks$inboundSchema)),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type GetProjectsLink1$Outbound = {
  org?: string | undefined;
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<GetProjectsLinkDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const GetProjectsLink1$outboundSchema: z.ZodType<
  GetProjectsLink1$Outbound,
  z.ZodTypeDef,
  GetProjectsLink1
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: GetProjectsLinkType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(z.lazy(() => GetProjectsLinkDeployHooks$outboundSchema)),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLink1$ {
  /** @deprecated use `GetProjectsLink1$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLink1$inboundSchema;
  /** @deprecated use `GetProjectsLink1$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLink1$outboundSchema;
  /** @deprecated use `GetProjectsLink1$Outbound` instead. */
  export type Outbound = GetProjectsLink1$Outbound;
}

/** @internal */
export const GetProjectsLink$inboundSchema: z.ZodType<
  GetProjectsLink,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetProjectsLink1$inboundSchema),
  z.lazy(() => GetProjectsLink3$inboundSchema),
  z.lazy(() => GetProjectsLink2$inboundSchema),
]);

/** @internal */
export type GetProjectsLink$Outbound =
  | GetProjectsLink1$Outbound
  | GetProjectsLink3$Outbound
  | GetProjectsLink2$Outbound;

/** @internal */
export const GetProjectsLink$outboundSchema: z.ZodType<
  GetProjectsLink$Outbound,
  z.ZodTypeDef,
  GetProjectsLink
> = z.union([
  z.lazy(() => GetProjectsLink1$outboundSchema),
  z.lazy(() => GetProjectsLink3$outboundSchema),
  z.lazy(() => GetProjectsLink2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLink$ {
  /** @deprecated use `GetProjectsLink$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLink$inboundSchema;
  /** @deprecated use `GetProjectsLink$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLink$outboundSchema;
  /** @deprecated use `GetProjectsLink$Outbound` instead. */
  export type Outbound = GetProjectsLink$Outbound;
}

/** @internal */
export const GetProjectsGroup$inboundSchema: z.ZodType<
  GetProjectsGroup,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/** @internal */
export type GetProjectsGroup$Outbound = {
  id: string;
  slug: string;
};

/** @internal */
export const GetProjectsGroup$outboundSchema: z.ZodType<
  GetProjectsGroup$Outbound,
  z.ZodTypeDef,
  GetProjectsGroup
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsGroup$ {
  /** @deprecated use `GetProjectsGroup$inboundSchema` instead. */
  export const inboundSchema = GetProjectsGroup$inboundSchema;
  /** @deprecated use `GetProjectsGroup$outboundSchema` instead. */
  export const outboundSchema = GetProjectsGroup$outboundSchema;
  /** @deprecated use `GetProjectsGroup$Outbound` instead. */
  export type Outbound = GetProjectsGroup$Outbound;
}

/** @internal */
export const GetProjectsMicrofrontends$inboundSchema: z.ZodType<
  GetProjectsMicrofrontends,
  z.ZodTypeDef,
  unknown
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => GetProjectsGroup$inboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/** @internal */
export type GetProjectsMicrofrontends$Outbound = {
  updatedAt: number;
  group: GetProjectsGroup$Outbound;
  enabled: boolean;
  isDefaultApp?: boolean | undefined;
  defaultRoute?: string | undefined;
};

/** @internal */
export const GetProjectsMicrofrontends$outboundSchema: z.ZodType<
  GetProjectsMicrofrontends$Outbound,
  z.ZodTypeDef,
  GetProjectsMicrofrontends
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => GetProjectsGroup$outboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsMicrofrontends$ {
  /** @deprecated use `GetProjectsMicrofrontends$inboundSchema` instead. */
  export const inboundSchema = GetProjectsMicrofrontends$inboundSchema;
  /** @deprecated use `GetProjectsMicrofrontends$outboundSchema` instead. */
  export const outboundSchema = GetProjectsMicrofrontends$outboundSchema;
  /** @deprecated use `GetProjectsMicrofrontends$Outbound` instead. */
  export type Outbound = GetProjectsMicrofrontends$Outbound;
}

/** @internal */
export const GetProjectsNodeVersion$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsNodeVersion
> = z.nativeEnum(GetProjectsNodeVersion);

/** @internal */
export const GetProjectsNodeVersion$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsNodeVersion
> = GetProjectsNodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsNodeVersion$ {
  /** @deprecated use `GetProjectsNodeVersion$inboundSchema` instead. */
  export const inboundSchema = GetProjectsNodeVersion$inboundSchema;
  /** @deprecated use `GetProjectsNodeVersion$outboundSchema` instead. */
  export const outboundSchema = GetProjectsNodeVersion$outboundSchema;
}

/** @internal */
export const GetProjectsPaths$inboundSchema: z.ZodType<
  GetProjectsPaths,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
});

/** @internal */
export type GetProjectsPaths$Outbound = {
  value: string;
};

/** @internal */
export const GetProjectsPaths$outboundSchema: z.ZodType<
  GetProjectsPaths$Outbound,
  z.ZodTypeDef,
  GetProjectsPaths
> = z.object({
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsPaths$ {
  /** @deprecated use `GetProjectsPaths$inboundSchema` instead. */
  export const inboundSchema = GetProjectsPaths$inboundSchema;
  /** @deprecated use `GetProjectsPaths$outboundSchema` instead. */
  export const outboundSchema = GetProjectsPaths$outboundSchema;
  /** @deprecated use `GetProjectsPaths$Outbound` instead. */
  export type Outbound = GetProjectsPaths$Outbound;
}

/** @internal */
export const GetProjectsOptionsAllowlist$inboundSchema: z.ZodType<
  GetProjectsOptionsAllowlist,
  z.ZodTypeDef,
  unknown
> = z.object({
  paths: z.array(z.lazy(() => GetProjectsPaths$inboundSchema)),
});

/** @internal */
export type GetProjectsOptionsAllowlist$Outbound = {
  paths: Array<GetProjectsPaths$Outbound>;
};

/** @internal */
export const GetProjectsOptionsAllowlist$outboundSchema: z.ZodType<
  GetProjectsOptionsAllowlist$Outbound,
  z.ZodTypeDef,
  GetProjectsOptionsAllowlist
> = z.object({
  paths: z.array(z.lazy(() => GetProjectsPaths$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsOptionsAllowlist$ {
  /** @deprecated use `GetProjectsOptionsAllowlist$inboundSchema` instead. */
  export const inboundSchema = GetProjectsOptionsAllowlist$inboundSchema;
  /** @deprecated use `GetProjectsOptionsAllowlist$outboundSchema` instead. */
  export const outboundSchema = GetProjectsOptionsAllowlist$outboundSchema;
  /** @deprecated use `GetProjectsOptionsAllowlist$Outbound` instead. */
  export type Outbound = GetProjectsOptionsAllowlist$Outbound;
}

/** @internal */
export const GetProjectsPasswordProtection$inboundSchema: z.ZodType<
  GetProjectsPasswordProtection,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type GetProjectsPasswordProtection$Outbound = {};

/** @internal */
export const GetProjectsPasswordProtection$outboundSchema: z.ZodType<
  GetProjectsPasswordProtection$Outbound,
  z.ZodTypeDef,
  GetProjectsPasswordProtection
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsPasswordProtection$ {
  /** @deprecated use `GetProjectsPasswordProtection$inboundSchema` instead. */
  export const inboundSchema = GetProjectsPasswordProtection$inboundSchema;
  /** @deprecated use `GetProjectsPasswordProtection$outboundSchema` instead. */
  export const outboundSchema = GetProjectsPasswordProtection$outboundSchema;
  /** @deprecated use `GetProjectsPasswordProtection$Outbound` instead. */
  export type Outbound = GetProjectsPasswordProtection$Outbound;
}

/** @internal */
export const GetProjectsFunctionDefaultMemoryType$inboundSchema:
  z.ZodNativeEnum<typeof GetProjectsFunctionDefaultMemoryType> = z.nativeEnum(
    GetProjectsFunctionDefaultMemoryType,
  );

/** @internal */
export const GetProjectsFunctionDefaultMemoryType$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsFunctionDefaultMemoryType> =
    GetProjectsFunctionDefaultMemoryType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsFunctionDefaultMemoryType$ {
  /** @deprecated use `GetProjectsFunctionDefaultMemoryType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsFunctionDefaultMemoryType$inboundSchema;
  /** @deprecated use `GetProjectsFunctionDefaultMemoryType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsFunctionDefaultMemoryType$outboundSchema;
}

/** @internal */
export const GetProjectsResourceConfig$inboundSchema: z.ZodType<
  GetProjectsResourceConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType: GetProjectsFunctionDefaultMemoryType$inboundSchema
    .optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/** @internal */
export type GetProjectsResourceConfig$Outbound = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?: string | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

/** @internal */
export const GetProjectsResourceConfig$outboundSchema: z.ZodType<
  GetProjectsResourceConfig$Outbound,
  z.ZodTypeDef,
  GetProjectsResourceConfig
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType: GetProjectsFunctionDefaultMemoryType$outboundSchema
    .optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsResourceConfig$ {
  /** @deprecated use `GetProjectsResourceConfig$inboundSchema` instead. */
  export const inboundSchema = GetProjectsResourceConfig$inboundSchema;
  /** @deprecated use `GetProjectsResourceConfig$outboundSchema` instead. */
  export const outboundSchema = GetProjectsResourceConfig$outboundSchema;
  /** @deprecated use `GetProjectsResourceConfig$Outbound` instead. */
  export type Outbound = GetProjectsResourceConfig$Outbound;
}

/** @internal */
export const GetProjectsDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsDeploymentType
> = z.nativeEnum(GetProjectsDeploymentType);

/** @internal */
export const GetProjectsDeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsDeploymentType
> = GetProjectsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsDeploymentType$ {
  /** @deprecated use `GetProjectsDeploymentType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsDeploymentType$inboundSchema;
  /** @deprecated use `GetProjectsDeploymentType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsDeploymentType$outboundSchema;
}

/** @internal */
export const GetProjectsSsoProtection$inboundSchema: z.ZodType<
  GetProjectsSsoProtection,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: GetProjectsDeploymentType$inboundSchema,
});

/** @internal */
export type GetProjectsSsoProtection$Outbound = {
  deploymentType: string;
};

/** @internal */
export const GetProjectsSsoProtection$outboundSchema: z.ZodType<
  GetProjectsSsoProtection$Outbound,
  z.ZodTypeDef,
  GetProjectsSsoProtection
> = z.object({
  deploymentType: GetProjectsDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsSsoProtection$ {
  /** @deprecated use `GetProjectsSsoProtection$inboundSchema` instead. */
  export const inboundSchema = GetProjectsSsoProtection$inboundSchema;
  /** @deprecated use `GetProjectsSsoProtection$outboundSchema` instead. */
  export const outboundSchema = GetProjectsSsoProtection$outboundSchema;
  /** @deprecated use `GetProjectsSsoProtection$Outbound` instead. */
  export type Outbound = GetProjectsSsoProtection$Outbound;
}

/** @internal */
export const GetProjectsProjectsAliasAssigned$inboundSchema: z.ZodType<
  GetProjectsProjectsAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type GetProjectsProjectsAliasAssigned$Outbound = number | boolean;

/** @internal */
export const GetProjectsProjectsAliasAssigned$outboundSchema: z.ZodType<
  GetProjectsProjectsAliasAssigned$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsAliasAssigned$ {
  /** @deprecated use `GetProjectsProjectsAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsAliasAssigned$inboundSchema;
  /** @deprecated use `GetProjectsProjectsAliasAssigned$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsAliasAssigned$outboundSchema;
  /** @deprecated use `GetProjectsProjectsAliasAssigned$Outbound` instead. */
  export type Outbound = GetProjectsProjectsAliasAssigned$Outbound;
}

/** @internal */
export const GetProjectsProjectsAliasError$inboundSchema: z.ZodType<
  GetProjectsProjectsAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type GetProjectsProjectsAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const GetProjectsProjectsAliasError$outboundSchema: z.ZodType<
  GetProjectsProjectsAliasError$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsAliasError$ {
  /** @deprecated use `GetProjectsProjectsAliasError$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsAliasError$inboundSchema;
  /** @deprecated use `GetProjectsProjectsAliasError$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsAliasError$outboundSchema;
  /** @deprecated use `GetProjectsProjectsAliasError$Outbound` instead. */
  export type Outbound = GetProjectsProjectsAliasError$Outbound;
}

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<typeof GetProjectsProjectsResponse200ApplicationJSONType> = z
    .nativeEnum(GetProjectsProjectsResponse200ApplicationJSONType);

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsProjectsResponse200ApplicationJSONType> =
    GetProjectsProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsBranchMatcher$inboundSchema: z.ZodType<
  GetProjectsProjectsBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetProjectsProjectsResponse200ApplicationJSONType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type GetProjectsProjectsBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const GetProjectsProjectsBranchMatcher$outboundSchema: z.ZodType<
  GetProjectsProjectsBranchMatcher$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsBranchMatcher
> = z.object({
  type: GetProjectsProjectsResponse200ApplicationJSONType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsBranchMatcher$ {
  /** @deprecated use `GetProjectsProjectsBranchMatcher$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsBranchMatcher$inboundSchema;
  /** @deprecated use `GetProjectsProjectsBranchMatcher$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsBranchMatcher$outboundSchema;
  /** @deprecated use `GetProjectsProjectsBranchMatcher$Outbound` instead. */
  export type Outbound = GetProjectsProjectsBranchMatcher$Outbound;
}

/** @internal */
export const GetProjectsProjectsBuilds$inboundSchema: z.ZodType<
  GetProjectsProjectsBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type GetProjectsProjectsBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const GetProjectsProjectsBuilds$outboundSchema: z.ZodType<
  GetProjectsProjectsBuilds$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsBuilds$ {
  /** @deprecated use `GetProjectsProjectsBuilds$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsBuilds$inboundSchema;
  /** @deprecated use `GetProjectsProjectsBuilds$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsBuilds$outboundSchema;
  /** @deprecated use `GetProjectsProjectsBuilds$Outbound` instead. */
  export type Outbound = GetProjectsProjectsBuilds$Outbound;
}

/** @internal */
export const GetProjectsProjectsChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsChecksConclusion
> = z.nativeEnum(GetProjectsProjectsChecksConclusion);

/** @internal */
export const GetProjectsProjectsChecksConclusion$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsProjectsChecksConclusion> =
    GetProjectsProjectsChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsChecksConclusion$ {
  /** @deprecated use `GetProjectsProjectsChecksConclusion$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsProjectsChecksConclusion$inboundSchema;
  /** @deprecated use `GetProjectsProjectsChecksConclusion$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsChecksConclusion$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsChecksState$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsChecksState
> = z.nativeEnum(GetProjectsProjectsChecksState);

/** @internal */
export const GetProjectsProjectsChecksState$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsChecksState
> = GetProjectsProjectsChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsChecksState$ {
  /** @deprecated use `GetProjectsProjectsChecksState$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsChecksState$inboundSchema;
  /** @deprecated use `GetProjectsProjectsChecksState$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsChecksState$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsCreator$inboundSchema: z.ZodType<
  GetProjectsProjectsCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type GetProjectsProjectsCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const GetProjectsProjectsCreator$outboundSchema: z.ZodType<
  GetProjectsProjectsCreator$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsCreator$ {
  /** @deprecated use `GetProjectsProjectsCreator$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsCreator$inboundSchema;
  /** @deprecated use `GetProjectsProjectsCreator$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsCreator$outboundSchema;
  /** @deprecated use `GetProjectsProjectsCreator$Outbound` instead. */
  export type Outbound = GetProjectsProjectsCreator$Outbound;
}

/** @internal */
export const GetProjectsProjectsOidcTokenClaims$inboundSchema: z.ZodType<
  GetProjectsProjectsOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type GetProjectsProjectsOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const GetProjectsProjectsOidcTokenClaims$outboundSchema: z.ZodType<
  GetProjectsProjectsOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsOidcTokenClaims$ {
  /** @deprecated use `GetProjectsProjectsOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsOidcTokenClaims$inboundSchema;
  /** @deprecated use `GetProjectsProjectsOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsOidcTokenClaims$outboundSchema;
  /** @deprecated use `GetProjectsProjectsOidcTokenClaims$Outbound` instead. */
  export type Outbound = GetProjectsProjectsOidcTokenClaims$Outbound;
}

/** @internal */
export const GetProjectsProjectsPlan$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsPlan
> = z.nativeEnum(GetProjectsProjectsPlan);

/** @internal */
export const GetProjectsProjectsPlan$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsPlan
> = GetProjectsProjectsPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsPlan$ {
  /** @deprecated use `GetProjectsProjectsPlan$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsPlan$inboundSchema;
  /** @deprecated use `GetProjectsProjectsPlan$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsPlan$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsReadyState$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsReadyState
> = z.nativeEnum(GetProjectsProjectsReadyState);

/** @internal */
export const GetProjectsProjectsReadyState$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsReadyState
> = GetProjectsProjectsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsReadyState$ {
  /** @deprecated use `GetProjectsProjectsReadyState$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsReadyState$inboundSchema;
  /** @deprecated use `GetProjectsProjectsReadyState$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsReadyState$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsReadySubstate
> = z.nativeEnum(GetProjectsProjectsReadySubstate);

/** @internal */
export const GetProjectsProjectsReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsReadySubstate
> = GetProjectsProjectsReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsReadySubstate$ {
  /** @deprecated use `GetProjectsProjectsReadySubstate$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsReadySubstate$inboundSchema;
  /** @deprecated use `GetProjectsProjectsReadySubstate$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsReadySubstate$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsResponseType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsResponseType
> = z.nativeEnum(GetProjectsProjectsResponseType);

/** @internal */
export const GetProjectsProjectsResponseType$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsResponseType
> = GetProjectsProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponseType$ {
  /** @deprecated use `GetProjectsProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsResponseType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsResponseType$outboundSchema;
}

/** @internal */
export const GetProjectsTargets$inboundSchema: z.ZodType<
  GetProjectsTargets,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => GetProjectsProjectsAliasError$inboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => GetProjectsProjectsBranchMatcher$inboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => GetProjectsProjectsBuilds$inboundSchema))
    .optional(),
  checksConclusion: GetProjectsProjectsChecksConclusion$inboundSchema
    .optional(),
  checksState: GetProjectsProjectsChecksState$inboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => GetProjectsProjectsCreator$inboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    GetProjectsProjectsOidcTokenClaims$inboundSchema
  ).optional(),
  plan: GetProjectsProjectsPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: GetProjectsProjectsReadyState$inboundSchema,
  readySubstate: GetProjectsProjectsReadySubstate$inboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: GetProjectsProjectsResponseType$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type GetProjectsTargets$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: GetProjectsProjectsAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: GetProjectsProjectsBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<GetProjectsProjectsBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: GetProjectsProjectsCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: GetProjectsProjectsOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const GetProjectsTargets$outboundSchema: z.ZodType<
  GetProjectsTargets$Outbound,
  z.ZodTypeDef,
  GetProjectsTargets
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => GetProjectsProjectsAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => GetProjectsProjectsBranchMatcher$outboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => GetProjectsProjectsBuilds$outboundSchema))
    .optional(),
  checksConclusion: GetProjectsProjectsChecksConclusion$outboundSchema
    .optional(),
  checksState: GetProjectsProjectsChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => GetProjectsProjectsCreator$outboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    GetProjectsProjectsOidcTokenClaims$outboundSchema
  ).optional(),
  plan: GetProjectsProjectsPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: GetProjectsProjectsReadyState$outboundSchema,
  readySubstate: GetProjectsProjectsReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: GetProjectsProjectsResponseType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTargets$ {
  /** @deprecated use `GetProjectsTargets$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTargets$inboundSchema;
  /** @deprecated use `GetProjectsTargets$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTargets$outboundSchema;
  /** @deprecated use `GetProjectsTargets$Outbound` instead. */
  export type Outbound = GetProjectsTargets$Outbound;
}

/** @internal */
export const GetProjectsPermissions$inboundSchema: z.ZodType<
  GetProjectsPermissions,
  z.ZodTypeDef,
  unknown
> = z.object({
  accessGroup: z.array(ACLAction$inboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$inboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  auditLog: z.array(ACLAction$inboundSchema).optional(),
  billingAddress: z.array(ACLAction$inboundSchema).optional(),
  billingInformation: z.array(ACLAction$inboundSchema).optional(),
  billingInvoice: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$inboundSchema).optional(),
  billingPlan: z.array(ACLAction$inboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$inboundSchema).optional(),
  billingTaxId: z.array(ACLAction$inboundSchema).optional(),
  blob: z.array(ACLAction$inboundSchema).optional(),
  budget: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$inboundSchema).optional(),
  codeChecks: z.array(ACLAction$inboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$inboundSchema).optional(),
  connect: z.array(ACLAction$inboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$inboundSchema).optional(),
  domain: z.array(ACLAction$inboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$inboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$inboundSchema).optional(),
  domainCertificate: z.array(ACLAction$inboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  domainMove: z.array(ACLAction$inboundSchema).optional(),
  domainPurchase: z.array(ACLAction$inboundSchema).optional(),
  domainRecord: z.array(ACLAction$inboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$inboundSchema).optional(),
  event: z.array(ACLAction$inboundSchema).optional(),
  ownEvent: z.array(ACLAction$inboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$inboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$inboundSchema).optional(),
  gitRepository: z.array(ACLAction$inboundSchema).optional(),
  ipBlocking: z.array(ACLAction$inboundSchema).optional(),
  integration: z.array(ACLAction$inboundSchema).optional(),
  integrationAccount: z.array(ACLAction$inboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationProjects: z.array(ACLAction$inboundSchema).optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$inboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$inboundSchema).optional(),
  integrationResource: z.array(ACLAction$inboundSchema).optional(),
  integrationEvent: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$inboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$inboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$inboundSchema).optional(),
  jobGlobal: z.array(ACLAction$inboundSchema).optional(),
  logDrain: z.array(ACLAction$inboundSchema).optional(),
  Monitoring: z.array(ACLAction$inboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$inboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$inboundSchema).optional(),
  monitoringChart: z.array(ACLAction$inboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$inboundSchema).optional(),
  NotificationMonitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$inboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$inboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$inboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$inboundSchema).optional(),
  paymentMethod: z.array(ACLAction$inboundSchema).optional(),
  permissions: z.array(ACLAction$inboundSchema).optional(),
  postgres: z.array(ACLAction$inboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$inboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  space: z.array(ACLAction$inboundSchema).optional(),
  spaceRun: z.array(ACLAction$inboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$inboundSchema).optional(),
  rateLimit: z.array(ACLAction$inboundSchema).optional(),
  redis: z.array(ACLAction$inboundSchema).optional(),
  repository: z.array(ACLAction$inboundSchema).optional(),
  remoteCaching: z.array(ACLAction$inboundSchema).optional(),
  samlConfig: z.array(ACLAction$inboundSchema).optional(),
  secret: z.array(ACLAction$inboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$inboundSchema).optional(),
  storeTransfer: z.array(ACLAction$inboundSchema).optional(),
  supportCase: z.array(ACLAction$inboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$inboundSchema).optional(),
  team: z.array(ACLAction$inboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$inboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$inboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$inboundSchema).optional(),
  teamInvite: z.array(ACLAction$inboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$inboundSchema).optional(),
  teamJoin: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$inboundSchema).optional(),
  token: z.array(ACLAction$inboundSchema).optional(),
  usage: z.array(ACLAction$inboundSchema).optional(),
  usageCycle: z.array(ACLAction$inboundSchema).optional(),
  user: z.array(ACLAction$inboundSchema).optional(),
  userConnection: z.array(ACLAction$inboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$inboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$inboundSchema).optional(),
  webAuthn: z.array(ACLAction$inboundSchema).optional(),
  edgeConfig: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$inboundSchema).optional(),
  webhook: z.array(ACLAction$inboundSchema).optional(),
  "webhook-event": z.array(ACLAction$inboundSchema).optional(),
  endpointVerification: z.array(ACLAction$inboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$inboundSchema).optional(),
  oauth2Application: z.array(ACLAction$inboundSchema).optional(),
  aliasProject: z.array(ACLAction$inboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$inboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$inboundSchema).optional(),
  deployment: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$inboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$inboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$inboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$inboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$inboundSchema).optional(),
  environments: z.array(ACLAction$inboundSchema).optional(),
  logs: z.array(ACLAction$inboundSchema).optional(),
  logsPreset: z.array(ACLAction$inboundSchema).optional(),
  passwordProtection: z.array(ACLAction$inboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$inboundSchema).optional(),
  job: z.array(ACLAction$inboundSchema).optional(),
  project: z.array(ACLAction$inboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$inboundSchema).optional(),
  projectDomain: z.array(ACLAction$inboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$inboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$inboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$inboundSchema).optional(),
  projectId: z.array(ACLAction$inboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  projectLink: z.array(ACLAction$inboundSchema).optional(),
  projectMember: z.array(ACLAction$inboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$inboundSchema).optional(),
  projectPermissions: z.array(ACLAction$inboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$inboundSchema).optional(),
  projectTransfer: z.array(ACLAction$inboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$inboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  projectUsage: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$inboundSchema).optional(),
  projectTier: z.array(ACLAction$inboundSchema).optional(),
  seawallConfig: z.array(ACLAction$inboundSchema).optional(),
  skewProtection: z.array(ACLAction$inboundSchema).optional(),
  analytics: z.array(ACLAction$inboundSchema).optional(),
  trustedIps: z.array(ACLAction$inboundSchema).optional(),
  webAnalytics: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$inboundSchema).optional(),
  sonar: z.array(ACLAction$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "Monitoring": "monitoring",
    "NotificationMonitoringAlert": "notificationMonitoringAlert",
    "webhook-event": "webhookEvent",
  });
});

/** @internal */
export type GetProjectsPermissions$Outbound = {
  accessGroup?: Array<string> | undefined;
  aliasGlobal?: Array<string> | undefined;
  analyticsSampling?: Array<string> | undefined;
  analyticsUsage?: Array<string> | undefined;
  auditLog?: Array<string> | undefined;
  billingAddress?: Array<string> | undefined;
  billingInformation?: Array<string> | undefined;
  billingInvoice?: Array<string> | undefined;
  billingInvoiceEmailRecipient?: Array<string> | undefined;
  billingInvoiceLanguage?: Array<string> | undefined;
  billingPlan?: Array<string> | undefined;
  billingPurchaseOrder?: Array<string> | undefined;
  billingTaxId?: Array<string> | undefined;
  blob?: Array<string> | undefined;
  budget?: Array<string> | undefined;
  cacheArtifact?: Array<string> | undefined;
  cacheArtifactUsageEvent?: Array<string> | undefined;
  codeChecks?: Array<string> | undefined;
  concurrentBuilds?: Array<string> | undefined;
  connect?: Array<string> | undefined;
  connectConfiguration?: Array<string> | undefined;
  domain?: Array<string> | undefined;
  domainAcceptDelegation?: Array<string> | undefined;
  domainAuthCodes?: Array<string> | undefined;
  domainCertificate?: Array<string> | undefined;
  domainCheckConfig?: Array<string> | undefined;
  domainMove?: Array<string> | undefined;
  domainPurchase?: Array<string> | undefined;
  domainRecord?: Array<string> | undefined;
  domainTransferIn?: Array<string> | undefined;
  event?: Array<string> | undefined;
  ownEvent?: Array<string> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<string> | undefined;
  fileUpload?: Array<string> | undefined;
  gitRepository?: Array<string> | undefined;
  ipBlocking?: Array<string> | undefined;
  integration?: Array<string> | undefined;
  integrationAccount?: Array<string> | undefined;
  integrationConfiguration?: Array<string> | undefined;
  integrationConfigurationTransfer?: Array<string> | undefined;
  integrationConfigurationProjects?: Array<string> | undefined;
  integrationVercelConfigurationOverride?: Array<string> | undefined;
  integrationConfigurationRole?: Array<string> | undefined;
  integrationResource?: Array<string> | undefined;
  integrationEvent?: Array<string> | undefined;
  integrationResourceSecrets?: Array<string> | undefined;
  integrationDeploymentAction?: Array<string> | undefined;
  marketplaceInstallationMember?: Array<string> | undefined;
  marketplaceBillingData?: Array<string> | undefined;
  marketplaceInvoice?: Array<string> | undefined;
  jobGlobal?: Array<string> | undefined;
  logDrain?: Array<string> | undefined;
  Monitoring?: Array<string> | undefined;
  monitoringSettings?: Array<string> | undefined;
  monitoringQuery?: Array<string> | undefined;
  monitoringChart?: Array<string> | undefined;
  monitoringAlert?: Array<string> | undefined;
  notificationDeploymentFailed?: Array<string> | undefined;
  notificationDomainConfiguration?: Array<string> | undefined;
  notificationDomainExpire?: Array<string> | undefined;
  notificationDomainMoved?: Array<string> | undefined;
  notificationDomainPurchase?: Array<string> | undefined;
  notificationDomainRenewal?: Array<string> | undefined;
  notificationDomainTransfer?: Array<string> | undefined;
  notificationDomainUnverified?: Array<string> | undefined;
  NotificationMonitoringAlert?: Array<string> | undefined;
  notificationPaymentFailed?: Array<string> | undefined;
  notificationUsageAlert?: Array<string> | undefined;
  notificationCustomerBudget?: Array<string> | undefined;
  notificationStatementOfReasons?: Array<string> | undefined;
  oauth2Connection?: Array<string> | undefined;
  openTelemetryEndpoint?: Array<string> | undefined;
  paymentMethod?: Array<string> | undefined;
  permissions?: Array<string> | undefined;
  postgres?: Array<string> | undefined;
  previewDeploymentSuffix?: Array<string> | undefined;
  proTrialOnboarding?: Array<string> | undefined;
  sharedEnvVars?: Array<string> | undefined;
  sharedEnvVarsProduction?: Array<string> | undefined;
  space?: Array<string> | undefined;
  spaceRun?: Array<string> | undefined;
  passwordProtectionInvoiceItem?: Array<string> | undefined;
  rateLimit?: Array<string> | undefined;
  redis?: Array<string> | undefined;
  repository?: Array<string> | undefined;
  remoteCaching?: Array<string> | undefined;
  samlConfig?: Array<string> | undefined;
  secret?: Array<string> | undefined;
  redisStoreTokenSet?: Array<string> | undefined;
  blobStoreTokenSet?: Array<string> | undefined;
  postgresStoreTokenSet?: Array<string> | undefined;
  integrationStoreTokenSet?: Array<string> | undefined;
  integrationResourceReplCommand?: Array<string> | undefined;
  storeTransfer?: Array<string> | undefined;
  supportCase?: Array<string> | undefined;
  supportCaseComment?: Array<string> | undefined;
  dataCacheBillingSettings?: Array<string> | undefined;
  team?: Array<string> | undefined;
  teamAccessRequest?: Array<string> | undefined;
  teamFellowMembership?: Array<string> | undefined;
  teamGitExclusivity?: Array<string> | undefined;
  teamInvite?: Array<string> | undefined;
  teamInviteCode?: Array<string> | undefined;
  teamJoin?: Array<string> | undefined;
  teamOwnMembership?: Array<string> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<string> | undefined;
  token?: Array<string> | undefined;
  usage?: Array<string> | undefined;
  usageCycle?: Array<string> | undefined;
  user?: Array<string> | undefined;
  userConnection?: Array<string> | undefined;
  vpcPeeringConnection?: Array<string> | undefined;
  webAnalyticsPlan?: Array<string> | undefined;
  webAuthn?: Array<string> | undefined;
  edgeConfig?: Array<string> | undefined;
  edgeConfigItem?: Array<string> | undefined;
  edgeConfigSchema?: Array<string> | undefined;
  edgeConfigToken?: Array<string> | undefined;
  webhook?: Array<string> | undefined;
  "webhook-event"?: Array<string> | undefined;
  endpointVerification?: Array<string> | undefined;
  projectTransferIn?: Array<string> | undefined;
  oauth2Application?: Array<string> | undefined;
  aliasProject?: Array<string> | undefined;
  aliasProtectionBypass?: Array<string> | undefined;
  productionAliasProtectionBypass?: Array<string> | undefined;
  connectConfigurationLink?: Array<string> | undefined;
  dataCacheNamespace?: Array<string> | undefined;
  deployment?: Array<string> | undefined;
  deploymentCheck?: Array<string> | undefined;
  deploymentCheckPreview?: Array<string> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<string> | undefined;
  deploymentProductionGit?: Array<string> | undefined;
  deploymentPreview?: Array<string> | undefined;
  deploymentPrivate?: Array<string> | undefined;
  deploymentPromote?: Array<string> | undefined;
  deploymentRollback?: Array<string> | undefined;
  environments?: Array<string> | undefined;
  logs?: Array<string> | undefined;
  logsPreset?: Array<string> | undefined;
  passwordProtection?: Array<string> | undefined;
  optionsAllowlist?: Array<string> | undefined;
  job?: Array<string> | undefined;
  project?: Array<string> | undefined;
  projectAccessGroup?: Array<string> | undefined;
  projectAnalyticsSampling?: Array<string> | undefined;
  projectDeploymentHook?: Array<string> | undefined;
  projectDomain?: Array<string> | undefined;
  projectDomainMove?: Array<string> | undefined;
  projectDomainCheckConfig?: Array<string> | undefined;
  projectEnvVars?: Array<string> | undefined;
  projectEnvVarsProduction?: Array<string> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<string> | undefined;
  projectFlags?: Array<string> | undefined;
  projectId?: Array<string> | undefined;
  projectIntegrationConfiguration?: Array<string> | undefined;
  projectLink?: Array<string> | undefined;
  projectMember?: Array<string> | undefined;
  projectMonitoring?: Array<string> | undefined;
  projectPermissions?: Array<string> | undefined;
  projectProductionBranch?: Array<string> | undefined;
  projectTransfer?: Array<string> | undefined;
  projectTransferOut?: Array<string> | undefined;
  projectProtectionBypass?: Array<string> | undefined;
  projectUsage?: Array<string> | undefined;
  projectAnalyticsUsage?: Array<string> | undefined;
  projectSupportCase?: Array<string> | undefined;
  projectSupportCaseComment?: Array<string> | undefined;
  projectDeploymentExpiration?: Array<string> | undefined;
  projectTier?: Array<string> | undefined;
  seawallConfig?: Array<string> | undefined;
  skewProtection?: Array<string> | undefined;
  analytics?: Array<string> | undefined;
  trustedIps?: Array<string> | undefined;
  webAnalytics?: Array<string> | undefined;
  sharedEnvVarConnection?: Array<string> | undefined;
  sonar?: Array<string> | undefined;
};

/** @internal */
export const GetProjectsPermissions$outboundSchema: z.ZodType<
  GetProjectsPermissions$Outbound,
  z.ZodTypeDef,
  GetProjectsPermissions
> = z.object({
  accessGroup: z.array(ACLAction$outboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$outboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  auditLog: z.array(ACLAction$outboundSchema).optional(),
  billingAddress: z.array(ACLAction$outboundSchema).optional(),
  billingInformation: z.array(ACLAction$outboundSchema).optional(),
  billingInvoice: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$outboundSchema).optional(),
  billingPlan: z.array(ACLAction$outboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$outboundSchema).optional(),
  billingTaxId: z.array(ACLAction$outboundSchema).optional(),
  blob: z.array(ACLAction$outboundSchema).optional(),
  budget: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$outboundSchema).optional(),
  codeChecks: z.array(ACLAction$outboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$outboundSchema).optional(),
  connect: z.array(ACLAction$outboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$outboundSchema).optional(),
  domain: z.array(ACLAction$outboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$outboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$outboundSchema).optional(),
  domainCertificate: z.array(ACLAction$outboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  domainMove: z.array(ACLAction$outboundSchema).optional(),
  domainPurchase: z.array(ACLAction$outboundSchema).optional(),
  domainRecord: z.array(ACLAction$outboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$outboundSchema).optional(),
  event: z.array(ACLAction$outboundSchema).optional(),
  ownEvent: z.array(ACLAction$outboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$outboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$outboundSchema).optional(),
  gitRepository: z.array(ACLAction$outboundSchema).optional(),
  ipBlocking: z.array(ACLAction$outboundSchema).optional(),
  integration: z.array(ACLAction$outboundSchema).optional(),
  integrationAccount: z.array(ACLAction$outboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationProjects: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$outboundSchema).optional(),
  integrationResource: z.array(ACLAction$outboundSchema).optional(),
  integrationEvent: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$outboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$outboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$outboundSchema).optional(),
  jobGlobal: z.array(ACLAction$outboundSchema).optional(),
  logDrain: z.array(ACLAction$outboundSchema).optional(),
  monitoring: z.array(ACLAction$outboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$outboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$outboundSchema).optional(),
  monitoringChart: z.array(ACLAction$outboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$outboundSchema).optional(),
  notificationMonitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$outboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$outboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$outboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$outboundSchema).optional(),
  paymentMethod: z.array(ACLAction$outboundSchema).optional(),
  permissions: z.array(ACLAction$outboundSchema).optional(),
  postgres: z.array(ACLAction$outboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$outboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  space: z.array(ACLAction$outboundSchema).optional(),
  spaceRun: z.array(ACLAction$outboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$outboundSchema).optional(),
  rateLimit: z.array(ACLAction$outboundSchema).optional(),
  redis: z.array(ACLAction$outboundSchema).optional(),
  repository: z.array(ACLAction$outboundSchema).optional(),
  remoteCaching: z.array(ACLAction$outboundSchema).optional(),
  samlConfig: z.array(ACLAction$outboundSchema).optional(),
  secret: z.array(ACLAction$outboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$outboundSchema).optional(),
  storeTransfer: z.array(ACLAction$outboundSchema).optional(),
  supportCase: z.array(ACLAction$outboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$outboundSchema).optional(),
  team: z.array(ACLAction$outboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$outboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$outboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$outboundSchema).optional(),
  teamInvite: z.array(ACLAction$outboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$outboundSchema).optional(),
  teamJoin: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$outboundSchema).optional(),
  token: z.array(ACLAction$outboundSchema).optional(),
  usage: z.array(ACLAction$outboundSchema).optional(),
  usageCycle: z.array(ACLAction$outboundSchema).optional(),
  user: z.array(ACLAction$outboundSchema).optional(),
  userConnection: z.array(ACLAction$outboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$outboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$outboundSchema).optional(),
  webAuthn: z.array(ACLAction$outboundSchema).optional(),
  edgeConfig: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$outboundSchema).optional(),
  webhook: z.array(ACLAction$outboundSchema).optional(),
  webhookEvent: z.array(ACLAction$outboundSchema).optional(),
  endpointVerification: z.array(ACLAction$outboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$outboundSchema).optional(),
  oauth2Application: z.array(ACLAction$outboundSchema).optional(),
  aliasProject: z.array(ACLAction$outboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$outboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$outboundSchema).optional(),
  deployment: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$outboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$outboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$outboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$outboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$outboundSchema).optional(),
  environments: z.array(ACLAction$outboundSchema).optional(),
  logs: z.array(ACLAction$outboundSchema).optional(),
  logsPreset: z.array(ACLAction$outboundSchema).optional(),
  passwordProtection: z.array(ACLAction$outboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$outboundSchema).optional(),
  job: z.array(ACLAction$outboundSchema).optional(),
  project: z.array(ACLAction$outboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$outboundSchema).optional(),
  projectDomain: z.array(ACLAction$outboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$outboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$outboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$outboundSchema).optional(),
  projectId: z.array(ACLAction$outboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  projectLink: z.array(ACLAction$outboundSchema).optional(),
  projectMember: z.array(ACLAction$outboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$outboundSchema).optional(),
  projectPermissions: z.array(ACLAction$outboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$outboundSchema).optional(),
  projectTransfer: z.array(ACLAction$outboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$outboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  projectUsage: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$outboundSchema).optional(),
  projectTier: z.array(ACLAction$outboundSchema).optional(),
  seawallConfig: z.array(ACLAction$outboundSchema).optional(),
  skewProtection: z.array(ACLAction$outboundSchema).optional(),
  analytics: z.array(ACLAction$outboundSchema).optional(),
  trustedIps: z.array(ACLAction$outboundSchema).optional(),
  webAnalytics: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$outboundSchema).optional(),
  sonar: z.array(ACLAction$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    monitoring: "Monitoring",
    notificationMonitoringAlert: "NotificationMonitoringAlert",
    webhookEvent: "webhook-event",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsPermissions$ {
  /** @deprecated use `GetProjectsPermissions$inboundSchema` instead. */
  export const inboundSchema = GetProjectsPermissions$inboundSchema;
  /** @deprecated use `GetProjectsPermissions$outboundSchema` instead. */
  export const outboundSchema = GetProjectsPermissions$outboundSchema;
  /** @deprecated use `GetProjectsPermissions$Outbound` instead. */
  export type Outbound = GetProjectsPermissions$Outbound;
}

/** @internal */
export const GetProjectsLastRollbackTarget$inboundSchema: z.ZodType<
  GetProjectsLastRollbackTarget,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type GetProjectsLastRollbackTarget$Outbound = {};

/** @internal */
export const GetProjectsLastRollbackTarget$outboundSchema: z.ZodType<
  GetProjectsLastRollbackTarget$Outbound,
  z.ZodTypeDef,
  GetProjectsLastRollbackTarget
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLastRollbackTarget$ {
  /** @deprecated use `GetProjectsLastRollbackTarget$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLastRollbackTarget$inboundSchema;
  /** @deprecated use `GetProjectsLastRollbackTarget$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLastRollbackTarget$outboundSchema;
  /** @deprecated use `GetProjectsLastRollbackTarget$Outbound` instead. */
  export type Outbound = GetProjectsLastRollbackTarget$Outbound;
}

/** @internal */
export const GetProjectsJobStatus$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsJobStatus
> = z.nativeEnum(GetProjectsJobStatus);

/** @internal */
export const GetProjectsJobStatus$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsJobStatus
> = GetProjectsJobStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsJobStatus$ {
  /** @deprecated use `GetProjectsJobStatus$inboundSchema` instead. */
  export const inboundSchema = GetProjectsJobStatus$inboundSchema;
  /** @deprecated use `GetProjectsJobStatus$outboundSchema` instead. */
  export const outboundSchema = GetProjectsJobStatus$outboundSchema;
}

/** @internal */
export const GetProjectsProjectsResponse200Type$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsResponse200Type
> = z.nativeEnum(GetProjectsProjectsResponse200Type);

/** @internal */
export const GetProjectsProjectsResponse200Type$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsProjectsResponse200Type
> = GetProjectsProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponse200Type$ {
  /** @deprecated use `GetProjectsProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsResponse200Type$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const GetProjectsLastAliasRequest$inboundSchema: z.ZodType<
  GetProjectsLastAliasRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: GetProjectsJobStatus$inboundSchema,
  requestedAt: z.number(),
  type: GetProjectsProjectsResponse200Type$inboundSchema,
});

/** @internal */
export type GetProjectsLastAliasRequest$Outbound = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: string;
  requestedAt: number;
  type: string;
};

/** @internal */
export const GetProjectsLastAliasRequest$outboundSchema: z.ZodType<
  GetProjectsLastAliasRequest$Outbound,
  z.ZodTypeDef,
  GetProjectsLastAliasRequest
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: GetProjectsJobStatus$outboundSchema,
  requestedAt: z.number(),
  type: GetProjectsProjectsResponse200Type$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsLastAliasRequest$ {
  /** @deprecated use `GetProjectsLastAliasRequest$inboundSchema` instead. */
  export const inboundSchema = GetProjectsLastAliasRequest$inboundSchema;
  /** @deprecated use `GetProjectsLastAliasRequest$outboundSchema` instead. */
  export const outboundSchema = GetProjectsLastAliasRequest$outboundSchema;
  /** @deprecated use `GetProjectsLastAliasRequest$Outbound` instead. */
  export type Outbound = GetProjectsLastAliasRequest$Outbound;
}

/** @internal */
export const GetProjectsScope$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsScope
> = z.nativeEnum(GetProjectsScope);

/** @internal */
export const GetProjectsScope$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsScope
> = GetProjectsScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsScope$ {
  /** @deprecated use `GetProjectsScope$inboundSchema` instead. */
  export const inboundSchema = GetProjectsScope$inboundSchema;
  /** @deprecated use `GetProjectsScope$outboundSchema` instead. */
  export const outboundSchema = GetProjectsScope$outboundSchema;
}

/** @internal */
export const GetProjectsProtectionBypass$inboundSchema: z.ZodType<
  GetProjectsProtectionBypass,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: GetProjectsScope$inboundSchema,
});

/** @internal */
export type GetProjectsProtectionBypass$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const GetProjectsProtectionBypass$outboundSchema: z.ZodType<
  GetProjectsProtectionBypass$Outbound,
  z.ZodTypeDef,
  GetProjectsProtectionBypass
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: GetProjectsScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProtectionBypass$ {
  /** @deprecated use `GetProjectsProtectionBypass$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProtectionBypass$inboundSchema;
  /** @deprecated use `GetProjectsProtectionBypass$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProtectionBypass$outboundSchema;
  /** @deprecated use `GetProjectsProtectionBypass$Outbound` instead. */
  export type Outbound = GetProjectsProtectionBypass$Outbound;
}

/** @internal */
export const GetProjectsTrustedIpsProjectsDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof GetProjectsTrustedIpsProjectsDeploymentType> = z
    .nativeEnum(GetProjectsTrustedIpsProjectsDeploymentType);

/** @internal */
export const GetProjectsTrustedIpsProjectsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsTrustedIpsProjectsDeploymentType> =
    GetProjectsTrustedIpsProjectsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIpsProjectsDeploymentType$ {
  /** @deprecated use `GetProjectsTrustedIpsProjectsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsTrustedIpsProjectsDeploymentType$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIpsProjectsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsTrustedIpsProjectsDeploymentType$outboundSchema;
}

/** @internal */
export const GetProjectsTrustedIps2$inboundSchema: z.ZodType<
  GetProjectsTrustedIps2,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: GetProjectsTrustedIpsProjectsDeploymentType$inboundSchema,
});

/** @internal */
export type GetProjectsTrustedIps2$Outbound = {
  deploymentType: string;
};

/** @internal */
export const GetProjectsTrustedIps2$outboundSchema: z.ZodType<
  GetProjectsTrustedIps2$Outbound,
  z.ZodTypeDef,
  GetProjectsTrustedIps2
> = z.object({
  deploymentType: GetProjectsTrustedIpsProjectsDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIps2$ {
  /** @deprecated use `GetProjectsTrustedIps2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTrustedIps2$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIps2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTrustedIps2$outboundSchema;
  /** @deprecated use `GetProjectsTrustedIps2$Outbound` instead. */
  export type Outbound = GetProjectsTrustedIps2$Outbound;
}

/** @internal */
export const GetProjectsTrustedIpsDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTrustedIpsDeploymentType
> = z.nativeEnum(GetProjectsTrustedIpsDeploymentType);

/** @internal */
export const GetProjectsTrustedIpsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsTrustedIpsDeploymentType> =
    GetProjectsTrustedIpsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIpsDeploymentType$ {
  /** @deprecated use `GetProjectsTrustedIpsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsTrustedIpsDeploymentType$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIpsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsTrustedIpsDeploymentType$outboundSchema;
}

/** @internal */
export const GetProjectsTrustedIpsAddresses$inboundSchema: z.ZodType<
  GetProjectsTrustedIpsAddresses,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/** @internal */
export type GetProjectsTrustedIpsAddresses$Outbound = {
  value: string;
  note?: string | undefined;
};

/** @internal */
export const GetProjectsTrustedIpsAddresses$outboundSchema: z.ZodType<
  GetProjectsTrustedIpsAddresses$Outbound,
  z.ZodTypeDef,
  GetProjectsTrustedIpsAddresses
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIpsAddresses$ {
  /** @deprecated use `GetProjectsTrustedIpsAddresses$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTrustedIpsAddresses$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIpsAddresses$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTrustedIpsAddresses$outboundSchema;
  /** @deprecated use `GetProjectsTrustedIpsAddresses$Outbound` instead. */
  export type Outbound = GetProjectsTrustedIpsAddresses$Outbound;
}

/** @internal */
export const GetProjectsTrustedIpsProtectionMode$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTrustedIpsProtectionMode
> = z.nativeEnum(GetProjectsTrustedIpsProtectionMode);

/** @internal */
export const GetProjectsTrustedIpsProtectionMode$outboundSchema:
  z.ZodNativeEnum<typeof GetProjectsTrustedIpsProtectionMode> =
    GetProjectsTrustedIpsProtectionMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIpsProtectionMode$ {
  /** @deprecated use `GetProjectsTrustedIpsProtectionMode$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsTrustedIpsProtectionMode$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIpsProtectionMode$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsTrustedIpsProtectionMode$outboundSchema;
}

/** @internal */
export const GetProjectsTrustedIps1$inboundSchema: z.ZodType<
  GetProjectsTrustedIps1,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: GetProjectsTrustedIpsDeploymentType$inboundSchema,
  addresses: z.array(
    z.lazy(() => GetProjectsTrustedIpsAddresses$inboundSchema),
  ),
  protectionMode: GetProjectsTrustedIpsProtectionMode$inboundSchema,
});

/** @internal */
export type GetProjectsTrustedIps1$Outbound = {
  deploymentType: string;
  addresses: Array<GetProjectsTrustedIpsAddresses$Outbound>;
  protectionMode: string;
};

/** @internal */
export const GetProjectsTrustedIps1$outboundSchema: z.ZodType<
  GetProjectsTrustedIps1$Outbound,
  z.ZodTypeDef,
  GetProjectsTrustedIps1
> = z.object({
  deploymentType: GetProjectsTrustedIpsDeploymentType$outboundSchema,
  addresses: z.array(
    z.lazy(() => GetProjectsTrustedIpsAddresses$outboundSchema),
  ),
  protectionMode: GetProjectsTrustedIpsProtectionMode$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIps1$ {
  /** @deprecated use `GetProjectsTrustedIps1$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTrustedIps1$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIps1$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTrustedIps1$outboundSchema;
  /** @deprecated use `GetProjectsTrustedIps1$Outbound` instead. */
  export type Outbound = GetProjectsTrustedIps1$Outbound;
}

/** @internal */
export const GetProjectsTrustedIps$inboundSchema: z.ZodType<
  GetProjectsTrustedIps,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetProjectsTrustedIps2$inboundSchema),
  z.lazy(() => GetProjectsTrustedIps1$inboundSchema),
]);

/** @internal */
export type GetProjectsTrustedIps$Outbound =
  | GetProjectsTrustedIps2$Outbound
  | GetProjectsTrustedIps1$Outbound;

/** @internal */
export const GetProjectsTrustedIps$outboundSchema: z.ZodType<
  GetProjectsTrustedIps$Outbound,
  z.ZodTypeDef,
  GetProjectsTrustedIps
> = z.union([
  z.lazy(() => GetProjectsTrustedIps2$outboundSchema),
  z.lazy(() => GetProjectsTrustedIps1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTrustedIps$ {
  /** @deprecated use `GetProjectsTrustedIps$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTrustedIps$inboundSchema;
  /** @deprecated use `GetProjectsTrustedIps$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTrustedIps$outboundSchema;
  /** @deprecated use `GetProjectsTrustedIps$Outbound` instead. */
  export type Outbound = GetProjectsTrustedIps$Outbound;
}

/** @internal */
export const GetProjectsGitComments$inboundSchema: z.ZodType<
  GetProjectsGitComments,
  z.ZodTypeDef,
  unknown
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/** @internal */
export type GetProjectsGitComments$Outbound = {
  onPullRequest: boolean;
  onCommit: boolean;
};

/** @internal */
export const GetProjectsGitComments$outboundSchema: z.ZodType<
  GetProjectsGitComments$Outbound,
  z.ZodTypeDef,
  GetProjectsGitComments
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsGitComments$ {
  /** @deprecated use `GetProjectsGitComments$inboundSchema` instead. */
  export const inboundSchema = GetProjectsGitComments$inboundSchema;
  /** @deprecated use `GetProjectsGitComments$outboundSchema` instead. */
  export const outboundSchema = GetProjectsGitComments$outboundSchema;
  /** @deprecated use `GetProjectsGitComments$Outbound` instead. */
  export type Outbound = GetProjectsGitComments$Outbound;
}

/** @internal */
export const GetProjectsWebAnalytics$inboundSchema: z.ZodType<
  GetProjectsWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type GetProjectsWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const GetProjectsWebAnalytics$outboundSchema: z.ZodType<
  GetProjectsWebAnalytics$Outbound,
  z.ZodTypeDef,
  GetProjectsWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsWebAnalytics$ {
  /** @deprecated use `GetProjectsWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = GetProjectsWebAnalytics$inboundSchema;
  /** @deprecated use `GetProjectsWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = GetProjectsWebAnalytics$outboundSchema;
  /** @deprecated use `GetProjectsWebAnalytics$Outbound` instead. */
  export type Outbound = GetProjectsWebAnalytics$Outbound;
}

/** @internal */
export const GetProjectsSrc2$inboundSchema: z.ZodType<
  GetProjectsSrc2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type GetProjectsSrc2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const GetProjectsSrc2$outboundSchema: z.ZodType<
  GetProjectsSrc2$Outbound,
  z.ZodTypeDef,
  GetProjectsSrc2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsSrc2$ {
  /** @deprecated use `GetProjectsSrc2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsSrc2$inboundSchema;
  /** @deprecated use `GetProjectsSrc2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsSrc2$outboundSchema;
  /** @deprecated use `GetProjectsSrc2$Outbound` instead. */
  export type Outbound = GetProjectsSrc2$Outbound;
}

/** @internal */
export const GetProjectsSrc$inboundSchema: z.ZodType<
  GetProjectsSrc,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => GetProjectsSrc2$inboundSchema), z.string()]);

/** @internal */
export type GetProjectsSrc$Outbound = GetProjectsSrc2$Outbound | string;

/** @internal */
export const GetProjectsSrc$outboundSchema: z.ZodType<
  GetProjectsSrc$Outbound,
  z.ZodTypeDef,
  GetProjectsSrc
> = z.union([z.lazy(() => GetProjectsSrc2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsSrc$ {
  /** @deprecated use `GetProjectsSrc$inboundSchema` instead. */
  export const inboundSchema = GetProjectsSrc$inboundSchema;
  /** @deprecated use `GetProjectsSrc$outboundSchema` instead. */
  export const outboundSchema = GetProjectsSrc$outboundSchema;
  /** @deprecated use `GetProjectsSrc$Outbound` instead. */
  export type Outbound = GetProjectsSrc$Outbound;
}

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType
  > = z.nativeEnum(
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType,
  );

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType
  > =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$ {
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$outboundSchema;
}

/** @internal */
export const GetProjectsValue2$inboundSchema: z.ZodType<
  GetProjectsValue2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type GetProjectsValue2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const GetProjectsValue2$outboundSchema: z.ZodType<
  GetProjectsValue2$Outbound,
  z.ZodTypeDef,
  GetProjectsValue2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsValue2$ {
  /** @deprecated use `GetProjectsValue2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsValue2$inboundSchema;
  /** @deprecated use `GetProjectsValue2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsValue2$outboundSchema;
  /** @deprecated use `GetProjectsValue2$Outbound` instead. */
  export type Outbound = GetProjectsValue2$Outbound;
}

/** @internal */
export const GetProjectsValue$inboundSchema: z.ZodType<
  GetProjectsValue,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => GetProjectsValue2$inboundSchema), z.string()]);

/** @internal */
export type GetProjectsValue$Outbound = GetProjectsValue2$Outbound | string;

/** @internal */
export const GetProjectsValue$outboundSchema: z.ZodType<
  GetProjectsValue$Outbound,
  z.ZodTypeDef,
  GetProjectsValue
> = z.union([z.lazy(() => GetProjectsValue2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsValue$ {
  /** @deprecated use `GetProjectsValue$inboundSchema` instead. */
  export const inboundSchema = GetProjectsValue$inboundSchema;
  /** @deprecated use `GetProjectsValue$outboundSchema` instead. */
  export const outboundSchema = GetProjectsValue$outboundSchema;
  /** @deprecated use `GetProjectsValue$Outbound` instead. */
  export type Outbound = GetProjectsValue$Outbound;
}

/** @internal */
export const GetProjectsHas$inboundSchema: z.ZodType<
  GetProjectsHas,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$inboundSchema,
  key: z.string().optional(),
  value: z.union([z.lazy(() => GetProjectsValue2$inboundSchema), z.string()])
    .optional(),
});

/** @internal */
export type GetProjectsHas$Outbound = {
  type: string;
  key?: string | undefined;
  value?: GetProjectsValue2$Outbound | string | undefined;
};

/** @internal */
export const GetProjectsHas$outboundSchema: z.ZodType<
  GetProjectsHas$Outbound,
  z.ZodTypeDef,
  GetProjectsHas
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityType$outboundSchema,
  key: z.string().optional(),
  value: z.union([z.lazy(() => GetProjectsValue2$outboundSchema), z.string()])
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsHas$ {
  /** @deprecated use `GetProjectsHas$inboundSchema` instead. */
  export const inboundSchema = GetProjectsHas$inboundSchema;
  /** @deprecated use `GetProjectsHas$outboundSchema` instead. */
  export const outboundSchema = GetProjectsHas$outboundSchema;
  /** @deprecated use `GetProjectsHas$Outbound` instead. */
  export type Outbound = GetProjectsHas$Outbound;
}

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType
  > = z.nativeEnum(
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType,
  );

/** @internal */
export const GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType
  > =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$ {
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$inboundSchema` instead. */
  export const inboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$inboundSchema;
  /** @deprecated use `GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$outboundSchema` instead. */
  export const outboundSchema =
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$outboundSchema;
}

/** @internal */
export const GetProjectsValueProjects2$inboundSchema: z.ZodType<
  GetProjectsValueProjects2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type GetProjectsValueProjects2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const GetProjectsValueProjects2$outboundSchema: z.ZodType<
  GetProjectsValueProjects2$Outbound,
  z.ZodTypeDef,
  GetProjectsValueProjects2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsValueProjects2$ {
  /** @deprecated use `GetProjectsValueProjects2$inboundSchema` instead. */
  export const inboundSchema = GetProjectsValueProjects2$inboundSchema;
  /** @deprecated use `GetProjectsValueProjects2$outboundSchema` instead. */
  export const outboundSchema = GetProjectsValueProjects2$outboundSchema;
  /** @deprecated use `GetProjectsValueProjects2$Outbound` instead. */
  export type Outbound = GetProjectsValueProjects2$Outbound;
}

/** @internal */
export const GetProjectsProjectsValue$inboundSchema: z.ZodType<
  GetProjectsProjectsValue,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetProjectsValueProjects2$inboundSchema),
  z.string(),
]);

/** @internal */
export type GetProjectsProjectsValue$Outbound =
  | GetProjectsValueProjects2$Outbound
  | string;

/** @internal */
export const GetProjectsProjectsValue$outboundSchema: z.ZodType<
  GetProjectsProjectsValue$Outbound,
  z.ZodTypeDef,
  GetProjectsProjectsValue
> = z.union([
  z.lazy(() => GetProjectsValueProjects2$outboundSchema),
  z.string(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjectsValue$ {
  /** @deprecated use `GetProjectsProjectsValue$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjectsValue$inboundSchema;
  /** @deprecated use `GetProjectsProjectsValue$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjectsValue$outboundSchema;
  /** @deprecated use `GetProjectsProjectsValue$Outbound` instead. */
  export type Outbound = GetProjectsProjectsValue$Outbound;
}

/** @internal */
export const GetProjectsMissing$inboundSchema: z.ZodType<
  GetProjectsMissing,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$inboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => GetProjectsValueProjects2$inboundSchema),
    z.string(),
  ]).optional(),
});

/** @internal */
export type GetProjectsMissing$Outbound = {
  type: string;
  key?: string | undefined;
  value?: GetProjectsValueProjects2$Outbound | string | undefined;
};

/** @internal */
export const GetProjectsMissing$outboundSchema: z.ZodType<
  GetProjectsMissing$Outbound,
  z.ZodTypeDef,
  GetProjectsMissing
> = z.object({
  type:
    GetProjectsProjectsResponse200ApplicationJSONResponseBodyProjectsSecurityFirewallRoutesType$outboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => GetProjectsValueProjects2$outboundSchema),
    z.string(),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsMissing$ {
  /** @deprecated use `GetProjectsMissing$inboundSchema` instead. */
  export const inboundSchema = GetProjectsMissing$inboundSchema;
  /** @deprecated use `GetProjectsMissing$outboundSchema` instead. */
  export const outboundSchema = GetProjectsMissing$outboundSchema;
  /** @deprecated use `GetProjectsMissing$Outbound` instead. */
  export type Outbound = GetProjectsMissing$Outbound;
}

/** @internal */
export const GetProjectsHandle$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsHandle
> = z.nativeEnum(GetProjectsHandle);

/** @internal */
export const GetProjectsHandle$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsHandle
> = GetProjectsHandle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsHandle$ {
  /** @deprecated use `GetProjectsHandle$inboundSchema` instead. */
  export const inboundSchema = GetProjectsHandle$inboundSchema;
  /** @deprecated use `GetProjectsHandle$outboundSchema` instead. */
  export const outboundSchema = GetProjectsHandle$outboundSchema;
}

/** @internal */
export const GetProjectsAction$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsAction
> = z.nativeEnum(GetProjectsAction);

/** @internal */
export const GetProjectsAction$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsAction
> = GetProjectsAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsAction$ {
  /** @deprecated use `GetProjectsAction$inboundSchema` instead. */
  export const inboundSchema = GetProjectsAction$inboundSchema;
  /** @deprecated use `GetProjectsAction$outboundSchema` instead. */
  export const outboundSchema = GetProjectsAction$outboundSchema;
}

/** @internal */
export const GetProjectsAlgo$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsAlgo
> = z.nativeEnum(GetProjectsAlgo);

/** @internal */
export const GetProjectsAlgo$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsAlgo
> = GetProjectsAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsAlgo$ {
  /** @deprecated use `GetProjectsAlgo$inboundSchema` instead. */
  export const inboundSchema = GetProjectsAlgo$inboundSchema;
  /** @deprecated use `GetProjectsAlgo$outboundSchema` instead. */
  export const outboundSchema = GetProjectsAlgo$outboundSchema;
}

/** @internal */
export const GetProjectsErl$inboundSchema: z.ZodType<
  GetProjectsErl,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: GetProjectsAlgo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
});

/** @internal */
export type GetProjectsErl$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
};

/** @internal */
export const GetProjectsErl$outboundSchema: z.ZodType<
  GetProjectsErl$Outbound,
  z.ZodTypeDef,
  GetProjectsErl
> = z.object({
  algo: GetProjectsAlgo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsErl$ {
  /** @deprecated use `GetProjectsErl$inboundSchema` instead. */
  export const inboundSchema = GetProjectsErl$inboundSchema;
  /** @deprecated use `GetProjectsErl$outboundSchema` instead. */
  export const outboundSchema = GetProjectsErl$outboundSchema;
  /** @deprecated use `GetProjectsErl$Outbound` instead. */
  export type Outbound = GetProjectsErl$Outbound;
}

/** @internal */
export const GetProjectsMitigate$inboundSchema: z.ZodType<
  GetProjectsMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: GetProjectsAction$inboundSchema,
  rule_id: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => GetProjectsErl$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "rule_id": "ruleId",
  });
});

/** @internal */
export type GetProjectsMitigate$Outbound = {
  action: string;
  rule_id: string;
  ttl?: number | undefined;
  erl?: GetProjectsErl$Outbound | undefined;
};

/** @internal */
export const GetProjectsMitigate$outboundSchema: z.ZodType<
  GetProjectsMitigate$Outbound,
  z.ZodTypeDef,
  GetProjectsMitigate
> = z.object({
  action: GetProjectsAction$outboundSchema,
  ruleId: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => GetProjectsErl$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    ruleId: "rule_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsMitigate$ {
  /** @deprecated use `GetProjectsMitigate$inboundSchema` instead. */
  export const inboundSchema = GetProjectsMitigate$inboundSchema;
  /** @deprecated use `GetProjectsMitigate$outboundSchema` instead. */
  export const outboundSchema = GetProjectsMitigate$outboundSchema;
  /** @deprecated use `GetProjectsMitigate$Outbound` instead. */
  export type Outbound = GetProjectsMitigate$Outbound;
}

/** @internal */
export const GetProjectsFirewallRoutes$inboundSchema: z.ZodType<
  GetProjectsFirewallRoutes,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.union([z.lazy(() => GetProjectsSrc2$inboundSchema), z.string()])
    .optional(),
  has: z.array(z.lazy(() => GetProjectsHas$inboundSchema)).optional(),
  missing: z.array(z.lazy(() => GetProjectsMissing$inboundSchema)).optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: GetProjectsHandle$inboundSchema.optional(),
  mitigate: z.lazy(() => GetProjectsMitigate$inboundSchema).optional(),
});

/** @internal */
export type GetProjectsFirewallRoutes$Outbound = {
  src?: GetProjectsSrc2$Outbound | string | undefined;
  has?: Array<GetProjectsHas$Outbound> | undefined;
  missing?: Array<GetProjectsMissing$Outbound> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: string | undefined;
  mitigate?: GetProjectsMitigate$Outbound | undefined;
};

/** @internal */
export const GetProjectsFirewallRoutes$outboundSchema: z.ZodType<
  GetProjectsFirewallRoutes$Outbound,
  z.ZodTypeDef,
  GetProjectsFirewallRoutes
> = z.object({
  src: z.union([z.lazy(() => GetProjectsSrc2$outboundSchema), z.string()])
    .optional(),
  has: z.array(z.lazy(() => GetProjectsHas$outboundSchema)).optional(),
  missing: z.array(z.lazy(() => GetProjectsMissing$outboundSchema)).optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: GetProjectsHandle$outboundSchema.optional(),
  mitigate: z.lazy(() => GetProjectsMitigate$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsFirewallRoutes$ {
  /** @deprecated use `GetProjectsFirewallRoutes$inboundSchema` instead. */
  export const inboundSchema = GetProjectsFirewallRoutes$inboundSchema;
  /** @deprecated use `GetProjectsFirewallRoutes$outboundSchema` instead. */
  export const outboundSchema = GetProjectsFirewallRoutes$outboundSchema;
  /** @deprecated use `GetProjectsFirewallRoutes$Outbound` instead. */
  export type Outbound = GetProjectsFirewallRoutes$Outbound;
}

/** @internal */
export const GetProjectsSecurity$inboundSchema: z.ZodType<
  GetProjectsSecurity,
  z.ZodTypeDef,
  unknown
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(z.lazy(() => GetProjectsFirewallRoutes$inboundSchema))
    .optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/** @internal */
export type GetProjectsSecurity$Outbound = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<GetProjectsFirewallRoutes$Outbound> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/** @internal */
export const GetProjectsSecurity$outboundSchema: z.ZodType<
  GetProjectsSecurity$Outbound,
  z.ZodTypeDef,
  GetProjectsSecurity
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(
    z.lazy(() => GetProjectsFirewallRoutes$outboundSchema),
  ).optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsSecurity$ {
  /** @deprecated use `GetProjectsSecurity$inboundSchema` instead. */
  export const inboundSchema = GetProjectsSecurity$inboundSchema;
  /** @deprecated use `GetProjectsSecurity$outboundSchema` instead. */
  export const outboundSchema = GetProjectsSecurity$outboundSchema;
  /** @deprecated use `GetProjectsSecurity$Outbound` instead. */
  export type Outbound = GetProjectsSecurity$Outbound;
}

/** @internal */
export const GetProjectsIssuerMode$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsIssuerMode
> = z.nativeEnum(GetProjectsIssuerMode);

/** @internal */
export const GetProjectsIssuerMode$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsIssuerMode
> = GetProjectsIssuerMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsIssuerMode$ {
  /** @deprecated use `GetProjectsIssuerMode$inboundSchema` instead. */
  export const inboundSchema = GetProjectsIssuerMode$inboundSchema;
  /** @deprecated use `GetProjectsIssuerMode$outboundSchema` instead. */
  export const outboundSchema = GetProjectsIssuerMode$outboundSchema;
}

/** @internal */
export const GetProjectsOidcTokenConfig$inboundSchema: z.ZodType<
  GetProjectsOidcTokenConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean(),
  issuerMode: GetProjectsIssuerMode$inboundSchema.optional(),
});

/** @internal */
export type GetProjectsOidcTokenConfig$Outbound = {
  enabled: boolean;
  issuerMode?: string | undefined;
};

/** @internal */
export const GetProjectsOidcTokenConfig$outboundSchema: z.ZodType<
  GetProjectsOidcTokenConfig$Outbound,
  z.ZodTypeDef,
  GetProjectsOidcTokenConfig
> = z.object({
  enabled: z.boolean(),
  issuerMode: GetProjectsIssuerMode$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsOidcTokenConfig$ {
  /** @deprecated use `GetProjectsOidcTokenConfig$inboundSchema` instead. */
  export const inboundSchema = GetProjectsOidcTokenConfig$inboundSchema;
  /** @deprecated use `GetProjectsOidcTokenConfig$outboundSchema` instead. */
  export const outboundSchema = GetProjectsOidcTokenConfig$outboundSchema;
  /** @deprecated use `GetProjectsOidcTokenConfig$Outbound` instead. */
  export type Outbound = GetProjectsOidcTokenConfig$Outbound;
}

/** @internal */
export const GetProjectsTier$inboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTier
> = z.nativeEnum(GetProjectsTier);

/** @internal */
export const GetProjectsTier$outboundSchema: z.ZodNativeEnum<
  typeof GetProjectsTier
> = GetProjectsTier$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsTier$ {
  /** @deprecated use `GetProjectsTier$inboundSchema` instead. */
  export const inboundSchema = GetProjectsTier$inboundSchema;
  /** @deprecated use `GetProjectsTier$outboundSchema` instead. */
  export const outboundSchema = GetProjectsTier$outboundSchema;
}

/** @internal */
export const GetProjectsProjects$inboundSchema: z.ZodType<
  GetProjectsProjects,
  z.ZodTypeDef,
  unknown
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => GetProjectsAnalytics$inboundSchema).optional(),
  speedInsights: z.lazy(() => GetProjectsSpeedInsights$inboundSchema)
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => GetProjectsCrons$inboundSchema).optional(),
  dataCache: z.lazy(() => GetProjectsDataCache$inboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => GetProjectsDeploymentExpiration$inboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => GetProjectsEnv$inboundSchema)).optional(),
  customEnvironments: z.array(
    z.lazy(() => GetProjectsCustomEnvironments$inboundSchema),
  ).optional(),
  framework: z.nullable(GetProjectsFramework$inboundSchema).optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => GetProjectsIpBuckets$inboundSchema))
    .optional(),
  latestDeployments: z.array(
    z.lazy(() => GetProjectsLatestDeployments$inboundSchema),
  ).optional(),
  link: z.union([
    z.lazy(() => GetProjectsLink1$inboundSchema),
    z.lazy(() => GetProjectsLink3$inboundSchema),
    z.lazy(() => GetProjectsLink2$inboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => GetProjectsMicrofrontends$inboundSchema)
    .optional(),
  name: z.string(),
  nodeVersion: GetProjectsNodeVersion$inboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => GetProjectsOptionsAllowlist$inboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => GetProjectsPasswordProtection$inboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => GetProjectsResourceConfig$inboundSchema)
    .optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => GetProjectsSsoProtection$inboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => GetProjectsTargets$inboundSchema)).optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => GetProjectsPermissions$inboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => GetProjectsLastRollbackTarget$inboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(
    z.lazy(() => GetProjectsLastAliasRequest$inboundSchema),
  ).optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(
    z.lazy(() => GetProjectsProtectionBypass$inboundSchema),
  ).optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => GetProjectsTrustedIps2$inboundSchema),
      z.lazy(() => GetProjectsTrustedIps1$inboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => GetProjectsGitComments$inboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => GetProjectsWebAnalytics$inboundSchema).optional(),
  security: z.lazy(() => GetProjectsSecurity$inboundSchema).optional(),
  oidcTokenConfig: z.lazy(() => GetProjectsOidcTokenConfig$inboundSchema)
    .optional(),
  tier: GetProjectsTier$inboundSchema.optional(),
});

/** @internal */
export type GetProjectsProjects$Outbound = {
  accountId: string;
  analytics?: GetProjectsAnalytics$Outbound | undefined;
  speedInsights?: GetProjectsSpeedInsights$Outbound | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: GetProjectsCrons$Outbound | undefined;
  dataCache?: GetProjectsDataCache$Outbound | undefined;
  deploymentExpiration?:
    | GetProjectsDeploymentExpiration$Outbound
    | null
    | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<GetProjectsEnv$Outbound> | undefined;
  customEnvironments?:
    | Array<GetProjectsCustomEnvironments$Outbound>
    | undefined;
  framework?: string | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<GetProjectsIpBuckets$Outbound> | undefined;
  latestDeployments?: Array<GetProjectsLatestDeployments$Outbound> | undefined;
  link?:
    | GetProjectsLink1$Outbound
    | GetProjectsLink3$Outbound
    | GetProjectsLink2$Outbound
    | undefined;
  microfrontends?: GetProjectsMicrofrontends$Outbound | undefined;
  name: string;
  nodeVersion: string;
  optionsAllowlist?: GetProjectsOptionsAllowlist$Outbound | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?:
    | GetProjectsPasswordProtection$Outbound
    | null
    | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: GetProjectsResourceConfig$Outbound | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: GetProjectsSsoProtection$Outbound | null | undefined;
  targets?: { [k: string]: GetProjectsTargets$Outbound } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: GetProjectsPermissions$Outbound | undefined;
  lastRollbackTarget?:
    | GetProjectsLastRollbackTarget$Outbound
    | null
    | undefined;
  lastAliasRequest?: GetProjectsLastAliasRequest$Outbound | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?:
    | { [k: string]: GetProjectsProtectionBypass$Outbound }
    | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?:
    | GetProjectsTrustedIps2$Outbound
    | GetProjectsTrustedIps1$Outbound
    | null
    | undefined;
  gitComments?: GetProjectsGitComments$Outbound | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: GetProjectsWebAnalytics$Outbound | undefined;
  security?: GetProjectsSecurity$Outbound | undefined;
  oidcTokenConfig?: GetProjectsOidcTokenConfig$Outbound | undefined;
  tier?: string | undefined;
};

/** @internal */
export const GetProjectsProjects$outboundSchema: z.ZodType<
  GetProjectsProjects$Outbound,
  z.ZodTypeDef,
  GetProjectsProjects
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => GetProjectsAnalytics$outboundSchema).optional(),
  speedInsights: z.lazy(() => GetProjectsSpeedInsights$outboundSchema)
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => GetProjectsCrons$outboundSchema).optional(),
  dataCache: z.lazy(() => GetProjectsDataCache$outboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => GetProjectsDeploymentExpiration$outboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => GetProjectsEnv$outboundSchema)).optional(),
  customEnvironments: z.array(
    z.lazy(() => GetProjectsCustomEnvironments$outboundSchema),
  ).optional(),
  framework: z.nullable(GetProjectsFramework$outboundSchema).optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => GetProjectsIpBuckets$outboundSchema))
    .optional(),
  latestDeployments: z.array(
    z.lazy(() => GetProjectsLatestDeployments$outboundSchema),
  ).optional(),
  link: z.union([
    z.lazy(() => GetProjectsLink1$outboundSchema),
    z.lazy(() => GetProjectsLink3$outboundSchema),
    z.lazy(() => GetProjectsLink2$outboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => GetProjectsMicrofrontends$outboundSchema)
    .optional(),
  name: z.string(),
  nodeVersion: GetProjectsNodeVersion$outboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => GetProjectsOptionsAllowlist$outboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => GetProjectsPasswordProtection$outboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => GetProjectsResourceConfig$outboundSchema)
    .optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => GetProjectsSsoProtection$outboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => GetProjectsTargets$outboundSchema)).optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => GetProjectsPermissions$outboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => GetProjectsLastRollbackTarget$outboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(
    z.lazy(() => GetProjectsLastAliasRequest$outboundSchema),
  ).optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(
    z.lazy(() => GetProjectsProtectionBypass$outboundSchema),
  ).optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => GetProjectsTrustedIps2$outboundSchema),
      z.lazy(() => GetProjectsTrustedIps1$outboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => GetProjectsGitComments$outboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => GetProjectsWebAnalytics$outboundSchema).optional(),
  security: z.lazy(() => GetProjectsSecurity$outboundSchema).optional(),
  oidcTokenConfig: z.lazy(() => GetProjectsOidcTokenConfig$outboundSchema)
    .optional(),
  tier: GetProjectsTier$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsProjects$ {
  /** @deprecated use `GetProjectsProjects$inboundSchema` instead. */
  export const inboundSchema = GetProjectsProjects$inboundSchema;
  /** @deprecated use `GetProjectsProjects$outboundSchema` instead. */
  export const outboundSchema = GetProjectsProjects$outboundSchema;
  /** @deprecated use `GetProjectsProjects$Outbound` instead. */
  export type Outbound = GetProjectsProjects$Outbound;
}

/** @internal */
export const GetProjectsResponseBody$inboundSchema: z.ZodType<
  GetProjectsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  projects: z.array(z.lazy(() => GetProjectsProjects$inboundSchema)),
  pagination: Pagination$inboundSchema,
});

/** @internal */
export type GetProjectsResponseBody$Outbound = {
  projects: Array<GetProjectsProjects$Outbound>;
  pagination: Pagination$Outbound;
};

/** @internal */
export const GetProjectsResponseBody$outboundSchema: z.ZodType<
  GetProjectsResponseBody$Outbound,
  z.ZodTypeDef,
  GetProjectsResponseBody
> = z.object({
  projects: z.array(z.lazy(() => GetProjectsProjects$outboundSchema)),
  pagination: Pagination$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetProjectsResponseBody$ {
  /** @deprecated use `GetProjectsResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetProjectsResponseBody$inboundSchema;
  /** @deprecated use `GetProjectsResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetProjectsResponseBody$outboundSchema;
  /** @deprecated use `GetProjectsResponseBody$Outbound` instead. */
  export type Outbound = GetProjectsResponseBody$Outbound;
}
