/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type GetIntegrationLogDrainsRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * The delivery log format
 */
export const GetIntegrationLogDrainsDeliveryFormat = {
  Json: "json",
  Ndjson: "ndjson",
  Syslog: "syslog",
} as const;
/**
 * The delivery log format
 */
export type GetIntegrationLogDrainsDeliveryFormat = ClosedEnum<
  typeof GetIntegrationLogDrainsDeliveryFormat
>;

/**
 * The sources from which logs are currently being delivered to this log drain.
 */
export const GetIntegrationLogDrainsSources = {
  Build: "build",
  Edge: "edge",
  Lambda: "lambda",
  Static: "static",
  External: "external",
  Firewall: "firewall",
} as const;
/**
 * The sources from which logs are currently being delivered to this log drain.
 */
export type GetIntegrationLogDrainsSources = ClosedEnum<
  typeof GetIntegrationLogDrainsSources
>;

/**
 * Whether the log drain was created by an integration or by a user
 */
export const CreatedFrom = {
  SelfServed: "self-served",
  Integration: "integration",
} as const;
/**
 * Whether the log drain was created by an integration or by a user
 */
export type CreatedFrom = ClosedEnum<typeof CreatedFrom>;

/**
 * The environment of log drain
 */
export const GetIntegrationLogDrainsEnvironments = {
  Production: "production",
  Preview: "preview",
} as const;
/**
 * The environment of log drain
 */
export type GetIntegrationLogDrainsEnvironments = ClosedEnum<
  typeof GetIntegrationLogDrainsEnvironments
>;

export type GetIntegrationLogDrainsResponseBody = {
  /**
   * The oauth2 client application id that created this log drain
   */
  clientId?: string | undefined;
  /**
   * The client configuration this log drain was created with
   */
  configurationId?: string | undefined;
  /**
   * A timestamp that tells you when the log drain was created
   */
  createdAt: number;
  /**
   * The unique identifier of the log drain. Always prefixed with `ld_`
   */
  id: string;
  /**
   * The delivery log format
   */
  deliveryFormat?: GetIntegrationLogDrainsDeliveryFormat | undefined;
  /**
   * The name of the log drain
   */
  name: string;
  /**
   * The identifier of the team or user whose events will trigger the log drain
   */
  ownerId: string;
  projectId?: string | null | undefined;
  /**
   * The identifier of the projects this log drain is associated with
   */
  projectIds?: Array<string> | undefined;
  /**
   * The URL to call when logs are generated
   */
  url: string;
  /**
   * The sources from which logs are currently being delivered to this log drain.
   */
  sources?: Array<GetIntegrationLogDrainsSources> | undefined;
  /**
   * Whether the log drain was created by an integration or by a user
   */
  createdFrom?: CreatedFrom | undefined;
  /**
   * The headers to send with the request
   */
  headers?: { [k: string]: string } | undefined;
  /**
   * The environment of log drain
   */
  environments: Array<GetIntegrationLogDrainsEnvironments>;
  /**
   * The branch regexp of log drain
   */
  branch?: string | undefined;
  /**
   * The sampling rate of log drain
   */
  samplingRate?: number | undefined;
};

/** @internal */
export const GetIntegrationLogDrainsRequest$inboundSchema: z.ZodType<
  GetIntegrationLogDrainsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetIntegrationLogDrainsRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetIntegrationLogDrainsRequest$outboundSchema: z.ZodType<
  GetIntegrationLogDrainsRequest$Outbound,
  z.ZodTypeDef,
  GetIntegrationLogDrainsRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetIntegrationLogDrainsRequest$ {
  /** @deprecated use `GetIntegrationLogDrainsRequest$inboundSchema` instead. */
  export const inboundSchema = GetIntegrationLogDrainsRequest$inboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsRequest$outboundSchema` instead. */
  export const outboundSchema = GetIntegrationLogDrainsRequest$outboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsRequest$Outbound` instead. */
  export type Outbound = GetIntegrationLogDrainsRequest$Outbound;
}

/** @internal */
export const GetIntegrationLogDrainsDeliveryFormat$inboundSchema:
  z.ZodNativeEnum<typeof GetIntegrationLogDrainsDeliveryFormat> = z.nativeEnum(
    GetIntegrationLogDrainsDeliveryFormat,
  );

/** @internal */
export const GetIntegrationLogDrainsDeliveryFormat$outboundSchema:
  z.ZodNativeEnum<typeof GetIntegrationLogDrainsDeliveryFormat> =
    GetIntegrationLogDrainsDeliveryFormat$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetIntegrationLogDrainsDeliveryFormat$ {
  /** @deprecated use `GetIntegrationLogDrainsDeliveryFormat$inboundSchema` instead. */
  export const inboundSchema =
    GetIntegrationLogDrainsDeliveryFormat$inboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsDeliveryFormat$outboundSchema` instead. */
  export const outboundSchema =
    GetIntegrationLogDrainsDeliveryFormat$outboundSchema;
}

/** @internal */
export const GetIntegrationLogDrainsSources$inboundSchema: z.ZodNativeEnum<
  typeof GetIntegrationLogDrainsSources
> = z.nativeEnum(GetIntegrationLogDrainsSources);

/** @internal */
export const GetIntegrationLogDrainsSources$outboundSchema: z.ZodNativeEnum<
  typeof GetIntegrationLogDrainsSources
> = GetIntegrationLogDrainsSources$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetIntegrationLogDrainsSources$ {
  /** @deprecated use `GetIntegrationLogDrainsSources$inboundSchema` instead. */
  export const inboundSchema = GetIntegrationLogDrainsSources$inboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsSources$outboundSchema` instead. */
  export const outboundSchema = GetIntegrationLogDrainsSources$outboundSchema;
}

/** @internal */
export const CreatedFrom$inboundSchema: z.ZodNativeEnum<typeof CreatedFrom> = z
  .nativeEnum(CreatedFrom);

/** @internal */
export const CreatedFrom$outboundSchema: z.ZodNativeEnum<typeof CreatedFrom> =
  CreatedFrom$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreatedFrom$ {
  /** @deprecated use `CreatedFrom$inboundSchema` instead. */
  export const inboundSchema = CreatedFrom$inboundSchema;
  /** @deprecated use `CreatedFrom$outboundSchema` instead. */
  export const outboundSchema = CreatedFrom$outboundSchema;
}

/** @internal */
export const GetIntegrationLogDrainsEnvironments$inboundSchema: z.ZodNativeEnum<
  typeof GetIntegrationLogDrainsEnvironments
> = z.nativeEnum(GetIntegrationLogDrainsEnvironments);

/** @internal */
export const GetIntegrationLogDrainsEnvironments$outboundSchema:
  z.ZodNativeEnum<typeof GetIntegrationLogDrainsEnvironments> =
    GetIntegrationLogDrainsEnvironments$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetIntegrationLogDrainsEnvironments$ {
  /** @deprecated use `GetIntegrationLogDrainsEnvironments$inboundSchema` instead. */
  export const inboundSchema =
    GetIntegrationLogDrainsEnvironments$inboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsEnvironments$outboundSchema` instead. */
  export const outboundSchema =
    GetIntegrationLogDrainsEnvironments$outboundSchema;
}

/** @internal */
export const GetIntegrationLogDrainsResponseBody$inboundSchema: z.ZodType<
  GetIntegrationLogDrainsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  clientId: z.string().optional(),
  configurationId: z.string().optional(),
  createdAt: z.number(),
  id: z.string(),
  deliveryFormat: GetIntegrationLogDrainsDeliveryFormat$inboundSchema
    .optional(),
  name: z.string(),
  ownerId: z.string(),
  projectId: z.nullable(z.string()).optional(),
  projectIds: z.array(z.string()).optional(),
  url: z.string(),
  sources: z.array(GetIntegrationLogDrainsSources$inboundSchema).optional(),
  createdFrom: CreatedFrom$inboundSchema.optional(),
  headers: z.record(z.string()).optional(),
  environments: z.array(GetIntegrationLogDrainsEnvironments$inboundSchema),
  branch: z.string().optional(),
  samplingRate: z.number().optional(),
});

/** @internal */
export type GetIntegrationLogDrainsResponseBody$Outbound = {
  clientId?: string | undefined;
  configurationId?: string | undefined;
  createdAt: number;
  id: string;
  deliveryFormat?: string | undefined;
  name: string;
  ownerId: string;
  projectId?: string | null | undefined;
  projectIds?: Array<string> | undefined;
  url: string;
  sources?: Array<string> | undefined;
  createdFrom?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  environments: Array<string>;
  branch?: string | undefined;
  samplingRate?: number | undefined;
};

/** @internal */
export const GetIntegrationLogDrainsResponseBody$outboundSchema: z.ZodType<
  GetIntegrationLogDrainsResponseBody$Outbound,
  z.ZodTypeDef,
  GetIntegrationLogDrainsResponseBody
> = z.object({
  clientId: z.string().optional(),
  configurationId: z.string().optional(),
  createdAt: z.number(),
  id: z.string(),
  deliveryFormat: GetIntegrationLogDrainsDeliveryFormat$outboundSchema
    .optional(),
  name: z.string(),
  ownerId: z.string(),
  projectId: z.nullable(z.string()).optional(),
  projectIds: z.array(z.string()).optional(),
  url: z.string(),
  sources: z.array(GetIntegrationLogDrainsSources$outboundSchema).optional(),
  createdFrom: CreatedFrom$outboundSchema.optional(),
  headers: z.record(z.string()).optional(),
  environments: z.array(GetIntegrationLogDrainsEnvironments$outboundSchema),
  branch: z.string().optional(),
  samplingRate: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetIntegrationLogDrainsResponseBody$ {
  /** @deprecated use `GetIntegrationLogDrainsResponseBody$inboundSchema` instead. */
  export const inboundSchema =
    GetIntegrationLogDrainsResponseBody$inboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsResponseBody$outboundSchema` instead. */
  export const outboundSchema =
    GetIntegrationLogDrainsResponseBody$outboundSchema;
  /** @deprecated use `GetIntegrationLogDrainsResponseBody$Outbound` instead. */
  export type Outbound = GetIntegrationLogDrainsResponseBody$Outbound;
}
