/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

/**
 * When true, the response will only include the nameservers assigned directly to the specified domain. When false and there are no nameservers assigned directly to the specified domain, the response will include the nameservers of the domain's parent zone.
 */
export const Strict = {
  True: "true",
  False: "false",
} as const;
/**
 * When true, the response will only include the nameservers assigned directly to the specified domain. When false and there are no nameservers assigned directly to the specified domain, the response will include the nameservers of the domain's parent zone.
 */
export type Strict = ClosedEnum<typeof Strict>;

export type GetDomainConfigRequest = {
  /**
   * The name of the domain.
   */
  domain: string;
  /**
   * When true, the response will only include the nameservers assigned directly to the specified domain. When false and there are no nameservers assigned directly to the specified domain, the response will include the nameservers of the domain's parent zone.
   */
  strict?: Strict | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * How we see the domain's configuration. - `CNAME`: Domain has a CNAME pointing to Vercel. - `A`: Domain's A record is resolving to Vercel. - `http`: Domain is resolving to Vercel but may be behind a Proxy. - `dns-01`: Domain is not resolving to Vercel but dns-01 challenge is enabled. - `null`: Domain is not resolving to Vercel.
 */
export const ConfiguredBy = {
  Cname: "CNAME",
  A: "A",
  Http: "http",
  Dns01: "dns-01",
} as const;
/**
 * How we see the domain's configuration. - `CNAME`: Domain has a CNAME pointing to Vercel. - `A`: Domain's A record is resolving to Vercel. - `http`: Domain is resolving to Vercel but may be behind a Proxy. - `dns-01`: Domain is not resolving to Vercel but dns-01 challenge is enabled. - `null`: Domain is not resolving to Vercel.
 */
export type ConfiguredBy = ClosedEnum<typeof ConfiguredBy>;

/**
 * Which challenge types the domain can use for issuing certs.
 */
export const AcceptedChallenges = {
  Dns01: "dns-01",
  Http01: "http-01",
} as const;
/**
 * Which challenge types the domain can use for issuing certs.
 */
export type AcceptedChallenges = ClosedEnum<typeof AcceptedChallenges>;

export type GetDomainConfigResponseBody = {
  /**
   * How we see the domain's configuration. - `CNAME`: Domain has a CNAME pointing to Vercel. - `A`: Domain's A record is resolving to Vercel. - `http`: Domain is resolving to Vercel but may be behind a Proxy. - `dns-01`: Domain is not resolving to Vercel but dns-01 challenge is enabled. - `null`: Domain is not resolving to Vercel.
   */
  configuredBy?: ConfiguredBy | null | undefined;
  /**
   * Which challenge types the domain can use for issuing certs.
   */
  acceptedChallenges?: Array<AcceptedChallenges> | undefined;
  /**
   * Whether or not the domain is configured AND we can automatically generate a TLS certificate.
   */
  misconfigured: boolean;
};

/** @internal */
export const Strict$inboundSchema: z.ZodNativeEnum<typeof Strict> = z
  .nativeEnum(Strict);

/** @internal */
export const Strict$outboundSchema: z.ZodNativeEnum<typeof Strict> =
  Strict$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Strict$ {
  /** @deprecated use `Strict$inboundSchema` instead. */
  export const inboundSchema = Strict$inboundSchema;
  /** @deprecated use `Strict$outboundSchema` instead. */
  export const outboundSchema = Strict$outboundSchema;
}

/** @internal */
export const GetDomainConfigRequest$inboundSchema: z.ZodType<
  GetDomainConfigRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  domain: z.string(),
  strict: Strict$inboundSchema.optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetDomainConfigRequest$Outbound = {
  domain: string;
  strict?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetDomainConfigRequest$outboundSchema: z.ZodType<
  GetDomainConfigRequest$Outbound,
  z.ZodTypeDef,
  GetDomainConfigRequest
> = z.object({
  domain: z.string(),
  strict: Strict$outboundSchema.optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDomainConfigRequest$ {
  /** @deprecated use `GetDomainConfigRequest$inboundSchema` instead. */
  export const inboundSchema = GetDomainConfigRequest$inboundSchema;
  /** @deprecated use `GetDomainConfigRequest$outboundSchema` instead. */
  export const outboundSchema = GetDomainConfigRequest$outboundSchema;
  /** @deprecated use `GetDomainConfigRequest$Outbound` instead. */
  export type Outbound = GetDomainConfigRequest$Outbound;
}

/** @internal */
export const ConfiguredBy$inboundSchema: z.ZodNativeEnum<typeof ConfiguredBy> =
  z.nativeEnum(ConfiguredBy);

/** @internal */
export const ConfiguredBy$outboundSchema: z.ZodNativeEnum<typeof ConfiguredBy> =
  ConfiguredBy$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConfiguredBy$ {
  /** @deprecated use `ConfiguredBy$inboundSchema` instead. */
  export const inboundSchema = ConfiguredBy$inboundSchema;
  /** @deprecated use `ConfiguredBy$outboundSchema` instead. */
  export const outboundSchema = ConfiguredBy$outboundSchema;
}

/** @internal */
export const AcceptedChallenges$inboundSchema: z.ZodNativeEnum<
  typeof AcceptedChallenges
> = z.nativeEnum(AcceptedChallenges);

/** @internal */
export const AcceptedChallenges$outboundSchema: z.ZodNativeEnum<
  typeof AcceptedChallenges
> = AcceptedChallenges$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AcceptedChallenges$ {
  /** @deprecated use `AcceptedChallenges$inboundSchema` instead. */
  export const inboundSchema = AcceptedChallenges$inboundSchema;
  /** @deprecated use `AcceptedChallenges$outboundSchema` instead. */
  export const outboundSchema = AcceptedChallenges$outboundSchema;
}

/** @internal */
export const GetDomainConfigResponseBody$inboundSchema: z.ZodType<
  GetDomainConfigResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  configuredBy: z.nullable(ConfiguredBy$inboundSchema).optional(),
  acceptedChallenges: z.array(AcceptedChallenges$inboundSchema).optional(),
  misconfigured: z.boolean(),
});

/** @internal */
export type GetDomainConfigResponseBody$Outbound = {
  configuredBy?: string | null | undefined;
  acceptedChallenges?: Array<string> | undefined;
  misconfigured: boolean;
};

/** @internal */
export const GetDomainConfigResponseBody$outboundSchema: z.ZodType<
  GetDomainConfigResponseBody$Outbound,
  z.ZodTypeDef,
  GetDomainConfigResponseBody
> = z.object({
  configuredBy: z.nullable(ConfiguredBy$outboundSchema).optional(),
  acceptedChallenges: z.array(AcceptedChallenges$outboundSchema).optional(),
  misconfigured: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDomainConfigResponseBody$ {
  /** @deprecated use `GetDomainConfigResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetDomainConfigResponseBody$inboundSchema;
  /** @deprecated use `GetDomainConfigResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetDomainConfigResponseBody$outboundSchema;
  /** @deprecated use `GetDomainConfigResponseBody$Outbound` instead. */
  export type Outbound = GetDomainConfigResponseBody$Outbound;
}
