/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type GetDomainRequest = {
  /**
   * The name of the domain.
   */
  domain: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * An object containing information of the domain creator, including the user's id, username, and email.
 */
export type GetDomainCreator = {
  username: string;
  email: string;
  customerId?: string | null | undefined;
  isDomainReseller?: boolean | undefined;
  id: string;
};

/**
 * The type of service the domain is handled by. `external` if the DNS is externally handled, `zeit.world` if handled with Vercel, or `na` if the service is not available.
 */
export const ServiceType = {
  ZeitWorld: "zeit.world",
  External: "external",
  Na: "na",
} as const;
/**
 * The type of service the domain is handled by. `external` if the DNS is externally handled, `zeit.world` if handled with Vercel, or `na` if the service is not available.
 */
export type ServiceType = ClosedEnum<typeof ServiceType>;

export type GetDomainDomain = {
  suffix: boolean;
  /**
   * If the domain has the ownership verified.
   */
  verified: boolean;
  /**
   * A list of the current nameservers of the domain.
   */
  nameservers: Array<string>;
  /**
   * A list of the intended nameservers for the domain to point to Vercel DNS.
   */
  intendedNameservers: Array<string>;
  /**
   * A list of custom nameservers for the domain to point to. Only applies to domains purchased with Vercel.
   */
  customNameservers?: Array<string> | undefined;
  /**
   * An object containing information of the domain creator, including the user's id, username, and email.
   */
  creator: GetDomainCreator;
  teamId: string | null;
  userId: string;
  /**
   * If it was purchased through Vercel, the timestamp in milliseconds when it was purchased.
   */
  boughtAt: number | null;
  /**
   * Timestamp in milliseconds when the domain was created in the registry.
   */
  createdAt: number;
  /**
   * Timestamp in milliseconds at which the domain is set to expire. `null` if not bought with Vercel.
   */
  expiresAt: number | null;
  /**
   * The unique identifier of the domain.
   */
  id: string;
  /**
   * The domain name.
   */
  name: string;
  /**
   * Timestamp in milliseconds at which the domain was ordered.
   */
  orderedAt?: number | undefined;
  /**
   * Indicates whether the domain is set to automatically renew.
   */
  renew?: boolean | undefined;
  /**
   * The type of service the domain is handled by. `external` if the DNS is externally handled, `zeit.world` if handled with Vercel, or `na` if the service is not available.
   */
  serviceType: ServiceType;
  /**
   * Timestamp in milliseconds at which the domain was successfully transferred into Vercel. `null` if the transfer is still processing or was never transferred in.
   */
  transferredAt?: number | null | undefined;
  /**
   * If transferred into Vercel, timestamp in milliseconds when the domain transfer was initiated.
   */
  transferStartedAt?: number | undefined;
};

/**
 * Successful response retrieving an information for a specific domains.
 */
export type GetDomainResponseBody = {
  domain: GetDomainDomain;
};

/** @internal */
export const GetDomainRequest$inboundSchema: z.ZodType<
  GetDomainRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  domain: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetDomainRequest$Outbound = {
  domain: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetDomainRequest$outboundSchema: z.ZodType<
  GetDomainRequest$Outbound,
  z.ZodTypeDef,
  GetDomainRequest
> = z.object({
  domain: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDomainRequest$ {
  /** @deprecated use `GetDomainRequest$inboundSchema` instead. */
  export const inboundSchema = GetDomainRequest$inboundSchema;
  /** @deprecated use `GetDomainRequest$outboundSchema` instead. */
  export const outboundSchema = GetDomainRequest$outboundSchema;
  /** @deprecated use `GetDomainRequest$Outbound` instead. */
  export type Outbound = GetDomainRequest$Outbound;
}

/** @internal */
export const GetDomainCreator$inboundSchema: z.ZodType<
  GetDomainCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  username: z.string(),
  email: z.string(),
  customerId: z.nullable(z.string()).optional(),
  isDomainReseller: z.boolean().optional(),
  id: z.string(),
});

/** @internal */
export type GetDomainCreator$Outbound = {
  username: string;
  email: string;
  customerId?: string | null | undefined;
  isDomainReseller?: boolean | undefined;
  id: string;
};

/** @internal */
export const GetDomainCreator$outboundSchema: z.ZodType<
  GetDomainCreator$Outbound,
  z.ZodTypeDef,
  GetDomainCreator
> = z.object({
  username: z.string(),
  email: z.string(),
  customerId: z.nullable(z.string()).optional(),
  isDomainReseller: z.boolean().optional(),
  id: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDomainCreator$ {
  /** @deprecated use `GetDomainCreator$inboundSchema` instead. */
  export const inboundSchema = GetDomainCreator$inboundSchema;
  /** @deprecated use `GetDomainCreator$outboundSchema` instead. */
  export const outboundSchema = GetDomainCreator$outboundSchema;
  /** @deprecated use `GetDomainCreator$Outbound` instead. */
  export type Outbound = GetDomainCreator$Outbound;
}

/** @internal */
export const ServiceType$inboundSchema: z.ZodNativeEnum<typeof ServiceType> = z
  .nativeEnum(ServiceType);

/** @internal */
export const ServiceType$outboundSchema: z.ZodNativeEnum<typeof ServiceType> =
  ServiceType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ServiceType$ {
  /** @deprecated use `ServiceType$inboundSchema` instead. */
  export const inboundSchema = ServiceType$inboundSchema;
  /** @deprecated use `ServiceType$outboundSchema` instead. */
  export const outboundSchema = ServiceType$outboundSchema;
}

/** @internal */
export const GetDomainDomain$inboundSchema: z.ZodType<
  GetDomainDomain,
  z.ZodTypeDef,
  unknown
> = z.object({
  suffix: z.boolean(),
  verified: z.boolean(),
  nameservers: z.array(z.string()),
  intendedNameservers: z.array(z.string()),
  customNameservers: z.array(z.string()).optional(),
  creator: z.lazy(() => GetDomainCreator$inboundSchema),
  teamId: z.nullable(z.string()),
  userId: z.string(),
  boughtAt: z.nullable(z.number()),
  createdAt: z.number(),
  expiresAt: z.nullable(z.number()),
  id: z.string(),
  name: z.string(),
  orderedAt: z.number().optional(),
  renew: z.boolean().optional(),
  serviceType: ServiceType$inboundSchema,
  transferredAt: z.nullable(z.number()).optional(),
  transferStartedAt: z.number().optional(),
});

/** @internal */
export type GetDomainDomain$Outbound = {
  suffix: boolean;
  verified: boolean;
  nameservers: Array<string>;
  intendedNameservers: Array<string>;
  customNameservers?: Array<string> | undefined;
  creator: GetDomainCreator$Outbound;
  teamId: string | null;
  userId: string;
  boughtAt: number | null;
  createdAt: number;
  expiresAt: number | null;
  id: string;
  name: string;
  orderedAt?: number | undefined;
  renew?: boolean | undefined;
  serviceType: string;
  transferredAt?: number | null | undefined;
  transferStartedAt?: number | undefined;
};

/** @internal */
export const GetDomainDomain$outboundSchema: z.ZodType<
  GetDomainDomain$Outbound,
  z.ZodTypeDef,
  GetDomainDomain
> = z.object({
  suffix: z.boolean(),
  verified: z.boolean(),
  nameservers: z.array(z.string()),
  intendedNameservers: z.array(z.string()),
  customNameservers: z.array(z.string()).optional(),
  creator: z.lazy(() => GetDomainCreator$outboundSchema),
  teamId: z.nullable(z.string()),
  userId: z.string(),
  boughtAt: z.nullable(z.number()),
  createdAt: z.number(),
  expiresAt: z.nullable(z.number()),
  id: z.string(),
  name: z.string(),
  orderedAt: z.number().optional(),
  renew: z.boolean().optional(),
  serviceType: ServiceType$outboundSchema,
  transferredAt: z.nullable(z.number()).optional(),
  transferStartedAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDomainDomain$ {
  /** @deprecated use `GetDomainDomain$inboundSchema` instead. */
  export const inboundSchema = GetDomainDomain$inboundSchema;
  /** @deprecated use `GetDomainDomain$outboundSchema` instead. */
  export const outboundSchema = GetDomainDomain$outboundSchema;
  /** @deprecated use `GetDomainDomain$Outbound` instead. */
  export type Outbound = GetDomainDomain$Outbound;
}

/** @internal */
export const GetDomainResponseBody$inboundSchema: z.ZodType<
  GetDomainResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  domain: z.lazy(() => GetDomainDomain$inboundSchema),
});

/** @internal */
export type GetDomainResponseBody$Outbound = {
  domain: GetDomainDomain$Outbound;
};

/** @internal */
export const GetDomainResponseBody$outboundSchema: z.ZodType<
  GetDomainResponseBody$Outbound,
  z.ZodTypeDef,
  GetDomainResponseBody
> = z.object({
  domain: z.lazy(() => GetDomainDomain$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDomainResponseBody$ {
  /** @deprecated use `GetDomainResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetDomainResponseBody$inboundSchema;
  /** @deprecated use `GetDomainResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetDomainResponseBody$outboundSchema;
  /** @deprecated use `GetDomainResponseBody$Outbound` instead. */
  export type Outbound = GetDomainResponseBody$Outbound;
}
