/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";
import {
  Pagination,
  Pagination$inboundSchema,
  Pagination$Outbound,
  Pagination$outboundSchema,
} from "../components/pagination.js";

export type GetDeploymentsRequest = {
  /**
   * Name of the deployment.
   */
  app?: string | undefined;
  /**
   * Gets the deployment created after this Date timestamp. (default: current time)
   */
  from?: number | undefined;
  /**
   * Maximum number of deployments to list from a request.
   */
  limit?: number | undefined;
  /**
   * Filter deployments from the given ID or name.
   */
  projectId?: string | undefined;
  /**
   * Filter deployments based on the environment.
   */
  target?: string | undefined;
  /**
   * Gets the deployment created before this Date timestamp. (default: current time)
   */
  to?: number | undefined;
  /**
   * Filter out deployments based on users who have created the deployment.
   */
  users?: string | undefined;
  /**
   * Get Deployments created after this JavaScript timestamp.
   */
  since?: number | undefined;
  /**
   * Get Deployments created before this JavaScript timestamp.
   */
  until?: number | undefined;
  /**
   * Filter deployments based on their state (`BUILDING`, `ERROR`, `INITIALIZING`, `QUEUED`, `READY`, `CANCELED`)
   */
  state?: string | undefined;
  /**
   * Filter deployments based on their rollback candidacy
   */
  rollbackCandidate?: boolean | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * The source of the deployment.
 */
export const GetDeploymentsSource = {
  ApiTriggerGitDeploy: "api-trigger-git-deploy",
  Cli: "cli",
  CloneRepo: "clone/repo",
  Git: "git",
  Import: "import",
  ImportRepo: "import/repo",
  Redeploy: "redeploy",
} as const;
/**
 * The source of the deployment.
 */
export type GetDeploymentsSource = ClosedEnum<typeof GetDeploymentsSource>;

/**
 * In which state is the deployment.
 */
export const GetDeploymentsState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
  Deleted: "DELETED",
} as const;
/**
 * In which state is the deployment.
 */
export type GetDeploymentsState = ClosedEnum<typeof GetDeploymentsState>;

/**
 * In which state is the deployment.
 */
export const GetDeploymentsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
  Deleted: "DELETED",
} as const;
/**
 * In which state is the deployment.
 */
export type GetDeploymentsReadyState = ClosedEnum<
  typeof GetDeploymentsReadyState
>;

/**
 * The type of the deployment.
 */
export const GetDeploymentsType = {
  Lambdas: "LAMBDAS",
} as const;
/**
 * The type of the deployment.
 */
export type GetDeploymentsType = ClosedEnum<typeof GetDeploymentsType>;

/**
 * Metadata information of the user who created the deployment.
 */
export type GetDeploymentsCreator = {
  /**
   * The unique identifier of the user.
   */
  uid: string;
  /**
   * The email address of the user.
   */
  email?: string | undefined;
  /**
   * The username of the user.
   */
  username?: string | undefined;
  /**
   * The GitHub login of the user.
   */
  githubLogin?: string | undefined;
  /**
   * The GitLab login of the user.
   */
  gitlabLogin?: string | undefined;
};

/**
 * On which environment has the deployment been deployed to.
 */
export const GetDeploymentsTarget = {
  Production: "production",
  Staging: "staging",
} as const;
/**
 * On which environment has the deployment been deployed to.
 */
export type GetDeploymentsTarget = ClosedEnum<typeof GetDeploymentsTarget>;

/**
 * An error object in case aliasing of the deployment failed.
 */
export type GetDeploymentsAliasError = {
  code: string;
  message: string;
};

export type GetDeploymentsAliasAssigned = number | boolean;

/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export const GetDeploymentsReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export type GetDeploymentsReadySubstate = ClosedEnum<
  typeof GetDeploymentsReadySubstate
>;

/**
 * State of all registered checks
 */
export const GetDeploymentsChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
/**
 * State of all registered checks
 */
export type GetDeploymentsChecksState = ClosedEnum<
  typeof GetDeploymentsChecksState
>;

/**
 * Conclusion for checks
 */
export const GetDeploymentsChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
/**
 * Conclusion for checks
 */
export type GetDeploymentsChecksConclusion = ClosedEnum<
  typeof GetDeploymentsChecksConclusion
>;

export const GetDeploymentsFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type GetDeploymentsFramework = ClosedEnum<
  typeof GetDeploymentsFramework
>;

export const GetDeploymentsNodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
  Eight10X: "8.10.x",
} as const;
export type GetDeploymentsNodeVersion = ClosedEnum<
  typeof GetDeploymentsNodeVersion
>;

export type GetDeploymentsSpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type GetDeploymentsWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/**
 * Since June '23
 */
export type GetDeploymentsGitComments = {
  /**
   * Whether the Vercel bot should comment on PRs
   */
  onPullRequest: boolean;
  /**
   * Whether the Vercel bot should comment on commits
   */
  onCommit: boolean;
};

/**
 * The project settings which was used for this deployment
 */
export type GetDeploymentsProjectSettings = {
  framework?: GetDeploymentsFramework | null | undefined;
  gitForkProtection?: boolean | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  gitLFS?: boolean | undefined;
  devCommand?: string | null | undefined;
  installCommand?: string | null | undefined;
  buildCommand?: string | null | undefined;
  nodeVersion?: GetDeploymentsNodeVersion | undefined;
  outputDirectory?: string | null | undefined;
  publicSource?: boolean | null | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  createdAt?: number | undefined;
  speedInsights?: GetDeploymentsSpeedInsights | undefined;
  webAnalytics?: GetDeploymentsWebAnalytics | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  /**
   * Since June '23
   */
  gitComments?: GetDeploymentsGitComments | undefined;
};

/**
 * The custom environment used for this deployment, if any
 */
export type GetDeploymentsCustomEnvironment = {
  id: string;
  name?: string | undefined;
};

export type Deployments = {
  /**
   * The unique identifier of the deployment.
   */
  uid: string;
  /**
   * The name of the deployment.
   */
  name: string;
  /**
   * The URL of the deployment.
   */
  url: string;
  /**
   * Timestamp of when the deployment got created.
   */
  created: number;
  /**
   * Timestamp of when the deployment got deleted.
   */
  deleted?: number | undefined;
  /**
   * Timestamp of when the deployment was undeleted.
   */
  undeleted?: number | undefined;
  /**
   * Optional flag to indicate if the deployment was soft deleted by retention policy.
   */
  softDeletedByRetention?: boolean | undefined;
  /**
   * The source of the deployment.
   */
  source?: GetDeploymentsSource | undefined;
  /**
   * In which state is the deployment.
   */
  state?: GetDeploymentsState | undefined;
  /**
   * In which state is the deployment.
   */
  readyState?: GetDeploymentsReadyState | undefined;
  /**
   * The type of the deployment.
   */
  type: GetDeploymentsType;
  /**
   * Metadata information of the user who created the deployment.
   */
  creator: GetDeploymentsCreator;
  /**
   * Metadata information from the Git provider.
   */
  meta?: { [k: string]: string } | undefined;
  /**
   * On which environment has the deployment been deployed to.
   */
  target?: GetDeploymentsTarget | null | undefined;
  /**
   * An error object in case aliasing of the deployment failed.
   */
  aliasError?: GetDeploymentsAliasError | null | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  /**
   * Timestamp of when the deployment got created.
   */
  createdAt?: number | undefined;
  /**
   * Timestamp of when the deployment started building at.
   */
  buildingAt?: number | undefined;
  /**
   * Timestamp of when the deployment got ready.
   */
  ready?: number | undefined;
  /**
   * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
   */
  readySubstate?: GetDeploymentsReadySubstate | undefined;
  /**
   * State of all registered checks
   */
  checksState?: GetDeploymentsChecksState | undefined;
  /**
   * Conclusion for checks
   */
  checksConclusion?: GetDeploymentsChecksConclusion | undefined;
  /**
   * Vercel URL to inspect the deployment.
   */
  inspectorUrl: string | null;
  /**
   * Deployment can be used for instant rollback
   */
  isRollbackCandidate?: boolean | null | undefined;
  /**
   * The project settings which was used for this deployment
   */
  projectSettings?: GetDeploymentsProjectSettings | undefined;
  /**
   * The flag saying if Secure Compute network is used for builds
   */
  connectBuildsEnabled?: boolean | undefined;
  /**
   * The ID of Secure Compute network used for this deployment
   */
  connectConfigurationId?: string | undefined;
  /**
   * The ID of Secure Compute network used for this deployment's passive functions
   */
  passiveConnectConfigurationId?: string | undefined;
  /**
   * The expiration configured by the project retention policy
   */
  expiration?: number | undefined;
  /**
   * The expiration proposed to replace the existing expiration
   */
  proposedExpiration?: number | undefined;
  /**
   * The custom environment used for this deployment, if any
   */
  customEnvironment?: GetDeploymentsCustomEnvironment | undefined;
};

export type GetDeploymentsResponseBody = {
  /**
   * This object contains information related to the pagination of the current request, including the necessary parameters to get the next or previous page of data.
   */
  pagination: Pagination;
  deployments: Array<Deployments>;
};

/** @internal */
export const GetDeploymentsRequest$inboundSchema: z.ZodType<
  GetDeploymentsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  app: z.string().optional(),
  from: z.number().optional(),
  limit: z.number().optional(),
  projectId: z.string().optional(),
  target: z.string().optional(),
  to: z.number().optional(),
  users: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  state: z.string().optional(),
  rollbackCandidate: z.boolean().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetDeploymentsRequest$Outbound = {
  app?: string | undefined;
  from?: number | undefined;
  limit?: number | undefined;
  projectId?: string | undefined;
  target?: string | undefined;
  to?: number | undefined;
  users?: string | undefined;
  since?: number | undefined;
  until?: number | undefined;
  state?: string | undefined;
  rollbackCandidate?: boolean | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetDeploymentsRequest$outboundSchema: z.ZodType<
  GetDeploymentsRequest$Outbound,
  z.ZodTypeDef,
  GetDeploymentsRequest
> = z.object({
  app: z.string().optional(),
  from: z.number().optional(),
  limit: z.number().optional(),
  projectId: z.string().optional(),
  target: z.string().optional(),
  to: z.number().optional(),
  users: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  state: z.string().optional(),
  rollbackCandidate: z.boolean().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsRequest$ {
  /** @deprecated use `GetDeploymentsRequest$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsRequest$inboundSchema;
  /** @deprecated use `GetDeploymentsRequest$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsRequest$outboundSchema;
  /** @deprecated use `GetDeploymentsRequest$Outbound` instead. */
  export type Outbound = GetDeploymentsRequest$Outbound;
}

/** @internal */
export const GetDeploymentsSource$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsSource
> = z.nativeEnum(GetDeploymentsSource);

/** @internal */
export const GetDeploymentsSource$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsSource
> = GetDeploymentsSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsSource$ {
  /** @deprecated use `GetDeploymentsSource$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsSource$inboundSchema;
  /** @deprecated use `GetDeploymentsSource$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsSource$outboundSchema;
}

/** @internal */
export const GetDeploymentsState$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsState
> = z.nativeEnum(GetDeploymentsState);

/** @internal */
export const GetDeploymentsState$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsState
> = GetDeploymentsState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsState$ {
  /** @deprecated use `GetDeploymentsState$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsState$inboundSchema;
  /** @deprecated use `GetDeploymentsState$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsState$outboundSchema;
}

/** @internal */
export const GetDeploymentsReadyState$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsReadyState
> = z.nativeEnum(GetDeploymentsReadyState);

/** @internal */
export const GetDeploymentsReadyState$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsReadyState
> = GetDeploymentsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsReadyState$ {
  /** @deprecated use `GetDeploymentsReadyState$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsReadyState$inboundSchema;
  /** @deprecated use `GetDeploymentsReadyState$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsReadyState$outboundSchema;
}

/** @internal */
export const GetDeploymentsType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsType
> = z.nativeEnum(GetDeploymentsType);

/** @internal */
export const GetDeploymentsType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsType
> = GetDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsType$ {
  /** @deprecated use `GetDeploymentsType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsType$inboundSchema;
  /** @deprecated use `GetDeploymentsType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsType$outboundSchema;
}

/** @internal */
export const GetDeploymentsCreator$inboundSchema: z.ZodType<
  GetDeploymentsCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  email: z.string().optional(),
  username: z.string().optional(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
});

/** @internal */
export type GetDeploymentsCreator$Outbound = {
  uid: string;
  email?: string | undefined;
  username?: string | undefined;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
};

/** @internal */
export const GetDeploymentsCreator$outboundSchema: z.ZodType<
  GetDeploymentsCreator$Outbound,
  z.ZodTypeDef,
  GetDeploymentsCreator
> = z.object({
  uid: z.string(),
  email: z.string().optional(),
  username: z.string().optional(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsCreator$ {
  /** @deprecated use `GetDeploymentsCreator$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsCreator$inboundSchema;
  /** @deprecated use `GetDeploymentsCreator$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsCreator$outboundSchema;
  /** @deprecated use `GetDeploymentsCreator$Outbound` instead. */
  export type Outbound = GetDeploymentsCreator$Outbound;
}

/** @internal */
export const GetDeploymentsTarget$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsTarget
> = z.nativeEnum(GetDeploymentsTarget);

/** @internal */
export const GetDeploymentsTarget$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsTarget
> = GetDeploymentsTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsTarget$ {
  /** @deprecated use `GetDeploymentsTarget$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsTarget$inboundSchema;
  /** @deprecated use `GetDeploymentsTarget$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsTarget$outboundSchema;
}

/** @internal */
export const GetDeploymentsAliasError$inboundSchema: z.ZodType<
  GetDeploymentsAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type GetDeploymentsAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const GetDeploymentsAliasError$outboundSchema: z.ZodType<
  GetDeploymentsAliasError$Outbound,
  z.ZodTypeDef,
  GetDeploymentsAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsAliasError$ {
  /** @deprecated use `GetDeploymentsAliasError$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsAliasError$inboundSchema;
  /** @deprecated use `GetDeploymentsAliasError$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsAliasError$outboundSchema;
  /** @deprecated use `GetDeploymentsAliasError$Outbound` instead. */
  export type Outbound = GetDeploymentsAliasError$Outbound;
}

/** @internal */
export const GetDeploymentsAliasAssigned$inboundSchema: z.ZodType<
  GetDeploymentsAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type GetDeploymentsAliasAssigned$Outbound = number | boolean;

/** @internal */
export const GetDeploymentsAliasAssigned$outboundSchema: z.ZodType<
  GetDeploymentsAliasAssigned$Outbound,
  z.ZodTypeDef,
  GetDeploymentsAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsAliasAssigned$ {
  /** @deprecated use `GetDeploymentsAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsAliasAssigned$inboundSchema;
  /** @deprecated use `GetDeploymentsAliasAssigned$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsAliasAssigned$outboundSchema;
  /** @deprecated use `GetDeploymentsAliasAssigned$Outbound` instead. */
  export type Outbound = GetDeploymentsAliasAssigned$Outbound;
}

/** @internal */
export const GetDeploymentsReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsReadySubstate
> = z.nativeEnum(GetDeploymentsReadySubstate);

/** @internal */
export const GetDeploymentsReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsReadySubstate
> = GetDeploymentsReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsReadySubstate$ {
  /** @deprecated use `GetDeploymentsReadySubstate$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsReadySubstate$inboundSchema;
  /** @deprecated use `GetDeploymentsReadySubstate$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsReadySubstate$outboundSchema;
}

/** @internal */
export const GetDeploymentsChecksState$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsChecksState
> = z.nativeEnum(GetDeploymentsChecksState);

/** @internal */
export const GetDeploymentsChecksState$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsChecksState
> = GetDeploymentsChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsChecksState$ {
  /** @deprecated use `GetDeploymentsChecksState$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsChecksState$inboundSchema;
  /** @deprecated use `GetDeploymentsChecksState$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsChecksState$outboundSchema;
}

/** @internal */
export const GetDeploymentsChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsChecksConclusion
> = z.nativeEnum(GetDeploymentsChecksConclusion);

/** @internal */
export const GetDeploymentsChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsChecksConclusion
> = GetDeploymentsChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsChecksConclusion$ {
  /** @deprecated use `GetDeploymentsChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsChecksConclusion$inboundSchema;
  /** @deprecated use `GetDeploymentsChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsChecksConclusion$outboundSchema;
}

/** @internal */
export const GetDeploymentsFramework$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsFramework
> = z.nativeEnum(GetDeploymentsFramework);

/** @internal */
export const GetDeploymentsFramework$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsFramework
> = GetDeploymentsFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsFramework$ {
  /** @deprecated use `GetDeploymentsFramework$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsFramework$inboundSchema;
  /** @deprecated use `GetDeploymentsFramework$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsFramework$outboundSchema;
}

/** @internal */
export const GetDeploymentsNodeVersion$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsNodeVersion
> = z.nativeEnum(GetDeploymentsNodeVersion);

/** @internal */
export const GetDeploymentsNodeVersion$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentsNodeVersion
> = GetDeploymentsNodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsNodeVersion$ {
  /** @deprecated use `GetDeploymentsNodeVersion$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsNodeVersion$inboundSchema;
  /** @deprecated use `GetDeploymentsNodeVersion$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsNodeVersion$outboundSchema;
}

/** @internal */
export const GetDeploymentsSpeedInsights$inboundSchema: z.ZodType<
  GetDeploymentsSpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type GetDeploymentsSpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const GetDeploymentsSpeedInsights$outboundSchema: z.ZodType<
  GetDeploymentsSpeedInsights$Outbound,
  z.ZodTypeDef,
  GetDeploymentsSpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsSpeedInsights$ {
  /** @deprecated use `GetDeploymentsSpeedInsights$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsSpeedInsights$inboundSchema;
  /** @deprecated use `GetDeploymentsSpeedInsights$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsSpeedInsights$outboundSchema;
  /** @deprecated use `GetDeploymentsSpeedInsights$Outbound` instead. */
  export type Outbound = GetDeploymentsSpeedInsights$Outbound;
}

/** @internal */
export const GetDeploymentsWebAnalytics$inboundSchema: z.ZodType<
  GetDeploymentsWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type GetDeploymentsWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const GetDeploymentsWebAnalytics$outboundSchema: z.ZodType<
  GetDeploymentsWebAnalytics$Outbound,
  z.ZodTypeDef,
  GetDeploymentsWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsWebAnalytics$ {
  /** @deprecated use `GetDeploymentsWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsWebAnalytics$inboundSchema;
  /** @deprecated use `GetDeploymentsWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsWebAnalytics$outboundSchema;
  /** @deprecated use `GetDeploymentsWebAnalytics$Outbound` instead. */
  export type Outbound = GetDeploymentsWebAnalytics$Outbound;
}

/** @internal */
export const GetDeploymentsGitComments$inboundSchema: z.ZodType<
  GetDeploymentsGitComments,
  z.ZodTypeDef,
  unknown
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/** @internal */
export type GetDeploymentsGitComments$Outbound = {
  onPullRequest: boolean;
  onCommit: boolean;
};

/** @internal */
export const GetDeploymentsGitComments$outboundSchema: z.ZodType<
  GetDeploymentsGitComments$Outbound,
  z.ZodTypeDef,
  GetDeploymentsGitComments
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsGitComments$ {
  /** @deprecated use `GetDeploymentsGitComments$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsGitComments$inboundSchema;
  /** @deprecated use `GetDeploymentsGitComments$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsGitComments$outboundSchema;
  /** @deprecated use `GetDeploymentsGitComments$Outbound` instead. */
  export type Outbound = GetDeploymentsGitComments$Outbound;
}

/** @internal */
export const GetDeploymentsProjectSettings$inboundSchema: z.ZodType<
  GetDeploymentsProjectSettings,
  z.ZodTypeDef,
  unknown
> = z.object({
  framework: z.nullable(GetDeploymentsFramework$inboundSchema).optional(),
  gitForkProtection: z.boolean().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  devCommand: z.nullable(z.string()).optional(),
  installCommand: z.nullable(z.string()).optional(),
  buildCommand: z.nullable(z.string()).optional(),
  nodeVersion: GetDeploymentsNodeVersion$inboundSchema.optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  speedInsights: z.lazy(() => GetDeploymentsSpeedInsights$inboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => GetDeploymentsWebAnalytics$inboundSchema)
    .optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  gitComments: z.lazy(() => GetDeploymentsGitComments$inboundSchema).optional(),
});

/** @internal */
export type GetDeploymentsProjectSettings$Outbound = {
  framework?: string | null | undefined;
  gitForkProtection?: boolean | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  gitLFS?: boolean | undefined;
  devCommand?: string | null | undefined;
  installCommand?: string | null | undefined;
  buildCommand?: string | null | undefined;
  nodeVersion?: string | undefined;
  outputDirectory?: string | null | undefined;
  publicSource?: boolean | null | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  createdAt?: number | undefined;
  speedInsights?: GetDeploymentsSpeedInsights$Outbound | undefined;
  webAnalytics?: GetDeploymentsWebAnalytics$Outbound | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  gitComments?: GetDeploymentsGitComments$Outbound | undefined;
};

/** @internal */
export const GetDeploymentsProjectSettings$outboundSchema: z.ZodType<
  GetDeploymentsProjectSettings$Outbound,
  z.ZodTypeDef,
  GetDeploymentsProjectSettings
> = z.object({
  framework: z.nullable(GetDeploymentsFramework$outboundSchema).optional(),
  gitForkProtection: z.boolean().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  devCommand: z.nullable(z.string()).optional(),
  installCommand: z.nullable(z.string()).optional(),
  buildCommand: z.nullable(z.string()).optional(),
  nodeVersion: GetDeploymentsNodeVersion$outboundSchema.optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  speedInsights: z.lazy(() => GetDeploymentsSpeedInsights$outboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => GetDeploymentsWebAnalytics$outboundSchema)
    .optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  gitComments: z.lazy(() => GetDeploymentsGitComments$outboundSchema)
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsProjectSettings$ {
  /** @deprecated use `GetDeploymentsProjectSettings$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsProjectSettings$inboundSchema;
  /** @deprecated use `GetDeploymentsProjectSettings$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsProjectSettings$outboundSchema;
  /** @deprecated use `GetDeploymentsProjectSettings$Outbound` instead. */
  export type Outbound = GetDeploymentsProjectSettings$Outbound;
}

/** @internal */
export const GetDeploymentsCustomEnvironment$inboundSchema: z.ZodType<
  GetDeploymentsCustomEnvironment,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string().optional(),
});

/** @internal */
export type GetDeploymentsCustomEnvironment$Outbound = {
  id: string;
  name?: string | undefined;
};

/** @internal */
export const GetDeploymentsCustomEnvironment$outboundSchema: z.ZodType<
  GetDeploymentsCustomEnvironment$Outbound,
  z.ZodTypeDef,
  GetDeploymentsCustomEnvironment
> = z.object({
  id: z.string(),
  name: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsCustomEnvironment$ {
  /** @deprecated use `GetDeploymentsCustomEnvironment$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsCustomEnvironment$inboundSchema;
  /** @deprecated use `GetDeploymentsCustomEnvironment$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsCustomEnvironment$outboundSchema;
  /** @deprecated use `GetDeploymentsCustomEnvironment$Outbound` instead. */
  export type Outbound = GetDeploymentsCustomEnvironment$Outbound;
}

/** @internal */
export const Deployments$inboundSchema: z.ZodType<
  Deployments,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  name: z.string(),
  url: z.string(),
  created: z.number(),
  deleted: z.number().optional(),
  undeleted: z.number().optional(),
  softDeletedByRetention: z.boolean().optional(),
  source: GetDeploymentsSource$inboundSchema.optional(),
  state: GetDeploymentsState$inboundSchema.optional(),
  readyState: GetDeploymentsReadyState$inboundSchema.optional(),
  type: GetDeploymentsType$inboundSchema,
  creator: z.lazy(() => GetDeploymentsCreator$inboundSchema),
  meta: z.record(z.string()).optional(),
  target: z.nullable(GetDeploymentsTarget$inboundSchema).optional(),
  aliasError: z.nullable(z.lazy(() => GetDeploymentsAliasError$inboundSchema))
    .optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  createdAt: z.number().optional(),
  buildingAt: z.number().optional(),
  ready: z.number().optional(),
  readySubstate: GetDeploymentsReadySubstate$inboundSchema.optional(),
  checksState: GetDeploymentsChecksState$inboundSchema.optional(),
  checksConclusion: GetDeploymentsChecksConclusion$inboundSchema.optional(),
  inspectorUrl: z.nullable(z.string()),
  isRollbackCandidate: z.nullable(z.boolean()).optional(),
  projectSettings: z.lazy(() => GetDeploymentsProjectSettings$inboundSchema)
    .optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  passiveConnectConfigurationId: z.string().optional(),
  expiration: z.number().optional(),
  proposedExpiration: z.number().optional(),
  customEnvironment: z.lazy(() => GetDeploymentsCustomEnvironment$inboundSchema)
    .optional(),
});

/** @internal */
export type Deployments$Outbound = {
  uid: string;
  name: string;
  url: string;
  created: number;
  deleted?: number | undefined;
  undeleted?: number | undefined;
  softDeletedByRetention?: boolean | undefined;
  source?: string | undefined;
  state?: string | undefined;
  readyState?: string | undefined;
  type: string;
  creator: GetDeploymentsCreator$Outbound;
  meta?: { [k: string]: string } | undefined;
  target?: string | null | undefined;
  aliasError?: GetDeploymentsAliasError$Outbound | null | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  createdAt?: number | undefined;
  buildingAt?: number | undefined;
  ready?: number | undefined;
  readySubstate?: string | undefined;
  checksState?: string | undefined;
  checksConclusion?: string | undefined;
  inspectorUrl: string | null;
  isRollbackCandidate?: boolean | null | undefined;
  projectSettings?: GetDeploymentsProjectSettings$Outbound | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  passiveConnectConfigurationId?: string | undefined;
  expiration?: number | undefined;
  proposedExpiration?: number | undefined;
  customEnvironment?: GetDeploymentsCustomEnvironment$Outbound | undefined;
};

/** @internal */
export const Deployments$outboundSchema: z.ZodType<
  Deployments$Outbound,
  z.ZodTypeDef,
  Deployments
> = z.object({
  uid: z.string(),
  name: z.string(),
  url: z.string(),
  created: z.number(),
  deleted: z.number().optional(),
  undeleted: z.number().optional(),
  softDeletedByRetention: z.boolean().optional(),
  source: GetDeploymentsSource$outboundSchema.optional(),
  state: GetDeploymentsState$outboundSchema.optional(),
  readyState: GetDeploymentsReadyState$outboundSchema.optional(),
  type: GetDeploymentsType$outboundSchema,
  creator: z.lazy(() => GetDeploymentsCreator$outboundSchema),
  meta: z.record(z.string()).optional(),
  target: z.nullable(GetDeploymentsTarget$outboundSchema).optional(),
  aliasError: z.nullable(z.lazy(() => GetDeploymentsAliasError$outboundSchema))
    .optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  createdAt: z.number().optional(),
  buildingAt: z.number().optional(),
  ready: z.number().optional(),
  readySubstate: GetDeploymentsReadySubstate$outboundSchema.optional(),
  checksState: GetDeploymentsChecksState$outboundSchema.optional(),
  checksConclusion: GetDeploymentsChecksConclusion$outboundSchema.optional(),
  inspectorUrl: z.nullable(z.string()),
  isRollbackCandidate: z.nullable(z.boolean()).optional(),
  projectSettings: z.lazy(() => GetDeploymentsProjectSettings$outboundSchema)
    .optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  passiveConnectConfigurationId: z.string().optional(),
  expiration: z.number().optional(),
  proposedExpiration: z.number().optional(),
  customEnvironment: z.lazy(() =>
    GetDeploymentsCustomEnvironment$outboundSchema
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Deployments$ {
  /** @deprecated use `Deployments$inboundSchema` instead. */
  export const inboundSchema = Deployments$inboundSchema;
  /** @deprecated use `Deployments$outboundSchema` instead. */
  export const outboundSchema = Deployments$outboundSchema;
  /** @deprecated use `Deployments$Outbound` instead. */
  export type Outbound = Deployments$Outbound;
}

/** @internal */
export const GetDeploymentsResponseBody$inboundSchema: z.ZodType<
  GetDeploymentsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  pagination: Pagination$inboundSchema,
  deployments: z.array(z.lazy(() => Deployments$inboundSchema)),
});

/** @internal */
export type GetDeploymentsResponseBody$Outbound = {
  pagination: Pagination$Outbound;
  deployments: Array<Deployments$Outbound>;
};

/** @internal */
export const GetDeploymentsResponseBody$outboundSchema: z.ZodType<
  GetDeploymentsResponseBody$Outbound,
  z.ZodTypeDef,
  GetDeploymentsResponseBody
> = z.object({
  pagination: Pagination$outboundSchema,
  deployments: z.array(z.lazy(() => Deployments$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentsResponseBody$ {
  /** @deprecated use `GetDeploymentsResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentsResponseBody$inboundSchema;
  /** @deprecated use `GetDeploymentsResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentsResponseBody$outboundSchema;
  /** @deprecated use `GetDeploymentsResponseBody$Outbound` instead. */
  export type Outbound = GetDeploymentsResponseBody$Outbound;
}
