/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

/**
 * Order of the returned events based on the timestamp.
 */
export const Direction = {
  Backward: "backward",
  Forward: "forward",
} as const;
/**
 * Order of the returned events based on the timestamp.
 */
export type Direction = ClosedEnum<typeof Direction>;

/**
 * HTTP status code range to filter events by.
 */
export type StatusCode = number | string;

export type GetDeploymentEventsRequest = {
  /**
   * The unique identifier or hostname of the deployment.
   */
  idOrUrl: string;
  /**
   * Order of the returned events based on the timestamp.
   */
  direction?: Direction | undefined;
  /**
   * When enabled, this endpoint will return live events as they happen.
   */
  follow?: number | undefined;
  /**
   * Maximum number of events to return. Provide `-1` to return all available logs.
   */
  limit?: number | undefined;
  /**
   * Deployment build ID.
   */
  name?: string | undefined;
  /**
   * Timestamp for when build logs should be pulled from.
   */
  since?: number | undefined;
  /**
   * Timestamp for when the build logs should be pulled up until.
   */
  until?: number | undefined;
  /**
   * HTTP status code range to filter events by.
   */
  statusCode?: number | string | undefined;
  delimiter?: number | undefined;
  builds?: number | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/** @internal */
export const Direction$inboundSchema: z.ZodNativeEnum<typeof Direction> = z
  .nativeEnum(Direction);

/** @internal */
export const Direction$outboundSchema: z.ZodNativeEnum<typeof Direction> =
  Direction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Direction$ {
  /** @deprecated use `Direction$inboundSchema` instead. */
  export const inboundSchema = Direction$inboundSchema;
  /** @deprecated use `Direction$outboundSchema` instead. */
  export const outboundSchema = Direction$outboundSchema;
}

/** @internal */
export const StatusCode$inboundSchema: z.ZodType<
  StatusCode,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.string()]);

/** @internal */
export type StatusCode$Outbound = number | string;

/** @internal */
export const StatusCode$outboundSchema: z.ZodType<
  StatusCode$Outbound,
  z.ZodTypeDef,
  StatusCode
> = z.union([z.number(), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace StatusCode$ {
  /** @deprecated use `StatusCode$inboundSchema` instead. */
  export const inboundSchema = StatusCode$inboundSchema;
  /** @deprecated use `StatusCode$outboundSchema` instead. */
  export const outboundSchema = StatusCode$outboundSchema;
  /** @deprecated use `StatusCode$Outbound` instead. */
  export type Outbound = StatusCode$Outbound;
}

/** @internal */
export const GetDeploymentEventsRequest$inboundSchema: z.ZodType<
  GetDeploymentEventsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrUrl: z.string(),
  direction: Direction$inboundSchema.default("forward"),
  follow: z.number().optional(),
  limit: z.number().optional(),
  name: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  statusCode: z.union([z.number(), z.string()]).optional(),
  delimiter: z.number().optional(),
  builds: z.number().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetDeploymentEventsRequest$Outbound = {
  idOrUrl: string;
  direction: string;
  follow?: number | undefined;
  limit?: number | undefined;
  name?: string | undefined;
  since?: number | undefined;
  until?: number | undefined;
  statusCode?: number | string | undefined;
  delimiter?: number | undefined;
  builds?: number | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetDeploymentEventsRequest$outboundSchema: z.ZodType<
  GetDeploymentEventsRequest$Outbound,
  z.ZodTypeDef,
  GetDeploymentEventsRequest
> = z.object({
  idOrUrl: z.string(),
  direction: Direction$outboundSchema.default("forward"),
  follow: z.number().optional(),
  limit: z.number().optional(),
  name: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  statusCode: z.union([z.number(), z.string()]).optional(),
  delimiter: z.number().optional(),
  builds: z.number().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentEventsRequest$ {
  /** @deprecated use `GetDeploymentEventsRequest$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentEventsRequest$inboundSchema;
  /** @deprecated use `GetDeploymentEventsRequest$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentEventsRequest$outboundSchema;
  /** @deprecated use `GetDeploymentEventsRequest$Outbound` instead. */
  export type Outbound = GetDeploymentEventsRequest$Outbound;
}
