/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  FlagJSONValue,
  FlagJSONValue$inboundSchema,
  FlagJSONValue$Outbound,
  FlagJSONValue$outboundSchema,
} from "../components/flagjsonvalue.js";

export type GetDeploymentRequest = {
  /**
   * The unique identifier or hostname of the deployment.
   */
  idOrUrl: string;
  /**
   * Whether to add in gitRepo information.
   */
  withGitRepoInfo?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export type GetDeploymentResponseBodyCreator = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

export const GetDeploymentResponseBodyDeploymentsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
} as const;
export type GetDeploymentResponseBodyDeploymentsReadyState = ClosedEnum<
  typeof GetDeploymentResponseBodyDeploymentsReadyState
>;

export type GetDeploymentResponseBodyOutput = {
  path: string;
  functionName: string;
};

/**
 * A partial representation of a Build used by the deployment endpoint.
 */
export type ResponseBodyLambdas = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: GetDeploymentResponseBodyDeploymentsReadyState | undefined;
  readyStateAt?: number | undefined;
  output: Array<GetDeploymentResponseBodyOutput>;
};

export const GetDeploymentResponseBodyStatus = {
  Queued: "QUEUED",
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type GetDeploymentResponseBodyStatus = ClosedEnum<
  typeof GetDeploymentResponseBodyStatus
>;

export type ResponseBodyTeam = {
  id: string;
  name: string;
  slug: string;
  avatar?: string | undefined;
};

export type GetDeploymentCustomEnvironment2 = {
  id: string;
};

export type GetDeploymentCustomEnvironment1 = {};

export type ResponseBodyCustomEnvironment =
  | GetDeploymentCustomEnvironment1
  | GetDeploymentCustomEnvironment2;

export type ResponseBodyAliasWarning = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

export const GetDeploymentResponseBodyType = {
  Lambdas: "LAMBDAS",
} as const;
export type GetDeploymentResponseBodyType = ClosedEnum<
  typeof GetDeploymentResponseBodyType
>;

export const GetDeploymentResponseBodyReadyState = {
  Queued: "QUEUED",
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type GetDeploymentResponseBodyReadyState = ClosedEnum<
  typeof GetDeploymentResponseBodyReadyState
>;

export type GetDeploymentResponseBodyAliasError = {
  code: string;
  message: string;
};

export const GetDeploymentResponseBodyChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type GetDeploymentResponseBodyChecksState = ClosedEnum<
  typeof GetDeploymentResponseBodyChecksState
>;

export const GetDeploymentResponseBodyChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type GetDeploymentResponseBodyChecksConclusion = ClosedEnum<
  typeof GetDeploymentResponseBodyChecksConclusion
>;

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type
  >;

export type GetDeploymentGitSource9 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type =
  {
    Gitlab: "gitlab",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type
  >;

export type GetDeploymentGitSource8 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type;
  ref: string;
  sha: string;
  projectId: number;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type =
  {
    Github: "github",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type
  >;

export type GetDeploymentGitSource7 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type =
  {
    Custom: "custom",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type
  >;

export type GetDeploymentGitSource6 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type;
  ref: string;
  sha: string;
  gitUrl: string;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type
  >;

export type GetDeploymentGitSource5 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type
  >;

export type GetDeploymentGitSource4 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type =
  {
    Gitlab: "gitlab",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type
  >;

export type GetDeploymentGitSourceDeploymentsProjectId = string | number;

export type GetDeploymentGitSource3 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type =
  {
    Github: "github",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type
  >;

export type GetDeploymentGitSource2 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type =
  {
    Github: "github",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type
  >;

export type GetDeploymentGitSourceDeploymentsRepoId = string | number;

export type GetDeploymentGitSource1 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export type ResponseBodyGitSource =
  | GetDeploymentGitSource6
  | GetDeploymentGitSource8
  | GetDeploymentGitSource1
  | GetDeploymentGitSource3
  | GetDeploymentGitSource2
  | GetDeploymentGitSource4
  | GetDeploymentGitSource5
  | GetDeploymentGitSource7
  | GetDeploymentGitSource9;

export type GetDeploymentResponseBodyProject = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export const GetDeploymentResponseBodyReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export type GetDeploymentResponseBodyReadySubstate = ClosedEnum<
  typeof GetDeploymentResponseBodyReadySubstate
>;

export const GetDeploymentResponseBodySource = {
  ApiTriggerGitDeploy: "api-trigger-git-deploy",
  Cli: "cli",
  CloneRepo: "clone/repo",
  Git: "git",
  Import: "import",
  ImportRepo: "import/repo",
  Redeploy: "redeploy",
} as const;
export type GetDeploymentResponseBodySource = ClosedEnum<
  typeof GetDeploymentResponseBodySource
>;

export const GetDeploymentResponseBodyTarget = {
  Staging: "staging",
  Production: "production",
} as const;
export type GetDeploymentResponseBodyTarget = ClosedEnum<
  typeof GetDeploymentResponseBodyTarget
>;

export type GetDeploymentResponseBodyOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

/**
 * The deployment including only public information
 */
export type GetDeploymentResponseBody2 = {
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: GetDeploymentResponseBodyCreator;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<ResponseBodyLambdas> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: GetDeploymentResponseBodyStatus;
  team?: ResponseBodyTeam | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | GetDeploymentCustomEnvironment1
    | GetDeploymentCustomEnvironment2
    | undefined;
  aliasWarning?: ResponseBodyAliasWarning | null | undefined;
  id: string;
  type: GetDeploymentResponseBodyType;
  createdAt: number;
  name: string;
  readyState: GetDeploymentResponseBodyReadyState;
  aliasError?: GetDeploymentResponseBodyAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  /**
   * applies to custom domains only, defaults to `true`
   */
  autoAssignCustomDomains?: boolean | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: GetDeploymentResponseBodyChecksState | undefined;
  checksConclusion?: GetDeploymentResponseBodyChecksConclusion | undefined;
  deletedAt?: number | null | undefined;
  /**
   * Computed field that is only available for deployments with a micro-frontend configuration.
   */
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorMessage?: string | null | undefined;
  errorStep?: string | undefined;
  /**
   * Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service
   */
  passiveRegions?: Array<string> | undefined;
  gitSource?:
    | GetDeploymentGitSource6
    | GetDeploymentGitSource8
    | GetDeploymentGitSource1
    | GetDeploymentGitSource3
    | GetDeploymentGitSource2
    | GetDeploymentGitSource4
    | GetDeploymentGitSource5
    | GetDeploymentGitSource7
    | GetDeploymentGitSource9
    | undefined;
  meta: { [k: string]: string };
  project?: GetDeploymentResponseBodyProject | undefined;
  /**
   * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
   */
  readySubstate?: GetDeploymentResponseBodyReadySubstate | undefined;
  regions: Array<string>;
  softDeletedByRetention?: boolean | undefined;
  source?: GetDeploymentResponseBodySource | undefined;
  target?: GetDeploymentResponseBodyTarget | null | undefined;
  undeletedAt?: number | undefined;
  url: string;
  version: number;
  oidcTokenClaims?: GetDeploymentResponseBodyOidcTokenClaims | undefined;
};

export type ResponseBodyAliasAssignedAt = number | boolean;

export type ResponseBodyBuild = {
  env: Array<string>;
};

export type ResponseBodyBuilds = {};

export const ResponseBodyFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type ResponseBodyFramework = ClosedEnum<typeof ResponseBodyFramework>;

export type ResponseBodySpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type ResponseBodyWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type ResponseBodyProjectSettings = {
  buildCommand?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: ResponseBodyFramework | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  installCommand?: string | null | undefined;
  outputDirectory?: string | null | undefined;
  speedInsights?: ResponseBodySpeedInsights | undefined;
  webAnalytics?: ResponseBodyWebAnalytics | undefined;
};

export const GetDeploymentResponseBodyDeploymentsStatus = {
  Error: "error",
  Skipped: "skipped",
  Pending: "pending",
  Ready: "ready",
  Timeout: "timeout",
} as const;
export type GetDeploymentResponseBodyDeploymentsStatus = ClosedEnum<
  typeof GetDeploymentResponseBodyDeploymentsStatus
>;

export type ResponseBodyIntegrations = {
  status: GetDeploymentResponseBodyDeploymentsStatus;
  startedAt: number;
  completedAt?: number | undefined;
  skippedAt?: number | undefined;
  skippedBy?: string | undefined;
};

export type ResponseBodyCreator = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

export const GetDeploymentResponseBodyDeploymentsResponseReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
} as const;
export type GetDeploymentResponseBodyDeploymentsResponseReadyState = ClosedEnum<
  typeof GetDeploymentResponseBodyDeploymentsResponseReadyState
>;

export type ResponseBodyOutput = {
  path: string;
  functionName: string;
};

/**
 * A partial representation of a Build used by the deployment endpoint.
 */
export type GetDeploymentResponseBodyLambdas = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?:
    | GetDeploymentResponseBodyDeploymentsResponseReadyState
    | undefined;
  readyStateAt?: number | undefined;
  output: Array<ResponseBodyOutput>;
};

export const ResponseBodyStatus = {
  Queued: "QUEUED",
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type ResponseBodyStatus = ClosedEnum<typeof ResponseBodyStatus>;

export type GetDeploymentResponseBodyTeam = {
  id: string;
  name: string;
  slug: string;
  avatar?: string | undefined;
};

export type GetDeploymentCustomEnvironmentDeployments2 = {
  id: string;
};

export type GetDeploymentCustomEnvironmentDeployments1 = {};

export type GetDeploymentResponseBodyCustomEnvironment =
  | GetDeploymentCustomEnvironmentDeployments1
  | GetDeploymentCustomEnvironmentDeployments2;

export type GetDeploymentResponseBodyAliasWarning = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

export const ResponseBodyType = {
  Lambdas: "LAMBDAS",
} as const;
export type ResponseBodyType = ClosedEnum<typeof ResponseBodyType>;

export const ResponseBodyReadyState = {
  Queued: "QUEUED",
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type ResponseBodyReadyState = ClosedEnum<typeof ResponseBodyReadyState>;

export type ResponseBodyAliasError = {
  code: string;
  message: string;
};

export const ResponseBodyChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type ResponseBodyChecksState = ClosedEnum<
  typeof ResponseBodyChecksState
>;

export const ResponseBodyChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type ResponseBodyChecksConclusion = ClosedEnum<
  typeof ResponseBodyChecksConclusion
>;

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type
  >;

export type GetDeploymentGitSourceDeployments9 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type =
  {
    Gitlab: "gitlab",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type
  >;

export type GetDeploymentGitSourceDeployments8 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type;
  ref: string;
  sha: string;
  projectId: number;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType =
  {
    Github: "github",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  >;

export type GetDeploymentGitSourceDeployments7 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType = {
  Custom: "custom",
} as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  >;

export type GetDeploymentGitSourceDeployments6 = {
  type: GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType;
  ref: string;
  sha: string;
  gitUrl: string;
};

export const GetDeploymentGitSourceDeploymentsResponse200Type = {
  Bitbucket: "bitbucket",
} as const;
export type GetDeploymentGitSourceDeploymentsResponse200Type = ClosedEnum<
  typeof GetDeploymentGitSourceDeploymentsResponse200Type
>;

export type GetDeploymentGitSourceDeployments5 = {
  type: GetDeploymentGitSourceDeploymentsResponse200Type;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponseType = {
  Bitbucket: "bitbucket",
} as const;
export type GetDeploymentGitSourceDeploymentsResponseType = ClosedEnum<
  typeof GetDeploymentGitSourceDeploymentsResponseType
>;

export type GetDeploymentGitSourceDeployments4 = {
  type: GetDeploymentGitSourceDeploymentsResponseType;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsType = {
  Gitlab: "gitlab",
} as const;
export type GetDeploymentGitSourceDeploymentsType = ClosedEnum<
  typeof GetDeploymentGitSourceDeploymentsType
>;

export type GetDeploymentGitSourceProjectId = string | number;

export type GetDeploymentGitSourceDeployments3 = {
  type: GetDeploymentGitSourceDeploymentsType;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceType = {
  Github: "github",
} as const;
export type GetDeploymentGitSourceType = ClosedEnum<
  typeof GetDeploymentGitSourceType
>;

export type GetDeploymentGitSourceDeployments2 = {
  type: GetDeploymentGitSourceType;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type =
  {
    Github: "github",
  } as const;
export type GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type =
  ClosedEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type
  >;

export type GetDeploymentGitSourceRepoId = string | number;

export type GetDeploymentGitSourceDeployments1 = {
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export type GetDeploymentResponseBodyGitSource =
  | GetDeploymentGitSourceDeployments6
  | GetDeploymentGitSourceDeployments8
  | GetDeploymentGitSourceDeployments1
  | GetDeploymentGitSourceDeployments3
  | GetDeploymentGitSourceDeployments2
  | GetDeploymentGitSourceDeployments4
  | GetDeploymentGitSourceDeployments5
  | GetDeploymentGitSourceDeployments7
  | GetDeploymentGitSourceDeployments9;

export type ResponseBodyProject = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export const ResponseBodyReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export type ResponseBodyReadySubstate = ClosedEnum<
  typeof ResponseBodyReadySubstate
>;

export const ResponseBodySource = {
  ApiTriggerGitDeploy: "api-trigger-git-deploy",
  Cli: "cli",
  CloneRepo: "clone/repo",
  Git: "git",
  Import: "import",
  ImportRepo: "import/repo",
  Redeploy: "redeploy",
} as const;
export type ResponseBodySource = ClosedEnum<typeof ResponseBodySource>;

export const ResponseBodyTarget = {
  Staging: "staging",
  Production: "production",
} as const;
export type ResponseBodyTarget = ClosedEnum<typeof ResponseBodyTarget>;

export type ResponseBodyOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const ResponseBodyPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type ResponseBodyPlan = ClosedEnum<typeof ResponseBodyPlan>;

export type ResponseBodyCrons = {
  schedule: string;
  path: string;
};

export type ResponseBodyFunctions = {
  memory?: number | undefined;
  maxDuration?: number | undefined;
  runtime?: string | undefined;
  includeFiles?: string | undefined;
  excludeFiles?: string | undefined;
};

export type GetDeploymentRoutes3 = {
  src: string;
  continue: boolean;
  middleware: number;
};

export const GetDeploymentRoutesHandle = {
  Error: "error",
  Filesystem: "filesystem",
  Hit: "hit",
  Miss: "miss",
  Rewrite: "rewrite",
  Resource: "resource",
} as const;
export type GetDeploymentRoutesHandle = ClosedEnum<
  typeof GetDeploymentRoutesHandle
>;

export type GetDeploymentRoutes2 = {
  handle: GetDeploymentRoutesHandle;
  src?: string | undefined;
  dest?: string | undefined;
  status?: number | undefined;
};

export const GetDeploymentHasType = {
  Header: "header",
  Cookie: "cookie",
  Query: "query",
} as const;
export type GetDeploymentHasType = ClosedEnum<typeof GetDeploymentHasType>;

export type GetDeploymentHas2 = {
  type: GetDeploymentHasType;
  key: string;
  value?: string | undefined;
};

export const GetDeploymentHasDeploymentsType = {
  Host: "host",
} as const;
export type GetDeploymentHasDeploymentsType = ClosedEnum<
  typeof GetDeploymentHasDeploymentsType
>;

export type GetDeploymentHas1 = {
  type: GetDeploymentHasDeploymentsType;
  value: string;
};

export type GetDeploymentRoutesHas = GetDeploymentHas1 | GetDeploymentHas2;

export const GetDeploymentMissingType = {
  Header: "header",
  Cookie: "cookie",
  Query: "query",
} as const;
export type GetDeploymentMissingType = ClosedEnum<
  typeof GetDeploymentMissingType
>;

export type GetDeploymentMissing2 = {
  type: GetDeploymentMissingType;
  key: string;
  value?: string | undefined;
};

export const GetDeploymentMissingDeploymentsType = {
  Host: "host",
} as const;
export type GetDeploymentMissingDeploymentsType = ClosedEnum<
  typeof GetDeploymentMissingDeploymentsType
>;

export type GetDeploymentMissing1 = {
  type: GetDeploymentMissingDeploymentsType;
  value: string;
};

export type GetDeploymentRoutesMissing =
  | GetDeploymentMissing1
  | GetDeploymentMissing2;

export type GetDeploymentRoutesLocale = {
  redirect?: { [k: string]: string } | undefined;
  cookie?: string | undefined;
};

export type GetDeploymentRoutes1 = {
  src: string;
  dest?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  methods?: Array<string> | undefined;
  continue?: boolean | undefined;
  override?: boolean | undefined;
  caseSensitive?: boolean | undefined;
  check?: boolean | undefined;
  important?: boolean | undefined;
  status?: number | undefined;
  has?: Array<GetDeploymentHas1 | GetDeploymentHas2> | undefined;
  missing?: Array<GetDeploymentMissing1 | GetDeploymentMissing2> | undefined;
  locale?: GetDeploymentRoutesLocale | undefined;
  /**
   * A middleware key within the `output` key under the build result. Overrides a `middleware` definition.
   */
  middlewarePath?: string | undefined;
  /**
   * The original middleware matchers.
   */
  middlewareRawSrc?: Array<string> | undefined;
  /**
   * A middleware index in the `middleware` key under the build result
   */
  middleware?: number | undefined;
};

export type ResponseBodyRoutes =
  | GetDeploymentRoutes3
  | GetDeploymentRoutes2
  | GetDeploymentRoutes1;

export const GetDeploymentGitRepoDeploymentsType = {
  Bitbucket: "bitbucket",
} as const;
export type GetDeploymentGitRepoDeploymentsType = ClosedEnum<
  typeof GetDeploymentGitRepoDeploymentsType
>;

export const GetDeploymentGitRepoOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type GetDeploymentGitRepoOwnerType = ClosedEnum<
  typeof GetDeploymentGitRepoOwnerType
>;

export type GetDeploymentGitRepo3 = {
  owner: string;
  repoUuid: string;
  slug: string;
  type: GetDeploymentGitRepoDeploymentsType;
  workspaceUuid: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: GetDeploymentGitRepoOwnerType;
};

export const GetDeploymentGitRepoType = {
  Github: "github",
} as const;
export type GetDeploymentGitRepoType = ClosedEnum<
  typeof GetDeploymentGitRepoType
>;

export const GetDeploymentGitRepoDeploymentsResponseOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type GetDeploymentGitRepoDeploymentsResponseOwnerType = ClosedEnum<
  typeof GetDeploymentGitRepoDeploymentsResponseOwnerType
>;

export type GetDeploymentGitRepo2 = {
  org: string;
  repo: string;
  repoId: number;
  type: GetDeploymentGitRepoType;
  repoOwnerId: number;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: GetDeploymentGitRepoDeploymentsResponseOwnerType;
};

export const GetDeploymentGitRepoDeploymentsResponseType = {
  Gitlab: "gitlab",
} as const;
export type GetDeploymentGitRepoDeploymentsResponseType = ClosedEnum<
  typeof GetDeploymentGitRepoDeploymentsResponseType
>;

export const GetDeploymentGitRepoDeploymentsOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type GetDeploymentGitRepoDeploymentsOwnerType = ClosedEnum<
  typeof GetDeploymentGitRepoDeploymentsOwnerType
>;

export type GetDeploymentGitRepo1 = {
  namespace: string;
  projectId: number;
  type: GetDeploymentGitRepoDeploymentsResponseType;
  url: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: GetDeploymentGitRepoDeploymentsOwnerType;
};

export type ResponseBodyGitRepo =
  | GetDeploymentGitRepo1
  | GetDeploymentGitRepo2
  | GetDeploymentGitRepo3;

/**
 * Flags defined in the Build Output API, used by this deployment. Primarily used by the Toolbar to know about the used flags.
 */
export type GetDeploymentFlags2 = {};

export type GetDeploymentFlagsOptions = {
  value: FlagJSONValue | null;
  label?: string | undefined;
};

export type GetDeploymentFlagsDefinitions = {
  options?: Array<GetDeploymentFlagsOptions> | undefined;
  url?: string | undefined;
  description?: string | undefined;
};

/**
 * Flags defined in the Build Output API, used by this deployment. Primarily used by the Toolbar to know about the used flags.
 */
export type GetDeploymentFlags1 = {
  definitions: { [k: string]: GetDeploymentFlagsDefinitions };
};

export type ResponseBodyFlags =
  | GetDeploymentFlags1
  | Array<GetDeploymentFlags2>;

/**
 * The deployment including both public and private information
 */
export type GetDeploymentResponseBody1 = {
  aliasAssignedAt?: number | boolean | null | undefined;
  alwaysRefuseToBuild?: boolean | undefined;
  build: ResponseBodyBuild;
  buildArtifactUrls?: Array<string> | undefined;
  builds?: Array<ResponseBodyBuilds> | undefined;
  env: Array<string>;
  inspectorUrl: string | null;
  isInConcurrentBuildsQueue: boolean;
  isInSystemBuildsQueue: boolean;
  projectSettings: ResponseBodyProjectSettings;
  readyStateReason?: string | undefined;
  integrations?: ResponseBodyIntegrations | undefined;
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: ResponseBodyCreator;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<GetDeploymentResponseBodyLambdas> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: ResponseBodyStatus;
  team?: GetDeploymentResponseBodyTeam | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | GetDeploymentCustomEnvironmentDeployments1
    | GetDeploymentCustomEnvironmentDeployments2
    | undefined;
  aliasWarning?: GetDeploymentResponseBodyAliasWarning | null | undefined;
  id: string;
  type: ResponseBodyType;
  createdAt: number;
  name: string;
  readyState: ResponseBodyReadyState;
  aliasError?: ResponseBodyAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  /**
   * applies to custom domains only, defaults to `true`
   */
  autoAssignCustomDomains?: boolean | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: ResponseBodyChecksState | undefined;
  checksConclusion?: ResponseBodyChecksConclusion | undefined;
  deletedAt?: number | null | undefined;
  /**
   * Computed field that is only available for deployments with a micro-frontend configuration.
   */
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorMessage?: string | null | undefined;
  errorStep?: string | undefined;
  /**
   * Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service
   */
  passiveRegions?: Array<string> | undefined;
  gitSource?:
    | GetDeploymentGitSourceDeployments6
    | GetDeploymentGitSourceDeployments8
    | GetDeploymentGitSourceDeployments1
    | GetDeploymentGitSourceDeployments3
    | GetDeploymentGitSourceDeployments2
    | GetDeploymentGitSourceDeployments4
    | GetDeploymentGitSourceDeployments5
    | GetDeploymentGitSourceDeployments7
    | GetDeploymentGitSourceDeployments9
    | undefined;
  meta: { [k: string]: string };
  project?: ResponseBodyProject | undefined;
  /**
   * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
   */
  readySubstate?: ResponseBodyReadySubstate | undefined;
  regions: Array<string>;
  softDeletedByRetention?: boolean | undefined;
  source?: ResponseBodySource | undefined;
  target?: ResponseBodyTarget | null | undefined;
  undeletedAt?: number | undefined;
  url: string;
  version: number;
  oidcTokenClaims?: ResponseBodyOidcTokenClaims | undefined;
  projectId: string;
  plan: ResponseBodyPlan;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdIn: string;
  crons?: Array<ResponseBodyCrons> | undefined;
  functions?: { [k: string]: ResponseBodyFunctions } | null | undefined;
  monorepoManager?: string | null | undefined;
  ownerId: string;
  /**
   * Since November 2023 this field defines a Secure Compute network that will only be used to deploy passive lambdas to (as in passiveRegions)
   */
  passiveConnectConfigurationId?: string | undefined;
  routes:
    | Array<GetDeploymentRoutes3 | GetDeploymentRoutes2 | GetDeploymentRoutes1>
    | null;
  gitRepo?:
    | GetDeploymentGitRepo1
    | GetDeploymentGitRepo2
    | GetDeploymentGitRepo3
    | null
    | undefined;
  flags?: GetDeploymentFlags1 | Array<GetDeploymentFlags2> | undefined;
};

/**
 * The deployment including only public information
 *
 * @remarks
 * The deployment including both public and private information
 */
export type GetDeploymentResponseBody =
  | GetDeploymentResponseBody2
  | GetDeploymentResponseBody1;

/** @internal */
export const GetDeploymentRequest$inboundSchema: z.ZodType<
  GetDeploymentRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrUrl: z.string(),
  withGitRepoInfo: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetDeploymentRequest$Outbound = {
  idOrUrl: string;
  withGitRepoInfo?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetDeploymentRequest$outboundSchema: z.ZodType<
  GetDeploymentRequest$Outbound,
  z.ZodTypeDef,
  GetDeploymentRequest
> = z.object({
  idOrUrl: z.string(),
  withGitRepoInfo: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRequest$ {
  /** @deprecated use `GetDeploymentRequest$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRequest$inboundSchema;
  /** @deprecated use `GetDeploymentRequest$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRequest$outboundSchema;
  /** @deprecated use `GetDeploymentRequest$Outbound` instead. */
  export type Outbound = GetDeploymentRequest$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyCreator$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/** @internal */
export type GetDeploymentResponseBodyCreator$Outbound = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

/** @internal */
export const GetDeploymentResponseBodyCreator$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyCreator$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyCreator
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyCreator$ {
  /** @deprecated use `GetDeploymentResponseBodyCreator$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyCreator$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyCreator$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyCreator$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyCreator$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyCreator$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyDeploymentsReadyState$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyDeploymentsReadyState> = z
    .nativeEnum(GetDeploymentResponseBodyDeploymentsReadyState);

/** @internal */
export const GetDeploymentResponseBodyDeploymentsReadyState$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyDeploymentsReadyState> =
    GetDeploymentResponseBodyDeploymentsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyDeploymentsReadyState$ {
  /** @deprecated use `GetDeploymentResponseBodyDeploymentsReadyState$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyDeploymentsReadyState$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyDeploymentsReadyState$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyDeploymentsReadyState$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyOutput$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/** @internal */
export type GetDeploymentResponseBodyOutput$Outbound = {
  path: string;
  functionName: string;
};

/** @internal */
export const GetDeploymentResponseBodyOutput$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyOutput$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyOutput
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyOutput$ {
  /** @deprecated use `GetDeploymentResponseBodyOutput$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyOutput$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyOutput$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyOutput$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyOutput$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyOutput$Outbound;
}

/** @internal */
export const ResponseBodyLambdas$inboundSchema: z.ZodType<
  ResponseBodyLambdas,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState: GetDeploymentResponseBodyDeploymentsReadyState$inboundSchema
    .optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => GetDeploymentResponseBodyOutput$inboundSchema)),
});

/** @internal */
export type ResponseBodyLambdas$Outbound = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: string | undefined;
  readyStateAt?: number | undefined;
  output: Array<GetDeploymentResponseBodyOutput$Outbound>;
};

/** @internal */
export const ResponseBodyLambdas$outboundSchema: z.ZodType<
  ResponseBodyLambdas$Outbound,
  z.ZodTypeDef,
  ResponseBodyLambdas
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState: GetDeploymentResponseBodyDeploymentsReadyState$outboundSchema
    .optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => GetDeploymentResponseBodyOutput$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyLambdas$ {
  /** @deprecated use `ResponseBodyLambdas$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyLambdas$inboundSchema;
  /** @deprecated use `ResponseBodyLambdas$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyLambdas$outboundSchema;
  /** @deprecated use `ResponseBodyLambdas$Outbound` instead. */
  export type Outbound = ResponseBodyLambdas$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyStatus$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyStatus
> = z.nativeEnum(GetDeploymentResponseBodyStatus);

/** @internal */
export const GetDeploymentResponseBodyStatus$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyStatus
> = GetDeploymentResponseBodyStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyStatus$ {
  /** @deprecated use `GetDeploymentResponseBodyStatus$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyStatus$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyStatus$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyStatus$outboundSchema;
}

/** @internal */
export const ResponseBodyTeam$inboundSchema: z.ZodType<
  ResponseBodyTeam,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  slug: z.string(),
  avatar: z.string().optional(),
});

/** @internal */
export type ResponseBodyTeam$Outbound = {
  id: string;
  name: string;
  slug: string;
  avatar?: string | undefined;
};

/** @internal */
export const ResponseBodyTeam$outboundSchema: z.ZodType<
  ResponseBodyTeam$Outbound,
  z.ZodTypeDef,
  ResponseBodyTeam
> = z.object({
  id: z.string(),
  name: z.string(),
  slug: z.string(),
  avatar: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyTeam$ {
  /** @deprecated use `ResponseBodyTeam$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyTeam$inboundSchema;
  /** @deprecated use `ResponseBodyTeam$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyTeam$outboundSchema;
  /** @deprecated use `ResponseBodyTeam$Outbound` instead. */
  export type Outbound = ResponseBodyTeam$Outbound;
}

/** @internal */
export const GetDeploymentCustomEnvironment2$inboundSchema: z.ZodType<
  GetDeploymentCustomEnvironment2,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
});

/** @internal */
export type GetDeploymentCustomEnvironment2$Outbound = {
  id: string;
};

/** @internal */
export const GetDeploymentCustomEnvironment2$outboundSchema: z.ZodType<
  GetDeploymentCustomEnvironment2$Outbound,
  z.ZodTypeDef,
  GetDeploymentCustomEnvironment2
> = z.object({
  id: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentCustomEnvironment2$ {
  /** @deprecated use `GetDeploymentCustomEnvironment2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentCustomEnvironment2$inboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironment2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentCustomEnvironment2$outboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironment2$Outbound` instead. */
  export type Outbound = GetDeploymentCustomEnvironment2$Outbound;
}

/** @internal */
export const GetDeploymentCustomEnvironment1$inboundSchema: z.ZodType<
  GetDeploymentCustomEnvironment1,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type GetDeploymentCustomEnvironment1$Outbound = {};

/** @internal */
export const GetDeploymentCustomEnvironment1$outboundSchema: z.ZodType<
  GetDeploymentCustomEnvironment1$Outbound,
  z.ZodTypeDef,
  GetDeploymentCustomEnvironment1
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentCustomEnvironment1$ {
  /** @deprecated use `GetDeploymentCustomEnvironment1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentCustomEnvironment1$inboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironment1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentCustomEnvironment1$outboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironment1$Outbound` instead. */
  export type Outbound = GetDeploymentCustomEnvironment1$Outbound;
}

/** @internal */
export const ResponseBodyCustomEnvironment$inboundSchema: z.ZodType<
  ResponseBodyCustomEnvironment,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentCustomEnvironment1$inboundSchema),
  z.lazy(() => GetDeploymentCustomEnvironment2$inboundSchema),
]);

/** @internal */
export type ResponseBodyCustomEnvironment$Outbound =
  | GetDeploymentCustomEnvironment1$Outbound
  | GetDeploymentCustomEnvironment2$Outbound;

/** @internal */
export const ResponseBodyCustomEnvironment$outboundSchema: z.ZodType<
  ResponseBodyCustomEnvironment$Outbound,
  z.ZodTypeDef,
  ResponseBodyCustomEnvironment
> = z.union([
  z.lazy(() => GetDeploymentCustomEnvironment1$outboundSchema),
  z.lazy(() => GetDeploymentCustomEnvironment2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyCustomEnvironment$ {
  /** @deprecated use `ResponseBodyCustomEnvironment$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyCustomEnvironment$inboundSchema;
  /** @deprecated use `ResponseBodyCustomEnvironment$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyCustomEnvironment$outboundSchema;
  /** @deprecated use `ResponseBodyCustomEnvironment$Outbound` instead. */
  export type Outbound = ResponseBodyCustomEnvironment$Outbound;
}

/** @internal */
export const ResponseBodyAliasWarning$inboundSchema: z.ZodType<
  ResponseBodyAliasWarning,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/** @internal */
export type ResponseBodyAliasWarning$Outbound = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

/** @internal */
export const ResponseBodyAliasWarning$outboundSchema: z.ZodType<
  ResponseBodyAliasWarning$Outbound,
  z.ZodTypeDef,
  ResponseBodyAliasWarning
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyAliasWarning$ {
  /** @deprecated use `ResponseBodyAliasWarning$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyAliasWarning$inboundSchema;
  /** @deprecated use `ResponseBodyAliasWarning$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyAliasWarning$outboundSchema;
  /** @deprecated use `ResponseBodyAliasWarning$Outbound` instead. */
  export type Outbound = ResponseBodyAliasWarning$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyType
> = z.nativeEnum(GetDeploymentResponseBodyType);

/** @internal */
export const GetDeploymentResponseBodyType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyType
> = GetDeploymentResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyType$ {
  /** @deprecated use `GetDeploymentResponseBodyType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyType$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyType$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyReadyState$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyReadyState
> = z.nativeEnum(GetDeploymentResponseBodyReadyState);

/** @internal */
export const GetDeploymentResponseBodyReadyState$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyReadyState> =
    GetDeploymentResponseBodyReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyReadyState$ {
  /** @deprecated use `GetDeploymentResponseBodyReadyState$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyReadyState$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyReadyState$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyReadyState$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyAliasError$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type GetDeploymentResponseBodyAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const GetDeploymentResponseBodyAliasError$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyAliasError$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyAliasError$ {
  /** @deprecated use `GetDeploymentResponseBodyAliasError$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyAliasError$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyAliasError$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyAliasError$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyAliasError$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyAliasError$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyChecksState$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyChecksState> = z.nativeEnum(
    GetDeploymentResponseBodyChecksState,
  );

/** @internal */
export const GetDeploymentResponseBodyChecksState$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyChecksState> =
    GetDeploymentResponseBodyChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyChecksState$ {
  /** @deprecated use `GetDeploymentResponseBodyChecksState$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyChecksState$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyChecksState$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyChecksState$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyChecksConclusion$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyChecksConclusion> = z
    .nativeEnum(GetDeploymentResponseBodyChecksConclusion);

/** @internal */
export const GetDeploymentResponseBodyChecksConclusion$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyChecksConclusion> =
    GetDeploymentResponseBodyChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyChecksConclusion$ {
  /** @deprecated use `GetDeploymentResponseBodyChecksConclusion$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyChecksConclusion$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyChecksConclusion$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyChecksConclusion$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource9$inboundSchema: z.ZodType<
  GetDeploymentGitSource9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/** @internal */
export type GetDeploymentGitSource9$Outbound = {
  type: string;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

/** @internal */
export const GetDeploymentGitSource9$outboundSchema: z.ZodType<
  GetDeploymentGitSource9$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource9
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody29Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource9$ {
  /** @deprecated use `GetDeploymentGitSource9$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource9$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource9$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource9$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource9$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource9$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource8$inboundSchema: z.ZodType<
  GetDeploymentGitSource8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/** @internal */
export type GetDeploymentGitSource8$Outbound = {
  type: string;
  ref: string;
  sha: string;
  projectId: number;
};

/** @internal */
export const GetDeploymentGitSource8$outboundSchema: z.ZodType<
  GetDeploymentGitSource8$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource8
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody28Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource8$ {
  /** @deprecated use `GetDeploymentGitSource8$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource8$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource8$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource8$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource8$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource8$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource7$inboundSchema: z.ZodType<
  GetDeploymentGitSource7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/** @internal */
export type GetDeploymentGitSource7$Outbound = {
  type: string;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

/** @internal */
export const GetDeploymentGitSource7$outboundSchema: z.ZodType<
  GetDeploymentGitSource7$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource7
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody27Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource7$ {
  /** @deprecated use `GetDeploymentGitSource7$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource7$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource7$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource7$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource7$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource7$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource6$inboundSchema: z.ZodType<
  GetDeploymentGitSource6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/** @internal */
export type GetDeploymentGitSource6$Outbound = {
  type: string;
  ref: string;
  sha: string;
  gitUrl: string;
};

/** @internal */
export const GetDeploymentGitSource6$outboundSchema: z.ZodType<
  GetDeploymentGitSource6$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource6
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody26Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource6$ {
  /** @deprecated use `GetDeploymentGitSource6$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource6$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource6$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource6$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource6$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource6$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource5$inboundSchema: z.ZodType<
  GetDeploymentGitSource5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$inboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSource5$Outbound = {
  type: string;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSource5$outboundSchema: z.ZodType<
  GetDeploymentGitSource5$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource5
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody25Type$outboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource5$ {
  /** @deprecated use `GetDeploymentGitSource5$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource5$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource5$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource5$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource5$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource5$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource4$inboundSchema: z.ZodType<
  GetDeploymentGitSource4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$inboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSource4$Outbound = {
  type: string;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSource4$outboundSchema: z.ZodType<
  GetDeploymentGitSource4$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource4
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody24Type$outboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource4$ {
  /** @deprecated use `GetDeploymentGitSource4$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource4$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource4$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource4$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource4$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource4$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsProjectId$inboundSchema:
  z.ZodType<GetDeploymentGitSourceDeploymentsProjectId, z.ZodTypeDef, unknown> =
    z.union([z.string(), z.number()]);

/** @internal */
export type GetDeploymentGitSourceDeploymentsProjectId$Outbound =
  | string
  | number;

/** @internal */
export const GetDeploymentGitSourceDeploymentsProjectId$outboundSchema:
  z.ZodType<
    GetDeploymentGitSourceDeploymentsProjectId$Outbound,
    z.ZodTypeDef,
    GetDeploymentGitSourceDeploymentsProjectId
  > = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsProjectId$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsProjectId$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsProjectId$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsProjectId$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsProjectId$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsProjectId$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeploymentsProjectId$Outbound;
}

/** @internal */
export const GetDeploymentGitSource3$inboundSchema: z.ZodType<
  GetDeploymentGitSource3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$inboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSource3$Outbound = {
  type: string;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSource3$outboundSchema: z.ZodType<
  GetDeploymentGitSource3$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource3
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody23Type$outboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource3$ {
  /** @deprecated use `GetDeploymentGitSource3$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource3$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource3$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource3$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource3$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource3$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSource2$inboundSchema: z.ZodType<
  GetDeploymentGitSource2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$inboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSource2$Outbound = {
  type: string;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSource2$outboundSchema: z.ZodType<
  GetDeploymentGitSource2$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource2
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody22Type$outboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource2$ {
  /** @deprecated use `GetDeploymentGitSource2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource2$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource2$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource2$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource2$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsRepoId$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeploymentsRepoId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GetDeploymentGitSourceDeploymentsRepoId$Outbound = string | number;

/** @internal */
export const GetDeploymentGitSourceDeploymentsRepoId$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeploymentsRepoId$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeploymentsRepoId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsRepoId$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsRepoId$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsRepoId$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsRepoId$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsRepoId$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsRepoId$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeploymentsRepoId$Outbound;
}

/** @internal */
export const GetDeploymentGitSource1$inboundSchema: z.ZodType<
  GetDeploymentGitSource1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$inboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSource1$Outbound = {
  type: string;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSource1$outboundSchema: z.ZodType<
  GetDeploymentGitSource1$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSource1
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody2Type$outboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSource1$ {
  /** @deprecated use `GetDeploymentGitSource1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSource1$inboundSchema;
  /** @deprecated use `GetDeploymentGitSource1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSource1$outboundSchema;
  /** @deprecated use `GetDeploymentGitSource1$Outbound` instead. */
  export type Outbound = GetDeploymentGitSource1$Outbound;
}

/** @internal */
export const ResponseBodyGitSource$inboundSchema: z.ZodType<
  ResponseBodyGitSource,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentGitSource6$inboundSchema),
  z.lazy(() => GetDeploymentGitSource8$inboundSchema),
  z.lazy(() => GetDeploymentGitSource1$inboundSchema),
  z.lazy(() => GetDeploymentGitSource3$inboundSchema),
  z.lazy(() => GetDeploymentGitSource2$inboundSchema),
  z.lazy(() => GetDeploymentGitSource4$inboundSchema),
  z.lazy(() => GetDeploymentGitSource5$inboundSchema),
  z.lazy(() => GetDeploymentGitSource7$inboundSchema),
  z.lazy(() => GetDeploymentGitSource9$inboundSchema),
]);

/** @internal */
export type ResponseBodyGitSource$Outbound =
  | GetDeploymentGitSource6$Outbound
  | GetDeploymentGitSource8$Outbound
  | GetDeploymentGitSource1$Outbound
  | GetDeploymentGitSource3$Outbound
  | GetDeploymentGitSource2$Outbound
  | GetDeploymentGitSource4$Outbound
  | GetDeploymentGitSource5$Outbound
  | GetDeploymentGitSource7$Outbound
  | GetDeploymentGitSource9$Outbound;

/** @internal */
export const ResponseBodyGitSource$outboundSchema: z.ZodType<
  ResponseBodyGitSource$Outbound,
  z.ZodTypeDef,
  ResponseBodyGitSource
> = z.union([
  z.lazy(() => GetDeploymentGitSource6$outboundSchema),
  z.lazy(() => GetDeploymentGitSource8$outboundSchema),
  z.lazy(() => GetDeploymentGitSource1$outboundSchema),
  z.lazy(() => GetDeploymentGitSource3$outboundSchema),
  z.lazy(() => GetDeploymentGitSource2$outboundSchema),
  z.lazy(() => GetDeploymentGitSource4$outboundSchema),
  z.lazy(() => GetDeploymentGitSource5$outboundSchema),
  z.lazy(() => GetDeploymentGitSource7$outboundSchema),
  z.lazy(() => GetDeploymentGitSource9$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyGitSource$ {
  /** @deprecated use `ResponseBodyGitSource$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyGitSource$inboundSchema;
  /** @deprecated use `ResponseBodyGitSource$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyGitSource$outboundSchema;
  /** @deprecated use `ResponseBodyGitSource$Outbound` instead. */
  export type Outbound = ResponseBodyGitSource$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyProject$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyProject,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/** @internal */
export type GetDeploymentResponseBodyProject$Outbound = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

/** @internal */
export const GetDeploymentResponseBodyProject$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyProject$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyProject
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyProject$ {
  /** @deprecated use `GetDeploymentResponseBodyProject$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyProject$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyProject$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyProject$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyProject$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyProject$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyReadySubstate$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyReadySubstate> = z.nativeEnum(
    GetDeploymentResponseBodyReadySubstate,
  );

/** @internal */
export const GetDeploymentResponseBodyReadySubstate$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyReadySubstate> =
    GetDeploymentResponseBodyReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyReadySubstate$ {
  /** @deprecated use `GetDeploymentResponseBodyReadySubstate$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyReadySubstate$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyReadySubstate$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyReadySubstate$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodySource$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodySource
> = z.nativeEnum(GetDeploymentResponseBodySource);

/** @internal */
export const GetDeploymentResponseBodySource$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodySource
> = GetDeploymentResponseBodySource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodySource$ {
  /** @deprecated use `GetDeploymentResponseBodySource$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodySource$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodySource$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodySource$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyTarget$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyTarget
> = z.nativeEnum(GetDeploymentResponseBodyTarget);

/** @internal */
export const GetDeploymentResponseBodyTarget$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentResponseBodyTarget
> = GetDeploymentResponseBodyTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyTarget$ {
  /** @deprecated use `GetDeploymentResponseBodyTarget$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyTarget$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyTarget$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyTarget$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyOidcTokenClaims$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type GetDeploymentResponseBodyOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const GetDeploymentResponseBodyOidcTokenClaims$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyOidcTokenClaims$ {
  /** @deprecated use `GetDeploymentResponseBodyOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyOidcTokenClaims$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyOidcTokenClaims$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyOidcTokenClaims$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyOidcTokenClaims$Outbound;
}

/** @internal */
export const GetDeploymentResponseBody2$inboundSchema: z.ZodType<
  GetDeploymentResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => GetDeploymentResponseBodyCreator$inboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => ResponseBodyLambdas$inboundSchema)).optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: GetDeploymentResponseBodyStatus$inboundSchema,
  team: z.lazy(() => ResponseBodyTeam$inboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => GetDeploymentCustomEnvironment1$inboundSchema),
    z.lazy(() => GetDeploymentCustomEnvironment2$inboundSchema),
  ]).optional(),
  aliasWarning: z.nullable(z.lazy(() => ResponseBodyAliasWarning$inboundSchema))
    .optional(),
  id: z.string(),
  type: GetDeploymentResponseBodyType$inboundSchema,
  createdAt: z.number(),
  name: z.string(),
  readyState: GetDeploymentResponseBodyReadyState$inboundSchema,
  aliasError: z.nullable(
    z.lazy(() => GetDeploymentResponseBodyAliasError$inboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: GetDeploymentResponseBodyChecksState$inboundSchema.optional(),
  checksConclusion: GetDeploymentResponseBodyChecksConclusion$inboundSchema
    .optional(),
  deletedAt: z.nullable(z.number()).optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.nullable(z.string()).optional(),
  errorStep: z.string().optional(),
  passiveRegions: z.array(z.string()).optional(),
  gitSource: z.union([
    z.lazy(() => GetDeploymentGitSource6$inboundSchema),
    z.lazy(() => GetDeploymentGitSource8$inboundSchema),
    z.lazy(() => GetDeploymentGitSource1$inboundSchema),
    z.lazy(() => GetDeploymentGitSource3$inboundSchema),
    z.lazy(() => GetDeploymentGitSource2$inboundSchema),
    z.lazy(() => GetDeploymentGitSource4$inboundSchema),
    z.lazy(() => GetDeploymentGitSource5$inboundSchema),
    z.lazy(() => GetDeploymentGitSource7$inboundSchema),
    z.lazy(() => GetDeploymentGitSource9$inboundSchema),
  ]).optional(),
  meta: z.record(z.string()),
  project: z.lazy(() => GetDeploymentResponseBodyProject$inboundSchema)
    .optional(),
  readySubstate: GetDeploymentResponseBodyReadySubstate$inboundSchema
    .optional(),
  regions: z.array(z.string()),
  softDeletedByRetention: z.boolean().optional(),
  source: GetDeploymentResponseBodySource$inboundSchema.optional(),
  target: z.nullable(GetDeploymentResponseBodyTarget$inboundSchema).optional(),
  undeletedAt: z.number().optional(),
  url: z.string(),
  version: z.number(),
  oidcTokenClaims: z.lazy(() =>
    GetDeploymentResponseBodyOidcTokenClaims$inboundSchema
  ).optional(),
});

/** @internal */
export type GetDeploymentResponseBody2$Outbound = {
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: GetDeploymentResponseBodyCreator$Outbound;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<ResponseBodyLambdas$Outbound> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: string;
  team?: ResponseBodyTeam$Outbound | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | GetDeploymentCustomEnvironment1$Outbound
    | GetDeploymentCustomEnvironment2$Outbound
    | undefined;
  aliasWarning?: ResponseBodyAliasWarning$Outbound | null | undefined;
  id: string;
  type: string;
  createdAt: number;
  name: string;
  readyState: string;
  aliasError?: GetDeploymentResponseBodyAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: string | undefined;
  checksConclusion?: string | undefined;
  deletedAt?: number | null | undefined;
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorMessage?: string | null | undefined;
  errorStep?: string | undefined;
  passiveRegions?: Array<string> | undefined;
  gitSource?:
    | GetDeploymentGitSource6$Outbound
    | GetDeploymentGitSource8$Outbound
    | GetDeploymentGitSource1$Outbound
    | GetDeploymentGitSource3$Outbound
    | GetDeploymentGitSource2$Outbound
    | GetDeploymentGitSource4$Outbound
    | GetDeploymentGitSource5$Outbound
    | GetDeploymentGitSource7$Outbound
    | GetDeploymentGitSource9$Outbound
    | undefined;
  meta: { [k: string]: string };
  project?: GetDeploymentResponseBodyProject$Outbound | undefined;
  readySubstate?: string | undefined;
  regions: Array<string>;
  softDeletedByRetention?: boolean | undefined;
  source?: string | undefined;
  target?: string | null | undefined;
  undeletedAt?: number | undefined;
  url: string;
  version: number;
  oidcTokenClaims?:
    | GetDeploymentResponseBodyOidcTokenClaims$Outbound
    | undefined;
};

/** @internal */
export const GetDeploymentResponseBody2$outboundSchema: z.ZodType<
  GetDeploymentResponseBody2$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBody2
> = z.object({
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => GetDeploymentResponseBodyCreator$outboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => ResponseBodyLambdas$outboundSchema)).optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: GetDeploymentResponseBodyStatus$outboundSchema,
  team: z.lazy(() => ResponseBodyTeam$outboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => GetDeploymentCustomEnvironment1$outboundSchema),
    z.lazy(() => GetDeploymentCustomEnvironment2$outboundSchema),
  ]).optional(),
  aliasWarning: z.nullable(
    z.lazy(() => ResponseBodyAliasWarning$outboundSchema),
  ).optional(),
  id: z.string(),
  type: GetDeploymentResponseBodyType$outboundSchema,
  createdAt: z.number(),
  name: z.string(),
  readyState: GetDeploymentResponseBodyReadyState$outboundSchema,
  aliasError: z.nullable(
    z.lazy(() => GetDeploymentResponseBodyAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: GetDeploymentResponseBodyChecksState$outboundSchema.optional(),
  checksConclusion: GetDeploymentResponseBodyChecksConclusion$outboundSchema
    .optional(),
  deletedAt: z.nullable(z.number()).optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.nullable(z.string()).optional(),
  errorStep: z.string().optional(),
  passiveRegions: z.array(z.string()).optional(),
  gitSource: z.union([
    z.lazy(() => GetDeploymentGitSource6$outboundSchema),
    z.lazy(() => GetDeploymentGitSource8$outboundSchema),
    z.lazy(() => GetDeploymentGitSource1$outboundSchema),
    z.lazy(() => GetDeploymentGitSource3$outboundSchema),
    z.lazy(() => GetDeploymentGitSource2$outboundSchema),
    z.lazy(() => GetDeploymentGitSource4$outboundSchema),
    z.lazy(() => GetDeploymentGitSource5$outboundSchema),
    z.lazy(() => GetDeploymentGitSource7$outboundSchema),
    z.lazy(() => GetDeploymentGitSource9$outboundSchema),
  ]).optional(),
  meta: z.record(z.string()),
  project: z.lazy(() => GetDeploymentResponseBodyProject$outboundSchema)
    .optional(),
  readySubstate: GetDeploymentResponseBodyReadySubstate$outboundSchema
    .optional(),
  regions: z.array(z.string()),
  softDeletedByRetention: z.boolean().optional(),
  source: GetDeploymentResponseBodySource$outboundSchema.optional(),
  target: z.nullable(GetDeploymentResponseBodyTarget$outboundSchema).optional(),
  undeletedAt: z.number().optional(),
  url: z.string(),
  version: z.number(),
  oidcTokenClaims: z.lazy(() =>
    GetDeploymentResponseBodyOidcTokenClaims$outboundSchema
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBody2$ {
  /** @deprecated use `GetDeploymentResponseBody2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBody2$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBody2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBody2$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBody2$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBody2$Outbound;
}

/** @internal */
export const ResponseBodyAliasAssignedAt$inboundSchema: z.ZodType<
  ResponseBodyAliasAssignedAt,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type ResponseBodyAliasAssignedAt$Outbound = number | boolean;

/** @internal */
export const ResponseBodyAliasAssignedAt$outboundSchema: z.ZodType<
  ResponseBodyAliasAssignedAt$Outbound,
  z.ZodTypeDef,
  ResponseBodyAliasAssignedAt
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyAliasAssignedAt$ {
  /** @deprecated use `ResponseBodyAliasAssignedAt$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyAliasAssignedAt$inboundSchema;
  /** @deprecated use `ResponseBodyAliasAssignedAt$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyAliasAssignedAt$outboundSchema;
  /** @deprecated use `ResponseBodyAliasAssignedAt$Outbound` instead. */
  export type Outbound = ResponseBodyAliasAssignedAt$Outbound;
}

/** @internal */
export const ResponseBodyBuild$inboundSchema: z.ZodType<
  ResponseBodyBuild,
  z.ZodTypeDef,
  unknown
> = z.object({
  env: z.array(z.string()),
});

/** @internal */
export type ResponseBodyBuild$Outbound = {
  env: Array<string>;
};

/** @internal */
export const ResponseBodyBuild$outboundSchema: z.ZodType<
  ResponseBodyBuild$Outbound,
  z.ZodTypeDef,
  ResponseBodyBuild
> = z.object({
  env: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyBuild$ {
  /** @deprecated use `ResponseBodyBuild$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyBuild$inboundSchema;
  /** @deprecated use `ResponseBodyBuild$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyBuild$outboundSchema;
  /** @deprecated use `ResponseBodyBuild$Outbound` instead. */
  export type Outbound = ResponseBodyBuild$Outbound;
}

/** @internal */
export const ResponseBodyBuilds$inboundSchema: z.ZodType<
  ResponseBodyBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type ResponseBodyBuilds$Outbound = {};

/** @internal */
export const ResponseBodyBuilds$outboundSchema: z.ZodType<
  ResponseBodyBuilds$Outbound,
  z.ZodTypeDef,
  ResponseBodyBuilds
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyBuilds$ {
  /** @deprecated use `ResponseBodyBuilds$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyBuilds$inboundSchema;
  /** @deprecated use `ResponseBodyBuilds$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyBuilds$outboundSchema;
  /** @deprecated use `ResponseBodyBuilds$Outbound` instead. */
  export type Outbound = ResponseBodyBuilds$Outbound;
}

/** @internal */
export const ResponseBodyFramework$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyFramework
> = z.nativeEnum(ResponseBodyFramework);

/** @internal */
export const ResponseBodyFramework$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyFramework
> = ResponseBodyFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyFramework$ {
  /** @deprecated use `ResponseBodyFramework$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyFramework$inboundSchema;
  /** @deprecated use `ResponseBodyFramework$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyFramework$outboundSchema;
}

/** @internal */
export const ResponseBodySpeedInsights$inboundSchema: z.ZodType<
  ResponseBodySpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type ResponseBodySpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const ResponseBodySpeedInsights$outboundSchema: z.ZodType<
  ResponseBodySpeedInsights$Outbound,
  z.ZodTypeDef,
  ResponseBodySpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodySpeedInsights$ {
  /** @deprecated use `ResponseBodySpeedInsights$inboundSchema` instead. */
  export const inboundSchema = ResponseBodySpeedInsights$inboundSchema;
  /** @deprecated use `ResponseBodySpeedInsights$outboundSchema` instead. */
  export const outboundSchema = ResponseBodySpeedInsights$outboundSchema;
  /** @deprecated use `ResponseBodySpeedInsights$Outbound` instead. */
  export type Outbound = ResponseBodySpeedInsights$Outbound;
}

/** @internal */
export const ResponseBodyWebAnalytics$inboundSchema: z.ZodType<
  ResponseBodyWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type ResponseBodyWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const ResponseBodyWebAnalytics$outboundSchema: z.ZodType<
  ResponseBodyWebAnalytics$Outbound,
  z.ZodTypeDef,
  ResponseBodyWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyWebAnalytics$ {
  /** @deprecated use `ResponseBodyWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyWebAnalytics$inboundSchema;
  /** @deprecated use `ResponseBodyWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyWebAnalytics$outboundSchema;
  /** @deprecated use `ResponseBodyWebAnalytics$Outbound` instead. */
  export type Outbound = ResponseBodyWebAnalytics$Outbound;
}

/** @internal */
export const ResponseBodyProjectSettings$inboundSchema: z.ZodType<
  ResponseBodyProjectSettings,
  z.ZodTypeDef,
  unknown
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(ResponseBodyFramework$inboundSchema).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  installCommand: z.nullable(z.string()).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  speedInsights: z.lazy(() => ResponseBodySpeedInsights$inboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => ResponseBodyWebAnalytics$inboundSchema).optional(),
});

/** @internal */
export type ResponseBodyProjectSettings$Outbound = {
  buildCommand?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  installCommand?: string | null | undefined;
  outputDirectory?: string | null | undefined;
  speedInsights?: ResponseBodySpeedInsights$Outbound | undefined;
  webAnalytics?: ResponseBodyWebAnalytics$Outbound | undefined;
};

/** @internal */
export const ResponseBodyProjectSettings$outboundSchema: z.ZodType<
  ResponseBodyProjectSettings$Outbound,
  z.ZodTypeDef,
  ResponseBodyProjectSettings
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(ResponseBodyFramework$outboundSchema).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  installCommand: z.nullable(z.string()).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  speedInsights: z.lazy(() => ResponseBodySpeedInsights$outboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => ResponseBodyWebAnalytics$outboundSchema)
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyProjectSettings$ {
  /** @deprecated use `ResponseBodyProjectSettings$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyProjectSettings$inboundSchema;
  /** @deprecated use `ResponseBodyProjectSettings$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyProjectSettings$outboundSchema;
  /** @deprecated use `ResponseBodyProjectSettings$Outbound` instead. */
  export type Outbound = ResponseBodyProjectSettings$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyDeploymentsStatus$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyDeploymentsStatus> = z
    .nativeEnum(GetDeploymentResponseBodyDeploymentsStatus);

/** @internal */
export const GetDeploymentResponseBodyDeploymentsStatus$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentResponseBodyDeploymentsStatus> =
    GetDeploymentResponseBodyDeploymentsStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyDeploymentsStatus$ {
  /** @deprecated use `GetDeploymentResponseBodyDeploymentsStatus$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyDeploymentsStatus$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyDeploymentsStatus$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyDeploymentsStatus$outboundSchema;
}

/** @internal */
export const ResponseBodyIntegrations$inboundSchema: z.ZodType<
  ResponseBodyIntegrations,
  z.ZodTypeDef,
  unknown
> = z.object({
  status: GetDeploymentResponseBodyDeploymentsStatus$inboundSchema,
  startedAt: z.number(),
  completedAt: z.number().optional(),
  skippedAt: z.number().optional(),
  skippedBy: z.string().optional(),
});

/** @internal */
export type ResponseBodyIntegrations$Outbound = {
  status: string;
  startedAt: number;
  completedAt?: number | undefined;
  skippedAt?: number | undefined;
  skippedBy?: string | undefined;
};

/** @internal */
export const ResponseBodyIntegrations$outboundSchema: z.ZodType<
  ResponseBodyIntegrations$Outbound,
  z.ZodTypeDef,
  ResponseBodyIntegrations
> = z.object({
  status: GetDeploymentResponseBodyDeploymentsStatus$outboundSchema,
  startedAt: z.number(),
  completedAt: z.number().optional(),
  skippedAt: z.number().optional(),
  skippedBy: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyIntegrations$ {
  /** @deprecated use `ResponseBodyIntegrations$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyIntegrations$inboundSchema;
  /** @deprecated use `ResponseBodyIntegrations$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyIntegrations$outboundSchema;
  /** @deprecated use `ResponseBodyIntegrations$Outbound` instead. */
  export type Outbound = ResponseBodyIntegrations$Outbound;
}

/** @internal */
export const ResponseBodyCreator$inboundSchema: z.ZodType<
  ResponseBodyCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/** @internal */
export type ResponseBodyCreator$Outbound = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

/** @internal */
export const ResponseBodyCreator$outboundSchema: z.ZodType<
  ResponseBodyCreator$Outbound,
  z.ZodTypeDef,
  ResponseBodyCreator
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyCreator$ {
  /** @deprecated use `ResponseBodyCreator$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyCreator$inboundSchema;
  /** @deprecated use `ResponseBodyCreator$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyCreator$outboundSchema;
  /** @deprecated use `ResponseBodyCreator$Outbound` instead. */
  export type Outbound = ResponseBodyCreator$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyDeploymentsResponseReadyState$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentResponseBodyDeploymentsResponseReadyState
  > = z.nativeEnum(GetDeploymentResponseBodyDeploymentsResponseReadyState);

/** @internal */
export const GetDeploymentResponseBodyDeploymentsResponseReadyState$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentResponseBodyDeploymentsResponseReadyState
  > = GetDeploymentResponseBodyDeploymentsResponseReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyDeploymentsResponseReadyState$ {
  /** @deprecated use `GetDeploymentResponseBodyDeploymentsResponseReadyState$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyDeploymentsResponseReadyState$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyDeploymentsResponseReadyState$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyDeploymentsResponseReadyState$outboundSchema;
}

/** @internal */
export const ResponseBodyOutput$inboundSchema: z.ZodType<
  ResponseBodyOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/** @internal */
export type ResponseBodyOutput$Outbound = {
  path: string;
  functionName: string;
};

/** @internal */
export const ResponseBodyOutput$outboundSchema: z.ZodType<
  ResponseBodyOutput$Outbound,
  z.ZodTypeDef,
  ResponseBodyOutput
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyOutput$ {
  /** @deprecated use `ResponseBodyOutput$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyOutput$inboundSchema;
  /** @deprecated use `ResponseBodyOutput$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyOutput$outboundSchema;
  /** @deprecated use `ResponseBodyOutput$Outbound` instead. */
  export type Outbound = ResponseBodyOutput$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyLambdas$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyLambdas,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState:
    GetDeploymentResponseBodyDeploymentsResponseReadyState$inboundSchema
      .optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => ResponseBodyOutput$inboundSchema)),
});

/** @internal */
export type GetDeploymentResponseBodyLambdas$Outbound = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: string | undefined;
  readyStateAt?: number | undefined;
  output: Array<ResponseBodyOutput$Outbound>;
};

/** @internal */
export const GetDeploymentResponseBodyLambdas$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyLambdas$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyLambdas
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState:
    GetDeploymentResponseBodyDeploymentsResponseReadyState$outboundSchema
      .optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => ResponseBodyOutput$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyLambdas$ {
  /** @deprecated use `GetDeploymentResponseBodyLambdas$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyLambdas$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyLambdas$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyLambdas$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyLambdas$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyLambdas$Outbound;
}

/** @internal */
export const ResponseBodyStatus$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyStatus
> = z.nativeEnum(ResponseBodyStatus);

/** @internal */
export const ResponseBodyStatus$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyStatus
> = ResponseBodyStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyStatus$ {
  /** @deprecated use `ResponseBodyStatus$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyStatus$inboundSchema;
  /** @deprecated use `ResponseBodyStatus$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyStatus$outboundSchema;
}

/** @internal */
export const GetDeploymentResponseBodyTeam$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyTeam,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  slug: z.string(),
  avatar: z.string().optional(),
});

/** @internal */
export type GetDeploymentResponseBodyTeam$Outbound = {
  id: string;
  name: string;
  slug: string;
  avatar?: string | undefined;
};

/** @internal */
export const GetDeploymentResponseBodyTeam$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyTeam$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyTeam
> = z.object({
  id: z.string(),
  name: z.string(),
  slug: z.string(),
  avatar: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyTeam$ {
  /** @deprecated use `GetDeploymentResponseBodyTeam$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyTeam$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyTeam$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBodyTeam$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyTeam$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyTeam$Outbound;
}

/** @internal */
export const GetDeploymentCustomEnvironmentDeployments2$inboundSchema:
  z.ZodType<GetDeploymentCustomEnvironmentDeployments2, z.ZodTypeDef, unknown> =
    z.object({
      id: z.string(),
    });

/** @internal */
export type GetDeploymentCustomEnvironmentDeployments2$Outbound = {
  id: string;
};

/** @internal */
export const GetDeploymentCustomEnvironmentDeployments2$outboundSchema:
  z.ZodType<
    GetDeploymentCustomEnvironmentDeployments2$Outbound,
    z.ZodTypeDef,
    GetDeploymentCustomEnvironmentDeployments2
  > = z.object({
    id: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentCustomEnvironmentDeployments2$ {
  /** @deprecated use `GetDeploymentCustomEnvironmentDeployments2$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentCustomEnvironmentDeployments2$inboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironmentDeployments2$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentCustomEnvironmentDeployments2$outboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironmentDeployments2$Outbound` instead. */
  export type Outbound = GetDeploymentCustomEnvironmentDeployments2$Outbound;
}

/** @internal */
export const GetDeploymentCustomEnvironmentDeployments1$inboundSchema:
  z.ZodType<GetDeploymentCustomEnvironmentDeployments1, z.ZodTypeDef, unknown> =
    z.object({});

/** @internal */
export type GetDeploymentCustomEnvironmentDeployments1$Outbound = {};

/** @internal */
export const GetDeploymentCustomEnvironmentDeployments1$outboundSchema:
  z.ZodType<
    GetDeploymentCustomEnvironmentDeployments1$Outbound,
    z.ZodTypeDef,
    GetDeploymentCustomEnvironmentDeployments1
  > = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentCustomEnvironmentDeployments1$ {
  /** @deprecated use `GetDeploymentCustomEnvironmentDeployments1$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentCustomEnvironmentDeployments1$inboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironmentDeployments1$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentCustomEnvironmentDeployments1$outboundSchema;
  /** @deprecated use `GetDeploymentCustomEnvironmentDeployments1$Outbound` instead. */
  export type Outbound = GetDeploymentCustomEnvironmentDeployments1$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyCustomEnvironment$inboundSchema:
  z.ZodType<GetDeploymentResponseBodyCustomEnvironment, z.ZodTypeDef, unknown> =
    z.union([
      z.lazy(() => GetDeploymentCustomEnvironmentDeployments1$inboundSchema),
      z.lazy(() => GetDeploymentCustomEnvironmentDeployments2$inboundSchema),
    ]);

/** @internal */
export type GetDeploymentResponseBodyCustomEnvironment$Outbound =
  | GetDeploymentCustomEnvironmentDeployments1$Outbound
  | GetDeploymentCustomEnvironmentDeployments2$Outbound;

/** @internal */
export const GetDeploymentResponseBodyCustomEnvironment$outboundSchema:
  z.ZodType<
    GetDeploymentResponseBodyCustomEnvironment$Outbound,
    z.ZodTypeDef,
    GetDeploymentResponseBodyCustomEnvironment
  > = z.union([
    z.lazy(() => GetDeploymentCustomEnvironmentDeployments1$outboundSchema),
    z.lazy(() => GetDeploymentCustomEnvironmentDeployments2$outboundSchema),
  ]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyCustomEnvironment$ {
  /** @deprecated use `GetDeploymentResponseBodyCustomEnvironment$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyCustomEnvironment$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyCustomEnvironment$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyCustomEnvironment$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyCustomEnvironment$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyCustomEnvironment$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyAliasWarning$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyAliasWarning,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/** @internal */
export type GetDeploymentResponseBodyAliasWarning$Outbound = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

/** @internal */
export const GetDeploymentResponseBodyAliasWarning$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyAliasWarning$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyAliasWarning
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyAliasWarning$ {
  /** @deprecated use `GetDeploymentResponseBodyAliasWarning$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentResponseBodyAliasWarning$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyAliasWarning$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyAliasWarning$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyAliasWarning$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyAliasWarning$Outbound;
}

/** @internal */
export const ResponseBodyType$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyType
> = z.nativeEnum(ResponseBodyType);

/** @internal */
export const ResponseBodyType$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyType
> = ResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyType$ {
  /** @deprecated use `ResponseBodyType$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyType$inboundSchema;
  /** @deprecated use `ResponseBodyType$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyType$outboundSchema;
}

/** @internal */
export const ResponseBodyReadyState$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyReadyState
> = z.nativeEnum(ResponseBodyReadyState);

/** @internal */
export const ResponseBodyReadyState$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyReadyState
> = ResponseBodyReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyReadyState$ {
  /** @deprecated use `ResponseBodyReadyState$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyReadyState$inboundSchema;
  /** @deprecated use `ResponseBodyReadyState$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyReadyState$outboundSchema;
}

/** @internal */
export const ResponseBodyAliasError$inboundSchema: z.ZodType<
  ResponseBodyAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type ResponseBodyAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const ResponseBodyAliasError$outboundSchema: z.ZodType<
  ResponseBodyAliasError$Outbound,
  z.ZodTypeDef,
  ResponseBodyAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyAliasError$ {
  /** @deprecated use `ResponseBodyAliasError$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyAliasError$inboundSchema;
  /** @deprecated use `ResponseBodyAliasError$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyAliasError$outboundSchema;
  /** @deprecated use `ResponseBodyAliasError$Outbound` instead. */
  export type Outbound = ResponseBodyAliasError$Outbound;
}

/** @internal */
export const ResponseBodyChecksState$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyChecksState
> = z.nativeEnum(ResponseBodyChecksState);

/** @internal */
export const ResponseBodyChecksState$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyChecksState
> = ResponseBodyChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyChecksState$ {
  /** @deprecated use `ResponseBodyChecksState$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyChecksState$inboundSchema;
  /** @deprecated use `ResponseBodyChecksState$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyChecksState$outboundSchema;
}

/** @internal */
export const ResponseBodyChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyChecksConclusion
> = z.nativeEnum(ResponseBodyChecksConclusion);

/** @internal */
export const ResponseBodyChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyChecksConclusion
> = ResponseBodyChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyChecksConclusion$ {
  /** @deprecated use `ResponseBodyChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyChecksConclusion$inboundSchema;
  /** @deprecated use `ResponseBodyChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyChecksConclusion$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments9$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments9$Outbound = {
  type: string;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

/** @internal */
export const GetDeploymentGitSourceDeployments9$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments9$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments9
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody19Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments9$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments9$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments9$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments9$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments9$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments9$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments9$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments8$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments8$Outbound = {
  type: string;
  ref: string;
  sha: string;
  projectId: number;
};

/** @internal */
export const GetDeploymentGitSourceDeployments8$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments8$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments8
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody1Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments8$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments8$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments8$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments8$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments8$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments8$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments8$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments7$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments7$Outbound = {
  type: string;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

/** @internal */
export const GetDeploymentGitSourceDeployments7$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments7$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments7
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments7$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments7$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments7$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments7$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments7$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments7$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments7$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments6$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments6$Outbound = {
  type: string;
  ref: string;
  sha: string;
  gitUrl: string;
};

/** @internal */
export const GetDeploymentGitSourceDeployments6$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments6$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments6
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments6$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments6$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments6$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments6$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments6$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments6$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments6$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitSourceDeploymentsResponse200Type> = z
    .nativeEnum(GetDeploymentGitSourceDeploymentsResponse200Type);

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitSourceDeploymentsResponse200Type> =
    GetDeploymentGitSourceDeploymentsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments5$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentGitSourceDeploymentsResponse200Type$inboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments5$Outbound = {
  type: string;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSourceDeployments5$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments5$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments5
> = z.object({
  type: GetDeploymentGitSourceDeploymentsResponse200Type$outboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments5$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments5$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments5$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments5$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments5$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments5$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments5$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitSourceDeploymentsResponseType> = z
    .nativeEnum(GetDeploymentGitSourceDeploymentsResponseType);

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitSourceDeploymentsResponseType> =
    GetDeploymentGitSourceDeploymentsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponseType$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponseType$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponseType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments4$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentGitSourceDeploymentsResponseType$inboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments4$Outbound = {
  type: string;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSourceDeployments4$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments4$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments4
> = z.object({
  type: GetDeploymentGitSourceDeploymentsResponseType$outboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments4$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments4$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments4$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments4$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments4$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments4$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments4$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsType$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitSourceDeploymentsType> = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsType,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitSourceDeploymentsType> =
    GetDeploymentGitSourceDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsType$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsType$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceProjectId$inboundSchema: z.ZodType<
  GetDeploymentGitSourceProjectId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GetDeploymentGitSourceProjectId$Outbound = string | number;

/** @internal */
export const GetDeploymentGitSourceProjectId$outboundSchema: z.ZodType<
  GetDeploymentGitSourceProjectId$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceProjectId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceProjectId$ {
  /** @deprecated use `GetDeploymentGitSourceProjectId$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceProjectId$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceProjectId$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSourceProjectId$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceProjectId$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceProjectId$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeployments3$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentGitSourceDeploymentsType$inboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments3$Outbound = {
  type: string;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSourceDeployments3$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments3$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments3
> = z.object({
  type: GetDeploymentGitSourceDeploymentsType$outboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments3$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments3$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments3$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments3$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments3$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments3$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments3$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitSourceType
> = z.nativeEnum(GetDeploymentGitSourceType);

/** @internal */
export const GetDeploymentGitSourceType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitSourceType
> = GetDeploymentGitSourceType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceType$ {
  /** @deprecated use `GetDeploymentGitSourceType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceType$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSourceType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceDeployments2$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentGitSourceType$inboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments2$Outbound = {
  type: string;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSourceDeployments2$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments2$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments2
> = z.object({
  type: GetDeploymentGitSourceType$outboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments2$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments2$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments2$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments2$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments2$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments2$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type
  > = z.nativeEnum(
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type,
  );

/** @internal */
export const GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type
  > =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$ {
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$outboundSchema;
}

/** @internal */
export const GetDeploymentGitSourceRepoId$inboundSchema: z.ZodType<
  GetDeploymentGitSourceRepoId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GetDeploymentGitSourceRepoId$Outbound = string | number;

/** @internal */
export const GetDeploymentGitSourceRepoId$outboundSchema: z.ZodType<
  GetDeploymentGitSourceRepoId$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceRepoId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceRepoId$ {
  /** @deprecated use `GetDeploymentGitSourceRepoId$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceRepoId$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceRepoId$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitSourceRepoId$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceRepoId$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceRepoId$Outbound;
}

/** @internal */
export const GetDeploymentGitSourceDeployments1$inboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$inboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GetDeploymentGitSourceDeployments1$Outbound = {
  type: string;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GetDeploymentGitSourceDeployments1$outboundSchema: z.ZodType<
  GetDeploymentGitSourceDeployments1$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitSourceDeployments1
> = z.object({
  type:
    GetDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody11Type$outboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitSourceDeployments1$ {
  /** @deprecated use `GetDeploymentGitSourceDeployments1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitSourceDeployments1$inboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments1$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitSourceDeployments1$outboundSchema;
  /** @deprecated use `GetDeploymentGitSourceDeployments1$Outbound` instead. */
  export type Outbound = GetDeploymentGitSourceDeployments1$Outbound;
}

/** @internal */
export const GetDeploymentResponseBodyGitSource$inboundSchema: z.ZodType<
  GetDeploymentResponseBodyGitSource,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentGitSourceDeployments6$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments8$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments1$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments3$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments2$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments4$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments5$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments7$inboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments9$inboundSchema),
]);

/** @internal */
export type GetDeploymentResponseBodyGitSource$Outbound =
  | GetDeploymentGitSourceDeployments6$Outbound
  | GetDeploymentGitSourceDeployments8$Outbound
  | GetDeploymentGitSourceDeployments1$Outbound
  | GetDeploymentGitSourceDeployments3$Outbound
  | GetDeploymentGitSourceDeployments2$Outbound
  | GetDeploymentGitSourceDeployments4$Outbound
  | GetDeploymentGitSourceDeployments5$Outbound
  | GetDeploymentGitSourceDeployments7$Outbound
  | GetDeploymentGitSourceDeployments9$Outbound;

/** @internal */
export const GetDeploymentResponseBodyGitSource$outboundSchema: z.ZodType<
  GetDeploymentResponseBodyGitSource$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBodyGitSource
> = z.union([
  z.lazy(() => GetDeploymentGitSourceDeployments6$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments8$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments1$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments3$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments2$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments4$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments5$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments7$outboundSchema),
  z.lazy(() => GetDeploymentGitSourceDeployments9$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBodyGitSource$ {
  /** @deprecated use `GetDeploymentResponseBodyGitSource$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBodyGitSource$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyGitSource$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentResponseBodyGitSource$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBodyGitSource$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBodyGitSource$Outbound;
}

/** @internal */
export const ResponseBodyProject$inboundSchema: z.ZodType<
  ResponseBodyProject,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/** @internal */
export type ResponseBodyProject$Outbound = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

/** @internal */
export const ResponseBodyProject$outboundSchema: z.ZodType<
  ResponseBodyProject$Outbound,
  z.ZodTypeDef,
  ResponseBodyProject
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyProject$ {
  /** @deprecated use `ResponseBodyProject$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyProject$inboundSchema;
  /** @deprecated use `ResponseBodyProject$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyProject$outboundSchema;
  /** @deprecated use `ResponseBodyProject$Outbound` instead. */
  export type Outbound = ResponseBodyProject$Outbound;
}

/** @internal */
export const ResponseBodyReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyReadySubstate
> = z.nativeEnum(ResponseBodyReadySubstate);

/** @internal */
export const ResponseBodyReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyReadySubstate
> = ResponseBodyReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyReadySubstate$ {
  /** @deprecated use `ResponseBodyReadySubstate$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyReadySubstate$inboundSchema;
  /** @deprecated use `ResponseBodyReadySubstate$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyReadySubstate$outboundSchema;
}

/** @internal */
export const ResponseBodySource$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodySource
> = z.nativeEnum(ResponseBodySource);

/** @internal */
export const ResponseBodySource$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodySource
> = ResponseBodySource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodySource$ {
  /** @deprecated use `ResponseBodySource$inboundSchema` instead. */
  export const inboundSchema = ResponseBodySource$inboundSchema;
  /** @deprecated use `ResponseBodySource$outboundSchema` instead. */
  export const outboundSchema = ResponseBodySource$outboundSchema;
}

/** @internal */
export const ResponseBodyTarget$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyTarget
> = z.nativeEnum(ResponseBodyTarget);

/** @internal */
export const ResponseBodyTarget$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyTarget
> = ResponseBodyTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyTarget$ {
  /** @deprecated use `ResponseBodyTarget$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyTarget$inboundSchema;
  /** @deprecated use `ResponseBodyTarget$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyTarget$outboundSchema;
}

/** @internal */
export const ResponseBodyOidcTokenClaims$inboundSchema: z.ZodType<
  ResponseBodyOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type ResponseBodyOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const ResponseBodyOidcTokenClaims$outboundSchema: z.ZodType<
  ResponseBodyOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  ResponseBodyOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyOidcTokenClaims$ {
  /** @deprecated use `ResponseBodyOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyOidcTokenClaims$inboundSchema;
  /** @deprecated use `ResponseBodyOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyOidcTokenClaims$outboundSchema;
  /** @deprecated use `ResponseBodyOidcTokenClaims$Outbound` instead. */
  export type Outbound = ResponseBodyOidcTokenClaims$Outbound;
}

/** @internal */
export const ResponseBodyPlan$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyPlan
> = z.nativeEnum(ResponseBodyPlan);

/** @internal */
export const ResponseBodyPlan$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyPlan
> = ResponseBodyPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyPlan$ {
  /** @deprecated use `ResponseBodyPlan$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyPlan$inboundSchema;
  /** @deprecated use `ResponseBodyPlan$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyPlan$outboundSchema;
}

/** @internal */
export const ResponseBodyCrons$inboundSchema: z.ZodType<
  ResponseBodyCrons,
  z.ZodTypeDef,
  unknown
> = z.object({
  schedule: z.string(),
  path: z.string(),
});

/** @internal */
export type ResponseBodyCrons$Outbound = {
  schedule: string;
  path: string;
};

/** @internal */
export const ResponseBodyCrons$outboundSchema: z.ZodType<
  ResponseBodyCrons$Outbound,
  z.ZodTypeDef,
  ResponseBodyCrons
> = z.object({
  schedule: z.string(),
  path: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyCrons$ {
  /** @deprecated use `ResponseBodyCrons$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyCrons$inboundSchema;
  /** @deprecated use `ResponseBodyCrons$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyCrons$outboundSchema;
  /** @deprecated use `ResponseBodyCrons$Outbound` instead. */
  export type Outbound = ResponseBodyCrons$Outbound;
}

/** @internal */
export const ResponseBodyFunctions$inboundSchema: z.ZodType<
  ResponseBodyFunctions,
  z.ZodTypeDef,
  unknown
> = z.object({
  memory: z.number().optional(),
  maxDuration: z.number().optional(),
  runtime: z.string().optional(),
  includeFiles: z.string().optional(),
  excludeFiles: z.string().optional(),
});

/** @internal */
export type ResponseBodyFunctions$Outbound = {
  memory?: number | undefined;
  maxDuration?: number | undefined;
  runtime?: string | undefined;
  includeFiles?: string | undefined;
  excludeFiles?: string | undefined;
};

/** @internal */
export const ResponseBodyFunctions$outboundSchema: z.ZodType<
  ResponseBodyFunctions$Outbound,
  z.ZodTypeDef,
  ResponseBodyFunctions
> = z.object({
  memory: z.number().optional(),
  maxDuration: z.number().optional(),
  runtime: z.string().optional(),
  includeFiles: z.string().optional(),
  excludeFiles: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyFunctions$ {
  /** @deprecated use `ResponseBodyFunctions$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyFunctions$inboundSchema;
  /** @deprecated use `ResponseBodyFunctions$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyFunctions$outboundSchema;
  /** @deprecated use `ResponseBodyFunctions$Outbound` instead. */
  export type Outbound = ResponseBodyFunctions$Outbound;
}

/** @internal */
export const GetDeploymentRoutes3$inboundSchema: z.ZodType<
  GetDeploymentRoutes3,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.string(),
  continue: z.boolean(),
  middleware: z.number(),
});

/** @internal */
export type GetDeploymentRoutes3$Outbound = {
  src: string;
  continue: boolean;
  middleware: number;
};

/** @internal */
export const GetDeploymentRoutes3$outboundSchema: z.ZodType<
  GetDeploymentRoutes3$Outbound,
  z.ZodTypeDef,
  GetDeploymentRoutes3
> = z.object({
  src: z.string(),
  continue: z.boolean(),
  middleware: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutes3$ {
  /** @deprecated use `GetDeploymentRoutes3$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutes3$inboundSchema;
  /** @deprecated use `GetDeploymentRoutes3$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutes3$outboundSchema;
  /** @deprecated use `GetDeploymentRoutes3$Outbound` instead. */
  export type Outbound = GetDeploymentRoutes3$Outbound;
}

/** @internal */
export const GetDeploymentRoutesHandle$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentRoutesHandle
> = z.nativeEnum(GetDeploymentRoutesHandle);

/** @internal */
export const GetDeploymentRoutesHandle$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentRoutesHandle
> = GetDeploymentRoutesHandle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutesHandle$ {
  /** @deprecated use `GetDeploymentRoutesHandle$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutesHandle$inboundSchema;
  /** @deprecated use `GetDeploymentRoutesHandle$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutesHandle$outboundSchema;
}

/** @internal */
export const GetDeploymentRoutes2$inboundSchema: z.ZodType<
  GetDeploymentRoutes2,
  z.ZodTypeDef,
  unknown
> = z.object({
  handle: GetDeploymentRoutesHandle$inboundSchema,
  src: z.string().optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
});

/** @internal */
export type GetDeploymentRoutes2$Outbound = {
  handle: string;
  src?: string | undefined;
  dest?: string | undefined;
  status?: number | undefined;
};

/** @internal */
export const GetDeploymentRoutes2$outboundSchema: z.ZodType<
  GetDeploymentRoutes2$Outbound,
  z.ZodTypeDef,
  GetDeploymentRoutes2
> = z.object({
  handle: GetDeploymentRoutesHandle$outboundSchema,
  src: z.string().optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutes2$ {
  /** @deprecated use `GetDeploymentRoutes2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutes2$inboundSchema;
  /** @deprecated use `GetDeploymentRoutes2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutes2$outboundSchema;
  /** @deprecated use `GetDeploymentRoutes2$Outbound` instead. */
  export type Outbound = GetDeploymentRoutes2$Outbound;
}

/** @internal */
export const GetDeploymentHasType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentHasType
> = z.nativeEnum(GetDeploymentHasType);

/** @internal */
export const GetDeploymentHasType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentHasType
> = GetDeploymentHasType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentHasType$ {
  /** @deprecated use `GetDeploymentHasType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentHasType$inboundSchema;
  /** @deprecated use `GetDeploymentHasType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentHasType$outboundSchema;
}

/** @internal */
export const GetDeploymentHas2$inboundSchema: z.ZodType<
  GetDeploymentHas2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentHasType$inboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type GetDeploymentHas2$Outbound = {
  type: string;
  key: string;
  value?: string | undefined;
};

/** @internal */
export const GetDeploymentHas2$outboundSchema: z.ZodType<
  GetDeploymentHas2$Outbound,
  z.ZodTypeDef,
  GetDeploymentHas2
> = z.object({
  type: GetDeploymentHasType$outboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentHas2$ {
  /** @deprecated use `GetDeploymentHas2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentHas2$inboundSchema;
  /** @deprecated use `GetDeploymentHas2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentHas2$outboundSchema;
  /** @deprecated use `GetDeploymentHas2$Outbound` instead. */
  export type Outbound = GetDeploymentHas2$Outbound;
}

/** @internal */
export const GetDeploymentHasDeploymentsType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentHasDeploymentsType
> = z.nativeEnum(GetDeploymentHasDeploymentsType);

/** @internal */
export const GetDeploymentHasDeploymentsType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentHasDeploymentsType
> = GetDeploymentHasDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentHasDeploymentsType$ {
  /** @deprecated use `GetDeploymentHasDeploymentsType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentHasDeploymentsType$inboundSchema;
  /** @deprecated use `GetDeploymentHasDeploymentsType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentHasDeploymentsType$outboundSchema;
}

/** @internal */
export const GetDeploymentHas1$inboundSchema: z.ZodType<
  GetDeploymentHas1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentHasDeploymentsType$inboundSchema,
  value: z.string(),
});

/** @internal */
export type GetDeploymentHas1$Outbound = {
  type: string;
  value: string;
};

/** @internal */
export const GetDeploymentHas1$outboundSchema: z.ZodType<
  GetDeploymentHas1$Outbound,
  z.ZodTypeDef,
  GetDeploymentHas1
> = z.object({
  type: GetDeploymentHasDeploymentsType$outboundSchema,
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentHas1$ {
  /** @deprecated use `GetDeploymentHas1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentHas1$inboundSchema;
  /** @deprecated use `GetDeploymentHas1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentHas1$outboundSchema;
  /** @deprecated use `GetDeploymentHas1$Outbound` instead. */
  export type Outbound = GetDeploymentHas1$Outbound;
}

/** @internal */
export const GetDeploymentRoutesHas$inboundSchema: z.ZodType<
  GetDeploymentRoutesHas,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentHas1$inboundSchema),
  z.lazy(() => GetDeploymentHas2$inboundSchema),
]);

/** @internal */
export type GetDeploymentRoutesHas$Outbound =
  | GetDeploymentHas1$Outbound
  | GetDeploymentHas2$Outbound;

/** @internal */
export const GetDeploymentRoutesHas$outboundSchema: z.ZodType<
  GetDeploymentRoutesHas$Outbound,
  z.ZodTypeDef,
  GetDeploymentRoutesHas
> = z.union([
  z.lazy(() => GetDeploymentHas1$outboundSchema),
  z.lazy(() => GetDeploymentHas2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutesHas$ {
  /** @deprecated use `GetDeploymentRoutesHas$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutesHas$inboundSchema;
  /** @deprecated use `GetDeploymentRoutesHas$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutesHas$outboundSchema;
  /** @deprecated use `GetDeploymentRoutesHas$Outbound` instead. */
  export type Outbound = GetDeploymentRoutesHas$Outbound;
}

/** @internal */
export const GetDeploymentMissingType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentMissingType
> = z.nativeEnum(GetDeploymentMissingType);

/** @internal */
export const GetDeploymentMissingType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentMissingType
> = GetDeploymentMissingType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentMissingType$ {
  /** @deprecated use `GetDeploymentMissingType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentMissingType$inboundSchema;
  /** @deprecated use `GetDeploymentMissingType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentMissingType$outboundSchema;
}

/** @internal */
export const GetDeploymentMissing2$inboundSchema: z.ZodType<
  GetDeploymentMissing2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentMissingType$inboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type GetDeploymentMissing2$Outbound = {
  type: string;
  key: string;
  value?: string | undefined;
};

/** @internal */
export const GetDeploymentMissing2$outboundSchema: z.ZodType<
  GetDeploymentMissing2$Outbound,
  z.ZodTypeDef,
  GetDeploymentMissing2
> = z.object({
  type: GetDeploymentMissingType$outboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentMissing2$ {
  /** @deprecated use `GetDeploymentMissing2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentMissing2$inboundSchema;
  /** @deprecated use `GetDeploymentMissing2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentMissing2$outboundSchema;
  /** @deprecated use `GetDeploymentMissing2$Outbound` instead. */
  export type Outbound = GetDeploymentMissing2$Outbound;
}

/** @internal */
export const GetDeploymentMissingDeploymentsType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentMissingDeploymentsType
> = z.nativeEnum(GetDeploymentMissingDeploymentsType);

/** @internal */
export const GetDeploymentMissingDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentMissingDeploymentsType> =
    GetDeploymentMissingDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentMissingDeploymentsType$ {
  /** @deprecated use `GetDeploymentMissingDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentMissingDeploymentsType$inboundSchema;
  /** @deprecated use `GetDeploymentMissingDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentMissingDeploymentsType$outboundSchema;
}

/** @internal */
export const GetDeploymentMissing1$inboundSchema: z.ZodType<
  GetDeploymentMissing1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: GetDeploymentMissingDeploymentsType$inboundSchema,
  value: z.string(),
});

/** @internal */
export type GetDeploymentMissing1$Outbound = {
  type: string;
  value: string;
};

/** @internal */
export const GetDeploymentMissing1$outboundSchema: z.ZodType<
  GetDeploymentMissing1$Outbound,
  z.ZodTypeDef,
  GetDeploymentMissing1
> = z.object({
  type: GetDeploymentMissingDeploymentsType$outboundSchema,
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentMissing1$ {
  /** @deprecated use `GetDeploymentMissing1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentMissing1$inboundSchema;
  /** @deprecated use `GetDeploymentMissing1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentMissing1$outboundSchema;
  /** @deprecated use `GetDeploymentMissing1$Outbound` instead. */
  export type Outbound = GetDeploymentMissing1$Outbound;
}

/** @internal */
export const GetDeploymentRoutesMissing$inboundSchema: z.ZodType<
  GetDeploymentRoutesMissing,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentMissing1$inboundSchema),
  z.lazy(() => GetDeploymentMissing2$inboundSchema),
]);

/** @internal */
export type GetDeploymentRoutesMissing$Outbound =
  | GetDeploymentMissing1$Outbound
  | GetDeploymentMissing2$Outbound;

/** @internal */
export const GetDeploymentRoutesMissing$outboundSchema: z.ZodType<
  GetDeploymentRoutesMissing$Outbound,
  z.ZodTypeDef,
  GetDeploymentRoutesMissing
> = z.union([
  z.lazy(() => GetDeploymentMissing1$outboundSchema),
  z.lazy(() => GetDeploymentMissing2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutesMissing$ {
  /** @deprecated use `GetDeploymentRoutesMissing$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutesMissing$inboundSchema;
  /** @deprecated use `GetDeploymentRoutesMissing$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutesMissing$outboundSchema;
  /** @deprecated use `GetDeploymentRoutesMissing$Outbound` instead. */
  export type Outbound = GetDeploymentRoutesMissing$Outbound;
}

/** @internal */
export const GetDeploymentRoutesLocale$inboundSchema: z.ZodType<
  GetDeploymentRoutesLocale,
  z.ZodTypeDef,
  unknown
> = z.object({
  redirect: z.record(z.string()).optional(),
  cookie: z.string().optional(),
});

/** @internal */
export type GetDeploymentRoutesLocale$Outbound = {
  redirect?: { [k: string]: string } | undefined;
  cookie?: string | undefined;
};

/** @internal */
export const GetDeploymentRoutesLocale$outboundSchema: z.ZodType<
  GetDeploymentRoutesLocale$Outbound,
  z.ZodTypeDef,
  GetDeploymentRoutesLocale
> = z.object({
  redirect: z.record(z.string()).optional(),
  cookie: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutesLocale$ {
  /** @deprecated use `GetDeploymentRoutesLocale$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutesLocale$inboundSchema;
  /** @deprecated use `GetDeploymentRoutesLocale$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutesLocale$outboundSchema;
  /** @deprecated use `GetDeploymentRoutesLocale$Outbound` instead. */
  export type Outbound = GetDeploymentRoutesLocale$Outbound;
}

/** @internal */
export const GetDeploymentRoutes1$inboundSchema: z.ZodType<
  GetDeploymentRoutes1,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.string(),
  dest: z.string().optional(),
  headers: z.record(z.string()).optional(),
  methods: z.array(z.string()).optional(),
  continue: z.boolean().optional(),
  override: z.boolean().optional(),
  caseSensitive: z.boolean().optional(),
  check: z.boolean().optional(),
  important: z.boolean().optional(),
  status: z.number().optional(),
  has: z.array(
    z.union([
      z.lazy(() => GetDeploymentHas1$inboundSchema),
      z.lazy(() => GetDeploymentHas2$inboundSchema),
    ]),
  ).optional(),
  missing: z.array(
    z.union([
      z.lazy(() => GetDeploymentMissing1$inboundSchema),
      z.lazy(() => GetDeploymentMissing2$inboundSchema),
    ]),
  ).optional(),
  locale: z.lazy(() => GetDeploymentRoutesLocale$inboundSchema).optional(),
  middlewarePath: z.string().optional(),
  middlewareRawSrc: z.array(z.string()).optional(),
  middleware: z.number().optional(),
});

/** @internal */
export type GetDeploymentRoutes1$Outbound = {
  src: string;
  dest?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  methods?: Array<string> | undefined;
  continue?: boolean | undefined;
  override?: boolean | undefined;
  caseSensitive?: boolean | undefined;
  check?: boolean | undefined;
  important?: boolean | undefined;
  status?: number | undefined;
  has?:
    | Array<GetDeploymentHas1$Outbound | GetDeploymentHas2$Outbound>
    | undefined;
  missing?:
    | Array<GetDeploymentMissing1$Outbound | GetDeploymentMissing2$Outbound>
    | undefined;
  locale?: GetDeploymentRoutesLocale$Outbound | undefined;
  middlewarePath?: string | undefined;
  middlewareRawSrc?: Array<string> | undefined;
  middleware?: number | undefined;
};

/** @internal */
export const GetDeploymentRoutes1$outboundSchema: z.ZodType<
  GetDeploymentRoutes1$Outbound,
  z.ZodTypeDef,
  GetDeploymentRoutes1
> = z.object({
  src: z.string(),
  dest: z.string().optional(),
  headers: z.record(z.string()).optional(),
  methods: z.array(z.string()).optional(),
  continue: z.boolean().optional(),
  override: z.boolean().optional(),
  caseSensitive: z.boolean().optional(),
  check: z.boolean().optional(),
  important: z.boolean().optional(),
  status: z.number().optional(),
  has: z.array(
    z.union([
      z.lazy(() => GetDeploymentHas1$outboundSchema),
      z.lazy(() => GetDeploymentHas2$outboundSchema),
    ]),
  ).optional(),
  missing: z.array(
    z.union([
      z.lazy(() => GetDeploymentMissing1$outboundSchema),
      z.lazy(() => GetDeploymentMissing2$outboundSchema),
    ]),
  ).optional(),
  locale: z.lazy(() => GetDeploymentRoutesLocale$outboundSchema).optional(),
  middlewarePath: z.string().optional(),
  middlewareRawSrc: z.array(z.string()).optional(),
  middleware: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentRoutes1$ {
  /** @deprecated use `GetDeploymentRoutes1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentRoutes1$inboundSchema;
  /** @deprecated use `GetDeploymentRoutes1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentRoutes1$outboundSchema;
  /** @deprecated use `GetDeploymentRoutes1$Outbound` instead. */
  export type Outbound = GetDeploymentRoutes1$Outbound;
}

/** @internal */
export const ResponseBodyRoutes$inboundSchema: z.ZodType<
  ResponseBodyRoutes,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentRoutes3$inboundSchema),
  z.lazy(() => GetDeploymentRoutes2$inboundSchema),
  z.lazy(() => GetDeploymentRoutes1$inboundSchema),
]);

/** @internal */
export type ResponseBodyRoutes$Outbound =
  | GetDeploymentRoutes3$Outbound
  | GetDeploymentRoutes2$Outbound
  | GetDeploymentRoutes1$Outbound;

/** @internal */
export const ResponseBodyRoutes$outboundSchema: z.ZodType<
  ResponseBodyRoutes$Outbound,
  z.ZodTypeDef,
  ResponseBodyRoutes
> = z.union([
  z.lazy(() => GetDeploymentRoutes3$outboundSchema),
  z.lazy(() => GetDeploymentRoutes2$outboundSchema),
  z.lazy(() => GetDeploymentRoutes1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyRoutes$ {
  /** @deprecated use `ResponseBodyRoutes$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyRoutes$inboundSchema;
  /** @deprecated use `ResponseBodyRoutes$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyRoutes$outboundSchema;
  /** @deprecated use `ResponseBodyRoutes$Outbound` instead. */
  export type Outbound = ResponseBodyRoutes$Outbound;
}

/** @internal */
export const GetDeploymentGitRepoDeploymentsType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitRepoDeploymentsType
> = z.nativeEnum(GetDeploymentGitRepoDeploymentsType);

/** @internal */
export const GetDeploymentGitRepoDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsType> =
    GetDeploymentGitRepoDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepoDeploymentsType$ {
  /** @deprecated use `GetDeploymentGitRepoDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitRepoDeploymentsType$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepoDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitRepoDeploymentsType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitRepoOwnerType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitRepoOwnerType
> = z.nativeEnum(GetDeploymentGitRepoOwnerType);

/** @internal */
export const GetDeploymentGitRepoOwnerType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitRepoOwnerType
> = GetDeploymentGitRepoOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepoOwnerType$ {
  /** @deprecated use `GetDeploymentGitRepoOwnerType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitRepoOwnerType$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepoOwnerType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitRepoOwnerType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitRepo3$inboundSchema: z.ZodType<
  GetDeploymentGitRepo3,
  z.ZodTypeDef,
  unknown
> = z.object({
  owner: z.string(),
  repoUuid: z.string(),
  slug: z.string(),
  type: GetDeploymentGitRepoDeploymentsType$inboundSchema,
  workspaceUuid: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GetDeploymentGitRepoOwnerType$inboundSchema,
});

/** @internal */
export type GetDeploymentGitRepo3$Outbound = {
  owner: string;
  repoUuid: string;
  slug: string;
  type: string;
  workspaceUuid: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const GetDeploymentGitRepo3$outboundSchema: z.ZodType<
  GetDeploymentGitRepo3$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitRepo3
> = z.object({
  owner: z.string(),
  repoUuid: z.string(),
  slug: z.string(),
  type: GetDeploymentGitRepoDeploymentsType$outboundSchema,
  workspaceUuid: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GetDeploymentGitRepoOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepo3$ {
  /** @deprecated use `GetDeploymentGitRepo3$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitRepo3$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepo3$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitRepo3$outboundSchema;
  /** @deprecated use `GetDeploymentGitRepo3$Outbound` instead. */
  export type Outbound = GetDeploymentGitRepo3$Outbound;
}

/** @internal */
export const GetDeploymentGitRepoType$inboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitRepoType
> = z.nativeEnum(GetDeploymentGitRepoType);

/** @internal */
export const GetDeploymentGitRepoType$outboundSchema: z.ZodNativeEnum<
  typeof GetDeploymentGitRepoType
> = GetDeploymentGitRepoType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepoType$ {
  /** @deprecated use `GetDeploymentGitRepoType$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitRepoType$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepoType$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitRepoType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsResponseOwnerType> = z
    .nativeEnum(GetDeploymentGitRepoDeploymentsResponseOwnerType);

/** @internal */
export const GetDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsResponseOwnerType> =
    GetDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepoDeploymentsResponseOwnerType$ {
  /** @deprecated use `GetDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitRepo2$inboundSchema: z.ZodType<
  GetDeploymentGitRepo2,
  z.ZodTypeDef,
  unknown
> = z.object({
  org: z.string(),
  repo: z.string(),
  repoId: z.number(),
  type: GetDeploymentGitRepoType$inboundSchema,
  repoOwnerId: z.number(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GetDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema,
});

/** @internal */
export type GetDeploymentGitRepo2$Outbound = {
  org: string;
  repo: string;
  repoId: number;
  type: string;
  repoOwnerId: number;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const GetDeploymentGitRepo2$outboundSchema: z.ZodType<
  GetDeploymentGitRepo2$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitRepo2
> = z.object({
  org: z.string(),
  repo: z.string(),
  repoId: z.number(),
  type: GetDeploymentGitRepoType$outboundSchema,
  repoOwnerId: z.number(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GetDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepo2$ {
  /** @deprecated use `GetDeploymentGitRepo2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitRepo2$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepo2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitRepo2$outboundSchema;
  /** @deprecated use `GetDeploymentGitRepo2$Outbound` instead. */
  export type Outbound = GetDeploymentGitRepo2$Outbound;
}

/** @internal */
export const GetDeploymentGitRepoDeploymentsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsResponseType> = z
    .nativeEnum(GetDeploymentGitRepoDeploymentsResponseType);

/** @internal */
export const GetDeploymentGitRepoDeploymentsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsResponseType> =
    GetDeploymentGitRepoDeploymentsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepoDeploymentsResponseType$ {
  /** @deprecated use `GetDeploymentGitRepoDeploymentsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitRepoDeploymentsResponseType$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepoDeploymentsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitRepoDeploymentsResponseType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitRepoDeploymentsOwnerType$inboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsOwnerType> = z
    .nativeEnum(GetDeploymentGitRepoDeploymentsOwnerType);

/** @internal */
export const GetDeploymentGitRepoDeploymentsOwnerType$outboundSchema:
  z.ZodNativeEnum<typeof GetDeploymentGitRepoDeploymentsOwnerType> =
    GetDeploymentGitRepoDeploymentsOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepoDeploymentsOwnerType$ {
  /** @deprecated use `GetDeploymentGitRepoDeploymentsOwnerType$inboundSchema` instead. */
  export const inboundSchema =
    GetDeploymentGitRepoDeploymentsOwnerType$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepoDeploymentsOwnerType$outboundSchema` instead. */
  export const outboundSchema =
    GetDeploymentGitRepoDeploymentsOwnerType$outboundSchema;
}

/** @internal */
export const GetDeploymentGitRepo1$inboundSchema: z.ZodType<
  GetDeploymentGitRepo1,
  z.ZodTypeDef,
  unknown
> = z.object({
  namespace: z.string(),
  projectId: z.number(),
  type: GetDeploymentGitRepoDeploymentsResponseType$inboundSchema,
  url: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GetDeploymentGitRepoDeploymentsOwnerType$inboundSchema,
});

/** @internal */
export type GetDeploymentGitRepo1$Outbound = {
  namespace: string;
  projectId: number;
  type: string;
  url: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const GetDeploymentGitRepo1$outboundSchema: z.ZodType<
  GetDeploymentGitRepo1$Outbound,
  z.ZodTypeDef,
  GetDeploymentGitRepo1
> = z.object({
  namespace: z.string(),
  projectId: z.number(),
  type: GetDeploymentGitRepoDeploymentsResponseType$outboundSchema,
  url: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GetDeploymentGitRepoDeploymentsOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentGitRepo1$ {
  /** @deprecated use `GetDeploymentGitRepo1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentGitRepo1$inboundSchema;
  /** @deprecated use `GetDeploymentGitRepo1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentGitRepo1$outboundSchema;
  /** @deprecated use `GetDeploymentGitRepo1$Outbound` instead. */
  export type Outbound = GetDeploymentGitRepo1$Outbound;
}

/** @internal */
export const ResponseBodyGitRepo$inboundSchema: z.ZodType<
  ResponseBodyGitRepo,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentGitRepo1$inboundSchema),
  z.lazy(() => GetDeploymentGitRepo2$inboundSchema),
  z.lazy(() => GetDeploymentGitRepo3$inboundSchema),
]);

/** @internal */
export type ResponseBodyGitRepo$Outbound =
  | GetDeploymentGitRepo1$Outbound
  | GetDeploymentGitRepo2$Outbound
  | GetDeploymentGitRepo3$Outbound;

/** @internal */
export const ResponseBodyGitRepo$outboundSchema: z.ZodType<
  ResponseBodyGitRepo$Outbound,
  z.ZodTypeDef,
  ResponseBodyGitRepo
> = z.union([
  z.lazy(() => GetDeploymentGitRepo1$outboundSchema),
  z.lazy(() => GetDeploymentGitRepo2$outboundSchema),
  z.lazy(() => GetDeploymentGitRepo3$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyGitRepo$ {
  /** @deprecated use `ResponseBodyGitRepo$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyGitRepo$inboundSchema;
  /** @deprecated use `ResponseBodyGitRepo$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyGitRepo$outboundSchema;
  /** @deprecated use `ResponseBodyGitRepo$Outbound` instead. */
  export type Outbound = ResponseBodyGitRepo$Outbound;
}

/** @internal */
export const GetDeploymentFlags2$inboundSchema: z.ZodType<
  GetDeploymentFlags2,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type GetDeploymentFlags2$Outbound = {};

/** @internal */
export const GetDeploymentFlags2$outboundSchema: z.ZodType<
  GetDeploymentFlags2$Outbound,
  z.ZodTypeDef,
  GetDeploymentFlags2
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentFlags2$ {
  /** @deprecated use `GetDeploymentFlags2$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentFlags2$inboundSchema;
  /** @deprecated use `GetDeploymentFlags2$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentFlags2$outboundSchema;
  /** @deprecated use `GetDeploymentFlags2$Outbound` instead. */
  export type Outbound = GetDeploymentFlags2$Outbound;
}

/** @internal */
export const GetDeploymentFlagsOptions$inboundSchema: z.ZodType<
  GetDeploymentFlagsOptions,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(FlagJSONValue$inboundSchema),
  label: z.string().optional(),
});

/** @internal */
export type GetDeploymentFlagsOptions$Outbound = {
  value: FlagJSONValue$Outbound | null;
  label?: string | undefined;
};

/** @internal */
export const GetDeploymentFlagsOptions$outboundSchema: z.ZodType<
  GetDeploymentFlagsOptions$Outbound,
  z.ZodTypeDef,
  GetDeploymentFlagsOptions
> = z.object({
  value: z.nullable(FlagJSONValue$outboundSchema),
  label: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentFlagsOptions$ {
  /** @deprecated use `GetDeploymentFlagsOptions$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentFlagsOptions$inboundSchema;
  /** @deprecated use `GetDeploymentFlagsOptions$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentFlagsOptions$outboundSchema;
  /** @deprecated use `GetDeploymentFlagsOptions$Outbound` instead. */
  export type Outbound = GetDeploymentFlagsOptions$Outbound;
}

/** @internal */
export const GetDeploymentFlagsDefinitions$inboundSchema: z.ZodType<
  GetDeploymentFlagsDefinitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  options: z.array(z.lazy(() => GetDeploymentFlagsOptions$inboundSchema))
    .optional(),
  url: z.string().optional(),
  description: z.string().optional(),
});

/** @internal */
export type GetDeploymentFlagsDefinitions$Outbound = {
  options?: Array<GetDeploymentFlagsOptions$Outbound> | undefined;
  url?: string | undefined;
  description?: string | undefined;
};

/** @internal */
export const GetDeploymentFlagsDefinitions$outboundSchema: z.ZodType<
  GetDeploymentFlagsDefinitions$Outbound,
  z.ZodTypeDef,
  GetDeploymentFlagsDefinitions
> = z.object({
  options: z.array(z.lazy(() => GetDeploymentFlagsOptions$outboundSchema))
    .optional(),
  url: z.string().optional(),
  description: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentFlagsDefinitions$ {
  /** @deprecated use `GetDeploymentFlagsDefinitions$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentFlagsDefinitions$inboundSchema;
  /** @deprecated use `GetDeploymentFlagsDefinitions$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentFlagsDefinitions$outboundSchema;
  /** @deprecated use `GetDeploymentFlagsDefinitions$Outbound` instead. */
  export type Outbound = GetDeploymentFlagsDefinitions$Outbound;
}

/** @internal */
export const GetDeploymentFlags1$inboundSchema: z.ZodType<
  GetDeploymentFlags1,
  z.ZodTypeDef,
  unknown
> = z.object({
  definitions: z.record(
    z.lazy(() => GetDeploymentFlagsDefinitions$inboundSchema),
  ),
});

/** @internal */
export type GetDeploymentFlags1$Outbound = {
  definitions: { [k: string]: GetDeploymentFlagsDefinitions$Outbound };
};

/** @internal */
export const GetDeploymentFlags1$outboundSchema: z.ZodType<
  GetDeploymentFlags1$Outbound,
  z.ZodTypeDef,
  GetDeploymentFlags1
> = z.object({
  definitions: z.record(
    z.lazy(() => GetDeploymentFlagsDefinitions$outboundSchema),
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentFlags1$ {
  /** @deprecated use `GetDeploymentFlags1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentFlags1$inboundSchema;
  /** @deprecated use `GetDeploymentFlags1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentFlags1$outboundSchema;
  /** @deprecated use `GetDeploymentFlags1$Outbound` instead. */
  export type Outbound = GetDeploymentFlags1$Outbound;
}

/** @internal */
export const ResponseBodyFlags$inboundSchema: z.ZodType<
  ResponseBodyFlags,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentFlags1$inboundSchema),
  z.array(z.lazy(() => GetDeploymentFlags2$inboundSchema)),
]);

/** @internal */
export type ResponseBodyFlags$Outbound =
  | GetDeploymentFlags1$Outbound
  | Array<GetDeploymentFlags2$Outbound>;

/** @internal */
export const ResponseBodyFlags$outboundSchema: z.ZodType<
  ResponseBodyFlags$Outbound,
  z.ZodTypeDef,
  ResponseBodyFlags
> = z.union([
  z.lazy(() => GetDeploymentFlags1$outboundSchema),
  z.array(z.lazy(() => GetDeploymentFlags2$outboundSchema)),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyFlags$ {
  /** @deprecated use `ResponseBodyFlags$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyFlags$inboundSchema;
  /** @deprecated use `ResponseBodyFlags$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyFlags$outboundSchema;
  /** @deprecated use `ResponseBodyFlags$Outbound` instead. */
  export type Outbound = ResponseBodyFlags$Outbound;
}

/** @internal */
export const GetDeploymentResponseBody1$inboundSchema: z.ZodType<
  GetDeploymentResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  aliasAssignedAt: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  alwaysRefuseToBuild: z.boolean().optional(),
  build: z.lazy(() => ResponseBodyBuild$inboundSchema),
  buildArtifactUrls: z.array(z.string()).optional(),
  builds: z.array(z.lazy(() => ResponseBodyBuilds$inboundSchema)).optional(),
  env: z.array(z.string()),
  inspectorUrl: z.nullable(z.string()),
  isInConcurrentBuildsQueue: z.boolean(),
  isInSystemBuildsQueue: z.boolean(),
  projectSettings: z.lazy(() => ResponseBodyProjectSettings$inboundSchema),
  readyStateReason: z.string().optional(),
  integrations: z.lazy(() => ResponseBodyIntegrations$inboundSchema).optional(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => ResponseBodyCreator$inboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => GetDeploymentResponseBodyLambdas$inboundSchema))
    .optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: ResponseBodyStatus$inboundSchema,
  team: z.lazy(() => GetDeploymentResponseBodyTeam$inboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => GetDeploymentCustomEnvironmentDeployments1$inboundSchema),
    z.lazy(() => GetDeploymentCustomEnvironmentDeployments2$inboundSchema),
  ]).optional(),
  aliasWarning: z.nullable(
    z.lazy(() => GetDeploymentResponseBodyAliasWarning$inboundSchema),
  ).optional(),
  id: z.string(),
  type: ResponseBodyType$inboundSchema,
  createdAt: z.number(),
  name: z.string(),
  readyState: ResponseBodyReadyState$inboundSchema,
  aliasError: z.nullable(z.lazy(() => ResponseBodyAliasError$inboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: ResponseBodyChecksState$inboundSchema.optional(),
  checksConclusion: ResponseBodyChecksConclusion$inboundSchema.optional(),
  deletedAt: z.nullable(z.number()).optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.nullable(z.string()).optional(),
  errorStep: z.string().optional(),
  passiveRegions: z.array(z.string()).optional(),
  gitSource: z.union([
    z.lazy(() => GetDeploymentGitSourceDeployments6$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments8$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments1$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments3$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments2$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments4$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments5$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments7$inboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments9$inboundSchema),
  ]).optional(),
  meta: z.record(z.string()),
  project: z.lazy(() => ResponseBodyProject$inboundSchema).optional(),
  readySubstate: ResponseBodyReadySubstate$inboundSchema.optional(),
  regions: z.array(z.string()),
  softDeletedByRetention: z.boolean().optional(),
  source: ResponseBodySource$inboundSchema.optional(),
  target: z.nullable(ResponseBodyTarget$inboundSchema).optional(),
  undeletedAt: z.number().optional(),
  url: z.string(),
  version: z.number(),
  oidcTokenClaims: z.lazy(() => ResponseBodyOidcTokenClaims$inboundSchema)
    .optional(),
  projectId: z.string(),
  plan: ResponseBodyPlan$inboundSchema,
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdIn: z.string(),
  crons: z.array(z.lazy(() => ResponseBodyCrons$inboundSchema)).optional(),
  functions: z.nullable(
    z.record(z.lazy(() => ResponseBodyFunctions$inboundSchema)),
  ).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  ownerId: z.string(),
  passiveConnectConfigurationId: z.string().optional(),
  routes: z.nullable(
    z.array(z.union([
      z.lazy(() => GetDeploymentRoutes3$inboundSchema),
      z.lazy(() =>
        GetDeploymentRoutes2$inboundSchema
      ),
      z.lazy(() => GetDeploymentRoutes1$inboundSchema),
    ])),
  ),
  gitRepo: z.nullable(
    z.union([
      z.lazy(() => GetDeploymentGitRepo1$inboundSchema),
      z.lazy(() => GetDeploymentGitRepo2$inboundSchema),
      z.lazy(() => GetDeploymentGitRepo3$inboundSchema),
    ]),
  ).optional(),
  flags: z.union([
    z.lazy(() => GetDeploymentFlags1$inboundSchema),
    z.array(z.lazy(() => GetDeploymentFlags2$inboundSchema)),
  ]).optional(),
});

/** @internal */
export type GetDeploymentResponseBody1$Outbound = {
  aliasAssignedAt?: number | boolean | null | undefined;
  alwaysRefuseToBuild?: boolean | undefined;
  build: ResponseBodyBuild$Outbound;
  buildArtifactUrls?: Array<string> | undefined;
  builds?: Array<ResponseBodyBuilds$Outbound> | undefined;
  env: Array<string>;
  inspectorUrl: string | null;
  isInConcurrentBuildsQueue: boolean;
  isInSystemBuildsQueue: boolean;
  projectSettings: ResponseBodyProjectSettings$Outbound;
  readyStateReason?: string | undefined;
  integrations?: ResponseBodyIntegrations$Outbound | undefined;
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: ResponseBodyCreator$Outbound;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<GetDeploymentResponseBodyLambdas$Outbound> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: string;
  team?: GetDeploymentResponseBodyTeam$Outbound | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | GetDeploymentCustomEnvironmentDeployments1$Outbound
    | GetDeploymentCustomEnvironmentDeployments2$Outbound
    | undefined;
  aliasWarning?:
    | GetDeploymentResponseBodyAliasWarning$Outbound
    | null
    | undefined;
  id: string;
  type: string;
  createdAt: number;
  name: string;
  readyState: string;
  aliasError?: ResponseBodyAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: string | undefined;
  checksConclusion?: string | undefined;
  deletedAt?: number | null | undefined;
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorMessage?: string | null | undefined;
  errorStep?: string | undefined;
  passiveRegions?: Array<string> | undefined;
  gitSource?:
    | GetDeploymentGitSourceDeployments6$Outbound
    | GetDeploymentGitSourceDeployments8$Outbound
    | GetDeploymentGitSourceDeployments1$Outbound
    | GetDeploymentGitSourceDeployments3$Outbound
    | GetDeploymentGitSourceDeployments2$Outbound
    | GetDeploymentGitSourceDeployments4$Outbound
    | GetDeploymentGitSourceDeployments5$Outbound
    | GetDeploymentGitSourceDeployments7$Outbound
    | GetDeploymentGitSourceDeployments9$Outbound
    | undefined;
  meta: { [k: string]: string };
  project?: ResponseBodyProject$Outbound | undefined;
  readySubstate?: string | undefined;
  regions: Array<string>;
  softDeletedByRetention?: boolean | undefined;
  source?: string | undefined;
  target?: string | null | undefined;
  undeletedAt?: number | undefined;
  url: string;
  version: number;
  oidcTokenClaims?: ResponseBodyOidcTokenClaims$Outbound | undefined;
  projectId: string;
  plan: string;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdIn: string;
  crons?: Array<ResponseBodyCrons$Outbound> | undefined;
  functions?:
    | { [k: string]: ResponseBodyFunctions$Outbound }
    | null
    | undefined;
  monorepoManager?: string | null | undefined;
  ownerId: string;
  passiveConnectConfigurationId?: string | undefined;
  routes:
    | Array<
      | GetDeploymentRoutes3$Outbound
      | GetDeploymentRoutes2$Outbound
      | GetDeploymentRoutes1$Outbound
    >
    | null;
  gitRepo?:
    | GetDeploymentGitRepo1$Outbound
    | GetDeploymentGitRepo2$Outbound
    | GetDeploymentGitRepo3$Outbound
    | null
    | undefined;
  flags?:
    | GetDeploymentFlags1$Outbound
    | Array<GetDeploymentFlags2$Outbound>
    | undefined;
};

/** @internal */
export const GetDeploymentResponseBody1$outboundSchema: z.ZodType<
  GetDeploymentResponseBody1$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBody1
> = z.object({
  aliasAssignedAt: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  alwaysRefuseToBuild: z.boolean().optional(),
  build: z.lazy(() => ResponseBodyBuild$outboundSchema),
  buildArtifactUrls: z.array(z.string()).optional(),
  builds: z.array(z.lazy(() => ResponseBodyBuilds$outboundSchema)).optional(),
  env: z.array(z.string()),
  inspectorUrl: z.nullable(z.string()),
  isInConcurrentBuildsQueue: z.boolean(),
  isInSystemBuildsQueue: z.boolean(),
  projectSettings: z.lazy(() => ResponseBodyProjectSettings$outboundSchema),
  readyStateReason: z.string().optional(),
  integrations: z.lazy(() => ResponseBodyIntegrations$outboundSchema)
    .optional(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => ResponseBodyCreator$outboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(
    z.lazy(() => GetDeploymentResponseBodyLambdas$outboundSchema),
  ).optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: ResponseBodyStatus$outboundSchema,
  team: z.lazy(() => GetDeploymentResponseBodyTeam$outboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => GetDeploymentCustomEnvironmentDeployments1$outboundSchema),
    z.lazy(() => GetDeploymentCustomEnvironmentDeployments2$outboundSchema),
  ]).optional(),
  aliasWarning: z.nullable(
    z.lazy(() => GetDeploymentResponseBodyAliasWarning$outboundSchema),
  ).optional(),
  id: z.string(),
  type: ResponseBodyType$outboundSchema,
  createdAt: z.number(),
  name: z.string(),
  readyState: ResponseBodyReadyState$outboundSchema,
  aliasError: z.nullable(z.lazy(() => ResponseBodyAliasError$outboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: ResponseBodyChecksState$outboundSchema.optional(),
  checksConclusion: ResponseBodyChecksConclusion$outboundSchema.optional(),
  deletedAt: z.nullable(z.number()).optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.nullable(z.string()).optional(),
  errorStep: z.string().optional(),
  passiveRegions: z.array(z.string()).optional(),
  gitSource: z.union([
    z.lazy(() => GetDeploymentGitSourceDeployments6$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments8$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments1$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments3$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments2$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments4$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments5$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments7$outboundSchema),
    z.lazy(() => GetDeploymentGitSourceDeployments9$outboundSchema),
  ]).optional(),
  meta: z.record(z.string()),
  project: z.lazy(() => ResponseBodyProject$outboundSchema).optional(),
  readySubstate: ResponseBodyReadySubstate$outboundSchema.optional(),
  regions: z.array(z.string()),
  softDeletedByRetention: z.boolean().optional(),
  source: ResponseBodySource$outboundSchema.optional(),
  target: z.nullable(ResponseBodyTarget$outboundSchema).optional(),
  undeletedAt: z.number().optional(),
  url: z.string(),
  version: z.number(),
  oidcTokenClaims: z.lazy(() => ResponseBodyOidcTokenClaims$outboundSchema)
    .optional(),
  projectId: z.string(),
  plan: ResponseBodyPlan$outboundSchema,
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdIn: z.string(),
  crons: z.array(z.lazy(() => ResponseBodyCrons$outboundSchema)).optional(),
  functions: z.nullable(
    z.record(z.lazy(() => ResponseBodyFunctions$outboundSchema)),
  ).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  ownerId: z.string(),
  passiveConnectConfigurationId: z.string().optional(),
  routes: z.nullable(
    z.array(z.union([
      z.lazy(() => GetDeploymentRoutes3$outboundSchema),
      z.lazy(() =>
        GetDeploymentRoutes2$outboundSchema
      ),
      z.lazy(() => GetDeploymentRoutes1$outboundSchema),
    ])),
  ),
  gitRepo: z.nullable(
    z.union([
      z.lazy(() => GetDeploymentGitRepo1$outboundSchema),
      z.lazy(() => GetDeploymentGitRepo2$outboundSchema),
      z.lazy(() => GetDeploymentGitRepo3$outboundSchema),
    ]),
  ).optional(),
  flags: z.union([
    z.lazy(() => GetDeploymentFlags1$outboundSchema),
    z.array(z.lazy(() => GetDeploymentFlags2$outboundSchema)),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBody1$ {
  /** @deprecated use `GetDeploymentResponseBody1$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBody1$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBody1$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBody1$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBody1$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBody1$Outbound;
}

/** @internal */
export const GetDeploymentResponseBody$inboundSchema: z.ZodType<
  GetDeploymentResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetDeploymentResponseBody2$inboundSchema),
  z.lazy(() => GetDeploymentResponseBody1$inboundSchema),
]);

/** @internal */
export type GetDeploymentResponseBody$Outbound =
  | GetDeploymentResponseBody2$Outbound
  | GetDeploymentResponseBody1$Outbound;

/** @internal */
export const GetDeploymentResponseBody$outboundSchema: z.ZodType<
  GetDeploymentResponseBody$Outbound,
  z.ZodTypeDef,
  GetDeploymentResponseBody
> = z.union([
  z.lazy(() => GetDeploymentResponseBody2$outboundSchema),
  z.lazy(() => GetDeploymentResponseBody1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetDeploymentResponseBody$ {
  /** @deprecated use `GetDeploymentResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetDeploymentResponseBody$inboundSchema;
  /** @deprecated use `GetDeploymentResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetDeploymentResponseBody$outboundSchema;
  /** @deprecated use `GetDeploymentResponseBody$Outbound` instead. */
  export type Outbound = GetDeploymentResponseBody$Outbound;
}
