/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export const View = {
  Account: "account",
  Project: "project",
} as const;
export type View = ClosedEnum<typeof View>;

export const InstallationType = {
  Marketplace: "marketplace",
  External: "external",
} as const;
export type InstallationType = ClosedEnum<typeof InstallationType>;

export type GetConfigurationsRequest = {
  view: View;
  installationType?: InstallationType | undefined;
  /**
   * ID of the integration
   */
  integrationIdOrSlug?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export type Integration = {
  name: string;
  icon: string;
  category: string;
  isLegacy: boolean;
  flags?: Array<string> | undefined;
  assignedBetaLabelAt?: number | undefined;
};

/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export const GetConfigurationsResponseBodyIntegrationsSource = {
  Marketplace: "marketplace",
  DeployButton: "deploy-button",
  External: "external",
} as const;
/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export type GetConfigurationsResponseBodyIntegrationsSource = ClosedEnum<
  typeof GetConfigurationsResponseBodyIntegrationsSource
>;

export const GetConfigurationsResponseBodyIntegrationsType = {
  IntegrationConfiguration: "integration-configuration",
} as const;
export type GetConfigurationsResponseBodyIntegrationsType = ClosedEnum<
  typeof GetConfigurationsResponseBodyIntegrationsType
>;

export const ResponseBodyDisabledReason = {
  DisabledByOwner: "disabled-by-owner",
  FeatureNotAvailable: "feature-not-available",
  DisabledByAdmin: "disabled-by-admin",
  OriginalOwnerLeftTheTeam: "original-owner-left-the-team",
  AccountPlanDowngrade: "account-plan-downgrade",
  OriginalOwnerRoleDowngraded: "original-owner-role-downgraded",
} as const;
export type ResponseBodyDisabledReason = ClosedEnum<
  typeof ResponseBodyDisabledReason
>;

/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export const GetConfigurationsResponseBodyInstallationType = {
  Marketplace: "marketplace",
  External: "external",
} as const;
/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export type GetConfigurationsResponseBodyInstallationType = ClosedEnum<
  typeof GetConfigurationsResponseBodyInstallationType
>;

export const GetConfigurationsResponseBodyIntegrationsResponse200Type = {
  Prepayment: "prepayment",
  Subscription: "subscription",
} as const;
export type GetConfigurationsResponseBodyIntegrationsResponse200Type =
  ClosedEnum<typeof GetConfigurationsResponseBodyIntegrationsResponse200Type>;

export const GetConfigurationsResponseBodyScope = {
  Installation: "installation",
  Resource: "resource",
} as const;
export type GetConfigurationsResponseBodyScope = ClosedEnum<
  typeof GetConfigurationsResponseBodyScope
>;

export type ResponseBodyDetails = {
  label: string;
  value?: string | undefined;
};

export type ResponseBodyHeightlightedDetails = {
  label: string;
  value?: string | undefined;
};

export type ResponseBodyQuote = {
  line: string;
  amount: string;
};

export type ResponseBodyBillingPlan = {
  id: string;
  type: GetConfigurationsResponseBodyIntegrationsResponse200Type;
  name: string;
  scope?: GetConfigurationsResponseBodyScope | undefined;
  description: string;
  paymentMethodRequired?: boolean | undefined;
  preauthorizationAmount?: number | undefined;
  cost?: string | undefined;
  details?: Array<ResponseBodyDetails> | undefined;
  heightlightedDetails?: Array<ResponseBodyHeightlightedDetails> | undefined;
  quote?: Array<ResponseBodyQuote> | undefined;
  effectiveDate?: string | undefined;
};

export type GetConfigurationsResponseBody2 = {
  integration: Integration;
  /**
   * A timestamp that tells you when the configuration was installed successfully
   */
  completedAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was created
   */
  createdAt: number;
  /**
   * The unique identifier of the configuration
   */
  id: string;
  /**
   * The unique identifier of the app the configuration was created for
   */
  integrationId: string;
  /**
   * The user or team ID that owns the configuration
   */
  ownerId: string;
  /**
   * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
   */
  projects?: Array<string> | undefined;
  /**
   * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
   */
  source?: GetConfigurationsResponseBodyIntegrationsSource | undefined;
  /**
   * The slug of the integration the configuration is created for.
   */
  slug: string;
  /**
   * When the configuration was created for a team, this will show the ID of the team.
   */
  teamId?: string | null | undefined;
  type: GetConfigurationsResponseBodyIntegrationsType;
  /**
   * A timestamp that tells you when the configuration was updated.
   */
  updatedAt: number;
  /**
   * The ID of the user that created the configuration.
   */
  userId: string;
  /**
   * The resources that are allowed to be accessed by the configuration.
   */
  scopes: Array<string>;
  /**
   * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
   */
  disabledAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was deleted.
   */
  deletedAt?: number | null | undefined;
  /**
   * A timestamp that tells you when the configuration deletion has been started for cases when the deletion needs to be settled/approved by partners, such as when marketplace invoices have been paid.
   */
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: ResponseBodyDisabledReason | undefined;
  /**
   * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
   */
  installationType?: GetConfigurationsResponseBodyInstallationType | undefined;
  billingPlan?: ResponseBodyBillingPlan | undefined;
  billingTotal?: string | undefined;
  periodStart?: string | undefined;
  periodEnd?: string | undefined;
};

/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export const GetConfigurationsResponseBodySource = {
  Marketplace: "marketplace",
  DeployButton: "deploy-button",
  External: "external",
} as const;
/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export type GetConfigurationsResponseBodySource = ClosedEnum<
  typeof GetConfigurationsResponseBodySource
>;

export const GetConfigurationsResponseBodyType = {
  IntegrationConfiguration: "integration-configuration",
} as const;
export type GetConfigurationsResponseBodyType = ClosedEnum<
  typeof GetConfigurationsResponseBodyType
>;

export const GetConfigurationsResponseBodyDisabledReason = {
  DisabledByOwner: "disabled-by-owner",
  FeatureNotAvailable: "feature-not-available",
  DisabledByAdmin: "disabled-by-admin",
  OriginalOwnerLeftTheTeam: "original-owner-left-the-team",
  AccountPlanDowngrade: "account-plan-downgrade",
  OriginalOwnerRoleDowngraded: "original-owner-role-downgraded",
} as const;
export type GetConfigurationsResponseBodyDisabledReason = ClosedEnum<
  typeof GetConfigurationsResponseBodyDisabledReason
>;

/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export const ResponseBodyInstallationType = {
  Marketplace: "marketplace",
  External: "external",
} as const;
/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export type ResponseBodyInstallationType = ClosedEnum<
  typeof ResponseBodyInstallationType
>;

export const GetConfigurationsResponseBodyIntegrationsResponseType = {
  Prepayment: "prepayment",
  Subscription: "subscription",
} as const;
export type GetConfigurationsResponseBodyIntegrationsResponseType = ClosedEnum<
  typeof GetConfigurationsResponseBodyIntegrationsResponseType
>;

export const ResponseBodyScope = {
  Installation: "installation",
  Resource: "resource",
} as const;
export type ResponseBodyScope = ClosedEnum<typeof ResponseBodyScope>;

export type Details = {
  label: string;
  value?: string | undefined;
};

export type HeightlightedDetails = {
  label: string;
  value?: string | undefined;
};

export type Quote = {
  line: string;
  amount: string;
};

export type BillingPlan = {
  id: string;
  type: GetConfigurationsResponseBodyIntegrationsResponseType;
  name: string;
  scope?: ResponseBodyScope | undefined;
  description: string;
  paymentMethodRequired?: boolean | undefined;
  preauthorizationAmount?: number | undefined;
  cost?: string | undefined;
  details?: Array<Details> | undefined;
  heightlightedDetails?: Array<HeightlightedDetails> | undefined;
  quote?: Array<Quote> | undefined;
  effectiveDate?: string | undefined;
};

/**
 * The list of configurations for the authenticated user
 */
export type GetConfigurationsResponseBody1 = {
  /**
   * A timestamp that tells you when the configuration was installed successfully
   */
  completedAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was created
   */
  createdAt?: number | undefined;
  /**
   * The unique identifier of the configuration
   */
  id?: string | undefined;
  /**
   * The unique identifier of the app the configuration was created for
   */
  integrationId?: string | undefined;
  /**
   * The user or team ID that owns the configuration
   */
  ownerId?: string | undefined;
  /**
   * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
   */
  projects?: Array<string> | undefined;
  /**
   * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
   */
  source?: GetConfigurationsResponseBodySource | undefined;
  /**
   * The slug of the integration the configuration is created for.
   */
  slug?: string | undefined;
  /**
   * When the configuration was created for a team, this will show the ID of the team.
   */
  teamId?: string | null | undefined;
  type?: GetConfigurationsResponseBodyType | undefined;
  /**
   * A timestamp that tells you when the configuration was updated.
   */
  updatedAt?: number | undefined;
  /**
   * The ID of the user that created the configuration.
   */
  userId?: string | undefined;
  /**
   * The resources that are allowed to be accessed by the configuration.
   */
  scopes?: Array<string> | undefined;
  /**
   * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
   */
  disabledAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was deleted.
   */
  deletedAt?: number | null | undefined;
  /**
   * A timestamp that tells you when the configuration deletion has been started for cases when the deletion needs to be settled/approved by partners, such as when marketplace invoices have been paid.
   */
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: GetConfigurationsResponseBodyDisabledReason | undefined;
  /**
   * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
   */
  installationType?: ResponseBodyInstallationType | undefined;
  billingPlan?: BillingPlan | undefined;
  billingTotal?: string | undefined;
  periodStart?: string | undefined;
  periodEnd?: string | undefined;
};

/**
 * The list of configurations for the authenticated user
 */
export type GetConfigurationsResponseBody =
  | Array<GetConfigurationsResponseBody1>
  | Array<GetConfigurationsResponseBody2>;

/** @internal */
export const View$inboundSchema: z.ZodNativeEnum<typeof View> = z.nativeEnum(
  View,
);

/** @internal */
export const View$outboundSchema: z.ZodNativeEnum<typeof View> =
  View$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace View$ {
  /** @deprecated use `View$inboundSchema` instead. */
  export const inboundSchema = View$inboundSchema;
  /** @deprecated use `View$outboundSchema` instead. */
  export const outboundSchema = View$outboundSchema;
}

/** @internal */
export const InstallationType$inboundSchema: z.ZodNativeEnum<
  typeof InstallationType
> = z.nativeEnum(InstallationType);

/** @internal */
export const InstallationType$outboundSchema: z.ZodNativeEnum<
  typeof InstallationType
> = InstallationType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace InstallationType$ {
  /** @deprecated use `InstallationType$inboundSchema` instead. */
  export const inboundSchema = InstallationType$inboundSchema;
  /** @deprecated use `InstallationType$outboundSchema` instead. */
  export const outboundSchema = InstallationType$outboundSchema;
}

/** @internal */
export const GetConfigurationsRequest$inboundSchema: z.ZodType<
  GetConfigurationsRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  view: View$inboundSchema,
  installationType: InstallationType$inboundSchema.optional(),
  integrationIdOrSlug: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetConfigurationsRequest$Outbound = {
  view: string;
  installationType?: string | undefined;
  integrationIdOrSlug?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetConfigurationsRequest$outboundSchema: z.ZodType<
  GetConfigurationsRequest$Outbound,
  z.ZodTypeDef,
  GetConfigurationsRequest
> = z.object({
  view: View$outboundSchema,
  installationType: InstallationType$outboundSchema.optional(),
  integrationIdOrSlug: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsRequest$ {
  /** @deprecated use `GetConfigurationsRequest$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationsRequest$inboundSchema;
  /** @deprecated use `GetConfigurationsRequest$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationsRequest$outboundSchema;
  /** @deprecated use `GetConfigurationsRequest$Outbound` instead. */
  export type Outbound = GetConfigurationsRequest$Outbound;
}

/** @internal */
export const Integration$inboundSchema: z.ZodType<
  Integration,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  icon: z.string(),
  category: z.string(),
  isLegacy: z.boolean(),
  flags: z.array(z.string()).optional(),
  assignedBetaLabelAt: z.number().optional(),
});

/** @internal */
export type Integration$Outbound = {
  name: string;
  icon: string;
  category: string;
  isLegacy: boolean;
  flags?: Array<string> | undefined;
  assignedBetaLabelAt?: number | undefined;
};

/** @internal */
export const Integration$outboundSchema: z.ZodType<
  Integration$Outbound,
  z.ZodTypeDef,
  Integration
> = z.object({
  name: z.string(),
  icon: z.string(),
  category: z.string(),
  isLegacy: z.boolean(),
  flags: z.array(z.string()).optional(),
  assignedBetaLabelAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Integration$ {
  /** @deprecated use `Integration$inboundSchema` instead. */
  export const inboundSchema = Integration$inboundSchema;
  /** @deprecated use `Integration$outboundSchema` instead. */
  export const outboundSchema = Integration$outboundSchema;
  /** @deprecated use `Integration$Outbound` instead. */
  export type Outbound = Integration$Outbound;
}

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsSource$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyIntegrationsSource> = z
    .nativeEnum(GetConfigurationsResponseBodyIntegrationsSource);

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsSource$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyIntegrationsSource> =
    GetConfigurationsResponseBodyIntegrationsSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyIntegrationsSource$ {
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsSource$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodyIntegrationsSource$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsSource$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyIntegrationsSource$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsType$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyIntegrationsType> = z
    .nativeEnum(GetConfigurationsResponseBodyIntegrationsType);

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsType$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyIntegrationsType> =
    GetConfigurationsResponseBodyIntegrationsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyIntegrationsType$ {
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodyIntegrationsType$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyIntegrationsType$outboundSchema;
}

/** @internal */
export const ResponseBodyDisabledReason$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyDisabledReason
> = z.nativeEnum(ResponseBodyDisabledReason);

/** @internal */
export const ResponseBodyDisabledReason$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyDisabledReason
> = ResponseBodyDisabledReason$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyDisabledReason$ {
  /** @deprecated use `ResponseBodyDisabledReason$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyDisabledReason$inboundSchema;
  /** @deprecated use `ResponseBodyDisabledReason$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyDisabledReason$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyInstallationType$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyInstallationType> = z
    .nativeEnum(GetConfigurationsResponseBodyInstallationType);

/** @internal */
export const GetConfigurationsResponseBodyInstallationType$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyInstallationType> =
    GetConfigurationsResponseBodyInstallationType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyInstallationType$ {
  /** @deprecated use `GetConfigurationsResponseBodyInstallationType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodyInstallationType$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyInstallationType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyInstallationType$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsResponse200Type$inboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationsResponseBodyIntegrationsResponse200Type
  > = z.nativeEnum(GetConfigurationsResponseBodyIntegrationsResponse200Type);

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsResponse200Type$outboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationsResponseBodyIntegrationsResponse200Type
  > = GetConfigurationsResponseBodyIntegrationsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyIntegrationsResponse200Type$ {
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodyIntegrationsResponse200Type$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyIntegrationsResponse200Type$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyScope$inboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationsResponseBodyScope
> = z.nativeEnum(GetConfigurationsResponseBodyScope);

/** @internal */
export const GetConfigurationsResponseBodyScope$outboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationsResponseBodyScope
> = GetConfigurationsResponseBodyScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyScope$ {
  /** @deprecated use `GetConfigurationsResponseBodyScope$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationsResponseBodyScope$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyScope$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyScope$outboundSchema;
}

/** @internal */
export const ResponseBodyDetails$inboundSchema: z.ZodType<
  ResponseBodyDetails,
  z.ZodTypeDef,
  unknown
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type ResponseBodyDetails$Outbound = {
  label: string;
  value?: string | undefined;
};

/** @internal */
export const ResponseBodyDetails$outboundSchema: z.ZodType<
  ResponseBodyDetails$Outbound,
  z.ZodTypeDef,
  ResponseBodyDetails
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyDetails$ {
  /** @deprecated use `ResponseBodyDetails$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyDetails$inboundSchema;
  /** @deprecated use `ResponseBodyDetails$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyDetails$outboundSchema;
  /** @deprecated use `ResponseBodyDetails$Outbound` instead. */
  export type Outbound = ResponseBodyDetails$Outbound;
}

/** @internal */
export const ResponseBodyHeightlightedDetails$inboundSchema: z.ZodType<
  ResponseBodyHeightlightedDetails,
  z.ZodTypeDef,
  unknown
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type ResponseBodyHeightlightedDetails$Outbound = {
  label: string;
  value?: string | undefined;
};

/** @internal */
export const ResponseBodyHeightlightedDetails$outboundSchema: z.ZodType<
  ResponseBodyHeightlightedDetails$Outbound,
  z.ZodTypeDef,
  ResponseBodyHeightlightedDetails
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyHeightlightedDetails$ {
  /** @deprecated use `ResponseBodyHeightlightedDetails$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyHeightlightedDetails$inboundSchema;
  /** @deprecated use `ResponseBodyHeightlightedDetails$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyHeightlightedDetails$outboundSchema;
  /** @deprecated use `ResponseBodyHeightlightedDetails$Outbound` instead. */
  export type Outbound = ResponseBodyHeightlightedDetails$Outbound;
}

/** @internal */
export const ResponseBodyQuote$inboundSchema: z.ZodType<
  ResponseBodyQuote,
  z.ZodTypeDef,
  unknown
> = z.object({
  line: z.string(),
  amount: z.string(),
});

/** @internal */
export type ResponseBodyQuote$Outbound = {
  line: string;
  amount: string;
};

/** @internal */
export const ResponseBodyQuote$outboundSchema: z.ZodType<
  ResponseBodyQuote$Outbound,
  z.ZodTypeDef,
  ResponseBodyQuote
> = z.object({
  line: z.string(),
  amount: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyQuote$ {
  /** @deprecated use `ResponseBodyQuote$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyQuote$inboundSchema;
  /** @deprecated use `ResponseBodyQuote$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyQuote$outboundSchema;
  /** @deprecated use `ResponseBodyQuote$Outbound` instead. */
  export type Outbound = ResponseBodyQuote$Outbound;
}

/** @internal */
export const ResponseBodyBillingPlan$inboundSchema: z.ZodType<
  ResponseBodyBillingPlan,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  type: GetConfigurationsResponseBodyIntegrationsResponse200Type$inboundSchema,
  name: z.string(),
  scope: GetConfigurationsResponseBodyScope$inboundSchema.optional(),
  description: z.string(),
  paymentMethodRequired: z.boolean().optional(),
  preauthorizationAmount: z.number().optional(),
  cost: z.string().optional(),
  details: z.array(z.lazy(() => ResponseBodyDetails$inboundSchema)).optional(),
  heightlightedDetails: z.array(
    z.lazy(() => ResponseBodyHeightlightedDetails$inboundSchema),
  ).optional(),
  quote: z.array(z.lazy(() => ResponseBodyQuote$inboundSchema)).optional(),
  effectiveDate: z.string().optional(),
});

/** @internal */
export type ResponseBodyBillingPlan$Outbound = {
  id: string;
  type: string;
  name: string;
  scope?: string | undefined;
  description: string;
  paymentMethodRequired?: boolean | undefined;
  preauthorizationAmount?: number | undefined;
  cost?: string | undefined;
  details?: Array<ResponseBodyDetails$Outbound> | undefined;
  heightlightedDetails?:
    | Array<ResponseBodyHeightlightedDetails$Outbound>
    | undefined;
  quote?: Array<ResponseBodyQuote$Outbound> | undefined;
  effectiveDate?: string | undefined;
};

/** @internal */
export const ResponseBodyBillingPlan$outboundSchema: z.ZodType<
  ResponseBodyBillingPlan$Outbound,
  z.ZodTypeDef,
  ResponseBodyBillingPlan
> = z.object({
  id: z.string(),
  type: GetConfigurationsResponseBodyIntegrationsResponse200Type$outboundSchema,
  name: z.string(),
  scope: GetConfigurationsResponseBodyScope$outboundSchema.optional(),
  description: z.string(),
  paymentMethodRequired: z.boolean().optional(),
  preauthorizationAmount: z.number().optional(),
  cost: z.string().optional(),
  details: z.array(z.lazy(() => ResponseBodyDetails$outboundSchema)).optional(),
  heightlightedDetails: z.array(
    z.lazy(() => ResponseBodyHeightlightedDetails$outboundSchema),
  ).optional(),
  quote: z.array(z.lazy(() => ResponseBodyQuote$outboundSchema)).optional(),
  effectiveDate: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyBillingPlan$ {
  /** @deprecated use `ResponseBodyBillingPlan$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyBillingPlan$inboundSchema;
  /** @deprecated use `ResponseBodyBillingPlan$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyBillingPlan$outboundSchema;
  /** @deprecated use `ResponseBodyBillingPlan$Outbound` instead. */
  export type Outbound = ResponseBodyBillingPlan$Outbound;
}

/** @internal */
export const GetConfigurationsResponseBody2$inboundSchema: z.ZodType<
  GetConfigurationsResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  integration: z.lazy(() => Integration$inboundSchema),
  completedAt: z.number().optional(),
  createdAt: z.number(),
  id: z.string(),
  integrationId: z.string(),
  ownerId: z.string(),
  projects: z.array(z.string()).optional(),
  source: GetConfigurationsResponseBodyIntegrationsSource$inboundSchema
    .optional(),
  slug: z.string(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationsResponseBodyIntegrationsType$inboundSchema,
  updatedAt: z.number(),
  userId: z.string(),
  scopes: z.array(z.string()),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason: ResponseBodyDisabledReason$inboundSchema.optional(),
  installationType: GetConfigurationsResponseBodyInstallationType$inboundSchema
    .optional(),
  billingPlan: z.lazy(() => ResponseBodyBillingPlan$inboundSchema).optional(),
  billingTotal: z.string().optional(),
  periodStart: z.string().optional(),
  periodEnd: z.string().optional(),
});

/** @internal */
export type GetConfigurationsResponseBody2$Outbound = {
  integration: Integration$Outbound;
  completedAt?: number | undefined;
  createdAt: number;
  id: string;
  integrationId: string;
  ownerId: string;
  projects?: Array<string> | undefined;
  source?: string | undefined;
  slug: string;
  teamId?: string | null | undefined;
  type: string;
  updatedAt: number;
  userId: string;
  scopes: Array<string>;
  disabledAt?: number | undefined;
  deletedAt?: number | null | undefined;
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: string | undefined;
  installationType?: string | undefined;
  billingPlan?: ResponseBodyBillingPlan$Outbound | undefined;
  billingTotal?: string | undefined;
  periodStart?: string | undefined;
  periodEnd?: string | undefined;
};

/** @internal */
export const GetConfigurationsResponseBody2$outboundSchema: z.ZodType<
  GetConfigurationsResponseBody2$Outbound,
  z.ZodTypeDef,
  GetConfigurationsResponseBody2
> = z.object({
  integration: z.lazy(() => Integration$outboundSchema),
  completedAt: z.number().optional(),
  createdAt: z.number(),
  id: z.string(),
  integrationId: z.string(),
  ownerId: z.string(),
  projects: z.array(z.string()).optional(),
  source: GetConfigurationsResponseBodyIntegrationsSource$outboundSchema
    .optional(),
  slug: z.string(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationsResponseBodyIntegrationsType$outboundSchema,
  updatedAt: z.number(),
  userId: z.string(),
  scopes: z.array(z.string()),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason: ResponseBodyDisabledReason$outboundSchema.optional(),
  installationType: GetConfigurationsResponseBodyInstallationType$outboundSchema
    .optional(),
  billingPlan: z.lazy(() => ResponseBodyBillingPlan$outboundSchema).optional(),
  billingTotal: z.string().optional(),
  periodStart: z.string().optional(),
  periodEnd: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBody2$ {
  /** @deprecated use `GetConfigurationsResponseBody2$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationsResponseBody2$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBody2$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationsResponseBody2$outboundSchema;
  /** @deprecated use `GetConfigurationsResponseBody2$Outbound` instead. */
  export type Outbound = GetConfigurationsResponseBody2$Outbound;
}

/** @internal */
export const GetConfigurationsResponseBodySource$inboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationsResponseBodySource
> = z.nativeEnum(GetConfigurationsResponseBodySource);

/** @internal */
export const GetConfigurationsResponseBodySource$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodySource> =
    GetConfigurationsResponseBodySource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodySource$ {
  /** @deprecated use `GetConfigurationsResponseBodySource$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodySource$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodySource$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodySource$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyType$inboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationsResponseBodyType
> = z.nativeEnum(GetConfigurationsResponseBodyType);

/** @internal */
export const GetConfigurationsResponseBodyType$outboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationsResponseBodyType
> = GetConfigurationsResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyType$ {
  /** @deprecated use `GetConfigurationsResponseBodyType$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationsResponseBodyType$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyType$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyDisabledReason$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyDisabledReason> = z
    .nativeEnum(GetConfigurationsResponseBodyDisabledReason);

/** @internal */
export const GetConfigurationsResponseBodyDisabledReason$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationsResponseBodyDisabledReason> =
    GetConfigurationsResponseBodyDisabledReason$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyDisabledReason$ {
  /** @deprecated use `GetConfigurationsResponseBodyDisabledReason$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodyDisabledReason$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyDisabledReason$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyDisabledReason$outboundSchema;
}

/** @internal */
export const ResponseBodyInstallationType$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyInstallationType
> = z.nativeEnum(ResponseBodyInstallationType);

/** @internal */
export const ResponseBodyInstallationType$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyInstallationType
> = ResponseBodyInstallationType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyInstallationType$ {
  /** @deprecated use `ResponseBodyInstallationType$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyInstallationType$inboundSchema;
  /** @deprecated use `ResponseBodyInstallationType$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyInstallationType$outboundSchema;
}

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsResponseType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationsResponseBodyIntegrationsResponseType
  > = z.nativeEnum(GetConfigurationsResponseBodyIntegrationsResponseType);

/** @internal */
export const GetConfigurationsResponseBodyIntegrationsResponseType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationsResponseBodyIntegrationsResponseType
  > = GetConfigurationsResponseBodyIntegrationsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBodyIntegrationsResponseType$ {
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationsResponseBodyIntegrationsResponseType$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBodyIntegrationsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationsResponseBodyIntegrationsResponseType$outboundSchema;
}

/** @internal */
export const ResponseBodyScope$inboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyScope
> = z.nativeEnum(ResponseBodyScope);

/** @internal */
export const ResponseBodyScope$outboundSchema: z.ZodNativeEnum<
  typeof ResponseBodyScope
> = ResponseBodyScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBodyScope$ {
  /** @deprecated use `ResponseBodyScope$inboundSchema` instead. */
  export const inboundSchema = ResponseBodyScope$inboundSchema;
  /** @deprecated use `ResponseBodyScope$outboundSchema` instead. */
  export const outboundSchema = ResponseBodyScope$outboundSchema;
}

/** @internal */
export const Details$inboundSchema: z.ZodType<Details, z.ZodTypeDef, unknown> =
  z.object({
    label: z.string(),
    value: z.string().optional(),
  });

/** @internal */
export type Details$Outbound = {
  label: string;
  value?: string | undefined;
};

/** @internal */
export const Details$outboundSchema: z.ZodType<
  Details$Outbound,
  z.ZodTypeDef,
  Details
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Details$ {
  /** @deprecated use `Details$inboundSchema` instead. */
  export const inboundSchema = Details$inboundSchema;
  /** @deprecated use `Details$outboundSchema` instead. */
  export const outboundSchema = Details$outboundSchema;
  /** @deprecated use `Details$Outbound` instead. */
  export type Outbound = Details$Outbound;
}

/** @internal */
export const HeightlightedDetails$inboundSchema: z.ZodType<
  HeightlightedDetails,
  z.ZodTypeDef,
  unknown
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type HeightlightedDetails$Outbound = {
  label: string;
  value?: string | undefined;
};

/** @internal */
export const HeightlightedDetails$outboundSchema: z.ZodType<
  HeightlightedDetails$Outbound,
  z.ZodTypeDef,
  HeightlightedDetails
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace HeightlightedDetails$ {
  /** @deprecated use `HeightlightedDetails$inboundSchema` instead. */
  export const inboundSchema = HeightlightedDetails$inboundSchema;
  /** @deprecated use `HeightlightedDetails$outboundSchema` instead. */
  export const outboundSchema = HeightlightedDetails$outboundSchema;
  /** @deprecated use `HeightlightedDetails$Outbound` instead. */
  export type Outbound = HeightlightedDetails$Outbound;
}

/** @internal */
export const Quote$inboundSchema: z.ZodType<Quote, z.ZodTypeDef, unknown> = z
  .object({
    line: z.string(),
    amount: z.string(),
  });

/** @internal */
export type Quote$Outbound = {
  line: string;
  amount: string;
};

/** @internal */
export const Quote$outboundSchema: z.ZodType<
  Quote$Outbound,
  z.ZodTypeDef,
  Quote
> = z.object({
  line: z.string(),
  amount: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Quote$ {
  /** @deprecated use `Quote$inboundSchema` instead. */
  export const inboundSchema = Quote$inboundSchema;
  /** @deprecated use `Quote$outboundSchema` instead. */
  export const outboundSchema = Quote$outboundSchema;
  /** @deprecated use `Quote$Outbound` instead. */
  export type Outbound = Quote$Outbound;
}

/** @internal */
export const BillingPlan$inboundSchema: z.ZodType<
  BillingPlan,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  type: GetConfigurationsResponseBodyIntegrationsResponseType$inboundSchema,
  name: z.string(),
  scope: ResponseBodyScope$inboundSchema.optional(),
  description: z.string(),
  paymentMethodRequired: z.boolean().optional(),
  preauthorizationAmount: z.number().optional(),
  cost: z.string().optional(),
  details: z.array(z.lazy(() => Details$inboundSchema)).optional(),
  heightlightedDetails: z.array(
    z.lazy(() => HeightlightedDetails$inboundSchema),
  ).optional(),
  quote: z.array(z.lazy(() => Quote$inboundSchema)).optional(),
  effectiveDate: z.string().optional(),
});

/** @internal */
export type BillingPlan$Outbound = {
  id: string;
  type: string;
  name: string;
  scope?: string | undefined;
  description: string;
  paymentMethodRequired?: boolean | undefined;
  preauthorizationAmount?: number | undefined;
  cost?: string | undefined;
  details?: Array<Details$Outbound> | undefined;
  heightlightedDetails?: Array<HeightlightedDetails$Outbound> | undefined;
  quote?: Array<Quote$Outbound> | undefined;
  effectiveDate?: string | undefined;
};

/** @internal */
export const BillingPlan$outboundSchema: z.ZodType<
  BillingPlan$Outbound,
  z.ZodTypeDef,
  BillingPlan
> = z.object({
  id: z.string(),
  type: GetConfigurationsResponseBodyIntegrationsResponseType$outboundSchema,
  name: z.string(),
  scope: ResponseBodyScope$outboundSchema.optional(),
  description: z.string(),
  paymentMethodRequired: z.boolean().optional(),
  preauthorizationAmount: z.number().optional(),
  cost: z.string().optional(),
  details: z.array(z.lazy(() => Details$outboundSchema)).optional(),
  heightlightedDetails: z.array(
    z.lazy(() => HeightlightedDetails$outboundSchema),
  ).optional(),
  quote: z.array(z.lazy(() => Quote$outboundSchema)).optional(),
  effectiveDate: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BillingPlan$ {
  /** @deprecated use `BillingPlan$inboundSchema` instead. */
  export const inboundSchema = BillingPlan$inboundSchema;
  /** @deprecated use `BillingPlan$outboundSchema` instead. */
  export const outboundSchema = BillingPlan$outboundSchema;
  /** @deprecated use `BillingPlan$Outbound` instead. */
  export type Outbound = BillingPlan$Outbound;
}

/** @internal */
export const GetConfigurationsResponseBody1$inboundSchema: z.ZodType<
  GetConfigurationsResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  completedAt: z.number().optional(),
  createdAt: z.number().optional(),
  id: z.string().optional(),
  integrationId: z.string().optional(),
  ownerId: z.string().optional(),
  projects: z.array(z.string()).optional(),
  source: GetConfigurationsResponseBodySource$inboundSchema.optional(),
  slug: z.string().optional(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationsResponseBodyType$inboundSchema.optional(),
  updatedAt: z.number().optional(),
  userId: z.string().optional(),
  scopes: z.array(z.string()).optional(),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason: GetConfigurationsResponseBodyDisabledReason$inboundSchema
    .optional(),
  installationType: ResponseBodyInstallationType$inboundSchema.optional(),
  billingPlan: z.lazy(() => BillingPlan$inboundSchema).optional(),
  billingTotal: z.string().optional(),
  periodStart: z.string().optional(),
  periodEnd: z.string().optional(),
});

/** @internal */
export type GetConfigurationsResponseBody1$Outbound = {
  completedAt?: number | undefined;
  createdAt?: number | undefined;
  id?: string | undefined;
  integrationId?: string | undefined;
  ownerId?: string | undefined;
  projects?: Array<string> | undefined;
  source?: string | undefined;
  slug?: string | undefined;
  teamId?: string | null | undefined;
  type?: string | undefined;
  updatedAt?: number | undefined;
  userId?: string | undefined;
  scopes?: Array<string> | undefined;
  disabledAt?: number | undefined;
  deletedAt?: number | null | undefined;
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: string | undefined;
  installationType?: string | undefined;
  billingPlan?: BillingPlan$Outbound | undefined;
  billingTotal?: string | undefined;
  periodStart?: string | undefined;
  periodEnd?: string | undefined;
};

/** @internal */
export const GetConfigurationsResponseBody1$outboundSchema: z.ZodType<
  GetConfigurationsResponseBody1$Outbound,
  z.ZodTypeDef,
  GetConfigurationsResponseBody1
> = z.object({
  completedAt: z.number().optional(),
  createdAt: z.number().optional(),
  id: z.string().optional(),
  integrationId: z.string().optional(),
  ownerId: z.string().optional(),
  projects: z.array(z.string()).optional(),
  source: GetConfigurationsResponseBodySource$outboundSchema.optional(),
  slug: z.string().optional(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationsResponseBodyType$outboundSchema.optional(),
  updatedAt: z.number().optional(),
  userId: z.string().optional(),
  scopes: z.array(z.string()).optional(),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason: GetConfigurationsResponseBodyDisabledReason$outboundSchema
    .optional(),
  installationType: ResponseBodyInstallationType$outboundSchema.optional(),
  billingPlan: z.lazy(() => BillingPlan$outboundSchema).optional(),
  billingTotal: z.string().optional(),
  periodStart: z.string().optional(),
  periodEnd: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBody1$ {
  /** @deprecated use `GetConfigurationsResponseBody1$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationsResponseBody1$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBody1$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationsResponseBody1$outboundSchema;
  /** @deprecated use `GetConfigurationsResponseBody1$Outbound` instead. */
  export type Outbound = GetConfigurationsResponseBody1$Outbound;
}

/** @internal */
export const GetConfigurationsResponseBody$inboundSchema: z.ZodType<
  GetConfigurationsResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(z.lazy(() => GetConfigurationsResponseBody1$inboundSchema)),
  z.array(z.lazy(() => GetConfigurationsResponseBody2$inboundSchema)),
]);

/** @internal */
export type GetConfigurationsResponseBody$Outbound =
  | Array<GetConfigurationsResponseBody1$Outbound>
  | Array<GetConfigurationsResponseBody2$Outbound>;

/** @internal */
export const GetConfigurationsResponseBody$outboundSchema: z.ZodType<
  GetConfigurationsResponseBody$Outbound,
  z.ZodTypeDef,
  GetConfigurationsResponseBody
> = z.union([
  z.array(z.lazy(() => GetConfigurationsResponseBody1$outboundSchema)),
  z.array(z.lazy(() => GetConfigurationsResponseBody2$outboundSchema)),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationsResponseBody$ {
  /** @deprecated use `GetConfigurationsResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationsResponseBody$inboundSchema;
  /** @deprecated use `GetConfigurationsResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationsResponseBody$outboundSchema;
  /** @deprecated use `GetConfigurationsResponseBody$Outbound` instead. */
  export type Outbound = GetConfigurationsResponseBody$Outbound;
}
