/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type GetConfigurationRequest = {
  /**
   * ID of the configuration to check
   */
  id: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * A string representing the permission for projects. Possible values are `all` or `selected`.
 */
export const ProjectSelection = {
  Selected: "selected",
  All: "all",
} as const;
/**
 * A string representing the permission for projects. Possible values are `all` or `selected`.
 */
export type ProjectSelection = ClosedEnum<typeof ProjectSelection>;

/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export const GetConfigurationResponseBodyIntegrationsSource = {
  Marketplace: "marketplace",
  DeployButton: "deploy-button",
  External: "external",
} as const;
/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export type GetConfigurationResponseBodyIntegrationsSource = ClosedEnum<
  typeof GetConfigurationResponseBodyIntegrationsSource
>;

export const GetConfigurationResponseBodyIntegrationsType = {
  IntegrationConfiguration: "integration-configuration",
} as const;
export type GetConfigurationResponseBodyIntegrationsType = ClosedEnum<
  typeof GetConfigurationResponseBodyIntegrationsType
>;

export const GetConfigurationResponseBodyIntegrationsDisabledReason = {
  DisabledByOwner: "disabled-by-owner",
  FeatureNotAvailable: "feature-not-available",
  DisabledByAdmin: "disabled-by-admin",
  OriginalOwnerLeftTheTeam: "original-owner-left-the-team",
  AccountPlanDowngrade: "account-plan-downgrade",
  OriginalOwnerRoleDowngraded: "original-owner-role-downgraded",
} as const;
export type GetConfigurationResponseBodyIntegrationsDisabledReason = ClosedEnum<
  typeof GetConfigurationResponseBodyIntegrationsDisabledReason
>;

/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export const GetConfigurationResponseBodyIntegrationsInstallationType = {
  Marketplace: "marketplace",
  External: "external",
} as const;
/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export type GetConfigurationResponseBodyIntegrationsInstallationType =
  ClosedEnum<typeof GetConfigurationResponseBodyIntegrationsInstallationType>;

export type GetConfigurationResponseBody2 = {
  /**
   * A string representing the permission for projects. Possible values are `all` or `selected`.
   */
  projectSelection: ProjectSelection;
  /**
   * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
   */
  projects?: Array<string> | undefined;
  /**
   * A timestamp that tells you when the configuration was installed successfully
   */
  completedAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was created
   */
  createdAt: number;
  /**
   * The unique identifier of the configuration
   */
  id: string;
  /**
   * The unique identifier of the app the configuration was created for
   */
  integrationId: string;
  /**
   * The user or team ID that owns the configuration
   */
  ownerId: string;
  /**
   * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
   */
  source?: GetConfigurationResponseBodyIntegrationsSource | undefined;
  /**
   * The slug of the integration the configuration is created for.
   */
  slug: string;
  /**
   * When the configuration was created for a team, this will show the ID of the team.
   */
  teamId?: string | null | undefined;
  type: GetConfigurationResponseBodyIntegrationsType;
  /**
   * A timestamp that tells you when the configuration was updated.
   */
  updatedAt: number;
  /**
   * The ID of the user that created the configuration.
   */
  userId: string;
  /**
   * The resources that are allowed to be accessed by the configuration.
   */
  scopes: Array<string>;
  /**
   * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
   */
  disabledAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was deleted.
   */
  deletedAt?: number | null | undefined;
  /**
   * A timestamp that tells you when the configuration deletion has been started for cases when the deletion needs to be settled/approved by partners, such as when marketplace invoices have been paid.
   */
  deleteRequestedAt?: number | null | undefined;
  disabledReason?:
    | GetConfigurationResponseBodyIntegrationsDisabledReason
    | undefined;
  /**
   * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
   */
  installationType?:
    | GetConfigurationResponseBodyIntegrationsInstallationType
    | undefined;
  canConfigureOpenTelemetry?: boolean | undefined;
};

export const GetConfigurationResponseBodyIntegrationsResponseType = {
  Prepayment: "prepayment",
  Subscription: "subscription",
} as const;
export type GetConfigurationResponseBodyIntegrationsResponseType = ClosedEnum<
  typeof GetConfigurationResponseBodyIntegrationsResponseType
>;

export const GetConfigurationResponseBodyScope = {
  Installation: "installation",
  Resource: "resource",
} as const;
export type GetConfigurationResponseBodyScope = ClosedEnum<
  typeof GetConfigurationResponseBodyScope
>;

export type GetConfigurationResponseBodyDetails = {
  label: string;
  value?: string | undefined;
};

export type GetConfigurationResponseBodyHeightlightedDetails = {
  label: string;
  value?: string | undefined;
};

export type GetConfigurationResponseBodyQuote = {
  line: string;
  amount: string;
};

export type GetConfigurationResponseBodyBillingPlan = {
  id: string;
  type: GetConfigurationResponseBodyIntegrationsResponseType;
  name: string;
  scope?: GetConfigurationResponseBodyScope | undefined;
  description: string;
  paymentMethodRequired?: boolean | undefined;
  preauthorizationAmount?: number | undefined;
  cost?: string | undefined;
  details?: Array<GetConfigurationResponseBodyDetails> | undefined;
  heightlightedDetails?:
    | Array<GetConfigurationResponseBodyHeightlightedDetails>
    | undefined;
  quote?: Array<GetConfigurationResponseBodyQuote> | undefined;
  effectiveDate?: string | undefined;
};

/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export const GetConfigurationResponseBodySource = {
  Marketplace: "marketplace",
  DeployButton: "deploy-button",
  External: "external",
} as const;
/**
 * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
 */
export type GetConfigurationResponseBodySource = ClosedEnum<
  typeof GetConfigurationResponseBodySource
>;

export const GetConfigurationResponseBodyType = {
  IntegrationConfiguration: "integration-configuration",
} as const;
export type GetConfigurationResponseBodyType = ClosedEnum<
  typeof GetConfigurationResponseBodyType
>;

export const GetConfigurationResponseBodyDisabledReason = {
  DisabledByOwner: "disabled-by-owner",
  FeatureNotAvailable: "feature-not-available",
  DisabledByAdmin: "disabled-by-admin",
  OriginalOwnerLeftTheTeam: "original-owner-left-the-team",
  AccountPlanDowngrade: "account-plan-downgrade",
  OriginalOwnerRoleDowngraded: "original-owner-role-downgraded",
} as const;
export type GetConfigurationResponseBodyDisabledReason = ClosedEnum<
  typeof GetConfigurationResponseBodyDisabledReason
>;

/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export const GetConfigurationResponseBodyInstallationType = {
  Marketplace: "marketplace",
  External: "external",
} as const;
/**
 * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
 */
export type GetConfigurationResponseBodyInstallationType = ClosedEnum<
  typeof GetConfigurationResponseBodyInstallationType
>;

/**
 * The configuration with the provided id
 */
export type GetConfigurationResponseBody1 = {
  billingPlan?: GetConfigurationResponseBodyBillingPlan | undefined;
  billingTotal?: string | undefined;
  periodStart?: string | undefined;
  periodEnd?: string | undefined;
  /**
   * A timestamp that tells you when the configuration was installed successfully
   */
  completedAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was created
   */
  createdAt: number;
  /**
   * The unique identifier of the configuration
   */
  id: string;
  /**
   * The unique identifier of the app the configuration was created for
   */
  integrationId: string;
  /**
   * The user or team ID that owns the configuration
   */
  ownerId: string;
  /**
   * When a configuration is limited to access certain projects, this will contain each of the project ID it is allowed to access. If it is not defined, the configuration has full access.
   */
  projects?: Array<string> | undefined;
  /**
   * Source defines where the configuration was installed from. It is used to analyze user engagement for integration installations in product metrics.
   */
  source?: GetConfigurationResponseBodySource | undefined;
  /**
   * The slug of the integration the configuration is created for.
   */
  slug: string;
  /**
   * When the configuration was created for a team, this will show the ID of the team.
   */
  teamId?: string | null | undefined;
  type: GetConfigurationResponseBodyType;
  /**
   * A timestamp that tells you when the configuration was updated.
   */
  updatedAt: number;
  /**
   * The ID of the user that created the configuration.
   */
  userId: string;
  /**
   * The resources that are allowed to be accessed by the configuration.
   */
  scopes: Array<string>;
  /**
   * A timestamp that tells you when the configuration was disabled. Note: Configurations can be disabled when the associated user loses access to a team. They do not function during this time until the configuration is 'transferred', meaning the associated user is changed to one with access to the team.
   */
  disabledAt?: number | undefined;
  /**
   * A timestamp that tells you when the configuration was deleted.
   */
  deletedAt?: number | null | undefined;
  /**
   * A timestamp that tells you when the configuration deletion has been started for cases when the deletion needs to be settled/approved by partners, such as when marketplace invoices have been paid.
   */
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: GetConfigurationResponseBodyDisabledReason | undefined;
  /**
   * Defines the installation type. - 'external' integrations are installed via the existing integrations flow - 'marketplace' integrations are natively installed: - when accepting the TOS of a partner during the store creation process - if undefined, assume 'external'
   */
  installationType?: GetConfigurationResponseBodyInstallationType | undefined;
};

/**
 * The configuration with the provided id
 */
export type GetConfigurationResponseBody =
  | GetConfigurationResponseBody2
  | GetConfigurationResponseBody1;

/** @internal */
export const GetConfigurationRequest$inboundSchema: z.ZodType<
  GetConfigurationRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetConfigurationRequest$Outbound = {
  id: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetConfigurationRequest$outboundSchema: z.ZodType<
  GetConfigurationRequest$Outbound,
  z.ZodTypeDef,
  GetConfigurationRequest
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationRequest$ {
  /** @deprecated use `GetConfigurationRequest$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationRequest$inboundSchema;
  /** @deprecated use `GetConfigurationRequest$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationRequest$outboundSchema;
  /** @deprecated use `GetConfigurationRequest$Outbound` instead. */
  export type Outbound = GetConfigurationRequest$Outbound;
}

/** @internal */
export const ProjectSelection$inboundSchema: z.ZodNativeEnum<
  typeof ProjectSelection
> = z.nativeEnum(ProjectSelection);

/** @internal */
export const ProjectSelection$outboundSchema: z.ZodNativeEnum<
  typeof ProjectSelection
> = ProjectSelection$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProjectSelection$ {
  /** @deprecated use `ProjectSelection$inboundSchema` instead. */
  export const inboundSchema = ProjectSelection$inboundSchema;
  /** @deprecated use `ProjectSelection$outboundSchema` instead. */
  export const outboundSchema = ProjectSelection$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyIntegrationsSource$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyIntegrationsSource> = z
    .nativeEnum(GetConfigurationResponseBodyIntegrationsSource);

/** @internal */
export const GetConfigurationResponseBodyIntegrationsSource$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyIntegrationsSource> =
    GetConfigurationResponseBodyIntegrationsSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyIntegrationsSource$ {
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsSource$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyIntegrationsSource$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsSource$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyIntegrationsSource$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyIntegrationsType$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyIntegrationsType> = z
    .nativeEnum(GetConfigurationResponseBodyIntegrationsType);

/** @internal */
export const GetConfigurationResponseBodyIntegrationsType$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyIntegrationsType> =
    GetConfigurationResponseBodyIntegrationsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyIntegrationsType$ {
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyIntegrationsType$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyIntegrationsType$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyIntegrationsDisabledReason$inboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationResponseBodyIntegrationsDisabledReason
  > = z.nativeEnum(GetConfigurationResponseBodyIntegrationsDisabledReason);

/** @internal */
export const GetConfigurationResponseBodyIntegrationsDisabledReason$outboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationResponseBodyIntegrationsDisabledReason
  > = GetConfigurationResponseBodyIntegrationsDisabledReason$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyIntegrationsDisabledReason$ {
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsDisabledReason$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyIntegrationsDisabledReason$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsDisabledReason$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyIntegrationsDisabledReason$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyIntegrationsInstallationType$inboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationResponseBodyIntegrationsInstallationType
  > = z.nativeEnum(GetConfigurationResponseBodyIntegrationsInstallationType);

/** @internal */
export const GetConfigurationResponseBodyIntegrationsInstallationType$outboundSchema:
  z.ZodNativeEnum<
    typeof GetConfigurationResponseBodyIntegrationsInstallationType
  > = GetConfigurationResponseBodyIntegrationsInstallationType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyIntegrationsInstallationType$ {
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsInstallationType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyIntegrationsInstallationType$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsInstallationType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyIntegrationsInstallationType$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBody2$inboundSchema: z.ZodType<
  GetConfigurationResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectSelection: ProjectSelection$inboundSchema,
  projects: z.array(z.string()).optional(),
  completedAt: z.number().optional(),
  createdAt: z.number(),
  id: z.string(),
  integrationId: z.string(),
  ownerId: z.string(),
  source: GetConfigurationResponseBodyIntegrationsSource$inboundSchema
    .optional(),
  slug: z.string(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationResponseBodyIntegrationsType$inboundSchema,
  updatedAt: z.number(),
  userId: z.string(),
  scopes: z.array(z.string()),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason:
    GetConfigurationResponseBodyIntegrationsDisabledReason$inboundSchema
      .optional(),
  installationType:
    GetConfigurationResponseBodyIntegrationsInstallationType$inboundSchema
      .optional(),
  canConfigureOpenTelemetry: z.boolean().optional(),
});

/** @internal */
export type GetConfigurationResponseBody2$Outbound = {
  projectSelection: string;
  projects?: Array<string> | undefined;
  completedAt?: number | undefined;
  createdAt: number;
  id: string;
  integrationId: string;
  ownerId: string;
  source?: string | undefined;
  slug: string;
  teamId?: string | null | undefined;
  type: string;
  updatedAt: number;
  userId: string;
  scopes: Array<string>;
  disabledAt?: number | undefined;
  deletedAt?: number | null | undefined;
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: string | undefined;
  installationType?: string | undefined;
  canConfigureOpenTelemetry?: boolean | undefined;
};

/** @internal */
export const GetConfigurationResponseBody2$outboundSchema: z.ZodType<
  GetConfigurationResponseBody2$Outbound,
  z.ZodTypeDef,
  GetConfigurationResponseBody2
> = z.object({
  projectSelection: ProjectSelection$outboundSchema,
  projects: z.array(z.string()).optional(),
  completedAt: z.number().optional(),
  createdAt: z.number(),
  id: z.string(),
  integrationId: z.string(),
  ownerId: z.string(),
  source: GetConfigurationResponseBodyIntegrationsSource$outboundSchema
    .optional(),
  slug: z.string(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationResponseBodyIntegrationsType$outboundSchema,
  updatedAt: z.number(),
  userId: z.string(),
  scopes: z.array(z.string()),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason:
    GetConfigurationResponseBodyIntegrationsDisabledReason$outboundSchema
      .optional(),
  installationType:
    GetConfigurationResponseBodyIntegrationsInstallationType$outboundSchema
      .optional(),
  canConfigureOpenTelemetry: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBody2$ {
  /** @deprecated use `GetConfigurationResponseBody2$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBody2$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBody2$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationResponseBody2$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBody2$Outbound` instead. */
  export type Outbound = GetConfigurationResponseBody2$Outbound;
}

/** @internal */
export const GetConfigurationResponseBodyIntegrationsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyIntegrationsResponseType> =
    z.nativeEnum(GetConfigurationResponseBodyIntegrationsResponseType);

/** @internal */
export const GetConfigurationResponseBodyIntegrationsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyIntegrationsResponseType> =
    GetConfigurationResponseBodyIntegrationsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyIntegrationsResponseType$ {
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyIntegrationsResponseType$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyIntegrationsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyIntegrationsResponseType$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyScope$inboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationResponseBodyScope
> = z.nativeEnum(GetConfigurationResponseBodyScope);

/** @internal */
export const GetConfigurationResponseBodyScope$outboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationResponseBodyScope
> = GetConfigurationResponseBodyScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyScope$ {
  /** @deprecated use `GetConfigurationResponseBodyScope$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBodyScope$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyScope$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyScope$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyDetails$inboundSchema: z.ZodType<
  GetConfigurationResponseBodyDetails,
  z.ZodTypeDef,
  unknown
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type GetConfigurationResponseBodyDetails$Outbound = {
  label: string;
  value?: string | undefined;
};

/** @internal */
export const GetConfigurationResponseBodyDetails$outboundSchema: z.ZodType<
  GetConfigurationResponseBodyDetails$Outbound,
  z.ZodTypeDef,
  GetConfigurationResponseBodyDetails
> = z.object({
  label: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyDetails$ {
  /** @deprecated use `GetConfigurationResponseBodyDetails$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyDetails$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyDetails$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyDetails$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyDetails$Outbound` instead. */
  export type Outbound = GetConfigurationResponseBodyDetails$Outbound;
}

/** @internal */
export const GetConfigurationResponseBodyHeightlightedDetails$inboundSchema:
  z.ZodType<
    GetConfigurationResponseBodyHeightlightedDetails,
    z.ZodTypeDef,
    unknown
  > = z.object({
    label: z.string(),
    value: z.string().optional(),
  });

/** @internal */
export type GetConfigurationResponseBodyHeightlightedDetails$Outbound = {
  label: string;
  value?: string | undefined;
};

/** @internal */
export const GetConfigurationResponseBodyHeightlightedDetails$outboundSchema:
  z.ZodType<
    GetConfigurationResponseBodyHeightlightedDetails$Outbound,
    z.ZodTypeDef,
    GetConfigurationResponseBodyHeightlightedDetails
  > = z.object({
    label: z.string(),
    value: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyHeightlightedDetails$ {
  /** @deprecated use `GetConfigurationResponseBodyHeightlightedDetails$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyHeightlightedDetails$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyHeightlightedDetails$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyHeightlightedDetails$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyHeightlightedDetails$Outbound` instead. */
  export type Outbound =
    GetConfigurationResponseBodyHeightlightedDetails$Outbound;
}

/** @internal */
export const GetConfigurationResponseBodyQuote$inboundSchema: z.ZodType<
  GetConfigurationResponseBodyQuote,
  z.ZodTypeDef,
  unknown
> = z.object({
  line: z.string(),
  amount: z.string(),
});

/** @internal */
export type GetConfigurationResponseBodyQuote$Outbound = {
  line: string;
  amount: string;
};

/** @internal */
export const GetConfigurationResponseBodyQuote$outboundSchema: z.ZodType<
  GetConfigurationResponseBodyQuote$Outbound,
  z.ZodTypeDef,
  GetConfigurationResponseBodyQuote
> = z.object({
  line: z.string(),
  amount: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyQuote$ {
  /** @deprecated use `GetConfigurationResponseBodyQuote$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBodyQuote$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyQuote$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyQuote$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyQuote$Outbound` instead. */
  export type Outbound = GetConfigurationResponseBodyQuote$Outbound;
}

/** @internal */
export const GetConfigurationResponseBodyBillingPlan$inboundSchema: z.ZodType<
  GetConfigurationResponseBodyBillingPlan,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  type: GetConfigurationResponseBodyIntegrationsResponseType$inboundSchema,
  name: z.string(),
  scope: GetConfigurationResponseBodyScope$inboundSchema.optional(),
  description: z.string(),
  paymentMethodRequired: z.boolean().optional(),
  preauthorizationAmount: z.number().optional(),
  cost: z.string().optional(),
  details: z.array(
    z.lazy(() => GetConfigurationResponseBodyDetails$inboundSchema),
  ).optional(),
  heightlightedDetails: z.array(
    z.lazy(() =>
      GetConfigurationResponseBodyHeightlightedDetails$inboundSchema
    ),
  ).optional(),
  quote: z.array(z.lazy(() => GetConfigurationResponseBodyQuote$inboundSchema))
    .optional(),
  effectiveDate: z.string().optional(),
});

/** @internal */
export type GetConfigurationResponseBodyBillingPlan$Outbound = {
  id: string;
  type: string;
  name: string;
  scope?: string | undefined;
  description: string;
  paymentMethodRequired?: boolean | undefined;
  preauthorizationAmount?: number | undefined;
  cost?: string | undefined;
  details?: Array<GetConfigurationResponseBodyDetails$Outbound> | undefined;
  heightlightedDetails?:
    | Array<GetConfigurationResponseBodyHeightlightedDetails$Outbound>
    | undefined;
  quote?: Array<GetConfigurationResponseBodyQuote$Outbound> | undefined;
  effectiveDate?: string | undefined;
};

/** @internal */
export const GetConfigurationResponseBodyBillingPlan$outboundSchema: z.ZodType<
  GetConfigurationResponseBodyBillingPlan$Outbound,
  z.ZodTypeDef,
  GetConfigurationResponseBodyBillingPlan
> = z.object({
  id: z.string(),
  type: GetConfigurationResponseBodyIntegrationsResponseType$outboundSchema,
  name: z.string(),
  scope: GetConfigurationResponseBodyScope$outboundSchema.optional(),
  description: z.string(),
  paymentMethodRequired: z.boolean().optional(),
  preauthorizationAmount: z.number().optional(),
  cost: z.string().optional(),
  details: z.array(
    z.lazy(() => GetConfigurationResponseBodyDetails$outboundSchema),
  ).optional(),
  heightlightedDetails: z.array(
    z.lazy(() =>
      GetConfigurationResponseBodyHeightlightedDetails$outboundSchema
    ),
  ).optional(),
  quote: z.array(z.lazy(() => GetConfigurationResponseBodyQuote$outboundSchema))
    .optional(),
  effectiveDate: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyBillingPlan$ {
  /** @deprecated use `GetConfigurationResponseBodyBillingPlan$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyBillingPlan$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyBillingPlan$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyBillingPlan$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyBillingPlan$Outbound` instead. */
  export type Outbound = GetConfigurationResponseBodyBillingPlan$Outbound;
}

/** @internal */
export const GetConfigurationResponseBodySource$inboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationResponseBodySource
> = z.nativeEnum(GetConfigurationResponseBodySource);

/** @internal */
export const GetConfigurationResponseBodySource$outboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationResponseBodySource
> = GetConfigurationResponseBodySource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodySource$ {
  /** @deprecated use `GetConfigurationResponseBodySource$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBodySource$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodySource$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodySource$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyType$inboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationResponseBodyType
> = z.nativeEnum(GetConfigurationResponseBodyType);

/** @internal */
export const GetConfigurationResponseBodyType$outboundSchema: z.ZodNativeEnum<
  typeof GetConfigurationResponseBodyType
> = GetConfigurationResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyType$ {
  /** @deprecated use `GetConfigurationResponseBodyType$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBodyType$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyType$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationResponseBodyType$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyDisabledReason$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyDisabledReason> = z
    .nativeEnum(GetConfigurationResponseBodyDisabledReason);

/** @internal */
export const GetConfigurationResponseBodyDisabledReason$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyDisabledReason> =
    GetConfigurationResponseBodyDisabledReason$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyDisabledReason$ {
  /** @deprecated use `GetConfigurationResponseBodyDisabledReason$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyDisabledReason$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyDisabledReason$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyDisabledReason$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBodyInstallationType$inboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyInstallationType> = z
    .nativeEnum(GetConfigurationResponseBodyInstallationType);

/** @internal */
export const GetConfigurationResponseBodyInstallationType$outboundSchema:
  z.ZodNativeEnum<typeof GetConfigurationResponseBodyInstallationType> =
    GetConfigurationResponseBodyInstallationType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBodyInstallationType$ {
  /** @deprecated use `GetConfigurationResponseBodyInstallationType$inboundSchema` instead. */
  export const inboundSchema =
    GetConfigurationResponseBodyInstallationType$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBodyInstallationType$outboundSchema` instead. */
  export const outboundSchema =
    GetConfigurationResponseBodyInstallationType$outboundSchema;
}

/** @internal */
export const GetConfigurationResponseBody1$inboundSchema: z.ZodType<
  GetConfigurationResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  billingPlan: z.lazy(() =>
    GetConfigurationResponseBodyBillingPlan$inboundSchema
  ).optional(),
  billingTotal: z.string().optional(),
  periodStart: z.string().optional(),
  periodEnd: z.string().optional(),
  completedAt: z.number().optional(),
  createdAt: z.number(),
  id: z.string(),
  integrationId: z.string(),
  ownerId: z.string(),
  projects: z.array(z.string()).optional(),
  source: GetConfigurationResponseBodySource$inboundSchema.optional(),
  slug: z.string(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationResponseBodyType$inboundSchema,
  updatedAt: z.number(),
  userId: z.string(),
  scopes: z.array(z.string()),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason: GetConfigurationResponseBodyDisabledReason$inboundSchema
    .optional(),
  installationType: GetConfigurationResponseBodyInstallationType$inboundSchema
    .optional(),
});

/** @internal */
export type GetConfigurationResponseBody1$Outbound = {
  billingPlan?: GetConfigurationResponseBodyBillingPlan$Outbound | undefined;
  billingTotal?: string | undefined;
  periodStart?: string | undefined;
  periodEnd?: string | undefined;
  completedAt?: number | undefined;
  createdAt: number;
  id: string;
  integrationId: string;
  ownerId: string;
  projects?: Array<string> | undefined;
  source?: string | undefined;
  slug: string;
  teamId?: string | null | undefined;
  type: string;
  updatedAt: number;
  userId: string;
  scopes: Array<string>;
  disabledAt?: number | undefined;
  deletedAt?: number | null | undefined;
  deleteRequestedAt?: number | null | undefined;
  disabledReason?: string | undefined;
  installationType?: string | undefined;
};

/** @internal */
export const GetConfigurationResponseBody1$outboundSchema: z.ZodType<
  GetConfigurationResponseBody1$Outbound,
  z.ZodTypeDef,
  GetConfigurationResponseBody1
> = z.object({
  billingPlan: z.lazy(() =>
    GetConfigurationResponseBodyBillingPlan$outboundSchema
  ).optional(),
  billingTotal: z.string().optional(),
  periodStart: z.string().optional(),
  periodEnd: z.string().optional(),
  completedAt: z.number().optional(),
  createdAt: z.number(),
  id: z.string(),
  integrationId: z.string(),
  ownerId: z.string(),
  projects: z.array(z.string()).optional(),
  source: GetConfigurationResponseBodySource$outboundSchema.optional(),
  slug: z.string(),
  teamId: z.nullable(z.string()).optional(),
  type: GetConfigurationResponseBodyType$outboundSchema,
  updatedAt: z.number(),
  userId: z.string(),
  scopes: z.array(z.string()),
  disabledAt: z.number().optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deleteRequestedAt: z.nullable(z.number()).optional(),
  disabledReason: GetConfigurationResponseBodyDisabledReason$outboundSchema
    .optional(),
  installationType: GetConfigurationResponseBodyInstallationType$outboundSchema
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBody1$ {
  /** @deprecated use `GetConfigurationResponseBody1$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBody1$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBody1$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationResponseBody1$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBody1$Outbound` instead. */
  export type Outbound = GetConfigurationResponseBody1$Outbound;
}

/** @internal */
export const GetConfigurationResponseBody$inboundSchema: z.ZodType<
  GetConfigurationResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GetConfigurationResponseBody2$inboundSchema),
  z.lazy(() => GetConfigurationResponseBody1$inboundSchema),
]);

/** @internal */
export type GetConfigurationResponseBody$Outbound =
  | GetConfigurationResponseBody2$Outbound
  | GetConfigurationResponseBody1$Outbound;

/** @internal */
export const GetConfigurationResponseBody$outboundSchema: z.ZodType<
  GetConfigurationResponseBody$Outbound,
  z.ZodTypeDef,
  GetConfigurationResponseBody
> = z.union([
  z.lazy(() => GetConfigurationResponseBody2$outboundSchema),
  z.lazy(() => GetConfigurationResponseBody1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetConfigurationResponseBody$ {
  /** @deprecated use `GetConfigurationResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetConfigurationResponseBody$inboundSchema;
  /** @deprecated use `GetConfigurationResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetConfigurationResponseBody$outboundSchema;
  /** @deprecated use `GetConfigurationResponseBody$Outbound` instead. */
  export type Outbound = GetConfigurationResponseBody$Outbound;
}
