/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

export type GetAllChecksRequest = {
  /**
   * The deployment to get all checks for
   */
  deploymentId: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export const GetAllChecksConclusion = {
  Canceled: "canceled",
  Failed: "failed",
  Neutral: "neutral",
  Succeeded: "succeeded",
  Skipped: "skipped",
  Stale: "stale",
} as const;
export type GetAllChecksConclusion = ClosedEnum<typeof GetAllChecksConclusion>;

export const GetAllChecksSource = {
  WebVitals: "web-vitals",
} as const;
export type GetAllChecksSource = ClosedEnum<typeof GetAllChecksSource>;

export type GetAllChecksFCP = {
  value: number | null;
  previousValue?: number | undefined;
  source: GetAllChecksSource;
};

export const GetAllChecksChecksSource = {
  WebVitals: "web-vitals",
} as const;
export type GetAllChecksChecksSource = ClosedEnum<
  typeof GetAllChecksChecksSource
>;

export type GetAllChecksLCP = {
  value: number | null;
  previousValue?: number | undefined;
  source: GetAllChecksChecksSource;
};

export const GetAllChecksChecksResponseSource = {
  WebVitals: "web-vitals",
} as const;
export type GetAllChecksChecksResponseSource = ClosedEnum<
  typeof GetAllChecksChecksResponseSource
>;

export type GetAllChecksCLS = {
  value: number | null;
  previousValue?: number | undefined;
  source: GetAllChecksChecksResponseSource;
};

export const GetAllChecksChecksResponse200Source = {
  WebVitals: "web-vitals",
} as const;
export type GetAllChecksChecksResponse200Source = ClosedEnum<
  typeof GetAllChecksChecksResponse200Source
>;

export type GetAllChecksTBT = {
  value: number | null;
  previousValue?: number | undefined;
  source: GetAllChecksChecksResponse200Source;
};

export const GetAllChecksChecksResponse200ApplicationJSONSource = {
  WebVitals: "web-vitals",
} as const;
export type GetAllChecksChecksResponse200ApplicationJSONSource = ClosedEnum<
  typeof GetAllChecksChecksResponse200ApplicationJSONSource
>;

export type GetAllChecksVirtualExperienceScore = {
  value: number | null;
  previousValue?: number | undefined;
  source: GetAllChecksChecksResponse200ApplicationJSONSource;
};

export type GetAllChecksMetrics = {
  fcp: GetAllChecksFCP;
  lcp: GetAllChecksLCP;
  cls: GetAllChecksCLS;
  tbt: GetAllChecksTBT;
  virtualExperienceScore?: GetAllChecksVirtualExperienceScore | undefined;
};

export type GetAllChecksOutput = {
  metrics?: GetAllChecksMetrics | undefined;
};

export const GetAllChecksStatus = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type GetAllChecksStatus = ClosedEnum<typeof GetAllChecksStatus>;

export type Checks = {
  completedAt?: number | undefined;
  conclusion?: GetAllChecksConclusion | undefined;
  createdAt: number;
  detailsUrl?: string | undefined;
  id: string;
  integrationId: string;
  name: string;
  output?: GetAllChecksOutput | undefined;
  path?: string | undefined;
  rerequestable: boolean;
  startedAt?: number | undefined;
  status: GetAllChecksStatus;
  updatedAt: number;
};

export type GetAllChecksResponseBody = {
  checks: Array<Checks>;
};

/** @internal */
export const GetAllChecksRequest$inboundSchema: z.ZodType<
  GetAllChecksRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetAllChecksRequest$Outbound = {
  deploymentId: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetAllChecksRequest$outboundSchema: z.ZodType<
  GetAllChecksRequest$Outbound,
  z.ZodTypeDef,
  GetAllChecksRequest
> = z.object({
  deploymentId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksRequest$ {
  /** @deprecated use `GetAllChecksRequest$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksRequest$inboundSchema;
  /** @deprecated use `GetAllChecksRequest$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksRequest$outboundSchema;
  /** @deprecated use `GetAllChecksRequest$Outbound` instead. */
  export type Outbound = GetAllChecksRequest$Outbound;
}

/** @internal */
export const GetAllChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksConclusion
> = z.nativeEnum(GetAllChecksConclusion);

/** @internal */
export const GetAllChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksConclusion
> = GetAllChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksConclusion$ {
  /** @deprecated use `GetAllChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksConclusion$inboundSchema;
  /** @deprecated use `GetAllChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksConclusion$outboundSchema;
}

/** @internal */
export const GetAllChecksSource$inboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksSource
> = z.nativeEnum(GetAllChecksSource);

/** @internal */
export const GetAllChecksSource$outboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksSource
> = GetAllChecksSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksSource$ {
  /** @deprecated use `GetAllChecksSource$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksSource$inboundSchema;
  /** @deprecated use `GetAllChecksSource$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksSource$outboundSchema;
}

/** @internal */
export const GetAllChecksFCP$inboundSchema: z.ZodType<
  GetAllChecksFCP,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksSource$inboundSchema,
});

/** @internal */
export type GetAllChecksFCP$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const GetAllChecksFCP$outboundSchema: z.ZodType<
  GetAllChecksFCP$Outbound,
  z.ZodTypeDef,
  GetAllChecksFCP
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksFCP$ {
  /** @deprecated use `GetAllChecksFCP$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksFCP$inboundSchema;
  /** @deprecated use `GetAllChecksFCP$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksFCP$outboundSchema;
  /** @deprecated use `GetAllChecksFCP$Outbound` instead. */
  export type Outbound = GetAllChecksFCP$Outbound;
}

/** @internal */
export const GetAllChecksChecksSource$inboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksChecksSource
> = z.nativeEnum(GetAllChecksChecksSource);

/** @internal */
export const GetAllChecksChecksSource$outboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksChecksSource
> = GetAllChecksChecksSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksChecksSource$ {
  /** @deprecated use `GetAllChecksChecksSource$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksChecksSource$inboundSchema;
  /** @deprecated use `GetAllChecksChecksSource$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksChecksSource$outboundSchema;
}

/** @internal */
export const GetAllChecksLCP$inboundSchema: z.ZodType<
  GetAllChecksLCP,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksSource$inboundSchema,
});

/** @internal */
export type GetAllChecksLCP$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const GetAllChecksLCP$outboundSchema: z.ZodType<
  GetAllChecksLCP$Outbound,
  z.ZodTypeDef,
  GetAllChecksLCP
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksLCP$ {
  /** @deprecated use `GetAllChecksLCP$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksLCP$inboundSchema;
  /** @deprecated use `GetAllChecksLCP$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksLCP$outboundSchema;
  /** @deprecated use `GetAllChecksLCP$Outbound` instead. */
  export type Outbound = GetAllChecksLCP$Outbound;
}

/** @internal */
export const GetAllChecksChecksResponseSource$inboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksChecksResponseSource
> = z.nativeEnum(GetAllChecksChecksResponseSource);

/** @internal */
export const GetAllChecksChecksResponseSource$outboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksChecksResponseSource
> = GetAllChecksChecksResponseSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksChecksResponseSource$ {
  /** @deprecated use `GetAllChecksChecksResponseSource$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksChecksResponseSource$inboundSchema;
  /** @deprecated use `GetAllChecksChecksResponseSource$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksChecksResponseSource$outboundSchema;
}

/** @internal */
export const GetAllChecksCLS$inboundSchema: z.ZodType<
  GetAllChecksCLS,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksResponseSource$inboundSchema,
});

/** @internal */
export type GetAllChecksCLS$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const GetAllChecksCLS$outboundSchema: z.ZodType<
  GetAllChecksCLS$Outbound,
  z.ZodTypeDef,
  GetAllChecksCLS
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksResponseSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksCLS$ {
  /** @deprecated use `GetAllChecksCLS$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksCLS$inboundSchema;
  /** @deprecated use `GetAllChecksCLS$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksCLS$outboundSchema;
  /** @deprecated use `GetAllChecksCLS$Outbound` instead. */
  export type Outbound = GetAllChecksCLS$Outbound;
}

/** @internal */
export const GetAllChecksChecksResponse200Source$inboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksChecksResponse200Source
> = z.nativeEnum(GetAllChecksChecksResponse200Source);

/** @internal */
export const GetAllChecksChecksResponse200Source$outboundSchema:
  z.ZodNativeEnum<typeof GetAllChecksChecksResponse200Source> =
    GetAllChecksChecksResponse200Source$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksChecksResponse200Source$ {
  /** @deprecated use `GetAllChecksChecksResponse200Source$inboundSchema` instead. */
  export const inboundSchema =
    GetAllChecksChecksResponse200Source$inboundSchema;
  /** @deprecated use `GetAllChecksChecksResponse200Source$outboundSchema` instead. */
  export const outboundSchema =
    GetAllChecksChecksResponse200Source$outboundSchema;
}

/** @internal */
export const GetAllChecksTBT$inboundSchema: z.ZodType<
  GetAllChecksTBT,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksResponse200Source$inboundSchema,
});

/** @internal */
export type GetAllChecksTBT$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const GetAllChecksTBT$outboundSchema: z.ZodType<
  GetAllChecksTBT$Outbound,
  z.ZodTypeDef,
  GetAllChecksTBT
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksResponse200Source$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksTBT$ {
  /** @deprecated use `GetAllChecksTBT$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksTBT$inboundSchema;
  /** @deprecated use `GetAllChecksTBT$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksTBT$outboundSchema;
  /** @deprecated use `GetAllChecksTBT$Outbound` instead. */
  export type Outbound = GetAllChecksTBT$Outbound;
}

/** @internal */
export const GetAllChecksChecksResponse200ApplicationJSONSource$inboundSchema:
  z.ZodNativeEnum<typeof GetAllChecksChecksResponse200ApplicationJSONSource> = z
    .nativeEnum(GetAllChecksChecksResponse200ApplicationJSONSource);

/** @internal */
export const GetAllChecksChecksResponse200ApplicationJSONSource$outboundSchema:
  z.ZodNativeEnum<typeof GetAllChecksChecksResponse200ApplicationJSONSource> =
    GetAllChecksChecksResponse200ApplicationJSONSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksChecksResponse200ApplicationJSONSource$ {
  /** @deprecated use `GetAllChecksChecksResponse200ApplicationJSONSource$inboundSchema` instead. */
  export const inboundSchema =
    GetAllChecksChecksResponse200ApplicationJSONSource$inboundSchema;
  /** @deprecated use `GetAllChecksChecksResponse200ApplicationJSONSource$outboundSchema` instead. */
  export const outboundSchema =
    GetAllChecksChecksResponse200ApplicationJSONSource$outboundSchema;
}

/** @internal */
export const GetAllChecksVirtualExperienceScore$inboundSchema: z.ZodType<
  GetAllChecksVirtualExperienceScore,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksResponse200ApplicationJSONSource$inboundSchema,
});

/** @internal */
export type GetAllChecksVirtualExperienceScore$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const GetAllChecksVirtualExperienceScore$outboundSchema: z.ZodType<
  GetAllChecksVirtualExperienceScore$Outbound,
  z.ZodTypeDef,
  GetAllChecksVirtualExperienceScore
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: GetAllChecksChecksResponse200ApplicationJSONSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksVirtualExperienceScore$ {
  /** @deprecated use `GetAllChecksVirtualExperienceScore$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksVirtualExperienceScore$inboundSchema;
  /** @deprecated use `GetAllChecksVirtualExperienceScore$outboundSchema` instead. */
  export const outboundSchema =
    GetAllChecksVirtualExperienceScore$outboundSchema;
  /** @deprecated use `GetAllChecksVirtualExperienceScore$Outbound` instead. */
  export type Outbound = GetAllChecksVirtualExperienceScore$Outbound;
}

/** @internal */
export const GetAllChecksMetrics$inboundSchema: z.ZodType<
  GetAllChecksMetrics,
  z.ZodTypeDef,
  unknown
> = z.object({
  FCP: z.lazy(() => GetAllChecksFCP$inboundSchema),
  LCP: z.lazy(() => GetAllChecksLCP$inboundSchema),
  CLS: z.lazy(() => GetAllChecksCLS$inboundSchema),
  TBT: z.lazy(() => GetAllChecksTBT$inboundSchema),
  virtualExperienceScore: z.lazy(() =>
    GetAllChecksVirtualExperienceScore$inboundSchema
  ).optional(),
}).transform((v) => {
  return remap$(v, {
    "FCP": "fcp",
    "LCP": "lcp",
    "CLS": "cls",
    "TBT": "tbt",
  });
});

/** @internal */
export type GetAllChecksMetrics$Outbound = {
  FCP: GetAllChecksFCP$Outbound;
  LCP: GetAllChecksLCP$Outbound;
  CLS: GetAllChecksCLS$Outbound;
  TBT: GetAllChecksTBT$Outbound;
  virtualExperienceScore?:
    | GetAllChecksVirtualExperienceScore$Outbound
    | undefined;
};

/** @internal */
export const GetAllChecksMetrics$outboundSchema: z.ZodType<
  GetAllChecksMetrics$Outbound,
  z.ZodTypeDef,
  GetAllChecksMetrics
> = z.object({
  fcp: z.lazy(() => GetAllChecksFCP$outboundSchema),
  lcp: z.lazy(() => GetAllChecksLCP$outboundSchema),
  cls: z.lazy(() => GetAllChecksCLS$outboundSchema),
  tbt: z.lazy(() => GetAllChecksTBT$outboundSchema),
  virtualExperienceScore: z.lazy(() =>
    GetAllChecksVirtualExperienceScore$outboundSchema
  ).optional(),
}).transform((v) => {
  return remap$(v, {
    fcp: "FCP",
    lcp: "LCP",
    cls: "CLS",
    tbt: "TBT",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksMetrics$ {
  /** @deprecated use `GetAllChecksMetrics$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksMetrics$inboundSchema;
  /** @deprecated use `GetAllChecksMetrics$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksMetrics$outboundSchema;
  /** @deprecated use `GetAllChecksMetrics$Outbound` instead. */
  export type Outbound = GetAllChecksMetrics$Outbound;
}

/** @internal */
export const GetAllChecksOutput$inboundSchema: z.ZodType<
  GetAllChecksOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  metrics: z.lazy(() => GetAllChecksMetrics$inboundSchema).optional(),
});

/** @internal */
export type GetAllChecksOutput$Outbound = {
  metrics?: GetAllChecksMetrics$Outbound | undefined;
};

/** @internal */
export const GetAllChecksOutput$outboundSchema: z.ZodType<
  GetAllChecksOutput$Outbound,
  z.ZodTypeDef,
  GetAllChecksOutput
> = z.object({
  metrics: z.lazy(() => GetAllChecksMetrics$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksOutput$ {
  /** @deprecated use `GetAllChecksOutput$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksOutput$inboundSchema;
  /** @deprecated use `GetAllChecksOutput$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksOutput$outboundSchema;
  /** @deprecated use `GetAllChecksOutput$Outbound` instead. */
  export type Outbound = GetAllChecksOutput$Outbound;
}

/** @internal */
export const GetAllChecksStatus$inboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksStatus
> = z.nativeEnum(GetAllChecksStatus);

/** @internal */
export const GetAllChecksStatus$outboundSchema: z.ZodNativeEnum<
  typeof GetAllChecksStatus
> = GetAllChecksStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksStatus$ {
  /** @deprecated use `GetAllChecksStatus$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksStatus$inboundSchema;
  /** @deprecated use `GetAllChecksStatus$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksStatus$outboundSchema;
}

/** @internal */
export const Checks$inboundSchema: z.ZodType<Checks, z.ZodTypeDef, unknown> = z
  .object({
    completedAt: z.number().optional(),
    conclusion: GetAllChecksConclusion$inboundSchema.optional(),
    createdAt: z.number(),
    detailsUrl: z.string().optional(),
    id: z.string(),
    integrationId: z.string(),
    name: z.string(),
    output: z.lazy(() => GetAllChecksOutput$inboundSchema).optional(),
    path: z.string().optional(),
    rerequestable: z.boolean(),
    startedAt: z.number().optional(),
    status: GetAllChecksStatus$inboundSchema,
    updatedAt: z.number(),
  });

/** @internal */
export type Checks$Outbound = {
  completedAt?: number | undefined;
  conclusion?: string | undefined;
  createdAt: number;
  detailsUrl?: string | undefined;
  id: string;
  integrationId: string;
  name: string;
  output?: GetAllChecksOutput$Outbound | undefined;
  path?: string | undefined;
  rerequestable: boolean;
  startedAt?: number | undefined;
  status: string;
  updatedAt: number;
};

/** @internal */
export const Checks$outboundSchema: z.ZodType<
  Checks$Outbound,
  z.ZodTypeDef,
  Checks
> = z.object({
  completedAt: z.number().optional(),
  conclusion: GetAllChecksConclusion$outboundSchema.optional(),
  createdAt: z.number(),
  detailsUrl: z.string().optional(),
  id: z.string(),
  integrationId: z.string(),
  name: z.string(),
  output: z.lazy(() => GetAllChecksOutput$outboundSchema).optional(),
  path: z.string().optional(),
  rerequestable: z.boolean(),
  startedAt: z.number().optional(),
  status: GetAllChecksStatus$outboundSchema,
  updatedAt: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Checks$ {
  /** @deprecated use `Checks$inboundSchema` instead. */
  export const inboundSchema = Checks$inboundSchema;
  /** @deprecated use `Checks$outboundSchema` instead. */
  export const outboundSchema = Checks$outboundSchema;
  /** @deprecated use `Checks$Outbound` instead. */
  export type Outbound = Checks$Outbound;
}

/** @internal */
export const GetAllChecksResponseBody$inboundSchema: z.ZodType<
  GetAllChecksResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  checks: z.array(z.lazy(() => Checks$inboundSchema)),
});

/** @internal */
export type GetAllChecksResponseBody$Outbound = {
  checks: Array<Checks$Outbound>;
};

/** @internal */
export const GetAllChecksResponseBody$outboundSchema: z.ZodType<
  GetAllChecksResponseBody$Outbound,
  z.ZodTypeDef,
  GetAllChecksResponseBody
> = z.object({
  checks: z.array(z.lazy(() => Checks$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAllChecksResponseBody$ {
  /** @deprecated use `GetAllChecksResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetAllChecksResponseBody$inboundSchema;
  /** @deprecated use `GetAllChecksResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetAllChecksResponseBody$outboundSchema;
  /** @deprecated use `GetAllChecksResponseBody$Outbound` instead. */
  export type Outbound = GetAllChecksResponseBody$Outbound;
}
