/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type GetAliasRequest = {
  /**
   * Get the alias only if it was created after the provided timestamp
   */
  from?: number | undefined;
  /**
   * The alias or alias ID to be retrieved
   */
  idOrAlias: string;
  /**
   * Get the alias only if it is assigned to the provided project ID
   */
  projectId?: string | undefined;
  /**
   * Get the alias only if it was created after this JavaScript timestamp
   */
  since?: number | undefined;
  /**
   * Get the alias only if it was created before this JavaScript timestamp
   */
  until?: number | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * Information of the user who created the alias
 */
export type GetAliasCreator = {
  /**
   * ID of the user who created the alias
   */
  uid: string;
  /**
   * Email of the user who created the alias
   */
  email: string;
  /**
   * Username of the user who created the alias
   */
  username: string;
};

/**
 * A map with the deployment ID, URL and metadata
 */
export type Deployment = {
  /**
   * The deployment unique identifier
   */
  id: string;
  /**
   * The deployment unique URL
   */
  url: string;
  /**
   * The deployment metadata
   */
  meta?: string | undefined;
};

export const GetAliasProtectionBypassAliasesResponseScope = {
  EmailInvite: "email_invite",
} as const;
export type GetAliasProtectionBypassAliasesResponseScope = ClosedEnum<
  typeof GetAliasProtectionBypassAliasesResponseScope
>;

/**
 * The protection bypass for the alias
 */
export type ProtectionBypass4 = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  scope: GetAliasProtectionBypassAliasesResponseScope;
};

export const GetAliasProtectionBypassAliasesScope = {
  AliasProtectionOverride: "alias-protection-override",
} as const;
export type GetAliasProtectionBypassAliasesScope = ClosedEnum<
  typeof GetAliasProtectionBypassAliasesScope
>;

/**
 * The protection bypass for the alias
 */
export type ProtectionBypass3 = {
  createdAt: number;
  createdBy: string;
  scope: GetAliasProtectionBypassAliasesScope;
};

export const Access = {
  Requested: "requested",
  Granted: "granted",
} as const;
export type Access = ClosedEnum<typeof Access>;

export const GetAliasProtectionBypassScope = {
  User: "user",
} as const;
export type GetAliasProtectionBypassScope = ClosedEnum<
  typeof GetAliasProtectionBypassScope
>;

/**
 * The protection bypass for the alias
 */
export type ProtectionBypass2 = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  access: Access;
  scope: GetAliasProtectionBypassScope;
};

export const ProtectionBypassScope = {
  ShareableLink: "shareable-link",
} as const;
export type ProtectionBypassScope = ClosedEnum<typeof ProtectionBypassScope>;

/**
 * The protection bypass for the alias
 */
export type ProtectionBypass1 = {
  createdAt: number;
  createdBy: string;
  scope: ProtectionBypassScope;
};

export type GetAliasProtectionBypass =
  | ProtectionBypass1
  | ProtectionBypass3
  | ProtectionBypass4
  | ProtectionBypass2;

/**
 * The alias information
 */
export type GetAliasResponseBody = {
  /**
   * The alias name, it could be a `.vercel.app` subdomain or a custom domain
   */
  alias: string;
  /**
   * The date when the alias was created
   */
  created: Date;
  /**
   * The date when the alias was created in milliseconds since the UNIX epoch
   */
  createdAt?: number | null | undefined;
  /**
   * Information of the user who created the alias
   */
  creator?: GetAliasCreator | undefined;
  /**
   * The date when the alias was deleted in milliseconds since the UNIX epoch
   */
  deletedAt?: number | null | undefined;
  /**
   * A map with the deployment ID, URL and metadata
   */
  deployment?: Deployment | undefined;
  /**
   * The deployment ID
   */
  deploymentId: string | null;
  /**
   * The unique identifier of the project
   */
  projectId: string | null;
  /**
   * Target destination domain for redirect when the alias is a redirect
   */
  redirect?: string | null | undefined;
  /**
   * Status code to be used on redirect
   */
  redirectStatusCode?: number | null | undefined;
  /**
   * The unique identifier of the alias
   */
  uid: string;
  /**
   * The date when the alias was updated in milliseconds since the UNIX epoch
   */
  updatedAt?: number | null | undefined;
  /**
   * The protection bypass for the alias
   */
  protectionBypass?: {
    [k: string]:
      | ProtectionBypass1
      | ProtectionBypass3
      | ProtectionBypass4
      | ProtectionBypass2;
  } | undefined;
};

/** @internal */
export const GetAliasRequest$inboundSchema: z.ZodType<
  GetAliasRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  from: z.number().optional(),
  idOrAlias: z.string(),
  projectId: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type GetAliasRequest$Outbound = {
  from?: number | undefined;
  idOrAlias: string;
  projectId?: string | undefined;
  since?: number | undefined;
  until?: number | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const GetAliasRequest$outboundSchema: z.ZodType<
  GetAliasRequest$Outbound,
  z.ZodTypeDef,
  GetAliasRequest
> = z.object({
  from: z.number().optional(),
  idOrAlias: z.string(),
  projectId: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasRequest$ {
  /** @deprecated use `GetAliasRequest$inboundSchema` instead. */
  export const inboundSchema = GetAliasRequest$inboundSchema;
  /** @deprecated use `GetAliasRequest$outboundSchema` instead. */
  export const outboundSchema = GetAliasRequest$outboundSchema;
  /** @deprecated use `GetAliasRequest$Outbound` instead. */
  export type Outbound = GetAliasRequest$Outbound;
}

/** @internal */
export const GetAliasCreator$inboundSchema: z.ZodType<
  GetAliasCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  email: z.string(),
  username: z.string(),
});

/** @internal */
export type GetAliasCreator$Outbound = {
  uid: string;
  email: string;
  username: string;
};

/** @internal */
export const GetAliasCreator$outboundSchema: z.ZodType<
  GetAliasCreator$Outbound,
  z.ZodTypeDef,
  GetAliasCreator
> = z.object({
  uid: z.string(),
  email: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasCreator$ {
  /** @deprecated use `GetAliasCreator$inboundSchema` instead. */
  export const inboundSchema = GetAliasCreator$inboundSchema;
  /** @deprecated use `GetAliasCreator$outboundSchema` instead. */
  export const outboundSchema = GetAliasCreator$outboundSchema;
  /** @deprecated use `GetAliasCreator$Outbound` instead. */
  export type Outbound = GetAliasCreator$Outbound;
}

/** @internal */
export const Deployment$inboundSchema: z.ZodType<
  Deployment,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  url: z.string(),
  meta: z.string().optional(),
});

/** @internal */
export type Deployment$Outbound = {
  id: string;
  url: string;
  meta?: string | undefined;
};

/** @internal */
export const Deployment$outboundSchema: z.ZodType<
  Deployment$Outbound,
  z.ZodTypeDef,
  Deployment
> = z.object({
  id: z.string(),
  url: z.string(),
  meta: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Deployment$ {
  /** @deprecated use `Deployment$inboundSchema` instead. */
  export const inboundSchema = Deployment$inboundSchema;
  /** @deprecated use `Deployment$outboundSchema` instead. */
  export const outboundSchema = Deployment$outboundSchema;
  /** @deprecated use `Deployment$Outbound` instead. */
  export type Outbound = Deployment$Outbound;
}

/** @internal */
export const GetAliasProtectionBypassAliasesResponseScope$inboundSchema:
  z.ZodNativeEnum<typeof GetAliasProtectionBypassAliasesResponseScope> = z
    .nativeEnum(GetAliasProtectionBypassAliasesResponseScope);

/** @internal */
export const GetAliasProtectionBypassAliasesResponseScope$outboundSchema:
  z.ZodNativeEnum<typeof GetAliasProtectionBypassAliasesResponseScope> =
    GetAliasProtectionBypassAliasesResponseScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasProtectionBypassAliasesResponseScope$ {
  /** @deprecated use `GetAliasProtectionBypassAliasesResponseScope$inboundSchema` instead. */
  export const inboundSchema =
    GetAliasProtectionBypassAliasesResponseScope$inboundSchema;
  /** @deprecated use `GetAliasProtectionBypassAliasesResponseScope$outboundSchema` instead. */
  export const outboundSchema =
    GetAliasProtectionBypassAliasesResponseScope$outboundSchema;
}

/** @internal */
export const ProtectionBypass4$inboundSchema: z.ZodType<
  ProtectionBypass4,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  scope: GetAliasProtectionBypassAliasesResponseScope$inboundSchema,
});

/** @internal */
export type ProtectionBypass4$Outbound = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  scope: string;
};

/** @internal */
export const ProtectionBypass4$outboundSchema: z.ZodType<
  ProtectionBypass4$Outbound,
  z.ZodTypeDef,
  ProtectionBypass4
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  scope: GetAliasProtectionBypassAliasesResponseScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionBypass4$ {
  /** @deprecated use `ProtectionBypass4$inboundSchema` instead. */
  export const inboundSchema = ProtectionBypass4$inboundSchema;
  /** @deprecated use `ProtectionBypass4$outboundSchema` instead. */
  export const outboundSchema = ProtectionBypass4$outboundSchema;
  /** @deprecated use `ProtectionBypass4$Outbound` instead. */
  export type Outbound = ProtectionBypass4$Outbound;
}

/** @internal */
export const GetAliasProtectionBypassAliasesScope$inboundSchema:
  z.ZodNativeEnum<typeof GetAliasProtectionBypassAliasesScope> = z.nativeEnum(
    GetAliasProtectionBypassAliasesScope,
  );

/** @internal */
export const GetAliasProtectionBypassAliasesScope$outboundSchema:
  z.ZodNativeEnum<typeof GetAliasProtectionBypassAliasesScope> =
    GetAliasProtectionBypassAliasesScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasProtectionBypassAliasesScope$ {
  /** @deprecated use `GetAliasProtectionBypassAliasesScope$inboundSchema` instead. */
  export const inboundSchema =
    GetAliasProtectionBypassAliasesScope$inboundSchema;
  /** @deprecated use `GetAliasProtectionBypassAliasesScope$outboundSchema` instead. */
  export const outboundSchema =
    GetAliasProtectionBypassAliasesScope$outboundSchema;
}

/** @internal */
export const ProtectionBypass3$inboundSchema: z.ZodType<
  ProtectionBypass3,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: GetAliasProtectionBypassAliasesScope$inboundSchema,
});

/** @internal */
export type ProtectionBypass3$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const ProtectionBypass3$outboundSchema: z.ZodType<
  ProtectionBypass3$Outbound,
  z.ZodTypeDef,
  ProtectionBypass3
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: GetAliasProtectionBypassAliasesScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionBypass3$ {
  /** @deprecated use `ProtectionBypass3$inboundSchema` instead. */
  export const inboundSchema = ProtectionBypass3$inboundSchema;
  /** @deprecated use `ProtectionBypass3$outboundSchema` instead. */
  export const outboundSchema = ProtectionBypass3$outboundSchema;
  /** @deprecated use `ProtectionBypass3$Outbound` instead. */
  export type Outbound = ProtectionBypass3$Outbound;
}

/** @internal */
export const Access$inboundSchema: z.ZodNativeEnum<typeof Access> = z
  .nativeEnum(Access);

/** @internal */
export const Access$outboundSchema: z.ZodNativeEnum<typeof Access> =
  Access$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Access$ {
  /** @deprecated use `Access$inboundSchema` instead. */
  export const inboundSchema = Access$inboundSchema;
  /** @deprecated use `Access$outboundSchema` instead. */
  export const outboundSchema = Access$outboundSchema;
}

/** @internal */
export const GetAliasProtectionBypassScope$inboundSchema: z.ZodNativeEnum<
  typeof GetAliasProtectionBypassScope
> = z.nativeEnum(GetAliasProtectionBypassScope);

/** @internal */
export const GetAliasProtectionBypassScope$outboundSchema: z.ZodNativeEnum<
  typeof GetAliasProtectionBypassScope
> = GetAliasProtectionBypassScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasProtectionBypassScope$ {
  /** @deprecated use `GetAliasProtectionBypassScope$inboundSchema` instead. */
  export const inboundSchema = GetAliasProtectionBypassScope$inboundSchema;
  /** @deprecated use `GetAliasProtectionBypassScope$outboundSchema` instead. */
  export const outboundSchema = GetAliasProtectionBypassScope$outboundSchema;
}

/** @internal */
export const ProtectionBypass2$inboundSchema: z.ZodType<
  ProtectionBypass2,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  access: Access$inboundSchema,
  scope: GetAliasProtectionBypassScope$inboundSchema,
});

/** @internal */
export type ProtectionBypass2$Outbound = {
  createdAt: number;
  lastUpdatedAt: number;
  lastUpdatedBy: string;
  access: string;
  scope: string;
};

/** @internal */
export const ProtectionBypass2$outboundSchema: z.ZodType<
  ProtectionBypass2$Outbound,
  z.ZodTypeDef,
  ProtectionBypass2
> = z.object({
  createdAt: z.number(),
  lastUpdatedAt: z.number(),
  lastUpdatedBy: z.string(),
  access: Access$outboundSchema,
  scope: GetAliasProtectionBypassScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionBypass2$ {
  /** @deprecated use `ProtectionBypass2$inboundSchema` instead. */
  export const inboundSchema = ProtectionBypass2$inboundSchema;
  /** @deprecated use `ProtectionBypass2$outboundSchema` instead. */
  export const outboundSchema = ProtectionBypass2$outboundSchema;
  /** @deprecated use `ProtectionBypass2$Outbound` instead. */
  export type Outbound = ProtectionBypass2$Outbound;
}

/** @internal */
export const ProtectionBypassScope$inboundSchema: z.ZodNativeEnum<
  typeof ProtectionBypassScope
> = z.nativeEnum(ProtectionBypassScope);

/** @internal */
export const ProtectionBypassScope$outboundSchema: z.ZodNativeEnum<
  typeof ProtectionBypassScope
> = ProtectionBypassScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionBypassScope$ {
  /** @deprecated use `ProtectionBypassScope$inboundSchema` instead. */
  export const inboundSchema = ProtectionBypassScope$inboundSchema;
  /** @deprecated use `ProtectionBypassScope$outboundSchema` instead. */
  export const outboundSchema = ProtectionBypassScope$outboundSchema;
}

/** @internal */
export const ProtectionBypass1$inboundSchema: z.ZodType<
  ProtectionBypass1,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: ProtectionBypassScope$inboundSchema,
});

/** @internal */
export type ProtectionBypass1$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const ProtectionBypass1$outboundSchema: z.ZodType<
  ProtectionBypass1$Outbound,
  z.ZodTypeDef,
  ProtectionBypass1
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: ProtectionBypassScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProtectionBypass1$ {
  /** @deprecated use `ProtectionBypass1$inboundSchema` instead. */
  export const inboundSchema = ProtectionBypass1$inboundSchema;
  /** @deprecated use `ProtectionBypass1$outboundSchema` instead. */
  export const outboundSchema = ProtectionBypass1$outboundSchema;
  /** @deprecated use `ProtectionBypass1$Outbound` instead. */
  export type Outbound = ProtectionBypass1$Outbound;
}

/** @internal */
export const GetAliasProtectionBypass$inboundSchema: z.ZodType<
  GetAliasProtectionBypass,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => ProtectionBypass1$inboundSchema),
  z.lazy(() => ProtectionBypass3$inboundSchema),
  z.lazy(() => ProtectionBypass4$inboundSchema),
  z.lazy(() => ProtectionBypass2$inboundSchema),
]);

/** @internal */
export type GetAliasProtectionBypass$Outbound =
  | ProtectionBypass1$Outbound
  | ProtectionBypass3$Outbound
  | ProtectionBypass4$Outbound
  | ProtectionBypass2$Outbound;

/** @internal */
export const GetAliasProtectionBypass$outboundSchema: z.ZodType<
  GetAliasProtectionBypass$Outbound,
  z.ZodTypeDef,
  GetAliasProtectionBypass
> = z.union([
  z.lazy(() => ProtectionBypass1$outboundSchema),
  z.lazy(() => ProtectionBypass3$outboundSchema),
  z.lazy(() => ProtectionBypass4$outboundSchema),
  z.lazy(() => ProtectionBypass2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasProtectionBypass$ {
  /** @deprecated use `GetAliasProtectionBypass$inboundSchema` instead. */
  export const inboundSchema = GetAliasProtectionBypass$inboundSchema;
  /** @deprecated use `GetAliasProtectionBypass$outboundSchema` instead. */
  export const outboundSchema = GetAliasProtectionBypass$outboundSchema;
  /** @deprecated use `GetAliasProtectionBypass$Outbound` instead. */
  export type Outbound = GetAliasProtectionBypass$Outbound;
}

/** @internal */
export const GetAliasResponseBody$inboundSchema: z.ZodType<
  GetAliasResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  alias: z.string(),
  created: z.string().datetime({ offset: true }).transform(v => new Date(v)),
  createdAt: z.nullable(z.number()).optional(),
  creator: z.lazy(() => GetAliasCreator$inboundSchema).optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deployment: z.lazy(() => Deployment$inboundSchema).optional(),
  deploymentId: z.nullable(z.string()),
  projectId: z.nullable(z.string()),
  redirect: z.nullable(z.string()).optional(),
  redirectStatusCode: z.nullable(z.number()).optional(),
  uid: z.string(),
  updatedAt: z.nullable(z.number()).optional(),
  protectionBypass: z.record(
    z.union([
      z.lazy(() => ProtectionBypass1$inboundSchema),
      z.lazy(() => ProtectionBypass3$inboundSchema),
      z.lazy(() => ProtectionBypass4$inboundSchema),
      z.lazy(() => ProtectionBypass2$inboundSchema),
    ]),
  ).optional(),
});

/** @internal */
export type GetAliasResponseBody$Outbound = {
  alias: string;
  created: string;
  createdAt?: number | null | undefined;
  creator?: GetAliasCreator$Outbound | undefined;
  deletedAt?: number | null | undefined;
  deployment?: Deployment$Outbound | undefined;
  deploymentId: string | null;
  projectId: string | null;
  redirect?: string | null | undefined;
  redirectStatusCode?: number | null | undefined;
  uid: string;
  updatedAt?: number | null | undefined;
  protectionBypass?: {
    [k: string]:
      | ProtectionBypass1$Outbound
      | ProtectionBypass3$Outbound
      | ProtectionBypass4$Outbound
      | ProtectionBypass2$Outbound;
  } | undefined;
};

/** @internal */
export const GetAliasResponseBody$outboundSchema: z.ZodType<
  GetAliasResponseBody$Outbound,
  z.ZodTypeDef,
  GetAliasResponseBody
> = z.object({
  alias: z.string(),
  created: z.date().transform(v => v.toISOString()),
  createdAt: z.nullable(z.number()).optional(),
  creator: z.lazy(() => GetAliasCreator$outboundSchema).optional(),
  deletedAt: z.nullable(z.number()).optional(),
  deployment: z.lazy(() => Deployment$outboundSchema).optional(),
  deploymentId: z.nullable(z.string()),
  projectId: z.nullable(z.string()),
  redirect: z.nullable(z.string()).optional(),
  redirectStatusCode: z.nullable(z.number()).optional(),
  uid: z.string(),
  updatedAt: z.nullable(z.number()).optional(),
  protectionBypass: z.record(
    z.union([
      z.lazy(() => ProtectionBypass1$outboundSchema),
      z.lazy(() => ProtectionBypass3$outboundSchema),
      z.lazy(() => ProtectionBypass4$outboundSchema),
      z.lazy(() => ProtectionBypass2$outboundSchema),
    ]),
  ).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GetAliasResponseBody$ {
  /** @deprecated use `GetAliasResponseBody$inboundSchema` instead. */
  export const inboundSchema = GetAliasResponseBody$inboundSchema;
  /** @deprecated use `GetAliasResponseBody$outboundSchema` instead. */
  export const outboundSchema = GetAliasResponseBody$outboundSchema;
  /** @deprecated use `GetAliasResponseBody$Outbound` instead. */
  export type Outbound = GetAliasResponseBody$Outbound;
}
