/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

export const EditProjectEnvTarget = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type EditProjectEnvTarget = ClosedEnum<typeof EditProjectEnvTarget>;

/**
 * The type of environment variable
 */
export const EditProjectEnvType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
/**
 * The type of environment variable
 */
export type EditProjectEnvType = ClosedEnum<typeof EditProjectEnvType>;

export type EditProjectEnvRequestBody = {
  /**
   * The name of the environment variable
   */
  key?: string | undefined;
  /**
   * The target environment of the environment variable
   */
  target?: Array<EditProjectEnvTarget> | undefined;
  /**
   * If defined, the git branch of the environment variable (must have target=preview)
   */
  gitBranch?: string | null | undefined;
  /**
   * The type of environment variable
   */
  type?: EditProjectEnvType | undefined;
  /**
   * The value of the environment variable
   */
  value?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  /**
   * A comment to add context on what this env var is for
   */
  comment?: string | undefined;
};

export type EditProjectEnvRequest = {
  /**
   * The unique project identifier or the project name
   */
  idOrName: string;
  /**
   * The unique environment variable identifier
   */
  id: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: EditProjectEnvRequestBody | undefined;
};

export type EditProjectEnvResponseBody2 = {};

export const EditProjectEnvTarget2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type EditProjectEnvTarget2 = ClosedEnum<typeof EditProjectEnvTarget2>;

export type EditProjectEnvResponseBodyTarget =
  | Array<string>
  | EditProjectEnvTarget2;

export const EditProjectEnvResponseBodyType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
export type EditProjectEnvResponseBodyType = ClosedEnum<
  typeof EditProjectEnvResponseBodyType
>;

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type
  >;

export type EditProjectEnvContentHint15 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type;
  projectId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type
  >;

export type EditProjectEnvContentHint14 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type
  >;

export type EditProjectEnvContentHint13 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type
  >;

export type EditProjectEnvContentHint12 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type
  >;

export type EditProjectEnvContentHint11 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type
  >;

export type EditProjectEnvContentHint10 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type
  >;

export type EditProjectEnvContentHint9 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type
  >;

export type EditProjectEnvContentHint8 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type
  >;

export type EditProjectEnvContentHint7 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type EditProjectEnvContentHint6 = {
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONType = {
  BlobReadWriteToken: "blob-read-write-token",
} as const;
export type EditProjectEnvContentHintProjectsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONType
  >;

export type EditProjectEnvContentHint5 = {
  type: EditProjectEnvContentHintProjectsResponse200ApplicationJSONType;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponse200Type = {
  RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
} as const;
export type EditProjectEnvContentHintProjectsResponse200Type = ClosedEnum<
  typeof EditProjectEnvContentHintProjectsResponse200Type
>;

export type EditProjectEnvContentHint4 = {
  type: EditProjectEnvContentHintProjectsResponse200Type;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsResponseType = {
  RedisRestApiToken: "redis-rest-api-token",
} as const;
export type EditProjectEnvContentHintProjectsResponseType = ClosedEnum<
  typeof EditProjectEnvContentHintProjectsResponseType
>;

export type EditProjectEnvContentHint3 = {
  type: EditProjectEnvContentHintProjectsResponseType;
  storeId: string;
};

export const EditProjectEnvContentHintProjectsType = {
  RedisRestApiUrl: "redis-rest-api-url",
} as const;
export type EditProjectEnvContentHintProjectsType = ClosedEnum<
  typeof EditProjectEnvContentHintProjectsType
>;

export type EditProjectEnvContentHint2 = {
  type: EditProjectEnvContentHintProjectsType;
  storeId: string;
};

export const EditProjectEnvContentHintType = {
  RedisUrl: "redis-url",
} as const;
export type EditProjectEnvContentHintType = ClosedEnum<
  typeof EditProjectEnvContentHintType
>;

export type EditProjectEnvContentHint1 = {
  type: EditProjectEnvContentHintType;
  storeId: string;
};

export type EditProjectEnvResponseBodyContentHint =
  | EditProjectEnvContentHint1
  | EditProjectEnvContentHint2
  | EditProjectEnvContentHint3
  | EditProjectEnvContentHint4
  | EditProjectEnvContentHint5
  | EditProjectEnvContentHint6
  | EditProjectEnvContentHint7
  | EditProjectEnvContentHint8
  | EditProjectEnvContentHint9
  | EditProjectEnvContentHint10
  | EditProjectEnvContentHint11
  | EditProjectEnvContentHint12
  | EditProjectEnvContentHint13
  | EditProjectEnvContentHint15
  | EditProjectEnvContentHint14;

export const EditProjectEnvResponseBodyProjectsType = {
  FlagsSecret: "flags-secret",
} as const;
export type EditProjectEnvResponseBodyProjectsType = ClosedEnum<
  typeof EditProjectEnvResponseBodyProjectsType
>;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type EditProjectEnvResponseBodyInternalContentHint = {
  type: EditProjectEnvResponseBodyProjectsType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type EditProjectEnvResponseBody1 = {
  target?: Array<string> | EditProjectEnvTarget2 | undefined;
  type: EditProjectEnvResponseBodyType;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | EditProjectEnvContentHint1
    | EditProjectEnvContentHint2
    | EditProjectEnvContentHint3
    | EditProjectEnvContentHint4
    | EditProjectEnvContentHint5
    | EditProjectEnvContentHint6
    | EditProjectEnvContentHint7
    | EditProjectEnvContentHint8
    | EditProjectEnvContentHint9
    | EditProjectEnvContentHint10
    | EditProjectEnvContentHint11
    | EditProjectEnvContentHint12
    | EditProjectEnvContentHint13
    | EditProjectEnvContentHint15
    | EditProjectEnvContentHint14
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?:
    | EditProjectEnvResponseBodyInternalContentHint
    | null
    | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
};

/**
 * The environment variable was successfully edited
 */
export type EditProjectEnvResponseBody =
  | EditProjectEnvResponseBody2
  | EditProjectEnvResponseBody1;

/** @internal */
export const EditProjectEnvTarget$inboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvTarget
> = z.nativeEnum(EditProjectEnvTarget);

/** @internal */
export const EditProjectEnvTarget$outboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvTarget
> = EditProjectEnvTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvTarget$ {
  /** @deprecated use `EditProjectEnvTarget$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvTarget$inboundSchema;
  /** @deprecated use `EditProjectEnvTarget$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvTarget$outboundSchema;
}

/** @internal */
export const EditProjectEnvType$inboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvType
> = z.nativeEnum(EditProjectEnvType);

/** @internal */
export const EditProjectEnvType$outboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvType
> = EditProjectEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvType$ {
  /** @deprecated use `EditProjectEnvType$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvType$inboundSchema;
  /** @deprecated use `EditProjectEnvType$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvType$outboundSchema;
}

/** @internal */
export const EditProjectEnvRequestBody$inboundSchema: z.ZodType<
  EditProjectEnvRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  key: z.string().optional(),
  target: z.array(EditProjectEnvTarget$inboundSchema).optional(),
  gitBranch: z.nullable(z.string()).optional(),
  type: EditProjectEnvType$inboundSchema.optional(),
  value: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  comment: z.string().optional(),
});

/** @internal */
export type EditProjectEnvRequestBody$Outbound = {
  key?: string | undefined;
  target?: Array<string> | undefined;
  gitBranch?: string | null | undefined;
  type?: string | undefined;
  value?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  comment?: string | undefined;
};

/** @internal */
export const EditProjectEnvRequestBody$outboundSchema: z.ZodType<
  EditProjectEnvRequestBody$Outbound,
  z.ZodTypeDef,
  EditProjectEnvRequestBody
> = z.object({
  key: z.string().optional(),
  target: z.array(EditProjectEnvTarget$outboundSchema).optional(),
  gitBranch: z.nullable(z.string()).optional(),
  type: EditProjectEnvType$outboundSchema.optional(),
  value: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvRequestBody$ {
  /** @deprecated use `EditProjectEnvRequestBody$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvRequestBody$inboundSchema;
  /** @deprecated use `EditProjectEnvRequestBody$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvRequestBody$outboundSchema;
  /** @deprecated use `EditProjectEnvRequestBody$Outbound` instead. */
  export type Outbound = EditProjectEnvRequestBody$Outbound;
}

/** @internal */
export const EditProjectEnvRequest$inboundSchema: z.ZodType<
  EditProjectEnvRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrName: z.string(),
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => EditProjectEnvRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type EditProjectEnvRequest$Outbound = {
  idOrName: string;
  id: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: EditProjectEnvRequestBody$Outbound | undefined;
};

/** @internal */
export const EditProjectEnvRequest$outboundSchema: z.ZodType<
  EditProjectEnvRequest$Outbound,
  z.ZodTypeDef,
  EditProjectEnvRequest
> = z.object({
  idOrName: z.string(),
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => EditProjectEnvRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvRequest$ {
  /** @deprecated use `EditProjectEnvRequest$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvRequest$inboundSchema;
  /** @deprecated use `EditProjectEnvRequest$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvRequest$outboundSchema;
  /** @deprecated use `EditProjectEnvRequest$Outbound` instead. */
  export type Outbound = EditProjectEnvRequest$Outbound;
}

/** @internal */
export const EditProjectEnvResponseBody2$inboundSchema: z.ZodType<
  EditProjectEnvResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type EditProjectEnvResponseBody2$Outbound = {};

/** @internal */
export const EditProjectEnvResponseBody2$outboundSchema: z.ZodType<
  EditProjectEnvResponseBody2$Outbound,
  z.ZodTypeDef,
  EditProjectEnvResponseBody2
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBody2$ {
  /** @deprecated use `EditProjectEnvResponseBody2$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvResponseBody2$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBody2$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvResponseBody2$outboundSchema;
  /** @deprecated use `EditProjectEnvResponseBody2$Outbound` instead. */
  export type Outbound = EditProjectEnvResponseBody2$Outbound;
}

/** @internal */
export const EditProjectEnvTarget2$inboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvTarget2
> = z.nativeEnum(EditProjectEnvTarget2);

/** @internal */
export const EditProjectEnvTarget2$outboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvTarget2
> = EditProjectEnvTarget2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvTarget2$ {
  /** @deprecated use `EditProjectEnvTarget2$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvTarget2$inboundSchema;
  /** @deprecated use `EditProjectEnvTarget2$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvTarget2$outboundSchema;
}

/** @internal */
export const EditProjectEnvResponseBodyTarget$inboundSchema: z.ZodType<
  EditProjectEnvResponseBodyTarget,
  z.ZodTypeDef,
  unknown
> = z.union([z.array(z.string()), EditProjectEnvTarget2$inboundSchema]);

/** @internal */
export type EditProjectEnvResponseBodyTarget$Outbound = Array<string> | string;

/** @internal */
export const EditProjectEnvResponseBodyTarget$outboundSchema: z.ZodType<
  EditProjectEnvResponseBodyTarget$Outbound,
  z.ZodTypeDef,
  EditProjectEnvResponseBodyTarget
> = z.union([z.array(z.string()), EditProjectEnvTarget2$outboundSchema]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBodyTarget$ {
  /** @deprecated use `EditProjectEnvResponseBodyTarget$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvResponseBodyTarget$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyTarget$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvResponseBodyTarget$outboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyTarget$Outbound` instead. */
  export type Outbound = EditProjectEnvResponseBodyTarget$Outbound;
}

/** @internal */
export const EditProjectEnvResponseBodyType$inboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvResponseBodyType
> = z.nativeEnum(EditProjectEnvResponseBodyType);

/** @internal */
export const EditProjectEnvResponseBodyType$outboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvResponseBodyType
> = EditProjectEnvResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBodyType$ {
  /** @deprecated use `EditProjectEnvResponseBodyType$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvResponseBodyType$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyType$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvResponseBodyType$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint15$inboundSchema: z.ZodType<
  EditProjectEnvContentHint15,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$inboundSchema,
  projectId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint15$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const EditProjectEnvContentHint15$outboundSchema: z.ZodType<
  EditProjectEnvContentHint15$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint15
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody115Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint15$ {
  /** @deprecated use `EditProjectEnvContentHint15$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint15$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint15$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint15$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint15$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint15$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint14$inboundSchema: z.ZodType<
  EditProjectEnvContentHint14,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint14$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const EditProjectEnvContentHint14$outboundSchema: z.ZodType<
  EditProjectEnvContentHint14$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint14
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody114Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint14$ {
  /** @deprecated use `EditProjectEnvContentHint14$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint14$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint14$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint14$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint14$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint14$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint13$inboundSchema: z.ZodType<
  EditProjectEnvContentHint13,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint13$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint13$outboundSchema: z.ZodType<
  EditProjectEnvContentHint13$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint13
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody113Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint13$ {
  /** @deprecated use `EditProjectEnvContentHint13$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint13$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint13$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint13$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint13$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint13$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint12$inboundSchema: z.ZodType<
  EditProjectEnvContentHint12,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint12$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint12$outboundSchema: z.ZodType<
  EditProjectEnvContentHint12$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint12
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody112Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint12$ {
  /** @deprecated use `EditProjectEnvContentHint12$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint12$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint12$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint12$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint12$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint12$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint11$inboundSchema: z.ZodType<
  EditProjectEnvContentHint11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint11$outboundSchema: z.ZodType<
  EditProjectEnvContentHint11$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint11
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody111Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint11$ {
  /** @deprecated use `EditProjectEnvContentHint11$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint11$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint11$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint11$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint11$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint11$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint10$inboundSchema: z.ZodType<
  EditProjectEnvContentHint10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint10$outboundSchema: z.ZodType<
  EditProjectEnvContentHint10$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint10
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody110Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint10$ {
  /** @deprecated use `EditProjectEnvContentHint10$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint10$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint10$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint10$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint10$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint10$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint9$inboundSchema: z.ZodType<
  EditProjectEnvContentHint9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint9$outboundSchema: z.ZodType<
  EditProjectEnvContentHint9$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint9
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody19Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint9$ {
  /** @deprecated use `EditProjectEnvContentHint9$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint9$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint9$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint9$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint9$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint9$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint8$inboundSchema: z.ZodType<
  EditProjectEnvContentHint8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint8$outboundSchema: z.ZodType<
  EditProjectEnvContentHint8$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint8
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody18Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint8$ {
  /** @deprecated use `EditProjectEnvContentHint8$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint8$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint8$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint8$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint8$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint8$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint7$inboundSchema: z.ZodType<
  EditProjectEnvContentHint7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint7$outboundSchema: z.ZodType<
  EditProjectEnvContentHint7$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint7
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBody1Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint7$ {
  /** @deprecated use `EditProjectEnvContentHint7$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint7$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint7$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint7$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint7$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint7$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint6$inboundSchema: z.ZodType<
  EditProjectEnvContentHint6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint6$outboundSchema: z.ZodType<
  EditProjectEnvContentHint6$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint6
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint6$ {
  /** @deprecated use `EditProjectEnvContentHint6$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint6$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint6$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint6$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint6$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint6$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONType
  > = z.nativeEnum(
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONType,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof EditProjectEnvContentHintProjectsResponse200ApplicationJSONType
  > =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint5$inboundSchema: z.ZodType<
  EditProjectEnvContentHint5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint5$outboundSchema: z.ZodType<
  EditProjectEnvContentHint5$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint5
> = z.object({
  type:
    EditProjectEnvContentHintProjectsResponse200ApplicationJSONType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint5$ {
  /** @deprecated use `EditProjectEnvContentHint5$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint5$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint5$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint5$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint5$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint5$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvContentHintProjectsResponse200Type> = z
    .nativeEnum(EditProjectEnvContentHintProjectsResponse200Type);

/** @internal */
export const EditProjectEnvContentHintProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvContentHintProjectsResponse200Type> =
    EditProjectEnvContentHintProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponse200Type$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponse200Type$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint4$inboundSchema: z.ZodType<
  EditProjectEnvContentHint4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: EditProjectEnvContentHintProjectsResponse200Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint4$outboundSchema: z.ZodType<
  EditProjectEnvContentHint4$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint4
> = z.object({
  type: EditProjectEnvContentHintProjectsResponse200Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint4$ {
  /** @deprecated use `EditProjectEnvContentHint4$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint4$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint4$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint4$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint4$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint4$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvContentHintProjectsResponseType> = z
    .nativeEnum(EditProjectEnvContentHintProjectsResponseType);

/** @internal */
export const EditProjectEnvContentHintProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvContentHintProjectsResponseType> =
    EditProjectEnvContentHintProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsResponseType$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsResponseType$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsResponseType$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint3$inboundSchema: z.ZodType<
  EditProjectEnvContentHint3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: EditProjectEnvContentHintProjectsResponseType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint3$outboundSchema: z.ZodType<
  EditProjectEnvContentHint3$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint3
> = z.object({
  type: EditProjectEnvContentHintProjectsResponseType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint3$ {
  /** @deprecated use `EditProjectEnvContentHint3$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint3$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint3$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint3$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint3$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint3$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvContentHintProjectsType> = z.nativeEnum(
    EditProjectEnvContentHintProjectsType,
  );

/** @internal */
export const EditProjectEnvContentHintProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvContentHintProjectsType> =
    EditProjectEnvContentHintProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintProjectsType$ {
  /** @deprecated use `EditProjectEnvContentHintProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvContentHintProjectsType$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvContentHintProjectsType$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint2$inboundSchema: z.ZodType<
  EditProjectEnvContentHint2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: EditProjectEnvContentHintProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint2$outboundSchema: z.ZodType<
  EditProjectEnvContentHint2$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint2
> = z.object({
  type: EditProjectEnvContentHintProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint2$ {
  /** @deprecated use `EditProjectEnvContentHint2$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint2$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint2$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint2$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint2$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint2$Outbound;
}

/** @internal */
export const EditProjectEnvContentHintType$inboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvContentHintType
> = z.nativeEnum(EditProjectEnvContentHintType);

/** @internal */
export const EditProjectEnvContentHintType$outboundSchema: z.ZodNativeEnum<
  typeof EditProjectEnvContentHintType
> = EditProjectEnvContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHintType$ {
  /** @deprecated use `EditProjectEnvContentHintType$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHintType$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHintType$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHintType$outboundSchema;
}

/** @internal */
export const EditProjectEnvContentHint1$inboundSchema: z.ZodType<
  EditProjectEnvContentHint1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: EditProjectEnvContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type EditProjectEnvContentHint1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const EditProjectEnvContentHint1$outboundSchema: z.ZodType<
  EditProjectEnvContentHint1$Outbound,
  z.ZodTypeDef,
  EditProjectEnvContentHint1
> = z.object({
  type: EditProjectEnvContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvContentHint1$ {
  /** @deprecated use `EditProjectEnvContentHint1$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvContentHint1$inboundSchema;
  /** @deprecated use `EditProjectEnvContentHint1$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvContentHint1$outboundSchema;
  /** @deprecated use `EditProjectEnvContentHint1$Outbound` instead. */
  export type Outbound = EditProjectEnvContentHint1$Outbound;
}

/** @internal */
export const EditProjectEnvResponseBodyContentHint$inboundSchema: z.ZodType<
  EditProjectEnvResponseBodyContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => EditProjectEnvContentHint1$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint2$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint3$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint4$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint5$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint6$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint7$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint8$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint9$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint10$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint11$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint12$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint13$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint15$inboundSchema),
  z.lazy(() => EditProjectEnvContentHint14$inboundSchema),
]);

/** @internal */
export type EditProjectEnvResponseBodyContentHint$Outbound =
  | EditProjectEnvContentHint1$Outbound
  | EditProjectEnvContentHint2$Outbound
  | EditProjectEnvContentHint3$Outbound
  | EditProjectEnvContentHint4$Outbound
  | EditProjectEnvContentHint5$Outbound
  | EditProjectEnvContentHint6$Outbound
  | EditProjectEnvContentHint7$Outbound
  | EditProjectEnvContentHint8$Outbound
  | EditProjectEnvContentHint9$Outbound
  | EditProjectEnvContentHint10$Outbound
  | EditProjectEnvContentHint11$Outbound
  | EditProjectEnvContentHint12$Outbound
  | EditProjectEnvContentHint13$Outbound
  | EditProjectEnvContentHint15$Outbound
  | EditProjectEnvContentHint14$Outbound;

/** @internal */
export const EditProjectEnvResponseBodyContentHint$outboundSchema: z.ZodType<
  EditProjectEnvResponseBodyContentHint$Outbound,
  z.ZodTypeDef,
  EditProjectEnvResponseBodyContentHint
> = z.union([
  z.lazy(() => EditProjectEnvContentHint1$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint2$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint3$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint4$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint5$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint6$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint7$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint8$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint9$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint10$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint11$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint12$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint13$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint15$outboundSchema),
  z.lazy(() => EditProjectEnvContentHint14$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBodyContentHint$ {
  /** @deprecated use `EditProjectEnvResponseBodyContentHint$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvResponseBodyContentHint$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyContentHint$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvResponseBodyContentHint$outboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyContentHint$Outbound` instead. */
  export type Outbound = EditProjectEnvResponseBodyContentHint$Outbound;
}

/** @internal */
export const EditProjectEnvResponseBodyProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvResponseBodyProjectsType> = z.nativeEnum(
    EditProjectEnvResponseBodyProjectsType,
  );

/** @internal */
export const EditProjectEnvResponseBodyProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof EditProjectEnvResponseBodyProjectsType> =
    EditProjectEnvResponseBodyProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBodyProjectsType$ {
  /** @deprecated use `EditProjectEnvResponseBodyProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvResponseBodyProjectsType$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvResponseBodyProjectsType$outboundSchema;
}

/** @internal */
export const EditProjectEnvResponseBodyInternalContentHint$inboundSchema:
  z.ZodType<
    EditProjectEnvResponseBodyInternalContentHint,
    z.ZodTypeDef,
    unknown
  > = z.object({
    type: EditProjectEnvResponseBodyProjectsType$inboundSchema,
    encryptedValue: z.string(),
  });

/** @internal */
export type EditProjectEnvResponseBodyInternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const EditProjectEnvResponseBodyInternalContentHint$outboundSchema:
  z.ZodType<
    EditProjectEnvResponseBodyInternalContentHint$Outbound,
    z.ZodTypeDef,
    EditProjectEnvResponseBodyInternalContentHint
  > = z.object({
    type: EditProjectEnvResponseBodyProjectsType$outboundSchema,
    encryptedValue: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBodyInternalContentHint$ {
  /** @deprecated use `EditProjectEnvResponseBodyInternalContentHint$inboundSchema` instead. */
  export const inboundSchema =
    EditProjectEnvResponseBodyInternalContentHint$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyInternalContentHint$outboundSchema` instead. */
  export const outboundSchema =
    EditProjectEnvResponseBodyInternalContentHint$outboundSchema;
  /** @deprecated use `EditProjectEnvResponseBodyInternalContentHint$Outbound` instead. */
  export type Outbound = EditProjectEnvResponseBodyInternalContentHint$Outbound;
}

/** @internal */
export const EditProjectEnvResponseBody1$inboundSchema: z.ZodType<
  EditProjectEnvResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  target: z.union([z.array(z.string()), EditProjectEnvTarget2$inboundSchema])
    .optional(),
  type: EditProjectEnvResponseBodyType$inboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => EditProjectEnvContentHint1$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint2$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint3$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint4$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint5$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint6$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint7$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint8$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint9$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint10$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint11$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint12$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint13$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint15$inboundSchema),
      z.lazy(() => EditProjectEnvContentHint14$inboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => EditProjectEnvResponseBodyInternalContentHint$inboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
});

/** @internal */
export type EditProjectEnvResponseBody1$Outbound = {
  target?: Array<string> | string | undefined;
  type: string;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | EditProjectEnvContentHint1$Outbound
    | EditProjectEnvContentHint2$Outbound
    | EditProjectEnvContentHint3$Outbound
    | EditProjectEnvContentHint4$Outbound
    | EditProjectEnvContentHint5$Outbound
    | EditProjectEnvContentHint6$Outbound
    | EditProjectEnvContentHint7$Outbound
    | EditProjectEnvContentHint8$Outbound
    | EditProjectEnvContentHint9$Outbound
    | EditProjectEnvContentHint10$Outbound
    | EditProjectEnvContentHint11$Outbound
    | EditProjectEnvContentHint12$Outbound
    | EditProjectEnvContentHint13$Outbound
    | EditProjectEnvContentHint15$Outbound
    | EditProjectEnvContentHint14$Outbound
    | null
    | undefined;
  internalContentHint?:
    | EditProjectEnvResponseBodyInternalContentHint$Outbound
    | null
    | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
};

/** @internal */
export const EditProjectEnvResponseBody1$outboundSchema: z.ZodType<
  EditProjectEnvResponseBody1$Outbound,
  z.ZodTypeDef,
  EditProjectEnvResponseBody1
> = z.object({
  target: z.union([z.array(z.string()), EditProjectEnvTarget2$outboundSchema])
    .optional(),
  type: EditProjectEnvResponseBodyType$outboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => EditProjectEnvContentHint1$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint2$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint3$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint4$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint5$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint6$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint7$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint8$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint9$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint10$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint11$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint12$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint13$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint15$outboundSchema),
      z.lazy(() => EditProjectEnvContentHint14$outboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => EditProjectEnvResponseBodyInternalContentHint$outboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBody1$ {
  /** @deprecated use `EditProjectEnvResponseBody1$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvResponseBody1$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBody1$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvResponseBody1$outboundSchema;
  /** @deprecated use `EditProjectEnvResponseBody1$Outbound` instead. */
  export type Outbound = EditProjectEnvResponseBody1$Outbound;
}

/** @internal */
export const EditProjectEnvResponseBody$inboundSchema: z.ZodType<
  EditProjectEnvResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => EditProjectEnvResponseBody2$inboundSchema),
  z.lazy(() => EditProjectEnvResponseBody1$inboundSchema),
]);

/** @internal */
export type EditProjectEnvResponseBody$Outbound =
  | EditProjectEnvResponseBody2$Outbound
  | EditProjectEnvResponseBody1$Outbound;

/** @internal */
export const EditProjectEnvResponseBody$outboundSchema: z.ZodType<
  EditProjectEnvResponseBody$Outbound,
  z.ZodTypeDef,
  EditProjectEnvResponseBody
> = z.union([
  z.lazy(() => EditProjectEnvResponseBody2$outboundSchema),
  z.lazy(() => EditProjectEnvResponseBody1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EditProjectEnvResponseBody$ {
  /** @deprecated use `EditProjectEnvResponseBody$inboundSchema` instead. */
  export const inboundSchema = EditProjectEnvResponseBody$inboundSchema;
  /** @deprecated use `EditProjectEnvResponseBody$outboundSchema` instead. */
  export const outboundSchema = EditProjectEnvResponseBody$outboundSchema;
  /** @deprecated use `EditProjectEnvResponseBody$Outbound` instead. */
  export type Outbound = EditProjectEnvResponseBody$Outbound;
}
