/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export type DeleteDeploymentRequest = {
  /**
   * The ID of the deployment to be deleted
   */
  id: string;
  /**
   * A Deployment or Alias URL. In case it is passed, the ID will be ignored
   */
  url?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

/**
 * A constant with the final state of the deployment.
 */
export const State = {
  Deleted: "DELETED",
} as const;
/**
 * A constant with the final state of the deployment.
 */
export type State = ClosedEnum<typeof State>;

/**
 * The deployment was successfully deleted
 */
export type DeleteDeploymentResponseBody = {
  /**
   * The removed deployment ID.
   */
  uid: string;
  /**
   * A constant with the final state of the deployment.
   */
  state: State;
};

/** @internal */
export const DeleteDeploymentRequest$inboundSchema: z.ZodType<
  DeleteDeploymentRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  url: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type DeleteDeploymentRequest$Outbound = {
  id: string;
  url?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const DeleteDeploymentRequest$outboundSchema: z.ZodType<
  DeleteDeploymentRequest$Outbound,
  z.ZodTypeDef,
  DeleteDeploymentRequest
> = z.object({
  id: z.string(),
  url: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeleteDeploymentRequest$ {
  /** @deprecated use `DeleteDeploymentRequest$inboundSchema` instead. */
  export const inboundSchema = DeleteDeploymentRequest$inboundSchema;
  /** @deprecated use `DeleteDeploymentRequest$outboundSchema` instead. */
  export const outboundSchema = DeleteDeploymentRequest$outboundSchema;
  /** @deprecated use `DeleteDeploymentRequest$Outbound` instead. */
  export type Outbound = DeleteDeploymentRequest$Outbound;
}

/** @internal */
export const State$inboundSchema: z.ZodNativeEnum<typeof State> = z.nativeEnum(
  State,
);

/** @internal */
export const State$outboundSchema: z.ZodNativeEnum<typeof State> =
  State$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace State$ {
  /** @deprecated use `State$inboundSchema` instead. */
  export const inboundSchema = State$inboundSchema;
  /** @deprecated use `State$outboundSchema` instead. */
  export const outboundSchema = State$outboundSchema;
}

/** @internal */
export const DeleteDeploymentResponseBody$inboundSchema: z.ZodType<
  DeleteDeploymentResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  state: State$inboundSchema,
});

/** @internal */
export type DeleteDeploymentResponseBody$Outbound = {
  uid: string;
  state: string;
};

/** @internal */
export const DeleteDeploymentResponseBody$outboundSchema: z.ZodType<
  DeleteDeploymentResponseBody$Outbound,
  z.ZodTypeDef,
  DeleteDeploymentResponseBody
> = z.object({
  uid: z.string(),
  state: State$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DeleteDeploymentResponseBody$ {
  /** @deprecated use `DeleteDeploymentResponseBody$inboundSchema` instead. */
  export const inboundSchema = DeleteDeploymentResponseBody$inboundSchema;
  /** @deprecated use `DeleteDeploymentResponseBody$outboundSchema` instead. */
  export const outboundSchema = DeleteDeploymentResponseBody$outboundSchema;
  /** @deprecated use `DeleteDeploymentResponseBody$Outbound` instead. */
  export type Outbound = DeleteDeploymentResponseBody$Outbound;
}
