/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

export const Events = {
  BudgetReached: "budget.reached",
  BudgetReset: "budget.reset",
  DomainCreated: "domain.created",
  DeploymentCreated: "deployment.created",
  DeploymentError: "deployment.error",
  DeploymentCanceled: "deployment.canceled",
  DeploymentSucceeded: "deployment.succeeded",
  DeploymentReady: "deployment.ready",
  DeploymentCheckRerequested: "deployment.check-rerequested",
  DeploymentPromoted: "deployment.promoted",
  DeploymentIntegrationActionStart: "deployment.integration.action.start",
  DeploymentIntegrationActionCancel: "deployment.integration.action.cancel",
  DeploymentIntegrationActionCleanup: "deployment.integration.action.cleanup",
  EdgeConfigCreated: "edge-config.created",
  EdgeConfigDeleted: "edge-config.deleted",
  EdgeConfigItemsUpdated: "edge-config.items.updated",
  FirewallAttack: "firewall.attack",
  IntegrationConfigurationPermissionUpgraded:
    "integration-configuration.permission-upgraded",
  IntegrationConfigurationRemoved: "integration-configuration.removed",
  IntegrationConfigurationScopeChangeConfirmed:
    "integration-configuration.scope-change-confirmed",
  ProjectCreated: "project.created",
  ProjectRemoved: "project.removed",
  DeploymentChecksCompletedLegacy: "deployment-checks-completed",
  DeploymentReadyLegacy: "deployment-ready",
  DeploymentPreparedLegacy: "deployment-prepared",
  DeploymentErrorLegacy: "deployment-error",
  DeploymentCheckRerequestedLegacy: "deployment-check-rerequested",
  DeploymentCanceledLegacy: "deployment-canceled",
  ProjectCreatedLegacy: "project-created",
  ProjectRemovedLegacy: "project-removed",
  DomainCreatedLegacy: "domain-created",
  DeploymentLegacy: "deployment",
  IntegrationConfigurationPermissionUpdatedLegacy:
    "integration-configuration-permission-updated",
  IntegrationConfigurationRemovedLegacy: "integration-configuration-removed",
  IntegrationConfigurationScopeChangeConfirmedLegacy:
    "integration-configuration-scope-change-confirmed",
  MarketplaceInvoiceCreated: "marketplace.invoice.created",
  MarketplaceInvoicePaid: "marketplace.invoice.paid",
  MarketplaceInvoiceNotpaid: "marketplace.invoice.notpaid",
  MarketplaceInvoiceRefunded: "marketplace.invoice.refunded",
  TestWebhook: "observability.anomaly",
  undefined: "test-webhook",
} as const;
export type Events = ClosedEnum<typeof Events>;

export type CreateWebhookRequestBody = {
  url: string;
  events: Array<Events>;
  projectIds?: Array<string> | undefined;
};

export type CreateWebhookRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: CreateWebhookRequestBody | undefined;
};

/**
 * The webhooks events
 */
export const CreateWebhookEvents = {
  BudgetReached: "budget.reached",
  BudgetReset: "budget.reset",
  DomainCreated: "domain.created",
  DeploymentCreated: "deployment.created",
  DeploymentError: "deployment.error",
  DeploymentCanceled: "deployment.canceled",
  DeploymentSucceeded: "deployment.succeeded",
  DeploymentReady: "deployment.ready",
  DeploymentCheckRerequested: "deployment.check-rerequested",
  DeploymentPromoted: "deployment.promoted",
  DeploymentIntegrationActionStart: "deployment.integration.action.start",
  DeploymentIntegrationActionCancel: "deployment.integration.action.cancel",
  DeploymentIntegrationActionCleanup: "deployment.integration.action.cleanup",
  EdgeConfigCreated: "edge-config.created",
  EdgeConfigDeleted: "edge-config.deleted",
  EdgeConfigItemsUpdated: "edge-config.items.updated",
  FirewallAttack: "firewall.attack",
  IntegrationConfigurationPermissionUpgraded:
    "integration-configuration.permission-upgraded",
  IntegrationConfigurationRemoved: "integration-configuration.removed",
  IntegrationConfigurationScopeChangeConfirmed:
    "integration-configuration.scope-change-confirmed",
  ProjectCreated: "project.created",
  ProjectRemoved: "project.removed",
  DeploymentChecksCompletedLegacy: "deployment-checks-completed",
  DeploymentReadyLegacy: "deployment-ready",
  DeploymentPreparedLegacy: "deployment-prepared",
  DeploymentErrorLegacy: "deployment-error",
  DeploymentCheckRerequestedLegacy: "deployment-check-rerequested",
  DeploymentCanceledLegacy: "deployment-canceled",
  ProjectCreatedLegacy: "project-created",
  ProjectRemovedLegacy: "project-removed",
  DomainCreatedLegacy: "domain-created",
  DeploymentLegacy: "deployment",
  IntegrationConfigurationPermissionUpdatedLegacy:
    "integration-configuration-permission-updated",
  IntegrationConfigurationRemovedLegacy: "integration-configuration-removed",
  IntegrationConfigurationScopeChangeConfirmedLegacy:
    "integration-configuration-scope-change-confirmed",
  MarketplaceInvoiceCreated: "marketplace.invoice.created",
  MarketplaceInvoicePaid: "marketplace.invoice.paid",
  MarketplaceInvoiceNotpaid: "marketplace.invoice.notpaid",
  MarketplaceInvoiceRefunded: "marketplace.invoice.refunded",
  TestWebhook: "observability.anomaly",
  undefined: "test-webhook",
} as const;
/**
 * The webhooks events
 */
export type CreateWebhookEvents = ClosedEnum<typeof CreateWebhookEvents>;

export type CreateWebhookResponseBody = {
  /**
   * The webhook secret used to sign the payload
   */
  secret: string;
  /**
   * The webhooks events
   */
  events: Array<CreateWebhookEvents>;
  /**
   * The webhook id
   */
  id: string;
  /**
   * A string with the URL of the webhook
   */
  url: string;
  /**
   * The unique ID of the team the webhook belongs to
   */
  ownerId: string;
  /**
   * A number containing the date when the webhook was created in in milliseconds
   */
  createdAt: number;
  /**
   * A number containing the date when the webhook was updated in in milliseconds
   */
  updatedAt: number;
  /**
   * The ID of the projects the webhook is associated with
   */
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const Events$inboundSchema: z.ZodNativeEnum<typeof Events> = z
  .nativeEnum(Events);

/** @internal */
export const Events$outboundSchema: z.ZodNativeEnum<typeof Events> =
  Events$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Events$ {
  /** @deprecated use `Events$inboundSchema` instead. */
  export const inboundSchema = Events$inboundSchema;
  /** @deprecated use `Events$outboundSchema` instead. */
  export const outboundSchema = Events$outboundSchema;
}

/** @internal */
export const CreateWebhookRequestBody$inboundSchema: z.ZodType<
  CreateWebhookRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  url: z.string(),
  events: z.array(Events$inboundSchema),
  projectIds: z.array(z.string()).optional(),
});

/** @internal */
export type CreateWebhookRequestBody$Outbound = {
  url: string;
  events: Array<string>;
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const CreateWebhookRequestBody$outboundSchema: z.ZodType<
  CreateWebhookRequestBody$Outbound,
  z.ZodTypeDef,
  CreateWebhookRequestBody
> = z.object({
  url: z.string(),
  events: z.array(Events$outboundSchema),
  projectIds: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateWebhookRequestBody$ {
  /** @deprecated use `CreateWebhookRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateWebhookRequestBody$inboundSchema;
  /** @deprecated use `CreateWebhookRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateWebhookRequestBody$outboundSchema;
  /** @deprecated use `CreateWebhookRequestBody$Outbound` instead. */
  export type Outbound = CreateWebhookRequestBody$Outbound;
}

/** @internal */
export const CreateWebhookRequest$inboundSchema: z.ZodType<
  CreateWebhookRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => CreateWebhookRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateWebhookRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: CreateWebhookRequestBody$Outbound | undefined;
};

/** @internal */
export const CreateWebhookRequest$outboundSchema: z.ZodType<
  CreateWebhookRequest$Outbound,
  z.ZodTypeDef,
  CreateWebhookRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => CreateWebhookRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateWebhookRequest$ {
  /** @deprecated use `CreateWebhookRequest$inboundSchema` instead. */
  export const inboundSchema = CreateWebhookRequest$inboundSchema;
  /** @deprecated use `CreateWebhookRequest$outboundSchema` instead. */
  export const outboundSchema = CreateWebhookRequest$outboundSchema;
  /** @deprecated use `CreateWebhookRequest$Outbound` instead. */
  export type Outbound = CreateWebhookRequest$Outbound;
}

/** @internal */
export const CreateWebhookEvents$inboundSchema: z.ZodNativeEnum<
  typeof CreateWebhookEvents
> = z.nativeEnum(CreateWebhookEvents);

/** @internal */
export const CreateWebhookEvents$outboundSchema: z.ZodNativeEnum<
  typeof CreateWebhookEvents
> = CreateWebhookEvents$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateWebhookEvents$ {
  /** @deprecated use `CreateWebhookEvents$inboundSchema` instead. */
  export const inboundSchema = CreateWebhookEvents$inboundSchema;
  /** @deprecated use `CreateWebhookEvents$outboundSchema` instead. */
  export const outboundSchema = CreateWebhookEvents$outboundSchema;
}

/** @internal */
export const CreateWebhookResponseBody$inboundSchema: z.ZodType<
  CreateWebhookResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  secret: z.string(),
  events: z.array(CreateWebhookEvents$inboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/** @internal */
export type CreateWebhookResponseBody$Outbound = {
  secret: string;
  events: Array<string>;
  id: string;
  url: string;
  ownerId: string;
  createdAt: number;
  updatedAt: number;
  projectIds?: Array<string> | undefined;
};

/** @internal */
export const CreateWebhookResponseBody$outboundSchema: z.ZodType<
  CreateWebhookResponseBody$Outbound,
  z.ZodTypeDef,
  CreateWebhookResponseBody
> = z.object({
  secret: z.string(),
  events: z.array(CreateWebhookEvents$outboundSchema),
  id: z.string(),
  url: z.string(),
  ownerId: z.string(),
  createdAt: z.number(),
  updatedAt: z.number(),
  projectIds: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateWebhookResponseBody$ {
  /** @deprecated use `CreateWebhookResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateWebhookResponseBody$inboundSchema;
  /** @deprecated use `CreateWebhookResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateWebhookResponseBody$outboundSchema;
  /** @deprecated use `CreateWebhookResponseBody$Outbound` instead. */
  export type Outbound = CreateWebhookResponseBody$Outbound;
}
