/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequest10Type = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequest10Type = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequest10Type
>;

export type RequestBodyHttps = {
  priority: number | null;
  target: string;
  params?: string | undefined;
};

export type Ten = {
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequest10Type;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  https: RequestBodyHttps;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequest9Type = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequest9Type = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequest9Type
>;

export type Nine = {
  /**
   * A subdomain name.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequest9Type;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * An NS domain value.
   */
  value?: string | undefined;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequest8Type = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequest8Type = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequest8Type
>;

export type Eight = {
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequest8Type;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * A TXT record containing arbitrary text.
   */
  value: string;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequest7Type = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequest7Type = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequest7Type
>;

export type RequestBodySrv = {
  priority: number | null;
  weight: number | null;
  port: number | null;
  target: string;
};

export type Seven = {
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequest7Type;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  srv: RequestBodySrv;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequest6Type = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequest6Type = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequest6Type
>;

export type Six = {
  /**
   * A subdomain name or an empty string for the root domain.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequest6Type;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * An MX record specifying the mail server responsible for accepting messages on behalf of the domain name.
   */
  value: string;
  mxPriority: number;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequest5Type = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequest5Type = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequest5Type
>;

export type RequestBody5 = {
  /**
   * A subdomain name or an empty string for the root domain.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequest5Type;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * A CNAME record mapping to another domain name.
   */
  value?: string | undefined;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsRequestType = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsRequestType = ClosedEnum<
  typeof CreateRecordRequestBodyDnsRequestType
>;

export type RequestBody4 = {
  /**
   * A subdomain name or an empty string for the root domain.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsRequestType;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * A CAA record to specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
   */
  value: string;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyDnsType = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyDnsType = ClosedEnum<
  typeof CreateRecordRequestBodyDnsType
>;

export type RequestBody3 = {
  /**
   * A subdomain name or an empty string for the root domain.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyDnsType;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * An ALIAS virtual record pointing to a hostname resolved to an A record on server side.
   */
  value: string;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const CreateRecordRequestBodyType = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type CreateRecordRequestBodyType = ClosedEnum<
  typeof CreateRecordRequestBodyType
>;

export type RequestBody2 = {
  /**
   * A subdomain name or an empty string for the root domain.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: CreateRecordRequestBodyType;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * An AAAA record pointing to an IPv6 address.
   */
  value: string;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

/**
 * The type of record, it could be one of the valid DNS records.
 */
export const RequestBodyType = {
  A: "A",
  Aaaa: "AAAA",
  Alias: "ALIAS",
  Caa: "CAA",
  Cname: "CNAME",
  Https: "HTTPS",
  Mx: "MX",
  Srv: "SRV",
  Txt: "TXT",
  Ns: "NS",
} as const;
/**
 * The type of record, it could be one of the valid DNS records.
 */
export type RequestBodyType = ClosedEnum<typeof RequestBodyType>;

export type RequestBody1 = {
  /**
   * A subdomain name or an empty string for the root domain.
   */
  name: string;
  /**
   * The type of record, it could be one of the valid DNS records.
   */
  type: RequestBodyType;
  /**
   * The TTL value. Must be a number between 60 and 2147483647. Default value is 60.
   */
  ttl?: number | undefined;
  /**
   * The record value must be a valid IPv4 address.
   */
  value: string;
  /**
   * A comment to add context on what this DNS record is for
   */
  comment?: string | undefined;
};

export type CreateRecordRequestBody =
  | Seven
  | Eight
  | Ten
  | RequestBody1
  | RequestBody2
  | RequestBody3
  | RequestBody4
  | RequestBody5
  | Nine
  | Six;

export type CreateRecordRequest = {
  /**
   * The domain used to create the DNS record.
   */
  domain: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?:
    | Seven
    | Eight
    | Ten
    | RequestBody1
    | RequestBody2
    | RequestBody3
    | RequestBody4
    | RequestBody5
    | Nine
    | Six
    | undefined;
};

export type CreateRecordResponseBody2 = {
  /**
   * The id of the newly created DNS record
   */
  uid: string;
};

export type CreateRecordResponseBody1 = {
  uid: string;
  updated: number;
};

/**
 * Successful response showing the uid of the newly created DNS record.
 */
export type CreateRecordResponseBody =
  | CreateRecordResponseBody2
  | CreateRecordResponseBody1;

/** @internal */
export const CreateRecordRequestBodyDnsRequest10Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest10Type> = z
    .nativeEnum(CreateRecordRequestBodyDnsRequest10Type);

/** @internal */
export const CreateRecordRequestBodyDnsRequest10Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest10Type> =
    CreateRecordRequestBodyDnsRequest10Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequest10Type$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequest10Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequest10Type$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequest10Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequest10Type$outboundSchema;
}

/** @internal */
export const RequestBodyHttps$inboundSchema: z.ZodType<
  RequestBodyHttps,
  z.ZodTypeDef,
  unknown
> = z.object({
  priority: z.nullable(z.number()),
  target: z.string(),
  params: z.string().optional(),
});

/** @internal */
export type RequestBodyHttps$Outbound = {
  priority: number | null;
  target: string;
  params?: string | undefined;
};

/** @internal */
export const RequestBodyHttps$outboundSchema: z.ZodType<
  RequestBodyHttps$Outbound,
  z.ZodTypeDef,
  RequestBodyHttps
> = z.object({
  priority: z.nullable(z.number()),
  target: z.string(),
  params: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyHttps$ {
  /** @deprecated use `RequestBodyHttps$inboundSchema` instead. */
  export const inboundSchema = RequestBodyHttps$inboundSchema;
  /** @deprecated use `RequestBodyHttps$outboundSchema` instead. */
  export const outboundSchema = RequestBodyHttps$outboundSchema;
  /** @deprecated use `RequestBodyHttps$Outbound` instead. */
  export type Outbound = RequestBodyHttps$Outbound;
}

/** @internal */
export const Ten$inboundSchema: z.ZodType<Ten, z.ZodTypeDef, unknown> = z
  .object({
    type: CreateRecordRequestBodyDnsRequest10Type$inboundSchema,
    ttl: z.number().optional(),
    https: z.lazy(() => RequestBodyHttps$inboundSchema),
    comment: z.string().optional(),
  });

/** @internal */
export type Ten$Outbound = {
  type: string;
  ttl?: number | undefined;
  https: RequestBodyHttps$Outbound;
  comment?: string | undefined;
};

/** @internal */
export const Ten$outboundSchema: z.ZodType<Ten$Outbound, z.ZodTypeDef, Ten> = z
  .object({
    type: CreateRecordRequestBodyDnsRequest10Type$outboundSchema,
    ttl: z.number().optional(),
    https: z.lazy(() => RequestBodyHttps$outboundSchema),
    comment: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Ten$ {
  /** @deprecated use `Ten$inboundSchema` instead. */
  export const inboundSchema = Ten$inboundSchema;
  /** @deprecated use `Ten$outboundSchema` instead. */
  export const outboundSchema = Ten$outboundSchema;
  /** @deprecated use `Ten$Outbound` instead. */
  export type Outbound = Ten$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsRequest9Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest9Type> = z.nativeEnum(
    CreateRecordRequestBodyDnsRequest9Type,
  );

/** @internal */
export const CreateRecordRequestBodyDnsRequest9Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest9Type> =
    CreateRecordRequestBodyDnsRequest9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequest9Type$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequest9Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequest9Type$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequest9Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequest9Type$outboundSchema;
}

/** @internal */
export const Nine$inboundSchema: z.ZodType<Nine, z.ZodTypeDef, unknown> = z
  .object({
    name: z.string(),
    type: CreateRecordRequestBodyDnsRequest9Type$inboundSchema,
    ttl: z.number().optional(),
    value: z.string().optional(),
    comment: z.string().optional(),
  });

/** @internal */
export type Nine$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value?: string | undefined;
  comment?: string | undefined;
};

/** @internal */
export const Nine$outboundSchema: z.ZodType<Nine$Outbound, z.ZodTypeDef, Nine> =
  z.object({
    name: z.string(),
    type: CreateRecordRequestBodyDnsRequest9Type$outboundSchema,
    ttl: z.number().optional(),
    value: z.string().optional(),
    comment: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Nine$ {
  /** @deprecated use `Nine$inboundSchema` instead. */
  export const inboundSchema = Nine$inboundSchema;
  /** @deprecated use `Nine$outboundSchema` instead. */
  export const outboundSchema = Nine$outboundSchema;
  /** @deprecated use `Nine$Outbound` instead. */
  export type Outbound = Nine$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsRequest8Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest8Type> = z.nativeEnum(
    CreateRecordRequestBodyDnsRequest8Type,
  );

/** @internal */
export const CreateRecordRequestBodyDnsRequest8Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest8Type> =
    CreateRecordRequestBodyDnsRequest8Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequest8Type$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequest8Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequest8Type$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequest8Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequest8Type$outboundSchema;
}

/** @internal */
export const Eight$inboundSchema: z.ZodType<Eight, z.ZodTypeDef, unknown> = z
  .object({
    type: CreateRecordRequestBodyDnsRequest8Type$inboundSchema,
    ttl: z.number().optional(),
    value: z.string(),
    comment: z.string().optional(),
  });

/** @internal */
export type Eight$Outbound = {
  type: string;
  ttl?: number | undefined;
  value: string;
  comment?: string | undefined;
};

/** @internal */
export const Eight$outboundSchema: z.ZodType<
  Eight$Outbound,
  z.ZodTypeDef,
  Eight
> = z.object({
  type: CreateRecordRequestBodyDnsRequest8Type$outboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Eight$ {
  /** @deprecated use `Eight$inboundSchema` instead. */
  export const inboundSchema = Eight$inboundSchema;
  /** @deprecated use `Eight$outboundSchema` instead. */
  export const outboundSchema = Eight$outboundSchema;
  /** @deprecated use `Eight$Outbound` instead. */
  export type Outbound = Eight$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsRequest7Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest7Type> = z.nativeEnum(
    CreateRecordRequestBodyDnsRequest7Type,
  );

/** @internal */
export const CreateRecordRequestBodyDnsRequest7Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest7Type> =
    CreateRecordRequestBodyDnsRequest7Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequest7Type$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequest7Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequest7Type$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequest7Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequest7Type$outboundSchema;
}

/** @internal */
export const RequestBodySrv$inboundSchema: z.ZodType<
  RequestBodySrv,
  z.ZodTypeDef,
  unknown
> = z.object({
  priority: z.nullable(z.number()),
  weight: z.nullable(z.number()),
  port: z.nullable(z.number()),
  target: z.string(),
});

/** @internal */
export type RequestBodySrv$Outbound = {
  priority: number | null;
  weight: number | null;
  port: number | null;
  target: string;
};

/** @internal */
export const RequestBodySrv$outboundSchema: z.ZodType<
  RequestBodySrv$Outbound,
  z.ZodTypeDef,
  RequestBodySrv
> = z.object({
  priority: z.nullable(z.number()),
  weight: z.nullable(z.number()),
  port: z.nullable(z.number()),
  target: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodySrv$ {
  /** @deprecated use `RequestBodySrv$inboundSchema` instead. */
  export const inboundSchema = RequestBodySrv$inboundSchema;
  /** @deprecated use `RequestBodySrv$outboundSchema` instead. */
  export const outboundSchema = RequestBodySrv$outboundSchema;
  /** @deprecated use `RequestBodySrv$Outbound` instead. */
  export type Outbound = RequestBodySrv$Outbound;
}

/** @internal */
export const Seven$inboundSchema: z.ZodType<Seven, z.ZodTypeDef, unknown> = z
  .object({
    type: CreateRecordRequestBodyDnsRequest7Type$inboundSchema,
    ttl: z.number().optional(),
    srv: z.lazy(() => RequestBodySrv$inboundSchema),
    comment: z.string().optional(),
  });

/** @internal */
export type Seven$Outbound = {
  type: string;
  ttl?: number | undefined;
  srv: RequestBodySrv$Outbound;
  comment?: string | undefined;
};

/** @internal */
export const Seven$outboundSchema: z.ZodType<
  Seven$Outbound,
  z.ZodTypeDef,
  Seven
> = z.object({
  type: CreateRecordRequestBodyDnsRequest7Type$outboundSchema,
  ttl: z.number().optional(),
  srv: z.lazy(() => RequestBodySrv$outboundSchema),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Seven$ {
  /** @deprecated use `Seven$inboundSchema` instead. */
  export const inboundSchema = Seven$inboundSchema;
  /** @deprecated use `Seven$outboundSchema` instead. */
  export const outboundSchema = Seven$outboundSchema;
  /** @deprecated use `Seven$Outbound` instead. */
  export type Outbound = Seven$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsRequest6Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest6Type> = z.nativeEnum(
    CreateRecordRequestBodyDnsRequest6Type,
  );

/** @internal */
export const CreateRecordRequestBodyDnsRequest6Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest6Type> =
    CreateRecordRequestBodyDnsRequest6Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequest6Type$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequest6Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequest6Type$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequest6Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequest6Type$outboundSchema;
}

/** @internal */
export const Six$inboundSchema: z.ZodType<Six, z.ZodTypeDef, unknown> = z
  .object({
    name: z.string(),
    type: CreateRecordRequestBodyDnsRequest6Type$inboundSchema,
    ttl: z.number().optional(),
    value: z.string(),
    mxPriority: z.number(),
    comment: z.string().optional(),
  });

/** @internal */
export type Six$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value: string;
  mxPriority: number;
  comment?: string | undefined;
};

/** @internal */
export const Six$outboundSchema: z.ZodType<Six$Outbound, z.ZodTypeDef, Six> = z
  .object({
    name: z.string(),
    type: CreateRecordRequestBodyDnsRequest6Type$outboundSchema,
    ttl: z.number().optional(),
    value: z.string(),
    mxPriority: z.number(),
    comment: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Six$ {
  /** @deprecated use `Six$inboundSchema` instead. */
  export const inboundSchema = Six$inboundSchema;
  /** @deprecated use `Six$outboundSchema` instead. */
  export const outboundSchema = Six$outboundSchema;
  /** @deprecated use `Six$Outbound` instead. */
  export type Outbound = Six$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsRequest5Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest5Type> = z.nativeEnum(
    CreateRecordRequestBodyDnsRequest5Type,
  );

/** @internal */
export const CreateRecordRequestBodyDnsRequest5Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequest5Type> =
    CreateRecordRequestBodyDnsRequest5Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequest5Type$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequest5Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequest5Type$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequest5Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequest5Type$outboundSchema;
}

/** @internal */
export const RequestBody5$inboundSchema: z.ZodType<
  RequestBody5,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyDnsRequest5Type$inboundSchema,
  ttl: z.number().optional(),
  value: z.string().optional(),
  comment: z.string().optional(),
});

/** @internal */
export type RequestBody5$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value?: string | undefined;
  comment?: string | undefined;
};

/** @internal */
export const RequestBody5$outboundSchema: z.ZodType<
  RequestBody5$Outbound,
  z.ZodTypeDef,
  RequestBody5
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyDnsRequest5Type$outboundSchema,
  ttl: z.number().optional(),
  value: z.string().optional(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody5$ {
  /** @deprecated use `RequestBody5$inboundSchema` instead. */
  export const inboundSchema = RequestBody5$inboundSchema;
  /** @deprecated use `RequestBody5$outboundSchema` instead. */
  export const outboundSchema = RequestBody5$outboundSchema;
  /** @deprecated use `RequestBody5$Outbound` instead. */
  export type Outbound = RequestBody5$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsRequestType$inboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequestType> = z.nativeEnum(
    CreateRecordRequestBodyDnsRequestType,
  );

/** @internal */
export const CreateRecordRequestBodyDnsRequestType$outboundSchema:
  z.ZodNativeEnum<typeof CreateRecordRequestBodyDnsRequestType> =
    CreateRecordRequestBodyDnsRequestType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsRequestType$ {
  /** @deprecated use `CreateRecordRequestBodyDnsRequestType$inboundSchema` instead. */
  export const inboundSchema =
    CreateRecordRequestBodyDnsRequestType$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsRequestType$outboundSchema` instead. */
  export const outboundSchema =
    CreateRecordRequestBodyDnsRequestType$outboundSchema;
}

/** @internal */
export const RequestBody4$inboundSchema: z.ZodType<
  RequestBody4,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyDnsRequestType$inboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/** @internal */
export type RequestBody4$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value: string;
  comment?: string | undefined;
};

/** @internal */
export const RequestBody4$outboundSchema: z.ZodType<
  RequestBody4$Outbound,
  z.ZodTypeDef,
  RequestBody4
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyDnsRequestType$outboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody4$ {
  /** @deprecated use `RequestBody4$inboundSchema` instead. */
  export const inboundSchema = RequestBody4$inboundSchema;
  /** @deprecated use `RequestBody4$outboundSchema` instead. */
  export const outboundSchema = RequestBody4$outboundSchema;
  /** @deprecated use `RequestBody4$Outbound` instead. */
  export type Outbound = RequestBody4$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyDnsType$inboundSchema: z.ZodNativeEnum<
  typeof CreateRecordRequestBodyDnsType
> = z.nativeEnum(CreateRecordRequestBodyDnsType);

/** @internal */
export const CreateRecordRequestBodyDnsType$outboundSchema: z.ZodNativeEnum<
  typeof CreateRecordRequestBodyDnsType
> = CreateRecordRequestBodyDnsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyDnsType$ {
  /** @deprecated use `CreateRecordRequestBodyDnsType$inboundSchema` instead. */
  export const inboundSchema = CreateRecordRequestBodyDnsType$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyDnsType$outboundSchema` instead. */
  export const outboundSchema = CreateRecordRequestBodyDnsType$outboundSchema;
}

/** @internal */
export const RequestBody3$inboundSchema: z.ZodType<
  RequestBody3,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyDnsType$inboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/** @internal */
export type RequestBody3$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value: string;
  comment?: string | undefined;
};

/** @internal */
export const RequestBody3$outboundSchema: z.ZodType<
  RequestBody3$Outbound,
  z.ZodTypeDef,
  RequestBody3
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyDnsType$outboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody3$ {
  /** @deprecated use `RequestBody3$inboundSchema` instead. */
  export const inboundSchema = RequestBody3$inboundSchema;
  /** @deprecated use `RequestBody3$outboundSchema` instead. */
  export const outboundSchema = RequestBody3$outboundSchema;
  /** @deprecated use `RequestBody3$Outbound` instead. */
  export type Outbound = RequestBody3$Outbound;
}

/** @internal */
export const CreateRecordRequestBodyType$inboundSchema: z.ZodNativeEnum<
  typeof CreateRecordRequestBodyType
> = z.nativeEnum(CreateRecordRequestBodyType);

/** @internal */
export const CreateRecordRequestBodyType$outboundSchema: z.ZodNativeEnum<
  typeof CreateRecordRequestBodyType
> = CreateRecordRequestBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBodyType$ {
  /** @deprecated use `CreateRecordRequestBodyType$inboundSchema` instead. */
  export const inboundSchema = CreateRecordRequestBodyType$inboundSchema;
  /** @deprecated use `CreateRecordRequestBodyType$outboundSchema` instead. */
  export const outboundSchema = CreateRecordRequestBodyType$outboundSchema;
}

/** @internal */
export const RequestBody2$inboundSchema: z.ZodType<
  RequestBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyType$inboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/** @internal */
export type RequestBody2$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value: string;
  comment?: string | undefined;
};

/** @internal */
export const RequestBody2$outboundSchema: z.ZodType<
  RequestBody2$Outbound,
  z.ZodTypeDef,
  RequestBody2
> = z.object({
  name: z.string(),
  type: CreateRecordRequestBodyType$outboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody2$ {
  /** @deprecated use `RequestBody2$inboundSchema` instead. */
  export const inboundSchema = RequestBody2$inboundSchema;
  /** @deprecated use `RequestBody2$outboundSchema` instead. */
  export const outboundSchema = RequestBody2$outboundSchema;
  /** @deprecated use `RequestBody2$Outbound` instead. */
  export type Outbound = RequestBody2$Outbound;
}

/** @internal */
export const RequestBodyType$inboundSchema: z.ZodNativeEnum<
  typeof RequestBodyType
> = z.nativeEnum(RequestBodyType);

/** @internal */
export const RequestBodyType$outboundSchema: z.ZodNativeEnum<
  typeof RequestBodyType
> = RequestBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyType$ {
  /** @deprecated use `RequestBodyType$inboundSchema` instead. */
  export const inboundSchema = RequestBodyType$inboundSchema;
  /** @deprecated use `RequestBodyType$outboundSchema` instead. */
  export const outboundSchema = RequestBodyType$outboundSchema;
}

/** @internal */
export const RequestBody1$inboundSchema: z.ZodType<
  RequestBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  type: RequestBodyType$inboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/** @internal */
export type RequestBody1$Outbound = {
  name: string;
  type: string;
  ttl?: number | undefined;
  value: string;
  comment?: string | undefined;
};

/** @internal */
export const RequestBody1$outboundSchema: z.ZodType<
  RequestBody1$Outbound,
  z.ZodTypeDef,
  RequestBody1
> = z.object({
  name: z.string(),
  type: RequestBodyType$outboundSchema,
  ttl: z.number().optional(),
  value: z.string(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBody1$ {
  /** @deprecated use `RequestBody1$inboundSchema` instead. */
  export const inboundSchema = RequestBody1$inboundSchema;
  /** @deprecated use `RequestBody1$outboundSchema` instead. */
  export const outboundSchema = RequestBody1$outboundSchema;
  /** @deprecated use `RequestBody1$Outbound` instead. */
  export type Outbound = RequestBody1$Outbound;
}

/** @internal */
export const CreateRecordRequestBody$inboundSchema: z.ZodType<
  CreateRecordRequestBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => Seven$inboundSchema),
  z.lazy(() => Eight$inboundSchema),
  z.lazy(() => Ten$inboundSchema),
  z.lazy(() => RequestBody1$inboundSchema),
  z.lazy(() => RequestBody2$inboundSchema),
  z.lazy(() => RequestBody3$inboundSchema),
  z.lazy(() => RequestBody4$inboundSchema),
  z.lazy(() => RequestBody5$inboundSchema),
  z.lazy(() => Nine$inboundSchema),
  z.lazy(() => Six$inboundSchema),
]);

/** @internal */
export type CreateRecordRequestBody$Outbound =
  | Seven$Outbound
  | Eight$Outbound
  | Ten$Outbound
  | RequestBody1$Outbound
  | RequestBody2$Outbound
  | RequestBody3$Outbound
  | RequestBody4$Outbound
  | RequestBody5$Outbound
  | Nine$Outbound
  | Six$Outbound;

/** @internal */
export const CreateRecordRequestBody$outboundSchema: z.ZodType<
  CreateRecordRequestBody$Outbound,
  z.ZodTypeDef,
  CreateRecordRequestBody
> = z.union([
  z.lazy(() => Seven$outboundSchema),
  z.lazy(() => Eight$outboundSchema),
  z.lazy(() => Ten$outboundSchema),
  z.lazy(() => RequestBody1$outboundSchema),
  z.lazy(() => RequestBody2$outboundSchema),
  z.lazy(() => RequestBody3$outboundSchema),
  z.lazy(() => RequestBody4$outboundSchema),
  z.lazy(() => RequestBody5$outboundSchema),
  z.lazy(() => Nine$outboundSchema),
  z.lazy(() => Six$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequestBody$ {
  /** @deprecated use `CreateRecordRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateRecordRequestBody$inboundSchema;
  /** @deprecated use `CreateRecordRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateRecordRequestBody$outboundSchema;
  /** @deprecated use `CreateRecordRequestBody$Outbound` instead. */
  export type Outbound = CreateRecordRequestBody$Outbound;
}

/** @internal */
export const CreateRecordRequest$inboundSchema: z.ZodType<
  CreateRecordRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  domain: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.union([
    z.lazy(() => Seven$inboundSchema),
    z.lazy(() => Eight$inboundSchema),
    z.lazy(() => Ten$inboundSchema),
    z.lazy(() => RequestBody1$inboundSchema),
    z.lazy(() => RequestBody2$inboundSchema),
    z.lazy(() => RequestBody3$inboundSchema),
    z.lazy(() => RequestBody4$inboundSchema),
    z.lazy(() => RequestBody5$inboundSchema),
    z.lazy(() => Nine$inboundSchema),
    z.lazy(() => Six$inboundSchema),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateRecordRequest$Outbound = {
  domain: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?:
    | Seven$Outbound
    | Eight$Outbound
    | Ten$Outbound
    | RequestBody1$Outbound
    | RequestBody2$Outbound
    | RequestBody3$Outbound
    | RequestBody4$Outbound
    | RequestBody5$Outbound
    | Nine$Outbound
    | Six$Outbound
    | undefined;
};

/** @internal */
export const CreateRecordRequest$outboundSchema: z.ZodType<
  CreateRecordRequest$Outbound,
  z.ZodTypeDef,
  CreateRecordRequest
> = z.object({
  domain: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.union([
    z.lazy(() => Seven$outboundSchema),
    z.lazy(() => Eight$outboundSchema),
    z.lazy(() => Ten$outboundSchema),
    z.lazy(() => RequestBody1$outboundSchema),
    z.lazy(() => RequestBody2$outboundSchema),
    z.lazy(() => RequestBody3$outboundSchema),
    z.lazy(() => RequestBody4$outboundSchema),
    z.lazy(() => RequestBody5$outboundSchema),
    z.lazy(() => Nine$outboundSchema),
    z.lazy(() => Six$outboundSchema),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordRequest$ {
  /** @deprecated use `CreateRecordRequest$inboundSchema` instead. */
  export const inboundSchema = CreateRecordRequest$inboundSchema;
  /** @deprecated use `CreateRecordRequest$outboundSchema` instead. */
  export const outboundSchema = CreateRecordRequest$outboundSchema;
  /** @deprecated use `CreateRecordRequest$Outbound` instead. */
  export type Outbound = CreateRecordRequest$Outbound;
}

/** @internal */
export const CreateRecordResponseBody2$inboundSchema: z.ZodType<
  CreateRecordResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
});

/** @internal */
export type CreateRecordResponseBody2$Outbound = {
  uid: string;
};

/** @internal */
export const CreateRecordResponseBody2$outboundSchema: z.ZodType<
  CreateRecordResponseBody2$Outbound,
  z.ZodTypeDef,
  CreateRecordResponseBody2
> = z.object({
  uid: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordResponseBody2$ {
  /** @deprecated use `CreateRecordResponseBody2$inboundSchema` instead. */
  export const inboundSchema = CreateRecordResponseBody2$inboundSchema;
  /** @deprecated use `CreateRecordResponseBody2$outboundSchema` instead. */
  export const outboundSchema = CreateRecordResponseBody2$outboundSchema;
  /** @deprecated use `CreateRecordResponseBody2$Outbound` instead. */
  export type Outbound = CreateRecordResponseBody2$Outbound;
}

/** @internal */
export const CreateRecordResponseBody1$inboundSchema: z.ZodType<
  CreateRecordResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  updated: z.number(),
});

/** @internal */
export type CreateRecordResponseBody1$Outbound = {
  uid: string;
  updated: number;
};

/** @internal */
export const CreateRecordResponseBody1$outboundSchema: z.ZodType<
  CreateRecordResponseBody1$Outbound,
  z.ZodTypeDef,
  CreateRecordResponseBody1
> = z.object({
  uid: z.string(),
  updated: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordResponseBody1$ {
  /** @deprecated use `CreateRecordResponseBody1$inboundSchema` instead. */
  export const inboundSchema = CreateRecordResponseBody1$inboundSchema;
  /** @deprecated use `CreateRecordResponseBody1$outboundSchema` instead. */
  export const outboundSchema = CreateRecordResponseBody1$outboundSchema;
  /** @deprecated use `CreateRecordResponseBody1$Outbound` instead. */
  export type Outbound = CreateRecordResponseBody1$Outbound;
}

/** @internal */
export const CreateRecordResponseBody$inboundSchema: z.ZodType<
  CreateRecordResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateRecordResponseBody2$inboundSchema),
  z.lazy(() => CreateRecordResponseBody1$inboundSchema),
]);

/** @internal */
export type CreateRecordResponseBody$Outbound =
  | CreateRecordResponseBody2$Outbound
  | CreateRecordResponseBody1$Outbound;

/** @internal */
export const CreateRecordResponseBody$outboundSchema: z.ZodType<
  CreateRecordResponseBody$Outbound,
  z.ZodTypeDef,
  CreateRecordResponseBody
> = z.union([
  z.lazy(() => CreateRecordResponseBody2$outboundSchema),
  z.lazy(() => CreateRecordResponseBody1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateRecordResponseBody$ {
  /** @deprecated use `CreateRecordResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateRecordResponseBody$inboundSchema;
  /** @deprecated use `CreateRecordResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateRecordResponseBody$outboundSchema;
  /** @deprecated use `CreateRecordResponseBody$Outbound` instead. */
  export type Outbound = CreateRecordResponseBody$Outbound;
}
