/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The type of environment variable
 */
export const CreateProjectEnv2Type = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
/**
 * The type of environment variable
 */
export type CreateProjectEnv2Type = ClosedEnum<typeof CreateProjectEnv2Type>;

export const CreateProjectEnv2Target = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnv2Target = ClosedEnum<
  typeof CreateProjectEnv2Target
>;

export type Two2 = {
  /**
   * The name of the environment variable
   */
  key: string;
  /**
   * The value of the environment variable
   */
  value: string;
  /**
   * The type of environment variable
   */
  type: CreateProjectEnv2Type;
  /**
   * The target environment of the environment variable
   */
  target?: Array<CreateProjectEnv2Target> | undefined;
  /**
   * If defined, the git branch of the environment variable (must have target=preview)
   */
  gitBranch?: string | null | undefined;
  /**
   * A comment to add context on what this environment variable is for
   */
  comment?: string | undefined;
};

/**
 * The type of environment variable
 */
export const TwoType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
/**
 * The type of environment variable
 */
export type TwoType = ClosedEnum<typeof TwoType>;

export const TwoTarget = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type TwoTarget = ClosedEnum<typeof TwoTarget>;

export type Two1 = {
  /**
   * The name of the environment variable
   */
  key: string;
  /**
   * The value of the environment variable
   */
  value: string;
  /**
   * The type of environment variable
   */
  type: TwoType;
  /**
   * The target environment of the environment variable
   */
  target: Array<TwoTarget>;
  /**
   * If defined, the git branch of the environment variable (must have target=preview)
   */
  gitBranch?: string | null | undefined;
  /**
   * A comment to add context on what this environment variable is for
   */
  comment?: string | undefined;
};

export type CreateProjectEnvRequestBody2 = Two1 | Two2;

/**
 * The type of environment variable
 */
export const CreateProjectEnv1Type = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
/**
 * The type of environment variable
 */
export type CreateProjectEnv1Type = ClosedEnum<typeof CreateProjectEnv1Type>;

export const CreateProjectEnv1Target = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnv1Target = ClosedEnum<
  typeof CreateProjectEnv1Target
>;

export type CreateProjectEnv12 = {
  /**
   * The name of the environment variable
   */
  key: string;
  /**
   * The value of the environment variable
   */
  value: string;
  /**
   * The type of environment variable
   */
  type: CreateProjectEnv1Type;
  /**
   * The target environment of the environment variable
   */
  target?: Array<CreateProjectEnv1Target> | undefined;
  /**
   * If defined, the git branch of the environment variable (must have target=preview)
   */
  gitBranch?: string | null | undefined;
  /**
   * A comment to add context on what this environment variable is for
   */
  comment?: string | undefined;
};

/**
 * The type of environment variable
 */
export const OneType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
/**
 * The type of environment variable
 */
export type OneType = ClosedEnum<typeof OneType>;

export const OneTarget = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type OneTarget = ClosedEnum<typeof OneTarget>;

export type CreateProjectEnv11 = {
  /**
   * The name of the environment variable
   */
  key: string;
  /**
   * The value of the environment variable
   */
  value: string;
  /**
   * The type of environment variable
   */
  type: OneType;
  /**
   * The target environment of the environment variable
   */
  target: Array<OneTarget>;
  /**
   * If defined, the git branch of the environment variable (must have target=preview)
   */
  gitBranch?: string | null | undefined;
  /**
   * A comment to add context on what this environment variable is for
   */
  comment?: string | undefined;
};

export type CreateProjectEnvRequestBody1 =
  | CreateProjectEnv11
  | CreateProjectEnv12;

export type CreateProjectEnvRequestBody =
  | CreateProjectEnv11
  | CreateProjectEnv12
  | Array<Two1 | Two2>;

export type CreateProjectEnvRequest = {
  /**
   * The unique project identifier or the project name
   */
  idOrName: string;
  /**
   * Allow override of environment variable if it already exists
   */
  upsert?: string | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?:
    | CreateProjectEnv11
    | CreateProjectEnv12
    | Array<Two1 | Two2>
    | undefined;
};

export const CreateProjectEnvTargetProjects2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnvTargetProjects2 = ClosedEnum<
  typeof CreateProjectEnvTargetProjects2
>;

export type CreateProjectEnvCreatedTarget =
  | Array<string>
  | CreateProjectEnvTargetProjects2;

export const CreateProjectEnvCreatedType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
export type CreateProjectEnvCreatedType = ClosedEnum<
  typeof CreateProjectEnvCreatedType
>;

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type
  >;

export type CreateProjectEnvContentHintProjects15 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type;
  projectId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type
  >;

export type CreateProjectEnvContentHintProjects14 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type
  >;

export type CreateProjectEnvContentHintProjects13 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type
  >;

export type CreateProjectEnvContentHintProjects12 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type
  >;

export type CreateProjectEnvContentHintProjects11 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type
  >;

export type CreateProjectEnvContentHintProjects10 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type
  >;

export type CreateProjectEnvContentHintProjects9 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type
  >;

export type CreateProjectEnvContentHintProjects8 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type
  >;

export type CreateProjectEnvContentHintProjects7 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type
  >;

export type CreateProjectEnvContentHintProjects6 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type =
  {
    BlobReadWriteToken: "blob-read-write-token",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type
  >;

export type CreateProjectEnvContentHintProjects5 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type =
  {
    RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type
  >;

export type CreateProjectEnvContentHintProjects4 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type =
  {
    RedisRestApiToken: "redis-rest-api-token",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type
  >;

export type CreateProjectEnvContentHintProjects3 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type =
  {
    RedisRestApiUrl: "redis-rest-api-url",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type
  >;

export type CreateProjectEnvContentHintProjects2 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type =
  {
    RedisUrl: "redis-url",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type
  >;

export type CreateProjectEnvContentHintProjects1 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type;
  storeId: string;
};

export type CreateProjectEnvCreatedContentHint =
  | CreateProjectEnvContentHintProjects1
  | CreateProjectEnvContentHintProjects2
  | CreateProjectEnvContentHintProjects3
  | CreateProjectEnvContentHintProjects4
  | CreateProjectEnvContentHintProjects5
  | CreateProjectEnvContentHintProjects6
  | CreateProjectEnvContentHintProjects7
  | CreateProjectEnvContentHintProjects8
  | CreateProjectEnvContentHintProjects9
  | CreateProjectEnvContentHintProjects10
  | CreateProjectEnvContentHintProjects11
  | CreateProjectEnvContentHintProjects12
  | CreateProjectEnvContentHintProjects13
  | CreateProjectEnvContentHintProjects15
  | CreateProjectEnvContentHintProjects14;

export const CreateProjectEnvCreatedProjectsResponseType = {
  FlagsSecret: "flags-secret",
} as const;
export type CreateProjectEnvCreatedProjectsResponseType = ClosedEnum<
  typeof CreateProjectEnvCreatedProjectsResponseType
>;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type CreateProjectEnvCreatedInternalContentHint = {
  type: CreateProjectEnvCreatedProjectsResponseType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type Created2 = {
  target?: Array<string> | CreateProjectEnvTargetProjects2 | undefined;
  type?: CreateProjectEnvCreatedType | undefined;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key?: string | undefined;
  value?: string | undefined;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | CreateProjectEnvContentHintProjects1
    | CreateProjectEnvContentHintProjects2
    | CreateProjectEnvContentHintProjects3
    | CreateProjectEnvContentHintProjects4
    | CreateProjectEnvContentHintProjects5
    | CreateProjectEnvContentHintProjects6
    | CreateProjectEnvContentHintProjects7
    | CreateProjectEnvContentHintProjects8
    | CreateProjectEnvContentHintProjects9
    | CreateProjectEnvContentHintProjects10
    | CreateProjectEnvContentHintProjects11
    | CreateProjectEnvContentHintProjects12
    | CreateProjectEnvContentHintProjects13
    | CreateProjectEnvContentHintProjects15
    | CreateProjectEnvContentHintProjects14
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?:
    | CreateProjectEnvCreatedInternalContentHint
    | null
    | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
  system?: boolean | undefined;
};

export const CreateProjectEnvTarget2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnvTarget2 = ClosedEnum<
  typeof CreateProjectEnvTarget2
>;

export const CreateProjectEnvTarget1 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnvTarget1 = ClosedEnum<
  typeof CreateProjectEnvTarget1
>;

export type CreatedTarget =
  | Array<CreateProjectEnvTarget1>
  | CreateProjectEnvTarget2;

export const CreatedType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
export type CreatedType = ClosedEnum<typeof CreatedType>;

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type
  >;

export type CreateProjectEnvContentHint15 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type;
  projectId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type
  >;

export type CreateProjectEnvContentHint14 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type
  >;

export type CreateProjectEnvContentHint13 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type
  >;

export type CreateProjectEnvContentHint12 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type
  >;

export type CreateProjectEnvContentHint11 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type
  >;

export type CreateProjectEnvContentHint10 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type
  >;

export type CreateProjectEnvContentHint9 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type
  >;

export type CreateProjectEnvContentHint8 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType
  >;

export type CreateProjectEnvContentHint7 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType
  >;

export type CreateProjectEnvContentHint6 = {
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType =
  {
    BlobReadWriteToken: "blob-read-write-token",
  } as const;
export type CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType =
  ClosedEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType
  >;

export type CreateProjectEnvContentHint5 = {
  type: CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponse201Type = {
  RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
} as const;
export type CreateProjectEnvContentHintProjectsResponse201Type = ClosedEnum<
  typeof CreateProjectEnvContentHintProjectsResponse201Type
>;

export type CreateProjectEnvContentHint4 = {
  type: CreateProjectEnvContentHintProjectsResponse201Type;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsResponseType = {
  RedisRestApiToken: "redis-rest-api-token",
} as const;
export type CreateProjectEnvContentHintProjectsResponseType = ClosedEnum<
  typeof CreateProjectEnvContentHintProjectsResponseType
>;

export type CreateProjectEnvContentHint3 = {
  type: CreateProjectEnvContentHintProjectsResponseType;
  storeId: string;
};

export const CreateProjectEnvContentHintProjectsType = {
  RedisRestApiUrl: "redis-rest-api-url",
} as const;
export type CreateProjectEnvContentHintProjectsType = ClosedEnum<
  typeof CreateProjectEnvContentHintProjectsType
>;

export type CreateProjectEnvContentHint2 = {
  type: CreateProjectEnvContentHintProjectsType;
  storeId: string;
};

export const CreateProjectEnvContentHintType = {
  RedisUrl: "redis-url",
} as const;
export type CreateProjectEnvContentHintType = ClosedEnum<
  typeof CreateProjectEnvContentHintType
>;

export type CreateProjectEnvContentHint1 = {
  type: CreateProjectEnvContentHintType;
  storeId: string;
};

export type CreatedContentHint =
  | CreateProjectEnvContentHint1
  | CreateProjectEnvContentHint2
  | CreateProjectEnvContentHint3
  | CreateProjectEnvContentHint4
  | CreateProjectEnvContentHint5
  | CreateProjectEnvContentHint6
  | CreateProjectEnvContentHint7
  | CreateProjectEnvContentHint8
  | CreateProjectEnvContentHint9
  | CreateProjectEnvContentHint10
  | CreateProjectEnvContentHint11
  | CreateProjectEnvContentHint12
  | CreateProjectEnvContentHint13
  | CreateProjectEnvContentHint15
  | CreateProjectEnvContentHint14;

export const CreateProjectEnvCreatedProjectsType = {
  FlagsSecret: "flags-secret",
} as const;
export type CreateProjectEnvCreatedProjectsType = ClosedEnum<
  typeof CreateProjectEnvCreatedProjectsType
>;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type CreatedInternalContentHint = {
  type: CreateProjectEnvCreatedProjectsType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type Created1 = {
  target?: Array<CreateProjectEnvTarget1> | CreateProjectEnvTarget2 | undefined;
  type?: CreatedType | undefined;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key?: string | undefined;
  value?: string | undefined;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | CreateProjectEnvContentHint1
    | CreateProjectEnvContentHint2
    | CreateProjectEnvContentHint3
    | CreateProjectEnvContentHint4
    | CreateProjectEnvContentHint5
    | CreateProjectEnvContentHint6
    | CreateProjectEnvContentHint7
    | CreateProjectEnvContentHint8
    | CreateProjectEnvContentHint9
    | CreateProjectEnvContentHint10
    | CreateProjectEnvContentHint11
    | CreateProjectEnvContentHint12
    | CreateProjectEnvContentHint13
    | CreateProjectEnvContentHint15
    | CreateProjectEnvContentHint14
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?: CreatedInternalContentHint | null | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
  system?: boolean | undefined;
};

export type Created = Created1 | Array<Created2>;

export const CreateProjectEnvValue2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnvValue2 = ClosedEnum<typeof CreateProjectEnvValue2>;

export type CreateProjectEnvValue = string | Array<CreateProjectEnvValue2>;

export const CreateProjectEnvTargetProjectsResponse2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnvTargetProjectsResponse2 = ClosedEnum<
  typeof CreateProjectEnvTargetProjectsResponse2
>;

export const CreateProjectEnvTargetProjects1 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectEnvTargetProjects1 = ClosedEnum<
  typeof CreateProjectEnvTargetProjects1
>;

export type CreateProjectEnvTarget =
  | Array<CreateProjectEnvTargetProjects1>
  | CreateProjectEnvTargetProjectsResponse2;

export type CreateProjectEnvError = {
  code: string;
  message: string;
  key?: string | undefined;
  envVarId?: string | undefined;
  envVarKey?: string | undefined;
  action?: string | undefined;
  link?: string | undefined;
  value?: string | Array<CreateProjectEnvValue2> | undefined;
  gitBranch?: string | undefined;
  target?:
    | Array<CreateProjectEnvTargetProjects1>
    | CreateProjectEnvTargetProjectsResponse2
    | undefined;
  project?: string | undefined;
};

export type Failed = {
  error: CreateProjectEnvError;
};

/**
 * The environment variable was created successfully
 */
export type CreateProjectEnvResponseBody = {
  created: Created1 | Array<Created2>;
  failed: Array<Failed>;
};

/** @internal */
export const CreateProjectEnv2Type$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv2Type
> = z.nativeEnum(CreateProjectEnv2Type);

/** @internal */
export const CreateProjectEnv2Type$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv2Type
> = CreateProjectEnv2Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv2Type$ {
  /** @deprecated use `CreateProjectEnv2Type$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv2Type$inboundSchema;
  /** @deprecated use `CreateProjectEnv2Type$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv2Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnv2Target$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv2Target
> = z.nativeEnum(CreateProjectEnv2Target);

/** @internal */
export const CreateProjectEnv2Target$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv2Target
> = CreateProjectEnv2Target$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv2Target$ {
  /** @deprecated use `CreateProjectEnv2Target$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv2Target$inboundSchema;
  /** @deprecated use `CreateProjectEnv2Target$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv2Target$outboundSchema;
}

/** @internal */
export const Two2$inboundSchema: z.ZodType<Two2, z.ZodTypeDef, unknown> = z
  .object({
    key: z.string(),
    value: z.string(),
    type: CreateProjectEnv2Type$inboundSchema,
    target: z.array(CreateProjectEnv2Target$inboundSchema).optional(),
    gitBranch: z.nullable(z.string()).optional(),
    comment: z.string().optional(),
  });

/** @internal */
export type Two2$Outbound = {
  key: string;
  value: string;
  type: string;
  target?: Array<string> | undefined;
  gitBranch?: string | null | undefined;
  comment?: string | undefined;
};

/** @internal */
export const Two2$outboundSchema: z.ZodType<Two2$Outbound, z.ZodTypeDef, Two2> =
  z.object({
    key: z.string(),
    value: z.string(),
    type: CreateProjectEnv2Type$outboundSchema,
    target: z.array(CreateProjectEnv2Target$outboundSchema).optional(),
    gitBranch: z.nullable(z.string()).optional(),
    comment: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Two2$ {
  /** @deprecated use `Two2$inboundSchema` instead. */
  export const inboundSchema = Two2$inboundSchema;
  /** @deprecated use `Two2$outboundSchema` instead. */
  export const outboundSchema = Two2$outboundSchema;
  /** @deprecated use `Two2$Outbound` instead. */
  export type Outbound = Two2$Outbound;
}

/** @internal */
export const TwoType$inboundSchema: z.ZodNativeEnum<typeof TwoType> = z
  .nativeEnum(TwoType);

/** @internal */
export const TwoType$outboundSchema: z.ZodNativeEnum<typeof TwoType> =
  TwoType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TwoType$ {
  /** @deprecated use `TwoType$inboundSchema` instead. */
  export const inboundSchema = TwoType$inboundSchema;
  /** @deprecated use `TwoType$outboundSchema` instead. */
  export const outboundSchema = TwoType$outboundSchema;
}

/** @internal */
export const TwoTarget$inboundSchema: z.ZodNativeEnum<typeof TwoTarget> = z
  .nativeEnum(TwoTarget);

/** @internal */
export const TwoTarget$outboundSchema: z.ZodNativeEnum<typeof TwoTarget> =
  TwoTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TwoTarget$ {
  /** @deprecated use `TwoTarget$inboundSchema` instead. */
  export const inboundSchema = TwoTarget$inboundSchema;
  /** @deprecated use `TwoTarget$outboundSchema` instead. */
  export const outboundSchema = TwoTarget$outboundSchema;
}

/** @internal */
export const Two1$inboundSchema: z.ZodType<Two1, z.ZodTypeDef, unknown> = z
  .object({
    key: z.string(),
    value: z.string(),
    type: TwoType$inboundSchema,
    target: z.array(TwoTarget$inboundSchema),
    gitBranch: z.nullable(z.string()).optional(),
    comment: z.string().optional(),
  });

/** @internal */
export type Two1$Outbound = {
  key: string;
  value: string;
  type: string;
  target: Array<string>;
  gitBranch?: string | null | undefined;
  comment?: string | undefined;
};

/** @internal */
export const Two1$outboundSchema: z.ZodType<Two1$Outbound, z.ZodTypeDef, Two1> =
  z.object({
    key: z.string(),
    value: z.string(),
    type: TwoType$outboundSchema,
    target: z.array(TwoTarget$outboundSchema),
    gitBranch: z.nullable(z.string()).optional(),
    comment: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Two1$ {
  /** @deprecated use `Two1$inboundSchema` instead. */
  export const inboundSchema = Two1$inboundSchema;
  /** @deprecated use `Two1$outboundSchema` instead. */
  export const outboundSchema = Two1$outboundSchema;
  /** @deprecated use `Two1$Outbound` instead. */
  export type Outbound = Two1$Outbound;
}

/** @internal */
export const CreateProjectEnvRequestBody2$inboundSchema: z.ZodType<
  CreateProjectEnvRequestBody2,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => Two1$inboundSchema),
  z.lazy(() => Two2$inboundSchema),
]);

/** @internal */
export type CreateProjectEnvRequestBody2$Outbound =
  | Two1$Outbound
  | Two2$Outbound;

/** @internal */
export const CreateProjectEnvRequestBody2$outboundSchema: z.ZodType<
  CreateProjectEnvRequestBody2$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvRequestBody2
> = z.union([
  z.lazy(() => Two1$outboundSchema),
  z.lazy(() => Two2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvRequestBody2$ {
  /** @deprecated use `CreateProjectEnvRequestBody2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvRequestBody2$inboundSchema;
  /** @deprecated use `CreateProjectEnvRequestBody2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvRequestBody2$outboundSchema;
  /** @deprecated use `CreateProjectEnvRequestBody2$Outbound` instead. */
  export type Outbound = CreateProjectEnvRequestBody2$Outbound;
}

/** @internal */
export const CreateProjectEnv1Type$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv1Type
> = z.nativeEnum(CreateProjectEnv1Type);

/** @internal */
export const CreateProjectEnv1Type$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv1Type
> = CreateProjectEnv1Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv1Type$ {
  /** @deprecated use `CreateProjectEnv1Type$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv1Type$inboundSchema;
  /** @deprecated use `CreateProjectEnv1Type$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv1Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnv1Target$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv1Target
> = z.nativeEnum(CreateProjectEnv1Target);

/** @internal */
export const CreateProjectEnv1Target$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnv1Target
> = CreateProjectEnv1Target$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv1Target$ {
  /** @deprecated use `CreateProjectEnv1Target$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv1Target$inboundSchema;
  /** @deprecated use `CreateProjectEnv1Target$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv1Target$outboundSchema;
}

/** @internal */
export const CreateProjectEnv12$inboundSchema: z.ZodType<
  CreateProjectEnv12,
  z.ZodTypeDef,
  unknown
> = z.object({
  key: z.string(),
  value: z.string(),
  type: CreateProjectEnv1Type$inboundSchema,
  target: z.array(CreateProjectEnv1Target$inboundSchema).optional(),
  gitBranch: z.nullable(z.string()).optional(),
  comment: z.string().optional(),
});

/** @internal */
export type CreateProjectEnv12$Outbound = {
  key: string;
  value: string;
  type: string;
  target?: Array<string> | undefined;
  gitBranch?: string | null | undefined;
  comment?: string | undefined;
};

/** @internal */
export const CreateProjectEnv12$outboundSchema: z.ZodType<
  CreateProjectEnv12$Outbound,
  z.ZodTypeDef,
  CreateProjectEnv12
> = z.object({
  key: z.string(),
  value: z.string(),
  type: CreateProjectEnv1Type$outboundSchema,
  target: z.array(CreateProjectEnv1Target$outboundSchema).optional(),
  gitBranch: z.nullable(z.string()).optional(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv12$ {
  /** @deprecated use `CreateProjectEnv12$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv12$inboundSchema;
  /** @deprecated use `CreateProjectEnv12$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv12$outboundSchema;
  /** @deprecated use `CreateProjectEnv12$Outbound` instead. */
  export type Outbound = CreateProjectEnv12$Outbound;
}

/** @internal */
export const OneType$inboundSchema: z.ZodNativeEnum<typeof OneType> = z
  .nativeEnum(OneType);

/** @internal */
export const OneType$outboundSchema: z.ZodNativeEnum<typeof OneType> =
  OneType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace OneType$ {
  /** @deprecated use `OneType$inboundSchema` instead. */
  export const inboundSchema = OneType$inboundSchema;
  /** @deprecated use `OneType$outboundSchema` instead. */
  export const outboundSchema = OneType$outboundSchema;
}

/** @internal */
export const OneTarget$inboundSchema: z.ZodNativeEnum<typeof OneTarget> = z
  .nativeEnum(OneTarget);

/** @internal */
export const OneTarget$outboundSchema: z.ZodNativeEnum<typeof OneTarget> =
  OneTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace OneTarget$ {
  /** @deprecated use `OneTarget$inboundSchema` instead. */
  export const inboundSchema = OneTarget$inboundSchema;
  /** @deprecated use `OneTarget$outboundSchema` instead. */
  export const outboundSchema = OneTarget$outboundSchema;
}

/** @internal */
export const CreateProjectEnv11$inboundSchema: z.ZodType<
  CreateProjectEnv11,
  z.ZodTypeDef,
  unknown
> = z.object({
  key: z.string(),
  value: z.string(),
  type: OneType$inboundSchema,
  target: z.array(OneTarget$inboundSchema),
  gitBranch: z.nullable(z.string()).optional(),
  comment: z.string().optional(),
});

/** @internal */
export type CreateProjectEnv11$Outbound = {
  key: string;
  value: string;
  type: string;
  target: Array<string>;
  gitBranch?: string | null | undefined;
  comment?: string | undefined;
};

/** @internal */
export const CreateProjectEnv11$outboundSchema: z.ZodType<
  CreateProjectEnv11$Outbound,
  z.ZodTypeDef,
  CreateProjectEnv11
> = z.object({
  key: z.string(),
  value: z.string(),
  type: OneType$outboundSchema,
  target: z.array(OneTarget$outboundSchema),
  gitBranch: z.nullable(z.string()).optional(),
  comment: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv11$ {
  /** @deprecated use `CreateProjectEnv11$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv11$inboundSchema;
  /** @deprecated use `CreateProjectEnv11$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv11$outboundSchema;
  /** @deprecated use `CreateProjectEnv11$Outbound` instead. */
  export type Outbound = CreateProjectEnv11$Outbound;
}

/** @internal */
export const CreateProjectEnvRequestBody1$inboundSchema: z.ZodType<
  CreateProjectEnvRequestBody1,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectEnv11$inboundSchema),
  z.lazy(() => CreateProjectEnv12$inboundSchema),
]);

/** @internal */
export type CreateProjectEnvRequestBody1$Outbound =
  | CreateProjectEnv11$Outbound
  | CreateProjectEnv12$Outbound;

/** @internal */
export const CreateProjectEnvRequestBody1$outboundSchema: z.ZodType<
  CreateProjectEnvRequestBody1$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvRequestBody1
> = z.union([
  z.lazy(() => CreateProjectEnv11$outboundSchema),
  z.lazy(() => CreateProjectEnv12$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvRequestBody1$ {
  /** @deprecated use `CreateProjectEnvRequestBody1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvRequestBody1$inboundSchema;
  /** @deprecated use `CreateProjectEnvRequestBody1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvRequestBody1$outboundSchema;
  /** @deprecated use `CreateProjectEnvRequestBody1$Outbound` instead. */
  export type Outbound = CreateProjectEnvRequestBody1$Outbound;
}

/** @internal */
export const CreateProjectEnvRequestBody$inboundSchema: z.ZodType<
  CreateProjectEnvRequestBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.union([
    z.lazy(() => CreateProjectEnv11$inboundSchema),
    z.lazy(() => CreateProjectEnv12$inboundSchema),
  ]),
  z.array(
    z.union([
      z.lazy(() => Two1$inboundSchema),
      z.lazy(() => Two2$inboundSchema),
    ]),
  ),
]);

/** @internal */
export type CreateProjectEnvRequestBody$Outbound =
  | CreateProjectEnv11$Outbound
  | CreateProjectEnv12$Outbound
  | Array<Two1$Outbound | Two2$Outbound>;

/** @internal */
export const CreateProjectEnvRequestBody$outboundSchema: z.ZodType<
  CreateProjectEnvRequestBody$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvRequestBody
> = z.union([
  z.union([
    z.lazy(() => CreateProjectEnv11$outboundSchema),
    z.lazy(() => CreateProjectEnv12$outboundSchema),
  ]),
  z.array(
    z.union([
      z.lazy(() => Two1$outboundSchema),
      z.lazy(() => Two2$outboundSchema),
    ]),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvRequestBody$ {
  /** @deprecated use `CreateProjectEnvRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvRequestBody$inboundSchema;
  /** @deprecated use `CreateProjectEnvRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvRequestBody$outboundSchema;
  /** @deprecated use `CreateProjectEnvRequestBody$Outbound` instead. */
  export type Outbound = CreateProjectEnvRequestBody$Outbound;
}

/** @internal */
export const CreateProjectEnvRequest$inboundSchema: z.ZodType<
  CreateProjectEnvRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrName: z.string(),
  upsert: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.union([
    z.union([
      z.lazy(() => CreateProjectEnv11$inboundSchema),
      z.lazy(() => CreateProjectEnv12$inboundSchema),
    ]),
    z.array(
      z.union([
        z.lazy(() => Two1$inboundSchema),
        z.lazy(() => Two2$inboundSchema),
      ]),
    ),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateProjectEnvRequest$Outbound = {
  idOrName: string;
  upsert?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?:
    | CreateProjectEnv11$Outbound
    | CreateProjectEnv12$Outbound
    | Array<Two1$Outbound | Two2$Outbound>
    | undefined;
};

/** @internal */
export const CreateProjectEnvRequest$outboundSchema: z.ZodType<
  CreateProjectEnvRequest$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvRequest
> = z.object({
  idOrName: z.string(),
  upsert: z.string().optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.union([
    z.union([
      z.lazy(() => CreateProjectEnv11$outboundSchema),
      z.lazy(() => CreateProjectEnv12$outboundSchema),
    ]),
    z.array(
      z.union([
        z.lazy(() => Two1$outboundSchema),
        z.lazy(() => Two2$outboundSchema),
      ]),
    ),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvRequest$ {
  /** @deprecated use `CreateProjectEnvRequest$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvRequest$inboundSchema;
  /** @deprecated use `CreateProjectEnvRequest$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvRequest$outboundSchema;
  /** @deprecated use `CreateProjectEnvRequest$Outbound` instead. */
  export type Outbound = CreateProjectEnvRequest$Outbound;
}

/** @internal */
export const CreateProjectEnvTargetProjects2$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTargetProjects2
> = z.nativeEnum(CreateProjectEnvTargetProjects2);

/** @internal */
export const CreateProjectEnvTargetProjects2$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTargetProjects2
> = CreateProjectEnvTargetProjects2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvTargetProjects2$ {
  /** @deprecated use `CreateProjectEnvTargetProjects2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvTargetProjects2$inboundSchema;
  /** @deprecated use `CreateProjectEnvTargetProjects2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvTargetProjects2$outboundSchema;
}

/** @internal */
export const CreateProjectEnvCreatedTarget$inboundSchema: z.ZodType<
  CreateProjectEnvCreatedTarget,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(z.string()),
  CreateProjectEnvTargetProjects2$inboundSchema,
]);

/** @internal */
export type CreateProjectEnvCreatedTarget$Outbound = Array<string> | string;

/** @internal */
export const CreateProjectEnvCreatedTarget$outboundSchema: z.ZodType<
  CreateProjectEnvCreatedTarget$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvCreatedTarget
> = z.union([
  z.array(z.string()),
  CreateProjectEnvTargetProjects2$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvCreatedTarget$ {
  /** @deprecated use `CreateProjectEnvCreatedTarget$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvCreatedTarget$inboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedTarget$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvCreatedTarget$outboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedTarget$Outbound` instead. */
  export type Outbound = CreateProjectEnvCreatedTarget$Outbound;
}

/** @internal */
export const CreateProjectEnvCreatedType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvCreatedType
> = z.nativeEnum(CreateProjectEnvCreatedType);

/** @internal */
export const CreateProjectEnvCreatedType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvCreatedType
> = CreateProjectEnvCreatedType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvCreatedType$ {
  /** @deprecated use `CreateProjectEnvCreatedType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvCreatedType$inboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvCreatedType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects15$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects15,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$inboundSchema,
  projectId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects15$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects15$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects15$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects15
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated215Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects15$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects15$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects15$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects15$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects15$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects15$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects15$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects14$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects14,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects14$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects14$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects14$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects14
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated214Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects14$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects14$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects14$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects14$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects14$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects14$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects14$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects13$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects13,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects13$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects13$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects13$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects13
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated213Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects13$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects13$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects13$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects13$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects13$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects13$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects13$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects12$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects12,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects12$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects12$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects12$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects12
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated212Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects12$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects12$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects12$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects12$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects12$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects12$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects12$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects11$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects11$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects11$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects11
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated211Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects11$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects11$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects11$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects11$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects11$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects11$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects11$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects10$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects10$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects10$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects10
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated210Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects10$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects10$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects10$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects10$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects10$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects10$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects10$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects9$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects9$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects9$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects9
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated29Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects9$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects9$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects9$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects9$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects9$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects9$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects9$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects8$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects8$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects8$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects8
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated28Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects8$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects8$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects8$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects8$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects8$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects8$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects8$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects7$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects7$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects7$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects7
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated27Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects7$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects7$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects7$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects7$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects7$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects7$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects7$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects6$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects6$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects6$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects6
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated26Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects6$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects6$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects6$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects6$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects6$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects6$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects6$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects5$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects5$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects5$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects5
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated25Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects5$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects5$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects5$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects5$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects5$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects5$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects5$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects4$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects4$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects4$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects4
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated24Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects4$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects4$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects4$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects4$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects4$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects4$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects4$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects3$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects3$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects3$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects3
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated23Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects3$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects3$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects3$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects3$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects3$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects3$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects3$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects2$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects2$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects2$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects2
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated22Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects2$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects2$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects2$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects2$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects2$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects2$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects2$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjects1$inboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHintProjects1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHintProjects1$outboundSchema: z.ZodType<
  CreateProjectEnvContentHintProjects1$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHintProjects1
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated2Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjects1$ {
  /** @deprecated use `CreateProjectEnvContentHintProjects1$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjects1$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects1$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjects1$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjects1$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHintProjects1$Outbound;
}

/** @internal */
export const CreateProjectEnvCreatedContentHint$inboundSchema: z.ZodType<
  CreateProjectEnvCreatedContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectEnvContentHintProjects1$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects2$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects3$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects4$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects5$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects6$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects7$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects8$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects9$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects10$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects11$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects12$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects13$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects15$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects14$inboundSchema),
]);

/** @internal */
export type CreateProjectEnvCreatedContentHint$Outbound =
  | CreateProjectEnvContentHintProjects1$Outbound
  | CreateProjectEnvContentHintProjects2$Outbound
  | CreateProjectEnvContentHintProjects3$Outbound
  | CreateProjectEnvContentHintProjects4$Outbound
  | CreateProjectEnvContentHintProjects5$Outbound
  | CreateProjectEnvContentHintProjects6$Outbound
  | CreateProjectEnvContentHintProjects7$Outbound
  | CreateProjectEnvContentHintProjects8$Outbound
  | CreateProjectEnvContentHintProjects9$Outbound
  | CreateProjectEnvContentHintProjects10$Outbound
  | CreateProjectEnvContentHintProjects11$Outbound
  | CreateProjectEnvContentHintProjects12$Outbound
  | CreateProjectEnvContentHintProjects13$Outbound
  | CreateProjectEnvContentHintProjects15$Outbound
  | CreateProjectEnvContentHintProjects14$Outbound;

/** @internal */
export const CreateProjectEnvCreatedContentHint$outboundSchema: z.ZodType<
  CreateProjectEnvCreatedContentHint$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvCreatedContentHint
> = z.union([
  z.lazy(() => CreateProjectEnvContentHintProjects1$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects2$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects3$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects4$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects5$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects6$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects7$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects8$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects9$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects10$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects11$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects12$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects13$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects15$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHintProjects14$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvCreatedContentHint$ {
  /** @deprecated use `CreateProjectEnvCreatedContentHint$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvCreatedContentHint$inboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedContentHint$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvCreatedContentHint$outboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedContentHint$Outbound` instead. */
  export type Outbound = CreateProjectEnvCreatedContentHint$Outbound;
}

/** @internal */
export const CreateProjectEnvCreatedProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvCreatedProjectsResponseType> = z
    .nativeEnum(CreateProjectEnvCreatedProjectsResponseType);

/** @internal */
export const CreateProjectEnvCreatedProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvCreatedProjectsResponseType> =
    CreateProjectEnvCreatedProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvCreatedProjectsResponseType$ {
  /** @deprecated use `CreateProjectEnvCreatedProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvCreatedProjectsResponseType$inboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvCreatedProjectsResponseType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvCreatedInternalContentHint$inboundSchema:
  z.ZodType<CreateProjectEnvCreatedInternalContentHint, z.ZodTypeDef, unknown> =
    z.object({
      type: CreateProjectEnvCreatedProjectsResponseType$inboundSchema,
      encryptedValue: z.string(),
    });

/** @internal */
export type CreateProjectEnvCreatedInternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const CreateProjectEnvCreatedInternalContentHint$outboundSchema:
  z.ZodType<
    CreateProjectEnvCreatedInternalContentHint$Outbound,
    z.ZodTypeDef,
    CreateProjectEnvCreatedInternalContentHint
  > = z.object({
    type: CreateProjectEnvCreatedProjectsResponseType$outboundSchema,
    encryptedValue: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvCreatedInternalContentHint$ {
  /** @deprecated use `CreateProjectEnvCreatedInternalContentHint$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvCreatedInternalContentHint$inboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedInternalContentHint$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvCreatedInternalContentHint$outboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedInternalContentHint$Outbound` instead. */
  export type Outbound = CreateProjectEnvCreatedInternalContentHint$Outbound;
}

/** @internal */
export const Created2$inboundSchema: z.ZodType<
  Created2,
  z.ZodTypeDef,
  unknown
> = z.object({
  target: z.union([
    z.array(z.string()),
    CreateProjectEnvTargetProjects2$inboundSchema,
  ]).optional(),
  type: CreateProjectEnvCreatedType$inboundSchema.optional(),
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  value: z.string().optional(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => CreateProjectEnvContentHintProjects1$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects2$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects3$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects4$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects5$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects6$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects7$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects8$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects9$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects10$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects11$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects12$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects13$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects15$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects14$inboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => CreateProjectEnvCreatedInternalContentHint$inboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
  system: z.boolean().optional(),
});

/** @internal */
export type Created2$Outbound = {
  target?: Array<string> | string | undefined;
  type?: string | undefined;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key?: string | undefined;
  value?: string | undefined;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | CreateProjectEnvContentHintProjects1$Outbound
    | CreateProjectEnvContentHintProjects2$Outbound
    | CreateProjectEnvContentHintProjects3$Outbound
    | CreateProjectEnvContentHintProjects4$Outbound
    | CreateProjectEnvContentHintProjects5$Outbound
    | CreateProjectEnvContentHintProjects6$Outbound
    | CreateProjectEnvContentHintProjects7$Outbound
    | CreateProjectEnvContentHintProjects8$Outbound
    | CreateProjectEnvContentHintProjects9$Outbound
    | CreateProjectEnvContentHintProjects10$Outbound
    | CreateProjectEnvContentHintProjects11$Outbound
    | CreateProjectEnvContentHintProjects12$Outbound
    | CreateProjectEnvContentHintProjects13$Outbound
    | CreateProjectEnvContentHintProjects15$Outbound
    | CreateProjectEnvContentHintProjects14$Outbound
    | null
    | undefined;
  internalContentHint?:
    | CreateProjectEnvCreatedInternalContentHint$Outbound
    | null
    | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
  system?: boolean | undefined;
};

/** @internal */
export const Created2$outboundSchema: z.ZodType<
  Created2$Outbound,
  z.ZodTypeDef,
  Created2
> = z.object({
  target: z.union([
    z.array(z.string()),
    CreateProjectEnvTargetProjects2$outboundSchema,
  ]).optional(),
  type: CreateProjectEnvCreatedType$outboundSchema.optional(),
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  value: z.string().optional(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => CreateProjectEnvContentHintProjects1$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects2$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects3$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects4$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects5$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects6$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects7$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects8$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects9$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects10$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects11$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects12$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects13$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects15$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHintProjects14$outboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => CreateProjectEnvCreatedInternalContentHint$outboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
  system: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Created2$ {
  /** @deprecated use `Created2$inboundSchema` instead. */
  export const inboundSchema = Created2$inboundSchema;
  /** @deprecated use `Created2$outboundSchema` instead. */
  export const outboundSchema = Created2$outboundSchema;
  /** @deprecated use `Created2$Outbound` instead. */
  export type Outbound = Created2$Outbound;
}

/** @internal */
export const CreateProjectEnvTarget2$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTarget2
> = z.nativeEnum(CreateProjectEnvTarget2);

/** @internal */
export const CreateProjectEnvTarget2$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTarget2
> = CreateProjectEnvTarget2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvTarget2$ {
  /** @deprecated use `CreateProjectEnvTarget2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvTarget2$inboundSchema;
  /** @deprecated use `CreateProjectEnvTarget2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvTarget2$outboundSchema;
}

/** @internal */
export const CreateProjectEnvTarget1$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTarget1
> = z.nativeEnum(CreateProjectEnvTarget1);

/** @internal */
export const CreateProjectEnvTarget1$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTarget1
> = CreateProjectEnvTarget1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvTarget1$ {
  /** @deprecated use `CreateProjectEnvTarget1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvTarget1$inboundSchema;
  /** @deprecated use `CreateProjectEnvTarget1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvTarget1$outboundSchema;
}

/** @internal */
export const CreatedTarget$inboundSchema: z.ZodType<
  CreatedTarget,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(CreateProjectEnvTarget1$inboundSchema),
  CreateProjectEnvTarget2$inboundSchema,
]);

/** @internal */
export type CreatedTarget$Outbound = Array<string> | string;

/** @internal */
export const CreatedTarget$outboundSchema: z.ZodType<
  CreatedTarget$Outbound,
  z.ZodTypeDef,
  CreatedTarget
> = z.union([
  z.array(CreateProjectEnvTarget1$outboundSchema),
  CreateProjectEnvTarget2$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreatedTarget$ {
  /** @deprecated use `CreatedTarget$inboundSchema` instead. */
  export const inboundSchema = CreatedTarget$inboundSchema;
  /** @deprecated use `CreatedTarget$outboundSchema` instead. */
  export const outboundSchema = CreatedTarget$outboundSchema;
  /** @deprecated use `CreatedTarget$Outbound` instead. */
  export type Outbound = CreatedTarget$Outbound;
}

/** @internal */
export const CreatedType$inboundSchema: z.ZodNativeEnum<typeof CreatedType> = z
  .nativeEnum(CreatedType);

/** @internal */
export const CreatedType$outboundSchema: z.ZodNativeEnum<typeof CreatedType> =
  CreatedType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreatedType$ {
  /** @deprecated use `CreatedType$inboundSchema` instead. */
  export const inboundSchema = CreatedType$inboundSchema;
  /** @deprecated use `CreatedType$outboundSchema` instead. */
  export const outboundSchema = CreatedType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint15$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint15,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$inboundSchema,
  projectId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint15$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const CreateProjectEnvContentHint15$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint15$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint15
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated115Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint15$ {
  /** @deprecated use `CreateProjectEnvContentHint15$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint15$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint15$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint15$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint15$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint15$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint14$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint14,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint14$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const CreateProjectEnvContentHint14$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint14$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint14
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated114Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint14$ {
  /** @deprecated use `CreateProjectEnvContentHint14$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint14$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint14$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint14$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint14$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint14$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint13$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint13,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint13$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint13$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint13$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint13
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated113Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint13$ {
  /** @deprecated use `CreateProjectEnvContentHint13$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint13$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint13$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint13$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint13$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint13$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint12$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint12,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint12$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint12$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint12$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint12
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated112Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint12$ {
  /** @deprecated use `CreateProjectEnvContentHint12$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint12$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint12$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint12$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint12$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint12$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint11$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint11$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint11$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint11
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated111Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint11$ {
  /** @deprecated use `CreateProjectEnvContentHint11$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint11$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint11$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint11$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint11$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint11$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint10$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint10$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint10$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint10
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated110Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint10$ {
  /** @deprecated use `CreateProjectEnvContentHint10$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint10$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint10$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint10$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint10$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint10$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint9$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint9$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint9$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint9
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated19Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint9$ {
  /** @deprecated use `CreateProjectEnvContentHint9$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint9$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint9$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint9$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint9$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint9$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint8$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint8$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint8$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint8
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreated1Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint8$ {
  /** @deprecated use `CreateProjectEnvContentHint8$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint8$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint8$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint8$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint8$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint8$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint7$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint7$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint7$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint7
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyCreatedType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint7$ {
  /** @deprecated use `CreateProjectEnvContentHint7$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint7$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint7$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint7$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint7$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint7$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint6$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint6$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint6$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint6
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONResponseBodyType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint6$ {
  /** @deprecated use `CreateProjectEnvContentHint6$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint6$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint6$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint6$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint6$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint6$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType
  > = z.nativeEnum(
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType,
  );

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType
  > =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint5$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint5$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint5$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint5
> = z.object({
  type:
    CreateProjectEnvContentHintProjectsResponse201ApplicationJSONType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint5$ {
  /** @deprecated use `CreateProjectEnvContentHint5$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint5$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint5$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint5$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint5$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint5$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvContentHintProjectsResponse201Type> = z
    .nativeEnum(CreateProjectEnvContentHintProjectsResponse201Type);

/** @internal */
export const CreateProjectEnvContentHintProjectsResponse201Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvContentHintProjectsResponse201Type> =
    CreateProjectEnvContentHintProjectsResponse201Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponse201Type$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponse201Type$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponse201Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponse201Type$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint4$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectEnvContentHintProjectsResponse201Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint4$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint4$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint4
> = z.object({
  type: CreateProjectEnvContentHintProjectsResponse201Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint4$ {
  /** @deprecated use `CreateProjectEnvContentHint4$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint4$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint4$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint4$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint4$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint4$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvContentHintProjectsResponseType> = z
    .nativeEnum(CreateProjectEnvContentHintProjectsResponseType);

/** @internal */
export const CreateProjectEnvContentHintProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvContentHintProjectsResponseType> =
    CreateProjectEnvContentHintProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsResponseType$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsResponseType$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsResponseType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint3$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectEnvContentHintProjectsResponseType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint3$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint3$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint3
> = z.object({
  type: CreateProjectEnvContentHintProjectsResponseType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint3$ {
  /** @deprecated use `CreateProjectEnvContentHint3$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint3$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint3$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint3$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint3$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint3$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvContentHintProjectsType> = z
    .nativeEnum(CreateProjectEnvContentHintProjectsType);

/** @internal */
export const CreateProjectEnvContentHintProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvContentHintProjectsType> =
    CreateProjectEnvContentHintProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintProjectsType$ {
  /** @deprecated use `CreateProjectEnvContentHintProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvContentHintProjectsType$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvContentHintProjectsType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint2$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectEnvContentHintProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint2$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint2$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint2
> = z.object({
  type: CreateProjectEnvContentHintProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint2$ {
  /** @deprecated use `CreateProjectEnvContentHint2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint2$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint2$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint2$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint2$Outbound;
}

/** @internal */
export const CreateProjectEnvContentHintType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvContentHintType
> = z.nativeEnum(CreateProjectEnvContentHintType);

/** @internal */
export const CreateProjectEnvContentHintType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvContentHintType
> = CreateProjectEnvContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHintType$ {
  /** @deprecated use `CreateProjectEnvContentHintType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHintType$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHintType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHintType$outboundSchema;
}

/** @internal */
export const CreateProjectEnvContentHint1$inboundSchema: z.ZodType<
  CreateProjectEnvContentHint1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectEnvContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectEnvContentHint1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectEnvContentHint1$outboundSchema: z.ZodType<
  CreateProjectEnvContentHint1$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvContentHint1
> = z.object({
  type: CreateProjectEnvContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvContentHint1$ {
  /** @deprecated use `CreateProjectEnvContentHint1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvContentHint1$inboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvContentHint1$outboundSchema;
  /** @deprecated use `CreateProjectEnvContentHint1$Outbound` instead. */
  export type Outbound = CreateProjectEnvContentHint1$Outbound;
}

/** @internal */
export const CreatedContentHint$inboundSchema: z.ZodType<
  CreatedContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectEnvContentHint1$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint2$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint3$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint4$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint5$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint6$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint7$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint8$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint9$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint10$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint11$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint12$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint13$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint15$inboundSchema),
  z.lazy(() => CreateProjectEnvContentHint14$inboundSchema),
]);

/** @internal */
export type CreatedContentHint$Outbound =
  | CreateProjectEnvContentHint1$Outbound
  | CreateProjectEnvContentHint2$Outbound
  | CreateProjectEnvContentHint3$Outbound
  | CreateProjectEnvContentHint4$Outbound
  | CreateProjectEnvContentHint5$Outbound
  | CreateProjectEnvContentHint6$Outbound
  | CreateProjectEnvContentHint7$Outbound
  | CreateProjectEnvContentHint8$Outbound
  | CreateProjectEnvContentHint9$Outbound
  | CreateProjectEnvContentHint10$Outbound
  | CreateProjectEnvContentHint11$Outbound
  | CreateProjectEnvContentHint12$Outbound
  | CreateProjectEnvContentHint13$Outbound
  | CreateProjectEnvContentHint15$Outbound
  | CreateProjectEnvContentHint14$Outbound;

/** @internal */
export const CreatedContentHint$outboundSchema: z.ZodType<
  CreatedContentHint$Outbound,
  z.ZodTypeDef,
  CreatedContentHint
> = z.union([
  z.lazy(() => CreateProjectEnvContentHint1$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint2$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint3$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint4$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint5$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint6$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint7$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint8$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint9$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint10$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint11$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint12$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint13$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint15$outboundSchema),
  z.lazy(() => CreateProjectEnvContentHint14$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreatedContentHint$ {
  /** @deprecated use `CreatedContentHint$inboundSchema` instead. */
  export const inboundSchema = CreatedContentHint$inboundSchema;
  /** @deprecated use `CreatedContentHint$outboundSchema` instead. */
  export const outboundSchema = CreatedContentHint$outboundSchema;
  /** @deprecated use `CreatedContentHint$Outbound` instead. */
  export type Outbound = CreatedContentHint$Outbound;
}

/** @internal */
export const CreateProjectEnvCreatedProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvCreatedProjectsType
> = z.nativeEnum(CreateProjectEnvCreatedProjectsType);

/** @internal */
export const CreateProjectEnvCreatedProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvCreatedProjectsType> =
    CreateProjectEnvCreatedProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvCreatedProjectsType$ {
  /** @deprecated use `CreateProjectEnvCreatedProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvCreatedProjectsType$inboundSchema;
  /** @deprecated use `CreateProjectEnvCreatedProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvCreatedProjectsType$outboundSchema;
}

/** @internal */
export const CreatedInternalContentHint$inboundSchema: z.ZodType<
  CreatedInternalContentHint,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectEnvCreatedProjectsType$inboundSchema,
  encryptedValue: z.string(),
});

/** @internal */
export type CreatedInternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const CreatedInternalContentHint$outboundSchema: z.ZodType<
  CreatedInternalContentHint$Outbound,
  z.ZodTypeDef,
  CreatedInternalContentHint
> = z.object({
  type: CreateProjectEnvCreatedProjectsType$outboundSchema,
  encryptedValue: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreatedInternalContentHint$ {
  /** @deprecated use `CreatedInternalContentHint$inboundSchema` instead. */
  export const inboundSchema = CreatedInternalContentHint$inboundSchema;
  /** @deprecated use `CreatedInternalContentHint$outboundSchema` instead. */
  export const outboundSchema = CreatedInternalContentHint$outboundSchema;
  /** @deprecated use `CreatedInternalContentHint$Outbound` instead. */
  export type Outbound = CreatedInternalContentHint$Outbound;
}

/** @internal */
export const Created1$inboundSchema: z.ZodType<
  Created1,
  z.ZodTypeDef,
  unknown
> = z.object({
  target: z.union([
    z.array(CreateProjectEnvTarget1$inboundSchema),
    CreateProjectEnvTarget2$inboundSchema,
  ]).optional(),
  type: CreatedType$inboundSchema.optional(),
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  value: z.string().optional(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => CreateProjectEnvContentHint1$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint2$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint3$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint4$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint5$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint6$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint7$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint8$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint9$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint10$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint11$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint12$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint13$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint15$inboundSchema),
      z.lazy(() => CreateProjectEnvContentHint14$inboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => CreatedInternalContentHint$inboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
  system: z.boolean().optional(),
});

/** @internal */
export type Created1$Outbound = {
  target?: Array<string> | string | undefined;
  type?: string | undefined;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key?: string | undefined;
  value?: string | undefined;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | CreateProjectEnvContentHint1$Outbound
    | CreateProjectEnvContentHint2$Outbound
    | CreateProjectEnvContentHint3$Outbound
    | CreateProjectEnvContentHint4$Outbound
    | CreateProjectEnvContentHint5$Outbound
    | CreateProjectEnvContentHint6$Outbound
    | CreateProjectEnvContentHint7$Outbound
    | CreateProjectEnvContentHint8$Outbound
    | CreateProjectEnvContentHint9$Outbound
    | CreateProjectEnvContentHint10$Outbound
    | CreateProjectEnvContentHint11$Outbound
    | CreateProjectEnvContentHint12$Outbound
    | CreateProjectEnvContentHint13$Outbound
    | CreateProjectEnvContentHint15$Outbound
    | CreateProjectEnvContentHint14$Outbound
    | null
    | undefined;
  internalContentHint?: CreatedInternalContentHint$Outbound | null | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
  system?: boolean | undefined;
};

/** @internal */
export const Created1$outboundSchema: z.ZodType<
  Created1$Outbound,
  z.ZodTypeDef,
  Created1
> = z.object({
  target: z.union([
    z.array(CreateProjectEnvTarget1$outboundSchema),
    CreateProjectEnvTarget2$outboundSchema,
  ]).optional(),
  type: CreatedType$outboundSchema.optional(),
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  value: z.string().optional(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => CreateProjectEnvContentHint1$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint2$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint3$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint4$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint5$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint6$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint7$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint8$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint9$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint10$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint11$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint12$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint13$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint15$outboundSchema),
      z.lazy(() => CreateProjectEnvContentHint14$outboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => CreatedInternalContentHint$outboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
  system: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Created1$ {
  /** @deprecated use `Created1$inboundSchema` instead. */
  export const inboundSchema = Created1$inboundSchema;
  /** @deprecated use `Created1$outboundSchema` instead. */
  export const outboundSchema = Created1$outboundSchema;
  /** @deprecated use `Created1$Outbound` instead. */
  export type Outbound = Created1$Outbound;
}

/** @internal */
export const Created$inboundSchema: z.ZodType<Created, z.ZodTypeDef, unknown> =
  z.union([
    z.lazy(() => Created1$inboundSchema),
    z.array(z.lazy(() => Created2$inboundSchema)),
  ]);

/** @internal */
export type Created$Outbound = Created1$Outbound | Array<Created2$Outbound>;

/** @internal */
export const Created$outboundSchema: z.ZodType<
  Created$Outbound,
  z.ZodTypeDef,
  Created
> = z.union([
  z.lazy(() => Created1$outboundSchema),
  z.array(z.lazy(() => Created2$outboundSchema)),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Created$ {
  /** @deprecated use `Created$inboundSchema` instead. */
  export const inboundSchema = Created$inboundSchema;
  /** @deprecated use `Created$outboundSchema` instead. */
  export const outboundSchema = Created$outboundSchema;
  /** @deprecated use `Created$Outbound` instead. */
  export type Outbound = Created$Outbound;
}

/** @internal */
export const CreateProjectEnvValue2$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvValue2
> = z.nativeEnum(CreateProjectEnvValue2);

/** @internal */
export const CreateProjectEnvValue2$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvValue2
> = CreateProjectEnvValue2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvValue2$ {
  /** @deprecated use `CreateProjectEnvValue2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvValue2$inboundSchema;
  /** @deprecated use `CreateProjectEnvValue2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvValue2$outboundSchema;
}

/** @internal */
export const CreateProjectEnvValue$inboundSchema: z.ZodType<
  CreateProjectEnvValue,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.array(CreateProjectEnvValue2$inboundSchema)]);

/** @internal */
export type CreateProjectEnvValue$Outbound = string | Array<string>;

/** @internal */
export const CreateProjectEnvValue$outboundSchema: z.ZodType<
  CreateProjectEnvValue$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvValue
> = z.union([z.string(), z.array(CreateProjectEnvValue2$outboundSchema)]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvValue$ {
  /** @deprecated use `CreateProjectEnvValue$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvValue$inboundSchema;
  /** @deprecated use `CreateProjectEnvValue$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvValue$outboundSchema;
  /** @deprecated use `CreateProjectEnvValue$Outbound` instead. */
  export type Outbound = CreateProjectEnvValue$Outbound;
}

/** @internal */
export const CreateProjectEnvTargetProjectsResponse2$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvTargetProjectsResponse2> = z
    .nativeEnum(CreateProjectEnvTargetProjectsResponse2);

/** @internal */
export const CreateProjectEnvTargetProjectsResponse2$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectEnvTargetProjectsResponse2> =
    CreateProjectEnvTargetProjectsResponse2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvTargetProjectsResponse2$ {
  /** @deprecated use `CreateProjectEnvTargetProjectsResponse2$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectEnvTargetProjectsResponse2$inboundSchema;
  /** @deprecated use `CreateProjectEnvTargetProjectsResponse2$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectEnvTargetProjectsResponse2$outboundSchema;
}

/** @internal */
export const CreateProjectEnvTargetProjects1$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTargetProjects1
> = z.nativeEnum(CreateProjectEnvTargetProjects1);

/** @internal */
export const CreateProjectEnvTargetProjects1$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectEnvTargetProjects1
> = CreateProjectEnvTargetProjects1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvTargetProjects1$ {
  /** @deprecated use `CreateProjectEnvTargetProjects1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvTargetProjects1$inboundSchema;
  /** @deprecated use `CreateProjectEnvTargetProjects1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvTargetProjects1$outboundSchema;
}

/** @internal */
export const CreateProjectEnvTarget$inboundSchema: z.ZodType<
  CreateProjectEnvTarget,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.array(CreateProjectEnvTargetProjects1$inboundSchema),
  CreateProjectEnvTargetProjectsResponse2$inboundSchema,
]);

/** @internal */
export type CreateProjectEnvTarget$Outbound = Array<string> | string;

/** @internal */
export const CreateProjectEnvTarget$outboundSchema: z.ZodType<
  CreateProjectEnvTarget$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvTarget
> = z.union([
  z.array(CreateProjectEnvTargetProjects1$outboundSchema),
  CreateProjectEnvTargetProjectsResponse2$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvTarget$ {
  /** @deprecated use `CreateProjectEnvTarget$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvTarget$inboundSchema;
  /** @deprecated use `CreateProjectEnvTarget$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvTarget$outboundSchema;
  /** @deprecated use `CreateProjectEnvTarget$Outbound` instead. */
  export type Outbound = CreateProjectEnvTarget$Outbound;
}

/** @internal */
export const CreateProjectEnvError$inboundSchema: z.ZodType<
  CreateProjectEnvError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
  key: z.string().optional(),
  envVarId: z.string().optional(),
  envVarKey: z.string().optional(),
  action: z.string().optional(),
  link: z.string().optional(),
  value: z.union([z.string(), z.array(CreateProjectEnvValue2$inboundSchema)])
    .optional(),
  gitBranch: z.string().optional(),
  target: z.union([
    z.array(CreateProjectEnvTargetProjects1$inboundSchema),
    CreateProjectEnvTargetProjectsResponse2$inboundSchema,
  ]).optional(),
  project: z.string().optional(),
});

/** @internal */
export type CreateProjectEnvError$Outbound = {
  code: string;
  message: string;
  key?: string | undefined;
  envVarId?: string | undefined;
  envVarKey?: string | undefined;
  action?: string | undefined;
  link?: string | undefined;
  value?: string | Array<string> | undefined;
  gitBranch?: string | undefined;
  target?: Array<string> | string | undefined;
  project?: string | undefined;
};

/** @internal */
export const CreateProjectEnvError$outboundSchema: z.ZodType<
  CreateProjectEnvError$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvError
> = z.object({
  code: z.string(),
  message: z.string(),
  key: z.string().optional(),
  envVarId: z.string().optional(),
  envVarKey: z.string().optional(),
  action: z.string().optional(),
  link: z.string().optional(),
  value: z.union([z.string(), z.array(CreateProjectEnvValue2$outboundSchema)])
    .optional(),
  gitBranch: z.string().optional(),
  target: z.union([
    z.array(CreateProjectEnvTargetProjects1$outboundSchema),
    CreateProjectEnvTargetProjectsResponse2$outboundSchema,
  ]).optional(),
  project: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvError$ {
  /** @deprecated use `CreateProjectEnvError$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvError$inboundSchema;
  /** @deprecated use `CreateProjectEnvError$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvError$outboundSchema;
  /** @deprecated use `CreateProjectEnvError$Outbound` instead. */
  export type Outbound = CreateProjectEnvError$Outbound;
}

/** @internal */
export const Failed$inboundSchema: z.ZodType<Failed, z.ZodTypeDef, unknown> = z
  .object({
    error: z.lazy(() => CreateProjectEnvError$inboundSchema),
  });

/** @internal */
export type Failed$Outbound = {
  error: CreateProjectEnvError$Outbound;
};

/** @internal */
export const Failed$outboundSchema: z.ZodType<
  Failed$Outbound,
  z.ZodTypeDef,
  Failed
> = z.object({
  error: z.lazy(() => CreateProjectEnvError$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Failed$ {
  /** @deprecated use `Failed$inboundSchema` instead. */
  export const inboundSchema = Failed$inboundSchema;
  /** @deprecated use `Failed$outboundSchema` instead. */
  export const outboundSchema = Failed$outboundSchema;
  /** @deprecated use `Failed$Outbound` instead. */
  export type Outbound = Failed$Outbound;
}

/** @internal */
export const CreateProjectEnvResponseBody$inboundSchema: z.ZodType<
  CreateProjectEnvResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  created: z.union([
    z.lazy(() => Created1$inboundSchema),
    z.array(z.lazy(() => Created2$inboundSchema)),
  ]),
  failed: z.array(z.lazy(() => Failed$inboundSchema)),
});

/** @internal */
export type CreateProjectEnvResponseBody$Outbound = {
  created: Created1$Outbound | Array<Created2$Outbound>;
  failed: Array<Failed$Outbound>;
};

/** @internal */
export const CreateProjectEnvResponseBody$outboundSchema: z.ZodType<
  CreateProjectEnvResponseBody$Outbound,
  z.ZodTypeDef,
  CreateProjectEnvResponseBody
> = z.object({
  created: z.union([
    z.lazy(() => Created1$outboundSchema),
    z.array(z.lazy(() => Created2$outboundSchema)),
  ]),
  failed: z.array(z.lazy(() => Failed$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnvResponseBody$ {
  /** @deprecated use `CreateProjectEnvResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnvResponseBody$inboundSchema;
  /** @deprecated use `CreateProjectEnvResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnvResponseBody$outboundSchema;
  /** @deprecated use `CreateProjectEnvResponseBody$Outbound` instead. */
  export type Outbound = CreateProjectEnvResponseBody$Outbound;
}
