/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  ACLAction,
  ACLAction$inboundSchema,
  ACLAction$outboundSchema,
} from "../components/aclaction.js";

export const Target2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type Target2 = ClosedEnum<typeof Target2>;

export const Target1 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type Target1 = ClosedEnum<typeof Target1>;

/**
 * Deployment Target or Targets in which the ENV variable will be used
 */
export type CreateProjectTarget = Target1 | Array<Target2>;

/**
 * Type of the ENV variable
 */
export const CreateProjectType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
/**
 * Type of the ENV variable
 */
export type CreateProjectType = ClosedEnum<typeof CreateProjectType>;

export type EnvironmentVariables = {
  /**
   * Name of the ENV variable
   */
  key: string;
  /**
   * Deployment Target or Targets in which the ENV variable will be used
   */
  target: Target1 | Array<Target2>;
  /**
   * If defined, the git branch of the environment variable (must have target=preview)
   */
  gitBranch?: string | undefined;
  /**
   * Type of the ENV variable
   */
  type?: CreateProjectType | undefined;
  /**
   * Value for the ENV variable
   */
  value: string;
};

/**
 * The framework that is being used for this project. When `null` is used no framework is selected
 */
export const CreateProjectFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
/**
 * The framework that is being used for this project. When `null` is used no framework is selected
 */
export type CreateProjectFramework = ClosedEnum<typeof CreateProjectFramework>;

/**
 * The Git Provider of the repository
 */
export const CreateProjectProjectsType = {
  Github: "github",
  Gitlab: "gitlab",
  Bitbucket: "bitbucket",
} as const;
/**
 * The Git Provider of the repository
 */
export type CreateProjectProjectsType = ClosedEnum<
  typeof CreateProjectProjectsType
>;

/**
 * The Git Repository that will be connected to the project. When this is defined, any pushes to the specified connected Git Repository will be automatically deployed
 */
export type GitRepository = {
  /**
   * The name of the git repository. For example: \"vercel/next.js\"
   */
  repo: string;
  /**
   * The Git Provider of the repository
   */
  type: CreateProjectProjectsType;
};

/**
 * team: `https://oidc.vercel.com/[team_slug]` global: `https://oidc.vercel.com`
 */
export const IssuerMode = {
  Team: "team",
  Global: "global",
} as const;
/**
 * team: `https://oidc.vercel.com/[team_slug]` global: `https://oidc.vercel.com`
 */
export type IssuerMode = ClosedEnum<typeof IssuerMode>;

/**
 * OpenID Connect JSON Web Token generation configuration.
 */
export type OidcTokenConfig = {
  /**
   * Whether or not to generate OpenID Connect JSON Web Tokens.
   */
  enabled: boolean;
  /**
   * team: `https://oidc.vercel.com/[team_slug]` global: `https://oidc.vercel.com`
   */
  issuerMode?: IssuerMode | undefined;
};

export type CreateProjectRequestBody = {
  /**
   * The build command for this project. When `null` is used this value will be automatically detected
   */
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  /**
   * The dev command for this project. When `null` is used this value will be automatically detected
   */
  devCommand?: string | null | undefined;
  /**
   * Collection of ENV Variables the Project will use
   */
  environmentVariables?: Array<EnvironmentVariables> | undefined;
  /**
   * The framework that is being used for this project. When `null` is used no framework is selected
   */
  framework?: CreateProjectFramework | undefined;
  /**
   * The Git Repository that will be connected to the project. When this is defined, any pushes to the specified connected Git Repository will be automatically deployed
   */
  gitRepository?: GitRepository | undefined;
  /**
   * The install command for this project. When `null` is used this value will be automatically detected
   */
  installCommand?: string | null | undefined;
  /**
   * The desired name for the project
   */
  name: string;
  /**
   * Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`.
   *
   * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
   */
  skipGitConnectDuringLink?: boolean | undefined;
  /**
   * The output directory of the project. When `null` is used this value will be automatically detected
   */
  outputDirectory?: string | null | undefined;
  /**
   * Specifies whether the source code and logs of the deployments for this project should be public or not
   */
  publicSource?: boolean | null | undefined;
  /**
   * The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root
   */
  rootDirectory?: string | null | undefined;
  /**
   * The region to deploy Serverless Functions in this project
   */
  serverlessFunctionRegion?: string | null | undefined;
  /**
   * Specifies whether Zero Config Failover is enabled for this project.
   */
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  /**
   * OpenID Connect JSON Web Token generation configuration.
   */
  oidcTokenConfig?: OidcTokenConfig | undefined;
  /**
   * Opt-in to skip deployments when there are no changes to the root directory and its dependencies
   */
  enableAffectedProjectsDeployments?: boolean | undefined;
};

export type CreateProjectRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: CreateProjectRequestBody | undefined;
};

export type CreateProjectAnalytics = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

export type CreateProjectSpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type CreateProjectDefinitions = {
  /**
   * The hostname that should be used.
   */
  host: string;
  /**
   * The path that should be called for the cronjob.
   */
  path: string;
  /**
   * The cron expression.
   */
  schedule: string;
};

export type CreateProjectCrons = {
  /**
   * The time the feature was enabled for this project. Note: It enables automatically with the first Deployment that outputs cronjobs.
   */
  enabledAt: number;
  /**
   * The time the feature was disabled for this project.
   */
  disabledAt: number | null;
  updatedAt: number;
  /**
   * The ID of the Deployment from which the definitions originated.
   */
  deploymentId: string | null;
  definitions: Array<CreateProjectDefinitions>;
};

export type CreateProjectDataCache = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

export type CreateProjectDeploymentExpiration = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

export const CreateProjectTarget2 = {
  Production: "production",
  Preview: "preview",
  Development: "development",
} as const;
export type CreateProjectTarget2 = ClosedEnum<typeof CreateProjectTarget2>;

export type CreateProjectProjectsTarget = Array<string> | CreateProjectTarget2;

export const CreateProjectProjectsResponseType = {
  System: "system",
  Secret: "secret",
  Encrypted: "encrypted",
  Plain: "plain",
  Sensitive: "sensitive",
} as const;
export type CreateProjectProjectsResponseType = ClosedEnum<
  typeof CreateProjectProjectsResponseType
>;

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type =
  {
    FlagsConnectionString: "flags-connection-string",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  >;

export type ContentHint15 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type;
  projectId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type =
  {
    IntegrationStoreSecret: "integration-store-secret",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  >;

export type ContentHint14 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type =
  {
    PostgresUrlNoSsl: "postgres-url-no-ssl",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  >;

export type ContentHint13 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type =
  {
    PostgresDatabase: "postgres-database",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  >;

export type ContentHint12 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type =
  {
    PostgresPassword: "postgres-password",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  >;

export type ContentHint11 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type =
  {
    PostgresHost: "postgres-host",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  >;

export type CreateProjectContentHint10 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type =
  {
    PostgresUser: "postgres-user",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  >;

export type CreateProjectContentHint9 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type =
  {
    PostgresPrismaUrl: "postgres-prisma-url",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type
  >;

export type CreateProjectContentHint8 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType =
  {
    PostgresUrlNonPooling: "postgres-url-non-pooling",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  >;

export type CreateProjectContentHint7 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  {
    PostgresUrl: "postgres-url",
  } as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type CreateProjectContentHint6 = {
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200ApplicationJSONType = {
  BlobReadWriteToken: "blob-read-write-token",
} as const;
export type CreateProjectContentHintProjectsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONType
  >;

export type CreateProjectContentHint5 = {
  type: CreateProjectContentHintProjectsResponse200ApplicationJSONType;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponse200Type = {
  RedisRestApiReadOnlyToken: "redis-rest-api-read-only-token",
} as const;
export type CreateProjectContentHintProjectsResponse200Type = ClosedEnum<
  typeof CreateProjectContentHintProjectsResponse200Type
>;

export type CreateProjectContentHint4 = {
  type: CreateProjectContentHintProjectsResponse200Type;
  storeId: string;
};

export const CreateProjectContentHintProjectsResponseType = {
  RedisRestApiToken: "redis-rest-api-token",
} as const;
export type CreateProjectContentHintProjectsResponseType = ClosedEnum<
  typeof CreateProjectContentHintProjectsResponseType
>;

export type CreateProjectContentHint3 = {
  type: CreateProjectContentHintProjectsResponseType;
  storeId: string;
};

export const CreateProjectContentHintProjectsType = {
  RedisRestApiUrl: "redis-rest-api-url",
} as const;
export type CreateProjectContentHintProjectsType = ClosedEnum<
  typeof CreateProjectContentHintProjectsType
>;

export type CreateProjectContentHint2 = {
  type: CreateProjectContentHintProjectsType;
  storeId: string;
};

export const CreateProjectContentHintType = {
  RedisUrl: "redis-url",
} as const;
export type CreateProjectContentHintType = ClosedEnum<
  typeof CreateProjectContentHintType
>;

export type CreateProjectContentHint1 = {
  type: CreateProjectContentHintType;
  storeId: string;
};

export type CreateProjectContentHint =
  | CreateProjectContentHint1
  | CreateProjectContentHint2
  | CreateProjectContentHint3
  | CreateProjectContentHint4
  | CreateProjectContentHint5
  | CreateProjectContentHint6
  | CreateProjectContentHint7
  | CreateProjectContentHint8
  | CreateProjectContentHint9
  | CreateProjectContentHint10
  | ContentHint11
  | ContentHint12
  | ContentHint13
  | ContentHint15
  | ContentHint14;

export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType =
  {
    FlagsSecret: "flags-secret",
  } as const;
export type CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType =
  ClosedEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType
  >;

/**
 * Similar to `contentHints`, but should not be exposed to the user.
 */
export type CreateProjectInternalContentHint = {
  type: CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType;
  /**
   * Contains the `value` of the env variable, encrypted with a special key to make decryption possible in the subscriber Lambda.
   */
  encryptedValue: string;
};

export type CreateProjectEnv = {
  target?: Array<string> | CreateProjectTarget2 | undefined;
  type: CreateProjectProjectsResponseType;
  /**
   * This is used to identiy variables that have been migrated from type secret to sensitive.
   */
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | CreateProjectContentHint1
    | CreateProjectContentHint2
    | CreateProjectContentHint3
    | CreateProjectContentHint4
    | CreateProjectContentHint5
    | CreateProjectContentHint6
    | CreateProjectContentHint7
    | CreateProjectContentHint8
    | CreateProjectContentHint9
    | CreateProjectContentHint10
    | ContentHint11
    | ContentHint12
    | ContentHint13
    | ContentHint15
    | ContentHint14
    | null
    | undefined;
  /**
   * Similar to `contentHints`, but should not be exposed to the user.
   */
  internalContentHint?: CreateProjectInternalContentHint | null | undefined;
  /**
   * Whether `value` and `vsmValue` are decrypted.
   */
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

export type CreateProjectCustomEnvironments = {};

export const CreateProjectProjectsFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type CreateProjectProjectsFramework = ClosedEnum<
  typeof CreateProjectProjectsFramework
>;

export type CreateProjectIpBuckets = {
  bucket: string;
  supportUntil?: number | undefined;
};

export type CreateProjectAliasAssigned = number | boolean;

export type CreateProjectAliasError = {
  code: string;
  message: string;
};

export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType =
  {
    EndsWith: "endsWith",
    StartsWith: "startsWith",
    Equals: "equals",
  } as const;
export type CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType =
  ClosedEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType
  >;

export type CreateProjectBranchMatcher = {
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType;
  pattern: string;
};

export type CreateProjectBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const CreateProjectChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type CreateProjectChecksConclusion = ClosedEnum<
  typeof CreateProjectChecksConclusion
>;

export const CreateProjectChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type CreateProjectChecksState = ClosedEnum<
  typeof CreateProjectChecksState
>;

export type CreateProjectCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type CreateProjectOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const CreateProjectPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type CreateProjectPlan = ClosedEnum<typeof CreateProjectPlan>;

export const CreateProjectReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type CreateProjectReadyState = ClosedEnum<
  typeof CreateProjectReadyState
>;

export const CreateProjectReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type CreateProjectReadySubstate = ClosedEnum<
  typeof CreateProjectReadySubstate
>;

export const CreateProjectProjectsResponse200Type = {
  Lambdas: "LAMBDAS",
} as const;
export type CreateProjectProjectsResponse200Type = ClosedEnum<
  typeof CreateProjectProjectsResponse200Type
>;

export type CreateProjectLatestDeployments = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: CreateProjectAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: CreateProjectBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<CreateProjectBuilds> | undefined;
  checksConclusion?: CreateProjectChecksConclusion | undefined;
  checksState?: CreateProjectChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: CreateProjectCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: CreateProjectOidcTokenClaims | undefined;
  plan: CreateProjectPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: CreateProjectReadyState;
  readySubstate?: CreateProjectReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: CreateProjectProjectsResponse200Type;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export const CreateProjectLinkProjectsResponseType = {
  Bitbucket: "bitbucket",
} as const;
export type CreateProjectLinkProjectsResponseType = ClosedEnum<
  typeof CreateProjectLinkProjectsResponseType
>;

export type CreateProjectLinkProjectsResponseDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type CreateProjectLink3 = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: CreateProjectLinkProjectsResponseType | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<CreateProjectLinkProjectsResponseDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const CreateProjectLinkProjectsType = {
  Gitlab: "gitlab",
} as const;
export type CreateProjectLinkProjectsType = ClosedEnum<
  typeof CreateProjectLinkProjectsType
>;

export type CreateProjectLinkProjectsDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type CreateProjectLink2 = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes. This is the id of the top level group that a namespace belongs to. Gitlab supports group nesting (up to 20 levels).
   */
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: CreateProjectLinkProjectsType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<CreateProjectLinkProjectsDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export const CreateProjectLinkType = {
  Github: "github",
} as const;
export type CreateProjectLinkType = ClosedEnum<typeof CreateProjectLinkType>;

export type CreateProjectLinkDeployHooks = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

export type CreateProjectLink1 = {
  org?: string | undefined;
  /**
   * A new field, should be included in all new project links, is being added just in time when a deployment is created. This is needed for Protected Git scopes.
   */
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: CreateProjectLinkType | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<CreateProjectLinkDeployHooks>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

export type CreateProjectLink =
  | CreateProjectLink1
  | CreateProjectLink3
  | CreateProjectLink2;

/**
 * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
 */
export type CreateProjectGroup = {
  /**
   * A unique identifier for the group of microfrontends. All related microfrontend projects will share this group ID. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
   */
  id: string;
  /**
   * A human readable name for the microfrontends group. This will be used to display the microfrontends group in the UI.
   */
  slug: string;
};

export type CreateProjectMicrofrontends = {
  /**
   * Timestamp when the microfrontends settings were last updated.
   */
  updatedAt: number;
  /**
   * The group of microfrontends that this project belongs to. Each microfrontend project must belong to a microfrontends group that is the set of microfrontends that are used together.
   */
  group: CreateProjectGroup;
  /**
   * Whether microfrontends are enabled for this project.
   */
  enabled: boolean;
  /**
   * Whether this project is the default application for the microfrontends group. The default application is the one that is used as the top level shell for the microfrontends group and hosts the other microfrontends.
   */
  isDefaultApp?: boolean | undefined;
  /**
   * A path that is used to take screenshots and as the default path in preview links when a domain for this microfrontend is shown in the UI.
   */
  defaultRoute?: string | undefined;
};

export const CreateProjectNodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
  Eight10X: "8.10.x",
} as const;
export type CreateProjectNodeVersion = ClosedEnum<
  typeof CreateProjectNodeVersion
>;

export type CreateProjectPaths = {
  value: string;
};

export type CreateProjectOptionsAllowlist = {
  paths: Array<CreateProjectPaths>;
};

export type CreateProjectPasswordProtection = {};

export const CreateProjectFunctionDefaultMemoryType = {
  StandardLegacy: "standard_legacy",
  Standard: "standard",
  Performance: "performance",
} as const;
export type CreateProjectFunctionDefaultMemoryType = ClosedEnum<
  typeof CreateProjectFunctionDefaultMemoryType
>;

export type CreateProjectResourceConfig = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?:
    | CreateProjectFunctionDefaultMemoryType
    | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

export const CreateProjectDeploymentType = {
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type CreateProjectDeploymentType = ClosedEnum<
  typeof CreateProjectDeploymentType
>;

export type CreateProjectSsoProtection = {
  deploymentType: CreateProjectDeploymentType;
};

export type CreateProjectProjectsAliasAssigned = number | boolean;

export type CreateProjectProjectsAliasError = {
  code: string;
  message: string;
};

export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType =
  {
    EndsWith: "endsWith",
    StartsWith: "startsWith",
    Equals: "equals",
  } as const;
export type CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType =
  ClosedEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType
  >;

export type CreateProjectProjectsBranchMatcher = {
  type: CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType;
  pattern: string;
};

export type CreateProjectProjectsBuilds = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

export const CreateProjectProjectsChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type CreateProjectProjectsChecksConclusion = ClosedEnum<
  typeof CreateProjectProjectsChecksConclusion
>;

export const CreateProjectProjectsChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type CreateProjectProjectsChecksState = ClosedEnum<
  typeof CreateProjectProjectsChecksState
>;

export type CreateProjectProjectsCreator = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

export type CreateProjectProjectsOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export const CreateProjectProjectsPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type CreateProjectProjectsPlan = ClosedEnum<
  typeof CreateProjectProjectsPlan
>;

export const CreateProjectProjectsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type CreateProjectProjectsReadyState = ClosedEnum<
  typeof CreateProjectProjectsReadyState
>;

export const CreateProjectProjectsReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
export type CreateProjectProjectsReadySubstate = ClosedEnum<
  typeof CreateProjectProjectsReadySubstate
>;

export const CreateProjectProjectsResponse200ApplicationJSONType = {
  Lambdas: "LAMBDAS",
} as const;
export type CreateProjectProjectsResponse200ApplicationJSONType = ClosedEnum<
  typeof CreateProjectProjectsResponse200ApplicationJSONType
>;

export type CreateProjectTargets = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: CreateProjectProjectsAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: CreateProjectProjectsBranchMatcher | undefined;
  buildingAt?: number | undefined;
  builds?: Array<CreateProjectProjectsBuilds> | undefined;
  checksConclusion?: CreateProjectProjectsChecksConclusion | undefined;
  checksState?: CreateProjectProjectsChecksState | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: CreateProjectProjectsCreator | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: CreateProjectProjectsOidcTokenClaims | undefined;
  plan: CreateProjectProjectsPlan;
  /**
   * Whether or not preview comments are enabled for the deployment
   */
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: CreateProjectProjectsReadyState;
  readySubstate?: CreateProjectProjectsReadySubstate | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: CreateProjectProjectsResponse200ApplicationJSONType;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

export type CreateProjectPermissions = {
  accessGroup?: Array<ACLAction> | undefined;
  aliasGlobal?: Array<ACLAction> | undefined;
  analyticsSampling?: Array<ACLAction> | undefined;
  analyticsUsage?: Array<ACLAction> | undefined;
  auditLog?: Array<ACLAction> | undefined;
  billingAddress?: Array<ACLAction> | undefined;
  billingInformation?: Array<ACLAction> | undefined;
  billingInvoice?: Array<ACLAction> | undefined;
  billingInvoiceEmailRecipient?: Array<ACLAction> | undefined;
  billingInvoiceLanguage?: Array<ACLAction> | undefined;
  billingPlan?: Array<ACLAction> | undefined;
  billingPurchaseOrder?: Array<ACLAction> | undefined;
  billingTaxId?: Array<ACLAction> | undefined;
  blob?: Array<ACLAction> | undefined;
  budget?: Array<ACLAction> | undefined;
  cacheArtifact?: Array<ACLAction> | undefined;
  cacheArtifactUsageEvent?: Array<ACLAction> | undefined;
  codeChecks?: Array<ACLAction> | undefined;
  concurrentBuilds?: Array<ACLAction> | undefined;
  connect?: Array<ACLAction> | undefined;
  connectConfiguration?: Array<ACLAction> | undefined;
  domain?: Array<ACLAction> | undefined;
  domainAcceptDelegation?: Array<ACLAction> | undefined;
  domainAuthCodes?: Array<ACLAction> | undefined;
  domainCertificate?: Array<ACLAction> | undefined;
  domainCheckConfig?: Array<ACLAction> | undefined;
  domainMove?: Array<ACLAction> | undefined;
  domainPurchase?: Array<ACLAction> | undefined;
  domainRecord?: Array<ACLAction> | undefined;
  domainTransferIn?: Array<ACLAction> | undefined;
  event?: Array<ACLAction> | undefined;
  ownEvent?: Array<ACLAction> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<ACLAction> | undefined;
  fileUpload?: Array<ACLAction> | undefined;
  gitRepository?: Array<ACLAction> | undefined;
  ipBlocking?: Array<ACLAction> | undefined;
  integration?: Array<ACLAction> | undefined;
  integrationAccount?: Array<ACLAction> | undefined;
  integrationConfiguration?: Array<ACLAction> | undefined;
  integrationConfigurationTransfer?: Array<ACLAction> | undefined;
  integrationConfigurationProjects?: Array<ACLAction> | undefined;
  integrationVercelConfigurationOverride?: Array<ACLAction> | undefined;
  integrationConfigurationRole?: Array<ACLAction> | undefined;
  integrationResource?: Array<ACLAction> | undefined;
  integrationEvent?: Array<ACLAction> | undefined;
  integrationResourceSecrets?: Array<ACLAction> | undefined;
  integrationDeploymentAction?: Array<ACLAction> | undefined;
  marketplaceInstallationMember?: Array<ACLAction> | undefined;
  marketplaceBillingData?: Array<ACLAction> | undefined;
  marketplaceInvoice?: Array<ACLAction> | undefined;
  jobGlobal?: Array<ACLAction> | undefined;
  logDrain?: Array<ACLAction> | undefined;
  monitoring?: Array<ACLAction> | undefined;
  monitoringSettings?: Array<ACLAction> | undefined;
  monitoringQuery?: Array<ACLAction> | undefined;
  monitoringChart?: Array<ACLAction> | undefined;
  monitoringAlert?: Array<ACLAction> | undefined;
  notificationDeploymentFailed?: Array<ACLAction> | undefined;
  notificationDomainConfiguration?: Array<ACLAction> | undefined;
  notificationDomainExpire?: Array<ACLAction> | undefined;
  notificationDomainMoved?: Array<ACLAction> | undefined;
  notificationDomainPurchase?: Array<ACLAction> | undefined;
  notificationDomainRenewal?: Array<ACLAction> | undefined;
  notificationDomainTransfer?: Array<ACLAction> | undefined;
  notificationDomainUnverified?: Array<ACLAction> | undefined;
  notificationMonitoringAlert?: Array<ACLAction> | undefined;
  notificationPaymentFailed?: Array<ACLAction> | undefined;
  notificationUsageAlert?: Array<ACLAction> | undefined;
  notificationCustomerBudget?: Array<ACLAction> | undefined;
  notificationStatementOfReasons?: Array<ACLAction> | undefined;
  oauth2Connection?: Array<ACLAction> | undefined;
  openTelemetryEndpoint?: Array<ACLAction> | undefined;
  paymentMethod?: Array<ACLAction> | undefined;
  permissions?: Array<ACLAction> | undefined;
  postgres?: Array<ACLAction> | undefined;
  previewDeploymentSuffix?: Array<ACLAction> | undefined;
  proTrialOnboarding?: Array<ACLAction> | undefined;
  sharedEnvVars?: Array<ACLAction> | undefined;
  sharedEnvVarsProduction?: Array<ACLAction> | undefined;
  space?: Array<ACLAction> | undefined;
  spaceRun?: Array<ACLAction> | undefined;
  passwordProtectionInvoiceItem?: Array<ACLAction> | undefined;
  rateLimit?: Array<ACLAction> | undefined;
  redis?: Array<ACLAction> | undefined;
  repository?: Array<ACLAction> | undefined;
  remoteCaching?: Array<ACLAction> | undefined;
  samlConfig?: Array<ACLAction> | undefined;
  secret?: Array<ACLAction> | undefined;
  redisStoreTokenSet?: Array<ACLAction> | undefined;
  blobStoreTokenSet?: Array<ACLAction> | undefined;
  postgresStoreTokenSet?: Array<ACLAction> | undefined;
  integrationStoreTokenSet?: Array<ACLAction> | undefined;
  integrationResourceReplCommand?: Array<ACLAction> | undefined;
  storeTransfer?: Array<ACLAction> | undefined;
  supportCase?: Array<ACLAction> | undefined;
  supportCaseComment?: Array<ACLAction> | undefined;
  dataCacheBillingSettings?: Array<ACLAction> | undefined;
  team?: Array<ACLAction> | undefined;
  teamAccessRequest?: Array<ACLAction> | undefined;
  teamFellowMembership?: Array<ACLAction> | undefined;
  teamGitExclusivity?: Array<ACLAction> | undefined;
  teamInvite?: Array<ACLAction> | undefined;
  teamInviteCode?: Array<ACLAction> | undefined;
  teamJoin?: Array<ACLAction> | undefined;
  teamOwnMembership?: Array<ACLAction> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<ACLAction> | undefined;
  token?: Array<ACLAction> | undefined;
  usage?: Array<ACLAction> | undefined;
  usageCycle?: Array<ACLAction> | undefined;
  user?: Array<ACLAction> | undefined;
  userConnection?: Array<ACLAction> | undefined;
  vpcPeeringConnection?: Array<ACLAction> | undefined;
  webAnalyticsPlan?: Array<ACLAction> | undefined;
  webAuthn?: Array<ACLAction> | undefined;
  edgeConfig?: Array<ACLAction> | undefined;
  edgeConfigItem?: Array<ACLAction> | undefined;
  edgeConfigSchema?: Array<ACLAction> | undefined;
  edgeConfigToken?: Array<ACLAction> | undefined;
  webhook?: Array<ACLAction> | undefined;
  webhookEvent?: Array<ACLAction> | undefined;
  endpointVerification?: Array<ACLAction> | undefined;
  projectTransferIn?: Array<ACLAction> | undefined;
  oauth2Application?: Array<ACLAction> | undefined;
  aliasProject?: Array<ACLAction> | undefined;
  aliasProtectionBypass?: Array<ACLAction> | undefined;
  productionAliasProtectionBypass?: Array<ACLAction> | undefined;
  connectConfigurationLink?: Array<ACLAction> | undefined;
  dataCacheNamespace?: Array<ACLAction> | undefined;
  deployment?: Array<ACLAction> | undefined;
  deploymentCheck?: Array<ACLAction> | undefined;
  deploymentCheckPreview?: Array<ACLAction> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<ACLAction> | undefined;
  deploymentProductionGit?: Array<ACLAction> | undefined;
  deploymentPreview?: Array<ACLAction> | undefined;
  deploymentPrivate?: Array<ACLAction> | undefined;
  deploymentPromote?: Array<ACLAction> | undefined;
  deploymentRollback?: Array<ACLAction> | undefined;
  environments?: Array<ACLAction> | undefined;
  logs?: Array<ACLAction> | undefined;
  logsPreset?: Array<ACLAction> | undefined;
  passwordProtection?: Array<ACLAction> | undefined;
  optionsAllowlist?: Array<ACLAction> | undefined;
  job?: Array<ACLAction> | undefined;
  project?: Array<ACLAction> | undefined;
  projectAccessGroup?: Array<ACLAction> | undefined;
  projectAnalyticsSampling?: Array<ACLAction> | undefined;
  projectDeploymentHook?: Array<ACLAction> | undefined;
  projectDomain?: Array<ACLAction> | undefined;
  projectDomainMove?: Array<ACLAction> | undefined;
  projectDomainCheckConfig?: Array<ACLAction> | undefined;
  projectEnvVars?: Array<ACLAction> | undefined;
  projectEnvVarsProduction?: Array<ACLAction> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<ACLAction> | undefined;
  projectFlags?: Array<ACLAction> | undefined;
  projectId?: Array<ACLAction> | undefined;
  projectIntegrationConfiguration?: Array<ACLAction> | undefined;
  projectLink?: Array<ACLAction> | undefined;
  projectMember?: Array<ACLAction> | undefined;
  projectMonitoring?: Array<ACLAction> | undefined;
  projectPermissions?: Array<ACLAction> | undefined;
  projectProductionBranch?: Array<ACLAction> | undefined;
  projectTransfer?: Array<ACLAction> | undefined;
  projectTransferOut?: Array<ACLAction> | undefined;
  projectProtectionBypass?: Array<ACLAction> | undefined;
  projectUsage?: Array<ACLAction> | undefined;
  projectAnalyticsUsage?: Array<ACLAction> | undefined;
  projectSupportCase?: Array<ACLAction> | undefined;
  projectSupportCaseComment?: Array<ACLAction> | undefined;
  projectDeploymentExpiration?: Array<ACLAction> | undefined;
  projectTier?: Array<ACLAction> | undefined;
  seawallConfig?: Array<ACLAction> | undefined;
  skewProtection?: Array<ACLAction> | undefined;
  analytics?: Array<ACLAction> | undefined;
  trustedIps?: Array<ACLAction> | undefined;
  webAnalytics?: Array<ACLAction> | undefined;
  sharedEnvVarConnection?: Array<ACLAction> | undefined;
  sonar?: Array<ACLAction> | undefined;
};

export type CreateProjectLastRollbackTarget = {};

export const CreateProjectJobStatus = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Pending: "pending",
  InProgress: "in-progress",
} as const;
export type CreateProjectJobStatus = ClosedEnum<typeof CreateProjectJobStatus>;

export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyType = {
  Promote: "promote",
  Rollback: "rollback",
} as const;
export type CreateProjectProjectsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyType
  >;

export type CreateProjectLastAliasRequest = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: CreateProjectJobStatus;
  requestedAt: number;
  type: CreateProjectProjectsResponse200ApplicationJSONResponseBodyType;
};

export const CreateProjectScope = {
  AutomationBypass: "automation-bypass",
} as const;
export type CreateProjectScope = ClosedEnum<typeof CreateProjectScope>;

export type CreateProjectProtectionBypass = {
  createdAt: number;
  createdBy: string;
  scope: CreateProjectScope;
};

export const CreateProjectTrustedIpsProjectsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type CreateProjectTrustedIpsProjectsDeploymentType = ClosedEnum<
  typeof CreateProjectTrustedIpsProjectsDeploymentType
>;

export type CreateProjectTrustedIps2 = {
  deploymentType: CreateProjectTrustedIpsProjectsDeploymentType;
};

export const CreateProjectTrustedIpsDeploymentType = {
  Production: "production",
  Preview: "preview",
  All: "all",
  ProdDeploymentUrlsAndAllPreviews: "prod_deployment_urls_and_all_previews",
} as const;
export type CreateProjectTrustedIpsDeploymentType = ClosedEnum<
  typeof CreateProjectTrustedIpsDeploymentType
>;

export type TrustedIpsAddresses = {
  value: string;
  note?: string | undefined;
};

export const TrustedIpsProtectionMode = {
  Additional: "additional",
  Exclusive: "exclusive",
} as const;
export type TrustedIpsProtectionMode = ClosedEnum<
  typeof TrustedIpsProtectionMode
>;

export type CreateProjectTrustedIps1 = {
  deploymentType: CreateProjectTrustedIpsDeploymentType;
  addresses: Array<TrustedIpsAddresses>;
  protectionMode: TrustedIpsProtectionMode;
};

export type CreateProjectTrustedIps =
  | CreateProjectTrustedIps2
  | CreateProjectTrustedIps1;

export type CreateProjectGitComments = {
  /**
   * Whether the Vercel bot should comment on PRs
   */
  onPullRequest: boolean;
  /**
   * Whether the Vercel bot should comment on commits
   */
  onCommit: boolean;
};

export type CreateProjectWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type CreateProjectSrc2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type CreateProjectSrc = CreateProjectSrc2 | string;

export const CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType =
  ClosedEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType
  >;

export type CreateProjectValue2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type CreateProjectValue = CreateProjectValue2 | string;

export type CreateProjectHas = {
  type: CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType;
  key?: string | undefined;
  value?: CreateProjectValue2 | string | undefined;
};

export const CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType =
  {
    Path: "path",
    Host: "host",
    Method: "method",
    Header: "header",
    Cookie: "cookie",
    Query: "query",
    IpAddress: "ip_address",
    Protocol: "protocol",
    Scheme: "scheme",
    Environment: "environment",
    Region: "region",
  } as const;
export type CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType =
  ClosedEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  >;

export type CreateProjectValueProjects2 = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

export type CreateProjectProjectsValue = CreateProjectValueProjects2 | string;

export type CreateProjectMissing = {
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType;
  key?: string | undefined;
  value?: CreateProjectValueProjects2 | string | undefined;
};

export const CreateProjectHandle = {
  Init: "init",
  Finalize: "finalize",
} as const;
export type CreateProjectHandle = ClosedEnum<typeof CreateProjectHandle>;

export const CreateProjectAction = {
  Deny: "deny",
  Challenge: "challenge",
  Log: "log",
  Bypass: "bypass",
  RateLimit: "rate_limit",
  Redirect: "redirect",
} as const;
export type CreateProjectAction = ClosedEnum<typeof CreateProjectAction>;

export const CreateProjectAlgo = {
  FixedWindow: "fixed_window",
  TokenBucket: "token_bucket",
} as const;
export type CreateProjectAlgo = ClosedEnum<typeof CreateProjectAlgo>;

export type CreateProjectErl = {
  algo: CreateProjectAlgo;
  window: number;
  limit: number;
  keys: Array<string>;
};

export type CreateProjectMitigate = {
  action: CreateProjectAction;
  ruleId: string;
  ttl?: number | undefined;
  erl?: CreateProjectErl | undefined;
};

export type CreateProjectFirewallRoutes = {
  src?: CreateProjectSrc2 | string | undefined;
  has?: Array<CreateProjectHas> | undefined;
  missing?: Array<CreateProjectMissing> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: CreateProjectHandle | undefined;
  mitigate?: CreateProjectMitigate | undefined;
};

export type CreateProjectSecurity = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<CreateProjectFirewallRoutes> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export const CreateProjectIssuerMode = {
  Team: "team",
  Global: "global",
} as const;
/**
 * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
 */
export type CreateProjectIssuerMode = ClosedEnum<
  typeof CreateProjectIssuerMode
>;

export type CreateProjectOidcTokenConfig = {
  enabled: boolean;
  /**
   * - team: `https://oidc.vercel.com/[team_slug]` - global: `https://oidc.vercel.com`
   */
  issuerMode?: CreateProjectIssuerMode | undefined;
};

export const CreateProjectTier = {
  Standard: "standard",
  Advanced: "advanced",
  Critical: "critical",
} as const;
export type CreateProjectTier = ClosedEnum<typeof CreateProjectTier>;

/**
 * The project was successfuly created
 */
export type CreateProjectResponseBody = {
  accountId: string;
  analytics?: CreateProjectAnalytics | undefined;
  speedInsights?: CreateProjectSpeedInsights | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: CreateProjectCrons | undefined;
  dataCache?: CreateProjectDataCache | undefined;
  deploymentExpiration?: CreateProjectDeploymentExpiration | null | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<CreateProjectEnv> | undefined;
  customEnvironments?: Array<CreateProjectCustomEnvironments> | undefined;
  framework?: CreateProjectProjectsFramework | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<CreateProjectIpBuckets> | undefined;
  latestDeployments?: Array<CreateProjectLatestDeployments> | undefined;
  link?:
    | CreateProjectLink1
    | CreateProjectLink3
    | CreateProjectLink2
    | undefined;
  microfrontends?: CreateProjectMicrofrontends | undefined;
  name: string;
  nodeVersion: CreateProjectNodeVersion;
  optionsAllowlist?: CreateProjectOptionsAllowlist | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?: CreateProjectPasswordProtection | null | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: CreateProjectResourceConfig | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: CreateProjectSsoProtection | null | undefined;
  targets?: { [k: string]: CreateProjectTargets } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: CreateProjectPermissions | undefined;
  lastRollbackTarget?: CreateProjectLastRollbackTarget | null | undefined;
  lastAliasRequest?: CreateProjectLastAliasRequest | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?: { [k: string]: CreateProjectProtectionBypass } | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?:
    | CreateProjectTrustedIps2
    | CreateProjectTrustedIps1
    | null
    | undefined;
  gitComments?: CreateProjectGitComments | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: CreateProjectWebAnalytics | undefined;
  security?: CreateProjectSecurity | undefined;
  oidcTokenConfig?: CreateProjectOidcTokenConfig | undefined;
  tier?: CreateProjectTier | undefined;
};

/** @internal */
export const Target2$inboundSchema: z.ZodNativeEnum<typeof Target2> = z
  .nativeEnum(Target2);

/** @internal */
export const Target2$outboundSchema: z.ZodNativeEnum<typeof Target2> =
  Target2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Target2$ {
  /** @deprecated use `Target2$inboundSchema` instead. */
  export const inboundSchema = Target2$inboundSchema;
  /** @deprecated use `Target2$outboundSchema` instead. */
  export const outboundSchema = Target2$outboundSchema;
}

/** @internal */
export const Target1$inboundSchema: z.ZodNativeEnum<typeof Target1> = z
  .nativeEnum(Target1);

/** @internal */
export const Target1$outboundSchema: z.ZodNativeEnum<typeof Target1> =
  Target1$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Target1$ {
  /** @deprecated use `Target1$inboundSchema` instead. */
  export const inboundSchema = Target1$inboundSchema;
  /** @deprecated use `Target1$outboundSchema` instead. */
  export const outboundSchema = Target1$outboundSchema;
}

/** @internal */
export const CreateProjectTarget$inboundSchema: z.ZodType<
  CreateProjectTarget,
  z.ZodTypeDef,
  unknown
> = z.union([Target1$inboundSchema, z.array(Target2$inboundSchema)]);

/** @internal */
export type CreateProjectTarget$Outbound = string | Array<string>;

/** @internal */
export const CreateProjectTarget$outboundSchema: z.ZodType<
  CreateProjectTarget$Outbound,
  z.ZodTypeDef,
  CreateProjectTarget
> = z.union([Target1$outboundSchema, z.array(Target2$outboundSchema)]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTarget$ {
  /** @deprecated use `CreateProjectTarget$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTarget$inboundSchema;
  /** @deprecated use `CreateProjectTarget$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTarget$outboundSchema;
  /** @deprecated use `CreateProjectTarget$Outbound` instead. */
  export type Outbound = CreateProjectTarget$Outbound;
}

/** @internal */
export const CreateProjectType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectType
> = z.nativeEnum(CreateProjectType);

/** @internal */
export const CreateProjectType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectType
> = CreateProjectType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectType$ {
  /** @deprecated use `CreateProjectType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectType$inboundSchema;
  /** @deprecated use `CreateProjectType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectType$outboundSchema;
}

/** @internal */
export const EnvironmentVariables$inboundSchema: z.ZodType<
  EnvironmentVariables,
  z.ZodTypeDef,
  unknown
> = z.object({
  key: z.string(),
  target: z.union([Target1$inboundSchema, z.array(Target2$inboundSchema)]),
  gitBranch: z.string().optional(),
  type: CreateProjectType$inboundSchema.optional(),
  value: z.string(),
});

/** @internal */
export type EnvironmentVariables$Outbound = {
  key: string;
  target: string | Array<string>;
  gitBranch?: string | undefined;
  type?: string | undefined;
  value: string;
};

/** @internal */
export const EnvironmentVariables$outboundSchema: z.ZodType<
  EnvironmentVariables$Outbound,
  z.ZodTypeDef,
  EnvironmentVariables
> = z.object({
  key: z.string(),
  target: z.union([Target1$outboundSchema, z.array(Target2$outboundSchema)]),
  gitBranch: z.string().optional(),
  type: CreateProjectType$outboundSchema.optional(),
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace EnvironmentVariables$ {
  /** @deprecated use `EnvironmentVariables$inboundSchema` instead. */
  export const inboundSchema = EnvironmentVariables$inboundSchema;
  /** @deprecated use `EnvironmentVariables$outboundSchema` instead. */
  export const outboundSchema = EnvironmentVariables$outboundSchema;
  /** @deprecated use `EnvironmentVariables$Outbound` instead. */
  export type Outbound = EnvironmentVariables$Outbound;
}

/** @internal */
export const CreateProjectFramework$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectFramework
> = z.nativeEnum(CreateProjectFramework);

/** @internal */
export const CreateProjectFramework$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectFramework
> = CreateProjectFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectFramework$ {
  /** @deprecated use `CreateProjectFramework$inboundSchema` instead. */
  export const inboundSchema = CreateProjectFramework$inboundSchema;
  /** @deprecated use `CreateProjectFramework$outboundSchema` instead. */
  export const outboundSchema = CreateProjectFramework$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsType
> = z.nativeEnum(CreateProjectProjectsType);

/** @internal */
export const CreateProjectProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsType
> = CreateProjectProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsType$ {
  /** @deprecated use `CreateProjectProjectsType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsType$outboundSchema;
}

/** @internal */
export const GitRepository$inboundSchema: z.ZodType<
  GitRepository,
  z.ZodTypeDef,
  unknown
> = z.object({
  repo: z.string(),
  type: CreateProjectProjectsType$inboundSchema,
});

/** @internal */
export type GitRepository$Outbound = {
  repo: string;
  type: string;
};

/** @internal */
export const GitRepository$outboundSchema: z.ZodType<
  GitRepository$Outbound,
  z.ZodTypeDef,
  GitRepository
> = z.object({
  repo: z.string(),
  type: CreateProjectProjectsType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepository$ {
  /** @deprecated use `GitRepository$inboundSchema` instead. */
  export const inboundSchema = GitRepository$inboundSchema;
  /** @deprecated use `GitRepository$outboundSchema` instead. */
  export const outboundSchema = GitRepository$outboundSchema;
  /** @deprecated use `GitRepository$Outbound` instead. */
  export type Outbound = GitRepository$Outbound;
}

/** @internal */
export const IssuerMode$inboundSchema: z.ZodNativeEnum<typeof IssuerMode> = z
  .nativeEnum(IssuerMode);

/** @internal */
export const IssuerMode$outboundSchema: z.ZodNativeEnum<typeof IssuerMode> =
  IssuerMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace IssuerMode$ {
  /** @deprecated use `IssuerMode$inboundSchema` instead. */
  export const inboundSchema = IssuerMode$inboundSchema;
  /** @deprecated use `IssuerMode$outboundSchema` instead. */
  export const outboundSchema = IssuerMode$outboundSchema;
}

/** @internal */
export const OidcTokenConfig$inboundSchema: z.ZodType<
  OidcTokenConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean(),
  issuerMode: IssuerMode$inboundSchema.default("global"),
});

/** @internal */
export type OidcTokenConfig$Outbound = {
  enabled: boolean;
  issuerMode: string;
};

/** @internal */
export const OidcTokenConfig$outboundSchema: z.ZodType<
  OidcTokenConfig$Outbound,
  z.ZodTypeDef,
  OidcTokenConfig
> = z.object({
  enabled: z.boolean(),
  issuerMode: IssuerMode$outboundSchema.default("global"),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace OidcTokenConfig$ {
  /** @deprecated use `OidcTokenConfig$inboundSchema` instead. */
  export const inboundSchema = OidcTokenConfig$inboundSchema;
  /** @deprecated use `OidcTokenConfig$outboundSchema` instead. */
  export const outboundSchema = OidcTokenConfig$outboundSchema;
  /** @deprecated use `OidcTokenConfig$Outbound` instead. */
  export type Outbound = OidcTokenConfig$Outbound;
}

/** @internal */
export const CreateProjectRequestBody$inboundSchema: z.ZodType<
  CreateProjectRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  environmentVariables: z.array(
    z.lazy(() => EnvironmentVariables$inboundSchema),
  ).optional(),
  framework: CreateProjectFramework$inboundSchema.optional(),
  gitRepository: z.lazy(() => GitRepository$inboundSchema).optional(),
  installCommand: z.nullable(z.string()).optional(),
  name: z.string(),
  skipGitConnectDuringLink: z.boolean().optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  oidcTokenConfig: z.lazy(() => OidcTokenConfig$inboundSchema).optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
});

/** @internal */
export type CreateProjectRequestBody$Outbound = {
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  devCommand?: string | null | undefined;
  environmentVariables?: Array<EnvironmentVariables$Outbound> | undefined;
  framework?: string | undefined;
  gitRepository?: GitRepository$Outbound | undefined;
  installCommand?: string | null | undefined;
  name: string;
  skipGitConnectDuringLink?: boolean | undefined;
  outputDirectory?: string | null | undefined;
  publicSource?: boolean | null | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  oidcTokenConfig?: OidcTokenConfig$Outbound | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
};

/** @internal */
export const CreateProjectRequestBody$outboundSchema: z.ZodType<
  CreateProjectRequestBody$Outbound,
  z.ZodTypeDef,
  CreateProjectRequestBody
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  environmentVariables: z.array(
    z.lazy(() => EnvironmentVariables$outboundSchema),
  ).optional(),
  framework: CreateProjectFramework$outboundSchema.optional(),
  gitRepository: z.lazy(() => GitRepository$outboundSchema).optional(),
  installCommand: z.nullable(z.string()).optional(),
  name: z.string(),
  skipGitConnectDuringLink: z.boolean().optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  oidcTokenConfig: z.lazy(() => OidcTokenConfig$outboundSchema).optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectRequestBody$ {
  /** @deprecated use `CreateProjectRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateProjectRequestBody$inboundSchema;
  /** @deprecated use `CreateProjectRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateProjectRequestBody$outboundSchema;
  /** @deprecated use `CreateProjectRequestBody$Outbound` instead. */
  export type Outbound = CreateProjectRequestBody$Outbound;
}

/** @internal */
export const CreateProjectRequest$inboundSchema: z.ZodType<
  CreateProjectRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => CreateProjectRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateProjectRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: CreateProjectRequestBody$Outbound | undefined;
};

/** @internal */
export const CreateProjectRequest$outboundSchema: z.ZodType<
  CreateProjectRequest$Outbound,
  z.ZodTypeDef,
  CreateProjectRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => CreateProjectRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectRequest$ {
  /** @deprecated use `CreateProjectRequest$inboundSchema` instead. */
  export const inboundSchema = CreateProjectRequest$inboundSchema;
  /** @deprecated use `CreateProjectRequest$outboundSchema` instead. */
  export const outboundSchema = CreateProjectRequest$outboundSchema;
  /** @deprecated use `CreateProjectRequest$Outbound` instead. */
  export type Outbound = CreateProjectRequest$Outbound;
}

/** @internal */
export const CreateProjectAnalytics$inboundSchema: z.ZodType<
  CreateProjectAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/** @internal */
export type CreateProjectAnalytics$Outbound = {
  id: string;
  canceledAt?: number | null | undefined;
  disabledAt: number;
  enabledAt: number;
  paidAt?: number | undefined;
  sampleRatePercent?: number | null | undefined;
  spendLimitInDollars?: number | null | undefined;
};

/** @internal */
export const CreateProjectAnalytics$outboundSchema: z.ZodType<
  CreateProjectAnalytics$Outbound,
  z.ZodTypeDef,
  CreateProjectAnalytics
> = z.object({
  id: z.string(),
  canceledAt: z.nullable(z.number()).optional(),
  disabledAt: z.number(),
  enabledAt: z.number(),
  paidAt: z.number().optional(),
  sampleRatePercent: z.nullable(z.number()).optional(),
  spendLimitInDollars: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectAnalytics$ {
  /** @deprecated use `CreateProjectAnalytics$inboundSchema` instead. */
  export const inboundSchema = CreateProjectAnalytics$inboundSchema;
  /** @deprecated use `CreateProjectAnalytics$outboundSchema` instead. */
  export const outboundSchema = CreateProjectAnalytics$outboundSchema;
  /** @deprecated use `CreateProjectAnalytics$Outbound` instead. */
  export type Outbound = CreateProjectAnalytics$Outbound;
}

/** @internal */
export const CreateProjectSpeedInsights$inboundSchema: z.ZodType<
  CreateProjectSpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type CreateProjectSpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const CreateProjectSpeedInsights$outboundSchema: z.ZodType<
  CreateProjectSpeedInsights$Outbound,
  z.ZodTypeDef,
  CreateProjectSpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectSpeedInsights$ {
  /** @deprecated use `CreateProjectSpeedInsights$inboundSchema` instead. */
  export const inboundSchema = CreateProjectSpeedInsights$inboundSchema;
  /** @deprecated use `CreateProjectSpeedInsights$outboundSchema` instead. */
  export const outboundSchema = CreateProjectSpeedInsights$outboundSchema;
  /** @deprecated use `CreateProjectSpeedInsights$Outbound` instead. */
  export type Outbound = CreateProjectSpeedInsights$Outbound;
}

/** @internal */
export const CreateProjectDefinitions$inboundSchema: z.ZodType<
  CreateProjectDefinitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/** @internal */
export type CreateProjectDefinitions$Outbound = {
  host: string;
  path: string;
  schedule: string;
};

/** @internal */
export const CreateProjectDefinitions$outboundSchema: z.ZodType<
  CreateProjectDefinitions$Outbound,
  z.ZodTypeDef,
  CreateProjectDefinitions
> = z.object({
  host: z.string(),
  path: z.string(),
  schedule: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectDefinitions$ {
  /** @deprecated use `CreateProjectDefinitions$inboundSchema` instead. */
  export const inboundSchema = CreateProjectDefinitions$inboundSchema;
  /** @deprecated use `CreateProjectDefinitions$outboundSchema` instead. */
  export const outboundSchema = CreateProjectDefinitions$outboundSchema;
  /** @deprecated use `CreateProjectDefinitions$Outbound` instead. */
  export type Outbound = CreateProjectDefinitions$Outbound;
}

/** @internal */
export const CreateProjectCrons$inboundSchema: z.ZodType<
  CreateProjectCrons,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => CreateProjectDefinitions$inboundSchema)),
});

/** @internal */
export type CreateProjectCrons$Outbound = {
  enabledAt: number;
  disabledAt: number | null;
  updatedAt: number;
  deploymentId: string | null;
  definitions: Array<CreateProjectDefinitions$Outbound>;
};

/** @internal */
export const CreateProjectCrons$outboundSchema: z.ZodType<
  CreateProjectCrons$Outbound,
  z.ZodTypeDef,
  CreateProjectCrons
> = z.object({
  enabledAt: z.number(),
  disabledAt: z.nullable(z.number()),
  updatedAt: z.number(),
  deploymentId: z.nullable(z.string()),
  definitions: z.array(z.lazy(() => CreateProjectDefinitions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectCrons$ {
  /** @deprecated use `CreateProjectCrons$inboundSchema` instead. */
  export const inboundSchema = CreateProjectCrons$inboundSchema;
  /** @deprecated use `CreateProjectCrons$outboundSchema` instead. */
  export const outboundSchema = CreateProjectCrons$outboundSchema;
  /** @deprecated use `CreateProjectCrons$Outbound` instead. */
  export type Outbound = CreateProjectCrons$Outbound;
}

/** @internal */
export const CreateProjectDataCache$inboundSchema: z.ZodType<
  CreateProjectDataCache,
  z.ZodTypeDef,
  unknown
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/** @internal */
export type CreateProjectDataCache$Outbound = {
  userDisabled: boolean;
  storageSizeBytes?: number | null | undefined;
  unlimited?: boolean | undefined;
};

/** @internal */
export const CreateProjectDataCache$outboundSchema: z.ZodType<
  CreateProjectDataCache$Outbound,
  z.ZodTypeDef,
  CreateProjectDataCache
> = z.object({
  userDisabled: z.boolean(),
  storageSizeBytes: z.nullable(z.number()).optional(),
  unlimited: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectDataCache$ {
  /** @deprecated use `CreateProjectDataCache$inboundSchema` instead. */
  export const inboundSchema = CreateProjectDataCache$inboundSchema;
  /** @deprecated use `CreateProjectDataCache$outboundSchema` instead. */
  export const outboundSchema = CreateProjectDataCache$outboundSchema;
  /** @deprecated use `CreateProjectDataCache$Outbound` instead. */
  export type Outbound = CreateProjectDataCache$Outbound;
}

/** @internal */
export const CreateProjectDeploymentExpiration$inboundSchema: z.ZodType<
  CreateProjectDeploymentExpiration,
  z.ZodTypeDef,
  unknown
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/** @internal */
export type CreateProjectDeploymentExpiration$Outbound = {
  expirationDays?: number | undefined;
  expirationDaysProduction?: number | undefined;
  expirationDaysCanceled?: number | undefined;
  expirationDaysErrored?: number | undefined;
  deploymentsToKeep?: number | undefined;
};

/** @internal */
export const CreateProjectDeploymentExpiration$outboundSchema: z.ZodType<
  CreateProjectDeploymentExpiration$Outbound,
  z.ZodTypeDef,
  CreateProjectDeploymentExpiration
> = z.object({
  expirationDays: z.number().optional(),
  expirationDaysProduction: z.number().optional(),
  expirationDaysCanceled: z.number().optional(),
  expirationDaysErrored: z.number().optional(),
  deploymentsToKeep: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectDeploymentExpiration$ {
  /** @deprecated use `CreateProjectDeploymentExpiration$inboundSchema` instead. */
  export const inboundSchema = CreateProjectDeploymentExpiration$inboundSchema;
  /** @deprecated use `CreateProjectDeploymentExpiration$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectDeploymentExpiration$outboundSchema;
  /** @deprecated use `CreateProjectDeploymentExpiration$Outbound` instead. */
  export type Outbound = CreateProjectDeploymentExpiration$Outbound;
}

/** @internal */
export const CreateProjectTarget2$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectTarget2
> = z.nativeEnum(CreateProjectTarget2);

/** @internal */
export const CreateProjectTarget2$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectTarget2
> = CreateProjectTarget2$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTarget2$ {
  /** @deprecated use `CreateProjectTarget2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTarget2$inboundSchema;
  /** @deprecated use `CreateProjectTarget2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTarget2$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsTarget$inboundSchema: z.ZodType<
  CreateProjectProjectsTarget,
  z.ZodTypeDef,
  unknown
> = z.union([z.array(z.string()), CreateProjectTarget2$inboundSchema]);

/** @internal */
export type CreateProjectProjectsTarget$Outbound = Array<string> | string;

/** @internal */
export const CreateProjectProjectsTarget$outboundSchema: z.ZodType<
  CreateProjectProjectsTarget$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsTarget
> = z.union([z.array(z.string()), CreateProjectTarget2$outboundSchema]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsTarget$ {
  /** @deprecated use `CreateProjectProjectsTarget$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsTarget$inboundSchema;
  /** @deprecated use `CreateProjectProjectsTarget$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsTarget$outboundSchema;
  /** @deprecated use `CreateProjectProjectsTarget$Outbound` instead. */
  export type Outbound = CreateProjectProjectsTarget$Outbound;
}

/** @internal */
export const CreateProjectProjectsResponseType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsResponseType
> = z.nativeEnum(CreateProjectProjectsResponseType);

/** @internal */
export const CreateProjectProjectsResponseType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsResponseType
> = CreateProjectProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponseType$ {
  /** @deprecated use `CreateProjectProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsResponseType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponseType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema;
}

/** @internal */
export const ContentHint15$inboundSchema: z.ZodType<
  ContentHint15,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$inboundSchema,
  projectId: z.string(),
});

/** @internal */
export type ContentHint15$Outbound = {
  type: string;
  projectId: string;
};

/** @internal */
export const ContentHint15$outboundSchema: z.ZodType<
  ContentHint15$Outbound,
  z.ZodTypeDef,
  ContentHint15
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv15Type$outboundSchema,
  projectId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint15$ {
  /** @deprecated use `ContentHint15$inboundSchema` instead. */
  export const inboundSchema = ContentHint15$inboundSchema;
  /** @deprecated use `ContentHint15$outboundSchema` instead. */
  export const outboundSchema = ContentHint15$outboundSchema;
  /** @deprecated use `ContentHint15$Outbound` instead. */
  export type Outbound = ContentHint15$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema;
}

/** @internal */
export const ContentHint14$inboundSchema: z.ZodType<
  ContentHint14,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$inboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/** @internal */
export type ContentHint14$Outbound = {
  type: string;
  storeId: string;
  integrationId: string;
  integrationProductId: string;
  integrationConfigurationId: string;
};

/** @internal */
export const ContentHint14$outboundSchema: z.ZodType<
  ContentHint14$Outbound,
  z.ZodTypeDef,
  ContentHint14
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv14Type$outboundSchema,
  storeId: z.string(),
  integrationId: z.string(),
  integrationProductId: z.string(),
  integrationConfigurationId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint14$ {
  /** @deprecated use `ContentHint14$inboundSchema` instead. */
  export const inboundSchema = ContentHint14$inboundSchema;
  /** @deprecated use `ContentHint14$outboundSchema` instead. */
  export const outboundSchema = ContentHint14$outboundSchema;
  /** @deprecated use `ContentHint14$Outbound` instead. */
  export type Outbound = ContentHint14$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema;
}

/** @internal */
export const ContentHint13$inboundSchema: z.ZodType<
  ContentHint13,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint13$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint13$outboundSchema: z.ZodType<
  ContentHint13$Outbound,
  z.ZodTypeDef,
  ContentHint13
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv13Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint13$ {
  /** @deprecated use `ContentHint13$inboundSchema` instead. */
  export const inboundSchema = ContentHint13$inboundSchema;
  /** @deprecated use `ContentHint13$outboundSchema` instead. */
  export const outboundSchema = ContentHint13$outboundSchema;
  /** @deprecated use `ContentHint13$Outbound` instead. */
  export type Outbound = ContentHint13$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema;
}

/** @internal */
export const ContentHint12$inboundSchema: z.ZodType<
  ContentHint12,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint12$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint12$outboundSchema: z.ZodType<
  ContentHint12$Outbound,
  z.ZodTypeDef,
  ContentHint12
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv12Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint12$ {
  /** @deprecated use `ContentHint12$inboundSchema` instead. */
  export const inboundSchema = ContentHint12$inboundSchema;
  /** @deprecated use `ContentHint12$outboundSchema` instead. */
  export const outboundSchema = ContentHint12$outboundSchema;
  /** @deprecated use `ContentHint12$Outbound` instead. */
  export type Outbound = ContentHint12$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema;
}

/** @internal */
export const ContentHint11$inboundSchema: z.ZodType<
  ContentHint11,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type ContentHint11$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const ContentHint11$outboundSchema: z.ZodType<
  ContentHint11$Outbound,
  z.ZodTypeDef,
  ContentHint11
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv11Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ContentHint11$ {
  /** @deprecated use `ContentHint11$inboundSchema` instead. */
  export const inboundSchema = ContentHint11$inboundSchema;
  /** @deprecated use `ContentHint11$outboundSchema` instead. */
  export const outboundSchema = ContentHint11$outboundSchema;
  /** @deprecated use `ContentHint11$Outbound` instead. */
  export type Outbound = ContentHint11$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint10$inboundSchema: z.ZodType<
  CreateProjectContentHint10,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint10$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint10$outboundSchema: z.ZodType<
  CreateProjectContentHint10$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint10
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv10Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint10$ {
  /** @deprecated use `CreateProjectContentHint10$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint10$inboundSchema;
  /** @deprecated use `CreateProjectContentHint10$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint10$outboundSchema;
  /** @deprecated use `CreateProjectContentHint10$Outbound` instead. */
  export type Outbound = CreateProjectContentHint10$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint9$inboundSchema: z.ZodType<
  CreateProjectContentHint9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint9$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint9$outboundSchema: z.ZodType<
  CreateProjectContentHint9$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint9
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv9Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint9$ {
  /** @deprecated use `CreateProjectContentHint9$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint9$inboundSchema;
  /** @deprecated use `CreateProjectContentHint9$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint9$outboundSchema;
  /** @deprecated use `CreateProjectContentHint9$Outbound` instead. */
  export type Outbound = CreateProjectContentHint9$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint8$inboundSchema: z.ZodType<
  CreateProjectContentHint8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint8$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint8$outboundSchema: z.ZodType<
  CreateProjectContentHint8$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint8
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnv8Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint8$ {
  /** @deprecated use `CreateProjectContentHint8$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint8$inboundSchema;
  /** @deprecated use `CreateProjectContentHint8$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint8$outboundSchema;
  /** @deprecated use `CreateProjectContentHint8$Outbound` instead. */
  export type Outbound = CreateProjectContentHint8$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint7$inboundSchema: z.ZodType<
  CreateProjectContentHint7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint7$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint7$outboundSchema: z.ZodType<
  CreateProjectContentHint7$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint7
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint7$ {
  /** @deprecated use `CreateProjectContentHint7$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint7$inboundSchema;
  /** @deprecated use `CreateProjectContentHint7$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint7$outboundSchema;
  /** @deprecated use `CreateProjectContentHint7$Outbound` instead. */
  export type Outbound = CreateProjectContentHint7$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint6$inboundSchema: z.ZodType<
  CreateProjectContentHint6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint6$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint6$outboundSchema: z.ZodType<
  CreateProjectContentHint6$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint6
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint6$ {
  /** @deprecated use `CreateProjectContentHint6$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint6$inboundSchema;
  /** @deprecated use `CreateProjectContentHint6$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint6$outboundSchema;
  /** @deprecated use `CreateProjectContentHint6$Outbound` instead. */
  export type Outbound = CreateProjectContentHint6$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONType
  > = z.nativeEnum(
    CreateProjectContentHintProjectsResponse200ApplicationJSONType,
  );

/** @internal */
export const CreateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectContentHintProjectsResponse200ApplicationJSONType
  > =
    CreateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint5$inboundSchema: z.ZodType<
  CreateProjectContentHint5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint5$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint5$outboundSchema: z.ZodType<
  CreateProjectContentHint5$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint5
> = z.object({
  type:
    CreateProjectContentHintProjectsResponse200ApplicationJSONType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint5$ {
  /** @deprecated use `CreateProjectContentHint5$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint5$inboundSchema;
  /** @deprecated use `CreateProjectContentHint5$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint5$outboundSchema;
  /** @deprecated use `CreateProjectContentHint5$Outbound` instead. */
  export type Outbound = CreateProjectContentHint5$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectContentHintProjectsResponse200Type> = z
    .nativeEnum(CreateProjectContentHintProjectsResponse200Type);

/** @internal */
export const CreateProjectContentHintProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectContentHintProjectsResponse200Type> =
    CreateProjectContentHintProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponse200Type$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponse200Type$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint4$inboundSchema: z.ZodType<
  CreateProjectContentHint4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectContentHintProjectsResponse200Type$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint4$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint4$outboundSchema: z.ZodType<
  CreateProjectContentHint4$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint4
> = z.object({
  type: CreateProjectContentHintProjectsResponse200Type$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint4$ {
  /** @deprecated use `CreateProjectContentHint4$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint4$inboundSchema;
  /** @deprecated use `CreateProjectContentHint4$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint4$outboundSchema;
  /** @deprecated use `CreateProjectContentHint4$Outbound` instead. */
  export type Outbound = CreateProjectContentHint4$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectContentHintProjectsResponseType> = z
    .nativeEnum(CreateProjectContentHintProjectsResponseType);

/** @internal */
export const CreateProjectContentHintProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectContentHintProjectsResponseType> =
    CreateProjectContentHintProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsResponseType$ {
  /** @deprecated use `CreateProjectContentHintProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsResponseType$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsResponseType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint3$inboundSchema: z.ZodType<
  CreateProjectContentHint3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectContentHintProjectsResponseType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint3$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint3$outboundSchema: z.ZodType<
  CreateProjectContentHint3$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint3
> = z.object({
  type: CreateProjectContentHintProjectsResponseType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint3$ {
  /** @deprecated use `CreateProjectContentHint3$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint3$inboundSchema;
  /** @deprecated use `CreateProjectContentHint3$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint3$outboundSchema;
  /** @deprecated use `CreateProjectContentHint3$Outbound` instead. */
  export type Outbound = CreateProjectContentHint3$Outbound;
}

/** @internal */
export const CreateProjectContentHintProjectsType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectContentHintProjectsType> = z.nativeEnum(
    CreateProjectContentHintProjectsType,
  );

/** @internal */
export const CreateProjectContentHintProjectsType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectContentHintProjectsType> =
    CreateProjectContentHintProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintProjectsType$ {
  /** @deprecated use `CreateProjectContentHintProjectsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectContentHintProjectsType$inboundSchema;
  /** @deprecated use `CreateProjectContentHintProjectsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectContentHintProjectsType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint2$inboundSchema: z.ZodType<
  CreateProjectContentHint2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectContentHintProjectsType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint2$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint2$outboundSchema: z.ZodType<
  CreateProjectContentHint2$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint2
> = z.object({
  type: CreateProjectContentHintProjectsType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint2$ {
  /** @deprecated use `CreateProjectContentHint2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint2$inboundSchema;
  /** @deprecated use `CreateProjectContentHint2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint2$outboundSchema;
  /** @deprecated use `CreateProjectContentHint2$Outbound` instead. */
  export type Outbound = CreateProjectContentHint2$Outbound;
}

/** @internal */
export const CreateProjectContentHintType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectContentHintType
> = z.nativeEnum(CreateProjectContentHintType);

/** @internal */
export const CreateProjectContentHintType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectContentHintType
> = CreateProjectContentHintType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHintType$ {
  /** @deprecated use `CreateProjectContentHintType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHintType$inboundSchema;
  /** @deprecated use `CreateProjectContentHintType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHintType$outboundSchema;
}

/** @internal */
export const CreateProjectContentHint1$inboundSchema: z.ZodType<
  CreateProjectContentHint1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateProjectContentHintType$inboundSchema,
  storeId: z.string(),
});

/** @internal */
export type CreateProjectContentHint1$Outbound = {
  type: string;
  storeId: string;
};

/** @internal */
export const CreateProjectContentHint1$outboundSchema: z.ZodType<
  CreateProjectContentHint1$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint1
> = z.object({
  type: CreateProjectContentHintType$outboundSchema,
  storeId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint1$ {
  /** @deprecated use `CreateProjectContentHint1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint1$inboundSchema;
  /** @deprecated use `CreateProjectContentHint1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint1$outboundSchema;
  /** @deprecated use `CreateProjectContentHint1$Outbound` instead. */
  export type Outbound = CreateProjectContentHint1$Outbound;
}

/** @internal */
export const CreateProjectContentHint$inboundSchema: z.ZodType<
  CreateProjectContentHint,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectContentHint1$inboundSchema),
  z.lazy(() => CreateProjectContentHint2$inboundSchema),
  z.lazy(() => CreateProjectContentHint3$inboundSchema),
  z.lazy(() => CreateProjectContentHint4$inboundSchema),
  z.lazy(() => CreateProjectContentHint5$inboundSchema),
  z.lazy(() => CreateProjectContentHint6$inboundSchema),
  z.lazy(() => CreateProjectContentHint7$inboundSchema),
  z.lazy(() => CreateProjectContentHint8$inboundSchema),
  z.lazy(() => CreateProjectContentHint9$inboundSchema),
  z.lazy(() => CreateProjectContentHint10$inboundSchema),
  z.lazy(() => ContentHint11$inboundSchema),
  z.lazy(() => ContentHint12$inboundSchema),
  z.lazy(() => ContentHint13$inboundSchema),
  z.lazy(() => ContentHint15$inboundSchema),
  z.lazy(() => ContentHint14$inboundSchema),
]);

/** @internal */
export type CreateProjectContentHint$Outbound =
  | CreateProjectContentHint1$Outbound
  | CreateProjectContentHint2$Outbound
  | CreateProjectContentHint3$Outbound
  | CreateProjectContentHint4$Outbound
  | CreateProjectContentHint5$Outbound
  | CreateProjectContentHint6$Outbound
  | CreateProjectContentHint7$Outbound
  | CreateProjectContentHint8$Outbound
  | CreateProjectContentHint9$Outbound
  | CreateProjectContentHint10$Outbound
  | ContentHint11$Outbound
  | ContentHint12$Outbound
  | ContentHint13$Outbound
  | ContentHint15$Outbound
  | ContentHint14$Outbound;

/** @internal */
export const CreateProjectContentHint$outboundSchema: z.ZodType<
  CreateProjectContentHint$Outbound,
  z.ZodTypeDef,
  CreateProjectContentHint
> = z.union([
  z.lazy(() => CreateProjectContentHint1$outboundSchema),
  z.lazy(() => CreateProjectContentHint2$outboundSchema),
  z.lazy(() => CreateProjectContentHint3$outboundSchema),
  z.lazy(() => CreateProjectContentHint4$outboundSchema),
  z.lazy(() => CreateProjectContentHint5$outboundSchema),
  z.lazy(() => CreateProjectContentHint6$outboundSchema),
  z.lazy(() => CreateProjectContentHint7$outboundSchema),
  z.lazy(() => CreateProjectContentHint8$outboundSchema),
  z.lazy(() => CreateProjectContentHint9$outboundSchema),
  z.lazy(() => CreateProjectContentHint10$outboundSchema),
  z.lazy(() => ContentHint11$outboundSchema),
  z.lazy(() => ContentHint12$outboundSchema),
  z.lazy(() => ContentHint13$outboundSchema),
  z.lazy(() => ContentHint15$outboundSchema),
  z.lazy(() => ContentHint14$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectContentHint$ {
  /** @deprecated use `CreateProjectContentHint$inboundSchema` instead. */
  export const inboundSchema = CreateProjectContentHint$inboundSchema;
  /** @deprecated use `CreateProjectContentHint$outboundSchema` instead. */
  export const outboundSchema = CreateProjectContentHint$outboundSchema;
  /** @deprecated use `CreateProjectContentHint$Outbound` instead. */
  export type Outbound = CreateProjectContentHint$Outbound;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType
  > = z.nativeEnum(
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType,
  );

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType
  > =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema;
}

/** @internal */
export const CreateProjectInternalContentHint$inboundSchema: z.ZodType<
  CreateProjectInternalContentHint,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$inboundSchema,
  encryptedValue: z.string(),
});

/** @internal */
export type CreateProjectInternalContentHint$Outbound = {
  type: string;
  encryptedValue: string;
};

/** @internal */
export const CreateProjectInternalContentHint$outboundSchema: z.ZodType<
  CreateProjectInternalContentHint$Outbound,
  z.ZodTypeDef,
  CreateProjectInternalContentHint
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyEnvType$outboundSchema,
  encryptedValue: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectInternalContentHint$ {
  /** @deprecated use `CreateProjectInternalContentHint$inboundSchema` instead. */
  export const inboundSchema = CreateProjectInternalContentHint$inboundSchema;
  /** @deprecated use `CreateProjectInternalContentHint$outboundSchema` instead. */
  export const outboundSchema = CreateProjectInternalContentHint$outboundSchema;
  /** @deprecated use `CreateProjectInternalContentHint$Outbound` instead. */
  export type Outbound = CreateProjectInternalContentHint$Outbound;
}

/** @internal */
export const CreateProjectEnv$inboundSchema: z.ZodType<
  CreateProjectEnv,
  z.ZodTypeDef,
  unknown
> = z.object({
  target: z.union([z.array(z.string()), CreateProjectTarget2$inboundSchema])
    .optional(),
  type: CreateProjectProjectsResponseType$inboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => CreateProjectContentHint1$inboundSchema),
      z.lazy(() => CreateProjectContentHint2$inboundSchema),
      z.lazy(() => CreateProjectContentHint3$inboundSchema),
      z.lazy(() => CreateProjectContentHint4$inboundSchema),
      z.lazy(() => CreateProjectContentHint5$inboundSchema),
      z.lazy(() => CreateProjectContentHint6$inboundSchema),
      z.lazy(() => CreateProjectContentHint7$inboundSchema),
      z.lazy(() => CreateProjectContentHint8$inboundSchema),
      z.lazy(() => CreateProjectContentHint9$inboundSchema),
      z.lazy(() => CreateProjectContentHint10$inboundSchema),
      z.lazy(() => ContentHint11$inboundSchema),
      z.lazy(() => ContentHint12$inboundSchema),
      z.lazy(() => ContentHint13$inboundSchema),
      z.lazy(() => ContentHint15$inboundSchema),
      z.lazy(() => ContentHint14$inboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => CreateProjectInternalContentHint$inboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
});

/** @internal */
export type CreateProjectEnv$Outbound = {
  target?: Array<string> | string | undefined;
  type: string;
  sunsetSecretId?: string | undefined;
  id?: string | undefined;
  key: string;
  value: string;
  configurationId?: string | null | undefined;
  createdAt?: number | undefined;
  updatedAt?: number | undefined;
  createdBy?: string | null | undefined;
  updatedBy?: string | null | undefined;
  gitBranch?: string | undefined;
  edgeConfigId?: string | null | undefined;
  edgeConfigTokenId?: string | null | undefined;
  contentHint?:
    | CreateProjectContentHint1$Outbound
    | CreateProjectContentHint2$Outbound
    | CreateProjectContentHint3$Outbound
    | CreateProjectContentHint4$Outbound
    | CreateProjectContentHint5$Outbound
    | CreateProjectContentHint6$Outbound
    | CreateProjectContentHint7$Outbound
    | CreateProjectContentHint8$Outbound
    | CreateProjectContentHint9$Outbound
    | CreateProjectContentHint10$Outbound
    | ContentHint11$Outbound
    | ContentHint12$Outbound
    | ContentHint13$Outbound
    | ContentHint15$Outbound
    | ContentHint14$Outbound
    | null
    | undefined;
  internalContentHint?:
    | CreateProjectInternalContentHint$Outbound
    | null
    | undefined;
  decrypted?: boolean | undefined;
  comment?: string | undefined;
  customEnvironmentIds?: Array<string> | undefined;
  vsmValue?: string | undefined;
};

/** @internal */
export const CreateProjectEnv$outboundSchema: z.ZodType<
  CreateProjectEnv$Outbound,
  z.ZodTypeDef,
  CreateProjectEnv
> = z.object({
  target: z.union([z.array(z.string()), CreateProjectTarget2$outboundSchema])
    .optional(),
  type: CreateProjectProjectsResponseType$outboundSchema,
  sunsetSecretId: z.string().optional(),
  id: z.string().optional(),
  key: z.string(),
  value: z.string(),
  configurationId: z.nullable(z.string()).optional(),
  createdAt: z.number().optional(),
  updatedAt: z.number().optional(),
  createdBy: z.nullable(z.string()).optional(),
  updatedBy: z.nullable(z.string()).optional(),
  gitBranch: z.string().optional(),
  edgeConfigId: z.nullable(z.string()).optional(),
  edgeConfigTokenId: z.nullable(z.string()).optional(),
  contentHint: z.nullable(
    z.union([
      z.lazy(() => CreateProjectContentHint1$outboundSchema),
      z.lazy(() => CreateProjectContentHint2$outboundSchema),
      z.lazy(() => CreateProjectContentHint3$outboundSchema),
      z.lazy(() => CreateProjectContentHint4$outboundSchema),
      z.lazy(() => CreateProjectContentHint5$outboundSchema),
      z.lazy(() => CreateProjectContentHint6$outboundSchema),
      z.lazy(() => CreateProjectContentHint7$outboundSchema),
      z.lazy(() => CreateProjectContentHint8$outboundSchema),
      z.lazy(() => CreateProjectContentHint9$outboundSchema),
      z.lazy(() => CreateProjectContentHint10$outboundSchema),
      z.lazy(() => ContentHint11$outboundSchema),
      z.lazy(() => ContentHint12$outboundSchema),
      z.lazy(() => ContentHint13$outboundSchema),
      z.lazy(() => ContentHint15$outboundSchema),
      z.lazy(() => ContentHint14$outboundSchema),
    ]),
  ).optional(),
  internalContentHint: z.nullable(
    z.lazy(() => CreateProjectInternalContentHint$outboundSchema),
  ).optional(),
  decrypted: z.boolean().optional(),
  comment: z.string().optional(),
  customEnvironmentIds: z.array(z.string()).optional(),
  vsmValue: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectEnv$ {
  /** @deprecated use `CreateProjectEnv$inboundSchema` instead. */
  export const inboundSchema = CreateProjectEnv$inboundSchema;
  /** @deprecated use `CreateProjectEnv$outboundSchema` instead. */
  export const outboundSchema = CreateProjectEnv$outboundSchema;
  /** @deprecated use `CreateProjectEnv$Outbound` instead. */
  export type Outbound = CreateProjectEnv$Outbound;
}

/** @internal */
export const CreateProjectCustomEnvironments$inboundSchema: z.ZodType<
  CreateProjectCustomEnvironments,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CreateProjectCustomEnvironments$Outbound = {};

/** @internal */
export const CreateProjectCustomEnvironments$outboundSchema: z.ZodType<
  CreateProjectCustomEnvironments$Outbound,
  z.ZodTypeDef,
  CreateProjectCustomEnvironments
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectCustomEnvironments$ {
  /** @deprecated use `CreateProjectCustomEnvironments$inboundSchema` instead. */
  export const inboundSchema = CreateProjectCustomEnvironments$inboundSchema;
  /** @deprecated use `CreateProjectCustomEnvironments$outboundSchema` instead. */
  export const outboundSchema = CreateProjectCustomEnvironments$outboundSchema;
  /** @deprecated use `CreateProjectCustomEnvironments$Outbound` instead. */
  export type Outbound = CreateProjectCustomEnvironments$Outbound;
}

/** @internal */
export const CreateProjectProjectsFramework$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsFramework
> = z.nativeEnum(CreateProjectProjectsFramework);

/** @internal */
export const CreateProjectProjectsFramework$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsFramework
> = CreateProjectProjectsFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsFramework$ {
  /** @deprecated use `CreateProjectProjectsFramework$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsFramework$inboundSchema;
  /** @deprecated use `CreateProjectProjectsFramework$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsFramework$outboundSchema;
}

/** @internal */
export const CreateProjectIpBuckets$inboundSchema: z.ZodType<
  CreateProjectIpBuckets,
  z.ZodTypeDef,
  unknown
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/** @internal */
export type CreateProjectIpBuckets$Outbound = {
  bucket: string;
  supportUntil?: number | undefined;
};

/** @internal */
export const CreateProjectIpBuckets$outboundSchema: z.ZodType<
  CreateProjectIpBuckets$Outbound,
  z.ZodTypeDef,
  CreateProjectIpBuckets
> = z.object({
  bucket: z.string(),
  supportUntil: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectIpBuckets$ {
  /** @deprecated use `CreateProjectIpBuckets$inboundSchema` instead. */
  export const inboundSchema = CreateProjectIpBuckets$inboundSchema;
  /** @deprecated use `CreateProjectIpBuckets$outboundSchema` instead. */
  export const outboundSchema = CreateProjectIpBuckets$outboundSchema;
  /** @deprecated use `CreateProjectIpBuckets$Outbound` instead. */
  export type Outbound = CreateProjectIpBuckets$Outbound;
}

/** @internal */
export const CreateProjectAliasAssigned$inboundSchema: z.ZodType<
  CreateProjectAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type CreateProjectAliasAssigned$Outbound = number | boolean;

/** @internal */
export const CreateProjectAliasAssigned$outboundSchema: z.ZodType<
  CreateProjectAliasAssigned$Outbound,
  z.ZodTypeDef,
  CreateProjectAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectAliasAssigned$ {
  /** @deprecated use `CreateProjectAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = CreateProjectAliasAssigned$inboundSchema;
  /** @deprecated use `CreateProjectAliasAssigned$outboundSchema` instead. */
  export const outboundSchema = CreateProjectAliasAssigned$outboundSchema;
  /** @deprecated use `CreateProjectAliasAssigned$Outbound` instead. */
  export type Outbound = CreateProjectAliasAssigned$Outbound;
}

/** @internal */
export const CreateProjectAliasError$inboundSchema: z.ZodType<
  CreateProjectAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type CreateProjectAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const CreateProjectAliasError$outboundSchema: z.ZodType<
  CreateProjectAliasError$Outbound,
  z.ZodTypeDef,
  CreateProjectAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectAliasError$ {
  /** @deprecated use `CreateProjectAliasError$inboundSchema` instead. */
  export const inboundSchema = CreateProjectAliasError$inboundSchema;
  /** @deprecated use `CreateProjectAliasError$outboundSchema` instead. */
  export const outboundSchema = CreateProjectAliasError$outboundSchema;
  /** @deprecated use `CreateProjectAliasError$Outbound` instead. */
  export type Outbound = CreateProjectAliasError$Outbound;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType
  > = z.nativeEnum(
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType,
  );

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType
  > =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$outboundSchema;
}

/** @internal */
export const CreateProjectBranchMatcher$inboundSchema: z.ZodType<
  CreateProjectBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type CreateProjectBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const CreateProjectBranchMatcher$outboundSchema: z.ZodType<
  CreateProjectBranchMatcher$Outbound,
  z.ZodTypeDef,
  CreateProjectBranchMatcher
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyLatestDeploymentsType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectBranchMatcher$ {
  /** @deprecated use `CreateProjectBranchMatcher$inboundSchema` instead. */
  export const inboundSchema = CreateProjectBranchMatcher$inboundSchema;
  /** @deprecated use `CreateProjectBranchMatcher$outboundSchema` instead. */
  export const outboundSchema = CreateProjectBranchMatcher$outboundSchema;
  /** @deprecated use `CreateProjectBranchMatcher$Outbound` instead. */
  export type Outbound = CreateProjectBranchMatcher$Outbound;
}

/** @internal */
export const CreateProjectBuilds$inboundSchema: z.ZodType<
  CreateProjectBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type CreateProjectBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const CreateProjectBuilds$outboundSchema: z.ZodType<
  CreateProjectBuilds$Outbound,
  z.ZodTypeDef,
  CreateProjectBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectBuilds$ {
  /** @deprecated use `CreateProjectBuilds$inboundSchema` instead. */
  export const inboundSchema = CreateProjectBuilds$inboundSchema;
  /** @deprecated use `CreateProjectBuilds$outboundSchema` instead. */
  export const outboundSchema = CreateProjectBuilds$outboundSchema;
  /** @deprecated use `CreateProjectBuilds$Outbound` instead. */
  export type Outbound = CreateProjectBuilds$Outbound;
}

/** @internal */
export const CreateProjectChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectChecksConclusion
> = z.nativeEnum(CreateProjectChecksConclusion);

/** @internal */
export const CreateProjectChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectChecksConclusion
> = CreateProjectChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectChecksConclusion$ {
  /** @deprecated use `CreateProjectChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = CreateProjectChecksConclusion$inboundSchema;
  /** @deprecated use `CreateProjectChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = CreateProjectChecksConclusion$outboundSchema;
}

/** @internal */
export const CreateProjectChecksState$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectChecksState
> = z.nativeEnum(CreateProjectChecksState);

/** @internal */
export const CreateProjectChecksState$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectChecksState
> = CreateProjectChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectChecksState$ {
  /** @deprecated use `CreateProjectChecksState$inboundSchema` instead. */
  export const inboundSchema = CreateProjectChecksState$inboundSchema;
  /** @deprecated use `CreateProjectChecksState$outboundSchema` instead. */
  export const outboundSchema = CreateProjectChecksState$outboundSchema;
}

/** @internal */
export const CreateProjectCreator$inboundSchema: z.ZodType<
  CreateProjectCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type CreateProjectCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const CreateProjectCreator$outboundSchema: z.ZodType<
  CreateProjectCreator$Outbound,
  z.ZodTypeDef,
  CreateProjectCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectCreator$ {
  /** @deprecated use `CreateProjectCreator$inboundSchema` instead. */
  export const inboundSchema = CreateProjectCreator$inboundSchema;
  /** @deprecated use `CreateProjectCreator$outboundSchema` instead. */
  export const outboundSchema = CreateProjectCreator$outboundSchema;
  /** @deprecated use `CreateProjectCreator$Outbound` instead. */
  export type Outbound = CreateProjectCreator$Outbound;
}

/** @internal */
export const CreateProjectOidcTokenClaims$inboundSchema: z.ZodType<
  CreateProjectOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type CreateProjectOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const CreateProjectOidcTokenClaims$outboundSchema: z.ZodType<
  CreateProjectOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  CreateProjectOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectOidcTokenClaims$ {
  /** @deprecated use `CreateProjectOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = CreateProjectOidcTokenClaims$inboundSchema;
  /** @deprecated use `CreateProjectOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema = CreateProjectOidcTokenClaims$outboundSchema;
  /** @deprecated use `CreateProjectOidcTokenClaims$Outbound` instead. */
  export type Outbound = CreateProjectOidcTokenClaims$Outbound;
}

/** @internal */
export const CreateProjectPlan$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectPlan
> = z.nativeEnum(CreateProjectPlan);

/** @internal */
export const CreateProjectPlan$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectPlan
> = CreateProjectPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectPlan$ {
  /** @deprecated use `CreateProjectPlan$inboundSchema` instead. */
  export const inboundSchema = CreateProjectPlan$inboundSchema;
  /** @deprecated use `CreateProjectPlan$outboundSchema` instead. */
  export const outboundSchema = CreateProjectPlan$outboundSchema;
}

/** @internal */
export const CreateProjectReadyState$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectReadyState
> = z.nativeEnum(CreateProjectReadyState);

/** @internal */
export const CreateProjectReadyState$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectReadyState
> = CreateProjectReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectReadyState$ {
  /** @deprecated use `CreateProjectReadyState$inboundSchema` instead. */
  export const inboundSchema = CreateProjectReadyState$inboundSchema;
  /** @deprecated use `CreateProjectReadyState$outboundSchema` instead. */
  export const outboundSchema = CreateProjectReadyState$outboundSchema;
}

/** @internal */
export const CreateProjectReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectReadySubstate
> = z.nativeEnum(CreateProjectReadySubstate);

/** @internal */
export const CreateProjectReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectReadySubstate
> = CreateProjectReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectReadySubstate$ {
  /** @deprecated use `CreateProjectReadySubstate$inboundSchema` instead. */
  export const inboundSchema = CreateProjectReadySubstate$inboundSchema;
  /** @deprecated use `CreateProjectReadySubstate$outboundSchema` instead. */
  export const outboundSchema = CreateProjectReadySubstate$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectProjectsResponse200Type> = z.nativeEnum(
    CreateProjectProjectsResponse200Type,
  );

/** @internal */
export const CreateProjectProjectsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectProjectsResponse200Type> =
    CreateProjectProjectsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200Type$ {
  /** @deprecated use `CreateProjectProjectsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200Type$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200Type$outboundSchema;
}

/** @internal */
export const CreateProjectLatestDeployments$inboundSchema: z.ZodType<
  CreateProjectLatestDeployments,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(z.lazy(() => CreateProjectAliasError$inboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => CreateProjectBranchMatcher$inboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => CreateProjectBuilds$inboundSchema)).optional(),
  checksConclusion: CreateProjectChecksConclusion$inboundSchema.optional(),
  checksState: CreateProjectChecksState$inboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => CreateProjectCreator$inboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() => CreateProjectOidcTokenClaims$inboundSchema)
    .optional(),
  plan: CreateProjectPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: CreateProjectReadyState$inboundSchema,
  readySubstate: CreateProjectReadySubstate$inboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: CreateProjectProjectsResponse200Type$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type CreateProjectLatestDeployments$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: CreateProjectAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: CreateProjectBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<CreateProjectBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: CreateProjectCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: CreateProjectOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const CreateProjectLatestDeployments$outboundSchema: z.ZodType<
  CreateProjectLatestDeployments$Outbound,
  z.ZodTypeDef,
  CreateProjectLatestDeployments
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(z.lazy(() => CreateProjectAliasError$outboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => CreateProjectBranchMatcher$outboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => CreateProjectBuilds$outboundSchema)).optional(),
  checksConclusion: CreateProjectChecksConclusion$outboundSchema.optional(),
  checksState: CreateProjectChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => CreateProjectCreator$outboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() => CreateProjectOidcTokenClaims$outboundSchema)
    .optional(),
  plan: CreateProjectPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: CreateProjectReadyState$outboundSchema,
  readySubstate: CreateProjectReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: CreateProjectProjectsResponse200Type$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLatestDeployments$ {
  /** @deprecated use `CreateProjectLatestDeployments$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLatestDeployments$inboundSchema;
  /** @deprecated use `CreateProjectLatestDeployments$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLatestDeployments$outboundSchema;
  /** @deprecated use `CreateProjectLatestDeployments$Outbound` instead. */
  export type Outbound = CreateProjectLatestDeployments$Outbound;
}

/** @internal */
export const CreateProjectLinkProjectsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectLinkProjectsResponseType> = z.nativeEnum(
    CreateProjectLinkProjectsResponseType,
  );

/** @internal */
export const CreateProjectLinkProjectsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectLinkProjectsResponseType> =
    CreateProjectLinkProjectsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLinkProjectsResponseType$ {
  /** @deprecated use `CreateProjectLinkProjectsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectLinkProjectsResponseType$inboundSchema;
  /** @deprecated use `CreateProjectLinkProjectsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectLinkProjectsResponseType$outboundSchema;
}

/** @internal */
export const CreateProjectLinkProjectsResponseDeployHooks$inboundSchema:
  z.ZodType<
    CreateProjectLinkProjectsResponseDeployHooks,
    z.ZodTypeDef,
    unknown
  > = z.object({
    createdAt: z.number().optional(),
    id: z.string(),
    name: z.string(),
    ref: z.string(),
    url: z.string(),
  });

/** @internal */
export type CreateProjectLinkProjectsResponseDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const CreateProjectLinkProjectsResponseDeployHooks$outboundSchema:
  z.ZodType<
    CreateProjectLinkProjectsResponseDeployHooks$Outbound,
    z.ZodTypeDef,
    CreateProjectLinkProjectsResponseDeployHooks
  > = z.object({
    createdAt: z.number().optional(),
    id: z.string(),
    name: z.string(),
    ref: z.string(),
    url: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLinkProjectsResponseDeployHooks$ {
  /** @deprecated use `CreateProjectLinkProjectsResponseDeployHooks$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectLinkProjectsResponseDeployHooks$inboundSchema;
  /** @deprecated use `CreateProjectLinkProjectsResponseDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectLinkProjectsResponseDeployHooks$outboundSchema;
  /** @deprecated use `CreateProjectLinkProjectsResponseDeployHooks$Outbound` instead. */
  export type Outbound = CreateProjectLinkProjectsResponseDeployHooks$Outbound;
}

/** @internal */
export const CreateProjectLink3$inboundSchema: z.ZodType<
  CreateProjectLink3,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: CreateProjectLinkProjectsResponseType$inboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => CreateProjectLinkProjectsResponseDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type CreateProjectLink3$Outbound = {
  name?: string | undefined;
  slug?: string | undefined;
  owner?: string | undefined;
  type?: string | undefined;
  uuid?: string | undefined;
  workspaceUuid?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<CreateProjectLinkProjectsResponseDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const CreateProjectLink3$outboundSchema: z.ZodType<
  CreateProjectLink3$Outbound,
  z.ZodTypeDef,
  CreateProjectLink3
> = z.object({
  name: z.string().optional(),
  slug: z.string().optional(),
  owner: z.string().optional(),
  type: CreateProjectLinkProjectsResponseType$outboundSchema.optional(),
  uuid: z.string().optional(),
  workspaceUuid: z.string().optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => CreateProjectLinkProjectsResponseDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLink3$ {
  /** @deprecated use `CreateProjectLink3$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLink3$inboundSchema;
  /** @deprecated use `CreateProjectLink3$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLink3$outboundSchema;
  /** @deprecated use `CreateProjectLink3$Outbound` instead. */
  export type Outbound = CreateProjectLink3$Outbound;
}

/** @internal */
export const CreateProjectLinkProjectsType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectLinkProjectsType
> = z.nativeEnum(CreateProjectLinkProjectsType);

/** @internal */
export const CreateProjectLinkProjectsType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectLinkProjectsType
> = CreateProjectLinkProjectsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLinkProjectsType$ {
  /** @deprecated use `CreateProjectLinkProjectsType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLinkProjectsType$inboundSchema;
  /** @deprecated use `CreateProjectLinkProjectsType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLinkProjectsType$outboundSchema;
}

/** @internal */
export const CreateProjectLinkProjectsDeployHooks$inboundSchema: z.ZodType<
  CreateProjectLinkProjectsDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type CreateProjectLinkProjectsDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const CreateProjectLinkProjectsDeployHooks$outboundSchema: z.ZodType<
  CreateProjectLinkProjectsDeployHooks$Outbound,
  z.ZodTypeDef,
  CreateProjectLinkProjectsDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLinkProjectsDeployHooks$ {
  /** @deprecated use `CreateProjectLinkProjectsDeployHooks$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectLinkProjectsDeployHooks$inboundSchema;
  /** @deprecated use `CreateProjectLinkProjectsDeployHooks$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectLinkProjectsDeployHooks$outboundSchema;
  /** @deprecated use `CreateProjectLinkProjectsDeployHooks$Outbound` instead. */
  export type Outbound = CreateProjectLinkProjectsDeployHooks$Outbound;
}

/** @internal */
export const CreateProjectLink2$inboundSchema: z.ZodType<
  CreateProjectLink2,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: CreateProjectLinkProjectsType$inboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => CreateProjectLinkProjectsDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type CreateProjectLink2$Outbound = {
  projectId?: string | undefined;
  projectName?: string | undefined;
  projectNameWithNamespace?: string | undefined;
  projectNamespace?: string | undefined;
  projectOwnerId?: number | undefined;
  projectUrl?: string | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<CreateProjectLinkProjectsDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const CreateProjectLink2$outboundSchema: z.ZodType<
  CreateProjectLink2$Outbound,
  z.ZodTypeDef,
  CreateProjectLink2
> = z.object({
  projectId: z.string().optional(),
  projectName: z.string().optional(),
  projectNameWithNamespace: z.string().optional(),
  projectNamespace: z.string().optional(),
  projectOwnerId: z.number().optional(),
  projectUrl: z.string().optional(),
  type: CreateProjectLinkProjectsType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => CreateProjectLinkProjectsDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLink2$ {
  /** @deprecated use `CreateProjectLink2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLink2$inboundSchema;
  /** @deprecated use `CreateProjectLink2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLink2$outboundSchema;
  /** @deprecated use `CreateProjectLink2$Outbound` instead. */
  export type Outbound = CreateProjectLink2$Outbound;
}

/** @internal */
export const CreateProjectLinkType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectLinkType
> = z.nativeEnum(CreateProjectLinkType);

/** @internal */
export const CreateProjectLinkType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectLinkType
> = CreateProjectLinkType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLinkType$ {
  /** @deprecated use `CreateProjectLinkType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLinkType$inboundSchema;
  /** @deprecated use `CreateProjectLinkType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLinkType$outboundSchema;
}

/** @internal */
export const CreateProjectLinkDeployHooks$inboundSchema: z.ZodType<
  CreateProjectLinkDeployHooks,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/** @internal */
export type CreateProjectLinkDeployHooks$Outbound = {
  createdAt?: number | undefined;
  id: string;
  name: string;
  ref: string;
  url: string;
};

/** @internal */
export const CreateProjectLinkDeployHooks$outboundSchema: z.ZodType<
  CreateProjectLinkDeployHooks$Outbound,
  z.ZodTypeDef,
  CreateProjectLinkDeployHooks
> = z.object({
  createdAt: z.number().optional(),
  id: z.string(),
  name: z.string(),
  ref: z.string(),
  url: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLinkDeployHooks$ {
  /** @deprecated use `CreateProjectLinkDeployHooks$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLinkDeployHooks$inboundSchema;
  /** @deprecated use `CreateProjectLinkDeployHooks$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLinkDeployHooks$outboundSchema;
  /** @deprecated use `CreateProjectLinkDeployHooks$Outbound` instead. */
  export type Outbound = CreateProjectLinkDeployHooks$Outbound;
}

/** @internal */
export const CreateProjectLink1$inboundSchema: z.ZodType<
  CreateProjectLink1,
  z.ZodTypeDef,
  unknown
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: CreateProjectLinkType$inboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => CreateProjectLinkDeployHooks$inboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/** @internal */
export type CreateProjectLink1$Outbound = {
  org?: string | undefined;
  repoOwnerId?: number | undefined;
  repo?: string | undefined;
  repoId?: number | undefined;
  type?: string | undefined;
  createdAt?: number | undefined;
  deployHooks: Array<CreateProjectLinkDeployHooks$Outbound>;
  gitCredentialId?: string | undefined;
  updatedAt?: number | undefined;
  sourceless?: boolean | undefined;
  productionBranch?: string | undefined;
};

/** @internal */
export const CreateProjectLink1$outboundSchema: z.ZodType<
  CreateProjectLink1$Outbound,
  z.ZodTypeDef,
  CreateProjectLink1
> = z.object({
  org: z.string().optional(),
  repoOwnerId: z.number().optional(),
  repo: z.string().optional(),
  repoId: z.number().optional(),
  type: CreateProjectLinkType$outboundSchema.optional(),
  createdAt: z.number().optional(),
  deployHooks: z.array(
    z.lazy(() => CreateProjectLinkDeployHooks$outboundSchema),
  ),
  gitCredentialId: z.string().optional(),
  updatedAt: z.number().optional(),
  sourceless: z.boolean().optional(),
  productionBranch: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLink1$ {
  /** @deprecated use `CreateProjectLink1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLink1$inboundSchema;
  /** @deprecated use `CreateProjectLink1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLink1$outboundSchema;
  /** @deprecated use `CreateProjectLink1$Outbound` instead. */
  export type Outbound = CreateProjectLink1$Outbound;
}

/** @internal */
export const CreateProjectLink$inboundSchema: z.ZodType<
  CreateProjectLink,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectLink1$inboundSchema),
  z.lazy(() => CreateProjectLink3$inboundSchema),
  z.lazy(() => CreateProjectLink2$inboundSchema),
]);

/** @internal */
export type CreateProjectLink$Outbound =
  | CreateProjectLink1$Outbound
  | CreateProjectLink3$Outbound
  | CreateProjectLink2$Outbound;

/** @internal */
export const CreateProjectLink$outboundSchema: z.ZodType<
  CreateProjectLink$Outbound,
  z.ZodTypeDef,
  CreateProjectLink
> = z.union([
  z.lazy(() => CreateProjectLink1$outboundSchema),
  z.lazy(() => CreateProjectLink3$outboundSchema),
  z.lazy(() => CreateProjectLink2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLink$ {
  /** @deprecated use `CreateProjectLink$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLink$inboundSchema;
  /** @deprecated use `CreateProjectLink$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLink$outboundSchema;
  /** @deprecated use `CreateProjectLink$Outbound` instead. */
  export type Outbound = CreateProjectLink$Outbound;
}

/** @internal */
export const CreateProjectGroup$inboundSchema: z.ZodType<
  CreateProjectGroup,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/** @internal */
export type CreateProjectGroup$Outbound = {
  id: string;
  slug: string;
};

/** @internal */
export const CreateProjectGroup$outboundSchema: z.ZodType<
  CreateProjectGroup$Outbound,
  z.ZodTypeDef,
  CreateProjectGroup
> = z.object({
  id: z.string(),
  slug: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectGroup$ {
  /** @deprecated use `CreateProjectGroup$inboundSchema` instead. */
  export const inboundSchema = CreateProjectGroup$inboundSchema;
  /** @deprecated use `CreateProjectGroup$outboundSchema` instead. */
  export const outboundSchema = CreateProjectGroup$outboundSchema;
  /** @deprecated use `CreateProjectGroup$Outbound` instead. */
  export type Outbound = CreateProjectGroup$Outbound;
}

/** @internal */
export const CreateProjectMicrofrontends$inboundSchema: z.ZodType<
  CreateProjectMicrofrontends,
  z.ZodTypeDef,
  unknown
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => CreateProjectGroup$inboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/** @internal */
export type CreateProjectMicrofrontends$Outbound = {
  updatedAt: number;
  group: CreateProjectGroup$Outbound;
  enabled: boolean;
  isDefaultApp?: boolean | undefined;
  defaultRoute?: string | undefined;
};

/** @internal */
export const CreateProjectMicrofrontends$outboundSchema: z.ZodType<
  CreateProjectMicrofrontends$Outbound,
  z.ZodTypeDef,
  CreateProjectMicrofrontends
> = z.object({
  updatedAt: z.number(),
  group: z.lazy(() => CreateProjectGroup$outboundSchema),
  enabled: z.boolean(),
  isDefaultApp: z.boolean().optional(),
  defaultRoute: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectMicrofrontends$ {
  /** @deprecated use `CreateProjectMicrofrontends$inboundSchema` instead. */
  export const inboundSchema = CreateProjectMicrofrontends$inboundSchema;
  /** @deprecated use `CreateProjectMicrofrontends$outboundSchema` instead. */
  export const outboundSchema = CreateProjectMicrofrontends$outboundSchema;
  /** @deprecated use `CreateProjectMicrofrontends$Outbound` instead. */
  export type Outbound = CreateProjectMicrofrontends$Outbound;
}

/** @internal */
export const CreateProjectNodeVersion$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectNodeVersion
> = z.nativeEnum(CreateProjectNodeVersion);

/** @internal */
export const CreateProjectNodeVersion$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectNodeVersion
> = CreateProjectNodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectNodeVersion$ {
  /** @deprecated use `CreateProjectNodeVersion$inboundSchema` instead. */
  export const inboundSchema = CreateProjectNodeVersion$inboundSchema;
  /** @deprecated use `CreateProjectNodeVersion$outboundSchema` instead. */
  export const outboundSchema = CreateProjectNodeVersion$outboundSchema;
}

/** @internal */
export const CreateProjectPaths$inboundSchema: z.ZodType<
  CreateProjectPaths,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
});

/** @internal */
export type CreateProjectPaths$Outbound = {
  value: string;
};

/** @internal */
export const CreateProjectPaths$outboundSchema: z.ZodType<
  CreateProjectPaths$Outbound,
  z.ZodTypeDef,
  CreateProjectPaths
> = z.object({
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectPaths$ {
  /** @deprecated use `CreateProjectPaths$inboundSchema` instead. */
  export const inboundSchema = CreateProjectPaths$inboundSchema;
  /** @deprecated use `CreateProjectPaths$outboundSchema` instead. */
  export const outboundSchema = CreateProjectPaths$outboundSchema;
  /** @deprecated use `CreateProjectPaths$Outbound` instead. */
  export type Outbound = CreateProjectPaths$Outbound;
}

/** @internal */
export const CreateProjectOptionsAllowlist$inboundSchema: z.ZodType<
  CreateProjectOptionsAllowlist,
  z.ZodTypeDef,
  unknown
> = z.object({
  paths: z.array(z.lazy(() => CreateProjectPaths$inboundSchema)),
});

/** @internal */
export type CreateProjectOptionsAllowlist$Outbound = {
  paths: Array<CreateProjectPaths$Outbound>;
};

/** @internal */
export const CreateProjectOptionsAllowlist$outboundSchema: z.ZodType<
  CreateProjectOptionsAllowlist$Outbound,
  z.ZodTypeDef,
  CreateProjectOptionsAllowlist
> = z.object({
  paths: z.array(z.lazy(() => CreateProjectPaths$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectOptionsAllowlist$ {
  /** @deprecated use `CreateProjectOptionsAllowlist$inboundSchema` instead. */
  export const inboundSchema = CreateProjectOptionsAllowlist$inboundSchema;
  /** @deprecated use `CreateProjectOptionsAllowlist$outboundSchema` instead. */
  export const outboundSchema = CreateProjectOptionsAllowlist$outboundSchema;
  /** @deprecated use `CreateProjectOptionsAllowlist$Outbound` instead. */
  export type Outbound = CreateProjectOptionsAllowlist$Outbound;
}

/** @internal */
export const CreateProjectPasswordProtection$inboundSchema: z.ZodType<
  CreateProjectPasswordProtection,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CreateProjectPasswordProtection$Outbound = {};

/** @internal */
export const CreateProjectPasswordProtection$outboundSchema: z.ZodType<
  CreateProjectPasswordProtection$Outbound,
  z.ZodTypeDef,
  CreateProjectPasswordProtection
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectPasswordProtection$ {
  /** @deprecated use `CreateProjectPasswordProtection$inboundSchema` instead. */
  export const inboundSchema = CreateProjectPasswordProtection$inboundSchema;
  /** @deprecated use `CreateProjectPasswordProtection$outboundSchema` instead. */
  export const outboundSchema = CreateProjectPasswordProtection$outboundSchema;
  /** @deprecated use `CreateProjectPasswordProtection$Outbound` instead. */
  export type Outbound = CreateProjectPasswordProtection$Outbound;
}

/** @internal */
export const CreateProjectFunctionDefaultMemoryType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectFunctionDefaultMemoryType> = z.nativeEnum(
    CreateProjectFunctionDefaultMemoryType,
  );

/** @internal */
export const CreateProjectFunctionDefaultMemoryType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectFunctionDefaultMemoryType> =
    CreateProjectFunctionDefaultMemoryType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectFunctionDefaultMemoryType$ {
  /** @deprecated use `CreateProjectFunctionDefaultMemoryType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectFunctionDefaultMemoryType$inboundSchema;
  /** @deprecated use `CreateProjectFunctionDefaultMemoryType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectFunctionDefaultMemoryType$outboundSchema;
}

/** @internal */
export const CreateProjectResourceConfig$inboundSchema: z.ZodType<
  CreateProjectResourceConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType:
    CreateProjectFunctionDefaultMemoryType$inboundSchema.optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/** @internal */
export type CreateProjectResourceConfig$Outbound = {
  functionDefaultTimeout?: number | undefined;
  functionDefaultMemoryType?: string | undefined;
  allowServerlessConcurrency?: boolean | undefined;
  elasticConcurrencyEnabled?: boolean | undefined;
};

/** @internal */
export const CreateProjectResourceConfig$outboundSchema: z.ZodType<
  CreateProjectResourceConfig$Outbound,
  z.ZodTypeDef,
  CreateProjectResourceConfig
> = z.object({
  functionDefaultTimeout: z.number().optional(),
  functionDefaultMemoryType:
    CreateProjectFunctionDefaultMemoryType$outboundSchema.optional(),
  allowServerlessConcurrency: z.boolean().optional(),
  elasticConcurrencyEnabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectResourceConfig$ {
  /** @deprecated use `CreateProjectResourceConfig$inboundSchema` instead. */
  export const inboundSchema = CreateProjectResourceConfig$inboundSchema;
  /** @deprecated use `CreateProjectResourceConfig$outboundSchema` instead. */
  export const outboundSchema = CreateProjectResourceConfig$outboundSchema;
  /** @deprecated use `CreateProjectResourceConfig$Outbound` instead. */
  export type Outbound = CreateProjectResourceConfig$Outbound;
}

/** @internal */
export const CreateProjectDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectDeploymentType
> = z.nativeEnum(CreateProjectDeploymentType);

/** @internal */
export const CreateProjectDeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectDeploymentType
> = CreateProjectDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectDeploymentType$ {
  /** @deprecated use `CreateProjectDeploymentType$inboundSchema` instead. */
  export const inboundSchema = CreateProjectDeploymentType$inboundSchema;
  /** @deprecated use `CreateProjectDeploymentType$outboundSchema` instead. */
  export const outboundSchema = CreateProjectDeploymentType$outboundSchema;
}

/** @internal */
export const CreateProjectSsoProtection$inboundSchema: z.ZodType<
  CreateProjectSsoProtection,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: CreateProjectDeploymentType$inboundSchema,
});

/** @internal */
export type CreateProjectSsoProtection$Outbound = {
  deploymentType: string;
};

/** @internal */
export const CreateProjectSsoProtection$outboundSchema: z.ZodType<
  CreateProjectSsoProtection$Outbound,
  z.ZodTypeDef,
  CreateProjectSsoProtection
> = z.object({
  deploymentType: CreateProjectDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectSsoProtection$ {
  /** @deprecated use `CreateProjectSsoProtection$inboundSchema` instead. */
  export const inboundSchema = CreateProjectSsoProtection$inboundSchema;
  /** @deprecated use `CreateProjectSsoProtection$outboundSchema` instead. */
  export const outboundSchema = CreateProjectSsoProtection$outboundSchema;
  /** @deprecated use `CreateProjectSsoProtection$Outbound` instead. */
  export type Outbound = CreateProjectSsoProtection$Outbound;
}

/** @internal */
export const CreateProjectProjectsAliasAssigned$inboundSchema: z.ZodType<
  CreateProjectProjectsAliasAssigned,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type CreateProjectProjectsAliasAssigned$Outbound = number | boolean;

/** @internal */
export const CreateProjectProjectsAliasAssigned$outboundSchema: z.ZodType<
  CreateProjectProjectsAliasAssigned$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsAliasAssigned
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsAliasAssigned$ {
  /** @deprecated use `CreateProjectProjectsAliasAssigned$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsAliasAssigned$inboundSchema;
  /** @deprecated use `CreateProjectProjectsAliasAssigned$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsAliasAssigned$outboundSchema;
  /** @deprecated use `CreateProjectProjectsAliasAssigned$Outbound` instead. */
  export type Outbound = CreateProjectProjectsAliasAssigned$Outbound;
}

/** @internal */
export const CreateProjectProjectsAliasError$inboundSchema: z.ZodType<
  CreateProjectProjectsAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type CreateProjectProjectsAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const CreateProjectProjectsAliasError$outboundSchema: z.ZodType<
  CreateProjectProjectsAliasError$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsAliasError$ {
  /** @deprecated use `CreateProjectProjectsAliasError$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsAliasError$inboundSchema;
  /** @deprecated use `CreateProjectProjectsAliasError$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsAliasError$outboundSchema;
  /** @deprecated use `CreateProjectProjectsAliasError$Outbound` instead. */
  export type Outbound = CreateProjectProjectsAliasError$Outbound;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType
  > = z.nativeEnum(
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType,
  );

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType
  > =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsBranchMatcher$inboundSchema: z.ZodType<
  CreateProjectProjectsBranchMatcher,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$inboundSchema,
  pattern: z.string(),
});

/** @internal */
export type CreateProjectProjectsBranchMatcher$Outbound = {
  type: string;
  pattern: string;
};

/** @internal */
export const CreateProjectProjectsBranchMatcher$outboundSchema: z.ZodType<
  CreateProjectProjectsBranchMatcher$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsBranchMatcher
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyTargetsType$outboundSchema,
  pattern: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsBranchMatcher$ {
  /** @deprecated use `CreateProjectProjectsBranchMatcher$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsBranchMatcher$inboundSchema;
  /** @deprecated use `CreateProjectProjectsBranchMatcher$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsBranchMatcher$outboundSchema;
  /** @deprecated use `CreateProjectProjectsBranchMatcher$Outbound` instead. */
  export type Outbound = CreateProjectProjectsBranchMatcher$Outbound;
}

/** @internal */
export const CreateProjectProjectsBuilds$inboundSchema: z.ZodType<
  CreateProjectProjectsBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/** @internal */
export type CreateProjectProjectsBuilds$Outbound = {
  use: string;
  src?: string | undefined;
  dest?: string | undefined;
};

/** @internal */
export const CreateProjectProjectsBuilds$outboundSchema: z.ZodType<
  CreateProjectProjectsBuilds$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsBuilds
> = z.object({
  use: z.string(),
  src: z.string().optional(),
  dest: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsBuilds$ {
  /** @deprecated use `CreateProjectProjectsBuilds$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsBuilds$inboundSchema;
  /** @deprecated use `CreateProjectProjectsBuilds$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsBuilds$outboundSchema;
  /** @deprecated use `CreateProjectProjectsBuilds$Outbound` instead. */
  export type Outbound = CreateProjectProjectsBuilds$Outbound;
}

/** @internal */
export const CreateProjectProjectsChecksConclusion$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectProjectsChecksConclusion> = z.nativeEnum(
    CreateProjectProjectsChecksConclusion,
  );

/** @internal */
export const CreateProjectProjectsChecksConclusion$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectProjectsChecksConclusion> =
    CreateProjectProjectsChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsChecksConclusion$ {
  /** @deprecated use `CreateProjectProjectsChecksConclusion$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsChecksConclusion$inboundSchema;
  /** @deprecated use `CreateProjectProjectsChecksConclusion$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsChecksConclusion$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsChecksState$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsChecksState
> = z.nativeEnum(CreateProjectProjectsChecksState);

/** @internal */
export const CreateProjectProjectsChecksState$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsChecksState
> = CreateProjectProjectsChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsChecksState$ {
  /** @deprecated use `CreateProjectProjectsChecksState$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsChecksState$inboundSchema;
  /** @deprecated use `CreateProjectProjectsChecksState$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsChecksState$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsCreator$inboundSchema: z.ZodType<
  CreateProjectProjectsCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/** @internal */
export type CreateProjectProjectsCreator$Outbound = {
  email: string;
  githubLogin?: string | undefined;
  gitlabLogin?: string | undefined;
  uid: string;
  username: string;
};

/** @internal */
export const CreateProjectProjectsCreator$outboundSchema: z.ZodType<
  CreateProjectProjectsCreator$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsCreator
> = z.object({
  email: z.string(),
  githubLogin: z.string().optional(),
  gitlabLogin: z.string().optional(),
  uid: z.string(),
  username: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsCreator$ {
  /** @deprecated use `CreateProjectProjectsCreator$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsCreator$inboundSchema;
  /** @deprecated use `CreateProjectProjectsCreator$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsCreator$outboundSchema;
  /** @deprecated use `CreateProjectProjectsCreator$Outbound` instead. */
  export type Outbound = CreateProjectProjectsCreator$Outbound;
}

/** @internal */
export const CreateProjectProjectsOidcTokenClaims$inboundSchema: z.ZodType<
  CreateProjectProjectsOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type CreateProjectProjectsOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const CreateProjectProjectsOidcTokenClaims$outboundSchema: z.ZodType<
  CreateProjectProjectsOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsOidcTokenClaims$ {
  /** @deprecated use `CreateProjectProjectsOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsOidcTokenClaims$inboundSchema;
  /** @deprecated use `CreateProjectProjectsOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsOidcTokenClaims$outboundSchema;
  /** @deprecated use `CreateProjectProjectsOidcTokenClaims$Outbound` instead. */
  export type Outbound = CreateProjectProjectsOidcTokenClaims$Outbound;
}

/** @internal */
export const CreateProjectProjectsPlan$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsPlan
> = z.nativeEnum(CreateProjectProjectsPlan);

/** @internal */
export const CreateProjectProjectsPlan$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsPlan
> = CreateProjectProjectsPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsPlan$ {
  /** @deprecated use `CreateProjectProjectsPlan$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsPlan$inboundSchema;
  /** @deprecated use `CreateProjectProjectsPlan$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsPlan$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsReadyState$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsReadyState
> = z.nativeEnum(CreateProjectProjectsReadyState);

/** @internal */
export const CreateProjectProjectsReadyState$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsReadyState
> = CreateProjectProjectsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsReadyState$ {
  /** @deprecated use `CreateProjectProjectsReadyState$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsReadyState$inboundSchema;
  /** @deprecated use `CreateProjectProjectsReadyState$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsReadyState$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsReadySubstate
> = z.nativeEnum(CreateProjectProjectsReadySubstate);

/** @internal */
export const CreateProjectProjectsReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectProjectsReadySubstate
> = CreateProjectProjectsReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsReadySubstate$ {
  /** @deprecated use `CreateProjectProjectsReadySubstate$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsReadySubstate$inboundSchema;
  /** @deprecated use `CreateProjectProjectsReadySubstate$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsReadySubstate$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectProjectsResponse200ApplicationJSONType> =
    z.nativeEnum(CreateProjectProjectsResponse200ApplicationJSONType);

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectProjectsResponse200ApplicationJSONType> =
    CreateProjectProjectsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const CreateProjectTargets$inboundSchema: z.ZodType<
  CreateProjectTargets,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => CreateProjectProjectsAliasError$inboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => CreateProjectProjectsBranchMatcher$inboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => CreateProjectProjectsBuilds$inboundSchema))
    .optional(),
  checksConclusion: CreateProjectProjectsChecksConclusion$inboundSchema
    .optional(),
  checksState: CreateProjectProjectsChecksState$inboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(z.lazy(() => CreateProjectProjectsCreator$inboundSchema)),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    CreateProjectProjectsOidcTokenClaims$inboundSchema
  ).optional(),
  plan: CreateProjectProjectsPlan$inboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: CreateProjectProjectsReadyState$inboundSchema,
  readySubstate: CreateProjectProjectsReadySubstate$inboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: CreateProjectProjectsResponse200ApplicationJSONType$inboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/** @internal */
export type CreateProjectTargets$Outbound = {
  id: string;
  alias?: Array<string> | undefined;
  aliasAssigned?: number | boolean | null | undefined;
  aliasError?: CreateProjectProjectsAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  branchMatcher?: CreateProjectProjectsBranchMatcher$Outbound | undefined;
  buildingAt?: number | undefined;
  builds?: Array<CreateProjectProjectsBuilds$Outbound> | undefined;
  checksConclusion?: string | undefined;
  checksState?: string | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdAt: number;
  createdIn: string;
  creator: CreateProjectProjectsCreator$Outbound | null;
  deletedAt?: number | undefined;
  deploymentHostname: string;
  forced?: boolean | undefined;
  name: string;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  oidcTokenClaims?: CreateProjectProjectsOidcTokenClaims$Outbound | undefined;
  plan: string;
  previewCommentsEnabled?: boolean | undefined;
  private: boolean;
  readyAt?: number | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  requestedAt?: number | undefined;
  target?: string | null | undefined;
  teamId?: string | null | undefined;
  type: string;
  url: string;
  userId: string;
  withCache?: boolean | undefined;
};

/** @internal */
export const CreateProjectTargets$outboundSchema: z.ZodType<
  CreateProjectTargets$Outbound,
  z.ZodTypeDef,
  CreateProjectTargets
> = z.object({
  id: z.string(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  aliasError: z.nullable(
    z.lazy(() => CreateProjectProjectsAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  branchMatcher: z.lazy(() => CreateProjectProjectsBranchMatcher$outboundSchema)
    .optional(),
  buildingAt: z.number().optional(),
  builds: z.array(z.lazy(() => CreateProjectProjectsBuilds$outboundSchema))
    .optional(),
  checksConclusion: CreateProjectProjectsChecksConclusion$outboundSchema
    .optional(),
  checksState: CreateProjectProjectsChecksState$outboundSchema.optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdAt: z.number(),
  createdIn: z.string(),
  creator: z.nullable(
    z.lazy(() => CreateProjectProjectsCreator$outboundSchema),
  ),
  deletedAt: z.number().optional(),
  deploymentHostname: z.string(),
  forced: z.boolean().optional(),
  name: z.string(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  oidcTokenClaims: z.lazy(() =>
    CreateProjectProjectsOidcTokenClaims$outboundSchema
  ).optional(),
  plan: CreateProjectProjectsPlan$outboundSchema,
  previewCommentsEnabled: z.boolean().optional(),
  private: z.boolean(),
  readyAt: z.number().optional(),
  readyState: CreateProjectProjectsReadyState$outboundSchema,
  readySubstate: CreateProjectProjectsReadySubstate$outboundSchema.optional(),
  requestedAt: z.number().optional(),
  target: z.nullable(z.string()).optional(),
  teamId: z.nullable(z.string()).optional(),
  type: CreateProjectProjectsResponse200ApplicationJSONType$outboundSchema,
  url: z.string(),
  userId: z.string(),
  withCache: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTargets$ {
  /** @deprecated use `CreateProjectTargets$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTargets$inboundSchema;
  /** @deprecated use `CreateProjectTargets$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTargets$outboundSchema;
  /** @deprecated use `CreateProjectTargets$Outbound` instead. */
  export type Outbound = CreateProjectTargets$Outbound;
}

/** @internal */
export const CreateProjectPermissions$inboundSchema: z.ZodType<
  CreateProjectPermissions,
  z.ZodTypeDef,
  unknown
> = z.object({
  accessGroup: z.array(ACLAction$inboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$inboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  auditLog: z.array(ACLAction$inboundSchema).optional(),
  billingAddress: z.array(ACLAction$inboundSchema).optional(),
  billingInformation: z.array(ACLAction$inboundSchema).optional(),
  billingInvoice: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$inboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$inboundSchema).optional(),
  billingPlan: z.array(ACLAction$inboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$inboundSchema).optional(),
  billingTaxId: z.array(ACLAction$inboundSchema).optional(),
  blob: z.array(ACLAction$inboundSchema).optional(),
  budget: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$inboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$inboundSchema).optional(),
  codeChecks: z.array(ACLAction$inboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$inboundSchema).optional(),
  connect: z.array(ACLAction$inboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$inboundSchema).optional(),
  domain: z.array(ACLAction$inboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$inboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$inboundSchema).optional(),
  domainCertificate: z.array(ACLAction$inboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  domainMove: z.array(ACLAction$inboundSchema).optional(),
  domainPurchase: z.array(ACLAction$inboundSchema).optional(),
  domainRecord: z.array(ACLAction$inboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$inboundSchema).optional(),
  event: z.array(ACLAction$inboundSchema).optional(),
  ownEvent: z.array(ACLAction$inboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$inboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$inboundSchema).optional(),
  gitRepository: z.array(ACLAction$inboundSchema).optional(),
  ipBlocking: z.array(ACLAction$inboundSchema).optional(),
  integration: z.array(ACLAction$inboundSchema).optional(),
  integrationAccount: z.array(ACLAction$inboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$inboundSchema).optional(),
  integrationConfigurationProjects: z.array(ACLAction$inboundSchema).optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$inboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$inboundSchema).optional(),
  integrationResource: z.array(ACLAction$inboundSchema).optional(),
  integrationEvent: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$inboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$inboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$inboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$inboundSchema).optional(),
  jobGlobal: z.array(ACLAction$inboundSchema).optional(),
  logDrain: z.array(ACLAction$inboundSchema).optional(),
  Monitoring: z.array(ACLAction$inboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$inboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$inboundSchema).optional(),
  monitoringChart: z.array(ACLAction$inboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$inboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$inboundSchema).optional(),
  NotificationMonitoringAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$inboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$inboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$inboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$inboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$inboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$inboundSchema).optional(),
  paymentMethod: z.array(ACLAction$inboundSchema).optional(),
  permissions: z.array(ACLAction$inboundSchema).optional(),
  postgres: z.array(ACLAction$inboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$inboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  space: z.array(ACLAction$inboundSchema).optional(),
  spaceRun: z.array(ACLAction$inboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$inboundSchema).optional(),
  rateLimit: z.array(ACLAction$inboundSchema).optional(),
  redis: z.array(ACLAction$inboundSchema).optional(),
  repository: z.array(ACLAction$inboundSchema).optional(),
  remoteCaching: z.array(ACLAction$inboundSchema).optional(),
  samlConfig: z.array(ACLAction$inboundSchema).optional(),
  secret: z.array(ACLAction$inboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$inboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$inboundSchema).optional(),
  storeTransfer: z.array(ACLAction$inboundSchema).optional(),
  supportCase: z.array(ACLAction$inboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$inboundSchema).optional(),
  team: z.array(ACLAction$inboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$inboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$inboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$inboundSchema).optional(),
  teamInvite: z.array(ACLAction$inboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$inboundSchema).optional(),
  teamJoin: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$inboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$inboundSchema).optional(),
  token: z.array(ACLAction$inboundSchema).optional(),
  usage: z.array(ACLAction$inboundSchema).optional(),
  usageCycle: z.array(ACLAction$inboundSchema).optional(),
  user: z.array(ACLAction$inboundSchema).optional(),
  userConnection: z.array(ACLAction$inboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$inboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$inboundSchema).optional(),
  webAuthn: z.array(ACLAction$inboundSchema).optional(),
  edgeConfig: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$inboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$inboundSchema).optional(),
  webhook: z.array(ACLAction$inboundSchema).optional(),
  "webhook-event": z.array(ACLAction$inboundSchema).optional(),
  endpointVerification: z.array(ACLAction$inboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$inboundSchema).optional(),
  oauth2Application: z.array(ACLAction$inboundSchema).optional(),
  aliasProject: z.array(ACLAction$inboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$inboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$inboundSchema).optional(),
  deployment: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$inboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$inboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$inboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$inboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$inboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$inboundSchema).optional(),
  environments: z.array(ACLAction$inboundSchema).optional(),
  logs: z.array(ACLAction$inboundSchema).optional(),
  logsPreset: z.array(ACLAction$inboundSchema).optional(),
  passwordProtection: z.array(ACLAction$inboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$inboundSchema).optional(),
  job: z.array(ACLAction$inboundSchema).optional(),
  project: z.array(ACLAction$inboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$inboundSchema).optional(),
  projectDomain: z.array(ACLAction$inboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$inboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$inboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$inboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$inboundSchema).optional(),
  projectId: z.array(ACLAction$inboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$inboundSchema).optional(),
  projectLink: z.array(ACLAction$inboundSchema).optional(),
  projectMember: z.array(ACLAction$inboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$inboundSchema).optional(),
  projectPermissions: z.array(ACLAction$inboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$inboundSchema).optional(),
  projectTransfer: z.array(ACLAction$inboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$inboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$inboundSchema).optional(),
  projectUsage: z.array(ACLAction$inboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$inboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$inboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$inboundSchema).optional(),
  projectTier: z.array(ACLAction$inboundSchema).optional(),
  seawallConfig: z.array(ACLAction$inboundSchema).optional(),
  skewProtection: z.array(ACLAction$inboundSchema).optional(),
  analytics: z.array(ACLAction$inboundSchema).optional(),
  trustedIps: z.array(ACLAction$inboundSchema).optional(),
  webAnalytics: z.array(ACLAction$inboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$inboundSchema).optional(),
  sonar: z.array(ACLAction$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "Monitoring": "monitoring",
    "NotificationMonitoringAlert": "notificationMonitoringAlert",
    "webhook-event": "webhookEvent",
  });
});

/** @internal */
export type CreateProjectPermissions$Outbound = {
  accessGroup?: Array<string> | undefined;
  aliasGlobal?: Array<string> | undefined;
  analyticsSampling?: Array<string> | undefined;
  analyticsUsage?: Array<string> | undefined;
  auditLog?: Array<string> | undefined;
  billingAddress?: Array<string> | undefined;
  billingInformation?: Array<string> | undefined;
  billingInvoice?: Array<string> | undefined;
  billingInvoiceEmailRecipient?: Array<string> | undefined;
  billingInvoiceLanguage?: Array<string> | undefined;
  billingPlan?: Array<string> | undefined;
  billingPurchaseOrder?: Array<string> | undefined;
  billingTaxId?: Array<string> | undefined;
  blob?: Array<string> | undefined;
  budget?: Array<string> | undefined;
  cacheArtifact?: Array<string> | undefined;
  cacheArtifactUsageEvent?: Array<string> | undefined;
  codeChecks?: Array<string> | undefined;
  concurrentBuilds?: Array<string> | undefined;
  connect?: Array<string> | undefined;
  connectConfiguration?: Array<string> | undefined;
  domain?: Array<string> | undefined;
  domainAcceptDelegation?: Array<string> | undefined;
  domainAuthCodes?: Array<string> | undefined;
  domainCertificate?: Array<string> | undefined;
  domainCheckConfig?: Array<string> | undefined;
  domainMove?: Array<string> | undefined;
  domainPurchase?: Array<string> | undefined;
  domainRecord?: Array<string> | undefined;
  domainTransferIn?: Array<string> | undefined;
  event?: Array<string> | undefined;
  ownEvent?: Array<string> | undefined;
  sensitiveEnvironmentVariablePolicy?: Array<string> | undefined;
  fileUpload?: Array<string> | undefined;
  gitRepository?: Array<string> | undefined;
  ipBlocking?: Array<string> | undefined;
  integration?: Array<string> | undefined;
  integrationAccount?: Array<string> | undefined;
  integrationConfiguration?: Array<string> | undefined;
  integrationConfigurationTransfer?: Array<string> | undefined;
  integrationConfigurationProjects?: Array<string> | undefined;
  integrationVercelConfigurationOverride?: Array<string> | undefined;
  integrationConfigurationRole?: Array<string> | undefined;
  integrationResource?: Array<string> | undefined;
  integrationEvent?: Array<string> | undefined;
  integrationResourceSecrets?: Array<string> | undefined;
  integrationDeploymentAction?: Array<string> | undefined;
  marketplaceInstallationMember?: Array<string> | undefined;
  marketplaceBillingData?: Array<string> | undefined;
  marketplaceInvoice?: Array<string> | undefined;
  jobGlobal?: Array<string> | undefined;
  logDrain?: Array<string> | undefined;
  Monitoring?: Array<string> | undefined;
  monitoringSettings?: Array<string> | undefined;
  monitoringQuery?: Array<string> | undefined;
  monitoringChart?: Array<string> | undefined;
  monitoringAlert?: Array<string> | undefined;
  notificationDeploymentFailed?: Array<string> | undefined;
  notificationDomainConfiguration?: Array<string> | undefined;
  notificationDomainExpire?: Array<string> | undefined;
  notificationDomainMoved?: Array<string> | undefined;
  notificationDomainPurchase?: Array<string> | undefined;
  notificationDomainRenewal?: Array<string> | undefined;
  notificationDomainTransfer?: Array<string> | undefined;
  notificationDomainUnverified?: Array<string> | undefined;
  NotificationMonitoringAlert?: Array<string> | undefined;
  notificationPaymentFailed?: Array<string> | undefined;
  notificationUsageAlert?: Array<string> | undefined;
  notificationCustomerBudget?: Array<string> | undefined;
  notificationStatementOfReasons?: Array<string> | undefined;
  oauth2Connection?: Array<string> | undefined;
  openTelemetryEndpoint?: Array<string> | undefined;
  paymentMethod?: Array<string> | undefined;
  permissions?: Array<string> | undefined;
  postgres?: Array<string> | undefined;
  previewDeploymentSuffix?: Array<string> | undefined;
  proTrialOnboarding?: Array<string> | undefined;
  sharedEnvVars?: Array<string> | undefined;
  sharedEnvVarsProduction?: Array<string> | undefined;
  space?: Array<string> | undefined;
  spaceRun?: Array<string> | undefined;
  passwordProtectionInvoiceItem?: Array<string> | undefined;
  rateLimit?: Array<string> | undefined;
  redis?: Array<string> | undefined;
  repository?: Array<string> | undefined;
  remoteCaching?: Array<string> | undefined;
  samlConfig?: Array<string> | undefined;
  secret?: Array<string> | undefined;
  redisStoreTokenSet?: Array<string> | undefined;
  blobStoreTokenSet?: Array<string> | undefined;
  postgresStoreTokenSet?: Array<string> | undefined;
  integrationStoreTokenSet?: Array<string> | undefined;
  integrationResourceReplCommand?: Array<string> | undefined;
  storeTransfer?: Array<string> | undefined;
  supportCase?: Array<string> | undefined;
  supportCaseComment?: Array<string> | undefined;
  dataCacheBillingSettings?: Array<string> | undefined;
  team?: Array<string> | undefined;
  teamAccessRequest?: Array<string> | undefined;
  teamFellowMembership?: Array<string> | undefined;
  teamGitExclusivity?: Array<string> | undefined;
  teamInvite?: Array<string> | undefined;
  teamInviteCode?: Array<string> | undefined;
  teamJoin?: Array<string> | undefined;
  teamOwnMembership?: Array<string> | undefined;
  teamOwnMembershipDisconnectSAML?: Array<string> | undefined;
  token?: Array<string> | undefined;
  usage?: Array<string> | undefined;
  usageCycle?: Array<string> | undefined;
  user?: Array<string> | undefined;
  userConnection?: Array<string> | undefined;
  vpcPeeringConnection?: Array<string> | undefined;
  webAnalyticsPlan?: Array<string> | undefined;
  webAuthn?: Array<string> | undefined;
  edgeConfig?: Array<string> | undefined;
  edgeConfigItem?: Array<string> | undefined;
  edgeConfigSchema?: Array<string> | undefined;
  edgeConfigToken?: Array<string> | undefined;
  webhook?: Array<string> | undefined;
  "webhook-event"?: Array<string> | undefined;
  endpointVerification?: Array<string> | undefined;
  projectTransferIn?: Array<string> | undefined;
  oauth2Application?: Array<string> | undefined;
  aliasProject?: Array<string> | undefined;
  aliasProtectionBypass?: Array<string> | undefined;
  productionAliasProtectionBypass?: Array<string> | undefined;
  connectConfigurationLink?: Array<string> | undefined;
  dataCacheNamespace?: Array<string> | undefined;
  deployment?: Array<string> | undefined;
  deploymentCheck?: Array<string> | undefined;
  deploymentCheckPreview?: Array<string> | undefined;
  deploymentCheckReRunFromProductionBranch?: Array<string> | undefined;
  deploymentProductionGit?: Array<string> | undefined;
  deploymentPreview?: Array<string> | undefined;
  deploymentPrivate?: Array<string> | undefined;
  deploymentPromote?: Array<string> | undefined;
  deploymentRollback?: Array<string> | undefined;
  environments?: Array<string> | undefined;
  logs?: Array<string> | undefined;
  logsPreset?: Array<string> | undefined;
  passwordProtection?: Array<string> | undefined;
  optionsAllowlist?: Array<string> | undefined;
  job?: Array<string> | undefined;
  project?: Array<string> | undefined;
  projectAccessGroup?: Array<string> | undefined;
  projectAnalyticsSampling?: Array<string> | undefined;
  projectDeploymentHook?: Array<string> | undefined;
  projectDomain?: Array<string> | undefined;
  projectDomainMove?: Array<string> | undefined;
  projectDomainCheckConfig?: Array<string> | undefined;
  projectEnvVars?: Array<string> | undefined;
  projectEnvVarsProduction?: Array<string> | undefined;
  projectEnvVarsUnownedByIntegration?: Array<string> | undefined;
  projectFlags?: Array<string> | undefined;
  projectId?: Array<string> | undefined;
  projectIntegrationConfiguration?: Array<string> | undefined;
  projectLink?: Array<string> | undefined;
  projectMember?: Array<string> | undefined;
  projectMonitoring?: Array<string> | undefined;
  projectPermissions?: Array<string> | undefined;
  projectProductionBranch?: Array<string> | undefined;
  projectTransfer?: Array<string> | undefined;
  projectTransferOut?: Array<string> | undefined;
  projectProtectionBypass?: Array<string> | undefined;
  projectUsage?: Array<string> | undefined;
  projectAnalyticsUsage?: Array<string> | undefined;
  projectSupportCase?: Array<string> | undefined;
  projectSupportCaseComment?: Array<string> | undefined;
  projectDeploymentExpiration?: Array<string> | undefined;
  projectTier?: Array<string> | undefined;
  seawallConfig?: Array<string> | undefined;
  skewProtection?: Array<string> | undefined;
  analytics?: Array<string> | undefined;
  trustedIps?: Array<string> | undefined;
  webAnalytics?: Array<string> | undefined;
  sharedEnvVarConnection?: Array<string> | undefined;
  sonar?: Array<string> | undefined;
};

/** @internal */
export const CreateProjectPermissions$outboundSchema: z.ZodType<
  CreateProjectPermissions$Outbound,
  z.ZodTypeDef,
  CreateProjectPermissions
> = z.object({
  accessGroup: z.array(ACLAction$outboundSchema).optional(),
  aliasGlobal: z.array(ACLAction$outboundSchema).optional(),
  analyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  analyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  auditLog: z.array(ACLAction$outboundSchema).optional(),
  billingAddress: z.array(ACLAction$outboundSchema).optional(),
  billingInformation: z.array(ACLAction$outboundSchema).optional(),
  billingInvoice: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceEmailRecipient: z.array(ACLAction$outboundSchema).optional(),
  billingInvoiceLanguage: z.array(ACLAction$outboundSchema).optional(),
  billingPlan: z.array(ACLAction$outboundSchema).optional(),
  billingPurchaseOrder: z.array(ACLAction$outboundSchema).optional(),
  billingTaxId: z.array(ACLAction$outboundSchema).optional(),
  blob: z.array(ACLAction$outboundSchema).optional(),
  budget: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifact: z.array(ACLAction$outboundSchema).optional(),
  cacheArtifactUsageEvent: z.array(ACLAction$outboundSchema).optional(),
  codeChecks: z.array(ACLAction$outboundSchema).optional(),
  concurrentBuilds: z.array(ACLAction$outboundSchema).optional(),
  connect: z.array(ACLAction$outboundSchema).optional(),
  connectConfiguration: z.array(ACLAction$outboundSchema).optional(),
  domain: z.array(ACLAction$outboundSchema).optional(),
  domainAcceptDelegation: z.array(ACLAction$outboundSchema).optional(),
  domainAuthCodes: z.array(ACLAction$outboundSchema).optional(),
  domainCertificate: z.array(ACLAction$outboundSchema).optional(),
  domainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  domainMove: z.array(ACLAction$outboundSchema).optional(),
  domainPurchase: z.array(ACLAction$outboundSchema).optional(),
  domainRecord: z.array(ACLAction$outboundSchema).optional(),
  domainTransferIn: z.array(ACLAction$outboundSchema).optional(),
  event: z.array(ACLAction$outboundSchema).optional(),
  ownEvent: z.array(ACLAction$outboundSchema).optional(),
  sensitiveEnvironmentVariablePolicy: z.array(ACLAction$outboundSchema)
    .optional(),
  fileUpload: z.array(ACLAction$outboundSchema).optional(),
  gitRepository: z.array(ACLAction$outboundSchema).optional(),
  ipBlocking: z.array(ACLAction$outboundSchema).optional(),
  integration: z.array(ACLAction$outboundSchema).optional(),
  integrationAccount: z.array(ACLAction$outboundSchema).optional(),
  integrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  integrationConfigurationTransfer: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationProjects: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationVercelConfigurationOverride: z.array(ACLAction$outboundSchema)
    .optional(),
  integrationConfigurationRole: z.array(ACLAction$outboundSchema).optional(),
  integrationResource: z.array(ACLAction$outboundSchema).optional(),
  integrationEvent: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceSecrets: z.array(ACLAction$outboundSchema).optional(),
  integrationDeploymentAction: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInstallationMember: z.array(ACLAction$outboundSchema).optional(),
  marketplaceBillingData: z.array(ACLAction$outboundSchema).optional(),
  marketplaceInvoice: z.array(ACLAction$outboundSchema).optional(),
  jobGlobal: z.array(ACLAction$outboundSchema).optional(),
  logDrain: z.array(ACLAction$outboundSchema).optional(),
  monitoring: z.array(ACLAction$outboundSchema).optional(),
  monitoringSettings: z.array(ACLAction$outboundSchema).optional(),
  monitoringQuery: z.array(ACLAction$outboundSchema).optional(),
  monitoringChart: z.array(ACLAction$outboundSchema).optional(),
  monitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationDeploymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainConfiguration: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainExpire: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainMoved: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainPurchase: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainRenewal: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainTransfer: z.array(ACLAction$outboundSchema).optional(),
  notificationDomainUnverified: z.array(ACLAction$outboundSchema).optional(),
  notificationMonitoringAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationPaymentFailed: z.array(ACLAction$outboundSchema).optional(),
  notificationUsageAlert: z.array(ACLAction$outboundSchema).optional(),
  notificationCustomerBudget: z.array(ACLAction$outboundSchema).optional(),
  notificationStatementOfReasons: z.array(ACLAction$outboundSchema).optional(),
  oauth2Connection: z.array(ACLAction$outboundSchema).optional(),
  openTelemetryEndpoint: z.array(ACLAction$outboundSchema).optional(),
  paymentMethod: z.array(ACLAction$outboundSchema).optional(),
  permissions: z.array(ACLAction$outboundSchema).optional(),
  postgres: z.array(ACLAction$outboundSchema).optional(),
  previewDeploymentSuffix: z.array(ACLAction$outboundSchema).optional(),
  proTrialOnboarding: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVars: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  space: z.array(ACLAction$outboundSchema).optional(),
  spaceRun: z.array(ACLAction$outboundSchema).optional(),
  passwordProtectionInvoiceItem: z.array(ACLAction$outboundSchema).optional(),
  rateLimit: z.array(ACLAction$outboundSchema).optional(),
  redis: z.array(ACLAction$outboundSchema).optional(),
  repository: z.array(ACLAction$outboundSchema).optional(),
  remoteCaching: z.array(ACLAction$outboundSchema).optional(),
  samlConfig: z.array(ACLAction$outboundSchema).optional(),
  secret: z.array(ACLAction$outboundSchema).optional(),
  redisStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  blobStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  postgresStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationStoreTokenSet: z.array(ACLAction$outboundSchema).optional(),
  integrationResourceReplCommand: z.array(ACLAction$outboundSchema).optional(),
  storeTransfer: z.array(ACLAction$outboundSchema).optional(),
  supportCase: z.array(ACLAction$outboundSchema).optional(),
  supportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  dataCacheBillingSettings: z.array(ACLAction$outboundSchema).optional(),
  team: z.array(ACLAction$outboundSchema).optional(),
  teamAccessRequest: z.array(ACLAction$outboundSchema).optional(),
  teamFellowMembership: z.array(ACLAction$outboundSchema).optional(),
  teamGitExclusivity: z.array(ACLAction$outboundSchema).optional(),
  teamInvite: z.array(ACLAction$outboundSchema).optional(),
  teamInviteCode: z.array(ACLAction$outboundSchema).optional(),
  teamJoin: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembership: z.array(ACLAction$outboundSchema).optional(),
  teamOwnMembershipDisconnectSAML: z.array(ACLAction$outboundSchema).optional(),
  token: z.array(ACLAction$outboundSchema).optional(),
  usage: z.array(ACLAction$outboundSchema).optional(),
  usageCycle: z.array(ACLAction$outboundSchema).optional(),
  user: z.array(ACLAction$outboundSchema).optional(),
  userConnection: z.array(ACLAction$outboundSchema).optional(),
  vpcPeeringConnection: z.array(ACLAction$outboundSchema).optional(),
  webAnalyticsPlan: z.array(ACLAction$outboundSchema).optional(),
  webAuthn: z.array(ACLAction$outboundSchema).optional(),
  edgeConfig: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigItem: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigSchema: z.array(ACLAction$outboundSchema).optional(),
  edgeConfigToken: z.array(ACLAction$outboundSchema).optional(),
  webhook: z.array(ACLAction$outboundSchema).optional(),
  webhookEvent: z.array(ACLAction$outboundSchema).optional(),
  endpointVerification: z.array(ACLAction$outboundSchema).optional(),
  projectTransferIn: z.array(ACLAction$outboundSchema).optional(),
  oauth2Application: z.array(ACLAction$outboundSchema).optional(),
  aliasProject: z.array(ACLAction$outboundSchema).optional(),
  aliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  productionAliasProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  connectConfigurationLink: z.array(ACLAction$outboundSchema).optional(),
  dataCacheNamespace: z.array(ACLAction$outboundSchema).optional(),
  deployment: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheck: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentCheckReRunFromProductionBranch: z.array(ACLAction$outboundSchema)
    .optional(),
  deploymentProductionGit: z.array(ACLAction$outboundSchema).optional(),
  deploymentPreview: z.array(ACLAction$outboundSchema).optional(),
  deploymentPrivate: z.array(ACLAction$outboundSchema).optional(),
  deploymentPromote: z.array(ACLAction$outboundSchema).optional(),
  deploymentRollback: z.array(ACLAction$outboundSchema).optional(),
  environments: z.array(ACLAction$outboundSchema).optional(),
  logs: z.array(ACLAction$outboundSchema).optional(),
  logsPreset: z.array(ACLAction$outboundSchema).optional(),
  passwordProtection: z.array(ACLAction$outboundSchema).optional(),
  optionsAllowlist: z.array(ACLAction$outboundSchema).optional(),
  job: z.array(ACLAction$outboundSchema).optional(),
  project: z.array(ACLAction$outboundSchema).optional(),
  projectAccessGroup: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsSampling: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentHook: z.array(ACLAction$outboundSchema).optional(),
  projectDomain: z.array(ACLAction$outboundSchema).optional(),
  projectDomainMove: z.array(ACLAction$outboundSchema).optional(),
  projectDomainCheckConfig: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVars: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsProduction: z.array(ACLAction$outboundSchema).optional(),
  projectEnvVarsUnownedByIntegration: z.array(ACLAction$outboundSchema)
    .optional(),
  projectFlags: z.array(ACLAction$outboundSchema).optional(),
  projectId: z.array(ACLAction$outboundSchema).optional(),
  projectIntegrationConfiguration: z.array(ACLAction$outboundSchema).optional(),
  projectLink: z.array(ACLAction$outboundSchema).optional(),
  projectMember: z.array(ACLAction$outboundSchema).optional(),
  projectMonitoring: z.array(ACLAction$outboundSchema).optional(),
  projectPermissions: z.array(ACLAction$outboundSchema).optional(),
  projectProductionBranch: z.array(ACLAction$outboundSchema).optional(),
  projectTransfer: z.array(ACLAction$outboundSchema).optional(),
  projectTransferOut: z.array(ACLAction$outboundSchema).optional(),
  projectProtectionBypass: z.array(ACLAction$outboundSchema).optional(),
  projectUsage: z.array(ACLAction$outboundSchema).optional(),
  projectAnalyticsUsage: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCase: z.array(ACLAction$outboundSchema).optional(),
  projectSupportCaseComment: z.array(ACLAction$outboundSchema).optional(),
  projectDeploymentExpiration: z.array(ACLAction$outboundSchema).optional(),
  projectTier: z.array(ACLAction$outboundSchema).optional(),
  seawallConfig: z.array(ACLAction$outboundSchema).optional(),
  skewProtection: z.array(ACLAction$outboundSchema).optional(),
  analytics: z.array(ACLAction$outboundSchema).optional(),
  trustedIps: z.array(ACLAction$outboundSchema).optional(),
  webAnalytics: z.array(ACLAction$outboundSchema).optional(),
  sharedEnvVarConnection: z.array(ACLAction$outboundSchema).optional(),
  sonar: z.array(ACLAction$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    monitoring: "Monitoring",
    notificationMonitoringAlert: "NotificationMonitoringAlert",
    webhookEvent: "webhook-event",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectPermissions$ {
  /** @deprecated use `CreateProjectPermissions$inboundSchema` instead. */
  export const inboundSchema = CreateProjectPermissions$inboundSchema;
  /** @deprecated use `CreateProjectPermissions$outboundSchema` instead. */
  export const outboundSchema = CreateProjectPermissions$outboundSchema;
  /** @deprecated use `CreateProjectPermissions$Outbound` instead. */
  export type Outbound = CreateProjectPermissions$Outbound;
}

/** @internal */
export const CreateProjectLastRollbackTarget$inboundSchema: z.ZodType<
  CreateProjectLastRollbackTarget,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CreateProjectLastRollbackTarget$Outbound = {};

/** @internal */
export const CreateProjectLastRollbackTarget$outboundSchema: z.ZodType<
  CreateProjectLastRollbackTarget$Outbound,
  z.ZodTypeDef,
  CreateProjectLastRollbackTarget
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLastRollbackTarget$ {
  /** @deprecated use `CreateProjectLastRollbackTarget$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLastRollbackTarget$inboundSchema;
  /** @deprecated use `CreateProjectLastRollbackTarget$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLastRollbackTarget$outboundSchema;
  /** @deprecated use `CreateProjectLastRollbackTarget$Outbound` instead. */
  export type Outbound = CreateProjectLastRollbackTarget$Outbound;
}

/** @internal */
export const CreateProjectJobStatus$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectJobStatus
> = z.nativeEnum(CreateProjectJobStatus);

/** @internal */
export const CreateProjectJobStatus$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectJobStatus
> = CreateProjectJobStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectJobStatus$ {
  /** @deprecated use `CreateProjectJobStatus$inboundSchema` instead. */
  export const inboundSchema = CreateProjectJobStatus$inboundSchema;
  /** @deprecated use `CreateProjectJobStatus$outboundSchema` instead. */
  export const outboundSchema = CreateProjectJobStatus$outboundSchema;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodyType
  > =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const CreateProjectLastAliasRequest$inboundSchema: z.ZodType<
  CreateProjectLastAliasRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: CreateProjectJobStatus$inboundSchema,
  requestedAt: z.number(),
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$inboundSchema,
});

/** @internal */
export type CreateProjectLastAliasRequest$Outbound = {
  fromDeploymentId: string;
  toDeploymentId: string;
  jobStatus: string;
  requestedAt: number;
  type: string;
};

/** @internal */
export const CreateProjectLastAliasRequest$outboundSchema: z.ZodType<
  CreateProjectLastAliasRequest$Outbound,
  z.ZodTypeDef,
  CreateProjectLastAliasRequest
> = z.object({
  fromDeploymentId: z.string(),
  toDeploymentId: z.string(),
  jobStatus: CreateProjectJobStatus$outboundSchema,
  requestedAt: z.number(),
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodyType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectLastAliasRequest$ {
  /** @deprecated use `CreateProjectLastAliasRequest$inboundSchema` instead. */
  export const inboundSchema = CreateProjectLastAliasRequest$inboundSchema;
  /** @deprecated use `CreateProjectLastAliasRequest$outboundSchema` instead. */
  export const outboundSchema = CreateProjectLastAliasRequest$outboundSchema;
  /** @deprecated use `CreateProjectLastAliasRequest$Outbound` instead. */
  export type Outbound = CreateProjectLastAliasRequest$Outbound;
}

/** @internal */
export const CreateProjectScope$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectScope
> = z.nativeEnum(CreateProjectScope);

/** @internal */
export const CreateProjectScope$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectScope
> = CreateProjectScope$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectScope$ {
  /** @deprecated use `CreateProjectScope$inboundSchema` instead. */
  export const inboundSchema = CreateProjectScope$inboundSchema;
  /** @deprecated use `CreateProjectScope$outboundSchema` instead. */
  export const outboundSchema = CreateProjectScope$outboundSchema;
}

/** @internal */
export const CreateProjectProtectionBypass$inboundSchema: z.ZodType<
  CreateProjectProtectionBypass,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: CreateProjectScope$inboundSchema,
});

/** @internal */
export type CreateProjectProtectionBypass$Outbound = {
  createdAt: number;
  createdBy: string;
  scope: string;
};

/** @internal */
export const CreateProjectProtectionBypass$outboundSchema: z.ZodType<
  CreateProjectProtectionBypass$Outbound,
  z.ZodTypeDef,
  CreateProjectProtectionBypass
> = z.object({
  createdAt: z.number(),
  createdBy: z.string(),
  scope: CreateProjectScope$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProtectionBypass$ {
  /** @deprecated use `CreateProjectProtectionBypass$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProtectionBypass$inboundSchema;
  /** @deprecated use `CreateProjectProtectionBypass$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProtectionBypass$outboundSchema;
  /** @deprecated use `CreateProjectProtectionBypass$Outbound` instead. */
  export type Outbound = CreateProjectProtectionBypass$Outbound;
}

/** @internal */
export const CreateProjectTrustedIpsProjectsDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectTrustedIpsProjectsDeploymentType> = z
    .nativeEnum(CreateProjectTrustedIpsProjectsDeploymentType);

/** @internal */
export const CreateProjectTrustedIpsProjectsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectTrustedIpsProjectsDeploymentType> =
    CreateProjectTrustedIpsProjectsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTrustedIpsProjectsDeploymentType$ {
  /** @deprecated use `CreateProjectTrustedIpsProjectsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectTrustedIpsProjectsDeploymentType$inboundSchema;
  /** @deprecated use `CreateProjectTrustedIpsProjectsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectTrustedIpsProjectsDeploymentType$outboundSchema;
}

/** @internal */
export const CreateProjectTrustedIps2$inboundSchema: z.ZodType<
  CreateProjectTrustedIps2,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: CreateProjectTrustedIpsProjectsDeploymentType$inboundSchema,
});

/** @internal */
export type CreateProjectTrustedIps2$Outbound = {
  deploymentType: string;
};

/** @internal */
export const CreateProjectTrustedIps2$outboundSchema: z.ZodType<
  CreateProjectTrustedIps2$Outbound,
  z.ZodTypeDef,
  CreateProjectTrustedIps2
> = z.object({
  deploymentType: CreateProjectTrustedIpsProjectsDeploymentType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTrustedIps2$ {
  /** @deprecated use `CreateProjectTrustedIps2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTrustedIps2$inboundSchema;
  /** @deprecated use `CreateProjectTrustedIps2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTrustedIps2$outboundSchema;
  /** @deprecated use `CreateProjectTrustedIps2$Outbound` instead. */
  export type Outbound = CreateProjectTrustedIps2$Outbound;
}

/** @internal */
export const CreateProjectTrustedIpsDeploymentType$inboundSchema:
  z.ZodNativeEnum<typeof CreateProjectTrustedIpsDeploymentType> = z.nativeEnum(
    CreateProjectTrustedIpsDeploymentType,
  );

/** @internal */
export const CreateProjectTrustedIpsDeploymentType$outboundSchema:
  z.ZodNativeEnum<typeof CreateProjectTrustedIpsDeploymentType> =
    CreateProjectTrustedIpsDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTrustedIpsDeploymentType$ {
  /** @deprecated use `CreateProjectTrustedIpsDeploymentType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectTrustedIpsDeploymentType$inboundSchema;
  /** @deprecated use `CreateProjectTrustedIpsDeploymentType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectTrustedIpsDeploymentType$outboundSchema;
}

/** @internal */
export const TrustedIpsAddresses$inboundSchema: z.ZodType<
  TrustedIpsAddresses,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/** @internal */
export type TrustedIpsAddresses$Outbound = {
  value: string;
  note?: string | undefined;
};

/** @internal */
export const TrustedIpsAddresses$outboundSchema: z.ZodType<
  TrustedIpsAddresses$Outbound,
  z.ZodTypeDef,
  TrustedIpsAddresses
> = z.object({
  value: z.string(),
  note: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TrustedIpsAddresses$ {
  /** @deprecated use `TrustedIpsAddresses$inboundSchema` instead. */
  export const inboundSchema = TrustedIpsAddresses$inboundSchema;
  /** @deprecated use `TrustedIpsAddresses$outboundSchema` instead. */
  export const outboundSchema = TrustedIpsAddresses$outboundSchema;
  /** @deprecated use `TrustedIpsAddresses$Outbound` instead. */
  export type Outbound = TrustedIpsAddresses$Outbound;
}

/** @internal */
export const TrustedIpsProtectionMode$inboundSchema: z.ZodNativeEnum<
  typeof TrustedIpsProtectionMode
> = z.nativeEnum(TrustedIpsProtectionMode);

/** @internal */
export const TrustedIpsProtectionMode$outboundSchema: z.ZodNativeEnum<
  typeof TrustedIpsProtectionMode
> = TrustedIpsProtectionMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace TrustedIpsProtectionMode$ {
  /** @deprecated use `TrustedIpsProtectionMode$inboundSchema` instead. */
  export const inboundSchema = TrustedIpsProtectionMode$inboundSchema;
  /** @deprecated use `TrustedIpsProtectionMode$outboundSchema` instead. */
  export const outboundSchema = TrustedIpsProtectionMode$outboundSchema;
}

/** @internal */
export const CreateProjectTrustedIps1$inboundSchema: z.ZodType<
  CreateProjectTrustedIps1,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentType: CreateProjectTrustedIpsDeploymentType$inboundSchema,
  addresses: z.array(z.lazy(() => TrustedIpsAddresses$inboundSchema)),
  protectionMode: TrustedIpsProtectionMode$inboundSchema,
});

/** @internal */
export type CreateProjectTrustedIps1$Outbound = {
  deploymentType: string;
  addresses: Array<TrustedIpsAddresses$Outbound>;
  protectionMode: string;
};

/** @internal */
export const CreateProjectTrustedIps1$outboundSchema: z.ZodType<
  CreateProjectTrustedIps1$Outbound,
  z.ZodTypeDef,
  CreateProjectTrustedIps1
> = z.object({
  deploymentType: CreateProjectTrustedIpsDeploymentType$outboundSchema,
  addresses: z.array(z.lazy(() => TrustedIpsAddresses$outboundSchema)),
  protectionMode: TrustedIpsProtectionMode$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTrustedIps1$ {
  /** @deprecated use `CreateProjectTrustedIps1$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTrustedIps1$inboundSchema;
  /** @deprecated use `CreateProjectTrustedIps1$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTrustedIps1$outboundSchema;
  /** @deprecated use `CreateProjectTrustedIps1$Outbound` instead. */
  export type Outbound = CreateProjectTrustedIps1$Outbound;
}

/** @internal */
export const CreateProjectTrustedIps$inboundSchema: z.ZodType<
  CreateProjectTrustedIps,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectTrustedIps2$inboundSchema),
  z.lazy(() => CreateProjectTrustedIps1$inboundSchema),
]);

/** @internal */
export type CreateProjectTrustedIps$Outbound =
  | CreateProjectTrustedIps2$Outbound
  | CreateProjectTrustedIps1$Outbound;

/** @internal */
export const CreateProjectTrustedIps$outboundSchema: z.ZodType<
  CreateProjectTrustedIps$Outbound,
  z.ZodTypeDef,
  CreateProjectTrustedIps
> = z.union([
  z.lazy(() => CreateProjectTrustedIps2$outboundSchema),
  z.lazy(() => CreateProjectTrustedIps1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTrustedIps$ {
  /** @deprecated use `CreateProjectTrustedIps$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTrustedIps$inboundSchema;
  /** @deprecated use `CreateProjectTrustedIps$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTrustedIps$outboundSchema;
  /** @deprecated use `CreateProjectTrustedIps$Outbound` instead. */
  export type Outbound = CreateProjectTrustedIps$Outbound;
}

/** @internal */
export const CreateProjectGitComments$inboundSchema: z.ZodType<
  CreateProjectGitComments,
  z.ZodTypeDef,
  unknown
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/** @internal */
export type CreateProjectGitComments$Outbound = {
  onPullRequest: boolean;
  onCommit: boolean;
};

/** @internal */
export const CreateProjectGitComments$outboundSchema: z.ZodType<
  CreateProjectGitComments$Outbound,
  z.ZodTypeDef,
  CreateProjectGitComments
> = z.object({
  onPullRequest: z.boolean(),
  onCommit: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectGitComments$ {
  /** @deprecated use `CreateProjectGitComments$inboundSchema` instead. */
  export const inboundSchema = CreateProjectGitComments$inboundSchema;
  /** @deprecated use `CreateProjectGitComments$outboundSchema` instead. */
  export const outboundSchema = CreateProjectGitComments$outboundSchema;
  /** @deprecated use `CreateProjectGitComments$Outbound` instead. */
  export type Outbound = CreateProjectGitComments$Outbound;
}

/** @internal */
export const CreateProjectWebAnalytics$inboundSchema: z.ZodType<
  CreateProjectWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type CreateProjectWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const CreateProjectWebAnalytics$outboundSchema: z.ZodType<
  CreateProjectWebAnalytics$Outbound,
  z.ZodTypeDef,
  CreateProjectWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectWebAnalytics$ {
  /** @deprecated use `CreateProjectWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = CreateProjectWebAnalytics$inboundSchema;
  /** @deprecated use `CreateProjectWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = CreateProjectWebAnalytics$outboundSchema;
  /** @deprecated use `CreateProjectWebAnalytics$Outbound` instead. */
  export type Outbound = CreateProjectWebAnalytics$Outbound;
}

/** @internal */
export const CreateProjectSrc2$inboundSchema: z.ZodType<
  CreateProjectSrc2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type CreateProjectSrc2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const CreateProjectSrc2$outboundSchema: z.ZodType<
  CreateProjectSrc2$Outbound,
  z.ZodTypeDef,
  CreateProjectSrc2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectSrc2$ {
  /** @deprecated use `CreateProjectSrc2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectSrc2$inboundSchema;
  /** @deprecated use `CreateProjectSrc2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectSrc2$outboundSchema;
  /** @deprecated use `CreateProjectSrc2$Outbound` instead. */
  export type Outbound = CreateProjectSrc2$Outbound;
}

/** @internal */
export const CreateProjectSrc$inboundSchema: z.ZodType<
  CreateProjectSrc,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => CreateProjectSrc2$inboundSchema), z.string()]);

/** @internal */
export type CreateProjectSrc$Outbound = CreateProjectSrc2$Outbound | string;

/** @internal */
export const CreateProjectSrc$outboundSchema: z.ZodType<
  CreateProjectSrc$Outbound,
  z.ZodTypeDef,
  CreateProjectSrc
> = z.union([z.lazy(() => CreateProjectSrc2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectSrc$ {
  /** @deprecated use `CreateProjectSrc$inboundSchema` instead. */
  export const inboundSchema = CreateProjectSrc$inboundSchema;
  /** @deprecated use `CreateProjectSrc$outboundSchema` instead. */
  export const outboundSchema = CreateProjectSrc$outboundSchema;
  /** @deprecated use `CreateProjectSrc$Outbound` instead. */
  export type Outbound = CreateProjectSrc$Outbound;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType
  > = z.nativeEnum(
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType,
  );

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType
  > =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema;
}

/** @internal */
export const CreateProjectValue2$inboundSchema: z.ZodType<
  CreateProjectValue2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type CreateProjectValue2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const CreateProjectValue2$outboundSchema: z.ZodType<
  CreateProjectValue2$Outbound,
  z.ZodTypeDef,
  CreateProjectValue2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectValue2$ {
  /** @deprecated use `CreateProjectValue2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectValue2$inboundSchema;
  /** @deprecated use `CreateProjectValue2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectValue2$outboundSchema;
  /** @deprecated use `CreateProjectValue2$Outbound` instead. */
  export type Outbound = CreateProjectValue2$Outbound;
}

/** @internal */
export const CreateProjectValue$inboundSchema: z.ZodType<
  CreateProjectValue,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => CreateProjectValue2$inboundSchema), z.string()]);

/** @internal */
export type CreateProjectValue$Outbound = CreateProjectValue2$Outbound | string;

/** @internal */
export const CreateProjectValue$outboundSchema: z.ZodType<
  CreateProjectValue$Outbound,
  z.ZodTypeDef,
  CreateProjectValue
> = z.union([z.lazy(() => CreateProjectValue2$outboundSchema), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectValue$ {
  /** @deprecated use `CreateProjectValue$inboundSchema` instead. */
  export const inboundSchema = CreateProjectValue$inboundSchema;
  /** @deprecated use `CreateProjectValue$outboundSchema` instead. */
  export const outboundSchema = CreateProjectValue$outboundSchema;
  /** @deprecated use `CreateProjectValue$Outbound` instead. */
  export type Outbound = CreateProjectValue$Outbound;
}

/** @internal */
export const CreateProjectHas$inboundSchema: z.ZodType<
  CreateProjectHas,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$inboundSchema,
  key: z.string().optional(),
  value: z.union([z.lazy(() => CreateProjectValue2$inboundSchema), z.string()])
    .optional(),
});

/** @internal */
export type CreateProjectHas$Outbound = {
  type: string;
  key?: string | undefined;
  value?: CreateProjectValue2$Outbound | string | undefined;
};

/** @internal */
export const CreateProjectHas$outboundSchema: z.ZodType<
  CreateProjectHas$Outbound,
  z.ZodTypeDef,
  CreateProjectHas
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityType$outboundSchema,
  key: z.string().optional(),
  value: z.union([z.lazy(() => CreateProjectValue2$outboundSchema), z.string()])
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectHas$ {
  /** @deprecated use `CreateProjectHas$inboundSchema` instead. */
  export const inboundSchema = CreateProjectHas$inboundSchema;
  /** @deprecated use `CreateProjectHas$outboundSchema` instead. */
  export const outboundSchema = CreateProjectHas$outboundSchema;
  /** @deprecated use `CreateProjectHas$Outbound` instead. */
  export type Outbound = CreateProjectHas$Outbound;
}

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  > = z.nativeEnum(
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType,
  );

/** @internal */
export const CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType
  > =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$ {
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema` instead. */
  export const inboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema;
  /** @deprecated use `CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema` instead. */
  export const outboundSchema =
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema;
}

/** @internal */
export const CreateProjectValueProjects2$inboundSchema: z.ZodType<
  CreateProjectValueProjects2,
  z.ZodTypeDef,
  unknown
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/** @internal */
export type CreateProjectValueProjects2$Outbound = {
  re?: string | undefined;
  eq?: string | undefined;
  neq?: string | undefined;
  inc?: Array<string> | undefined;
  ninc?: Array<string> | undefined;
  pre?: string | undefined;
  suf?: string | undefined;
  gt?: number | undefined;
  gte?: number | undefined;
  lt?: number | undefined;
  lte?: number | undefined;
};

/** @internal */
export const CreateProjectValueProjects2$outboundSchema: z.ZodType<
  CreateProjectValueProjects2$Outbound,
  z.ZodTypeDef,
  CreateProjectValueProjects2
> = z.object({
  re: z.string().optional(),
  eq: z.string().optional(),
  neq: z.string().optional(),
  inc: z.array(z.string()).optional(),
  ninc: z.array(z.string()).optional(),
  pre: z.string().optional(),
  suf: z.string().optional(),
  gt: z.number().optional(),
  gte: z.number().optional(),
  lt: z.number().optional(),
  lte: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectValueProjects2$ {
  /** @deprecated use `CreateProjectValueProjects2$inboundSchema` instead. */
  export const inboundSchema = CreateProjectValueProjects2$inboundSchema;
  /** @deprecated use `CreateProjectValueProjects2$outboundSchema` instead. */
  export const outboundSchema = CreateProjectValueProjects2$outboundSchema;
  /** @deprecated use `CreateProjectValueProjects2$Outbound` instead. */
  export type Outbound = CreateProjectValueProjects2$Outbound;
}

/** @internal */
export const CreateProjectProjectsValue$inboundSchema: z.ZodType<
  CreateProjectProjectsValue,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateProjectValueProjects2$inboundSchema),
  z.string(),
]);

/** @internal */
export type CreateProjectProjectsValue$Outbound =
  | CreateProjectValueProjects2$Outbound
  | string;

/** @internal */
export const CreateProjectProjectsValue$outboundSchema: z.ZodType<
  CreateProjectProjectsValue$Outbound,
  z.ZodTypeDef,
  CreateProjectProjectsValue
> = z.union([
  z.lazy(() => CreateProjectValueProjects2$outboundSchema),
  z.string(),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectProjectsValue$ {
  /** @deprecated use `CreateProjectProjectsValue$inboundSchema` instead. */
  export const inboundSchema = CreateProjectProjectsValue$inboundSchema;
  /** @deprecated use `CreateProjectProjectsValue$outboundSchema` instead. */
  export const outboundSchema = CreateProjectProjectsValue$outboundSchema;
  /** @deprecated use `CreateProjectProjectsValue$Outbound` instead. */
  export type Outbound = CreateProjectProjectsValue$Outbound;
}

/** @internal */
export const CreateProjectMissing$inboundSchema: z.ZodType<
  CreateProjectMissing,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$inboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => CreateProjectValueProjects2$inboundSchema),
    z.string(),
  ]).optional(),
});

/** @internal */
export type CreateProjectMissing$Outbound = {
  type: string;
  key?: string | undefined;
  value?: CreateProjectValueProjects2$Outbound | string | undefined;
};

/** @internal */
export const CreateProjectMissing$outboundSchema: z.ZodType<
  CreateProjectMissing$Outbound,
  z.ZodTypeDef,
  CreateProjectMissing
> = z.object({
  type:
    CreateProjectProjectsResponse200ApplicationJSONResponseBodySecurityFirewallRoutesType$outboundSchema,
  key: z.string().optional(),
  value: z.union([
    z.lazy(() => CreateProjectValueProjects2$outboundSchema),
    z.string(),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectMissing$ {
  /** @deprecated use `CreateProjectMissing$inboundSchema` instead. */
  export const inboundSchema = CreateProjectMissing$inboundSchema;
  /** @deprecated use `CreateProjectMissing$outboundSchema` instead. */
  export const outboundSchema = CreateProjectMissing$outboundSchema;
  /** @deprecated use `CreateProjectMissing$Outbound` instead. */
  export type Outbound = CreateProjectMissing$Outbound;
}

/** @internal */
export const CreateProjectHandle$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectHandle
> = z.nativeEnum(CreateProjectHandle);

/** @internal */
export const CreateProjectHandle$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectHandle
> = CreateProjectHandle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectHandle$ {
  /** @deprecated use `CreateProjectHandle$inboundSchema` instead. */
  export const inboundSchema = CreateProjectHandle$inboundSchema;
  /** @deprecated use `CreateProjectHandle$outboundSchema` instead. */
  export const outboundSchema = CreateProjectHandle$outboundSchema;
}

/** @internal */
export const CreateProjectAction$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectAction
> = z.nativeEnum(CreateProjectAction);

/** @internal */
export const CreateProjectAction$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectAction
> = CreateProjectAction$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectAction$ {
  /** @deprecated use `CreateProjectAction$inboundSchema` instead. */
  export const inboundSchema = CreateProjectAction$inboundSchema;
  /** @deprecated use `CreateProjectAction$outboundSchema` instead. */
  export const outboundSchema = CreateProjectAction$outboundSchema;
}

/** @internal */
export const CreateProjectAlgo$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectAlgo
> = z.nativeEnum(CreateProjectAlgo);

/** @internal */
export const CreateProjectAlgo$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectAlgo
> = CreateProjectAlgo$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectAlgo$ {
  /** @deprecated use `CreateProjectAlgo$inboundSchema` instead. */
  export const inboundSchema = CreateProjectAlgo$inboundSchema;
  /** @deprecated use `CreateProjectAlgo$outboundSchema` instead. */
  export const outboundSchema = CreateProjectAlgo$outboundSchema;
}

/** @internal */
export const CreateProjectErl$inboundSchema: z.ZodType<
  CreateProjectErl,
  z.ZodTypeDef,
  unknown
> = z.object({
  algo: CreateProjectAlgo$inboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
});

/** @internal */
export type CreateProjectErl$Outbound = {
  algo: string;
  window: number;
  limit: number;
  keys: Array<string>;
};

/** @internal */
export const CreateProjectErl$outboundSchema: z.ZodType<
  CreateProjectErl$Outbound,
  z.ZodTypeDef,
  CreateProjectErl
> = z.object({
  algo: CreateProjectAlgo$outboundSchema,
  window: z.number(),
  limit: z.number(),
  keys: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectErl$ {
  /** @deprecated use `CreateProjectErl$inboundSchema` instead. */
  export const inboundSchema = CreateProjectErl$inboundSchema;
  /** @deprecated use `CreateProjectErl$outboundSchema` instead. */
  export const outboundSchema = CreateProjectErl$outboundSchema;
  /** @deprecated use `CreateProjectErl$Outbound` instead. */
  export type Outbound = CreateProjectErl$Outbound;
}

/** @internal */
export const CreateProjectMitigate$inboundSchema: z.ZodType<
  CreateProjectMitigate,
  z.ZodTypeDef,
  unknown
> = z.object({
  action: CreateProjectAction$inboundSchema,
  rule_id: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => CreateProjectErl$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "rule_id": "ruleId",
  });
});

/** @internal */
export type CreateProjectMitigate$Outbound = {
  action: string;
  rule_id: string;
  ttl?: number | undefined;
  erl?: CreateProjectErl$Outbound | undefined;
};

/** @internal */
export const CreateProjectMitigate$outboundSchema: z.ZodType<
  CreateProjectMitigate$Outbound,
  z.ZodTypeDef,
  CreateProjectMitigate
> = z.object({
  action: CreateProjectAction$outboundSchema,
  ruleId: z.string(),
  ttl: z.number().optional(),
  erl: z.lazy(() => CreateProjectErl$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    ruleId: "rule_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectMitigate$ {
  /** @deprecated use `CreateProjectMitigate$inboundSchema` instead. */
  export const inboundSchema = CreateProjectMitigate$inboundSchema;
  /** @deprecated use `CreateProjectMitigate$outboundSchema` instead. */
  export const outboundSchema = CreateProjectMitigate$outboundSchema;
  /** @deprecated use `CreateProjectMitigate$Outbound` instead. */
  export type Outbound = CreateProjectMitigate$Outbound;
}

/** @internal */
export const CreateProjectFirewallRoutes$inboundSchema: z.ZodType<
  CreateProjectFirewallRoutes,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.union([z.lazy(() => CreateProjectSrc2$inboundSchema), z.string()])
    .optional(),
  has: z.array(z.lazy(() => CreateProjectHas$inboundSchema)).optional(),
  missing: z.array(z.lazy(() => CreateProjectMissing$inboundSchema)).optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: CreateProjectHandle$inboundSchema.optional(),
  mitigate: z.lazy(() => CreateProjectMitigate$inboundSchema).optional(),
});

/** @internal */
export type CreateProjectFirewallRoutes$Outbound = {
  src?: CreateProjectSrc2$Outbound | string | undefined;
  has?: Array<CreateProjectHas$Outbound> | undefined;
  missing?: Array<CreateProjectMissing$Outbound> | undefined;
  dest?: string | undefined;
  status?: number | undefined;
  handle?: string | undefined;
  mitigate?: CreateProjectMitigate$Outbound | undefined;
};

/** @internal */
export const CreateProjectFirewallRoutes$outboundSchema: z.ZodType<
  CreateProjectFirewallRoutes$Outbound,
  z.ZodTypeDef,
  CreateProjectFirewallRoutes
> = z.object({
  src: z.union([z.lazy(() => CreateProjectSrc2$outboundSchema), z.string()])
    .optional(),
  has: z.array(z.lazy(() => CreateProjectHas$outboundSchema)).optional(),
  missing: z.array(z.lazy(() => CreateProjectMissing$outboundSchema))
    .optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
  handle: CreateProjectHandle$outboundSchema.optional(),
  mitigate: z.lazy(() => CreateProjectMitigate$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectFirewallRoutes$ {
  /** @deprecated use `CreateProjectFirewallRoutes$inboundSchema` instead. */
  export const inboundSchema = CreateProjectFirewallRoutes$inboundSchema;
  /** @deprecated use `CreateProjectFirewallRoutes$outboundSchema` instead. */
  export const outboundSchema = CreateProjectFirewallRoutes$outboundSchema;
  /** @deprecated use `CreateProjectFirewallRoutes$Outbound` instead. */
  export type Outbound = CreateProjectFirewallRoutes$Outbound;
}

/** @internal */
export const CreateProjectSecurity$inboundSchema: z.ZodType<
  CreateProjectSecurity,
  z.ZodTypeDef,
  unknown
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(
    z.lazy(() => CreateProjectFirewallRoutes$inboundSchema),
  ).optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/** @internal */
export type CreateProjectSecurity$Outbound = {
  attackModeEnabled?: boolean | undefined;
  attackModeUpdatedAt?: number | undefined;
  firewallEnabled?: boolean | undefined;
  firewallUpdatedAt?: number | undefined;
  attackModeActiveUntil?: number | null | undefined;
  firewallConfigVersion?: number | undefined;
  firewallRoutes?: Array<CreateProjectFirewallRoutes$Outbound> | undefined;
  firewallSeawallEnabled?: boolean | undefined;
  ja3Enabled?: boolean | undefined;
  ja4Enabled?: boolean | undefined;
};

/** @internal */
export const CreateProjectSecurity$outboundSchema: z.ZodType<
  CreateProjectSecurity$Outbound,
  z.ZodTypeDef,
  CreateProjectSecurity
> = z.object({
  attackModeEnabled: z.boolean().optional(),
  attackModeUpdatedAt: z.number().optional(),
  firewallEnabled: z.boolean().optional(),
  firewallUpdatedAt: z.number().optional(),
  attackModeActiveUntil: z.nullable(z.number()).optional(),
  firewallConfigVersion: z.number().optional(),
  firewallRoutes: z.array(
    z.lazy(() => CreateProjectFirewallRoutes$outboundSchema),
  ).optional(),
  firewallSeawallEnabled: z.boolean().optional(),
  ja3Enabled: z.boolean().optional(),
  ja4Enabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectSecurity$ {
  /** @deprecated use `CreateProjectSecurity$inboundSchema` instead. */
  export const inboundSchema = CreateProjectSecurity$inboundSchema;
  /** @deprecated use `CreateProjectSecurity$outboundSchema` instead. */
  export const outboundSchema = CreateProjectSecurity$outboundSchema;
  /** @deprecated use `CreateProjectSecurity$Outbound` instead. */
  export type Outbound = CreateProjectSecurity$Outbound;
}

/** @internal */
export const CreateProjectIssuerMode$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectIssuerMode
> = z.nativeEnum(CreateProjectIssuerMode);

/** @internal */
export const CreateProjectIssuerMode$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectIssuerMode
> = CreateProjectIssuerMode$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectIssuerMode$ {
  /** @deprecated use `CreateProjectIssuerMode$inboundSchema` instead. */
  export const inboundSchema = CreateProjectIssuerMode$inboundSchema;
  /** @deprecated use `CreateProjectIssuerMode$outboundSchema` instead. */
  export const outboundSchema = CreateProjectIssuerMode$outboundSchema;
}

/** @internal */
export const CreateProjectOidcTokenConfig$inboundSchema: z.ZodType<
  CreateProjectOidcTokenConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean(),
  issuerMode: CreateProjectIssuerMode$inboundSchema.optional(),
});

/** @internal */
export type CreateProjectOidcTokenConfig$Outbound = {
  enabled: boolean;
  issuerMode?: string | undefined;
};

/** @internal */
export const CreateProjectOidcTokenConfig$outboundSchema: z.ZodType<
  CreateProjectOidcTokenConfig$Outbound,
  z.ZodTypeDef,
  CreateProjectOidcTokenConfig
> = z.object({
  enabled: z.boolean(),
  issuerMode: CreateProjectIssuerMode$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectOidcTokenConfig$ {
  /** @deprecated use `CreateProjectOidcTokenConfig$inboundSchema` instead. */
  export const inboundSchema = CreateProjectOidcTokenConfig$inboundSchema;
  /** @deprecated use `CreateProjectOidcTokenConfig$outboundSchema` instead. */
  export const outboundSchema = CreateProjectOidcTokenConfig$outboundSchema;
  /** @deprecated use `CreateProjectOidcTokenConfig$Outbound` instead. */
  export type Outbound = CreateProjectOidcTokenConfig$Outbound;
}

/** @internal */
export const CreateProjectTier$inboundSchema: z.ZodNativeEnum<
  typeof CreateProjectTier
> = z.nativeEnum(CreateProjectTier);

/** @internal */
export const CreateProjectTier$outboundSchema: z.ZodNativeEnum<
  typeof CreateProjectTier
> = CreateProjectTier$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectTier$ {
  /** @deprecated use `CreateProjectTier$inboundSchema` instead. */
  export const inboundSchema = CreateProjectTier$inboundSchema;
  /** @deprecated use `CreateProjectTier$outboundSchema` instead. */
  export const outboundSchema = CreateProjectTier$outboundSchema;
}

/** @internal */
export const CreateProjectResponseBody$inboundSchema: z.ZodType<
  CreateProjectResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => CreateProjectAnalytics$inboundSchema).optional(),
  speedInsights: z.lazy(() => CreateProjectSpeedInsights$inboundSchema)
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => CreateProjectCrons$inboundSchema).optional(),
  dataCache: z.lazy(() => CreateProjectDataCache$inboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => CreateProjectDeploymentExpiration$inboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => CreateProjectEnv$inboundSchema)).optional(),
  customEnvironments: z.array(
    z.lazy(() => CreateProjectCustomEnvironments$inboundSchema),
  ).optional(),
  framework: z.nullable(CreateProjectProjectsFramework$inboundSchema)
    .optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => CreateProjectIpBuckets$inboundSchema))
    .optional(),
  latestDeployments: z.array(
    z.lazy(() => CreateProjectLatestDeployments$inboundSchema),
  ).optional(),
  link: z.union([
    z.lazy(() => CreateProjectLink1$inboundSchema),
    z.lazy(() => CreateProjectLink3$inboundSchema),
    z.lazy(() => CreateProjectLink2$inboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => CreateProjectMicrofrontends$inboundSchema)
    .optional(),
  name: z.string(),
  nodeVersion: CreateProjectNodeVersion$inboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => CreateProjectOptionsAllowlist$inboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => CreateProjectPasswordProtection$inboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => CreateProjectResourceConfig$inboundSchema)
    .optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => CreateProjectSsoProtection$inboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => CreateProjectTargets$inboundSchema))
    .optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => CreateProjectPermissions$inboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => CreateProjectLastRollbackTarget$inboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(
    z.lazy(() => CreateProjectLastAliasRequest$inboundSchema),
  ).optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(
    z.lazy(() => CreateProjectProtectionBypass$inboundSchema),
  ).optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => CreateProjectTrustedIps2$inboundSchema),
      z.lazy(() => CreateProjectTrustedIps1$inboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => CreateProjectGitComments$inboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => CreateProjectWebAnalytics$inboundSchema)
    .optional(),
  security: z.lazy(() => CreateProjectSecurity$inboundSchema).optional(),
  oidcTokenConfig: z.lazy(() => CreateProjectOidcTokenConfig$inboundSchema)
    .optional(),
  tier: CreateProjectTier$inboundSchema.optional(),
});

/** @internal */
export type CreateProjectResponseBody$Outbound = {
  accountId: string;
  analytics?: CreateProjectAnalytics$Outbound | undefined;
  speedInsights?: CreateProjectSpeedInsights$Outbound | undefined;
  autoExposeSystemEnvs?: boolean | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  autoAssignCustomDomainsUpdatedBy?: string | undefined;
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  connectConfigurationId?: string | null | undefined;
  connectBuildsEnabled?: boolean | undefined;
  createdAt?: number | undefined;
  customerSupportCodeVisibility?: boolean | undefined;
  crons?: CreateProjectCrons$Outbound | undefined;
  dataCache?: CreateProjectDataCache$Outbound | undefined;
  deploymentExpiration?:
    | CreateProjectDeploymentExpiration$Outbound
    | null
    | undefined;
  devCommand?: string | null | undefined;
  directoryListing: boolean;
  installCommand?: string | null | undefined;
  env?: Array<CreateProjectEnv$Outbound> | undefined;
  customEnvironments?:
    | Array<CreateProjectCustomEnvironments$Outbound>
    | undefined;
  framework?: string | null | undefined;
  gitForkProtection?: boolean | undefined;
  gitLFS?: boolean | undefined;
  id: string;
  ipBuckets?: Array<CreateProjectIpBuckets$Outbound> | undefined;
  latestDeployments?:
    | Array<CreateProjectLatestDeployments$Outbound>
    | undefined;
  link?:
    | CreateProjectLink1$Outbound
    | CreateProjectLink3$Outbound
    | CreateProjectLink2$Outbound
    | undefined;
  microfrontends?: CreateProjectMicrofrontends$Outbound | undefined;
  name: string;
  nodeVersion: string;
  optionsAllowlist?: CreateProjectOptionsAllowlist$Outbound | null | undefined;
  outputDirectory?: string | null | undefined;
  passiveConnectConfigurationId?: string | null | undefined;
  passwordProtection?:
    | CreateProjectPasswordProtection$Outbound
    | null
    | undefined;
  productionDeploymentsFastLane?: boolean | undefined;
  publicSource?: boolean | null | undefined;
  resourceConfig?: CreateProjectResourceConfig$Outbound | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  serverlessFunctionZeroConfigFailover?: boolean | undefined;
  skewProtectionBoundaryAt?: number | undefined;
  skewProtectionMaxAge?: number | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
  enableAffectedProjectsDeployments?: boolean | undefined;
  ssoProtection?: CreateProjectSsoProtection$Outbound | null | undefined;
  targets?: { [k: string]: CreateProjectTargets$Outbound } | undefined;
  transferCompletedAt?: number | undefined;
  transferStartedAt?: number | undefined;
  transferToAccountId?: string | undefined;
  transferredFromAccountId?: string | undefined;
  updatedAt?: number | undefined;
  live?: boolean | undefined;
  enablePreviewFeedback?: boolean | null | undefined;
  enableProductionFeedback?: boolean | null | undefined;
  permissions?: CreateProjectPermissions$Outbound | undefined;
  lastRollbackTarget?:
    | CreateProjectLastRollbackTarget$Outbound
    | null
    | undefined;
  lastAliasRequest?: CreateProjectLastAliasRequest$Outbound | null | undefined;
  hasFloatingAliases?: boolean | undefined;
  protectionBypass?:
    | { [k: string]: CreateProjectProtectionBypass$Outbound }
    | undefined;
  hasActiveBranches?: boolean | undefined;
  trustedIps?:
    | CreateProjectTrustedIps2$Outbound
    | CreateProjectTrustedIps1$Outbound
    | null
    | undefined;
  gitComments?: CreateProjectGitComments$Outbound | undefined;
  paused?: boolean | undefined;
  concurrencyBucketName?: string | undefined;
  webAnalytics?: CreateProjectWebAnalytics$Outbound | undefined;
  security?: CreateProjectSecurity$Outbound | undefined;
  oidcTokenConfig?: CreateProjectOidcTokenConfig$Outbound | undefined;
  tier?: string | undefined;
};

/** @internal */
export const CreateProjectResponseBody$outboundSchema: z.ZodType<
  CreateProjectResponseBody$Outbound,
  z.ZodTypeDef,
  CreateProjectResponseBody
> = z.object({
  accountId: z.string(),
  analytics: z.lazy(() => CreateProjectAnalytics$outboundSchema).optional(),
  speedInsights: z.lazy(() => CreateProjectSpeedInsights$outboundSchema)
    .optional(),
  autoExposeSystemEnvs: z.boolean().optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  autoAssignCustomDomainsUpdatedBy: z.string().optional(),
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  connectConfigurationId: z.nullable(z.string()).optional(),
  connectBuildsEnabled: z.boolean().optional(),
  createdAt: z.number().optional(),
  customerSupportCodeVisibility: z.boolean().optional(),
  crons: z.lazy(() => CreateProjectCrons$outboundSchema).optional(),
  dataCache: z.lazy(() => CreateProjectDataCache$outboundSchema).optional(),
  deploymentExpiration: z.nullable(
    z.lazy(() => CreateProjectDeploymentExpiration$outboundSchema),
  ).optional(),
  devCommand: z.nullable(z.string()).optional(),
  directoryListing: z.boolean(),
  installCommand: z.nullable(z.string()).optional(),
  env: z.array(z.lazy(() => CreateProjectEnv$outboundSchema)).optional(),
  customEnvironments: z.array(
    z.lazy(() => CreateProjectCustomEnvironments$outboundSchema),
  ).optional(),
  framework: z.nullable(CreateProjectProjectsFramework$outboundSchema)
    .optional(),
  gitForkProtection: z.boolean().optional(),
  gitLFS: z.boolean().optional(),
  id: z.string(),
  ipBuckets: z.array(z.lazy(() => CreateProjectIpBuckets$outboundSchema))
    .optional(),
  latestDeployments: z.array(
    z.lazy(() => CreateProjectLatestDeployments$outboundSchema),
  ).optional(),
  link: z.union([
    z.lazy(() => CreateProjectLink1$outboundSchema),
    z.lazy(() => CreateProjectLink3$outboundSchema),
    z.lazy(() => CreateProjectLink2$outboundSchema),
  ]).optional(),
  microfrontends: z.lazy(() => CreateProjectMicrofrontends$outboundSchema)
    .optional(),
  name: z.string(),
  nodeVersion: CreateProjectNodeVersion$outboundSchema,
  optionsAllowlist: z.nullable(
    z.lazy(() => CreateProjectOptionsAllowlist$outboundSchema),
  ).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  passiveConnectConfigurationId: z.nullable(z.string()).optional(),
  passwordProtection: z.nullable(
    z.lazy(() => CreateProjectPasswordProtection$outboundSchema),
  ).optional(),
  productionDeploymentsFastLane: z.boolean().optional(),
  publicSource: z.nullable(z.boolean()).optional(),
  resourceConfig: z.lazy(() => CreateProjectResourceConfig$outboundSchema)
    .optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  serverlessFunctionZeroConfigFailover: z.boolean().optional(),
  skewProtectionBoundaryAt: z.number().optional(),
  skewProtectionMaxAge: z.number().optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
  enableAffectedProjectsDeployments: z.boolean().optional(),
  ssoProtection: z.nullable(
    z.lazy(() => CreateProjectSsoProtection$outboundSchema),
  ).optional(),
  targets: z.record(z.lazy(() => CreateProjectTargets$outboundSchema))
    .optional(),
  transferCompletedAt: z.number().optional(),
  transferStartedAt: z.number().optional(),
  transferToAccountId: z.string().optional(),
  transferredFromAccountId: z.string().optional(),
  updatedAt: z.number().optional(),
  live: z.boolean().optional(),
  enablePreviewFeedback: z.nullable(z.boolean()).optional(),
  enableProductionFeedback: z.nullable(z.boolean()).optional(),
  permissions: z.lazy(() => CreateProjectPermissions$outboundSchema).optional(),
  lastRollbackTarget: z.nullable(
    z.lazy(() => CreateProjectLastRollbackTarget$outboundSchema),
  ).optional(),
  lastAliasRequest: z.nullable(
    z.lazy(() => CreateProjectLastAliasRequest$outboundSchema),
  ).optional(),
  hasFloatingAliases: z.boolean().optional(),
  protectionBypass: z.record(
    z.lazy(() => CreateProjectProtectionBypass$outboundSchema),
  ).optional(),
  hasActiveBranches: z.boolean().optional(),
  trustedIps: z.nullable(
    z.union([
      z.lazy(() => CreateProjectTrustedIps2$outboundSchema),
      z.lazy(() => CreateProjectTrustedIps1$outboundSchema),
    ]),
  ).optional(),
  gitComments: z.lazy(() => CreateProjectGitComments$outboundSchema).optional(),
  paused: z.boolean().optional(),
  concurrencyBucketName: z.string().optional(),
  webAnalytics: z.lazy(() => CreateProjectWebAnalytics$outboundSchema)
    .optional(),
  security: z.lazy(() => CreateProjectSecurity$outboundSchema).optional(),
  oidcTokenConfig: z.lazy(() => CreateProjectOidcTokenConfig$outboundSchema)
    .optional(),
  tier: CreateProjectTier$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateProjectResponseBody$ {
  /** @deprecated use `CreateProjectResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateProjectResponseBody$inboundSchema;
  /** @deprecated use `CreateProjectResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateProjectResponseBody$outboundSchema;
  /** @deprecated use `CreateProjectResponseBody$Outbound` instead. */
  export type Outbound = CreateProjectResponseBody$Outbound;
}
