/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  FlagJSONValue,
  FlagJSONValue$inboundSchema,
  FlagJSONValue$Outbound,
  FlagJSONValue$outboundSchema,
} from "../components/flagjsonvalue.js";

/**
 * Allows to skip framework detection so the API would not fail to ask for confirmation
 */
export const SkipAutoDetectionConfirmation = {
  Zero: "0",
  One: "1",
} as const;
/**
 * Allows to skip framework detection so the API would not fail to ask for confirmation
 */
export type SkipAutoDetectionConfirmation = ClosedEnum<
  typeof SkipAutoDetectionConfirmation
>;

/**
 * Forces a new deployment even if there is a previous similar deployment
 */
export const ForceNew = {
  Zero: "0",
  One: "1",
} as const;
/**
 * Forces a new deployment even if there is a previous similar deployment
 */
export type ForceNew = ClosedEnum<typeof ForceNew>;

/**
 * Used in the case you want to reference a file that was already uploaded
 */
export type UploadedFile = {
  /**
   * The file path relative to the project root
   */
  file: string;
  /**
   * The file contents hashed with SHA1, used to check the integrity
   */
  sha?: string | undefined;
  /**
   * The file size in bytes
   */
  size?: number | undefined;
};

/**
 * The file content encoding, it could be either a base64 (useful for images, etc.) of the files or the plain text for source code.
 */
export const Encoding = {
  Base64: "base64",
  Utf8: "utf-8",
} as const;
/**
 * The file content encoding, it could be either a base64 (useful for images, etc.) of the files or the plain text for source code.
 */
export type Encoding = ClosedEnum<typeof Encoding>;

/**
 * Used in the case you want to inline a file inside the request
 */
export type InlinedFile = {
  /**
   * The file content, it could be either a `base64` (useful for images, etc.) of the files or the plain content for source code
   */
  data: string;
  /**
   * The file content encoding, it could be either a base64 (useful for images, etc.) of the files or the plain text for source code.
   */
  encoding?: Encoding | undefined;
  /**
   * The file name including the whole path
   */
  file: string;
};

export type Files = InlinedFile | UploadedFile;

/**
 * Populates initial git metadata for different git providers.
 */
export type GitMetadata = {
  /**
   * The git repository's remote origin url
   */
  remoteUrl?: string | undefined;
  /**
   * The name of the author of the commit
   */
  commitAuthorName?: string | undefined;
  /**
   * The commit message
   */
  commitMessage?: string | undefined;
  /**
   * The branch on which the commit was made
   */
  commitRef?: string | undefined;
  /**
   * The hash of the commit
   */
  commitSha?: string | undefined;
  /**
   * Whether or not there have been modifications to the working tree since the latest commit
   */
  dirty?: boolean | undefined;
};

export const CreateDeploymentGitSourceDeploymentsRequestType = {
  Bitbucket: "bitbucket",
} as const;
export type CreateDeploymentGitSourceDeploymentsRequestType = ClosedEnum<
  typeof CreateDeploymentGitSourceDeploymentsRequestType
>;

export type Five = {
  owner: string;
  ref: string;
  sha?: string | undefined;
  slug: string;
  type: CreateDeploymentGitSourceDeploymentsRequestType;
};

export const CreateDeploymentGitSourceDeploymentsType = {
  Bitbucket: "bitbucket",
} as const;
export type CreateDeploymentGitSourceDeploymentsType = ClosedEnum<
  typeof CreateDeploymentGitSourceDeploymentsType
>;

export type Four = {
  ref: string;
  repoUuid: string;
  sha?: string | undefined;
  type: CreateDeploymentGitSourceDeploymentsType;
  workspaceUuid?: string | undefined;
};

export type ProjectId = number | string;

export const CreateDeploymentGitSourceType = {
  Gitlab: "gitlab",
} as const;
export type CreateDeploymentGitSourceType = ClosedEnum<
  typeof CreateDeploymentGitSourceType
>;

export type Three = {
  projectId: number | string;
  ref: string;
  sha?: string | undefined;
  type: CreateDeploymentGitSourceType;
};

export const GitSourceType = {
  Github: "github",
} as const;
export type GitSourceType = ClosedEnum<typeof GitSourceType>;

export type Two = {
  org: string;
  ref: string;
  repo: string;
  sha?: string | undefined;
  type: GitSourceType;
};

export type RepoId = number | string;

export const Type = {
  Github: "github",
} as const;
export type Type = ClosedEnum<typeof Type>;

export type One = {
  ref: string;
  repoId: number | string;
  sha?: string | undefined;
  type: Type;
};

/**
 * Defines the Git Repository source to be deployed. This property can not be used in combination with `files`.
 */
export type GitSource = One | Three | Two | Four | Five;

/**
 * The framework that is being used for this project. When `null` is used no framework is selected
 */
export const Framework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
/**
 * The framework that is being used for this project. When `null` is used no framework is selected
 */
export type Framework = ClosedEnum<typeof Framework>;

/**
 * Override the Node.js version that should be used for this deployment
 */
export const NodeVersion = {
  TwentyTwoX: "22.x",
  TwentyX: "20.x",
  EighteenX: "18.x",
  SixteenX: "16.x",
  FourteenX: "14.x",
  TwelveX: "12.x",
  TenX: "10.x",
  Eight10X: "8.10.x",
} as const;
/**
 * Override the Node.js version that should be used for this deployment
 */
export type NodeVersion = ClosedEnum<typeof NodeVersion>;

/**
 * Project settings that will be applied to the deployment. It is required for the first deployment of a project and will be saved for any following deployments
 */
export type ProjectSettings = {
  /**
   * The build command for this project. When `null` is used this value will be automatically detected
   */
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  /**
   * The dev command for this project. When `null` is used this value will be automatically detected
   */
  devCommand?: string | null | undefined;
  /**
   * The framework that is being used for this project. When `null` is used no framework is selected
   */
  framework?: Framework | null | undefined;
  /**
   * The install command for this project. When `null` is used this value will be automatically detected
   */
  installCommand?: string | null | undefined;
  /**
   * Override the Node.js version that should be used for this deployment
   */
  nodeVersion?: NodeVersion | undefined;
  /**
   * The output directory of the project. When `null` is used this value will be automatically detected
   */
  outputDirectory?: string | null | undefined;
  /**
   * The name of a directory or relative path to the source code of your project. When `null` is used it will default to the project root
   */
  rootDirectory?: string | null | undefined;
  /**
   * The region to deploy Serverless Functions in this project
   */
  serverlessFunctionRegion?: string | null | undefined;
  /**
   * Opts-out of the message prompting a CLI user to connect a Git repository in `vercel link`.
   *
   * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
   */
  skipGitConnectDuringLink?: boolean | undefined;
  /**
   * Indicates if there are source files outside of the root directory, typically used for monorepos
   */
  sourceFilesOutsideRootDirectory?: boolean | undefined;
};

/**
 * Either not defined, `staging`, or `production`. If `staging`, a staging alias in the format `<project>-<team>.vercel.app` will be assigned. If `production`, any aliases defined in `alias` will be assigned. If omitted, the target will be `preview`
 */
export const Target = {
  Staging: "staging",
  Production: "production",
} as const;
/**
 * Either not defined, `staging`, or `production`. If `staging`, a staging alias in the format `<project>-<team>.vercel.app` will be assigned. If `production`, any aliases defined in `alias` will be assigned. If omitted, the target will be `preview`
 */
export type Target = ClosedEnum<typeof Target>;

export type CreateDeploymentRequestBody = {
  /**
   * An deployment id for an existing deployment to redeploy
   */
  deploymentId?: string | undefined;
  /**
   * A list of objects with the files to be deployed
   */
  files?: Array<InlinedFile | UploadedFile> | undefined;
  /**
   * Populates initial git metadata for different git providers.
   */
  gitMetadata?: GitMetadata | undefined;
  /**
   * Defines the Git Repository source to be deployed. This property can not be used in combination with `files`.
   */
  gitSource?: One | Three | Two | Four | Five | undefined;
  /**
   * An object containing the deployment's metadata. Multiple key-value pairs can be attached to a deployment
   */
  meta?: { [k: string]: string } | undefined;
  /**
   * The monorepo manager that is being used for this deployment. When `null` is used no monorepo manager is selected
   */
  monorepoManager?: string | null | undefined;
  /**
   * A string with the project name used in the deployment URL
   */
  name: string;
  /**
   * The target project identifier in which the deployment will be created. When defined, this parameter overrides name
   */
  project?: string | undefined;
  /**
   * Project settings that will be applied to the deployment. It is required for the first deployment of a project and will be saved for any following deployments
   */
  projectSettings?: ProjectSettings | undefined;
  /**
   * Either not defined, `staging`, or `production`. If `staging`, a staging alias in the format `<project>-<team>.vercel.app` will be assigned. If `production`, any aliases defined in `alias` will be assigned. If omitted, the target will be `preview`
   */
  target?: Target | undefined;
  /**
   * When `true` and `deploymentId` is passed in, the sha from the previous deployment's `gitSource` is removed forcing the latest commit to be used.
   */
  withLatestCommit?: boolean | undefined;
};

export type CreateDeploymentRequest = {
  /**
   * Allows to skip framework detection so the API would not fail to ask for confirmation
   */
  skipAutoDetectionConfirmation?: SkipAutoDetectionConfirmation | undefined;
  /**
   * Forces a new deployment even if there is a previous similar deployment
   */
  forceNew?: ForceNew | undefined;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: CreateDeploymentRequestBody | undefined;
};

export type AliasAssignedAt = number | boolean;

export type Build = {
  env: Array<string>;
};

export type Builds = {};

export const CreateDeploymentFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type CreateDeploymentFramework = ClosedEnum<
  typeof CreateDeploymentFramework
>;

export type CreateDeploymentSpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type CreateDeploymentWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type CreateDeploymentProjectSettings = {
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: CreateDeploymentFramework | null | undefined;
  installCommand?: string | null | undefined;
  outputDirectory?: string | null | undefined;
  speedInsights?: CreateDeploymentSpeedInsights | undefined;
  webAnalytics?: CreateDeploymentWebAnalytics | undefined;
};

export const CreateDeploymentDeploymentsStatus = {
  Error: "error",
  Skipped: "skipped",
  Pending: "pending",
  Ready: "ready",
  Timeout: "timeout",
} as const;
export type CreateDeploymentDeploymentsStatus = ClosedEnum<
  typeof CreateDeploymentDeploymentsStatus
>;

export type Integrations = {
  status: CreateDeploymentDeploymentsStatus;
  startedAt: number;
  completedAt?: number | undefined;
  skippedAt?: number | undefined;
  skippedBy?: string | undefined;
};

export type Creator = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

export const CreateDeploymentReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
} as const;
export type CreateDeploymentReadyState = ClosedEnum<
  typeof CreateDeploymentReadyState
>;

export type CreateDeploymentOutput = {
  path: string;
  functionName: string;
};

/**
 * A partial representation of a Build used by the deployment endpoint.
 */
export type Lambdas = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: CreateDeploymentReadyState | undefined;
  readyStateAt?: number | undefined;
  output: Array<CreateDeploymentOutput>;
};

export const CreateDeploymentStatus = {
  Canceled: "CANCELED",
  Error: "ERROR",
  Queued: "QUEUED",
  Building: "BUILDING",
  Initializing: "INITIALIZING",
  Ready: "READY",
} as const;
export type CreateDeploymentStatus = ClosedEnum<typeof CreateDeploymentStatus>;

export type Team = {
  name: string;
  id: string;
  slug: string;
  avatar?: string | undefined;
};

export type CustomEnvironment2 = {
  id: string;
};

export type CustomEnvironment1 = {};

export type CustomEnvironment = CustomEnvironment1 | CustomEnvironment2;

export const CreateDeploymentType = {
  Lambdas: "LAMBDAS",
} as const;
export type CreateDeploymentType = ClosedEnum<typeof CreateDeploymentType>;

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type
  >;

export type CreateDeploymentGitSource9 = {
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type =
  {
    Gitlab: "gitlab",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type
  >;

export type CreateDeploymentGitSource8 = {
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type;
  ref: string;
  sha: string;
  projectId: number;
};

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type =
  {
    Github: "github",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type
  >;

export type CreateDeploymentGitSource7 = {
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type =
  {
    Custom: "custom",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type
  >;

export type CreateDeploymentGitSource6 = {
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type;
  ref: string;
  sha: string;
  gitUrl: string;
};

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type
  >;

export type GitSource5 = {
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType =
  {
    Bitbucket: "bitbucket",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  >;

export type GitSource4 = {
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType =
  {
    Gitlab: "gitlab",
  } as const;
export type CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  >;

export type GitSourceProjectId = string | number;

export type GitSource3 = {
  type: CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CreateDeploymentGitSourceDeploymentsResponse200Type = {
  Github: "github",
} as const;
export type CreateDeploymentGitSourceDeploymentsResponse200Type = ClosedEnum<
  typeof CreateDeploymentGitSourceDeploymentsResponse200Type
>;

export type GitSource2 = {
  type: CreateDeploymentGitSourceDeploymentsResponse200Type;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CreateDeploymentGitSourceDeploymentsResponseType = {
  Github: "github",
} as const;
export type CreateDeploymentGitSourceDeploymentsResponseType = ClosedEnum<
  typeof CreateDeploymentGitSourceDeploymentsResponseType
>;

export type GitSourceRepoId = string | number;

export type GitSource1 = {
  type: CreateDeploymentGitSourceDeploymentsResponseType;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export type CreateDeploymentGitSource =
  | CreateDeploymentGitSource6
  | CreateDeploymentGitSource8
  | GitSource1
  | GitSource3
  | GitSource2
  | GitSource4
  | GitSource5
  | CreateDeploymentGitSource7
  | CreateDeploymentGitSource9;

export type Project = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

export const ReadyState = {
  Canceled: "CANCELED",
  Error: "ERROR",
  Queued: "QUEUED",
  Building: "BUILDING",
  Initializing: "INITIALIZING",
  Ready: "READY",
} as const;
export type ReadyState = ClosedEnum<typeof ReadyState>;

export const CreateDeploymentSource = {
  Cli: "cli",
  Git: "git",
  Import: "import",
  ImportRepo: "import/repo",
  CloneRepo: "clone/repo",
  ApiTriggerGitDeploy: "api-trigger-git-deploy",
  Redeploy: "redeploy",
} as const;
export type CreateDeploymentSource = ClosedEnum<typeof CreateDeploymentSource>;

export const CreateDeploymentTarget = {
  Staging: "staging",
  Production: "production",
} as const;
export type CreateDeploymentTarget = ClosedEnum<typeof CreateDeploymentTarget>;

export type AliasWarning = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

export type AliasError = {
  code: string;
  message: string;
};

export const ChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type ChecksState = ClosedEnum<typeof ChecksState>;

export const ChecksConclusion = {
  Succeeded: "succeeded",
  Failed: "failed",
  Skipped: "skipped",
  Canceled: "canceled",
} as const;
export type ChecksConclusion = ClosedEnum<typeof ChecksConclusion>;

/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export const ReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export type ReadySubstate = ClosedEnum<typeof ReadySubstate>;

export type OidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export type Functions = {
  memory?: number | undefined;
  maxDuration?: number | undefined;
  runtime?: string | undefined;
  includeFiles?: string | undefined;
  excludeFiles?: string | undefined;
};

export type Routes3 = {
  src: string;
  continue: boolean;
  middleware: number;
};

export const RoutesHandle = {
  Error: "error",
  Filesystem: "filesystem",
  Hit: "hit",
  Miss: "miss",
  Rewrite: "rewrite",
  Resource: "resource",
} as const;
export type RoutesHandle = ClosedEnum<typeof RoutesHandle>;

export type Routes2 = {
  handle: RoutesHandle;
  src?: string | undefined;
  dest?: string | undefined;
  status?: number | undefined;
};

export const CreateDeploymentHasType = {
  Header: "header",
  Cookie: "cookie",
  Query: "query",
} as const;
export type CreateDeploymentHasType = ClosedEnum<
  typeof CreateDeploymentHasType
>;

export type Has2 = {
  type: CreateDeploymentHasType;
  key: string;
  value?: string | undefined;
};

export const HasType = {
  Host: "host",
} as const;
export type HasType = ClosedEnum<typeof HasType>;

export type Has1 = {
  type: HasType;
  value: string;
};

export type RoutesHas = Has1 | Has2;

export const CreateDeploymentMissingType = {
  Header: "header",
  Cookie: "cookie",
  Query: "query",
} as const;
export type CreateDeploymentMissingType = ClosedEnum<
  typeof CreateDeploymentMissingType
>;

export type Missing2 = {
  type: CreateDeploymentMissingType;
  key: string;
  value?: string | undefined;
};

export const MissingType = {
  Host: "host",
} as const;
export type MissingType = ClosedEnum<typeof MissingType>;

export type Missing1 = {
  type: MissingType;
  value: string;
};

export type RoutesMissing = Missing1 | Missing2;

export type Locale = {
  redirect?: { [k: string]: string } | undefined;
  cookie?: string | undefined;
};

export type Routes1 = {
  src: string;
  dest?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  methods?: Array<string> | undefined;
  continue?: boolean | undefined;
  override?: boolean | undefined;
  caseSensitive?: boolean | undefined;
  check?: boolean | undefined;
  important?: boolean | undefined;
  status?: number | undefined;
  has?: Array<Has1 | Has2> | undefined;
  missing?: Array<Missing1 | Missing2> | undefined;
  locale?: Locale | undefined;
  /**
   * A middleware key within the `output` key under the build result. Overrides a `middleware` definition.
   */
  middlewarePath?: string | undefined;
  /**
   * The original middleware matchers.
   */
  middlewareRawSrc?: Array<string> | undefined;
  /**
   * A middleware index in the `middleware` key under the build result
   */
  middleware?: number | undefined;
};

export type Routes = Routes3 | Routes2 | Routes1;

export type CreateDeploymentCrons = {
  schedule: string;
  path: string;
};

export const Plan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type Plan = ClosedEnum<typeof Plan>;

export const CreateDeploymentGitRepoDeploymentsType = {
  Bitbucket: "bitbucket",
} as const;
export type CreateDeploymentGitRepoDeploymentsType = ClosedEnum<
  typeof CreateDeploymentGitRepoDeploymentsType
>;

export const CreateDeploymentGitRepoOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type CreateDeploymentGitRepoOwnerType = ClosedEnum<
  typeof CreateDeploymentGitRepoOwnerType
>;

export type GitRepo3 = {
  owner: string;
  repoUuid: string;
  slug: string;
  type: CreateDeploymentGitRepoDeploymentsType;
  workspaceUuid: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: CreateDeploymentGitRepoOwnerType;
};

export const CreateDeploymentGitRepoType = {
  Github: "github",
} as const;
export type CreateDeploymentGitRepoType = ClosedEnum<
  typeof CreateDeploymentGitRepoType
>;

export const GitRepoOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type GitRepoOwnerType = ClosedEnum<typeof GitRepoOwnerType>;

export type GitRepo2 = {
  org: string;
  repo: string;
  repoId: number;
  type: CreateDeploymentGitRepoType;
  repoOwnerId: number;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: GitRepoOwnerType;
};

export const GitRepoType = {
  Gitlab: "gitlab",
} as const;
export type GitRepoType = ClosedEnum<typeof GitRepoType>;

export const OwnerType = {
  Team: "team",
  User: "user",
} as const;
export type OwnerType = ClosedEnum<typeof OwnerType>;

export type GitRepo1 = {
  namespace: string;
  projectId: number;
  type: GitRepoType;
  url: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: OwnerType;
};

export type GitRepo = GitRepo1 | GitRepo2 | GitRepo3;

/**
 * Flags defined in the Build Output API, used by this deployment. Primarily used by the Toolbar to know about the used flags.
 */
export type Flags2 = {};

export type Options = {
  value: FlagJSONValue | null;
  label?: string | undefined;
};

export type FlagsDefinitions = {
  options?: Array<Options> | undefined;
  url?: string | undefined;
  description?: string | undefined;
};

/**
 * Flags defined in the Build Output API, used by this deployment. Primarily used by the Toolbar to know about the used flags.
 */
export type Flags1 = {
  definitions: { [k: string]: FlagsDefinitions };
};

export type Flags = Flags1 | Array<Flags2>;

/**
 * The successfully created deployment
 */
export type CreateDeploymentResponseBody = {
  aliasAssignedAt?: number | boolean | null | undefined;
  alwaysRefuseToBuild?: boolean | undefined;
  build: Build;
  buildArtifactUrls?: Array<string> | undefined;
  builds?: Array<Builds> | undefined;
  env: Array<string>;
  inspectorUrl: string | null;
  isInConcurrentBuildsQueue: boolean;
  isInSystemBuildsQueue: boolean;
  projectSettings: CreateDeploymentProjectSettings;
  readyStateReason?: string | undefined;
  integrations?: Integrations | undefined;
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: Creator;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<Lambdas> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: CreateDeploymentStatus;
  team?: Team | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?: CustomEnvironment1 | CustomEnvironment2 | undefined;
  type: CreateDeploymentType;
  createdAt: number;
  name: string;
  deletedAt?: number | null | undefined;
  id: string;
  version: number;
  /**
   * applies to custom domains only, defaults to `true`
   */
  autoAssignCustomDomains?: boolean | undefined;
  gitSource?:
    | CreateDeploymentGitSource6
    | CreateDeploymentGitSource8
    | GitSource1
    | GitSource3
    | GitSource2
    | GitSource4
    | GitSource5
    | CreateDeploymentGitSource7
    | CreateDeploymentGitSource9
    | undefined;
  meta: { [k: string]: string };
  project?: Project | undefined;
  readyState: ReadyState;
  source?: CreateDeploymentSource | undefined;
  target?: CreateDeploymentTarget | null | undefined;
  /**
   * Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service
   */
  passiveRegions?: Array<string> | undefined;
  regions: Array<string>;
  errorMessage?: string | null | undefined;
  aliasWarning?: AliasWarning | null | undefined;
  aliasError?: AliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: ChecksState | undefined;
  checksConclusion?: ChecksConclusion | undefined;
  /**
   * Computed field that is only available for deployments with a micro-frontend configuration.
   */
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorStep?: string | undefined;
  /**
   * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
   */
  readySubstate?: ReadySubstate | undefined;
  softDeletedByRetention?: boolean | undefined;
  undeletedAt?: number | undefined;
  url: string;
  oidcTokenClaims?: OidcTokenClaims | undefined;
  projectId: string;
  ownerId: string;
  monorepoManager?: string | null | undefined;
  functions?: { [k: string]: Functions } | null | undefined;
  routes: Array<Routes3 | Routes2 | Routes1> | null;
  crons?: Array<CreateDeploymentCrons> | undefined;
  plan: Plan;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdIn: string;
  /**
   * Since November 2023 this field defines a Secure Compute network that will only be used to deploy passive lambdas to (as in passiveRegions)
   */
  passiveConnectConfigurationId?: string | undefined;
  gitRepo?: GitRepo1 | GitRepo2 | GitRepo3 | null | undefined;
  flags?: Flags1 | Array<Flags2> | undefined;
};

/** @internal */
export const SkipAutoDetectionConfirmation$inboundSchema: z.ZodNativeEnum<
  typeof SkipAutoDetectionConfirmation
> = z.nativeEnum(SkipAutoDetectionConfirmation);

/** @internal */
export const SkipAutoDetectionConfirmation$outboundSchema: z.ZodNativeEnum<
  typeof SkipAutoDetectionConfirmation
> = SkipAutoDetectionConfirmation$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace SkipAutoDetectionConfirmation$ {
  /** @deprecated use `SkipAutoDetectionConfirmation$inboundSchema` instead. */
  export const inboundSchema = SkipAutoDetectionConfirmation$inboundSchema;
  /** @deprecated use `SkipAutoDetectionConfirmation$outboundSchema` instead. */
  export const outboundSchema = SkipAutoDetectionConfirmation$outboundSchema;
}

/** @internal */
export const ForceNew$inboundSchema: z.ZodNativeEnum<typeof ForceNew> = z
  .nativeEnum(ForceNew);

/** @internal */
export const ForceNew$outboundSchema: z.ZodNativeEnum<typeof ForceNew> =
  ForceNew$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ForceNew$ {
  /** @deprecated use `ForceNew$inboundSchema` instead. */
  export const inboundSchema = ForceNew$inboundSchema;
  /** @deprecated use `ForceNew$outboundSchema` instead. */
  export const outboundSchema = ForceNew$outboundSchema;
}

/** @internal */
export const UploadedFile$inboundSchema: z.ZodType<
  UploadedFile,
  z.ZodTypeDef,
  unknown
> = z.object({
  file: z.string(),
  sha: z.string().optional(),
  size: z.number().int().optional(),
});

/** @internal */
export type UploadedFile$Outbound = {
  file: string;
  sha?: string | undefined;
  size?: number | undefined;
};

/** @internal */
export const UploadedFile$outboundSchema: z.ZodType<
  UploadedFile$Outbound,
  z.ZodTypeDef,
  UploadedFile
> = z.object({
  file: z.string(),
  sha: z.string().optional(),
  size: z.number().int().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace UploadedFile$ {
  /** @deprecated use `UploadedFile$inboundSchema` instead. */
  export const inboundSchema = UploadedFile$inboundSchema;
  /** @deprecated use `UploadedFile$outboundSchema` instead. */
  export const outboundSchema = UploadedFile$outboundSchema;
  /** @deprecated use `UploadedFile$Outbound` instead. */
  export type Outbound = UploadedFile$Outbound;
}

/** @internal */
export const Encoding$inboundSchema: z.ZodNativeEnum<typeof Encoding> = z
  .nativeEnum(Encoding);

/** @internal */
export const Encoding$outboundSchema: z.ZodNativeEnum<typeof Encoding> =
  Encoding$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Encoding$ {
  /** @deprecated use `Encoding$inboundSchema` instead. */
  export const inboundSchema = Encoding$inboundSchema;
  /** @deprecated use `Encoding$outboundSchema` instead. */
  export const outboundSchema = Encoding$outboundSchema;
}

/** @internal */
export const InlinedFile$inboundSchema: z.ZodType<
  InlinedFile,
  z.ZodTypeDef,
  unknown
> = z.object({
  data: z.string(),
  encoding: Encoding$inboundSchema.optional(),
  file: z.string(),
});

/** @internal */
export type InlinedFile$Outbound = {
  data: string;
  encoding?: string | undefined;
  file: string;
};

/** @internal */
export const InlinedFile$outboundSchema: z.ZodType<
  InlinedFile$Outbound,
  z.ZodTypeDef,
  InlinedFile
> = z.object({
  data: z.string(),
  encoding: Encoding$outboundSchema.optional(),
  file: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace InlinedFile$ {
  /** @deprecated use `InlinedFile$inboundSchema` instead. */
  export const inboundSchema = InlinedFile$inboundSchema;
  /** @deprecated use `InlinedFile$outboundSchema` instead. */
  export const outboundSchema = InlinedFile$outboundSchema;
  /** @deprecated use `InlinedFile$Outbound` instead. */
  export type Outbound = InlinedFile$Outbound;
}

/** @internal */
export const Files$inboundSchema: z.ZodType<Files, z.ZodTypeDef, unknown> = z
  .union([
    z.lazy(() => InlinedFile$inboundSchema),
    z.lazy(() => UploadedFile$inboundSchema),
  ]);

/** @internal */
export type Files$Outbound = InlinedFile$Outbound | UploadedFile$Outbound;

/** @internal */
export const Files$outboundSchema: z.ZodType<
  Files$Outbound,
  z.ZodTypeDef,
  Files
> = z.union([
  z.lazy(() => InlinedFile$outboundSchema),
  z.lazy(() => UploadedFile$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Files$ {
  /** @deprecated use `Files$inboundSchema` instead. */
  export const inboundSchema = Files$inboundSchema;
  /** @deprecated use `Files$outboundSchema` instead. */
  export const outboundSchema = Files$outboundSchema;
  /** @deprecated use `Files$Outbound` instead. */
  export type Outbound = Files$Outbound;
}

/** @internal */
export const GitMetadata$inboundSchema: z.ZodType<
  GitMetadata,
  z.ZodTypeDef,
  unknown
> = z.object({
  remoteUrl: z.string().optional(),
  commitAuthorName: z.string().optional(),
  commitMessage: z.string().optional(),
  commitRef: z.string().optional(),
  commitSha: z.string().optional(),
  dirty: z.boolean().optional(),
});

/** @internal */
export type GitMetadata$Outbound = {
  remoteUrl?: string | undefined;
  commitAuthorName?: string | undefined;
  commitMessage?: string | undefined;
  commitRef?: string | undefined;
  commitSha?: string | undefined;
  dirty?: boolean | undefined;
};

/** @internal */
export const GitMetadata$outboundSchema: z.ZodType<
  GitMetadata$Outbound,
  z.ZodTypeDef,
  GitMetadata
> = z.object({
  remoteUrl: z.string().optional(),
  commitAuthorName: z.string().optional(),
  commitMessage: z.string().optional(),
  commitRef: z.string().optional(),
  commitSha: z.string().optional(),
  dirty: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitMetadata$ {
  /** @deprecated use `GitMetadata$inboundSchema` instead. */
  export const inboundSchema = GitMetadata$inboundSchema;
  /** @deprecated use `GitMetadata$outboundSchema` instead. */
  export const outboundSchema = GitMetadata$outboundSchema;
  /** @deprecated use `GitMetadata$Outbound` instead. */
  export type Outbound = GitMetadata$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsRequestType$inboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsRequestType> = z
    .nativeEnum(CreateDeploymentGitSourceDeploymentsRequestType);

/** @internal */
export const CreateDeploymentGitSourceDeploymentsRequestType$outboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsRequestType> =
    CreateDeploymentGitSourceDeploymentsRequestType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsRequestType$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsRequestType$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsRequestType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsRequestType$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsRequestType$outboundSchema;
}

/** @internal */
export const Five$inboundSchema: z.ZodType<Five, z.ZodTypeDef, unknown> = z
  .object({
    owner: z.string(),
    ref: z.string(),
    sha: z.string().optional(),
    slug: z.string(),
    type: CreateDeploymentGitSourceDeploymentsRequestType$inboundSchema,
  });

/** @internal */
export type Five$Outbound = {
  owner: string;
  ref: string;
  sha?: string | undefined;
  slug: string;
  type: string;
};

/** @internal */
export const Five$outboundSchema: z.ZodType<Five$Outbound, z.ZodTypeDef, Five> =
  z.object({
    owner: z.string(),
    ref: z.string(),
    sha: z.string().optional(),
    slug: z.string(),
    type: CreateDeploymentGitSourceDeploymentsRequestType$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Five$ {
  /** @deprecated use `Five$inboundSchema` instead. */
  export const inboundSchema = Five$inboundSchema;
  /** @deprecated use `Five$outboundSchema` instead. */
  export const outboundSchema = Five$outboundSchema;
  /** @deprecated use `Five$Outbound` instead. */
  export type Outbound = Five$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsType$inboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsType> = z
    .nativeEnum(CreateDeploymentGitSourceDeploymentsType);

/** @internal */
export const CreateDeploymentGitSourceDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsType> =
    CreateDeploymentGitSourceDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsType$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsType$outboundSchema;
}

/** @internal */
export const Four$inboundSchema: z.ZodType<Four, z.ZodTypeDef, unknown> = z
  .object({
    ref: z.string(),
    repoUuid: z.string(),
    sha: z.string().optional(),
    type: CreateDeploymentGitSourceDeploymentsType$inboundSchema,
    workspaceUuid: z.string().optional(),
  });

/** @internal */
export type Four$Outbound = {
  ref: string;
  repoUuid: string;
  sha?: string | undefined;
  type: string;
  workspaceUuid?: string | undefined;
};

/** @internal */
export const Four$outboundSchema: z.ZodType<Four$Outbound, z.ZodTypeDef, Four> =
  z.object({
    ref: z.string(),
    repoUuid: z.string(),
    sha: z.string().optional(),
    type: CreateDeploymentGitSourceDeploymentsType$outboundSchema,
    workspaceUuid: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Four$ {
  /** @deprecated use `Four$inboundSchema` instead. */
  export const inboundSchema = Four$inboundSchema;
  /** @deprecated use `Four$outboundSchema` instead. */
  export const outboundSchema = Four$outboundSchema;
  /** @deprecated use `Four$Outbound` instead. */
  export type Outbound = Four$Outbound;
}

/** @internal */
export const ProjectId$inboundSchema: z.ZodType<
  ProjectId,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.string()]);

/** @internal */
export type ProjectId$Outbound = number | string;

/** @internal */
export const ProjectId$outboundSchema: z.ZodType<
  ProjectId$Outbound,
  z.ZodTypeDef,
  ProjectId
> = z.union([z.number(), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProjectId$ {
  /** @deprecated use `ProjectId$inboundSchema` instead. */
  export const inboundSchema = ProjectId$inboundSchema;
  /** @deprecated use `ProjectId$outboundSchema` instead. */
  export const outboundSchema = ProjectId$outboundSchema;
  /** @deprecated use `ProjectId$Outbound` instead. */
  export type Outbound = ProjectId$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceType$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentGitSourceType
> = z.nativeEnum(CreateDeploymentGitSourceType);

/** @internal */
export const CreateDeploymentGitSourceType$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentGitSourceType
> = CreateDeploymentGitSourceType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceType$ {
  /** @deprecated use `CreateDeploymentGitSourceType$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitSourceType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceType$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitSourceType$outboundSchema;
}

/** @internal */
export const Three$inboundSchema: z.ZodType<Three, z.ZodTypeDef, unknown> = z
  .object({
    projectId: z.union([z.number(), z.string()]),
    ref: z.string(),
    sha: z.string().optional(),
    type: CreateDeploymentGitSourceType$inboundSchema,
  });

/** @internal */
export type Three$Outbound = {
  projectId: number | string;
  ref: string;
  sha?: string | undefined;
  type: string;
};

/** @internal */
export const Three$outboundSchema: z.ZodType<
  Three$Outbound,
  z.ZodTypeDef,
  Three
> = z.object({
  projectId: z.union([z.number(), z.string()]),
  ref: z.string(),
  sha: z.string().optional(),
  type: CreateDeploymentGitSourceType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Three$ {
  /** @deprecated use `Three$inboundSchema` instead. */
  export const inboundSchema = Three$inboundSchema;
  /** @deprecated use `Three$outboundSchema` instead. */
  export const outboundSchema = Three$outboundSchema;
  /** @deprecated use `Three$Outbound` instead. */
  export type Outbound = Three$Outbound;
}

/** @internal */
export const GitSourceType$inboundSchema: z.ZodNativeEnum<
  typeof GitSourceType
> = z.nativeEnum(GitSourceType);

/** @internal */
export const GitSourceType$outboundSchema: z.ZodNativeEnum<
  typeof GitSourceType
> = GitSourceType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSourceType$ {
  /** @deprecated use `GitSourceType$inboundSchema` instead. */
  export const inboundSchema = GitSourceType$inboundSchema;
  /** @deprecated use `GitSourceType$outboundSchema` instead. */
  export const outboundSchema = GitSourceType$outboundSchema;
}

/** @internal */
export const Two$inboundSchema: z.ZodType<Two, z.ZodTypeDef, unknown> = z
  .object({
    org: z.string(),
    ref: z.string(),
    repo: z.string(),
    sha: z.string().optional(),
    type: GitSourceType$inboundSchema,
  });

/** @internal */
export type Two$Outbound = {
  org: string;
  ref: string;
  repo: string;
  sha?: string | undefined;
  type: string;
};

/** @internal */
export const Two$outboundSchema: z.ZodType<Two$Outbound, z.ZodTypeDef, Two> = z
  .object({
    org: z.string(),
    ref: z.string(),
    repo: z.string(),
    sha: z.string().optional(),
    type: GitSourceType$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Two$ {
  /** @deprecated use `Two$inboundSchema` instead. */
  export const inboundSchema = Two$inboundSchema;
  /** @deprecated use `Two$outboundSchema` instead. */
  export const outboundSchema = Two$outboundSchema;
  /** @deprecated use `Two$Outbound` instead. */
  export type Outbound = Two$Outbound;
}

/** @internal */
export const RepoId$inboundSchema: z.ZodType<RepoId, z.ZodTypeDef, unknown> = z
  .union([z.number(), z.string()]);

/** @internal */
export type RepoId$Outbound = number | string;

/** @internal */
export const RepoId$outboundSchema: z.ZodType<
  RepoId$Outbound,
  z.ZodTypeDef,
  RepoId
> = z.union([z.number(), z.string()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RepoId$ {
  /** @deprecated use `RepoId$inboundSchema` instead. */
  export const inboundSchema = RepoId$inboundSchema;
  /** @deprecated use `RepoId$outboundSchema` instead. */
  export const outboundSchema = RepoId$outboundSchema;
  /** @deprecated use `RepoId$Outbound` instead. */
  export type Outbound = RepoId$Outbound;
}

/** @internal */
export const Type$inboundSchema: z.ZodNativeEnum<typeof Type> = z.nativeEnum(
  Type,
);

/** @internal */
export const Type$outboundSchema: z.ZodNativeEnum<typeof Type> =
  Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Type$ {
  /** @deprecated use `Type$inboundSchema` instead. */
  export const inboundSchema = Type$inboundSchema;
  /** @deprecated use `Type$outboundSchema` instead. */
  export const outboundSchema = Type$outboundSchema;
}

/** @internal */
export const One$inboundSchema: z.ZodType<One, z.ZodTypeDef, unknown> = z
  .object({
    ref: z.string(),
    repoId: z.union([z.number(), z.string()]),
    sha: z.string().optional(),
    type: Type$inboundSchema,
  });

/** @internal */
export type One$Outbound = {
  ref: string;
  repoId: number | string;
  sha?: string | undefined;
  type: string;
};

/** @internal */
export const One$outboundSchema: z.ZodType<One$Outbound, z.ZodTypeDef, One> = z
  .object({
    ref: z.string(),
    repoId: z.union([z.number(), z.string()]),
    sha: z.string().optional(),
    type: Type$outboundSchema,
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace One$ {
  /** @deprecated use `One$inboundSchema` instead. */
  export const inboundSchema = One$inboundSchema;
  /** @deprecated use `One$outboundSchema` instead. */
  export const outboundSchema = One$outboundSchema;
  /** @deprecated use `One$Outbound` instead. */
  export type Outbound = One$Outbound;
}

/** @internal */
export const GitSource$inboundSchema: z.ZodType<
  GitSource,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => One$inboundSchema),
  z.lazy(() => Three$inboundSchema),
  z.lazy(() => Two$inboundSchema),
  z.lazy(() => Four$inboundSchema),
  z.lazy(() => Five$inboundSchema),
]);

/** @internal */
export type GitSource$Outbound =
  | One$Outbound
  | Three$Outbound
  | Two$Outbound
  | Four$Outbound
  | Five$Outbound;

/** @internal */
export const GitSource$outboundSchema: z.ZodType<
  GitSource$Outbound,
  z.ZodTypeDef,
  GitSource
> = z.union([
  z.lazy(() => One$outboundSchema),
  z.lazy(() => Three$outboundSchema),
  z.lazy(() => Two$outboundSchema),
  z.lazy(() => Four$outboundSchema),
  z.lazy(() => Five$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource$ {
  /** @deprecated use `GitSource$inboundSchema` instead. */
  export const inboundSchema = GitSource$inboundSchema;
  /** @deprecated use `GitSource$outboundSchema` instead. */
  export const outboundSchema = GitSource$outboundSchema;
  /** @deprecated use `GitSource$Outbound` instead. */
  export type Outbound = GitSource$Outbound;
}

/** @internal */
export const Framework$inboundSchema: z.ZodNativeEnum<typeof Framework> = z
  .nativeEnum(Framework);

/** @internal */
export const Framework$outboundSchema: z.ZodNativeEnum<typeof Framework> =
  Framework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Framework$ {
  /** @deprecated use `Framework$inboundSchema` instead. */
  export const inboundSchema = Framework$inboundSchema;
  /** @deprecated use `Framework$outboundSchema` instead. */
  export const outboundSchema = Framework$outboundSchema;
}

/** @internal */
export const NodeVersion$inboundSchema: z.ZodNativeEnum<typeof NodeVersion> = z
  .nativeEnum(NodeVersion);

/** @internal */
export const NodeVersion$outboundSchema: z.ZodNativeEnum<typeof NodeVersion> =
  NodeVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace NodeVersion$ {
  /** @deprecated use `NodeVersion$inboundSchema` instead. */
  export const inboundSchema = NodeVersion$inboundSchema;
  /** @deprecated use `NodeVersion$outboundSchema` instead. */
  export const outboundSchema = NodeVersion$outboundSchema;
}

/** @internal */
export const ProjectSettings$inboundSchema: z.ZodType<
  ProjectSettings,
  z.ZodTypeDef,
  unknown
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(Framework$inboundSchema).optional(),
  installCommand: z.nullable(z.string()).optional(),
  nodeVersion: NodeVersion$inboundSchema.optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
});

/** @internal */
export type ProjectSettings$Outbound = {
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: string | null | undefined;
  installCommand?: string | null | undefined;
  nodeVersion?: string | undefined;
  outputDirectory?: string | null | undefined;
  rootDirectory?: string | null | undefined;
  serverlessFunctionRegion?: string | null | undefined;
  skipGitConnectDuringLink?: boolean | undefined;
  sourceFilesOutsideRootDirectory?: boolean | undefined;
};

/** @internal */
export const ProjectSettings$outboundSchema: z.ZodType<
  ProjectSettings$Outbound,
  z.ZodTypeDef,
  ProjectSettings
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(Framework$outboundSchema).optional(),
  installCommand: z.nullable(z.string()).optional(),
  nodeVersion: NodeVersion$outboundSchema.optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  rootDirectory: z.nullable(z.string()).optional(),
  serverlessFunctionRegion: z.nullable(z.string()).optional(),
  skipGitConnectDuringLink: z.boolean().optional(),
  sourceFilesOutsideRootDirectory: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ProjectSettings$ {
  /** @deprecated use `ProjectSettings$inboundSchema` instead. */
  export const inboundSchema = ProjectSettings$inboundSchema;
  /** @deprecated use `ProjectSettings$outboundSchema` instead. */
  export const outboundSchema = ProjectSettings$outboundSchema;
  /** @deprecated use `ProjectSettings$Outbound` instead. */
  export type Outbound = ProjectSettings$Outbound;
}

/** @internal */
export const Target$inboundSchema: z.ZodNativeEnum<typeof Target> = z
  .nativeEnum(Target);

/** @internal */
export const Target$outboundSchema: z.ZodNativeEnum<typeof Target> =
  Target$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Target$ {
  /** @deprecated use `Target$inboundSchema` instead. */
  export const inboundSchema = Target$inboundSchema;
  /** @deprecated use `Target$outboundSchema` instead. */
  export const outboundSchema = Target$outboundSchema;
}

/** @internal */
export const CreateDeploymentRequestBody$inboundSchema: z.ZodType<
  CreateDeploymentRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentId: z.string().optional(),
  files: z.array(
    z.union([
      z.lazy(() => InlinedFile$inboundSchema),
      z.lazy(() => UploadedFile$inboundSchema),
    ]),
  ).optional(),
  gitMetadata: z.lazy(() => GitMetadata$inboundSchema).optional(),
  gitSource: z.union([
    z.lazy(() => One$inboundSchema),
    z.lazy(() => Three$inboundSchema),
    z.lazy(() => Two$inboundSchema),
    z.lazy(() => Four$inboundSchema),
    z.lazy(() => Five$inboundSchema),
  ]).optional(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  name: z.string(),
  project: z.string().optional(),
  projectSettings: z.lazy(() => ProjectSettings$inboundSchema).optional(),
  target: Target$inboundSchema.optional(),
  withLatestCommit: z.boolean().optional(),
});

/** @internal */
export type CreateDeploymentRequestBody$Outbound = {
  deploymentId?: string | undefined;
  files?: Array<InlinedFile$Outbound | UploadedFile$Outbound> | undefined;
  gitMetadata?: GitMetadata$Outbound | undefined;
  gitSource?:
    | One$Outbound
    | Three$Outbound
    | Two$Outbound
    | Four$Outbound
    | Five$Outbound
    | undefined;
  meta?: { [k: string]: string } | undefined;
  monorepoManager?: string | null | undefined;
  name: string;
  project?: string | undefined;
  projectSettings?: ProjectSettings$Outbound | undefined;
  target?: string | undefined;
  withLatestCommit?: boolean | undefined;
};

/** @internal */
export const CreateDeploymentRequestBody$outboundSchema: z.ZodType<
  CreateDeploymentRequestBody$Outbound,
  z.ZodTypeDef,
  CreateDeploymentRequestBody
> = z.object({
  deploymentId: z.string().optional(),
  files: z.array(
    z.union([
      z.lazy(() => InlinedFile$outboundSchema),
      z.lazy(() => UploadedFile$outboundSchema),
    ]),
  ).optional(),
  gitMetadata: z.lazy(() => GitMetadata$outboundSchema).optional(),
  gitSource: z.union([
    z.lazy(() => One$outboundSchema),
    z.lazy(() => Three$outboundSchema),
    z.lazy(() => Two$outboundSchema),
    z.lazy(() => Four$outboundSchema),
    z.lazy(() => Five$outboundSchema),
  ]).optional(),
  meta: z.record(z.string()).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  name: z.string(),
  project: z.string().optional(),
  projectSettings: z.lazy(() => ProjectSettings$outboundSchema).optional(),
  target: Target$outboundSchema.optional(),
  withLatestCommit: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentRequestBody$ {
  /** @deprecated use `CreateDeploymentRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentRequestBody$inboundSchema;
  /** @deprecated use `CreateDeploymentRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentRequestBody$outboundSchema;
  /** @deprecated use `CreateDeploymentRequestBody$Outbound` instead. */
  export type Outbound = CreateDeploymentRequestBody$Outbound;
}

/** @internal */
export const CreateDeploymentRequest$inboundSchema: z.ZodType<
  CreateDeploymentRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  skipAutoDetectionConfirmation: SkipAutoDetectionConfirmation$inboundSchema
    .optional(),
  forceNew: ForceNew$inboundSchema.optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => CreateDeploymentRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateDeploymentRequest$Outbound = {
  skipAutoDetectionConfirmation?: string | undefined;
  forceNew?: string | undefined;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: CreateDeploymentRequestBody$Outbound | undefined;
};

/** @internal */
export const CreateDeploymentRequest$outboundSchema: z.ZodType<
  CreateDeploymentRequest$Outbound,
  z.ZodTypeDef,
  CreateDeploymentRequest
> = z.object({
  skipAutoDetectionConfirmation: SkipAutoDetectionConfirmation$outboundSchema
    .optional(),
  forceNew: ForceNew$outboundSchema.optional(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => CreateDeploymentRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentRequest$ {
  /** @deprecated use `CreateDeploymentRequest$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentRequest$inboundSchema;
  /** @deprecated use `CreateDeploymentRequest$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentRequest$outboundSchema;
  /** @deprecated use `CreateDeploymentRequest$Outbound` instead. */
  export type Outbound = CreateDeploymentRequest$Outbound;
}

/** @internal */
export const AliasAssignedAt$inboundSchema: z.ZodType<
  AliasAssignedAt,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type AliasAssignedAt$Outbound = number | boolean;

/** @internal */
export const AliasAssignedAt$outboundSchema: z.ZodType<
  AliasAssignedAt$Outbound,
  z.ZodTypeDef,
  AliasAssignedAt
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AliasAssignedAt$ {
  /** @deprecated use `AliasAssignedAt$inboundSchema` instead. */
  export const inboundSchema = AliasAssignedAt$inboundSchema;
  /** @deprecated use `AliasAssignedAt$outboundSchema` instead. */
  export const outboundSchema = AliasAssignedAt$outboundSchema;
  /** @deprecated use `AliasAssignedAt$Outbound` instead. */
  export type Outbound = AliasAssignedAt$Outbound;
}

/** @internal */
export const Build$inboundSchema: z.ZodType<Build, z.ZodTypeDef, unknown> = z
  .object({
    env: z.array(z.string()),
  });

/** @internal */
export type Build$Outbound = {
  env: Array<string>;
};

/** @internal */
export const Build$outboundSchema: z.ZodType<
  Build$Outbound,
  z.ZodTypeDef,
  Build
> = z.object({
  env: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Build$ {
  /** @deprecated use `Build$inboundSchema` instead. */
  export const inboundSchema = Build$inboundSchema;
  /** @deprecated use `Build$outboundSchema` instead. */
  export const outboundSchema = Build$outboundSchema;
  /** @deprecated use `Build$Outbound` instead. */
  export type Outbound = Build$Outbound;
}

/** @internal */
export const Builds$inboundSchema: z.ZodType<Builds, z.ZodTypeDef, unknown> = z
  .object({});

/** @internal */
export type Builds$Outbound = {};

/** @internal */
export const Builds$outboundSchema: z.ZodType<
  Builds$Outbound,
  z.ZodTypeDef,
  Builds
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Builds$ {
  /** @deprecated use `Builds$inboundSchema` instead. */
  export const inboundSchema = Builds$inboundSchema;
  /** @deprecated use `Builds$outboundSchema` instead. */
  export const outboundSchema = Builds$outboundSchema;
  /** @deprecated use `Builds$Outbound` instead. */
  export type Outbound = Builds$Outbound;
}

/** @internal */
export const CreateDeploymentFramework$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentFramework
> = z.nativeEnum(CreateDeploymentFramework);

/** @internal */
export const CreateDeploymentFramework$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentFramework
> = CreateDeploymentFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentFramework$ {
  /** @deprecated use `CreateDeploymentFramework$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentFramework$inboundSchema;
  /** @deprecated use `CreateDeploymentFramework$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentFramework$outboundSchema;
}

/** @internal */
export const CreateDeploymentSpeedInsights$inboundSchema: z.ZodType<
  CreateDeploymentSpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type CreateDeploymentSpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const CreateDeploymentSpeedInsights$outboundSchema: z.ZodType<
  CreateDeploymentSpeedInsights$Outbound,
  z.ZodTypeDef,
  CreateDeploymentSpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentSpeedInsights$ {
  /** @deprecated use `CreateDeploymentSpeedInsights$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentSpeedInsights$inboundSchema;
  /** @deprecated use `CreateDeploymentSpeedInsights$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentSpeedInsights$outboundSchema;
  /** @deprecated use `CreateDeploymentSpeedInsights$Outbound` instead. */
  export type Outbound = CreateDeploymentSpeedInsights$Outbound;
}

/** @internal */
export const CreateDeploymentWebAnalytics$inboundSchema: z.ZodType<
  CreateDeploymentWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type CreateDeploymentWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const CreateDeploymentWebAnalytics$outboundSchema: z.ZodType<
  CreateDeploymentWebAnalytics$Outbound,
  z.ZodTypeDef,
  CreateDeploymentWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentWebAnalytics$ {
  /** @deprecated use `CreateDeploymentWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentWebAnalytics$inboundSchema;
  /** @deprecated use `CreateDeploymentWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentWebAnalytics$outboundSchema;
  /** @deprecated use `CreateDeploymentWebAnalytics$Outbound` instead. */
  export type Outbound = CreateDeploymentWebAnalytics$Outbound;
}

/** @internal */
export const CreateDeploymentProjectSettings$inboundSchema: z.ZodType<
  CreateDeploymentProjectSettings,
  z.ZodTypeDef,
  unknown
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(CreateDeploymentFramework$inboundSchema).optional(),
  installCommand: z.nullable(z.string()).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  speedInsights: z.lazy(() => CreateDeploymentSpeedInsights$inboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => CreateDeploymentWebAnalytics$inboundSchema)
    .optional(),
});

/** @internal */
export type CreateDeploymentProjectSettings$Outbound = {
  buildCommand?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: string | null | undefined;
  installCommand?: string | null | undefined;
  outputDirectory?: string | null | undefined;
  speedInsights?: CreateDeploymentSpeedInsights$Outbound | undefined;
  webAnalytics?: CreateDeploymentWebAnalytics$Outbound | undefined;
};

/** @internal */
export const CreateDeploymentProjectSettings$outboundSchema: z.ZodType<
  CreateDeploymentProjectSettings$Outbound,
  z.ZodTypeDef,
  CreateDeploymentProjectSettings
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(CreateDeploymentFramework$outboundSchema).optional(),
  installCommand: z.nullable(z.string()).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  speedInsights: z.lazy(() => CreateDeploymentSpeedInsights$outboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => CreateDeploymentWebAnalytics$outboundSchema)
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentProjectSettings$ {
  /** @deprecated use `CreateDeploymentProjectSettings$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentProjectSettings$inboundSchema;
  /** @deprecated use `CreateDeploymentProjectSettings$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentProjectSettings$outboundSchema;
  /** @deprecated use `CreateDeploymentProjectSettings$Outbound` instead. */
  export type Outbound = CreateDeploymentProjectSettings$Outbound;
}

/** @internal */
export const CreateDeploymentDeploymentsStatus$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentDeploymentsStatus
> = z.nativeEnum(CreateDeploymentDeploymentsStatus);

/** @internal */
export const CreateDeploymentDeploymentsStatus$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentDeploymentsStatus
> = CreateDeploymentDeploymentsStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentDeploymentsStatus$ {
  /** @deprecated use `CreateDeploymentDeploymentsStatus$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentDeploymentsStatus$inboundSchema;
  /** @deprecated use `CreateDeploymentDeploymentsStatus$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentDeploymentsStatus$outboundSchema;
}

/** @internal */
export const Integrations$inboundSchema: z.ZodType<
  Integrations,
  z.ZodTypeDef,
  unknown
> = z.object({
  status: CreateDeploymentDeploymentsStatus$inboundSchema,
  startedAt: z.number(),
  completedAt: z.number().optional(),
  skippedAt: z.number().optional(),
  skippedBy: z.string().optional(),
});

/** @internal */
export type Integrations$Outbound = {
  status: string;
  startedAt: number;
  completedAt?: number | undefined;
  skippedAt?: number | undefined;
  skippedBy?: string | undefined;
};

/** @internal */
export const Integrations$outboundSchema: z.ZodType<
  Integrations$Outbound,
  z.ZodTypeDef,
  Integrations
> = z.object({
  status: CreateDeploymentDeploymentsStatus$outboundSchema,
  startedAt: z.number(),
  completedAt: z.number().optional(),
  skippedAt: z.number().optional(),
  skippedBy: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Integrations$ {
  /** @deprecated use `Integrations$inboundSchema` instead. */
  export const inboundSchema = Integrations$inboundSchema;
  /** @deprecated use `Integrations$outboundSchema` instead. */
  export const outboundSchema = Integrations$outboundSchema;
  /** @deprecated use `Integrations$Outbound` instead. */
  export type Outbound = Integrations$Outbound;
}

/** @internal */
export const Creator$inboundSchema: z.ZodType<Creator, z.ZodTypeDef, unknown> =
  z.object({
    uid: z.string(),
    username: z.string().optional(),
    avatar: z.string().optional(),
  });

/** @internal */
export type Creator$Outbound = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

/** @internal */
export const Creator$outboundSchema: z.ZodType<
  Creator$Outbound,
  z.ZodTypeDef,
  Creator
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Creator$ {
  /** @deprecated use `Creator$inboundSchema` instead. */
  export const inboundSchema = Creator$inboundSchema;
  /** @deprecated use `Creator$outboundSchema` instead. */
  export const outboundSchema = Creator$outboundSchema;
  /** @deprecated use `Creator$Outbound` instead. */
  export type Outbound = Creator$Outbound;
}

/** @internal */
export const CreateDeploymentReadyState$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentReadyState
> = z.nativeEnum(CreateDeploymentReadyState);

/** @internal */
export const CreateDeploymentReadyState$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentReadyState
> = CreateDeploymentReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentReadyState$ {
  /** @deprecated use `CreateDeploymentReadyState$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentReadyState$inboundSchema;
  /** @deprecated use `CreateDeploymentReadyState$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentReadyState$outboundSchema;
}

/** @internal */
export const CreateDeploymentOutput$inboundSchema: z.ZodType<
  CreateDeploymentOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/** @internal */
export type CreateDeploymentOutput$Outbound = {
  path: string;
  functionName: string;
};

/** @internal */
export const CreateDeploymentOutput$outboundSchema: z.ZodType<
  CreateDeploymentOutput$Outbound,
  z.ZodTypeDef,
  CreateDeploymentOutput
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentOutput$ {
  /** @deprecated use `CreateDeploymentOutput$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentOutput$inboundSchema;
  /** @deprecated use `CreateDeploymentOutput$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentOutput$outboundSchema;
  /** @deprecated use `CreateDeploymentOutput$Outbound` instead. */
  export type Outbound = CreateDeploymentOutput$Outbound;
}

/** @internal */
export const Lambdas$inboundSchema: z.ZodType<Lambdas, z.ZodTypeDef, unknown> =
  z.object({
    id: z.string().optional(),
    createdAt: z.number().optional(),
    entrypoint: z.nullable(z.string()).optional(),
    readyState: CreateDeploymentReadyState$inboundSchema.optional(),
    readyStateAt: z.number().optional(),
    output: z.array(z.lazy(() => CreateDeploymentOutput$inboundSchema)),
  });

/** @internal */
export type Lambdas$Outbound = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: string | undefined;
  readyStateAt?: number | undefined;
  output: Array<CreateDeploymentOutput$Outbound>;
};

/** @internal */
export const Lambdas$outboundSchema: z.ZodType<
  Lambdas$Outbound,
  z.ZodTypeDef,
  Lambdas
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState: CreateDeploymentReadyState$outboundSchema.optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => CreateDeploymentOutput$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Lambdas$ {
  /** @deprecated use `Lambdas$inboundSchema` instead. */
  export const inboundSchema = Lambdas$inboundSchema;
  /** @deprecated use `Lambdas$outboundSchema` instead. */
  export const outboundSchema = Lambdas$outboundSchema;
  /** @deprecated use `Lambdas$Outbound` instead. */
  export type Outbound = Lambdas$Outbound;
}

/** @internal */
export const CreateDeploymentStatus$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentStatus
> = z.nativeEnum(CreateDeploymentStatus);

/** @internal */
export const CreateDeploymentStatus$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentStatus
> = CreateDeploymentStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentStatus$ {
  /** @deprecated use `CreateDeploymentStatus$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentStatus$inboundSchema;
  /** @deprecated use `CreateDeploymentStatus$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentStatus$outboundSchema;
}

/** @internal */
export const Team$inboundSchema: z.ZodType<Team, z.ZodTypeDef, unknown> = z
  .object({
    name: z.string(),
    id: z.string(),
    slug: z.string(),
    avatar: z.string().optional(),
  });

/** @internal */
export type Team$Outbound = {
  name: string;
  id: string;
  slug: string;
  avatar?: string | undefined;
};

/** @internal */
export const Team$outboundSchema: z.ZodType<Team$Outbound, z.ZodTypeDef, Team> =
  z.object({
    name: z.string(),
    id: z.string(),
    slug: z.string(),
    avatar: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Team$ {
  /** @deprecated use `Team$inboundSchema` instead. */
  export const inboundSchema = Team$inboundSchema;
  /** @deprecated use `Team$outboundSchema` instead. */
  export const outboundSchema = Team$outboundSchema;
  /** @deprecated use `Team$Outbound` instead. */
  export type Outbound = Team$Outbound;
}

/** @internal */
export const CustomEnvironment2$inboundSchema: z.ZodType<
  CustomEnvironment2,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
});

/** @internal */
export type CustomEnvironment2$Outbound = {
  id: string;
};

/** @internal */
export const CustomEnvironment2$outboundSchema: z.ZodType<
  CustomEnvironment2$Outbound,
  z.ZodTypeDef,
  CustomEnvironment2
> = z.object({
  id: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CustomEnvironment2$ {
  /** @deprecated use `CustomEnvironment2$inboundSchema` instead. */
  export const inboundSchema = CustomEnvironment2$inboundSchema;
  /** @deprecated use `CustomEnvironment2$outboundSchema` instead. */
  export const outboundSchema = CustomEnvironment2$outboundSchema;
  /** @deprecated use `CustomEnvironment2$Outbound` instead. */
  export type Outbound = CustomEnvironment2$Outbound;
}

/** @internal */
export const CustomEnvironment1$inboundSchema: z.ZodType<
  CustomEnvironment1,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CustomEnvironment1$Outbound = {};

/** @internal */
export const CustomEnvironment1$outboundSchema: z.ZodType<
  CustomEnvironment1$Outbound,
  z.ZodTypeDef,
  CustomEnvironment1
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CustomEnvironment1$ {
  /** @deprecated use `CustomEnvironment1$inboundSchema` instead. */
  export const inboundSchema = CustomEnvironment1$inboundSchema;
  /** @deprecated use `CustomEnvironment1$outboundSchema` instead. */
  export const outboundSchema = CustomEnvironment1$outboundSchema;
  /** @deprecated use `CustomEnvironment1$Outbound` instead. */
  export type Outbound = CustomEnvironment1$Outbound;
}

/** @internal */
export const CustomEnvironment$inboundSchema: z.ZodType<
  CustomEnvironment,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CustomEnvironment1$inboundSchema),
  z.lazy(() => CustomEnvironment2$inboundSchema),
]);

/** @internal */
export type CustomEnvironment$Outbound =
  | CustomEnvironment1$Outbound
  | CustomEnvironment2$Outbound;

/** @internal */
export const CustomEnvironment$outboundSchema: z.ZodType<
  CustomEnvironment$Outbound,
  z.ZodTypeDef,
  CustomEnvironment
> = z.union([
  z.lazy(() => CustomEnvironment1$outboundSchema),
  z.lazy(() => CustomEnvironment2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CustomEnvironment$ {
  /** @deprecated use `CustomEnvironment$inboundSchema` instead. */
  export const inboundSchema = CustomEnvironment$inboundSchema;
  /** @deprecated use `CustomEnvironment$outboundSchema` instead. */
  export const outboundSchema = CustomEnvironment$outboundSchema;
  /** @deprecated use `CustomEnvironment$Outbound` instead. */
  export type Outbound = CustomEnvironment$Outbound;
}

/** @internal */
export const CreateDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentType
> = z.nativeEnum(CreateDeploymentType);

/** @internal */
export const CreateDeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentType
> = CreateDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentType$ {
  /** @deprecated use `CreateDeploymentType$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentType$inboundSchema;
  /** @deprecated use `CreateDeploymentType$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentType$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitSource9$inboundSchema: z.ZodType<
  CreateDeploymentGitSource9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/** @internal */
export type CreateDeploymentGitSource9$Outbound = {
  type: string;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

/** @internal */
export const CreateDeploymentGitSource9$outboundSchema: z.ZodType<
  CreateDeploymentGitSource9$Outbound,
  z.ZodTypeDef,
  CreateDeploymentGitSource9
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSource9$ {
  /** @deprecated use `CreateDeploymentGitSource9$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitSource9$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSource9$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitSource9$outboundSchema;
  /** @deprecated use `CreateDeploymentGitSource9$Outbound` instead. */
  export type Outbound = CreateDeploymentGitSource9$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitSource8$inboundSchema: z.ZodType<
  CreateDeploymentGitSource8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/** @internal */
export type CreateDeploymentGitSource8$Outbound = {
  type: string;
  ref: string;
  sha: string;
  projectId: number;
};

/** @internal */
export const CreateDeploymentGitSource8$outboundSchema: z.ZodType<
  CreateDeploymentGitSource8$Outbound,
  z.ZodTypeDef,
  CreateDeploymentGitSource8
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSource8$ {
  /** @deprecated use `CreateDeploymentGitSource8$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitSource8$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSource8$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitSource8$outboundSchema;
  /** @deprecated use `CreateDeploymentGitSource8$Outbound` instead. */
  export type Outbound = CreateDeploymentGitSource8$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitSource7$inboundSchema: z.ZodType<
  CreateDeploymentGitSource7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/** @internal */
export type CreateDeploymentGitSource7$Outbound = {
  type: string;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

/** @internal */
export const CreateDeploymentGitSource7$outboundSchema: z.ZodType<
  CreateDeploymentGitSource7$Outbound,
  z.ZodTypeDef,
  CreateDeploymentGitSource7
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSource7$ {
  /** @deprecated use `CreateDeploymentGitSource7$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitSource7$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSource7$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitSource7$outboundSchema;
  /** @deprecated use `CreateDeploymentGitSource7$Outbound` instead. */
  export type Outbound = CreateDeploymentGitSource7$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitSource6$inboundSchema: z.ZodType<
  CreateDeploymentGitSource6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/** @internal */
export type CreateDeploymentGitSource6$Outbound = {
  type: string;
  ref: string;
  sha: string;
  gitUrl: string;
};

/** @internal */
export const CreateDeploymentGitSource6$outboundSchema: z.ZodType<
  CreateDeploymentGitSource6$Outbound,
  z.ZodTypeDef,
  CreateDeploymentGitSource6
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody6Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSource6$ {
  /** @deprecated use `CreateDeploymentGitSource6$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitSource6$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSource6$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitSource6$outboundSchema;
  /** @deprecated use `CreateDeploymentGitSource6$Outbound` instead. */
  export type Outbound = CreateDeploymentGitSource6$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$outboundSchema;
}

/** @internal */
export const GitSource5$inboundSchema: z.ZodType<
  GitSource5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$inboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GitSource5$Outbound = {
  type: string;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GitSource5$outboundSchema: z.ZodType<
  GitSource5$Outbound,
  z.ZodTypeDef,
  GitSource5
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody5Type$outboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource5$ {
  /** @deprecated use `GitSource5$inboundSchema` instead. */
  export const inboundSchema = GitSource5$inboundSchema;
  /** @deprecated use `GitSource5$outboundSchema` instead. */
  export const outboundSchema = GitSource5$outboundSchema;
  /** @deprecated use `GitSource5$Outbound` instead. */
  export type Outbound = GitSource5$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const GitSource4$inboundSchema: z.ZodType<
  GitSource4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GitSource4$Outbound = {
  type: string;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GitSource4$outboundSchema: z.ZodType<
  GitSource4$Outbound,
  z.ZodTypeDef,
  GitSource4
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource4$ {
  /** @deprecated use `GitSource4$inboundSchema` instead. */
  export const inboundSchema = GitSource4$inboundSchema;
  /** @deprecated use `GitSource4$outboundSchema` instead. */
  export const outboundSchema = GitSource4$outboundSchema;
  /** @deprecated use `GitSource4$Outbound` instead. */
  export type Outbound = GitSource4$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  > = z.nativeEnum(
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType,
  );

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  > =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const GitSourceProjectId$inboundSchema: z.ZodType<
  GitSourceProjectId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GitSourceProjectId$Outbound = string | number;

/** @internal */
export const GitSourceProjectId$outboundSchema: z.ZodType<
  GitSourceProjectId$Outbound,
  z.ZodTypeDef,
  GitSourceProjectId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSourceProjectId$ {
  /** @deprecated use `GitSourceProjectId$inboundSchema` instead. */
  export const inboundSchema = GitSourceProjectId$inboundSchema;
  /** @deprecated use `GitSourceProjectId$outboundSchema` instead. */
  export const outboundSchema = GitSourceProjectId$outboundSchema;
  /** @deprecated use `GitSourceProjectId$Outbound` instead. */
  export type Outbound = GitSourceProjectId$Outbound;
}

/** @internal */
export const GitSource3$inboundSchema: z.ZodType<
  GitSource3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GitSource3$Outbound = {
  type: string;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GitSource3$outboundSchema: z.ZodType<
  GitSource3$Outbound,
  z.ZodTypeDef,
  GitSource3
> = z.object({
  type:
    CreateDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource3$ {
  /** @deprecated use `GitSource3$inboundSchema` instead. */
  export const inboundSchema = GitSource3$inboundSchema;
  /** @deprecated use `GitSource3$outboundSchema` instead. */
  export const outboundSchema = GitSource3$outboundSchema;
  /** @deprecated use `GitSource3$Outbound` instead. */
  export type Outbound = GitSource3$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsResponse200Type> =
    z.nativeEnum(CreateDeploymentGitSourceDeploymentsResponse200Type);

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsResponse200Type> =
    CreateDeploymentGitSourceDeploymentsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponse200Type$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200Type$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponse200Type$outboundSchema;
}

/** @internal */
export const GitSource2$inboundSchema: z.ZodType<
  GitSource2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateDeploymentGitSourceDeploymentsResponse200Type$inboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GitSource2$Outbound = {
  type: string;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GitSource2$outboundSchema: z.ZodType<
  GitSource2$Outbound,
  z.ZodTypeDef,
  GitSource2
> = z.object({
  type: CreateDeploymentGitSourceDeploymentsResponse200Type$outboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource2$ {
  /** @deprecated use `GitSource2$inboundSchema` instead. */
  export const inboundSchema = GitSource2$inboundSchema;
  /** @deprecated use `GitSource2$outboundSchema` instead. */
  export const outboundSchema = GitSource2$outboundSchema;
  /** @deprecated use `GitSource2$Outbound` instead. */
  export type Outbound = GitSource2$Outbound;
}

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsResponseType> = z
    .nativeEnum(CreateDeploymentGitSourceDeploymentsResponseType);

/** @internal */
export const CreateDeploymentGitSourceDeploymentsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitSourceDeploymentsResponseType> =
    CreateDeploymentGitSourceDeploymentsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSourceDeploymentsResponseType$ {
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitSourceDeploymentsResponseType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSourceDeploymentsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitSourceDeploymentsResponseType$outboundSchema;
}

/** @internal */
export const GitSourceRepoId$inboundSchema: z.ZodType<
  GitSourceRepoId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GitSourceRepoId$Outbound = string | number;

/** @internal */
export const GitSourceRepoId$outboundSchema: z.ZodType<
  GitSourceRepoId$Outbound,
  z.ZodTypeDef,
  GitSourceRepoId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSourceRepoId$ {
  /** @deprecated use `GitSourceRepoId$inboundSchema` instead. */
  export const inboundSchema = GitSourceRepoId$inboundSchema;
  /** @deprecated use `GitSourceRepoId$outboundSchema` instead. */
  export const outboundSchema = GitSourceRepoId$outboundSchema;
  /** @deprecated use `GitSourceRepoId$Outbound` instead. */
  export type Outbound = GitSourceRepoId$Outbound;
}

/** @internal */
export const GitSource1$inboundSchema: z.ZodType<
  GitSource1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateDeploymentGitSourceDeploymentsResponseType$inboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type GitSource1$Outbound = {
  type: string;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const GitSource1$outboundSchema: z.ZodType<
  GitSource1$Outbound,
  z.ZodTypeDef,
  GitSource1
> = z.object({
  type: CreateDeploymentGitSourceDeploymentsResponseType$outboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource1$ {
  /** @deprecated use `GitSource1$inboundSchema` instead. */
  export const inboundSchema = GitSource1$inboundSchema;
  /** @deprecated use `GitSource1$outboundSchema` instead. */
  export const outboundSchema = GitSource1$outboundSchema;
  /** @deprecated use `GitSource1$Outbound` instead. */
  export type Outbound = GitSource1$Outbound;
}

/** @internal */
export const CreateDeploymentGitSource$inboundSchema: z.ZodType<
  CreateDeploymentGitSource,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CreateDeploymentGitSource6$inboundSchema),
  z.lazy(() => CreateDeploymentGitSource8$inboundSchema),
  z.lazy(() => GitSource1$inboundSchema),
  z.lazy(() => GitSource3$inboundSchema),
  z.lazy(() => GitSource2$inboundSchema),
  z.lazy(() => GitSource4$inboundSchema),
  z.lazy(() => GitSource5$inboundSchema),
  z.lazy(() => CreateDeploymentGitSource7$inboundSchema),
  z.lazy(() => CreateDeploymentGitSource9$inboundSchema),
]);

/** @internal */
export type CreateDeploymentGitSource$Outbound =
  | CreateDeploymentGitSource6$Outbound
  | CreateDeploymentGitSource8$Outbound
  | GitSource1$Outbound
  | GitSource3$Outbound
  | GitSource2$Outbound
  | GitSource4$Outbound
  | GitSource5$Outbound
  | CreateDeploymentGitSource7$Outbound
  | CreateDeploymentGitSource9$Outbound;

/** @internal */
export const CreateDeploymentGitSource$outboundSchema: z.ZodType<
  CreateDeploymentGitSource$Outbound,
  z.ZodTypeDef,
  CreateDeploymentGitSource
> = z.union([
  z.lazy(() => CreateDeploymentGitSource6$outboundSchema),
  z.lazy(() => CreateDeploymentGitSource8$outboundSchema),
  z.lazy(() => GitSource1$outboundSchema),
  z.lazy(() => GitSource3$outboundSchema),
  z.lazy(() => GitSource2$outboundSchema),
  z.lazy(() => GitSource4$outboundSchema),
  z.lazy(() => GitSource5$outboundSchema),
  z.lazy(() => CreateDeploymentGitSource7$outboundSchema),
  z.lazy(() => CreateDeploymentGitSource9$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitSource$ {
  /** @deprecated use `CreateDeploymentGitSource$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitSource$inboundSchema;
  /** @deprecated use `CreateDeploymentGitSource$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitSource$outboundSchema;
  /** @deprecated use `CreateDeploymentGitSource$Outbound` instead. */
  export type Outbound = CreateDeploymentGitSource$Outbound;
}

/** @internal */
export const Project$inboundSchema: z.ZodType<Project, z.ZodTypeDef, unknown> =
  z.object({
    id: z.string(),
    name: z.string(),
    framework: z.nullable(z.string()).optional(),
  });

/** @internal */
export type Project$Outbound = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

/** @internal */
export const Project$outboundSchema: z.ZodType<
  Project$Outbound,
  z.ZodTypeDef,
  Project
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Project$ {
  /** @deprecated use `Project$inboundSchema` instead. */
  export const inboundSchema = Project$inboundSchema;
  /** @deprecated use `Project$outboundSchema` instead. */
  export const outboundSchema = Project$outboundSchema;
  /** @deprecated use `Project$Outbound` instead. */
  export type Outbound = Project$Outbound;
}

/** @internal */
export const ReadyState$inboundSchema: z.ZodNativeEnum<typeof ReadyState> = z
  .nativeEnum(ReadyState);

/** @internal */
export const ReadyState$outboundSchema: z.ZodNativeEnum<typeof ReadyState> =
  ReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ReadyState$ {
  /** @deprecated use `ReadyState$inboundSchema` instead. */
  export const inboundSchema = ReadyState$inboundSchema;
  /** @deprecated use `ReadyState$outboundSchema` instead. */
  export const outboundSchema = ReadyState$outboundSchema;
}

/** @internal */
export const CreateDeploymentSource$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentSource
> = z.nativeEnum(CreateDeploymentSource);

/** @internal */
export const CreateDeploymentSource$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentSource
> = CreateDeploymentSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentSource$ {
  /** @deprecated use `CreateDeploymentSource$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentSource$inboundSchema;
  /** @deprecated use `CreateDeploymentSource$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentSource$outboundSchema;
}

/** @internal */
export const CreateDeploymentTarget$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentTarget
> = z.nativeEnum(CreateDeploymentTarget);

/** @internal */
export const CreateDeploymentTarget$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentTarget
> = CreateDeploymentTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentTarget$ {
  /** @deprecated use `CreateDeploymentTarget$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentTarget$inboundSchema;
  /** @deprecated use `CreateDeploymentTarget$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentTarget$outboundSchema;
}

/** @internal */
export const AliasWarning$inboundSchema: z.ZodType<
  AliasWarning,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/** @internal */
export type AliasWarning$Outbound = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

/** @internal */
export const AliasWarning$outboundSchema: z.ZodType<
  AliasWarning$Outbound,
  z.ZodTypeDef,
  AliasWarning
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AliasWarning$ {
  /** @deprecated use `AliasWarning$inboundSchema` instead. */
  export const inboundSchema = AliasWarning$inboundSchema;
  /** @deprecated use `AliasWarning$outboundSchema` instead. */
  export const outboundSchema = AliasWarning$outboundSchema;
  /** @deprecated use `AliasWarning$Outbound` instead. */
  export type Outbound = AliasWarning$Outbound;
}

/** @internal */
export const AliasError$inboundSchema: z.ZodType<
  AliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type AliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const AliasError$outboundSchema: z.ZodType<
  AliasError$Outbound,
  z.ZodTypeDef,
  AliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AliasError$ {
  /** @deprecated use `AliasError$inboundSchema` instead. */
  export const inboundSchema = AliasError$inboundSchema;
  /** @deprecated use `AliasError$outboundSchema` instead. */
  export const outboundSchema = AliasError$outboundSchema;
  /** @deprecated use `AliasError$Outbound` instead. */
  export type Outbound = AliasError$Outbound;
}

/** @internal */
export const ChecksState$inboundSchema: z.ZodNativeEnum<typeof ChecksState> = z
  .nativeEnum(ChecksState);

/** @internal */
export const ChecksState$outboundSchema: z.ZodNativeEnum<typeof ChecksState> =
  ChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ChecksState$ {
  /** @deprecated use `ChecksState$inboundSchema` instead. */
  export const inboundSchema = ChecksState$inboundSchema;
  /** @deprecated use `ChecksState$outboundSchema` instead. */
  export const outboundSchema = ChecksState$outboundSchema;
}

/** @internal */
export const ChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof ChecksConclusion
> = z.nativeEnum(ChecksConclusion);

/** @internal */
export const ChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof ChecksConclusion
> = ChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ChecksConclusion$ {
  /** @deprecated use `ChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = ChecksConclusion$inboundSchema;
  /** @deprecated use `ChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = ChecksConclusion$outboundSchema;
}

/** @internal */
export const ReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof ReadySubstate
> = z.nativeEnum(ReadySubstate);

/** @internal */
export const ReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof ReadySubstate
> = ReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ReadySubstate$ {
  /** @deprecated use `ReadySubstate$inboundSchema` instead. */
  export const inboundSchema = ReadySubstate$inboundSchema;
  /** @deprecated use `ReadySubstate$outboundSchema` instead. */
  export const outboundSchema = ReadySubstate$outboundSchema;
}

/** @internal */
export const OidcTokenClaims$inboundSchema: z.ZodType<
  OidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type OidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const OidcTokenClaims$outboundSchema: z.ZodType<
  OidcTokenClaims$Outbound,
  z.ZodTypeDef,
  OidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace OidcTokenClaims$ {
  /** @deprecated use `OidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = OidcTokenClaims$inboundSchema;
  /** @deprecated use `OidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema = OidcTokenClaims$outboundSchema;
  /** @deprecated use `OidcTokenClaims$Outbound` instead. */
  export type Outbound = OidcTokenClaims$Outbound;
}

/** @internal */
export const Functions$inboundSchema: z.ZodType<
  Functions,
  z.ZodTypeDef,
  unknown
> = z.object({
  memory: z.number().optional(),
  maxDuration: z.number().optional(),
  runtime: z.string().optional(),
  includeFiles: z.string().optional(),
  excludeFiles: z.string().optional(),
});

/** @internal */
export type Functions$Outbound = {
  memory?: number | undefined;
  maxDuration?: number | undefined;
  runtime?: string | undefined;
  includeFiles?: string | undefined;
  excludeFiles?: string | undefined;
};

/** @internal */
export const Functions$outboundSchema: z.ZodType<
  Functions$Outbound,
  z.ZodTypeDef,
  Functions
> = z.object({
  memory: z.number().optional(),
  maxDuration: z.number().optional(),
  runtime: z.string().optional(),
  includeFiles: z.string().optional(),
  excludeFiles: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Functions$ {
  /** @deprecated use `Functions$inboundSchema` instead. */
  export const inboundSchema = Functions$inboundSchema;
  /** @deprecated use `Functions$outboundSchema` instead. */
  export const outboundSchema = Functions$outboundSchema;
  /** @deprecated use `Functions$Outbound` instead. */
  export type Outbound = Functions$Outbound;
}

/** @internal */
export const Routes3$inboundSchema: z.ZodType<Routes3, z.ZodTypeDef, unknown> =
  z.object({
    src: z.string(),
    continue: z.boolean(),
    middleware: z.number(),
  });

/** @internal */
export type Routes3$Outbound = {
  src: string;
  continue: boolean;
  middleware: number;
};

/** @internal */
export const Routes3$outboundSchema: z.ZodType<
  Routes3$Outbound,
  z.ZodTypeDef,
  Routes3
> = z.object({
  src: z.string(),
  continue: z.boolean(),
  middleware: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Routes3$ {
  /** @deprecated use `Routes3$inboundSchema` instead. */
  export const inboundSchema = Routes3$inboundSchema;
  /** @deprecated use `Routes3$outboundSchema` instead. */
  export const outboundSchema = Routes3$outboundSchema;
  /** @deprecated use `Routes3$Outbound` instead. */
  export type Outbound = Routes3$Outbound;
}

/** @internal */
export const RoutesHandle$inboundSchema: z.ZodNativeEnum<typeof RoutesHandle> =
  z.nativeEnum(RoutesHandle);

/** @internal */
export const RoutesHandle$outboundSchema: z.ZodNativeEnum<typeof RoutesHandle> =
  RoutesHandle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RoutesHandle$ {
  /** @deprecated use `RoutesHandle$inboundSchema` instead. */
  export const inboundSchema = RoutesHandle$inboundSchema;
  /** @deprecated use `RoutesHandle$outboundSchema` instead. */
  export const outboundSchema = RoutesHandle$outboundSchema;
}

/** @internal */
export const Routes2$inboundSchema: z.ZodType<Routes2, z.ZodTypeDef, unknown> =
  z.object({
    handle: RoutesHandle$inboundSchema,
    src: z.string().optional(),
    dest: z.string().optional(),
    status: z.number().optional(),
  });

/** @internal */
export type Routes2$Outbound = {
  handle: string;
  src?: string | undefined;
  dest?: string | undefined;
  status?: number | undefined;
};

/** @internal */
export const Routes2$outboundSchema: z.ZodType<
  Routes2$Outbound,
  z.ZodTypeDef,
  Routes2
> = z.object({
  handle: RoutesHandle$outboundSchema,
  src: z.string().optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Routes2$ {
  /** @deprecated use `Routes2$inboundSchema` instead. */
  export const inboundSchema = Routes2$inboundSchema;
  /** @deprecated use `Routes2$outboundSchema` instead. */
  export const outboundSchema = Routes2$outboundSchema;
  /** @deprecated use `Routes2$Outbound` instead. */
  export type Outbound = Routes2$Outbound;
}

/** @internal */
export const CreateDeploymentHasType$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentHasType
> = z.nativeEnum(CreateDeploymentHasType);

/** @internal */
export const CreateDeploymentHasType$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentHasType
> = CreateDeploymentHasType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentHasType$ {
  /** @deprecated use `CreateDeploymentHasType$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentHasType$inboundSchema;
  /** @deprecated use `CreateDeploymentHasType$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentHasType$outboundSchema;
}

/** @internal */
export const Has2$inboundSchema: z.ZodType<Has2, z.ZodTypeDef, unknown> = z
  .object({
    type: CreateDeploymentHasType$inboundSchema,
    key: z.string(),
    value: z.string().optional(),
  });

/** @internal */
export type Has2$Outbound = {
  type: string;
  key: string;
  value?: string | undefined;
};

/** @internal */
export const Has2$outboundSchema: z.ZodType<Has2$Outbound, z.ZodTypeDef, Has2> =
  z.object({
    type: CreateDeploymentHasType$outboundSchema,
    key: z.string(),
    value: z.string().optional(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Has2$ {
  /** @deprecated use `Has2$inboundSchema` instead. */
  export const inboundSchema = Has2$inboundSchema;
  /** @deprecated use `Has2$outboundSchema` instead. */
  export const outboundSchema = Has2$outboundSchema;
  /** @deprecated use `Has2$Outbound` instead. */
  export type Outbound = Has2$Outbound;
}

/** @internal */
export const HasType$inboundSchema: z.ZodNativeEnum<typeof HasType> = z
  .nativeEnum(HasType);

/** @internal */
export const HasType$outboundSchema: z.ZodNativeEnum<typeof HasType> =
  HasType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace HasType$ {
  /** @deprecated use `HasType$inboundSchema` instead. */
  export const inboundSchema = HasType$inboundSchema;
  /** @deprecated use `HasType$outboundSchema` instead. */
  export const outboundSchema = HasType$outboundSchema;
}

/** @internal */
export const Has1$inboundSchema: z.ZodType<Has1, z.ZodTypeDef, unknown> = z
  .object({
    type: HasType$inboundSchema,
    value: z.string(),
  });

/** @internal */
export type Has1$Outbound = {
  type: string;
  value: string;
};

/** @internal */
export const Has1$outboundSchema: z.ZodType<Has1$Outbound, z.ZodTypeDef, Has1> =
  z.object({
    type: HasType$outboundSchema,
    value: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Has1$ {
  /** @deprecated use `Has1$inboundSchema` instead. */
  export const inboundSchema = Has1$inboundSchema;
  /** @deprecated use `Has1$outboundSchema` instead. */
  export const outboundSchema = Has1$outboundSchema;
  /** @deprecated use `Has1$Outbound` instead. */
  export type Outbound = Has1$Outbound;
}

/** @internal */
export const RoutesHas$inboundSchema: z.ZodType<
  RoutesHas,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => Has1$inboundSchema),
  z.lazy(() => Has2$inboundSchema),
]);

/** @internal */
export type RoutesHas$Outbound = Has1$Outbound | Has2$Outbound;

/** @internal */
export const RoutesHas$outboundSchema: z.ZodType<
  RoutesHas$Outbound,
  z.ZodTypeDef,
  RoutesHas
> = z.union([
  z.lazy(() => Has1$outboundSchema),
  z.lazy(() => Has2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RoutesHas$ {
  /** @deprecated use `RoutesHas$inboundSchema` instead. */
  export const inboundSchema = RoutesHas$inboundSchema;
  /** @deprecated use `RoutesHas$outboundSchema` instead. */
  export const outboundSchema = RoutesHas$outboundSchema;
  /** @deprecated use `RoutesHas$Outbound` instead. */
  export type Outbound = RoutesHas$Outbound;
}

/** @internal */
export const CreateDeploymentMissingType$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentMissingType
> = z.nativeEnum(CreateDeploymentMissingType);

/** @internal */
export const CreateDeploymentMissingType$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentMissingType
> = CreateDeploymentMissingType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentMissingType$ {
  /** @deprecated use `CreateDeploymentMissingType$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentMissingType$inboundSchema;
  /** @deprecated use `CreateDeploymentMissingType$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentMissingType$outboundSchema;
}

/** @internal */
export const Missing2$inboundSchema: z.ZodType<
  Missing2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CreateDeploymentMissingType$inboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type Missing2$Outbound = {
  type: string;
  key: string;
  value?: string | undefined;
};

/** @internal */
export const Missing2$outboundSchema: z.ZodType<
  Missing2$Outbound,
  z.ZodTypeDef,
  Missing2
> = z.object({
  type: CreateDeploymentMissingType$outboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Missing2$ {
  /** @deprecated use `Missing2$inboundSchema` instead. */
  export const inboundSchema = Missing2$inboundSchema;
  /** @deprecated use `Missing2$outboundSchema` instead. */
  export const outboundSchema = Missing2$outboundSchema;
  /** @deprecated use `Missing2$Outbound` instead. */
  export type Outbound = Missing2$Outbound;
}

/** @internal */
export const MissingType$inboundSchema: z.ZodNativeEnum<typeof MissingType> = z
  .nativeEnum(MissingType);

/** @internal */
export const MissingType$outboundSchema: z.ZodNativeEnum<typeof MissingType> =
  MissingType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace MissingType$ {
  /** @deprecated use `MissingType$inboundSchema` instead. */
  export const inboundSchema = MissingType$inboundSchema;
  /** @deprecated use `MissingType$outboundSchema` instead. */
  export const outboundSchema = MissingType$outboundSchema;
}

/** @internal */
export const Missing1$inboundSchema: z.ZodType<
  Missing1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: MissingType$inboundSchema,
  value: z.string(),
});

/** @internal */
export type Missing1$Outbound = {
  type: string;
  value: string;
};

/** @internal */
export const Missing1$outboundSchema: z.ZodType<
  Missing1$Outbound,
  z.ZodTypeDef,
  Missing1
> = z.object({
  type: MissingType$outboundSchema,
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Missing1$ {
  /** @deprecated use `Missing1$inboundSchema` instead. */
  export const inboundSchema = Missing1$inboundSchema;
  /** @deprecated use `Missing1$outboundSchema` instead. */
  export const outboundSchema = Missing1$outboundSchema;
  /** @deprecated use `Missing1$Outbound` instead. */
  export type Outbound = Missing1$Outbound;
}

/** @internal */
export const RoutesMissing$inboundSchema: z.ZodType<
  RoutesMissing,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => Missing1$inboundSchema),
  z.lazy(() => Missing2$inboundSchema),
]);

/** @internal */
export type RoutesMissing$Outbound = Missing1$Outbound | Missing2$Outbound;

/** @internal */
export const RoutesMissing$outboundSchema: z.ZodType<
  RoutesMissing$Outbound,
  z.ZodTypeDef,
  RoutesMissing
> = z.union([
  z.lazy(() => Missing1$outboundSchema),
  z.lazy(() => Missing2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RoutesMissing$ {
  /** @deprecated use `RoutesMissing$inboundSchema` instead. */
  export const inboundSchema = RoutesMissing$inboundSchema;
  /** @deprecated use `RoutesMissing$outboundSchema` instead. */
  export const outboundSchema = RoutesMissing$outboundSchema;
  /** @deprecated use `RoutesMissing$Outbound` instead. */
  export type Outbound = RoutesMissing$Outbound;
}

/** @internal */
export const Locale$inboundSchema: z.ZodType<Locale, z.ZodTypeDef, unknown> = z
  .object({
    redirect: z.record(z.string()).optional(),
    cookie: z.string().optional(),
  });

/** @internal */
export type Locale$Outbound = {
  redirect?: { [k: string]: string } | undefined;
  cookie?: string | undefined;
};

/** @internal */
export const Locale$outboundSchema: z.ZodType<
  Locale$Outbound,
  z.ZodTypeDef,
  Locale
> = z.object({
  redirect: z.record(z.string()).optional(),
  cookie: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Locale$ {
  /** @deprecated use `Locale$inboundSchema` instead. */
  export const inboundSchema = Locale$inboundSchema;
  /** @deprecated use `Locale$outboundSchema` instead. */
  export const outboundSchema = Locale$outboundSchema;
  /** @deprecated use `Locale$Outbound` instead. */
  export type Outbound = Locale$Outbound;
}

/** @internal */
export const Routes1$inboundSchema: z.ZodType<Routes1, z.ZodTypeDef, unknown> =
  z.object({
    src: z.string(),
    dest: z.string().optional(),
    headers: z.record(z.string()).optional(),
    methods: z.array(z.string()).optional(),
    continue: z.boolean().optional(),
    override: z.boolean().optional(),
    caseSensitive: z.boolean().optional(),
    check: z.boolean().optional(),
    important: z.boolean().optional(),
    status: z.number().optional(),
    has: z.array(
      z.union([
        z.lazy(() => Has1$inboundSchema),
        z.lazy(() => Has2$inboundSchema),
      ]),
    ).optional(),
    missing: z.array(
      z.union([
        z.lazy(() => Missing1$inboundSchema),
        z.lazy(() => Missing2$inboundSchema),
      ]),
    ).optional(),
    locale: z.lazy(() => Locale$inboundSchema).optional(),
    middlewarePath: z.string().optional(),
    middlewareRawSrc: z.array(z.string()).optional(),
    middleware: z.number().optional(),
  });

/** @internal */
export type Routes1$Outbound = {
  src: string;
  dest?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  methods?: Array<string> | undefined;
  continue?: boolean | undefined;
  override?: boolean | undefined;
  caseSensitive?: boolean | undefined;
  check?: boolean | undefined;
  important?: boolean | undefined;
  status?: number | undefined;
  has?: Array<Has1$Outbound | Has2$Outbound> | undefined;
  missing?: Array<Missing1$Outbound | Missing2$Outbound> | undefined;
  locale?: Locale$Outbound | undefined;
  middlewarePath?: string | undefined;
  middlewareRawSrc?: Array<string> | undefined;
  middleware?: number | undefined;
};

/** @internal */
export const Routes1$outboundSchema: z.ZodType<
  Routes1$Outbound,
  z.ZodTypeDef,
  Routes1
> = z.object({
  src: z.string(),
  dest: z.string().optional(),
  headers: z.record(z.string()).optional(),
  methods: z.array(z.string()).optional(),
  continue: z.boolean().optional(),
  override: z.boolean().optional(),
  caseSensitive: z.boolean().optional(),
  check: z.boolean().optional(),
  important: z.boolean().optional(),
  status: z.number().optional(),
  has: z.array(
    z.union([
      z.lazy(() => Has1$outboundSchema),
      z.lazy(() => Has2$outboundSchema),
    ]),
  ).optional(),
  missing: z.array(
    z.union([
      z.lazy(() => Missing1$outboundSchema),
      z.lazy(() => Missing2$outboundSchema),
    ]),
  ).optional(),
  locale: z.lazy(() => Locale$outboundSchema).optional(),
  middlewarePath: z.string().optional(),
  middlewareRawSrc: z.array(z.string()).optional(),
  middleware: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Routes1$ {
  /** @deprecated use `Routes1$inboundSchema` instead. */
  export const inboundSchema = Routes1$inboundSchema;
  /** @deprecated use `Routes1$outboundSchema` instead. */
  export const outboundSchema = Routes1$outboundSchema;
  /** @deprecated use `Routes1$Outbound` instead. */
  export type Outbound = Routes1$Outbound;
}

/** @internal */
export const Routes$inboundSchema: z.ZodType<Routes, z.ZodTypeDef, unknown> = z
  .union([
    z.lazy(() => Routes3$inboundSchema),
    z.lazy(() => Routes2$inboundSchema),
    z.lazy(() => Routes1$inboundSchema),
  ]);

/** @internal */
export type Routes$Outbound =
  | Routes3$Outbound
  | Routes2$Outbound
  | Routes1$Outbound;

/** @internal */
export const Routes$outboundSchema: z.ZodType<
  Routes$Outbound,
  z.ZodTypeDef,
  Routes
> = z.union([
  z.lazy(() => Routes3$outboundSchema),
  z.lazy(() => Routes2$outboundSchema),
  z.lazy(() => Routes1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Routes$ {
  /** @deprecated use `Routes$inboundSchema` instead. */
  export const inboundSchema = Routes$inboundSchema;
  /** @deprecated use `Routes$outboundSchema` instead. */
  export const outboundSchema = Routes$outboundSchema;
  /** @deprecated use `Routes$Outbound` instead. */
  export type Outbound = Routes$Outbound;
}

/** @internal */
export const CreateDeploymentCrons$inboundSchema: z.ZodType<
  CreateDeploymentCrons,
  z.ZodTypeDef,
  unknown
> = z.object({
  schedule: z.string(),
  path: z.string(),
});

/** @internal */
export type CreateDeploymentCrons$Outbound = {
  schedule: string;
  path: string;
};

/** @internal */
export const CreateDeploymentCrons$outboundSchema: z.ZodType<
  CreateDeploymentCrons$Outbound,
  z.ZodTypeDef,
  CreateDeploymentCrons
> = z.object({
  schedule: z.string(),
  path: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentCrons$ {
  /** @deprecated use `CreateDeploymentCrons$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentCrons$inboundSchema;
  /** @deprecated use `CreateDeploymentCrons$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentCrons$outboundSchema;
  /** @deprecated use `CreateDeploymentCrons$Outbound` instead. */
  export type Outbound = CreateDeploymentCrons$Outbound;
}

/** @internal */
export const Plan$inboundSchema: z.ZodNativeEnum<typeof Plan> = z.nativeEnum(
  Plan,
);

/** @internal */
export const Plan$outboundSchema: z.ZodNativeEnum<typeof Plan> =
  Plan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Plan$ {
  /** @deprecated use `Plan$inboundSchema` instead. */
  export const inboundSchema = Plan$inboundSchema;
  /** @deprecated use `Plan$outboundSchema` instead. */
  export const outboundSchema = Plan$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitRepoDeploymentsType$inboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitRepoDeploymentsType> = z.nativeEnum(
    CreateDeploymentGitRepoDeploymentsType,
  );

/** @internal */
export const CreateDeploymentGitRepoDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof CreateDeploymentGitRepoDeploymentsType> =
    CreateDeploymentGitRepoDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitRepoDeploymentsType$ {
  /** @deprecated use `CreateDeploymentGitRepoDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    CreateDeploymentGitRepoDeploymentsType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitRepoDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CreateDeploymentGitRepoDeploymentsType$outboundSchema;
}

/** @internal */
export const CreateDeploymentGitRepoOwnerType$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentGitRepoOwnerType
> = z.nativeEnum(CreateDeploymentGitRepoOwnerType);

/** @internal */
export const CreateDeploymentGitRepoOwnerType$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentGitRepoOwnerType
> = CreateDeploymentGitRepoOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitRepoOwnerType$ {
  /** @deprecated use `CreateDeploymentGitRepoOwnerType$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitRepoOwnerType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitRepoOwnerType$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitRepoOwnerType$outboundSchema;
}

/** @internal */
export const GitRepo3$inboundSchema: z.ZodType<
  GitRepo3,
  z.ZodTypeDef,
  unknown
> = z.object({
  owner: z.string(),
  repoUuid: z.string(),
  slug: z.string(),
  type: CreateDeploymentGitRepoDeploymentsType$inboundSchema,
  workspaceUuid: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CreateDeploymentGitRepoOwnerType$inboundSchema,
});

/** @internal */
export type GitRepo3$Outbound = {
  owner: string;
  repoUuid: string;
  slug: string;
  type: string;
  workspaceUuid: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const GitRepo3$outboundSchema: z.ZodType<
  GitRepo3$Outbound,
  z.ZodTypeDef,
  GitRepo3
> = z.object({
  owner: z.string(),
  repoUuid: z.string(),
  slug: z.string(),
  type: CreateDeploymentGitRepoDeploymentsType$outboundSchema,
  workspaceUuid: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CreateDeploymentGitRepoOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepo3$ {
  /** @deprecated use `GitRepo3$inboundSchema` instead. */
  export const inboundSchema = GitRepo3$inboundSchema;
  /** @deprecated use `GitRepo3$outboundSchema` instead. */
  export const outboundSchema = GitRepo3$outboundSchema;
  /** @deprecated use `GitRepo3$Outbound` instead. */
  export type Outbound = GitRepo3$Outbound;
}

/** @internal */
export const CreateDeploymentGitRepoType$inboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentGitRepoType
> = z.nativeEnum(CreateDeploymentGitRepoType);

/** @internal */
export const CreateDeploymentGitRepoType$outboundSchema: z.ZodNativeEnum<
  typeof CreateDeploymentGitRepoType
> = CreateDeploymentGitRepoType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentGitRepoType$ {
  /** @deprecated use `CreateDeploymentGitRepoType$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentGitRepoType$inboundSchema;
  /** @deprecated use `CreateDeploymentGitRepoType$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentGitRepoType$outboundSchema;
}

/** @internal */
export const GitRepoOwnerType$inboundSchema: z.ZodNativeEnum<
  typeof GitRepoOwnerType
> = z.nativeEnum(GitRepoOwnerType);

/** @internal */
export const GitRepoOwnerType$outboundSchema: z.ZodNativeEnum<
  typeof GitRepoOwnerType
> = GitRepoOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepoOwnerType$ {
  /** @deprecated use `GitRepoOwnerType$inboundSchema` instead. */
  export const inboundSchema = GitRepoOwnerType$inboundSchema;
  /** @deprecated use `GitRepoOwnerType$outboundSchema` instead. */
  export const outboundSchema = GitRepoOwnerType$outboundSchema;
}

/** @internal */
export const GitRepo2$inboundSchema: z.ZodType<
  GitRepo2,
  z.ZodTypeDef,
  unknown
> = z.object({
  org: z.string(),
  repo: z.string(),
  repoId: z.number(),
  type: CreateDeploymentGitRepoType$inboundSchema,
  repoOwnerId: z.number(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GitRepoOwnerType$inboundSchema,
});

/** @internal */
export type GitRepo2$Outbound = {
  org: string;
  repo: string;
  repoId: number;
  type: string;
  repoOwnerId: number;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const GitRepo2$outboundSchema: z.ZodType<
  GitRepo2$Outbound,
  z.ZodTypeDef,
  GitRepo2
> = z.object({
  org: z.string(),
  repo: z.string(),
  repoId: z.number(),
  type: CreateDeploymentGitRepoType$outboundSchema,
  repoOwnerId: z.number(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: GitRepoOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepo2$ {
  /** @deprecated use `GitRepo2$inboundSchema` instead. */
  export const inboundSchema = GitRepo2$inboundSchema;
  /** @deprecated use `GitRepo2$outboundSchema` instead. */
  export const outboundSchema = GitRepo2$outboundSchema;
  /** @deprecated use `GitRepo2$Outbound` instead. */
  export type Outbound = GitRepo2$Outbound;
}

/** @internal */
export const GitRepoType$inboundSchema: z.ZodNativeEnum<typeof GitRepoType> = z
  .nativeEnum(GitRepoType);

/** @internal */
export const GitRepoType$outboundSchema: z.ZodNativeEnum<typeof GitRepoType> =
  GitRepoType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepoType$ {
  /** @deprecated use `GitRepoType$inboundSchema` instead. */
  export const inboundSchema = GitRepoType$inboundSchema;
  /** @deprecated use `GitRepoType$outboundSchema` instead. */
  export const outboundSchema = GitRepoType$outboundSchema;
}

/** @internal */
export const OwnerType$inboundSchema: z.ZodNativeEnum<typeof OwnerType> = z
  .nativeEnum(OwnerType);

/** @internal */
export const OwnerType$outboundSchema: z.ZodNativeEnum<typeof OwnerType> =
  OwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace OwnerType$ {
  /** @deprecated use `OwnerType$inboundSchema` instead. */
  export const inboundSchema = OwnerType$inboundSchema;
  /** @deprecated use `OwnerType$outboundSchema` instead. */
  export const outboundSchema = OwnerType$outboundSchema;
}

/** @internal */
export const GitRepo1$inboundSchema: z.ZodType<
  GitRepo1,
  z.ZodTypeDef,
  unknown
> = z.object({
  namespace: z.string(),
  projectId: z.number(),
  type: GitRepoType$inboundSchema,
  url: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: OwnerType$inboundSchema,
});

/** @internal */
export type GitRepo1$Outbound = {
  namespace: string;
  projectId: number;
  type: string;
  url: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const GitRepo1$outboundSchema: z.ZodType<
  GitRepo1$Outbound,
  z.ZodTypeDef,
  GitRepo1
> = z.object({
  namespace: z.string(),
  projectId: z.number(),
  type: GitRepoType$outboundSchema,
  url: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: OwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepo1$ {
  /** @deprecated use `GitRepo1$inboundSchema` instead. */
  export const inboundSchema = GitRepo1$inboundSchema;
  /** @deprecated use `GitRepo1$outboundSchema` instead. */
  export const outboundSchema = GitRepo1$outboundSchema;
  /** @deprecated use `GitRepo1$Outbound` instead. */
  export type Outbound = GitRepo1$Outbound;
}

/** @internal */
export const GitRepo$inboundSchema: z.ZodType<GitRepo, z.ZodTypeDef, unknown> =
  z.union([
    z.lazy(() => GitRepo1$inboundSchema),
    z.lazy(() => GitRepo2$inboundSchema),
    z.lazy(() => GitRepo3$inboundSchema),
  ]);

/** @internal */
export type GitRepo$Outbound =
  | GitRepo1$Outbound
  | GitRepo2$Outbound
  | GitRepo3$Outbound;

/** @internal */
export const GitRepo$outboundSchema: z.ZodType<
  GitRepo$Outbound,
  z.ZodTypeDef,
  GitRepo
> = z.union([
  z.lazy(() => GitRepo1$outboundSchema),
  z.lazy(() => GitRepo2$outboundSchema),
  z.lazy(() => GitRepo3$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitRepo$ {
  /** @deprecated use `GitRepo$inboundSchema` instead. */
  export const inboundSchema = GitRepo$inboundSchema;
  /** @deprecated use `GitRepo$outboundSchema` instead. */
  export const outboundSchema = GitRepo$outboundSchema;
  /** @deprecated use `GitRepo$Outbound` instead. */
  export type Outbound = GitRepo$Outbound;
}

/** @internal */
export const Flags2$inboundSchema: z.ZodType<Flags2, z.ZodTypeDef, unknown> = z
  .object({});

/** @internal */
export type Flags2$Outbound = {};

/** @internal */
export const Flags2$outboundSchema: z.ZodType<
  Flags2$Outbound,
  z.ZodTypeDef,
  Flags2
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Flags2$ {
  /** @deprecated use `Flags2$inboundSchema` instead. */
  export const inboundSchema = Flags2$inboundSchema;
  /** @deprecated use `Flags2$outboundSchema` instead. */
  export const outboundSchema = Flags2$outboundSchema;
  /** @deprecated use `Flags2$Outbound` instead. */
  export type Outbound = Flags2$Outbound;
}

/** @internal */
export const Options$inboundSchema: z.ZodType<Options, z.ZodTypeDef, unknown> =
  z.object({
    value: z.nullable(FlagJSONValue$inboundSchema),
    label: z.string().optional(),
  });

/** @internal */
export type Options$Outbound = {
  value: FlagJSONValue$Outbound | null;
  label?: string | undefined;
};

/** @internal */
export const Options$outboundSchema: z.ZodType<
  Options$Outbound,
  z.ZodTypeDef,
  Options
> = z.object({
  value: z.nullable(FlagJSONValue$outboundSchema),
  label: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Options$ {
  /** @deprecated use `Options$inboundSchema` instead. */
  export const inboundSchema = Options$inboundSchema;
  /** @deprecated use `Options$outboundSchema` instead. */
  export const outboundSchema = Options$outboundSchema;
  /** @deprecated use `Options$Outbound` instead. */
  export type Outbound = Options$Outbound;
}

/** @internal */
export const FlagsDefinitions$inboundSchema: z.ZodType<
  FlagsDefinitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  options: z.array(z.lazy(() => Options$inboundSchema)).optional(),
  url: z.string().optional(),
  description: z.string().optional(),
});

/** @internal */
export type FlagsDefinitions$Outbound = {
  options?: Array<Options$Outbound> | undefined;
  url?: string | undefined;
  description?: string | undefined;
};

/** @internal */
export const FlagsDefinitions$outboundSchema: z.ZodType<
  FlagsDefinitions$Outbound,
  z.ZodTypeDef,
  FlagsDefinitions
> = z.object({
  options: z.array(z.lazy(() => Options$outboundSchema)).optional(),
  url: z.string().optional(),
  description: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FlagsDefinitions$ {
  /** @deprecated use `FlagsDefinitions$inboundSchema` instead. */
  export const inboundSchema = FlagsDefinitions$inboundSchema;
  /** @deprecated use `FlagsDefinitions$outboundSchema` instead. */
  export const outboundSchema = FlagsDefinitions$outboundSchema;
  /** @deprecated use `FlagsDefinitions$Outbound` instead. */
  export type Outbound = FlagsDefinitions$Outbound;
}

/** @internal */
export const Flags1$inboundSchema: z.ZodType<Flags1, z.ZodTypeDef, unknown> = z
  .object({
    definitions: z.record(z.lazy(() => FlagsDefinitions$inboundSchema)),
  });

/** @internal */
export type Flags1$Outbound = {
  definitions: { [k: string]: FlagsDefinitions$Outbound };
};

/** @internal */
export const Flags1$outboundSchema: z.ZodType<
  Flags1$Outbound,
  z.ZodTypeDef,
  Flags1
> = z.object({
  definitions: z.record(z.lazy(() => FlagsDefinitions$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Flags1$ {
  /** @deprecated use `Flags1$inboundSchema` instead. */
  export const inboundSchema = Flags1$inboundSchema;
  /** @deprecated use `Flags1$outboundSchema` instead. */
  export const outboundSchema = Flags1$outboundSchema;
  /** @deprecated use `Flags1$Outbound` instead. */
  export type Outbound = Flags1$Outbound;
}

/** @internal */
export const Flags$inboundSchema: z.ZodType<Flags, z.ZodTypeDef, unknown> = z
  .union([
    z.lazy(() => Flags1$inboundSchema),
    z.array(z.lazy(() => Flags2$inboundSchema)),
  ]);

/** @internal */
export type Flags$Outbound = Flags1$Outbound | Array<Flags2$Outbound>;

/** @internal */
export const Flags$outboundSchema: z.ZodType<
  Flags$Outbound,
  z.ZodTypeDef,
  Flags
> = z.union([
  z.lazy(() => Flags1$outboundSchema),
  z.array(z.lazy(() => Flags2$outboundSchema)),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Flags$ {
  /** @deprecated use `Flags$inboundSchema` instead. */
  export const inboundSchema = Flags$inboundSchema;
  /** @deprecated use `Flags$outboundSchema` instead. */
  export const outboundSchema = Flags$outboundSchema;
  /** @deprecated use `Flags$Outbound` instead. */
  export type Outbound = Flags$Outbound;
}

/** @internal */
export const CreateDeploymentResponseBody$inboundSchema: z.ZodType<
  CreateDeploymentResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  aliasAssignedAt: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  alwaysRefuseToBuild: z.boolean().optional(),
  build: z.lazy(() => Build$inboundSchema),
  buildArtifactUrls: z.array(z.string()).optional(),
  builds: z.array(z.lazy(() => Builds$inboundSchema)).optional(),
  env: z.array(z.string()),
  inspectorUrl: z.nullable(z.string()),
  isInConcurrentBuildsQueue: z.boolean(),
  isInSystemBuildsQueue: z.boolean(),
  projectSettings: z.lazy(() => CreateDeploymentProjectSettings$inboundSchema),
  readyStateReason: z.string().optional(),
  integrations: z.lazy(() => Integrations$inboundSchema).optional(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => Creator$inboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => Lambdas$inboundSchema)).optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: CreateDeploymentStatus$inboundSchema,
  team: z.lazy(() => Team$inboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => CustomEnvironment1$inboundSchema),
    z.lazy(() => CustomEnvironment2$inboundSchema),
  ]).optional(),
  type: CreateDeploymentType$inboundSchema,
  createdAt: z.number(),
  name: z.string(),
  deletedAt: z.nullable(z.number()).optional(),
  id: z.string(),
  version: z.number(),
  autoAssignCustomDomains: z.boolean().optional(),
  gitSource: z.union([
    z.lazy(() => CreateDeploymentGitSource6$inboundSchema),
    z.lazy(() => CreateDeploymentGitSource8$inboundSchema),
    z.lazy(() => GitSource1$inboundSchema),
    z.lazy(() => GitSource3$inboundSchema),
    z.lazy(() => GitSource2$inboundSchema),
    z.lazy(() => GitSource4$inboundSchema),
    z.lazy(() => GitSource5$inboundSchema),
    z.lazy(() => CreateDeploymentGitSource7$inboundSchema),
    z.lazy(() => CreateDeploymentGitSource9$inboundSchema),
  ]).optional(),
  meta: z.record(z.string()),
  project: z.lazy(() => Project$inboundSchema).optional(),
  readyState: ReadyState$inboundSchema,
  source: CreateDeploymentSource$inboundSchema.optional(),
  target: z.nullable(CreateDeploymentTarget$inboundSchema).optional(),
  passiveRegions: z.array(z.string()).optional(),
  regions: z.array(z.string()),
  errorMessage: z.nullable(z.string()).optional(),
  aliasWarning: z.nullable(z.lazy(() => AliasWarning$inboundSchema)).optional(),
  aliasError: z.nullable(z.lazy(() => AliasError$inboundSchema)).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: ChecksState$inboundSchema.optional(),
  checksConclusion: ChecksConclusion$inboundSchema.optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorStep: z.string().optional(),
  readySubstate: ReadySubstate$inboundSchema.optional(),
  softDeletedByRetention: z.boolean().optional(),
  undeletedAt: z.number().optional(),
  url: z.string(),
  oidcTokenClaims: z.lazy(() => OidcTokenClaims$inboundSchema).optional(),
  projectId: z.string(),
  ownerId: z.string(),
  monorepoManager: z.nullable(z.string()).optional(),
  functions: z.nullable(z.record(z.lazy(() => Functions$inboundSchema)))
    .optional(),
  routes: z.nullable(
    z.array(z.union([
      z.lazy(() => Routes3$inboundSchema),
      z.lazy(() =>
        Routes2$inboundSchema
      ),
      z.lazy(() => Routes1$inboundSchema),
    ])),
  ),
  crons: z.array(z.lazy(() => CreateDeploymentCrons$inboundSchema)).optional(),
  plan: Plan$inboundSchema,
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdIn: z.string(),
  passiveConnectConfigurationId: z.string().optional(),
  gitRepo: z.nullable(
    z.union([
      z.lazy(() => GitRepo1$inboundSchema),
      z.lazy(() => GitRepo2$inboundSchema),
      z.lazy(() => GitRepo3$inboundSchema),
    ]),
  ).optional(),
  flags: z.union([
    z.lazy(() => Flags1$inboundSchema),
    z.array(z.lazy(() => Flags2$inboundSchema)),
  ]).optional(),
});

/** @internal */
export type CreateDeploymentResponseBody$Outbound = {
  aliasAssignedAt?: number | boolean | null | undefined;
  alwaysRefuseToBuild?: boolean | undefined;
  build: Build$Outbound;
  buildArtifactUrls?: Array<string> | undefined;
  builds?: Array<Builds$Outbound> | undefined;
  env: Array<string>;
  inspectorUrl: string | null;
  isInConcurrentBuildsQueue: boolean;
  isInSystemBuildsQueue: boolean;
  projectSettings: CreateDeploymentProjectSettings$Outbound;
  readyStateReason?: string | undefined;
  integrations?: Integrations$Outbound | undefined;
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: Creator$Outbound;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<Lambdas$Outbound> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: string;
  team?: Team$Outbound | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | CustomEnvironment1$Outbound
    | CustomEnvironment2$Outbound
    | undefined;
  type: string;
  createdAt: number;
  name: string;
  deletedAt?: number | null | undefined;
  id: string;
  version: number;
  autoAssignCustomDomains?: boolean | undefined;
  gitSource?:
    | CreateDeploymentGitSource6$Outbound
    | CreateDeploymentGitSource8$Outbound
    | GitSource1$Outbound
    | GitSource3$Outbound
    | GitSource2$Outbound
    | GitSource4$Outbound
    | GitSource5$Outbound
    | CreateDeploymentGitSource7$Outbound
    | CreateDeploymentGitSource9$Outbound
    | undefined;
  meta: { [k: string]: string };
  project?: Project$Outbound | undefined;
  readyState: string;
  source?: string | undefined;
  target?: string | null | undefined;
  passiveRegions?: Array<string> | undefined;
  regions: Array<string>;
  errorMessage?: string | null | undefined;
  aliasWarning?: AliasWarning$Outbound | null | undefined;
  aliasError?: AliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: string | undefined;
  checksConclusion?: string | undefined;
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorStep?: string | undefined;
  readySubstate?: string | undefined;
  softDeletedByRetention?: boolean | undefined;
  undeletedAt?: number | undefined;
  url: string;
  oidcTokenClaims?: OidcTokenClaims$Outbound | undefined;
  projectId: string;
  ownerId: string;
  monorepoManager?: string | null | undefined;
  functions?: { [k: string]: Functions$Outbound } | null | undefined;
  routes: Array<Routes3$Outbound | Routes2$Outbound | Routes1$Outbound> | null;
  crons?: Array<CreateDeploymentCrons$Outbound> | undefined;
  plan: string;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdIn: string;
  passiveConnectConfigurationId?: string | undefined;
  gitRepo?:
    | GitRepo1$Outbound
    | GitRepo2$Outbound
    | GitRepo3$Outbound
    | null
    | undefined;
  flags?: Flags1$Outbound | Array<Flags2$Outbound> | undefined;
};

/** @internal */
export const CreateDeploymentResponseBody$outboundSchema: z.ZodType<
  CreateDeploymentResponseBody$Outbound,
  z.ZodTypeDef,
  CreateDeploymentResponseBody
> = z.object({
  aliasAssignedAt: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  alwaysRefuseToBuild: z.boolean().optional(),
  build: z.lazy(() => Build$outboundSchema),
  buildArtifactUrls: z.array(z.string()).optional(),
  builds: z.array(z.lazy(() => Builds$outboundSchema)).optional(),
  env: z.array(z.string()),
  inspectorUrl: z.nullable(z.string()),
  isInConcurrentBuildsQueue: z.boolean(),
  isInSystemBuildsQueue: z.boolean(),
  projectSettings: z.lazy(() => CreateDeploymentProjectSettings$outboundSchema),
  readyStateReason: z.string().optional(),
  integrations: z.lazy(() => Integrations$outboundSchema).optional(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => Creator$outboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => Lambdas$outboundSchema)).optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: CreateDeploymentStatus$outboundSchema,
  team: z.lazy(() => Team$outboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => CustomEnvironment1$outboundSchema),
    z.lazy(() => CustomEnvironment2$outboundSchema),
  ]).optional(),
  type: CreateDeploymentType$outboundSchema,
  createdAt: z.number(),
  name: z.string(),
  deletedAt: z.nullable(z.number()).optional(),
  id: z.string(),
  version: z.number(),
  autoAssignCustomDomains: z.boolean().optional(),
  gitSource: z.union([
    z.lazy(() => CreateDeploymentGitSource6$outboundSchema),
    z.lazy(() => CreateDeploymentGitSource8$outboundSchema),
    z.lazy(() => GitSource1$outboundSchema),
    z.lazy(() => GitSource3$outboundSchema),
    z.lazy(() => GitSource2$outboundSchema),
    z.lazy(() => GitSource4$outboundSchema),
    z.lazy(() => GitSource5$outboundSchema),
    z.lazy(() => CreateDeploymentGitSource7$outboundSchema),
    z.lazy(() => CreateDeploymentGitSource9$outboundSchema),
  ]).optional(),
  meta: z.record(z.string()),
  project: z.lazy(() => Project$outboundSchema).optional(),
  readyState: ReadyState$outboundSchema,
  source: CreateDeploymentSource$outboundSchema.optional(),
  target: z.nullable(CreateDeploymentTarget$outboundSchema).optional(),
  passiveRegions: z.array(z.string()).optional(),
  regions: z.array(z.string()),
  errorMessage: z.nullable(z.string()).optional(),
  aliasWarning: z.nullable(z.lazy(() => AliasWarning$outboundSchema))
    .optional(),
  aliasError: z.nullable(z.lazy(() => AliasError$outboundSchema)).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: ChecksState$outboundSchema.optional(),
  checksConclusion: ChecksConclusion$outboundSchema.optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorStep: z.string().optional(),
  readySubstate: ReadySubstate$outboundSchema.optional(),
  softDeletedByRetention: z.boolean().optional(),
  undeletedAt: z.number().optional(),
  url: z.string(),
  oidcTokenClaims: z.lazy(() => OidcTokenClaims$outboundSchema).optional(),
  projectId: z.string(),
  ownerId: z.string(),
  monorepoManager: z.nullable(z.string()).optional(),
  functions: z.nullable(z.record(z.lazy(() => Functions$outboundSchema)))
    .optional(),
  routes: z.nullable(
    z.array(z.union([
      z.lazy(() => Routes3$outboundSchema),
      z.lazy(() =>
        Routes2$outboundSchema
      ),
      z.lazy(() => Routes1$outboundSchema),
    ])),
  ),
  crons: z.array(z.lazy(() => CreateDeploymentCrons$outboundSchema)).optional(),
  plan: Plan$outboundSchema,
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdIn: z.string(),
  passiveConnectConfigurationId: z.string().optional(),
  gitRepo: z.nullable(
    z.union([
      z.lazy(() => GitRepo1$outboundSchema),
      z.lazy(() => GitRepo2$outboundSchema),
      z.lazy(() => GitRepo3$outboundSchema),
    ]),
  ).optional(),
  flags: z.union([
    z.lazy(() => Flags1$outboundSchema),
    z.array(z.lazy(() => Flags2$outboundSchema)),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateDeploymentResponseBody$ {
  /** @deprecated use `CreateDeploymentResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateDeploymentResponseBody$inboundSchema;
  /** @deprecated use `CreateDeploymentResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateDeploymentResponseBody$outboundSchema;
  /** @deprecated use `CreateDeploymentResponseBody$Outbound` instead. */
  export type Outbound = CreateDeploymentResponseBody$Outbound;
}
