/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

export type CreateCheckRequestBody = {
  /**
   * The name of the check being created
   */
  name: string;
  /**
   * Path of the page that is being checked
   */
  path?: string | undefined;
  /**
   * Whether the check should block a deployment from succeeding
   */
  blocking: boolean;
  /**
   * URL to display for further details
   */
  detailsUrl?: string | undefined;
  /**
   * An identifier that can be used as an external reference
   */
  externalId?: string | undefined;
  /**
   * Whether a user should be able to request for the check to be rerun if it fails
   */
  rerequestable?: boolean | undefined;
};

export type CreateCheckRequest = {
  /**
   * The deployment to create the check for.
   */
  deploymentId: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: CreateCheckRequestBody | undefined;
};

export const CreateCheckStatus = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type CreateCheckStatus = ClosedEnum<typeof CreateCheckStatus>;

export const CreateCheckConclusion = {
  Canceled: "canceled",
  Failed: "failed",
  Neutral: "neutral",
  Succeeded: "succeeded",
  Skipped: "skipped",
  Stale: "stale",
} as const;
export type CreateCheckConclusion = ClosedEnum<typeof CreateCheckConclusion>;

export const CreateCheckSource = {
  WebVitals: "web-vitals",
} as const;
export type CreateCheckSource = ClosedEnum<typeof CreateCheckSource>;

export type CreateCheckFCP = {
  value: number | null;
  previousValue?: number | undefined;
  source: CreateCheckSource;
};

export const CreateCheckChecksSource = {
  WebVitals: "web-vitals",
} as const;
export type CreateCheckChecksSource = ClosedEnum<
  typeof CreateCheckChecksSource
>;

export type CreateCheckLCP = {
  value: number | null;
  previousValue?: number | undefined;
  source: CreateCheckChecksSource;
};

export const CreateCheckChecksResponseSource = {
  WebVitals: "web-vitals",
} as const;
export type CreateCheckChecksResponseSource = ClosedEnum<
  typeof CreateCheckChecksResponseSource
>;

export type CreateCheckCLS = {
  value: number | null;
  previousValue?: number | undefined;
  source: CreateCheckChecksResponseSource;
};

export const CreateCheckChecksResponse200Source = {
  WebVitals: "web-vitals",
} as const;
export type CreateCheckChecksResponse200Source = ClosedEnum<
  typeof CreateCheckChecksResponse200Source
>;

export type CreateCheckTBT = {
  value: number | null;
  previousValue?: number | undefined;
  source: CreateCheckChecksResponse200Source;
};

export const CreateCheckChecksResponse200ApplicationJSONSource = {
  WebVitals: "web-vitals",
} as const;
export type CreateCheckChecksResponse200ApplicationJSONSource = ClosedEnum<
  typeof CreateCheckChecksResponse200ApplicationJSONSource
>;

export type CreateCheckVirtualExperienceScore = {
  value: number | null;
  previousValue?: number | undefined;
  source: CreateCheckChecksResponse200ApplicationJSONSource;
};

export type CreateCheckMetrics = {
  fcp: CreateCheckFCP;
  lcp: CreateCheckLCP;
  cls: CreateCheckCLS;
  tbt: CreateCheckTBT;
  virtualExperienceScore?: CreateCheckVirtualExperienceScore | undefined;
};

export type CreateCheckOutput = {
  metrics?: CreateCheckMetrics | undefined;
};

export type CreateCheckResponseBody = {
  id: string;
  name: string;
  path?: string | undefined;
  status: CreateCheckStatus;
  conclusion?: CreateCheckConclusion | undefined;
  blocking: boolean;
  output?: CreateCheckOutput | undefined;
  detailsUrl?: string | undefined;
  integrationId: string;
  deploymentId: string;
  externalId?: string | undefined;
  createdAt: number;
  updatedAt: number;
  startedAt?: number | undefined;
  completedAt?: number | undefined;
  rerequestable?: boolean | undefined;
};

/** @internal */
export const CreateCheckRequestBody$inboundSchema: z.ZodType<
  CreateCheckRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  path: z.string().optional(),
  blocking: z.boolean(),
  detailsUrl: z.string().optional(),
  externalId: z.string().optional(),
  rerequestable: z.boolean().optional(),
});

/** @internal */
export type CreateCheckRequestBody$Outbound = {
  name: string;
  path?: string | undefined;
  blocking: boolean;
  detailsUrl?: string | undefined;
  externalId?: string | undefined;
  rerequestable?: boolean | undefined;
};

/** @internal */
export const CreateCheckRequestBody$outboundSchema: z.ZodType<
  CreateCheckRequestBody$Outbound,
  z.ZodTypeDef,
  CreateCheckRequestBody
> = z.object({
  name: z.string(),
  path: z.string().optional(),
  blocking: z.boolean(),
  detailsUrl: z.string().optional(),
  externalId: z.string().optional(),
  rerequestable: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckRequestBody$ {
  /** @deprecated use `CreateCheckRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateCheckRequestBody$inboundSchema;
  /** @deprecated use `CreateCheckRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateCheckRequestBody$outboundSchema;
  /** @deprecated use `CreateCheckRequestBody$Outbound` instead. */
  export type Outbound = CreateCheckRequestBody$Outbound;
}

/** @internal */
export const CreateCheckRequest$inboundSchema: z.ZodType<
  CreateCheckRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  deploymentId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => CreateCheckRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateCheckRequest$Outbound = {
  deploymentId: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: CreateCheckRequestBody$Outbound | undefined;
};

/** @internal */
export const CreateCheckRequest$outboundSchema: z.ZodType<
  CreateCheckRequest$Outbound,
  z.ZodTypeDef,
  CreateCheckRequest
> = z.object({
  deploymentId: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => CreateCheckRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckRequest$ {
  /** @deprecated use `CreateCheckRequest$inboundSchema` instead. */
  export const inboundSchema = CreateCheckRequest$inboundSchema;
  /** @deprecated use `CreateCheckRequest$outboundSchema` instead. */
  export const outboundSchema = CreateCheckRequest$outboundSchema;
  /** @deprecated use `CreateCheckRequest$Outbound` instead. */
  export type Outbound = CreateCheckRequest$Outbound;
}

/** @internal */
export const CreateCheckStatus$inboundSchema: z.ZodNativeEnum<
  typeof CreateCheckStatus
> = z.nativeEnum(CreateCheckStatus);

/** @internal */
export const CreateCheckStatus$outboundSchema: z.ZodNativeEnum<
  typeof CreateCheckStatus
> = CreateCheckStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckStatus$ {
  /** @deprecated use `CreateCheckStatus$inboundSchema` instead. */
  export const inboundSchema = CreateCheckStatus$inboundSchema;
  /** @deprecated use `CreateCheckStatus$outboundSchema` instead. */
  export const outboundSchema = CreateCheckStatus$outboundSchema;
}

/** @internal */
export const CreateCheckConclusion$inboundSchema: z.ZodNativeEnum<
  typeof CreateCheckConclusion
> = z.nativeEnum(CreateCheckConclusion);

/** @internal */
export const CreateCheckConclusion$outboundSchema: z.ZodNativeEnum<
  typeof CreateCheckConclusion
> = CreateCheckConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckConclusion$ {
  /** @deprecated use `CreateCheckConclusion$inboundSchema` instead. */
  export const inboundSchema = CreateCheckConclusion$inboundSchema;
  /** @deprecated use `CreateCheckConclusion$outboundSchema` instead. */
  export const outboundSchema = CreateCheckConclusion$outboundSchema;
}

/** @internal */
export const CreateCheckSource$inboundSchema: z.ZodNativeEnum<
  typeof CreateCheckSource
> = z.nativeEnum(CreateCheckSource);

/** @internal */
export const CreateCheckSource$outboundSchema: z.ZodNativeEnum<
  typeof CreateCheckSource
> = CreateCheckSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckSource$ {
  /** @deprecated use `CreateCheckSource$inboundSchema` instead. */
  export const inboundSchema = CreateCheckSource$inboundSchema;
  /** @deprecated use `CreateCheckSource$outboundSchema` instead. */
  export const outboundSchema = CreateCheckSource$outboundSchema;
}

/** @internal */
export const CreateCheckFCP$inboundSchema: z.ZodType<
  CreateCheckFCP,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckSource$inboundSchema,
});

/** @internal */
export type CreateCheckFCP$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const CreateCheckFCP$outboundSchema: z.ZodType<
  CreateCheckFCP$Outbound,
  z.ZodTypeDef,
  CreateCheckFCP
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckFCP$ {
  /** @deprecated use `CreateCheckFCP$inboundSchema` instead. */
  export const inboundSchema = CreateCheckFCP$inboundSchema;
  /** @deprecated use `CreateCheckFCP$outboundSchema` instead. */
  export const outboundSchema = CreateCheckFCP$outboundSchema;
  /** @deprecated use `CreateCheckFCP$Outbound` instead. */
  export type Outbound = CreateCheckFCP$Outbound;
}

/** @internal */
export const CreateCheckChecksSource$inboundSchema: z.ZodNativeEnum<
  typeof CreateCheckChecksSource
> = z.nativeEnum(CreateCheckChecksSource);

/** @internal */
export const CreateCheckChecksSource$outboundSchema: z.ZodNativeEnum<
  typeof CreateCheckChecksSource
> = CreateCheckChecksSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckChecksSource$ {
  /** @deprecated use `CreateCheckChecksSource$inboundSchema` instead. */
  export const inboundSchema = CreateCheckChecksSource$inboundSchema;
  /** @deprecated use `CreateCheckChecksSource$outboundSchema` instead. */
  export const outboundSchema = CreateCheckChecksSource$outboundSchema;
}

/** @internal */
export const CreateCheckLCP$inboundSchema: z.ZodType<
  CreateCheckLCP,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksSource$inboundSchema,
});

/** @internal */
export type CreateCheckLCP$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const CreateCheckLCP$outboundSchema: z.ZodType<
  CreateCheckLCP$Outbound,
  z.ZodTypeDef,
  CreateCheckLCP
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckLCP$ {
  /** @deprecated use `CreateCheckLCP$inboundSchema` instead. */
  export const inboundSchema = CreateCheckLCP$inboundSchema;
  /** @deprecated use `CreateCheckLCP$outboundSchema` instead. */
  export const outboundSchema = CreateCheckLCP$outboundSchema;
  /** @deprecated use `CreateCheckLCP$Outbound` instead. */
  export type Outbound = CreateCheckLCP$Outbound;
}

/** @internal */
export const CreateCheckChecksResponseSource$inboundSchema: z.ZodNativeEnum<
  typeof CreateCheckChecksResponseSource
> = z.nativeEnum(CreateCheckChecksResponseSource);

/** @internal */
export const CreateCheckChecksResponseSource$outboundSchema: z.ZodNativeEnum<
  typeof CreateCheckChecksResponseSource
> = CreateCheckChecksResponseSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckChecksResponseSource$ {
  /** @deprecated use `CreateCheckChecksResponseSource$inboundSchema` instead. */
  export const inboundSchema = CreateCheckChecksResponseSource$inboundSchema;
  /** @deprecated use `CreateCheckChecksResponseSource$outboundSchema` instead. */
  export const outboundSchema = CreateCheckChecksResponseSource$outboundSchema;
}

/** @internal */
export const CreateCheckCLS$inboundSchema: z.ZodType<
  CreateCheckCLS,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksResponseSource$inboundSchema,
});

/** @internal */
export type CreateCheckCLS$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const CreateCheckCLS$outboundSchema: z.ZodType<
  CreateCheckCLS$Outbound,
  z.ZodTypeDef,
  CreateCheckCLS
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksResponseSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckCLS$ {
  /** @deprecated use `CreateCheckCLS$inboundSchema` instead. */
  export const inboundSchema = CreateCheckCLS$inboundSchema;
  /** @deprecated use `CreateCheckCLS$outboundSchema` instead. */
  export const outboundSchema = CreateCheckCLS$outboundSchema;
  /** @deprecated use `CreateCheckCLS$Outbound` instead. */
  export type Outbound = CreateCheckCLS$Outbound;
}

/** @internal */
export const CreateCheckChecksResponse200Source$inboundSchema: z.ZodNativeEnum<
  typeof CreateCheckChecksResponse200Source
> = z.nativeEnum(CreateCheckChecksResponse200Source);

/** @internal */
export const CreateCheckChecksResponse200Source$outboundSchema: z.ZodNativeEnum<
  typeof CreateCheckChecksResponse200Source
> = CreateCheckChecksResponse200Source$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckChecksResponse200Source$ {
  /** @deprecated use `CreateCheckChecksResponse200Source$inboundSchema` instead. */
  export const inboundSchema = CreateCheckChecksResponse200Source$inboundSchema;
  /** @deprecated use `CreateCheckChecksResponse200Source$outboundSchema` instead. */
  export const outboundSchema =
    CreateCheckChecksResponse200Source$outboundSchema;
}

/** @internal */
export const CreateCheckTBT$inboundSchema: z.ZodType<
  CreateCheckTBT,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksResponse200Source$inboundSchema,
});

/** @internal */
export type CreateCheckTBT$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const CreateCheckTBT$outboundSchema: z.ZodType<
  CreateCheckTBT$Outbound,
  z.ZodTypeDef,
  CreateCheckTBT
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksResponse200Source$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckTBT$ {
  /** @deprecated use `CreateCheckTBT$inboundSchema` instead. */
  export const inboundSchema = CreateCheckTBT$inboundSchema;
  /** @deprecated use `CreateCheckTBT$outboundSchema` instead. */
  export const outboundSchema = CreateCheckTBT$outboundSchema;
  /** @deprecated use `CreateCheckTBT$Outbound` instead. */
  export type Outbound = CreateCheckTBT$Outbound;
}

/** @internal */
export const CreateCheckChecksResponse200ApplicationJSONSource$inboundSchema:
  z.ZodNativeEnum<typeof CreateCheckChecksResponse200ApplicationJSONSource> = z
    .nativeEnum(CreateCheckChecksResponse200ApplicationJSONSource);

/** @internal */
export const CreateCheckChecksResponse200ApplicationJSONSource$outboundSchema:
  z.ZodNativeEnum<typeof CreateCheckChecksResponse200ApplicationJSONSource> =
    CreateCheckChecksResponse200ApplicationJSONSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckChecksResponse200ApplicationJSONSource$ {
  /** @deprecated use `CreateCheckChecksResponse200ApplicationJSONSource$inboundSchema` instead. */
  export const inboundSchema =
    CreateCheckChecksResponse200ApplicationJSONSource$inboundSchema;
  /** @deprecated use `CreateCheckChecksResponse200ApplicationJSONSource$outboundSchema` instead. */
  export const outboundSchema =
    CreateCheckChecksResponse200ApplicationJSONSource$outboundSchema;
}

/** @internal */
export const CreateCheckVirtualExperienceScore$inboundSchema: z.ZodType<
  CreateCheckVirtualExperienceScore,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksResponse200ApplicationJSONSource$inboundSchema,
});

/** @internal */
export type CreateCheckVirtualExperienceScore$Outbound = {
  value: number | null;
  previousValue?: number | undefined;
  source: string;
};

/** @internal */
export const CreateCheckVirtualExperienceScore$outboundSchema: z.ZodType<
  CreateCheckVirtualExperienceScore$Outbound,
  z.ZodTypeDef,
  CreateCheckVirtualExperienceScore
> = z.object({
  value: z.nullable(z.number()),
  previousValue: z.number().optional(),
  source: CreateCheckChecksResponse200ApplicationJSONSource$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckVirtualExperienceScore$ {
  /** @deprecated use `CreateCheckVirtualExperienceScore$inboundSchema` instead. */
  export const inboundSchema = CreateCheckVirtualExperienceScore$inboundSchema;
  /** @deprecated use `CreateCheckVirtualExperienceScore$outboundSchema` instead. */
  export const outboundSchema =
    CreateCheckVirtualExperienceScore$outboundSchema;
  /** @deprecated use `CreateCheckVirtualExperienceScore$Outbound` instead. */
  export type Outbound = CreateCheckVirtualExperienceScore$Outbound;
}

/** @internal */
export const CreateCheckMetrics$inboundSchema: z.ZodType<
  CreateCheckMetrics,
  z.ZodTypeDef,
  unknown
> = z.object({
  FCP: z.lazy(() => CreateCheckFCP$inboundSchema),
  LCP: z.lazy(() => CreateCheckLCP$inboundSchema),
  CLS: z.lazy(() => CreateCheckCLS$inboundSchema),
  TBT: z.lazy(() => CreateCheckTBT$inboundSchema),
  virtualExperienceScore: z.lazy(() =>
    CreateCheckVirtualExperienceScore$inboundSchema
  ).optional(),
}).transform((v) => {
  return remap$(v, {
    "FCP": "fcp",
    "LCP": "lcp",
    "CLS": "cls",
    "TBT": "tbt",
  });
});

/** @internal */
export type CreateCheckMetrics$Outbound = {
  FCP: CreateCheckFCP$Outbound;
  LCP: CreateCheckLCP$Outbound;
  CLS: CreateCheckCLS$Outbound;
  TBT: CreateCheckTBT$Outbound;
  virtualExperienceScore?:
    | CreateCheckVirtualExperienceScore$Outbound
    | undefined;
};

/** @internal */
export const CreateCheckMetrics$outboundSchema: z.ZodType<
  CreateCheckMetrics$Outbound,
  z.ZodTypeDef,
  CreateCheckMetrics
> = z.object({
  fcp: z.lazy(() => CreateCheckFCP$outboundSchema),
  lcp: z.lazy(() => CreateCheckLCP$outboundSchema),
  cls: z.lazy(() => CreateCheckCLS$outboundSchema),
  tbt: z.lazy(() => CreateCheckTBT$outboundSchema),
  virtualExperienceScore: z.lazy(() =>
    CreateCheckVirtualExperienceScore$outboundSchema
  ).optional(),
}).transform((v) => {
  return remap$(v, {
    fcp: "FCP",
    lcp: "LCP",
    cls: "CLS",
    tbt: "TBT",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckMetrics$ {
  /** @deprecated use `CreateCheckMetrics$inboundSchema` instead. */
  export const inboundSchema = CreateCheckMetrics$inboundSchema;
  /** @deprecated use `CreateCheckMetrics$outboundSchema` instead. */
  export const outboundSchema = CreateCheckMetrics$outboundSchema;
  /** @deprecated use `CreateCheckMetrics$Outbound` instead. */
  export type Outbound = CreateCheckMetrics$Outbound;
}

/** @internal */
export const CreateCheckOutput$inboundSchema: z.ZodType<
  CreateCheckOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  metrics: z.lazy(() => CreateCheckMetrics$inboundSchema).optional(),
});

/** @internal */
export type CreateCheckOutput$Outbound = {
  metrics?: CreateCheckMetrics$Outbound | undefined;
};

/** @internal */
export const CreateCheckOutput$outboundSchema: z.ZodType<
  CreateCheckOutput$Outbound,
  z.ZodTypeDef,
  CreateCheckOutput
> = z.object({
  metrics: z.lazy(() => CreateCheckMetrics$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckOutput$ {
  /** @deprecated use `CreateCheckOutput$inboundSchema` instead. */
  export const inboundSchema = CreateCheckOutput$inboundSchema;
  /** @deprecated use `CreateCheckOutput$outboundSchema` instead. */
  export const outboundSchema = CreateCheckOutput$outboundSchema;
  /** @deprecated use `CreateCheckOutput$Outbound` instead. */
  export type Outbound = CreateCheckOutput$Outbound;
}

/** @internal */
export const CreateCheckResponseBody$inboundSchema: z.ZodType<
  CreateCheckResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  path: z.string().optional(),
  status: CreateCheckStatus$inboundSchema,
  conclusion: CreateCheckConclusion$inboundSchema.optional(),
  blocking: z.boolean(),
  output: z.lazy(() => CreateCheckOutput$inboundSchema).optional(),
  detailsUrl: z.string().optional(),
  integrationId: z.string(),
  deploymentId: z.string(),
  externalId: z.string().optional(),
  createdAt: z.number(),
  updatedAt: z.number(),
  startedAt: z.number().optional(),
  completedAt: z.number().optional(),
  rerequestable: z.boolean().optional(),
});

/** @internal */
export type CreateCheckResponseBody$Outbound = {
  id: string;
  name: string;
  path?: string | undefined;
  status: string;
  conclusion?: string | undefined;
  blocking: boolean;
  output?: CreateCheckOutput$Outbound | undefined;
  detailsUrl?: string | undefined;
  integrationId: string;
  deploymentId: string;
  externalId?: string | undefined;
  createdAt: number;
  updatedAt: number;
  startedAt?: number | undefined;
  completedAt?: number | undefined;
  rerequestable?: boolean | undefined;
};

/** @internal */
export const CreateCheckResponseBody$outboundSchema: z.ZodType<
  CreateCheckResponseBody$Outbound,
  z.ZodTypeDef,
  CreateCheckResponseBody
> = z.object({
  id: z.string(),
  name: z.string(),
  path: z.string().optional(),
  status: CreateCheckStatus$outboundSchema,
  conclusion: CreateCheckConclusion$outboundSchema.optional(),
  blocking: z.boolean(),
  output: z.lazy(() => CreateCheckOutput$outboundSchema).optional(),
  detailsUrl: z.string().optional(),
  integrationId: z.string(),
  deploymentId: z.string(),
  externalId: z.string().optional(),
  createdAt: z.number(),
  updatedAt: z.number(),
  startedAt: z.number().optional(),
  completedAt: z.number().optional(),
  rerequestable: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateCheckResponseBody$ {
  /** @deprecated use `CreateCheckResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateCheckResponseBody$inboundSchema;
  /** @deprecated use `CreateCheckResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateCheckResponseBody$outboundSchema;
  /** @deprecated use `CreateCheckResponseBody$Outbound` instead. */
  export type Outbound = CreateCheckResponseBody$Outbound;
}
