/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import {
  AuthToken,
  AuthToken$inboundSchema,
  AuthToken$Outbound,
  AuthToken$outboundSchema,
} from "../components/authtoken.js";

export type CreateAuthTokenRequestBody = {
  name: string;
  expiresAt?: number | undefined;
};

export type CreateAuthTokenRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: CreateAuthTokenRequestBody | undefined;
};

/**
 * Successful response.
 */
export type CreateAuthTokenResponseBody = {
  /**
   * Authentication token metadata.
   */
  token: AuthToken;
  /**
   * The authentication token's actual value. This token is only provided in this response, and can never be retrieved again in the future. Be sure to save it somewhere safe!
   */
  bearerToken: string;
};

/** @internal */
export const CreateAuthTokenRequestBody$inboundSchema: z.ZodType<
  CreateAuthTokenRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  expiresAt: z.number().optional(),
});

/** @internal */
export type CreateAuthTokenRequestBody$Outbound = {
  name: string;
  expiresAt?: number | undefined;
};

/** @internal */
export const CreateAuthTokenRequestBody$outboundSchema: z.ZodType<
  CreateAuthTokenRequestBody$Outbound,
  z.ZodTypeDef,
  CreateAuthTokenRequestBody
> = z.object({
  name: z.string(),
  expiresAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAuthTokenRequestBody$ {
  /** @deprecated use `CreateAuthTokenRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateAuthTokenRequestBody$inboundSchema;
  /** @deprecated use `CreateAuthTokenRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateAuthTokenRequestBody$outboundSchema;
  /** @deprecated use `CreateAuthTokenRequestBody$Outbound` instead. */
  export type Outbound = CreateAuthTokenRequestBody$Outbound;
}

/** @internal */
export const CreateAuthTokenRequest$inboundSchema: z.ZodType<
  CreateAuthTokenRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => CreateAuthTokenRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateAuthTokenRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: CreateAuthTokenRequestBody$Outbound | undefined;
};

/** @internal */
export const CreateAuthTokenRequest$outboundSchema: z.ZodType<
  CreateAuthTokenRequest$Outbound,
  z.ZodTypeDef,
  CreateAuthTokenRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => CreateAuthTokenRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAuthTokenRequest$ {
  /** @deprecated use `CreateAuthTokenRequest$inboundSchema` instead. */
  export const inboundSchema = CreateAuthTokenRequest$inboundSchema;
  /** @deprecated use `CreateAuthTokenRequest$outboundSchema` instead. */
  export const outboundSchema = CreateAuthTokenRequest$outboundSchema;
  /** @deprecated use `CreateAuthTokenRequest$Outbound` instead. */
  export type Outbound = CreateAuthTokenRequest$Outbound;
}

/** @internal */
export const CreateAuthTokenResponseBody$inboundSchema: z.ZodType<
  CreateAuthTokenResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  token: AuthToken$inboundSchema,
  bearerToken: z.string(),
});

/** @internal */
export type CreateAuthTokenResponseBody$Outbound = {
  token: AuthToken$Outbound;
  bearerToken: string;
};

/** @internal */
export const CreateAuthTokenResponseBody$outboundSchema: z.ZodType<
  CreateAuthTokenResponseBody$Outbound,
  z.ZodTypeDef,
  CreateAuthTokenResponseBody
> = z.object({
  token: AuthToken$outboundSchema,
  bearerToken: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAuthTokenResponseBody$ {
  /** @deprecated use `CreateAuthTokenResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateAuthTokenResponseBody$inboundSchema;
  /** @deprecated use `CreateAuthTokenResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateAuthTokenResponseBody$outboundSchema;
  /** @deprecated use `CreateAuthTokenResponseBody$Outbound` instead. */
  export type Outbound = CreateAuthTokenResponseBody$Outbound;
}
