/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The project role that will be added to this Access Group. \"null\" will remove this project level role.
 */
export const CreateAccessGroupRole = {
  Admin: "ADMIN",
  ProjectViewer: "PROJECT_VIEWER",
  ProjectDeveloper: "PROJECT_DEVELOPER",
} as const;
/**
 * The project role that will be added to this Access Group. \"null\" will remove this project level role.
 */
export type CreateAccessGroupRole = ClosedEnum<typeof CreateAccessGroupRole>;

export type CreateAccessGroupProjects = {
  /**
   * The ID of the project.
   */
  projectId: string;
  /**
   * The project role that will be added to this Access Group. \"null\" will remove this project level role.
   */
  role: CreateAccessGroupRole | null;
};

export type CreateAccessGroupRequestBody = {
  /**
   * The name of the access group
   */
  name: string;
  projects?: Array<CreateAccessGroupProjects> | undefined;
  /**
   * List of members to add to the access group.
   */
  membersToAdd?: Array<string> | undefined;
};

export type CreateAccessGroupRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: CreateAccessGroupRequestBody | undefined;
};

export type CreateAccessGroupResponseBody = {
  membersCount: number;
  projectsCount: number;
  /**
   * The name of this access group.
   */
  name: string;
  /**
   * Timestamp in milliseconds when the access group was created.
   */
  createdAt: string;
  /**
   * ID of the team that this access group belongs to.
   */
  teamId: string;
  /**
   * Timestamp in milliseconds when the access group was last updated.
   */
  updatedAt: string;
  /**
   * ID of the access group.
   */
  accessGroupId: string;
};

/** @internal */
export const CreateAccessGroupRole$inboundSchema: z.ZodNativeEnum<
  typeof CreateAccessGroupRole
> = z.nativeEnum(CreateAccessGroupRole);

/** @internal */
export const CreateAccessGroupRole$outboundSchema: z.ZodNativeEnum<
  typeof CreateAccessGroupRole
> = CreateAccessGroupRole$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAccessGroupRole$ {
  /** @deprecated use `CreateAccessGroupRole$inboundSchema` instead. */
  export const inboundSchema = CreateAccessGroupRole$inboundSchema;
  /** @deprecated use `CreateAccessGroupRole$outboundSchema` instead. */
  export const outboundSchema = CreateAccessGroupRole$outboundSchema;
}

/** @internal */
export const CreateAccessGroupProjects$inboundSchema: z.ZodType<
  CreateAccessGroupProjects,
  z.ZodTypeDef,
  unknown
> = z.object({
  projectId: z.string(),
  role: z.nullable(CreateAccessGroupRole$inboundSchema),
});

/** @internal */
export type CreateAccessGroupProjects$Outbound = {
  projectId: string;
  role: string | null;
};

/** @internal */
export const CreateAccessGroupProjects$outboundSchema: z.ZodType<
  CreateAccessGroupProjects$Outbound,
  z.ZodTypeDef,
  CreateAccessGroupProjects
> = z.object({
  projectId: z.string(),
  role: z.nullable(CreateAccessGroupRole$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAccessGroupProjects$ {
  /** @deprecated use `CreateAccessGroupProjects$inboundSchema` instead. */
  export const inboundSchema = CreateAccessGroupProjects$inboundSchema;
  /** @deprecated use `CreateAccessGroupProjects$outboundSchema` instead. */
  export const outboundSchema = CreateAccessGroupProjects$outboundSchema;
  /** @deprecated use `CreateAccessGroupProjects$Outbound` instead. */
  export type Outbound = CreateAccessGroupProjects$Outbound;
}

/** @internal */
export const CreateAccessGroupRequestBody$inboundSchema: z.ZodType<
  CreateAccessGroupRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  projects: z.array(z.lazy(() => CreateAccessGroupProjects$inboundSchema))
    .optional(),
  membersToAdd: z.array(z.string()).optional(),
});

/** @internal */
export type CreateAccessGroupRequestBody$Outbound = {
  name: string;
  projects?: Array<CreateAccessGroupProjects$Outbound> | undefined;
  membersToAdd?: Array<string> | undefined;
};

/** @internal */
export const CreateAccessGroupRequestBody$outboundSchema: z.ZodType<
  CreateAccessGroupRequestBody$Outbound,
  z.ZodTypeDef,
  CreateAccessGroupRequestBody
> = z.object({
  name: z.string(),
  projects: z.array(z.lazy(() => CreateAccessGroupProjects$outboundSchema))
    .optional(),
  membersToAdd: z.array(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAccessGroupRequestBody$ {
  /** @deprecated use `CreateAccessGroupRequestBody$inboundSchema` instead. */
  export const inboundSchema = CreateAccessGroupRequestBody$inboundSchema;
  /** @deprecated use `CreateAccessGroupRequestBody$outboundSchema` instead. */
  export const outboundSchema = CreateAccessGroupRequestBody$outboundSchema;
  /** @deprecated use `CreateAccessGroupRequestBody$Outbound` instead. */
  export type Outbound = CreateAccessGroupRequestBody$Outbound;
}

/** @internal */
export const CreateAccessGroupRequest$inboundSchema: z.ZodType<
  CreateAccessGroupRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => CreateAccessGroupRequestBody$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type CreateAccessGroupRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: CreateAccessGroupRequestBody$Outbound | undefined;
};

/** @internal */
export const CreateAccessGroupRequest$outboundSchema: z.ZodType<
  CreateAccessGroupRequest$Outbound,
  z.ZodTypeDef,
  CreateAccessGroupRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => CreateAccessGroupRequestBody$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAccessGroupRequest$ {
  /** @deprecated use `CreateAccessGroupRequest$inboundSchema` instead. */
  export const inboundSchema = CreateAccessGroupRequest$inboundSchema;
  /** @deprecated use `CreateAccessGroupRequest$outboundSchema` instead. */
  export const outboundSchema = CreateAccessGroupRequest$outboundSchema;
  /** @deprecated use `CreateAccessGroupRequest$Outbound` instead. */
  export type Outbound = CreateAccessGroupRequest$Outbound;
}

/** @internal */
export const CreateAccessGroupResponseBody$inboundSchema: z.ZodType<
  CreateAccessGroupResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  membersCount: z.number(),
  projectsCount: z.number(),
  name: z.string(),
  createdAt: z.string(),
  teamId: z.string(),
  updatedAt: z.string(),
  accessGroupId: z.string(),
});

/** @internal */
export type CreateAccessGroupResponseBody$Outbound = {
  membersCount: number;
  projectsCount: number;
  name: string;
  createdAt: string;
  teamId: string;
  updatedAt: string;
  accessGroupId: string;
};

/** @internal */
export const CreateAccessGroupResponseBody$outboundSchema: z.ZodType<
  CreateAccessGroupResponseBody$Outbound,
  z.ZodTypeDef,
  CreateAccessGroupResponseBody
> = z.object({
  membersCount: z.number(),
  projectsCount: z.number(),
  name: z.string(),
  createdAt: z.string(),
  teamId: z.string(),
  updatedAt: z.string(),
  accessGroupId: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CreateAccessGroupResponseBody$ {
  /** @deprecated use `CreateAccessGroupResponseBody$inboundSchema` instead. */
  export const inboundSchema = CreateAccessGroupResponseBody$inboundSchema;
  /** @deprecated use `CreateAccessGroupResponseBody$outboundSchema` instead. */
  export const outboundSchema = CreateAccessGroupResponseBody$outboundSchema;
  /** @deprecated use `CreateAccessGroupResponseBody$Outbound` instead. */
  export type Outbound = CreateAccessGroupResponseBody$Outbound;
}
