/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";
import {
  FlagJSONValue,
  FlagJSONValue$inboundSchema,
  FlagJSONValue$Outbound,
  FlagJSONValue$outboundSchema,
} from "../components/flagjsonvalue.js";

export type CancelDeploymentRequest = {
  /**
   * The unique identifier of the deployment.
   */
  id: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
};

export type CancelDeploymentAliasAssignedAt = number | boolean;

export type CancelDeploymentBuild = {
  env: Array<string>;
};

export type CancelDeploymentBuilds = {};

export const CancelDeploymentFramework = {
  Blitzjs: "blitzjs",
  Nextjs: "nextjs",
  Gatsby: "gatsby",
  Remix: "remix",
  Astro: "astro",
  Hexo: "hexo",
  Eleventy: "eleventy",
  Docusaurus2: "docusaurus-2",
  Docusaurus: "docusaurus",
  Preact: "preact",
  Solidstart1: "solidstart-1",
  Solidstart: "solidstart",
  Dojo: "dojo",
  Ember: "ember",
  Vue: "vue",
  Scully: "scully",
  IonicAngular: "ionic-angular",
  Angular: "angular",
  Polymer: "polymer",
  Svelte: "svelte",
  Sveltekit: "sveltekit",
  Sveltekit1: "sveltekit-1",
  IonicReact: "ionic-react",
  CreateReactApp: "create-react-app",
  Gridsome: "gridsome",
  Umijs: "umijs",
  Sapper: "sapper",
  Saber: "saber",
  Stencil: "stencil",
  Nuxtjs: "nuxtjs",
  Redwoodjs: "redwoodjs",
  Hugo: "hugo",
  Jekyll: "jekyll",
  Brunch: "brunch",
  Middleman: "middleman",
  Zola: "zola",
  Hydrogen: "hydrogen",
  Vite: "vite",
  Vitepress: "vitepress",
  Vuepress: "vuepress",
  Parcel: "parcel",
  Fasthtml: "fasthtml",
  SanityV3: "sanity-v3",
  Sanity: "sanity",
  Storybook: "storybook",
} as const;
export type CancelDeploymentFramework = ClosedEnum<
  typeof CancelDeploymentFramework
>;

export type CancelDeploymentSpeedInsights = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

export type CancelDeploymentWebAnalytics = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

export type CancelDeploymentProjectSettings = {
  buildCommand?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: CancelDeploymentFramework | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  installCommand?: string | null | undefined;
  outputDirectory?: string | null | undefined;
  speedInsights?: CancelDeploymentSpeedInsights | undefined;
  webAnalytics?: CancelDeploymentWebAnalytics | undefined;
};

export const CancelDeploymentDeploymentsStatus = {
  Pending: "pending",
  Ready: "ready",
  Error: "error",
  Skipped: "skipped",
  Timeout: "timeout",
} as const;
export type CancelDeploymentDeploymentsStatus = ClosedEnum<
  typeof CancelDeploymentDeploymentsStatus
>;

export type CancelDeploymentIntegrations = {
  status: CancelDeploymentDeploymentsStatus;
  startedAt: number;
  completedAt?: number | undefined;
  skippedAt?: number | undefined;
  skippedBy?: string | undefined;
};

export type CancelDeploymentCreator = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

export const CancelDeploymentDeploymentsReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Ready: "READY",
} as const;
export type CancelDeploymentDeploymentsReadyState = ClosedEnum<
  typeof CancelDeploymentDeploymentsReadyState
>;

export type CancelDeploymentOutput = {
  path: string;
  functionName: string;
};

/**
 * A partial representation of a Build used by the deployment endpoint.
 */
export type CancelDeploymentLambdas = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: CancelDeploymentDeploymentsReadyState | undefined;
  readyStateAt?: number | undefined;
  output: Array<CancelDeploymentOutput>;
};

export const CancelDeploymentStatus = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type CancelDeploymentStatus = ClosedEnum<typeof CancelDeploymentStatus>;

export type CancelDeploymentTeam = {
  id: string;
  name: string;
  avatar?: string | undefined;
  slug: string;
};

export type CancelDeploymentCustomEnvironment2 = {
  id: string;
};

export type CancelDeploymentCustomEnvironment1 = {};

export type CancelDeploymentCustomEnvironment =
  | CancelDeploymentCustomEnvironment1
  | CancelDeploymentCustomEnvironment2;

export type CancelDeploymentAliasError = {
  code: string;
  message: string;
};

export type CancelDeploymentAliasWarning = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

export const CancelDeploymentChecksState = {
  Registered: "registered",
  Running: "running",
  Completed: "completed",
} as const;
export type CancelDeploymentChecksState = ClosedEnum<
  typeof CancelDeploymentChecksState
>;

export const CancelDeploymentChecksConclusion = {
  Skipped: "skipped",
  Succeeded: "succeeded",
  Failed: "failed",
  Canceled: "canceled",
} as const;
export type CancelDeploymentChecksConclusion = ClosedEnum<
  typeof CancelDeploymentChecksConclusion
>;

export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type =
  {
    Bitbucket: "bitbucket",
  } as const;
export type CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type =
  ClosedEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type
  >;

export type GitSource9 = {
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type =
  {
    Gitlab: "gitlab",
  } as const;
export type CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type =
  ClosedEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type
  >;

export type GitSource8 = {
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type;
  ref: string;
  sha: string;
  projectId: number;
};

export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type =
  {
    Github: "github",
  } as const;
export type CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type =
  ClosedEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type
  >;

export type GitSource7 = {
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType =
  {
    Custom: "custom",
  } as const;
export type CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType =
  ClosedEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  >;

export type GitSource6 = {
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType;
  ref: string;
  sha: string;
  gitUrl: string;
};

export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType =
  {
    Bitbucket: "bitbucket",
  } as const;
export type CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType =
  ClosedEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  >;

export type CancelDeploymentGitSource5 = {
  type: CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CancelDeploymentGitSourceDeploymentsResponse200Type = {
  Bitbucket: "bitbucket",
} as const;
export type CancelDeploymentGitSourceDeploymentsResponse200Type = ClosedEnum<
  typeof CancelDeploymentGitSourceDeploymentsResponse200Type
>;

export type CancelDeploymentGitSource4 = {
  type: CancelDeploymentGitSourceDeploymentsResponse200Type;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CancelDeploymentGitSourceDeploymentsResponseType = {
  Gitlab: "gitlab",
} as const;
export type CancelDeploymentGitSourceDeploymentsResponseType = ClosedEnum<
  typeof CancelDeploymentGitSourceDeploymentsResponseType
>;

export type CancelDeploymentGitSourceProjectId = string | number;

export type CancelDeploymentGitSource3 = {
  type: CancelDeploymentGitSourceDeploymentsResponseType;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CancelDeploymentGitSourceDeploymentsType = {
  Github: "github",
} as const;
export type CancelDeploymentGitSourceDeploymentsType = ClosedEnum<
  typeof CancelDeploymentGitSourceDeploymentsType
>;

export type CancelDeploymentGitSource2 = {
  type: CancelDeploymentGitSourceDeploymentsType;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export const CancelDeploymentGitSourceType = {
  Github: "github",
} as const;
export type CancelDeploymentGitSourceType = ClosedEnum<
  typeof CancelDeploymentGitSourceType
>;

export type CancelDeploymentGitSourceRepoId = string | number;

export type CancelDeploymentGitSource1 = {
  type: CancelDeploymentGitSourceType;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

export type CancelDeploymentGitSource =
  | GitSource6
  | GitSource8
  | CancelDeploymentGitSource1
  | CancelDeploymentGitSource3
  | CancelDeploymentGitSource2
  | CancelDeploymentGitSource4
  | CancelDeploymentGitSource5
  | GitSource7
  | GitSource9;

export type CancelDeploymentProject = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

export const CancelDeploymentReadyState = {
  Building: "BUILDING",
  Error: "ERROR",
  Initializing: "INITIALIZING",
  Queued: "QUEUED",
  Ready: "READY",
  Canceled: "CANCELED",
} as const;
export type CancelDeploymentReadyState = ClosedEnum<
  typeof CancelDeploymentReadyState
>;

/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export const CancelDeploymentReadySubstate = {
  Staged: "STAGED",
  Promoted: "PROMOTED",
} as const;
/**
 * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
 */
export type CancelDeploymentReadySubstate = ClosedEnum<
  typeof CancelDeploymentReadySubstate
>;

export const CancelDeploymentSource = {
  ApiTriggerGitDeploy: "api-trigger-git-deploy",
  Cli: "cli",
  CloneRepo: "clone/repo",
  Git: "git",
  Import: "import",
  ImportRepo: "import/repo",
  Redeploy: "redeploy",
} as const;
export type CancelDeploymentSource = ClosedEnum<typeof CancelDeploymentSource>;

export const CancelDeploymentTarget = {
  Production: "production",
  Staging: "staging",
} as const;
export type CancelDeploymentTarget = ClosedEnum<typeof CancelDeploymentTarget>;

export const CancelDeploymentType = {
  Lambdas: "LAMBDAS",
} as const;
export type CancelDeploymentType = ClosedEnum<typeof CancelDeploymentType>;

export type CancelDeploymentOidcTokenClaims = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  ownerId: string;
  project: string;
  projectId: string;
  environment: string;
};

export type CancelDeploymentCrons = {
  schedule: string;
  path: string;
};

export type CancelDeploymentFunctions = {
  memory?: number | undefined;
  maxDuration?: number | undefined;
  runtime?: string | undefined;
  includeFiles?: string | undefined;
  excludeFiles?: string | undefined;
};

export const CancelDeploymentPlan = {
  Pro: "pro",
  Enterprise: "enterprise",
  Hobby: "hobby",
} as const;
export type CancelDeploymentPlan = ClosedEnum<typeof CancelDeploymentPlan>;

export type CancelDeploymentRoutes3 = {
  src: string;
  continue: boolean;
  middleware: number;
};

export const CancelDeploymentRoutesHandle = {
  Error: "error",
  Filesystem: "filesystem",
  Hit: "hit",
  Miss: "miss",
  Rewrite: "rewrite",
  Resource: "resource",
} as const;
export type CancelDeploymentRoutesHandle = ClosedEnum<
  typeof CancelDeploymentRoutesHandle
>;

export type CancelDeploymentRoutes2 = {
  handle: CancelDeploymentRoutesHandle;
  src?: string | undefined;
  dest?: string | undefined;
  status?: number | undefined;
};

export const CancelDeploymentHasDeploymentsType = {
  Header: "header",
  Cookie: "cookie",
  Query: "query",
} as const;
export type CancelDeploymentHasDeploymentsType = ClosedEnum<
  typeof CancelDeploymentHasDeploymentsType
>;

export type CancelDeploymentHas2 = {
  type: CancelDeploymentHasDeploymentsType;
  key: string;
  value?: string | undefined;
};

export const CancelDeploymentHasType = {
  Host: "host",
} as const;
export type CancelDeploymentHasType = ClosedEnum<
  typeof CancelDeploymentHasType
>;

export type CancelDeploymentHas1 = {
  type: CancelDeploymentHasType;
  value: string;
};

export type CancelDeploymentRoutesHas =
  | CancelDeploymentHas1
  | CancelDeploymentHas2;

export const CancelDeploymentMissingDeploymentsType = {
  Header: "header",
  Cookie: "cookie",
  Query: "query",
} as const;
export type CancelDeploymentMissingDeploymentsType = ClosedEnum<
  typeof CancelDeploymentMissingDeploymentsType
>;

export type CancelDeploymentMissing2 = {
  type: CancelDeploymentMissingDeploymentsType;
  key: string;
  value?: string | undefined;
};

export const CancelDeploymentMissingType = {
  Host: "host",
} as const;
export type CancelDeploymentMissingType = ClosedEnum<
  typeof CancelDeploymentMissingType
>;

export type CancelDeploymentMissing1 = {
  type: CancelDeploymentMissingType;
  value: string;
};

export type CancelDeploymentRoutesMissing =
  | CancelDeploymentMissing1
  | CancelDeploymentMissing2;

export type RoutesLocale = {
  redirect?: { [k: string]: string } | undefined;
  cookie?: string | undefined;
};

export type CancelDeploymentRoutes1 = {
  src: string;
  dest?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  methods?: Array<string> | undefined;
  continue?: boolean | undefined;
  override?: boolean | undefined;
  caseSensitive?: boolean | undefined;
  check?: boolean | undefined;
  important?: boolean | undefined;
  status?: number | undefined;
  has?: Array<CancelDeploymentHas1 | CancelDeploymentHas2> | undefined;
  missing?:
    | Array<CancelDeploymentMissing1 | CancelDeploymentMissing2>
    | undefined;
  locale?: RoutesLocale | undefined;
  /**
   * A middleware key within the `output` key under the build result. Overrides a `middleware` definition.
   */
  middlewarePath?: string | undefined;
  /**
   * The original middleware matchers.
   */
  middlewareRawSrc?: Array<string> | undefined;
  /**
   * A middleware index in the `middleware` key under the build result
   */
  middleware?: number | undefined;
};

export type CancelDeploymentRoutes =
  | CancelDeploymentRoutes3
  | CancelDeploymentRoutes2
  | CancelDeploymentRoutes1;

export const CancelDeploymentGitRepoDeploymentsResponseType = {
  Bitbucket: "bitbucket",
} as const;
export type CancelDeploymentGitRepoDeploymentsResponseType = ClosedEnum<
  typeof CancelDeploymentGitRepoDeploymentsResponseType
>;

export const CancelDeploymentGitRepoDeploymentsResponseOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type CancelDeploymentGitRepoDeploymentsResponseOwnerType = ClosedEnum<
  typeof CancelDeploymentGitRepoDeploymentsResponseOwnerType
>;

export type CancelDeploymentGitRepo3 = {
  owner: string;
  repoUuid: string;
  slug: string;
  type: CancelDeploymentGitRepoDeploymentsResponseType;
  workspaceUuid: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: CancelDeploymentGitRepoDeploymentsResponseOwnerType;
};

export const CancelDeploymentGitRepoDeploymentsType = {
  Github: "github",
} as const;
export type CancelDeploymentGitRepoDeploymentsType = ClosedEnum<
  typeof CancelDeploymentGitRepoDeploymentsType
>;

export const CancelDeploymentGitRepoDeploymentsOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type CancelDeploymentGitRepoDeploymentsOwnerType = ClosedEnum<
  typeof CancelDeploymentGitRepoDeploymentsOwnerType
>;

export type CancelDeploymentGitRepo2 = {
  org: string;
  repo: string;
  repoId: number;
  type: CancelDeploymentGitRepoDeploymentsType;
  repoOwnerId: number;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: CancelDeploymentGitRepoDeploymentsOwnerType;
};

export const CancelDeploymentGitRepoType = {
  Gitlab: "gitlab",
} as const;
export type CancelDeploymentGitRepoType = ClosedEnum<
  typeof CancelDeploymentGitRepoType
>;

export const CancelDeploymentGitRepoOwnerType = {
  Team: "team",
  User: "user",
} as const;
export type CancelDeploymentGitRepoOwnerType = ClosedEnum<
  typeof CancelDeploymentGitRepoOwnerType
>;

export type CancelDeploymentGitRepo1 = {
  namespace: string;
  projectId: number;
  type: CancelDeploymentGitRepoType;
  url: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: CancelDeploymentGitRepoOwnerType;
};

export type CancelDeploymentGitRepo =
  | CancelDeploymentGitRepo1
  | CancelDeploymentGitRepo2
  | CancelDeploymentGitRepo3;

/**
 * Flags defined in the Build Output API, used by this deployment. Primarily used by the Toolbar to know about the used flags.
 */
export type CancelDeploymentFlags2 = {};

export type FlagsOptions = {
  value: FlagJSONValue | null;
  label?: string | undefined;
};

export type CancelDeploymentFlagsDefinitions = {
  options?: Array<FlagsOptions> | undefined;
  url?: string | undefined;
  description?: string | undefined;
};

/**
 * Flags defined in the Build Output API, used by this deployment. Primarily used by the Toolbar to know about the used flags.
 */
export type CancelDeploymentFlags1 = {
  definitions: { [k: string]: CancelDeploymentFlagsDefinitions };
};

export type CancelDeploymentFlags =
  | CancelDeploymentFlags1
  | Array<CancelDeploymentFlags2>;

/**
 * The private deployment representation of a Deployment.
 */
export type CancelDeploymentResponseBody = {
  aliasAssignedAt?: number | boolean | null | undefined;
  alwaysRefuseToBuild?: boolean | undefined;
  build: CancelDeploymentBuild;
  buildArtifactUrls?: Array<string> | undefined;
  builds?: Array<CancelDeploymentBuilds> | undefined;
  env: Array<string>;
  inspectorUrl: string | null;
  isInConcurrentBuildsQueue: boolean;
  isInSystemBuildsQueue: boolean;
  projectSettings: CancelDeploymentProjectSettings;
  readyStateReason?: string | undefined;
  integrations?: CancelDeploymentIntegrations | undefined;
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: CancelDeploymentCreator;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<CancelDeploymentLambdas> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: CancelDeploymentStatus;
  team?: CancelDeploymentTeam | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | CancelDeploymentCustomEnvironment1
    | CancelDeploymentCustomEnvironment2
    | undefined;
  id: string;
  aliasError?: CancelDeploymentAliasError | null | undefined;
  aliasFinal?: string | null | undefined;
  aliasWarning?: CancelDeploymentAliasWarning | null | undefined;
  /**
   * applies to custom domains only, defaults to `true`
   */
  autoAssignCustomDomains?: boolean | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: CancelDeploymentChecksState | undefined;
  checksConclusion?: CancelDeploymentChecksConclusion | undefined;
  createdAt: number;
  deletedAt?: number | null | undefined;
  /**
   * Computed field that is only available for deployments with a micro-frontend configuration.
   */
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorMessage?: string | null | undefined;
  errorStep?: string | undefined;
  /**
   * Since November 2023 this field defines a set of regions that we will deploy the lambda to passively Lambdas will be deployed to these regions but only invoked if all of the primary `regions` are marked as out of service
   */
  passiveRegions?: Array<string> | undefined;
  gitSource?:
    | GitSource6
    | GitSource8
    | CancelDeploymentGitSource1
    | CancelDeploymentGitSource3
    | CancelDeploymentGitSource2
    | CancelDeploymentGitSource4
    | CancelDeploymentGitSource5
    | GitSource7
    | GitSource9
    | undefined;
  name: string;
  meta: { [k: string]: string };
  project?: CancelDeploymentProject | undefined;
  readyState: CancelDeploymentReadyState;
  /**
   * Since June 2023 Substate of deployment when readyState is 'READY' Tracks whether or not deployment has seen production traffic: - STAGED: never seen production traffic - PROMOTED: has seen production traffic
   */
  readySubstate?: CancelDeploymentReadySubstate | undefined;
  regions: Array<string>;
  softDeletedByRetention?: boolean | undefined;
  source?: CancelDeploymentSource | undefined;
  target?: CancelDeploymentTarget | null | undefined;
  type: CancelDeploymentType;
  undeletedAt?: number | undefined;
  url: string;
  version: number;
  oidcTokenClaims?: CancelDeploymentOidcTokenClaims | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdIn: string;
  crons?: Array<CancelDeploymentCrons> | undefined;
  functions?: { [k: string]: CancelDeploymentFunctions } | null | undefined;
  monorepoManager?: string | null | undefined;
  ownerId: string;
  /**
   * Since November 2023 this field defines a Secure Compute network that will only be used to deploy passive lambdas to (as in passiveRegions)
   */
  passiveConnectConfigurationId?: string | undefined;
  plan: CancelDeploymentPlan;
  projectId: string;
  routes:
    | Array<
      | CancelDeploymentRoutes3
      | CancelDeploymentRoutes2
      | CancelDeploymentRoutes1
    >
    | null;
  gitRepo?:
    | CancelDeploymentGitRepo1
    | CancelDeploymentGitRepo2
    | CancelDeploymentGitRepo3
    | null
    | undefined;
  flags?: CancelDeploymentFlags1 | Array<CancelDeploymentFlags2> | undefined;
};

/** @internal */
export const CancelDeploymentRequest$inboundSchema: z.ZodType<
  CancelDeploymentRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/** @internal */
export type CancelDeploymentRequest$Outbound = {
  id: string;
  teamId?: string | undefined;
  slug?: string | undefined;
};

/** @internal */
export const CancelDeploymentRequest$outboundSchema: z.ZodType<
  CancelDeploymentRequest$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRequest
> = z.object({
  id: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRequest$ {
  /** @deprecated use `CancelDeploymentRequest$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRequest$inboundSchema;
  /** @deprecated use `CancelDeploymentRequest$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRequest$outboundSchema;
  /** @deprecated use `CancelDeploymentRequest$Outbound` instead. */
  export type Outbound = CancelDeploymentRequest$Outbound;
}

/** @internal */
export const CancelDeploymentAliasAssignedAt$inboundSchema: z.ZodType<
  CancelDeploymentAliasAssignedAt,
  z.ZodTypeDef,
  unknown
> = z.union([z.number(), z.boolean()]);

/** @internal */
export type CancelDeploymentAliasAssignedAt$Outbound = number | boolean;

/** @internal */
export const CancelDeploymentAliasAssignedAt$outboundSchema: z.ZodType<
  CancelDeploymentAliasAssignedAt$Outbound,
  z.ZodTypeDef,
  CancelDeploymentAliasAssignedAt
> = z.union([z.number(), z.boolean()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentAliasAssignedAt$ {
  /** @deprecated use `CancelDeploymentAliasAssignedAt$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentAliasAssignedAt$inboundSchema;
  /** @deprecated use `CancelDeploymentAliasAssignedAt$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentAliasAssignedAt$outboundSchema;
  /** @deprecated use `CancelDeploymentAliasAssignedAt$Outbound` instead. */
  export type Outbound = CancelDeploymentAliasAssignedAt$Outbound;
}

/** @internal */
export const CancelDeploymentBuild$inboundSchema: z.ZodType<
  CancelDeploymentBuild,
  z.ZodTypeDef,
  unknown
> = z.object({
  env: z.array(z.string()),
});

/** @internal */
export type CancelDeploymentBuild$Outbound = {
  env: Array<string>;
};

/** @internal */
export const CancelDeploymentBuild$outboundSchema: z.ZodType<
  CancelDeploymentBuild$Outbound,
  z.ZodTypeDef,
  CancelDeploymentBuild
> = z.object({
  env: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentBuild$ {
  /** @deprecated use `CancelDeploymentBuild$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentBuild$inboundSchema;
  /** @deprecated use `CancelDeploymentBuild$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentBuild$outboundSchema;
  /** @deprecated use `CancelDeploymentBuild$Outbound` instead. */
  export type Outbound = CancelDeploymentBuild$Outbound;
}

/** @internal */
export const CancelDeploymentBuilds$inboundSchema: z.ZodType<
  CancelDeploymentBuilds,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CancelDeploymentBuilds$Outbound = {};

/** @internal */
export const CancelDeploymentBuilds$outboundSchema: z.ZodType<
  CancelDeploymentBuilds$Outbound,
  z.ZodTypeDef,
  CancelDeploymentBuilds
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentBuilds$ {
  /** @deprecated use `CancelDeploymentBuilds$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentBuilds$inboundSchema;
  /** @deprecated use `CancelDeploymentBuilds$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentBuilds$outboundSchema;
  /** @deprecated use `CancelDeploymentBuilds$Outbound` instead. */
  export type Outbound = CancelDeploymentBuilds$Outbound;
}

/** @internal */
export const CancelDeploymentFramework$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentFramework
> = z.nativeEnum(CancelDeploymentFramework);

/** @internal */
export const CancelDeploymentFramework$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentFramework
> = CancelDeploymentFramework$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentFramework$ {
  /** @deprecated use `CancelDeploymentFramework$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentFramework$inboundSchema;
  /** @deprecated use `CancelDeploymentFramework$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentFramework$outboundSchema;
}

/** @internal */
export const CancelDeploymentSpeedInsights$inboundSchema: z.ZodType<
  CancelDeploymentSpeedInsights,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/** @internal */
export type CancelDeploymentSpeedInsights$Outbound = {
  id: string;
  enabledAt?: number | undefined;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  hasData?: boolean | undefined;
  paidAt?: number | undefined;
};

/** @internal */
export const CancelDeploymentSpeedInsights$outboundSchema: z.ZodType<
  CancelDeploymentSpeedInsights$Outbound,
  z.ZodTypeDef,
  CancelDeploymentSpeedInsights
> = z.object({
  id: z.string(),
  enabledAt: z.number().optional(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  hasData: z.boolean().optional(),
  paidAt: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentSpeedInsights$ {
  /** @deprecated use `CancelDeploymentSpeedInsights$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentSpeedInsights$inboundSchema;
  /** @deprecated use `CancelDeploymentSpeedInsights$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentSpeedInsights$outboundSchema;
  /** @deprecated use `CancelDeploymentSpeedInsights$Outbound` instead. */
  export type Outbound = CancelDeploymentSpeedInsights$Outbound;
}

/** @internal */
export const CancelDeploymentWebAnalytics$inboundSchema: z.ZodType<
  CancelDeploymentWebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/** @internal */
export type CancelDeploymentWebAnalytics$Outbound = {
  id: string;
  disabledAt?: number | undefined;
  canceledAt?: number | undefined;
  enabledAt?: number | undefined;
  hasData?: boolean | undefined;
};

/** @internal */
export const CancelDeploymentWebAnalytics$outboundSchema: z.ZodType<
  CancelDeploymentWebAnalytics$Outbound,
  z.ZodTypeDef,
  CancelDeploymentWebAnalytics
> = z.object({
  id: z.string(),
  disabledAt: z.number().optional(),
  canceledAt: z.number().optional(),
  enabledAt: z.number().optional(),
  hasData: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentWebAnalytics$ {
  /** @deprecated use `CancelDeploymentWebAnalytics$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentWebAnalytics$inboundSchema;
  /** @deprecated use `CancelDeploymentWebAnalytics$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentWebAnalytics$outboundSchema;
  /** @deprecated use `CancelDeploymentWebAnalytics$Outbound` instead. */
  export type Outbound = CancelDeploymentWebAnalytics$Outbound;
}

/** @internal */
export const CancelDeploymentProjectSettings$inboundSchema: z.ZodType<
  CancelDeploymentProjectSettings,
  z.ZodTypeDef,
  unknown
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(CancelDeploymentFramework$inboundSchema).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  installCommand: z.nullable(z.string()).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  speedInsights: z.lazy(() => CancelDeploymentSpeedInsights$inboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => CancelDeploymentWebAnalytics$inboundSchema)
    .optional(),
});

/** @internal */
export type CancelDeploymentProjectSettings$Outbound = {
  buildCommand?: string | null | undefined;
  devCommand?: string | null | undefined;
  framework?: string | null | undefined;
  commandForIgnoringBuildStep?: string | null | undefined;
  installCommand?: string | null | undefined;
  outputDirectory?: string | null | undefined;
  speedInsights?: CancelDeploymentSpeedInsights$Outbound | undefined;
  webAnalytics?: CancelDeploymentWebAnalytics$Outbound | undefined;
};

/** @internal */
export const CancelDeploymentProjectSettings$outboundSchema: z.ZodType<
  CancelDeploymentProjectSettings$Outbound,
  z.ZodTypeDef,
  CancelDeploymentProjectSettings
> = z.object({
  buildCommand: z.nullable(z.string()).optional(),
  devCommand: z.nullable(z.string()).optional(),
  framework: z.nullable(CancelDeploymentFramework$outboundSchema).optional(),
  commandForIgnoringBuildStep: z.nullable(z.string()).optional(),
  installCommand: z.nullable(z.string()).optional(),
  outputDirectory: z.nullable(z.string()).optional(),
  speedInsights: z.lazy(() => CancelDeploymentSpeedInsights$outboundSchema)
    .optional(),
  webAnalytics: z.lazy(() => CancelDeploymentWebAnalytics$outboundSchema)
    .optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentProjectSettings$ {
  /** @deprecated use `CancelDeploymentProjectSettings$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentProjectSettings$inboundSchema;
  /** @deprecated use `CancelDeploymentProjectSettings$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentProjectSettings$outboundSchema;
  /** @deprecated use `CancelDeploymentProjectSettings$Outbound` instead. */
  export type Outbound = CancelDeploymentProjectSettings$Outbound;
}

/** @internal */
export const CancelDeploymentDeploymentsStatus$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentDeploymentsStatus
> = z.nativeEnum(CancelDeploymentDeploymentsStatus);

/** @internal */
export const CancelDeploymentDeploymentsStatus$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentDeploymentsStatus
> = CancelDeploymentDeploymentsStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentDeploymentsStatus$ {
  /** @deprecated use `CancelDeploymentDeploymentsStatus$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentDeploymentsStatus$inboundSchema;
  /** @deprecated use `CancelDeploymentDeploymentsStatus$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentDeploymentsStatus$outboundSchema;
}

/** @internal */
export const CancelDeploymentIntegrations$inboundSchema: z.ZodType<
  CancelDeploymentIntegrations,
  z.ZodTypeDef,
  unknown
> = z.object({
  status: CancelDeploymentDeploymentsStatus$inboundSchema,
  startedAt: z.number(),
  completedAt: z.number().optional(),
  skippedAt: z.number().optional(),
  skippedBy: z.string().optional(),
});

/** @internal */
export type CancelDeploymentIntegrations$Outbound = {
  status: string;
  startedAt: number;
  completedAt?: number | undefined;
  skippedAt?: number | undefined;
  skippedBy?: string | undefined;
};

/** @internal */
export const CancelDeploymentIntegrations$outboundSchema: z.ZodType<
  CancelDeploymentIntegrations$Outbound,
  z.ZodTypeDef,
  CancelDeploymentIntegrations
> = z.object({
  status: CancelDeploymentDeploymentsStatus$outboundSchema,
  startedAt: z.number(),
  completedAt: z.number().optional(),
  skippedAt: z.number().optional(),
  skippedBy: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentIntegrations$ {
  /** @deprecated use `CancelDeploymentIntegrations$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentIntegrations$inboundSchema;
  /** @deprecated use `CancelDeploymentIntegrations$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentIntegrations$outboundSchema;
  /** @deprecated use `CancelDeploymentIntegrations$Outbound` instead. */
  export type Outbound = CancelDeploymentIntegrations$Outbound;
}

/** @internal */
export const CancelDeploymentCreator$inboundSchema: z.ZodType<
  CancelDeploymentCreator,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/** @internal */
export type CancelDeploymentCreator$Outbound = {
  uid: string;
  username?: string | undefined;
  avatar?: string | undefined;
};

/** @internal */
export const CancelDeploymentCreator$outboundSchema: z.ZodType<
  CancelDeploymentCreator$Outbound,
  z.ZodTypeDef,
  CancelDeploymentCreator
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  avatar: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentCreator$ {
  /** @deprecated use `CancelDeploymentCreator$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentCreator$inboundSchema;
  /** @deprecated use `CancelDeploymentCreator$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentCreator$outboundSchema;
  /** @deprecated use `CancelDeploymentCreator$Outbound` instead. */
  export type Outbound = CancelDeploymentCreator$Outbound;
}

/** @internal */
export const CancelDeploymentDeploymentsReadyState$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentDeploymentsReadyState> = z.nativeEnum(
    CancelDeploymentDeploymentsReadyState,
  );

/** @internal */
export const CancelDeploymentDeploymentsReadyState$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentDeploymentsReadyState> =
    CancelDeploymentDeploymentsReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentDeploymentsReadyState$ {
  /** @deprecated use `CancelDeploymentDeploymentsReadyState$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentDeploymentsReadyState$inboundSchema;
  /** @deprecated use `CancelDeploymentDeploymentsReadyState$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentDeploymentsReadyState$outboundSchema;
}

/** @internal */
export const CancelDeploymentOutput$inboundSchema: z.ZodType<
  CancelDeploymentOutput,
  z.ZodTypeDef,
  unknown
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/** @internal */
export type CancelDeploymentOutput$Outbound = {
  path: string;
  functionName: string;
};

/** @internal */
export const CancelDeploymentOutput$outboundSchema: z.ZodType<
  CancelDeploymentOutput$Outbound,
  z.ZodTypeDef,
  CancelDeploymentOutput
> = z.object({
  path: z.string(),
  functionName: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentOutput$ {
  /** @deprecated use `CancelDeploymentOutput$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentOutput$inboundSchema;
  /** @deprecated use `CancelDeploymentOutput$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentOutput$outboundSchema;
  /** @deprecated use `CancelDeploymentOutput$Outbound` instead. */
  export type Outbound = CancelDeploymentOutput$Outbound;
}

/** @internal */
export const CancelDeploymentLambdas$inboundSchema: z.ZodType<
  CancelDeploymentLambdas,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState: CancelDeploymentDeploymentsReadyState$inboundSchema.optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => CancelDeploymentOutput$inboundSchema)),
});

/** @internal */
export type CancelDeploymentLambdas$Outbound = {
  id?: string | undefined;
  createdAt?: number | undefined;
  entrypoint?: string | null | undefined;
  readyState?: string | undefined;
  readyStateAt?: number | undefined;
  output: Array<CancelDeploymentOutput$Outbound>;
};

/** @internal */
export const CancelDeploymentLambdas$outboundSchema: z.ZodType<
  CancelDeploymentLambdas$Outbound,
  z.ZodTypeDef,
  CancelDeploymentLambdas
> = z.object({
  id: z.string().optional(),
  createdAt: z.number().optional(),
  entrypoint: z.nullable(z.string()).optional(),
  readyState: CancelDeploymentDeploymentsReadyState$outboundSchema.optional(),
  readyStateAt: z.number().optional(),
  output: z.array(z.lazy(() => CancelDeploymentOutput$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentLambdas$ {
  /** @deprecated use `CancelDeploymentLambdas$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentLambdas$inboundSchema;
  /** @deprecated use `CancelDeploymentLambdas$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentLambdas$outboundSchema;
  /** @deprecated use `CancelDeploymentLambdas$Outbound` instead. */
  export type Outbound = CancelDeploymentLambdas$Outbound;
}

/** @internal */
export const CancelDeploymentStatus$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentStatus
> = z.nativeEnum(CancelDeploymentStatus);

/** @internal */
export const CancelDeploymentStatus$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentStatus
> = CancelDeploymentStatus$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentStatus$ {
  /** @deprecated use `CancelDeploymentStatus$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentStatus$inboundSchema;
  /** @deprecated use `CancelDeploymentStatus$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentStatus$outboundSchema;
}

/** @internal */
export const CancelDeploymentTeam$inboundSchema: z.ZodType<
  CancelDeploymentTeam,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  avatar: z.string().optional(),
  slug: z.string(),
});

/** @internal */
export type CancelDeploymentTeam$Outbound = {
  id: string;
  name: string;
  avatar?: string | undefined;
  slug: string;
};

/** @internal */
export const CancelDeploymentTeam$outboundSchema: z.ZodType<
  CancelDeploymentTeam$Outbound,
  z.ZodTypeDef,
  CancelDeploymentTeam
> = z.object({
  id: z.string(),
  name: z.string(),
  avatar: z.string().optional(),
  slug: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentTeam$ {
  /** @deprecated use `CancelDeploymentTeam$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentTeam$inboundSchema;
  /** @deprecated use `CancelDeploymentTeam$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentTeam$outboundSchema;
  /** @deprecated use `CancelDeploymentTeam$Outbound` instead. */
  export type Outbound = CancelDeploymentTeam$Outbound;
}

/** @internal */
export const CancelDeploymentCustomEnvironment2$inboundSchema: z.ZodType<
  CancelDeploymentCustomEnvironment2,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
});

/** @internal */
export type CancelDeploymentCustomEnvironment2$Outbound = {
  id: string;
};

/** @internal */
export const CancelDeploymentCustomEnvironment2$outboundSchema: z.ZodType<
  CancelDeploymentCustomEnvironment2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentCustomEnvironment2
> = z.object({
  id: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentCustomEnvironment2$ {
  /** @deprecated use `CancelDeploymentCustomEnvironment2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentCustomEnvironment2$inboundSchema;
  /** @deprecated use `CancelDeploymentCustomEnvironment2$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentCustomEnvironment2$outboundSchema;
  /** @deprecated use `CancelDeploymentCustomEnvironment2$Outbound` instead. */
  export type Outbound = CancelDeploymentCustomEnvironment2$Outbound;
}

/** @internal */
export const CancelDeploymentCustomEnvironment1$inboundSchema: z.ZodType<
  CancelDeploymentCustomEnvironment1,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CancelDeploymentCustomEnvironment1$Outbound = {};

/** @internal */
export const CancelDeploymentCustomEnvironment1$outboundSchema: z.ZodType<
  CancelDeploymentCustomEnvironment1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentCustomEnvironment1
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentCustomEnvironment1$ {
  /** @deprecated use `CancelDeploymentCustomEnvironment1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentCustomEnvironment1$inboundSchema;
  /** @deprecated use `CancelDeploymentCustomEnvironment1$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentCustomEnvironment1$outboundSchema;
  /** @deprecated use `CancelDeploymentCustomEnvironment1$Outbound` instead. */
  export type Outbound = CancelDeploymentCustomEnvironment1$Outbound;
}

/** @internal */
export const CancelDeploymentCustomEnvironment$inboundSchema: z.ZodType<
  CancelDeploymentCustomEnvironment,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CancelDeploymentCustomEnvironment1$inboundSchema),
  z.lazy(() => CancelDeploymentCustomEnvironment2$inboundSchema),
]);

/** @internal */
export type CancelDeploymentCustomEnvironment$Outbound =
  | CancelDeploymentCustomEnvironment1$Outbound
  | CancelDeploymentCustomEnvironment2$Outbound;

/** @internal */
export const CancelDeploymentCustomEnvironment$outboundSchema: z.ZodType<
  CancelDeploymentCustomEnvironment$Outbound,
  z.ZodTypeDef,
  CancelDeploymentCustomEnvironment
> = z.union([
  z.lazy(() => CancelDeploymentCustomEnvironment1$outboundSchema),
  z.lazy(() => CancelDeploymentCustomEnvironment2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentCustomEnvironment$ {
  /** @deprecated use `CancelDeploymentCustomEnvironment$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentCustomEnvironment$inboundSchema;
  /** @deprecated use `CancelDeploymentCustomEnvironment$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentCustomEnvironment$outboundSchema;
  /** @deprecated use `CancelDeploymentCustomEnvironment$Outbound` instead. */
  export type Outbound = CancelDeploymentCustomEnvironment$Outbound;
}

/** @internal */
export const CancelDeploymentAliasError$inboundSchema: z.ZodType<
  CancelDeploymentAliasError,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
});

/** @internal */
export type CancelDeploymentAliasError$Outbound = {
  code: string;
  message: string;
};

/** @internal */
export const CancelDeploymentAliasError$outboundSchema: z.ZodType<
  CancelDeploymentAliasError$Outbound,
  z.ZodTypeDef,
  CancelDeploymentAliasError
> = z.object({
  code: z.string(),
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentAliasError$ {
  /** @deprecated use `CancelDeploymentAliasError$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentAliasError$inboundSchema;
  /** @deprecated use `CancelDeploymentAliasError$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentAliasError$outboundSchema;
  /** @deprecated use `CancelDeploymentAliasError$Outbound` instead. */
  export type Outbound = CancelDeploymentAliasError$Outbound;
}

/** @internal */
export const CancelDeploymentAliasWarning$inboundSchema: z.ZodType<
  CancelDeploymentAliasWarning,
  z.ZodTypeDef,
  unknown
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/** @internal */
export type CancelDeploymentAliasWarning$Outbound = {
  code: string;
  message: string;
  link?: string | undefined;
  action?: string | undefined;
};

/** @internal */
export const CancelDeploymentAliasWarning$outboundSchema: z.ZodType<
  CancelDeploymentAliasWarning$Outbound,
  z.ZodTypeDef,
  CancelDeploymentAliasWarning
> = z.object({
  code: z.string(),
  message: z.string(),
  link: z.string().optional(),
  action: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentAliasWarning$ {
  /** @deprecated use `CancelDeploymentAliasWarning$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentAliasWarning$inboundSchema;
  /** @deprecated use `CancelDeploymentAliasWarning$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentAliasWarning$outboundSchema;
  /** @deprecated use `CancelDeploymentAliasWarning$Outbound` instead. */
  export type Outbound = CancelDeploymentAliasWarning$Outbound;
}

/** @internal */
export const CancelDeploymentChecksState$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentChecksState
> = z.nativeEnum(CancelDeploymentChecksState);

/** @internal */
export const CancelDeploymentChecksState$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentChecksState
> = CancelDeploymentChecksState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentChecksState$ {
  /** @deprecated use `CancelDeploymentChecksState$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentChecksState$inboundSchema;
  /** @deprecated use `CancelDeploymentChecksState$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentChecksState$outboundSchema;
}

/** @internal */
export const CancelDeploymentChecksConclusion$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentChecksConclusion
> = z.nativeEnum(CancelDeploymentChecksConclusion);

/** @internal */
export const CancelDeploymentChecksConclusion$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentChecksConclusion
> = CancelDeploymentChecksConclusion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentChecksConclusion$ {
  /** @deprecated use `CancelDeploymentChecksConclusion$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentChecksConclusion$inboundSchema;
  /** @deprecated use `CancelDeploymentChecksConclusion$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentChecksConclusion$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type
  > = z.nativeEnum(
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type,
  );

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type
  > =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema;
}

/** @internal */
export const GitSource9$inboundSchema: z.ZodType<
  GitSource9,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/** @internal */
export type GitSource9$Outbound = {
  type: string;
  ref: string;
  sha: string;
  owner?: string | undefined;
  slug?: string | undefined;
  workspaceUuid: string;
  repoUuid: string;
};

/** @internal */
export const GitSource9$outboundSchema: z.ZodType<
  GitSource9$Outbound,
  z.ZodTypeDef,
  GitSource9
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody9Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  owner: z.string().optional(),
  slug: z.string().optional(),
  workspaceUuid: z.string(),
  repoUuid: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource9$ {
  /** @deprecated use `GitSource9$inboundSchema` instead. */
  export const inboundSchema = GitSource9$inboundSchema;
  /** @deprecated use `GitSource9$outboundSchema` instead. */
  export const outboundSchema = GitSource9$outboundSchema;
  /** @deprecated use `GitSource9$Outbound` instead. */
  export type Outbound = GitSource9$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type
  > = z.nativeEnum(
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type,
  );

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type
  > =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema;
}

/** @internal */
export const GitSource8$inboundSchema: z.ZodType<
  GitSource8,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/** @internal */
export type GitSource8$Outbound = {
  type: string;
  ref: string;
  sha: string;
  projectId: number;
};

/** @internal */
export const GitSource8$outboundSchema: z.ZodType<
  GitSource8$Outbound,
  z.ZodTypeDef,
  GitSource8
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody8Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  projectId: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource8$ {
  /** @deprecated use `GitSource8$inboundSchema` instead. */
  export const inboundSchema = GitSource8$inboundSchema;
  /** @deprecated use `GitSource8$outboundSchema` instead. */
  export const outboundSchema = GitSource8$outboundSchema;
  /** @deprecated use `GitSource8$Outbound` instead. */
  export type Outbound = GitSource8$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type
  > = z.nativeEnum(
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type,
  );

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type
  > =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema;
}

/** @internal */
export const GitSource7$inboundSchema: z.ZodType<
  GitSource7,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/** @internal */
export type GitSource7$Outbound = {
  type: string;
  ref: string;
  sha: string;
  repoId: number;
  org?: string | undefined;
  repo?: string | undefined;
};

/** @internal */
export const GitSource7$outboundSchema: z.ZodType<
  GitSource7$Outbound,
  z.ZodTypeDef,
  GitSource7
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBody7Type$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  repoId: z.number(),
  org: z.string().optional(),
  repo: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource7$ {
  /** @deprecated use `GitSource7$inboundSchema` instead. */
  export const inboundSchema = GitSource7$inboundSchema;
  /** @deprecated use `GitSource7$outboundSchema` instead. */
  export const outboundSchema = GitSource7$outboundSchema;
  /** @deprecated use `GitSource7$Outbound` instead. */
  export type Outbound = GitSource7$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  > = z.nativeEnum(
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType,
  );

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType
  > =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema;
}

/** @internal */
export const GitSource6$inboundSchema: z.ZodType<
  GitSource6,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$inboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/** @internal */
export type GitSource6$Outbound = {
  type: string;
  ref: string;
  sha: string;
  gitUrl: string;
};

/** @internal */
export const GitSource6$outboundSchema: z.ZodType<
  GitSource6$Outbound,
  z.ZodTypeDef,
  GitSource6
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONResponseBodyType$outboundSchema,
  ref: z.string(),
  sha: z.string(),
  gitUrl: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitSource6$ {
  /** @deprecated use `GitSource6$inboundSchema` instead. */
  export const inboundSchema = GitSource6$inboundSchema;
  /** @deprecated use `GitSource6$outboundSchema` instead. */
  export const outboundSchema = GitSource6$outboundSchema;
  /** @deprecated use `GitSource6$Outbound` instead. */
  export type Outbound = GitSource6$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  > = z.nativeEnum(
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType,
  );

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema:
  z.ZodNativeEnum<
    typeof CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType
  > =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitSource5$inboundSchema: z.ZodType<
  CancelDeploymentGitSource5,
  z.ZodTypeDef,
  unknown
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$inboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type CancelDeploymentGitSource5$Outbound = {
  type: string;
  owner: string;
  slug: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const CancelDeploymentGitSource5$outboundSchema: z.ZodType<
  CancelDeploymentGitSource5$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSource5
> = z.object({
  type:
    CancelDeploymentGitSourceDeploymentsResponse200ApplicationJSONType$outboundSchema,
  owner: z.string(),
  slug: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSource5$ {
  /** @deprecated use `CancelDeploymentGitSource5$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSource5$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSource5$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSource5$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSource5$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSource5$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200Type$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitSourceDeploymentsResponse200Type> =
    z.nativeEnum(CancelDeploymentGitSourceDeploymentsResponse200Type);

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponse200Type$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitSourceDeploymentsResponse200Type> =
    CancelDeploymentGitSourceDeploymentsResponse200Type$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponse200Type$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200Type$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200Type$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponse200Type$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponse200Type$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitSource4$inboundSchema: z.ZodType<
  CancelDeploymentGitSource4,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentGitSourceDeploymentsResponse200Type$inboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type CancelDeploymentGitSource4$Outbound = {
  type: string;
  workspaceUuid?: string | undefined;
  repoUuid: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const CancelDeploymentGitSource4$outboundSchema: z.ZodType<
  CancelDeploymentGitSource4$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSource4
> = z.object({
  type: CancelDeploymentGitSourceDeploymentsResponse200Type$outboundSchema,
  workspaceUuid: z.string().optional(),
  repoUuid: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSource4$ {
  /** @deprecated use `CancelDeploymentGitSource4$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSource4$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSource4$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSource4$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSource4$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSource4$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitSourceDeploymentsResponseType> = z
    .nativeEnum(CancelDeploymentGitSourceDeploymentsResponseType);

/** @internal */
export const CancelDeploymentGitSourceDeploymentsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitSourceDeploymentsResponseType> =
    CancelDeploymentGitSourceDeploymentsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsResponseType$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsResponseType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsResponseType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitSourceProjectId$inboundSchema: z.ZodType<
  CancelDeploymentGitSourceProjectId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type CancelDeploymentGitSourceProjectId$Outbound = string | number;

/** @internal */
export const CancelDeploymentGitSourceProjectId$outboundSchema: z.ZodType<
  CancelDeploymentGitSourceProjectId$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSourceProjectId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceProjectId$ {
  /** @deprecated use `CancelDeploymentGitSourceProjectId$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSourceProjectId$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceProjectId$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceProjectId$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceProjectId$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSourceProjectId$Outbound;
}

/** @internal */
export const CancelDeploymentGitSource3$inboundSchema: z.ZodType<
  CancelDeploymentGitSource3,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentGitSourceDeploymentsResponseType$inboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type CancelDeploymentGitSource3$Outbound = {
  type: string;
  projectId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const CancelDeploymentGitSource3$outboundSchema: z.ZodType<
  CancelDeploymentGitSource3$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSource3
> = z.object({
  type: CancelDeploymentGitSourceDeploymentsResponseType$outboundSchema,
  projectId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSource3$ {
  /** @deprecated use `CancelDeploymentGitSource3$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSource3$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSource3$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSource3$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSource3$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSource3$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceDeploymentsType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitSourceDeploymentsType> = z
    .nativeEnum(CancelDeploymentGitSourceDeploymentsType);

/** @internal */
export const CancelDeploymentGitSourceDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitSourceDeploymentsType> =
    CancelDeploymentGitSourceDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceDeploymentsType$ {
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitSourceDeploymentsType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitSourceDeploymentsType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitSource2$inboundSchema: z.ZodType<
  CancelDeploymentGitSource2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentGitSourceDeploymentsType$inboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type CancelDeploymentGitSource2$Outbound = {
  type: string;
  org: string;
  repo: string;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const CancelDeploymentGitSource2$outboundSchema: z.ZodType<
  CancelDeploymentGitSource2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSource2
> = z.object({
  type: CancelDeploymentGitSourceDeploymentsType$outboundSchema,
  org: z.string(),
  repo: z.string(),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSource2$ {
  /** @deprecated use `CancelDeploymentGitSource2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSource2$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSource2$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSource2$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSource2$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSource2$Outbound;
}

/** @internal */
export const CancelDeploymentGitSourceType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentGitSourceType
> = z.nativeEnum(CancelDeploymentGitSourceType);

/** @internal */
export const CancelDeploymentGitSourceType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentGitSourceType
> = CancelDeploymentGitSourceType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceType$ {
  /** @deprecated use `CancelDeploymentGitSourceType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSourceType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceType$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSourceType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitSourceRepoId$inboundSchema: z.ZodType<
  CancelDeploymentGitSourceRepoId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type CancelDeploymentGitSourceRepoId$Outbound = string | number;

/** @internal */
export const CancelDeploymentGitSourceRepoId$outboundSchema: z.ZodType<
  CancelDeploymentGitSourceRepoId$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSourceRepoId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSourceRepoId$ {
  /** @deprecated use `CancelDeploymentGitSourceRepoId$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSourceRepoId$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceRepoId$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSourceRepoId$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSourceRepoId$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSourceRepoId$Outbound;
}

/** @internal */
export const CancelDeploymentGitSource1$inboundSchema: z.ZodType<
  CancelDeploymentGitSource1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentGitSourceType$inboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/** @internal */
export type CancelDeploymentGitSource1$Outbound = {
  type: string;
  repoId: string | number;
  ref?: string | null | undefined;
  sha?: string | undefined;
  prId?: number | null | undefined;
};

/** @internal */
export const CancelDeploymentGitSource1$outboundSchema: z.ZodType<
  CancelDeploymentGitSource1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSource1
> = z.object({
  type: CancelDeploymentGitSourceType$outboundSchema,
  repoId: z.union([z.string(), z.number()]),
  ref: z.nullable(z.string()).optional(),
  sha: z.string().optional(),
  prId: z.nullable(z.number()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSource1$ {
  /** @deprecated use `CancelDeploymentGitSource1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSource1$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSource1$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSource1$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSource1$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSource1$Outbound;
}

/** @internal */
export const CancelDeploymentGitSource$inboundSchema: z.ZodType<
  CancelDeploymentGitSource,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => GitSource6$inboundSchema),
  z.lazy(() => GitSource8$inboundSchema),
  z.lazy(() => CancelDeploymentGitSource1$inboundSchema),
  z.lazy(() => CancelDeploymentGitSource3$inboundSchema),
  z.lazy(() => CancelDeploymentGitSource2$inboundSchema),
  z.lazy(() => CancelDeploymentGitSource4$inboundSchema),
  z.lazy(() => CancelDeploymentGitSource5$inboundSchema),
  z.lazy(() => GitSource7$inboundSchema),
  z.lazy(() => GitSource9$inboundSchema),
]);

/** @internal */
export type CancelDeploymentGitSource$Outbound =
  | GitSource6$Outbound
  | GitSource8$Outbound
  | CancelDeploymentGitSource1$Outbound
  | CancelDeploymentGitSource3$Outbound
  | CancelDeploymentGitSource2$Outbound
  | CancelDeploymentGitSource4$Outbound
  | CancelDeploymentGitSource5$Outbound
  | GitSource7$Outbound
  | GitSource9$Outbound;

/** @internal */
export const CancelDeploymentGitSource$outboundSchema: z.ZodType<
  CancelDeploymentGitSource$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitSource
> = z.union([
  z.lazy(() => GitSource6$outboundSchema),
  z.lazy(() => GitSource8$outboundSchema),
  z.lazy(() => CancelDeploymentGitSource1$outboundSchema),
  z.lazy(() => CancelDeploymentGitSource3$outboundSchema),
  z.lazy(() => CancelDeploymentGitSource2$outboundSchema),
  z.lazy(() => CancelDeploymentGitSource4$outboundSchema),
  z.lazy(() => CancelDeploymentGitSource5$outboundSchema),
  z.lazy(() => GitSource7$outboundSchema),
  z.lazy(() => GitSource9$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitSource$ {
  /** @deprecated use `CancelDeploymentGitSource$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitSource$inboundSchema;
  /** @deprecated use `CancelDeploymentGitSource$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitSource$outboundSchema;
  /** @deprecated use `CancelDeploymentGitSource$Outbound` instead. */
  export type Outbound = CancelDeploymentGitSource$Outbound;
}

/** @internal */
export const CancelDeploymentProject$inboundSchema: z.ZodType<
  CancelDeploymentProject,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/** @internal */
export type CancelDeploymentProject$Outbound = {
  id: string;
  name: string;
  framework?: string | null | undefined;
};

/** @internal */
export const CancelDeploymentProject$outboundSchema: z.ZodType<
  CancelDeploymentProject$Outbound,
  z.ZodTypeDef,
  CancelDeploymentProject
> = z.object({
  id: z.string(),
  name: z.string(),
  framework: z.nullable(z.string()).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentProject$ {
  /** @deprecated use `CancelDeploymentProject$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentProject$inboundSchema;
  /** @deprecated use `CancelDeploymentProject$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentProject$outboundSchema;
  /** @deprecated use `CancelDeploymentProject$Outbound` instead. */
  export type Outbound = CancelDeploymentProject$Outbound;
}

/** @internal */
export const CancelDeploymentReadyState$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentReadyState
> = z.nativeEnum(CancelDeploymentReadyState);

/** @internal */
export const CancelDeploymentReadyState$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentReadyState
> = CancelDeploymentReadyState$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentReadyState$ {
  /** @deprecated use `CancelDeploymentReadyState$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentReadyState$inboundSchema;
  /** @deprecated use `CancelDeploymentReadyState$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentReadyState$outboundSchema;
}

/** @internal */
export const CancelDeploymentReadySubstate$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentReadySubstate
> = z.nativeEnum(CancelDeploymentReadySubstate);

/** @internal */
export const CancelDeploymentReadySubstate$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentReadySubstate
> = CancelDeploymentReadySubstate$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentReadySubstate$ {
  /** @deprecated use `CancelDeploymentReadySubstate$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentReadySubstate$inboundSchema;
  /** @deprecated use `CancelDeploymentReadySubstate$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentReadySubstate$outboundSchema;
}

/** @internal */
export const CancelDeploymentSource$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentSource
> = z.nativeEnum(CancelDeploymentSource);

/** @internal */
export const CancelDeploymentSource$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentSource
> = CancelDeploymentSource$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentSource$ {
  /** @deprecated use `CancelDeploymentSource$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentSource$inboundSchema;
  /** @deprecated use `CancelDeploymentSource$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentSource$outboundSchema;
}

/** @internal */
export const CancelDeploymentTarget$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentTarget
> = z.nativeEnum(CancelDeploymentTarget);

/** @internal */
export const CancelDeploymentTarget$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentTarget
> = CancelDeploymentTarget$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentTarget$ {
  /** @deprecated use `CancelDeploymentTarget$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentTarget$inboundSchema;
  /** @deprecated use `CancelDeploymentTarget$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentTarget$outboundSchema;
}

/** @internal */
export const CancelDeploymentType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentType
> = z.nativeEnum(CancelDeploymentType);

/** @internal */
export const CancelDeploymentType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentType
> = CancelDeploymentType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentType$ {
  /** @deprecated use `CancelDeploymentType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentType$inboundSchema;
  /** @deprecated use `CancelDeploymentType$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentType$outboundSchema;
}

/** @internal */
export const CancelDeploymentOidcTokenClaims$inboundSchema: z.ZodType<
  CancelDeploymentOidcTokenClaims,
  z.ZodTypeDef,
  unknown
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  owner_id: z.string(),
  project: z.string(),
  project_id: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    "owner_id": "ownerId",
    "project_id": "projectId",
  });
});

/** @internal */
export type CancelDeploymentOidcTokenClaims$Outbound = {
  iss: string;
  sub: string;
  scope: string;
  aud: string;
  owner: string;
  owner_id: string;
  project: string;
  project_id: string;
  environment: string;
};

/** @internal */
export const CancelDeploymentOidcTokenClaims$outboundSchema: z.ZodType<
  CancelDeploymentOidcTokenClaims$Outbound,
  z.ZodTypeDef,
  CancelDeploymentOidcTokenClaims
> = z.object({
  iss: z.string(),
  sub: z.string(),
  scope: z.string(),
  aud: z.string(),
  owner: z.string(),
  ownerId: z.string(),
  project: z.string(),
  projectId: z.string(),
  environment: z.string(),
}).transform((v) => {
  return remap$(v, {
    ownerId: "owner_id",
    projectId: "project_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentOidcTokenClaims$ {
  /** @deprecated use `CancelDeploymentOidcTokenClaims$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentOidcTokenClaims$inboundSchema;
  /** @deprecated use `CancelDeploymentOidcTokenClaims$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentOidcTokenClaims$outboundSchema;
  /** @deprecated use `CancelDeploymentOidcTokenClaims$Outbound` instead. */
  export type Outbound = CancelDeploymentOidcTokenClaims$Outbound;
}

/** @internal */
export const CancelDeploymentCrons$inboundSchema: z.ZodType<
  CancelDeploymentCrons,
  z.ZodTypeDef,
  unknown
> = z.object({
  schedule: z.string(),
  path: z.string(),
});

/** @internal */
export type CancelDeploymentCrons$Outbound = {
  schedule: string;
  path: string;
};

/** @internal */
export const CancelDeploymentCrons$outboundSchema: z.ZodType<
  CancelDeploymentCrons$Outbound,
  z.ZodTypeDef,
  CancelDeploymentCrons
> = z.object({
  schedule: z.string(),
  path: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentCrons$ {
  /** @deprecated use `CancelDeploymentCrons$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentCrons$inboundSchema;
  /** @deprecated use `CancelDeploymentCrons$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentCrons$outboundSchema;
  /** @deprecated use `CancelDeploymentCrons$Outbound` instead. */
  export type Outbound = CancelDeploymentCrons$Outbound;
}

/** @internal */
export const CancelDeploymentFunctions$inboundSchema: z.ZodType<
  CancelDeploymentFunctions,
  z.ZodTypeDef,
  unknown
> = z.object({
  memory: z.number().optional(),
  maxDuration: z.number().optional(),
  runtime: z.string().optional(),
  includeFiles: z.string().optional(),
  excludeFiles: z.string().optional(),
});

/** @internal */
export type CancelDeploymentFunctions$Outbound = {
  memory?: number | undefined;
  maxDuration?: number | undefined;
  runtime?: string | undefined;
  includeFiles?: string | undefined;
  excludeFiles?: string | undefined;
};

/** @internal */
export const CancelDeploymentFunctions$outboundSchema: z.ZodType<
  CancelDeploymentFunctions$Outbound,
  z.ZodTypeDef,
  CancelDeploymentFunctions
> = z.object({
  memory: z.number().optional(),
  maxDuration: z.number().optional(),
  runtime: z.string().optional(),
  includeFiles: z.string().optional(),
  excludeFiles: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentFunctions$ {
  /** @deprecated use `CancelDeploymentFunctions$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentFunctions$inboundSchema;
  /** @deprecated use `CancelDeploymentFunctions$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentFunctions$outboundSchema;
  /** @deprecated use `CancelDeploymentFunctions$Outbound` instead. */
  export type Outbound = CancelDeploymentFunctions$Outbound;
}

/** @internal */
export const CancelDeploymentPlan$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentPlan
> = z.nativeEnum(CancelDeploymentPlan);

/** @internal */
export const CancelDeploymentPlan$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentPlan
> = CancelDeploymentPlan$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentPlan$ {
  /** @deprecated use `CancelDeploymentPlan$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentPlan$inboundSchema;
  /** @deprecated use `CancelDeploymentPlan$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentPlan$outboundSchema;
}

/** @internal */
export const CancelDeploymentRoutes3$inboundSchema: z.ZodType<
  CancelDeploymentRoutes3,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.string(),
  continue: z.boolean(),
  middleware: z.number(),
});

/** @internal */
export type CancelDeploymentRoutes3$Outbound = {
  src: string;
  continue: boolean;
  middleware: number;
};

/** @internal */
export const CancelDeploymentRoutes3$outboundSchema: z.ZodType<
  CancelDeploymentRoutes3$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRoutes3
> = z.object({
  src: z.string(),
  continue: z.boolean(),
  middleware: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutes3$ {
  /** @deprecated use `CancelDeploymentRoutes3$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutes3$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutes3$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutes3$outboundSchema;
  /** @deprecated use `CancelDeploymentRoutes3$Outbound` instead. */
  export type Outbound = CancelDeploymentRoutes3$Outbound;
}

/** @internal */
export const CancelDeploymentRoutesHandle$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentRoutesHandle
> = z.nativeEnum(CancelDeploymentRoutesHandle);

/** @internal */
export const CancelDeploymentRoutesHandle$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentRoutesHandle
> = CancelDeploymentRoutesHandle$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutesHandle$ {
  /** @deprecated use `CancelDeploymentRoutesHandle$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutesHandle$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutesHandle$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutesHandle$outboundSchema;
}

/** @internal */
export const CancelDeploymentRoutes2$inboundSchema: z.ZodType<
  CancelDeploymentRoutes2,
  z.ZodTypeDef,
  unknown
> = z.object({
  handle: CancelDeploymentRoutesHandle$inboundSchema,
  src: z.string().optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
});

/** @internal */
export type CancelDeploymentRoutes2$Outbound = {
  handle: string;
  src?: string | undefined;
  dest?: string | undefined;
  status?: number | undefined;
};

/** @internal */
export const CancelDeploymentRoutes2$outboundSchema: z.ZodType<
  CancelDeploymentRoutes2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRoutes2
> = z.object({
  handle: CancelDeploymentRoutesHandle$outboundSchema,
  src: z.string().optional(),
  dest: z.string().optional(),
  status: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutes2$ {
  /** @deprecated use `CancelDeploymentRoutes2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutes2$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutes2$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutes2$outboundSchema;
  /** @deprecated use `CancelDeploymentRoutes2$Outbound` instead. */
  export type Outbound = CancelDeploymentRoutes2$Outbound;
}

/** @internal */
export const CancelDeploymentHasDeploymentsType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentHasDeploymentsType
> = z.nativeEnum(CancelDeploymentHasDeploymentsType);

/** @internal */
export const CancelDeploymentHasDeploymentsType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentHasDeploymentsType
> = CancelDeploymentHasDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentHasDeploymentsType$ {
  /** @deprecated use `CancelDeploymentHasDeploymentsType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentHasDeploymentsType$inboundSchema;
  /** @deprecated use `CancelDeploymentHasDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentHasDeploymentsType$outboundSchema;
}

/** @internal */
export const CancelDeploymentHas2$inboundSchema: z.ZodType<
  CancelDeploymentHas2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentHasDeploymentsType$inboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type CancelDeploymentHas2$Outbound = {
  type: string;
  key: string;
  value?: string | undefined;
};

/** @internal */
export const CancelDeploymentHas2$outboundSchema: z.ZodType<
  CancelDeploymentHas2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentHas2
> = z.object({
  type: CancelDeploymentHasDeploymentsType$outboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentHas2$ {
  /** @deprecated use `CancelDeploymentHas2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentHas2$inboundSchema;
  /** @deprecated use `CancelDeploymentHas2$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentHas2$outboundSchema;
  /** @deprecated use `CancelDeploymentHas2$Outbound` instead. */
  export type Outbound = CancelDeploymentHas2$Outbound;
}

/** @internal */
export const CancelDeploymentHasType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentHasType
> = z.nativeEnum(CancelDeploymentHasType);

/** @internal */
export const CancelDeploymentHasType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentHasType
> = CancelDeploymentHasType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentHasType$ {
  /** @deprecated use `CancelDeploymentHasType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentHasType$inboundSchema;
  /** @deprecated use `CancelDeploymentHasType$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentHasType$outboundSchema;
}

/** @internal */
export const CancelDeploymentHas1$inboundSchema: z.ZodType<
  CancelDeploymentHas1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentHasType$inboundSchema,
  value: z.string(),
});

/** @internal */
export type CancelDeploymentHas1$Outbound = {
  type: string;
  value: string;
};

/** @internal */
export const CancelDeploymentHas1$outboundSchema: z.ZodType<
  CancelDeploymentHas1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentHas1
> = z.object({
  type: CancelDeploymentHasType$outboundSchema,
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentHas1$ {
  /** @deprecated use `CancelDeploymentHas1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentHas1$inboundSchema;
  /** @deprecated use `CancelDeploymentHas1$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentHas1$outboundSchema;
  /** @deprecated use `CancelDeploymentHas1$Outbound` instead. */
  export type Outbound = CancelDeploymentHas1$Outbound;
}

/** @internal */
export const CancelDeploymentRoutesHas$inboundSchema: z.ZodType<
  CancelDeploymentRoutesHas,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CancelDeploymentHas1$inboundSchema),
  z.lazy(() => CancelDeploymentHas2$inboundSchema),
]);

/** @internal */
export type CancelDeploymentRoutesHas$Outbound =
  | CancelDeploymentHas1$Outbound
  | CancelDeploymentHas2$Outbound;

/** @internal */
export const CancelDeploymentRoutesHas$outboundSchema: z.ZodType<
  CancelDeploymentRoutesHas$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRoutesHas
> = z.union([
  z.lazy(() => CancelDeploymentHas1$outboundSchema),
  z.lazy(() => CancelDeploymentHas2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutesHas$ {
  /** @deprecated use `CancelDeploymentRoutesHas$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutesHas$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutesHas$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutesHas$outboundSchema;
  /** @deprecated use `CancelDeploymentRoutesHas$Outbound` instead. */
  export type Outbound = CancelDeploymentRoutesHas$Outbound;
}

/** @internal */
export const CancelDeploymentMissingDeploymentsType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentMissingDeploymentsType> = z.nativeEnum(
    CancelDeploymentMissingDeploymentsType,
  );

/** @internal */
export const CancelDeploymentMissingDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentMissingDeploymentsType> =
    CancelDeploymentMissingDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentMissingDeploymentsType$ {
  /** @deprecated use `CancelDeploymentMissingDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentMissingDeploymentsType$inboundSchema;
  /** @deprecated use `CancelDeploymentMissingDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentMissingDeploymentsType$outboundSchema;
}

/** @internal */
export const CancelDeploymentMissing2$inboundSchema: z.ZodType<
  CancelDeploymentMissing2,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentMissingDeploymentsType$inboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/** @internal */
export type CancelDeploymentMissing2$Outbound = {
  type: string;
  key: string;
  value?: string | undefined;
};

/** @internal */
export const CancelDeploymentMissing2$outboundSchema: z.ZodType<
  CancelDeploymentMissing2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentMissing2
> = z.object({
  type: CancelDeploymentMissingDeploymentsType$outboundSchema,
  key: z.string(),
  value: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentMissing2$ {
  /** @deprecated use `CancelDeploymentMissing2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentMissing2$inboundSchema;
  /** @deprecated use `CancelDeploymentMissing2$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentMissing2$outboundSchema;
  /** @deprecated use `CancelDeploymentMissing2$Outbound` instead. */
  export type Outbound = CancelDeploymentMissing2$Outbound;
}

/** @internal */
export const CancelDeploymentMissingType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentMissingType
> = z.nativeEnum(CancelDeploymentMissingType);

/** @internal */
export const CancelDeploymentMissingType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentMissingType
> = CancelDeploymentMissingType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentMissingType$ {
  /** @deprecated use `CancelDeploymentMissingType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentMissingType$inboundSchema;
  /** @deprecated use `CancelDeploymentMissingType$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentMissingType$outboundSchema;
}

/** @internal */
export const CancelDeploymentMissing1$inboundSchema: z.ZodType<
  CancelDeploymentMissing1,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: CancelDeploymentMissingType$inboundSchema,
  value: z.string(),
});

/** @internal */
export type CancelDeploymentMissing1$Outbound = {
  type: string;
  value: string;
};

/** @internal */
export const CancelDeploymentMissing1$outboundSchema: z.ZodType<
  CancelDeploymentMissing1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentMissing1
> = z.object({
  type: CancelDeploymentMissingType$outboundSchema,
  value: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentMissing1$ {
  /** @deprecated use `CancelDeploymentMissing1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentMissing1$inboundSchema;
  /** @deprecated use `CancelDeploymentMissing1$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentMissing1$outboundSchema;
  /** @deprecated use `CancelDeploymentMissing1$Outbound` instead. */
  export type Outbound = CancelDeploymentMissing1$Outbound;
}

/** @internal */
export const CancelDeploymentRoutesMissing$inboundSchema: z.ZodType<
  CancelDeploymentRoutesMissing,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CancelDeploymentMissing1$inboundSchema),
  z.lazy(() => CancelDeploymentMissing2$inboundSchema),
]);

/** @internal */
export type CancelDeploymentRoutesMissing$Outbound =
  | CancelDeploymentMissing1$Outbound
  | CancelDeploymentMissing2$Outbound;

/** @internal */
export const CancelDeploymentRoutesMissing$outboundSchema: z.ZodType<
  CancelDeploymentRoutesMissing$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRoutesMissing
> = z.union([
  z.lazy(() => CancelDeploymentMissing1$outboundSchema),
  z.lazy(() => CancelDeploymentMissing2$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutesMissing$ {
  /** @deprecated use `CancelDeploymentRoutesMissing$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutesMissing$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutesMissing$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutesMissing$outboundSchema;
  /** @deprecated use `CancelDeploymentRoutesMissing$Outbound` instead. */
  export type Outbound = CancelDeploymentRoutesMissing$Outbound;
}

/** @internal */
export const RoutesLocale$inboundSchema: z.ZodType<
  RoutesLocale,
  z.ZodTypeDef,
  unknown
> = z.object({
  redirect: z.record(z.string()).optional(),
  cookie: z.string().optional(),
});

/** @internal */
export type RoutesLocale$Outbound = {
  redirect?: { [k: string]: string } | undefined;
  cookie?: string | undefined;
};

/** @internal */
export const RoutesLocale$outboundSchema: z.ZodType<
  RoutesLocale$Outbound,
  z.ZodTypeDef,
  RoutesLocale
> = z.object({
  redirect: z.record(z.string()).optional(),
  cookie: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RoutesLocale$ {
  /** @deprecated use `RoutesLocale$inboundSchema` instead. */
  export const inboundSchema = RoutesLocale$inboundSchema;
  /** @deprecated use `RoutesLocale$outboundSchema` instead. */
  export const outboundSchema = RoutesLocale$outboundSchema;
  /** @deprecated use `RoutesLocale$Outbound` instead. */
  export type Outbound = RoutesLocale$Outbound;
}

/** @internal */
export const CancelDeploymentRoutes1$inboundSchema: z.ZodType<
  CancelDeploymentRoutes1,
  z.ZodTypeDef,
  unknown
> = z.object({
  src: z.string(),
  dest: z.string().optional(),
  headers: z.record(z.string()).optional(),
  methods: z.array(z.string()).optional(),
  continue: z.boolean().optional(),
  override: z.boolean().optional(),
  caseSensitive: z.boolean().optional(),
  check: z.boolean().optional(),
  important: z.boolean().optional(),
  status: z.number().optional(),
  has: z.array(
    z.union([
      z.lazy(() => CancelDeploymentHas1$inboundSchema),
      z.lazy(() => CancelDeploymentHas2$inboundSchema),
    ]),
  ).optional(),
  missing: z.array(
    z.union([
      z.lazy(() => CancelDeploymentMissing1$inboundSchema),
      z.lazy(() => CancelDeploymentMissing2$inboundSchema),
    ]),
  ).optional(),
  locale: z.lazy(() => RoutesLocale$inboundSchema).optional(),
  middlewarePath: z.string().optional(),
  middlewareRawSrc: z.array(z.string()).optional(),
  middleware: z.number().optional(),
});

/** @internal */
export type CancelDeploymentRoutes1$Outbound = {
  src: string;
  dest?: string | undefined;
  headers?: { [k: string]: string } | undefined;
  methods?: Array<string> | undefined;
  continue?: boolean | undefined;
  override?: boolean | undefined;
  caseSensitive?: boolean | undefined;
  check?: boolean | undefined;
  important?: boolean | undefined;
  status?: number | undefined;
  has?:
    | Array<CancelDeploymentHas1$Outbound | CancelDeploymentHas2$Outbound>
    | undefined;
  missing?:
    | Array<
      CancelDeploymentMissing1$Outbound | CancelDeploymentMissing2$Outbound
    >
    | undefined;
  locale?: RoutesLocale$Outbound | undefined;
  middlewarePath?: string | undefined;
  middlewareRawSrc?: Array<string> | undefined;
  middleware?: number | undefined;
};

/** @internal */
export const CancelDeploymentRoutes1$outboundSchema: z.ZodType<
  CancelDeploymentRoutes1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRoutes1
> = z.object({
  src: z.string(),
  dest: z.string().optional(),
  headers: z.record(z.string()).optional(),
  methods: z.array(z.string()).optional(),
  continue: z.boolean().optional(),
  override: z.boolean().optional(),
  caseSensitive: z.boolean().optional(),
  check: z.boolean().optional(),
  important: z.boolean().optional(),
  status: z.number().optional(),
  has: z.array(
    z.union([
      z.lazy(() => CancelDeploymentHas1$outboundSchema),
      z.lazy(() => CancelDeploymentHas2$outboundSchema),
    ]),
  ).optional(),
  missing: z.array(
    z.union([
      z.lazy(() => CancelDeploymentMissing1$outboundSchema),
      z.lazy(() => CancelDeploymentMissing2$outboundSchema),
    ]),
  ).optional(),
  locale: z.lazy(() => RoutesLocale$outboundSchema).optional(),
  middlewarePath: z.string().optional(),
  middlewareRawSrc: z.array(z.string()).optional(),
  middleware: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutes1$ {
  /** @deprecated use `CancelDeploymentRoutes1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutes1$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutes1$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutes1$outboundSchema;
  /** @deprecated use `CancelDeploymentRoutes1$Outbound` instead. */
  export type Outbound = CancelDeploymentRoutes1$Outbound;
}

/** @internal */
export const CancelDeploymentRoutes$inboundSchema: z.ZodType<
  CancelDeploymentRoutes,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CancelDeploymentRoutes3$inboundSchema),
  z.lazy(() => CancelDeploymentRoutes2$inboundSchema),
  z.lazy(() => CancelDeploymentRoutes1$inboundSchema),
]);

/** @internal */
export type CancelDeploymentRoutes$Outbound =
  | CancelDeploymentRoutes3$Outbound
  | CancelDeploymentRoutes2$Outbound
  | CancelDeploymentRoutes1$Outbound;

/** @internal */
export const CancelDeploymentRoutes$outboundSchema: z.ZodType<
  CancelDeploymentRoutes$Outbound,
  z.ZodTypeDef,
  CancelDeploymentRoutes
> = z.union([
  z.lazy(() => CancelDeploymentRoutes3$outboundSchema),
  z.lazy(() => CancelDeploymentRoutes2$outboundSchema),
  z.lazy(() => CancelDeploymentRoutes1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentRoutes$ {
  /** @deprecated use `CancelDeploymentRoutes$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentRoutes$inboundSchema;
  /** @deprecated use `CancelDeploymentRoutes$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentRoutes$outboundSchema;
  /** @deprecated use `CancelDeploymentRoutes$Outbound` instead. */
  export type Outbound = CancelDeploymentRoutes$Outbound;
}

/** @internal */
export const CancelDeploymentGitRepoDeploymentsResponseType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsResponseType> = z
    .nativeEnum(CancelDeploymentGitRepoDeploymentsResponseType);

/** @internal */
export const CancelDeploymentGitRepoDeploymentsResponseType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsResponseType> =
    CancelDeploymentGitRepoDeploymentsResponseType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepoDeploymentsResponseType$ {
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsResponseType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitRepoDeploymentsResponseType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsResponseType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitRepoDeploymentsResponseType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsResponseOwnerType> =
    z.nativeEnum(CancelDeploymentGitRepoDeploymentsResponseOwnerType);

/** @internal */
export const CancelDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsResponseOwnerType> =
    CancelDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepoDeploymentsResponseOwnerType$ {
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitRepo3$inboundSchema: z.ZodType<
  CancelDeploymentGitRepo3,
  z.ZodTypeDef,
  unknown
> = z.object({
  owner: z.string(),
  repoUuid: z.string(),
  slug: z.string(),
  type: CancelDeploymentGitRepoDeploymentsResponseType$inboundSchema,
  workspaceUuid: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CancelDeploymentGitRepoDeploymentsResponseOwnerType$inboundSchema,
});

/** @internal */
export type CancelDeploymentGitRepo3$Outbound = {
  owner: string;
  repoUuid: string;
  slug: string;
  type: string;
  workspaceUuid: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const CancelDeploymentGitRepo3$outboundSchema: z.ZodType<
  CancelDeploymentGitRepo3$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitRepo3
> = z.object({
  owner: z.string(),
  repoUuid: z.string(),
  slug: z.string(),
  type: CancelDeploymentGitRepoDeploymentsResponseType$outboundSchema,
  workspaceUuid: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CancelDeploymentGitRepoDeploymentsResponseOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepo3$ {
  /** @deprecated use `CancelDeploymentGitRepo3$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitRepo3$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo3$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitRepo3$outboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo3$Outbound` instead. */
  export type Outbound = CancelDeploymentGitRepo3$Outbound;
}

/** @internal */
export const CancelDeploymentGitRepoDeploymentsType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsType> = z.nativeEnum(
    CancelDeploymentGitRepoDeploymentsType,
  );

/** @internal */
export const CancelDeploymentGitRepoDeploymentsType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsType> =
    CancelDeploymentGitRepoDeploymentsType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepoDeploymentsType$ {
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitRepoDeploymentsType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitRepoDeploymentsType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitRepoDeploymentsOwnerType$inboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsOwnerType> = z
    .nativeEnum(CancelDeploymentGitRepoDeploymentsOwnerType);

/** @internal */
export const CancelDeploymentGitRepoDeploymentsOwnerType$outboundSchema:
  z.ZodNativeEnum<typeof CancelDeploymentGitRepoDeploymentsOwnerType> =
    CancelDeploymentGitRepoDeploymentsOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepoDeploymentsOwnerType$ {
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsOwnerType$inboundSchema` instead. */
  export const inboundSchema =
    CancelDeploymentGitRepoDeploymentsOwnerType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepoDeploymentsOwnerType$outboundSchema` instead. */
  export const outboundSchema =
    CancelDeploymentGitRepoDeploymentsOwnerType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitRepo2$inboundSchema: z.ZodType<
  CancelDeploymentGitRepo2,
  z.ZodTypeDef,
  unknown
> = z.object({
  org: z.string(),
  repo: z.string(),
  repoId: z.number(),
  type: CancelDeploymentGitRepoDeploymentsType$inboundSchema,
  repoOwnerId: z.number(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CancelDeploymentGitRepoDeploymentsOwnerType$inboundSchema,
});

/** @internal */
export type CancelDeploymentGitRepo2$Outbound = {
  org: string;
  repo: string;
  repoId: number;
  type: string;
  repoOwnerId: number;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const CancelDeploymentGitRepo2$outboundSchema: z.ZodType<
  CancelDeploymentGitRepo2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitRepo2
> = z.object({
  org: z.string(),
  repo: z.string(),
  repoId: z.number(),
  type: CancelDeploymentGitRepoDeploymentsType$outboundSchema,
  repoOwnerId: z.number(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CancelDeploymentGitRepoDeploymentsOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepo2$ {
  /** @deprecated use `CancelDeploymentGitRepo2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitRepo2$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo2$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitRepo2$outboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo2$Outbound` instead. */
  export type Outbound = CancelDeploymentGitRepo2$Outbound;
}

/** @internal */
export const CancelDeploymentGitRepoType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentGitRepoType
> = z.nativeEnum(CancelDeploymentGitRepoType);

/** @internal */
export const CancelDeploymentGitRepoType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentGitRepoType
> = CancelDeploymentGitRepoType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepoType$ {
  /** @deprecated use `CancelDeploymentGitRepoType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitRepoType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepoType$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitRepoType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitRepoOwnerType$inboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentGitRepoOwnerType
> = z.nativeEnum(CancelDeploymentGitRepoOwnerType);

/** @internal */
export const CancelDeploymentGitRepoOwnerType$outboundSchema: z.ZodNativeEnum<
  typeof CancelDeploymentGitRepoOwnerType
> = CancelDeploymentGitRepoOwnerType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepoOwnerType$ {
  /** @deprecated use `CancelDeploymentGitRepoOwnerType$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitRepoOwnerType$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepoOwnerType$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitRepoOwnerType$outboundSchema;
}

/** @internal */
export const CancelDeploymentGitRepo1$inboundSchema: z.ZodType<
  CancelDeploymentGitRepo1,
  z.ZodTypeDef,
  unknown
> = z.object({
  namespace: z.string(),
  projectId: z.number(),
  type: CancelDeploymentGitRepoType$inboundSchema,
  url: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CancelDeploymentGitRepoOwnerType$inboundSchema,
});

/** @internal */
export type CancelDeploymentGitRepo1$Outbound = {
  namespace: string;
  projectId: number;
  type: string;
  url: string;
  path: string;
  defaultBranch: string;
  name: string;
  private: boolean;
  ownerType: string;
};

/** @internal */
export const CancelDeploymentGitRepo1$outboundSchema: z.ZodType<
  CancelDeploymentGitRepo1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitRepo1
> = z.object({
  namespace: z.string(),
  projectId: z.number(),
  type: CancelDeploymentGitRepoType$outboundSchema,
  url: z.string(),
  path: z.string(),
  defaultBranch: z.string(),
  name: z.string(),
  private: z.boolean(),
  ownerType: CancelDeploymentGitRepoOwnerType$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepo1$ {
  /** @deprecated use `CancelDeploymentGitRepo1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitRepo1$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo1$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitRepo1$outboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo1$Outbound` instead. */
  export type Outbound = CancelDeploymentGitRepo1$Outbound;
}

/** @internal */
export const CancelDeploymentGitRepo$inboundSchema: z.ZodType<
  CancelDeploymentGitRepo,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CancelDeploymentGitRepo1$inboundSchema),
  z.lazy(() => CancelDeploymentGitRepo2$inboundSchema),
  z.lazy(() => CancelDeploymentGitRepo3$inboundSchema),
]);

/** @internal */
export type CancelDeploymentGitRepo$Outbound =
  | CancelDeploymentGitRepo1$Outbound
  | CancelDeploymentGitRepo2$Outbound
  | CancelDeploymentGitRepo3$Outbound;

/** @internal */
export const CancelDeploymentGitRepo$outboundSchema: z.ZodType<
  CancelDeploymentGitRepo$Outbound,
  z.ZodTypeDef,
  CancelDeploymentGitRepo
> = z.union([
  z.lazy(() => CancelDeploymentGitRepo1$outboundSchema),
  z.lazy(() => CancelDeploymentGitRepo2$outboundSchema),
  z.lazy(() => CancelDeploymentGitRepo3$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentGitRepo$ {
  /** @deprecated use `CancelDeploymentGitRepo$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentGitRepo$inboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentGitRepo$outboundSchema;
  /** @deprecated use `CancelDeploymentGitRepo$Outbound` instead. */
  export type Outbound = CancelDeploymentGitRepo$Outbound;
}

/** @internal */
export const CancelDeploymentFlags2$inboundSchema: z.ZodType<
  CancelDeploymentFlags2,
  z.ZodTypeDef,
  unknown
> = z.object({});

/** @internal */
export type CancelDeploymentFlags2$Outbound = {};

/** @internal */
export const CancelDeploymentFlags2$outboundSchema: z.ZodType<
  CancelDeploymentFlags2$Outbound,
  z.ZodTypeDef,
  CancelDeploymentFlags2
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentFlags2$ {
  /** @deprecated use `CancelDeploymentFlags2$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentFlags2$inboundSchema;
  /** @deprecated use `CancelDeploymentFlags2$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentFlags2$outboundSchema;
  /** @deprecated use `CancelDeploymentFlags2$Outbound` instead. */
  export type Outbound = CancelDeploymentFlags2$Outbound;
}

/** @internal */
export const FlagsOptions$inboundSchema: z.ZodType<
  FlagsOptions,
  z.ZodTypeDef,
  unknown
> = z.object({
  value: z.nullable(FlagJSONValue$inboundSchema),
  label: z.string().optional(),
});

/** @internal */
export type FlagsOptions$Outbound = {
  value: FlagJSONValue$Outbound | null;
  label?: string | undefined;
};

/** @internal */
export const FlagsOptions$outboundSchema: z.ZodType<
  FlagsOptions$Outbound,
  z.ZodTypeDef,
  FlagsOptions
> = z.object({
  value: z.nullable(FlagJSONValue$outboundSchema),
  label: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FlagsOptions$ {
  /** @deprecated use `FlagsOptions$inboundSchema` instead. */
  export const inboundSchema = FlagsOptions$inboundSchema;
  /** @deprecated use `FlagsOptions$outboundSchema` instead. */
  export const outboundSchema = FlagsOptions$outboundSchema;
  /** @deprecated use `FlagsOptions$Outbound` instead. */
  export type Outbound = FlagsOptions$Outbound;
}

/** @internal */
export const CancelDeploymentFlagsDefinitions$inboundSchema: z.ZodType<
  CancelDeploymentFlagsDefinitions,
  z.ZodTypeDef,
  unknown
> = z.object({
  options: z.array(z.lazy(() => FlagsOptions$inboundSchema)).optional(),
  url: z.string().optional(),
  description: z.string().optional(),
});

/** @internal */
export type CancelDeploymentFlagsDefinitions$Outbound = {
  options?: Array<FlagsOptions$Outbound> | undefined;
  url?: string | undefined;
  description?: string | undefined;
};

/** @internal */
export const CancelDeploymentFlagsDefinitions$outboundSchema: z.ZodType<
  CancelDeploymentFlagsDefinitions$Outbound,
  z.ZodTypeDef,
  CancelDeploymentFlagsDefinitions
> = z.object({
  options: z.array(z.lazy(() => FlagsOptions$outboundSchema)).optional(),
  url: z.string().optional(),
  description: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentFlagsDefinitions$ {
  /** @deprecated use `CancelDeploymentFlagsDefinitions$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentFlagsDefinitions$inboundSchema;
  /** @deprecated use `CancelDeploymentFlagsDefinitions$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentFlagsDefinitions$outboundSchema;
  /** @deprecated use `CancelDeploymentFlagsDefinitions$Outbound` instead. */
  export type Outbound = CancelDeploymentFlagsDefinitions$Outbound;
}

/** @internal */
export const CancelDeploymentFlags1$inboundSchema: z.ZodType<
  CancelDeploymentFlags1,
  z.ZodTypeDef,
  unknown
> = z.object({
  definitions: z.record(
    z.lazy(() => CancelDeploymentFlagsDefinitions$inboundSchema),
  ),
});

/** @internal */
export type CancelDeploymentFlags1$Outbound = {
  definitions: { [k: string]: CancelDeploymentFlagsDefinitions$Outbound };
};

/** @internal */
export const CancelDeploymentFlags1$outboundSchema: z.ZodType<
  CancelDeploymentFlags1$Outbound,
  z.ZodTypeDef,
  CancelDeploymentFlags1
> = z.object({
  definitions: z.record(
    z.lazy(() => CancelDeploymentFlagsDefinitions$outboundSchema),
  ),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentFlags1$ {
  /** @deprecated use `CancelDeploymentFlags1$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentFlags1$inboundSchema;
  /** @deprecated use `CancelDeploymentFlags1$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentFlags1$outboundSchema;
  /** @deprecated use `CancelDeploymentFlags1$Outbound` instead. */
  export type Outbound = CancelDeploymentFlags1$Outbound;
}

/** @internal */
export const CancelDeploymentFlags$inboundSchema: z.ZodType<
  CancelDeploymentFlags,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => CancelDeploymentFlags1$inboundSchema),
  z.array(z.lazy(() => CancelDeploymentFlags2$inboundSchema)),
]);

/** @internal */
export type CancelDeploymentFlags$Outbound =
  | CancelDeploymentFlags1$Outbound
  | Array<CancelDeploymentFlags2$Outbound>;

/** @internal */
export const CancelDeploymentFlags$outboundSchema: z.ZodType<
  CancelDeploymentFlags$Outbound,
  z.ZodTypeDef,
  CancelDeploymentFlags
> = z.union([
  z.lazy(() => CancelDeploymentFlags1$outboundSchema),
  z.array(z.lazy(() => CancelDeploymentFlags2$outboundSchema)),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentFlags$ {
  /** @deprecated use `CancelDeploymentFlags$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentFlags$inboundSchema;
  /** @deprecated use `CancelDeploymentFlags$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentFlags$outboundSchema;
  /** @deprecated use `CancelDeploymentFlags$Outbound` instead. */
  export type Outbound = CancelDeploymentFlags$Outbound;
}

/** @internal */
export const CancelDeploymentResponseBody$inboundSchema: z.ZodType<
  CancelDeploymentResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  aliasAssignedAt: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  alwaysRefuseToBuild: z.boolean().optional(),
  build: z.lazy(() => CancelDeploymentBuild$inboundSchema),
  buildArtifactUrls: z.array(z.string()).optional(),
  builds: z.array(z.lazy(() => CancelDeploymentBuilds$inboundSchema))
    .optional(),
  env: z.array(z.string()),
  inspectorUrl: z.nullable(z.string()),
  isInConcurrentBuildsQueue: z.boolean(),
  isInSystemBuildsQueue: z.boolean(),
  projectSettings: z.lazy(() => CancelDeploymentProjectSettings$inboundSchema),
  readyStateReason: z.string().optional(),
  integrations: z.lazy(() => CancelDeploymentIntegrations$inboundSchema)
    .optional(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => CancelDeploymentCreator$inboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => CancelDeploymentLambdas$inboundSchema))
    .optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: CancelDeploymentStatus$inboundSchema,
  team: z.lazy(() => CancelDeploymentTeam$inboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => CancelDeploymentCustomEnvironment1$inboundSchema),
    z.lazy(() => CancelDeploymentCustomEnvironment2$inboundSchema),
  ]).optional(),
  id: z.string(),
  aliasError: z.nullable(z.lazy(() => CancelDeploymentAliasError$inboundSchema))
    .optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  aliasWarning: z.nullable(
    z.lazy(() => CancelDeploymentAliasWarning$inboundSchema),
  ).optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: CancelDeploymentChecksState$inboundSchema.optional(),
  checksConclusion: CancelDeploymentChecksConclusion$inboundSchema.optional(),
  createdAt: z.number(),
  deletedAt: z.nullable(z.number()).optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.nullable(z.string()).optional(),
  errorStep: z.string().optional(),
  passiveRegions: z.array(z.string()).optional(),
  gitSource: z.union([
    z.lazy(() => GitSource6$inboundSchema),
    z.lazy(() => GitSource8$inboundSchema),
    z.lazy(() => CancelDeploymentGitSource1$inboundSchema),
    z.lazy(() => CancelDeploymentGitSource3$inboundSchema),
    z.lazy(() => CancelDeploymentGitSource2$inboundSchema),
    z.lazy(() => CancelDeploymentGitSource4$inboundSchema),
    z.lazy(() => CancelDeploymentGitSource5$inboundSchema),
    z.lazy(() => GitSource7$inboundSchema),
    z.lazy(() => GitSource9$inboundSchema),
  ]).optional(),
  name: z.string(),
  meta: z.record(z.string()),
  project: z.lazy(() => CancelDeploymentProject$inboundSchema).optional(),
  readyState: CancelDeploymentReadyState$inboundSchema,
  readySubstate: CancelDeploymentReadySubstate$inboundSchema.optional(),
  regions: z.array(z.string()),
  softDeletedByRetention: z.boolean().optional(),
  source: CancelDeploymentSource$inboundSchema.optional(),
  target: z.nullable(CancelDeploymentTarget$inboundSchema).optional(),
  type: CancelDeploymentType$inboundSchema,
  undeletedAt: z.number().optional(),
  url: z.string(),
  version: z.number(),
  oidcTokenClaims: z.lazy(() => CancelDeploymentOidcTokenClaims$inboundSchema)
    .optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdIn: z.string(),
  crons: z.array(z.lazy(() => CancelDeploymentCrons$inboundSchema)).optional(),
  functions: z.nullable(
    z.record(z.lazy(() => CancelDeploymentFunctions$inboundSchema)),
  ).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  ownerId: z.string(),
  passiveConnectConfigurationId: z.string().optional(),
  plan: CancelDeploymentPlan$inboundSchema,
  projectId: z.string(),
  routes: z.nullable(
    z.array(z.union([
      z.lazy(() => CancelDeploymentRoutes3$inboundSchema),
      z.lazy(() =>
        CancelDeploymentRoutes2$inboundSchema
      ),
      z.lazy(() => CancelDeploymentRoutes1$inboundSchema),
    ])),
  ),
  gitRepo: z.nullable(
    z.union([
      z.lazy(() => CancelDeploymentGitRepo1$inboundSchema),
      z.lazy(() => CancelDeploymentGitRepo2$inboundSchema),
      z.lazy(() => CancelDeploymentGitRepo3$inboundSchema),
    ]),
  ).optional(),
  flags: z.union([
    z.lazy(() => CancelDeploymentFlags1$inboundSchema),
    z.array(z.lazy(() => CancelDeploymentFlags2$inboundSchema)),
  ]).optional(),
});

/** @internal */
export type CancelDeploymentResponseBody$Outbound = {
  aliasAssignedAt?: number | boolean | null | undefined;
  alwaysRefuseToBuild?: boolean | undefined;
  build: CancelDeploymentBuild$Outbound;
  buildArtifactUrls?: Array<string> | undefined;
  builds?: Array<CancelDeploymentBuilds$Outbound> | undefined;
  env: Array<string>;
  inspectorUrl: string | null;
  isInConcurrentBuildsQueue: boolean;
  isInSystemBuildsQueue: boolean;
  projectSettings: CancelDeploymentProjectSettings$Outbound;
  readyStateReason?: string | undefined;
  integrations?: CancelDeploymentIntegrations$Outbound | undefined;
  alias?: Array<string> | undefined;
  aliasAssigned: boolean;
  bootedAt: number;
  buildingAt: number;
  buildSkipped: boolean;
  creator: CancelDeploymentCreator$Outbound;
  initReadyAt?: number | undefined;
  isFirstBranchDeployment?: boolean | undefined;
  lambdas?: Array<CancelDeploymentLambdas$Outbound> | undefined;
  public: boolean;
  ready?: number | undefined;
  status: string;
  team?: CancelDeploymentTeam$Outbound | undefined;
  userAliases?: Array<string> | undefined;
  previewCommentsEnabled?: boolean | undefined;
  ttyBuildLogs?: boolean | undefined;
  customEnvironment?:
    | CancelDeploymentCustomEnvironment1$Outbound
    | CancelDeploymentCustomEnvironment2$Outbound
    | undefined;
  id: string;
  aliasError?: CancelDeploymentAliasError$Outbound | null | undefined;
  aliasFinal?: string | null | undefined;
  aliasWarning?: CancelDeploymentAliasWarning$Outbound | null | undefined;
  autoAssignCustomDomains?: boolean | undefined;
  automaticAliases?: Array<string> | undefined;
  buildErrorAt?: number | undefined;
  checksState?: string | undefined;
  checksConclusion?: string | undefined;
  createdAt: number;
  deletedAt?: number | null | undefined;
  defaultRoute?: string | undefined;
  canceledAt?: number | undefined;
  errorCode?: string | undefined;
  errorLink?: string | undefined;
  errorMessage?: string | null | undefined;
  errorStep?: string | undefined;
  passiveRegions?: Array<string> | undefined;
  gitSource?:
    | GitSource6$Outbound
    | GitSource8$Outbound
    | CancelDeploymentGitSource1$Outbound
    | CancelDeploymentGitSource3$Outbound
    | CancelDeploymentGitSource2$Outbound
    | CancelDeploymentGitSource4$Outbound
    | CancelDeploymentGitSource5$Outbound
    | GitSource7$Outbound
    | GitSource9$Outbound
    | undefined;
  name: string;
  meta: { [k: string]: string };
  project?: CancelDeploymentProject$Outbound | undefined;
  readyState: string;
  readySubstate?: string | undefined;
  regions: Array<string>;
  softDeletedByRetention?: boolean | undefined;
  source?: string | undefined;
  target?: string | null | undefined;
  type: string;
  undeletedAt?: number | undefined;
  url: string;
  version: number;
  oidcTokenClaims?: CancelDeploymentOidcTokenClaims$Outbound | undefined;
  connectBuildsEnabled?: boolean | undefined;
  connectConfigurationId?: string | undefined;
  createdIn: string;
  crons?: Array<CancelDeploymentCrons$Outbound> | undefined;
  functions?:
    | { [k: string]: CancelDeploymentFunctions$Outbound }
    | null
    | undefined;
  monorepoManager?: string | null | undefined;
  ownerId: string;
  passiveConnectConfigurationId?: string | undefined;
  plan: string;
  projectId: string;
  routes:
    | Array<
      | CancelDeploymentRoutes3$Outbound
      | CancelDeploymentRoutes2$Outbound
      | CancelDeploymentRoutes1$Outbound
    >
    | null;
  gitRepo?:
    | CancelDeploymentGitRepo1$Outbound
    | CancelDeploymentGitRepo2$Outbound
    | CancelDeploymentGitRepo3$Outbound
    | null
    | undefined;
  flags?:
    | CancelDeploymentFlags1$Outbound
    | Array<CancelDeploymentFlags2$Outbound>
    | undefined;
};

/** @internal */
export const CancelDeploymentResponseBody$outboundSchema: z.ZodType<
  CancelDeploymentResponseBody$Outbound,
  z.ZodTypeDef,
  CancelDeploymentResponseBody
> = z.object({
  aliasAssignedAt: z.nullable(z.union([z.number(), z.boolean()])).optional(),
  alwaysRefuseToBuild: z.boolean().optional(),
  build: z.lazy(() => CancelDeploymentBuild$outboundSchema),
  buildArtifactUrls: z.array(z.string()).optional(),
  builds: z.array(z.lazy(() => CancelDeploymentBuilds$outboundSchema))
    .optional(),
  env: z.array(z.string()),
  inspectorUrl: z.nullable(z.string()),
  isInConcurrentBuildsQueue: z.boolean(),
  isInSystemBuildsQueue: z.boolean(),
  projectSettings: z.lazy(() => CancelDeploymentProjectSettings$outboundSchema),
  readyStateReason: z.string().optional(),
  integrations: z.lazy(() => CancelDeploymentIntegrations$outboundSchema)
    .optional(),
  alias: z.array(z.string()).optional(),
  aliasAssigned: z.boolean(),
  bootedAt: z.number(),
  buildingAt: z.number(),
  buildSkipped: z.boolean(),
  creator: z.lazy(() => CancelDeploymentCreator$outboundSchema),
  initReadyAt: z.number().optional(),
  isFirstBranchDeployment: z.boolean().optional(),
  lambdas: z.array(z.lazy(() => CancelDeploymentLambdas$outboundSchema))
    .optional(),
  public: z.boolean(),
  ready: z.number().optional(),
  status: CancelDeploymentStatus$outboundSchema,
  team: z.lazy(() => CancelDeploymentTeam$outboundSchema).optional(),
  userAliases: z.array(z.string()).optional(),
  previewCommentsEnabled: z.boolean().optional(),
  ttyBuildLogs: z.boolean().optional(),
  customEnvironment: z.union([
    z.lazy(() => CancelDeploymentCustomEnvironment1$outboundSchema),
    z.lazy(() => CancelDeploymentCustomEnvironment2$outboundSchema),
  ]).optional(),
  id: z.string(),
  aliasError: z.nullable(
    z.lazy(() => CancelDeploymentAliasError$outboundSchema),
  ).optional(),
  aliasFinal: z.nullable(z.string()).optional(),
  aliasWarning: z.nullable(
    z.lazy(() => CancelDeploymentAliasWarning$outboundSchema),
  ).optional(),
  autoAssignCustomDomains: z.boolean().optional(),
  automaticAliases: z.array(z.string()).optional(),
  buildErrorAt: z.number().optional(),
  checksState: CancelDeploymentChecksState$outboundSchema.optional(),
  checksConclusion: CancelDeploymentChecksConclusion$outboundSchema.optional(),
  createdAt: z.number(),
  deletedAt: z.nullable(z.number()).optional(),
  defaultRoute: z.string().optional(),
  canceledAt: z.number().optional(),
  errorCode: z.string().optional(),
  errorLink: z.string().optional(),
  errorMessage: z.nullable(z.string()).optional(),
  errorStep: z.string().optional(),
  passiveRegions: z.array(z.string()).optional(),
  gitSource: z.union([
    z.lazy(() => GitSource6$outboundSchema),
    z.lazy(() => GitSource8$outboundSchema),
    z.lazy(() => CancelDeploymentGitSource1$outboundSchema),
    z.lazy(() => CancelDeploymentGitSource3$outboundSchema),
    z.lazy(() => CancelDeploymentGitSource2$outboundSchema),
    z.lazy(() => CancelDeploymentGitSource4$outboundSchema),
    z.lazy(() => CancelDeploymentGitSource5$outboundSchema),
    z.lazy(() => GitSource7$outboundSchema),
    z.lazy(() => GitSource9$outboundSchema),
  ]).optional(),
  name: z.string(),
  meta: z.record(z.string()),
  project: z.lazy(() => CancelDeploymentProject$outboundSchema).optional(),
  readyState: CancelDeploymentReadyState$outboundSchema,
  readySubstate: CancelDeploymentReadySubstate$outboundSchema.optional(),
  regions: z.array(z.string()),
  softDeletedByRetention: z.boolean().optional(),
  source: CancelDeploymentSource$outboundSchema.optional(),
  target: z.nullable(CancelDeploymentTarget$outboundSchema).optional(),
  type: CancelDeploymentType$outboundSchema,
  undeletedAt: z.number().optional(),
  url: z.string(),
  version: z.number(),
  oidcTokenClaims: z.lazy(() => CancelDeploymentOidcTokenClaims$outboundSchema)
    .optional(),
  connectBuildsEnabled: z.boolean().optional(),
  connectConfigurationId: z.string().optional(),
  createdIn: z.string(),
  crons: z.array(z.lazy(() => CancelDeploymentCrons$outboundSchema)).optional(),
  functions: z.nullable(
    z.record(z.lazy(() => CancelDeploymentFunctions$outboundSchema)),
  ).optional(),
  monorepoManager: z.nullable(z.string()).optional(),
  ownerId: z.string(),
  passiveConnectConfigurationId: z.string().optional(),
  plan: CancelDeploymentPlan$outboundSchema,
  projectId: z.string(),
  routes: z.nullable(
    z.array(z.union([
      z.lazy(() => CancelDeploymentRoutes3$outboundSchema),
      z.lazy(() =>
        CancelDeploymentRoutes2$outboundSchema
      ),
      z.lazy(() => CancelDeploymentRoutes1$outboundSchema),
    ])),
  ),
  gitRepo: z.nullable(
    z.union([
      z.lazy(() => CancelDeploymentGitRepo1$outboundSchema),
      z.lazy(() => CancelDeploymentGitRepo2$outboundSchema),
      z.lazy(() => CancelDeploymentGitRepo3$outboundSchema),
    ]),
  ).optional(),
  flags: z.union([
    z.lazy(() => CancelDeploymentFlags1$outboundSchema),
    z.array(z.lazy(() => CancelDeploymentFlags2$outboundSchema)),
  ]).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CancelDeploymentResponseBody$ {
  /** @deprecated use `CancelDeploymentResponseBody$inboundSchema` instead. */
  export const inboundSchema = CancelDeploymentResponseBody$inboundSchema;
  /** @deprecated use `CancelDeploymentResponseBody$outboundSchema` instead. */
  export const outboundSchema = CancelDeploymentResponseBody$outboundSchema;
  /** @deprecated use `CancelDeploymentResponseBody$Outbound` instead. */
  export type Outbound = CancelDeploymentResponseBody$Outbound;
}
