/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";

export type ArtifactQueryRequestBody = {
  /**
   * artifact hashes
   */
  hashes: Array<string>;
};

export type ArtifactQueryRequest = {
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?: ArtifactQueryRequestBody | undefined;
};

export type ErrorT = {
  message: string;
};

export type ResponseBody2 = {
  error: ErrorT;
};

export type ResponseBody1 = {
  size: number;
  taskDurationMs: number;
  tag?: string | undefined;
};

export type ResponseBody = ResponseBody2 | ResponseBody1;

/** @internal */
export const ArtifactQueryRequestBody$inboundSchema: z.ZodType<
  ArtifactQueryRequestBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  hashes: z.array(z.string()),
});

/** @internal */
export type ArtifactQueryRequestBody$Outbound = {
  hashes: Array<string>;
};

/** @internal */
export const ArtifactQueryRequestBody$outboundSchema: z.ZodType<
  ArtifactQueryRequestBody$Outbound,
  z.ZodTypeDef,
  ArtifactQueryRequestBody
> = z.object({
  hashes: z.array(z.string()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ArtifactQueryRequestBody$ {
  /** @deprecated use `ArtifactQueryRequestBody$inboundSchema` instead. */
  export const inboundSchema = ArtifactQueryRequestBody$inboundSchema;
  /** @deprecated use `ArtifactQueryRequestBody$outboundSchema` instead. */
  export const outboundSchema = ArtifactQueryRequestBody$outboundSchema;
  /** @deprecated use `ArtifactQueryRequestBody$Outbound` instead. */
  export type Outbound = ArtifactQueryRequestBody$Outbound;
}

/** @internal */
export const ArtifactQueryRequest$inboundSchema: z.ZodType<
  ArtifactQueryRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.lazy(() => ArtifactQueryRequestBody$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type ArtifactQueryRequest$Outbound = {
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?: ArtifactQueryRequestBody$Outbound | undefined;
};

/** @internal */
export const ArtifactQueryRequest$outboundSchema: z.ZodType<
  ArtifactQueryRequest$Outbound,
  z.ZodTypeDef,
  ArtifactQueryRequest
> = z.object({
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.lazy(() => ArtifactQueryRequestBody$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ArtifactQueryRequest$ {
  /** @deprecated use `ArtifactQueryRequest$inboundSchema` instead. */
  export const inboundSchema = ArtifactQueryRequest$inboundSchema;
  /** @deprecated use `ArtifactQueryRequest$outboundSchema` instead. */
  export const outboundSchema = ArtifactQueryRequest$outboundSchema;
  /** @deprecated use `ArtifactQueryRequest$Outbound` instead. */
  export type Outbound = ArtifactQueryRequest$Outbound;
}

/** @internal */
export const ErrorT$inboundSchema: z.ZodType<ErrorT, z.ZodTypeDef, unknown> = z
  .object({
    message: z.string(),
  });

/** @internal */
export type ErrorT$Outbound = {
  message: string;
};

/** @internal */
export const ErrorT$outboundSchema: z.ZodType<
  ErrorT$Outbound,
  z.ZodTypeDef,
  ErrorT
> = z.object({
  message: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ErrorT$ {
  /** @deprecated use `ErrorT$inboundSchema` instead. */
  export const inboundSchema = ErrorT$inboundSchema;
  /** @deprecated use `ErrorT$outboundSchema` instead. */
  export const outboundSchema = ErrorT$outboundSchema;
  /** @deprecated use `ErrorT$Outbound` instead. */
  export type Outbound = ErrorT$Outbound;
}

/** @internal */
export const ResponseBody2$inboundSchema: z.ZodType<
  ResponseBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  error: z.lazy(() => ErrorT$inboundSchema),
});

/** @internal */
export type ResponseBody2$Outbound = {
  error: ErrorT$Outbound;
};

/** @internal */
export const ResponseBody2$outboundSchema: z.ZodType<
  ResponseBody2$Outbound,
  z.ZodTypeDef,
  ResponseBody2
> = z.object({
  error: z.lazy(() => ErrorT$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBody2$ {
  /** @deprecated use `ResponseBody2$inboundSchema` instead. */
  export const inboundSchema = ResponseBody2$inboundSchema;
  /** @deprecated use `ResponseBody2$outboundSchema` instead. */
  export const outboundSchema = ResponseBody2$outboundSchema;
  /** @deprecated use `ResponseBody2$Outbound` instead. */
  export type Outbound = ResponseBody2$Outbound;
}

/** @internal */
export const ResponseBody1$inboundSchema: z.ZodType<
  ResponseBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  size: z.number(),
  taskDurationMs: z.number(),
  tag: z.string().optional(),
});

/** @internal */
export type ResponseBody1$Outbound = {
  size: number;
  taskDurationMs: number;
  tag?: string | undefined;
};

/** @internal */
export const ResponseBody1$outboundSchema: z.ZodType<
  ResponseBody1$Outbound,
  z.ZodTypeDef,
  ResponseBody1
> = z.object({
  size: z.number(),
  taskDurationMs: z.number(),
  tag: z.string().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBody1$ {
  /** @deprecated use `ResponseBody1$inboundSchema` instead. */
  export const inboundSchema = ResponseBody1$inboundSchema;
  /** @deprecated use `ResponseBody1$outboundSchema` instead. */
  export const outboundSchema = ResponseBody1$outboundSchema;
  /** @deprecated use `ResponseBody1$Outbound` instead. */
  export type Outbound = ResponseBody1$Outbound;
}

/** @internal */
export const ResponseBody$inboundSchema: z.ZodType<
  ResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => ResponseBody2$inboundSchema),
  z.lazy(() => ResponseBody1$inboundSchema),
]);

/** @internal */
export type ResponseBody$Outbound =
  | ResponseBody2$Outbound
  | ResponseBody1$Outbound;

/** @internal */
export const ResponseBody$outboundSchema: z.ZodType<
  ResponseBody$Outbound,
  z.ZodTypeDef,
  ResponseBody
> = z.union([
  z.lazy(() => ResponseBody2$outboundSchema),
  z.lazy(() => ResponseBody1$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBody$ {
  /** @deprecated use `ResponseBody$inboundSchema` instead. */
  export const inboundSchema = ResponseBody$inboundSchema;
  /** @deprecated use `ResponseBody$outboundSchema` instead. */
  export const outboundSchema = ResponseBody$outboundSchema;
  /** @deprecated use `ResponseBody$Outbound` instead. */
  export type Outbound = ResponseBody$Outbound;
}
