/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The project role of the member that will be added.
 */
export const AddProjectMemberRequestBodyProjectMembersRole = {
  Admin: "ADMIN",
  ProjectDeveloper: "PROJECT_DEVELOPER",
  ProjectViewer: "PROJECT_VIEWER",
} as const;
/**
 * The project role of the member that will be added.
 */
export type AddProjectMemberRequestBodyProjectMembersRole = ClosedEnum<
  typeof AddProjectMemberRequestBodyProjectMembersRole
>;

export type AddProjectMemberRequestBody3 = {
  /**
   * The ID of the team member that should be added to this project.
   */
  uid?: string | undefined;
  /**
   * The username of the team member that should be added to this project.
   */
  username?: string | undefined;
  /**
   * The email of the team member that should be added to this project.
   */
  email: string;
  /**
   * The project role of the member that will be added.
   */
  role: AddProjectMemberRequestBodyProjectMembersRole;
};

/**
 * The project role of the member that will be added.
 */
export const AddProjectMemberRequestBodyRole = {
  Admin: "ADMIN",
  ProjectDeveloper: "PROJECT_DEVELOPER",
  ProjectViewer: "PROJECT_VIEWER",
} as const;
/**
 * The project role of the member that will be added.
 */
export type AddProjectMemberRequestBodyRole = ClosedEnum<
  typeof AddProjectMemberRequestBodyRole
>;

export type AddProjectMemberRequestBody2 = {
  /**
   * The ID of the team member that should be added to this project.
   */
  uid?: string | undefined;
  /**
   * The username of the team member that should be added to this project.
   */
  username: string;
  /**
   * The email of the team member that should be added to this project.
   */
  email?: string | undefined;
  /**
   * The project role of the member that will be added.
   */
  role: AddProjectMemberRequestBodyRole;
};

/**
 * The project role of the member that will be added.
 */
export const RequestBodyRole = {
  Admin: "ADMIN",
  ProjectDeveloper: "PROJECT_DEVELOPER",
  ProjectViewer: "PROJECT_VIEWER",
} as const;
/**
 * The project role of the member that will be added.
 */
export type RequestBodyRole = ClosedEnum<typeof RequestBodyRole>;

export type AddProjectMemberRequestBody1 = {
  /**
   * The ID of the team member that should be added to this project.
   */
  uid: string;
  /**
   * The username of the team member that should be added to this project.
   */
  username?: string | undefined;
  /**
   * The email of the team member that should be added to this project.
   */
  email?: string | undefined;
  /**
   * The project role of the member that will be added.
   */
  role: RequestBodyRole;
};

export type AddProjectMemberRequestBody =
  | AddProjectMemberRequestBody1
  | AddProjectMemberRequestBody2
  | AddProjectMemberRequestBody3;

export type AddProjectMemberRequest = {
  /**
   * The ID or name of the Project.
   */
  idOrName: string;
  /**
   * The Team identifier to perform the request on behalf of.
   */
  teamId?: string | undefined;
  /**
   * The Team slug to perform the request on behalf of.
   */
  slug?: string | undefined;
  requestBody?:
    | AddProjectMemberRequestBody1
    | AddProjectMemberRequestBody2
    | AddProjectMemberRequestBody3
    | undefined;
};

/**
 * Responds with the project ID on success.
 */
export type AddProjectMemberResponseBody = {
  id: string;
};

/** @internal */
export const AddProjectMemberRequestBodyProjectMembersRole$inboundSchema:
  z.ZodNativeEnum<typeof AddProjectMemberRequestBodyProjectMembersRole> = z
    .nativeEnum(AddProjectMemberRequestBodyProjectMembersRole);

/** @internal */
export const AddProjectMemberRequestBodyProjectMembersRole$outboundSchema:
  z.ZodNativeEnum<typeof AddProjectMemberRequestBodyProjectMembersRole> =
    AddProjectMemberRequestBodyProjectMembersRole$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequestBodyProjectMembersRole$ {
  /** @deprecated use `AddProjectMemberRequestBodyProjectMembersRole$inboundSchema` instead. */
  export const inboundSchema =
    AddProjectMemberRequestBodyProjectMembersRole$inboundSchema;
  /** @deprecated use `AddProjectMemberRequestBodyProjectMembersRole$outboundSchema` instead. */
  export const outboundSchema =
    AddProjectMemberRequestBodyProjectMembersRole$outboundSchema;
}

/** @internal */
export const AddProjectMemberRequestBody3$inboundSchema: z.ZodType<
  AddProjectMemberRequestBody3,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string().optional(),
  username: z.string().optional(),
  email: z.string(),
  role: AddProjectMemberRequestBodyProjectMembersRole$inboundSchema,
});

/** @internal */
export type AddProjectMemberRequestBody3$Outbound = {
  uid?: string | undefined;
  username?: string | undefined;
  email: string;
  role: string;
};

/** @internal */
export const AddProjectMemberRequestBody3$outboundSchema: z.ZodType<
  AddProjectMemberRequestBody3$Outbound,
  z.ZodTypeDef,
  AddProjectMemberRequestBody3
> = z.object({
  uid: z.string().optional(),
  username: z.string().optional(),
  email: z.string(),
  role: AddProjectMemberRequestBodyProjectMembersRole$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequestBody3$ {
  /** @deprecated use `AddProjectMemberRequestBody3$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberRequestBody3$inboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody3$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberRequestBody3$outboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody3$Outbound` instead. */
  export type Outbound = AddProjectMemberRequestBody3$Outbound;
}

/** @internal */
export const AddProjectMemberRequestBodyRole$inboundSchema: z.ZodNativeEnum<
  typeof AddProjectMemberRequestBodyRole
> = z.nativeEnum(AddProjectMemberRequestBodyRole);

/** @internal */
export const AddProjectMemberRequestBodyRole$outboundSchema: z.ZodNativeEnum<
  typeof AddProjectMemberRequestBodyRole
> = AddProjectMemberRequestBodyRole$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequestBodyRole$ {
  /** @deprecated use `AddProjectMemberRequestBodyRole$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberRequestBodyRole$inboundSchema;
  /** @deprecated use `AddProjectMemberRequestBodyRole$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberRequestBodyRole$outboundSchema;
}

/** @internal */
export const AddProjectMemberRequestBody2$inboundSchema: z.ZodType<
  AddProjectMemberRequestBody2,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string().optional(),
  username: z.string(),
  email: z.string().optional(),
  role: AddProjectMemberRequestBodyRole$inboundSchema,
});

/** @internal */
export type AddProjectMemberRequestBody2$Outbound = {
  uid?: string | undefined;
  username: string;
  email?: string | undefined;
  role: string;
};

/** @internal */
export const AddProjectMemberRequestBody2$outboundSchema: z.ZodType<
  AddProjectMemberRequestBody2$Outbound,
  z.ZodTypeDef,
  AddProjectMemberRequestBody2
> = z.object({
  uid: z.string().optional(),
  username: z.string(),
  email: z.string().optional(),
  role: AddProjectMemberRequestBodyRole$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequestBody2$ {
  /** @deprecated use `AddProjectMemberRequestBody2$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberRequestBody2$inboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody2$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberRequestBody2$outboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody2$Outbound` instead. */
  export type Outbound = AddProjectMemberRequestBody2$Outbound;
}

/** @internal */
export const RequestBodyRole$inboundSchema: z.ZodNativeEnum<
  typeof RequestBodyRole
> = z.nativeEnum(RequestBodyRole);

/** @internal */
export const RequestBodyRole$outboundSchema: z.ZodNativeEnum<
  typeof RequestBodyRole
> = RequestBodyRole$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RequestBodyRole$ {
  /** @deprecated use `RequestBodyRole$inboundSchema` instead. */
  export const inboundSchema = RequestBodyRole$inboundSchema;
  /** @deprecated use `RequestBodyRole$outboundSchema` instead. */
  export const outboundSchema = RequestBodyRole$outboundSchema;
}

/** @internal */
export const AddProjectMemberRequestBody1$inboundSchema: z.ZodType<
  AddProjectMemberRequestBody1,
  z.ZodTypeDef,
  unknown
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  email: z.string().optional(),
  role: RequestBodyRole$inboundSchema,
});

/** @internal */
export type AddProjectMemberRequestBody1$Outbound = {
  uid: string;
  username?: string | undefined;
  email?: string | undefined;
  role: string;
};

/** @internal */
export const AddProjectMemberRequestBody1$outboundSchema: z.ZodType<
  AddProjectMemberRequestBody1$Outbound,
  z.ZodTypeDef,
  AddProjectMemberRequestBody1
> = z.object({
  uid: z.string(),
  username: z.string().optional(),
  email: z.string().optional(),
  role: RequestBodyRole$outboundSchema,
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequestBody1$ {
  /** @deprecated use `AddProjectMemberRequestBody1$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberRequestBody1$inboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody1$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberRequestBody1$outboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody1$Outbound` instead. */
  export type Outbound = AddProjectMemberRequestBody1$Outbound;
}

/** @internal */
export const AddProjectMemberRequestBody$inboundSchema: z.ZodType<
  AddProjectMemberRequestBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  z.lazy(() => AddProjectMemberRequestBody1$inboundSchema),
  z.lazy(() => AddProjectMemberRequestBody2$inboundSchema),
  z.lazy(() => AddProjectMemberRequestBody3$inboundSchema),
]);

/** @internal */
export type AddProjectMemberRequestBody$Outbound =
  | AddProjectMemberRequestBody1$Outbound
  | AddProjectMemberRequestBody2$Outbound
  | AddProjectMemberRequestBody3$Outbound;

/** @internal */
export const AddProjectMemberRequestBody$outboundSchema: z.ZodType<
  AddProjectMemberRequestBody$Outbound,
  z.ZodTypeDef,
  AddProjectMemberRequestBody
> = z.union([
  z.lazy(() => AddProjectMemberRequestBody1$outboundSchema),
  z.lazy(() => AddProjectMemberRequestBody2$outboundSchema),
  z.lazy(() => AddProjectMemberRequestBody3$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequestBody$ {
  /** @deprecated use `AddProjectMemberRequestBody$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberRequestBody$inboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberRequestBody$outboundSchema;
  /** @deprecated use `AddProjectMemberRequestBody$Outbound` instead. */
  export type Outbound = AddProjectMemberRequestBody$Outbound;
}

/** @internal */
export const AddProjectMemberRequest$inboundSchema: z.ZodType<
  AddProjectMemberRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  idOrName: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  RequestBody: z.union([
    z.lazy(() => AddProjectMemberRequestBody1$inboundSchema),
    z.lazy(() => AddProjectMemberRequestBody2$inboundSchema),
    z.lazy(() => AddProjectMemberRequestBody3$inboundSchema),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    "RequestBody": "requestBody",
  });
});

/** @internal */
export type AddProjectMemberRequest$Outbound = {
  idOrName: string;
  teamId?: string | undefined;
  slug?: string | undefined;
  RequestBody?:
    | AddProjectMemberRequestBody1$Outbound
    | AddProjectMemberRequestBody2$Outbound
    | AddProjectMemberRequestBody3$Outbound
    | undefined;
};

/** @internal */
export const AddProjectMemberRequest$outboundSchema: z.ZodType<
  AddProjectMemberRequest$Outbound,
  z.ZodTypeDef,
  AddProjectMemberRequest
> = z.object({
  idOrName: z.string(),
  teamId: z.string().optional(),
  slug: z.string().optional(),
  requestBody: z.union([
    z.lazy(() => AddProjectMemberRequestBody1$outboundSchema),
    z.lazy(() => AddProjectMemberRequestBody2$outboundSchema),
    z.lazy(() => AddProjectMemberRequestBody3$outboundSchema),
  ]).optional(),
}).transform((v) => {
  return remap$(v, {
    requestBody: "RequestBody",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberRequest$ {
  /** @deprecated use `AddProjectMemberRequest$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberRequest$inboundSchema;
  /** @deprecated use `AddProjectMemberRequest$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberRequest$outboundSchema;
  /** @deprecated use `AddProjectMemberRequest$Outbound` instead. */
  export type Outbound = AddProjectMemberRequest$Outbound;
}

/** @internal */
export const AddProjectMemberResponseBody$inboundSchema: z.ZodType<
  AddProjectMemberResponseBody,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
});

/** @internal */
export type AddProjectMemberResponseBody$Outbound = {
  id: string;
};

/** @internal */
export const AddProjectMemberResponseBody$outboundSchema: z.ZodType<
  AddProjectMemberResponseBody$Outbound,
  z.ZodTypeDef,
  AddProjectMemberResponseBody
> = z.object({
  id: z.string(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AddProjectMemberResponseBody$ {
  /** @deprecated use `AddProjectMemberResponseBody$inboundSchema` instead. */
  export const inboundSchema = AddProjectMemberResponseBody$inboundSchema;
  /** @deprecated use `AddProjectMemberResponseBody$outboundSchema` instead. */
  export const outboundSchema = AddProjectMemberResponseBody$outboundSchema;
  /** @deprecated use `AddProjectMemberResponseBody$Outbound` instead. */
  export type Outbound = AddProjectMemberResponseBody$Outbound;
}
