/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

/**
 * The user's version. Will either be unset or `northstar`.
 */
export const AuthUserLimitedVersion = {
  Northstar: "northstar",
} as const;
/**
 * The user's version. Will either be unset or `northstar`.
 */
export type AuthUserLimitedVersion = ClosedEnum<typeof AuthUserLimitedVersion>;

/**
 * A limited form of data for the currently authenticated User, due to the authentication token missing privileges to read the full User data.
 */
export type AuthUserLimited = {
  /**
   * Property indicating that this User data contains only limited information, due to the authentication token missing privileges to read the full User data. Re-login with email, GitHub, GitLab or Bitbucket in order to upgrade the authentication token with the necessary privileges.
   */
  limited: boolean;
  /**
   * The User's unique identifier.
   */
  id: string;
  /**
   * Email address associated with the User account.
   */
  email: string;
  /**
   * Name associated with the User account, or `null` if none has been provided.
   */
  name: string | null;
  /**
   * Unique username associated with the User account.
   */
  username: string;
  /**
   * SHA1 hash of the avatar for the User account. Can be used in conjuction with the ... endpoint to retrieve the avatar image.
   */
  avatar: string | null;
  /**
   * The user's default team. Only applies if the user's `version` is `'northstar'`.
   */
  defaultTeamId: string | null;
  /**
   * The user's version. Will either be unset or `northstar`.
   */
  version: AuthUserLimitedVersion | null;
};

/** @internal */
export const AuthUserLimitedVersion$inboundSchema: z.ZodNativeEnum<
  typeof AuthUserLimitedVersion
> = z.nativeEnum(AuthUserLimitedVersion);

/** @internal */
export const AuthUserLimitedVersion$outboundSchema: z.ZodNativeEnum<
  typeof AuthUserLimitedVersion
> = AuthUserLimitedVersion$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AuthUserLimitedVersion$ {
  /** @deprecated use `AuthUserLimitedVersion$inboundSchema` instead. */
  export const inboundSchema = AuthUserLimitedVersion$inboundSchema;
  /** @deprecated use `AuthUserLimitedVersion$outboundSchema` instead. */
  export const outboundSchema = AuthUserLimitedVersion$outboundSchema;
}

/** @internal */
export const AuthUserLimited$inboundSchema: z.ZodType<
  AuthUserLimited,
  z.ZodTypeDef,
  unknown
> = z.object({
  limited: z.boolean(),
  id: z.string(),
  email: z.string(),
  name: z.nullable(z.string()),
  username: z.string(),
  avatar: z.nullable(z.string()),
  defaultTeamId: z.nullable(z.string()),
  version: z.nullable(AuthUserLimitedVersion$inboundSchema),
});

/** @internal */
export type AuthUserLimited$Outbound = {
  limited: boolean;
  id: string;
  email: string;
  name: string | null;
  username: string;
  avatar: string | null;
  defaultTeamId: string | null;
  version: string | null;
};

/** @internal */
export const AuthUserLimited$outboundSchema: z.ZodType<
  AuthUserLimited$Outbound,
  z.ZodTypeDef,
  AuthUserLimited
> = z.object({
  limited: z.boolean(),
  id: z.string(),
  email: z.string(),
  name: z.nullable(z.string()),
  username: z.string(),
  avatar: z.nullable(z.string()),
  defaultTeamId: z.nullable(z.string()),
  version: z.nullable(AuthUserLimitedVersion$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AuthUserLimited$ {
  /** @deprecated use `AuthUserLimited$inboundSchema` instead. */
  export const inboundSchema = AuthUserLimited$inboundSchema;
  /** @deprecated use `AuthUserLimited$outboundSchema` instead. */
  export const outboundSchema = AuthUserLimited$outboundSchema;
  /** @deprecated use `AuthUserLimited$Outbound` instead. */
  export type Outbound = AuthUserLimited$Outbound;
}
