/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { ClosedEnum } from "../../types/enums.js";

export const Reason = {
  SubscriptionCanceled: "SUBSCRIPTION_CANCELED",
  SubscriptionExpired: "SUBSCRIPTION_EXPIRED",
  UnpaidInvoice: "UNPAID_INVOICE",
  EnterpriseTrialEnded: "ENTERPRISE_TRIAL_ENDED",
  FairUseLimitsExceeded: "FAIR_USE_LIMITS_EXCEEDED",
  BlockedForPlatformAbuse: "BLOCKED_FOR_PLATFORM_ABUSE",
} as const;
export type Reason = ClosedEnum<typeof Reason>;

export const BlockedDueToOverageType = {
  AnalyticsUsage: "analyticsUsage",
  Artifacts: "artifacts",
  Bandwidth: "bandwidth",
  BlobStores: "blobStores",
  BlobTotalAdvancedRequests: "blobTotalAdvancedRequests",
  BlobTotalAvgSizeInBytes: "blobTotalAvgSizeInBytes",
  BlobTotalGetResponseObjectSizeInBytes:
    "blobTotalGetResponseObjectSizeInBytes",
  BlobTotalSimpleRequests: "blobTotalSimpleRequests",
  BuildMinute: "buildMinute",
  DataCacheRead: "dataCacheRead",
  DataCacheRevalidation: "dataCacheRevalidation",
  DataCacheWrite: "dataCacheWrite",
  EdgeConfigRead: "edgeConfigRead",
  EdgeConfigWrite: "edgeConfigWrite",
  EdgeFunctionExecutionUnits: "edgeFunctionExecutionUnits",
  EdgeMiddlewareInvocations: "edgeMiddlewareInvocations",
  EdgeRequest: "edgeRequest",
  EdgeRequestAdditionalCpuDuration: "edgeRequestAdditionalCpuDuration",
  FastDataTransfer: "fastDataTransfer",
  FastOriginTransfer: "fastOriginTransfer",
  FunctionDuration: "functionDuration",
  FunctionInvocation: "functionInvocation",
  LogDrainsVolume: "logDrainsVolume",
  MonitoringMetric: "monitoringMetric",
  PostgresComputeTime: "postgresComputeTime",
  PostgresDataStorage: "postgresDataStorage",
  PostgresDataTransfer: "postgresDataTransfer",
  PostgresDatabase: "postgresDatabase",
  PostgresWrittenData: "postgresWrittenData",
  ServerlessFunctionExecution: "serverlessFunctionExecution",
  SourceImages: "sourceImages",
  StorageRedisTotalBandwidthInBytes: "storageRedisTotalBandwidthInBytes",
  StorageRedisTotalCommands: "storageRedisTotalCommands",
  StorageRedisTotalDailyAvgStorageInBytes:
    "storageRedisTotalDailyAvgStorageInBytes",
  StorageRedisTotalDatabases: "storageRedisTotalDatabases",
  WafOwaspExcessBytes: "wafOwaspExcessBytes",
  WafOwaspRequests: "wafOwaspRequests",
  WafRateLimitRequest: "wafRateLimitRequest",
  WebAnalyticsEvent: "webAnalyticsEvent",
} as const;
export type BlockedDueToOverageType = ClosedEnum<
  typeof BlockedDueToOverageType
>;

/**
 * When the User account has been "soft blocked", this property will contain the date when the restriction was enacted, and the identifier for why.
 */
export type SoftBlock = {
  blockedAt: number;
  reason: Reason;
  blockedDueToOverageType?: BlockedDueToOverageType | undefined;
};

/**
 * An object containing billing infomation associated with the User account.
 */
export type Billing = {};

/**
 * An object containing infomation related to the amount of platform resources may be allocated to the User account.
 */
export type ResourceConfig = {
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  blobStores?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  nodeType?: string | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  concurrentBuilds?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  awsAccountType?: string | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  awsAccountIds?: Array<string> | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  cfZoneName?: string | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  imageOptimizationType?: string | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  edgeConfigs?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  edgeConfigSize?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  edgeFunctionMaxSizeBytes?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  edgeFunctionExecutionTimeoutMs?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  serverlessFunctionDefaultMaxExecutionTime?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  kvDatabases?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  postgresDatabases?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  integrationStores?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  cronJobs?: number | undefined;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  cronJobsPerProject?: number | undefined;
};

export const ViewPreference = {
  List: "list",
  Cards: "cards",
} as const;
export type ViewPreference = ClosedEnum<typeof ViewPreference>;

export const FavoritesViewPreference = {
  Open: "open",
  Closed: "closed",
} as const;
export type FavoritesViewPreference = ClosedEnum<
  typeof FavoritesViewPreference
>;

export const RecentsViewPreference = {
  Open: "open",
  Closed: "closed",
} as const;
export type RecentsViewPreference = ClosedEnum<typeof RecentsViewPreference>;

/**
 * set of dashboard view preferences (cards or list) per scopeId
 */
export type ActiveDashboardViews = {
  scopeId: string;
  viewPreference?: ViewPreference | undefined;
  favoritesViewPreference?: FavoritesViewPreference | undefined;
  recentsViewPreference?: RecentsViewPreference | undefined;
};

export type ImportFlowGitNamespace = string | number;

export type ImportFlowGitNamespaceId = string | number;

export const ImportFlowGitProvider = {
  Github: "github",
  Gitlab: "gitlab",
  Bitbucket: "bitbucket",
} as const;
export type ImportFlowGitProvider = ClosedEnum<typeof ImportFlowGitProvider>;

export type GitNamespaceId = string | number;

export type PreferredScopesAndGitNamespaces = {
  scopeId: string;
  gitNamespaceId: string | number | null;
};

export type Dismissals = {
  scopeId: string;
  createdAt: number;
};

/**
 * A record of when, under a certain scopeId, a toast was dismissed
 */
export type DismissedToasts = {
  name: string;
  dismissals: Array<Dismissals>;
};

/**
 * A list of projects and spaces across teams that a user has marked as a favorite.
 */
export type Two = {
  spaceId: string;
  scopeSlug: string;
  scopeId: string;
};

/**
 * A list of projects and spaces across teams that a user has marked as a favorite.
 */
export type One = {
  projectId: string;
  scopeSlug: string;
  scopeId: string;
};

export type FavoriteProjectsAndSpaces = One | Two;

/**
 * remote caching settings
 */
export type RemoteCaching = {
  enabled?: boolean | undefined;
};

/**
 * data cache settings
 */
export type DataCache = {
  excessBillingEnabled?: boolean | undefined;
};

export type WebAnalytics = {
  blockedFrom?: number | undefined;
  blockedUntil?: number | undefined;
  isCurrentlyBlocked: boolean;
};

/**
 * Feature blocks for the user
 */
export type FeatureBlocks = {
  webAnalytics?: WebAnalytics | undefined;
};

export type NorthstarMigration = {
  /**
   * The ID of the team we created for this user.
   */
  teamId: string;
  /**
   * The number of projects migrated for this user.
   */
  projects: number;
  /**
   * The number of stores migrated for this user.
   */
  stores: number;
  /**
   * The number of integration configurations migrated for this user.
   */
  integrationConfigurations: number;
  /**
   * The number of integration clients migrated for this user.
   */
  integrationClients: number;
  /**
   * The migration start time timestamp for this user.
   */
  startTime: number;
  /**
   * The migration end time timestamp for this user.
   */
  endTime: number;
};

/**
 * The user's version. Will either be unset or `northstar`.
 */
export const Version = {
  Northstar: "northstar",
} as const;
/**
 * The user's version. Will either be unset or `northstar`.
 */
export type Version = ClosedEnum<typeof Version>;

/**
 * Data for the currently authenticated User.
 */
export type AuthUser = {
  /**
   * UNIX timestamp (in milliseconds) when the User account was created.
   */
  createdAt: number;
  /**
   * When the User account has been "soft blocked", this property will contain the date when the restriction was enacted, and the identifier for why.
   */
  softBlock: SoftBlock | null;
  /**
   * An object containing billing infomation associated with the User account.
   */
  billing: Billing | null;
  /**
   * An object containing infomation related to the amount of platform resources may be allocated to the User account.
   */
  resourceConfig: ResourceConfig;
  /**
   * Prefix that will be used in the URL of "Preview" deployments created by the User account.
   */
  stagingPrefix: string;
  /**
   * set of dashboard view preferences (cards or list) per scopeId
   */
  activeDashboardViews?: Array<ActiveDashboardViews> | undefined;
  importFlowGitNamespace?: string | number | null | undefined;
  importFlowGitNamespaceId?: string | number | null | undefined;
  importFlowGitProvider?: ImportFlowGitProvider | undefined;
  preferredScopesAndGitNamespaces?:
    | Array<PreferredScopesAndGitNamespaces>
    | undefined;
  /**
   * A record of when, under a certain scopeId, a toast was dismissed
   */
  dismissedToasts?: Array<DismissedToasts> | undefined;
  /**
   * A list of projects and spaces across teams that a user has marked as a favorite.
   */
  favoriteProjectsAndSpaces?: Array<One | Two> | undefined;
  /**
   * Whether the user has a trial available for a paid plan subscription.
   */
  hasTrialAvailable: boolean;
  /**
   * remote caching settings
   */
  remoteCaching?: RemoteCaching | undefined;
  /**
   * data cache settings
   */
  dataCache?: DataCache | undefined;
  /**
   * Feature blocks for the user
   */
  featureBlocks?: FeatureBlocks | undefined;
  northstarMigration?: NorthstarMigration | undefined;
  /**
   * The User's unique identifier.
   */
  id: string;
  /**
   * Email address associated with the User account.
   */
  email: string;
  /**
   * Name associated with the User account, or `null` if none has been provided.
   */
  name: string | null;
  /**
   * Unique username associated with the User account.
   */
  username: string;
  /**
   * SHA1 hash of the avatar for the User account. Can be used in conjuction with the ... endpoint to retrieve the avatar image.
   */
  avatar: string | null;
  /**
   * The user's default team. Only applies if the user's `version` is `'northstar'`.
   */
  defaultTeamId: string | null;
  /**
   * The user's version. Will either be unset or `northstar`.
   */
  version: Version | null;
};

/** @internal */
export const Reason$inboundSchema: z.ZodNativeEnum<typeof Reason> = z
  .nativeEnum(Reason);

/** @internal */
export const Reason$outboundSchema: z.ZodNativeEnum<typeof Reason> =
  Reason$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Reason$ {
  /** @deprecated use `Reason$inboundSchema` instead. */
  export const inboundSchema = Reason$inboundSchema;
  /** @deprecated use `Reason$outboundSchema` instead. */
  export const outboundSchema = Reason$outboundSchema;
}

/** @internal */
export const BlockedDueToOverageType$inboundSchema: z.ZodNativeEnum<
  typeof BlockedDueToOverageType
> = z.nativeEnum(BlockedDueToOverageType);

/** @internal */
export const BlockedDueToOverageType$outboundSchema: z.ZodNativeEnum<
  typeof BlockedDueToOverageType
> = BlockedDueToOverageType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BlockedDueToOverageType$ {
  /** @deprecated use `BlockedDueToOverageType$inboundSchema` instead. */
  export const inboundSchema = BlockedDueToOverageType$inboundSchema;
  /** @deprecated use `BlockedDueToOverageType$outboundSchema` instead. */
  export const outboundSchema = BlockedDueToOverageType$outboundSchema;
}

/** @internal */
export const SoftBlock$inboundSchema: z.ZodType<
  SoftBlock,
  z.ZodTypeDef,
  unknown
> = z.object({
  blockedAt: z.number(),
  reason: Reason$inboundSchema,
  blockedDueToOverageType: BlockedDueToOverageType$inboundSchema.optional(),
});

/** @internal */
export type SoftBlock$Outbound = {
  blockedAt: number;
  reason: string;
  blockedDueToOverageType?: string | undefined;
};

/** @internal */
export const SoftBlock$outboundSchema: z.ZodType<
  SoftBlock$Outbound,
  z.ZodTypeDef,
  SoftBlock
> = z.object({
  blockedAt: z.number(),
  reason: Reason$outboundSchema,
  blockedDueToOverageType: BlockedDueToOverageType$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace SoftBlock$ {
  /** @deprecated use `SoftBlock$inboundSchema` instead. */
  export const inboundSchema = SoftBlock$inboundSchema;
  /** @deprecated use `SoftBlock$outboundSchema` instead. */
  export const outboundSchema = SoftBlock$outboundSchema;
  /** @deprecated use `SoftBlock$Outbound` instead. */
  export type Outbound = SoftBlock$Outbound;
}

/** @internal */
export const Billing$inboundSchema: z.ZodType<Billing, z.ZodTypeDef, unknown> =
  z.object({});

/** @internal */
export type Billing$Outbound = {};

/** @internal */
export const Billing$outboundSchema: z.ZodType<
  Billing$Outbound,
  z.ZodTypeDef,
  Billing
> = z.object({});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Billing$ {
  /** @deprecated use `Billing$inboundSchema` instead. */
  export const inboundSchema = Billing$inboundSchema;
  /** @deprecated use `Billing$outboundSchema` instead. */
  export const outboundSchema = Billing$outboundSchema;
  /** @deprecated use `Billing$Outbound` instead. */
  export type Outbound = Billing$Outbound;
}

/** @internal */
export const ResourceConfig$inboundSchema: z.ZodType<
  ResourceConfig,
  z.ZodTypeDef,
  unknown
> = z.object({
  blobStores: z.number().optional(),
  nodeType: z.string().optional(),
  concurrentBuilds: z.number().optional(),
  awsAccountType: z.string().optional(),
  awsAccountIds: z.array(z.string()).optional(),
  cfZoneName: z.string().optional(),
  imageOptimizationType: z.string().optional(),
  edgeConfigs: z.number().optional(),
  edgeConfigSize: z.number().optional(),
  edgeFunctionMaxSizeBytes: z.number().optional(),
  edgeFunctionExecutionTimeoutMs: z.number().optional(),
  serverlessFunctionDefaultMaxExecutionTime: z.number().optional(),
  kvDatabases: z.number().optional(),
  postgresDatabases: z.number().optional(),
  integrationStores: z.number().optional(),
  cronJobs: z.number().optional(),
  cronJobsPerProject: z.number().optional(),
});

/** @internal */
export type ResourceConfig$Outbound = {
  blobStores?: number | undefined;
  nodeType?: string | undefined;
  concurrentBuilds?: number | undefined;
  awsAccountType?: string | undefined;
  awsAccountIds?: Array<string> | undefined;
  cfZoneName?: string | undefined;
  imageOptimizationType?: string | undefined;
  edgeConfigs?: number | undefined;
  edgeConfigSize?: number | undefined;
  edgeFunctionMaxSizeBytes?: number | undefined;
  edgeFunctionExecutionTimeoutMs?: number | undefined;
  serverlessFunctionDefaultMaxExecutionTime?: number | undefined;
  kvDatabases?: number | undefined;
  postgresDatabases?: number | undefined;
  integrationStores?: number | undefined;
  cronJobs?: number | undefined;
  cronJobsPerProject?: number | undefined;
};

/** @internal */
export const ResourceConfig$outboundSchema: z.ZodType<
  ResourceConfig$Outbound,
  z.ZodTypeDef,
  ResourceConfig
> = z.object({
  blobStores: z.number().optional(),
  nodeType: z.string().optional(),
  concurrentBuilds: z.number().optional(),
  awsAccountType: z.string().optional(),
  awsAccountIds: z.array(z.string()).optional(),
  cfZoneName: z.string().optional(),
  imageOptimizationType: z.string().optional(),
  edgeConfigs: z.number().optional(),
  edgeConfigSize: z.number().optional(),
  edgeFunctionMaxSizeBytes: z.number().optional(),
  edgeFunctionExecutionTimeoutMs: z.number().optional(),
  serverlessFunctionDefaultMaxExecutionTime: z.number().optional(),
  kvDatabases: z.number().optional(),
  postgresDatabases: z.number().optional(),
  integrationStores: z.number().optional(),
  cronJobs: z.number().optional(),
  cronJobsPerProject: z.number().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResourceConfig$ {
  /** @deprecated use `ResourceConfig$inboundSchema` instead. */
  export const inboundSchema = ResourceConfig$inboundSchema;
  /** @deprecated use `ResourceConfig$outboundSchema` instead. */
  export const outboundSchema = ResourceConfig$outboundSchema;
  /** @deprecated use `ResourceConfig$Outbound` instead. */
  export type Outbound = ResourceConfig$Outbound;
}

/** @internal */
export const ViewPreference$inboundSchema: z.ZodNativeEnum<
  typeof ViewPreference
> = z.nativeEnum(ViewPreference);

/** @internal */
export const ViewPreference$outboundSchema: z.ZodNativeEnum<
  typeof ViewPreference
> = ViewPreference$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ViewPreference$ {
  /** @deprecated use `ViewPreference$inboundSchema` instead. */
  export const inboundSchema = ViewPreference$inboundSchema;
  /** @deprecated use `ViewPreference$outboundSchema` instead. */
  export const outboundSchema = ViewPreference$outboundSchema;
}

/** @internal */
export const FavoritesViewPreference$inboundSchema: z.ZodNativeEnum<
  typeof FavoritesViewPreference
> = z.nativeEnum(FavoritesViewPreference);

/** @internal */
export const FavoritesViewPreference$outboundSchema: z.ZodNativeEnum<
  typeof FavoritesViewPreference
> = FavoritesViewPreference$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FavoritesViewPreference$ {
  /** @deprecated use `FavoritesViewPreference$inboundSchema` instead. */
  export const inboundSchema = FavoritesViewPreference$inboundSchema;
  /** @deprecated use `FavoritesViewPreference$outboundSchema` instead. */
  export const outboundSchema = FavoritesViewPreference$outboundSchema;
}

/** @internal */
export const RecentsViewPreference$inboundSchema: z.ZodNativeEnum<
  typeof RecentsViewPreference
> = z.nativeEnum(RecentsViewPreference);

/** @internal */
export const RecentsViewPreference$outboundSchema: z.ZodNativeEnum<
  typeof RecentsViewPreference
> = RecentsViewPreference$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RecentsViewPreference$ {
  /** @deprecated use `RecentsViewPreference$inboundSchema` instead. */
  export const inboundSchema = RecentsViewPreference$inboundSchema;
  /** @deprecated use `RecentsViewPreference$outboundSchema` instead. */
  export const outboundSchema = RecentsViewPreference$outboundSchema;
}

/** @internal */
export const ActiveDashboardViews$inboundSchema: z.ZodType<
  ActiveDashboardViews,
  z.ZodTypeDef,
  unknown
> = z.object({
  scopeId: z.string(),
  viewPreference: ViewPreference$inboundSchema.optional(),
  favoritesViewPreference: FavoritesViewPreference$inboundSchema.optional(),
  recentsViewPreference: RecentsViewPreference$inboundSchema.optional(),
});

/** @internal */
export type ActiveDashboardViews$Outbound = {
  scopeId: string;
  viewPreference?: string | undefined;
  favoritesViewPreference?: string | undefined;
  recentsViewPreference?: string | undefined;
};

/** @internal */
export const ActiveDashboardViews$outboundSchema: z.ZodType<
  ActiveDashboardViews$Outbound,
  z.ZodTypeDef,
  ActiveDashboardViews
> = z.object({
  scopeId: z.string(),
  viewPreference: ViewPreference$outboundSchema.optional(),
  favoritesViewPreference: FavoritesViewPreference$outboundSchema.optional(),
  recentsViewPreference: RecentsViewPreference$outboundSchema.optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ActiveDashboardViews$ {
  /** @deprecated use `ActiveDashboardViews$inboundSchema` instead. */
  export const inboundSchema = ActiveDashboardViews$inboundSchema;
  /** @deprecated use `ActiveDashboardViews$outboundSchema` instead. */
  export const outboundSchema = ActiveDashboardViews$outboundSchema;
  /** @deprecated use `ActiveDashboardViews$Outbound` instead. */
  export type Outbound = ActiveDashboardViews$Outbound;
}

/** @internal */
export const ImportFlowGitNamespace$inboundSchema: z.ZodType<
  ImportFlowGitNamespace,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type ImportFlowGitNamespace$Outbound = string | number;

/** @internal */
export const ImportFlowGitNamespace$outboundSchema: z.ZodType<
  ImportFlowGitNamespace$Outbound,
  z.ZodTypeDef,
  ImportFlowGitNamespace
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ImportFlowGitNamespace$ {
  /** @deprecated use `ImportFlowGitNamespace$inboundSchema` instead. */
  export const inboundSchema = ImportFlowGitNamespace$inboundSchema;
  /** @deprecated use `ImportFlowGitNamespace$outboundSchema` instead. */
  export const outboundSchema = ImportFlowGitNamespace$outboundSchema;
  /** @deprecated use `ImportFlowGitNamespace$Outbound` instead. */
  export type Outbound = ImportFlowGitNamespace$Outbound;
}

/** @internal */
export const ImportFlowGitNamespaceId$inboundSchema: z.ZodType<
  ImportFlowGitNamespaceId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type ImportFlowGitNamespaceId$Outbound = string | number;

/** @internal */
export const ImportFlowGitNamespaceId$outboundSchema: z.ZodType<
  ImportFlowGitNamespaceId$Outbound,
  z.ZodTypeDef,
  ImportFlowGitNamespaceId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ImportFlowGitNamespaceId$ {
  /** @deprecated use `ImportFlowGitNamespaceId$inboundSchema` instead. */
  export const inboundSchema = ImportFlowGitNamespaceId$inboundSchema;
  /** @deprecated use `ImportFlowGitNamespaceId$outboundSchema` instead. */
  export const outboundSchema = ImportFlowGitNamespaceId$outboundSchema;
  /** @deprecated use `ImportFlowGitNamespaceId$Outbound` instead. */
  export type Outbound = ImportFlowGitNamespaceId$Outbound;
}

/** @internal */
export const ImportFlowGitProvider$inboundSchema: z.ZodNativeEnum<
  typeof ImportFlowGitProvider
> = z.nativeEnum(ImportFlowGitProvider);

/** @internal */
export const ImportFlowGitProvider$outboundSchema: z.ZodNativeEnum<
  typeof ImportFlowGitProvider
> = ImportFlowGitProvider$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ImportFlowGitProvider$ {
  /** @deprecated use `ImportFlowGitProvider$inboundSchema` instead. */
  export const inboundSchema = ImportFlowGitProvider$inboundSchema;
  /** @deprecated use `ImportFlowGitProvider$outboundSchema` instead. */
  export const outboundSchema = ImportFlowGitProvider$outboundSchema;
}

/** @internal */
export const GitNamespaceId$inboundSchema: z.ZodType<
  GitNamespaceId,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.number()]);

/** @internal */
export type GitNamespaceId$Outbound = string | number;

/** @internal */
export const GitNamespaceId$outboundSchema: z.ZodType<
  GitNamespaceId$Outbound,
  z.ZodTypeDef,
  GitNamespaceId
> = z.union([z.string(), z.number()]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace GitNamespaceId$ {
  /** @deprecated use `GitNamespaceId$inboundSchema` instead. */
  export const inboundSchema = GitNamespaceId$inboundSchema;
  /** @deprecated use `GitNamespaceId$outboundSchema` instead. */
  export const outboundSchema = GitNamespaceId$outboundSchema;
  /** @deprecated use `GitNamespaceId$Outbound` instead. */
  export type Outbound = GitNamespaceId$Outbound;
}

/** @internal */
export const PreferredScopesAndGitNamespaces$inboundSchema: z.ZodType<
  PreferredScopesAndGitNamespaces,
  z.ZodTypeDef,
  unknown
> = z.object({
  scopeId: z.string(),
  gitNamespaceId: z.nullable(z.union([z.string(), z.number()])),
});

/** @internal */
export type PreferredScopesAndGitNamespaces$Outbound = {
  scopeId: string;
  gitNamespaceId: string | number | null;
};

/** @internal */
export const PreferredScopesAndGitNamespaces$outboundSchema: z.ZodType<
  PreferredScopesAndGitNamespaces$Outbound,
  z.ZodTypeDef,
  PreferredScopesAndGitNamespaces
> = z.object({
  scopeId: z.string(),
  gitNamespaceId: z.nullable(z.union([z.string(), z.number()])),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace PreferredScopesAndGitNamespaces$ {
  /** @deprecated use `PreferredScopesAndGitNamespaces$inboundSchema` instead. */
  export const inboundSchema = PreferredScopesAndGitNamespaces$inboundSchema;
  /** @deprecated use `PreferredScopesAndGitNamespaces$outboundSchema` instead. */
  export const outboundSchema = PreferredScopesAndGitNamespaces$outboundSchema;
  /** @deprecated use `PreferredScopesAndGitNamespaces$Outbound` instead. */
  export type Outbound = PreferredScopesAndGitNamespaces$Outbound;
}

/** @internal */
export const Dismissals$inboundSchema: z.ZodType<
  Dismissals,
  z.ZodTypeDef,
  unknown
> = z.object({
  scopeId: z.string(),
  createdAt: z.number(),
});

/** @internal */
export type Dismissals$Outbound = {
  scopeId: string;
  createdAt: number;
};

/** @internal */
export const Dismissals$outboundSchema: z.ZodType<
  Dismissals$Outbound,
  z.ZodTypeDef,
  Dismissals
> = z.object({
  scopeId: z.string(),
  createdAt: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Dismissals$ {
  /** @deprecated use `Dismissals$inboundSchema` instead. */
  export const inboundSchema = Dismissals$inboundSchema;
  /** @deprecated use `Dismissals$outboundSchema` instead. */
  export const outboundSchema = Dismissals$outboundSchema;
  /** @deprecated use `Dismissals$Outbound` instead. */
  export type Outbound = Dismissals$Outbound;
}

/** @internal */
export const DismissedToasts$inboundSchema: z.ZodType<
  DismissedToasts,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  dismissals: z.array(z.lazy(() => Dismissals$inboundSchema)),
});

/** @internal */
export type DismissedToasts$Outbound = {
  name: string;
  dismissals: Array<Dismissals$Outbound>;
};

/** @internal */
export const DismissedToasts$outboundSchema: z.ZodType<
  DismissedToasts$Outbound,
  z.ZodTypeDef,
  DismissedToasts
> = z.object({
  name: z.string(),
  dismissals: z.array(z.lazy(() => Dismissals$outboundSchema)),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DismissedToasts$ {
  /** @deprecated use `DismissedToasts$inboundSchema` instead. */
  export const inboundSchema = DismissedToasts$inboundSchema;
  /** @deprecated use `DismissedToasts$outboundSchema` instead. */
  export const outboundSchema = DismissedToasts$outboundSchema;
  /** @deprecated use `DismissedToasts$Outbound` instead. */
  export type Outbound = DismissedToasts$Outbound;
}

/** @internal */
export const Two$inboundSchema: z.ZodType<Two, z.ZodTypeDef, unknown> = z
  .object({
    spaceId: z.string(),
    scopeSlug: z.string(),
    scopeId: z.string(),
  });

/** @internal */
export type Two$Outbound = {
  spaceId: string;
  scopeSlug: string;
  scopeId: string;
};

/** @internal */
export const Two$outboundSchema: z.ZodType<Two$Outbound, z.ZodTypeDef, Two> = z
  .object({
    spaceId: z.string(),
    scopeSlug: z.string(),
    scopeId: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Two$ {
  /** @deprecated use `Two$inboundSchema` instead. */
  export const inboundSchema = Two$inboundSchema;
  /** @deprecated use `Two$outboundSchema` instead. */
  export const outboundSchema = Two$outboundSchema;
  /** @deprecated use `Two$Outbound` instead. */
  export type Outbound = Two$Outbound;
}

/** @internal */
export const One$inboundSchema: z.ZodType<One, z.ZodTypeDef, unknown> = z
  .object({
    projectId: z.string(),
    scopeSlug: z.string(),
    scopeId: z.string(),
  });

/** @internal */
export type One$Outbound = {
  projectId: string;
  scopeSlug: string;
  scopeId: string;
};

/** @internal */
export const One$outboundSchema: z.ZodType<One$Outbound, z.ZodTypeDef, One> = z
  .object({
    projectId: z.string(),
    scopeSlug: z.string(),
    scopeId: z.string(),
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace One$ {
  /** @deprecated use `One$inboundSchema` instead. */
  export const inboundSchema = One$inboundSchema;
  /** @deprecated use `One$outboundSchema` instead. */
  export const outboundSchema = One$outboundSchema;
  /** @deprecated use `One$Outbound` instead. */
  export type Outbound = One$Outbound;
}

/** @internal */
export const FavoriteProjectsAndSpaces$inboundSchema: z.ZodType<
  FavoriteProjectsAndSpaces,
  z.ZodTypeDef,
  unknown
> = z.union([z.lazy(() => One$inboundSchema), z.lazy(() => Two$inboundSchema)]);

/** @internal */
export type FavoriteProjectsAndSpaces$Outbound = One$Outbound | Two$Outbound;

/** @internal */
export const FavoriteProjectsAndSpaces$outboundSchema: z.ZodType<
  FavoriteProjectsAndSpaces$Outbound,
  z.ZodTypeDef,
  FavoriteProjectsAndSpaces
> = z.union([
  z.lazy(() => One$outboundSchema),
  z.lazy(() => Two$outboundSchema),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FavoriteProjectsAndSpaces$ {
  /** @deprecated use `FavoriteProjectsAndSpaces$inboundSchema` instead. */
  export const inboundSchema = FavoriteProjectsAndSpaces$inboundSchema;
  /** @deprecated use `FavoriteProjectsAndSpaces$outboundSchema` instead. */
  export const outboundSchema = FavoriteProjectsAndSpaces$outboundSchema;
  /** @deprecated use `FavoriteProjectsAndSpaces$Outbound` instead. */
  export type Outbound = FavoriteProjectsAndSpaces$Outbound;
}

/** @internal */
export const RemoteCaching$inboundSchema: z.ZodType<
  RemoteCaching,
  z.ZodTypeDef,
  unknown
> = z.object({
  enabled: z.boolean().optional(),
});

/** @internal */
export type RemoteCaching$Outbound = {
  enabled?: boolean | undefined;
};

/** @internal */
export const RemoteCaching$outboundSchema: z.ZodType<
  RemoteCaching$Outbound,
  z.ZodTypeDef,
  RemoteCaching
> = z.object({
  enabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace RemoteCaching$ {
  /** @deprecated use `RemoteCaching$inboundSchema` instead. */
  export const inboundSchema = RemoteCaching$inboundSchema;
  /** @deprecated use `RemoteCaching$outboundSchema` instead. */
  export const outboundSchema = RemoteCaching$outboundSchema;
  /** @deprecated use `RemoteCaching$Outbound` instead. */
  export type Outbound = RemoteCaching$Outbound;
}

/** @internal */
export const DataCache$inboundSchema: z.ZodType<
  DataCache,
  z.ZodTypeDef,
  unknown
> = z.object({
  excessBillingEnabled: z.boolean().optional(),
});

/** @internal */
export type DataCache$Outbound = {
  excessBillingEnabled?: boolean | undefined;
};

/** @internal */
export const DataCache$outboundSchema: z.ZodType<
  DataCache$Outbound,
  z.ZodTypeDef,
  DataCache
> = z.object({
  excessBillingEnabled: z.boolean().optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace DataCache$ {
  /** @deprecated use `DataCache$inboundSchema` instead. */
  export const inboundSchema = DataCache$inboundSchema;
  /** @deprecated use `DataCache$outboundSchema` instead. */
  export const outboundSchema = DataCache$outboundSchema;
  /** @deprecated use `DataCache$Outbound` instead. */
  export type Outbound = DataCache$Outbound;
}

/** @internal */
export const WebAnalytics$inboundSchema: z.ZodType<
  WebAnalytics,
  z.ZodTypeDef,
  unknown
> = z.object({
  blockedFrom: z.number().optional(),
  blockedUntil: z.number().optional(),
  isCurrentlyBlocked: z.boolean(),
});

/** @internal */
export type WebAnalytics$Outbound = {
  blockedFrom?: number | undefined;
  blockedUntil?: number | undefined;
  isCurrentlyBlocked: boolean;
};

/** @internal */
export const WebAnalytics$outboundSchema: z.ZodType<
  WebAnalytics$Outbound,
  z.ZodTypeDef,
  WebAnalytics
> = z.object({
  blockedFrom: z.number().optional(),
  blockedUntil: z.number().optional(),
  isCurrentlyBlocked: z.boolean(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace WebAnalytics$ {
  /** @deprecated use `WebAnalytics$inboundSchema` instead. */
  export const inboundSchema = WebAnalytics$inboundSchema;
  /** @deprecated use `WebAnalytics$outboundSchema` instead. */
  export const outboundSchema = WebAnalytics$outboundSchema;
  /** @deprecated use `WebAnalytics$Outbound` instead. */
  export type Outbound = WebAnalytics$Outbound;
}

/** @internal */
export const FeatureBlocks$inboundSchema: z.ZodType<
  FeatureBlocks,
  z.ZodTypeDef,
  unknown
> = z.object({
  webAnalytics: z.lazy(() => WebAnalytics$inboundSchema).optional(),
});

/** @internal */
export type FeatureBlocks$Outbound = {
  webAnalytics?: WebAnalytics$Outbound | undefined;
};

/** @internal */
export const FeatureBlocks$outboundSchema: z.ZodType<
  FeatureBlocks$Outbound,
  z.ZodTypeDef,
  FeatureBlocks
> = z.object({
  webAnalytics: z.lazy(() => WebAnalytics$outboundSchema).optional(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace FeatureBlocks$ {
  /** @deprecated use `FeatureBlocks$inboundSchema` instead. */
  export const inboundSchema = FeatureBlocks$inboundSchema;
  /** @deprecated use `FeatureBlocks$outboundSchema` instead. */
  export const outboundSchema = FeatureBlocks$outboundSchema;
  /** @deprecated use `FeatureBlocks$Outbound` instead. */
  export type Outbound = FeatureBlocks$Outbound;
}

/** @internal */
export const NorthstarMigration$inboundSchema: z.ZodType<
  NorthstarMigration,
  z.ZodTypeDef,
  unknown
> = z.object({
  teamId: z.string(),
  projects: z.number(),
  stores: z.number(),
  integrationConfigurations: z.number(),
  integrationClients: z.number(),
  startTime: z.number(),
  endTime: z.number(),
});

/** @internal */
export type NorthstarMigration$Outbound = {
  teamId: string;
  projects: number;
  stores: number;
  integrationConfigurations: number;
  integrationClients: number;
  startTime: number;
  endTime: number;
};

/** @internal */
export const NorthstarMigration$outboundSchema: z.ZodType<
  NorthstarMigration$Outbound,
  z.ZodTypeDef,
  NorthstarMigration
> = z.object({
  teamId: z.string(),
  projects: z.number(),
  stores: z.number(),
  integrationConfigurations: z.number(),
  integrationClients: z.number(),
  startTime: z.number(),
  endTime: z.number(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace NorthstarMigration$ {
  /** @deprecated use `NorthstarMigration$inboundSchema` instead. */
  export const inboundSchema = NorthstarMigration$inboundSchema;
  /** @deprecated use `NorthstarMigration$outboundSchema` instead. */
  export const outboundSchema = NorthstarMigration$outboundSchema;
  /** @deprecated use `NorthstarMigration$Outbound` instead. */
  export type Outbound = NorthstarMigration$Outbound;
}

/** @internal */
export const Version$inboundSchema: z.ZodNativeEnum<typeof Version> = z
  .nativeEnum(Version);

/** @internal */
export const Version$outboundSchema: z.ZodNativeEnum<typeof Version> =
  Version$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Version$ {
  /** @deprecated use `Version$inboundSchema` instead. */
  export const inboundSchema = Version$inboundSchema;
  /** @deprecated use `Version$outboundSchema` instead. */
  export const outboundSchema = Version$outboundSchema;
}

/** @internal */
export const AuthUser$inboundSchema: z.ZodType<
  AuthUser,
  z.ZodTypeDef,
  unknown
> = z.object({
  createdAt: z.number(),
  softBlock: z.nullable(z.lazy(() => SoftBlock$inboundSchema)),
  billing: z.nullable(z.lazy(() => Billing$inboundSchema)),
  resourceConfig: z.lazy(() => ResourceConfig$inboundSchema),
  stagingPrefix: z.string(),
  activeDashboardViews: z.array(
    z.lazy(() => ActiveDashboardViews$inboundSchema),
  ).optional(),
  importFlowGitNamespace: z.nullable(z.union([z.string(), z.number()]))
    .optional(),
  importFlowGitNamespaceId: z.nullable(z.union([z.string(), z.number()]))
    .optional(),
  importFlowGitProvider: ImportFlowGitProvider$inboundSchema.optional(),
  preferredScopesAndGitNamespaces: z.array(
    z.lazy(() => PreferredScopesAndGitNamespaces$inboundSchema),
  ).optional(),
  dismissedToasts: z.array(z.lazy(() => DismissedToasts$inboundSchema))
    .optional(),
  favoriteProjectsAndSpaces: z.array(
    z.union([z.lazy(() => One$inboundSchema), z.lazy(() => Two$inboundSchema)]),
  ).optional(),
  hasTrialAvailable: z.boolean(),
  remoteCaching: z.lazy(() => RemoteCaching$inboundSchema).optional(),
  dataCache: z.lazy(() => DataCache$inboundSchema).optional(),
  featureBlocks: z.lazy(() => FeatureBlocks$inboundSchema).optional(),
  northstarMigration: z.lazy(() => NorthstarMigration$inboundSchema).optional(),
  id: z.string(),
  email: z.string(),
  name: z.nullable(z.string()),
  username: z.string(),
  avatar: z.nullable(z.string()),
  defaultTeamId: z.nullable(z.string()),
  version: z.nullable(Version$inboundSchema),
});

/** @internal */
export type AuthUser$Outbound = {
  createdAt: number;
  softBlock: SoftBlock$Outbound | null;
  billing: Billing$Outbound | null;
  resourceConfig: ResourceConfig$Outbound;
  stagingPrefix: string;
  activeDashboardViews?: Array<ActiveDashboardViews$Outbound> | undefined;
  importFlowGitNamespace?: string | number | null | undefined;
  importFlowGitNamespaceId?: string | number | null | undefined;
  importFlowGitProvider?: string | undefined;
  preferredScopesAndGitNamespaces?:
    | Array<PreferredScopesAndGitNamespaces$Outbound>
    | undefined;
  dismissedToasts?: Array<DismissedToasts$Outbound> | undefined;
  favoriteProjectsAndSpaces?: Array<One$Outbound | Two$Outbound> | undefined;
  hasTrialAvailable: boolean;
  remoteCaching?: RemoteCaching$Outbound | undefined;
  dataCache?: DataCache$Outbound | undefined;
  featureBlocks?: FeatureBlocks$Outbound | undefined;
  northstarMigration?: NorthstarMigration$Outbound | undefined;
  id: string;
  email: string;
  name: string | null;
  username: string;
  avatar: string | null;
  defaultTeamId: string | null;
  version: string | null;
};

/** @internal */
export const AuthUser$outboundSchema: z.ZodType<
  AuthUser$Outbound,
  z.ZodTypeDef,
  AuthUser
> = z.object({
  createdAt: z.number(),
  softBlock: z.nullable(z.lazy(() => SoftBlock$outboundSchema)),
  billing: z.nullable(z.lazy(() => Billing$outboundSchema)),
  resourceConfig: z.lazy(() => ResourceConfig$outboundSchema),
  stagingPrefix: z.string(),
  activeDashboardViews: z.array(
    z.lazy(() => ActiveDashboardViews$outboundSchema),
  ).optional(),
  importFlowGitNamespace: z.nullable(z.union([z.string(), z.number()]))
    .optional(),
  importFlowGitNamespaceId: z.nullable(z.union([z.string(), z.number()]))
    .optional(),
  importFlowGitProvider: ImportFlowGitProvider$outboundSchema.optional(),
  preferredScopesAndGitNamespaces: z.array(
    z.lazy(() => PreferredScopesAndGitNamespaces$outboundSchema),
  ).optional(),
  dismissedToasts: z.array(z.lazy(() => DismissedToasts$outboundSchema))
    .optional(),
  favoriteProjectsAndSpaces: z.array(
    z.union([
      z.lazy(() => One$outboundSchema),
      z.lazy(() => Two$outboundSchema),
    ]),
  ).optional(),
  hasTrialAvailable: z.boolean(),
  remoteCaching: z.lazy(() => RemoteCaching$outboundSchema).optional(),
  dataCache: z.lazy(() => DataCache$outboundSchema).optional(),
  featureBlocks: z.lazy(() => FeatureBlocks$outboundSchema).optional(),
  northstarMigration: z.lazy(() => NorthstarMigration$outboundSchema)
    .optional(),
  id: z.string(),
  email: z.string(),
  name: z.nullable(z.string()),
  username: z.string(),
  avatar: z.nullable(z.string()),
  defaultTeamId: z.nullable(z.string()),
  version: z.nullable(Version$outboundSchema),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AuthUser$ {
  /** @deprecated use `AuthUser$inboundSchema` instead. */
  export const inboundSchema = AuthUser$inboundSchema;
  /** @deprecated use `AuthUser$outboundSchema` instead. */
  export const outboundSchema = AuthUser$outboundSchema;
  /** @deprecated use `AuthUser$Outbound` instead. */
  export type Outbound = AuthUser$Outbound;
}
