/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

class InvariantError extends Error {
  constructor(message: string) {
    super(message);
    this.name = "InvariantError";
  }
}

export function invariant(
  condition: unknown,
  message: string,
): asserts condition {
  if (!condition) {
    throw new InvariantError(message);
  }
}

export type ExactPartial<T> = {
  [P in keyof T]?: T[P] | undefined;
};

export type Remap<Inp, Mapping extends { [k in keyof Inp]?: string | null }> = {
  [k in keyof Inp as Mapping[k] extends string /* if we have a string mapping for this key then use it */
    ? Mapping[k]
    : Mapping[k] extends null /* if the mapping is to `null` then drop the key */
    ? never
    : k /* otherwise keep the key as-is */]: Inp[k];
};

/**
 * Converts or omits an object's keys according to a mapping.
 *
 * @param inp An object whose keys will be remapped
 * @param mappings A mapping of original keys to new keys. If a key is not present in the mapping, it will be left as is. If a key is mapped to `null`, it will be removed in the resulting object.
 * @returns A new object with keys remapped or omitted according to the mappings
 */
export function remap<
  Inp extends Record<string, unknown>,
  const Mapping extends { [k in keyof Inp]?: string | null },
>(inp: Inp, mappings: Mapping): Remap<Inp, Mapping> {
  let out: any = {};

  if (!Object.keys(mappings).length) {
    out = inp;
    return out;
  }

  for (const [k, v] of Object.entries(inp)) {
    const j = mappings[k];
    if (j === null) {
      continue;
    }
    out[j ?? k] = v;
  }

  return out;
}
