# UploadArtifactRequest

## Example Usage

```typescript
import { UploadArtifactRequest } from "@vercel/sdk/models/operations/uploadartifact.js";

// No examples available for this model
```

## Fields

| Field                                                                                                                                      | Type                                                                                                                                       | Required                                                                                                                                   | Description                                                                                                                                | Example                                                                                                                                    |
| ------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ |
| `contentLength`                                                                                                                            | *number*                                                                                                                                   | :heavy_check_mark:                                                                                                                         | The artifact size in bytes                                                                                                                 |                                                                                                                                            |
| `xArtifactDuration`                                                                                                                        | *number*                                                                                                                                   | :heavy_minus_sign:                                                                                                                         | The time taken to generate the uploaded artifact in milliseconds.                                                                          | 400                                                                                                                                        |
| `xArtifactClientCi`                                                                                                                        | *string*                                                                                                                                   | :heavy_minus_sign:                                                                                                                         | The continuous integration or delivery environment where this artifact was generated.                                                      | VERCEL                                                                                                                                     |
| `xArtifactClientInteractive`                                                                                                               | *number*                                                                                                                                   | :heavy_minus_sign:                                                                                                                         | 1 if the client is an interactive shell. Otherwise 0                                                                                       | 0                                                                                                                                          |
| `xArtifactTag`                                                                                                                             | *string*                                                                                                                                   | :heavy_minus_sign:                                                                                                                         | The base64 encoded tag for this artifact. The value is sent back to clients when the artifact is downloaded as the header `x-artifact-tag` | Tc0BmHvJYMIYJ62/zx87YqO0Flxk+5Ovip25NY825CQ=                                                                                               |
| `hash`                                                                                                                                     | *string*                                                                                                                                   | :heavy_check_mark:                                                                                                                         | The artifact hash                                                                                                                          | 12HKQaOmR5t5Uy6vdcQsNIiZgHGB                                                                                                               |
| `teamId`                                                                                                                                   | *string*                                                                                                                                   | :heavy_minus_sign:                                                                                                                         | The Team identifier to perform the request on behalf of.                                                                                   |                                                                                                                                            |
| `slug`                                                                                                                                     | *string*                                                                                                                                   | :heavy_minus_sign:                                                                                                                         | The Team slug to perform the request on behalf of.                                                                                         |                                                                                                                                            |
| `requestBody`                                                                                                                              | *ReadableStream<Uint8Array>*                                                                                                               | :heavy_minus_sign:                                                                                                                         | N/A                                                                                                                                        |                                                                                                                                            |